import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListPlatformApplicationsCommand, se_ListPlatformApplicationsCommand } from "../protocols/Aws_query";
export { $Command };
export class ListPlatformApplicationsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "ListPlatformApplications", {})
    .n("SNSClient", "ListPlatformApplicationsCommand")
    .f(void 0, void 0)
    .ser(se_ListPlatformApplicationsCommand)
    .de(de_ListPlatformApplicationsCommand)
    .build() {
}
