import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { OptInPhoneNumberInputFilterSensitiveLog, } from "../models/models_0";
import { de_OptInPhoneNumberCommand, se_OptInPhoneNumberCommand } from "../protocols/Aws_query";
export { $Command };
export class OptInPhoneNumberCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "OptInPhoneNumber", {})
    .n("SNSClient", "OptInPhoneNumberCommand")
    .f(OptInPhoneNumberInputFilterSensitiveLog, void 0)
    .ser(se_OptInPhoneNumberCommand)
    .de(de_OptInPhoneNumberCommand)
    .build() {
}
