import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog, } from "../models/models_0";
import { de_DescribeMaintenanceWindowExecutionTaskInvocationsCommand, se_DescribeMaintenanceWindowExecutionTaskInvocationsCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeMaintenanceWindowExecutionTaskInvocationsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeMaintenanceWindowExecutionTaskInvocations", {})
    .n("SSMClient", "DescribeMaintenanceWindowExecutionTaskInvocationsCommand")
    .f(void 0, DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog)
    .ser(se_DescribeMaintenanceWindowExecutionTaskInvocationsCommand)
    .de(de_DescribeMaintenanceWindowExecutionTaskInvocationsCommand)
    .build() {
}
