import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeMaintenanceWindowsResultFilterSensitiveLog, } from "../models/models_1";
import { de_DescribeMaintenanceWindowsCommand, se_DescribeMaintenanceWindowsCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeMaintenanceWindowsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeMaintenanceWindows", {})
    .n("SSMClient", "DescribeMaintenanceWindowsCommand")
    .f(void 0, DescribeMaintenanceWindowsResultFilterSensitiveLog)
    .ser(se_DescribeMaintenanceWindowsCommand)
    .de(de_DescribeMaintenanceWindowsCommand)
    .build() {
}
