"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const CheckStateMachineExecutions_1 = require("./HelperFunctions/CheckStateMachineExecutions");
const STATUS_SUCCEEDED = 'SUCCEEDED';
const STATUS_FAILED = 'FAILED';
const region = process.env.AWS_REGION;
const handler = async (event, context) => {
    const stateMachineArn = event.ResourceProperties.StateMachineArn;
    const imagePipelineArn = event.ResourceProperties.ImagePipelineArn;
    const executionName = event.RequestId;
    console.log('Context is invoked with:' + JSON.stringify(context));
    console.log('Lambda is invoked with:' + JSON.stringify(event));
    console.log('Resource properties: ' + JSON.stringify(event.ResourceProperties));
    console.log('State Machine ARN: ' + stateMachineArn);
    console.log('Image Pipeline ARN: ' + imagePipelineArn);
    console.log('REGION: ' + region);
    let response = {
        IsComplete: true,
        Data: {
            AmiId: '',
        },
    };
    try {
        const executions = await (0, CheckStateMachineExecutions_1.listExecutions)(stateMachineArn);
        const filteredExecutions = executions.filter(execution => execution.name.includes(executionName));
        const executionArnArray = filteredExecutions.map(execution => execution.executionArn);
        const executionArn = executionArnArray.length > 0 ? executionArnArray[0] : '';
        const debugImagePipeline = event.ResourceProperties.DebugImagePipeline;
        console.log('Execution ARN: ' + executionArn);
        /**
             * If there are no executions, then the state machine has not been started yet.
             * Only check for the execution status if there are executions.
             */
        if (!filteredExecutions.length || debugImagePipeline === 'true') {
            return response;
        }
        const executionStatus = filteredExecutions.map(execution => execution.status);
        if (executionStatus.includes(STATUS_SUCCEEDED)) {
            const amiId = await (0, CheckStateMachineExecutions_1.getExecutionHistory)(executionArn);
            response.Data = {
                AmiId: amiId,
            };
        }
        else if (executionStatus.includes(STATUS_FAILED)) {
            throw new Error('Execution failed');
        }
        else {
            console.log('No succeeded or failed executions found yet.');
            response = {
                IsComplete: false,
            };
        }
    }
    catch (error) {
        console.log('Error: ' + error);
        throw error;
    }
    return response;
};
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ2hlY2tTdGF0ZU1hY2hpbmVTdGF0dXMubGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL0xhbWJkYXMvQ2hlY2tTdGF0ZU1hY2hpbmVTdGF0dXMvQ2hlY2tTdGF0ZU1hY2hpbmVTdGF0dXMubGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLCtGQUFvRztBQUVwRyxNQUFNLGdCQUFnQixHQUFHLFdBQVcsQ0FBQztBQUNyQyxNQUFNLGFBQWEsR0FBRyxRQUFRLENBQUM7QUFDL0IsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUM7QUFHL0IsTUFBTSxPQUFPLEdBQUcsS0FBSyxFQUMxQixLQUF3QyxFQUN4QyxPQUFnQixFQUM4QixFQUFFO0lBRWhELE1BQU0sZUFBZSxHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUM7SUFDakUsTUFBTSxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUMsZ0JBQWdCLENBQUM7SUFDbkUsTUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztJQUN0QyxPQUFPLENBQUMsR0FBRyxDQUFDLDBCQUEwQixHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUNsRSxPQUFPLENBQUMsR0FBRyxDQUFDLHlCQUF5QixHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUMvRCxPQUFPLENBQUMsR0FBRyxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUNoRixPQUFPLENBQUMsR0FBRyxDQUFDLHFCQUFxQixHQUFHLGVBQWUsQ0FBQyxDQUFDO0lBQ3JELE9BQU8sQ0FBQyxHQUFHLENBQUMsc0JBQXNCLEdBQUcsZ0JBQWdCLENBQUMsQ0FBQztJQUN2RCxPQUFPLENBQUMsR0FBRyxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsQ0FBQztJQUVqQyxJQUFJLFFBQVEsR0FBd0M7UUFDbEQsVUFBVSxFQUFFLElBQUk7UUFDaEIsSUFBSSxFQUFFO1lBQ0osS0FBSyxFQUFFLEVBQUU7U0FDVjtLQUNGLENBQUM7SUFFRixJQUFJLENBQUM7UUFDSCxNQUFNLFVBQVUsR0FBRyxNQUFNLElBQUEsNENBQWMsRUFBQyxlQUFlLENBQUMsQ0FBQztRQUN6RCxNQUFNLGtCQUFrQixHQUFHLFVBQVcsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsSUFBSyxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBQ3BHLE1BQU0saUJBQWlCLEdBQUcsa0JBQWtCLENBQUMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ3RGLE1BQU0sWUFBWSxHQUFHLGlCQUFpQixDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBVyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFDeEYsTUFBTSxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUMsa0JBQWtCLENBQUM7UUFDdkUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsR0FBRyxZQUFZLENBQUMsQ0FBQztRQUM5Qzs7O2VBR087UUFDUCxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxJQUFJLGtCQUFrQixLQUFLLE1BQU0sRUFBRSxDQUFDO1lBQ2hFLE9BQU8sUUFBUSxDQUFDO1FBQ2xCLENBQUM7UUFFRCxNQUFNLGVBQWUsR0FBRyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFOUUsSUFBSSxlQUFlLENBQUMsUUFBUSxDQUFDLGdCQUFnQixDQUFDLEVBQUUsQ0FBQztZQUMvQyxNQUFNLEtBQUssR0FBRyxNQUFNLElBQUEsaURBQW1CLEVBQUMsWUFBWSxDQUFDLENBQUM7WUFDdEQsUUFBUSxDQUFDLElBQUksR0FBRztnQkFDZCxLQUFLLEVBQUUsS0FBSzthQUNiLENBQUM7UUFDSixDQUFDO2FBQU0sSUFBSSxlQUFlLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxFQUFFLENBQUM7WUFDbkQsTUFBTSxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3RDLENBQUM7YUFBTSxDQUFDO1lBQ04sT0FBTyxDQUFDLEdBQUcsQ0FBQyw4Q0FBOEMsQ0FBQyxDQUFDO1lBQzVELFFBQVEsR0FBRztnQkFDVCxVQUFVLEVBQUUsS0FBSzthQUNsQixDQUFDO1FBQ0osQ0FBQztJQUNILENBQUM7SUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1FBQ2YsT0FBTyxDQUFDLEdBQUcsQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLENBQUM7UUFDL0IsTUFBTSxLQUFLLENBQUM7SUFDZCxDQUFDO0lBQ0QsT0FBTyxRQUFRLENBQUM7QUFDbEIsQ0FBQyxDQUFDO0FBekRXLFFBQUEsT0FBTyxXQXlEbEIiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgaW1wb3J0L25vLWV4dHJhbmVvdXMtZGVwZW5kZW5jaWVzXG5pbXBvcnQgeyBDZGtDdXN0b21SZXNvdXJjZUlzQ29tcGxldGVSZXNwb25zZSwgQ2xvdWRGb3JtYXRpb25DdXN0b21SZXNvdXJjZUV2ZW50LCBDb250ZXh0IH0gZnJvbSAnYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBnZXRFeGVjdXRpb25IaXN0b3J5LCBsaXN0RXhlY3V0aW9ucyB9IGZyb20gJy4vSGVscGVyRnVuY3Rpb25zL0NoZWNrU3RhdGVNYWNoaW5lRXhlY3V0aW9ucyc7XG5cbmNvbnN0IFNUQVRVU19TVUNDRUVERUQgPSAnU1VDQ0VFREVEJztcbmNvbnN0IFNUQVRVU19GQUlMRUQgPSAnRkFJTEVEJztcbmNvbnN0IHJlZ2lvbiA9IHByb2Nlc3MuZW52LkFXU19SRUdJT047XG5cblxuZXhwb3J0IGNvbnN0IGhhbmRsZXIgPSBhc3luYyAoXG4gIGV2ZW50OiBDbG91ZEZvcm1hdGlvbkN1c3RvbVJlc291cmNlRXZlbnQsXG4gIGNvbnRleHQ6IENvbnRleHQsXG4pOiBQcm9taXNlPENka0N1c3RvbVJlc291cmNlSXNDb21wbGV0ZVJlc3BvbnNlPiA9PiB7XG5cbiAgY29uc3Qgc3RhdGVNYWNoaW5lQXJuID0gZXZlbnQuUmVzb3VyY2VQcm9wZXJ0aWVzLlN0YXRlTWFjaGluZUFybjtcbiAgY29uc3QgaW1hZ2VQaXBlbGluZUFybiA9IGV2ZW50LlJlc291cmNlUHJvcGVydGllcy5JbWFnZVBpcGVsaW5lQXJuO1xuICBjb25zdCBleGVjdXRpb25OYW1lID0gZXZlbnQuUmVxdWVzdElkO1xuICBjb25zb2xlLmxvZygnQ29udGV4dCBpcyBpbnZva2VkIHdpdGg6JyArIEpTT04uc3RyaW5naWZ5KGNvbnRleHQpKTtcbiAgY29uc29sZS5sb2coJ0xhbWJkYSBpcyBpbnZva2VkIHdpdGg6JyArIEpTT04uc3RyaW5naWZ5KGV2ZW50KSk7XG4gIGNvbnNvbGUubG9nKCdSZXNvdXJjZSBwcm9wZXJ0aWVzOiAnICsgSlNPTi5zdHJpbmdpZnkoZXZlbnQuUmVzb3VyY2VQcm9wZXJ0aWVzKSk7XG4gIGNvbnNvbGUubG9nKCdTdGF0ZSBNYWNoaW5lIEFSTjogJyArIHN0YXRlTWFjaGluZUFybik7XG4gIGNvbnNvbGUubG9nKCdJbWFnZSBQaXBlbGluZSBBUk46ICcgKyBpbWFnZVBpcGVsaW5lQXJuKTtcbiAgY29uc29sZS5sb2coJ1JFR0lPTjogJyArIHJlZ2lvbik7XG5cbiAgbGV0IHJlc3BvbnNlOiBDZGtDdXN0b21SZXNvdXJjZUlzQ29tcGxldGVSZXNwb25zZSA9IHtcbiAgICBJc0NvbXBsZXRlOiB0cnVlLFxuICAgIERhdGE6IHtcbiAgICAgIEFtaUlkOiAnJyxcbiAgICB9LFxuICB9O1xuXG4gIHRyeSB7XG4gICAgY29uc3QgZXhlY3V0aW9ucyA9IGF3YWl0IGxpc3RFeGVjdXRpb25zKHN0YXRlTWFjaGluZUFybik7XG4gICAgY29uc3QgZmlsdGVyZWRFeGVjdXRpb25zID0gZXhlY3V0aW9ucyEuZmlsdGVyKGV4ZWN1dGlvbiA9PiBleGVjdXRpb24ubmFtZSEuaW5jbHVkZXMoZXhlY3V0aW9uTmFtZSkpO1xuICAgIGNvbnN0IGV4ZWN1dGlvbkFybkFycmF5ID0gZmlsdGVyZWRFeGVjdXRpb25zLm1hcChleGVjdXRpb24gPT4gZXhlY3V0aW9uLmV4ZWN1dGlvbkFybik7XG4gICAgY29uc3QgZXhlY3V0aW9uQXJuID0gZXhlY3V0aW9uQXJuQXJyYXkubGVuZ3RoID4gMCA/IGV4ZWN1dGlvbkFybkFycmF5WzBdIGFzIHN0cmluZyA6ICcnO1xuICAgIGNvbnN0IGRlYnVnSW1hZ2VQaXBlbGluZSA9IGV2ZW50LlJlc291cmNlUHJvcGVydGllcy5EZWJ1Z0ltYWdlUGlwZWxpbmU7XG4gICAgY29uc29sZS5sb2coJ0V4ZWN1dGlvbiBBUk46ICcgKyBleGVjdXRpb25Bcm4pO1xuICAgIC8qKlxuICAgICAgICAgKiBJZiB0aGVyZSBhcmUgbm8gZXhlY3V0aW9ucywgdGhlbiB0aGUgc3RhdGUgbWFjaGluZSBoYXMgbm90IGJlZW4gc3RhcnRlZCB5ZXQuXG4gICAgICAgICAqIE9ubHkgY2hlY2sgZm9yIHRoZSBleGVjdXRpb24gc3RhdHVzIGlmIHRoZXJlIGFyZSBleGVjdXRpb25zLlxuICAgICAgICAgKi9cbiAgICBpZiAoIWZpbHRlcmVkRXhlY3V0aW9ucy5sZW5ndGggfHwgZGVidWdJbWFnZVBpcGVsaW5lID09PSAndHJ1ZScpIHtcbiAgICAgIHJldHVybiByZXNwb25zZTtcbiAgICB9XG5cbiAgICBjb25zdCBleGVjdXRpb25TdGF0dXMgPSBmaWx0ZXJlZEV4ZWN1dGlvbnMubWFwKGV4ZWN1dGlvbiA9PiBleGVjdXRpb24uc3RhdHVzKTtcblxuICAgIGlmIChleGVjdXRpb25TdGF0dXMuaW5jbHVkZXMoU1RBVFVTX1NVQ0NFRURFRCkpIHtcbiAgICAgIGNvbnN0IGFtaUlkID0gYXdhaXQgZ2V0RXhlY3V0aW9uSGlzdG9yeShleGVjdXRpb25Bcm4pO1xuICAgICAgcmVzcG9uc2UuRGF0YSA9IHtcbiAgICAgICAgQW1pSWQ6IGFtaUlkLFxuICAgICAgfTtcbiAgICB9IGVsc2UgaWYgKGV4ZWN1dGlvblN0YXR1cy5pbmNsdWRlcyhTVEFUVVNfRkFJTEVEKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdFeGVjdXRpb24gZmFpbGVkJyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNvbnNvbGUubG9nKCdObyBzdWNjZWVkZWQgb3IgZmFpbGVkIGV4ZWN1dGlvbnMgZm91bmQgeWV0LicpO1xuICAgICAgcmVzcG9uc2UgPSB7XG4gICAgICAgIElzQ29tcGxldGU6IGZhbHNlLFxuICAgICAgfTtcbiAgICB9XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgY29uc29sZS5sb2coJ0Vycm9yOiAnICsgZXJyb3IpO1xuICAgIHRocm93IGVycm9yO1xuICB9XG4gIHJldHVybiByZXNwb25zZTtcbn07XG5cblxuIl19