import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateImageUsageReportRequest, CreateImageUsageReportResult } from "../models/models_1";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateImageUsageReportCommand}.
 */
export interface CreateImageUsageReportCommandInput extends CreateImageUsageReportRequest {
}
/**
 * @public
 *
 * The output of {@link CreateImageUsageReportCommand}.
 */
export interface CreateImageUsageReportCommandOutput extends CreateImageUsageReportResult, __MetadataBearer {
}
declare const CreateImageUsageReportCommand_base: {
    new (input: CreateImageUsageReportCommandInput): import("@smithy/smithy-client").CommandImpl<CreateImageUsageReportCommandInput, CreateImageUsageReportCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateImageUsageReportCommandInput): import("@smithy/smithy-client").CommandImpl<CreateImageUsageReportCommandInput, CreateImageUsageReportCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates a report that shows how your image is used across other Amazon Web Services accounts. The report
 *       provides visibility into which accounts are using the specified image, and how many resources
 *       (EC2 instances or launch templates) are referencing it.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/your-ec2-ami-usage.html">View your AMI usage</a> in the
 *       <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateImageUsageReportCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateImageUsageReportCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // CreateImageUsageReportRequest
 *   ImageId: "STRING_VALUE", // required
 *   DryRun: true || false,
 *   ResourceTypes: [ // ImageUsageResourceTypeRequestList // required
 *     { // ImageUsageResourceTypeRequest
 *       ResourceType: "STRING_VALUE",
 *       ResourceTypeOptions: [ // ImageUsageResourceTypeOptionRequestList
 *         { // ImageUsageResourceTypeOptionRequest
 *           OptionName: "STRING_VALUE",
 *           OptionValues: [ // ImageUsageResourceTypeOptionValuesList
 *             "STRING_VALUE",
 *           ],
 *         },
 *       ],
 *     },
 *   ],
 *   AccountIds: [ // ImageUsageReportUserIdStringList
 *     "STRING_VALUE",
 *   ],
 *   ClientToken: "STRING_VALUE",
 *   TagSpecifications: [ // TagSpecificationList
 *     { // TagSpecification
 *       ResourceType: "capacity-reservation" || "client-vpn-endpoint" || "customer-gateway" || "carrier-gateway" || "coip-pool" || "declarative-policies-report" || "dedicated-host" || "dhcp-options" || "egress-only-internet-gateway" || "elastic-ip" || "elastic-gpu" || "export-image-task" || "export-instance-task" || "fleet" || "fpga-image" || "host-reservation" || "image" || "image-usage-report" || "import-image-task" || "import-snapshot-task" || "instance" || "instance-event-window" || "internet-gateway" || "ipam" || "ipam-pool" || "ipam-scope" || "ipv4pool-ec2" || "ipv6pool-ec2" || "key-pair" || "launch-template" || "local-gateway" || "local-gateway-route-table" || "local-gateway-virtual-interface" || "local-gateway-virtual-interface-group" || "local-gateway-route-table-vpc-association" || "local-gateway-route-table-virtual-interface-group-association" || "natgateway" || "network-acl" || "network-interface" || "network-insights-analysis" || "network-insights-path" || "network-insights-access-scope" || "network-insights-access-scope-analysis" || "outpost-lag" || "placement-group" || "prefix-list" || "replace-root-volume-task" || "reserved-instances" || "route-table" || "security-group" || "security-group-rule" || "service-link-virtual-interface" || "snapshot" || "spot-fleet-request" || "spot-instances-request" || "subnet" || "subnet-cidr-reservation" || "traffic-mirror-filter" || "traffic-mirror-session" || "traffic-mirror-target" || "transit-gateway" || "transit-gateway-attachment" || "transit-gateway-connect-peer" || "transit-gateway-multicast-domain" || "transit-gateway-policy-table" || "transit-gateway-route-table" || "transit-gateway-route-table-announcement" || "volume" || "vpc" || "vpc-endpoint" || "vpc-endpoint-connection" || "vpc-endpoint-service" || "vpc-endpoint-service-permission" || "vpc-peering-connection" || "vpn-connection" || "vpn-gateway" || "vpc-flow-log" || "capacity-reservation-fleet" || "traffic-mirror-filter-rule" || "vpc-endpoint-connection-device-type" || "verified-access-instance" || "verified-access-group" || "verified-access-endpoint" || "verified-access-policy" || "verified-access-trust-provider" || "vpn-connection-device-type" || "vpc-block-public-access-exclusion" || "route-server" || "route-server-endpoint" || "route-server-peer" || "ipam-resource-discovery" || "ipam-resource-discovery-association" || "instance-connect-endpoint" || "verified-access-endpoint-target" || "ipam-external-resource-verification-token" || "capacity-block" || "mac-modification-task",
 *       Tags: [ // TagList
 *         { // Tag
 *           Key: "STRING_VALUE",
 *           Value: "STRING_VALUE",
 *         },
 *       ],
 *     },
 *   ],
 * };
 * const command = new CreateImageUsageReportCommand(input);
 * const response = await client.send(command);
 * // { // CreateImageUsageReportResult
 * //   ReportId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param CreateImageUsageReportCommandInput - {@link CreateImageUsageReportCommandInput}
 * @returns {@link CreateImageUsageReportCommandOutput}
 * @see {@link CreateImageUsageReportCommandInput} for command's `input` shape.
 * @see {@link CreateImageUsageReportCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class CreateImageUsageReportCommand extends CreateImageUsageReportCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateImageUsageReportRequest;
            output: CreateImageUsageReportResult;
        };
        sdk: {
            input: CreateImageUsageReportCommandInput;
            output: CreateImageUsageReportCommandOutput;
        };
    };
}
