import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisassociateEnclaveCertificateIamRoleRequest, DisassociateEnclaveCertificateIamRoleResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DisassociateEnclaveCertificateIamRoleCommand}.
 */
export interface DisassociateEnclaveCertificateIamRoleCommandInput extends DisassociateEnclaveCertificateIamRoleRequest {
}
/**
 * @public
 *
 * The output of {@link DisassociateEnclaveCertificateIamRoleCommand}.
 */
export interface DisassociateEnclaveCertificateIamRoleCommandOutput extends DisassociateEnclaveCertificateIamRoleResult, __MetadataBearer {
}
declare const DisassociateEnclaveCertificateIamRoleCommand_base: {
    new (input: DisassociateEnclaveCertificateIamRoleCommandInput): import("@smithy/smithy-client").CommandImpl<DisassociateEnclaveCertificateIamRoleCommandInput, DisassociateEnclaveCertificateIamRoleCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DisassociateEnclaveCertificateIamRoleCommandInput): import("@smithy/smithy-client").CommandImpl<DisassociateEnclaveCertificateIamRoleCommandInput, DisassociateEnclaveCertificateIamRoleCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role
 * 			from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and
 * 			encrypted private key from the Amazon S3 bucket. It also revokes the IAM role's permission to use the
 * 			KMS key used to encrypt the private key. This effectively revokes the role's permission
 * 			to use the certificate.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisassociateEnclaveCertificateIamRoleCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisassociateEnclaveCertificateIamRoleCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // DisassociateEnclaveCertificateIamRoleRequest
 *   CertificateArn: "STRING_VALUE", // required
 *   RoleArn: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DisassociateEnclaveCertificateIamRoleCommand(input);
 * const response = await client.send(command);
 * // { // DisassociateEnclaveCertificateIamRoleResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param DisassociateEnclaveCertificateIamRoleCommandInput - {@link DisassociateEnclaveCertificateIamRoleCommandInput}
 * @returns {@link DisassociateEnclaveCertificateIamRoleCommandOutput}
 * @see {@link DisassociateEnclaveCertificateIamRoleCommandInput} for command's `input` shape.
 * @see {@link DisassociateEnclaveCertificateIamRoleCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DisassociateEnclaveCertificateIamRoleCommand extends DisassociateEnclaveCertificateIamRoleCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DisassociateEnclaveCertificateIamRoleRequest;
            output: DisassociateEnclaveCertificateIamRoleResult;
        };
        sdk: {
            input: DisassociateEnclaveCertificateIamRoleCommandInput;
            output: DisassociateEnclaveCertificateIamRoleCommandOutput;
        };
    };
}
