import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetManagedPrefixListEntriesRequest, GetManagedPrefixListEntriesResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link GetManagedPrefixListEntriesCommand}.
 */
export interface GetManagedPrefixListEntriesCommandInput extends GetManagedPrefixListEntriesRequest {
}
/**
 * @public
 *
 * The output of {@link GetManagedPrefixListEntriesCommand}.
 */
export interface GetManagedPrefixListEntriesCommandOutput extends GetManagedPrefixListEntriesResult, __MetadataBearer {
}
declare const GetManagedPrefixListEntriesCommand_base: {
    new (input: GetManagedPrefixListEntriesCommandInput): import("@smithy/smithy-client").CommandImpl<GetManagedPrefixListEntriesCommandInput, GetManagedPrefixListEntriesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: GetManagedPrefixListEntriesCommandInput): import("@smithy/smithy-client").CommandImpl<GetManagedPrefixListEntriesCommandInput, GetManagedPrefixListEntriesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Gets information about the entries for a specified managed prefix list.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetManagedPrefixListEntriesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetManagedPrefixListEntriesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // GetManagedPrefixListEntriesRequest
 *   DryRun: true || false,
 *   PrefixListId: "STRING_VALUE", // required
 *   TargetVersion: Number("long"),
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 * };
 * const command = new GetManagedPrefixListEntriesCommand(input);
 * const response = await client.send(command);
 * // { // GetManagedPrefixListEntriesResult
 * //   Entries: [ // PrefixListEntrySet
 * //     { // PrefixListEntry
 * //       Cidr: "STRING_VALUE",
 * //       Description: "STRING_VALUE",
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetManagedPrefixListEntriesCommandInput - {@link GetManagedPrefixListEntriesCommandInput}
 * @returns {@link GetManagedPrefixListEntriesCommandOutput}
 * @see {@link GetManagedPrefixListEntriesCommandInput} for command's `input` shape.
 * @see {@link GetManagedPrefixListEntriesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class GetManagedPrefixListEntriesCommand extends GetManagedPrefixListEntriesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: GetManagedPrefixListEntriesRequest;
            output: GetManagedPrefixListEntriesResult;
        };
        sdk: {
            input: GetManagedPrefixListEntriesCommandInput;
            output: GetManagedPrefixListEntriesCommandOutput;
        };
    };
}
