import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { SearchTransitGatewayRoutesRequest, SearchTransitGatewayRoutesResult } from "../models/models_8";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link SearchTransitGatewayRoutesCommand}.
 */
export interface SearchTransitGatewayRoutesCommandInput extends SearchTransitGatewayRoutesRequest {
}
/**
 * @public
 *
 * The output of {@link SearchTransitGatewayRoutesCommand}.
 */
export interface SearchTransitGatewayRoutesCommandOutput extends SearchTransitGatewayRoutesResult, __MetadataBearer {
}
declare const SearchTransitGatewayRoutesCommand_base: {
    new (input: SearchTransitGatewayRoutesCommandInput): import("@smithy/smithy-client").CommandImpl<SearchTransitGatewayRoutesCommandInput, SearchTransitGatewayRoutesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: SearchTransitGatewayRoutesCommandInput): import("@smithy/smithy-client").CommandImpl<SearchTransitGatewayRoutesCommandInput, SearchTransitGatewayRoutesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Searches for routes in the specified transit gateway route table.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, SearchTransitGatewayRoutesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, SearchTransitGatewayRoutesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // SearchTransitGatewayRoutesRequest
 *   TransitGatewayRouteTableId: "STRING_VALUE", // required
 *   Filters: [ // FilterList // required
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   MaxResults: Number("int"),
 *   DryRun: true || false,
 * };
 * const command = new SearchTransitGatewayRoutesCommand(input);
 * const response = await client.send(command);
 * // { // SearchTransitGatewayRoutesResult
 * //   Routes: [ // TransitGatewayRouteList
 * //     { // TransitGatewayRoute
 * //       DestinationCidrBlock: "STRING_VALUE",
 * //       PrefixListId: "STRING_VALUE",
 * //       TransitGatewayRouteTableAnnouncementId: "STRING_VALUE",
 * //       TransitGatewayAttachments: [ // TransitGatewayRouteAttachmentList
 * //         { // TransitGatewayRouteAttachment
 * //           ResourceId: "STRING_VALUE",
 * //           TransitGatewayAttachmentId: "STRING_VALUE",
 * //           ResourceType: "vpc" || "vpn" || "direct-connect-gateway" || "connect" || "peering" || "tgw-peering" || "network-function",
 * //         },
 * //       ],
 * //       Type: "static" || "propagated",
 * //       State: "pending" || "active" || "blackhole" || "deleting" || "deleted",
 * //     },
 * //   ],
 * //   AdditionalRoutesAvailable: true || false,
 * // };
 *
 * ```
 *
 * @param SearchTransitGatewayRoutesCommandInput - {@link SearchTransitGatewayRoutesCommandInput}
 * @returns {@link SearchTransitGatewayRoutesCommandOutput}
 * @see {@link SearchTransitGatewayRoutesCommandInput} for command's `input` shape.
 * @see {@link SearchTransitGatewayRoutesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class SearchTransitGatewayRoutesCommand extends SearchTransitGatewayRoutesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: SearchTransitGatewayRoutesRequest;
            output: SearchTransitGatewayRoutesResult;
        };
        sdk: {
            input: SearchTransitGatewayRoutesCommandInput;
            output: SearchTransitGatewayRoutesCommandOutput;
        };
    };
}
