import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeTasksCommand, se_DescribeTasksCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeTasksCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerServiceV20141113", "DescribeTasks", {})
    .n("ECSClient", "DescribeTasksCommand")
    .f(void 0, void 0)
    .ser(se_DescribeTasksCommand)
    .de(de_DescribeTasksCommand)
    .build() {
}
