import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_SetEndpointAttributesCommand, se_SetEndpointAttributesCommand } from "../protocols/Aws_query";
export { $Command };
export class SetEndpointAttributesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "SetEndpointAttributes", {})
    .n("SNSClient", "SetEndpointAttributesCommand")
    .f(void 0, void 0)
    .ser(se_SetEndpointAttributesCommand)
    .de(de_SetEndpointAttributesCommand)
    .build() {
}
