import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeAutomationExecutionsCommand, se_DescribeAutomationExecutionsCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeAutomationExecutionsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeAutomationExecutions", {})
    .n("SSMClient", "DescribeAutomationExecutionsCommand")
    .f(void 0, void 0)
    .ser(se_DescribeAutomationExecutionsCommand)
    .de(de_DescribeAutomationExecutionsCommand)
    .build() {
}
