import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetMaintenanceWindowTaskResultFilterSensitiveLog, } from "../models/models_1";
import { de_GetMaintenanceWindowTaskCommand, se_GetMaintenanceWindowTaskCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetMaintenanceWindowTaskCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "GetMaintenanceWindowTask", {})
    .n("SSMClient", "GetMaintenanceWindowTaskCommand")
    .f(void 0, GetMaintenanceWindowTaskResultFilterSensitiveLog)
    .ser(se_GetMaintenanceWindowTaskCommand)
    .de(de_GetMaintenanceWindowTaskCommand)
    .build() {
}
