/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.proxy;

import io.ray.runtime.metric.Count;
import io.ray.runtime.metric.Metrics;
import io.ray.runtime.metric.TagKey;
import io.ray.runtime.serializer.MessagePackSerializer;
import io.ray.serve.exception.RayServeException;
import io.ray.serve.handle.RayServeHandle;
import io.ray.serve.metrics.RayServeMetrics;
import io.ray.serve.proxy.ProxyRouter;
import io.ray.serve.proxy.ServeProxy;
import io.ray.serve.util.LogUtil;
import io.ray.serve.util.SocketUtil;
import io.ray.shaded.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxy
implements ServeProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpProxy.class);
    public static final String PROXY_NAME = "HTTP_PROXY";
    public static final String PROXY_HTTP_PORT = "ray.serve.proxy.http.port";
    public static final String PROXY_HTTP_METHODS = "ray.serve.proxy.http.methods";
    private int port;
    private Count requestCounter;
    private HttpServer httpServer;
    private ProxyRouter proxyRouter;

    @Override
    public void init(Map<String, String> config, ProxyRouter proxyRouter) {
        this.port = Optional.ofNullable(config).map(conf -> (String)conf.get(PROXY_HTTP_PORT)).map(httpPort -> Integer.valueOf(httpPort)).orElse(SocketUtil.findAvailableTcpPort(8000));
        this.proxyRouter = proxyRouter;
        RayServeMetrics.execute(() -> {
            this.requestCounter = (Count)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)Metrics.count().name("serve_num_http_requests")).description("The number of HTTP requests processed.")).unit("")).tags(new HashMap<String, String>())).register();
        });
        this.startupHttpServer(this.port);
        LOGGER.info("Proxy {} has been started with port:{}", (Object)this.getName(), (Object)this.port);
    }

    private void startupHttpServer(int port) {
        try {
            this.httpServer = ServerBootstrap.bootstrap().setListenerPort(port).register("*", new ServeHttpHandler()).registerVirtual(InetAddress.getLocalHost().getHostAddress(), "*", new ServeHttpHandler()).create();
            this.httpServer.start();
        }
        catch (Throwable e) {
            String errMsg = LogUtil.format("Proxy {} failed to startup HTTP server on port {}.", this.getName(), this.port);
            LOGGER.error(errMsg);
            throw new RayServeException(errMsg, e);
        }
    }

    @Override
    public String getName() {
        return PROXY_NAME;
    }

    public int getPort() {
        return this.port;
    }

    public ProxyRouter getProxyRouter() {
        return this.proxyRouter;
    }

    private class ServeHttpHandler
    implements HttpRequestHandler {
        private ServeHttpHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
            String route;
            Object result;
            int code;
            block16: {
                code = 200;
                result = null;
                route = request.getPath();
                try {
                    RayServeMetrics.execute(() -> HttpProxy.this.requestCounter.update(1.0, ImmutableMap.of(new TagKey("route"), route)));
                    Object[] parameters = null;
                    HttpEntity httpEntity = request.getEntity();
                    if (null == httpEntity) {
                        parameters = new Object[]{};
                    } else {
                        byte[] body = EntityUtils.toByteArray(httpEntity);
                        parameters = (Object[])MessagePackSerializer.decode(body, Object[].class);
                    }
                    RayServeHandle rayServeHandle = HttpProxy.this.proxyRouter.matchRoute(route);
                    if (rayServeHandle == null) {
                        code = 404;
                        break block16;
                    }
                    result = rayServeHandle.remote(parameters).get();
                }
                catch (Throwable e) {
                    try {
                        LOGGER.error("HTTP Proxy failed to process request.", e);
                        code = 500;
                    }
                    catch (Throwable throwable) {
                        response.setCode(code);
                        if (code == 404) {
                            response.setEntity(new StringEntity(LogUtil.format("Path '{}' not found. Please ping http://.../-/routes for route table.", route), Charset.forName("UTF-8")));
                        } else if (result != null) {
                            response.setEntity(new ByteArrayEntity(MessagePackSerializer.encode(result).getLeft(), null));
                        }
                        throw throwable;
                    }
                    response.setCode(code);
                    if (code == 404) {
                        response.setEntity(new StringEntity(LogUtil.format("Path '{}' not found. Please ping http://.../-/routes for route table.", route), Charset.forName("UTF-8")));
                    } else if (result != null) {
                        response.setEntity(new ByteArrayEntity(MessagePackSerializer.encode(result).getLeft(), null));
                    }
                }
            }
            response.setCode(code);
            if (code == 404) {
                response.setEntity(new StringEntity(LogUtil.format("Path '{}' not found. Please ping http://.../-/routes for route table.", route), Charset.forName("UTF-8")));
            } else if (result != null) {
                response.setEntity(new ByteArrayEntity(MessagePackSerializer.encode(result).getLeft(), null));
            }
        }
    }
}

