from copy import copy
from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__), **kwargs):
    hdr = evolve_header(constant_hdr, **kwargs)
    return generate_dicom(out_dir, num_vols, hdr,
                          collated_data, varying_hdr)



num_vols = 531


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "DERIVED",
            "PRIMARY",
            "AXIAL",
            "CT_SOM5 SPI"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.2"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "144927.519000"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "152301.696000"
        ]
    },
    "00080050": {
        "vr": "SH",
        "Value": [
            "987654321"
        ]
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "CT"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "SIEMENS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "Address of said institute"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "University"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "QUADRA10016"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^Project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "AC CT 3.0  SWB HD_FoV"
        ]
    },
    "00081050": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Principal Investigator"
            }
        ]
    },
    "00081070": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Sydney Imaging"
            }
        ]
    },
    "00081080": {
        "vr": "LO",
        "Value": [
            "Physics"
        ]
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "Biograph128_Vision Quadra Edge"
        ]
    },
    "00081140": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.2"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.30000023082421141748900003652"
                    ]
                }
            }
        ]
    },
    "00082111": {
        "vr": "ST",
        "Value": [
            "Reconstruction field larger than scan field"
        ]
    },
    "00082112": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.9.1"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.30000023082422094374600000052"
                    ]
                }
            }
        ]
    },
    "00083010": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422094374600000052"
        ]
    },
    "00090010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CT VA1 DUMMY"
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Session Identifier"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "Session Label"
        ]
    },
    "00100030": {
        "vr": "DA",
        "Value": [
            "19800228"
        ]
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "M"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "043Y"
        ]
    },
    "00101020": {
        "vr": "DS",
        "Value": [
            1.8
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            75.0
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "PARTIALBODY"
        ]
    },
    "00180050": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00180060": {
        "vr": "DS",
        "Value": [
            120.0
        ]
    },
    "00180090": {
        "vr": "DS",
        "Value": [
            500.0
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "10016"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "VR20B"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "U_FDG_SWB_LM"
        ]
    },
    "00181100": {
        "vr": "DS",
        "Value": [
            780.0
        ]
    },
    "00181110": {
        "vr": "DS",
        "Value": [
            1085.6
        ]
    },
    "00181111": {
        "vr": "DS",
        "Value": [
            595.0
        ]
    },
    "00181120": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00181130": {
        "vr": "DS",
        "Value": [
            140.5
        ]
    },
    "00181140": {
        "vr": "CS",
        "Value": [
            "CW"
        ]
    },
    "00181150": {
        "vr": "IS",
        "Value": [
            500
        ]
    },
    "00181160": {
        "vr": "SH",
        "Value": [
            "FLAT"
        ]
    },
    "00181170": {
        "vr": "IS",
        "Value": [
            3
        ]
    },
    "00181190": {
        "vr": "DS",
        "Value": [
            0.9
        ]
    },
    "00181200": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00181201": {
        "vr": "TM",
        "Value": [
            "071955.000000"
        ]
    },
    "00181210": {
        "vr": "SH",
        "Value": [
            "Br38f",
            "3"
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "00189306": {
        "vr": "FD",
        "Value": [
            0.6
        ]
    },
    "00189307": {
        "vr": "FD",
        "Value": [
            38.4
        ]
    },
    "00189309": {
        "vr": "FD",
        "Value": [
            61.4
        ]
    },
    "00189310": {
        "vr": "FD",
        "Value": [
            30.7
        ]
    },
    "00189311": {
        "vr": "FD",
        "Value": [
            0.8
        ]
    },
    "00189323": {
        "vr": "CS",
        "Value": [
            "XYZ_EC"
        ]
    },
    "00189324": {
        "vr": "FD",
        "Value": [
            68.85
        ]
    },
    "00189346": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "113691"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "DCM"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "IEC Body Dosimetry Phantom"
                    ]
                }
            }
        ]
    },
    "00190010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CT VA0  COAD"
        ]
    },
    "00191090": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00191092": {
        "vr": "DS",
        "Value": [
            0.9236
        ]
    },
    "00191093": {
        "vr": "DS",
        "Value": [
            -1.6565
        ]
    },
    "00191096": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "001910B0": {
        "vr": "DS",
        "Value": [
            30.7
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422093565300000019"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082421255920000017965"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "PROJECT_ID"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "00200012": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "00200037": {
        "vr": "DS",
        "Value": [
            1.0,
            0.0,
            0.0,
            0.0,
            1.0,
            0.0
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422094374600000050"
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00204000": {
        "vr": "LT"
    },
    "00210010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MED"
        ]
    },
    "00211011": {
        "vr": "DS",
        "Value": [
            0.0,
            0.0
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            512
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            512
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            1.5234375,
            1.5234375
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            12
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            11
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00280106": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00281050": {
        "vr": "DS",
        "Value": [
            40.0,
            300.0
        ]
    },
    "00281051": {
        "vr": "DS",
        "Value": [
            300.0,
            1500.0
        ]
    },
    "00281052": {
        "vr": "DS",
        "Value": [
            -1024.0
        ]
    },
    "00281053": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00281054": {
        "vr": "LO",
        "Value": [
            "HU"
        ]
    },
    "00281055": {
        "vr": "LO",
        "Value": [
            "WINDOW1",
            "WINDOW2"
        ]
    },
    "00282110": {
        "vr": "CS",
        "Value": [
            "01"
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CSA HEADER"
        ]
    },
    "00290011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MEDCOM HEADER"
        ]
    },
    "00290012": {
        "vr": "LO",
        "Value": [
            "SIEMENS MEDCOM OOG"
        ]
    },
    "00291008": {
        "vr": "CS",
        "Value": [
            "SOM 5"
        ]
    },
    "00291009": {
        "vr": "LO",
        "Value": [
            "VA10A 971201"
        ]
    },
    "00291208": {
        "vr": "CS",
        "Value": [
            "MEDCOM OOG 2"
        ]
    },
    "00291209": {
        "vr": "LO",
        "Value": [
            "0103 syngo VZ20A"
        ]
    },
    "60000010": {
        "vr": "US",
        "Value": [
            512
        ]
    },
    "60000011": {
        "vr": "US",
        "Value": [
            512
        ]
    },
    "60000015": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "60000022": {
        "vr": "LO",
        "Value": [
            "Siemens MedCom Object Graphics"
        ]
    },
    "60000040": {
        "vr": "CS",
        "Value": [
            "G"
        ]
    },
    "60000050": {
        "vr": "SS",
        "Value": [
            1,
            1
        ]
    },
    "60000051": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "60000100": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "60000102": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            "Patient comments string"
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotype"
            }
        ]
    }
}


varying_hdr = {"00080018": {"0": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017966"]}, "1": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017967"]}, "2": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017968"]}, "3": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017969"]}, "4": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017970"]}, "5": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017971"]}, "6": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017972"]}, "7": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017973"]}, "8": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017974"]}, "9": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017975"]}, "10": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017976"]}, "11": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017977"]}, "12": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017978"]}, "13": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017979"]}, "14": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017980"]}, "15": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017981"]}, "16": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017982"]}, "17": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017983"]}, "18": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017984"]}, "19": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017985"]}, "20": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017986"]}, "21": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017987"]}, "22": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017988"]}, "23": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017989"]}, "24": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017990"]}, "25": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017991"]}, "26": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017992"]}, "27": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017993"]}, "28": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017994"]}, "29": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017995"]}, "30": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017996"]}, "31": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017997"]}, "32": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017998"]}, "33": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000017999"]}, "34": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018000"]}, "35": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018001"]}, "36": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018002"]}, "37": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018003"]}, "38": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018004"]}, "39": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018005"]}, "40": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018006"]}, "41": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018007"]}, "42": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018008"]}, "43": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018009"]}, "44": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018010"]}, "45": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018011"]}, "46": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018012"]}, "47": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018013"]}, "48": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018014"]}, "49": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018015"]}, "50": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018016"]}, "51": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018017"]}, "52": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018018"]}, "53": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018019"]}, "54": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018020"]}, "55": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018021"]}, "56": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018022"]}, "57": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018023"]}, "58": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018024"]}, "59": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018025"]}, "60": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018026"]}, "61": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018027"]}, "62": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018028"]}, "63": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018029"]}, "64": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018030"]}, "65": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018031"]}, "66": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018032"]}, "67": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018033"]}, "68": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018034"]}, "69": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018035"]}, "70": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018036"]}, "71": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018037"]}, "72": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018038"]}, "73": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018039"]}, "74": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018040"]}, "75": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018041"]}, "76": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018042"]}, "77": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018043"]}, "78": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018044"]}, "79": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018045"]}, "80": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018046"]}, "81": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018047"]}, "82": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018048"]}, "83": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018049"]}, "84": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018050"]}, "85": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018051"]}, "86": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018052"]}, "87": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018053"]}, "88": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018054"]}, "89": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018055"]}, "90": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018056"]}, "91": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018057"]}, "92": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018058"]}, "93": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018059"]}, "94": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018060"]}, "95": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018061"]}, "96": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018062"]}, "97": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018063"]}, "98": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018064"]}, "99": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018065"]}, "100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018066"]}, "101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018067"]}, "102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018068"]}, "103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018069"]}, "104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018070"]}, "105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018071"]}, "106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018072"]}, "107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018073"]}, "108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018074"]}, "109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018075"]}, "110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018076"]}, "111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018077"]}, "112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018078"]}, "113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018079"]}, "114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018080"]}, "115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018081"]}, "116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018082"]}, "117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018083"]}, "118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018084"]}, "119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018085"]}, "120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018086"]}, "121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018087"]}, "122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018088"]}, "123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018089"]}, "124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018090"]}, "125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018091"]}, "126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018092"]}, "127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018093"]}, "128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018094"]}, "129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018095"]}, "130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018096"]}, "131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018097"]}, "132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018098"]}, "133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018099"]}, "134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018100"]}, "135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018101"]}, "136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018102"]}, "137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018103"]}, "138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018104"]}, "139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018105"]}, "140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018106"]}, "141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018107"]}, "142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018108"]}, "143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018109"]}, "144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018110"]}, "145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018111"]}, "146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018112"]}, "147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018113"]}, "148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018114"]}, "149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018115"]}, "150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018116"]}, "151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018117"]}, "152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018118"]}, "153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018119"]}, "154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018120"]}, "155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018121"]}, "156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018122"]}, "157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018123"]}, "158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018124"]}, "159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018125"]}, "160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018126"]}, "161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018127"]}, "162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018128"]}, "163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018129"]}, "164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018130"]}, "165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018131"]}, "166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018132"]}, "167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018133"]}, "168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018134"]}, "169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018135"]}, "170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018136"]}, "171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018137"]}, "172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018138"]}, "173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018139"]}, "174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018140"]}, "175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018141"]}, "176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018142"]}, "177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018143"]}, "178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018144"]}, "179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018145"]}, "180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018146"]}, "181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018147"]}, "182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018148"]}, "183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018149"]}, "184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018150"]}, "185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018151"]}, "186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018152"]}, "187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018153"]}, "188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018154"]}, "189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018155"]}, "190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018156"]}, "191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018157"]}, "192": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018158"]}, "193": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018159"]}, "194": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018160"]}, "195": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018161"]}, "196": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018162"]}, "197": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018163"]}, "198": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018164"]}, "199": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018165"]}, "200": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018166"]}, "201": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018167"]}, "202": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018168"]}, "203": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018169"]}, "204": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018170"]}, "205": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018171"]}, "206": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018172"]}, "207": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018173"]}, "208": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018174"]}, "209": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018175"]}, "210": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018176"]}, "211": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018177"]}, "212": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018178"]}, "213": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018179"]}, "214": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018180"]}, "215": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018181"]}, "216": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018182"]}, "217": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018183"]}, "218": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018184"]}, "219": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018185"]}, "220": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018186"]}, "221": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018187"]}, "222": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018188"]}, "223": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018189"]}, "224": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018190"]}, "225": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018191"]}, "226": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018192"]}, "227": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018193"]}, "228": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018194"]}, "229": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018195"]}, "230": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018196"]}, "231": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018197"]}, "232": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018198"]}, "233": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018199"]}, "234": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018200"]}, "235": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018201"]}, "236": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018202"]}, "237": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018203"]}, "238": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018204"]}, "239": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018205"]}, "240": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018206"]}, "241": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018207"]}, "242": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018208"]}, "243": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018209"]}, "244": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018210"]}, "245": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018211"]}, "246": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018212"]}, "247": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018213"]}, "248": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018214"]}, "249": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018215"]}, "250": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018216"]}, "251": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018217"]}, "252": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018218"]}, "253": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018219"]}, "254": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018220"]}, "255": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018221"]}, "256": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018222"]}, "257": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018223"]}, "258": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018224"]}, "259": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018225"]}, "260": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018226"]}, "261": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018227"]}, "262": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018228"]}, "263": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018229"]}, "264": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018230"]}, "265": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018231"]}, "266": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018232"]}, "267": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018233"]}, "268": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018234"]}, "269": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018235"]}, "270": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018236"]}, "271": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018237"]}, "272": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018238"]}, "273": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018239"]}, "274": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018240"]}, "275": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018241"]}, "276": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018242"]}, "277": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018243"]}, "278": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018244"]}, "279": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018245"]}, "280": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018246"]}, "281": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018247"]}, "282": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018248"]}, "283": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018249"]}, "284": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018250"]}, "285": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018251"]}, "286": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018252"]}, "287": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018253"]}, "288": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018254"]}, "289": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018255"]}, "290": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018256"]}, "291": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018257"]}, "292": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018258"]}, "293": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018259"]}, "294": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018260"]}, "295": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018261"]}, "296": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018262"]}, "297": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018263"]}, "298": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018264"]}, "299": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018265"]}, "300": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018266"]}, "301": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018267"]}, "302": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018268"]}, "303": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018269"]}, "304": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018270"]}, "305": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018271"]}, "306": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018272"]}, "307": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018273"]}, "308": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018274"]}, "309": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018275"]}, "310": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018276"]}, "311": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018277"]}, "312": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018278"]}, "313": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018279"]}, "314": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018280"]}, "315": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018281"]}, "316": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018282"]}, "317": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018283"]}, "318": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018284"]}, "319": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018285"]}, "320": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018286"]}, "321": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018287"]}, "322": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018288"]}, "323": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018289"]}, "324": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018290"]}, "325": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018291"]}, "326": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018292"]}, "327": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018293"]}, "328": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018294"]}, "329": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018295"]}, "330": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018296"]}, "331": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018297"]}, "332": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018298"]}, "333": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018299"]}, "334": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018300"]}, "335": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018301"]}, "336": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018302"]}, "337": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018303"]}, "338": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018304"]}, "339": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018305"]}, "340": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018306"]}, "341": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018307"]}, "342": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018308"]}, "343": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018309"]}, "344": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018310"]}, "345": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018311"]}, "346": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018312"]}, "347": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018313"]}, "348": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018314"]}, "349": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018315"]}, "350": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018316"]}, "351": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018317"]}, "352": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018318"]}, "353": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018319"]}, "354": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018320"]}, "355": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018321"]}, "356": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018322"]}, "357": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018323"]}, "358": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018324"]}, "359": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018325"]}, "360": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018326"]}, "361": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018327"]}, "362": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018328"]}, "363": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018329"]}, "364": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018330"]}, "365": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018331"]}, "366": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018332"]}, "367": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018333"]}, "368": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018334"]}, "369": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018335"]}, "370": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018336"]}, "371": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018337"]}, "372": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018338"]}, "373": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018339"]}, "374": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018340"]}, "375": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018341"]}, "376": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018342"]}, "377": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018343"]}, "378": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018344"]}, "379": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018345"]}, "380": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018346"]}, "381": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018347"]}, "382": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018348"]}, "383": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018349"]}, "384": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018350"]}, "385": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018351"]}, "386": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018352"]}, "387": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018353"]}, "388": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018354"]}, "389": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018355"]}, "390": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018356"]}, "391": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018357"]}, "392": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018358"]}, "393": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018359"]}, "394": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018360"]}, "395": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018361"]}, "396": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018362"]}, "397": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018363"]}, "398": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018364"]}, "399": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018365"]}, "400": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018366"]}, "401": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018367"]}, "402": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018368"]}, "403": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018369"]}, "404": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018370"]}, "405": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018371"]}, "406": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018372"]}, "407": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018373"]}, "408": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018374"]}, "409": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018375"]}, "410": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018376"]}, "411": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018377"]}, "412": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018378"]}, "413": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018379"]}, "414": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018380"]}, "415": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018381"]}, "416": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018382"]}, "417": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018383"]}, "418": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018384"]}, "419": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018385"]}, "420": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018386"]}, "421": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018387"]}, "422": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018388"]}, "423": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018389"]}, "424": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018390"]}, "425": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018391"]}, "426": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018392"]}, "427": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018393"]}, "428": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018394"]}, "429": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018395"]}, "430": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018396"]}, "431": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018397"]}, "432": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018398"]}, "433": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018399"]}, "434": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018400"]}, "435": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018401"]}, "436": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018402"]}, "437": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018403"]}, "438": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018404"]}, "439": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018405"]}, "440": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018406"]}, "441": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018407"]}, "442": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018408"]}, "443": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018409"]}, "444": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018410"]}, "445": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018411"]}, "446": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018412"]}, "447": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018413"]}, "448": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018414"]}, "449": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018415"]}, "450": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018416"]}, "451": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018417"]}, "452": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018418"]}, "453": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018419"]}, "454": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018420"]}, "455": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018421"]}, "456": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018422"]}, "457": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018423"]}, "458": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018424"]}, "459": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018425"]}, "460": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018426"]}, "461": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018427"]}, "462": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018428"]}, "463": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018429"]}, "464": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018430"]}, "465": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018431"]}, "466": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018432"]}, "467": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018433"]}, "468": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018434"]}, "469": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018435"]}, "470": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018436"]}, "471": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018437"]}, "472": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018438"]}, "473": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018439"]}, "474": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018440"]}, "475": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018441"]}, "476": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018442"]}, "477": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018443"]}, "478": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018444"]}, "479": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018445"]}, "480": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018446"]}, "481": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018447"]}, "482": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018448"]}, "483": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018449"]}, "484": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018450"]}, "485": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018451"]}, "486": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018452"]}, "487": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018453"]}, "488": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018454"]}, "489": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018455"]}, "490": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018456"]}, "491": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018457"]}, "492": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018458"]}, "493": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018459"]}, "494": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018460"]}, "495": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018461"]}, "496": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018462"]}, "497": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018463"]}, "498": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018464"]}, "499": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018465"]}, "500": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018466"]}, "501": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018467"]}, "502": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018468"]}, "503": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018469"]}, "504": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018470"]}, "505": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018471"]}, "506": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018472"]}, "507": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018473"]}, "508": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018474"]}, "509": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018475"]}, "510": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018476"]}, "511": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018477"]}, "512": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018478"]}, "513": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018479"]}, "514": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018480"]}, "515": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018481"]}, "516": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018482"]}, "517": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018483"]}, "518": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018484"]}, "519": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018485"]}, "520": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018486"]}, "521": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018487"]}, "522": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018488"]}, "523": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018489"]}, "524": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018490"]}, "525": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018491"]}, "526": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018492"]}, "527": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018493"]}, "528": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018494"]}, "529": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018495"]}, "530": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082421255920000018496"]}}, "0008002A": {"0": {"vr": "DT", "Value": ["20230825152242.146000"]}, "1": {"vr": "DT", "Value": ["20230825152242.146000"]}, "2": {"vr": "DT", "Value": ["20230825152242.146000"]}, "3": {"vr": "DT", "Value": ["20230825152242.146000"]}, "4": {"vr": "DT", "Value": ["20230825152242.146000"]}, "5": {"vr": "DT", "Value": ["20230825152242.146000"]}, "6": {"vr": "DT", "Value": ["20230825152242.164000"]}, "7": {"vr": "DT", "Value": ["20230825152242.184000"]}, "8": {"vr": "DT", "Value": ["20230825152242.223000"]}, "9": {"vr": "DT", "Value": ["20230825152242.262000"]}, "10": {"vr": "DT", "Value": ["20230825152242.281000"]}, "11": {"vr": "DT", "Value": ["20230825152242.320000"]}, "12": {"vr": "DT", "Value": ["20230825152242.359000"]}, "13": {"vr": "DT", "Value": ["20230825152242.379000"]}, "14": {"vr": "DT", "Value": ["20230825152242.418000"]}, "15": {"vr": "DT", "Value": ["20230825152242.457000"]}, "16": {"vr": "DT", "Value": ["20230825152242.476000"]}, "17": {"vr": "DT", "Value": ["20230825152242.516000"]}, "18": {"vr": "DT", "Value": ["20230825152242.555000"]}, "19": {"vr": "DT", "Value": ["20230825152242.574000"]}, "20": {"vr": "DT", "Value": ["20230825152242.613000"]}, "21": {"vr": "DT", "Value": ["20230825152242.652000"]}, "22": {"vr": "DT", "Value": ["20230825152242.672000"]}, "23": {"vr": "DT", "Value": ["20230825152242.711000"]}, "24": {"vr": "DT", "Value": ["20230825152242.750000"]}, "25": {"vr": "DT", "Value": ["20230825152242.770000"]}, "26": {"vr": "DT", "Value": ["20230825152242.809000"]}, "27": {"vr": "DT", "Value": ["20230825152242.848000"]}, "28": {"vr": "DT", "Value": ["20230825152242.867000"]}, "29": {"vr": "DT", "Value": ["20230825152242.906000"]}, "30": {"vr": "DT", "Value": ["20230825152242.945000"]}, "31": {"vr": "DT", "Value": ["20230825152242.965000"]}, "32": {"vr": "DT", "Value": ["20230825152243.004000"]}, "33": {"vr": "DT", "Value": ["20230825152243.043000"]}, "34": {"vr": "DT", "Value": ["20230825152243.063000"]}, "35": {"vr": "DT", "Value": ["20230825152243.102000"]}, "36": {"vr": "DT", "Value": ["20230825152243.141000"]}, "37": {"vr": "DT", "Value": ["20230825152243.161000"]}, "38": {"vr": "DT", "Value": ["20230825152243.200000"]}, "39": {"vr": "DT", "Value": ["20230825152243.239000"]}, "40": {"vr": "DT", "Value": ["20230825152243.258000"]}, "41": {"vr": "DT", "Value": ["20230825152243.297000"]}, "42": {"vr": "DT", "Value": ["20230825152243.336000"]}, "43": {"vr": "DT", "Value": ["20230825152243.356000"]}, "44": {"vr": "DT", "Value": ["20230825152243.395000"]}, "45": {"vr": "DT", "Value": ["20230825152243.434000"]}, "46": {"vr": "DT", "Value": ["20230825152243.454000"]}, "47": {"vr": "DT", "Value": ["20230825152243.493000"]}, "48": {"vr": "DT", "Value": ["20230825152243.532000"]}, "49": {"vr": "DT", "Value": ["20230825152243.551000"]}, "50": {"vr": "DT", "Value": ["20230825152243.590000"]}, "51": {"vr": "DT", "Value": ["20230825152243.630000"]}, "52": {"vr": "DT", "Value": ["20230825152243.649000"]}, "53": {"vr": "DT", "Value": ["20230825152243.688000"]}, "54": {"vr": "DT", "Value": ["20230825152243.727000"]}, "55": {"vr": "DT", "Value": ["20230825152243.747000"]}, "56": {"vr": "DT", "Value": ["20230825152243.786000"]}, "57": {"vr": "DT", "Value": ["20230825152243.825000"]}, "58": {"vr": "DT", "Value": ["20230825152243.845000"]}, "59": {"vr": "DT", "Value": ["20230825152243.884000"]}, "60": {"vr": "DT", "Value": ["20230825152243.923000"]}, "61": {"vr": "DT", "Value": ["20230825152243.943000"]}, "62": {"vr": "DT", "Value": ["20230825152243.981000"]}, "63": {"vr": "DT", "Value": ["20230825152244.020000"]}, "64": {"vr": "DT", "Value": ["20230825152244.040000"]}, "65": {"vr": "DT", "Value": ["20230825152244.079000"]}, "66": {"vr": "DT", "Value": ["20230825152244.119000"]}, "67": {"vr": "DT", "Value": ["20230825152244.138000"]}, "68": {"vr": "DT", "Value": ["20230825152244.177000"]}, "69": {"vr": "DT", "Value": ["20230825152244.216000"]}, "70": {"vr": "DT", "Value": ["20230825152244.236000"]}, "71": {"vr": "DT", "Value": ["20230825152244.275000"]}, "72": {"vr": "DT", "Value": ["20230825152244.314000"]}, "73": {"vr": "DT", "Value": ["20230825152244.333000"]}, "74": {"vr": "DT", "Value": ["20230825152244.372000"]}, "75": {"vr": "DT", "Value": ["20230825152244.412000"]}, "76": {"vr": "DT", "Value": ["20230825152244.431000"]}, "77": {"vr": "DT", "Value": ["20230825152244.470000"]}, "78": {"vr": "DT", "Value": ["20230825152244.509000"]}, "79": {"vr": "DT", "Value": ["20230825152244.529000"]}, "80": {"vr": "DT", "Value": ["20230825152244.568000"]}, "81": {"vr": "DT", "Value": ["20230825152244.607000"]}, "82": {"vr": "DT", "Value": ["20230825152244.627000"]}, "83": {"vr": "DT", "Value": ["20230825152244.666000"]}, "84": {"vr": "DT", "Value": ["20230825152244.705000"]}, "85": {"vr": "DT", "Value": ["20230825152244.724000"]}, "86": {"vr": "DT", "Value": ["20230825152244.763000"]}, "87": {"vr": "DT", "Value": ["20230825152244.802000"]}, "88": {"vr": "DT", "Value": ["20230825152244.822000"]}, "89": {"vr": "DT", "Value": ["20230825152244.861000"]}, "90": {"vr": "DT", "Value": ["20230825152244.900000"]}, "91": {"vr": "DT", "Value": ["20230825152244.919000"]}, "92": {"vr": "DT", "Value": ["20230825152244.958000"]}, "93": {"vr": "DT", "Value": ["20230825152244.997000"]}, "94": {"vr": "DT", "Value": ["20230825152245.017000"]}, "95": {"vr": "DT", "Value": ["20230825152245.056000"]}, "96": {"vr": "DT", "Value": ["20230825152245.095000"]}, "97": {"vr": "DT", "Value": ["20230825152245.115000"]}, "98": {"vr": "DT", "Value": ["20230825152245.154000"]}, "99": {"vr": "DT", "Value": ["20230825152245.193000"]}, "100": {"vr": "DT", "Value": ["20230825152245.213000"]}, "101": {"vr": "DT", "Value": ["20230825152245.252000"]}, "102": {"vr": "DT", "Value": ["20230825152245.291000"]}, "103": {"vr": "DT", "Value": ["20230825152245.310000"]}, "104": {"vr": "DT", "Value": ["20230825152245.349000"]}, "105": {"vr": "DT", "Value": ["20230825152245.389000"]}, "106": {"vr": "DT", "Value": ["20230825152245.408000"]}, "107": {"vr": "DT", "Value": ["20230825152245.447000"]}, "108": {"vr": "DT", "Value": ["20230825152245.486000"]}, "109": {"vr": "DT", "Value": ["20230825152245.506000"]}, "110": {"vr": "DT", "Value": ["20230825152245.545000"]}, "111": {"vr": "DT", "Value": ["20230825152245.584000"]}, "112": {"vr": "DT", "Value": ["20230825152245.603000"]}, "113": {"vr": "DT", "Value": ["20230825152245.643000"]}, "114": {"vr": "DT", "Value": ["20230825152245.682000"]}, "115": {"vr": "DT", "Value": ["20230825152245.701000"]}, "116": {"vr": "DT", "Value": ["20230825152245.740000"]}, "117": {"vr": "DT", "Value": ["20230825152245.780000"]}, "118": {"vr": "DT", "Value": ["20230825152245.799000"]}, "119": {"vr": "DT", "Value": ["20230825152245.838000"]}, "120": {"vr": "DT", "Value": ["20230825152245.877000"]}, "121": {"vr": "DT", "Value": ["20230825152245.897000"]}, "122": {"vr": "DT", "Value": ["20230825152245.936000"]}, "123": {"vr": "DT", "Value": ["20230825152245.975000"]}, "124": {"vr": "DT", "Value": ["20230825152245.995000"]}, "125": {"vr": "DT", "Value": ["20230825152246.034000"]}, "126": {"vr": "DT", "Value": ["20230825152246.073000"]}, "127": {"vr": "DT", "Value": ["20230825152246.092000"]}, "128": {"vr": "DT", "Value": ["20230825152246.131000"]}, "129": {"vr": "DT", "Value": ["20230825152246.171000"]}, "130": {"vr": "DT", "Value": ["20230825152246.190000"]}, "131": {"vr": "DT", "Value": ["20230825152246.229000"]}, "132": {"vr": "DT", "Value": ["20230825152246.268000"]}, "133": {"vr": "DT", "Value": ["20230825152246.288000"]}, "134": {"vr": "DT", "Value": ["20230825152246.327000"]}, "135": {"vr": "DT", "Value": ["20230825152246.366000"]}, "136": {"vr": "DT", "Value": ["20230825152246.386000"]}, "137": {"vr": "DT", "Value": ["20230825152246.425000"]}, "138": {"vr": "DT", "Value": ["20230825152246.464000"]}, "139": {"vr": "DT", "Value": ["20230825152246.483000"]}, "140": {"vr": "DT", "Value": ["20230825152246.522000"]}, "141": {"vr": "DT", "Value": ["20230825152246.562000"]}, "142": {"vr": "DT", "Value": ["20230825152246.581000"]}, "143": {"vr": "DT", "Value": ["20230825152246.620000"]}, "144": {"vr": "DT", "Value": ["20230825152246.659000"]}, "145": {"vr": "DT", "Value": ["20230825152246.679000"]}, "146": {"vr": "DT", "Value": ["20230825152246.718000"]}, "147": {"vr": "DT", "Value": ["20230825152246.757000"]}, "148": {"vr": "DT", "Value": ["20230825152246.776000"]}, "149": {"vr": "DT", "Value": ["20230825152246.816000"]}, "150": {"vr": "DT", "Value": ["20230825152246.855000"]}, "151": {"vr": "DT", "Value": ["20230825152246.874000"]}, "152": {"vr": "DT", "Value": ["20230825152246.913000"]}, "153": {"vr": "DT", "Value": ["20230825152246.952000"]}, "154": {"vr": "DT", "Value": ["20230825152246.972000"]}, "155": {"vr": "DT", "Value": ["20230825152247.011000"]}, "156": {"vr": "DT", "Value": ["20230825152247.050000"]}, "157": {"vr": "DT", "Value": ["20230825152247.070000"]}, "158": {"vr": "DT", "Value": ["20230825152247.109000"]}, "159": {"vr": "DT", "Value": ["20230825152247.148000"]}, "160": {"vr": "DT", "Value": ["20230825152247.167000"]}, "161": {"vr": "DT", "Value": ["20230825152247.206000"]}, "162": {"vr": "DT", "Value": ["20230825152247.245000"]}, "163": {"vr": "DT", "Value": ["20230825152247.265000"]}, "164": {"vr": "DT", "Value": ["20230825152247.304000"]}, "165": {"vr": "DT", "Value": ["20230825152247.343000"]}, "166": {"vr": "DT", "Value": ["20230825152247.363000"]}, "167": {"vr": "DT", "Value": ["20230825152247.402000"]}, "168": {"vr": "DT", "Value": ["20230825152247.441000"]}, "169": {"vr": "DT", "Value": ["20230825152247.460000"]}, "170": {"vr": "DT", "Value": ["20230825152247.499000"]}, "171": {"vr": "DT", "Value": ["20230825152247.539000"]}, "172": {"vr": "DT", "Value": ["20230825152247.558000"]}, "173": {"vr": "DT", "Value": ["20230825152247.597000"]}, "174": {"vr": "DT", "Value": ["20230825152247.636000"]}, "175": {"vr": "DT", "Value": ["20230825152247.656000"]}, "176": {"vr": "DT", "Value": ["20230825152247.695000"]}, "177": {"vr": "DT", "Value": ["20230825152247.734000"]}, "178": {"vr": "DT", "Value": ["20230825152247.754000"]}, "179": {"vr": "DT", "Value": ["20230825152247.793000"]}, "180": {"vr": "DT", "Value": ["20230825152247.832000"]}, "181": {"vr": "DT", "Value": ["20230825152247.851000"]}, "182": {"vr": "DT", "Value": ["20230825152247.890000"]}, "183": {"vr": "DT", "Value": ["20230825152247.929000"]}, "184": {"vr": "DT", "Value": ["20230825152247.949000"]}, "185": {"vr": "DT", "Value": ["20230825152247.988000"]}, "186": {"vr": "DT", "Value": ["20230825152248.028000"]}, "187": {"vr": "DT", "Value": ["20230825152248.047000"]}, "188": {"vr": "DT", "Value": ["20230825152248.086000"]}, "189": {"vr": "DT", "Value": ["20230825152248.125000"]}, "190": {"vr": "DT", "Value": ["20230825152248.145000"]}, "191": {"vr": "DT", "Value": ["20230825152248.184000"]}, "192": {"vr": "DT", "Value": ["20230825152248.223000"]}, "193": {"vr": "DT", "Value": ["20230825152248.242000"]}, "194": {"vr": "DT", "Value": ["20230825152248.281000"]}, "195": {"vr": "DT", "Value": ["20230825152248.321000"]}, "196": {"vr": "DT", "Value": ["20230825152248.340000"]}, "197": {"vr": "DT", "Value": ["20230825152248.379000"]}, "198": {"vr": "DT", "Value": ["20230825152248.418000"]}, "199": {"vr": "DT", "Value": ["20230825152248.438000"]}, "200": {"vr": "DT", "Value": ["20230825152248.477000"]}, "201": {"vr": "DT", "Value": ["20230825152248.516000"]}, "202": {"vr": "DT", "Value": ["20230825152248.535000"]}, "203": {"vr": "DT", "Value": ["20230825152248.575000"]}, "204": {"vr": "DT", "Value": ["20230825152248.614000"]}, "205": {"vr": "DT", "Value": ["20230825152248.633000"]}, "206": {"vr": "DT", "Value": ["20230825152248.673000"]}, "207": {"vr": "DT", "Value": ["20230825152248.712000"]}, "208": {"vr": "DT", "Value": ["20230825152248.731000"]}, "209": {"vr": "DT", "Value": ["20230825152248.770000"]}, "210": {"vr": "DT", "Value": ["20230825152248.809000"]}, "211": {"vr": "DT", "Value": ["20230825152248.829000"]}, "212": {"vr": "DT", "Value": ["20230825152248.868000"]}, "213": {"vr": "DT", "Value": ["20230825152248.907000"]}, "214": {"vr": "DT", "Value": ["20230825152248.926000"]}, "215": {"vr": "DT", "Value": ["20230825152248.966000"]}, "216": {"vr": "DT", "Value": ["20230825152249.005000"]}, "217": {"vr": "DT", "Value": ["20230825152249.024000"]}, "218": {"vr": "DT", "Value": ["20230825152249.063000"]}, "219": {"vr": "DT", "Value": ["20230825152249.102000"]}, "220": {"vr": "DT", "Value": ["20230825152249.122000"]}, "221": {"vr": "DT", "Value": ["20230825152249.161000"]}, "222": {"vr": "DT", "Value": ["20230825152249.200000"]}, "223": {"vr": "DT", "Value": ["20230825152249.220000"]}, "224": {"vr": "DT", "Value": ["20230825152249.259000"]}, "225": {"vr": "DT", "Value": ["20230825152249.298000"]}, "226": {"vr": "DT", "Value": ["20230825152249.317000"]}, "227": {"vr": "DT", "Value": ["20230825152249.356000"]}, "228": {"vr": "DT", "Value": ["20230825152249.395000"]}, "229": {"vr": "DT", "Value": ["20230825152249.415000"]}, "230": {"vr": "DT", "Value": ["20230825152249.454000"]}, "231": {"vr": "DT", "Value": ["20230825152249.493000"]}, "232": {"vr": "DT", "Value": ["20230825152249.513000"]}, "233": {"vr": "DT", "Value": ["20230825152249.552000"]}, "234": {"vr": "DT", "Value": ["20230825152249.591000"]}, "235": {"vr": "DT", "Value": ["20230825152249.610000"]}, "236": {"vr": "DT", "Value": ["20230825152249.650000"]}, "237": {"vr": "DT", "Value": ["20230825152249.689000"]}, "238": {"vr": "DT", "Value": ["20230825152249.708000"]}, "239": {"vr": "DT", "Value": ["20230825152249.747000"]}, "240": {"vr": "DT", "Value": ["20230825152249.786000"]}, "241": {"vr": "DT", "Value": ["20230825152249.806000"]}, "242": {"vr": "DT", "Value": ["20230825152249.845000"]}, "243": {"vr": "DT", "Value": ["20230825152249.884000"]}, "244": {"vr": "DT", "Value": ["20230825152249.903000"]}, "245": {"vr": "DT", "Value": ["20230825152249.943000"]}, "246": {"vr": "DT", "Value": ["20230825152249.982000"]}, "247": {"vr": "DT", "Value": ["20230825152250.001000"]}, "248": {"vr": "DT", "Value": ["20230825152250.040000"]}, "249": {"vr": "DT", "Value": ["20230825152250.079000"]}, "250": {"vr": "DT", "Value": ["20230825152250.099000"]}, "251": {"vr": "DT", "Value": ["20230825152250.138000"]}, "252": {"vr": "DT", "Value": ["20230825152250.177000"]}, "253": {"vr": "DT", "Value": ["20230825152250.196000"]}, "254": {"vr": "DT", "Value": ["20230825152250.236000"]}, "255": {"vr": "DT", "Value": ["20230825152250.275000"]}, "256": {"vr": "DT", "Value": ["20230825152250.295000"]}, "257": {"vr": "DT", "Value": ["20230825152250.334000"]}, "258": {"vr": "DT", "Value": ["20230825152250.373000"]}, "259": {"vr": "DT", "Value": ["20230825152250.392000"]}, "260": {"vr": "DT", "Value": ["20230825152250.431000"]}, "261": {"vr": "DT", "Value": ["20230825152250.470000"]}, "262": {"vr": "DT", "Value": ["20230825152250.490000"]}, "263": {"vr": "DT", "Value": ["20230825152250.529000"]}, "264": {"vr": "DT", "Value": ["20230825152250.568000"]}, "265": {"vr": "DT", "Value": ["20230825152250.588000"]}, "266": {"vr": "DT", "Value": ["20230825152250.627000"]}, "267": {"vr": "DT", "Value": ["20230825152250.666000"]}, "268": {"vr": "DT", "Value": ["20230825152250.686000"]}, "269": {"vr": "DT", "Value": ["20230825152250.725000"]}, "270": {"vr": "DT", "Value": ["20230825152250.764000"]}, "271": {"vr": "DT", "Value": ["20230825152250.783000"]}, "272": {"vr": "DT", "Value": ["20230825152250.822000"]}, "273": {"vr": "DT", "Value": ["20230825152250.861000"]}, "274": {"vr": "DT", "Value": ["20230825152250.881000"]}, "275": {"vr": "DT", "Value": ["20230825152250.920000"]}, "276": {"vr": "DT", "Value": ["20230825152250.959000"]}, "277": {"vr": "DT", "Value": ["20230825152250.979000"]}, "278": {"vr": "DT", "Value": ["20230825152251.018000"]}, "279": {"vr": "DT", "Value": ["20230825152251.057000"]}, "280": {"vr": "DT", "Value": ["20230825152251.077000"]}, "281": {"vr": "DT", "Value": ["20230825152251.116000"]}, "282": {"vr": "DT", "Value": ["20230825152251.155000"]}, "283": {"vr": "DT", "Value": ["20230825152251.174000"]}, "284": {"vr": "DT", "Value": ["20230825152251.213000"]}, "285": {"vr": "DT", "Value": ["20230825152251.253000"]}, "286": {"vr": "DT", "Value": ["20230825152251.272000"]}, "287": {"vr": "DT", "Value": ["20230825152251.311000"]}, "288": {"vr": "DT", "Value": ["20230825152251.350000"]}, "289": {"vr": "DT", "Value": ["20230825152251.370000"]}, "290": {"vr": "DT", "Value": ["20230825152251.409000"]}, "291": {"vr": "DT", "Value": ["20230825152251.448000"]}, "292": {"vr": "DT", "Value": ["20230825152251.467000"]}, "293": {"vr": "DT", "Value": ["20230825152251.506000"]}, "294": {"vr": "DT", "Value": ["20230825152251.546000"]}, "295": {"vr": "DT", "Value": ["20230825152251.565000"]}, "296": {"vr": "DT", "Value": ["20230825152251.604000"]}, "297": {"vr": "DT", "Value": ["20230825152251.643000"]}, "298": {"vr": "DT", "Value": ["20230825152251.663000"]}, "299": {"vr": "DT", "Value": ["20230825152251.702000"]}, "300": {"vr": "DT", "Value": ["20230825152251.741000"]}, "301": {"vr": "DT", "Value": ["20230825152251.760000"]}, "302": {"vr": "DT", "Value": ["20230825152251.799000"]}, "303": {"vr": "DT", "Value": ["20230825152251.838000"]}, "304": {"vr": "DT", "Value": ["20230825152251.858000"]}, "305": {"vr": "DT", "Value": ["20230825152251.897000"]}, "306": {"vr": "DT", "Value": ["20230825152251.936000"]}, "307": {"vr": "DT", "Value": ["20230825152251.956000"]}, "308": {"vr": "DT", "Value": ["20230825152251.995000"]}, "309": {"vr": "DT", "Value": ["20230825152252.034000"]}, "310": {"vr": "DT", "Value": ["20230825152252.054000"]}, "311": {"vr": "DT", "Value": ["20230825152252.093000"]}, "312": {"vr": "DT", "Value": ["20230825152252.132000"]}, "313": {"vr": "DT", "Value": ["20230825152252.151000"]}, "314": {"vr": "DT", "Value": ["20230825152252.190000"]}, "315": {"vr": "DT", "Value": ["20230825152252.229000"]}, "316": {"vr": "DT", "Value": ["20230825152252.249000"]}, "317": {"vr": "DT", "Value": ["20230825152252.288000"]}, "318": {"vr": "DT", "Value": ["20230825152252.327000"]}, "319": {"vr": "DT", "Value": ["20230825152252.347000"]}, "320": {"vr": "DT", "Value": ["20230825152252.386000"]}, "321": {"vr": "DT", "Value": ["20230825152252.425000"]}, "322": {"vr": "DT", "Value": ["20230825152252.444000"]}, "323": {"vr": "DT", "Value": ["20230825152252.484000"]}, "324": {"vr": "DT", "Value": ["20230825152252.523000"]}, "325": {"vr": "DT", "Value": ["20230825152252.542000"]}, "326": {"vr": "DT", "Value": ["20230825152252.581000"]}, "327": {"vr": "DT", "Value": ["20230825152252.621000"]}, "328": {"vr": "DT", "Value": ["20230825152252.640000"]}, "329": {"vr": "DT", "Value": ["20230825152252.679000"]}, "330": {"vr": "DT", "Value": ["20230825152252.718000"]}, "331": {"vr": "DT", "Value": ["20230825152252.738000"]}, "332": {"vr": "DT", "Value": ["20230825152252.777000"]}, "333": {"vr": "DT", "Value": ["20230825152252.816000"]}, "334": {"vr": "DT", "Value": ["20230825152252.835000"]}, "335": {"vr": "DT", "Value": ["20230825152252.875000"]}, "336": {"vr": "DT", "Value": ["20230825152252.914000"]}, "337": {"vr": "DT", "Value": ["20230825152252.933000"]}, "338": {"vr": "DT", "Value": ["20230825152252.972000"]}, "339": {"vr": "DT", "Value": ["20230825152253.011000"]}, "340": {"vr": "DT", "Value": ["20230825152253.031000"]}, "341": {"vr": "DT", "Value": ["20230825152253.070000"]}, "342": {"vr": "DT", "Value": ["20230825152253.109000"]}, "343": {"vr": "DT", "Value": ["20230825152253.129000"]}, "344": {"vr": "DT", "Value": ["20230825152253.168000"]}, "345": {"vr": "DT", "Value": ["20230825152253.207000"]}, "346": {"vr": "DT", "Value": ["20230825152253.227000"]}, "347": {"vr": "DT", "Value": ["20230825152253.266000"]}, "348": {"vr": "DT", "Value": ["20230825152253.305000"]}, "349": {"vr": "DT", "Value": ["20230825152253.324000"]}, "350": {"vr": "DT", "Value": ["20230825152253.363000"]}, "351": {"vr": "DT", "Value": ["20230825152253.402000"]}, "352": {"vr": "DT", "Value": ["20230825152253.422000"]}, "353": {"vr": "DT", "Value": ["20230825152253.461000"]}, "354": {"vr": "DT", "Value": ["20230825152253.500000"]}, "355": {"vr": "DT", "Value": ["20230825152253.520000"]}, "356": {"vr": "DT", "Value": ["20230825152253.559000"]}, "357": {"vr": "DT", "Value": ["20230825152253.598000"]}, "358": {"vr": "DT", "Value": ["20230825152253.617000"]}, "359": {"vr": "DT", "Value": ["20230825152253.657000"]}, "360": {"vr": "DT", "Value": ["20230825152253.696000"]}, "361": {"vr": "DT", "Value": ["20230825152253.715000"]}, "362": {"vr": "DT", "Value": ["20230825152253.754000"]}, "363": {"vr": "DT", "Value": ["20230825152253.793000"]}, "364": {"vr": "DT", "Value": ["20230825152253.813000"]}, "365": {"vr": "DT", "Value": ["20230825152253.852000"]}, "366": {"vr": "DT", "Value": ["20230825152253.891000"]}, "367": {"vr": "DT", "Value": ["20230825152253.911000"]}, "368": {"vr": "DT", "Value": ["20230825152253.950000"]}, "369": {"vr": "DT", "Value": ["20230825152253.989000"]}, "370": {"vr": "DT", "Value": ["20230825152254.008000"]}, "371": {"vr": "DT", "Value": ["20230825152254.047000"]}, "372": {"vr": "DT", "Value": ["20230825152254.086000"]}, "373": {"vr": "DT", "Value": ["20230825152254.106000"]}, "374": {"vr": "DT", "Value": ["20230825152254.145000"]}, "375": {"vr": "DT", "Value": ["20230825152254.184000"]}, "376": {"vr": "DT", "Value": ["20230825152254.204000"]}, "377": {"vr": "DT", "Value": ["20230825152254.243000"]}, "378": {"vr": "DT", "Value": ["20230825152254.282000"]}, "379": {"vr": "DT", "Value": ["20230825152254.301000"]}, "380": {"vr": "DT", "Value": ["20230825152254.340000"]}, "381": {"vr": "DT", "Value": ["20230825152254.379000"]}, "382": {"vr": "DT", "Value": ["20230825152254.399000"]}, "383": {"vr": "DT", "Value": ["20230825152254.438000"]}, "384": {"vr": "DT", "Value": ["20230825152254.477000"]}, "385": {"vr": "DT", "Value": ["20230825152254.497000"]}, "386": {"vr": "DT", "Value": ["20230825152254.536000"]}, "387": {"vr": "DT", "Value": ["20230825152254.575000"]}, "388": {"vr": "DT", "Value": ["20230825152254.594000"]}, "389": {"vr": "DT", "Value": ["20230825152254.634000"]}, "390": {"vr": "DT", "Value": ["20230825152254.673000"]}, "391": {"vr": "DT", "Value": ["20230825152254.692000"]}, "392": {"vr": "DT", "Value": ["20230825152254.731000"]}, "393": {"vr": "DT", "Value": ["20230825152254.770000"]}, "394": {"vr": "DT", "Value": ["20230825152254.790000"]}, "395": {"vr": "DT", "Value": ["20230825152254.829000"]}, "396": {"vr": "DT", "Value": ["20230825152254.868000"]}, "397": {"vr": "DT", "Value": ["20230825152254.888000"]}, "398": {"vr": "DT", "Value": ["20230825152254.927000"]}, "399": {"vr": "DT", "Value": ["20230825152254.966000"]}, "400": {"vr": "DT", "Value": ["20230825152254.985000"]}, "401": {"vr": "DT", "Value": ["20230825152255.025000"]}, "402": {"vr": "DT", "Value": ["20230825152255.064000"]}, "403": {"vr": "DT", "Value": ["20230825152255.083000"]}, "404": {"vr": "DT", "Value": ["20230825152255.122000"]}, "405": {"vr": "DT", "Value": ["20230825152255.162000"]}, "406": {"vr": "DT", "Value": ["20230825152255.181000"]}, "407": {"vr": "DT", "Value": ["20230825152255.220000"]}, "408": {"vr": "DT", "Value": ["20230825152255.259000"]}, "409": {"vr": "DT", "Value": ["20230825152255.279000"]}, "410": {"vr": "DT", "Value": ["20230825152255.318000"]}, "411": {"vr": "DT", "Value": ["20230825152255.357000"]}, "412": {"vr": "DT", "Value": ["20230825152255.376000"]}, "413": {"vr": "DT", "Value": ["20230825152255.415000"]}, "414": {"vr": "DT", "Value": ["20230825152255.455000"]}, "415": {"vr": "DT", "Value": ["20230825152255.474000"]}, "416": {"vr": "DT", "Value": ["20230825152255.513000"]}, "417": {"vr": "DT", "Value": ["20230825152255.552000"]}, "418": {"vr": "DT", "Value": ["20230825152255.572000"]}, "419": {"vr": "DT", "Value": ["20230825152255.611000"]}, "420": {"vr": "DT", "Value": ["20230825152255.650000"]}, "421": {"vr": "DT", "Value": ["20230825152255.670000"]}, "422": {"vr": "DT", "Value": ["20230825152255.709000"]}, "423": {"vr": "DT", "Value": ["20230825152255.748000"]}, "424": {"vr": "DT", "Value": ["20230825152255.767000"]}, "425": {"vr": "DT", "Value": ["20230825152255.807000"]}, "426": {"vr": "DT", "Value": ["20230825152255.846000"]}, "427": {"vr": "DT", "Value": ["20230825152255.865000"]}, "428": {"vr": "DT", "Value": ["20230825152255.904000"]}, "429": {"vr": "DT", "Value": ["20230825152255.943000"]}, "430": {"vr": "DT", "Value": ["20230825152255.963000"]}, "431": {"vr": "DT", "Value": ["20230825152256.002000"]}, "432": {"vr": "DT", "Value": ["20230825152256.041000"]}, "433": {"vr": "DT", "Value": ["20230825152256.060000"]}, "434": {"vr": "DT", "Value": ["20230825152256.100000"]}, "435": {"vr": "DT", "Value": ["20230825152256.139000"]}, "436": {"vr": "DT", "Value": ["20230825152256.158000"]}, "437": {"vr": "DT", "Value": ["20230825152256.198000"]}, "438": {"vr": "DT", "Value": ["20230825152256.237000"]}, "439": {"vr": "DT", "Value": ["20230825152256.256000"]}, "440": {"vr": "DT", "Value": ["20230825152256.295000"]}, "441": {"vr": "DT", "Value": ["20230825152256.334000"]}, "442": {"vr": "DT", "Value": ["20230825152256.354000"]}, "443": {"vr": "DT", "Value": ["20230825152256.393000"]}, "444": {"vr": "DT", "Value": ["20230825152256.432000"]}, "445": {"vr": "DT", "Value": ["20230825152256.451000"]}, "446": {"vr": "DT", "Value": ["20230825152256.490000"]}, "447": {"vr": "DT", "Value": ["20230825152256.529000"]}, "448": {"vr": "DT", "Value": ["20230825152256.549000"]}, "449": {"vr": "DT", "Value": ["20230825152256.588000"]}, "450": {"vr": "DT", "Value": ["20230825152256.627000"]}, "451": {"vr": "DT", "Value": ["20230825152256.647000"]}, "452": {"vr": "DT", "Value": ["20230825152256.685000"]}, "453": {"vr": "DT", "Value": ["20230825152256.725000"]}, "454": {"vr": "DT", "Value": ["20230825152256.744000"]}, "455": {"vr": "DT", "Value": ["20230825152256.784000"]}, "456": {"vr": "DT", "Value": ["20230825152256.823000"]}, "457": {"vr": "DT", "Value": ["20230825152256.842000"]}, "458": {"vr": "DT", "Value": ["20230825152256.881000"]}, "459": {"vr": "DT", "Value": ["20230825152256.920000"]}, "460": {"vr": "DT", "Value": ["20230825152256.940000"]}, "461": {"vr": "DT", "Value": ["20230825152256.979000"]}, "462": {"vr": "DT", "Value": ["20230825152257.018000"]}, "463": {"vr": "DT", "Value": ["20230825152257.037000"]}, "464": {"vr": "DT", "Value": ["20230825152257.077000"]}, "465": {"vr": "DT", "Value": ["20230825152257.116000"]}, "466": {"vr": "DT", "Value": ["20230825152257.136000"]}, "467": {"vr": "DT", "Value": ["20230825152257.175000"]}, "468": {"vr": "DT", "Value": ["20230825152257.214000"]}, "469": {"vr": "DT", "Value": ["20230825152257.233000"]}, "470": {"vr": "DT", "Value": ["20230825152257.272000"]}, "471": {"vr": "DT", "Value": ["20230825152257.311000"]}, "472": {"vr": "DT", "Value": ["20230825152257.331000"]}, "473": {"vr": "DT", "Value": ["20230825152257.370000"]}, "474": {"vr": "DT", "Value": ["20230825152257.409000"]}, "475": {"vr": "DT", "Value": ["20230825152257.429000"]}, "476": {"vr": "DT", "Value": ["20230825152257.468000"]}, "477": {"vr": "DT", "Value": ["20230825152257.507000"]}, "478": {"vr": "DT", "Value": ["20230825152257.526000"]}, "479": {"vr": "DT", "Value": ["20230825152257.565000"]}, "480": {"vr": "DT", "Value": ["20230825152257.605000"]}, "481": {"vr": "DT", "Value": ["20230825152257.624000"]}, "482": {"vr": "DT", "Value": ["20230825152257.663000"]}, "483": {"vr": "DT", "Value": ["20230825152257.702000"]}, "484": {"vr": "DT", "Value": ["20230825152257.722000"]}, "485": {"vr": "DT", "Value": ["20230825152257.761000"]}, "486": {"vr": "DT", "Value": ["20230825152257.800000"]}, "487": {"vr": "DT", "Value": ["20230825152257.820000"]}, "488": {"vr": "DT", "Value": ["20230825152257.859000"]}, "489": {"vr": "DT", "Value": ["20230825152257.898000"]}, "490": {"vr": "DT", "Value": ["20230825152257.917000"]}, "491": {"vr": "DT", "Value": ["20230825152257.956000"]}, "492": {"vr": "DT", "Value": ["20230825152257.995000"]}, "493": {"vr": "DT", "Value": ["20230825152258.015000"]}, "494": {"vr": "DT", "Value": ["20230825152258.054000"]}, "495": {"vr": "DT", "Value": ["20230825152258.093000"]}, "496": {"vr": "DT", "Value": ["20230825152258.113000"]}, "497": {"vr": "DT", "Value": ["20230825152258.152000"]}, "498": {"vr": "DT", "Value": ["20230825152258.191000"]}, "499": {"vr": "DT", "Value": ["20230825152258.211000"]}, "500": {"vr": "DT", "Value": ["20230825152258.250000"]}, "501": {"vr": "DT", "Value": ["20230825152258.289000"]}, "502": {"vr": "DT", "Value": ["20230825152258.308000"]}, "503": {"vr": "DT", "Value": ["20230825152258.347000"]}, "504": {"vr": "DT", "Value": ["20230825152258.387000"]}, "505": {"vr": "DT", "Value": ["20230825152258.406000"]}, "506": {"vr": "DT", "Value": ["20230825152258.445000"]}, "507": {"vr": "DT", "Value": ["20230825152258.484000"]}, "508": {"vr": "DT", "Value": ["20230825152258.504000"]}, "509": {"vr": "DT", "Value": ["20230825152258.543000"]}, "510": {"vr": "DT", "Value": ["20230825152258.582000"]}, "511": {"vr": "DT", "Value": ["20230825152258.602000"]}, "512": {"vr": "DT", "Value": ["20230825152258.641000"]}, "513": {"vr": "DT", "Value": ["20230825152258.680000"]}, "514": {"vr": "DT", "Value": ["20230825152258.699000"]}, "515": {"vr": "DT", "Value": ["20230825152258.738000"]}, "516": {"vr": "DT", "Value": ["20230825152258.777000"]}, "517": {"vr": "DT", "Value": ["20230825152258.797000"]}, "518": {"vr": "DT", "Value": ["20230825152258.836000"]}, "519": {"vr": "DT", "Value": ["20230825152258.875000"]}, "520": {"vr": "DT", "Value": ["20230825152258.894000"]}, "521": {"vr": "DT", "Value": ["20230825152258.933000"]}, "522": {"vr": "DT", "Value": ["20230825152258.972000"]}, "523": {"vr": "DT", "Value": ["20230825152258.992000"]}, "524": {"vr": "DT", "Value": ["20230825152259.031000"]}, "525": {"vr": "DT", "Value": ["20230825152259.070000"]}, "526": {"vr": "DT", "Value": ["20230825152259.090000"]}, "527": {"vr": "DT", "Value": ["20230825152259.129000"]}, "528": {"vr": "DT", "Value": ["20230825152259.168000"]}, "529": {"vr": "DT", "Value": ["20230825152259.188000"]}, "530": {"vr": "DT", "Value": ["20230825152259.227000"]}}, "00080032": {"0": {"vr": "TM", "Value": ["152242.146000"]}, "1": {"vr": "TM", "Value": ["152242.146000"]}, "2": {"vr": "TM", "Value": ["152242.146000"]}, "3": {"vr": "TM", "Value": ["152242.146000"]}, "4": {"vr": "TM", "Value": ["152242.146000"]}, "5": {"vr": "TM", "Value": ["152242.146000"]}, "6": {"vr": "TM", "Value": ["152242.164000"]}, "7": {"vr": "TM", "Value": ["152242.184000"]}, "8": {"vr": "TM", "Value": ["152242.223000"]}, "9": {"vr": "TM", "Value": ["152242.262000"]}, "10": {"vr": "TM", "Value": ["152242.281000"]}, "11": {"vr": "TM", "Value": ["152242.320000"]}, "12": {"vr": "TM", "Value": ["152242.359000"]}, "13": {"vr": "TM", "Value": ["152242.379000"]}, "14": {"vr": "TM", "Value": ["152242.418000"]}, "15": {"vr": "TM", "Value": ["152242.457000"]}, "16": {"vr": "TM", "Value": ["152242.476000"]}, "17": {"vr": "TM", "Value": ["152242.516000"]}, "18": {"vr": "TM", "Value": ["152242.555000"]}, "19": {"vr": "TM", "Value": ["152242.574000"]}, "20": {"vr": "TM", "Value": ["152242.613000"]}, "21": {"vr": "TM", "Value": ["152242.652000"]}, "22": {"vr": "TM", "Value": ["152242.672000"]}, "23": {"vr": "TM", "Value": ["152242.711000"]}, "24": {"vr": "TM", "Value": ["152242.750000"]}, "25": {"vr": "TM", "Value": ["152242.770000"]}, "26": {"vr": "TM", "Value": ["152242.809000"]}, "27": {"vr": "TM", "Value": ["152242.848000"]}, "28": {"vr": "TM", "Value": ["152242.867000"]}, "29": {"vr": "TM", "Value": ["152242.906000"]}, "30": {"vr": "TM", "Value": ["152242.945000"]}, "31": {"vr": "TM", "Value": ["152242.965000"]}, "32": {"vr": "TM", "Value": ["152243.004000"]}, "33": {"vr": "TM", "Value": ["152243.043000"]}, "34": {"vr": "TM", "Value": ["152243.063000"]}, "35": {"vr": "TM", "Value": ["152243.102000"]}, "36": {"vr": "TM", "Value": ["152243.141000"]}, "37": {"vr": "TM", "Value": ["152243.161000"]}, "38": {"vr": "TM", "Value": ["152243.200000"]}, "39": {"vr": "TM", "Value": ["152243.239000"]}, "40": {"vr": "TM", "Value": ["152243.258000"]}, "41": {"vr": "TM", "Value": ["152243.297000"]}, "42": {"vr": "TM", "Value": ["152243.336000"]}, "43": {"vr": "TM", "Value": ["152243.356000"]}, "44": {"vr": "TM", "Value": ["152243.395000"]}, "45": {"vr": "TM", "Value": ["152243.434000"]}, "46": {"vr": "TM", "Value": ["152243.454000"]}, "47": {"vr": "TM", "Value": ["152243.493000"]}, "48": {"vr": "TM", "Value": ["152243.532000"]}, "49": {"vr": "TM", "Value": ["152243.551000"]}, "50": {"vr": "TM", "Value": ["152243.590000"]}, "51": {"vr": "TM", "Value": ["152243.630000"]}, "52": {"vr": "TM", "Value": ["152243.649000"]}, "53": {"vr": "TM", "Value": ["152243.688000"]}, "54": {"vr": "TM", "Value": ["152243.727000"]}, "55": {"vr": "TM", "Value": ["152243.747000"]}, "56": {"vr": "TM", "Value": ["152243.786000"]}, "57": {"vr": "TM", "Value": ["152243.825000"]}, "58": {"vr": "TM", "Value": ["152243.845000"]}, "59": {"vr": "TM", "Value": ["152243.884000"]}, "60": {"vr": "TM", "Value": ["152243.923000"]}, "61": {"vr": "TM", "Value": ["152243.943000"]}, "62": {"vr": "TM", "Value": ["152243.981000"]}, "63": {"vr": "TM", "Value": ["152244.020000"]}, "64": {"vr": "TM", "Value": ["152244.040000"]}, "65": {"vr": "TM", "Value": ["152244.079000"]}, "66": {"vr": "TM", "Value": ["152244.119000"]}, "67": {"vr": "TM", "Value": ["152244.138000"]}, "68": {"vr": "TM", "Value": ["152244.177000"]}, "69": {"vr": "TM", "Value": ["152244.216000"]}, "70": {"vr": "TM", "Value": ["152244.236000"]}, "71": {"vr": "TM", "Value": ["152244.275000"]}, "72": {"vr": "TM", "Value": ["152244.314000"]}, "73": {"vr": "TM", "Value": ["152244.333000"]}, "74": {"vr": "TM", "Value": ["152244.372000"]}, "75": {"vr": "TM", "Value": ["152244.412000"]}, "76": {"vr": "TM", "Value": ["152244.431000"]}, "77": {"vr": "TM", "Value": ["152244.470000"]}, "78": {"vr": "TM", "Value": ["152244.509000"]}, "79": {"vr": "TM", "Value": ["152244.529000"]}, "80": {"vr": "TM", "Value": ["152244.568000"]}, "81": {"vr": "TM", "Value": ["152244.607000"]}, "82": {"vr": "TM", "Value": ["152244.627000"]}, "83": {"vr": "TM", "Value": ["152244.666000"]}, "84": {"vr": "TM", "Value": ["152244.705000"]}, "85": {"vr": "TM", "Value": ["152244.724000"]}, "86": {"vr": "TM", "Value": ["152244.763000"]}, "87": {"vr": "TM", "Value": ["152244.802000"]}, "88": {"vr": "TM", "Value": ["152244.822000"]}, "89": {"vr": "TM", "Value": ["152244.861000"]}, "90": {"vr": "TM", "Value": ["152244.900000"]}, "91": {"vr": "TM", "Value": ["152244.919000"]}, "92": {"vr": "TM", "Value": ["152244.958000"]}, "93": {"vr": "TM", "Value": ["152244.997000"]}, "94": {"vr": "TM", "Value": ["152245.017000"]}, "95": {"vr": "TM", "Value": ["152245.056000"]}, "96": {"vr": "TM", "Value": ["152245.095000"]}, "97": {"vr": "TM", "Value": ["152245.115000"]}, "98": {"vr": "TM", "Value": ["152245.154000"]}, "99": {"vr": "TM", "Value": ["152245.193000"]}, "100": {"vr": "TM", "Value": ["152245.213000"]}, "101": {"vr": "TM", "Value": ["152245.252000"]}, "102": {"vr": "TM", "Value": ["152245.291000"]}, "103": {"vr": "TM", "Value": ["152245.310000"]}, "104": {"vr": "TM", "Value": ["152245.349000"]}, "105": {"vr": "TM", "Value": ["152245.389000"]}, "106": {"vr": "TM", "Value": ["152245.408000"]}, "107": {"vr": "TM", "Value": ["152245.447000"]}, "108": {"vr": "TM", "Value": ["152245.486000"]}, "109": {"vr": "TM", "Value": ["152245.506000"]}, "110": {"vr": "TM", "Value": ["152245.545000"]}, "111": {"vr": "TM", "Value": ["152245.584000"]}, "112": {"vr": "TM", "Value": ["152245.603000"]}, "113": {"vr": "TM", "Value": ["152245.643000"]}, "114": {"vr": "TM", "Value": ["152245.682000"]}, "115": {"vr": "TM", "Value": ["152245.701000"]}, "116": {"vr": "TM", "Value": ["152245.740000"]}, "117": {"vr": "TM", "Value": ["152245.780000"]}, "118": {"vr": "TM", "Value": ["152245.799000"]}, "119": {"vr": "TM", "Value": ["152245.838000"]}, "120": {"vr": "TM", "Value": ["152245.877000"]}, "121": {"vr": "TM", "Value": ["152245.897000"]}, "122": {"vr": "TM", "Value": ["152245.936000"]}, "123": {"vr": "TM", "Value": ["152245.975000"]}, "124": {"vr": "TM", "Value": ["152245.995000"]}, "125": {"vr": "TM", "Value": ["152246.034000"]}, "126": {"vr": "TM", "Value": ["152246.073000"]}, "127": {"vr": "TM", "Value": ["152246.092000"]}, "128": {"vr": "TM", "Value": ["152246.131000"]}, "129": {"vr": "TM", "Value": ["152246.171000"]}, "130": {"vr": "TM", "Value": ["152246.190000"]}, "131": {"vr": "TM", "Value": ["152246.229000"]}, "132": {"vr": "TM", "Value": ["152246.268000"]}, "133": {"vr": "TM", "Value": ["152246.288000"]}, "134": {"vr": "TM", "Value": ["152246.327000"]}, "135": {"vr": "TM", "Value": ["152246.366000"]}, "136": {"vr": "TM", "Value": ["152246.386000"]}, "137": {"vr": "TM", "Value": ["152246.425000"]}, "138": {"vr": "TM", "Value": ["152246.464000"]}, "139": {"vr": "TM", "Value": ["152246.483000"]}, "140": {"vr": "TM", "Value": ["152246.522000"]}, "141": {"vr": "TM", "Value": ["152246.562000"]}, "142": {"vr": "TM", "Value": ["152246.581000"]}, "143": {"vr": "TM", "Value": ["152246.620000"]}, "144": {"vr": "TM", "Value": ["152246.659000"]}, "145": {"vr": "TM", "Value": ["152246.679000"]}, "146": {"vr": "TM", "Value": ["152246.718000"]}, "147": {"vr": "TM", "Value": ["152246.757000"]}, "148": {"vr": "TM", "Value": ["152246.776000"]}, "149": {"vr": "TM", "Value": ["152246.816000"]}, "150": {"vr": "TM", "Value": ["152246.855000"]}, "151": {"vr": "TM", "Value": ["152246.874000"]}, "152": {"vr": "TM", "Value": ["152246.913000"]}, "153": {"vr": "TM", "Value": ["152246.952000"]}, "154": {"vr": "TM", "Value": ["152246.972000"]}, "155": {"vr": "TM", "Value": ["152247.011000"]}, "156": {"vr": "TM", "Value": ["152247.050000"]}, "157": {"vr": "TM", "Value": ["152247.070000"]}, "158": {"vr": "TM", "Value": ["152247.109000"]}, "159": {"vr": "TM", "Value": ["152247.148000"]}, "160": {"vr": "TM", "Value": ["152247.167000"]}, "161": {"vr": "TM", "Value": ["152247.206000"]}, "162": {"vr": "TM", "Value": ["152247.245000"]}, "163": {"vr": "TM", "Value": ["152247.265000"]}, "164": {"vr": "TM", "Value": ["152247.304000"]}, "165": {"vr": "TM", "Value": ["152247.343000"]}, "166": {"vr": "TM", "Value": ["152247.363000"]}, "167": {"vr": "TM", "Value": ["152247.402000"]}, "168": {"vr": "TM", "Value": ["152247.441000"]}, "169": {"vr": "TM", "Value": ["152247.460000"]}, "170": {"vr": "TM", "Value": ["152247.499000"]}, "171": {"vr": "TM", "Value": ["152247.539000"]}, "172": {"vr": "TM", "Value": ["152247.558000"]}, "173": {"vr": "TM", "Value": ["152247.597000"]}, "174": {"vr": "TM", "Value": ["152247.636000"]}, "175": {"vr": "TM", "Value": ["152247.656000"]}, "176": {"vr": "TM", "Value": ["152247.695000"]}, "177": {"vr": "TM", "Value": ["152247.734000"]}, "178": {"vr": "TM", "Value": ["152247.754000"]}, "179": {"vr": "TM", "Value": ["152247.793000"]}, "180": {"vr": "TM", "Value": ["152247.832000"]}, "181": {"vr": "TM", "Value": ["152247.851000"]}, "182": {"vr": "TM", "Value": ["152247.890000"]}, "183": {"vr": "TM", "Value": ["152247.929000"]}, "184": {"vr": "TM", "Value": ["152247.949000"]}, "185": {"vr": "TM", "Value": ["152247.988000"]}, "186": {"vr": "TM", "Value": ["152248.028000"]}, "187": {"vr": "TM", "Value": ["152248.047000"]}, "188": {"vr": "TM", "Value": ["152248.086000"]}, "189": {"vr": "TM", "Value": ["152248.125000"]}, "190": {"vr": "TM", "Value": ["152248.145000"]}, "191": {"vr": "TM", "Value": ["152248.184000"]}, "192": {"vr": "TM", "Value": ["152248.223000"]}, "193": {"vr": "TM", "Value": ["152248.242000"]}, "194": {"vr": "TM", "Value": ["152248.281000"]}, "195": {"vr": "TM", "Value": ["152248.321000"]}, "196": {"vr": "TM", "Value": ["152248.340000"]}, "197": {"vr": "TM", "Value": ["152248.379000"]}, "198": {"vr": "TM", "Value": ["152248.418000"]}, "199": {"vr": "TM", "Value": ["152248.438000"]}, "200": {"vr": "TM", "Value": ["152248.477000"]}, "201": {"vr": "TM", "Value": ["152248.516000"]}, "202": {"vr": "TM", "Value": ["152248.535000"]}, "203": {"vr": "TM", "Value": ["152248.575000"]}, "204": {"vr": "TM", "Value": ["152248.614000"]}, "205": {"vr": "TM", "Value": ["152248.633000"]}, "206": {"vr": "TM", "Value": ["152248.673000"]}, "207": {"vr": "TM", "Value": ["152248.712000"]}, "208": {"vr": "TM", "Value": ["152248.731000"]}, "209": {"vr": "TM", "Value": ["152248.770000"]}, "210": {"vr": "TM", "Value": ["152248.809000"]}, "211": {"vr": "TM", "Value": ["152248.829000"]}, "212": {"vr": "TM", "Value": ["152248.868000"]}, "213": {"vr": "TM", "Value": ["152248.907000"]}, "214": {"vr": "TM", "Value": ["152248.926000"]}, "215": {"vr": "TM", "Value": ["152248.966000"]}, "216": {"vr": "TM", "Value": ["152249.005000"]}, "217": {"vr": "TM", "Value": ["152249.024000"]}, "218": {"vr": "TM", "Value": ["152249.063000"]}, "219": {"vr": "TM", "Value": ["152249.102000"]}, "220": {"vr": "TM", "Value": ["152249.122000"]}, "221": {"vr": "TM", "Value": ["152249.161000"]}, "222": {"vr": "TM", "Value": ["152249.200000"]}, "223": {"vr": "TM", "Value": ["152249.220000"]}, "224": {"vr": "TM", "Value": ["152249.259000"]}, "225": {"vr": "TM", "Value": ["152249.298000"]}, "226": {"vr": "TM", "Value": ["152249.317000"]}, "227": {"vr": "TM", "Value": ["152249.356000"]}, "228": {"vr": "TM", "Value": ["152249.395000"]}, "229": {"vr": "TM", "Value": ["152249.415000"]}, "230": {"vr": "TM", "Value": ["152249.454000"]}, "231": {"vr": "TM", "Value": ["152249.493000"]}, "232": {"vr": "TM", "Value": ["152249.513000"]}, "233": {"vr": "TM", "Value": ["152249.552000"]}, "234": {"vr": "TM", "Value": ["152249.591000"]}, "235": {"vr": "TM", "Value": ["152249.610000"]}, "236": {"vr": "TM", "Value": ["152249.650000"]}, "237": {"vr": "TM", "Value": ["152249.689000"]}, "238": {"vr": "TM", "Value": ["152249.708000"]}, "239": {"vr": "TM", "Value": ["152249.747000"]}, "240": {"vr": "TM", "Value": ["152249.786000"]}, "241": {"vr": "TM", "Value": ["152249.806000"]}, "242": {"vr": "TM", "Value": ["152249.845000"]}, "243": {"vr": "TM", "Value": ["152249.884000"]}, "244": {"vr": "TM", "Value": ["152249.903000"]}, "245": {"vr": "TM", "Value": ["152249.943000"]}, "246": {"vr": "TM", "Value": ["152249.982000"]}, "247": {"vr": "TM", "Value": ["152250.001000"]}, "248": {"vr": "TM", "Value": ["152250.040000"]}, "249": {"vr": "TM", "Value": ["152250.079000"]}, "250": {"vr": "TM", "Value": ["152250.099000"]}, "251": {"vr": "TM", "Value": ["152250.138000"]}, "252": {"vr": "TM", "Value": ["152250.177000"]}, "253": {"vr": "TM", "Value": ["152250.196000"]}, "254": {"vr": "TM", "Value": ["152250.236000"]}, "255": {"vr": "TM", "Value": ["152250.275000"]}, "256": {"vr": "TM", "Value": ["152250.295000"]}, "257": {"vr": "TM", "Value": ["152250.334000"]}, "258": {"vr": "TM", "Value": ["152250.373000"]}, "259": {"vr": "TM", "Value": ["152250.392000"]}, "260": {"vr": "TM", "Value": ["152250.431000"]}, "261": {"vr": "TM", "Value": ["152250.470000"]}, "262": {"vr": "TM", "Value": ["152250.490000"]}, "263": {"vr": "TM", "Value": ["152250.529000"]}, "264": {"vr": "TM", "Value": ["152250.568000"]}, "265": {"vr": "TM", "Value": ["152250.588000"]}, "266": {"vr": "TM", "Value": ["152250.627000"]}, "267": {"vr": "TM", "Value": ["152250.666000"]}, "268": {"vr": "TM", "Value": ["152250.686000"]}, "269": {"vr": "TM", "Value": ["152250.725000"]}, "270": {"vr": "TM", "Value": ["152250.764000"]}, "271": {"vr": "TM", "Value": ["152250.783000"]}, "272": {"vr": "TM", "Value": ["152250.822000"]}, "273": {"vr": "TM", "Value": ["152250.861000"]}, "274": {"vr": "TM", "Value": ["152250.881000"]}, "275": {"vr": "TM", "Value": ["152250.920000"]}, "276": {"vr": "TM", "Value": ["152250.959000"]}, "277": {"vr": "TM", "Value": ["152250.979000"]}, "278": {"vr": "TM", "Value": ["152251.018000"]}, "279": {"vr": "TM", "Value": ["152251.057000"]}, "280": {"vr": "TM", "Value": ["152251.077000"]}, "281": {"vr": "TM", "Value": ["152251.116000"]}, "282": {"vr": "TM", "Value": ["152251.155000"]}, "283": {"vr": "TM", "Value": ["152251.174000"]}, "284": {"vr": "TM", "Value": ["152251.213000"]}, "285": {"vr": "TM", "Value": ["152251.253000"]}, "286": {"vr": "TM", "Value": ["152251.272000"]}, "287": {"vr": "TM", "Value": ["152251.311000"]}, "288": {"vr": "TM", "Value": ["152251.350000"]}, "289": {"vr": "TM", "Value": ["152251.370000"]}, "290": {"vr": "TM", "Value": ["152251.409000"]}, "291": {"vr": "TM", "Value": ["152251.448000"]}, "292": {"vr": "TM", "Value": ["152251.467000"]}, "293": {"vr": "TM", "Value": ["152251.506000"]}, "294": {"vr": "TM", "Value": ["152251.546000"]}, "295": {"vr": "TM", "Value": ["152251.565000"]}, "296": {"vr": "TM", "Value": ["152251.604000"]}, "297": {"vr": "TM", "Value": ["152251.643000"]}, "298": {"vr": "TM", "Value": ["152251.663000"]}, "299": {"vr": "TM", "Value": ["152251.702000"]}, "300": {"vr": "TM", "Value": ["152251.741000"]}, "301": {"vr": "TM", "Value": ["152251.760000"]}, "302": {"vr": "TM", "Value": ["152251.799000"]}, "303": {"vr": "TM", "Value": ["152251.838000"]}, "304": {"vr": "TM", "Value": ["152251.858000"]}, "305": {"vr": "TM", "Value": ["152251.897000"]}, "306": {"vr": "TM", "Value": ["152251.936000"]}, "307": {"vr": "TM", "Value": ["152251.956000"]}, "308": {"vr": "TM", "Value": ["152251.995000"]}, "309": {"vr": "TM", "Value": ["152252.034000"]}, "310": {"vr": "TM", "Value": ["152252.054000"]}, "311": {"vr": "TM", "Value": ["152252.093000"]}, "312": {"vr": "TM", "Value": ["152252.132000"]}, "313": {"vr": "TM", "Value": ["152252.151000"]}, "314": {"vr": "TM", "Value": ["152252.190000"]}, "315": {"vr": "TM", "Value": ["152252.229000"]}, "316": {"vr": "TM", "Value": ["152252.249000"]}, "317": {"vr": "TM", "Value": ["152252.288000"]}, "318": {"vr": "TM", "Value": ["152252.327000"]}, "319": {"vr": "TM", "Value": ["152252.347000"]}, "320": {"vr": "TM", "Value": ["152252.386000"]}, "321": {"vr": "TM", "Value": ["152252.425000"]}, "322": {"vr": "TM", "Value": ["152252.444000"]}, "323": {"vr": "TM", "Value": ["152252.484000"]}, "324": {"vr": "TM", "Value": ["152252.523000"]}, "325": {"vr": "TM", "Value": ["152252.542000"]}, "326": {"vr": "TM", "Value": ["152252.581000"]}, "327": {"vr": "TM", "Value": ["152252.621000"]}, "328": {"vr": "TM", "Value": ["152252.640000"]}, "329": {"vr": "TM", "Value": ["152252.679000"]}, "330": {"vr": "TM", "Value": ["152252.718000"]}, "331": {"vr": "TM", "Value": ["152252.738000"]}, "332": {"vr": "TM", "Value": ["152252.777000"]}, "333": {"vr": "TM", "Value": ["152252.816000"]}, "334": {"vr": "TM", "Value": ["152252.835000"]}, "335": {"vr": "TM", "Value": ["152252.875000"]}, "336": {"vr": "TM", "Value": ["152252.914000"]}, "337": {"vr": "TM", "Value": ["152252.933000"]}, "338": {"vr": "TM", "Value": ["152252.972000"]}, "339": {"vr": "TM", "Value": ["152253.011000"]}, "340": {"vr": "TM", "Value": ["152253.031000"]}, "341": {"vr": "TM", "Value": ["152253.070000"]}, "342": {"vr": "TM", "Value": ["152253.109000"]}, "343": {"vr": "TM", "Value": ["152253.129000"]}, "344": {"vr": "TM", "Value": ["152253.168000"]}, "345": {"vr": "TM", "Value": ["152253.207000"]}, "346": {"vr": "TM", "Value": ["152253.227000"]}, "347": {"vr": "TM", "Value": ["152253.266000"]}, "348": {"vr": "TM", "Value": ["152253.305000"]}, "349": {"vr": "TM", "Value": ["152253.324000"]}, "350": {"vr": "TM", "Value": ["152253.363000"]}, "351": {"vr": "TM", "Value": ["152253.402000"]}, "352": {"vr": "TM", "Value": ["152253.422000"]}, "353": {"vr": "TM", "Value": ["152253.461000"]}, "354": {"vr": "TM", "Value": ["152253.500000"]}, "355": {"vr": "TM", "Value": ["152253.520000"]}, "356": {"vr": "TM", "Value": ["152253.559000"]}, "357": {"vr": "TM", "Value": ["152253.598000"]}, "358": {"vr": "TM", "Value": ["152253.617000"]}, "359": {"vr": "TM", "Value": ["152253.657000"]}, "360": {"vr": "TM", "Value": ["152253.696000"]}, "361": {"vr": "TM", "Value": ["152253.715000"]}, "362": {"vr": "TM", "Value": ["152253.754000"]}, "363": {"vr": "TM", "Value": ["152253.793000"]}, "364": {"vr": "TM", "Value": ["152253.813000"]}, "365": {"vr": "TM", "Value": ["152253.852000"]}, "366": {"vr": "TM", "Value": ["152253.891000"]}, "367": {"vr": "TM", "Value": ["152253.911000"]}, "368": {"vr": "TM", "Value": ["152253.950000"]}, "369": {"vr": "TM", "Value": ["152253.989000"]}, "370": {"vr": "TM", "Value": ["152254.008000"]}, "371": {"vr": "TM", "Value": ["152254.047000"]}, "372": {"vr": "TM", "Value": ["152254.086000"]}, "373": {"vr": "TM", "Value": ["152254.106000"]}, "374": {"vr": "TM", "Value": ["152254.145000"]}, "375": {"vr": "TM", "Value": ["152254.184000"]}, "376": {"vr": "TM", "Value": ["152254.204000"]}, "377": {"vr": "TM", "Value": ["152254.243000"]}, "378": {"vr": "TM", "Value": ["152254.282000"]}, "379": {"vr": "TM", "Value": ["152254.301000"]}, "380": {"vr": "TM", "Value": ["152254.340000"]}, "381": {"vr": "TM", "Value": ["152254.379000"]}, "382": {"vr": "TM", "Value": ["152254.399000"]}, "383": {"vr": "TM", "Value": ["152254.438000"]}, "384": {"vr": "TM", "Value": ["152254.477000"]}, "385": {"vr": "TM", "Value": ["152254.497000"]}, "386": {"vr": "TM", "Value": ["152254.536000"]}, "387": {"vr": "TM", "Value": ["152254.575000"]}, "388": {"vr": "TM", "Value": ["152254.594000"]}, "389": {"vr": "TM", "Value": ["152254.634000"]}, "390": {"vr": "TM", "Value": ["152254.673000"]}, "391": {"vr": "TM", "Value": ["152254.692000"]}, "392": {"vr": "TM", "Value": ["152254.731000"]}, "393": {"vr": "TM", "Value": ["152254.770000"]}, "394": {"vr": "TM", "Value": ["152254.790000"]}, "395": {"vr": "TM", "Value": ["152254.829000"]}, "396": {"vr": "TM", "Value": ["152254.868000"]}, "397": {"vr": "TM", "Value": ["152254.888000"]}, "398": {"vr": "TM", "Value": ["152254.927000"]}, "399": {"vr": "TM", "Value": ["152254.966000"]}, "400": {"vr": "TM", "Value": ["152254.985000"]}, "401": {"vr": "TM", "Value": ["152255.025000"]}, "402": {"vr": "TM", "Value": ["152255.064000"]}, "403": {"vr": "TM", "Value": ["152255.083000"]}, "404": {"vr": "TM", "Value": ["152255.122000"]}, "405": {"vr": "TM", "Value": ["152255.162000"]}, "406": {"vr": "TM", "Value": ["152255.181000"]}, "407": {"vr": "TM", "Value": ["152255.220000"]}, "408": {"vr": "TM", "Value": ["152255.259000"]}, "409": {"vr": "TM", "Value": ["152255.279000"]}, "410": {"vr": "TM", "Value": ["152255.318000"]}, "411": {"vr": "TM", "Value": ["152255.357000"]}, "412": {"vr": "TM", "Value": ["152255.376000"]}, "413": {"vr": "TM", "Value": ["152255.415000"]}, "414": {"vr": "TM", "Value": ["152255.455000"]}, "415": {"vr": "TM", "Value": ["152255.474000"]}, "416": {"vr": "TM", "Value": ["152255.513000"]}, "417": {"vr": "TM", "Value": ["152255.552000"]}, "418": {"vr": "TM", "Value": ["152255.572000"]}, "419": {"vr": "TM", "Value": ["152255.611000"]}, "420": {"vr": "TM", "Value": ["152255.650000"]}, "421": {"vr": "TM", "Value": ["152255.670000"]}, "422": {"vr": "TM", "Value": ["152255.709000"]}, "423": {"vr": "TM", "Value": ["152255.748000"]}, "424": {"vr": "TM", "Value": ["152255.767000"]}, "425": {"vr": "TM", "Value": ["152255.807000"]}, "426": {"vr": "TM", "Value": ["152255.846000"]}, "427": {"vr": "TM", "Value": ["152255.865000"]}, "428": {"vr": "TM", "Value": ["152255.904000"]}, "429": {"vr": "TM", "Value": ["152255.943000"]}, "430": {"vr": "TM", "Value": ["152255.963000"]}, "431": {"vr": "TM", "Value": ["152256.002000"]}, "432": {"vr": "TM", "Value": ["152256.041000"]}, "433": {"vr": "TM", "Value": ["152256.060000"]}, "434": {"vr": "TM", "Value": ["152256.100000"]}, "435": {"vr": "TM", "Value": ["152256.139000"]}, "436": {"vr": "TM", "Value": ["152256.158000"]}, "437": {"vr": "TM", "Value": ["152256.198000"]}, "438": {"vr": "TM", "Value": ["152256.237000"]}, "439": {"vr": "TM", "Value": ["152256.256000"]}, "440": {"vr": "TM", "Value": ["152256.295000"]}, "441": {"vr": "TM", "Value": ["152256.334000"]}, "442": {"vr": "TM", "Value": ["152256.354000"]}, "443": {"vr": "TM", "Value": ["152256.393000"]}, "444": {"vr": "TM", "Value": ["152256.432000"]}, "445": {"vr": "TM", "Value": ["152256.451000"]}, "446": {"vr": "TM", "Value": ["152256.490000"]}, "447": {"vr": "TM", "Value": ["152256.529000"]}, "448": {"vr": "TM", "Value": ["152256.549000"]}, "449": {"vr": "TM", "Value": ["152256.588000"]}, "450": {"vr": "TM", "Value": ["152256.627000"]}, "451": {"vr": "TM", "Value": ["152256.647000"]}, "452": {"vr": "TM", "Value": ["152256.685000"]}, "453": {"vr": "TM", "Value": ["152256.725000"]}, "454": {"vr": "TM", "Value": ["152256.744000"]}, "455": {"vr": "TM", "Value": ["152256.784000"]}, "456": {"vr": "TM", "Value": ["152256.823000"]}, "457": {"vr": "TM", "Value": ["152256.842000"]}, "458": {"vr": "TM", "Value": ["152256.881000"]}, "459": {"vr": "TM", "Value": ["152256.920000"]}, "460": {"vr": "TM", "Value": ["152256.940000"]}, "461": {"vr": "TM", "Value": ["152256.979000"]}, "462": {"vr": "TM", "Value": ["152257.018000"]}, "463": {"vr": "TM", "Value": ["152257.037000"]}, "464": {"vr": "TM", "Value": ["152257.077000"]}, "465": {"vr": "TM", "Value": ["152257.116000"]}, "466": {"vr": "TM", "Value": ["152257.136000"]}, "467": {"vr": "TM", "Value": ["152257.175000"]}, "468": {"vr": "TM", "Value": ["152257.214000"]}, "469": {"vr": "TM", "Value": ["152257.233000"]}, "470": {"vr": "TM", "Value": ["152257.272000"]}, "471": {"vr": "TM", "Value": ["152257.311000"]}, "472": {"vr": "TM", "Value": ["152257.331000"]}, "473": {"vr": "TM", "Value": ["152257.370000"]}, "474": {"vr": "TM", "Value": ["152257.409000"]}, "475": {"vr": "TM", "Value": ["152257.429000"]}, "476": {"vr": "TM", "Value": ["152257.468000"]}, "477": {"vr": "TM", "Value": ["152257.507000"]}, "478": {"vr": "TM", "Value": ["152257.526000"]}, "479": {"vr": "TM", "Value": ["152257.565000"]}, "480": {"vr": "TM", "Value": ["152257.605000"]}, "481": {"vr": "TM", "Value": ["152257.624000"]}, "482": {"vr": "TM", "Value": ["152257.663000"]}, "483": {"vr": "TM", "Value": ["152257.702000"]}, "484": {"vr": "TM", "Value": ["152257.722000"]}, "485": {"vr": "TM", "Value": ["152257.761000"]}, "486": {"vr": "TM", "Value": ["152257.800000"]}, "487": {"vr": "TM", "Value": ["152257.820000"]}, "488": {"vr": "TM", "Value": ["152257.859000"]}, "489": {"vr": "TM", "Value": ["152257.898000"]}, "490": {"vr": "TM", "Value": ["152257.917000"]}, "491": {"vr": "TM", "Value": ["152257.956000"]}, "492": {"vr": "TM", "Value": ["152257.995000"]}, "493": {"vr": "TM", "Value": ["152258.015000"]}, "494": {"vr": "TM", "Value": ["152258.054000"]}, "495": {"vr": "TM", "Value": ["152258.093000"]}, "496": {"vr": "TM", "Value": ["152258.113000"]}, "497": {"vr": "TM", "Value": ["152258.152000"]}, "498": {"vr": "TM", "Value": ["152258.191000"]}, "499": {"vr": "TM", "Value": ["152258.211000"]}, "500": {"vr": "TM", "Value": ["152258.250000"]}, "501": {"vr": "TM", "Value": ["152258.289000"]}, "502": {"vr": "TM", "Value": ["152258.308000"]}, "503": {"vr": "TM", "Value": ["152258.347000"]}, "504": {"vr": "TM", "Value": ["152258.387000"]}, "505": {"vr": "TM", "Value": ["152258.406000"]}, "506": {"vr": "TM", "Value": ["152258.445000"]}, "507": {"vr": "TM", "Value": ["152258.484000"]}, "508": {"vr": "TM", "Value": ["152258.504000"]}, "509": {"vr": "TM", "Value": ["152258.543000"]}, "510": {"vr": "TM", "Value": ["152258.582000"]}, "511": {"vr": "TM", "Value": ["152258.602000"]}, "512": {"vr": "TM", "Value": ["152258.641000"]}, "513": {"vr": "TM", "Value": ["152258.680000"]}, "514": {"vr": "TM", "Value": ["152258.699000"]}, "515": {"vr": "TM", "Value": ["152258.738000"]}, "516": {"vr": "TM", "Value": ["152258.777000"]}, "517": {"vr": "TM", "Value": ["152258.797000"]}, "518": {"vr": "TM", "Value": ["152258.836000"]}, "519": {"vr": "TM", "Value": ["152258.875000"]}, "520": {"vr": "TM", "Value": ["152258.894000"]}, "521": {"vr": "TM", "Value": ["152258.933000"]}, "522": {"vr": "TM", "Value": ["152258.972000"]}, "523": {"vr": "TM", "Value": ["152258.992000"]}, "524": {"vr": "TM", "Value": ["152259.031000"]}, "525": {"vr": "TM", "Value": ["152259.070000"]}, "526": {"vr": "TM", "Value": ["152259.090000"]}, "527": {"vr": "TM", "Value": ["152259.129000"]}, "528": {"vr": "TM", "Value": ["152259.168000"]}, "529": {"vr": "TM", "Value": ["152259.188000"]}, "530": {"vr": "TM", "Value": ["152259.227000"]}}, "00080033": {"0": {"vr": "TM", "Value": ["152242.146000"]}, "1": {"vr": "TM", "Value": ["152242.146000"]}, "2": {"vr": "TM", "Value": ["152242.146000"]}, "3": {"vr": "TM", "Value": ["152242.146000"]}, "4": {"vr": "TM", "Value": ["152242.146000"]}, "5": {"vr": "TM", "Value": ["152242.146000"]}, "6": {"vr": "TM", "Value": ["152242.164000"]}, "7": {"vr": "TM", "Value": ["152242.184000"]}, "8": {"vr": "TM", "Value": ["152242.223000"]}, "9": {"vr": "TM", "Value": ["152242.262000"]}, "10": {"vr": "TM", "Value": ["152242.281000"]}, "11": {"vr": "TM", "Value": ["152242.320000"]}, "12": {"vr": "TM", "Value": ["152242.359000"]}, "13": {"vr": "TM", "Value": ["152242.379000"]}, "14": {"vr": "TM", "Value": ["152242.418000"]}, "15": {"vr": "TM", "Value": ["152242.457000"]}, "16": {"vr": "TM", "Value": ["152242.476000"]}, "17": {"vr": "TM", "Value": ["152242.516000"]}, "18": {"vr": "TM", "Value": ["152242.555000"]}, "19": {"vr": "TM", "Value": ["152242.574000"]}, "20": {"vr": "TM", "Value": ["152242.613000"]}, "21": {"vr": "TM", "Value": ["152242.652000"]}, "22": {"vr": "TM", "Value": ["152242.672000"]}, "23": {"vr": "TM", "Value": ["152242.711000"]}, "24": {"vr": "TM", "Value": ["152242.750000"]}, "25": {"vr": "TM", "Value": ["152242.770000"]}, "26": {"vr": "TM", "Value": ["152242.809000"]}, "27": {"vr": "TM", "Value": ["152242.848000"]}, "28": {"vr": "TM", "Value": ["152242.867000"]}, "29": {"vr": "TM", "Value": ["152242.906000"]}, "30": {"vr": "TM", "Value": ["152242.945000"]}, "31": {"vr": "TM", "Value": ["152242.965000"]}, "32": {"vr": "TM", "Value": ["152243.004000"]}, "33": {"vr": "TM", "Value": ["152243.043000"]}, "34": {"vr": "TM", "Value": ["152243.063000"]}, "35": {"vr": "TM", "Value": ["152243.102000"]}, "36": {"vr": "TM", "Value": ["152243.141000"]}, "37": {"vr": "TM", "Value": ["152243.161000"]}, "38": {"vr": "TM", "Value": ["152243.200000"]}, "39": {"vr": "TM", "Value": ["152243.239000"]}, "40": {"vr": "TM", "Value": ["152243.258000"]}, "41": {"vr": "TM", "Value": ["152243.297000"]}, "42": {"vr": "TM", "Value": ["152243.336000"]}, "43": {"vr": "TM", "Value": ["152243.356000"]}, "44": {"vr": "TM", "Value": ["152243.395000"]}, "45": {"vr": "TM", "Value": ["152243.434000"]}, "46": {"vr": "TM", "Value": ["152243.454000"]}, "47": {"vr": "TM", "Value": ["152243.493000"]}, "48": {"vr": "TM", "Value": ["152243.532000"]}, "49": {"vr": "TM", "Value": ["152243.551000"]}, "50": {"vr": "TM", "Value": ["152243.590000"]}, "51": {"vr": "TM", "Value": ["152243.630000"]}, "52": {"vr": "TM", "Value": ["152243.649000"]}, "53": {"vr": "TM", "Value": ["152243.688000"]}, "54": {"vr": "TM", "Value": ["152243.727000"]}, "55": {"vr": "TM", "Value": ["152243.747000"]}, "56": {"vr": "TM", "Value": ["152243.786000"]}, "57": {"vr": "TM", "Value": ["152243.825000"]}, "58": {"vr": "TM", "Value": ["152243.845000"]}, "59": {"vr": "TM", "Value": ["152243.884000"]}, "60": {"vr": "TM", "Value": ["152243.923000"]}, "61": {"vr": "TM", "Value": ["152243.943000"]}, "62": {"vr": "TM", "Value": ["152243.981000"]}, "63": {"vr": "TM", "Value": ["152244.020000"]}, "64": {"vr": "TM", "Value": ["152244.040000"]}, "65": {"vr": "TM", "Value": ["152244.079000"]}, "66": {"vr": "TM", "Value": ["152244.119000"]}, "67": {"vr": "TM", "Value": ["152244.138000"]}, "68": {"vr": "TM", "Value": ["152244.177000"]}, "69": {"vr": "TM", "Value": ["152244.216000"]}, "70": {"vr": "TM", "Value": ["152244.236000"]}, "71": {"vr": "TM", "Value": ["152244.275000"]}, "72": {"vr": "TM", "Value": ["152244.314000"]}, "73": {"vr": "TM", "Value": ["152244.333000"]}, "74": {"vr": "TM", "Value": ["152244.372000"]}, "75": {"vr": "TM", "Value": ["152244.412000"]}, "76": {"vr": "TM", "Value": ["152244.431000"]}, "77": {"vr": "TM", "Value": ["152244.470000"]}, "78": {"vr": "TM", "Value": ["152244.509000"]}, "79": {"vr": "TM", "Value": ["152244.529000"]}, "80": {"vr": "TM", "Value": ["152244.568000"]}, "81": {"vr": "TM", "Value": ["152244.607000"]}, "82": {"vr": "TM", "Value": ["152244.627000"]}, "83": {"vr": "TM", "Value": ["152244.666000"]}, "84": {"vr": "TM", "Value": ["152244.705000"]}, "85": {"vr": "TM", "Value": ["152244.724000"]}, "86": {"vr": "TM", "Value": ["152244.763000"]}, "87": {"vr": "TM", "Value": ["152244.802000"]}, "88": {"vr": "TM", "Value": ["152244.822000"]}, "89": {"vr": "TM", "Value": ["152244.861000"]}, "90": {"vr": "TM", "Value": ["152244.900000"]}, "91": {"vr": "TM", "Value": ["152244.919000"]}, "92": {"vr": "TM", "Value": ["152244.958000"]}, "93": {"vr": "TM", "Value": ["152244.997000"]}, "94": {"vr": "TM", "Value": ["152245.017000"]}, "95": {"vr": "TM", "Value": ["152245.056000"]}, "96": {"vr": "TM", "Value": ["152245.095000"]}, "97": {"vr": "TM", "Value": ["152245.115000"]}, "98": {"vr": "TM", "Value": ["152245.154000"]}, "99": {"vr": "TM", "Value": ["152245.193000"]}, "100": {"vr": "TM", "Value": ["152245.213000"]}, "101": {"vr": "TM", "Value": ["152245.252000"]}, "102": {"vr": "TM", "Value": ["152245.291000"]}, "103": {"vr": "TM", "Value": ["152245.310000"]}, "104": {"vr": "TM", "Value": ["152245.349000"]}, "105": {"vr": "TM", "Value": ["152245.389000"]}, "106": {"vr": "TM", "Value": ["152245.408000"]}, "107": {"vr": "TM", "Value": ["152245.447000"]}, "108": {"vr": "TM", "Value": ["152245.486000"]}, "109": {"vr": "TM", "Value": ["152245.506000"]}, "110": {"vr": "TM", "Value": ["152245.545000"]}, "111": {"vr": "TM", "Value": ["152245.584000"]}, "112": {"vr": "TM", "Value": ["152245.603000"]}, "113": {"vr": "TM", "Value": ["152245.643000"]}, "114": {"vr": "TM", "Value": ["152245.682000"]}, "115": {"vr": "TM", "Value": ["152245.701000"]}, "116": {"vr": "TM", "Value": ["152245.740000"]}, "117": {"vr": "TM", "Value": ["152245.780000"]}, "118": {"vr": "TM", "Value": ["152245.799000"]}, "119": {"vr": "TM", "Value": ["152245.838000"]}, "120": {"vr": "TM", "Value": ["152245.877000"]}, "121": {"vr": "TM", "Value": ["152245.897000"]}, "122": {"vr": "TM", "Value": ["152245.936000"]}, "123": {"vr": "TM", "Value": ["152245.975000"]}, "124": {"vr": "TM", "Value": ["152245.995000"]}, "125": {"vr": "TM", "Value": ["152246.034000"]}, "126": {"vr": "TM", "Value": ["152246.073000"]}, "127": {"vr": "TM", "Value": ["152246.092000"]}, "128": {"vr": "TM", "Value": ["152246.131000"]}, "129": {"vr": "TM", "Value": ["152246.171000"]}, "130": {"vr": "TM", "Value": ["152246.190000"]}, "131": {"vr": "TM", "Value": ["152246.229000"]}, "132": {"vr": "TM", "Value": ["152246.268000"]}, "133": {"vr": "TM", "Value": ["152246.288000"]}, "134": {"vr": "TM", "Value": ["152246.327000"]}, "135": {"vr": "TM", "Value": ["152246.366000"]}, "136": {"vr": "TM", "Value": ["152246.386000"]}, "137": {"vr": "TM", "Value": ["152246.425000"]}, "138": {"vr": "TM", "Value": ["152246.464000"]}, "139": {"vr": "TM", "Value": ["152246.483000"]}, "140": {"vr": "TM", "Value": ["152246.522000"]}, "141": {"vr": "TM", "Value": ["152246.562000"]}, "142": {"vr": "TM", "Value": ["152246.581000"]}, "143": {"vr": "TM", "Value": ["152246.620000"]}, "144": {"vr": "TM", "Value": ["152246.659000"]}, "145": {"vr": "TM", "Value": ["152246.679000"]}, "146": {"vr": "TM", "Value": ["152246.718000"]}, "147": {"vr": "TM", "Value": ["152246.757000"]}, "148": {"vr": "TM", "Value": ["152246.776000"]}, "149": {"vr": "TM", "Value": ["152246.816000"]}, "150": {"vr": "TM", "Value": ["152246.855000"]}, "151": {"vr": "TM", "Value": ["152246.874000"]}, "152": {"vr": "TM", "Value": ["152246.913000"]}, "153": {"vr": "TM", "Value": ["152246.952000"]}, "154": {"vr": "TM", "Value": ["152246.972000"]}, "155": {"vr": "TM", "Value": ["152247.011000"]}, "156": {"vr": "TM", "Value": ["152247.050000"]}, "157": {"vr": "TM", "Value": ["152247.070000"]}, "158": {"vr": "TM", "Value": ["152247.109000"]}, "159": {"vr": "TM", "Value": ["152247.148000"]}, "160": {"vr": "TM", "Value": ["152247.167000"]}, "161": {"vr": "TM", "Value": ["152247.206000"]}, "162": {"vr": "TM", "Value": ["152247.245000"]}, "163": {"vr": "TM", "Value": ["152247.265000"]}, "164": {"vr": "TM", "Value": ["152247.304000"]}, "165": {"vr": "TM", "Value": ["152247.343000"]}, "166": {"vr": "TM", "Value": ["152247.363000"]}, "167": {"vr": "TM", "Value": ["152247.402000"]}, "168": {"vr": "TM", "Value": ["152247.441000"]}, "169": {"vr": "TM", "Value": ["152247.460000"]}, "170": {"vr": "TM", "Value": ["152247.499000"]}, "171": {"vr": "TM", "Value": ["152247.539000"]}, "172": {"vr": "TM", "Value": ["152247.558000"]}, "173": {"vr": "TM", "Value": ["152247.597000"]}, "174": {"vr": "TM", "Value": ["152247.636000"]}, "175": {"vr": "TM", "Value": ["152247.656000"]}, "176": {"vr": "TM", "Value": ["152247.695000"]}, "177": {"vr": "TM", "Value": ["152247.734000"]}, "178": {"vr": "TM", "Value": ["152247.754000"]}, "179": {"vr": "TM", "Value": ["152247.793000"]}, "180": {"vr": "TM", "Value": ["152247.832000"]}, "181": {"vr": "TM", "Value": ["152247.851000"]}, "182": {"vr": "TM", "Value": ["152247.890000"]}, "183": {"vr": "TM", "Value": ["152247.929000"]}, "184": {"vr": "TM", "Value": ["152247.949000"]}, "185": {"vr": "TM", "Value": ["152247.988000"]}, "186": {"vr": "TM", "Value": ["152248.028000"]}, "187": {"vr": "TM", "Value": ["152248.047000"]}, "188": {"vr": "TM", "Value": ["152248.086000"]}, "189": {"vr": "TM", "Value": ["152248.125000"]}, "190": {"vr": "TM", "Value": ["152248.145000"]}, "191": {"vr": "TM", "Value": ["152248.184000"]}, "192": {"vr": "TM", "Value": ["152248.223000"]}, "193": {"vr": "TM", "Value": ["152248.242000"]}, "194": {"vr": "TM", "Value": ["152248.281000"]}, "195": {"vr": "TM", "Value": ["152248.321000"]}, "196": {"vr": "TM", "Value": ["152248.340000"]}, "197": {"vr": "TM", "Value": ["152248.379000"]}, "198": {"vr": "TM", "Value": ["152248.418000"]}, "199": {"vr": "TM", "Value": ["152248.438000"]}, "200": {"vr": "TM", "Value": ["152248.477000"]}, "201": {"vr": "TM", "Value": ["152248.516000"]}, "202": {"vr": "TM", "Value": ["152248.535000"]}, "203": {"vr": "TM", "Value": ["152248.575000"]}, "204": {"vr": "TM", "Value": ["152248.614000"]}, "205": {"vr": "TM", "Value": ["152248.633000"]}, "206": {"vr": "TM", "Value": ["152248.673000"]}, "207": {"vr": "TM", "Value": ["152248.712000"]}, "208": {"vr": "TM", "Value": ["152248.731000"]}, "209": {"vr": "TM", "Value": ["152248.770000"]}, "210": {"vr": "TM", "Value": ["152248.809000"]}, "211": {"vr": "TM", "Value": ["152248.829000"]}, "212": {"vr": "TM", "Value": ["152248.868000"]}, "213": {"vr": "TM", "Value": ["152248.907000"]}, "214": {"vr": "TM", "Value": ["152248.926000"]}, "215": {"vr": "TM", "Value": ["152248.966000"]}, "216": {"vr": "TM", "Value": ["152249.005000"]}, "217": {"vr": "TM", "Value": ["152249.024000"]}, "218": {"vr": "TM", "Value": ["152249.063000"]}, "219": {"vr": "TM", "Value": ["152249.102000"]}, "220": {"vr": "TM", "Value": ["152249.122000"]}, "221": {"vr": "TM", "Value": ["152249.161000"]}, "222": {"vr": "TM", "Value": ["152249.200000"]}, "223": {"vr": "TM", "Value": ["152249.220000"]}, "224": {"vr": "TM", "Value": ["152249.259000"]}, "225": {"vr": "TM", "Value": ["152249.298000"]}, "226": {"vr": "TM", "Value": ["152249.317000"]}, "227": {"vr": "TM", "Value": ["152249.356000"]}, "228": {"vr": "TM", "Value": ["152249.395000"]}, "229": {"vr": "TM", "Value": ["152249.415000"]}, "230": {"vr": "TM", "Value": ["152249.454000"]}, "231": {"vr": "TM", "Value": ["152249.493000"]}, "232": {"vr": "TM", "Value": ["152249.513000"]}, "233": {"vr": "TM", "Value": ["152249.552000"]}, "234": {"vr": "TM", "Value": ["152249.591000"]}, "235": {"vr": "TM", "Value": ["152249.610000"]}, "236": {"vr": "TM", "Value": ["152249.650000"]}, "237": {"vr": "TM", "Value": ["152249.689000"]}, "238": {"vr": "TM", "Value": ["152249.708000"]}, "239": {"vr": "TM", "Value": ["152249.747000"]}, "240": {"vr": "TM", "Value": ["152249.786000"]}, "241": {"vr": "TM", "Value": ["152249.806000"]}, "242": {"vr": "TM", "Value": ["152249.845000"]}, "243": {"vr": "TM", "Value": ["152249.884000"]}, "244": {"vr": "TM", "Value": ["152249.903000"]}, "245": {"vr": "TM", "Value": ["152249.943000"]}, "246": {"vr": "TM", "Value": ["152249.982000"]}, "247": {"vr": "TM", "Value": ["152250.001000"]}, "248": {"vr": "TM", "Value": ["152250.040000"]}, "249": {"vr": "TM", "Value": ["152250.079000"]}, "250": {"vr": "TM", "Value": ["152250.099000"]}, "251": {"vr": "TM", "Value": ["152250.138000"]}, "252": {"vr": "TM", "Value": ["152250.177000"]}, "253": {"vr": "TM", "Value": ["152250.196000"]}, "254": {"vr": "TM", "Value": ["152250.236000"]}, "255": {"vr": "TM", "Value": ["152250.275000"]}, "256": {"vr": "TM", "Value": ["152250.295000"]}, "257": {"vr": "TM", "Value": ["152250.334000"]}, "258": {"vr": "TM", "Value": ["152250.373000"]}, "259": {"vr": "TM", "Value": ["152250.392000"]}, "260": {"vr": "TM", "Value": ["152250.431000"]}, "261": {"vr": "TM", "Value": ["152250.470000"]}, "262": {"vr": "TM", "Value": ["152250.490000"]}, "263": {"vr": "TM", "Value": ["152250.529000"]}, "264": {"vr": "TM", "Value": ["152250.568000"]}, "265": {"vr": "TM", "Value": ["152250.588000"]}, "266": {"vr": "TM", "Value": ["152250.627000"]}, "267": {"vr": "TM", "Value": ["152250.666000"]}, "268": {"vr": "TM", "Value": ["152250.686000"]}, "269": {"vr": "TM", "Value": ["152250.725000"]}, "270": {"vr": "TM", "Value": ["152250.764000"]}, "271": {"vr": "TM", "Value": ["152250.783000"]}, "272": {"vr": "TM", "Value": ["152250.822000"]}, "273": {"vr": "TM", "Value": ["152250.861000"]}, "274": {"vr": "TM", "Value": ["152250.881000"]}, "275": {"vr": "TM", "Value": ["152250.920000"]}, "276": {"vr": "TM", "Value": ["152250.959000"]}, "277": {"vr": "TM", "Value": ["152250.979000"]}, "278": {"vr": "TM", "Value": ["152251.018000"]}, "279": {"vr": "TM", "Value": ["152251.057000"]}, "280": {"vr": "TM", "Value": ["152251.077000"]}, "281": {"vr": "TM", "Value": ["152251.116000"]}, "282": {"vr": "TM", "Value": ["152251.155000"]}, "283": {"vr": "TM", "Value": ["152251.174000"]}, "284": {"vr": "TM", "Value": ["152251.213000"]}, "285": {"vr": "TM", "Value": ["152251.253000"]}, "286": {"vr": "TM", "Value": ["152251.272000"]}, "287": {"vr": "TM", "Value": ["152251.311000"]}, "288": {"vr": "TM", "Value": ["152251.350000"]}, "289": {"vr": "TM", "Value": ["152251.370000"]}, "290": {"vr": "TM", "Value": ["152251.409000"]}, "291": {"vr": "TM", "Value": ["152251.448000"]}, "292": {"vr": "TM", "Value": ["152251.467000"]}, "293": {"vr": "TM", "Value": ["152251.506000"]}, "294": {"vr": "TM", "Value": ["152251.546000"]}, "295": {"vr": "TM", "Value": ["152251.565000"]}, "296": {"vr": "TM", "Value": ["152251.604000"]}, "297": {"vr": "TM", "Value": ["152251.643000"]}, "298": {"vr": "TM", "Value": ["152251.663000"]}, "299": {"vr": "TM", "Value": ["152251.702000"]}, "300": {"vr": "TM", "Value": ["152251.741000"]}, "301": {"vr": "TM", "Value": ["152251.760000"]}, "302": {"vr": "TM", "Value": ["152251.799000"]}, "303": {"vr": "TM", "Value": ["152251.838000"]}, "304": {"vr": "TM", "Value": ["152251.858000"]}, "305": {"vr": "TM", "Value": ["152251.897000"]}, "306": {"vr": "TM", "Value": ["152251.936000"]}, "307": {"vr": "TM", "Value": ["152251.956000"]}, "308": {"vr": "TM", "Value": ["152251.995000"]}, "309": {"vr": "TM", "Value": ["152252.034000"]}, "310": {"vr": "TM", "Value": ["152252.054000"]}, "311": {"vr": "TM", "Value": ["152252.093000"]}, "312": {"vr": "TM", "Value": ["152252.132000"]}, "313": {"vr": "TM", "Value": ["152252.151000"]}, "314": {"vr": "TM", "Value": ["152252.190000"]}, "315": {"vr": "TM", "Value": ["152252.229000"]}, "316": {"vr": "TM", "Value": ["152252.249000"]}, "317": {"vr": "TM", "Value": ["152252.288000"]}, "318": {"vr": "TM", "Value": ["152252.327000"]}, "319": {"vr": "TM", "Value": ["152252.347000"]}, "320": {"vr": "TM", "Value": ["152252.386000"]}, "321": {"vr": "TM", "Value": ["152252.425000"]}, "322": {"vr": "TM", "Value": ["152252.444000"]}, "323": {"vr": "TM", "Value": ["152252.484000"]}, "324": {"vr": "TM", "Value": ["152252.523000"]}, "325": {"vr": "TM", "Value": ["152252.542000"]}, "326": {"vr": "TM", "Value": ["152252.581000"]}, "327": {"vr": "TM", "Value": ["152252.621000"]}, "328": {"vr": "TM", "Value": ["152252.640000"]}, "329": {"vr": "TM", "Value": ["152252.679000"]}, "330": {"vr": "TM", "Value": ["152252.718000"]}, "331": {"vr": "TM", "Value": ["152252.738000"]}, "332": {"vr": "TM", "Value": ["152252.777000"]}, "333": {"vr": "TM", "Value": ["152252.816000"]}, "334": {"vr": "TM", "Value": ["152252.835000"]}, "335": {"vr": "TM", "Value": ["152252.875000"]}, "336": {"vr": "TM", "Value": ["152252.914000"]}, "337": {"vr": "TM", "Value": ["152252.933000"]}, "338": {"vr": "TM", "Value": ["152252.972000"]}, "339": {"vr": "TM", "Value": ["152253.011000"]}, "340": {"vr": "TM", "Value": ["152253.031000"]}, "341": {"vr": "TM", "Value": ["152253.070000"]}, "342": {"vr": "TM", "Value": ["152253.109000"]}, "343": {"vr": "TM", "Value": ["152253.129000"]}, "344": {"vr": "TM", "Value": ["152253.168000"]}, "345": {"vr": "TM", "Value": ["152253.207000"]}, "346": {"vr": "TM", "Value": ["152253.227000"]}, "347": {"vr": "TM", "Value": ["152253.266000"]}, "348": {"vr": "TM", "Value": ["152253.305000"]}, "349": {"vr": "TM", "Value": ["152253.324000"]}, "350": {"vr": "TM", "Value": ["152253.363000"]}, "351": {"vr": "TM", "Value": ["152253.402000"]}, "352": {"vr": "TM", "Value": ["152253.422000"]}, "353": {"vr": "TM", "Value": ["152253.461000"]}, "354": {"vr": "TM", "Value": ["152253.500000"]}, "355": {"vr": "TM", "Value": ["152253.520000"]}, "356": {"vr": "TM", "Value": ["152253.559000"]}, "357": {"vr": "TM", "Value": ["152253.598000"]}, "358": {"vr": "TM", "Value": ["152253.617000"]}, "359": {"vr": "TM", "Value": ["152253.657000"]}, "360": {"vr": "TM", "Value": ["152253.696000"]}, "361": {"vr": "TM", "Value": ["152253.715000"]}, "362": {"vr": "TM", "Value": ["152253.754000"]}, "363": {"vr": "TM", "Value": ["152253.793000"]}, "364": {"vr": "TM", "Value": ["152253.813000"]}, "365": {"vr": "TM", "Value": ["152253.852000"]}, "366": {"vr": "TM", "Value": ["152253.891000"]}, "367": {"vr": "TM", "Value": ["152253.911000"]}, "368": {"vr": "TM", "Value": ["152253.950000"]}, "369": {"vr": "TM", "Value": ["152253.989000"]}, "370": {"vr": "TM", "Value": ["152254.008000"]}, "371": {"vr": "TM", "Value": ["152254.047000"]}, "372": {"vr": "TM", "Value": ["152254.086000"]}, "373": {"vr": "TM", "Value": ["152254.106000"]}, "374": {"vr": "TM", "Value": ["152254.145000"]}, "375": {"vr": "TM", "Value": ["152254.184000"]}, "376": {"vr": "TM", "Value": ["152254.204000"]}, "377": {"vr": "TM", "Value": ["152254.243000"]}, "378": {"vr": "TM", "Value": ["152254.282000"]}, "379": {"vr": "TM", "Value": ["152254.301000"]}, "380": {"vr": "TM", "Value": ["152254.340000"]}, "381": {"vr": "TM", "Value": ["152254.379000"]}, "382": {"vr": "TM", "Value": ["152254.399000"]}, "383": {"vr": "TM", "Value": ["152254.438000"]}, "384": {"vr": "TM", "Value": ["152254.477000"]}, "385": {"vr": "TM", "Value": ["152254.497000"]}, "386": {"vr": "TM", "Value": ["152254.536000"]}, "387": {"vr": "TM", "Value": ["152254.575000"]}, "388": {"vr": "TM", "Value": ["152254.594000"]}, "389": {"vr": "TM", "Value": ["152254.634000"]}, "390": {"vr": "TM", "Value": ["152254.673000"]}, "391": {"vr": "TM", "Value": ["152254.692000"]}, "392": {"vr": "TM", "Value": ["152254.731000"]}, "393": {"vr": "TM", "Value": ["152254.770000"]}, "394": {"vr": "TM", "Value": ["152254.790000"]}, "395": {"vr": "TM", "Value": ["152254.829000"]}, "396": {"vr": "TM", "Value": ["152254.868000"]}, "397": {"vr": "TM", "Value": ["152254.888000"]}, "398": {"vr": "TM", "Value": ["152254.927000"]}, "399": {"vr": "TM", "Value": ["152254.966000"]}, "400": {"vr": "TM", "Value": ["152254.985000"]}, "401": {"vr": "TM", "Value": ["152255.025000"]}, "402": {"vr": "TM", "Value": ["152255.064000"]}, "403": {"vr": "TM", "Value": ["152255.083000"]}, "404": {"vr": "TM", "Value": ["152255.122000"]}, "405": {"vr": "TM", "Value": ["152255.162000"]}, "406": {"vr": "TM", "Value": ["152255.181000"]}, "407": {"vr": "TM", "Value": ["152255.220000"]}, "408": {"vr": "TM", "Value": ["152255.259000"]}, "409": {"vr": "TM", "Value": ["152255.279000"]}, "410": {"vr": "TM", "Value": ["152255.318000"]}, "411": {"vr": "TM", "Value": ["152255.357000"]}, "412": {"vr": "TM", "Value": ["152255.376000"]}, "413": {"vr": "TM", "Value": ["152255.415000"]}, "414": {"vr": "TM", "Value": ["152255.455000"]}, "415": {"vr": "TM", "Value": ["152255.474000"]}, "416": {"vr": "TM", "Value": ["152255.513000"]}, "417": {"vr": "TM", "Value": ["152255.552000"]}, "418": {"vr": "TM", "Value": ["152255.572000"]}, "419": {"vr": "TM", "Value": ["152255.611000"]}, "420": {"vr": "TM", "Value": ["152255.650000"]}, "421": {"vr": "TM", "Value": ["152255.670000"]}, "422": {"vr": "TM", "Value": ["152255.709000"]}, "423": {"vr": "TM", "Value": ["152255.748000"]}, "424": {"vr": "TM", "Value": ["152255.767000"]}, "425": {"vr": "TM", "Value": ["152255.807000"]}, "426": {"vr": "TM", "Value": ["152255.846000"]}, "427": {"vr": "TM", "Value": ["152255.865000"]}, "428": {"vr": "TM", "Value": ["152255.904000"]}, "429": {"vr": "TM", "Value": ["152255.943000"]}, "430": {"vr": "TM", "Value": ["152255.963000"]}, "431": {"vr": "TM", "Value": ["152256.002000"]}, "432": {"vr": "TM", "Value": ["152256.041000"]}, "433": {"vr": "TM", "Value": ["152256.060000"]}, "434": {"vr": "TM", "Value": ["152256.100000"]}, "435": {"vr": "TM", "Value": ["152256.139000"]}, "436": {"vr": "TM", "Value": ["152256.158000"]}, "437": {"vr": "TM", "Value": ["152256.198000"]}, "438": {"vr": "TM", "Value": ["152256.237000"]}, "439": {"vr": "TM", "Value": ["152256.256000"]}, "440": {"vr": "TM", "Value": ["152256.295000"]}, "441": {"vr": "TM", "Value": ["152256.334000"]}, "442": {"vr": "TM", "Value": ["152256.354000"]}, "443": {"vr": "TM", "Value": ["152256.393000"]}, "444": {"vr": "TM", "Value": ["152256.432000"]}, "445": {"vr": "TM", "Value": ["152256.451000"]}, "446": {"vr": "TM", "Value": ["152256.490000"]}, "447": {"vr": "TM", "Value": ["152256.529000"]}, "448": {"vr": "TM", "Value": ["152256.549000"]}, "449": {"vr": "TM", "Value": ["152256.588000"]}, "450": {"vr": "TM", "Value": ["152256.627000"]}, "451": {"vr": "TM", "Value": ["152256.647000"]}, "452": {"vr": "TM", "Value": ["152256.685000"]}, "453": {"vr": "TM", "Value": ["152256.725000"]}, "454": {"vr": "TM", "Value": ["152256.744000"]}, "455": {"vr": "TM", "Value": ["152256.784000"]}, "456": {"vr": "TM", "Value": ["152256.823000"]}, "457": {"vr": "TM", "Value": ["152256.842000"]}, "458": {"vr": "TM", "Value": ["152256.881000"]}, "459": {"vr": "TM", "Value": ["152256.920000"]}, "460": {"vr": "TM", "Value": ["152256.940000"]}, "461": {"vr": "TM", "Value": ["152256.979000"]}, "462": {"vr": "TM", "Value": ["152257.018000"]}, "463": {"vr": "TM", "Value": ["152257.037000"]}, "464": {"vr": "TM", "Value": ["152257.077000"]}, "465": {"vr": "TM", "Value": ["152257.116000"]}, "466": {"vr": "TM", "Value": ["152257.136000"]}, "467": {"vr": "TM", "Value": ["152257.175000"]}, "468": {"vr": "TM", "Value": ["152257.214000"]}, "469": {"vr": "TM", "Value": ["152257.233000"]}, "470": {"vr": "TM", "Value": ["152257.272000"]}, "471": {"vr": "TM", "Value": ["152257.311000"]}, "472": {"vr": "TM", "Value": ["152257.331000"]}, "473": {"vr": "TM", "Value": ["152257.370000"]}, "474": {"vr": "TM", "Value": ["152257.409000"]}, "475": {"vr": "TM", "Value": ["152257.429000"]}, "476": {"vr": "TM", "Value": ["152257.468000"]}, "477": {"vr": "TM", "Value": ["152257.507000"]}, "478": {"vr": "TM", "Value": ["152257.526000"]}, "479": {"vr": "TM", "Value": ["152257.565000"]}, "480": {"vr": "TM", "Value": ["152257.605000"]}, "481": {"vr": "TM", "Value": ["152257.624000"]}, "482": {"vr": "TM", "Value": ["152257.663000"]}, "483": {"vr": "TM", "Value": ["152257.702000"]}, "484": {"vr": "TM", "Value": ["152257.722000"]}, "485": {"vr": "TM", "Value": ["152257.761000"]}, "486": {"vr": "TM", "Value": ["152257.800000"]}, "487": {"vr": "TM", "Value": ["152257.820000"]}, "488": {"vr": "TM", "Value": ["152257.859000"]}, "489": {"vr": "TM", "Value": ["152257.898000"]}, "490": {"vr": "TM", "Value": ["152257.917000"]}, "491": {"vr": "TM", "Value": ["152257.956000"]}, "492": {"vr": "TM", "Value": ["152257.995000"]}, "493": {"vr": "TM", "Value": ["152258.015000"]}, "494": {"vr": "TM", "Value": ["152258.054000"]}, "495": {"vr": "TM", "Value": ["152258.093000"]}, "496": {"vr": "TM", "Value": ["152258.113000"]}, "497": {"vr": "TM", "Value": ["152258.152000"]}, "498": {"vr": "TM", "Value": ["152258.191000"]}, "499": {"vr": "TM", "Value": ["152258.211000"]}, "500": {"vr": "TM", "Value": ["152258.250000"]}, "501": {"vr": "TM", "Value": ["152258.289000"]}, "502": {"vr": "TM", "Value": ["152258.308000"]}, "503": {"vr": "TM", "Value": ["152258.347000"]}, "504": {"vr": "TM", "Value": ["152258.387000"]}, "505": {"vr": "TM", "Value": ["152258.406000"]}, "506": {"vr": "TM", "Value": ["152258.445000"]}, "507": {"vr": "TM", "Value": ["152258.484000"]}, "508": {"vr": "TM", "Value": ["152258.504000"]}, "509": {"vr": "TM", "Value": ["152258.543000"]}, "510": {"vr": "TM", "Value": ["152258.582000"]}, "511": {"vr": "TM", "Value": ["152258.602000"]}, "512": {"vr": "TM", "Value": ["152258.641000"]}, "513": {"vr": "TM", "Value": ["152258.680000"]}, "514": {"vr": "TM", "Value": ["152258.699000"]}, "515": {"vr": "TM", "Value": ["152258.738000"]}, "516": {"vr": "TM", "Value": ["152258.777000"]}, "517": {"vr": "TM", "Value": ["152258.797000"]}, "518": {"vr": "TM", "Value": ["152258.836000"]}, "519": {"vr": "TM", "Value": ["152258.875000"]}, "520": {"vr": "TM", "Value": ["152258.894000"]}, "521": {"vr": "TM", "Value": ["152258.933000"]}, "522": {"vr": "TM", "Value": ["152258.972000"]}, "523": {"vr": "TM", "Value": ["152258.992000"]}, "524": {"vr": "TM", "Value": ["152259.031000"]}, "525": {"vr": "TM", "Value": ["152259.070000"]}, "526": {"vr": "TM", "Value": ["152259.090000"]}, "527": {"vr": "TM", "Value": ["152259.129000"]}, "528": {"vr": "TM", "Value": ["152259.168000"]}, "529": {"vr": "TM", "Value": ["152259.188000"]}, "530": {"vr": "TM", "Value": ["152259.227000"]}}, "00181151": {"0": {"vr": "IS", "Value": [19]}, "1": {"vr": "IS", "Value": [19]}, "2": {"vr": "IS", "Value": [19]}, "3": {"vr": "IS", "Value": [19]}, "4": {"vr": "IS", "Value": [19]}, "5": {"vr": "IS", "Value": [19]}, "6": {"vr": "IS", "Value": [19]}, "7": {"vr": "IS", "Value": [19]}, "8": {"vr": "IS", "Value": [19]}, "9": {"vr": "IS", "Value": [19]}, "10": {"vr": "IS", "Value": [19]}, "11": {"vr": "IS", "Value": [19]}, "12": {"vr": "IS", "Value": [19]}, "13": {"vr": "IS", "Value": [19]}, "14": {"vr": "IS", "Value": [19]}, "15": {"vr": "IS", "Value": [19]}, "16": {"vr": "IS", "Value": [19]}, "17": {"vr": "IS", "Value": [19]}, "18": {"vr": "IS", "Value": [19]}, "19": {"vr": "IS", "Value": [20]}, "20": {"vr": "IS", "Value": [20]}, "21": {"vr": "IS", "Value": [20]}, "22": {"vr": "IS", "Value": [20]}, "23": {"vr": "IS", "Value": [20]}, "24": {"vr": "IS", "Value": [20]}, "25": {"vr": "IS", "Value": [20]}, "26": {"vr": "IS", "Value": [20]}, "27": {"vr": "IS", "Value": [20]}, "28": {"vr": "IS", "Value": [20]}, "29": {"vr": "IS", "Value": [20]}, "30": {"vr": "IS", "Value": [20]}, "31": {"vr": "IS", "Value": [20]}, "32": {"vr": "IS", "Value": [20]}, "33": {"vr": "IS", "Value": [20]}, "34": {"vr": "IS", "Value": [20]}, "35": {"vr": "IS", "Value": [20]}, "36": {"vr": "IS", "Value": [20]}, "37": {"vr": "IS", "Value": [20]}, "38": {"vr": "IS", "Value": [20]}, "39": {"vr": "IS", "Value": [20]}, "40": {"vr": "IS", "Value": [20]}, "41": {"vr": "IS", "Value": [20]}, "42": {"vr": "IS", "Value": [20]}, "43": {"vr": "IS", "Value": [20]}, "44": {"vr": "IS", "Value": [20]}, "45": {"vr": "IS", "Value": [20]}, "46": {"vr": "IS", "Value": [20]}, "47": {"vr": "IS", "Value": [20]}, "48": {"vr": "IS", "Value": [20]}, "49": {"vr": "IS", "Value": [20]}, "50": {"vr": "IS", "Value": [20]}, "51": {"vr": "IS", "Value": [20]}, "52": {"vr": "IS", "Value": [20]}, "53": {"vr": "IS", "Value": [20]}, "54": {"vr": "IS", "Value": [20]}, "55": {"vr": "IS", "Value": [20]}, "56": {"vr": "IS", "Value": [21]}, "57": {"vr": "IS", "Value": [22]}, "58": {"vr": "IS", "Value": [23]}, "59": {"vr": "IS", "Value": [24]}, "60": {"vr": "IS", "Value": [25]}, "61": {"vr": "IS", "Value": [26]}, "62": {"vr": "IS", "Value": [27]}, "63": {"vr": "IS", "Value": [28]}, "64": {"vr": "IS", "Value": [29]}, "65": {"vr": "IS", "Value": [30]}, "66": {"vr": "IS", "Value": [31]}, "67": {"vr": "IS", "Value": [32]}, "68": {"vr": "IS", "Value": [33]}, "69": {"vr": "IS", "Value": [33]}, "70": {"vr": "IS", "Value": [34]}, "71": {"vr": "IS", "Value": [34]}, "72": {"vr": "IS", "Value": [35]}, "73": {"vr": "IS", "Value": [35]}, "74": {"vr": "IS", "Value": [35]}, "75": {"vr": "IS", "Value": [35]}, "76": {"vr": "IS", "Value": [35]}, "77": {"vr": "IS", "Value": [35]}, "78": {"vr": "IS", "Value": [36]}, "79": {"vr": "IS", "Value": [36]}, "80": {"vr": "IS", "Value": [36]}, "81": {"vr": "IS", "Value": [36]}, "82": {"vr": "IS", "Value": [36]}, "83": {"vr": "IS", "Value": [37]}, "84": {"vr": "IS", "Value": [37]}, "85": {"vr": "IS", "Value": [37]}, "86": {"vr": "IS", "Value": [37]}, "87": {"vr": "IS", "Value": [37]}, "88": {"vr": "IS", "Value": [37]}, "89": {"vr": "IS", "Value": [37]}, "90": {"vr": "IS", "Value": [37]}, "91": {"vr": "IS", "Value": [37]}, "92": {"vr": "IS", "Value": [36]}, "93": {"vr": "IS", "Value": [36]}, "94": {"vr": "IS", "Value": [36]}, "95": {"vr": "IS", "Value": [36]}, "96": {"vr": "IS", "Value": [35]}, "97": {"vr": "IS", "Value": [35]}, "98": {"vr": "IS", "Value": [35]}, "99": {"vr": "IS", "Value": [35]}, "100": {"vr": "IS", "Value": [35]}, "101": {"vr": "IS", "Value": [35]}, "102": {"vr": "IS", "Value": [34]}, "103": {"vr": "IS", "Value": [34]}, "104": {"vr": "IS", "Value": [34]}, "105": {"vr": "IS", "Value": [33]}, "106": {"vr": "IS", "Value": [33]}, "107": {"vr": "IS", "Value": [33]}, "108": {"vr": "IS", "Value": [33]}, "109": {"vr": "IS", "Value": [33]}, "110": {"vr": "IS", "Value": [33]}, "111": {"vr": "IS", "Value": [33]}, "112": {"vr": "IS", "Value": [33]}, "113": {"vr": "IS", "Value": [33]}, "114": {"vr": "IS", "Value": [33]}, "115": {"vr": "IS", "Value": [34]}, "116": {"vr": "IS", "Value": [34]}, "117": {"vr": "IS", "Value": [34]}, "118": {"vr": "IS", "Value": [35]}, "119": {"vr": "IS", "Value": [35]}, "120": {"vr": "IS", "Value": [35]}, "121": {"vr": "IS", "Value": [36]}, "122": {"vr": "IS", "Value": [36]}, "123": {"vr": "IS", "Value": [36]}, "124": {"vr": "IS", "Value": [37]}, "125": {"vr": "IS", "Value": [37]}, "126": {"vr": "IS", "Value": [37]}, "127": {"vr": "IS", "Value": [37]}, "128": {"vr": "IS", "Value": [37]}, "129": {"vr": "IS", "Value": [37]}, "130": {"vr": "IS", "Value": [37]}, "131": {"vr": "IS", "Value": [37]}, "132": {"vr": "IS", "Value": [37]}, "133": {"vr": "IS", "Value": [37]}, "134": {"vr": "IS", "Value": [37]}, "135": {"vr": "IS", "Value": [37]}, "136": {"vr": "IS", "Value": [37]}, "137": {"vr": "IS", "Value": [37]}, "138": {"vr": "IS", "Value": [37]}, "139": {"vr": "IS", "Value": [37]}, "140": {"vr": "IS", "Value": [37]}, "141": {"vr": "IS", "Value": [37]}, "142": {"vr": "IS", "Value": [37]}, "143": {"vr": "IS", "Value": [37]}, "144": {"vr": "IS", "Value": [37]}, "145": {"vr": "IS", "Value": [37]}, "146": {"vr": "IS", "Value": [37]}, "147": {"vr": "IS", "Value": [37]}, "148": {"vr": "IS", "Value": [37]}, "149": {"vr": "IS", "Value": [37]}, "150": {"vr": "IS", "Value": [37]}, "151": {"vr": "IS", "Value": [37]}, "152": {"vr": "IS", "Value": [37]}, "153": {"vr": "IS", "Value": [38]}, "154": {"vr": "IS", "Value": [38]}, "155": {"vr": "IS", "Value": [38]}, "156": {"vr": "IS", "Value": [38]}, "157": {"vr": "IS", "Value": [38]}, "158": {"vr": "IS", "Value": [38]}, "159": {"vr": "IS", "Value": [38]}, "160": {"vr": "IS", "Value": [38]}, "161": {"vr": "IS", "Value": [38]}, "162": {"vr": "IS", "Value": [38]}, "163": {"vr": "IS", "Value": [37]}, "164": {"vr": "IS", "Value": [37]}, "165": {"vr": "IS", "Value": [37]}, "166": {"vr": "IS", "Value": [37]}, "167": {"vr": "IS", "Value": [37]}, "168": {"vr": "IS", "Value": [37]}, "169": {"vr": "IS", "Value": [37]}, "170": {"vr": "IS", "Value": [37]}, "171": {"vr": "IS", "Value": [37]}, "172": {"vr": "IS", "Value": [37]}, "173": {"vr": "IS", "Value": [37]}, "174": {"vr": "IS", "Value": [37]}, "175": {"vr": "IS", "Value": [37]}, "176": {"vr": "IS", "Value": [37]}, "177": {"vr": "IS", "Value": [37]}, "178": {"vr": "IS", "Value": [37]}, "179": {"vr": "IS", "Value": [37]}, "180": {"vr": "IS", "Value": [37]}, "181": {"vr": "IS", "Value": [37]}, "182": {"vr": "IS", "Value": [37]}, "183": {"vr": "IS", "Value": [37]}, "184": {"vr": "IS", "Value": [37]}, "185": {"vr": "IS", "Value": [37]}, "186": {"vr": "IS", "Value": [37]}, "187": {"vr": "IS", "Value": [37]}, "188": {"vr": "IS", "Value": [37]}, "189": {"vr": "IS", "Value": [37]}, "190": {"vr": "IS", "Value": [37]}, "191": {"vr": "IS", "Value": [37]}, "192": {"vr": "IS", "Value": [37]}, "193": {"vr": "IS", "Value": [37]}, "194": {"vr": "IS", "Value": [37]}, "195": {"vr": "IS", "Value": [37]}, "196": {"vr": "IS", "Value": [37]}, "197": {"vr": "IS", "Value": [37]}, "198": {"vr": "IS", "Value": [37]}, "199": {"vr": "IS", "Value": [37]}, "200": {"vr": "IS", "Value": [37]}, "201": {"vr": "IS", "Value": [37]}, "202": {"vr": "IS", "Value": [37]}, "203": {"vr": "IS", "Value": [37]}, "204": {"vr": "IS", "Value": [37]}, "205": {"vr": "IS", "Value": [37]}, "206": {"vr": "IS", "Value": [37]}, "207": {"vr": "IS", "Value": [37]}, "208": {"vr": "IS", "Value": [37]}, "209": {"vr": "IS", "Value": [37]}, "210": {"vr": "IS", "Value": [37]}, "211": {"vr": "IS", "Value": [37]}, "212": {"vr": "IS", "Value": [37]}, "213": {"vr": "IS", "Value": [37]}, "214": {"vr": "IS", "Value": [37]}, "215": {"vr": "IS", "Value": [38]}, "216": {"vr": "IS", "Value": [38]}, "217": {"vr": "IS", "Value": [39]}, "218": {"vr": "IS", "Value": [41]}, "219": {"vr": "IS", "Value": [42]}, "220": {"vr": "IS", "Value": [45]}, "221": {"vr": "IS", "Value": [48]}, "222": {"vr": "IS", "Value": [50]}, "223": {"vr": "IS", "Value": [53]}, "224": {"vr": "IS", "Value": [57]}, "225": {"vr": "IS", "Value": [59]}, "226": {"vr": "IS", "Value": [62]}, "227": {"vr": "IS", "Value": [66]}, "228": {"vr": "IS", "Value": [67]}, "229": {"vr": "IS", "Value": [71]}, "230": {"vr": "IS", "Value": [74]}, "231": {"vr": "IS", "Value": [75]}, "232": {"vr": "IS", "Value": [77]}, "233": {"vr": "IS", "Value": [79]}, "234": {"vr": "IS", "Value": [79]}, "235": {"vr": "IS", "Value": [79]}, "236": {"vr": "IS", "Value": [78]}, "237": {"vr": "IS", "Value": [77]}, "238": {"vr": "IS", "Value": [76]}, "239": {"vr": "IS", "Value": [74]}, "240": {"vr": "IS", "Value": [72]}, "241": {"vr": "IS", "Value": [69]}, "242": {"vr": "IS", "Value": [65]}, "243": {"vr": "IS", "Value": [62]}, "244": {"vr": "IS", "Value": [58]}, "245": {"vr": "IS", "Value": [53]}, "246": {"vr": "IS", "Value": [51]}, "247": {"vr": "IS", "Value": [46]}, "248": {"vr": "IS", "Value": [42]}, "249": {"vr": "IS", "Value": [40]}, "250": {"vr": "IS", "Value": [36]}, "251": {"vr": "IS", "Value": [32]}, "252": {"vr": "IS", "Value": [30]}, "253": {"vr": "IS", "Value": [27]}, "254": {"vr": "IS", "Value": [24]}, "255": {"vr": "IS", "Value": [22]}, "256": {"vr": "IS", "Value": [21]}, "257": {"vr": "IS", "Value": [19]}, "258": {"vr": "IS", "Value": [19]}, "259": {"vr": "IS", "Value": [19]}, "260": {"vr": "IS", "Value": [19]}, "261": {"vr": "IS", "Value": [19]}, "262": {"vr": "IS", "Value": [19]}, "263": {"vr": "IS", "Value": [18]}, "264": {"vr": "IS", "Value": [18]}, "265": {"vr": "IS", "Value": [18]}, "266": {"vr": "IS", "Value": [18]}, "267": {"vr": "IS", "Value": [18]}, "268": {"vr": "IS", "Value": [18]}, "269": {"vr": "IS", "Value": [18]}, "270": {"vr": "IS", "Value": [18]}, "271": {"vr": "IS", "Value": [18]}, "272": {"vr": "IS", "Value": [18]}, "273": {"vr": "IS", "Value": [18]}, "274": {"vr": "IS", "Value": [18]}, "275": {"vr": "IS", "Value": [17]}, "276": {"vr": "IS", "Value": [17]}, "277": {"vr": "IS", "Value": [17]}, "278": {"vr": "IS", "Value": [17]}, "279": {"vr": "IS", "Value": [17]}, "280": {"vr": "IS", "Value": [17]}, "281": {"vr": "IS", "Value": [18]}, "282": {"vr": "IS", "Value": [18]}, "283": {"vr": "IS", "Value": [17]}, "284": {"vr": "IS", "Value": [17]}, "285": {"vr": "IS", "Value": [17]}, "286": {"vr": "IS", "Value": [17]}, "287": {"vr": "IS", "Value": [17]}, "288": {"vr": "IS", "Value": [17]}, "289": {"vr": "IS", "Value": [17]}, "290": {"vr": "IS", "Value": [17]}, "291": {"vr": "IS", "Value": [17]}, "292": {"vr": "IS", "Value": [17]}, "293": {"vr": "IS", "Value": [17]}, "294": {"vr": "IS", "Value": [17]}, "295": {"vr": "IS", "Value": [17]}, "296": {"vr": "IS", "Value": [17]}, "297": {"vr": "IS", "Value": [17]}, "298": {"vr": "IS", "Value": [17]}, "299": {"vr": "IS", "Value": [17]}, "300": {"vr": "IS", "Value": [17]}, "301": {"vr": "IS", "Value": [17]}, "302": {"vr": "IS", "Value": [17]}, "303": {"vr": "IS", "Value": [17]}, "304": {"vr": "IS", "Value": [17]}, "305": {"vr": "IS", "Value": [17]}, "306": {"vr": "IS", "Value": [18]}, "307": {"vr": "IS", "Value": [18]}, "308": {"vr": "IS", "Value": [17]}, "309": {"vr": "IS", "Value": [17]}, "310": {"vr": "IS", "Value": [17]}, "311": {"vr": "IS", "Value": [17]}, "312": {"vr": "IS", "Value": [17]}, "313": {"vr": "IS", "Value": [17]}, "314": {"vr": "IS", "Value": [17]}, "315": {"vr": "IS", "Value": [17]}, "316": {"vr": "IS", "Value": [17]}, "317": {"vr": "IS", "Value": [17]}, "318": {"vr": "IS", "Value": [17]}, "319": {"vr": "IS", "Value": [17]}, "320": {"vr": "IS", "Value": [17]}, "321": {"vr": "IS", "Value": [17]}, "322": {"vr": "IS", "Value": [17]}, "323": {"vr": "IS", "Value": [17]}, "324": {"vr": "IS", "Value": [17]}, "325": {"vr": "IS", "Value": [17]}, "326": {"vr": "IS", "Value": [17]}, "327": {"vr": "IS", "Value": [17]}, "328": {"vr": "IS", "Value": [17]}, "329": {"vr": "IS", "Value": [17]}, "330": {"vr": "IS", "Value": [17]}, "331": {"vr": "IS", "Value": [17]}, "332": {"vr": "IS", "Value": [17]}, "333": {"vr": "IS", "Value": [17]}, "334": {"vr": "IS", "Value": [17]}, "335": {"vr": "IS", "Value": [17]}, "336": {"vr": "IS", "Value": [17]}, "337": {"vr": "IS", "Value": [18]}, "338": {"vr": "IS", "Value": [18]}, "339": {"vr": "IS", "Value": [18]}, "340": {"vr": "IS", "Value": [18]}, "341": {"vr": "IS", "Value": [18]}, "342": {"vr": "IS", "Value": [18]}, "343": {"vr": "IS", "Value": [18]}, "344": {"vr": "IS", "Value": [18]}, "345": {"vr": "IS", "Value": [18]}, "346": {"vr": "IS", "Value": [18]}, "347": {"vr": "IS", "Value": [18]}, "348": {"vr": "IS", "Value": [18]}, "349": {"vr": "IS", "Value": [18]}, "350": {"vr": "IS", "Value": [18]}, "351": {"vr": "IS", "Value": [18]}, "352": {"vr": "IS", "Value": [18]}, "353": {"vr": "IS", "Value": [18]}, "354": {"vr": "IS", "Value": [18]}, "355": {"vr": "IS", "Value": [18]}, "356": {"vr": "IS", "Value": [18]}, "357": {"vr": "IS", "Value": [18]}, "358": {"vr": "IS", "Value": [18]}, "359": {"vr": "IS", "Value": [18]}, "360": {"vr": "IS", "Value": [18]}, "361": {"vr": "IS", "Value": [18]}, "362": {"vr": "IS", "Value": [18]}, "363": {"vr": "IS", "Value": [18]}, "364": {"vr": "IS", "Value": [18]}, "365": {"vr": "IS", "Value": [18]}, "366": {"vr": "IS", "Value": [18]}, "367": {"vr": "IS", "Value": [18]}, "368": {"vr": "IS", "Value": [18]}, "369": {"vr": "IS", "Value": [18]}, "370": {"vr": "IS", "Value": [18]}, "371": {"vr": "IS", "Value": [18]}, "372": {"vr": "IS", "Value": [18]}, "373": {"vr": "IS", "Value": [18]}, "374": {"vr": "IS", "Value": [18]}, "375": {"vr": "IS", "Value": [18]}, "376": {"vr": "IS", "Value": [18]}, "377": {"vr": "IS", "Value": [18]}, "378": {"vr": "IS", "Value": [18]}, "379": {"vr": "IS", "Value": [18]}, "380": {"vr": "IS", "Value": [18]}, "381": {"vr": "IS", "Value": [18]}, "382": {"vr": "IS", "Value": [18]}, "383": {"vr": "IS", "Value": [18]}, "384": {"vr": "IS", "Value": [18]}, "385": {"vr": "IS", "Value": [18]}, "386": {"vr": "IS", "Value": [18]}, "387": {"vr": "IS", "Value": [18]}, "388": {"vr": "IS", "Value": [18]}, "389": {"vr": "IS", "Value": [18]}, "390": {"vr": "IS", "Value": [18]}, "391": {"vr": "IS", "Value": [18]}, "392": {"vr": "IS", "Value": [18]}, "393": {"vr": "IS", "Value": [18]}, "394": {"vr": "IS", "Value": [18]}, "395": {"vr": "IS", "Value": [18]}, "396": {"vr": "IS", "Value": [18]}, "397": {"vr": "IS", "Value": [18]}, "398": {"vr": "IS", "Value": [18]}, "399": {"vr": "IS", "Value": [18]}, "400": {"vr": "IS", "Value": [18]}, "401": {"vr": "IS", "Value": [18]}, "402": {"vr": "IS", "Value": [18]}, "403": {"vr": "IS", "Value": [18]}, "404": {"vr": "IS", "Value": [18]}, "405": {"vr": "IS", "Value": [18]}, "406": {"vr": "IS", "Value": [18]}, "407": {"vr": "IS", "Value": [18]}, "408": {"vr": "IS", "Value": [18]}, "409": {"vr": "IS", "Value": [18]}, "410": {"vr": "IS", "Value": [18]}, "411": {"vr": "IS", "Value": [18]}, "412": {"vr": "IS", "Value": [18]}, "413": {"vr": "IS", "Value": [18]}, "414": {"vr": "IS", "Value": [18]}, "415": {"vr": "IS", "Value": [18]}, "416": {"vr": "IS", "Value": [18]}, "417": {"vr": "IS", "Value": [18]}, "418": {"vr": "IS", "Value": [18]}, "419": {"vr": "IS", "Value": [18]}, "420": {"vr": "IS", "Value": [18]}, "421": {"vr": "IS", "Value": [18]}, "422": {"vr": "IS", "Value": [18]}, "423": {"vr": "IS", "Value": [18]}, "424": {"vr": "IS", "Value": [18]}, "425": {"vr": "IS", "Value": [18]}, "426": {"vr": "IS", "Value": [18]}, "427": {"vr": "IS", "Value": [18]}, "428": {"vr": "IS", "Value": [18]}, "429": {"vr": "IS", "Value": [18]}, "430": {"vr": "IS", "Value": [18]}, "431": {"vr": "IS", "Value": [18]}, "432": {"vr": "IS", "Value": [18]}, "433": {"vr": "IS", "Value": [18]}, "434": {"vr": "IS", "Value": [18]}, "435": {"vr": "IS", "Value": [18]}, "436": {"vr": "IS", "Value": [18]}, "437": {"vr": "IS", "Value": [18]}, "438": {"vr": "IS", "Value": [18]}, "439": {"vr": "IS", "Value": [18]}, "440": {"vr": "IS", "Value": [18]}, "441": {"vr": "IS", "Value": [18]}, "442": {"vr": "IS", "Value": [18]}, "443": {"vr": "IS", "Value": [18]}, "444": {"vr": "IS", "Value": [18]}, "445": {"vr": "IS", "Value": [18]}, "446": {"vr": "IS", "Value": [18]}, "447": {"vr": "IS", "Value": [18]}, "448": {"vr": "IS", "Value": [18]}, "449": {"vr": "IS", "Value": [18]}, "450": {"vr": "IS", "Value": [18]}, "451": {"vr": "IS", "Value": [18]}, "452": {"vr": "IS", "Value": [18]}, "453": {"vr": "IS", "Value": [18]}, "454": {"vr": "IS", "Value": [18]}, "455": {"vr": "IS", "Value": [18]}, "456": {"vr": "IS", "Value": [18]}, "457": {"vr": "IS", "Value": [18]}, "458": {"vr": "IS", "Value": [18]}, "459": {"vr": "IS", "Value": [18]}, "460": {"vr": "IS", "Value": [18]}, "461": {"vr": "IS", "Value": [18]}, "462": {"vr": "IS", "Value": [18]}, "463": {"vr": "IS", "Value": [18]}, "464": {"vr": "IS", "Value": [18]}, "465": {"vr": "IS", "Value": [18]}, "466": {"vr": "IS", "Value": [18]}, "467": {"vr": "IS", "Value": [18]}, "468": {"vr": "IS", "Value": [18]}, "469": {"vr": "IS", "Value": [18]}, "470": {"vr": "IS", "Value": [18]}, "471": {"vr": "IS", "Value": [18]}, "472": {"vr": "IS", "Value": [18]}, "473": {"vr": "IS", "Value": [18]}, "474": {"vr": "IS", "Value": [18]}, "475": {"vr": "IS", "Value": [18]}, "476": {"vr": "IS", "Value": [18]}, "477": {"vr": "IS", "Value": [18]}, "478": {"vr": "IS", "Value": [18]}, "479": {"vr": "IS", "Value": [18]}, "480": {"vr": "IS", "Value": [18]}, "481": {"vr": "IS", "Value": [18]}, "482": {"vr": "IS", "Value": [18]}, "483": {"vr": "IS", "Value": [18]}, "484": {"vr": "IS", "Value": [18]}, "485": {"vr": "IS", "Value": [18]}, "486": {"vr": "IS", "Value": [18]}, "487": {"vr": "IS", "Value": [18]}, "488": {"vr": "IS", "Value": [18]}, "489": {"vr": "IS", "Value": [18]}, "490": {"vr": "IS", "Value": [18]}, "491": {"vr": "IS", "Value": [18]}, "492": {"vr": "IS", "Value": [18]}, "493": {"vr": "IS", "Value": [18]}, "494": {"vr": "IS", "Value": [18]}, "495": {"vr": "IS", "Value": [18]}, "496": {"vr": "IS", "Value": [18]}, "497": {"vr": "IS", "Value": [18]}, "498": {"vr": "IS", "Value": [18]}, "499": {"vr": "IS", "Value": [18]}, "500": {"vr": "IS", "Value": [18]}, "501": {"vr": "IS", "Value": [18]}, "502": {"vr": "IS", "Value": [18]}, "503": {"vr": "IS", "Value": [18]}, "504": {"vr": "IS", "Value": [18]}, "505": {"vr": "IS", "Value": [18]}, "506": {"vr": "IS", "Value": [18]}, "507": {"vr": "IS", "Value": [18]}, "508": {"vr": "IS", "Value": [18]}, "509": {"vr": "IS", "Value": [18]}, "510": {"vr": "IS", "Value": [18]}, "511": {"vr": "IS", "Value": [18]}, "512": {"vr": "IS", "Value": [18]}, "513": {"vr": "IS", "Value": [18]}, "514": {"vr": "IS", "Value": [18]}, "515": {"vr": "IS", "Value": [18]}, "516": {"vr": "IS", "Value": [18]}, "517": {"vr": "IS", "Value": [18]}, "518": {"vr": "IS", "Value": [18]}, "519": {"vr": "IS", "Value": [18]}, "520": {"vr": "IS", "Value": [18]}, "521": {"vr": "IS", "Value": [18]}, "522": {"vr": "IS", "Value": [18]}, "523": {"vr": "IS", "Value": [18]}, "524": {"vr": "IS", "Value": [18]}, "525": {"vr": "IS", "Value": [18]}, "526": {"vr": "IS", "Value": [18]}, "527": {"vr": "IS", "Value": [18]}, "528": {"vr": "IS", "Value": [18]}, "529": {"vr": "IS", "Value": [18]}, "530": {"vr": "IS", "Value": [18]}}, "00181152": {"0": {"vr": "IS", "Value": [11]}, "1": {"vr": "IS", "Value": [11]}, "2": {"vr": "IS", "Value": [11]}, "3": {"vr": "IS", "Value": [11]}, "4": {"vr": "IS", "Value": [11]}, "5": {"vr": "IS", "Value": [11]}, "6": {"vr": "IS", "Value": [11]}, "7": {"vr": "IS", "Value": [11]}, "8": {"vr": "IS", "Value": [11]}, "9": {"vr": "IS", "Value": [11]}, "10": {"vr": "IS", "Value": [11]}, "11": {"vr": "IS", "Value": [11]}, "12": {"vr": "IS", "Value": [11]}, "13": {"vr": "IS", "Value": [11]}, "14": {"vr": "IS", "Value": [11]}, "15": {"vr": "IS", "Value": [11]}, "16": {"vr": "IS", "Value": [11]}, "17": {"vr": "IS", "Value": [11]}, "18": {"vr": "IS", "Value": [11]}, "19": {"vr": "IS", "Value": [12]}, "20": {"vr": "IS", "Value": [12]}, "21": {"vr": "IS", "Value": [12]}, "22": {"vr": "IS", "Value": [12]}, "23": {"vr": "IS", "Value": [12]}, "24": {"vr": "IS", "Value": [12]}, "25": {"vr": "IS", "Value": [12]}, "26": {"vr": "IS", "Value": [12]}, "27": {"vr": "IS", "Value": [12]}, "28": {"vr": "IS", "Value": [12]}, "29": {"vr": "IS", "Value": [12]}, "30": {"vr": "IS", "Value": [12]}, "31": {"vr": "IS", "Value": [12]}, "32": {"vr": "IS", "Value": [12]}, "33": {"vr": "IS", "Value": [12]}, "34": {"vr": "IS", "Value": [12]}, "35": {"vr": "IS", "Value": [12]}, "36": {"vr": "IS", "Value": [12]}, "37": {"vr": "IS", "Value": [12]}, "38": {"vr": "IS", "Value": [12]}, "39": {"vr": "IS", "Value": [12]}, "40": {"vr": "IS", "Value": [12]}, "41": {"vr": "IS", "Value": [12]}, "42": {"vr": "IS", "Value": [12]}, "43": {"vr": "IS", "Value": [12]}, "44": {"vr": "IS", "Value": [12]}, "45": {"vr": "IS", "Value": [12]}, "46": {"vr": "IS", "Value": [12]}, "47": {"vr": "IS", "Value": [12]}, "48": {"vr": "IS", "Value": [12]}, "49": {"vr": "IS", "Value": [12]}, "50": {"vr": "IS", "Value": [12]}, "51": {"vr": "IS", "Value": [12]}, "52": {"vr": "IS", "Value": [12]}, "53": {"vr": "IS", "Value": [12]}, "54": {"vr": "IS", "Value": [12]}, "55": {"vr": "IS", "Value": [12]}, "56": {"vr": "IS", "Value": [13]}, "57": {"vr": "IS", "Value": [13]}, "58": {"vr": "IS", "Value": [14]}, "59": {"vr": "IS", "Value": [15]}, "60": {"vr": "IS", "Value": [15]}, "61": {"vr": "IS", "Value": [16]}, "62": {"vr": "IS", "Value": [16]}, "63": {"vr": "IS", "Value": [17]}, "64": {"vr": "IS", "Value": [18]}, "65": {"vr": "IS", "Value": [18]}, "66": {"vr": "IS", "Value": [19]}, "67": {"vr": "IS", "Value": [20]}, "68": {"vr": "IS", "Value": [20]}, "69": {"vr": "IS", "Value": [20]}, "70": {"vr": "IS", "Value": [21]}, "71": {"vr": "IS", "Value": [21]}, "72": {"vr": "IS", "Value": [21]}, "73": {"vr": "IS", "Value": [21]}, "74": {"vr": "IS", "Value": [21]}, "75": {"vr": "IS", "Value": [21]}, "76": {"vr": "IS", "Value": [21]}, "77": {"vr": "IS", "Value": [21]}, "78": {"vr": "IS", "Value": [22]}, "79": {"vr": "IS", "Value": [22]}, "80": {"vr": "IS", "Value": [22]}, "81": {"vr": "IS", "Value": [22]}, "82": {"vr": "IS", "Value": [22]}, "83": {"vr": "IS", "Value": [23]}, "84": {"vr": "IS", "Value": [23]}, "85": {"vr": "IS", "Value": [23]}, "86": {"vr": "IS", "Value": [23]}, "87": {"vr": "IS", "Value": [23]}, "88": {"vr": "IS", "Value": [23]}, "89": {"vr": "IS", "Value": [23]}, "90": {"vr": "IS", "Value": [23]}, "91": {"vr": "IS", "Value": [23]}, "92": {"vr": "IS", "Value": [22]}, "93": {"vr": "IS", "Value": [22]}, "94": {"vr": "IS", "Value": [22]}, "95": {"vr": "IS", "Value": [22]}, "96": {"vr": "IS", "Value": [21]}, "97": {"vr": "IS", "Value": [21]}, "98": {"vr": "IS", "Value": [21]}, "99": {"vr": "IS", "Value": [21]}, "100": {"vr": "IS", "Value": [21]}, "101": {"vr": "IS", "Value": [21]}, "102": {"vr": "IS", "Value": [21]}, "103": {"vr": "IS", "Value": [21]}, "104": {"vr": "IS", "Value": [21]}, "105": {"vr": "IS", "Value": [20]}, "106": {"vr": "IS", "Value": [20]}, "107": {"vr": "IS", "Value": [20]}, "108": {"vr": "IS", "Value": [20]}, "109": {"vr": "IS", "Value": [20]}, "110": {"vr": "IS", "Value": [20]}, "111": {"vr": "IS", "Value": [20]}, "112": {"vr": "IS", "Value": [20]}, "113": {"vr": "IS", "Value": [20]}, "114": {"vr": "IS", "Value": [20]}, "115": {"vr": "IS", "Value": [21]}, "116": {"vr": "IS", "Value": [21]}, "117": {"vr": "IS", "Value": [21]}, "118": {"vr": "IS", "Value": [21]}, "119": {"vr": "IS", "Value": [21]}, "120": {"vr": "IS", "Value": [21]}, "121": {"vr": "IS", "Value": [22]}, "122": {"vr": "IS", "Value": [22]}, "123": {"vr": "IS", "Value": [22]}, "124": {"vr": "IS", "Value": [23]}, "125": {"vr": "IS", "Value": [23]}, "126": {"vr": "IS", "Value": [23]}, "127": {"vr": "IS", "Value": [23]}, "128": {"vr": "IS", "Value": [23]}, "129": {"vr": "IS", "Value": [23]}, "130": {"vr": "IS", "Value": [23]}, "131": {"vr": "IS", "Value": [23]}, "132": {"vr": "IS", "Value": [23]}, "133": {"vr": "IS", "Value": [23]}, "134": {"vr": "IS", "Value": [23]}, "135": {"vr": "IS", "Value": [23]}, "136": {"vr": "IS", "Value": [23]}, "137": {"vr": "IS", "Value": [23]}, "138": {"vr": "IS", "Value": [23]}, "139": {"vr": "IS", "Value": [23]}, "140": {"vr": "IS", "Value": [23]}, "141": {"vr": "IS", "Value": [23]}, "142": {"vr": "IS", "Value": [23]}, "143": {"vr": "IS", "Value": [23]}, "144": {"vr": "IS", "Value": [23]}, "145": {"vr": "IS", "Value": [23]}, "146": {"vr": "IS", "Value": [23]}, "147": {"vr": "IS", "Value": [23]}, "148": {"vr": "IS", "Value": [23]}, "149": {"vr": "IS", "Value": [23]}, "150": {"vr": "IS", "Value": [23]}, "151": {"vr": "IS", "Value": [23]}, "152": {"vr": "IS", "Value": [23]}, "153": {"vr": "IS", "Value": [23]}, "154": {"vr": "IS", "Value": [23]}, "155": {"vr": "IS", "Value": [23]}, "156": {"vr": "IS", "Value": [23]}, "157": {"vr": "IS", "Value": [23]}, "158": {"vr": "IS", "Value": [23]}, "159": {"vr": "IS", "Value": [23]}, "160": {"vr": "IS", "Value": [23]}, "161": {"vr": "IS", "Value": [23]}, "162": {"vr": "IS", "Value": [23]}, "163": {"vr": "IS", "Value": [23]}, "164": {"vr": "IS", "Value": [23]}, "165": {"vr": "IS", "Value": [23]}, "166": {"vr": "IS", "Value": [23]}, "167": {"vr": "IS", "Value": [23]}, "168": {"vr": "IS", "Value": [23]}, "169": {"vr": "IS", "Value": [23]}, "170": {"vr": "IS", "Value": [23]}, "171": {"vr": "IS", "Value": [23]}, "172": {"vr": "IS", "Value": [23]}, "173": {"vr": "IS", "Value": [23]}, "174": {"vr": "IS", "Value": [23]}, "175": {"vr": "IS", "Value": [23]}, "176": {"vr": "IS", "Value": [23]}, "177": {"vr": "IS", "Value": [23]}, "178": {"vr": "IS", "Value": [23]}, "179": {"vr": "IS", "Value": [23]}, "180": {"vr": "IS", "Value": [23]}, "181": {"vr": "IS", "Value": [23]}, "182": {"vr": "IS", "Value": [23]}, "183": {"vr": "IS", "Value": [23]}, "184": {"vr": "IS", "Value": [23]}, "185": {"vr": "IS", "Value": [23]}, "186": {"vr": "IS", "Value": [23]}, "187": {"vr": "IS", "Value": [23]}, "188": {"vr": "IS", "Value": [23]}, "189": {"vr": "IS", "Value": [23]}, "190": {"vr": "IS", "Value": [23]}, "191": {"vr": "IS", "Value": [23]}, "192": {"vr": "IS", "Value": [23]}, "193": {"vr": "IS", "Value": [23]}, "194": {"vr": "IS", "Value": [23]}, "195": {"vr": "IS", "Value": [23]}, "196": {"vr": "IS", "Value": [23]}, "197": {"vr": "IS", "Value": [23]}, "198": {"vr": "IS", "Value": [23]}, "199": {"vr": "IS", "Value": [23]}, "200": {"vr": "IS", "Value": [23]}, "201": {"vr": "IS", "Value": [23]}, "202": {"vr": "IS", "Value": [23]}, "203": {"vr": "IS", "Value": [23]}, "204": {"vr": "IS", "Value": [23]}, "205": {"vr": "IS", "Value": [23]}, "206": {"vr": "IS", "Value": [23]}, "207": {"vr": "IS", "Value": [23]}, "208": {"vr": "IS", "Value": [23]}, "209": {"vr": "IS", "Value": [23]}, "210": {"vr": "IS", "Value": [23]}, "211": {"vr": "IS", "Value": [23]}, "212": {"vr": "IS", "Value": [23]}, "213": {"vr": "IS", "Value": [23]}, "214": {"vr": "IS", "Value": [23]}, "215": {"vr": "IS", "Value": [23]}, "216": {"vr": "IS", "Value": [23]}, "217": {"vr": "IS", "Value": [24]}, "218": {"vr": "IS", "Value": [25]}, "219": {"vr": "IS", "Value": [26]}, "220": {"vr": "IS", "Value": [28]}, "221": {"vr": "IS", "Value": [30]}, "222": {"vr": "IS", "Value": [31]}, "223": {"vr": "IS", "Value": [33]}, "224": {"vr": "IS", "Value": [35]}, "225": {"vr": "IS", "Value": [36]}, "226": {"vr": "IS", "Value": [38]}, "227": {"vr": "IS", "Value": [41]}, "228": {"vr": "IS", "Value": [41]}, "229": {"vr": "IS", "Value": [44]}, "230": {"vr": "IS", "Value": [46]}, "231": {"vr": "IS", "Value": [46]}, "232": {"vr": "IS", "Value": [48]}, "233": {"vr": "IS", "Value": [49]}, "234": {"vr": "IS", "Value": [49]}, "235": {"vr": "IS", "Value": [49]}, "236": {"vr": "IS", "Value": [48]}, "237": {"vr": "IS", "Value": [48]}, "238": {"vr": "IS", "Value": [47]}, "239": {"vr": "IS", "Value": [46]}, "240": {"vr": "IS", "Value": [45]}, "241": {"vr": "IS", "Value": [43]}, "242": {"vr": "IS", "Value": [40]}, "243": {"vr": "IS", "Value": [38]}, "244": {"vr": "IS", "Value": [36]}, "245": {"vr": "IS", "Value": [33]}, "246": {"vr": "IS", "Value": [31]}, "247": {"vr": "IS", "Value": [28]}, "248": {"vr": "IS", "Value": [26]}, "249": {"vr": "IS", "Value": [25]}, "250": {"vr": "IS", "Value": [22]}, "251": {"vr": "IS", "Value": [20]}, "252": {"vr": "IS", "Value": [18]}, "253": {"vr": "IS", "Value": [16]}, "254": {"vr": "IS", "Value": [15]}, "255": {"vr": "IS", "Value": [13]}, "256": {"vr": "IS", "Value": [13]}, "257": {"vr": "IS", "Value": [11]}, "258": {"vr": "IS", "Value": [11]}, "259": {"vr": "IS", "Value": [11]}, "260": {"vr": "IS", "Value": [11]}, "261": {"vr": "IS", "Value": [11]}, "262": {"vr": "IS", "Value": [11]}, "263": {"vr": "IS", "Value": [11]}, "264": {"vr": "IS", "Value": [11]}, "265": {"vr": "IS", "Value": [11]}, "266": {"vr": "IS", "Value": [11]}, "267": {"vr": "IS", "Value": [11]}, "268": {"vr": "IS", "Value": [11]}, "269": {"vr": "IS", "Value": [11]}, "270": {"vr": "IS", "Value": [11]}, "271": {"vr": "IS", "Value": [11]}, "272": {"vr": "IS", "Value": [11]}, "273": {"vr": "IS", "Value": [11]}, "274": {"vr": "IS", "Value": [11]}, "275": {"vr": "IS", "Value": [10]}, "276": {"vr": "IS", "Value": [10]}, "277": {"vr": "IS", "Value": [10]}, "278": {"vr": "IS", "Value": [10]}, "279": {"vr": "IS", "Value": [10]}, "280": {"vr": "IS", "Value": [10]}, "281": {"vr": "IS", "Value": [11]}, "282": {"vr": "IS", "Value": [11]}, "283": {"vr": "IS", "Value": [10]}, "284": {"vr": "IS", "Value": [10]}, "285": {"vr": "IS", "Value": [10]}, "286": {"vr": "IS", "Value": [10]}, "287": {"vr": "IS", "Value": [10]}, "288": {"vr": "IS", "Value": [10]}, "289": {"vr": "IS", "Value": [10]}, "290": {"vr": "IS", "Value": [10]}, "291": {"vr": "IS", "Value": [10]}, "292": {"vr": "IS", "Value": [10]}, "293": {"vr": "IS", "Value": [10]}, "294": {"vr": "IS", "Value": [10]}, "295": {"vr": "IS", "Value": [10]}, "296": {"vr": "IS", "Value": [10]}, "297": {"vr": "IS", "Value": [10]}, "298": {"vr": "IS", "Value": [10]}, "299": {"vr": "IS", "Value": [10]}, "300": {"vr": "IS", "Value": [10]}, "301": {"vr": "IS", "Value": [10]}, "302": {"vr": "IS", "Value": [10]}, "303": {"vr": "IS", "Value": [10]}, "304": {"vr": "IS", "Value": [10]}, "305": {"vr": "IS", "Value": [10]}, "306": {"vr": "IS", "Value": [11]}, "307": {"vr": "IS", "Value": [11]}, "308": {"vr": "IS", "Value": [10]}, "309": {"vr": "IS", "Value": [10]}, "310": {"vr": "IS", "Value": [10]}, "311": {"vr": "IS", "Value": [10]}, "312": {"vr": "IS", "Value": [10]}, "313": {"vr": "IS", "Value": [10]}, "314": {"vr": "IS", "Value": [10]}, "315": {"vr": "IS", "Value": [10]}, "316": {"vr": "IS", "Value": [10]}, "317": {"vr": "IS", "Value": [10]}, "318": {"vr": "IS", "Value": [10]}, "319": {"vr": "IS", "Value": [10]}, "320": {"vr": "IS", "Value": [10]}, "321": {"vr": "IS", "Value": [10]}, "322": {"vr": "IS", "Value": [10]}, "323": {"vr": "IS", "Value": [10]}, "324": {"vr": "IS", "Value": [10]}, "325": {"vr": "IS", "Value": [10]}, "326": {"vr": "IS", "Value": [10]}, "327": {"vr": "IS", "Value": [10]}, "328": {"vr": "IS", "Value": [10]}, "329": {"vr": "IS", "Value": [10]}, "330": {"vr": "IS", "Value": [10]}, "331": {"vr": "IS", "Value": [10]}, "332": {"vr": "IS", "Value": [10]}, "333": {"vr": "IS", "Value": [10]}, "334": {"vr": "IS", "Value": [10]}, "335": {"vr": "IS", "Value": [10]}, "336": {"vr": "IS", "Value": [10]}, "337": {"vr": "IS", "Value": [11]}, "338": {"vr": "IS", "Value": [11]}, "339": {"vr": "IS", "Value": [11]}, "340": {"vr": "IS", "Value": [11]}, "341": {"vr": "IS", "Value": [11]}, "342": {"vr": "IS", "Value": [11]}, "343": {"vr": "IS", "Value": [11]}, "344": {"vr": "IS", "Value": [11]}, "345": {"vr": "IS", "Value": [11]}, "346": {"vr": "IS", "Value": [11]}, "347": {"vr": "IS", "Value": [11]}, "348": {"vr": "IS", "Value": [11]}, "349": {"vr": "IS", "Value": [11]}, "350": {"vr": "IS", "Value": [11]}, "351": {"vr": "IS", "Value": [11]}, "352": {"vr": "IS", "Value": [11]}, "353": {"vr": "IS", "Value": [11]}, "354": {"vr": "IS", "Value": [11]}, "355": {"vr": "IS", "Value": [11]}, "356": {"vr": "IS", "Value": [11]}, "357": {"vr": "IS", "Value": [11]}, "358": {"vr": "IS", "Value": [11]}, "359": {"vr": "IS", "Value": [11]}, "360": {"vr": "IS", "Value": [11]}, "361": {"vr": "IS", "Value": [11]}, "362": {"vr": "IS", "Value": [11]}, "363": {"vr": "IS", "Value": [11]}, "364": {"vr": "IS", "Value": [11]}, "365": {"vr": "IS", "Value": [11]}, "366": {"vr": "IS", "Value": [11]}, "367": {"vr": "IS", "Value": [11]}, "368": {"vr": "IS", "Value": [11]}, "369": {"vr": "IS", "Value": [11]}, "370": {"vr": "IS", "Value": [11]}, "371": {"vr": "IS", "Value": [11]}, "372": {"vr": "IS", "Value": [11]}, "373": {"vr": "IS", "Value": [11]}, "374": {"vr": "IS", "Value": [11]}, "375": {"vr": "IS", "Value": [11]}, "376": {"vr": "IS", "Value": [11]}, "377": {"vr": "IS", "Value": [11]}, "378": {"vr": "IS", "Value": [11]}, "379": {"vr": "IS", "Value": [11]}, "380": {"vr": "IS", "Value": [11]}, "381": {"vr": "IS", "Value": [11]}, "382": {"vr": "IS", "Value": [11]}, "383": {"vr": "IS", "Value": [11]}, "384": {"vr": "IS", "Value": [11]}, "385": {"vr": "IS", "Value": [11]}, "386": {"vr": "IS", "Value": [11]}, "387": {"vr": "IS", "Value": [11]}, "388": {"vr": "IS", "Value": [11]}, "389": {"vr": "IS", "Value": [11]}, "390": {"vr": "IS", "Value": [11]}, "391": {"vr": "IS", "Value": [11]}, "392": {"vr": "IS", "Value": [11]}, "393": {"vr": "IS", "Value": [11]}, "394": {"vr": "IS", "Value": [11]}, "395": {"vr": "IS", "Value": [11]}, "396": {"vr": "IS", "Value": [11]}, "397": {"vr": "IS", "Value": [11]}, "398": {"vr": "IS", "Value": [11]}, "399": {"vr": "IS", "Value": [11]}, "400": {"vr": "IS", "Value": [11]}, "401": {"vr": "IS", "Value": [11]}, "402": {"vr": "IS", "Value": [11]}, "403": {"vr": "IS", "Value": [11]}, "404": {"vr": "IS", "Value": [11]}, "405": {"vr": "IS", "Value": [11]}, "406": {"vr": "IS", "Value": [11]}, "407": {"vr": "IS", "Value": [11]}, "408": {"vr": "IS", "Value": [11]}, "409": {"vr": "IS", "Value": [11]}, "410": {"vr": "IS", "Value": [11]}, "411": {"vr": "IS", "Value": [11]}, "412": {"vr": "IS", "Value": [11]}, "413": {"vr": "IS", "Value": [11]}, "414": {"vr": "IS", "Value": [11]}, "415": {"vr": "IS", "Value": [11]}, "416": {"vr": "IS", "Value": [11]}, "417": {"vr": "IS", "Value": [11]}, "418": {"vr": "IS", "Value": [11]}, "419": {"vr": "IS", "Value": [11]}, "420": {"vr": "IS", "Value": [11]}, "421": {"vr": "IS", "Value": [11]}, "422": {"vr": "IS", "Value": [11]}, "423": {"vr": "IS", "Value": [11]}, "424": {"vr": "IS", "Value": [11]}, "425": {"vr": "IS", "Value": [11]}, "426": {"vr": "IS", "Value": [11]}, "427": {"vr": "IS", "Value": [11]}, "428": {"vr": "IS", "Value": [11]}, "429": {"vr": "IS", "Value": [11]}, "430": {"vr": "IS", "Value": [11]}, "431": {"vr": "IS", "Value": [11]}, "432": {"vr": "IS", "Value": [11]}, "433": {"vr": "IS", "Value": [11]}, "434": {"vr": "IS", "Value": [11]}, "435": {"vr": "IS", "Value": [11]}, "436": {"vr": "IS", "Value": [11]}, "437": {"vr": "IS", "Value": [11]}, "438": {"vr": "IS", "Value": [11]}, "439": {"vr": "IS", "Value": [11]}, "440": {"vr": "IS", "Value": [11]}, "441": {"vr": "IS", "Value": [11]}, "442": {"vr": "IS", "Value": [11]}, "443": {"vr": "IS", "Value": [11]}, "444": {"vr": "IS", "Value": [11]}, "445": {"vr": "IS", "Value": [11]}, "446": {"vr": "IS", "Value": [11]}, "447": {"vr": "IS", "Value": [11]}, "448": {"vr": "IS", "Value": [11]}, "449": {"vr": "IS", "Value": [11]}, "450": {"vr": "IS", "Value": [11]}, "451": {"vr": "IS", "Value": [11]}, "452": {"vr": "IS", "Value": [11]}, "453": {"vr": "IS", "Value": [11]}, "454": {"vr": "IS", "Value": [11]}, "455": {"vr": "IS", "Value": [11]}, "456": {"vr": "IS", "Value": [11]}, "457": {"vr": "IS", "Value": [11]}, "458": {"vr": "IS", "Value": [11]}, "459": {"vr": "IS", "Value": [11]}, "460": {"vr": "IS", "Value": [11]}, "461": {"vr": "IS", "Value": [11]}, "462": {"vr": "IS", "Value": [11]}, "463": {"vr": "IS", "Value": [11]}, "464": {"vr": "IS", "Value": [11]}, "465": {"vr": "IS", "Value": [11]}, "466": {"vr": "IS", "Value": [11]}, "467": {"vr": "IS", "Value": [11]}, "468": {"vr": "IS", "Value": [11]}, "469": {"vr": "IS", "Value": [11]}, "470": {"vr": "IS", "Value": [11]}, "471": {"vr": "IS", "Value": [11]}, "472": {"vr": "IS", "Value": [11]}, "473": {"vr": "IS", "Value": [11]}, "474": {"vr": "IS", "Value": [11]}, "475": {"vr": "IS", "Value": [11]}, "476": {"vr": "IS", "Value": [11]}, "477": {"vr": "IS", "Value": [11]}, "478": {"vr": "IS", "Value": [11]}, "479": {"vr": "IS", "Value": [11]}, "480": {"vr": "IS", "Value": [11]}, "481": {"vr": "IS", "Value": [11]}, "482": {"vr": "IS", "Value": [11]}, "483": {"vr": "IS", "Value": [11]}, "484": {"vr": "IS", "Value": [11]}, "485": {"vr": "IS", "Value": [11]}, "486": {"vr": "IS", "Value": [11]}, "487": {"vr": "IS", "Value": [11]}, "488": {"vr": "IS", "Value": [11]}, "489": {"vr": "IS", "Value": [11]}, "490": {"vr": "IS", "Value": [11]}, "491": {"vr": "IS", "Value": [11]}, "492": {"vr": "IS", "Value": [11]}, "493": {"vr": "IS", "Value": [11]}, "494": {"vr": "IS", "Value": [11]}, "495": {"vr": "IS", "Value": [11]}, "496": {"vr": "IS", "Value": [11]}, "497": {"vr": "IS", "Value": [11]}, "498": {"vr": "IS", "Value": [11]}, "499": {"vr": "IS", "Value": [11]}, "500": {"vr": "IS", "Value": [11]}, "501": {"vr": "IS", "Value": [11]}, "502": {"vr": "IS", "Value": [11]}, "503": {"vr": "IS", "Value": [11]}, "504": {"vr": "IS", "Value": [11]}, "505": {"vr": "IS", "Value": [11]}, "506": {"vr": "IS", "Value": [11]}, "507": {"vr": "IS", "Value": [11]}, "508": {"vr": "IS", "Value": [11]}, "509": {"vr": "IS", "Value": [11]}, "510": {"vr": "IS", "Value": [11]}, "511": {"vr": "IS", "Value": [11]}, "512": {"vr": "IS", "Value": [11]}, "513": {"vr": "IS", "Value": [11]}, "514": {"vr": "IS", "Value": [11]}, "515": {"vr": "IS", "Value": [11]}, "516": {"vr": "IS", "Value": [11]}, "517": {"vr": "IS", "Value": [11]}, "518": {"vr": "IS", "Value": [11]}, "519": {"vr": "IS", "Value": [11]}, "520": {"vr": "IS", "Value": [11]}, "521": {"vr": "IS", "Value": [11]}, "522": {"vr": "IS", "Value": [11]}, "523": {"vr": "IS", "Value": [11]}, "524": {"vr": "IS", "Value": [11]}, "525": {"vr": "IS", "Value": [11]}, "526": {"vr": "IS", "Value": [11]}, "527": {"vr": "IS", "Value": [11]}, "528": {"vr": "IS", "Value": [11]}, "529": {"vr": "IS", "Value": [11]}, "530": {"vr": "IS", "Value": [11]}}, "00189313": {"0": {"vr": "FD", "Value": [0.0, -140.5, 168.5]}, "1": {"vr": "FD", "Value": [0.0, -140.5, 166.5]}, "2": {"vr": "FD", "Value": [0.0, -140.5, 164.5]}, "3": {"vr": "FD", "Value": [0.0, -140.5, 162.5]}, "4": {"vr": "FD", "Value": [0.0, -140.5, 160.5]}, "5": {"vr": "FD", "Value": [0.0, -140.5, 158.5]}, "6": {"vr": "FD", "Value": [0.0, -140.5, 156.5]}, "7": {"vr": "FD", "Value": [0.0, -140.5, 154.5]}, "8": {"vr": "FD", "Value": [0.0, -140.5, 152.5]}, "9": {"vr": "FD", "Value": [0.0, -140.5, 150.5]}, "10": {"vr": "FD", "Value": [0.0, -140.5, 148.5]}, "11": {"vr": "FD", "Value": [0.0, -140.5, 146.5]}, "12": {"vr": "FD", "Value": [0.0, -140.5, 144.5]}, "13": {"vr": "FD", "Value": [0.0, -140.5, 142.5]}, "14": {"vr": "FD", "Value": [0.0, -140.5, 140.5]}, "15": {"vr": "FD", "Value": [0.0, -140.5, 138.5]}, "16": {"vr": "FD", "Value": [0.0, -140.5, 136.5]}, "17": {"vr": "FD", "Value": [0.0, -140.5, 134.5]}, "18": {"vr": "FD", "Value": [0.0, -140.5, 132.5]}, "19": {"vr": "FD", "Value": [0.0, -140.5, 130.5]}, "20": {"vr": "FD", "Value": [0.0, -140.5, 128.5]}, "21": {"vr": "FD", "Value": [0.0, -140.5, 126.5]}, "22": {"vr": "FD", "Value": [0.0, -140.5, 124.5]}, "23": {"vr": "FD", "Value": [0.0, -140.5, 122.5]}, "24": {"vr": "FD", "Value": [0.0, -140.5, 120.5]}, "25": {"vr": "FD", "Value": [0.0, -140.5, 118.5]}, "26": {"vr": "FD", "Value": [0.0, -140.5, 116.5]}, "27": {"vr": "FD", "Value": [0.0, -140.5, 114.5]}, "28": {"vr": "FD", "Value": [0.0, -140.5, 112.5]}, "29": {"vr": "FD", "Value": [0.0, -140.5, 110.5]}, "30": {"vr": "FD", "Value": [0.0, -140.5, 108.5]}, "31": {"vr": "FD", "Value": [0.0, -140.5, 106.5]}, "32": {"vr": "FD", "Value": [0.0, -140.5, 104.5]}, "33": {"vr": "FD", "Value": [0.0, -140.5, 102.5]}, "34": {"vr": "FD", "Value": [0.0, -140.5, 100.5]}, "35": {"vr": "FD", "Value": [0.0, -140.5, 98.5]}, "36": {"vr": "FD", "Value": [0.0, -140.5, 96.5]}, "37": {"vr": "FD", "Value": [0.0, -140.5, 94.5]}, "38": {"vr": "FD", "Value": [0.0, -140.5, 92.5]}, "39": {"vr": "FD", "Value": [0.0, -140.5, 90.5]}, "40": {"vr": "FD", "Value": [0.0, -140.5, 88.5]}, "41": {"vr": "FD", "Value": [0.0, -140.5, 86.5]}, "42": {"vr": "FD", "Value": [0.0, -140.5, 84.5]}, "43": {"vr": "FD", "Value": [0.0, -140.5, 82.5]}, "44": {"vr": "FD", "Value": [0.0, -140.5, 80.5]}, "45": {"vr": "FD", "Value": [0.0, -140.5, 78.5]}, "46": {"vr": "FD", "Value": [0.0, -140.5, 76.5]}, "47": {"vr": "FD", "Value": [0.0, -140.5, 74.5]}, "48": {"vr": "FD", "Value": [0.0, -140.5, 72.5]}, "49": {"vr": "FD", "Value": [0.0, -140.5, 70.5]}, "50": {"vr": "FD", "Value": [0.0, -140.5, 68.5]}, "51": {"vr": "FD", "Value": [0.0, -140.5, 66.5]}, "52": {"vr": "FD", "Value": [0.0, -140.5, 64.5]}, "53": {"vr": "FD", "Value": [0.0, -140.5, 62.5]}, "54": {"vr": "FD", "Value": [0.0, -140.5, 60.5]}, "55": {"vr": "FD", "Value": [0.0, -140.5, 58.5]}, "56": {"vr": "FD", "Value": [0.0, -140.5, 56.5]}, "57": {"vr": "FD", "Value": [0.0, -140.5, 54.5]}, "58": {"vr": "FD", "Value": [0.0, -140.5, 52.5]}, "59": {"vr": "FD", "Value": [0.0, -140.5, 50.5]}, "60": {"vr": "FD", "Value": [0.0, -140.5, 48.5]}, "61": {"vr": "FD", "Value": [0.0, -140.5, 46.5]}, "62": {"vr": "FD", "Value": [0.0, -140.5, 44.5]}, "63": {"vr": "FD", "Value": [0.0, -140.5, 42.5]}, "64": {"vr": "FD", "Value": [0.0, -140.5, 40.5]}, "65": {"vr": "FD", "Value": [0.0, -140.5, 38.5]}, "66": {"vr": "FD", "Value": [0.0, -140.5, 36.5]}, "67": {"vr": "FD", "Value": [0.0, -140.5, 34.5]}, "68": {"vr": "FD", "Value": [0.0, -140.5, 32.5]}, "69": {"vr": "FD", "Value": [0.0, -140.5, 30.5]}, "70": {"vr": "FD", "Value": [0.0, -140.5, 28.5]}, "71": {"vr": "FD", "Value": [0.0, -140.5, 26.5]}, "72": {"vr": "FD", "Value": [0.0, -140.5, 24.5]}, "73": {"vr": "FD", "Value": [0.0, -140.5, 22.5]}, "74": {"vr": "FD", "Value": [0.0, -140.5, 20.5]}, "75": {"vr": "FD", "Value": [0.0, -140.5, 18.5]}, "76": {"vr": "FD", "Value": [0.0, -140.5, 16.5]}, "77": {"vr": "FD", "Value": [0.0, -140.5, 14.5]}, "78": {"vr": "FD", "Value": [0.0, -140.5, 12.5]}, "79": {"vr": "FD", "Value": [0.0, -140.5, 10.5]}, "80": {"vr": "FD", "Value": [0.0, -140.5, 8.5]}, "81": {"vr": "FD", "Value": [0.0, -140.5, 6.5]}, "82": {"vr": "FD", "Value": [0.0, -140.5, 4.5]}, "83": {"vr": "FD", "Value": [0.0, -140.5, 2.5]}, "84": {"vr": "FD", "Value": [0.0, -140.5, 0.5]}, "85": {"vr": "FD", "Value": [0.0, -140.5, -1.5]}, "86": {"vr": "FD", "Value": [0.0, -140.5, -3.5]}, "87": {"vr": "FD", "Value": [0.0, -140.5, -5.5]}, "88": {"vr": "FD", "Value": [0.0, -140.5, -7.5]}, "89": {"vr": "FD", "Value": [0.0, -140.5, -9.5]}, "90": {"vr": "FD", "Value": [0.0, -140.5, -11.5]}, "91": {"vr": "FD", "Value": [0.0, -140.5, -13.5]}, "92": {"vr": "FD", "Value": [0.0, -140.5, -15.5]}, "93": {"vr": "FD", "Value": [0.0, -140.5, -17.5]}, "94": {"vr": "FD", "Value": [0.0, -140.5, -19.5]}, "95": {"vr": "FD", "Value": [0.0, -140.5, -21.5]}, "96": {"vr": "FD", "Value": [0.0, -140.5, -23.5]}, "97": {"vr": "FD", "Value": [0.0, -140.5, -25.5]}, "98": {"vr": "FD", "Value": [0.0, -140.5, -27.5]}, "99": {"vr": "FD", "Value": [0.0, -140.5, -29.5]}, "100": {"vr": "FD", "Value": [0.0, -140.5, -31.5]}, "101": {"vr": "FD", "Value": [0.0, -140.5, -33.5]}, "102": {"vr": "FD", "Value": [0.0, -140.5, -35.5]}, "103": {"vr": "FD", "Value": [0.0, -140.5, -37.5]}, "104": {"vr": "FD", "Value": [0.0, -140.5, -39.5]}, "105": {"vr": "FD", "Value": [0.0, -140.5, -41.5]}, "106": {"vr": "FD", "Value": [0.0, -140.5, -43.5]}, "107": {"vr": "FD", "Value": [0.0, -140.5, -45.5]}, "108": {"vr": "FD", "Value": [0.0, -140.5, -47.5]}, "109": {"vr": "FD", "Value": [0.0, -140.5, -49.5]}, "110": {"vr": "FD", "Value": [0.0, -140.5, -51.5]}, "111": {"vr": "FD", "Value": [0.0, -140.5, -53.5]}, "112": {"vr": "FD", "Value": [0.0, -140.5, -55.5]}, "113": {"vr": "FD", "Value": [0.0, -140.5, -57.5]}, "114": {"vr": "FD", "Value": [0.0, -140.5, -59.5]}, "115": {"vr": "FD", "Value": [0.0, -140.5, -61.5]}, "116": {"vr": "FD", "Value": [0.0, -140.5, -63.5]}, "117": {"vr": "FD", "Value": [0.0, -140.5, -65.5]}, "118": {"vr": "FD", "Value": [0.0, -140.5, -67.5]}, "119": {"vr": "FD", "Value": [0.0, -140.5, -69.5]}, "120": {"vr": "FD", "Value": [0.0, -140.5, -71.5]}, "121": {"vr": "FD", "Value": [0.0, -140.5, -73.5]}, "122": {"vr": "FD", "Value": [0.0, -140.5, -75.5]}, "123": {"vr": "FD", "Value": [0.0, -140.5, -77.5]}, "124": {"vr": "FD", "Value": [0.0, -140.5, -79.5]}, "125": {"vr": "FD", "Value": [0.0, -140.5, -81.5]}, "126": {"vr": "FD", "Value": [0.0, -140.5, -83.5]}, "127": {"vr": "FD", "Value": [0.0, -140.5, -85.5]}, "128": {"vr": "FD", "Value": [0.0, -140.5, -87.5]}, "129": {"vr": "FD", "Value": [0.0, -140.5, -89.5]}, "130": {"vr": "FD", "Value": [0.0, -140.5, -91.5]}, "131": {"vr": "FD", "Value": [0.0, -140.5, -93.5]}, "132": {"vr": "FD", "Value": [0.0, -140.5, -95.5]}, "133": {"vr": "FD", "Value": [0.0, -140.5, -97.5]}, "134": {"vr": "FD", "Value": [0.0, -140.5, -99.5]}, "135": {"vr": "FD", "Value": [0.0, -140.5, -101.5]}, "136": {"vr": "FD", "Value": [0.0, -140.5, -103.5]}, "137": {"vr": "FD", "Value": [0.0, -140.5, -105.5]}, "138": {"vr": "FD", "Value": [0.0, -140.5, -107.5]}, "139": {"vr": "FD", "Value": [0.0, -140.5, -109.5]}, "140": {"vr": "FD", "Value": [0.0, -140.5, -111.5]}, "141": {"vr": "FD", "Value": [0.0, -140.5, -113.5]}, "142": {"vr": "FD", "Value": [0.0, -140.5, -115.5]}, "143": {"vr": "FD", "Value": [0.0, -140.5, -117.5]}, "144": {"vr": "FD", "Value": [0.0, -140.5, -119.5]}, "145": {"vr": "FD", "Value": [0.0, -140.5, -121.5]}, "146": {"vr": "FD", "Value": [0.0, -140.5, -123.5]}, "147": {"vr": "FD", "Value": [0.0, -140.5, -125.5]}, "148": {"vr": "FD", "Value": [0.0, -140.5, -127.5]}, "149": {"vr": "FD", "Value": [0.0, -140.5, -129.5]}, "150": {"vr": "FD", "Value": [0.0, -140.5, -131.5]}, "151": {"vr": "FD", "Value": [0.0, -140.5, -133.5]}, "152": {"vr": "FD", "Value": [0.0, -140.5, -135.5]}, "153": {"vr": "FD", "Value": [0.0, -140.5, -137.5]}, "154": {"vr": "FD", "Value": [0.0, -140.5, -139.5]}, "155": {"vr": "FD", "Value": [0.0, -140.5, -141.5]}, "156": {"vr": "FD", "Value": [0.0, -140.5, -143.5]}, "157": {"vr": "FD", "Value": [0.0, -140.5, -145.5]}, "158": {"vr": "FD", "Value": [0.0, -140.5, -147.5]}, "159": {"vr": "FD", "Value": [0.0, -140.5, -149.5]}, "160": {"vr": "FD", "Value": [0.0, -140.5, -151.5]}, "161": {"vr": "FD", "Value": [0.0, -140.5, -153.5]}, "162": {"vr": "FD", "Value": [0.0, -140.5, -155.5]}, "163": {"vr": "FD", "Value": [0.0, -140.5, -157.5]}, "164": {"vr": "FD", "Value": [0.0, -140.5, -159.5]}, "165": {"vr": "FD", "Value": [0.0, -140.5, -161.5]}, "166": {"vr": "FD", "Value": [0.0, -140.5, -163.5]}, "167": {"vr": "FD", "Value": [0.0, -140.5, -165.5]}, "168": {"vr": "FD", "Value": [0.0, -140.5, -167.5]}, "169": {"vr": "FD", "Value": [0.0, -140.5, -169.5]}, "170": {"vr": "FD", "Value": [0.0, -140.5, -171.5]}, "171": {"vr": "FD", "Value": [0.0, -140.5, -173.5]}, "172": {"vr": "FD", "Value": [0.0, -140.5, -175.5]}, "173": {"vr": "FD", "Value": [0.0, -140.5, -177.5]}, "174": {"vr": "FD", "Value": [0.0, -140.5, -179.5]}, "175": {"vr": "FD", "Value": [0.0, -140.5, -181.5]}, "176": {"vr": "FD", "Value": [0.0, -140.5, -183.5]}, "177": {"vr": "FD", "Value": [0.0, -140.5, -185.5]}, "178": {"vr": "FD", "Value": [0.0, -140.5, -187.5]}, "179": {"vr": "FD", "Value": [0.0, -140.5, -189.5]}, "180": {"vr": "FD", "Value": [0.0, -140.5, -191.5]}, "181": {"vr": "FD", "Value": [0.0, -140.5, -193.5]}, "182": {"vr": "FD", "Value": [0.0, -140.5, -195.5]}, "183": {"vr": "FD", "Value": [0.0, -140.5, -197.5]}, "184": {"vr": "FD", "Value": [0.0, -140.5, -199.5]}, "185": {"vr": "FD", "Value": [0.0, -140.5, -201.5]}, "186": {"vr": "FD", "Value": [0.0, -140.5, -203.5]}, "187": {"vr": "FD", "Value": [0.0, -140.5, -205.5]}, "188": {"vr": "FD", "Value": [0.0, -140.5, -207.5]}, "189": {"vr": "FD", "Value": [0.0, -140.5, -209.5]}, "190": {"vr": "FD", "Value": [0.0, -140.5, -211.5]}, "191": {"vr": "FD", "Value": [0.0, -140.5, -213.5]}, "192": {"vr": "FD", "Value": [0.0, -140.5, -215.5]}, "193": {"vr": "FD", "Value": [0.0, -140.5, -217.5]}, "194": {"vr": "FD", "Value": [0.0, -140.5, -219.5]}, "195": {"vr": "FD", "Value": [0.0, -140.5, -221.5]}, "196": {"vr": "FD", "Value": [0.0, -140.5, -223.5]}, "197": {"vr": "FD", "Value": [0.0, -140.5, -225.5]}, "198": {"vr": "FD", "Value": [0.0, -140.5, -227.5]}, "199": {"vr": "FD", "Value": [0.0, -140.5, -229.5]}, "200": {"vr": "FD", "Value": [0.0, -140.5, -231.5]}, "201": {"vr": "FD", "Value": [0.0, -140.5, -233.5]}, "202": {"vr": "FD", "Value": [0.0, -140.5, -235.5]}, "203": {"vr": "FD", "Value": [0.0, -140.5, -237.5]}, "204": {"vr": "FD", "Value": [0.0, -140.5, -239.5]}, "205": {"vr": "FD", "Value": [0.0, -140.5, -241.5]}, "206": {"vr": "FD", "Value": [0.0, -140.5, -243.5]}, "207": {"vr": "FD", "Value": [0.0, -140.5, -245.5]}, "208": {"vr": "FD", "Value": [0.0, -140.5, -247.5]}, "209": {"vr": "FD", "Value": [0.0, -140.5, -249.5]}, "210": {"vr": "FD", "Value": [0.0, -140.5, -251.5]}, "211": {"vr": "FD", "Value": [0.0, -140.5, -253.5]}, "212": {"vr": "FD", "Value": [0.0, -140.5, -255.5]}, "213": {"vr": "FD", "Value": [0.0, -140.5, -257.5]}, "214": {"vr": "FD", "Value": [0.0, -140.5, -259.5]}, "215": {"vr": "FD", "Value": [0.0, -140.5, -261.5]}, "216": {"vr": "FD", "Value": [0.0, -140.5, -263.5]}, "217": {"vr": "FD", "Value": [0.0, -140.5, -265.5]}, "218": {"vr": "FD", "Value": [0.0, -140.5, -267.5]}, "219": {"vr": "FD", "Value": [0.0, -140.5, -269.5]}, "220": {"vr": "FD", "Value": [0.0, -140.5, -271.5]}, "221": {"vr": "FD", "Value": [0.0, -140.5, -273.5]}, "222": {"vr": "FD", "Value": [0.0, -140.5, -275.5]}, "223": {"vr": "FD", "Value": [0.0, -140.5, -277.5]}, "224": {"vr": "FD", "Value": [0.0, -140.5, -279.5]}, "225": {"vr": "FD", "Value": [0.0, -140.5, -281.5]}, "226": {"vr": "FD", "Value": [0.0, -140.5, -283.5]}, "227": {"vr": "FD", "Value": [0.0, -140.5, -285.5]}, "228": {"vr": "FD", "Value": [0.0, -140.5, -287.5]}, "229": {"vr": "FD", "Value": [0.0, -140.5, -289.5]}, "230": {"vr": "FD", "Value": [0.0, -140.5, -291.5]}, "231": {"vr": "FD", "Value": [0.0, -140.5, -293.5]}, "232": {"vr": "FD", "Value": [0.0, -140.5, -295.5]}, "233": {"vr": "FD", "Value": [0.0, -140.5, -297.5]}, "234": {"vr": "FD", "Value": [0.0, -140.5, -299.5]}, "235": {"vr": "FD", "Value": [0.0, -140.5, -301.5]}, "236": {"vr": "FD", "Value": [0.0, -140.5, -303.5]}, "237": {"vr": "FD", "Value": [0.0, -140.5, -305.5]}, "238": {"vr": "FD", "Value": [0.0, -140.5, -307.5]}, "239": {"vr": "FD", "Value": [0.0, -140.5, -309.5]}, "240": {"vr": "FD", "Value": [0.0, -140.5, -311.5]}, "241": {"vr": "FD", "Value": [0.0, -140.5, -313.5]}, "242": {"vr": "FD", "Value": [0.0, -140.5, -315.5]}, "243": {"vr": "FD", "Value": [0.0, -140.5, -317.5]}, "244": {"vr": "FD", "Value": [0.0, -140.5, -319.5]}, "245": {"vr": "FD", "Value": [0.0, -140.5, -321.5]}, "246": {"vr": "FD", "Value": [0.0, -140.5, -323.5]}, "247": {"vr": "FD", "Value": [0.0, -140.5, -325.5]}, "248": {"vr": "FD", "Value": [0.0, -140.5, -327.5]}, "249": {"vr": "FD", "Value": [0.0, -140.5, -329.5]}, "250": {"vr": "FD", "Value": [0.0, -140.5, -331.5]}, "251": {"vr": "FD", "Value": [0.0, -140.5, -333.5]}, "252": {"vr": "FD", "Value": [0.0, -140.5, -335.5]}, "253": {"vr": "FD", "Value": [0.0, -140.5, -337.5]}, "254": {"vr": "FD", "Value": [0.0, -140.5, -339.5]}, "255": {"vr": "FD", "Value": [0.0, -140.5, -341.5]}, "256": {"vr": "FD", "Value": [0.0, -140.5, -343.5]}, "257": {"vr": "FD", "Value": [0.0, -140.5, -345.5]}, "258": {"vr": "FD", "Value": [0.0, -140.5, -347.5]}, "259": {"vr": "FD", "Value": [0.0, -140.5, -349.5]}, "260": {"vr": "FD", "Value": [0.0, -140.5, -351.5]}, "261": {"vr": "FD", "Value": [0.0, -140.5, -353.5]}, "262": {"vr": "FD", "Value": [0.0, -140.5, -355.5]}, "263": {"vr": "FD", "Value": [0.0, -140.5, -357.5]}, "264": {"vr": "FD", "Value": [0.0, -140.5, -359.5]}, "265": {"vr": "FD", "Value": [0.0, -140.5, -361.5]}, "266": {"vr": "FD", "Value": [0.0, -140.5, -363.5]}, "267": {"vr": "FD", "Value": [0.0, -140.5, -365.5]}, "268": {"vr": "FD", "Value": [0.0, -140.5, -367.5]}, "269": {"vr": "FD", "Value": [0.0, -140.5, -369.5]}, "270": {"vr": "FD", "Value": [0.0, -140.5, -371.5]}, "271": {"vr": "FD", "Value": [0.0, -140.5, -373.5]}, "272": {"vr": "FD", "Value": [0.0, -140.5, -375.5]}, "273": {"vr": "FD", "Value": [0.0, -140.5, -377.5]}, "274": {"vr": "FD", "Value": [0.0, -140.5, -379.5]}, "275": {"vr": "FD", "Value": [0.0, -140.5, -381.5]}, "276": {"vr": "FD", "Value": [0.0, -140.5, -383.5]}, "277": {"vr": "FD", "Value": [0.0, -140.5, -385.5]}, "278": {"vr": "FD", "Value": [0.0, -140.5, -387.5]}, "279": {"vr": "FD", "Value": [0.0, -140.5, -389.5]}, "280": {"vr": "FD", "Value": [0.0, -140.5, -391.5]}, "281": {"vr": "FD", "Value": [0.0, -140.5, -393.5]}, "282": {"vr": "FD", "Value": [0.0, -140.5, -395.5]}, "283": {"vr": "FD", "Value": [0.0, -140.5, -397.5]}, "284": {"vr": "FD", "Value": [0.0, -140.5, -399.5]}, "285": {"vr": "FD", "Value": [0.0, -140.5, -401.5]}, "286": {"vr": "FD", "Value": [0.0, -140.5, -403.5]}, "287": {"vr": "FD", "Value": [0.0, -140.5, -405.5]}, "288": {"vr": "FD", "Value": [0.0, -140.5, -407.5]}, "289": {"vr": "FD", "Value": [0.0, -140.5, -409.5]}, "290": {"vr": "FD", "Value": [0.0, -140.5, -411.5]}, "291": {"vr": "FD", "Value": [0.0, -140.5, -413.5]}, "292": {"vr": "FD", "Value": [0.0, -140.5, -415.5]}, "293": {"vr": "FD", "Value": [0.0, -140.5, -417.5]}, "294": {"vr": "FD", "Value": [0.0, -140.5, -419.5]}, "295": {"vr": "FD", "Value": [0.0, -140.5, -421.5]}, "296": {"vr": "FD", "Value": [0.0, -140.5, -423.5]}, "297": {"vr": "FD", "Value": [0.0, -140.5, -425.5]}, "298": {"vr": "FD", "Value": [0.0, -140.5, -427.5]}, "299": {"vr": "FD", "Value": [0.0, -140.5, -429.5]}, "300": {"vr": "FD", "Value": [0.0, -140.5, -431.5]}, "301": {"vr": "FD", "Value": [0.0, -140.5, -433.5]}, "302": {"vr": "FD", "Value": [0.0, -140.5, -435.5]}, "303": {"vr": "FD", "Value": [0.0, -140.5, -437.5]}, "304": {"vr": "FD", "Value": [0.0, -140.5, -439.5]}, "305": {"vr": "FD", "Value": [0.0, -140.5, -441.5]}, "306": {"vr": "FD", "Value": [0.0, -140.5, -443.5]}, "307": {"vr": "FD", "Value": [0.0, -140.5, -445.5]}, "308": {"vr": "FD", "Value": [0.0, -140.5, -447.5]}, "309": {"vr": "FD", "Value": [0.0, -140.5, -449.5]}, "310": {"vr": "FD", "Value": [0.0, -140.5, -451.5]}, "311": {"vr": "FD", "Value": [0.0, -140.5, -453.5]}, "312": {"vr": "FD", "Value": [0.0, -140.5, -455.5]}, "313": {"vr": "FD", "Value": [0.0, -140.5, -457.5]}, "314": {"vr": "FD", "Value": [0.0, -140.5, -459.5]}, "315": {"vr": "FD", "Value": [0.0, -140.5, -461.5]}, "316": {"vr": "FD", "Value": [0.0, -140.5, -463.5]}, "317": {"vr": "FD", "Value": [0.0, -140.5, -465.5]}, "318": {"vr": "FD", "Value": [0.0, -140.5, -467.5]}, "319": {"vr": "FD", "Value": [0.0, -140.5, -469.5]}, "320": {"vr": "FD", "Value": [0.0, -140.5, -471.5]}, "321": {"vr": "FD", "Value": [0.0, -140.5, -473.5]}, "322": {"vr": "FD", "Value": [0.0, -140.5, -475.5]}, "323": {"vr": "FD", "Value": [0.0, -140.5, -477.5]}, "324": {"vr": "FD", "Value": [0.0, -140.5, -479.5]}, "325": {"vr": "FD", "Value": [0.0, -140.5, -481.5]}, "326": {"vr": "FD", "Value": [0.0, -140.5, -483.5]}, "327": {"vr": "FD", "Value": [0.0, -140.5, -485.5]}, "328": {"vr": "FD", "Value": [0.0, -140.5, -487.5]}, "329": {"vr": "FD", "Value": [0.0, -140.5, -489.5]}, "330": {"vr": "FD", "Value": [0.0, -140.5, -491.5]}, "331": {"vr": "FD", "Value": [0.0, -140.5, -493.5]}, "332": {"vr": "FD", "Value": [0.0, -140.5, -495.5]}, "333": {"vr": "FD", "Value": [0.0, -140.5, -497.5]}, "334": {"vr": "FD", "Value": [0.0, -140.5, -499.5]}, "335": {"vr": "FD", "Value": [0.0, -140.5, -501.5]}, "336": {"vr": "FD", "Value": [0.0, -140.5, -503.5]}, "337": {"vr": "FD", "Value": [0.0, -140.5, -505.5]}, "338": {"vr": "FD", "Value": [0.0, -140.5, -507.5]}, "339": {"vr": "FD", "Value": [0.0, -140.5, -509.5]}, "340": {"vr": "FD", "Value": [0.0, -140.5, -511.5]}, "341": {"vr": "FD", "Value": [0.0, -140.5, -513.5]}, "342": {"vr": "FD", "Value": [0.0, -140.5, -515.5]}, "343": {"vr": "FD", "Value": [0.0, -140.5, -517.5]}, "344": {"vr": "FD", "Value": [0.0, -140.5, -519.5]}, "345": {"vr": "FD", "Value": [0.0, -140.5, -521.5]}, "346": {"vr": "FD", "Value": [0.0, -140.5, -523.5]}, "347": {"vr": "FD", "Value": [0.0, -140.5, -525.5]}, "348": {"vr": "FD", "Value": [0.0, -140.5, -527.5]}, "349": {"vr": "FD", "Value": [0.0, -140.5, -529.5]}, "350": {"vr": "FD", "Value": [0.0, -140.5, -531.5]}, "351": {"vr": "FD", "Value": [0.0, -140.5, -533.5]}, "352": {"vr": "FD", "Value": [0.0, -140.5, -535.5]}, "353": {"vr": "FD", "Value": [0.0, -140.5, -537.5]}, "354": {"vr": "FD", "Value": [0.0, -140.5, -539.5]}, "355": {"vr": "FD", "Value": [0.0, -140.5, -541.5]}, "356": {"vr": "FD", "Value": [0.0, -140.5, -543.5]}, "357": {"vr": "FD", "Value": [0.0, -140.5, -545.5]}, "358": {"vr": "FD", "Value": [0.0, -140.5, -547.5]}, "359": {"vr": "FD", "Value": [0.0, -140.5, -549.5]}, "360": {"vr": "FD", "Value": [0.0, -140.5, -551.5]}, "361": {"vr": "FD", "Value": [0.0, -140.5, -553.5]}, "362": {"vr": "FD", "Value": [0.0, -140.5, -555.5]}, "363": {"vr": "FD", "Value": [0.0, -140.5, -557.5]}, "364": {"vr": "FD", "Value": [0.0, -140.5, -559.5]}, "365": {"vr": "FD", "Value": [0.0, -140.5, -561.5]}, "366": {"vr": "FD", "Value": [0.0, -140.5, -563.5]}, "367": {"vr": "FD", "Value": [0.0, -140.5, -565.5]}, "368": {"vr": "FD", "Value": [0.0, -140.5, -567.5]}, "369": {"vr": "FD", "Value": [0.0, -140.5, -569.5]}, "370": {"vr": "FD", "Value": [0.0, -140.5, -571.5]}, "371": {"vr": "FD", "Value": [0.0, -140.5, -573.5]}, "372": {"vr": "FD", "Value": [0.0, -140.5, -575.5]}, "373": {"vr": "FD", "Value": [0.0, -140.5, -577.5]}, "374": {"vr": "FD", "Value": [0.0, -140.5, -579.5]}, "375": {"vr": "FD", "Value": [0.0, -140.5, -581.5]}, "376": {"vr": "FD", "Value": [0.0, -140.5, -583.5]}, "377": {"vr": "FD", "Value": [0.0, -140.5, -585.5]}, "378": {"vr": "FD", "Value": [0.0, -140.5, -587.5]}, "379": {"vr": "FD", "Value": [0.0, -140.5, -589.5]}, "380": {"vr": "FD", "Value": [0.0, -140.5, -591.5]}, "381": {"vr": "FD", "Value": [0.0, -140.5, -593.5]}, "382": {"vr": "FD", "Value": [0.0, -140.5, -595.5]}, "383": {"vr": "FD", "Value": [0.0, -140.5, -597.5]}, "384": {"vr": "FD", "Value": [0.0, -140.5, -599.5]}, "385": {"vr": "FD", "Value": [0.0, -140.5, -601.5]}, "386": {"vr": "FD", "Value": [0.0, -140.5, -603.5]}, "387": {"vr": "FD", "Value": [0.0, -140.5, -605.5]}, "388": {"vr": "FD", "Value": [0.0, -140.5, -607.5]}, "389": {"vr": "FD", "Value": [0.0, -140.5, -609.5]}, "390": {"vr": "FD", "Value": [0.0, -140.5, -611.5]}, "391": {"vr": "FD", "Value": [0.0, -140.5, -613.5]}, "392": {"vr": "FD", "Value": [0.0, -140.5, -615.5]}, "393": {"vr": "FD", "Value": [0.0, -140.5, -617.5]}, "394": {"vr": "FD", "Value": [0.0, -140.5, -619.5]}, "395": {"vr": "FD", "Value": [0.0, -140.5, -621.5]}, "396": {"vr": "FD", "Value": [0.0, -140.5, -623.5]}, "397": {"vr": "FD", "Value": [0.0, -140.5, -625.5]}, "398": {"vr": "FD", "Value": [0.0, -140.5, -627.5]}, "399": {"vr": "FD", "Value": [0.0, -140.5, -629.5]}, "400": {"vr": "FD", "Value": [0.0, -140.5, -631.5]}, "401": {"vr": "FD", "Value": [0.0, -140.5, -633.5]}, "402": {"vr": "FD", "Value": [0.0, -140.5, -635.5]}, "403": {"vr": "FD", "Value": [0.0, -140.5, -637.5]}, "404": {"vr": "FD", "Value": [0.0, -140.5, -639.5]}, "405": {"vr": "FD", "Value": [0.0, -140.5, -641.5]}, "406": {"vr": "FD", "Value": [0.0, -140.5, -643.5]}, "407": {"vr": "FD", "Value": [0.0, -140.5, -645.5]}, "408": {"vr": "FD", "Value": [0.0, -140.5, -647.5]}, "409": {"vr": "FD", "Value": [0.0, -140.5, -649.5]}, "410": {"vr": "FD", "Value": [0.0, -140.5, -651.5]}, "411": {"vr": "FD", "Value": [0.0, -140.5, -653.5]}, "412": {"vr": "FD", "Value": [0.0, -140.5, -655.5]}, "413": {"vr": "FD", "Value": [0.0, -140.5, -657.5]}, "414": {"vr": "FD", "Value": [0.0, -140.5, -659.5]}, "415": {"vr": "FD", "Value": [0.0, -140.5, -661.5]}, "416": {"vr": "FD", "Value": [0.0, -140.5, -663.5]}, "417": {"vr": "FD", "Value": [0.0, -140.5, -665.5]}, "418": {"vr": "FD", "Value": [0.0, -140.5, -667.5]}, "419": {"vr": "FD", "Value": [0.0, -140.5, -669.5]}, "420": {"vr": "FD", "Value": [0.0, -140.5, -671.5]}, "421": {"vr": "FD", "Value": [0.0, -140.5, -673.5]}, "422": {"vr": "FD", "Value": [0.0, -140.5, -675.5]}, "423": {"vr": "FD", "Value": [0.0, -140.5, -677.5]}, "424": {"vr": "FD", "Value": [0.0, -140.5, -679.5]}, "425": {"vr": "FD", "Value": [0.0, -140.5, -681.5]}, "426": {"vr": "FD", "Value": [0.0, -140.5, -683.5]}, "427": {"vr": "FD", "Value": [0.0, -140.5, -685.5]}, "428": {"vr": "FD", "Value": [0.0, -140.5, -687.5]}, "429": {"vr": "FD", "Value": [0.0, -140.5, -689.5]}, "430": {"vr": "FD", "Value": [0.0, -140.5, -691.5]}, "431": {"vr": "FD", "Value": [0.0, -140.5, -693.5]}, "432": {"vr": "FD", "Value": [0.0, -140.5, -695.5]}, "433": {"vr": "FD", "Value": [0.0, -140.5, -697.5]}, "434": {"vr": "FD", "Value": [0.0, -140.5, -699.5]}, "435": {"vr": "FD", "Value": [0.0, -140.5, -701.5]}, "436": {"vr": "FD", "Value": [0.0, -140.5, -703.5]}, "437": {"vr": "FD", "Value": [0.0, -140.5, -705.5]}, "438": {"vr": "FD", "Value": [0.0, -140.5, -707.5]}, "439": {"vr": "FD", "Value": [0.0, -140.5, -709.5]}, "440": {"vr": "FD", "Value": [0.0, -140.5, -711.5]}, "441": {"vr": "FD", "Value": [0.0, -140.5, -713.5]}, "442": {"vr": "FD", "Value": [0.0, -140.5, -715.5]}, "443": {"vr": "FD", "Value": [0.0, -140.5, -717.5]}, "444": {"vr": "FD", "Value": [0.0, -140.5, -719.5]}, "445": {"vr": "FD", "Value": [0.0, -140.5, -721.5]}, "446": {"vr": "FD", "Value": [0.0, -140.5, -723.5]}, "447": {"vr": "FD", "Value": [0.0, -140.5, -725.5]}, "448": {"vr": "FD", "Value": [0.0, -140.5, -727.5]}, "449": {"vr": "FD", "Value": [0.0, -140.5, -729.5]}, "450": {"vr": "FD", "Value": [0.0, -140.5, -731.5]}, "451": {"vr": "FD", "Value": [0.0, -140.5, -733.5]}, "452": {"vr": "FD", "Value": [0.0, -140.5, -735.5]}, "453": {"vr": "FD", "Value": [0.0, -140.5, -737.5]}, "454": {"vr": "FD", "Value": [0.0, -140.5, -739.5]}, "455": {"vr": "FD", "Value": [0.0, -140.5, -741.5]}, "456": {"vr": "FD", "Value": [0.0, -140.5, -743.5]}, "457": {"vr": "FD", "Value": [0.0, -140.5, -745.5]}, "458": {"vr": "FD", "Value": [0.0, -140.5, -747.5]}, "459": {"vr": "FD", "Value": [0.0, -140.5, -749.5]}, "460": {"vr": "FD", "Value": [0.0, -140.5, -751.5]}, "461": {"vr": "FD", "Value": [0.0, -140.5, -753.5]}, "462": {"vr": "FD", "Value": [0.0, -140.5, -755.5]}, "463": {"vr": "FD", "Value": [0.0, -140.5, -757.5]}, "464": {"vr": "FD", "Value": [0.0, -140.5, -759.5]}, "465": {"vr": "FD", "Value": [0.0, -140.5, -761.5]}, "466": {"vr": "FD", "Value": [0.0, -140.5, -763.5]}, "467": {"vr": "FD", "Value": [0.0, -140.5, -765.5]}, "468": {"vr": "FD", "Value": [0.0, -140.5, -767.5]}, "469": {"vr": "FD", "Value": [0.0, -140.5, -769.5]}, "470": {"vr": "FD", "Value": [0.0, -140.5, -771.5]}, "471": {"vr": "FD", "Value": [0.0, -140.5, -773.5]}, "472": {"vr": "FD", "Value": [0.0, -140.5, -775.5]}, "473": {"vr": "FD", "Value": [0.0, -140.5, -777.5]}, "474": {"vr": "FD", "Value": [0.0, -140.5, -779.5]}, "475": {"vr": "FD", "Value": [0.0, -140.5, -781.5]}, "476": {"vr": "FD", "Value": [0.0, -140.5, -783.5]}, "477": {"vr": "FD", "Value": [0.0, -140.5, -785.5]}, "478": {"vr": "FD", "Value": [0.0, -140.5, -787.5]}, "479": {"vr": "FD", "Value": [0.0, -140.5, -789.5]}, "480": {"vr": "FD", "Value": [0.0, -140.5, -791.5]}, "481": {"vr": "FD", "Value": [0.0, -140.5, -793.5]}, "482": {"vr": "FD", "Value": [0.0, -140.5, -795.5]}, "483": {"vr": "FD", "Value": [0.0, -140.5, -797.5]}, "484": {"vr": "FD", "Value": [0.0, -140.5, -799.5]}, "485": {"vr": "FD", "Value": [0.0, -140.5, -801.5]}, "486": {"vr": "FD", "Value": [0.0, -140.5, -803.5]}, "487": {"vr": "FD", "Value": [0.0, -140.5, -805.5]}, "488": {"vr": "FD", "Value": [0.0, -140.5, -807.5]}, "489": {"vr": "FD", "Value": [0.0, -140.5, -809.5]}, "490": {"vr": "FD", "Value": [0.0, -140.5, -811.5]}, "491": {"vr": "FD", "Value": [0.0, -140.5, -813.5]}, "492": {"vr": "FD", "Value": [0.0, -140.5, -815.5]}, "493": {"vr": "FD", "Value": [0.0, -140.5, -817.5]}, "494": {"vr": "FD", "Value": [0.0, -140.5, -819.5]}, "495": {"vr": "FD", "Value": [0.0, -140.5, -821.5]}, "496": {"vr": "FD", "Value": [0.0, -140.5, -823.5]}, "497": {"vr": "FD", "Value": [0.0, -140.5, -825.5]}, "498": {"vr": "FD", "Value": [0.0, -140.5, -827.5]}, "499": {"vr": "FD", "Value": [0.0, -140.5, -829.5]}, "500": {"vr": "FD", "Value": [0.0, -140.5, -831.5]}, "501": {"vr": "FD", "Value": [0.0, -140.5, -833.5]}, "502": {"vr": "FD", "Value": [0.0, -140.5, -835.5]}, "503": {"vr": "FD", "Value": [0.0, -140.5, -837.5]}, "504": {"vr": "FD", "Value": [0.0, -140.5, -839.5]}, "505": {"vr": "FD", "Value": [0.0, -140.5, -841.5]}, "506": {"vr": "FD", "Value": [0.0, -140.5, -843.5]}, "507": {"vr": "FD", "Value": [0.0, -140.5, -845.5]}, "508": {"vr": "FD", "Value": [0.0, -140.5, -847.5]}, "509": {"vr": "FD", "Value": [0.0, -140.5, -849.5]}, "510": {"vr": "FD", "Value": [0.0, -140.5, -851.5]}, "511": {"vr": "FD", "Value": [0.0, -140.5, -853.5]}, "512": {"vr": "FD", "Value": [0.0, -140.5, -855.5]}, "513": {"vr": "FD", "Value": [0.0, -140.5, -857.5]}, "514": {"vr": "FD", "Value": [0.0, -140.5, -859.5]}, "515": {"vr": "FD", "Value": [0.0, -140.5, -861.5]}, "516": {"vr": "FD", "Value": [0.0, -140.5, -863.5]}, "517": {"vr": "FD", "Value": [0.0, -140.5, -865.5]}, "518": {"vr": "FD", "Value": [0.0, -140.5, -867.5]}, "519": {"vr": "FD", "Value": [0.0, -140.5, -869.5]}, "520": {"vr": "FD", "Value": [0.0, -140.5, -871.5]}, "521": {"vr": "FD", "Value": [0.0, -140.5, -873.5]}, "522": {"vr": "FD", "Value": [0.0, -140.5, -875.5]}, "523": {"vr": "FD", "Value": [0.0, -140.5, -877.5]}, "524": {"vr": "FD", "Value": [0.0, -140.5, -879.5]}, "525": {"vr": "FD", "Value": [0.0, -140.5, -881.5]}, "526": {"vr": "FD", "Value": [0.0, -140.5, -883.5]}, "527": {"vr": "FD", "Value": [0.0, -140.5, -885.5]}, "528": {"vr": "FD", "Value": [0.0, -140.5, -887.5]}, "529": {"vr": "FD", "Value": [0.0, -140.5, -889.5]}, "530": {"vr": "FD", "Value": [0.0, -140.5, -891.5]}}, "00189318": {"0": {"vr": "FD", "Value": [0.0, -140.5, 168.5]}, "1": {"vr": "FD", "Value": [0.0, -140.5, 166.5]}, "2": {"vr": "FD", "Value": [0.0, -140.5, 164.5]}, "3": {"vr": "FD", "Value": [0.0, -140.5, 162.5]}, "4": {"vr": "FD", "Value": [0.0, -140.5, 160.5]}, "5": {"vr": "FD", "Value": [0.0, -140.5, 158.5]}, "6": {"vr": "FD", "Value": [0.0, -140.5, 156.5]}, "7": {"vr": "FD", "Value": [0.0, -140.5, 154.5]}, "8": {"vr": "FD", "Value": [0.0, -140.5, 152.5]}, "9": {"vr": "FD", "Value": [0.0, -140.5, 150.5]}, "10": {"vr": "FD", "Value": [0.0, -140.5, 148.5]}, "11": {"vr": "FD", "Value": [0.0, -140.5, 146.5]}, "12": {"vr": "FD", "Value": [0.0, -140.5, 144.5]}, "13": {"vr": "FD", "Value": [0.0, -140.5, 142.5]}, "14": {"vr": "FD", "Value": [0.0, -140.5, 140.5]}, "15": {"vr": "FD", "Value": [0.0, -140.5, 138.5]}, "16": {"vr": "FD", "Value": [0.0, -140.5, 136.5]}, "17": {"vr": "FD", "Value": [0.0, -140.5, 134.5]}, "18": {"vr": "FD", "Value": [0.0, -140.5, 132.5]}, "19": {"vr": "FD", "Value": [0.0, -140.5, 130.5]}, "20": {"vr": "FD", "Value": [0.0, -140.5, 128.5]}, "21": {"vr": "FD", "Value": [0.0, -140.5, 126.5]}, "22": {"vr": "FD", "Value": [0.0, -140.5, 124.5]}, "23": {"vr": "FD", "Value": [0.0, -140.5, 122.5]}, "24": {"vr": "FD", "Value": [0.0, -140.5, 120.5]}, "25": {"vr": "FD", "Value": [0.0, -140.5, 118.5]}, "26": {"vr": "FD", "Value": [0.0, -140.5, 116.5]}, "27": {"vr": "FD", "Value": [0.0, -140.5, 114.5]}, "28": {"vr": "FD", "Value": [0.0, -140.5, 112.5]}, "29": {"vr": "FD", "Value": [0.0, -140.5, 110.5]}, "30": {"vr": "FD", "Value": [0.0, -140.5, 108.5]}, "31": {"vr": "FD", "Value": [0.0, -140.5, 106.5]}, "32": {"vr": "FD", "Value": [0.0, -140.5, 104.5]}, "33": {"vr": "FD", "Value": [0.0, -140.5, 102.5]}, "34": {"vr": "FD", "Value": [0.0, -140.5, 100.5]}, "35": {"vr": "FD", "Value": [0.0, -140.5, 98.5]}, "36": {"vr": "FD", "Value": [0.0, -140.5, 96.5]}, "37": {"vr": "FD", "Value": [0.0, -140.5, 94.5]}, "38": {"vr": "FD", "Value": [0.0, -140.5, 92.5]}, "39": {"vr": "FD", "Value": [0.0, -140.5, 90.5]}, "40": {"vr": "FD", "Value": [0.0, -140.5, 88.5]}, "41": {"vr": "FD", "Value": [0.0, -140.5, 86.5]}, "42": {"vr": "FD", "Value": [0.0, -140.5, 84.5]}, "43": {"vr": "FD", "Value": [0.0, -140.5, 82.5]}, "44": {"vr": "FD", "Value": [0.0, -140.5, 80.5]}, "45": {"vr": "FD", "Value": [0.0, -140.5, 78.5]}, "46": {"vr": "FD", "Value": [0.0, -140.5, 76.5]}, "47": {"vr": "FD", "Value": [0.0, -140.5, 74.5]}, "48": {"vr": "FD", "Value": [0.0, -140.5, 72.5]}, "49": {"vr": "FD", "Value": [0.0, -140.5, 70.5]}, "50": {"vr": "FD", "Value": [0.0, -140.5, 68.5]}, "51": {"vr": "FD", "Value": [0.0, -140.5, 66.5]}, "52": {"vr": "FD", "Value": [0.0, -140.5, 64.5]}, "53": {"vr": "FD", "Value": [0.0, -140.5, 62.5]}, "54": {"vr": "FD", "Value": [0.0, -140.5, 60.5]}, "55": {"vr": "FD", "Value": [0.0, -140.5, 58.5]}, "56": {"vr": "FD", "Value": [0.0, -140.5, 56.5]}, "57": {"vr": "FD", "Value": [0.0, -140.5, 54.5]}, "58": {"vr": "FD", "Value": [0.0, -140.5, 52.5]}, "59": {"vr": "FD", "Value": [0.0, -140.5, 50.5]}, "60": {"vr": "FD", "Value": [0.0, -140.5, 48.5]}, "61": {"vr": "FD", "Value": [0.0, -140.5, 46.5]}, "62": {"vr": "FD", "Value": [0.0, -140.5, 44.5]}, "63": {"vr": "FD", "Value": [0.0, -140.5, 42.5]}, "64": {"vr": "FD", "Value": [0.0, -140.5, 40.5]}, "65": {"vr": "FD", "Value": [0.0, -140.5, 38.5]}, "66": {"vr": "FD", "Value": [0.0, -140.5, 36.5]}, "67": {"vr": "FD", "Value": [0.0, -140.5, 34.5]}, "68": {"vr": "FD", "Value": [0.0, -140.5, 32.5]}, "69": {"vr": "FD", "Value": [0.0, -140.5, 30.5]}, "70": {"vr": "FD", "Value": [0.0, -140.5, 28.5]}, "71": {"vr": "FD", "Value": [0.0, -140.5, 26.5]}, "72": {"vr": "FD", "Value": [0.0, -140.5, 24.5]}, "73": {"vr": "FD", "Value": [0.0, -140.5, 22.5]}, "74": {"vr": "FD", "Value": [0.0, -140.5, 20.5]}, "75": {"vr": "FD", "Value": [0.0, -140.5, 18.5]}, "76": {"vr": "FD", "Value": [0.0, -140.5, 16.5]}, "77": {"vr": "FD", "Value": [0.0, -140.5, 14.5]}, "78": {"vr": "FD", "Value": [0.0, -140.5, 12.5]}, "79": {"vr": "FD", "Value": [0.0, -140.5, 10.5]}, "80": {"vr": "FD", "Value": [0.0, -140.5, 8.5]}, "81": {"vr": "FD", "Value": [0.0, -140.5, 6.5]}, "82": {"vr": "FD", "Value": [0.0, -140.5, 4.5]}, "83": {"vr": "FD", "Value": [0.0, -140.5, 2.5]}, "84": {"vr": "FD", "Value": [0.0, -140.5, 0.5]}, "85": {"vr": "FD", "Value": [0.0, -140.5, -1.5]}, "86": {"vr": "FD", "Value": [0.0, -140.5, -3.5]}, "87": {"vr": "FD", "Value": [0.0, -140.5, -5.5]}, "88": {"vr": "FD", "Value": [0.0, -140.5, -7.5]}, "89": {"vr": "FD", "Value": [0.0, -140.5, -9.5]}, "90": {"vr": "FD", "Value": [0.0, -140.5, -11.5]}, "91": {"vr": "FD", "Value": [0.0, -140.5, -13.5]}, "92": {"vr": "FD", "Value": [0.0, -140.5, -15.5]}, "93": {"vr": "FD", "Value": [0.0, -140.5, -17.5]}, "94": {"vr": "FD", "Value": [0.0, -140.5, -19.5]}, "95": {"vr": "FD", "Value": [0.0, -140.5, -21.5]}, "96": {"vr": "FD", "Value": [0.0, -140.5, -23.5]}, "97": {"vr": "FD", "Value": [0.0, -140.5, -25.5]}, "98": {"vr": "FD", "Value": [0.0, -140.5, -27.5]}, "99": {"vr": "FD", "Value": [0.0, -140.5, -29.5]}, "100": {"vr": "FD", "Value": [0.0, -140.5, -31.5]}, "101": {"vr": "FD", "Value": [0.0, -140.5, -33.5]}, "102": {"vr": "FD", "Value": [0.0, -140.5, -35.5]}, "103": {"vr": "FD", "Value": [0.0, -140.5, -37.5]}, "104": {"vr": "FD", "Value": [0.0, -140.5, -39.5]}, "105": {"vr": "FD", "Value": [0.0, -140.5, -41.5]}, "106": {"vr": "FD", "Value": [0.0, -140.5, -43.5]}, "107": {"vr": "FD", "Value": [0.0, -140.5, -45.5]}, "108": {"vr": "FD", "Value": [0.0, -140.5, -47.5]}, "109": {"vr": "FD", "Value": [0.0, -140.5, -49.5]}, "110": {"vr": "FD", "Value": [0.0, -140.5, -51.5]}, "111": {"vr": "FD", "Value": [0.0, -140.5, -53.5]}, "112": {"vr": "FD", "Value": [0.0, -140.5, -55.5]}, "113": {"vr": "FD", "Value": [0.0, -140.5, -57.5]}, "114": {"vr": "FD", "Value": [0.0, -140.5, -59.5]}, "115": {"vr": "FD", "Value": [0.0, -140.5, -61.5]}, "116": {"vr": "FD", "Value": [0.0, -140.5, -63.5]}, "117": {"vr": "FD", "Value": [0.0, -140.5, -65.5]}, "118": {"vr": "FD", "Value": [0.0, -140.5, -67.5]}, "119": {"vr": "FD", "Value": [0.0, -140.5, -69.5]}, "120": {"vr": "FD", "Value": [0.0, -140.5, -71.5]}, "121": {"vr": "FD", "Value": [0.0, -140.5, -73.5]}, "122": {"vr": "FD", "Value": [0.0, -140.5, -75.5]}, "123": {"vr": "FD", "Value": [0.0, -140.5, -77.5]}, "124": {"vr": "FD", "Value": [0.0, -140.5, -79.5]}, "125": {"vr": "FD", "Value": [0.0, -140.5, -81.5]}, "126": {"vr": "FD", "Value": [0.0, -140.5, -83.5]}, "127": {"vr": "FD", "Value": [0.0, -140.5, -85.5]}, "128": {"vr": "FD", "Value": [0.0, -140.5, -87.5]}, "129": {"vr": "FD", "Value": [0.0, -140.5, -89.5]}, "130": {"vr": "FD", "Value": [0.0, -140.5, -91.5]}, "131": {"vr": "FD", "Value": [0.0, -140.5, -93.5]}, "132": {"vr": "FD", "Value": [0.0, -140.5, -95.5]}, "133": {"vr": "FD", "Value": [0.0, -140.5, -97.5]}, "134": {"vr": "FD", "Value": [0.0, -140.5, -99.5]}, "135": {"vr": "FD", "Value": [0.0, -140.5, -101.5]}, "136": {"vr": "FD", "Value": [0.0, -140.5, -103.5]}, "137": {"vr": "FD", "Value": [0.0, -140.5, -105.5]}, "138": {"vr": "FD", "Value": [0.0, -140.5, -107.5]}, "139": {"vr": "FD", "Value": [0.0, -140.5, -109.5]}, "140": {"vr": "FD", "Value": [0.0, -140.5, -111.5]}, "141": {"vr": "FD", "Value": [0.0, -140.5, -113.5]}, "142": {"vr": "FD", "Value": [0.0, -140.5, -115.5]}, "143": {"vr": "FD", "Value": [0.0, -140.5, -117.5]}, "144": {"vr": "FD", "Value": [0.0, -140.5, -119.5]}, "145": {"vr": "FD", "Value": [0.0, -140.5, -121.5]}, "146": {"vr": "FD", "Value": [0.0, -140.5, -123.5]}, "147": {"vr": "FD", "Value": [0.0, -140.5, -125.5]}, "148": {"vr": "FD", "Value": [0.0, -140.5, -127.5]}, "149": {"vr": "FD", "Value": [0.0, -140.5, -129.5]}, "150": {"vr": "FD", "Value": [0.0, -140.5, -131.5]}, "151": {"vr": "FD", "Value": [0.0, -140.5, -133.5]}, "152": {"vr": "FD", "Value": [0.0, -140.5, -135.5]}, "153": {"vr": "FD", "Value": [0.0, -140.5, -137.5]}, "154": {"vr": "FD", "Value": [0.0, -140.5, -139.5]}, "155": {"vr": "FD", "Value": [0.0, -140.5, -141.5]}, "156": {"vr": "FD", "Value": [0.0, -140.5, -143.5]}, "157": {"vr": "FD", "Value": [0.0, -140.5, -145.5]}, "158": {"vr": "FD", "Value": [0.0, -140.5, -147.5]}, "159": {"vr": "FD", "Value": [0.0, -140.5, -149.5]}, "160": {"vr": "FD", "Value": [0.0, -140.5, -151.5]}, "161": {"vr": "FD", "Value": [0.0, -140.5, -153.5]}, "162": {"vr": "FD", "Value": [0.0, -140.5, -155.5]}, "163": {"vr": "FD", "Value": [0.0, -140.5, -157.5]}, "164": {"vr": "FD", "Value": [0.0, -140.5, -159.5]}, "165": {"vr": "FD", "Value": [0.0, -140.5, -161.5]}, "166": {"vr": "FD", "Value": [0.0, -140.5, -163.5]}, "167": {"vr": "FD", "Value": [0.0, -140.5, -165.5]}, "168": {"vr": "FD", "Value": [0.0, -140.5, -167.5]}, "169": {"vr": "FD", "Value": [0.0, -140.5, -169.5]}, "170": {"vr": "FD", "Value": [0.0, -140.5, -171.5]}, "171": {"vr": "FD", "Value": [0.0, -140.5, -173.5]}, "172": {"vr": "FD", "Value": [0.0, -140.5, -175.5]}, "173": {"vr": "FD", "Value": [0.0, -140.5, -177.5]}, "174": {"vr": "FD", "Value": [0.0, -140.5, -179.5]}, "175": {"vr": "FD", "Value": [0.0, -140.5, -181.5]}, "176": {"vr": "FD", "Value": [0.0, -140.5, -183.5]}, "177": {"vr": "FD", "Value": [0.0, -140.5, -185.5]}, "178": {"vr": "FD", "Value": [0.0, -140.5, -187.5]}, "179": {"vr": "FD", "Value": [0.0, -140.5, -189.5]}, "180": {"vr": "FD", "Value": [0.0, -140.5, -191.5]}, "181": {"vr": "FD", "Value": [0.0, -140.5, -193.5]}, "182": {"vr": "FD", "Value": [0.0, -140.5, -195.5]}, "183": {"vr": "FD", "Value": [0.0, -140.5, -197.5]}, "184": {"vr": "FD", "Value": [0.0, -140.5, -199.5]}, "185": {"vr": "FD", "Value": [0.0, -140.5, -201.5]}, "186": {"vr": "FD", "Value": [0.0, -140.5, -203.5]}, "187": {"vr": "FD", "Value": [0.0, -140.5, -205.5]}, "188": {"vr": "FD", "Value": [0.0, -140.5, -207.5]}, "189": {"vr": "FD", "Value": [0.0, -140.5, -209.5]}, "190": {"vr": "FD", "Value": [0.0, -140.5, -211.5]}, "191": {"vr": "FD", "Value": [0.0, -140.5, -213.5]}, "192": {"vr": "FD", "Value": [0.0, -140.5, -215.5]}, "193": {"vr": "FD", "Value": [0.0, -140.5, -217.5]}, "194": {"vr": "FD", "Value": [0.0, -140.5, -219.5]}, "195": {"vr": "FD", "Value": [0.0, -140.5, -221.5]}, "196": {"vr": "FD", "Value": [0.0, -140.5, -223.5]}, "197": {"vr": "FD", "Value": [0.0, -140.5, -225.5]}, "198": {"vr": "FD", "Value": [0.0, -140.5, -227.5]}, "199": {"vr": "FD", "Value": [0.0, -140.5, -229.5]}, "200": {"vr": "FD", "Value": [0.0, -140.5, -231.5]}, "201": {"vr": "FD", "Value": [0.0, -140.5, -233.5]}, "202": {"vr": "FD", "Value": [0.0, -140.5, -235.5]}, "203": {"vr": "FD", "Value": [0.0, -140.5, -237.5]}, "204": {"vr": "FD", "Value": [0.0, -140.5, -239.5]}, "205": {"vr": "FD", "Value": [0.0, -140.5, -241.5]}, "206": {"vr": "FD", "Value": [0.0, -140.5, -243.5]}, "207": {"vr": "FD", "Value": [0.0, -140.5, -245.5]}, "208": {"vr": "FD", "Value": [0.0, -140.5, -247.5]}, "209": {"vr": "FD", "Value": [0.0, -140.5, -249.5]}, "210": {"vr": "FD", "Value": [0.0, -140.5, -251.5]}, "211": {"vr": "FD", "Value": [0.0, -140.5, -253.5]}, "212": {"vr": "FD", "Value": [0.0, -140.5, -255.5]}, "213": {"vr": "FD", "Value": [0.0, -140.5, -257.5]}, "214": {"vr": "FD", "Value": [0.0, -140.5, -259.5]}, "215": {"vr": "FD", "Value": [0.0, -140.5, -261.5]}, "216": {"vr": "FD", "Value": [0.0, -140.5, -263.5]}, "217": {"vr": "FD", "Value": [0.0, -140.5, -265.5]}, "218": {"vr": "FD", "Value": [0.0, -140.5, -267.5]}, "219": {"vr": "FD", "Value": [0.0, -140.5, -269.5]}, "220": {"vr": "FD", "Value": [0.0, -140.5, -271.5]}, "221": {"vr": "FD", "Value": [0.0, -140.5, -273.5]}, "222": {"vr": "FD", "Value": [0.0, -140.5, -275.5]}, "223": {"vr": "FD", "Value": [0.0, -140.5, -277.5]}, "224": {"vr": "FD", "Value": [0.0, -140.5, -279.5]}, "225": {"vr": "FD", "Value": [0.0, -140.5, -281.5]}, "226": {"vr": "FD", "Value": [0.0, -140.5, -283.5]}, "227": {"vr": "FD", "Value": [0.0, -140.5, -285.5]}, "228": {"vr": "FD", "Value": [0.0, -140.5, -287.5]}, "229": {"vr": "FD", "Value": [0.0, -140.5, -289.5]}, "230": {"vr": "FD", "Value": [0.0, -140.5, -291.5]}, "231": {"vr": "FD", "Value": [0.0, -140.5, -293.5]}, "232": {"vr": "FD", "Value": [0.0, -140.5, -295.5]}, "233": {"vr": "FD", "Value": [0.0, -140.5, -297.5]}, "234": {"vr": "FD", "Value": [0.0, -140.5, -299.5]}, "235": {"vr": "FD", "Value": [0.0, -140.5, -301.5]}, "236": {"vr": "FD", "Value": [0.0, -140.5, -303.5]}, "237": {"vr": "FD", "Value": [0.0, -140.5, -305.5]}, "238": {"vr": "FD", "Value": [0.0, -140.5, -307.5]}, "239": {"vr": "FD", "Value": [0.0, -140.5, -309.5]}, "240": {"vr": "FD", "Value": [0.0, -140.5, -311.5]}, "241": {"vr": "FD", "Value": [0.0, -140.5, -313.5]}, "242": {"vr": "FD", "Value": [0.0, -140.5, -315.5]}, "243": {"vr": "FD", "Value": [0.0, -140.5, -317.5]}, "244": {"vr": "FD", "Value": [0.0, -140.5, -319.5]}, "245": {"vr": "FD", "Value": [0.0, -140.5, -321.5]}, "246": {"vr": "FD", "Value": [0.0, -140.5, -323.5]}, "247": {"vr": "FD", "Value": [0.0, -140.5, -325.5]}, "248": {"vr": "FD", "Value": [0.0, -140.5, -327.5]}, "249": {"vr": "FD", "Value": [0.0, -140.5, -329.5]}, "250": {"vr": "FD", "Value": [0.0, -140.5, -331.5]}, "251": {"vr": "FD", "Value": [0.0, -140.5, -333.5]}, "252": {"vr": "FD", "Value": [0.0, -140.5, -335.5]}, "253": {"vr": "FD", "Value": [0.0, -140.5, -337.5]}, "254": {"vr": "FD", "Value": [0.0, -140.5, -339.5]}, "255": {"vr": "FD", "Value": [0.0, -140.5, -341.5]}, "256": {"vr": "FD", "Value": [0.0, -140.5, -343.5]}, "257": {"vr": "FD", "Value": [0.0, -140.5, -345.5]}, "258": {"vr": "FD", "Value": [0.0, -140.5, -347.5]}, "259": {"vr": "FD", "Value": [0.0, -140.5, -349.5]}, "260": {"vr": "FD", "Value": [0.0, -140.5, -351.5]}, "261": {"vr": "FD", "Value": [0.0, -140.5, -353.5]}, "262": {"vr": "FD", "Value": [0.0, -140.5, -355.5]}, "263": {"vr": "FD", "Value": [0.0, -140.5, -357.5]}, "264": {"vr": "FD", "Value": [0.0, -140.5, -359.5]}, "265": {"vr": "FD", "Value": [0.0, -140.5, -361.5]}, "266": {"vr": "FD", "Value": [0.0, -140.5, -363.5]}, "267": {"vr": "FD", "Value": [0.0, -140.5, -365.5]}, "268": {"vr": "FD", "Value": [0.0, -140.5, -367.5]}, "269": {"vr": "FD", "Value": [0.0, -140.5, -369.5]}, "270": {"vr": "FD", "Value": [0.0, -140.5, -371.5]}, "271": {"vr": "FD", "Value": [0.0, -140.5, -373.5]}, "272": {"vr": "FD", "Value": [0.0, -140.5, -375.5]}, "273": {"vr": "FD", "Value": [0.0, -140.5, -377.5]}, "274": {"vr": "FD", "Value": [0.0, -140.5, -379.5]}, "275": {"vr": "FD", "Value": [0.0, -140.5, -381.5]}, "276": {"vr": "FD", "Value": [0.0, -140.5, -383.5]}, "277": {"vr": "FD", "Value": [0.0, -140.5, -385.5]}, "278": {"vr": "FD", "Value": [0.0, -140.5, -387.5]}, "279": {"vr": "FD", "Value": [0.0, -140.5, -389.5]}, "280": {"vr": "FD", "Value": [0.0, -140.5, -391.5]}, "281": {"vr": "FD", "Value": [0.0, -140.5, -393.5]}, "282": {"vr": "FD", "Value": [0.0, -140.5, -395.5]}, "283": {"vr": "FD", "Value": [0.0, -140.5, -397.5]}, "284": {"vr": "FD", "Value": [0.0, -140.5, -399.5]}, "285": {"vr": "FD", "Value": [0.0, -140.5, -401.5]}, "286": {"vr": "FD", "Value": [0.0, -140.5, -403.5]}, "287": {"vr": "FD", "Value": [0.0, -140.5, -405.5]}, "288": {"vr": "FD", "Value": [0.0, -140.5, -407.5]}, "289": {"vr": "FD", "Value": [0.0, -140.5, -409.5]}, "290": {"vr": "FD", "Value": [0.0, -140.5, -411.5]}, "291": {"vr": "FD", "Value": [0.0, -140.5, -413.5]}, "292": {"vr": "FD", "Value": [0.0, -140.5, -415.5]}, "293": {"vr": "FD", "Value": [0.0, -140.5, -417.5]}, "294": {"vr": "FD", "Value": [0.0, -140.5, -419.5]}, "295": {"vr": "FD", "Value": [0.0, -140.5, -421.5]}, "296": {"vr": "FD", "Value": [0.0, -140.5, -423.5]}, "297": {"vr": "FD", "Value": [0.0, -140.5, -425.5]}, "298": {"vr": "FD", "Value": [0.0, -140.5, -427.5]}, "299": {"vr": "FD", "Value": [0.0, -140.5, -429.5]}, "300": {"vr": "FD", "Value": [0.0, -140.5, -431.5]}, "301": {"vr": "FD", "Value": [0.0, -140.5, -433.5]}, "302": {"vr": "FD", "Value": [0.0, -140.5, -435.5]}, "303": {"vr": "FD", "Value": [0.0, -140.5, -437.5]}, "304": {"vr": "FD", "Value": [0.0, -140.5, -439.5]}, "305": {"vr": "FD", "Value": [0.0, -140.5, -441.5]}, "306": {"vr": "FD", "Value": [0.0, -140.5, -443.5]}, "307": {"vr": "FD", "Value": [0.0, -140.5, -445.5]}, "308": {"vr": "FD", "Value": [0.0, -140.5, -447.5]}, "309": {"vr": "FD", "Value": [0.0, -140.5, -449.5]}, "310": {"vr": "FD", "Value": [0.0, -140.5, -451.5]}, "311": {"vr": "FD", "Value": [0.0, -140.5, -453.5]}, "312": {"vr": "FD", "Value": [0.0, -140.5, -455.5]}, "313": {"vr": "FD", "Value": [0.0, -140.5, -457.5]}, "314": {"vr": "FD", "Value": [0.0, -140.5, -459.5]}, "315": {"vr": "FD", "Value": [0.0, -140.5, -461.5]}, "316": {"vr": "FD", "Value": [0.0, -140.5, -463.5]}, "317": {"vr": "FD", "Value": [0.0, -140.5, -465.5]}, "318": {"vr": "FD", "Value": [0.0, -140.5, -467.5]}, "319": {"vr": "FD", "Value": [0.0, -140.5, -469.5]}, "320": {"vr": "FD", "Value": [0.0, -140.5, -471.5]}, "321": {"vr": "FD", "Value": [0.0, -140.5, -473.5]}, "322": {"vr": "FD", "Value": [0.0, -140.5, -475.5]}, "323": {"vr": "FD", "Value": [0.0, -140.5, -477.5]}, "324": {"vr": "FD", "Value": [0.0, -140.5, -479.5]}, "325": {"vr": "FD", "Value": [0.0, -140.5, -481.5]}, "326": {"vr": "FD", "Value": [0.0, -140.5, -483.5]}, "327": {"vr": "FD", "Value": [0.0, -140.5, -485.5]}, "328": {"vr": "FD", "Value": [0.0, -140.5, -487.5]}, "329": {"vr": "FD", "Value": [0.0, -140.5, -489.5]}, "330": {"vr": "FD", "Value": [0.0, -140.5, -491.5]}, "331": {"vr": "FD", "Value": [0.0, -140.5, -493.5]}, "332": {"vr": "FD", "Value": [0.0, -140.5, -495.5]}, "333": {"vr": "FD", "Value": [0.0, -140.5, -497.5]}, "334": {"vr": "FD", "Value": [0.0, -140.5, -499.5]}, "335": {"vr": "FD", "Value": [0.0, -140.5, -501.5]}, "336": {"vr": "FD", "Value": [0.0, -140.5, -503.5]}, "337": {"vr": "FD", "Value": [0.0, -140.5, -505.5]}, "338": {"vr": "FD", "Value": [0.0, -140.5, -507.5]}, "339": {"vr": "FD", "Value": [0.0, -140.5, -509.5]}, "340": {"vr": "FD", "Value": [0.0, -140.5, -511.5]}, "341": {"vr": "FD", "Value": [0.0, -140.5, -513.5]}, "342": {"vr": "FD", "Value": [0.0, -140.5, -515.5]}, "343": {"vr": "FD", "Value": [0.0, -140.5, -517.5]}, "344": {"vr": "FD", "Value": [0.0, -140.5, -519.5]}, "345": {"vr": "FD", "Value": [0.0, -140.5, -521.5]}, "346": {"vr": "FD", "Value": [0.0, -140.5, -523.5]}, "347": {"vr": "FD", "Value": [0.0, -140.5, -525.5]}, "348": {"vr": "FD", "Value": [0.0, -140.5, -527.5]}, "349": {"vr": "FD", "Value": [0.0, -140.5, -529.5]}, "350": {"vr": "FD", "Value": [0.0, -140.5, -531.5]}, "351": {"vr": "FD", "Value": [0.0, -140.5, -533.5]}, "352": {"vr": "FD", "Value": [0.0, -140.5, -535.5]}, "353": {"vr": "FD", "Value": [0.0, -140.5, -537.5]}, "354": {"vr": "FD", "Value": [0.0, -140.5, -539.5]}, "355": {"vr": "FD", "Value": [0.0, -140.5, -541.5]}, "356": {"vr": "FD", "Value": [0.0, -140.5, -543.5]}, "357": {"vr": "FD", "Value": [0.0, -140.5, -545.5]}, "358": {"vr": "FD", "Value": [0.0, -140.5, -547.5]}, "359": {"vr": "FD", "Value": [0.0, -140.5, -549.5]}, "360": {"vr": "FD", "Value": [0.0, -140.5, -551.5]}, "361": {"vr": "FD", "Value": [0.0, -140.5, -553.5]}, "362": {"vr": "FD", "Value": [0.0, -140.5, -555.5]}, "363": {"vr": "FD", "Value": [0.0, -140.5, -557.5]}, "364": {"vr": "FD", "Value": [0.0, -140.5, -559.5]}, "365": {"vr": "FD", "Value": [0.0, -140.5, -561.5]}, "366": {"vr": "FD", "Value": [0.0, -140.5, -563.5]}, "367": {"vr": "FD", "Value": [0.0, -140.5, -565.5]}, "368": {"vr": "FD", "Value": [0.0, -140.5, -567.5]}, "369": {"vr": "FD", "Value": [0.0, -140.5, -569.5]}, "370": {"vr": "FD", "Value": [0.0, -140.5, -571.5]}, "371": {"vr": "FD", "Value": [0.0, -140.5, -573.5]}, "372": {"vr": "FD", "Value": [0.0, -140.5, -575.5]}, "373": {"vr": "FD", "Value": [0.0, -140.5, -577.5]}, "374": {"vr": "FD", "Value": [0.0, -140.5, -579.5]}, "375": {"vr": "FD", "Value": [0.0, -140.5, -581.5]}, "376": {"vr": "FD", "Value": [0.0, -140.5, -583.5]}, "377": {"vr": "FD", "Value": [0.0, -140.5, -585.5]}, "378": {"vr": "FD", "Value": [0.0, -140.5, -587.5]}, "379": {"vr": "FD", "Value": [0.0, -140.5, -589.5]}, "380": {"vr": "FD", "Value": [0.0, -140.5, -591.5]}, "381": {"vr": "FD", "Value": [0.0, -140.5, -593.5]}, "382": {"vr": "FD", "Value": [0.0, -140.5, -595.5]}, "383": {"vr": "FD", "Value": [0.0, -140.5, -597.5]}, "384": {"vr": "FD", "Value": [0.0, -140.5, -599.5]}, "385": {"vr": "FD", "Value": [0.0, -140.5, -601.5]}, "386": {"vr": "FD", "Value": [0.0, -140.5, -603.5]}, "387": {"vr": "FD", "Value": [0.0, -140.5, -605.5]}, "388": {"vr": "FD", "Value": [0.0, -140.5, -607.5]}, "389": {"vr": "FD", "Value": [0.0, -140.5, -609.5]}, "390": {"vr": "FD", "Value": [0.0, -140.5, -611.5]}, "391": {"vr": "FD", "Value": [0.0, -140.5, -613.5]}, "392": {"vr": "FD", "Value": [0.0, -140.5, -615.5]}, "393": {"vr": "FD", "Value": [0.0, -140.5, -617.5]}, "394": {"vr": "FD", "Value": [0.0, -140.5, -619.5]}, "395": {"vr": "FD", "Value": [0.0, -140.5, -621.5]}, "396": {"vr": "FD", "Value": [0.0, -140.5, -623.5]}, "397": {"vr": "FD", "Value": [0.0, -140.5, -625.5]}, "398": {"vr": "FD", "Value": [0.0, -140.5, -627.5]}, "399": {"vr": "FD", "Value": [0.0, -140.5, -629.5]}, "400": {"vr": "FD", "Value": [0.0, -140.5, -631.5]}, "401": {"vr": "FD", "Value": [0.0, -140.5, -633.5]}, "402": {"vr": "FD", "Value": [0.0, -140.5, -635.5]}, "403": {"vr": "FD", "Value": [0.0, -140.5, -637.5]}, "404": {"vr": "FD", "Value": [0.0, -140.5, -639.5]}, "405": {"vr": "FD", "Value": [0.0, -140.5, -641.5]}, "406": {"vr": "FD", "Value": [0.0, -140.5, -643.5]}, "407": {"vr": "FD", "Value": [0.0, -140.5, -645.5]}, "408": {"vr": "FD", "Value": [0.0, -140.5, -647.5]}, "409": {"vr": "FD", "Value": [0.0, -140.5, -649.5]}, "410": {"vr": "FD", "Value": [0.0, -140.5, -651.5]}, "411": {"vr": "FD", "Value": [0.0, -140.5, -653.5]}, "412": {"vr": "FD", "Value": [0.0, -140.5, -655.5]}, "413": {"vr": "FD", "Value": [0.0, -140.5, -657.5]}, "414": {"vr": "FD", "Value": [0.0, -140.5, -659.5]}, "415": {"vr": "FD", "Value": [0.0, -140.5, -661.5]}, "416": {"vr": "FD", "Value": [0.0, -140.5, -663.5]}, "417": {"vr": "FD", "Value": [0.0, -140.5, -665.5]}, "418": {"vr": "FD", "Value": [0.0, -140.5, -667.5]}, "419": {"vr": "FD", "Value": [0.0, -140.5, -669.5]}, "420": {"vr": "FD", "Value": [0.0, -140.5, -671.5]}, "421": {"vr": "FD", "Value": [0.0, -140.5, -673.5]}, "422": {"vr": "FD", "Value": [0.0, -140.5, -675.5]}, "423": {"vr": "FD", "Value": [0.0, -140.5, -677.5]}, "424": {"vr": "FD", "Value": [0.0, -140.5, -679.5]}, "425": {"vr": "FD", "Value": [0.0, -140.5, -681.5]}, "426": {"vr": "FD", "Value": [0.0, -140.5, -683.5]}, "427": {"vr": "FD", "Value": [0.0, -140.5, -685.5]}, "428": {"vr": "FD", "Value": [0.0, -140.5, -687.5]}, "429": {"vr": "FD", "Value": [0.0, -140.5, -689.5]}, "430": {"vr": "FD", "Value": [0.0, -140.5, -691.5]}, "431": {"vr": "FD", "Value": [0.0, -140.5, -693.5]}, "432": {"vr": "FD", "Value": [0.0, -140.5, -695.5]}, "433": {"vr": "FD", "Value": [0.0, -140.5, -697.5]}, "434": {"vr": "FD", "Value": [0.0, -140.5, -699.5]}, "435": {"vr": "FD", "Value": [0.0, -140.5, -701.5]}, "436": {"vr": "FD", "Value": [0.0, -140.5, -703.5]}, "437": {"vr": "FD", "Value": [0.0, -140.5, -705.5]}, "438": {"vr": "FD", "Value": [0.0, -140.5, -707.5]}, "439": {"vr": "FD", "Value": [0.0, -140.5, -709.5]}, "440": {"vr": "FD", "Value": [0.0, -140.5, -711.5]}, "441": {"vr": "FD", "Value": [0.0, -140.5, -713.5]}, "442": {"vr": "FD", "Value": [0.0, -140.5, -715.5]}, "443": {"vr": "FD", "Value": [0.0, -140.5, -717.5]}, "444": {"vr": "FD", "Value": [0.0, -140.5, -719.5]}, "445": {"vr": "FD", "Value": [0.0, -140.5, -721.5]}, "446": {"vr": "FD", "Value": [0.0, -140.5, -723.5]}, "447": {"vr": "FD", "Value": [0.0, -140.5, -725.5]}, "448": {"vr": "FD", "Value": [0.0, -140.5, -727.5]}, "449": {"vr": "FD", "Value": [0.0, -140.5, -729.5]}, "450": {"vr": "FD", "Value": [0.0, -140.5, -731.5]}, "451": {"vr": "FD", "Value": [0.0, -140.5, -733.5]}, "452": {"vr": "FD", "Value": [0.0, -140.5, -735.5]}, "453": {"vr": "FD", "Value": [0.0, -140.5, -737.5]}, "454": {"vr": "FD", "Value": [0.0, -140.5, -739.5]}, "455": {"vr": "FD", "Value": [0.0, -140.5, -741.5]}, "456": {"vr": "FD", "Value": [0.0, -140.5, -743.5]}, "457": {"vr": "FD", "Value": [0.0, -140.5, -745.5]}, "458": {"vr": "FD", "Value": [0.0, -140.5, -747.5]}, "459": {"vr": "FD", "Value": [0.0, -140.5, -749.5]}, "460": {"vr": "FD", "Value": [0.0, -140.5, -751.5]}, "461": {"vr": "FD", "Value": [0.0, -140.5, -753.5]}, "462": {"vr": "FD", "Value": [0.0, -140.5, -755.5]}, "463": {"vr": "FD", "Value": [0.0, -140.5, -757.5]}, "464": {"vr": "FD", "Value": [0.0, -140.5, -759.5]}, "465": {"vr": "FD", "Value": [0.0, -140.5, -761.5]}, "466": {"vr": "FD", "Value": [0.0, -140.5, -763.5]}, "467": {"vr": "FD", "Value": [0.0, -140.5, -765.5]}, "468": {"vr": "FD", "Value": [0.0, -140.5, -767.5]}, "469": {"vr": "FD", "Value": [0.0, -140.5, -769.5]}, "470": {"vr": "FD", "Value": [0.0, -140.5, -771.5]}, "471": {"vr": "FD", "Value": [0.0, -140.5, -773.5]}, "472": {"vr": "FD", "Value": [0.0, -140.5, -775.5]}, "473": {"vr": "FD", "Value": [0.0, -140.5, -777.5]}, "474": {"vr": "FD", "Value": [0.0, -140.5, -779.5]}, "475": {"vr": "FD", "Value": [0.0, -140.5, -781.5]}, "476": {"vr": "FD", "Value": [0.0, -140.5, -783.5]}, "477": {"vr": "FD", "Value": [0.0, -140.5, -785.5]}, "478": {"vr": "FD", "Value": [0.0, -140.5, -787.5]}, "479": {"vr": "FD", "Value": [0.0, -140.5, -789.5]}, "480": {"vr": "FD", "Value": [0.0, -140.5, -791.5]}, "481": {"vr": "FD", "Value": [0.0, -140.5, -793.5]}, "482": {"vr": "FD", "Value": [0.0, -140.5, -795.5]}, "483": {"vr": "FD", "Value": [0.0, -140.5, -797.5]}, "484": {"vr": "FD", "Value": [0.0, -140.5, -799.5]}, "485": {"vr": "FD", "Value": [0.0, -140.5, -801.5]}, "486": {"vr": "FD", "Value": [0.0, -140.5, -803.5]}, "487": {"vr": "FD", "Value": [0.0, -140.5, -805.5]}, "488": {"vr": "FD", "Value": [0.0, -140.5, -807.5]}, "489": {"vr": "FD", "Value": [0.0, -140.5, -809.5]}, "490": {"vr": "FD", "Value": [0.0, -140.5, -811.5]}, "491": {"vr": "FD", "Value": [0.0, -140.5, -813.5]}, "492": {"vr": "FD", "Value": [0.0, -140.5, -815.5]}, "493": {"vr": "FD", "Value": [0.0, -140.5, -817.5]}, "494": {"vr": "FD", "Value": [0.0, -140.5, -819.5]}, "495": {"vr": "FD", "Value": [0.0, -140.5, -821.5]}, "496": {"vr": "FD", "Value": [0.0, -140.5, -823.5]}, "497": {"vr": "FD", "Value": [0.0, -140.5, -825.5]}, "498": {"vr": "FD", "Value": [0.0, -140.5, -827.5]}, "499": {"vr": "FD", "Value": [0.0, -140.5, -829.5]}, "500": {"vr": "FD", "Value": [0.0, -140.5, -831.5]}, "501": {"vr": "FD", "Value": [0.0, -140.5, -833.5]}, "502": {"vr": "FD", "Value": [0.0, -140.5, -835.5]}, "503": {"vr": "FD", "Value": [0.0, -140.5, -837.5]}, "504": {"vr": "FD", "Value": [0.0, -140.5, -839.5]}, "505": {"vr": "FD", "Value": [0.0, -140.5, -841.5]}, "506": {"vr": "FD", "Value": [0.0, -140.5, -843.5]}, "507": {"vr": "FD", "Value": [0.0, -140.5, -845.5]}, "508": {"vr": "FD", "Value": [0.0, -140.5, -847.5]}, "509": {"vr": "FD", "Value": [0.0, -140.5, -849.5]}, "510": {"vr": "FD", "Value": [0.0, -140.5, -851.5]}, "511": {"vr": "FD", "Value": [0.0, -140.5, -853.5]}, "512": {"vr": "FD", "Value": [0.0, -140.5, -855.5]}, "513": {"vr": "FD", "Value": [0.0, -140.5, -857.5]}, "514": {"vr": "FD", "Value": [0.0, -140.5, -859.5]}, "515": {"vr": "FD", "Value": [0.0, -140.5, -861.5]}, "516": {"vr": "FD", "Value": [0.0, -140.5, -863.5]}, "517": {"vr": "FD", "Value": [0.0, -140.5, -865.5]}, "518": {"vr": "FD", "Value": [0.0, -140.5, -867.5]}, "519": {"vr": "FD", "Value": [0.0, -140.5, -869.5]}, "520": {"vr": "FD", "Value": [0.0, -140.5, -871.5]}, "521": {"vr": "FD", "Value": [0.0, -140.5, -873.5]}, "522": {"vr": "FD", "Value": [0.0, -140.5, -875.5]}, "523": {"vr": "FD", "Value": [0.0, -140.5, -877.5]}, "524": {"vr": "FD", "Value": [0.0, -140.5, -879.5]}, "525": {"vr": "FD", "Value": [0.0, -140.5, -881.5]}, "526": {"vr": "FD", "Value": [0.0, -140.5, -883.5]}, "527": {"vr": "FD", "Value": [0.0, -140.5, -885.5]}, "528": {"vr": "FD", "Value": [0.0, -140.5, -887.5]}, "529": {"vr": "FD", "Value": [0.0, -140.5, -889.5]}, "530": {"vr": "FD", "Value": [0.0, -140.5, -891.5]}}, "00189345": {"0": {"vr": "FD", "Value": [0.8003272338762214]}, "1": {"vr": "FD", "Value": [0.8003272338762214]}, "2": {"vr": "FD", "Value": [0.8003272338762214]}, "3": {"vr": "FD", "Value": [0.8003272338762214]}, "4": {"vr": "FD", "Value": [0.8003272338762214]}, "5": {"vr": "FD", "Value": [0.8003272338762214]}, "6": {"vr": "FD", "Value": [0.8003272338762214]}, "7": {"vr": "FD", "Value": [0.8003272338762214]}, "8": {"vr": "FD", "Value": [0.8003272338762214]}, "9": {"vr": "FD", "Value": [0.8003272338762214]}, "10": {"vr": "FD", "Value": [0.8003272338762214]}, "11": {"vr": "FD", "Value": [0.8003272338762214]}, "12": {"vr": "FD", "Value": [0.8003272338762214]}, "13": {"vr": "FD", "Value": [0.8003272338762214]}, "14": {"vr": "FD", "Value": [0.8003272338762214]}, "15": {"vr": "FD", "Value": [0.8003272338762214]}, "16": {"vr": "FD", "Value": [0.8003272338762214]}, "17": {"vr": "FD", "Value": [0.8003272338762214]}, "18": {"vr": "FD", "Value": [0.8003272338762214]}, "19": {"vr": "FD", "Value": [0.8424497198697068]}, "20": {"vr": "FD", "Value": [0.8424497198697068]}, "21": {"vr": "FD", "Value": [0.8424497198697068]}, "22": {"vr": "FD", "Value": [0.8424497198697068]}, "23": {"vr": "FD", "Value": [0.8424497198697068]}, "24": {"vr": "FD", "Value": [0.8424497198697068]}, "25": {"vr": "FD", "Value": [0.8424497198697068]}, "26": {"vr": "FD", "Value": [0.8424497198697068]}, "27": {"vr": "FD", "Value": [0.8424497198697068]}, "28": {"vr": "FD", "Value": [0.8424497198697068]}, "29": {"vr": "FD", "Value": [0.8424497198697068]}, "30": {"vr": "FD", "Value": [0.8424497198697068]}, "31": {"vr": "FD", "Value": [0.8424497198697068]}, "32": {"vr": "FD", "Value": [0.8424497198697068]}, "33": {"vr": "FD", "Value": [0.8424497198697068]}, "34": {"vr": "FD", "Value": [0.8424497198697068]}, "35": {"vr": "FD", "Value": [0.8424497198697068]}, "36": {"vr": "FD", "Value": [0.8424497198697068]}, "37": {"vr": "FD", "Value": [0.8424497198697068]}, "38": {"vr": "FD", "Value": [0.8424497198697068]}, "39": {"vr": "FD", "Value": [0.8424497198697068]}, "40": {"vr": "FD", "Value": [0.8424497198697068]}, "41": {"vr": "FD", "Value": [0.8424497198697068]}, "42": {"vr": "FD", "Value": [0.8424497198697068]}, "43": {"vr": "FD", "Value": [0.8424497198697068]}, "44": {"vr": "FD", "Value": [0.8424497198697068]}, "45": {"vr": "FD", "Value": [0.8424497198697068]}, "46": {"vr": "FD", "Value": [0.8424497198697068]}, "47": {"vr": "FD", "Value": [0.8424497198697068]}, "48": {"vr": "FD", "Value": [0.8424497198697068]}, "49": {"vr": "FD", "Value": [0.8424497198697068]}, "50": {"vr": "FD", "Value": [0.8424497198697068]}, "51": {"vr": "FD", "Value": [0.8424497198697068]}, "52": {"vr": "FD", "Value": [0.8424497198697068]}, "53": {"vr": "FD", "Value": [0.8424497198697068]}, "54": {"vr": "FD", "Value": [0.8424497198697068]}, "55": {"vr": "FD", "Value": [0.8424497198697068]}, "56": {"vr": "FD", "Value": [0.8845722058631921]}, "57": {"vr": "FD", "Value": [0.9266946918566774]}, "58": {"vr": "FD", "Value": [0.9688171778501629]}, "59": {"vr": "FD", "Value": [1.010939663843648]}, "60": {"vr": "FD", "Value": [1.0530621498371333]}, "61": {"vr": "FD", "Value": [1.095184635830619]}, "62": {"vr": "FD", "Value": [1.1373071218241042]}, "63": {"vr": "FD", "Value": [1.1794296078175894]}, "64": {"vr": "FD", "Value": [1.2215520938110749]}, "65": {"vr": "FD", "Value": [1.2636745798045603]}, "66": {"vr": "FD", "Value": [1.3057970657980456]}, "67": {"vr": "FD", "Value": [1.347919551791531]}, "68": {"vr": "FD", "Value": [1.3900420377850162]}, "69": {"vr": "FD", "Value": [1.3900420377850162]}, "70": {"vr": "FD", "Value": [1.4321645237785015]}, "71": {"vr": "FD", "Value": [1.4321645237785015]}, "72": {"vr": "FD", "Value": [1.474287009771987]}, "73": {"vr": "FD", "Value": [1.474287009771987]}, "74": {"vr": "FD", "Value": [1.474287009771987]}, "75": {"vr": "FD", "Value": [1.474287009771987]}, "76": {"vr": "FD", "Value": [1.474287009771987]}, "77": {"vr": "FD", "Value": [1.474287009771987]}, "78": {"vr": "FD", "Value": [1.5164094957654723]}, "79": {"vr": "FD", "Value": [1.5164094957654723]}, "80": {"vr": "FD", "Value": [1.5164094957654723]}, "81": {"vr": "FD", "Value": [1.5164094957654723]}, "82": {"vr": "FD", "Value": [1.5164094957654723]}, "83": {"vr": "FD", "Value": [1.5585319817589576]}, "84": {"vr": "FD", "Value": [1.5585319817589576]}, "85": {"vr": "FD", "Value": [1.5585319817589576]}, "86": {"vr": "FD", "Value": [1.5585319817589576]}, "87": {"vr": "FD", "Value": [1.5585319817589576]}, "88": {"vr": "FD", "Value": [1.5585319817589576]}, "89": {"vr": "FD", "Value": [1.5585319817589576]}, "90": {"vr": "FD", "Value": [1.5585319817589576]}, "91": {"vr": "FD", "Value": [1.5585319817589576]}, "92": {"vr": "FD", "Value": [1.5164094957654723]}, "93": {"vr": "FD", "Value": [1.5164094957654723]}, "94": {"vr": "FD", "Value": [1.5164094957654723]}, "95": {"vr": "FD", "Value": [1.5164094957654723]}, "96": {"vr": "FD", "Value": [1.474287009771987]}, "97": {"vr": "FD", "Value": [1.474287009771987]}, "98": {"vr": "FD", "Value": [1.474287009771987]}, "99": {"vr": "FD", "Value": [1.474287009771987]}, "100": {"vr": "FD", "Value": [1.474287009771987]}, "101": {"vr": "FD", "Value": [1.474287009771987]}, "102": {"vr": "FD", "Value": [1.4321645237785015]}, "103": {"vr": "FD", "Value": [1.4321645237785015]}, "104": {"vr": "FD", "Value": [1.4321645237785015]}, "105": {"vr": "FD", "Value": [1.3900420377850162]}, "106": {"vr": "FD", "Value": [1.3900420377850162]}, "107": {"vr": "FD", "Value": [1.3900420377850162]}, "108": {"vr": "FD", "Value": [1.3900420377850162]}, "109": {"vr": "FD", "Value": [1.3900420377850162]}, "110": {"vr": "FD", "Value": [1.3900420377850162]}, "111": {"vr": "FD", "Value": [1.3900420377850162]}, "112": {"vr": "FD", "Value": [1.3900420377850162]}, "113": {"vr": "FD", "Value": [1.3900420377850162]}, "114": {"vr": "FD", "Value": [1.3900420377850162]}, "115": {"vr": "FD", "Value": [1.4321645237785015]}, "116": {"vr": "FD", "Value": [1.4321645237785015]}, "117": {"vr": "FD", "Value": [1.4321645237785015]}, "118": {"vr": "FD", "Value": [1.474287009771987]}, "119": {"vr": "FD", "Value": [1.474287009771987]}, "120": {"vr": "FD", "Value": [1.474287009771987]}, "121": {"vr": "FD", "Value": [1.5164094957654723]}, "122": {"vr": "FD", "Value": [1.5164094957654723]}, "123": {"vr": "FD", "Value": [1.5164094957654723]}, "124": {"vr": "FD", "Value": [1.5585319817589576]}, "125": {"vr": "FD", "Value": [1.5585319817589576]}, "126": {"vr": "FD", "Value": [1.5585319817589576]}, "127": {"vr": "FD", "Value": [1.5585319817589576]}, "128": {"vr": "FD", "Value": [1.5585319817589576]}, "129": {"vr": "FD", "Value": [1.5585319817589576]}, "130": {"vr": "FD", "Value": [1.5585319817589576]}, "131": {"vr": "FD", "Value": [1.5585319817589576]}, "132": {"vr": "FD", "Value": [1.5585319817589576]}, "133": {"vr": "FD", "Value": [1.5585319817589576]}, "134": {"vr": "FD", "Value": [1.5585319817589576]}, "135": {"vr": "FD", "Value": [1.5585319817589576]}, "136": {"vr": "FD", "Value": [1.5585319817589576]}, "137": {"vr": "FD", "Value": [1.5585319817589576]}, "138": {"vr": "FD", "Value": [1.5585319817589576]}, "139": {"vr": "FD", "Value": [1.5585319817589576]}, "140": {"vr": "FD", "Value": [1.5585319817589576]}, "141": {"vr": "FD", "Value": [1.5585319817589576]}, "142": {"vr": "FD", "Value": [1.5585319817589576]}, "143": {"vr": "FD", "Value": [1.5585319817589576]}, "144": {"vr": "FD", "Value": [1.5585319817589576]}, "145": {"vr": "FD", "Value": [1.5585319817589576]}, "146": {"vr": "FD", "Value": [1.5585319817589576]}, "147": {"vr": "FD", "Value": [1.5585319817589576]}, "148": {"vr": "FD", "Value": [1.5585319817589576]}, "149": {"vr": "FD", "Value": [1.5585319817589576]}, "150": {"vr": "FD", "Value": [1.5585319817589576]}, "151": {"vr": "FD", "Value": [1.5585319817589576]}, "152": {"vr": "FD", "Value": [1.5585319817589576]}, "153": {"vr": "FD", "Value": [1.6006544677524428]}, "154": {"vr": "FD", "Value": [1.6006544677524428]}, "155": {"vr": "FD", "Value": [1.6006544677524428]}, "156": {"vr": "FD", "Value": [1.6006544677524428]}, "157": {"vr": "FD", "Value": [1.6006544677524428]}, "158": {"vr": "FD", "Value": [1.6006544677524428]}, "159": {"vr": "FD", "Value": [1.6006544677524428]}, "160": {"vr": "FD", "Value": [1.6006544677524428]}, "161": {"vr": "FD", "Value": [1.6006544677524428]}, "162": {"vr": "FD", "Value": [1.6006544677524428]}, "163": {"vr": "FD", "Value": [1.5585319817589576]}, "164": {"vr": "FD", "Value": [1.5585319817589576]}, "165": {"vr": "FD", "Value": [1.5585319817589576]}, "166": {"vr": "FD", "Value": [1.5585319817589576]}, "167": {"vr": "FD", "Value": [1.5585319817589576]}, "168": {"vr": "FD", "Value": [1.5585319817589576]}, "169": {"vr": "FD", "Value": [1.5585319817589576]}, "170": {"vr": "FD", "Value": [1.5585319817589576]}, "171": {"vr": "FD", "Value": [1.5585319817589576]}, "172": {"vr": "FD", "Value": [1.5585319817589576]}, "173": {"vr": "FD", "Value": [1.5585319817589576]}, "174": {"vr": "FD", "Value": [1.5585319817589576]}, "175": {"vr": "FD", "Value": [1.5585319817589576]}, "176": {"vr": "FD", "Value": [1.5585319817589576]}, "177": {"vr": "FD", "Value": [1.5585319817589576]}, "178": {"vr": "FD", "Value": [1.5585319817589576]}, "179": {"vr": "FD", "Value": [1.5585319817589576]}, "180": {"vr": "FD", "Value": [1.5585319817589576]}, "181": {"vr": "FD", "Value": [1.5585319817589576]}, "182": {"vr": "FD", "Value": [1.5585319817589576]}, "183": {"vr": "FD", "Value": [1.5585319817589576]}, "184": {"vr": "FD", "Value": [1.5585319817589576]}, "185": {"vr": "FD", "Value": [1.5585319817589576]}, "186": {"vr": "FD", "Value": [1.5585319817589576]}, "187": {"vr": "FD", "Value": [1.5585319817589576]}, "188": {"vr": "FD", "Value": [1.5585319817589576]}, "189": {"vr": "FD", "Value": [1.5585319817589576]}, "190": {"vr": "FD", "Value": [1.5585319817589576]}, "191": {"vr": "FD", "Value": [1.5585319817589576]}, "192": {"vr": "FD", "Value": [1.5585319817589576]}, "193": {"vr": "FD", "Value": [1.5585319817589576]}, "194": {"vr": "FD", "Value": [1.5585319817589576]}, "195": {"vr": "FD", "Value": [1.5585319817589576]}, "196": {"vr": "FD", "Value": [1.5585319817589576]}, "197": {"vr": "FD", "Value": [1.5585319817589576]}, "198": {"vr": "FD", "Value": [1.5585319817589576]}, "199": {"vr": "FD", "Value": [1.5585319817589576]}, "200": {"vr": "FD", "Value": [1.5585319817589576]}, "201": {"vr": "FD", "Value": [1.5585319817589576]}, "202": {"vr": "FD", "Value": [1.5585319817589576]}, "203": {"vr": "FD", "Value": [1.5585319817589576]}, "204": {"vr": "FD", "Value": [1.5585319817589576]}, "205": {"vr": "FD", "Value": [1.5585319817589576]}, "206": {"vr": "FD", "Value": [1.5585319817589576]}, "207": {"vr": "FD", "Value": [1.5585319817589576]}, "208": {"vr": "FD", "Value": [1.5585319817589576]}, "209": {"vr": "FD", "Value": [1.5585319817589576]}, "210": {"vr": "FD", "Value": [1.5585319817589576]}, "211": {"vr": "FD", "Value": [1.5585319817589576]}, "212": {"vr": "FD", "Value": [1.5585319817589576]}, "213": {"vr": "FD", "Value": [1.5585319817589576]}, "214": {"vr": "FD", "Value": [1.5585319817589576]}, "215": {"vr": "FD", "Value": [1.6006544677524428]}, "216": {"vr": "FD", "Value": [1.6006544677524428]}, "217": {"vr": "FD", "Value": [1.6427769537459282]}, "218": {"vr": "FD", "Value": [1.727021925732899]}, "219": {"vr": "FD", "Value": [1.7691444117263841]}, "220": {"vr": "FD", "Value": [1.89551186970684]}, "221": {"vr": "FD", "Value": [2.021879327687296]}, "222": {"vr": "FD", "Value": [2.1061242996742666]}, "223": {"vr": "FD", "Value": [2.232491757654723]}, "224": {"vr": "FD", "Value": [2.4009817016286643]}, "225": {"vr": "FD", "Value": [2.4852266736156348]}, "226": {"vr": "FD", "Value": [2.611594131596091]}, "227": {"vr": "FD", "Value": [2.7800840755700325]}, "228": {"vr": "FD", "Value": [2.8222065615635175]}, "229": {"vr": "FD", "Value": [2.9906965055374592]}, "230": {"vr": "FD", "Value": [3.117063963517915]}, "231": {"vr": "FD", "Value": [3.1591864495114006]}, "232": {"vr": "FD", "Value": [3.243431421498371]}, "233": {"vr": "FD", "Value": [3.3276763934853415]}, "234": {"vr": "FD", "Value": [3.3276763934853415]}, "235": {"vr": "FD", "Value": [3.3276763934853415]}, "236": {"vr": "FD", "Value": [3.2855539074918565]}, "237": {"vr": "FD", "Value": [3.243431421498371]}, "238": {"vr": "FD", "Value": [3.2013089355048856]}, "239": {"vr": "FD", "Value": [3.117063963517915]}, "240": {"vr": "FD", "Value": [3.0328189915309447]}, "241": {"vr": "FD", "Value": [2.9064515335504884]}, "242": {"vr": "FD", "Value": [2.737961589576547]}, "243": {"vr": "FD", "Value": [2.611594131596091]}, "244": {"vr": "FD", "Value": [2.4431041876221498]}, "245": {"vr": "FD", "Value": [2.232491757654723]}, "246": {"vr": "FD", "Value": [2.1482467856677525]}, "247": {"vr": "FD", "Value": [1.9376343557003257]}, "248": {"vr": "FD", "Value": [1.7691444117263841]}, "249": {"vr": "FD", "Value": [1.6848994397394137]}, "250": {"vr": "FD", "Value": [1.5164094957654723]}, "251": {"vr": "FD", "Value": [1.347919551791531]}, "252": {"vr": "FD", "Value": [1.2636745798045603]}, "253": {"vr": "FD", "Value": [1.1373071218241042]}, "254": {"vr": "FD", "Value": [1.010939663843648]}, "255": {"vr": "FD", "Value": [0.9266946918566774]}, "256": {"vr": "FD", "Value": [0.8845722058631921]}, "257": {"vr": "FD", "Value": [0.8003272338762214]}, "258": {"vr": "FD", "Value": [0.8003272338762214]}, "259": {"vr": "FD", "Value": [0.8003272338762214]}, "260": {"vr": "FD", "Value": [0.8003272338762214]}, "261": {"vr": "FD", "Value": [0.8003272338762214]}, "262": {"vr": "FD", "Value": [0.8003272338762214]}, "263": {"vr": "FD", "Value": [0.7582047478827362]}, "264": {"vr": "FD", "Value": [0.7582047478827362]}, "265": {"vr": "FD", "Value": [0.7582047478827362]}, "266": {"vr": "FD", "Value": [0.7582047478827362]}, "267": {"vr": "FD", "Value": [0.7582047478827362]}, "268": {"vr": "FD", "Value": [0.7582047478827362]}, "269": {"vr": "FD", "Value": [0.7582047478827362]}, "270": {"vr": "FD", "Value": [0.7582047478827362]}, "271": {"vr": "FD", "Value": [0.7582047478827362]}, "272": {"vr": "FD", "Value": [0.7582047478827362]}, "273": {"vr": "FD", "Value": [0.7582047478827362]}, "274": {"vr": "FD", "Value": [0.7582047478827362]}, "275": {"vr": "FD", "Value": [0.7160822618892507]}, "276": {"vr": "FD", "Value": [0.7160822618892507]}, "277": {"vr": "FD", "Value": [0.7160822618892507]}, "278": {"vr": "FD", "Value": [0.7160822618892507]}, "279": {"vr": "FD", "Value": [0.7160822618892507]}, "280": {"vr": "FD", "Value": [0.7160822618892507]}, "281": {"vr": "FD", "Value": [0.7582047478827362]}, "282": {"vr": "FD", "Value": [0.7582047478827362]}, "283": {"vr": "FD", "Value": [0.7160822618892507]}, "284": {"vr": "FD", "Value": [0.7160822618892507]}, "285": {"vr": "FD", "Value": [0.7160822618892507]}, "286": {"vr": "FD", "Value": [0.7160822618892507]}, "287": {"vr": "FD", "Value": [0.7160822618892507]}, "288": {"vr": "FD", "Value": [0.7160822618892507]}, "289": {"vr": "FD", "Value": [0.7160822618892507]}, "290": {"vr": "FD", "Value": [0.7160822618892507]}, "291": {"vr": "FD", "Value": [0.7160822618892507]}, "292": {"vr": "FD", "Value": [0.7160822618892507]}, "293": {"vr": "FD", "Value": [0.7160822618892507]}, "294": {"vr": "FD", "Value": [0.7160822618892507]}, "295": {"vr": "FD", "Value": [0.7160822618892507]}, "296": {"vr": "FD", "Value": [0.7160822618892507]}, "297": {"vr": "FD", "Value": [0.7160822618892507]}, "298": {"vr": "FD", "Value": [0.7160822618892507]}, "299": {"vr": "FD", "Value": [0.7160822618892507]}, "300": {"vr": "FD", "Value": [0.7160822618892507]}, "301": {"vr": "FD", "Value": [0.7160822618892507]}, "302": {"vr": "FD", "Value": [0.7160822618892507]}, "303": {"vr": "FD", "Value": [0.7160822618892507]}, "304": {"vr": "FD", "Value": [0.7160822618892507]}, "305": {"vr": "FD", "Value": [0.7160822618892507]}, "306": {"vr": "FD", "Value": [0.7582047478827362]}, "307": {"vr": "FD", "Value": [0.7582047478827362]}, "308": {"vr": "FD", "Value": [0.7160822618892507]}, "309": {"vr": "FD", "Value": [0.7160822618892507]}, "310": {"vr": "FD", "Value": [0.7160822618892507]}, "311": {"vr": "FD", "Value": [0.7160822618892507]}, "312": {"vr": "FD", "Value": [0.7160822618892507]}, "313": {"vr": "FD", "Value": [0.7160822618892507]}, "314": {"vr": "FD", "Value": [0.7160822618892507]}, "315": {"vr": "FD", "Value": [0.7160822618892507]}, "316": {"vr": "FD", "Value": [0.7160822618892507]}, "317": {"vr": "FD", "Value": [0.7160822618892507]}, "318": {"vr": "FD", "Value": [0.7160822618892507]}, "319": {"vr": "FD", "Value": [0.7160822618892507]}, "320": {"vr": "FD", "Value": [0.7160822618892507]}, "321": {"vr": "FD", "Value": [0.7160822618892507]}, "322": {"vr": "FD", "Value": [0.7160822618892507]}, "323": {"vr": "FD", "Value": [0.7160822618892507]}, "324": {"vr": "FD", "Value": [0.7160822618892507]}, "325": {"vr": "FD", "Value": [0.7160822618892507]}, "326": {"vr": "FD", "Value": [0.7160822618892507]}, "327": {"vr": "FD", "Value": [0.7160822618892507]}, "328": {"vr": "FD", "Value": [0.7160822618892507]}, "329": {"vr": "FD", "Value": [0.7160822618892507]}, "330": {"vr": "FD", "Value": [0.7160822618892507]}, "331": {"vr": "FD", "Value": [0.7160822618892507]}, "332": {"vr": "FD", "Value": [0.7160822618892507]}, "333": {"vr": "FD", "Value": [0.7160822618892507]}, "334": {"vr": "FD", "Value": [0.7160822618892507]}, "335": {"vr": "FD", "Value": [0.7160822618892507]}, "336": {"vr": "FD", "Value": [0.7160822618892507]}, "337": {"vr": "FD", "Value": [0.7582047478827362]}, "338": {"vr": "FD", "Value": [0.7582047478827362]}, "339": {"vr": "FD", "Value": [0.7582047478827362]}, "340": {"vr": "FD", "Value": [0.7582047478827362]}, "341": {"vr": "FD", "Value": [0.7582047478827362]}, "342": {"vr": "FD", "Value": [0.7582047478827362]}, "343": {"vr": "FD", "Value": [0.7582047478827362]}, "344": {"vr": "FD", "Value": [0.7582047478827362]}, "345": {"vr": "FD", "Value": [0.7582047478827362]}, "346": {"vr": "FD", "Value": [0.7582047478827362]}, "347": {"vr": "FD", "Value": [0.7582047478827362]}, "348": {"vr": "FD", "Value": [0.7582047478827362]}, "349": {"vr": "FD", "Value": [0.7582047478827362]}, "350": {"vr": "FD", "Value": [0.7582047478827362]}, "351": {"vr": "FD", "Value": [0.7582047478827362]}, "352": {"vr": "FD", "Value": [0.7582047478827362]}, "353": {"vr": "FD", "Value": [0.7582047478827362]}, "354": {"vr": "FD", "Value": [0.7582047478827362]}, "355": {"vr": "FD", "Value": [0.7582047478827362]}, "356": {"vr": "FD", "Value": [0.7582047478827362]}, "357": {"vr": "FD", "Value": [0.7582047478827362]}, "358": {"vr": "FD", "Value": [0.7582047478827362]}, "359": {"vr": "FD", "Value": [0.7582047478827362]}, "360": {"vr": "FD", "Value": [0.7582047478827362]}, "361": {"vr": "FD", "Value": [0.7582047478827362]}, "362": {"vr": "FD", "Value": [0.7582047478827362]}, "363": {"vr": "FD", "Value": [0.7582047478827362]}, "364": {"vr": "FD", "Value": [0.7582047478827362]}, "365": {"vr": "FD", "Value": [0.7582047478827362]}, "366": {"vr": "FD", "Value": [0.7582047478827362]}, "367": {"vr": "FD", "Value": [0.7582047478827362]}, "368": {"vr": "FD", "Value": [0.7582047478827362]}, "369": {"vr": "FD", "Value": [0.7582047478827362]}, "370": {"vr": "FD", "Value": [0.7582047478827362]}, "371": {"vr": "FD", "Value": [0.7582047478827362]}, "372": {"vr": "FD", "Value": [0.7582047478827362]}, "373": {"vr": "FD", "Value": [0.7582047478827362]}, "374": {"vr": "FD", "Value": [0.7582047478827362]}, "375": {"vr": "FD", "Value": [0.7582047478827362]}, "376": {"vr": "FD", "Value": [0.7582047478827362]}, "377": {"vr": "FD", "Value": [0.7582047478827362]}, "378": {"vr": "FD", "Value": [0.7582047478827362]}, "379": {"vr": "FD", "Value": [0.7582047478827362]}, "380": {"vr": "FD", "Value": [0.7582047478827362]}, "381": {"vr": "FD", "Value": [0.7582047478827362]}, "382": {"vr": "FD", "Value": [0.7582047478827362]}, "383": {"vr": "FD", "Value": [0.7582047478827362]}, "384": {"vr": "FD", "Value": [0.7582047478827362]}, "385": {"vr": "FD", "Value": [0.7582047478827362]}, "386": {"vr": "FD", "Value": [0.7582047478827362]}, "387": {"vr": "FD", "Value": [0.7582047478827362]}, "388": {"vr": "FD", "Value": [0.7582047478827362]}, "389": {"vr": "FD", "Value": [0.7582047478827362]}, "390": {"vr": "FD", "Value": [0.7582047478827362]}, "391": {"vr": "FD", "Value": [0.7582047478827362]}, "392": {"vr": "FD", "Value": [0.7582047478827362]}, "393": {"vr": "FD", "Value": [0.7582047478827362]}, "394": {"vr": "FD", "Value": [0.7582047478827362]}, "395": {"vr": "FD", "Value": [0.7582047478827362]}, "396": {"vr": "FD", "Value": [0.7582047478827362]}, "397": {"vr": "FD", "Value": [0.7582047478827362]}, "398": {"vr": "FD", "Value": [0.7582047478827362]}, "399": {"vr": "FD", "Value": [0.7582047478827362]}, "400": {"vr": "FD", "Value": [0.7582047478827362]}, "401": {"vr": "FD", "Value": [0.7582047478827362]}, "402": {"vr": "FD", "Value": [0.7582047478827362]}, "403": {"vr": "FD", "Value": [0.7582047478827362]}, "404": {"vr": "FD", "Value": [0.7582047478827362]}, "405": {"vr": "FD", "Value": [0.7582047478827362]}, "406": {"vr": "FD", "Value": [0.7582047478827362]}, "407": {"vr": "FD", "Value": [0.7582047478827362]}, "408": {"vr": "FD", "Value": [0.7582047478827362]}, "409": {"vr": "FD", "Value": [0.7582047478827362]}, "410": {"vr": "FD", "Value": [0.7582047478827362]}, "411": {"vr": "FD", "Value": [0.7582047478827362]}, "412": {"vr": "FD", "Value": [0.7582047478827362]}, "413": {"vr": "FD", "Value": [0.7582047478827362]}, "414": {"vr": "FD", "Value": [0.7582047478827362]}, "415": {"vr": "FD", "Value": [0.7582047478827362]}, "416": {"vr": "FD", "Value": [0.7582047478827362]}, "417": {"vr": "FD", "Value": [0.7582047478827362]}, "418": {"vr": "FD", "Value": [0.7582047478827362]}, "419": {"vr": "FD", "Value": [0.7582047478827362]}, "420": {"vr": "FD", "Value": [0.7582047478827362]}, "421": {"vr": "FD", "Value": [0.7582047478827362]}, "422": {"vr": "FD", "Value": [0.7582047478827362]}, "423": {"vr": "FD", "Value": [0.7582047478827362]}, "424": {"vr": "FD", "Value": [0.7582047478827362]}, "425": {"vr": "FD", "Value": [0.7582047478827362]}, "426": {"vr": "FD", "Value": [0.7582047478827362]}, "427": {"vr": "FD", "Value": [0.7582047478827362]}, "428": {"vr": "FD", "Value": [0.7582047478827362]}, "429": {"vr": "FD", "Value": [0.7582047478827362]}, "430": {"vr": "FD", "Value": [0.7582047478827362]}, "431": {"vr": "FD", "Value": [0.7582047478827362]}, "432": {"vr": "FD", "Value": [0.7582047478827362]}, "433": {"vr": "FD", "Value": [0.7582047478827362]}, "434": {"vr": "FD", "Value": [0.7582047478827362]}, "435": {"vr": "FD", "Value": [0.7582047478827362]}, "436": {"vr": "FD", "Value": [0.7582047478827362]}, "437": {"vr": "FD", "Value": [0.7582047478827362]}, "438": {"vr": "FD", "Value": [0.7582047478827362]}, "439": {"vr": "FD", "Value": [0.7582047478827362]}, "440": {"vr": "FD", "Value": [0.7582047478827362]}, "441": {"vr": "FD", "Value": [0.7582047478827362]}, "442": {"vr": "FD", "Value": [0.7582047478827362]}, "443": {"vr": "FD", "Value": [0.7582047478827362]}, "444": {"vr": "FD", "Value": [0.7582047478827362]}, "445": {"vr": "FD", "Value": [0.7582047478827362]}, "446": {"vr": "FD", "Value": [0.7582047478827362]}, "447": {"vr": "FD", "Value": [0.7582047478827362]}, "448": {"vr": "FD", "Value": [0.7582047478827362]}, "449": {"vr": "FD", "Value": [0.7582047478827362]}, "450": {"vr": "FD", "Value": [0.7582047478827362]}, "451": {"vr": "FD", "Value": [0.7582047478827362]}, "452": {"vr": "FD", "Value": [0.7582047478827362]}, "453": {"vr": "FD", "Value": [0.7582047478827362]}, "454": {"vr": "FD", "Value": [0.7582047478827362]}, "455": {"vr": "FD", "Value": [0.7582047478827362]}, "456": {"vr": "FD", "Value": [0.7582047478827362]}, "457": {"vr": "FD", "Value": [0.7582047478827362]}, "458": {"vr": "FD", "Value": [0.7582047478827362]}, "459": {"vr": "FD", "Value": [0.7582047478827362]}, "460": {"vr": "FD", "Value": [0.7582047478827362]}, "461": {"vr": "FD", "Value": [0.7582047478827362]}, "462": {"vr": "FD", "Value": [0.7582047478827362]}, "463": {"vr": "FD", "Value": [0.7582047478827362]}, "464": {"vr": "FD", "Value": [0.7582047478827362]}, "465": {"vr": "FD", "Value": [0.7582047478827362]}, "466": {"vr": "FD", "Value": [0.7582047478827362]}, "467": {"vr": "FD", "Value": [0.7582047478827362]}, "468": {"vr": "FD", "Value": [0.7582047478827362]}, "469": {"vr": "FD", "Value": [0.7582047478827362]}, "470": {"vr": "FD", "Value": [0.7582047478827362]}, "471": {"vr": "FD", "Value": [0.7582047478827362]}, "472": {"vr": "FD", "Value": [0.7582047478827362]}, "473": {"vr": "FD", "Value": [0.7582047478827362]}, "474": {"vr": "FD", "Value": [0.7582047478827362]}, "475": {"vr": "FD", "Value": [0.7582047478827362]}, "476": {"vr": "FD", "Value": [0.7582047478827362]}, "477": {"vr": "FD", "Value": [0.7582047478827362]}, "478": {"vr": "FD", "Value": [0.7582047478827362]}, "479": {"vr": "FD", "Value": [0.7582047478827362]}, "480": {"vr": "FD", "Value": [0.7582047478827362]}, "481": {"vr": "FD", "Value": [0.7582047478827362]}, "482": {"vr": "FD", "Value": [0.7582047478827362]}, "483": {"vr": "FD", "Value": [0.7582047478827362]}, "484": {"vr": "FD", "Value": [0.7582047478827362]}, "485": {"vr": "FD", "Value": [0.7582047478827362]}, "486": {"vr": "FD", "Value": [0.7582047478827362]}, "487": {"vr": "FD", "Value": [0.7582047478827362]}, "488": {"vr": "FD", "Value": [0.7582047478827362]}, "489": {"vr": "FD", "Value": [0.7582047478827362]}, "490": {"vr": "FD", "Value": [0.7582047478827362]}, "491": {"vr": "FD", "Value": [0.7582047478827362]}, "492": {"vr": "FD", "Value": [0.7582047478827362]}, "493": {"vr": "FD", "Value": [0.7582047478827362]}, "494": {"vr": "FD", "Value": [0.7582047478827362]}, "495": {"vr": "FD", "Value": [0.7582047478827362]}, "496": {"vr": "FD", "Value": [0.7582047478827362]}, "497": {"vr": "FD", "Value": [0.7582047478827362]}, "498": {"vr": "FD", "Value": [0.7582047478827362]}, "499": {"vr": "FD", "Value": [0.7582047478827362]}, "500": {"vr": "FD", "Value": [0.7582047478827362]}, "501": {"vr": "FD", "Value": [0.7582047478827362]}, "502": {"vr": "FD", "Value": [0.7582047478827362]}, "503": {"vr": "FD", "Value": [0.7582047478827362]}, "504": {"vr": "FD", "Value": [0.7582047478827362]}, "505": {"vr": "FD", "Value": [0.7582047478827362]}, "506": {"vr": "FD", "Value": [0.7582047478827362]}, "507": {"vr": "FD", "Value": [0.7582047478827362]}, "508": {"vr": "FD", "Value": [0.7582047478827362]}, "509": {"vr": "FD", "Value": [0.7582047478827362]}, "510": {"vr": "FD", "Value": [0.7582047478827362]}, "511": {"vr": "FD", "Value": [0.7582047478827362]}, "512": {"vr": "FD", "Value": [0.7582047478827362]}, "513": {"vr": "FD", "Value": [0.7582047478827362]}, "514": {"vr": "FD", "Value": [0.7582047478827362]}, "515": {"vr": "FD", "Value": [0.7582047478827362]}, "516": {"vr": "FD", "Value": [0.7582047478827362]}, "517": {"vr": "FD", "Value": [0.7582047478827362]}, "518": {"vr": "FD", "Value": [0.7582047478827362]}, "519": {"vr": "FD", "Value": [0.7582047478827362]}, "520": {"vr": "FD", "Value": [0.7582047478827362]}, "521": {"vr": "FD", "Value": [0.7582047478827362]}, "522": {"vr": "FD", "Value": [0.7582047478827362]}, "523": {"vr": "FD", "Value": [0.7582047478827362]}, "524": {"vr": "FD", "Value": [0.7582047478827362]}, "525": {"vr": "FD", "Value": [0.7582047478827362]}, "526": {"vr": "FD", "Value": [0.7582047478827362]}, "527": {"vr": "FD", "Value": [0.7582047478827362]}, "528": {"vr": "FD", "Value": [0.7582047478827362]}, "529": {"vr": "FD", "Value": [0.7582047478827362]}, "530": {"vr": "FD", "Value": [0.7582047478827362]}}, "00200013": {"0": {"vr": "IS", "Value": [1]}, "1": {"vr": "IS", "Value": [2]}, "2": {"vr": "IS", "Value": [3]}, "3": {"vr": "IS", "Value": [4]}, "4": {"vr": "IS", "Value": [5]}, "5": {"vr": "IS", "Value": [6]}, "6": {"vr": "IS", "Value": [7]}, "7": {"vr": "IS", "Value": [8]}, "8": {"vr": "IS", "Value": [9]}, "9": {"vr": "IS", "Value": [10]}, "10": {"vr": "IS", "Value": [11]}, "11": {"vr": "IS", "Value": [12]}, "12": {"vr": "IS", "Value": [13]}, "13": {"vr": "IS", "Value": [14]}, "14": {"vr": "IS", "Value": [15]}, "15": {"vr": "IS", "Value": [16]}, "16": {"vr": "IS", "Value": [17]}, "17": {"vr": "IS", "Value": [18]}, "18": {"vr": "IS", "Value": [19]}, "19": {"vr": "IS", "Value": [20]}, "20": {"vr": "IS", "Value": [21]}, "21": {"vr": "IS", "Value": [22]}, "22": {"vr": "IS", "Value": [23]}, "23": {"vr": "IS", "Value": [24]}, "24": {"vr": "IS", "Value": [25]}, "25": {"vr": "IS", "Value": [26]}, "26": {"vr": "IS", "Value": [27]}, "27": {"vr": "IS", "Value": [28]}, "28": {"vr": "IS", "Value": [29]}, "29": {"vr": "IS", "Value": [30]}, "30": {"vr": "IS", "Value": [31]}, "31": {"vr": "IS", "Value": [32]}, "32": {"vr": "IS", "Value": [33]}, "33": {"vr": "IS", "Value": [34]}, "34": {"vr": "IS", "Value": [35]}, "35": {"vr": "IS", "Value": [36]}, "36": {"vr": "IS", "Value": [37]}, "37": {"vr": "IS", "Value": [38]}, "38": {"vr": "IS", "Value": [39]}, "39": {"vr": "IS", "Value": [40]}, "40": {"vr": "IS", "Value": [41]}, "41": {"vr": "IS", "Value": [42]}, "42": {"vr": "IS", "Value": [43]}, "43": {"vr": "IS", "Value": [44]}, "44": {"vr": "IS", "Value": [45]}, "45": {"vr": "IS", "Value": [46]}, "46": {"vr": "IS", "Value": [47]}, "47": {"vr": "IS", "Value": [48]}, "48": {"vr": "IS", "Value": [49]}, "49": {"vr": "IS", "Value": [50]}, "50": {"vr": "IS", "Value": [51]}, "51": {"vr": "IS", "Value": [52]}, "52": {"vr": "IS", "Value": [53]}, "53": {"vr": "IS", "Value": [54]}, "54": {"vr": "IS", "Value": [55]}, "55": {"vr": "IS", "Value": [56]}, "56": {"vr": "IS", "Value": [57]}, "57": {"vr": "IS", "Value": [58]}, "58": {"vr": "IS", "Value": [59]}, "59": {"vr": "IS", "Value": [60]}, "60": {"vr": "IS", "Value": [61]}, "61": {"vr": "IS", "Value": [62]}, "62": {"vr": "IS", "Value": [63]}, "63": {"vr": "IS", "Value": [64]}, "64": {"vr": "IS", "Value": [65]}, "65": {"vr": "IS", "Value": [66]}, "66": {"vr": "IS", "Value": [67]}, "67": {"vr": "IS", "Value": [68]}, "68": {"vr": "IS", "Value": [69]}, "69": {"vr": "IS", "Value": [70]}, "70": {"vr": "IS", "Value": [71]}, "71": {"vr": "IS", "Value": [72]}, "72": {"vr": "IS", "Value": [73]}, "73": {"vr": "IS", "Value": [74]}, "74": {"vr": "IS", "Value": [75]}, "75": {"vr": "IS", "Value": [76]}, "76": {"vr": "IS", "Value": [77]}, "77": {"vr": "IS", "Value": [78]}, "78": {"vr": "IS", "Value": [79]}, "79": {"vr": "IS", "Value": [80]}, "80": {"vr": "IS", "Value": [81]}, "81": {"vr": "IS", "Value": [82]}, "82": {"vr": "IS", "Value": [83]}, "83": {"vr": "IS", "Value": [84]}, "84": {"vr": "IS", "Value": [85]}, "85": {"vr": "IS", "Value": [86]}, "86": {"vr": "IS", "Value": [87]}, "87": {"vr": "IS", "Value": [88]}, "88": {"vr": "IS", "Value": [89]}, "89": {"vr": "IS", "Value": [90]}, "90": {"vr": "IS", "Value": [91]}, "91": {"vr": "IS", "Value": [92]}, "92": {"vr": "IS", "Value": [93]}, "93": {"vr": "IS", "Value": [94]}, "94": {"vr": "IS", "Value": [95]}, "95": {"vr": "IS", "Value": [96]}, "96": {"vr": "IS", "Value": [97]}, "97": {"vr": "IS", "Value": [98]}, "98": {"vr": "IS", "Value": [99]}, "99": {"vr": "IS", "Value": [100]}, "100": {"vr": "IS", "Value": [101]}, "101": {"vr": "IS", "Value": [102]}, "102": {"vr": "IS", "Value": [103]}, "103": {"vr": "IS", "Value": [104]}, "104": {"vr": "IS", "Value": [105]}, "105": {"vr": "IS", "Value": [106]}, "106": {"vr": "IS", "Value": [107]}, "107": {"vr": "IS", "Value": [108]}, "108": {"vr": "IS", "Value": [109]}, "109": {"vr": "IS", "Value": [110]}, "110": {"vr": "IS", "Value": [111]}, "111": {"vr": "IS", "Value": [112]}, "112": {"vr": "IS", "Value": [113]}, "113": {"vr": "IS", "Value": [114]}, "114": {"vr": "IS", "Value": [115]}, "115": {"vr": "IS", "Value": [116]}, "116": {"vr": "IS", "Value": [117]}, "117": {"vr": "IS", "Value": [118]}, "118": {"vr": "IS", "Value": [119]}, "119": {"vr": "IS", "Value": [120]}, "120": {"vr": "IS", "Value": [121]}, "121": {"vr": "IS", "Value": [122]}, "122": {"vr": "IS", "Value": [123]}, "123": {"vr": "IS", "Value": [124]}, "124": {"vr": "IS", "Value": [125]}, "125": {"vr": "IS", "Value": [126]}, "126": {"vr": "IS", "Value": [127]}, "127": {"vr": "IS", "Value": [128]}, "128": {"vr": "IS", "Value": [129]}, "129": {"vr": "IS", "Value": [130]}, "130": {"vr": "IS", "Value": [131]}, "131": {"vr": "IS", "Value": [132]}, "132": {"vr": "IS", "Value": [133]}, "133": {"vr": "IS", "Value": [134]}, "134": {"vr": "IS", "Value": [135]}, "135": {"vr": "IS", "Value": [136]}, "136": {"vr": "IS", "Value": [137]}, "137": {"vr": "IS", "Value": [138]}, "138": {"vr": "IS", "Value": [139]}, "139": {"vr": "IS", "Value": [140]}, "140": {"vr": "IS", "Value": [141]}, "141": {"vr": "IS", "Value": [142]}, "142": {"vr": "IS", "Value": [143]}, "143": {"vr": "IS", "Value": [144]}, "144": {"vr": "IS", "Value": [145]}, "145": {"vr": "IS", "Value": [146]}, "146": {"vr": "IS", "Value": [147]}, "147": {"vr": "IS", "Value": [148]}, "148": {"vr": "IS", "Value": [149]}, "149": {"vr": "IS", "Value": [150]}, "150": {"vr": "IS", "Value": [151]}, "151": {"vr": "IS", "Value": [152]}, "152": {"vr": "IS", "Value": [153]}, "153": {"vr": "IS", "Value": [154]}, "154": {"vr": "IS", "Value": [155]}, "155": {"vr": "IS", "Value": [156]}, "156": {"vr": "IS", "Value": [157]}, "157": {"vr": "IS", "Value": [158]}, "158": {"vr": "IS", "Value": [159]}, "159": {"vr": "IS", "Value": [160]}, "160": {"vr": "IS", "Value": [161]}, "161": {"vr": "IS", "Value": [162]}, "162": {"vr": "IS", "Value": [163]}, "163": {"vr": "IS", "Value": [164]}, "164": {"vr": "IS", "Value": [165]}, "165": {"vr": "IS", "Value": [166]}, "166": {"vr": "IS", "Value": [167]}, "167": {"vr": "IS", "Value": [168]}, "168": {"vr": "IS", "Value": [169]}, "169": {"vr": "IS", "Value": [170]}, "170": {"vr": "IS", "Value": [171]}, "171": {"vr": "IS", "Value": [172]}, "172": {"vr": "IS", "Value": [173]}, "173": {"vr": "IS", "Value": [174]}, "174": {"vr": "IS", "Value": [175]}, "175": {"vr": "IS", "Value": [176]}, "176": {"vr": "IS", "Value": [177]}, "177": {"vr": "IS", "Value": [178]}, "178": {"vr": "IS", "Value": [179]}, "179": {"vr": "IS", "Value": [180]}, "180": {"vr": "IS", "Value": [181]}, "181": {"vr": "IS", "Value": [182]}, "182": {"vr": "IS", "Value": [183]}, "183": {"vr": "IS", "Value": [184]}, "184": {"vr": "IS", "Value": [185]}, "185": {"vr": "IS", "Value": [186]}, "186": {"vr": "IS", "Value": [187]}, "187": {"vr": "IS", "Value": [188]}, "188": {"vr": "IS", "Value": [189]}, "189": {"vr": "IS", "Value": [190]}, "190": {"vr": "IS", "Value": [191]}, "191": {"vr": "IS", "Value": [192]}, "192": {"vr": "IS", "Value": [193]}, "193": {"vr": "IS", "Value": [194]}, "194": {"vr": "IS", "Value": [195]}, "195": {"vr": "IS", "Value": [196]}, "196": {"vr": "IS", "Value": [197]}, "197": {"vr": "IS", "Value": [198]}, "198": {"vr": "IS", "Value": [199]}, "199": {"vr": "IS", "Value": [200]}, "200": {"vr": "IS", "Value": [201]}, "201": {"vr": "IS", "Value": [202]}, "202": {"vr": "IS", "Value": [203]}, "203": {"vr": "IS", "Value": [204]}, "204": {"vr": "IS", "Value": [205]}, "205": {"vr": "IS", "Value": [206]}, "206": {"vr": "IS", "Value": [207]}, "207": {"vr": "IS", "Value": [208]}, "208": {"vr": "IS", "Value": [209]}, "209": {"vr": "IS", "Value": [210]}, "210": {"vr": "IS", "Value": [211]}, "211": {"vr": "IS", "Value": [212]}, "212": {"vr": "IS", "Value": [213]}, "213": {"vr": "IS", "Value": [214]}, "214": {"vr": "IS", "Value": [215]}, "215": {"vr": "IS", "Value": [216]}, "216": {"vr": "IS", "Value": [217]}, "217": {"vr": "IS", "Value": [218]}, "218": {"vr": "IS", "Value": [219]}, "219": {"vr": "IS", "Value": [220]}, "220": {"vr": "IS", "Value": [221]}, "221": {"vr": "IS", "Value": [222]}, "222": {"vr": "IS", "Value": [223]}, "223": {"vr": "IS", "Value": [224]}, "224": {"vr": "IS", "Value": [225]}, "225": {"vr": "IS", "Value": [226]}, "226": {"vr": "IS", "Value": [227]}, "227": {"vr": "IS", "Value": [228]}, "228": {"vr": "IS", "Value": [229]}, "229": {"vr": "IS", "Value": [230]}, "230": {"vr": "IS", "Value": [231]}, "231": {"vr": "IS", "Value": [232]}, "232": {"vr": "IS", "Value": [233]}, "233": {"vr": "IS", "Value": [234]}, "234": {"vr": "IS", "Value": [235]}, "235": {"vr": "IS", "Value": [236]}, "236": {"vr": "IS", "Value": [237]}, "237": {"vr": "IS", "Value": [238]}, "238": {"vr": "IS", "Value": [239]}, "239": {"vr": "IS", "Value": [240]}, "240": {"vr": "IS", "Value": [241]}, "241": {"vr": "IS", "Value": [242]}, "242": {"vr": "IS", "Value": [243]}, "243": {"vr": "IS", "Value": [244]}, "244": {"vr": "IS", "Value": [245]}, "245": {"vr": "IS", "Value": [246]}, "246": {"vr": "IS", "Value": [247]}, "247": {"vr": "IS", "Value": [248]}, "248": {"vr": "IS", "Value": [249]}, "249": {"vr": "IS", "Value": [250]}, "250": {"vr": "IS", "Value": [251]}, "251": {"vr": "IS", "Value": [252]}, "252": {"vr": "IS", "Value": [253]}, "253": {"vr": "IS", "Value": [254]}, "254": {"vr": "IS", "Value": [255]}, "255": {"vr": "IS", "Value": [256]}, "256": {"vr": "IS", "Value": [257]}, "257": {"vr": "IS", "Value": [258]}, "258": {"vr": "IS", "Value": [259]}, "259": {"vr": "IS", "Value": [260]}, "260": {"vr": "IS", "Value": [261]}, "261": {"vr": "IS", "Value": [262]}, "262": {"vr": "IS", "Value": [263]}, "263": {"vr": "IS", "Value": [264]}, "264": {"vr": "IS", "Value": [265]}, "265": {"vr": "IS", "Value": [266]}, "266": {"vr": "IS", "Value": [267]}, "267": {"vr": "IS", "Value": [268]}, "268": {"vr": "IS", "Value": [269]}, "269": {"vr": "IS", "Value": [270]}, "270": {"vr": "IS", "Value": [271]}, "271": {"vr": "IS", "Value": [272]}, "272": {"vr": "IS", "Value": [273]}, "273": {"vr": "IS", "Value": [274]}, "274": {"vr": "IS", "Value": [275]}, "275": {"vr": "IS", "Value": [276]}, "276": {"vr": "IS", "Value": [277]}, "277": {"vr": "IS", "Value": [278]}, "278": {"vr": "IS", "Value": [279]}, "279": {"vr": "IS", "Value": [280]}, "280": {"vr": "IS", "Value": [281]}, "281": {"vr": "IS", "Value": [282]}, "282": {"vr": "IS", "Value": [283]}, "283": {"vr": "IS", "Value": [284]}, "284": {"vr": "IS", "Value": [285]}, "285": {"vr": "IS", "Value": [286]}, "286": {"vr": "IS", "Value": [287]}, "287": {"vr": "IS", "Value": [288]}, "288": {"vr": "IS", "Value": [289]}, "289": {"vr": "IS", "Value": [290]}, "290": {"vr": "IS", "Value": [291]}, "291": {"vr": "IS", "Value": [292]}, "292": {"vr": "IS", "Value": [293]}, "293": {"vr": "IS", "Value": [294]}, "294": {"vr": "IS", "Value": [295]}, "295": {"vr": "IS", "Value": [296]}, "296": {"vr": "IS", "Value": [297]}, "297": {"vr": "IS", "Value": [298]}, "298": {"vr": "IS", "Value": [299]}, "299": {"vr": "IS", "Value": [300]}, "300": {"vr": "IS", "Value": [301]}, "301": {"vr": "IS", "Value": [302]}, "302": {"vr": "IS", "Value": [303]}, "303": {"vr": "IS", "Value": [304]}, "304": {"vr": "IS", "Value": [305]}, "305": {"vr": "IS", "Value": [306]}, "306": {"vr": "IS", "Value": [307]}, "307": {"vr": "IS", "Value": [308]}, "308": {"vr": "IS", "Value": [309]}, "309": {"vr": "IS", "Value": [310]}, "310": {"vr": "IS", "Value": [311]}, "311": {"vr": "IS", "Value": [312]}, "312": {"vr": "IS", "Value": [313]}, "313": {"vr": "IS", "Value": [314]}, "314": {"vr": "IS", "Value": [315]}, "315": {"vr": "IS", "Value": [316]}, "316": {"vr": "IS", "Value": [317]}, "317": {"vr": "IS", "Value": [318]}, "318": {"vr": "IS", "Value": [319]}, "319": {"vr": "IS", "Value": [320]}, "320": {"vr": "IS", "Value": [321]}, "321": {"vr": "IS", "Value": [322]}, "322": {"vr": "IS", "Value": [323]}, "323": {"vr": "IS", "Value": [324]}, "324": {"vr": "IS", "Value": [325]}, "325": {"vr": "IS", "Value": [326]}, "326": {"vr": "IS", "Value": [327]}, "327": {"vr": "IS", "Value": [328]}, "328": {"vr": "IS", "Value": [329]}, "329": {"vr": "IS", "Value": [330]}, "330": {"vr": "IS", "Value": [331]}, "331": {"vr": "IS", "Value": [332]}, "332": {"vr": "IS", "Value": [333]}, "333": {"vr": "IS", "Value": [334]}, "334": {"vr": "IS", "Value": [335]}, "335": {"vr": "IS", "Value": [336]}, "336": {"vr": "IS", "Value": [337]}, "337": {"vr": "IS", "Value": [338]}, "338": {"vr": "IS", "Value": [339]}, "339": {"vr": "IS", "Value": [340]}, "340": {"vr": "IS", "Value": [341]}, "341": {"vr": "IS", "Value": [342]}, "342": {"vr": "IS", "Value": [343]}, "343": {"vr": "IS", "Value": [344]}, "344": {"vr": "IS", "Value": [345]}, "345": {"vr": "IS", "Value": [346]}, "346": {"vr": "IS", "Value": [347]}, "347": {"vr": "IS", "Value": [348]}, "348": {"vr": "IS", "Value": [349]}, "349": {"vr": "IS", "Value": [350]}, "350": {"vr": "IS", "Value": [351]}, "351": {"vr": "IS", "Value": [352]}, "352": {"vr": "IS", "Value": [353]}, "353": {"vr": "IS", "Value": [354]}, "354": {"vr": "IS", "Value": [355]}, "355": {"vr": "IS", "Value": [356]}, "356": {"vr": "IS", "Value": [357]}, "357": {"vr": "IS", "Value": [358]}, "358": {"vr": "IS", "Value": [359]}, "359": {"vr": "IS", "Value": [360]}, "360": {"vr": "IS", "Value": [361]}, "361": {"vr": "IS", "Value": [362]}, "362": {"vr": "IS", "Value": [363]}, "363": {"vr": "IS", "Value": [364]}, "364": {"vr": "IS", "Value": [365]}, "365": {"vr": "IS", "Value": [366]}, "366": {"vr": "IS", "Value": [367]}, "367": {"vr": "IS", "Value": [368]}, "368": {"vr": "IS", "Value": [369]}, "369": {"vr": "IS", "Value": [370]}, "370": {"vr": "IS", "Value": [371]}, "371": {"vr": "IS", "Value": [372]}, "372": {"vr": "IS", "Value": [373]}, "373": {"vr": "IS", "Value": [374]}, "374": {"vr": "IS", "Value": [375]}, "375": {"vr": "IS", "Value": [376]}, "376": {"vr": "IS", "Value": [377]}, "377": {"vr": "IS", "Value": [378]}, "378": {"vr": "IS", "Value": [379]}, "379": {"vr": "IS", "Value": [380]}, "380": {"vr": "IS", "Value": [381]}, "381": {"vr": "IS", "Value": [382]}, "382": {"vr": "IS", "Value": [383]}, "383": {"vr": "IS", "Value": [384]}, "384": {"vr": "IS", "Value": [385]}, "385": {"vr": "IS", "Value": [386]}, "386": {"vr": "IS", "Value": [387]}, "387": {"vr": "IS", "Value": [388]}, "388": {"vr": "IS", "Value": [389]}, "389": {"vr": "IS", "Value": [390]}, "390": {"vr": "IS", "Value": [391]}, "391": {"vr": "IS", "Value": [392]}, "392": {"vr": "IS", "Value": [393]}, "393": {"vr": "IS", "Value": [394]}, "394": {"vr": "IS", "Value": [395]}, "395": {"vr": "IS", "Value": [396]}, "396": {"vr": "IS", "Value": [397]}, "397": {"vr": "IS", "Value": [398]}, "398": {"vr": "IS", "Value": [399]}, "399": {"vr": "IS", "Value": [400]}, "400": {"vr": "IS", "Value": [401]}, "401": {"vr": "IS", "Value": [402]}, "402": {"vr": "IS", "Value": [403]}, "403": {"vr": "IS", "Value": [404]}, "404": {"vr": "IS", "Value": [405]}, "405": {"vr": "IS", "Value": [406]}, "406": {"vr": "IS", "Value": [407]}, "407": {"vr": "IS", "Value": [408]}, "408": {"vr": "IS", "Value": [409]}, "409": {"vr": "IS", "Value": [410]}, "410": {"vr": "IS", "Value": [411]}, "411": {"vr": "IS", "Value": [412]}, "412": {"vr": "IS", "Value": [413]}, "413": {"vr": "IS", "Value": [414]}, "414": {"vr": "IS", "Value": [415]}, "415": {"vr": "IS", "Value": [416]}, "416": {"vr": "IS", "Value": [417]}, "417": {"vr": "IS", "Value": [418]}, "418": {"vr": "IS", "Value": [419]}, "419": {"vr": "IS", "Value": [420]}, "420": {"vr": "IS", "Value": [421]}, "421": {"vr": "IS", "Value": [422]}, "422": {"vr": "IS", "Value": [423]}, "423": {"vr": "IS", "Value": [424]}, "424": {"vr": "IS", "Value": [425]}, "425": {"vr": "IS", "Value": [426]}, "426": {"vr": "IS", "Value": [427]}, "427": {"vr": "IS", "Value": [428]}, "428": {"vr": "IS", "Value": [429]}, "429": {"vr": "IS", "Value": [430]}, "430": {"vr": "IS", "Value": [431]}, "431": {"vr": "IS", "Value": [432]}, "432": {"vr": "IS", "Value": [433]}, "433": {"vr": "IS", "Value": [434]}, "434": {"vr": "IS", "Value": [435]}, "435": {"vr": "IS", "Value": [436]}, "436": {"vr": "IS", "Value": [437]}, "437": {"vr": "IS", "Value": [438]}, "438": {"vr": "IS", "Value": [439]}, "439": {"vr": "IS", "Value": [440]}, "440": {"vr": "IS", "Value": [441]}, "441": {"vr": "IS", "Value": [442]}, "442": {"vr": "IS", "Value": [443]}, "443": {"vr": "IS", "Value": [444]}, "444": {"vr": "IS", "Value": [445]}, "445": {"vr": "IS", "Value": [446]}, "446": {"vr": "IS", "Value": [447]}, "447": {"vr": "IS", "Value": [448]}, "448": {"vr": "IS", "Value": [449]}, "449": {"vr": "IS", "Value": [450]}, "450": {"vr": "IS", "Value": [451]}, "451": {"vr": "IS", "Value": [452]}, "452": {"vr": "IS", "Value": [453]}, "453": {"vr": "IS", "Value": [454]}, "454": {"vr": "IS", "Value": [455]}, "455": {"vr": "IS", "Value": [456]}, "456": {"vr": "IS", "Value": [457]}, "457": {"vr": "IS", "Value": [458]}, "458": {"vr": "IS", "Value": [459]}, "459": {"vr": "IS", "Value": [460]}, "460": {"vr": "IS", "Value": [461]}, "461": {"vr": "IS", "Value": [462]}, "462": {"vr": "IS", "Value": [463]}, "463": {"vr": "IS", "Value": [464]}, "464": {"vr": "IS", "Value": [465]}, "465": {"vr": "IS", "Value": [466]}, "466": {"vr": "IS", "Value": [467]}, "467": {"vr": "IS", "Value": [468]}, "468": {"vr": "IS", "Value": [469]}, "469": {"vr": "IS", "Value": [470]}, "470": {"vr": "IS", "Value": [471]}, "471": {"vr": "IS", "Value": [472]}, "472": {"vr": "IS", "Value": [473]}, "473": {"vr": "IS", "Value": [474]}, "474": {"vr": "IS", "Value": [475]}, "475": {"vr": "IS", "Value": [476]}, "476": {"vr": "IS", "Value": [477]}, "477": {"vr": "IS", "Value": [478]}, "478": {"vr": "IS", "Value": [479]}, "479": {"vr": "IS", "Value": [480]}, "480": {"vr": "IS", "Value": [481]}, "481": {"vr": "IS", "Value": [482]}, "482": {"vr": "IS", "Value": [483]}, "483": {"vr": "IS", "Value": [484]}, "484": {"vr": "IS", "Value": [485]}, "485": {"vr": "IS", "Value": [486]}, "486": {"vr": "IS", "Value": [487]}, "487": {"vr": "IS", "Value": [488]}, "488": {"vr": "IS", "Value": [489]}, "489": {"vr": "IS", "Value": [490]}, "490": {"vr": "IS", "Value": [491]}, "491": {"vr": "IS", "Value": [492]}, "492": {"vr": "IS", "Value": [493]}, "493": {"vr": "IS", "Value": [494]}, "494": {"vr": "IS", "Value": [495]}, "495": {"vr": "IS", "Value": [496]}, "496": {"vr": "IS", "Value": [497]}, "497": {"vr": "IS", "Value": [498]}, "498": {"vr": "IS", "Value": [499]}, "499": {"vr": "IS", "Value": [500]}, "500": {"vr": "IS", "Value": [501]}, "501": {"vr": "IS", "Value": [502]}, "502": {"vr": "IS", "Value": [503]}, "503": {"vr": "IS", "Value": [504]}, "504": {"vr": "IS", "Value": [505]}, "505": {"vr": "IS", "Value": [506]}, "506": {"vr": "IS", "Value": [507]}, "507": {"vr": "IS", "Value": [508]}, "508": {"vr": "IS", "Value": [509]}, "509": {"vr": "IS", "Value": [510]}, "510": {"vr": "IS", "Value": [511]}, "511": {"vr": "IS", "Value": [512]}, "512": {"vr": "IS", "Value": [513]}, "513": {"vr": "IS", "Value": [514]}, "514": {"vr": "IS", "Value": [515]}, "515": {"vr": "IS", "Value": [516]}, "516": {"vr": "IS", "Value": [517]}, "517": {"vr": "IS", "Value": [518]}, "518": {"vr": "IS", "Value": [519]}, "519": {"vr": "IS", "Value": [520]}, "520": {"vr": "IS", "Value": [521]}, "521": {"vr": "IS", "Value": [522]}, "522": {"vr": "IS", "Value": [523]}, "523": {"vr": "IS", "Value": [524]}, "524": {"vr": "IS", "Value": [525]}, "525": {"vr": "IS", "Value": [526]}, "526": {"vr": "IS", "Value": [527]}, "527": {"vr": "IS", "Value": [528]}, "528": {"vr": "IS", "Value": [529]}, "529": {"vr": "IS", "Value": [530]}, "530": {"vr": "IS", "Value": [531]}}, "00200032": {"0": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 168.5]}, "1": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 166.5]}, "2": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 164.5]}, "3": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 162.5]}, "4": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 160.5]}, "5": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 158.5]}, "6": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 156.5]}, "7": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 154.5]}, "8": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 152.5]}, "9": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 150.5]}, "10": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 148.5]}, "11": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 146.5]}, "12": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 144.5]}, "13": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 142.5]}, "14": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 140.5]}, "15": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 138.5]}, "16": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 136.5]}, "17": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 134.5]}, "18": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 132.5]}, "19": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 130.5]}, "20": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 128.5]}, "21": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 126.5]}, "22": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 124.5]}, "23": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 122.5]}, "24": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 120.5]}, "25": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 118.5]}, "26": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 116.5]}, "27": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 114.5]}, "28": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 112.5]}, "29": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 110.5]}, "30": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 108.5]}, "31": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 106.5]}, "32": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 104.5]}, "33": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 102.5]}, "34": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 100.5]}, "35": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 98.5]}, "36": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 96.5]}, "37": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 94.5]}, "38": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 92.5]}, "39": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 90.5]}, "40": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 88.5]}, "41": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 86.5]}, "42": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 84.5]}, "43": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 82.5]}, "44": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 80.5]}, "45": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 78.5]}, "46": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 76.5]}, "47": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 74.5]}, "48": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 72.5]}, "49": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 70.5]}, "50": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 68.5]}, "51": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 66.5]}, "52": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 64.5]}, "53": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 62.5]}, "54": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 60.5]}, "55": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 58.5]}, "56": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 56.5]}, "57": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 54.5]}, "58": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 52.5]}, "59": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 50.5]}, "60": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 48.5]}, "61": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 46.5]}, "62": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 44.5]}, "63": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 42.5]}, "64": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 40.5]}, "65": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 38.5]}, "66": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 36.5]}, "67": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 34.5]}, "68": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 32.5]}, "69": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 30.5]}, "70": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 28.5]}, "71": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 26.5]}, "72": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 24.5]}, "73": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 22.5]}, "74": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 20.5]}, "75": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 18.5]}, "76": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 16.5]}, "77": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 14.5]}, "78": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 12.5]}, "79": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 10.5]}, "80": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 8.5]}, "81": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 6.5]}, "82": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 4.5]}, "83": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 2.5]}, "84": {"vr": "DS", "Value": [-389.23828125, -529.73828125, 0.5]}, "85": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -1.5]}, "86": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -3.5]}, "87": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -5.5]}, "88": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -7.5]}, "89": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -9.5]}, "90": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -11.5]}, "91": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -13.5]}, "92": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -15.5]}, "93": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -17.5]}, "94": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -19.5]}, "95": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -21.5]}, "96": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -23.5]}, "97": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -25.5]}, "98": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -27.5]}, "99": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -29.5]}, "100": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -31.5]}, "101": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -33.5]}, "102": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -35.5]}, "103": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -37.5]}, "104": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -39.5]}, "105": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -41.5]}, "106": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -43.5]}, "107": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -45.5]}, "108": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -47.5]}, "109": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -49.5]}, "110": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -51.5]}, "111": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -53.5]}, "112": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -55.5]}, "113": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -57.5]}, "114": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -59.5]}, "115": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -61.5]}, "116": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -63.5]}, "117": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -65.5]}, "118": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -67.5]}, "119": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -69.5]}, "120": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -71.5]}, "121": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -73.5]}, "122": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -75.5]}, "123": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -77.5]}, "124": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -79.5]}, "125": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -81.5]}, "126": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -83.5]}, "127": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -85.5]}, "128": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -87.5]}, "129": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -89.5]}, "130": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -91.5]}, "131": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -93.5]}, "132": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -95.5]}, "133": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -97.5]}, "134": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -99.5]}, "135": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -101.5]}, "136": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -103.5]}, "137": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -105.5]}, "138": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -107.5]}, "139": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -109.5]}, "140": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -111.5]}, "141": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -113.5]}, "142": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -115.5]}, "143": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -117.5]}, "144": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -119.5]}, "145": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -121.5]}, "146": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -123.5]}, "147": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -125.5]}, "148": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -127.5]}, "149": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -129.5]}, "150": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -131.5]}, "151": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -133.5]}, "152": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -135.5]}, "153": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -137.5]}, "154": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -139.5]}, "155": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -141.5]}, "156": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -143.5]}, "157": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -145.5]}, "158": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -147.5]}, "159": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -149.5]}, "160": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -151.5]}, "161": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -153.5]}, "162": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -155.5]}, "163": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -157.5]}, "164": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -159.5]}, "165": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -161.5]}, "166": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -163.5]}, "167": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -165.5]}, "168": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -167.5]}, "169": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -169.5]}, "170": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -171.5]}, "171": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -173.5]}, "172": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -175.5]}, "173": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -177.5]}, "174": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -179.5]}, "175": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -181.5]}, "176": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -183.5]}, "177": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -185.5]}, "178": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -187.5]}, "179": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -189.5]}, "180": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -191.5]}, "181": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -193.5]}, "182": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -195.5]}, "183": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -197.5]}, "184": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -199.5]}, "185": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -201.5]}, "186": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -203.5]}, "187": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -205.5]}, "188": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -207.5]}, "189": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -209.5]}, "190": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -211.5]}, "191": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -213.5]}, "192": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -215.5]}, "193": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -217.5]}, "194": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -219.5]}, "195": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -221.5]}, "196": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -223.5]}, "197": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -225.5]}, "198": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -227.5]}, "199": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -229.5]}, "200": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -231.5]}, "201": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -233.5]}, "202": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -235.5]}, "203": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -237.5]}, "204": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -239.5]}, "205": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -241.5]}, "206": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -243.5]}, "207": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -245.5]}, "208": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -247.5]}, "209": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -249.5]}, "210": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -251.5]}, "211": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -253.5]}, "212": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -255.5]}, "213": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -257.5]}, "214": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -259.5]}, "215": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -261.5]}, "216": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -263.5]}, "217": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -265.5]}, "218": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -267.5]}, "219": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -269.5]}, "220": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -271.5]}, "221": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -273.5]}, "222": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -275.5]}, "223": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -277.5]}, "224": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -279.5]}, "225": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -281.5]}, "226": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -283.5]}, "227": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -285.5]}, "228": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -287.5]}, "229": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -289.5]}, "230": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -291.5]}, "231": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -293.5]}, "232": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -295.5]}, "233": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -297.5]}, "234": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -299.5]}, "235": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -301.5]}, "236": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -303.5]}, "237": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -305.5]}, "238": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -307.5]}, "239": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -309.5]}, "240": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -311.5]}, "241": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -313.5]}, "242": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -315.5]}, "243": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -317.5]}, "244": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -319.5]}, "245": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -321.5]}, "246": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -323.5]}, "247": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -325.5]}, "248": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -327.5]}, "249": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -329.5]}, "250": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -331.5]}, "251": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -333.5]}, "252": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -335.5]}, "253": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -337.5]}, "254": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -339.5]}, "255": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -341.5]}, "256": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -343.5]}, "257": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -345.5]}, "258": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -347.5]}, "259": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -349.5]}, "260": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -351.5]}, "261": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -353.5]}, "262": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -355.5]}, "263": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -357.5]}, "264": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -359.5]}, "265": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -361.5]}, "266": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -363.5]}, "267": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -365.5]}, "268": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -367.5]}, "269": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -369.5]}, "270": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -371.5]}, "271": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -373.5]}, "272": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -375.5]}, "273": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -377.5]}, "274": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -379.5]}, "275": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -381.5]}, "276": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -383.5]}, "277": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -385.5]}, "278": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -387.5]}, "279": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -389.5]}, "280": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -391.5]}, "281": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -393.5]}, "282": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -395.5]}, "283": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -397.5]}, "284": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -399.5]}, "285": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -401.5]}, "286": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -403.5]}, "287": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -405.5]}, "288": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -407.5]}, "289": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -409.5]}, "290": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -411.5]}, "291": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -413.5]}, "292": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -415.5]}, "293": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -417.5]}, "294": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -419.5]}, "295": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -421.5]}, "296": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -423.5]}, "297": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -425.5]}, "298": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -427.5]}, "299": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -429.5]}, "300": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -431.5]}, "301": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -433.5]}, "302": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -435.5]}, "303": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -437.5]}, "304": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -439.5]}, "305": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -441.5]}, "306": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -443.5]}, "307": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -445.5]}, "308": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -447.5]}, "309": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -449.5]}, "310": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -451.5]}, "311": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -453.5]}, "312": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -455.5]}, "313": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -457.5]}, "314": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -459.5]}, "315": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -461.5]}, "316": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -463.5]}, "317": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -465.5]}, "318": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -467.5]}, "319": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -469.5]}, "320": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -471.5]}, "321": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -473.5]}, "322": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -475.5]}, "323": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -477.5]}, "324": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -479.5]}, "325": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -481.5]}, "326": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -483.5]}, "327": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -485.5]}, "328": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -487.5]}, "329": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -489.5]}, "330": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -491.5]}, "331": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -493.5]}, "332": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -495.5]}, "333": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -497.5]}, "334": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -499.5]}, "335": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -501.5]}, "336": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -503.5]}, "337": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -505.5]}, "338": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -507.5]}, "339": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -509.5]}, "340": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -511.5]}, "341": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -513.5]}, "342": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -515.5]}, "343": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -517.5]}, "344": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -519.5]}, "345": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -521.5]}, "346": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -523.5]}, "347": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -525.5]}, "348": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -527.5]}, "349": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -529.5]}, "350": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -531.5]}, "351": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -533.5]}, "352": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -535.5]}, "353": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -537.5]}, "354": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -539.5]}, "355": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -541.5]}, "356": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -543.5]}, "357": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -545.5]}, "358": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -547.5]}, "359": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -549.5]}, "360": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -551.5]}, "361": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -553.5]}, "362": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -555.5]}, "363": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -557.5]}, "364": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -559.5]}, "365": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -561.5]}, "366": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -563.5]}, "367": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -565.5]}, "368": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -567.5]}, "369": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -569.5]}, "370": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -571.5]}, "371": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -573.5]}, "372": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -575.5]}, "373": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -577.5]}, "374": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -579.5]}, "375": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -581.5]}, "376": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -583.5]}, "377": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -585.5]}, "378": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -587.5]}, "379": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -589.5]}, "380": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -591.5]}, "381": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -593.5]}, "382": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -595.5]}, "383": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -597.5]}, "384": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -599.5]}, "385": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -601.5]}, "386": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -603.5]}, "387": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -605.5]}, "388": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -607.5]}, "389": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -609.5]}, "390": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -611.5]}, "391": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -613.5]}, "392": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -615.5]}, "393": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -617.5]}, "394": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -619.5]}, "395": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -621.5]}, "396": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -623.5]}, "397": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -625.5]}, "398": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -627.5]}, "399": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -629.5]}, "400": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -631.5]}, "401": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -633.5]}, "402": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -635.5]}, "403": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -637.5]}, "404": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -639.5]}, "405": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -641.5]}, "406": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -643.5]}, "407": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -645.5]}, "408": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -647.5]}, "409": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -649.5]}, "410": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -651.5]}, "411": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -653.5]}, "412": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -655.5]}, "413": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -657.5]}, "414": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -659.5]}, "415": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -661.5]}, "416": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -663.5]}, "417": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -665.5]}, "418": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -667.5]}, "419": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -669.5]}, "420": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -671.5]}, "421": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -673.5]}, "422": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -675.5]}, "423": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -677.5]}, "424": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -679.5]}, "425": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -681.5]}, "426": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -683.5]}, "427": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -685.5]}, "428": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -687.5]}, "429": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -689.5]}, "430": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -691.5]}, "431": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -693.5]}, "432": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -695.5]}, "433": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -697.5]}, "434": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -699.5]}, "435": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -701.5]}, "436": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -703.5]}, "437": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -705.5]}, "438": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -707.5]}, "439": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -709.5]}, "440": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -711.5]}, "441": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -713.5]}, "442": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -715.5]}, "443": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -717.5]}, "444": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -719.5]}, "445": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -721.5]}, "446": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -723.5]}, "447": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -725.5]}, "448": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -727.5]}, "449": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -729.5]}, "450": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -731.5]}, "451": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -733.5]}, "452": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -735.5]}, "453": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -737.5]}, "454": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -739.5]}, "455": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -741.5]}, "456": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -743.5]}, "457": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -745.5]}, "458": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -747.5]}, "459": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -749.5]}, "460": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -751.5]}, "461": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -753.5]}, "462": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -755.5]}, "463": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -757.5]}, "464": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -759.5]}, "465": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -761.5]}, "466": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -763.5]}, "467": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -765.5]}, "468": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -767.5]}, "469": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -769.5]}, "470": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -771.5]}, "471": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -773.5]}, "472": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -775.5]}, "473": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -777.5]}, "474": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -779.5]}, "475": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -781.5]}, "476": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -783.5]}, "477": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -785.5]}, "478": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -787.5]}, "479": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -789.5]}, "480": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -791.5]}, "481": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -793.5]}, "482": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -795.5]}, "483": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -797.5]}, "484": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -799.5]}, "485": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -801.5]}, "486": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -803.5]}, "487": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -805.5]}, "488": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -807.5]}, "489": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -809.5]}, "490": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -811.5]}, "491": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -813.5]}, "492": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -815.5]}, "493": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -817.5]}, "494": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -819.5]}, "495": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -821.5]}, "496": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -823.5]}, "497": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -825.5]}, "498": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -827.5]}, "499": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -829.5]}, "500": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -831.5]}, "501": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -833.5]}, "502": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -835.5]}, "503": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -837.5]}, "504": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -839.5]}, "505": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -841.5]}, "506": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -843.5]}, "507": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -845.5]}, "508": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -847.5]}, "509": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -849.5]}, "510": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -851.5]}, "511": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -853.5]}, "512": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -855.5]}, "513": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -857.5]}, "514": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -859.5]}, "515": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -861.5]}, "516": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -863.5]}, "517": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -865.5]}, "518": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -867.5]}, "519": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -869.5]}, "520": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -871.5]}, "521": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -873.5]}, "522": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -875.5]}, "523": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -877.5]}, "524": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -879.5]}, "525": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -881.5]}, "526": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -883.5]}, "527": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -885.5]}, "528": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -887.5]}, "529": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -889.5]}, "530": {"vr": "DS", "Value": [-389.23828125, -529.73828125, -891.5]}}, "00201041": {"0": {"vr": "DS", "Value": [168.5]}, "1": {"vr": "DS", "Value": [166.5]}, "2": {"vr": "DS", "Value": [164.5]}, "3": {"vr": "DS", "Value": [162.5]}, "4": {"vr": "DS", "Value": [160.5]}, "5": {"vr": "DS", "Value": [158.5]}, "6": {"vr": "DS", "Value": [156.5]}, "7": {"vr": "DS", "Value": [154.5]}, "8": {"vr": "DS", "Value": [152.5]}, "9": {"vr": "DS", "Value": [150.5]}, "10": {"vr": "DS", "Value": [148.5]}, "11": {"vr": "DS", "Value": [146.5]}, "12": {"vr": "DS", "Value": [144.5]}, "13": {"vr": "DS", "Value": [142.5]}, "14": {"vr": "DS", "Value": [140.5]}, "15": {"vr": "DS", "Value": [138.5]}, "16": {"vr": "DS", "Value": [136.5]}, "17": {"vr": "DS", "Value": [134.5]}, "18": {"vr": "DS", "Value": [132.5]}, "19": {"vr": "DS", "Value": [130.5]}, "20": {"vr": "DS", "Value": [128.5]}, "21": {"vr": "DS", "Value": [126.5]}, "22": {"vr": "DS", "Value": [124.5]}, "23": {"vr": "DS", "Value": [122.5]}, "24": {"vr": "DS", "Value": [120.5]}, "25": {"vr": "DS", "Value": [118.5]}, "26": {"vr": "DS", "Value": [116.5]}, "27": {"vr": "DS", "Value": [114.5]}, "28": {"vr": "DS", "Value": [112.5]}, "29": {"vr": "DS", "Value": [110.5]}, "30": {"vr": "DS", "Value": [108.5]}, "31": {"vr": "DS", "Value": [106.5]}, "32": {"vr": "DS", "Value": [104.5]}, "33": {"vr": "DS", "Value": [102.5]}, "34": {"vr": "DS", "Value": [100.5]}, "35": {"vr": "DS", "Value": [98.5]}, "36": {"vr": "DS", "Value": [96.5]}, "37": {"vr": "DS", "Value": [94.5]}, "38": {"vr": "DS", "Value": [92.5]}, "39": {"vr": "DS", "Value": [90.5]}, "40": {"vr": "DS", "Value": [88.5]}, "41": {"vr": "DS", "Value": [86.5]}, "42": {"vr": "DS", "Value": [84.5]}, "43": {"vr": "DS", "Value": [82.5]}, "44": {"vr": "DS", "Value": [80.5]}, "45": {"vr": "DS", "Value": [78.5]}, "46": {"vr": "DS", "Value": [76.5]}, "47": {"vr": "DS", "Value": [74.5]}, "48": {"vr": "DS", "Value": [72.5]}, "49": {"vr": "DS", "Value": [70.5]}, "50": {"vr": "DS", "Value": [68.5]}, "51": {"vr": "DS", "Value": [66.5]}, "52": {"vr": "DS", "Value": [64.5]}, "53": {"vr": "DS", "Value": [62.5]}, "54": {"vr": "DS", "Value": [60.5]}, "55": {"vr": "DS", "Value": [58.5]}, "56": {"vr": "DS", "Value": [56.5]}, "57": {"vr": "DS", "Value": [54.5]}, "58": {"vr": "DS", "Value": [52.5]}, "59": {"vr": "DS", "Value": [50.5]}, "60": {"vr": "DS", "Value": [48.5]}, "61": {"vr": "DS", "Value": [46.5]}, "62": {"vr": "DS", "Value": [44.5]}, "63": {"vr": "DS", "Value": [42.5]}, "64": {"vr": "DS", "Value": [40.5]}, "65": {"vr": "DS", "Value": [38.5]}, "66": {"vr": "DS", "Value": [36.5]}, "67": {"vr": "DS", "Value": [34.5]}, "68": {"vr": "DS", "Value": [32.5]}, "69": {"vr": "DS", "Value": [30.5]}, "70": {"vr": "DS", "Value": [28.5]}, "71": {"vr": "DS", "Value": [26.5]}, "72": {"vr": "DS", "Value": [24.5]}, "73": {"vr": "DS", "Value": [22.5]}, "74": {"vr": "DS", "Value": [20.5]}, "75": {"vr": "DS", "Value": [18.5]}, "76": {"vr": "DS", "Value": [16.5]}, "77": {"vr": "DS", "Value": [14.5]}, "78": {"vr": "DS", "Value": [12.5]}, "79": {"vr": "DS", "Value": [10.5]}, "80": {"vr": "DS", "Value": [8.5]}, "81": {"vr": "DS", "Value": [6.5]}, "82": {"vr": "DS", "Value": [4.5]}, "83": {"vr": "DS", "Value": [2.5]}, "84": {"vr": "DS", "Value": [0.5]}, "85": {"vr": "DS", "Value": [-1.5]}, "86": {"vr": "DS", "Value": [-3.5]}, "87": {"vr": "DS", "Value": [-5.5]}, "88": {"vr": "DS", "Value": [-7.5]}, "89": {"vr": "DS", "Value": [-9.5]}, "90": {"vr": "DS", "Value": [-11.5]}, "91": {"vr": "DS", "Value": [-13.5]}, "92": {"vr": "DS", "Value": [-15.5]}, "93": {"vr": "DS", "Value": [-17.5]}, "94": {"vr": "DS", "Value": [-19.5]}, "95": {"vr": "DS", "Value": [-21.5]}, "96": {"vr": "DS", "Value": [-23.5]}, "97": {"vr": "DS", "Value": [-25.5]}, "98": {"vr": "DS", "Value": [-27.5]}, "99": {"vr": "DS", "Value": [-29.5]}, "100": {"vr": "DS", "Value": [-31.5]}, "101": {"vr": "DS", "Value": [-33.5]}, "102": {"vr": "DS", "Value": [-35.5]}, "103": {"vr": "DS", "Value": [-37.5]}, "104": {"vr": "DS", "Value": [-39.5]}, "105": {"vr": "DS", "Value": [-41.5]}, "106": {"vr": "DS", "Value": [-43.5]}, "107": {"vr": "DS", "Value": [-45.5]}, "108": {"vr": "DS", "Value": [-47.5]}, "109": {"vr": "DS", "Value": [-49.5]}, "110": {"vr": "DS", "Value": [-51.5]}, "111": {"vr": "DS", "Value": [-53.5]}, "112": {"vr": "DS", "Value": [-55.5]}, "113": {"vr": "DS", "Value": [-57.5]}, "114": {"vr": "DS", "Value": [-59.5]}, "115": {"vr": "DS", "Value": [-61.5]}, "116": {"vr": "DS", "Value": [-63.5]}, "117": {"vr": "DS", "Value": [-65.5]}, "118": {"vr": "DS", "Value": [-67.5]}, "119": {"vr": "DS", "Value": [-69.5]}, "120": {"vr": "DS", "Value": [-71.5]}, "121": {"vr": "DS", "Value": [-73.5]}, "122": {"vr": "DS", "Value": [-75.5]}, "123": {"vr": "DS", "Value": [-77.5]}, "124": {"vr": "DS", "Value": [-79.5]}, "125": {"vr": "DS", "Value": [-81.5]}, "126": {"vr": "DS", "Value": [-83.5]}, "127": {"vr": "DS", "Value": [-85.5]}, "128": {"vr": "DS", "Value": [-87.5]}, "129": {"vr": "DS", "Value": [-89.5]}, "130": {"vr": "DS", "Value": [-91.5]}, "131": {"vr": "DS", "Value": [-93.5]}, "132": {"vr": "DS", "Value": [-95.5]}, "133": {"vr": "DS", "Value": [-97.5]}, "134": {"vr": "DS", "Value": [-99.5]}, "135": {"vr": "DS", "Value": [-101.5]}, "136": {"vr": "DS", "Value": [-103.5]}, "137": {"vr": "DS", "Value": [-105.5]}, "138": {"vr": "DS", "Value": [-107.5]}, "139": {"vr": "DS", "Value": [-109.5]}, "140": {"vr": "DS", "Value": [-111.5]}, "141": {"vr": "DS", "Value": [-113.5]}, "142": {"vr": "DS", "Value": [-115.5]}, "143": {"vr": "DS", "Value": [-117.5]}, "144": {"vr": "DS", "Value": [-119.5]}, "145": {"vr": "DS", "Value": [-121.5]}, "146": {"vr": "DS", "Value": [-123.5]}, "147": {"vr": "DS", "Value": [-125.5]}, "148": {"vr": "DS", "Value": [-127.5]}, "149": {"vr": "DS", "Value": [-129.5]}, "150": {"vr": "DS", "Value": [-131.5]}, "151": {"vr": "DS", "Value": [-133.5]}, "152": {"vr": "DS", "Value": [-135.5]}, "153": {"vr": "DS", "Value": [-137.5]}, "154": {"vr": "DS", "Value": [-139.5]}, "155": {"vr": "DS", "Value": [-141.5]}, "156": {"vr": "DS", "Value": [-143.5]}, "157": {"vr": "DS", "Value": [-145.5]}, "158": {"vr": "DS", "Value": [-147.5]}, "159": {"vr": "DS", "Value": [-149.5]}, "160": {"vr": "DS", "Value": [-151.5]}, "161": {"vr": "DS", "Value": [-153.5]}, "162": {"vr": "DS", "Value": [-155.5]}, "163": {"vr": "DS", "Value": [-157.5]}, "164": {"vr": "DS", "Value": [-159.5]}, "165": {"vr": "DS", "Value": [-161.5]}, "166": {"vr": "DS", "Value": [-163.5]}, "167": {"vr": "DS", "Value": [-165.5]}, "168": {"vr": "DS", "Value": [-167.5]}, "169": {"vr": "DS", "Value": [-169.5]}, "170": {"vr": "DS", "Value": [-171.5]}, "171": {"vr": "DS", "Value": [-173.5]}, "172": {"vr": "DS", "Value": [-175.5]}, "173": {"vr": "DS", "Value": [-177.5]}, "174": {"vr": "DS", "Value": [-179.5]}, "175": {"vr": "DS", "Value": [-181.5]}, "176": {"vr": "DS", "Value": [-183.5]}, "177": {"vr": "DS", "Value": [-185.5]}, "178": {"vr": "DS", "Value": [-187.5]}, "179": {"vr": "DS", "Value": [-189.5]}, "180": {"vr": "DS", "Value": [-191.5]}, "181": {"vr": "DS", "Value": [-193.5]}, "182": {"vr": "DS", "Value": [-195.5]}, "183": {"vr": "DS", "Value": [-197.5]}, "184": {"vr": "DS", "Value": [-199.5]}, "185": {"vr": "DS", "Value": [-201.5]}, "186": {"vr": "DS", "Value": [-203.5]}, "187": {"vr": "DS", "Value": [-205.5]}, "188": {"vr": "DS", "Value": [-207.5]}, "189": {"vr": "DS", "Value": [-209.5]}, "190": {"vr": "DS", "Value": [-211.5]}, "191": {"vr": "DS", "Value": [-213.5]}, "192": {"vr": "DS", "Value": [-215.5]}, "193": {"vr": "DS", "Value": [-217.5]}, "194": {"vr": "DS", "Value": [-219.5]}, "195": {"vr": "DS", "Value": [-221.5]}, "196": {"vr": "DS", "Value": [-223.5]}, "197": {"vr": "DS", "Value": [-225.5]}, "198": {"vr": "DS", "Value": [-227.5]}, "199": {"vr": "DS", "Value": [-229.5]}, "200": {"vr": "DS", "Value": [-231.5]}, "201": {"vr": "DS", "Value": [-233.5]}, "202": {"vr": "DS", "Value": [-235.5]}, "203": {"vr": "DS", "Value": [-237.5]}, "204": {"vr": "DS", "Value": [-239.5]}, "205": {"vr": "DS", "Value": [-241.5]}, "206": {"vr": "DS", "Value": [-243.5]}, "207": {"vr": "DS", "Value": [-245.5]}, "208": {"vr": "DS", "Value": [-247.5]}, "209": {"vr": "DS", "Value": [-249.5]}, "210": {"vr": "DS", "Value": [-251.5]}, "211": {"vr": "DS", "Value": [-253.5]}, "212": {"vr": "DS", "Value": [-255.5]}, "213": {"vr": "DS", "Value": [-257.5]}, "214": {"vr": "DS", "Value": [-259.5]}, "215": {"vr": "DS", "Value": [-261.5]}, "216": {"vr": "DS", "Value": [-263.5]}, "217": {"vr": "DS", "Value": [-265.5]}, "218": {"vr": "DS", "Value": [-267.5]}, "219": {"vr": "DS", "Value": [-269.5]}, "220": {"vr": "DS", "Value": [-271.5]}, "221": {"vr": "DS", "Value": [-273.5]}, "222": {"vr": "DS", "Value": [-275.5]}, "223": {"vr": "DS", "Value": [-277.5]}, "224": {"vr": "DS", "Value": [-279.5]}, "225": {"vr": "DS", "Value": [-281.5]}, "226": {"vr": "DS", "Value": [-283.5]}, "227": {"vr": "DS", "Value": [-285.5]}, "228": {"vr": "DS", "Value": [-287.5]}, "229": {"vr": "DS", "Value": [-289.5]}, "230": {"vr": "DS", "Value": [-291.5]}, "231": {"vr": "DS", "Value": [-293.5]}, "232": {"vr": "DS", "Value": [-295.5]}, "233": {"vr": "DS", "Value": [-297.5]}, "234": {"vr": "DS", "Value": [-299.5]}, "235": {"vr": "DS", "Value": [-301.5]}, "236": {"vr": "DS", "Value": [-303.5]}, "237": {"vr": "DS", "Value": [-305.5]}, "238": {"vr": "DS", "Value": [-307.5]}, "239": {"vr": "DS", "Value": [-309.5]}, "240": {"vr": "DS", "Value": [-311.5]}, "241": {"vr": "DS", "Value": [-313.5]}, "242": {"vr": "DS", "Value": [-315.5]}, "243": {"vr": "DS", "Value": [-317.5]}, "244": {"vr": "DS", "Value": [-319.5]}, "245": {"vr": "DS", "Value": [-321.5]}, "246": {"vr": "DS", "Value": [-323.5]}, "247": {"vr": "DS", "Value": [-325.5]}, "248": {"vr": "DS", "Value": [-327.5]}, "249": {"vr": "DS", "Value": [-329.5]}, "250": {"vr": "DS", "Value": [-331.5]}, "251": {"vr": "DS", "Value": [-333.5]}, "252": {"vr": "DS", "Value": [-335.5]}, "253": {"vr": "DS", "Value": [-337.5]}, "254": {"vr": "DS", "Value": [-339.5]}, "255": {"vr": "DS", "Value": [-341.5]}, "256": {"vr": "DS", "Value": [-343.5]}, "257": {"vr": "DS", "Value": [-345.5]}, "258": {"vr": "DS", "Value": [-347.5]}, "259": {"vr": "DS", "Value": [-349.5]}, "260": {"vr": "DS", "Value": [-351.5]}, "261": {"vr": "DS", "Value": [-353.5]}, "262": {"vr": "DS", "Value": [-355.5]}, "263": {"vr": "DS", "Value": [-357.5]}, "264": {"vr": "DS", "Value": [-359.5]}, "265": {"vr": "DS", "Value": [-361.5]}, "266": {"vr": "DS", "Value": [-363.5]}, "267": {"vr": "DS", "Value": [-365.5]}, "268": {"vr": "DS", "Value": [-367.5]}, "269": {"vr": "DS", "Value": [-369.5]}, "270": {"vr": "DS", "Value": [-371.5]}, "271": {"vr": "DS", "Value": [-373.5]}, "272": {"vr": "DS", "Value": [-375.5]}, "273": {"vr": "DS", "Value": [-377.5]}, "274": {"vr": "DS", "Value": [-379.5]}, "275": {"vr": "DS", "Value": [-381.5]}, "276": {"vr": "DS", "Value": [-383.5]}, "277": {"vr": "DS", "Value": [-385.5]}, "278": {"vr": "DS", "Value": [-387.5]}, "279": {"vr": "DS", "Value": [-389.5]}, "280": {"vr": "DS", "Value": [-391.5]}, "281": {"vr": "DS", "Value": [-393.5]}, "282": {"vr": "DS", "Value": [-395.5]}, "283": {"vr": "DS", "Value": [-397.5]}, "284": {"vr": "DS", "Value": [-399.5]}, "285": {"vr": "DS", "Value": [-401.5]}, "286": {"vr": "DS", "Value": [-403.5]}, "287": {"vr": "DS", "Value": [-405.5]}, "288": {"vr": "DS", "Value": [-407.5]}, "289": {"vr": "DS", "Value": [-409.5]}, "290": {"vr": "DS", "Value": [-411.5]}, "291": {"vr": "DS", "Value": [-413.5]}, "292": {"vr": "DS", "Value": [-415.5]}, "293": {"vr": "DS", "Value": [-417.5]}, "294": {"vr": "DS", "Value": [-419.5]}, "295": {"vr": "DS", "Value": [-421.5]}, "296": {"vr": "DS", "Value": [-423.5]}, "297": {"vr": "DS", "Value": [-425.5]}, "298": {"vr": "DS", "Value": [-427.5]}, "299": {"vr": "DS", "Value": [-429.5]}, "300": {"vr": "DS", "Value": [-431.5]}, "301": {"vr": "DS", "Value": [-433.5]}, "302": {"vr": "DS", "Value": [-435.5]}, "303": {"vr": "DS", "Value": [-437.5]}, "304": {"vr": "DS", "Value": [-439.5]}, "305": {"vr": "DS", "Value": [-441.5]}, "306": {"vr": "DS", "Value": [-443.5]}, "307": {"vr": "DS", "Value": [-445.5]}, "308": {"vr": "DS", "Value": [-447.5]}, "309": {"vr": "DS", "Value": [-449.5]}, "310": {"vr": "DS", "Value": [-451.5]}, "311": {"vr": "DS", "Value": [-453.5]}, "312": {"vr": "DS", "Value": [-455.5]}, "313": {"vr": "DS", "Value": [-457.5]}, "314": {"vr": "DS", "Value": [-459.5]}, "315": {"vr": "DS", "Value": [-461.5]}, "316": {"vr": "DS", "Value": [-463.5]}, "317": {"vr": "DS", "Value": [-465.5]}, "318": {"vr": "DS", "Value": [-467.5]}, "319": {"vr": "DS", "Value": [-469.5]}, "320": {"vr": "DS", "Value": [-471.5]}, "321": {"vr": "DS", "Value": [-473.5]}, "322": {"vr": "DS", "Value": [-475.5]}, "323": {"vr": "DS", "Value": [-477.5]}, "324": {"vr": "DS", "Value": [-479.5]}, "325": {"vr": "DS", "Value": [-481.5]}, "326": {"vr": "DS", "Value": [-483.5]}, "327": {"vr": "DS", "Value": [-485.5]}, "328": {"vr": "DS", "Value": [-487.5]}, "329": {"vr": "DS", "Value": [-489.5]}, "330": {"vr": "DS", "Value": [-491.5]}, "331": {"vr": "DS", "Value": [-493.5]}, "332": {"vr": "DS", "Value": [-495.5]}, "333": {"vr": "DS", "Value": [-497.5]}, "334": {"vr": "DS", "Value": [-499.5]}, "335": {"vr": "DS", "Value": [-501.5]}, "336": {"vr": "DS", "Value": [-503.5]}, "337": {"vr": "DS", "Value": [-505.5]}, "338": {"vr": "DS", "Value": [-507.5]}, "339": {"vr": "DS", "Value": [-509.5]}, "340": {"vr": "DS", "Value": [-511.5]}, "341": {"vr": "DS", "Value": [-513.5]}, "342": {"vr": "DS", "Value": [-515.5]}, "343": {"vr": "DS", "Value": [-517.5]}, "344": {"vr": "DS", "Value": [-519.5]}, "345": {"vr": "DS", "Value": [-521.5]}, "346": {"vr": "DS", "Value": [-523.5]}, "347": {"vr": "DS", "Value": [-525.5]}, "348": {"vr": "DS", "Value": [-527.5]}, "349": {"vr": "DS", "Value": [-529.5]}, "350": {"vr": "DS", "Value": [-531.5]}, "351": {"vr": "DS", "Value": [-533.5]}, "352": {"vr": "DS", "Value": [-535.5]}, "353": {"vr": "DS", "Value": [-537.5]}, "354": {"vr": "DS", "Value": [-539.5]}, "355": {"vr": "DS", "Value": [-541.5]}, "356": {"vr": "DS", "Value": [-543.5]}, "357": {"vr": "DS", "Value": [-545.5]}, "358": {"vr": "DS", "Value": [-547.5]}, "359": {"vr": "DS", "Value": [-549.5]}, "360": {"vr": "DS", "Value": [-551.5]}, "361": {"vr": "DS", "Value": [-553.5]}, "362": {"vr": "DS", "Value": [-555.5]}, "363": {"vr": "DS", "Value": [-557.5]}, "364": {"vr": "DS", "Value": [-559.5]}, "365": {"vr": "DS", "Value": [-561.5]}, "366": {"vr": "DS", "Value": [-563.5]}, "367": {"vr": "DS", "Value": [-565.5]}, "368": {"vr": "DS", "Value": [-567.5]}, "369": {"vr": "DS", "Value": [-569.5]}, "370": {"vr": "DS", "Value": [-571.5]}, "371": {"vr": "DS", "Value": [-573.5]}, "372": {"vr": "DS", "Value": [-575.5]}, "373": {"vr": "DS", "Value": [-577.5]}, "374": {"vr": "DS", "Value": [-579.5]}, "375": {"vr": "DS", "Value": [-581.5]}, "376": {"vr": "DS", "Value": [-583.5]}, "377": {"vr": "DS", "Value": [-585.5]}, "378": {"vr": "DS", "Value": [-587.5]}, "379": {"vr": "DS", "Value": [-589.5]}, "380": {"vr": "DS", "Value": [-591.5]}, "381": {"vr": "DS", "Value": [-593.5]}, "382": {"vr": "DS", "Value": [-595.5]}, "383": {"vr": "DS", "Value": [-597.5]}, "384": {"vr": "DS", "Value": [-599.5]}, "385": {"vr": "DS", "Value": [-601.5]}, "386": {"vr": "DS", "Value": [-603.5]}, "387": {"vr": "DS", "Value": [-605.5]}, "388": {"vr": "DS", "Value": [-607.5]}, "389": {"vr": "DS", "Value": [-609.5]}, "390": {"vr": "DS", "Value": [-611.5]}, "391": {"vr": "DS", "Value": [-613.5]}, "392": {"vr": "DS", "Value": [-615.5]}, "393": {"vr": "DS", "Value": [-617.5]}, "394": {"vr": "DS", "Value": [-619.5]}, "395": {"vr": "DS", "Value": [-621.5]}, "396": {"vr": "DS", "Value": [-623.5]}, "397": {"vr": "DS", "Value": [-625.5]}, "398": {"vr": "DS", "Value": [-627.5]}, "399": {"vr": "DS", "Value": [-629.5]}, "400": {"vr": "DS", "Value": [-631.5]}, "401": {"vr": "DS", "Value": [-633.5]}, "402": {"vr": "DS", "Value": [-635.5]}, "403": {"vr": "DS", "Value": [-637.5]}, "404": {"vr": "DS", "Value": [-639.5]}, "405": {"vr": "DS", "Value": [-641.5]}, "406": {"vr": "DS", "Value": [-643.5]}, "407": {"vr": "DS", "Value": [-645.5]}, "408": {"vr": "DS", "Value": [-647.5]}, "409": {"vr": "DS", "Value": [-649.5]}, "410": {"vr": "DS", "Value": [-651.5]}, "411": {"vr": "DS", "Value": [-653.5]}, "412": {"vr": "DS", "Value": [-655.5]}, "413": {"vr": "DS", "Value": [-657.5]}, "414": {"vr": "DS", "Value": [-659.5]}, "415": {"vr": "DS", "Value": [-661.5]}, "416": {"vr": "DS", "Value": [-663.5]}, "417": {"vr": "DS", "Value": [-665.5]}, "418": {"vr": "DS", "Value": [-667.5]}, "419": {"vr": "DS", "Value": [-669.5]}, "420": {"vr": "DS", "Value": [-671.5]}, "421": {"vr": "DS", "Value": [-673.5]}, "422": {"vr": "DS", "Value": [-675.5]}, "423": {"vr": "DS", "Value": [-677.5]}, "424": {"vr": "DS", "Value": [-679.5]}, "425": {"vr": "DS", "Value": [-681.5]}, "426": {"vr": "DS", "Value": [-683.5]}, "427": {"vr": "DS", "Value": [-685.5]}, "428": {"vr": "DS", "Value": [-687.5]}, "429": {"vr": "DS", "Value": [-689.5]}, "430": {"vr": "DS", "Value": [-691.5]}, "431": {"vr": "DS", "Value": [-693.5]}, "432": {"vr": "DS", "Value": [-695.5]}, "433": {"vr": "DS", "Value": [-697.5]}, "434": {"vr": "DS", "Value": [-699.5]}, "435": {"vr": "DS", "Value": [-701.5]}, "436": {"vr": "DS", "Value": [-703.5]}, "437": {"vr": "DS", "Value": [-705.5]}, "438": {"vr": "DS", "Value": [-707.5]}, "439": {"vr": "DS", "Value": [-709.5]}, "440": {"vr": "DS", "Value": [-711.5]}, "441": {"vr": "DS", "Value": [-713.5]}, "442": {"vr": "DS", "Value": [-715.5]}, "443": {"vr": "DS", "Value": [-717.5]}, "444": {"vr": "DS", "Value": [-719.5]}, "445": {"vr": "DS", "Value": [-721.5]}, "446": {"vr": "DS", "Value": [-723.5]}, "447": {"vr": "DS", "Value": [-725.5]}, "448": {"vr": "DS", "Value": [-727.5]}, "449": {"vr": "DS", "Value": [-729.5]}, "450": {"vr": "DS", "Value": [-731.5]}, "451": {"vr": "DS", "Value": [-733.5]}, "452": {"vr": "DS", "Value": [-735.5]}, "453": {"vr": "DS", "Value": [-737.5]}, "454": {"vr": "DS", "Value": [-739.5]}, "455": {"vr": "DS", "Value": [-741.5]}, "456": {"vr": "DS", "Value": [-743.5]}, "457": {"vr": "DS", "Value": [-745.5]}, "458": {"vr": "DS", "Value": [-747.5]}, "459": {"vr": "DS", "Value": [-749.5]}, "460": {"vr": "DS", "Value": [-751.5]}, "461": {"vr": "DS", "Value": [-753.5]}, "462": {"vr": "DS", "Value": [-755.5]}, "463": {"vr": "DS", "Value": [-757.5]}, "464": {"vr": "DS", "Value": [-759.5]}, "465": {"vr": "DS", "Value": [-761.5]}, "466": {"vr": "DS", "Value": [-763.5]}, "467": {"vr": "DS", "Value": [-765.5]}, "468": {"vr": "DS", "Value": [-767.5]}, "469": {"vr": "DS", "Value": [-769.5]}, "470": {"vr": "DS", "Value": [-771.5]}, "471": {"vr": "DS", "Value": [-773.5]}, "472": {"vr": "DS", "Value": [-775.5]}, "473": {"vr": "DS", "Value": [-777.5]}, "474": {"vr": "DS", "Value": [-779.5]}, "475": {"vr": "DS", "Value": [-781.5]}, "476": {"vr": "DS", "Value": [-783.5]}, "477": {"vr": "DS", "Value": [-785.5]}, "478": {"vr": "DS", "Value": [-787.5]}, "479": {"vr": "DS", "Value": [-789.5]}, "480": {"vr": "DS", "Value": [-791.5]}, "481": {"vr": "DS", "Value": [-793.5]}, "482": {"vr": "DS", "Value": [-795.5]}, "483": {"vr": "DS", "Value": [-797.5]}, "484": {"vr": "DS", "Value": [-799.5]}, "485": {"vr": "DS", "Value": [-801.5]}, "486": {"vr": "DS", "Value": [-803.5]}, "487": {"vr": "DS", "Value": [-805.5]}, "488": {"vr": "DS", "Value": [-807.5]}, "489": {"vr": "DS", "Value": [-809.5]}, "490": {"vr": "DS", "Value": [-811.5]}, "491": {"vr": "DS", "Value": [-813.5]}, "492": {"vr": "DS", "Value": [-815.5]}, "493": {"vr": "DS", "Value": [-817.5]}, "494": {"vr": "DS", "Value": [-819.5]}, "495": {"vr": "DS", "Value": [-821.5]}, "496": {"vr": "DS", "Value": [-823.5]}, "497": {"vr": "DS", "Value": [-825.5]}, "498": {"vr": "DS", "Value": [-827.5]}, "499": {"vr": "DS", "Value": [-829.5]}, "500": {"vr": "DS", "Value": [-831.5]}, "501": {"vr": "DS", "Value": [-833.5]}, "502": {"vr": "DS", "Value": [-835.5]}, "503": {"vr": "DS", "Value": [-837.5]}, "504": {"vr": "DS", "Value": [-839.5]}, "505": {"vr": "DS", "Value": [-841.5]}, "506": {"vr": "DS", "Value": [-843.5]}, "507": {"vr": "DS", "Value": [-845.5]}, "508": {"vr": "DS", "Value": [-847.5]}, "509": {"vr": "DS", "Value": [-849.5]}, "510": {"vr": "DS", "Value": [-851.5]}, "511": {"vr": "DS", "Value": [-853.5]}, "512": {"vr": "DS", "Value": [-855.5]}, "513": {"vr": "DS", "Value": [-857.5]}, "514": {"vr": "DS", "Value": [-859.5]}, "515": {"vr": "DS", "Value": [-861.5]}, "516": {"vr": "DS", "Value": [-863.5]}, "517": {"vr": "DS", "Value": [-865.5]}, "518": {"vr": "DS", "Value": [-867.5]}, "519": {"vr": "DS", "Value": [-869.5]}, "520": {"vr": "DS", "Value": [-871.5]}, "521": {"vr": "DS", "Value": [-873.5]}, "522": {"vr": "DS", "Value": [-875.5]}, "523": {"vr": "DS", "Value": [-877.5]}, "524": {"vr": "DS", "Value": [-879.5]}, "525": {"vr": "DS", "Value": [-881.5]}, "526": {"vr": "DS", "Value": [-883.5]}, "527": {"vr": "DS", "Value": [-885.5]}, "528": {"vr": "DS", "Value": [-887.5]}, "529": {"vr": "DS", "Value": [-889.5]}, "530": {"vr": "DS", "Value": [-891.5]}}, "00280107": {"0": {"vr": "US", "Value": [44]}, "1": {"vr": "US", "Value": [42]}, "2": {"vr": "US", "Value": [42]}, "3": {"vr": "US", "Value": [41]}, "4": {"vr": "US", "Value": [41]}, "5": {"vr": "US", "Value": [42]}, "6": {"vr": "US", "Value": [41]}, "7": {"vr": "US", "Value": [39]}, "8": {"vr": "US", "Value": [41]}, "9": {"vr": "US", "Value": [39]}, "10": {"vr": "US", "Value": [39]}, "11": {"vr": "US", "Value": [39]}, "12": {"vr": "US", "Value": [40]}, "13": {"vr": "US", "Value": [39]}, "14": {"vr": "US", "Value": [40]}, "15": {"vr": "US", "Value": [39]}, "16": {"vr": "US", "Value": [43]}, "17": {"vr": "US", "Value": [38]}, "18": {"vr": "US", "Value": [41]}, "19": {"vr": "US", "Value": [39]}, "20": {"vr": "US", "Value": [39]}, "21": {"vr": "US", "Value": [42]}, "22": {"vr": "US", "Value": [41]}, "23": {"vr": "US", "Value": [39]}, "24": {"vr": "US", "Value": [40]}, "25": {"vr": "US", "Value": [41]}, "26": {"vr": "US", "Value": [41]}, "27": {"vr": "US", "Value": [40]}, "28": {"vr": "US", "Value": [40]}, "29": {"vr": "US", "Value": [40]}, "30": {"vr": "US", "Value": [38]}, "31": {"vr": "US", "Value": [41]}, "32": {"vr": "US", "Value": [38]}, "33": {"vr": "US", "Value": [39]}, "34": {"vr": "US", "Value": [40]}, "35": {"vr": "US", "Value": [38]}, "36": {"vr": "US", "Value": [40]}, "37": {"vr": "US", "Value": [42]}, "38": {"vr": "US", "Value": [41]}, "39": {"vr": "US", "Value": [41]}, "40": {"vr": "US", "Value": [40]}, "41": {"vr": "US", "Value": [39]}, "42": {"vr": "US", "Value": [39]}, "43": {"vr": "US", "Value": [40]}, "44": {"vr": "US", "Value": [40]}, "45": {"vr": "US", "Value": [40]}, "46": {"vr": "US", "Value": [40]}, "47": {"vr": "US", "Value": [39]}, "48": {"vr": "US", "Value": [43]}, "49": {"vr": "US", "Value": [40]}, "50": {"vr": "US", "Value": [107]}, "51": {"vr": "US", "Value": [578]}, "52": {"vr": "US", "Value": [1214]}, "53": {"vr": "US", "Value": [1338]}, "54": {"vr": "US", "Value": [1408]}, "55": {"vr": "US", "Value": [1438]}, "56": {"vr": "US", "Value": [1457]}, "57": {"vr": "US", "Value": [1478]}, "58": {"vr": "US", "Value": [1452]}, "59": {"vr": "US", "Value": [1477]}, "60": {"vr": "US", "Value": [1510]}, "61": {"vr": "US", "Value": [1520]}, "62": {"vr": "US", "Value": [1521]}, "63": {"vr": "US", "Value": [1522]}, "64": {"vr": "US", "Value": [1527]}, "65": {"vr": "US", "Value": [1546]}, "66": {"vr": "US", "Value": [2604]}, "67": {"vr": "US", "Value": [4015]}, "68": {"vr": "US", "Value": [4094]}, "69": {"vr": "US", "Value": [4095]}, "70": {"vr": "US", "Value": [4094]}, "71": {"vr": "US", "Value": [4095]}, "72": {"vr": "US", "Value": [4094]}, "73": {"vr": "US", "Value": [4095]}, "74": {"vr": "US", "Value": [4095]}, "75": {"vr": "US", "Value": [4095]}, "76": {"vr": "US", "Value": [4095]}, "77": {"vr": "US", "Value": [4095]}, "78": {"vr": "US", "Value": [4095]}, "79": {"vr": "US", "Value": [4095]}, "80": {"vr": "US", "Value": [4095]}, "81": {"vr": "US", "Value": [4095]}, "82": {"vr": "US", "Value": [4095]}, "83": {"vr": "US", "Value": [4095]}, "84": {"vr": "US", "Value": [4095]}, "85": {"vr": "US", "Value": [4095]}, "86": {"vr": "US", "Value": [2361]}, "87": {"vr": "US", "Value": [1012]}, "88": {"vr": "US", "Value": [999]}, "89": {"vr": "US", "Value": [991]}, "90": {"vr": "US", "Value": [987]}, "91": {"vr": "US", "Value": [1015]}, "92": {"vr": "US", "Value": [1066]}, "93": {"vr": "US", "Value": [1187]}, "94": {"vr": "US", "Value": [1195]}, "95": {"vr": "US", "Value": [1151]}, "96": {"vr": "US", "Value": [1140]}, "97": {"vr": "US", "Value": [1133]}, "98": {"vr": "US", "Value": [1132]}, "99": {"vr": "US", "Value": [1137]}, "100": {"vr": "US", "Value": [1135]}, "101": {"vr": "US", "Value": [1137]}, "102": {"vr": "US", "Value": [1139]}, "103": {"vr": "US", "Value": [1143]}, "104": {"vr": "US", "Value": [1137]}, "105": {"vr": "US", "Value": [1142]}, "106": {"vr": "US", "Value": [1147]}, "107": {"vr": "US", "Value": [1132]}, "108": {"vr": "US", "Value": [1137]}, "109": {"vr": "US", "Value": [1142]}, "110": {"vr": "US", "Value": [1134]}, "111": {"vr": "US", "Value": [1140]}, "112": {"vr": "US", "Value": [1141]}, "113": {"vr": "US", "Value": [1131]}, "114": {"vr": "US", "Value": [1135]}, "115": {"vr": "US", "Value": [1136]}, "116": {"vr": "US", "Value": [1133]}, "117": {"vr": "US", "Value": [1137]}, "118": {"vr": "US", "Value": [1137]}, "119": {"vr": "US", "Value": [1142]}, "120": {"vr": "US", "Value": [1140]}, "121": {"vr": "US", "Value": [1131]}, "122": {"vr": "US", "Value": [1132]}, "123": {"vr": "US", "Value": [1138]}, "124": {"vr": "US", "Value": [1130]}, "125": {"vr": "US", "Value": [1135]}, "126": {"vr": "US", "Value": [1133]}, "127": {"vr": "US", "Value": [1138]}, "128": {"vr": "US", "Value": [1130]}, "129": {"vr": "US", "Value": [1132]}, "130": {"vr": "US", "Value": [1137]}, "131": {"vr": "US", "Value": [1133]}, "132": {"vr": "US", "Value": [1135]}, "133": {"vr": "US", "Value": [1135]}, "134": {"vr": "US", "Value": [1129]}, "135": {"vr": "US", "Value": [1130]}, "136": {"vr": "US", "Value": [1132]}, "137": {"vr": "US", "Value": [1136]}, "138": {"vr": "US", "Value": [1136]}, "139": {"vr": "US", "Value": [1133]}, "140": {"vr": "US", "Value": [1144]}, "141": {"vr": "US", "Value": [1136]}, "142": {"vr": "US", "Value": [1131]}, "143": {"vr": "US", "Value": [1130]}, "144": {"vr": "US", "Value": [1138]}, "145": {"vr": "US", "Value": [1133]}, "146": {"vr": "US", "Value": [1131]}, "147": {"vr": "US", "Value": [1137]}, "148": {"vr": "US", "Value": [1143]}, "149": {"vr": "US", "Value": [1136]}, "150": {"vr": "US", "Value": [1138]}, "151": {"vr": "US", "Value": [1137]}, "152": {"vr": "US", "Value": [1129]}, "153": {"vr": "US", "Value": [1134]}, "154": {"vr": "US", "Value": [1137]}, "155": {"vr": "US", "Value": [1150]}, "156": {"vr": "US", "Value": [1132]}, "157": {"vr": "US", "Value": [1133]}, "158": {"vr": "US", "Value": [1131]}, "159": {"vr": "US", "Value": [1136]}, "160": {"vr": "US", "Value": [1135]}, "161": {"vr": "US", "Value": [1130]}, "162": {"vr": "US", "Value": [1133]}, "163": {"vr": "US", "Value": [1136]}, "164": {"vr": "US", "Value": [1134]}, "165": {"vr": "US", "Value": [1129]}, "166": {"vr": "US", "Value": [1131]}, "167": {"vr": "US", "Value": [1136]}, "168": {"vr": "US", "Value": [1132]}, "169": {"vr": "US", "Value": [1135]}, "170": {"vr": "US", "Value": [1132]}, "171": {"vr": "US", "Value": [1130]}, "172": {"vr": "US", "Value": [1136]}, "173": {"vr": "US", "Value": [1136]}, "174": {"vr": "US", "Value": [1133]}, "175": {"vr": "US", "Value": [1134]}, "176": {"vr": "US", "Value": [1130]}, "177": {"vr": "US", "Value": [1134]}, "178": {"vr": "US", "Value": [1139]}, "179": {"vr": "US", "Value": [1140]}, "180": {"vr": "US", "Value": [1130]}, "181": {"vr": "US", "Value": [1133]}, "182": {"vr": "US", "Value": [1134]}, "183": {"vr": "US", "Value": [1137]}, "184": {"vr": "US", "Value": [1134]}, "185": {"vr": "US", "Value": [1135]}, "186": {"vr": "US", "Value": [1132]}, "187": {"vr": "US", "Value": [1150]}, "188": {"vr": "US", "Value": [1137]}, "189": {"vr": "US", "Value": [1130]}, "190": {"vr": "US", "Value": [1139]}, "191": {"vr": "US", "Value": [1136]}, "192": {"vr": "US", "Value": [1135]}, "193": {"vr": "US", "Value": [1132]}, "194": {"vr": "US", "Value": [1132]}, "195": {"vr": "US", "Value": [1135]}, "196": {"vr": "US", "Value": [1131]}, "197": {"vr": "US", "Value": [1132]}, "198": {"vr": "US", "Value": [1135]}, "199": {"vr": "US", "Value": [1141]}, "200": {"vr": "US", "Value": [1137]}, "201": {"vr": "US", "Value": [1131]}, "202": {"vr": "US", "Value": [1132]}, "203": {"vr": "US", "Value": [1130]}, "204": {"vr": "US", "Value": [1138]}, "205": {"vr": "US", "Value": [1133]}, "206": {"vr": "US", "Value": [1135]}, "207": {"vr": "US", "Value": [1143]}, "208": {"vr": "US", "Value": [1134]}, "209": {"vr": "US", "Value": [1133]}, "210": {"vr": "US", "Value": [1132]}, "211": {"vr": "US", "Value": [1130]}, "212": {"vr": "US", "Value": [1133]}, "213": {"vr": "US", "Value": [1132]}, "214": {"vr": "US", "Value": [1134]}, "215": {"vr": "US", "Value": [1132]}, "216": {"vr": "US", "Value": [1134]}, "217": {"vr": "US", "Value": [1136]}, "218": {"vr": "US", "Value": [1128]}, "219": {"vr": "US", "Value": [1136]}, "220": {"vr": "US", "Value": [1131]}, "221": {"vr": "US", "Value": [1128]}, "222": {"vr": "US", "Value": [1131]}, "223": {"vr": "US", "Value": [1127]}, "224": {"vr": "US", "Value": [1126]}, "225": {"vr": "US", "Value": [1134]}, "226": {"vr": "US", "Value": [1126]}, "227": {"vr": "US", "Value": [1127]}, "228": {"vr": "US", "Value": [1126]}, "229": {"vr": "US", "Value": [1123]}, "230": {"vr": "US", "Value": [1126]}, "231": {"vr": "US", "Value": [1123]}, "232": {"vr": "US", "Value": [1123]}, "233": {"vr": "US", "Value": [1122]}, "234": {"vr": "US", "Value": [1118]}, "235": {"vr": "US", "Value": [1124]}, "236": {"vr": "US", "Value": [1121]}, "237": {"vr": "US", "Value": [1124]}, "238": {"vr": "US", "Value": [1119]}, "239": {"vr": "US", "Value": [1108]}, "240": {"vr": "US", "Value": [1084]}, "241": {"vr": "US", "Value": [1107]}, "242": {"vr": "US", "Value": [1593]}, "243": {"vr": "US", "Value": [2151]}, "244": {"vr": "US", "Value": [2405]}, "245": {"vr": "US", "Value": [2396]}, "246": {"vr": "US", "Value": [2428]}, "247": {"vr": "US", "Value": [2420]}, "248": {"vr": "US", "Value": [2469]}, "249": {"vr": "US", "Value": [2589]}, "250": {"vr": "US", "Value": [2580]}, "251": {"vr": "US", "Value": [2614]}, "252": {"vr": "US", "Value": [2744]}, "253": {"vr": "US", "Value": [2771]}, "254": {"vr": "US", "Value": [2745]}, "255": {"vr": "US", "Value": [2760]}, "256": {"vr": "US", "Value": [2810]}, "257": {"vr": "US", "Value": [2911]}, "258": {"vr": "US", "Value": [2946]}, "259": {"vr": "US", "Value": [2929]}, "260": {"vr": "US", "Value": [2871]}, "261": {"vr": "US", "Value": [2893]}, "262": {"vr": "US", "Value": [2924]}, "263": {"vr": "US", "Value": [2752]}, "264": {"vr": "US", "Value": [2579]}, "265": {"vr": "US", "Value": [2565]}, "266": {"vr": "US", "Value": [2562]}, "267": {"vr": "US", "Value": [2559]}, "268": {"vr": "US", "Value": [2574]}, "269": {"vr": "US", "Value": [3899]}, "270": {"vr": "US", "Value": [4016]}, "271": {"vr": "US", "Value": [3084]}, "272": {"vr": "US", "Value": [3000]}, "273": {"vr": "US", "Value": [3821]}, "274": {"vr": "US", "Value": [4091]}, "275": {"vr": "US", "Value": [3909]}, "276": {"vr": "US", "Value": [3093]}, "277": {"vr": "US", "Value": [2908]}, "278": {"vr": "US", "Value": [3973]}, "279": {"vr": "US", "Value": [4012]}, "280": {"vr": "US", "Value": [3017]}, "281": {"vr": "US", "Value": [2504]}, "282": {"vr": "US", "Value": [2569]}, "283": {"vr": "US", "Value": [2620]}, "284": {"vr": "US", "Value": [2571]}, "285": {"vr": "US", "Value": [2566]}, "286": {"vr": "US", "Value": [2518]}, "287": {"vr": "US", "Value": [2469]}, "288": {"vr": "US", "Value": [2458]}, "289": {"vr": "US", "Value": [2465]}, "290": {"vr": "US", "Value": [2472]}, "291": {"vr": "US", "Value": [2502]}, "292": {"vr": "US", "Value": [2479]}, "293": {"vr": "US", "Value": [2517]}, "294": {"vr": "US", "Value": [2522]}, "295": {"vr": "US", "Value": [2488]}, "296": {"vr": "US", "Value": [2524]}, "297": {"vr": "US", "Value": [2551]}, "298": {"vr": "US", "Value": [2551]}, "299": {"vr": "US", "Value": [2538]}, "300": {"vr": "US", "Value": [2519]}, "301": {"vr": "US", "Value": [2557]}, "302": {"vr": "US", "Value": [2218]}, "303": {"vr": "US", "Value": [1659]}, "304": {"vr": "US", "Value": [1530]}, "305": {"vr": "US", "Value": [1537]}, "306": {"vr": "US", "Value": [1545]}, "307": {"vr": "US", "Value": [1545]}, "308": {"vr": "US", "Value": [1554]}, "309": {"vr": "US", "Value": [1554]}, "310": {"vr": "US", "Value": [1565]}, "311": {"vr": "US", "Value": [1566]}, "312": {"vr": "US", "Value": [1570]}, "313": {"vr": "US", "Value": [1574]}, "314": {"vr": "US", "Value": [1563]}, "315": {"vr": "US", "Value": [1538]}, "316": {"vr": "US", "Value": [1530]}, "317": {"vr": "US", "Value": [1532]}, "318": {"vr": "US", "Value": [1544]}, "319": {"vr": "US", "Value": [1548]}, "320": {"vr": "US", "Value": [1556]}, "321": {"vr": "US", "Value": [1537]}, "322": {"vr": "US", "Value": [1535]}, "323": {"vr": "US", "Value": [1546]}, "324": {"vr": "US", "Value": [1550]}, "325": {"vr": "US", "Value": [1553]}, "326": {"vr": "US", "Value": [1548]}, "327": {"vr": "US", "Value": [1540]}, "328": {"vr": "US", "Value": [1538]}, "329": {"vr": "US", "Value": [1538]}, "330": {"vr": "US", "Value": [1541]}, "331": {"vr": "US", "Value": [1536]}, "332": {"vr": "US", "Value": [1547]}, "333": {"vr": "US", "Value": [1564]}, "334": {"vr": "US", "Value": [1564]}, "335": {"vr": "US", "Value": [1548]}, "336": {"vr": "US", "Value": [1540]}, "337": {"vr": "US", "Value": [1539]}, "338": {"vr": "US", "Value": [1544]}, "339": {"vr": "US", "Value": [1545]}, "340": {"vr": "US", "Value": [1538]}, "341": {"vr": "US", "Value": [1537]}, "342": {"vr": "US", "Value": [1536]}, "343": {"vr": "US", "Value": [1533]}, "344": {"vr": "US", "Value": [1526]}, "345": {"vr": "US", "Value": [1528]}, "346": {"vr": "US", "Value": [1531]}, "347": {"vr": "US", "Value": [1535]}, "348": {"vr": "US", "Value": [1537]}, "349": {"vr": "US", "Value": [1538]}, "350": {"vr": "US", "Value": [1542]}, "351": {"vr": "US", "Value": [1530]}, "352": {"vr": "US", "Value": [1533]}, "353": {"vr": "US", "Value": [1537]}, "354": {"vr": "US", "Value": [1537]}, "355": {"vr": "US", "Value": [1538]}, "356": {"vr": "US", "Value": [1540]}, "357": {"vr": "US", "Value": [1541]}, "358": {"vr": "US", "Value": [1551]}, "359": {"vr": "US", "Value": [1553]}, "360": {"vr": "US", "Value": [1534]}, "361": {"vr": "US", "Value": [1530]}, "362": {"vr": "US", "Value": [1531]}, "363": {"vr": "US", "Value": [1546]}, "364": {"vr": "US", "Value": [1560]}, "365": {"vr": "US", "Value": [1544]}, "366": {"vr": "US", "Value": [1538]}, "367": {"vr": "US", "Value": [1536]}, "368": {"vr": "US", "Value": [1539]}, "369": {"vr": "US", "Value": [1551]}, "370": {"vr": "US", "Value": [1558]}, "371": {"vr": "US", "Value": [1547]}, "372": {"vr": "US", "Value": [1540]}, "373": {"vr": "US", "Value": [1542]}, "374": {"vr": "US", "Value": [1557]}, "375": {"vr": "US", "Value": [1544]}, "376": {"vr": "US", "Value": [1526]}, "377": {"vr": "US", "Value": [1521]}, "378": {"vr": "US", "Value": [1526]}, "379": {"vr": "US", "Value": [1536]}, "380": {"vr": "US", "Value": [1545]}, "381": {"vr": "US", "Value": [1537]}, "382": {"vr": "US", "Value": [1537]}, "383": {"vr": "US", "Value": [1534]}, "384": {"vr": "US", "Value": [1543]}, "385": {"vr": "US", "Value": [1538]}, "386": {"vr": "US", "Value": [1527]}, "387": {"vr": "US", "Value": [1533]}, "388": {"vr": "US", "Value": [1532]}, "389": {"vr": "US", "Value": [1537]}, "390": {"vr": "US", "Value": [1530]}, "391": {"vr": "US", "Value": [1516]}, "392": {"vr": "US", "Value": [1517]}, "393": {"vr": "US", "Value": [1527]}, "394": {"vr": "US", "Value": [1540]}, "395": {"vr": "US", "Value": [1542]}, "396": {"vr": "US", "Value": [1527]}, "397": {"vr": "US", "Value": [1531]}, "398": {"vr": "US", "Value": [1523]}, "399": {"vr": "US", "Value": [1526]}, "400": {"vr": "US", "Value": [1526]}, "401": {"vr": "US", "Value": [1530]}, "402": {"vr": "US", "Value": [1535]}, "403": {"vr": "US", "Value": [1548]}, "404": {"vr": "US", "Value": [1538]}, "405": {"vr": "US", "Value": [1527]}, "406": {"vr": "US", "Value": [1515]}, "407": {"vr": "US", "Value": [1518]}, "408": {"vr": "US", "Value": [1517]}, "409": {"vr": "US", "Value": [1519]}, "410": {"vr": "US", "Value": [1535]}, "411": {"vr": "US", "Value": [1535]}, "412": {"vr": "US", "Value": [1531]}, "413": {"vr": "US", "Value": [1532]}, "414": {"vr": "US", "Value": [1537]}, "415": {"vr": "US", "Value": [1535]}, "416": {"vr": "US", "Value": [1543]}, "417": {"vr": "US", "Value": [1531]}, "418": {"vr": "US", "Value": [1532]}, "419": {"vr": "US", "Value": [1547]}, "420": {"vr": "US", "Value": [1538]}, "421": {"vr": "US", "Value": [1537]}, "422": {"vr": "US", "Value": [1514]}, "423": {"vr": "US", "Value": [1521]}, "424": {"vr": "US", "Value": [1530]}, "425": {"vr": "US", "Value": [1532]}, "426": {"vr": "US", "Value": [1534]}, "427": {"vr": "US", "Value": [1530]}, "428": {"vr": "US", "Value": [1527]}, "429": {"vr": "US", "Value": [1526]}, "430": {"vr": "US", "Value": [1540]}, "431": {"vr": "US", "Value": [1545]}, "432": {"vr": "US", "Value": [1538]}, "433": {"vr": "US", "Value": [1536]}, "434": {"vr": "US", "Value": [1530]}, "435": {"vr": "US", "Value": [1541]}, "436": {"vr": "US", "Value": [1529]}, "437": {"vr": "US", "Value": [1513]}, "438": {"vr": "US", "Value": [1520]}, "439": {"vr": "US", "Value": [1533]}, "440": {"vr": "US", "Value": [1522]}, "441": {"vr": "US", "Value": [1524]}, "442": {"vr": "US", "Value": [1524]}, "443": {"vr": "US", "Value": [1521]}, "444": {"vr": "US", "Value": [1529]}, "445": {"vr": "US", "Value": [1532]}, "446": {"vr": "US", "Value": [1536]}, "447": {"vr": "US", "Value": [1544]}, "448": {"vr": "US", "Value": [1545]}, "449": {"vr": "US", "Value": [1549]}, "450": {"vr": "US", "Value": [1553]}, "451": {"vr": "US", "Value": [1546]}, "452": {"vr": "US", "Value": [1522]}, "453": {"vr": "US", "Value": [1525]}, "454": {"vr": "US", "Value": [1537]}, "455": {"vr": "US", "Value": [1534]}, "456": {"vr": "US", "Value": [1532]}, "457": {"vr": "US", "Value": [1521]}, "458": {"vr": "US", "Value": [1516]}, "459": {"vr": "US", "Value": [1530]}, "460": {"vr": "US", "Value": [1525]}, "461": {"vr": "US", "Value": [1525]}, "462": {"vr": "US", "Value": [1523]}, "463": {"vr": "US", "Value": [1526]}, "464": {"vr": "US", "Value": [1530]}, "465": {"vr": "US", "Value": [1535]}, "466": {"vr": "US", "Value": [1533]}, "467": {"vr": "US", "Value": [1523]}, "468": {"vr": "US", "Value": [1519]}, "469": {"vr": "US", "Value": [1535]}, "470": {"vr": "US", "Value": [1526]}, "471": {"vr": "US", "Value": [1525]}, "472": {"vr": "US", "Value": [1529]}, "473": {"vr": "US", "Value": [1533]}, "474": {"vr": "US", "Value": [1537]}, "475": {"vr": "US", "Value": [1533]}, "476": {"vr": "US", "Value": [1529]}, "477": {"vr": "US", "Value": [1528]}, "478": {"vr": "US", "Value": [1536]}, "479": {"vr": "US", "Value": [1539]}, "480": {"vr": "US", "Value": [1561]}, "481": {"vr": "US", "Value": [1554]}, "482": {"vr": "US", "Value": [1522]}, "483": {"vr": "US", "Value": [1518]}, "484": {"vr": "US", "Value": [1524]}, "485": {"vr": "US", "Value": [1531]}, "486": {"vr": "US", "Value": [1545]}, "487": {"vr": "US", "Value": [1551]}, "488": {"vr": "US", "Value": [1548]}, "489": {"vr": "US", "Value": [1549]}, "490": {"vr": "US", "Value": [1534]}, "491": {"vr": "US", "Value": [1534]}, "492": {"vr": "US", "Value": [1542]}, "493": {"vr": "US", "Value": [1541]}, "494": {"vr": "US", "Value": [1537]}, "495": {"vr": "US", "Value": [1533]}, "496": {"vr": "US", "Value": [1537]}, "497": {"vr": "US", "Value": [1524]}, "498": {"vr": "US", "Value": [1522]}, "499": {"vr": "US", "Value": [1530]}, "500": {"vr": "US", "Value": [1532]}, "501": {"vr": "US", "Value": [1538]}, "502": {"vr": "US", "Value": [1543]}, "503": {"vr": "US", "Value": [1542]}, "504": {"vr": "US", "Value": [1530]}, "505": {"vr": "US", "Value": [1538]}, "506": {"vr": "US", "Value": [1533]}, "507": {"vr": "US", "Value": [1529]}, "508": {"vr": "US", "Value": [1539]}, "509": {"vr": "US", "Value": [1547]}, "510": {"vr": "US", "Value": [1549]}, "511": {"vr": "US", "Value": [1548]}, "512": {"vr": "US", "Value": [1539]}, "513": {"vr": "US", "Value": [1527]}, "514": {"vr": "US", "Value": [1517]}, "515": {"vr": "US", "Value": [1525]}, "516": {"vr": "US", "Value": [1537]}, "517": {"vr": "US", "Value": [1544]}, "518": {"vr": "US", "Value": [1547]}, "519": {"vr": "US", "Value": [1545]}, "520": {"vr": "US", "Value": [1543]}, "521": {"vr": "US", "Value": [1546]}, "522": {"vr": "US", "Value": [1544]}, "523": {"vr": "US", "Value": [1542]}, "524": {"vr": "US", "Value": [1553]}, "525": {"vr": "US", "Value": [1549]}, "526": {"vr": "US", "Value": [1559]}, "527": {"vr": "US", "Value": [1548]}, "528": {"vr": "US", "Value": [1541]}, "529": {"vr": "US", "Value": [1562]}, "530": {"vr": "US", "Value": [1561]}}, "00291140": {"0": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "1": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "2": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "3": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "4": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "5": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "6": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "7": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "8": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "9": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "10": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "11": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "12": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "13": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "14": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "15": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "16": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "17": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "18": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "19": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "20": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "21": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "22": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "23": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "24": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "25": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "26": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "27": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "28": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "29": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "30": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "31": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMABJ"}}]}, "32": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "33": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "34": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "35": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "36": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "37": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "38": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "39": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "40": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "41": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "42": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "43": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "44": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "45": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "46": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "47": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "48": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "49": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "50": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "51": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "52": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "53": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACw"}}]}, "54": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "55": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "56": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "57": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "58": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "59": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "60": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "61": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMABJ"}}]}, "62": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACw"}}]}, "63": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "64": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "65": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "66": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "67": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "68": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "69": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "70": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "71": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "72": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "73": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "74": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "75": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "76": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "77": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "78": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "79": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "80": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "81": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "82": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "83": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "84": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "85": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "86": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "87": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "88": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "89": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "90": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "91": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "92": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "93": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "94": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "95": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "96": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "97": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "98": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "99": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "100": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "101": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "102": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "103": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "104": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "105": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "106": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "107": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "108": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "109": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "110": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "111": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "112": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "113": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "114": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "115": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "116": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "117": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "118": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "119": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "120": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "121": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "122": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "123": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "124": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "125": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "126": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "127": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "128": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "129": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "130": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "131": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "132": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "133": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "134": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "135": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "136": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "137": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "138": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMABI"}}]}, "139": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "140": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "141": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "142": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "143": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "144": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "145": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "146": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "147": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "148": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "149": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "150": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "151": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "152": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "153": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "154": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "155": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "156": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "157": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "158": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "159": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "160": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "161": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "162": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "163": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "164": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "165": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "166": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "167": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "168": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "169": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "170": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "171": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "172": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "173": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAw"}}]}, "174": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "175": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "176": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "177": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "178": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "179": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "180": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "181": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "182": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "183": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "184": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "185": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "186": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "187": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "188": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "189": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "190": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "191": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "192": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "193": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "194": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "195": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "196": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "197": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "198": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "199": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "200": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "201": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "202": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "203": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "204": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "205": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "206": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "207": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "208": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "209": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "210": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "211": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "212": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "213": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "214": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "215": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "216": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "217": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "218": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "219": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "220": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "221": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "222": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "223": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "224": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "225": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "226": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "227": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "228": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMABB"}}]}, "229": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "230": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "231": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "232": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "233": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "234": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "235": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "236": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "237": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "238": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "239": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "240": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "241": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "242": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "243": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACv"}}]}, "244": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "245": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "246": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "247": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "248": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "249": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "250": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "251": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "252": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "253": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "254": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "255": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "256": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "257": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "258": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "259": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "260": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "261": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "262": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "263": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "264": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "265": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "266": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "267": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "268": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "269": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "270": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "271": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "272": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "273": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "274": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "275": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "276": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "277": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "278": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "279": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "280": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "281": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "282": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "283": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "284": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "285": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "286": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "287": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "288": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "289": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "290": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "291": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "292": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "293": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "294": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "295": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "296": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "297": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "298": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "299": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "300": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "301": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "302": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAC/"}}]}, "303": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "304": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "305": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "306": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "307": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACv"}}]}, "308": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "309": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "310": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "311": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "312": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "313": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "314": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "315": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "316": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "317": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "318": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "319": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "320": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "321": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "322": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "323": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "324": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "325": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "326": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "327": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "328": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "329": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "330": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "331": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "332": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "333": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "334": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "335": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "336": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "337": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "338": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "339": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "340": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "341": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "342": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACx"}}]}, "343": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "344": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "345": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "346": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "347": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "348": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "349": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "350": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "351": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "352": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "353": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "354": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "355": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "356": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "357": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "358": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "359": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "360": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "361": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "362": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "363": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "364": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "365": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "366": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "367": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "368": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "369": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "370": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "371": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "372": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "373": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "374": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "375": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "376": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "377": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "378": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "379": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "380": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "381": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "382": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "383": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "384": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "385": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "386": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "387": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "388": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "389": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "390": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "391": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "392": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "393": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "394": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "395": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "396": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "397": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "398": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "399": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "400": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "401": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "402": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "403": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "404": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "405": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "406": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "407": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "408": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "409": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "410": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "411": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "412": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "413": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "414": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "415": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "416": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "417": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "418": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "419": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "420": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "421": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "422": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "423": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "424": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "425": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "426": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "427": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "428": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "429": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "430": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "431": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "432": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "433": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "434": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "435": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "436": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "437": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "438": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "439": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "440": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "441": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "442": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "443": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "444": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "445": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "446": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "447": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "448": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "449": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "450": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "451": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "452": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "453": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "454": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAD/"}}]}, "455": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "456": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "457": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "458": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "459": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "460": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "461": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "462": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "463": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAA"}}]}, "464": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "465": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "466": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "467": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "468": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "469": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "470": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "471": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "472": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "473": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "474": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "475": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "476": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "477": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "478": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "479": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "480": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACx"}}]}, "481": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "482": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "483": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "484": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "485": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "486": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "487": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "488": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "489": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "490": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "491": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "492": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "493": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "494": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "495": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "496": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "497": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "498": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "499": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "500": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "501": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "502": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "503": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "504": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "505": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "506": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "507": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "508": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "509": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "510": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "511": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "512": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "513": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "514": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "515": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "516": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "517": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAA6"}}]}, "518": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "519": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "520": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "521": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "522": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "523": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMAAu"}}]}, "524": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "525": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "526": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "527": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMADA"}}]}, "528": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACu"}}]}, "529": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}, "530": {"vr": "SQ", "Value": [{"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["VIA_CARE_KV_WIND"]}, "00291042": {"vr": "LO", "Value": ["ORIG WINDOW VALUES FROM CAREKV"]}, "00291043": {"vr": "LO", "Value": ["V1 20120914"]}, "00291044": {"vr": "OB", "InlineBinary": "NAAwACMAMwAwADAAAAA="}}, {"00290010": {"vr": "LO", "Value": ["SIEMENS MEDCOM HEADER"]}, "00291041": {"vr": "CS", "Value": ["SOM 5 TPOS"]}, "00291042": {"vr": "LO", "Value": ["SOM 5 NULLPOSITION"]}, "00291043": {"vr": "LO", "Value": ["VB10A 20030626"]}, "00291044": {"vr": "OB", "InlineBinary": "LTAwMDAwMzcwMACf"}}]}}}


collated_data = {"00291010": {"0": {"vr": "OB", "BinaryLength": 1784}, "1": {"vr": "OB", "BinaryLength": 1784}, "2": {"vr": "OB", "BinaryLength": 1784}, "3": {"vr": "OB", "BinaryLength": 1784}, "4": {"vr": "OB", "BinaryLength": 1784}, "5": {"vr": "OB", "BinaryLength": 1784}, "6": {"vr": "OB", "BinaryLength": 1784}, "7": {"vr": "OB", "BinaryLength": 1784}, "8": {"vr": "OB", "BinaryLength": 1784}, "9": {"vr": "OB", "BinaryLength": 1784}, "10": {"vr": "OB", "BinaryLength": 1784}, "11": {"vr": "OB", "BinaryLength": 1784}, "12": {"vr": "OB", "BinaryLength": 1784}, "13": {"vr": "OB", "BinaryLength": 1784}, "14": {"vr": "OB", "BinaryLength": 1784}, "15": {"vr": "OB", "BinaryLength": 1784}, "16": {"vr": "OB", "BinaryLength": 1784}, "17": {"vr": "OB", "BinaryLength": 1784}, "18": {"vr": "OB", "BinaryLength": 1784}, "19": {"vr": "OB", "BinaryLength": 1784}, "20": {"vr": "OB", "BinaryLength": 1784}, "21": {"vr": "OB", "BinaryLength": 1784}, "22": {"vr": "OB", "BinaryLength": 1784}, "23": {"vr": "OB", "BinaryLength": 1784}, "24": {"vr": "OB", "BinaryLength": 1784}, "25": {"vr": "OB", "BinaryLength": 1784}, "26": {"vr": "OB", "BinaryLength": 1784}, "27": {"vr": "OB", "BinaryLength": 1784}, "28": {"vr": "OB", "BinaryLength": 1784}, "29": {"vr": "OB", "BinaryLength": 1784}, "30": {"vr": "OB", "BinaryLength": 1784}, "31": {"vr": "OB", "BinaryLength": 1784}, "32": {"vr": "OB", "BinaryLength": 1784}, "33": {"vr": "OB", "BinaryLength": 1784}, "34": {"vr": "OB", "BinaryLength": 1784}, "35": {"vr": "OB", "BinaryLength": 1784}, "36": {"vr": "OB", "BinaryLength": 1784}, "37": {"vr": "OB", "BinaryLength": 1784}, "38": {"vr": "OB", "BinaryLength": 1784}, "39": {"vr": "OB", "BinaryLength": 1784}, "40": {"vr": "OB", "BinaryLength": 1784}, "41": {"vr": "OB", "BinaryLength": 1784}, "42": {"vr": "OB", "BinaryLength": 1784}, "43": {"vr": "OB", "BinaryLength": 1784}, "44": {"vr": "OB", "BinaryLength": 1784}, "45": {"vr": "OB", "BinaryLength": 1784}, "46": {"vr": "OB", "BinaryLength": 1784}, "47": {"vr": "OB", "BinaryLength": 1784}, "48": {"vr": "OB", "BinaryLength": 1784}, "49": {"vr": "OB", "BinaryLength": 1784}, "50": {"vr": "OB", "BinaryLength": 1784}, "51": {"vr": "OB", "BinaryLength": 1784}, "52": {"vr": "OB", "BinaryLength": 1784}, "53": {"vr": "OB", "BinaryLength": 1784}, "54": {"vr": "OB", "BinaryLength": 1784}, "55": {"vr": "OB", "BinaryLength": 1784}, "56": {"vr": "OB", "BinaryLength": 1784}, "57": {"vr": "OB", "BinaryLength": 1784}, "58": {"vr": "OB", "BinaryLength": 1784}, "59": {"vr": "OB", "BinaryLength": 1784}, "60": {"vr": "OB", "BinaryLength": 1784}, "61": {"vr": "OB", "BinaryLength": 1784}, "62": {"vr": "OB", "BinaryLength": 1784}, "63": {"vr": "OB", "BinaryLength": 1784}, "64": {"vr": "OB", "BinaryLength": 1784}, "65": {"vr": "OB", "BinaryLength": 1784}, "66": {"vr": "OB", "BinaryLength": 1784}, "67": {"vr": "OB", "BinaryLength": 1784}, "68": {"vr": "OB", "BinaryLength": 1784}, "69": {"vr": "OB", "BinaryLength": 1784}, "70": {"vr": "OB", "BinaryLength": 1784}, "71": {"vr": "OB", "BinaryLength": 1784}, "72": {"vr": "OB", "BinaryLength": 1784}, "73": {"vr": "OB", "BinaryLength": 1784}, "74": {"vr": "OB", "BinaryLength": 1784}, "75": {"vr": "OB", "BinaryLength": 1784}, "76": {"vr": "OB", "BinaryLength": 1784}, "77": {"vr": "OB", "BinaryLength": 1784}, "78": {"vr": "OB", "BinaryLength": 1784}, "79": {"vr": "OB", "BinaryLength": 1784}, "80": {"vr": "OB", "BinaryLength": 1784}, "81": {"vr": "OB", "BinaryLength": 1784}, "82": {"vr": "OB", "BinaryLength": 1784}, "83": {"vr": "OB", "BinaryLength": 1784}, "84": {"vr": "OB", "BinaryLength": 1784}, "85": {"vr": "OB", "BinaryLength": 1784}, "86": {"vr": "OB", "BinaryLength": 1784}, "87": {"vr": "OB", "BinaryLength": 1784}, "88": {"vr": "OB", "BinaryLength": 1784}, "89": {"vr": "OB", "BinaryLength": 1784}, "90": {"vr": "OB", "BinaryLength": 1784}, "91": {"vr": "OB", "BinaryLength": 1784}, "92": {"vr": "OB", "BinaryLength": 1784}, "93": {"vr": "OB", "BinaryLength": 1784}, "94": {"vr": "OB", "BinaryLength": 1784}, "95": {"vr": "OB", "BinaryLength": 1784}, "96": {"vr": "OB", "BinaryLength": 1784}, "97": {"vr": "OB", "BinaryLength": 1784}, "98": {"vr": "OB", "BinaryLength": 1784}, "99": {"vr": "OB", "BinaryLength": 1784}, "100": {"vr": "OB", "BinaryLength": 1784}, "101": {"vr": "OB", "BinaryLength": 1784}, "102": {"vr": "OB", "BinaryLength": 1784}, "103": {"vr": "OB", "BinaryLength": 1784}, "104": {"vr": "OB", "BinaryLength": 1784}, "105": {"vr": "OB", "BinaryLength": 1784}, "106": {"vr": "OB", "BinaryLength": 1784}, "107": {"vr": "OB", "BinaryLength": 1784}, "108": {"vr": "OB", "BinaryLength": 1784}, "109": {"vr": "OB", "BinaryLength": 1784}, "110": {"vr": "OB", "BinaryLength": 1784}, "111": {"vr": "OB", "BinaryLength": 1784}, "112": {"vr": "OB", "BinaryLength": 1784}, "113": {"vr": "OB", "BinaryLength": 1784}, "114": {"vr": "OB", "BinaryLength": 1784}, "115": {"vr": "OB", "BinaryLength": 1784}, "116": {"vr": "OB", "BinaryLength": 1784}, "117": {"vr": "OB", "BinaryLength": 1784}, "118": {"vr": "OB", "BinaryLength": 1784}, "119": {"vr": "OB", "BinaryLength": 1784}, "120": {"vr": "OB", "BinaryLength": 1784}, "121": {"vr": "OB", "BinaryLength": 1784}, "122": {"vr": "OB", "BinaryLength": 1784}, "123": {"vr": "OB", "BinaryLength": 1784}, "124": {"vr": "OB", "BinaryLength": 1784}, "125": {"vr": "OB", "BinaryLength": 1784}, "126": {"vr": "OB", "BinaryLength": 1784}, "127": {"vr": "OB", "BinaryLength": 1784}, "128": {"vr": "OB", "BinaryLength": 1784}, "129": {"vr": "OB", "BinaryLength": 1784}, "130": {"vr": "OB", "BinaryLength": 1784}, "131": {"vr": "OB", "BinaryLength": 1784}, "132": {"vr": "OB", "BinaryLength": 1784}, "133": {"vr": "OB", "BinaryLength": 1784}, "134": {"vr": "OB", "BinaryLength": 1784}, "135": {"vr": "OB", "BinaryLength": 1784}, "136": {"vr": "OB", "BinaryLength": 1784}, "137": {"vr": "OB", "BinaryLength": 1784}, "138": {"vr": "OB", "BinaryLength": 1784}, "139": {"vr": "OB", "BinaryLength": 1784}, "140": {"vr": "OB", "BinaryLength": 1784}, "141": {"vr": "OB", "BinaryLength": 1784}, "142": {"vr": "OB", "BinaryLength": 1784}, "143": {"vr": "OB", "BinaryLength": 1784}, "144": {"vr": "OB", "BinaryLength": 1784}, "145": {"vr": "OB", "BinaryLength": 1784}, "146": {"vr": "OB", "BinaryLength": 1784}, "147": {"vr": "OB", "BinaryLength": 1784}, "148": {"vr": "OB", "BinaryLength": 1784}, "149": {"vr": "OB", "BinaryLength": 1784}, "150": {"vr": "OB", "BinaryLength": 1784}, "151": {"vr": "OB", "BinaryLength": 1784}, "152": {"vr": "OB", "BinaryLength": 1784}, "153": {"vr": "OB", "BinaryLength": 1784}, "154": {"vr": "OB", "BinaryLength": 1784}, "155": {"vr": "OB", "BinaryLength": 1784}, "156": {"vr": "OB", "BinaryLength": 1784}, "157": {"vr": "OB", "BinaryLength": 1784}, "158": {"vr": "OB", "BinaryLength": 1784}, "159": {"vr": "OB", "BinaryLength": 1784}, "160": {"vr": "OB", "BinaryLength": 1784}, "161": {"vr": "OB", "BinaryLength": 1784}, "162": {"vr": "OB", "BinaryLength": 1784}, "163": {"vr": "OB", "BinaryLength": 1784}, "164": {"vr": "OB", "BinaryLength": 1784}, "165": {"vr": "OB", "BinaryLength": 1784}, "166": {"vr": "OB", "BinaryLength": 1784}, "167": {"vr": "OB", "BinaryLength": 1784}, "168": {"vr": "OB", "BinaryLength": 1784}, "169": {"vr": "OB", "BinaryLength": 1784}, "170": {"vr": "OB", "BinaryLength": 1784}, "171": {"vr": "OB", "BinaryLength": 1784}, "172": {"vr": "OB", "BinaryLength": 1784}, "173": {"vr": "OB", "BinaryLength": 1784}, "174": {"vr": "OB", "BinaryLength": 1784}, "175": {"vr": "OB", "BinaryLength": 1784}, "176": {"vr": "OB", "BinaryLength": 1784}, "177": {"vr": "OB", "BinaryLength": 1784}, "178": {"vr": "OB", "BinaryLength": 1784}, "179": {"vr": "OB", "BinaryLength": 1784}, "180": {"vr": "OB", "BinaryLength": 1784}, "181": {"vr": "OB", "BinaryLength": 1784}, "182": {"vr": "OB", "BinaryLength": 1784}, "183": {"vr": "OB", "BinaryLength": 1784}, "184": {"vr": "OB", "BinaryLength": 1784}, "185": {"vr": "OB", "BinaryLength": 1784}, "186": {"vr": "OB", "BinaryLength": 1784}, "187": {"vr": "OB", "BinaryLength": 1784}, "188": {"vr": "OB", "BinaryLength": 1784}, "189": {"vr": "OB", "BinaryLength": 1784}, "190": {"vr": "OB", "BinaryLength": 1784}, "191": {"vr": "OB", "BinaryLength": 1784}, "192": {"vr": "OB", "BinaryLength": 1784}, "193": {"vr": "OB", "BinaryLength": 1784}, "194": {"vr": "OB", "BinaryLength": 1784}, "195": {"vr": "OB", "BinaryLength": 1784}, "196": {"vr": "OB", "BinaryLength": 1784}, "197": {"vr": "OB", "BinaryLength": 1784}, "198": {"vr": "OB", "BinaryLength": 1784}, "199": {"vr": "OB", "BinaryLength": 1784}, "200": {"vr": "OB", "BinaryLength": 1784}, "201": {"vr": "OB", "BinaryLength": 1784}, "202": {"vr": "OB", "BinaryLength": 1784}, "203": {"vr": "OB", "BinaryLength": 1784}, "204": {"vr": "OB", "BinaryLength": 1784}, "205": {"vr": "OB", "BinaryLength": 1784}, "206": {"vr": "OB", "BinaryLength": 1784}, "207": {"vr": "OB", "BinaryLength": 1784}, "208": {"vr": "OB", "BinaryLength": 1784}, "209": {"vr": "OB", "BinaryLength": 1784}, "210": {"vr": "OB", "BinaryLength": 1784}, "211": {"vr": "OB", "BinaryLength": 1784}, "212": {"vr": "OB", "BinaryLength": 1784}, "213": {"vr": "OB", "BinaryLength": 1784}, "214": {"vr": "OB", "BinaryLength": 1784}, "215": {"vr": "OB", "BinaryLength": 1784}, "216": {"vr": "OB", "BinaryLength": 1784}, "217": {"vr": "OB", "BinaryLength": 1784}, "218": {"vr": "OB", "BinaryLength": 1784}, "219": {"vr": "OB", "BinaryLength": 1784}, "220": {"vr": "OB", "BinaryLength": 1784}, "221": {"vr": "OB", "BinaryLength": 1784}, "222": {"vr": "OB", "BinaryLength": 1784}, "223": {"vr": "OB", "BinaryLength": 1784}, "224": {"vr": "OB", "BinaryLength": 1784}, "225": {"vr": "OB", "BinaryLength": 1784}, "226": {"vr": "OB", "BinaryLength": 1784}, "227": {"vr": "OB", "BinaryLength": 1784}, "228": {"vr": "OB", "BinaryLength": 1784}, "229": {"vr": "OB", "BinaryLength": 1784}, "230": {"vr": "OB", "BinaryLength": 1784}, "231": {"vr": "OB", "BinaryLength": 1784}, "232": {"vr": "OB", "BinaryLength": 1784}, "233": {"vr": "OB", "BinaryLength": 1784}, "234": {"vr": "OB", "BinaryLength": 1784}, "235": {"vr": "OB", "BinaryLength": 1784}, "236": {"vr": "OB", "BinaryLength": 1784}, "237": {"vr": "OB", "BinaryLength": 1784}, "238": {"vr": "OB", "BinaryLength": 1784}, "239": {"vr": "OB", "BinaryLength": 1784}, "240": {"vr": "OB", "BinaryLength": 1784}, "241": {"vr": "OB", "BinaryLength": 1784}, "242": {"vr": "OB", "BinaryLength": 1784}, "243": {"vr": "OB", "BinaryLength": 1784}, "244": {"vr": "OB", "BinaryLength": 1784}, "245": {"vr": "OB", "BinaryLength": 1784}, "246": {"vr": "OB", "BinaryLength": 1784}, "247": {"vr": "OB", "BinaryLength": 1784}, "248": {"vr": "OB", "BinaryLength": 1784}, "249": {"vr": "OB", "BinaryLength": 1784}, "250": {"vr": "OB", "BinaryLength": 1784}, "251": {"vr": "OB", "BinaryLength": 1784}, "252": {"vr": "OB", "BinaryLength": 1784}, "253": {"vr": "OB", "BinaryLength": 1784}, "254": {"vr": "OB", "BinaryLength": 1784}, "255": {"vr": "OB", "BinaryLength": 1784}, "256": {"vr": "OB", "BinaryLength": 1784}, "257": {"vr": "OB", "BinaryLength": 1784}, "258": {"vr": "OB", "BinaryLength": 1784}, "259": {"vr": "OB", "BinaryLength": 1784}, "260": {"vr": "OB", "BinaryLength": 1784}, "261": {"vr": "OB", "BinaryLength": 1784}, "262": {"vr": "OB", "BinaryLength": 1784}, "263": {"vr": "OB", "BinaryLength": 1784}, "264": {"vr": "OB", "BinaryLength": 1784}, "265": {"vr": "OB", "BinaryLength": 1784}, "266": {"vr": "OB", "BinaryLength": 1784}, "267": {"vr": "OB", "BinaryLength": 1784}, "268": {"vr": "OB", "BinaryLength": 1784}, "269": {"vr": "OB", "BinaryLength": 1784}, "270": {"vr": "OB", "BinaryLength": 1784}, "271": {"vr": "OB", "BinaryLength": 1784}, "272": {"vr": "OB", "BinaryLength": 1784}, "273": {"vr": "OB", "BinaryLength": 1784}, "274": {"vr": "OB", "BinaryLength": 1784}, "275": {"vr": "OB", "BinaryLength": 1784}, "276": {"vr": "OB", "BinaryLength": 1784}, "277": {"vr": "OB", "BinaryLength": 1784}, "278": {"vr": "OB", "BinaryLength": 1784}, "279": {"vr": "OB", "BinaryLength": 1784}, "280": {"vr": "OB", "BinaryLength": 1784}, "281": {"vr": "OB", "BinaryLength": 1784}, "282": {"vr": "OB", "BinaryLength": 1784}, "283": {"vr": "OB", "BinaryLength": 1784}, "284": {"vr": "OB", "BinaryLength": 1784}, "285": {"vr": "OB", "BinaryLength": 1784}, "286": {"vr": "OB", "BinaryLength": 1784}, "287": {"vr": "OB", "BinaryLength": 1784}, "288": {"vr": "OB", "BinaryLength": 1784}, "289": {"vr": "OB", "BinaryLength": 1784}, "290": {"vr": "OB", "BinaryLength": 1784}, "291": {"vr": "OB", "BinaryLength": 1784}, "292": {"vr": "OB", "BinaryLength": 1784}, "293": {"vr": "OB", "BinaryLength": 1784}, "294": {"vr": "OB", "BinaryLength": 1784}, "295": {"vr": "OB", "BinaryLength": 1784}, "296": {"vr": "OB", "BinaryLength": 1784}, "297": {"vr": "OB", "BinaryLength": 1784}, "298": {"vr": "OB", "BinaryLength": 1784}, "299": {"vr": "OB", "BinaryLength": 1784}, "300": {"vr": "OB", "BinaryLength": 1784}, "301": {"vr": "OB", "BinaryLength": 1784}, "302": {"vr": "OB", "BinaryLength": 1784}, "303": {"vr": "OB", "BinaryLength": 1784}, "304": {"vr": "OB", "BinaryLength": 1784}, "305": {"vr": "OB", "BinaryLength": 1784}, "306": {"vr": "OB", "BinaryLength": 1784}, "307": {"vr": "OB", "BinaryLength": 1784}, "308": {"vr": "OB", "BinaryLength": 1784}, "309": {"vr": "OB", "BinaryLength": 1784}, "310": {"vr": "OB", "BinaryLength": 1784}, "311": {"vr": "OB", "BinaryLength": 1784}, "312": {"vr": "OB", "BinaryLength": 1784}, "313": {"vr": "OB", "BinaryLength": 1784}, "314": {"vr": "OB", "BinaryLength": 1784}, "315": {"vr": "OB", "BinaryLength": 1784}, "316": {"vr": "OB", "BinaryLength": 1784}, "317": {"vr": "OB", "BinaryLength": 1784}, "318": {"vr": "OB", "BinaryLength": 1784}, "319": {"vr": "OB", "BinaryLength": 1784}, "320": {"vr": "OB", "BinaryLength": 1784}, "321": {"vr": "OB", "BinaryLength": 1784}, "322": {"vr": "OB", "BinaryLength": 1784}, "323": {"vr": "OB", "BinaryLength": 1784}, "324": {"vr": "OB", "BinaryLength": 1784}, "325": {"vr": "OB", "BinaryLength": 1784}, "326": {"vr": "OB", "BinaryLength": 1784}, "327": {"vr": "OB", "BinaryLength": 1784}, "328": {"vr": "OB", "BinaryLength": 1784}, "329": {"vr": "OB", "BinaryLength": 1784}, "330": {"vr": "OB", "BinaryLength": 1784}, "331": {"vr": "OB", "BinaryLength": 1784}, "332": {"vr": "OB", "BinaryLength": 1784}, "333": {"vr": "OB", "BinaryLength": 1784}, "334": {"vr": "OB", "BinaryLength": 1784}, "335": {"vr": "OB", "BinaryLength": 1784}, "336": {"vr": "OB", "BinaryLength": 1784}, "337": {"vr": "OB", "BinaryLength": 1784}, "338": {"vr": "OB", "BinaryLength": 1784}, "339": {"vr": "OB", "BinaryLength": 1784}, "340": {"vr": "OB", "BinaryLength": 1784}, "341": {"vr": "OB", "BinaryLength": 1784}, "342": {"vr": "OB", "BinaryLength": 1784}, "343": {"vr": "OB", "BinaryLength": 1784}, "344": {"vr": "OB", "BinaryLength": 1784}, "345": {"vr": "OB", "BinaryLength": 1784}, "346": {"vr": "OB", "BinaryLength": 1784}, "347": {"vr": "OB", "BinaryLength": 1784}, "348": {"vr": "OB", "BinaryLength": 1784}, "349": {"vr": "OB", "BinaryLength": 1784}, "350": {"vr": "OB", "BinaryLength": 1784}, "351": {"vr": "OB", "BinaryLength": 1784}, "352": {"vr": "OB", "BinaryLength": 1784}, "353": {"vr": "OB", "BinaryLength": 1784}, "354": {"vr": "OB", "BinaryLength": 1784}, "355": {"vr": "OB", "BinaryLength": 1784}, "356": {"vr": "OB", "BinaryLength": 1784}, "357": {"vr": "OB", "BinaryLength": 1784}, "358": {"vr": "OB", "BinaryLength": 1784}, "359": {"vr": "OB", "BinaryLength": 1784}, "360": {"vr": "OB", "BinaryLength": 1784}, "361": {"vr": "OB", "BinaryLength": 1784}, "362": {"vr": "OB", "BinaryLength": 1784}, "363": {"vr": "OB", "BinaryLength": 1784}, "364": {"vr": "OB", "BinaryLength": 1784}, "365": {"vr": "OB", "BinaryLength": 1784}, "366": {"vr": "OB", "BinaryLength": 1784}, "367": {"vr": "OB", "BinaryLength": 1784}, "368": {"vr": "OB", "BinaryLength": 1784}, "369": {"vr": "OB", "BinaryLength": 1784}, "370": {"vr": "OB", "BinaryLength": 1784}, "371": {"vr": "OB", "BinaryLength": 1784}, "372": {"vr": "OB", "BinaryLength": 1784}, "373": {"vr": "OB", "BinaryLength": 1784}, "374": {"vr": "OB", "BinaryLength": 1784}, "375": {"vr": "OB", "BinaryLength": 1784}, "376": {"vr": "OB", "BinaryLength": 1784}, "377": {"vr": "OB", "BinaryLength": 1784}, "378": {"vr": "OB", "BinaryLength": 1784}, "379": {"vr": "OB", "BinaryLength": 1784}, "380": {"vr": "OB", "BinaryLength": 1784}, "381": {"vr": "OB", "BinaryLength": 1784}, "382": {"vr": "OB", "BinaryLength": 1784}, "383": {"vr": "OB", "BinaryLength": 1784}, "384": {"vr": "OB", "BinaryLength": 1784}, "385": {"vr": "OB", "BinaryLength": 1784}, "386": {"vr": "OB", "BinaryLength": 1784}, "387": {"vr": "OB", "BinaryLength": 1784}, "388": {"vr": "OB", "BinaryLength": 1784}, "389": {"vr": "OB", "BinaryLength": 1784}, "390": {"vr": "OB", "BinaryLength": 1784}, "391": {"vr": "OB", "BinaryLength": 1784}, "392": {"vr": "OB", "BinaryLength": 1784}, "393": {"vr": "OB", "BinaryLength": 1784}, "394": {"vr": "OB", "BinaryLength": 1784}, "395": {"vr": "OB", "BinaryLength": 1784}, "396": {"vr": "OB", "BinaryLength": 1784}, "397": {"vr": "OB", "BinaryLength": 1784}, "398": {"vr": "OB", "BinaryLength": 1784}, "399": {"vr": "OB", "BinaryLength": 1784}, "400": {"vr": "OB", "BinaryLength": 1784}, "401": {"vr": "OB", "BinaryLength": 1784}, "402": {"vr": "OB", "BinaryLength": 1784}, "403": {"vr": "OB", "BinaryLength": 1784}, "404": {"vr": "OB", "BinaryLength": 1784}, "405": {"vr": "OB", "BinaryLength": 1784}, "406": {"vr": "OB", "BinaryLength": 1784}, "407": {"vr": "OB", "BinaryLength": 1784}, "408": {"vr": "OB", "BinaryLength": 1784}, "409": {"vr": "OB", "BinaryLength": 1784}, "410": {"vr": "OB", "BinaryLength": 1784}, "411": {"vr": "OB", "BinaryLength": 1784}, "412": {"vr": "OB", "BinaryLength": 1784}, "413": {"vr": "OB", "BinaryLength": 1784}, "414": {"vr": "OB", "BinaryLength": 1784}, "415": {"vr": "OB", "BinaryLength": 1784}, "416": {"vr": "OB", "BinaryLength": 1784}, "417": {"vr": "OB", "BinaryLength": 1784}, "418": {"vr": "OB", "BinaryLength": 1784}, "419": {"vr": "OB", "BinaryLength": 1784}, "420": {"vr": "OB", "BinaryLength": 1784}, "421": {"vr": "OB", "BinaryLength": 1784}, "422": {"vr": "OB", "BinaryLength": 1784}, "423": {"vr": "OB", "BinaryLength": 1784}, "424": {"vr": "OB", "BinaryLength": 1784}, "425": {"vr": "OB", "BinaryLength": 1784}, "426": {"vr": "OB", "BinaryLength": 1784}, "427": {"vr": "OB", "BinaryLength": 1784}, "428": {"vr": "OB", "BinaryLength": 1784}, "429": {"vr": "OB", "BinaryLength": 1784}, "430": {"vr": "OB", "BinaryLength": 1784}, "431": {"vr": "OB", "BinaryLength": 1784}, "432": {"vr": "OB", "BinaryLength": 1784}, "433": {"vr": "OB", "BinaryLength": 1784}, "434": {"vr": "OB", "BinaryLength": 1784}, "435": {"vr": "OB", "BinaryLength": 1784}, "436": {"vr": "OB", "BinaryLength": 1784}, "437": {"vr": "OB", "BinaryLength": 1784}, "438": {"vr": "OB", "BinaryLength": 1784}, "439": {"vr": "OB", "BinaryLength": 1784}, "440": {"vr": "OB", "BinaryLength": 1784}, "441": {"vr": "OB", "BinaryLength": 1784}, "442": {"vr": "OB", "BinaryLength": 1784}, "443": {"vr": "OB", "BinaryLength": 1784}, "444": {"vr": "OB", "BinaryLength": 1784}, "445": {"vr": "OB", "BinaryLength": 1784}, "446": {"vr": "OB", "BinaryLength": 1784}, "447": {"vr": "OB", "BinaryLength": 1784}, "448": {"vr": "OB", "BinaryLength": 1784}, "449": {"vr": "OB", "BinaryLength": 1784}, "450": {"vr": "OB", "BinaryLength": 1784}, "451": {"vr": "OB", "BinaryLength": 1784}, "452": {"vr": "OB", "BinaryLength": 1784}, "453": {"vr": "OB", "BinaryLength": 1784}, "454": {"vr": "OB", "BinaryLength": 1784}, "455": {"vr": "OB", "BinaryLength": 1784}, "456": {"vr": "OB", "BinaryLength": 1784}, "457": {"vr": "OB", "BinaryLength": 1784}, "458": {"vr": "OB", "BinaryLength": 1784}, "459": {"vr": "OB", "BinaryLength": 1784}, "460": {"vr": "OB", "BinaryLength": 1784}, "461": {"vr": "OB", "BinaryLength": 1784}, "462": {"vr": "OB", "BinaryLength": 1784}, "463": {"vr": "OB", "BinaryLength": 1784}, "464": {"vr": "OB", "BinaryLength": 1784}, "465": {"vr": "OB", "BinaryLength": 1784}, "466": {"vr": "OB", "BinaryLength": 1784}, "467": {"vr": "OB", "BinaryLength": 1784}, "468": {"vr": "OB", "BinaryLength": 1784}, "469": {"vr": "OB", "BinaryLength": 1784}, "470": {"vr": "OB", "BinaryLength": 1784}, "471": {"vr": "OB", "BinaryLength": 1784}, "472": {"vr": "OB", "BinaryLength": 1784}, "473": {"vr": "OB", "BinaryLength": 1784}, "474": {"vr": "OB", "BinaryLength": 1784}, "475": {"vr": "OB", "BinaryLength": 1784}, "476": {"vr": "OB", "BinaryLength": 1784}, "477": {"vr": "OB", "BinaryLength": 1784}, "478": {"vr": "OB", "BinaryLength": 1784}, "479": {"vr": "OB", "BinaryLength": 1784}, "480": {"vr": "OB", "BinaryLength": 1784}, "481": {"vr": "OB", "BinaryLength": 1784}, "482": {"vr": "OB", "BinaryLength": 1784}, "483": {"vr": "OB", "BinaryLength": 1784}, "484": {"vr": "OB", "BinaryLength": 1784}, "485": {"vr": "OB", "BinaryLength": 1784}, "486": {"vr": "OB", "BinaryLength": 1784}, "487": {"vr": "OB", "BinaryLength": 1784}, "488": {"vr": "OB", "BinaryLength": 1784}, "489": {"vr": "OB", "BinaryLength": 1784}, "490": {"vr": "OB", "BinaryLength": 1784}, "491": {"vr": "OB", "BinaryLength": 1784}, "492": {"vr": "OB", "BinaryLength": 1784}, "493": {"vr": "OB", "BinaryLength": 1784}, "494": {"vr": "OB", "BinaryLength": 1784}, "495": {"vr": "OB", "BinaryLength": 1784}, "496": {"vr": "OB", "BinaryLength": 1784}, "497": {"vr": "OB", "BinaryLength": 1784}, "498": {"vr": "OB", "BinaryLength": 1784}, "499": {"vr": "OB", "BinaryLength": 1784}, "500": {"vr": "OB", "BinaryLength": 1784}, "501": {"vr": "OB", "BinaryLength": 1784}, "502": {"vr": "OB", "BinaryLength": 1784}, "503": {"vr": "OB", "BinaryLength": 1784}, "504": {"vr": "OB", "BinaryLength": 1784}, "505": {"vr": "OB", "BinaryLength": 1784}, "506": {"vr": "OB", "BinaryLength": 1784}, "507": {"vr": "OB", "BinaryLength": 1784}, "508": {"vr": "OB", "BinaryLength": 1784}, "509": {"vr": "OB", "BinaryLength": 1784}, "510": {"vr": "OB", "BinaryLength": 1784}, "511": {"vr": "OB", "BinaryLength": 1784}, "512": {"vr": "OB", "BinaryLength": 1784}, "513": {"vr": "OB", "BinaryLength": 1784}, "514": {"vr": "OB", "BinaryLength": 1784}, "515": {"vr": "OB", "BinaryLength": 1784}, "516": {"vr": "OB", "BinaryLength": 1784}, "517": {"vr": "OB", "BinaryLength": 1784}, "518": {"vr": "OB", "BinaryLength": 1784}, "519": {"vr": "OB", "BinaryLength": 1784}, "520": {"vr": "OB", "BinaryLength": 1784}, "521": {"vr": "OB", "BinaryLength": 1784}, "522": {"vr": "OB", "BinaryLength": 1784}, "523": {"vr": "OB", "BinaryLength": 1784}, "524": {"vr": "OB", "BinaryLength": 1784}, "525": {"vr": "OB", "BinaryLength": 1784}, "526": {"vr": "OB", "BinaryLength": 1784}, "527": {"vr": "OB", "BinaryLength": 1784}, "528": {"vr": "OB", "BinaryLength": 1784}, "529": {"vr": "OB", "BinaryLength": 1784}, "530": {"vr": "OB", "BinaryLength": 1784}}, "00291210": {"0": {"vr": "OB", "BinaryLength": 1504}, "1": {"vr": "OB", "BinaryLength": 1504}, "2": {"vr": "OB", "BinaryLength": 1504}, "3": {"vr": "OB", "BinaryLength": 1504}, "4": {"vr": "OB", "BinaryLength": 1504}, "5": {"vr": "OB", "BinaryLength": 1504}, "6": {"vr": "OB", "BinaryLength": 1504}, "7": {"vr": "OB", "BinaryLength": 1504}, "8": {"vr": "OB", "BinaryLength": 1504}, "9": {"vr": "OB", "BinaryLength": 1504}, "10": {"vr": "OB", "BinaryLength": 1504}, "11": {"vr": "OB", "BinaryLength": 1504}, "12": {"vr": "OB", "BinaryLength": 1504}, "13": {"vr": "OB", "BinaryLength": 1504}, "14": {"vr": "OB", "BinaryLength": 1504}, "15": {"vr": "OB", "BinaryLength": 1504}, "16": {"vr": "OB", "BinaryLength": 1504}, "17": {"vr": "OB", "BinaryLength": 1504}, "18": {"vr": "OB", "BinaryLength": 1504}, "19": {"vr": "OB", "BinaryLength": 1504}, "20": {"vr": "OB", "BinaryLength": 1504}, "21": {"vr": "OB", "BinaryLength": 1504}, "22": {"vr": "OB", "BinaryLength": 1504}, "23": {"vr": "OB", "BinaryLength": 1504}, "24": {"vr": "OB", "BinaryLength": 1504}, "25": {"vr": "OB", "BinaryLength": 1504}, "26": {"vr": "OB", "BinaryLength": 1504}, "27": {"vr": "OB", "BinaryLength": 1504}, "28": {"vr": "OB", "BinaryLength": 1504}, "29": {"vr": "OB", "BinaryLength": 1504}, "30": {"vr": "OB", "BinaryLength": 1504}, "31": {"vr": "OB", "BinaryLength": 1504}, "32": {"vr": "OB", "BinaryLength": 1504}, "33": {"vr": "OB", "BinaryLength": 1504}, "34": {"vr": "OB", "BinaryLength": 1504}, "35": {"vr": "OB", "BinaryLength": 1504}, "36": {"vr": "OB", "BinaryLength": 1504}, "37": {"vr": "OB", "BinaryLength": 1504}, "38": {"vr": "OB", "BinaryLength": 1504}, "39": {"vr": "OB", "BinaryLength": 1504}, "40": {"vr": "OB", "BinaryLength": 1504}, "41": {"vr": "OB", "BinaryLength": 1504}, "42": {"vr": "OB", "BinaryLength": 1504}, "43": {"vr": "OB", "BinaryLength": 1504}, "44": {"vr": "OB", "BinaryLength": 1504}, "45": {"vr": "OB", "BinaryLength": 1504}, "46": {"vr": "OB", "BinaryLength": 1504}, "47": {"vr": "OB", "BinaryLength": 1504}, "48": {"vr": "OB", "BinaryLength": 1504}, "49": {"vr": "OB", "BinaryLength": 1504}, "50": {"vr": "OB", "BinaryLength": 1504}, "51": {"vr": "OB", "BinaryLength": 1504}, "52": {"vr": "OB", "BinaryLength": 1504}, "53": {"vr": "OB", "BinaryLength": 1504}, "54": {"vr": "OB", "BinaryLength": 1504}, "55": {"vr": "OB", "BinaryLength": 1504}, "56": {"vr": "OB", "BinaryLength": 1504}, "57": {"vr": "OB", "BinaryLength": 1504}, "58": {"vr": "OB", "BinaryLength": 1504}, "59": {"vr": "OB", "BinaryLength": 1504}, "60": {"vr": "OB", "BinaryLength": 1504}, "61": {"vr": "OB", "BinaryLength": 1504}, "62": {"vr": "OB", "BinaryLength": 1504}, "63": {"vr": "OB", "BinaryLength": 1504}, "64": {"vr": "OB", "BinaryLength": 1504}, "65": {"vr": "OB", "BinaryLength": 1504}, "66": {"vr": "OB", "BinaryLength": 1504}, "67": {"vr": "OB", "BinaryLength": 1504}, "68": {"vr": "OB", "BinaryLength": 1504}, "69": {"vr": "OB", "BinaryLength": 1504}, "70": {"vr": "OB", "BinaryLength": 1504}, "71": {"vr": "OB", "BinaryLength": 1504}, "72": {"vr": "OB", "BinaryLength": 1504}, "73": {"vr": "OB", "BinaryLength": 1504}, "74": {"vr": "OB", "BinaryLength": 1504}, "75": {"vr": "OB", "BinaryLength": 1504}, "76": {"vr": "OB", "BinaryLength": 1504}, "77": {"vr": "OB", "BinaryLength": 1504}, "78": {"vr": "OB", "BinaryLength": 1504}, "79": {"vr": "OB", "BinaryLength": 1504}, "80": {"vr": "OB", "BinaryLength": 1504}, "81": {"vr": "OB", "BinaryLength": 1504}, "82": {"vr": "OB", "BinaryLength": 1504}, "83": {"vr": "OB", "BinaryLength": 1504}, "84": {"vr": "OB", "BinaryLength": 1504}, "85": {"vr": "OB", "BinaryLength": 1504}, "86": {"vr": "OB", "BinaryLength": 1504}, "87": {"vr": "OB", "BinaryLength": 1504}, "88": {"vr": "OB", "BinaryLength": 1504}, "89": {"vr": "OB", "BinaryLength": 1504}, "90": {"vr": "OB", "BinaryLength": 1504}, "91": {"vr": "OB", "BinaryLength": 1504}, "92": {"vr": "OB", "BinaryLength": 1504}, "93": {"vr": "OB", "BinaryLength": 1504}, "94": {"vr": "OB", "BinaryLength": 1504}, "95": {"vr": "OB", "BinaryLength": 1504}, "96": {"vr": "OB", "BinaryLength": 1504}, "97": {"vr": "OB", "BinaryLength": 1504}, "98": {"vr": "OB", "BinaryLength": 1504}, "99": {"vr": "OB", "BinaryLength": 1504}, "100": {"vr": "OB", "BinaryLength": 1504}, "101": {"vr": "OB", "BinaryLength": 1504}, "102": {"vr": "OB", "BinaryLength": 1504}, "103": {"vr": "OB", "BinaryLength": 1504}, "104": {"vr": "OB", "BinaryLength": 1504}, "105": {"vr": "OB", "BinaryLength": 1504}, "106": {"vr": "OB", "BinaryLength": 1504}, "107": {"vr": "OB", "BinaryLength": 1504}, "108": {"vr": "OB", "BinaryLength": 1504}, "109": {"vr": "OB", "BinaryLength": 1504}, "110": {"vr": "OB", "BinaryLength": 1504}, "111": {"vr": "OB", "BinaryLength": 1504}, "112": {"vr": "OB", "BinaryLength": 1504}, "113": {"vr": "OB", "BinaryLength": 1504}, "114": {"vr": "OB", "BinaryLength": 1504}, "115": {"vr": "OB", "BinaryLength": 1504}, "116": {"vr": "OB", "BinaryLength": 1504}, "117": {"vr": "OB", "BinaryLength": 1504}, "118": {"vr": "OB", "BinaryLength": 1504}, "119": {"vr": "OB", "BinaryLength": 1504}, "120": {"vr": "OB", "BinaryLength": 1504}, "121": {"vr": "OB", "BinaryLength": 1504}, "122": {"vr": "OB", "BinaryLength": 1504}, "123": {"vr": "OB", "BinaryLength": 1504}, "124": {"vr": "OB", "BinaryLength": 1504}, "125": {"vr": "OB", "BinaryLength": 1504}, "126": {"vr": "OB", "BinaryLength": 1504}, "127": {"vr": "OB", "BinaryLength": 1504}, "128": {"vr": "OB", "BinaryLength": 1504}, "129": {"vr": "OB", "BinaryLength": 1504}, "130": {"vr": "OB", "BinaryLength": 1504}, "131": {"vr": "OB", "BinaryLength": 1504}, "132": {"vr": "OB", "BinaryLength": 1504}, "133": {"vr": "OB", "BinaryLength": 1504}, "134": {"vr": "OB", "BinaryLength": 1504}, "135": {"vr": "OB", "BinaryLength": 1504}, "136": {"vr": "OB", "BinaryLength": 1504}, "137": {"vr": "OB", "BinaryLength": 1504}, "138": {"vr": "OB", "BinaryLength": 1504}, "139": {"vr": "OB", "BinaryLength": 1504}, "140": {"vr": "OB", "BinaryLength": 1504}, "141": {"vr": "OB", "BinaryLength": 1504}, "142": {"vr": "OB", "BinaryLength": 1504}, "143": {"vr": "OB", "BinaryLength": 1504}, "144": {"vr": "OB", "BinaryLength": 1504}, "145": {"vr": "OB", "BinaryLength": 1504}, "146": {"vr": "OB", "BinaryLength": 1504}, "147": {"vr": "OB", "BinaryLength": 1504}, "148": {"vr": "OB", "BinaryLength": 1504}, "149": {"vr": "OB", "BinaryLength": 1504}, "150": {"vr": "OB", "BinaryLength": 1504}, "151": {"vr": "OB", "BinaryLength": 1504}, "152": {"vr": "OB", "BinaryLength": 1504}, "153": {"vr": "OB", "BinaryLength": 1504}, "154": {"vr": "OB", "BinaryLength": 1504}, "155": {"vr": "OB", "BinaryLength": 1504}, "156": {"vr": "OB", "BinaryLength": 1504}, "157": {"vr": "OB", "BinaryLength": 1504}, "158": {"vr": "OB", "BinaryLength": 1504}, "159": {"vr": "OB", "BinaryLength": 1504}, "160": {"vr": "OB", "BinaryLength": 1504}, "161": {"vr": "OB", "BinaryLength": 1504}, "162": {"vr": "OB", "BinaryLength": 1504}, "163": {"vr": "OB", "BinaryLength": 1504}, "164": {"vr": "OB", "BinaryLength": 1504}, "165": {"vr": "OB", "BinaryLength": 1504}, "166": {"vr": "OB", "BinaryLength": 1504}, "167": {"vr": "OB", "BinaryLength": 1504}, "168": {"vr": "OB", "BinaryLength": 1504}, "169": {"vr": "OB", "BinaryLength": 1504}, "170": {"vr": "OB", "BinaryLength": 1504}, "171": {"vr": "OB", "BinaryLength": 1504}, "172": {"vr": "OB", "BinaryLength": 1504}, "173": {"vr": "OB", "BinaryLength": 1504}, "174": {"vr": "OB", "BinaryLength": 1504}, "175": {"vr": "OB", "BinaryLength": 1504}, "176": {"vr": "OB", "BinaryLength": 1504}, "177": {"vr": "OB", "BinaryLength": 1504}, "178": {"vr": "OB", "BinaryLength": 1504}, "179": {"vr": "OB", "BinaryLength": 1504}, "180": {"vr": "OB", "BinaryLength": 1504}, "181": {"vr": "OB", "BinaryLength": 1504}, "182": {"vr": "OB", "BinaryLength": 1504}, "183": {"vr": "OB", "BinaryLength": 1504}, "184": {"vr": "OB", "BinaryLength": 1504}, "185": {"vr": "OB", "BinaryLength": 1504}, "186": {"vr": "OB", "BinaryLength": 1504}, "187": {"vr": "OB", "BinaryLength": 1504}, "188": {"vr": "OB", "BinaryLength": 1504}, "189": {"vr": "OB", "BinaryLength": 1504}, "190": {"vr": "OB", "BinaryLength": 1504}, "191": {"vr": "OB", "BinaryLength": 1504}, "192": {"vr": "OB", "BinaryLength": 1504}, "193": {"vr": "OB", "BinaryLength": 1504}, "194": {"vr": "OB", "BinaryLength": 1504}, "195": {"vr": "OB", "BinaryLength": 1504}, "196": {"vr": "OB", "BinaryLength": 1504}, "197": {"vr": "OB", "BinaryLength": 1504}, "198": {"vr": "OB", "BinaryLength": 1504}, "199": {"vr": "OB", "BinaryLength": 1504}, "200": {"vr": "OB", "BinaryLength": 1504}, "201": {"vr": "OB", "BinaryLength": 1504}, "202": {"vr": "OB", "BinaryLength": 1504}, "203": {"vr": "OB", "BinaryLength": 1504}, "204": {"vr": "OB", "BinaryLength": 1504}, "205": {"vr": "OB", "BinaryLength": 1504}, "206": {"vr": "OB", "BinaryLength": 1504}, "207": {"vr": "OB", "BinaryLength": 1504}, "208": {"vr": "OB", "BinaryLength": 1504}, "209": {"vr": "OB", "BinaryLength": 1504}, "210": {"vr": "OB", "BinaryLength": 1504}, "211": {"vr": "OB", "BinaryLength": 1504}, "212": {"vr": "OB", "BinaryLength": 1504}, "213": {"vr": "OB", "BinaryLength": 1504}, "214": {"vr": "OB", "BinaryLength": 1504}, "215": {"vr": "OB", "BinaryLength": 1504}, "216": {"vr": "OB", "BinaryLength": 1504}, "217": {"vr": "OB", "BinaryLength": 1504}, "218": {"vr": "OB", "BinaryLength": 1504}, "219": {"vr": "OB", "BinaryLength": 1504}, "220": {"vr": "OB", "BinaryLength": 1504}, "221": {"vr": "OB", "BinaryLength": 1504}, "222": {"vr": "OB", "BinaryLength": 1504}, "223": {"vr": "OB", "BinaryLength": 1504}, "224": {"vr": "OB", "BinaryLength": 1504}, "225": {"vr": "OB", "BinaryLength": 1504}, "226": {"vr": "OB", "BinaryLength": 1504}, "227": {"vr": "OB", "BinaryLength": 1504}, "228": {"vr": "OB", "BinaryLength": 1504}, "229": {"vr": "OB", "BinaryLength": 1504}, "230": {"vr": "OB", "BinaryLength": 1504}, "231": {"vr": "OB", "BinaryLength": 1504}, "232": {"vr": "OB", "BinaryLength": 1504}, "233": {"vr": "OB", "BinaryLength": 1504}, "234": {"vr": "OB", "BinaryLength": 1504}, "235": {"vr": "OB", "BinaryLength": 1504}, "236": {"vr": "OB", "BinaryLength": 1504}, "237": {"vr": "OB", "BinaryLength": 1504}, "238": {"vr": "OB", "BinaryLength": 1504}, "239": {"vr": "OB", "BinaryLength": 1504}, "240": {"vr": "OB", "BinaryLength": 1504}, "241": {"vr": "OB", "BinaryLength": 1504}, "242": {"vr": "OB", "BinaryLength": 1504}, "243": {"vr": "OB", "BinaryLength": 1504}, "244": {"vr": "OB", "BinaryLength": 1504}, "245": {"vr": "OB", "BinaryLength": 1504}, "246": {"vr": "OB", "BinaryLength": 1504}, "247": {"vr": "OB", "BinaryLength": 1504}, "248": {"vr": "OB", "BinaryLength": 1504}, "249": {"vr": "OB", "BinaryLength": 1504}, "250": {"vr": "OB", "BinaryLength": 1504}, "251": {"vr": "OB", "BinaryLength": 1504}, "252": {"vr": "OB", "BinaryLength": 1504}, "253": {"vr": "OB", "BinaryLength": 1504}, "254": {"vr": "OB", "BinaryLength": 1504}, "255": {"vr": "OB", "BinaryLength": 1504}, "256": {"vr": "OB", "BinaryLength": 1504}, "257": {"vr": "OB", "BinaryLength": 1504}, "258": {"vr": "OB", "BinaryLength": 1504}, "259": {"vr": "OB", "BinaryLength": 1504}, "260": {"vr": "OB", "BinaryLength": 1504}, "261": {"vr": "OB", "BinaryLength": 1504}, "262": {"vr": "OB", "BinaryLength": 1504}, "263": {"vr": "OB", "BinaryLength": 1504}, "264": {"vr": "OB", "BinaryLength": 1504}, "265": {"vr": "OB", "BinaryLength": 1504}, "266": {"vr": "OB", "BinaryLength": 1504}, "267": {"vr": "OB", "BinaryLength": 1504}, "268": {"vr": "OB", "BinaryLength": 1504}, "269": {"vr": "OB", "BinaryLength": 1504}, "270": {"vr": "OB", "BinaryLength": 1504}, "271": {"vr": "OB", "BinaryLength": 1504}, "272": {"vr": "OB", "BinaryLength": 1504}, "273": {"vr": "OB", "BinaryLength": 1504}, "274": {"vr": "OB", "BinaryLength": 1504}, "275": {"vr": "OB", "BinaryLength": 1504}, "276": {"vr": "OB", "BinaryLength": 1504}, "277": {"vr": "OB", "BinaryLength": 1504}, "278": {"vr": "OB", "BinaryLength": 1504}, "279": {"vr": "OB", "BinaryLength": 1504}, "280": {"vr": "OB", "BinaryLength": 1504}, "281": {"vr": "OB", "BinaryLength": 1504}, "282": {"vr": "OB", "BinaryLength": 1504}, "283": {"vr": "OB", "BinaryLength": 1504}, "284": {"vr": "OB", "BinaryLength": 1504}, "285": {"vr": "OB", "BinaryLength": 1504}, "286": {"vr": "OB", "BinaryLength": 1504}, "287": {"vr": "OB", "BinaryLength": 1504}, "288": {"vr": "OB", "BinaryLength": 1504}, "289": {"vr": "OB", "BinaryLength": 1504}, "290": {"vr": "OB", "BinaryLength": 1504}, "291": {"vr": "OB", "BinaryLength": 1504}, "292": {"vr": "OB", "BinaryLength": 1504}, "293": {"vr": "OB", "BinaryLength": 1504}, "294": {"vr": "OB", "BinaryLength": 1504}, "295": {"vr": "OB", "BinaryLength": 1504}, "296": {"vr": "OB", "BinaryLength": 1504}, "297": {"vr": "OB", "BinaryLength": 1504}, "298": {"vr": "OB", "BinaryLength": 1504}, "299": {"vr": "OB", "BinaryLength": 1504}, "300": {"vr": "OB", "BinaryLength": 1504}, "301": {"vr": "OB", "BinaryLength": 1504}, "302": {"vr": "OB", "BinaryLength": 1504}, "303": {"vr": "OB", "BinaryLength": 1504}, "304": {"vr": "OB", "BinaryLength": 1504}, "305": {"vr": "OB", "BinaryLength": 1504}, "306": {"vr": "OB", "BinaryLength": 1504}, "307": {"vr": "OB", "BinaryLength": 1504}, "308": {"vr": "OB", "BinaryLength": 1504}, "309": {"vr": "OB", "BinaryLength": 1504}, "310": {"vr": "OB", "BinaryLength": 1504}, "311": {"vr": "OB", "BinaryLength": 1504}, "312": {"vr": "OB", "BinaryLength": 1504}, "313": {"vr": "OB", "BinaryLength": 1504}, "314": {"vr": "OB", "BinaryLength": 1504}, "315": {"vr": "OB", "BinaryLength": 1504}, "316": {"vr": "OB", "BinaryLength": 1504}, "317": {"vr": "OB", "BinaryLength": 1504}, "318": {"vr": "OB", "BinaryLength": 1504}, "319": {"vr": "OB", "BinaryLength": 1504}, "320": {"vr": "OB", "BinaryLength": 1504}, "321": {"vr": "OB", "BinaryLength": 1504}, "322": {"vr": "OB", "BinaryLength": 1504}, "323": {"vr": "OB", "BinaryLength": 1504}, "324": {"vr": "OB", "BinaryLength": 1504}, "325": {"vr": "OB", "BinaryLength": 1504}, "326": {"vr": "OB", "BinaryLength": 1504}, "327": {"vr": "OB", "BinaryLength": 1504}, "328": {"vr": "OB", "BinaryLength": 1504}, "329": {"vr": "OB", "BinaryLength": 1504}, "330": {"vr": "OB", "BinaryLength": 1504}, "331": {"vr": "OB", "BinaryLength": 1504}, "332": {"vr": "OB", "BinaryLength": 1504}, "333": {"vr": "OB", "BinaryLength": 1504}, "334": {"vr": "OB", "BinaryLength": 1504}, "335": {"vr": "OB", "BinaryLength": 1504}, "336": {"vr": "OB", "BinaryLength": 1504}, "337": {"vr": "OB", "BinaryLength": 1504}, "338": {"vr": "OB", "BinaryLength": 1504}, "339": {"vr": "OB", "BinaryLength": 1504}, "340": {"vr": "OB", "BinaryLength": 1504}, "341": {"vr": "OB", "BinaryLength": 1504}, "342": {"vr": "OB", "BinaryLength": 1504}, "343": {"vr": "OB", "BinaryLength": 1504}, "344": {"vr": "OB", "BinaryLength": 1504}, "345": {"vr": "OB", "BinaryLength": 1504}, "346": {"vr": "OB", "BinaryLength": 1504}, "347": {"vr": "OB", "BinaryLength": 1504}, "348": {"vr": "OB", "BinaryLength": 1504}, "349": {"vr": "OB", "BinaryLength": 1504}, "350": {"vr": "OB", "BinaryLength": 1504}, "351": {"vr": "OB", "BinaryLength": 1504}, "352": {"vr": "OB", "BinaryLength": 1504}, "353": {"vr": "OB", "BinaryLength": 1504}, "354": {"vr": "OB", "BinaryLength": 1504}, "355": {"vr": "OB", "BinaryLength": 1504}, "356": {"vr": "OB", "BinaryLength": 1504}, "357": {"vr": "OB", "BinaryLength": 1504}, "358": {"vr": "OB", "BinaryLength": 1504}, "359": {"vr": "OB", "BinaryLength": 1504}, "360": {"vr": "OB", "BinaryLength": 1504}, "361": {"vr": "OB", "BinaryLength": 1504}, "362": {"vr": "OB", "BinaryLength": 1504}, "363": {"vr": "OB", "BinaryLength": 1504}, "364": {"vr": "OB", "BinaryLength": 1504}, "365": {"vr": "OB", "BinaryLength": 1504}, "366": {"vr": "OB", "BinaryLength": 1504}, "367": {"vr": "OB", "BinaryLength": 1504}, "368": {"vr": "OB", "BinaryLength": 1504}, "369": {"vr": "OB", "BinaryLength": 1504}, "370": {"vr": "OB", "BinaryLength": 1504}, "371": {"vr": "OB", "BinaryLength": 1504}, "372": {"vr": "OB", "BinaryLength": 1504}, "373": {"vr": "OB", "BinaryLength": 1504}, "374": {"vr": "OB", "BinaryLength": 1504}, "375": {"vr": "OB", "BinaryLength": 1504}, "376": {"vr": "OB", "BinaryLength": 1504}, "377": {"vr": "OB", "BinaryLength": 1504}, "378": {"vr": "OB", "BinaryLength": 1504}, "379": {"vr": "OB", "BinaryLength": 1504}, "380": {"vr": "OB", "BinaryLength": 1504}, "381": {"vr": "OB", "BinaryLength": 1504}, "382": {"vr": "OB", "BinaryLength": 1504}, "383": {"vr": "OB", "BinaryLength": 1504}, "384": {"vr": "OB", "BinaryLength": 1504}, "385": {"vr": "OB", "BinaryLength": 1504}, "386": {"vr": "OB", "BinaryLength": 1504}, "387": {"vr": "OB", "BinaryLength": 1504}, "388": {"vr": "OB", "BinaryLength": 1504}, "389": {"vr": "OB", "BinaryLength": 1504}, "390": {"vr": "OB", "BinaryLength": 1504}, "391": {"vr": "OB", "BinaryLength": 1504}, "392": {"vr": "OB", "BinaryLength": 1504}, "393": {"vr": "OB", "BinaryLength": 1504}, "394": {"vr": "OB", "BinaryLength": 1504}, "395": {"vr": "OB", "BinaryLength": 1504}, "396": {"vr": "OB", "BinaryLength": 1504}, "397": {"vr": "OB", "BinaryLength": 1504}, "398": {"vr": "OB", "BinaryLength": 1504}, "399": {"vr": "OB", "BinaryLength": 1504}, "400": {"vr": "OB", "BinaryLength": 1504}, "401": {"vr": "OB", "BinaryLength": 1504}, "402": {"vr": "OB", "BinaryLength": 1504}, "403": {"vr": "OB", "BinaryLength": 1504}, "404": {"vr": "OB", "BinaryLength": 1504}, "405": {"vr": "OB", "BinaryLength": 1504}, "406": {"vr": "OB", "BinaryLength": 1504}, "407": {"vr": "OB", "BinaryLength": 1504}, "408": {"vr": "OB", "BinaryLength": 1504}, "409": {"vr": "OB", "BinaryLength": 1504}, "410": {"vr": "OB", "BinaryLength": 1504}, "411": {"vr": "OB", "BinaryLength": 1504}, "412": {"vr": "OB", "BinaryLength": 1504}, "413": {"vr": "OB", "BinaryLength": 1504}, "414": {"vr": "OB", "BinaryLength": 1504}, "415": {"vr": "OB", "BinaryLength": 1504}, "416": {"vr": "OB", "BinaryLength": 1504}, "417": {"vr": "OB", "BinaryLength": 1504}, "418": {"vr": "OB", "BinaryLength": 1504}, "419": {"vr": "OB", "BinaryLength": 1504}, "420": {"vr": "OB", "BinaryLength": 1504}, "421": {"vr": "OB", "BinaryLength": 1504}, "422": {"vr": "OB", "BinaryLength": 1504}, "423": {"vr": "OB", "BinaryLength": 1504}, "424": {"vr": "OB", "BinaryLength": 1504}, "425": {"vr": "OB", "BinaryLength": 1504}, "426": {"vr": "OB", "BinaryLength": 1504}, "427": {"vr": "OB", "BinaryLength": 1504}, "428": {"vr": "OB", "BinaryLength": 1504}, "429": {"vr": "OB", "BinaryLength": 1504}, "430": {"vr": "OB", "BinaryLength": 1504}, "431": {"vr": "OB", "BinaryLength": 1504}, "432": {"vr": "OB", "BinaryLength": 1504}, "433": {"vr": "OB", "BinaryLength": 1504}, "434": {"vr": "OB", "BinaryLength": 1504}, "435": {"vr": "OB", "BinaryLength": 1504}, "436": {"vr": "OB", "BinaryLength": 1504}, "437": {"vr": "OB", "BinaryLength": 1504}, "438": {"vr": "OB", "BinaryLength": 1504}, "439": {"vr": "OB", "BinaryLength": 1504}, "440": {"vr": "OB", "BinaryLength": 1504}, "441": {"vr": "OB", "BinaryLength": 1504}, "442": {"vr": "OB", "BinaryLength": 1504}, "443": {"vr": "OB", "BinaryLength": 1504}, "444": {"vr": "OB", "BinaryLength": 1504}, "445": {"vr": "OB", "BinaryLength": 1504}, "446": {"vr": "OB", "BinaryLength": 1504}, "447": {"vr": "OB", "BinaryLength": 1504}, "448": {"vr": "OB", "BinaryLength": 1504}, "449": {"vr": "OB", "BinaryLength": 1504}, "450": {"vr": "OB", "BinaryLength": 1504}, "451": {"vr": "OB", "BinaryLength": 1504}, "452": {"vr": "OB", "BinaryLength": 1504}, "453": {"vr": "OB", "BinaryLength": 1504}, "454": {"vr": "OB", "BinaryLength": 1504}, "455": {"vr": "OB", "BinaryLength": 1504}, "456": {"vr": "OB", "BinaryLength": 1504}, "457": {"vr": "OB", "BinaryLength": 1504}, "458": {"vr": "OB", "BinaryLength": 1504}, "459": {"vr": "OB", "BinaryLength": 1504}, "460": {"vr": "OB", "BinaryLength": 1504}, "461": {"vr": "OB", "BinaryLength": 1504}, "462": {"vr": "OB", "BinaryLength": 1504}, "463": {"vr": "OB", "BinaryLength": 1504}, "464": {"vr": "OB", "BinaryLength": 1504}, "465": {"vr": "OB", "BinaryLength": 1504}, "466": {"vr": "OB", "BinaryLength": 1504}, "467": {"vr": "OB", "BinaryLength": 1504}, "468": {"vr": "OB", "BinaryLength": 1504}, "469": {"vr": "OB", "BinaryLength": 1504}, "470": {"vr": "OB", "BinaryLength": 1504}, "471": {"vr": "OB", "BinaryLength": 1504}, "472": {"vr": "OB", "BinaryLength": 1504}, "473": {"vr": "OB", "BinaryLength": 1504}, "474": {"vr": "OB", "BinaryLength": 1504}, "475": {"vr": "OB", "BinaryLength": 1504}, "476": {"vr": "OB", "BinaryLength": 1504}, "477": {"vr": "OB", "BinaryLength": 1504}, "478": {"vr": "OB", "BinaryLength": 1504}, "479": {"vr": "OB", "BinaryLength": 1504}, "480": {"vr": "OB", "BinaryLength": 1504}, "481": {"vr": "OB", "BinaryLength": 1504}, "482": {"vr": "OB", "BinaryLength": 1504}, "483": {"vr": "OB", "BinaryLength": 1504}, "484": {"vr": "OB", "BinaryLength": 1504}, "485": {"vr": "OB", "BinaryLength": 1504}, "486": {"vr": "OB", "BinaryLength": 1504}, "487": {"vr": "OB", "BinaryLength": 1504}, "488": {"vr": "OB", "BinaryLength": 1504}, "489": {"vr": "OB", "BinaryLength": 1504}, "490": {"vr": "OB", "BinaryLength": 1504}, "491": {"vr": "OB", "BinaryLength": 1504}, "492": {"vr": "OB", "BinaryLength": 1504}, "493": {"vr": "OB", "BinaryLength": 1504}, "494": {"vr": "OB", "BinaryLength": 1504}, "495": {"vr": "OB", "BinaryLength": 1504}, "496": {"vr": "OB", "BinaryLength": 1504}, "497": {"vr": "OB", "BinaryLength": 1504}, "498": {"vr": "OB", "BinaryLength": 1504}, "499": {"vr": "OB", "BinaryLength": 1504}, "500": {"vr": "OB", "BinaryLength": 1504}, "501": {"vr": "OB", "BinaryLength": 1504}, "502": {"vr": "OB", "BinaryLength": 1504}, "503": {"vr": "OB", "BinaryLength": 1504}, "504": {"vr": "OB", "BinaryLength": 1504}, "505": {"vr": "OB", "BinaryLength": 1504}, "506": {"vr": "OB", "BinaryLength": 1504}, "507": {"vr": "OB", "BinaryLength": 1504}, "508": {"vr": "OB", "BinaryLength": 1504}, "509": {"vr": "OB", "BinaryLength": 1504}, "510": {"vr": "OB", "BinaryLength": 1504}, "511": {"vr": "OB", "BinaryLength": 1504}, "512": {"vr": "OB", "BinaryLength": 1504}, "513": {"vr": "OB", "BinaryLength": 1504}, "514": {"vr": "OB", "BinaryLength": 1504}, "515": {"vr": "OB", "BinaryLength": 1504}, "516": {"vr": "OB", "BinaryLength": 1504}, "517": {"vr": "OB", "BinaryLength": 1504}, "518": {"vr": "OB", "BinaryLength": 1504}, "519": {"vr": "OB", "BinaryLength": 1504}, "520": {"vr": "OB", "BinaryLength": 1504}, "521": {"vr": "OB", "BinaryLength": 1504}, "522": {"vr": "OB", "BinaryLength": 1504}, "523": {"vr": "OB", "BinaryLength": 1504}, "524": {"vr": "OB", "BinaryLength": 1504}, "525": {"vr": "OB", "BinaryLength": 1504}, "526": {"vr": "OB", "BinaryLength": 1504}, "527": {"vr": "OB", "BinaryLength": 1504}, "528": {"vr": "OB", "BinaryLength": 1504}, "529": {"vr": "OB", "BinaryLength": 1504}, "530": {"vr": "OB", "BinaryLength": 1504}}, "60003000": {"0": {"vr": "OW", "BinaryLength": 43692}, "1": {"vr": "OW", "BinaryLength": 43692}, "2": {"vr": "OW", "BinaryLength": 43692}, "3": {"vr": "OW", "BinaryLength": 43692}, "4": {"vr": "OW", "BinaryLength": 43692}, "5": {"vr": "OW", "BinaryLength": 43692}, "6": {"vr": "OW", "BinaryLength": 43692}, "7": {"vr": "OW", "BinaryLength": 43692}, "8": {"vr": "OW", "BinaryLength": 43692}, "9": {"vr": "OW", "BinaryLength": 43692}, "10": {"vr": "OW", "BinaryLength": 43692}, "11": {"vr": "OW", "BinaryLength": 43692}, "12": {"vr": "OW", "BinaryLength": 43692}, "13": {"vr": "OW", "BinaryLength": 43692}, "14": {"vr": "OW", "BinaryLength": 43692}, "15": {"vr": "OW", "BinaryLength": 43692}, "16": {"vr": "OW", "BinaryLength": 43692}, "17": {"vr": "OW", "BinaryLength": 43692}, "18": {"vr": "OW", "BinaryLength": 43692}, "19": {"vr": "OW", "BinaryLength": 43692}, "20": {"vr": "OW", "BinaryLength": 43692}, "21": {"vr": "OW", "BinaryLength": 43692}, "22": {"vr": "OW", "BinaryLength": 43692}, "23": {"vr": "OW", "BinaryLength": 43692}, "24": {"vr": "OW", "BinaryLength": 43692}, "25": {"vr": "OW", "BinaryLength": 43692}, "26": {"vr": "OW", "BinaryLength": 43692}, "27": {"vr": "OW", "BinaryLength": 43692}, "28": {"vr": "OW", "BinaryLength": 43692}, "29": {"vr": "OW", "BinaryLength": 43692}, "30": {"vr": "OW", "BinaryLength": 43692}, "31": {"vr": "OW", "BinaryLength": 43692}, "32": {"vr": "OW", "BinaryLength": 43692}, "33": {"vr": "OW", "BinaryLength": 43692}, "34": {"vr": "OW", "BinaryLength": 43692}, "35": {"vr": "OW", "BinaryLength": 43692}, "36": {"vr": "OW", "BinaryLength": 43692}, "37": {"vr": "OW", "BinaryLength": 43692}, "38": {"vr": "OW", "BinaryLength": 43692}, "39": {"vr": "OW", "BinaryLength": 43692}, "40": {"vr": "OW", "BinaryLength": 43692}, "41": {"vr": "OW", "BinaryLength": 43692}, "42": {"vr": "OW", "BinaryLength": 43692}, "43": {"vr": "OW", "BinaryLength": 43692}, "44": {"vr": "OW", "BinaryLength": 43692}, "45": {"vr": "OW", "BinaryLength": 43692}, "46": {"vr": "OW", "BinaryLength": 43692}, "47": {"vr": "OW", "BinaryLength": 43692}, "48": {"vr": "OW", "BinaryLength": 43692}, "49": {"vr": "OW", "BinaryLength": 43692}, "50": {"vr": "OW", "BinaryLength": 43692}, "51": {"vr": "OW", "BinaryLength": 43692}, "52": {"vr": "OW", "BinaryLength": 43692}, "53": {"vr": "OW", "BinaryLength": 43692}, "54": {"vr": "OW", "BinaryLength": 43692}, "55": {"vr": "OW", "BinaryLength": 43692}, "56": {"vr": "OW", "BinaryLength": 43692}, "57": {"vr": "OW", "BinaryLength": 43692}, "58": {"vr": "OW", "BinaryLength": 43692}, "59": {"vr": "OW", "BinaryLength": 43692}, "60": {"vr": "OW", "BinaryLength": 43692}, "61": {"vr": "OW", "BinaryLength": 43692}, "62": {"vr": "OW", "BinaryLength": 43692}, "63": {"vr": "OW", "BinaryLength": 43692}, "64": {"vr": "OW", "BinaryLength": 43692}, "65": {"vr": "OW", "BinaryLength": 43692}, "66": {"vr": "OW", "BinaryLength": 43692}, "67": {"vr": "OW", "BinaryLength": 43692}, "68": {"vr": "OW", "BinaryLength": 43692}, "69": {"vr": "OW", "BinaryLength": 43692}, "70": {"vr": "OW", "BinaryLength": 43692}, "71": {"vr": "OW", "BinaryLength": 43692}, "72": {"vr": "OW", "BinaryLength": 43692}, "73": {"vr": "OW", "BinaryLength": 43692}, "74": {"vr": "OW", "BinaryLength": 43692}, "75": {"vr": "OW", "BinaryLength": 43692}, "76": {"vr": "OW", "BinaryLength": 43692}, "77": {"vr": "OW", "BinaryLength": 43692}, "78": {"vr": "OW", "BinaryLength": 43692}, "79": {"vr": "OW", "BinaryLength": 43692}, "80": {"vr": "OW", "BinaryLength": 43692}, "81": {"vr": "OW", "BinaryLength": 43692}, "82": {"vr": "OW", "BinaryLength": 43692}, "83": {"vr": "OW", "BinaryLength": 43692}, "84": {"vr": "OW", "BinaryLength": 43692}, "85": {"vr": "OW", "BinaryLength": 43692}, "86": {"vr": "OW", "BinaryLength": 43692}, "87": {"vr": "OW", "BinaryLength": 43692}, "88": {"vr": "OW", "BinaryLength": 43692}, "89": {"vr": "OW", "BinaryLength": 43692}, "90": {"vr": "OW", "BinaryLength": 43692}, "91": {"vr": "OW", "BinaryLength": 43692}, "92": {"vr": "OW", "BinaryLength": 43692}, "93": {"vr": "OW", "BinaryLength": 43692}, "94": {"vr": "OW", "BinaryLength": 43692}, "95": {"vr": "OW", "BinaryLength": 43692}, "96": {"vr": "OW", "BinaryLength": 43692}, "97": {"vr": "OW", "BinaryLength": 43692}, "98": {"vr": "OW", "BinaryLength": 43692}, "99": {"vr": "OW", "BinaryLength": 43692}, "100": {"vr": "OW", "BinaryLength": 43692}, "101": {"vr": "OW", "BinaryLength": 43692}, "102": {"vr": "OW", "BinaryLength": 43692}, "103": {"vr": "OW", "BinaryLength": 43692}, "104": {"vr": "OW", "BinaryLength": 43692}, "105": {"vr": "OW", "BinaryLength": 43692}, "106": {"vr": "OW", "BinaryLength": 43692}, "107": {"vr": "OW", "BinaryLength": 43692}, "108": {"vr": "OW", "BinaryLength": 43692}, "109": {"vr": "OW", "BinaryLength": 43692}, "110": {"vr": "OW", "BinaryLength": 43692}, "111": {"vr": "OW", "BinaryLength": 43692}, "112": {"vr": "OW", "BinaryLength": 43692}, "113": {"vr": "OW", "BinaryLength": 43692}, "114": {"vr": "OW", "BinaryLength": 43692}, "115": {"vr": "OW", "BinaryLength": 43692}, "116": {"vr": "OW", "BinaryLength": 43692}, "117": {"vr": "OW", "BinaryLength": 43692}, "118": {"vr": "OW", "BinaryLength": 43692}, "119": {"vr": "OW", "BinaryLength": 43692}, "120": {"vr": "OW", "BinaryLength": 43692}, "121": {"vr": "OW", "BinaryLength": 43692}, "122": {"vr": "OW", "BinaryLength": 43692}, "123": {"vr": "OW", "BinaryLength": 43692}, "124": {"vr": "OW", "BinaryLength": 43692}, "125": {"vr": "OW", "BinaryLength": 43692}, "126": {"vr": "OW", "BinaryLength": 43692}, "127": {"vr": "OW", "BinaryLength": 43692}, "128": {"vr": "OW", "BinaryLength": 43692}, "129": {"vr": "OW", "BinaryLength": 43692}, "130": {"vr": "OW", "BinaryLength": 43692}, "131": {"vr": "OW", "BinaryLength": 43692}, "132": {"vr": "OW", "BinaryLength": 43692}, "133": {"vr": "OW", "BinaryLength": 43692}, "134": {"vr": "OW", "BinaryLength": 43692}, "135": {"vr": "OW", "BinaryLength": 43692}, "136": {"vr": "OW", "BinaryLength": 43692}, "137": {"vr": "OW", "BinaryLength": 43692}, "138": {"vr": "OW", "BinaryLength": 43692}, "139": {"vr": "OW", "BinaryLength": 43692}, "140": {"vr": "OW", "BinaryLength": 43692}, "141": {"vr": "OW", "BinaryLength": 43692}, "142": {"vr": "OW", "BinaryLength": 43692}, "143": {"vr": "OW", "BinaryLength": 43692}, "144": {"vr": "OW", "BinaryLength": 43692}, "145": {"vr": "OW", "BinaryLength": 43692}, "146": {"vr": "OW", "BinaryLength": 43692}, "147": {"vr": "OW", "BinaryLength": 43692}, "148": {"vr": "OW", "BinaryLength": 43692}, "149": {"vr": "OW", "BinaryLength": 43692}, "150": {"vr": "OW", "BinaryLength": 43692}, "151": {"vr": "OW", "BinaryLength": 43692}, "152": {"vr": "OW", "BinaryLength": 43692}, "153": {"vr": "OW", "BinaryLength": 43692}, "154": {"vr": "OW", "BinaryLength": 43692}, "155": {"vr": "OW", "BinaryLength": 43692}, "156": {"vr": "OW", "BinaryLength": 43692}, "157": {"vr": "OW", "BinaryLength": 43692}, "158": {"vr": "OW", "BinaryLength": 43692}, "159": {"vr": "OW", "BinaryLength": 43692}, "160": {"vr": "OW", "BinaryLength": 43692}, "161": {"vr": "OW", "BinaryLength": 43692}, "162": {"vr": "OW", "BinaryLength": 43692}, "163": {"vr": "OW", "BinaryLength": 43692}, "164": {"vr": "OW", "BinaryLength": 43692}, "165": {"vr": "OW", "BinaryLength": 43692}, "166": {"vr": "OW", "BinaryLength": 43692}, "167": {"vr": "OW", "BinaryLength": 43692}, "168": {"vr": "OW", "BinaryLength": 43692}, "169": {"vr": "OW", "BinaryLength": 43692}, "170": {"vr": "OW", "BinaryLength": 43692}, "171": {"vr": "OW", "BinaryLength": 43692}, "172": {"vr": "OW", "BinaryLength": 43692}, "173": {"vr": "OW", "BinaryLength": 43692}, "174": {"vr": "OW", "BinaryLength": 43692}, "175": {"vr": "OW", "BinaryLength": 43692}, "176": {"vr": "OW", "BinaryLength": 43692}, "177": {"vr": "OW", "BinaryLength": 43692}, "178": {"vr": "OW", "BinaryLength": 43692}, "179": {"vr": "OW", "BinaryLength": 43692}, "180": {"vr": "OW", "BinaryLength": 43692}, "181": {"vr": "OW", "BinaryLength": 43692}, "182": {"vr": "OW", "BinaryLength": 43692}, "183": {"vr": "OW", "BinaryLength": 43692}, "184": {"vr": "OW", "BinaryLength": 43692}, "185": {"vr": "OW", "BinaryLength": 43692}, "186": {"vr": "OW", "BinaryLength": 43692}, "187": {"vr": "OW", "BinaryLength": 43692}, "188": {"vr": "OW", "BinaryLength": 43692}, "189": {"vr": "OW", "BinaryLength": 43692}, "190": {"vr": "OW", "BinaryLength": 43692}, "191": {"vr": "OW", "BinaryLength": 43692}, "192": {"vr": "OW", "BinaryLength": 43692}, "193": {"vr": "OW", "BinaryLength": 43692}, "194": {"vr": "OW", "BinaryLength": 43692}, "195": {"vr": "OW", "BinaryLength": 43692}, "196": {"vr": "OW", "BinaryLength": 43692}, "197": {"vr": "OW", "BinaryLength": 43692}, "198": {"vr": "OW", "BinaryLength": 43692}, "199": {"vr": "OW", "BinaryLength": 43692}, "200": {"vr": "OW", "BinaryLength": 43692}, "201": {"vr": "OW", "BinaryLength": 43692}, "202": {"vr": "OW", "BinaryLength": 43692}, "203": {"vr": "OW", "BinaryLength": 43692}, "204": {"vr": "OW", "BinaryLength": 43692}, "205": {"vr": "OW", "BinaryLength": 43692}, "206": {"vr": "OW", "BinaryLength": 43692}, "207": {"vr": "OW", "BinaryLength": 43692}, "208": {"vr": "OW", "BinaryLength": 43692}, "209": {"vr": "OW", "BinaryLength": 43692}, "210": {"vr": "OW", "BinaryLength": 43692}, "211": {"vr": "OW", "BinaryLength": 43692}, "212": {"vr": "OW", "BinaryLength": 43692}, "213": {"vr": "OW", "BinaryLength": 43692}, "214": {"vr": "OW", "BinaryLength": 43692}, "215": {"vr": "OW", "BinaryLength": 43692}, "216": {"vr": "OW", "BinaryLength": 43692}, "217": {"vr": "OW", "BinaryLength": 43692}, "218": {"vr": "OW", "BinaryLength": 43692}, "219": {"vr": "OW", "BinaryLength": 43692}, "220": {"vr": "OW", "BinaryLength": 43692}, "221": {"vr": "OW", "BinaryLength": 43692}, "222": {"vr": "OW", "BinaryLength": 43692}, "223": {"vr": "OW", "BinaryLength": 43692}, "224": {"vr": "OW", "BinaryLength": 43692}, "225": {"vr": "OW", "BinaryLength": 43692}, "226": {"vr": "OW", "BinaryLength": 43692}, "227": {"vr": "OW", "BinaryLength": 43692}, "228": {"vr": "OW", "BinaryLength": 43692}, "229": {"vr": "OW", "BinaryLength": 43692}, "230": {"vr": "OW", "BinaryLength": 43692}, "231": {"vr": "OW", "BinaryLength": 43692}, "232": {"vr": "OW", "BinaryLength": 43692}, "233": {"vr": "OW", "BinaryLength": 43692}, "234": {"vr": "OW", "BinaryLength": 43692}, "235": {"vr": "OW", "BinaryLength": 43692}, "236": {"vr": "OW", "BinaryLength": 43692}, "237": {"vr": "OW", "BinaryLength": 43692}, "238": {"vr": "OW", "BinaryLength": 43692}, "239": {"vr": "OW", "BinaryLength": 43692}, "240": {"vr": "OW", "BinaryLength": 43692}, "241": {"vr": "OW", "BinaryLength": 43692}, "242": {"vr": "OW", "BinaryLength": 43692}, "243": {"vr": "OW", "BinaryLength": 43692}, "244": {"vr": "OW", "BinaryLength": 43692}, "245": {"vr": "OW", "BinaryLength": 43692}, "246": {"vr": "OW", "BinaryLength": 43692}, "247": {"vr": "OW", "BinaryLength": 43692}, "248": {"vr": "OW", "BinaryLength": 43692}, "249": {"vr": "OW", "BinaryLength": 43692}, "250": {"vr": "OW", "BinaryLength": 43692}, "251": {"vr": "OW", "BinaryLength": 43692}, "252": {"vr": "OW", "BinaryLength": 43692}, "253": {"vr": "OW", "BinaryLength": 43692}, "254": {"vr": "OW", "BinaryLength": 43692}, "255": {"vr": "OW", "BinaryLength": 43692}, "256": {"vr": "OW", "BinaryLength": 43692}, "257": {"vr": "OW", "BinaryLength": 43692}, "258": {"vr": "OW", "BinaryLength": 43692}, "259": {"vr": "OW", "BinaryLength": 43692}, "260": {"vr": "OW", "BinaryLength": 43692}, "261": {"vr": "OW", "BinaryLength": 43692}, "262": {"vr": "OW", "BinaryLength": 43692}, "263": {"vr": "OW", "BinaryLength": 43692}, "264": {"vr": "OW", "BinaryLength": 43692}, "265": {"vr": "OW", "BinaryLength": 43692}, "266": {"vr": "OW", "BinaryLength": 43692}, "267": {"vr": "OW", "BinaryLength": 43692}, "268": {"vr": "OW", "BinaryLength": 43692}, "269": {"vr": "OW", "BinaryLength": 43692}, "270": {"vr": "OW", "BinaryLength": 43692}, "271": {"vr": "OW", "BinaryLength": 43692}, "272": {"vr": "OW", "BinaryLength": 43692}, "273": {"vr": "OW", "BinaryLength": 43692}, "274": {"vr": "OW", "BinaryLength": 43692}, "275": {"vr": "OW", "BinaryLength": 43692}, "276": {"vr": "OW", "BinaryLength": 43692}, "277": {"vr": "OW", "BinaryLength": 43692}, "278": {"vr": "OW", "BinaryLength": 43692}, "279": {"vr": "OW", "BinaryLength": 43692}, "280": {"vr": "OW", "BinaryLength": 43692}, "281": {"vr": "OW", "BinaryLength": 43692}, "282": {"vr": "OW", "BinaryLength": 43692}, "283": {"vr": "OW", "BinaryLength": 43692}, "284": {"vr": "OW", "BinaryLength": 43692}, "285": {"vr": "OW", "BinaryLength": 43692}, "286": {"vr": "OW", "BinaryLength": 43692}, "287": {"vr": "OW", "BinaryLength": 43692}, "288": {"vr": "OW", "BinaryLength": 43692}, "289": {"vr": "OW", "BinaryLength": 43692}, "290": {"vr": "OW", "BinaryLength": 43692}, "291": {"vr": "OW", "BinaryLength": 43692}, "292": {"vr": "OW", "BinaryLength": 43692}, "293": {"vr": "OW", "BinaryLength": 43692}, "294": {"vr": "OW", "BinaryLength": 43692}, "295": {"vr": "OW", "BinaryLength": 43692}, "296": {"vr": "OW", "BinaryLength": 43692}, "297": {"vr": "OW", "BinaryLength": 43692}, "298": {"vr": "OW", "BinaryLength": 43692}, "299": {"vr": "OW", "BinaryLength": 43692}, "300": {"vr": "OW", "BinaryLength": 43692}, "301": {"vr": "OW", "BinaryLength": 43692}, "302": {"vr": "OW", "BinaryLength": 43692}, "303": {"vr": "OW", "BinaryLength": 43692}, "304": {"vr": "OW", "BinaryLength": 43692}, "305": {"vr": "OW", "BinaryLength": 43692}, "306": {"vr": "OW", "BinaryLength": 43692}, "307": {"vr": "OW", "BinaryLength": 43692}, "308": {"vr": "OW", "BinaryLength": 43692}, "309": {"vr": "OW", "BinaryLength": 43692}, "310": {"vr": "OW", "BinaryLength": 43692}, "311": {"vr": "OW", "BinaryLength": 43692}, "312": {"vr": "OW", "BinaryLength": 43692}, "313": {"vr": "OW", "BinaryLength": 43692}, "314": {"vr": "OW", "BinaryLength": 43692}, "315": {"vr": "OW", "BinaryLength": 43692}, "316": {"vr": "OW", "BinaryLength": 43692}, "317": {"vr": "OW", "BinaryLength": 43692}, "318": {"vr": "OW", "BinaryLength": 43692}, "319": {"vr": "OW", "BinaryLength": 43692}, "320": {"vr": "OW", "BinaryLength": 43692}, "321": {"vr": "OW", "BinaryLength": 43692}, "322": {"vr": "OW", "BinaryLength": 43692}, "323": {"vr": "OW", "BinaryLength": 43692}, "324": {"vr": "OW", "BinaryLength": 43692}, "325": {"vr": "OW", "BinaryLength": 43692}, "326": {"vr": "OW", "BinaryLength": 43692}, "327": {"vr": "OW", "BinaryLength": 43692}, "328": {"vr": "OW", "BinaryLength": 43692}, "329": {"vr": "OW", "BinaryLength": 43692}, "330": {"vr": "OW", "BinaryLength": 43692}, "331": {"vr": "OW", "BinaryLength": 43692}, "332": {"vr": "OW", "BinaryLength": 43692}, "333": {"vr": "OW", "BinaryLength": 43692}, "334": {"vr": "OW", "BinaryLength": 43692}, "335": {"vr": "OW", "BinaryLength": 43692}, "336": {"vr": "OW", "BinaryLength": 43692}, "337": {"vr": "OW", "BinaryLength": 43692}, "338": {"vr": "OW", "BinaryLength": 43692}, "339": {"vr": "OW", "BinaryLength": 43692}, "340": {"vr": "OW", "BinaryLength": 43692}, "341": {"vr": "OW", "BinaryLength": 43692}, "342": {"vr": "OW", "BinaryLength": 43692}, "343": {"vr": "OW", "BinaryLength": 43692}, "344": {"vr": "OW", "BinaryLength": 43692}, "345": {"vr": "OW", "BinaryLength": 43692}, "346": {"vr": "OW", "BinaryLength": 43692}, "347": {"vr": "OW", "BinaryLength": 43692}, "348": {"vr": "OW", "BinaryLength": 43692}, "349": {"vr": "OW", "BinaryLength": 43692}, "350": {"vr": "OW", "BinaryLength": 43692}, "351": {"vr": "OW", "BinaryLength": 43692}, "352": {"vr": "OW", "BinaryLength": 43692}, "353": {"vr": "OW", "BinaryLength": 43692}, "354": {"vr": "OW", "BinaryLength": 43692}, "355": {"vr": "OW", "BinaryLength": 43692}, "356": {"vr": "OW", "BinaryLength": 43692}, "357": {"vr": "OW", "BinaryLength": 43692}, "358": {"vr": "OW", "BinaryLength": 43692}, "359": {"vr": "OW", "BinaryLength": 43692}, "360": {"vr": "OW", "BinaryLength": 43692}, "361": {"vr": "OW", "BinaryLength": 43692}, "362": {"vr": "OW", "BinaryLength": 43692}, "363": {"vr": "OW", "BinaryLength": 43692}, "364": {"vr": "OW", "BinaryLength": 43692}, "365": {"vr": "OW", "BinaryLength": 43692}, "366": {"vr": "OW", "BinaryLength": 43692}, "367": {"vr": "OW", "BinaryLength": 43692}, "368": {"vr": "OW", "BinaryLength": 43692}, "369": {"vr": "OW", "BinaryLength": 43692}, "370": {"vr": "OW", "BinaryLength": 43692}, "371": {"vr": "OW", "BinaryLength": 43692}, "372": {"vr": "OW", "BinaryLength": 43692}, "373": {"vr": "OW", "BinaryLength": 43692}, "374": {"vr": "OW", "BinaryLength": 43692}, "375": {"vr": "OW", "BinaryLength": 43692}, "376": {"vr": "OW", "BinaryLength": 43692}, "377": {"vr": "OW", "BinaryLength": 43692}, "378": {"vr": "OW", "BinaryLength": 43692}, "379": {"vr": "OW", "BinaryLength": 43692}, "380": {"vr": "OW", "BinaryLength": 43692}, "381": {"vr": "OW", "BinaryLength": 43692}, "382": {"vr": "OW", "BinaryLength": 43692}, "383": {"vr": "OW", "BinaryLength": 43692}, "384": {"vr": "OW", "BinaryLength": 43692}, "385": {"vr": "OW", "BinaryLength": 43692}, "386": {"vr": "OW", "BinaryLength": 43692}, "387": {"vr": "OW", "BinaryLength": 43692}, "388": {"vr": "OW", "BinaryLength": 43692}, "389": {"vr": "OW", "BinaryLength": 43692}, "390": {"vr": "OW", "BinaryLength": 43692}, "391": {"vr": "OW", "BinaryLength": 43692}, "392": {"vr": "OW", "BinaryLength": 43692}, "393": {"vr": "OW", "BinaryLength": 43692}, "394": {"vr": "OW", "BinaryLength": 43692}, "395": {"vr": "OW", "BinaryLength": 43692}, "396": {"vr": "OW", "BinaryLength": 43692}, "397": {"vr": "OW", "BinaryLength": 43692}, "398": {"vr": "OW", "BinaryLength": 43692}, "399": {"vr": "OW", "BinaryLength": 43692}, "400": {"vr": "OW", "BinaryLength": 43692}, "401": {"vr": "OW", "BinaryLength": 43692}, "402": {"vr": "OW", "BinaryLength": 43692}, "403": {"vr": "OW", "BinaryLength": 43692}, "404": {"vr": "OW", "BinaryLength": 43692}, "405": {"vr": "OW", "BinaryLength": 43692}, "406": {"vr": "OW", "BinaryLength": 43692}, "407": {"vr": "OW", "BinaryLength": 43692}, "408": {"vr": "OW", "BinaryLength": 43692}, "409": {"vr": "OW", "BinaryLength": 43692}, "410": {"vr": "OW", "BinaryLength": 43692}, "411": {"vr": "OW", "BinaryLength": 43692}, "412": {"vr": "OW", "BinaryLength": 43692}, "413": {"vr": "OW", "BinaryLength": 43692}, "414": {"vr": "OW", "BinaryLength": 43692}, "415": {"vr": "OW", "BinaryLength": 43692}, "416": {"vr": "OW", "BinaryLength": 43692}, "417": {"vr": "OW", "BinaryLength": 43692}, "418": {"vr": "OW", "BinaryLength": 43692}, "419": {"vr": "OW", "BinaryLength": 43692}, "420": {"vr": "OW", "BinaryLength": 43692}, "421": {"vr": "OW", "BinaryLength": 43692}, "422": {"vr": "OW", "BinaryLength": 43692}, "423": {"vr": "OW", "BinaryLength": 43692}, "424": {"vr": "OW", "BinaryLength": 43692}, "425": {"vr": "OW", "BinaryLength": 43692}, "426": {"vr": "OW", "BinaryLength": 43692}, "427": {"vr": "OW", "BinaryLength": 43692}, "428": {"vr": "OW", "BinaryLength": 43692}, "429": {"vr": "OW", "BinaryLength": 43692}, "430": {"vr": "OW", "BinaryLength": 43692}, "431": {"vr": "OW", "BinaryLength": 43692}, "432": {"vr": "OW", "BinaryLength": 43692}, "433": {"vr": "OW", "BinaryLength": 43692}, "434": {"vr": "OW", "BinaryLength": 43692}, "435": {"vr": "OW", "BinaryLength": 43692}, "436": {"vr": "OW", "BinaryLength": 43692}, "437": {"vr": "OW", "BinaryLength": 43692}, "438": {"vr": "OW", "BinaryLength": 43692}, "439": {"vr": "OW", "BinaryLength": 43692}, "440": {"vr": "OW", "BinaryLength": 43692}, "441": {"vr": "OW", "BinaryLength": 43692}, "442": {"vr": "OW", "BinaryLength": 43692}, "443": {"vr": "OW", "BinaryLength": 43692}, "444": {"vr": "OW", "BinaryLength": 43692}, "445": {"vr": "OW", "BinaryLength": 43692}, "446": {"vr": "OW", "BinaryLength": 43692}, "447": {"vr": "OW", "BinaryLength": 43692}, "448": {"vr": "OW", "BinaryLength": 43692}, "449": {"vr": "OW", "BinaryLength": 43692}, "450": {"vr": "OW", "BinaryLength": 43692}, "451": {"vr": "OW", "BinaryLength": 43692}, "452": {"vr": "OW", "BinaryLength": 43692}, "453": {"vr": "OW", "BinaryLength": 43692}, "454": {"vr": "OW", "BinaryLength": 43692}, "455": {"vr": "OW", "BinaryLength": 43692}, "456": {"vr": "OW", "BinaryLength": 43692}, "457": {"vr": "OW", "BinaryLength": 43692}, "458": {"vr": "OW", "BinaryLength": 43692}, "459": {"vr": "OW", "BinaryLength": 43692}, "460": {"vr": "OW", "BinaryLength": 43692}, "461": {"vr": "OW", "BinaryLength": 43692}, "462": {"vr": "OW", "BinaryLength": 43692}, "463": {"vr": "OW", "BinaryLength": 43692}, "464": {"vr": "OW", "BinaryLength": 43692}, "465": {"vr": "OW", "BinaryLength": 43692}, "466": {"vr": "OW", "BinaryLength": 43692}, "467": {"vr": "OW", "BinaryLength": 43692}, "468": {"vr": "OW", "BinaryLength": 43692}, "469": {"vr": "OW", "BinaryLength": 43692}, "470": {"vr": "OW", "BinaryLength": 43692}, "471": {"vr": "OW", "BinaryLength": 43692}, "472": {"vr": "OW", "BinaryLength": 43692}, "473": {"vr": "OW", "BinaryLength": 43692}, "474": {"vr": "OW", "BinaryLength": 43692}, "475": {"vr": "OW", "BinaryLength": 43692}, "476": {"vr": "OW", "BinaryLength": 43692}, "477": {"vr": "OW", "BinaryLength": 43692}, "478": {"vr": "OW", "BinaryLength": 43692}, "479": {"vr": "OW", "BinaryLength": 43692}, "480": {"vr": "OW", "BinaryLength": 43692}, "481": {"vr": "OW", "BinaryLength": 43692}, "482": {"vr": "OW", "BinaryLength": 43692}, "483": {"vr": "OW", "BinaryLength": 43692}, "484": {"vr": "OW", "BinaryLength": 43692}, "485": {"vr": "OW", "BinaryLength": 43692}, "486": {"vr": "OW", "BinaryLength": 43692}, "487": {"vr": "OW", "BinaryLength": 43692}, "488": {"vr": "OW", "BinaryLength": 43692}, "489": {"vr": "OW", "BinaryLength": 43692}, "490": {"vr": "OW", "BinaryLength": 43692}, "491": {"vr": "OW", "BinaryLength": 43692}, "492": {"vr": "OW", "BinaryLength": 43692}, "493": {"vr": "OW", "BinaryLength": 43692}, "494": {"vr": "OW", "BinaryLength": 43692}, "495": {"vr": "OW", "BinaryLength": 43692}, "496": {"vr": "OW", "BinaryLength": 43692}, "497": {"vr": "OW", "BinaryLength": 43692}, "498": {"vr": "OW", "BinaryLength": 43692}, "499": {"vr": "OW", "BinaryLength": 43692}, "500": {"vr": "OW", "BinaryLength": 43692}, "501": {"vr": "OW", "BinaryLength": 43692}, "502": {"vr": "OW", "BinaryLength": 43692}, "503": {"vr": "OW", "BinaryLength": 43692}, "504": {"vr": "OW", "BinaryLength": 43692}, "505": {"vr": "OW", "BinaryLength": 43692}, "506": {"vr": "OW", "BinaryLength": 43692}, "507": {"vr": "OW", "BinaryLength": 43692}, "508": {"vr": "OW", "BinaryLength": 43692}, "509": {"vr": "OW", "BinaryLength": 43692}, "510": {"vr": "OW", "BinaryLength": 43692}, "511": {"vr": "OW", "BinaryLength": 43692}, "512": {"vr": "OW", "BinaryLength": 43692}, "513": {"vr": "OW", "BinaryLength": 43692}, "514": {"vr": "OW", "BinaryLength": 43692}, "515": {"vr": "OW", "BinaryLength": 43692}, "516": {"vr": "OW", "BinaryLength": 43692}, "517": {"vr": "OW", "BinaryLength": 43692}, "518": {"vr": "OW", "BinaryLength": 43692}, "519": {"vr": "OW", "BinaryLength": 43692}, "520": {"vr": "OW", "BinaryLength": 43692}, "521": {"vr": "OW", "BinaryLength": 43692}, "522": {"vr": "OW", "BinaryLength": 43692}, "523": {"vr": "OW", "BinaryLength": 43692}, "524": {"vr": "OW", "BinaryLength": 43692}, "525": {"vr": "OW", "BinaryLength": 43692}, "526": {"vr": "OW", "BinaryLength": 43692}, "527": {"vr": "OW", "BinaryLength": 43692}, "528": {"vr": "OW", "BinaryLength": 43692}, "529": {"vr": "OW", "BinaryLength": 43692}, "530": {"vr": "OW", "BinaryLength": 43692}}, "7FE00010": {"0": {"vr": "OW", "BinaryLength": 699052}, "1": {"vr": "OW", "BinaryLength": 699052}, "2": {"vr": "OW", "BinaryLength": 699052}, "3": {"vr": "OW", "BinaryLength": 699052}, "4": {"vr": "OW", "BinaryLength": 699052}, "5": {"vr": "OW", "BinaryLength": 699052}, "6": {"vr": "OW", "BinaryLength": 699052}, "7": {"vr": "OW", "BinaryLength": 699052}, "8": {"vr": "OW", "BinaryLength": 699052}, "9": {"vr": "OW", "BinaryLength": 699052}, "10": {"vr": "OW", "BinaryLength": 699052}, "11": {"vr": "OW", "BinaryLength": 699052}, "12": {"vr": "OW", "BinaryLength": 699052}, "13": {"vr": "OW", "BinaryLength": 699052}, "14": {"vr": "OW", "BinaryLength": 699052}, "15": {"vr": "OW", "BinaryLength": 699052}, "16": {"vr": "OW", "BinaryLength": 699052}, "17": {"vr": "OW", "BinaryLength": 699052}, "18": {"vr": "OW", "BinaryLength": 699052}, "19": {"vr": "OW", "BinaryLength": 699052}, "20": {"vr": "OW", "BinaryLength": 699052}, "21": {"vr": "OW", "BinaryLength": 699052}, "22": {"vr": "OW", "BinaryLength": 699052}, "23": {"vr": "OW", "BinaryLength": 699052}, "24": {"vr": "OW", "BinaryLength": 699052}, "25": {"vr": "OW", "BinaryLength": 699052}, "26": {"vr": "OW", "BinaryLength": 699052}, "27": {"vr": "OW", "BinaryLength": 699052}, "28": {"vr": "OW", "BinaryLength": 699052}, "29": {"vr": "OW", "BinaryLength": 699052}, "30": {"vr": "OW", "BinaryLength": 699052}, "31": {"vr": "OW", "BinaryLength": 699052}, "32": {"vr": "OW", "BinaryLength": 699052}, "33": {"vr": "OW", "BinaryLength": 699052}, "34": {"vr": "OW", "BinaryLength": 699052}, "35": {"vr": "OW", "BinaryLength": 699052}, "36": {"vr": "OW", "BinaryLength": 699052}, "37": {"vr": "OW", "BinaryLength": 699052}, "38": {"vr": "OW", "BinaryLength": 699052}, "39": {"vr": "OW", "BinaryLength": 699052}, "40": {"vr": "OW", "BinaryLength": 699052}, "41": {"vr": "OW", "BinaryLength": 699052}, "42": {"vr": "OW", "BinaryLength": 699052}, "43": {"vr": "OW", "BinaryLength": 699052}, "44": {"vr": "OW", "BinaryLength": 699052}, "45": {"vr": "OW", "BinaryLength": 699052}, "46": {"vr": "OW", "BinaryLength": 699052}, "47": {"vr": "OW", "BinaryLength": 699052}, "48": {"vr": "OW", "BinaryLength": 699052}, "49": {"vr": "OW", "BinaryLength": 699052}, "50": {"vr": "OW", "BinaryLength": 699052}, "51": {"vr": "OW", "BinaryLength": 699052}, "52": {"vr": "OW", "BinaryLength": 699052}, "53": {"vr": "OW", "BinaryLength": 699052}, "54": {"vr": "OW", "BinaryLength": 699052}, "55": {"vr": "OW", "BinaryLength": 699052}, "56": {"vr": "OW", "BinaryLength": 699052}, "57": {"vr": "OW", "BinaryLength": 699052}, "58": {"vr": "OW", "BinaryLength": 699052}, "59": {"vr": "OW", "BinaryLength": 699052}, "60": {"vr": "OW", "BinaryLength": 699052}, "61": {"vr": "OW", "BinaryLength": 699052}, "62": {"vr": "OW", "BinaryLength": 699052}, "63": {"vr": "OW", "BinaryLength": 699052}, "64": {"vr": "OW", "BinaryLength": 699052}, "65": {"vr": "OW", "BinaryLength": 699052}, "66": {"vr": "OW", "BinaryLength": 699052}, "67": {"vr": "OW", "BinaryLength": 699052}, "68": {"vr": "OW", "BinaryLength": 699052}, "69": {"vr": "OW", "BinaryLength": 699052}, "70": {"vr": "OW", "BinaryLength": 699052}, "71": {"vr": "OW", "BinaryLength": 699052}, "72": {"vr": "OW", "BinaryLength": 699052}, "73": {"vr": "OW", "BinaryLength": 699052}, "74": {"vr": "OW", "BinaryLength": 699052}, "75": {"vr": "OW", "BinaryLength": 699052}, "76": {"vr": "OW", "BinaryLength": 699052}, "77": {"vr": "OW", "BinaryLength": 699052}, "78": {"vr": "OW", "BinaryLength": 699052}, "79": {"vr": "OW", "BinaryLength": 699052}, "80": {"vr": "OW", "BinaryLength": 699052}, "81": {"vr": "OW", "BinaryLength": 699052}, "82": {"vr": "OW", "BinaryLength": 699052}, "83": {"vr": "OW", "BinaryLength": 699052}, "84": {"vr": "OW", "BinaryLength": 699052}, "85": {"vr": "OW", "BinaryLength": 699052}, "86": {"vr": "OW", "BinaryLength": 699052}, "87": {"vr": "OW", "BinaryLength": 699052}, "88": {"vr": "OW", "BinaryLength": 699052}, "89": {"vr": "OW", "BinaryLength": 699052}, "90": {"vr": "OW", "BinaryLength": 699052}, "91": {"vr": "OW", "BinaryLength": 699052}, "92": {"vr": "OW", "BinaryLength": 699052}, "93": {"vr": "OW", "BinaryLength": 699052}, "94": {"vr": "OW", "BinaryLength": 699052}, "95": {"vr": "OW", "BinaryLength": 699052}, "96": {"vr": "OW", "BinaryLength": 699052}, "97": {"vr": "OW", "BinaryLength": 699052}, "98": {"vr": "OW", "BinaryLength": 699052}, "99": {"vr": "OW", "BinaryLength": 699052}, "100": {"vr": "OW", "BinaryLength": 699052}, "101": {"vr": "OW", "BinaryLength": 699052}, "102": {"vr": "OW", "BinaryLength": 699052}, "103": {"vr": "OW", "BinaryLength": 699052}, "104": {"vr": "OW", "BinaryLength": 699052}, "105": {"vr": "OW", "BinaryLength": 699052}, "106": {"vr": "OW", "BinaryLength": 699052}, "107": {"vr": "OW", "BinaryLength": 699052}, "108": {"vr": "OW", "BinaryLength": 699052}, "109": {"vr": "OW", "BinaryLength": 699052}, "110": {"vr": "OW", "BinaryLength": 699052}, "111": {"vr": "OW", "BinaryLength": 699052}, "112": {"vr": "OW", "BinaryLength": 699052}, "113": {"vr": "OW", "BinaryLength": 699052}, "114": {"vr": "OW", "BinaryLength": 699052}, "115": {"vr": "OW", "BinaryLength": 699052}, "116": {"vr": "OW", "BinaryLength": 699052}, "117": {"vr": "OW", "BinaryLength": 699052}, "118": {"vr": "OW", "BinaryLength": 699052}, "119": {"vr": "OW", "BinaryLength": 699052}, "120": {"vr": "OW", "BinaryLength": 699052}, "121": {"vr": "OW", "BinaryLength": 699052}, "122": {"vr": "OW", "BinaryLength": 699052}, "123": {"vr": "OW", "BinaryLength": 699052}, "124": {"vr": "OW", "BinaryLength": 699052}, "125": {"vr": "OW", "BinaryLength": 699052}, "126": {"vr": "OW", "BinaryLength": 699052}, "127": {"vr": "OW", "BinaryLength": 699052}, "128": {"vr": "OW", "BinaryLength": 699052}, "129": {"vr": "OW", "BinaryLength": 699052}, "130": {"vr": "OW", "BinaryLength": 699052}, "131": {"vr": "OW", "BinaryLength": 699052}, "132": {"vr": "OW", "BinaryLength": 699052}, "133": {"vr": "OW", "BinaryLength": 699052}, "134": {"vr": "OW", "BinaryLength": 699052}, "135": {"vr": "OW", "BinaryLength": 699052}, "136": {"vr": "OW", "BinaryLength": 699052}, "137": {"vr": "OW", "BinaryLength": 699052}, "138": {"vr": "OW", "BinaryLength": 699052}, "139": {"vr": "OW", "BinaryLength": 699052}, "140": {"vr": "OW", "BinaryLength": 699052}, "141": {"vr": "OW", "BinaryLength": 699052}, "142": {"vr": "OW", "BinaryLength": 699052}, "143": {"vr": "OW", "BinaryLength": 699052}, "144": {"vr": "OW", "BinaryLength": 699052}, "145": {"vr": "OW", "BinaryLength": 699052}, "146": {"vr": "OW", "BinaryLength": 699052}, "147": {"vr": "OW", "BinaryLength": 699052}, "148": {"vr": "OW", "BinaryLength": 699052}, "149": {"vr": "OW", "BinaryLength": 699052}, "150": {"vr": "OW", "BinaryLength": 699052}, "151": {"vr": "OW", "BinaryLength": 699052}, "152": {"vr": "OW", "BinaryLength": 699052}, "153": {"vr": "OW", "BinaryLength": 699052}, "154": {"vr": "OW", "BinaryLength": 699052}, "155": {"vr": "OW", "BinaryLength": 699052}, "156": {"vr": "OW", "BinaryLength": 699052}, "157": {"vr": "OW", "BinaryLength": 699052}, "158": {"vr": "OW", "BinaryLength": 699052}, "159": {"vr": "OW", "BinaryLength": 699052}, "160": {"vr": "OW", "BinaryLength": 699052}, "161": {"vr": "OW", "BinaryLength": 699052}, "162": {"vr": "OW", "BinaryLength": 699052}, "163": {"vr": "OW", "BinaryLength": 699052}, "164": {"vr": "OW", "BinaryLength": 699052}, "165": {"vr": "OW", "BinaryLength": 699052}, "166": {"vr": "OW", "BinaryLength": 699052}, "167": {"vr": "OW", "BinaryLength": 699052}, "168": {"vr": "OW", "BinaryLength": 699052}, "169": {"vr": "OW", "BinaryLength": 699052}, "170": {"vr": "OW", "BinaryLength": 699052}, "171": {"vr": "OW", "BinaryLength": 699052}, "172": {"vr": "OW", "BinaryLength": 699052}, "173": {"vr": "OW", "BinaryLength": 699052}, "174": {"vr": "OW", "BinaryLength": 699052}, "175": {"vr": "OW", "BinaryLength": 699052}, "176": {"vr": "OW", "BinaryLength": 699052}, "177": {"vr": "OW", "BinaryLength": 699052}, "178": {"vr": "OW", "BinaryLength": 699052}, "179": {"vr": "OW", "BinaryLength": 699052}, "180": {"vr": "OW", "BinaryLength": 699052}, "181": {"vr": "OW", "BinaryLength": 699052}, "182": {"vr": "OW", "BinaryLength": 699052}, "183": {"vr": "OW", "BinaryLength": 699052}, "184": {"vr": "OW", "BinaryLength": 699052}, "185": {"vr": "OW", "BinaryLength": 699052}, "186": {"vr": "OW", "BinaryLength": 699052}, "187": {"vr": "OW", "BinaryLength": 699052}, "188": {"vr": "OW", "BinaryLength": 699052}, "189": {"vr": "OW", "BinaryLength": 699052}, "190": {"vr": "OW", "BinaryLength": 699052}, "191": {"vr": "OW", "BinaryLength": 699052}, "192": {"vr": "OW", "BinaryLength": 699052}, "193": {"vr": "OW", "BinaryLength": 699052}, "194": {"vr": "OW", "BinaryLength": 699052}, "195": {"vr": "OW", "BinaryLength": 699052}, "196": {"vr": "OW", "BinaryLength": 699052}, "197": {"vr": "OW", "BinaryLength": 699052}, "198": {"vr": "OW", "BinaryLength": 699052}, "199": {"vr": "OW", "BinaryLength": 699052}, "200": {"vr": "OW", "BinaryLength": 699052}, "201": {"vr": "OW", "BinaryLength": 699052}, "202": {"vr": "OW", "BinaryLength": 699052}, "203": {"vr": "OW", "BinaryLength": 699052}, "204": {"vr": "OW", "BinaryLength": 699052}, "205": {"vr": "OW", "BinaryLength": 699052}, "206": {"vr": "OW", "BinaryLength": 699052}, "207": {"vr": "OW", "BinaryLength": 699052}, "208": {"vr": "OW", "BinaryLength": 699052}, "209": {"vr": "OW", "BinaryLength": 699052}, "210": {"vr": "OW", "BinaryLength": 699052}, "211": {"vr": "OW", "BinaryLength": 699052}, "212": {"vr": "OW", "BinaryLength": 699052}, "213": {"vr": "OW", "BinaryLength": 699052}, "214": {"vr": "OW", "BinaryLength": 699052}, "215": {"vr": "OW", "BinaryLength": 699052}, "216": {"vr": "OW", "BinaryLength": 699052}, "217": {"vr": "OW", "BinaryLength": 699052}, "218": {"vr": "OW", "BinaryLength": 699052}, "219": {"vr": "OW", "BinaryLength": 699052}, "220": {"vr": "OW", "BinaryLength": 699052}, "221": {"vr": "OW", "BinaryLength": 699052}, "222": {"vr": "OW", "BinaryLength": 699052}, "223": {"vr": "OW", "BinaryLength": 699052}, "224": {"vr": "OW", "BinaryLength": 699052}, "225": {"vr": "OW", "BinaryLength": 699052}, "226": {"vr": "OW", "BinaryLength": 699052}, "227": {"vr": "OW", "BinaryLength": 699052}, "228": {"vr": "OW", "BinaryLength": 699052}, "229": {"vr": "OW", "BinaryLength": 699052}, "230": {"vr": "OW", "BinaryLength": 699052}, "231": {"vr": "OW", "BinaryLength": 699052}, "232": {"vr": "OW", "BinaryLength": 699052}, "233": {"vr": "OW", "BinaryLength": 699052}, "234": {"vr": "OW", "BinaryLength": 699052}, "235": {"vr": "OW", "BinaryLength": 699052}, "236": {"vr": "OW", "BinaryLength": 699052}, "237": {"vr": "OW", "BinaryLength": 699052}, "238": {"vr": "OW", "BinaryLength": 699052}, "239": {"vr": "OW", "BinaryLength": 699052}, "240": {"vr": "OW", "BinaryLength": 699052}, "241": {"vr": "OW", "BinaryLength": 699052}, "242": {"vr": "OW", "BinaryLength": 699052}, "243": {"vr": "OW", "BinaryLength": 699052}, "244": {"vr": "OW", "BinaryLength": 699052}, "245": {"vr": "OW", "BinaryLength": 699052}, "246": {"vr": "OW", "BinaryLength": 699052}, "247": {"vr": "OW", "BinaryLength": 699052}, "248": {"vr": "OW", "BinaryLength": 699052}, "249": {"vr": "OW", "BinaryLength": 699052}, "250": {"vr": "OW", "BinaryLength": 699052}, "251": {"vr": "OW", "BinaryLength": 699052}, "252": {"vr": "OW", "BinaryLength": 699052}, "253": {"vr": "OW", "BinaryLength": 699052}, "254": {"vr": "OW", "BinaryLength": 699052}, "255": {"vr": "OW", "BinaryLength": 699052}, "256": {"vr": "OW", "BinaryLength": 699052}, "257": {"vr": "OW", "BinaryLength": 699052}, "258": {"vr": "OW", "BinaryLength": 699052}, "259": {"vr": "OW", "BinaryLength": 699052}, "260": {"vr": "OW", "BinaryLength": 699052}, "261": {"vr": "OW", "BinaryLength": 699052}, "262": {"vr": "OW", "BinaryLength": 699052}, "263": {"vr": "OW", "BinaryLength": 699052}, "264": {"vr": "OW", "BinaryLength": 699052}, "265": {"vr": "OW", "BinaryLength": 699052}, "266": {"vr": "OW", "BinaryLength": 699052}, "267": {"vr": "OW", "BinaryLength": 699052}, "268": {"vr": "OW", "BinaryLength": 699052}, "269": {"vr": "OW", "BinaryLength": 699052}, "270": {"vr": "OW", "BinaryLength": 699052}, "271": {"vr": "OW", "BinaryLength": 699052}, "272": {"vr": "OW", "BinaryLength": 699052}, "273": {"vr": "OW", "BinaryLength": 699052}, "274": {"vr": "OW", "BinaryLength": 699052}, "275": {"vr": "OW", "BinaryLength": 699052}, "276": {"vr": "OW", "BinaryLength": 699052}, "277": {"vr": "OW", "BinaryLength": 699052}, "278": {"vr": "OW", "BinaryLength": 699052}, "279": {"vr": "OW", "BinaryLength": 699052}, "280": {"vr": "OW", "BinaryLength": 699052}, "281": {"vr": "OW", "BinaryLength": 699052}, "282": {"vr": "OW", "BinaryLength": 699052}, "283": {"vr": "OW", "BinaryLength": 699052}, "284": {"vr": "OW", "BinaryLength": 699052}, "285": {"vr": "OW", "BinaryLength": 699052}, "286": {"vr": "OW", "BinaryLength": 699052}, "287": {"vr": "OW", "BinaryLength": 699052}, "288": {"vr": "OW", "BinaryLength": 699052}, "289": {"vr": "OW", "BinaryLength": 699052}, "290": {"vr": "OW", "BinaryLength": 699052}, "291": {"vr": "OW", "BinaryLength": 699052}, "292": {"vr": "OW", "BinaryLength": 699052}, "293": {"vr": "OW", "BinaryLength": 699052}, "294": {"vr": "OW", "BinaryLength": 699052}, "295": {"vr": "OW", "BinaryLength": 699052}, "296": {"vr": "OW", "BinaryLength": 699052}, "297": {"vr": "OW", "BinaryLength": 699052}, "298": {"vr": "OW", "BinaryLength": 699052}, "299": {"vr": "OW", "BinaryLength": 699052}, "300": {"vr": "OW", "BinaryLength": 699052}, "301": {"vr": "OW", "BinaryLength": 699052}, "302": {"vr": "OW", "BinaryLength": 699052}, "303": {"vr": "OW", "BinaryLength": 699052}, "304": {"vr": "OW", "BinaryLength": 699052}, "305": {"vr": "OW", "BinaryLength": 699052}, "306": {"vr": "OW", "BinaryLength": 699052}, "307": {"vr": "OW", "BinaryLength": 699052}, "308": {"vr": "OW", "BinaryLength": 699052}, "309": {"vr": "OW", "BinaryLength": 699052}, "310": {"vr": "OW", "BinaryLength": 699052}, "311": {"vr": "OW", "BinaryLength": 699052}, "312": {"vr": "OW", "BinaryLength": 699052}, "313": {"vr": "OW", "BinaryLength": 699052}, "314": {"vr": "OW", "BinaryLength": 699052}, "315": {"vr": "OW", "BinaryLength": 699052}, "316": {"vr": "OW", "BinaryLength": 699052}, "317": {"vr": "OW", "BinaryLength": 699052}, "318": {"vr": "OW", "BinaryLength": 699052}, "319": {"vr": "OW", "BinaryLength": 699052}, "320": {"vr": "OW", "BinaryLength": 699052}, "321": {"vr": "OW", "BinaryLength": 699052}, "322": {"vr": "OW", "BinaryLength": 699052}, "323": {"vr": "OW", "BinaryLength": 699052}, "324": {"vr": "OW", "BinaryLength": 699052}, "325": {"vr": "OW", "BinaryLength": 699052}, "326": {"vr": "OW", "BinaryLength": 699052}, "327": {"vr": "OW", "BinaryLength": 699052}, "328": {"vr": "OW", "BinaryLength": 699052}, "329": {"vr": "OW", "BinaryLength": 699052}, "330": {"vr": "OW", "BinaryLength": 699052}, "331": {"vr": "OW", "BinaryLength": 699052}, "332": {"vr": "OW", "BinaryLength": 699052}, "333": {"vr": "OW", "BinaryLength": 699052}, "334": {"vr": "OW", "BinaryLength": 699052}, "335": {"vr": "OW", "BinaryLength": 699052}, "336": {"vr": "OW", "BinaryLength": 699052}, "337": {"vr": "OW", "BinaryLength": 699052}, "338": {"vr": "OW", "BinaryLength": 699052}, "339": {"vr": "OW", "BinaryLength": 699052}, "340": {"vr": "OW", "BinaryLength": 699052}, "341": {"vr": "OW", "BinaryLength": 699052}, "342": {"vr": "OW", "BinaryLength": 699052}, "343": {"vr": "OW", "BinaryLength": 699052}, "344": {"vr": "OW", "BinaryLength": 699052}, "345": {"vr": "OW", "BinaryLength": 699052}, "346": {"vr": "OW", "BinaryLength": 699052}, "347": {"vr": "OW", "BinaryLength": 699052}, "348": {"vr": "OW", "BinaryLength": 699052}, "349": {"vr": "OW", "BinaryLength": 699052}, "350": {"vr": "OW", "BinaryLength": 699052}, "351": {"vr": "OW", "BinaryLength": 699052}, "352": {"vr": "OW", "BinaryLength": 699052}, "353": {"vr": "OW", "BinaryLength": 699052}, "354": {"vr": "OW", "BinaryLength": 699052}, "355": {"vr": "OW", "BinaryLength": 699052}, "356": {"vr": "OW", "BinaryLength": 699052}, "357": {"vr": "OW", "BinaryLength": 699052}, "358": {"vr": "OW", "BinaryLength": 699052}, "359": {"vr": "OW", "BinaryLength": 699052}, "360": {"vr": "OW", "BinaryLength": 699052}, "361": {"vr": "OW", "BinaryLength": 699052}, "362": {"vr": "OW", "BinaryLength": 699052}, "363": {"vr": "OW", "BinaryLength": 699052}, "364": {"vr": "OW", "BinaryLength": 699052}, "365": {"vr": "OW", "BinaryLength": 699052}, "366": {"vr": "OW", "BinaryLength": 699052}, "367": {"vr": "OW", "BinaryLength": 699052}, "368": {"vr": "OW", "BinaryLength": 699052}, "369": {"vr": "OW", "BinaryLength": 699052}, "370": {"vr": "OW", "BinaryLength": 699052}, "371": {"vr": "OW", "BinaryLength": 699052}, "372": {"vr": "OW", "BinaryLength": 699052}, "373": {"vr": "OW", "BinaryLength": 699052}, "374": {"vr": "OW", "BinaryLength": 699052}, "375": {"vr": "OW", "BinaryLength": 699052}, "376": {"vr": "OW", "BinaryLength": 699052}, "377": {"vr": "OW", "BinaryLength": 699052}, "378": {"vr": "OW", "BinaryLength": 699052}, "379": {"vr": "OW", "BinaryLength": 699052}, "380": {"vr": "OW", "BinaryLength": 699052}, "381": {"vr": "OW", "BinaryLength": 699052}, "382": {"vr": "OW", "BinaryLength": 699052}, "383": {"vr": "OW", "BinaryLength": 699052}, "384": {"vr": "OW", "BinaryLength": 699052}, "385": {"vr": "OW", "BinaryLength": 699052}, "386": {"vr": "OW", "BinaryLength": 699052}, "387": {"vr": "OW", "BinaryLength": 699052}, "388": {"vr": "OW", "BinaryLength": 699052}, "389": {"vr": "OW", "BinaryLength": 699052}, "390": {"vr": "OW", "BinaryLength": 699052}, "391": {"vr": "OW", "BinaryLength": 699052}, "392": {"vr": "OW", "BinaryLength": 699052}, "393": {"vr": "OW", "BinaryLength": 699052}, "394": {"vr": "OW", "BinaryLength": 699052}, "395": {"vr": "OW", "BinaryLength": 699052}, "396": {"vr": "OW", "BinaryLength": 699052}, "397": {"vr": "OW", "BinaryLength": 699052}, "398": {"vr": "OW", "BinaryLength": 699052}, "399": {"vr": "OW", "BinaryLength": 699052}, "400": {"vr": "OW", "BinaryLength": 699052}, "401": {"vr": "OW", "BinaryLength": 699052}, "402": {"vr": "OW", "BinaryLength": 699052}, "403": {"vr": "OW", "BinaryLength": 699052}, "404": {"vr": "OW", "BinaryLength": 699052}, "405": {"vr": "OW", "BinaryLength": 699052}, "406": {"vr": "OW", "BinaryLength": 699052}, "407": {"vr": "OW", "BinaryLength": 699052}, "408": {"vr": "OW", "BinaryLength": 699052}, "409": {"vr": "OW", "BinaryLength": 699052}, "410": {"vr": "OW", "BinaryLength": 699052}, "411": {"vr": "OW", "BinaryLength": 699052}, "412": {"vr": "OW", "BinaryLength": 699052}, "413": {"vr": "OW", "BinaryLength": 699052}, "414": {"vr": "OW", "BinaryLength": 699052}, "415": {"vr": "OW", "BinaryLength": 699052}, "416": {"vr": "OW", "BinaryLength": 699052}, "417": {"vr": "OW", "BinaryLength": 699052}, "418": {"vr": "OW", "BinaryLength": 699052}, "419": {"vr": "OW", "BinaryLength": 699052}, "420": {"vr": "OW", "BinaryLength": 699052}, "421": {"vr": "OW", "BinaryLength": 699052}, "422": {"vr": "OW", "BinaryLength": 699052}, "423": {"vr": "OW", "BinaryLength": 699052}, "424": {"vr": "OW", "BinaryLength": 699052}, "425": {"vr": "OW", "BinaryLength": 699052}, "426": {"vr": "OW", "BinaryLength": 699052}, "427": {"vr": "OW", "BinaryLength": 699052}, "428": {"vr": "OW", "BinaryLength": 699052}, "429": {"vr": "OW", "BinaryLength": 699052}, "430": {"vr": "OW", "BinaryLength": 699052}, "431": {"vr": "OW", "BinaryLength": 699052}, "432": {"vr": "OW", "BinaryLength": 699052}, "433": {"vr": "OW", "BinaryLength": 699052}, "434": {"vr": "OW", "BinaryLength": 699052}, "435": {"vr": "OW", "BinaryLength": 699052}, "436": {"vr": "OW", "BinaryLength": 699052}, "437": {"vr": "OW", "BinaryLength": 699052}, "438": {"vr": "OW", "BinaryLength": 699052}, "439": {"vr": "OW", "BinaryLength": 699052}, "440": {"vr": "OW", "BinaryLength": 699052}, "441": {"vr": "OW", "BinaryLength": 699052}, "442": {"vr": "OW", "BinaryLength": 699052}, "443": {"vr": "OW", "BinaryLength": 699052}, "444": {"vr": "OW", "BinaryLength": 699052}, "445": {"vr": "OW", "BinaryLength": 699052}, "446": {"vr": "OW", "BinaryLength": 699052}, "447": {"vr": "OW", "BinaryLength": 699052}, "448": {"vr": "OW", "BinaryLength": 699052}, "449": {"vr": "OW", "BinaryLength": 699052}, "450": {"vr": "OW", "BinaryLength": 699052}, "451": {"vr": "OW", "BinaryLength": 699052}, "452": {"vr": "OW", "BinaryLength": 699052}, "453": {"vr": "OW", "BinaryLength": 699052}, "454": {"vr": "OW", "BinaryLength": 699052}, "455": {"vr": "OW", "BinaryLength": 699052}, "456": {"vr": "OW", "BinaryLength": 699052}, "457": {"vr": "OW", "BinaryLength": 699052}, "458": {"vr": "OW", "BinaryLength": 699052}, "459": {"vr": "OW", "BinaryLength": 699052}, "460": {"vr": "OW", "BinaryLength": 699052}, "461": {"vr": "OW", "BinaryLength": 699052}, "462": {"vr": "OW", "BinaryLength": 699052}, "463": {"vr": "OW", "BinaryLength": 699052}, "464": {"vr": "OW", "BinaryLength": 699052}, "465": {"vr": "OW", "BinaryLength": 699052}, "466": {"vr": "OW", "BinaryLength": 699052}, "467": {"vr": "OW", "BinaryLength": 699052}, "468": {"vr": "OW", "BinaryLength": 699052}, "469": {"vr": "OW", "BinaryLength": 699052}, "470": {"vr": "OW", "BinaryLength": 699052}, "471": {"vr": "OW", "BinaryLength": 699052}, "472": {"vr": "OW", "BinaryLength": 699052}, "473": {"vr": "OW", "BinaryLength": 699052}, "474": {"vr": "OW", "BinaryLength": 699052}, "475": {"vr": "OW", "BinaryLength": 699052}, "476": {"vr": "OW", "BinaryLength": 699052}, "477": {"vr": "OW", "BinaryLength": 699052}, "478": {"vr": "OW", "BinaryLength": 699052}, "479": {"vr": "OW", "BinaryLength": 699052}, "480": {"vr": "OW", "BinaryLength": 699052}, "481": {"vr": "OW", "BinaryLength": 699052}, "482": {"vr": "OW", "BinaryLength": 699052}, "483": {"vr": "OW", "BinaryLength": 699052}, "484": {"vr": "OW", "BinaryLength": 699052}, "485": {"vr": "OW", "BinaryLength": 699052}, "486": {"vr": "OW", "BinaryLength": 699052}, "487": {"vr": "OW", "BinaryLength": 699052}, "488": {"vr": "OW", "BinaryLength": 699052}, "489": {"vr": "OW", "BinaryLength": 699052}, "490": {"vr": "OW", "BinaryLength": 699052}, "491": {"vr": "OW", "BinaryLength": 699052}, "492": {"vr": "OW", "BinaryLength": 699052}, "493": {"vr": "OW", "BinaryLength": 699052}, "494": {"vr": "OW", "BinaryLength": 699052}, "495": {"vr": "OW", "BinaryLength": 699052}, "496": {"vr": "OW", "BinaryLength": 699052}, "497": {"vr": "OW", "BinaryLength": 699052}, "498": {"vr": "OW", "BinaryLength": 699052}, "499": {"vr": "OW", "BinaryLength": 699052}, "500": {"vr": "OW", "BinaryLength": 699052}, "501": {"vr": "OW", "BinaryLength": 699052}, "502": {"vr": "OW", "BinaryLength": 699052}, "503": {"vr": "OW", "BinaryLength": 699052}, "504": {"vr": "OW", "BinaryLength": 699052}, "505": {"vr": "OW", "BinaryLength": 699052}, "506": {"vr": "OW", "BinaryLength": 699052}, "507": {"vr": "OW", "BinaryLength": 699052}, "508": {"vr": "OW", "BinaryLength": 699052}, "509": {"vr": "OW", "BinaryLength": 699052}, "510": {"vr": "OW", "BinaryLength": 699052}, "511": {"vr": "OW", "BinaryLength": 699052}, "512": {"vr": "OW", "BinaryLength": 699052}, "513": {"vr": "OW", "BinaryLength": 699052}, "514": {"vr": "OW", "BinaryLength": 699052}, "515": {"vr": "OW", "BinaryLength": 699052}, "516": {"vr": "OW", "BinaryLength": 699052}, "517": {"vr": "OW", "BinaryLength": 699052}, "518": {"vr": "OW", "BinaryLength": 699052}, "519": {"vr": "OW", "BinaryLength": 699052}, "520": {"vr": "OW", "BinaryLength": 699052}, "521": {"vr": "OW", "BinaryLength": 699052}, "522": {"vr": "OW", "BinaryLength": 699052}, "523": {"vr": "OW", "BinaryLength": 699052}, "524": {"vr": "OW", "BinaryLength": 699052}, "525": {"vr": "OW", "BinaryLength": 699052}, "526": {"vr": "OW", "BinaryLength": 699052}, "527": {"vr": "OW", "BinaryLength": 699052}, "528": {"vr": "OW", "BinaryLength": 699052}, "529": {"vr": "OW", "BinaryLength": 699052}, "530": {"vr": "OW", "BinaryLength": 699052}}}


