from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__)):
    return generate_dicom(out_dir, num_vols, constant_hdr,
                          collated_data, varying_hdr)


num_vols = 192


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY",
            "M",
            "ND",
            "NORM"
        ]
    },
    "00080012": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.4"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "091331.137000"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "092253.572000"
        ]
    },
    "00080032": {
        "vr": "TM",
        "Value": [
            "091738.400000"
        ]
    },
    "00080050": {
        "vr": "SH"
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "MR"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "SIEMENS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "Address of said institute"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Data repository"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "AWP45193"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^Project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "t1_mprage_sag_p2_iso_1"
        ]
    },
    "00081040": {
        "vr": "LO",
        "Value": [
            "Department"
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotype"
            }
        ]
    },
    "00081050": {
        "vr": "PN"
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "Skyra"
        ]
    },
    "00081140": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509142122884100541"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509142519936700545"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509141726605700537"
                    ]
                }
            }
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Session Identifier"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "Session Label"
        ]
    },
    "00100021": {
        "vr": "LO",
        "Value": [
            "2"
        ]
    },
    "00100030": {
        "vr": "DA",
        "Value": [
            "19800824"
        ]
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "M"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "037Y"
        ]
    },
    "00101020": {
        "vr": "DS",
        "Value": [
            1.82
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            90.0
        ]
    },
    "00102000": {
        "vr": "LO",
        "Value": [
            "None"
        ]
    },
    "00102110": {
        "vr": "LO",
        "Value": [
            "None"
        ]
    },
    "001021C0": {
        "vr": "US",
        "Value": [
            4
        ]
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            "Project:A_PROJECT Subject:A_SUBJECT Session:A_SESSION"
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "BRAIN"
        ]
    },
    "00180020": {
        "vr": "CS",
        "Value": [
            "GR",
            "IR"
        ]
    },
    "00180021": {
        "vr": "CS",
        "Value": [
            "SK",
            "SP",
            "MP"
        ]
    },
    "00180022": {
        "vr": "CS",
        "Value": [
            "IR"
        ]
    },
    "00180023": {
        "vr": "CS",
        "Value": [
            "3D"
        ]
    },
    "00180024": {
        "vr": "SH",
        "Value": [
            "*tfl3d1_16ns"
        ]
    },
    "00180025": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00180050": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00180080": {
        "vr": "DS",
        "Value": [
            2300.0
        ]
    },
    "00180081": {
        "vr": "DS",
        "Value": [
            2.07
        ]
    },
    "00180082": {
        "vr": "DS",
        "Value": [
            900.0
        ]
    },
    "00180083": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00180084": {
        "vr": "DS",
        "Value": [
            123.251994
        ]
    },
    "00180085": {
        "vr": "SH",
        "Value": [
            "1H"
        ]
    },
    "00180086": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00180087": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00180089": {
        "vr": "IS",
        "Value": [
            239
        ]
    },
    "00180091": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00180093": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "00180094": {
        "vr": "DS",
        "Value": [
            93.75
        ]
    },
    "00180095": {
        "vr": "DS",
        "Value": [
            230.0
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "45193"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "syngo MR D13C"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "t1_mprage_sag_p2_iso_1"
        ]
    },
    "00181200": {
        "vr": "DA",
        "Value": [
            "20090304",
            "20090304"
        ]
    },
    "00181201": {
        "vr": "TM",
        "Value": [
            "123723.000000",
            "123723.000000"
        ]
    },
    "00181251": {
        "vr": "SH",
        "Value": [
            "Body"
        ]
    },
    "00181310": {
        "vr": "US",
        "Value": [
            0,
            256,
            240,
            0
        ]
    },
    "00181312": {
        "vr": "CS",
        "Value": [
            "ROW"
        ]
    },
    "00181314": {
        "vr": "DS",
        "Value": [
            9.0
        ]
    },
    "00181315": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00181316": {
        "vr": "DS",
        "Value": [
            0.08872682171054
        ]
    },
    "00181318": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "00190010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR HEADER"
        ]
    },
    "00191008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00191009": {
        "vr": "LO",
        "Value": [
            "1.0"
        ]
    },
    "0019100B": {
        "vr": "DS",
        "Value": [
            309605.0
        ]
    },
    "0019100F": {
        "vr": "SH",
        "Value": [
            "Normal"
        ]
    },
    "00191011": {
        "vr": "SH",
        "Value": [
            "No"
        ]
    },
    "00191012": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00191013": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00191014": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00191017": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00191018": {
        "vr": "IS",
        "Value": [
            8500
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.2.826.0.1.3680043.8.498.35939304416003656006618747446767853539"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.2.19.45193.2018052509173746910900550.0.0.0"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "PROJECT_ID"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "00200012": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00200037": {
        "vr": "DS",
        "Value": [
            -0.0209393156747,
            0.99978074849393,
            2.180012e-09,
            -0.0191939883458,
            -0.0004019949394,
            -0.999815697622
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.2.19.45193.1.20180525091331822.0.0.0"
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00210010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR SDS 01"
        ]
    },
    "00210011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR SDI 02"
        ]
    },
    "00211001": {
        "vr": "IS",
        "Value": [
            90
        ]
    },
    "00211004": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00211005": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00211006": {
        "vr": "LO",
        "Value": [
            "void"
        ]
    },
    "00211007": {
        "vr": "LO",
        "Value": [
            "NUMARIS/4"
        ]
    },
    "00211008": {
        "vr": "SH",
        "Value": [
            "Normal"
        ]
    },
    "00211009": {
        "vr": "LO",
        "Value": [
            "p2"
        ]
    },
    "0021100A": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "0021100C": {
        "vr": "SH",
        "Value": [
            "+LPH"
        ]
    },
    "0021100D": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "0021100F": {
        "vr": "DS",
        "Value": [
            27.8939991,
            23.26799965,
            38.05500031
        ]
    },
    "00211010": {
        "vr": "IS",
        "Value": [
            41330004
        ]
    },
    "00211011": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211012": {
        "vr": "FD",
        "Value": [
            2.0
        ]
    },
    "00211013": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211014": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211016": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211017": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211018": {
        "vr": "SH",
        "Value": [
            "Head"
        ]
    },
    "0021101A": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "0021101B": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "0021101C": {
        "vr": "DS",
        "Value": [
            13.73810482,
            13.02842712,
            10.57036972
        ]
    },
    "0021101D": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "00211022": {
        "vr": "SH",
        "Value": [
            "SIEMENS"
        ]
    },
    "00211023": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211025": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00211026": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            12173,
            0,
            0,
            0,
            0,
            0,
            0
        ]
    },
    "00211027": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "0021102A": {
        "vr": "IS",
        "Value": [
            255,
            0,
            0,
            0,
            0,
            0,
            0,
            4865,
            4866,
            0,
            0
        ]
    },
    "0021102B": {
        "vr": "ST",
        "Value": [
            "1;HFS;90.00;37.75;2;0;2;-2057087971"
        ]
    },
    "0021102C": {
        "vr": "DS",
        "Value": [
            1000000.0,
            28.37931985,
            28.37931929
        ]
    },
    "0021102D": {
        "vr": "DS",
        "Value": [
            3.2,
            0.40248437,
            0.0
        ]
    },
    "0021102E": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "0021102F": {
        "vr": "DS",
        "Value": [
            37.0,
            37.0,
            38.0
        ]
    },
    "00211030": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211031": {
        "vr": "IS",
        "Value": [
            -1098
        ]
    },
    "00211032": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00211033": {
        "vr": "SH",
        "Value": [
            "GC99"
        ]
    },
    "00211034": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00211035": {
        "vr": "DS",
        "Value": [
            0.79885161
        ]
    },
    "00211036": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211038": {
        "vr": "DS",
        "Value": [
            365.746003
        ]
    },
    "0021103B": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0021103D": {
        "vr": "CS",
        "Value": [
            "3D"
        ]
    },
    "00211044": {
        "vr": "DS",
        "Value": [
            7.07106781,
            0.85418529
        ]
    },
    "00211045": {
        "vr": "CS",
        "Value": [
            "NO"
        ]
    },
    "00211046": {
        "vr": "DS",
        "Value": [
            2275.846875
        ]
    },
    "00211047": {
        "vr": "CS",
        "Value": [
            "IEC"
        ]
    },
    "00211048": {
        "vr": "CS"
    },
    "00211049": {
        "vr": "CS"
    },
    "00211050": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00211051": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00211053": {
        "vr": "CS",
        "Value": [
            "U"
        ]
    },
    "00211103": {
        "vr": "DS",
        "Value": [
            309605.0
        ]
    },
    "0021111C": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00211124": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211133": {
        "vr": "IS",
        "Value": [
            128
        ]
    },
    "00211135": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211142": {
        "vr": "IS",
        "Value": [
            8500
        ]
    },
    "00211145": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00211148": {
        "vr": "IS",
        "Value": [
            96
        ]
    },
    "00211149": {
        "vr": "IS",
        "Value": [
            120
        ]
    },
    "0021114F": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "00211151": {
        "vr": "UL",
        "Value": [
            134217728
        ]
    },
    "00211154": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00211156": {
        "vr": "LO",
        "Value": [
            "p2"
        ]
    },
    "00211158": {
        "vr": "SH",
        "Value": [
            "240*256"
        ]
    },
    "00211159": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "0021115E": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211171": {
        "vr": "UT",
        "Value": [
            "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
        ]
    },
    "00211176": {
        "vr": "LO",
        "Value": [
            "ChannelMixing:ND=true_CMM=1_CDM=1",
            "ACC1",
            "NormalizeAlgo:PreScan"
        ]
    },
    "00250010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR EXTRACTED CSA HEADER"
        ]
    },
    "00251001": {
        "vr": "SQ",
        "Value": [
            {
                "00250010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MR EXTRACTED CSA HEADER"
                    ]
                },
                "00251002": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS CSA HEADER"
                    ]
                },
                "00251003": {
                    "vr": "AT",
                    "Value": [
                        "00290010"
                    ]
                }
            },
            {
                "00250010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MR EXTRACTED CSA HEADER"
                    ]
                },
                "00251002": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS CSA HEADER"
                    ]
                },
                "00251003": {
                    "vr": "AT",
                    "Value": [
                        "00290020"
                    ]
                }
            }
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            256
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            240
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            1.0,
            1.0
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            12
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            11
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00280106": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00281055": {
        "vr": "LO",
        "Value": [
            "Algo1"
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CSA HEADER"
        ]
    },
    "00290011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MEDCOM HEADER2"
        ]
    },
    "00291008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00291009": {
        "vr": "LO",
        "Value": [
            "20180525"
        ]
    },
    "00291018": {
        "vr": "CS",
        "Value": [
            "MR"
        ]
    },
    "00291019": {
        "vr": "LO",
        "Value": [
            "20180525"
        ]
    },
    "00291160": {
        "vr": "LO",
        "Value": [
            "com"
        ]
    },
    "00321032": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "MND Phenotypes"
            }
        ]
    },
    "00321060": {
        "vr": "LO",
        "Value": [
            "MR_EXAM"
        ]
    },
    "00400244": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00400245": {
        "vr": "TM",
        "Value": [
            "091331.375000"
        ]
    },
    "00400253": {
        "vr": "SH",
        "Value": [
            "001"
        ]
    },
    "00400254": {
        "vr": "LO",
        "Value": [
            "MR Scan"
        ]
    },
    "00400275": {
        "vr": "SQ",
        "Value": [
            {
                "00400007": {
                    "vr": "LO",
                    "Value": [
                        "MR Scan"
                    ]
                },
                "00400009": {
                    "vr": "SH",
                    "Value": [
                        "001"
                    ]
                },
                "00401001": {
                    "vr": "SH",
                    "Value": [
                        "MRH060"
                    ]
                }
            }
        ]
    },
    "00400280": {
        "vr": "ST"
    },
    "00510010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR HEADER"
        ]
    },
    "00511008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00511009": {
        "vr": "LO",
        "Value": [
            "1.0"
        ]
    },
    "0051100A": {
        "vr": "LO",
        "Value": [
            "TA 05:09"
        ]
    },
    "0051100B": {
        "vr": "LO",
        "Value": [
            "240*256"
        ]
    },
    "0051100C": {
        "vr": "LO",
        "Value": [
            "FoV 240*256"
        ]
    },
    "0051100E": {
        "vr": "LO",
        "Value": [
            "Sag>Cor(-1.2)>Tra(1.1)"
        ]
    },
    "0051100F": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "00511011": {
        "vr": "LO",
        "Value": [
            "p2"
        ]
    },
    "00511012": {
        "vr": "SH",
        "Value": [
            "TP 0"
        ]
    },
    "00511013": {
        "vr": "SH",
        "Value": [
            "+LPH"
        ]
    },
    "00511016": {
        "vr": "LO",
        "Value": [
            "p2 M/ND/NORM"
        ]
    },
    "00511017": {
        "vr": "SH",
        "Value": [
            "SL 1.0"
        ]
    },
    "00511019": {
        "vr": "LO",
        "Value": [
            "A1/IR"
        ]
    }
}


varying_hdr = {"00080013": {"0": {"vr": "TM", "Value": ["092253.784000"]}, "1": {"vr": "TM", "Value": ["092253.922000"]}, "2": {"vr": "TM", "Value": ["092253.609000"]}, "3": {"vr": "TM", "Value": ["092253.929000"]}, "4": {"vr": "TM", "Value": ["092253.769000"]}, "5": {"vr": "TM", "Value": ["092253.848000"]}, "6": {"vr": "TM", "Value": ["092253.704000"]}, "7": {"vr": "TM", "Value": ["092253.678000"]}, "8": {"vr": "TM", "Value": ["092253.817000"]}, "9": {"vr": "TM", "Value": ["092253.918000"]}, "10": {"vr": "TM", "Value": ["092253.936000"]}, "11": {"vr": "TM", "Value": ["092253.966000"]}, "12": {"vr": "TM", "Value": ["092254.015000"]}, "13": {"vr": "TM", "Value": ["092253.618000"]}, "14": {"vr": "TM", "Value": ["092253.800000"]}, "15": {"vr": "TM", "Value": ["092253.864000"]}, "16": {"vr": "TM", "Value": ["092253.628000"]}, "17": {"vr": "TM", "Value": ["092254.039000"]}, "18": {"vr": "TM", "Value": ["092253.621000"]}, "19": {"vr": "TM", "Value": ["092253.648000"]}, "20": {"vr": "TM", "Value": ["092253.829000"]}, "21": {"vr": "TM", "Value": ["092254.049000"]}, "22": {"vr": "TM", "Value": ["092254.017000"]}, "23": {"vr": "TM", "Value": ["092253.820000"]}, "24": {"vr": "TM", "Value": ["092253.940000"]}, "25": {"vr": "TM", "Value": ["092253.724000"]}, "26": {"vr": "TM", "Value": ["092253.886000"]}, "27": {"vr": "TM", "Value": ["092253.881000"]}, "28": {"vr": "TM", "Value": ["092253.904000"]}, "29": {"vr": "TM", "Value": ["092253.742000"]}, "30": {"vr": "TM", "Value": ["092253.623000"]}, "31": {"vr": "TM", "Value": ["092253.906000"]}, "32": {"vr": "TM", "Value": ["092253.805000"]}, "33": {"vr": "TM", "Value": ["092253.626000"]}, "34": {"vr": "TM", "Value": ["092253.990000"]}, "35": {"vr": "TM", "Value": ["092253.994000"]}, "36": {"vr": "TM", "Value": ["092253.836000"]}, "37": {"vr": "TM", "Value": ["092253.899000"]}, "38": {"vr": "TM", "Value": ["092253.852000"]}, "39": {"vr": "TM", "Value": ["092253.693000"]}, "40": {"vr": "TM", "Value": ["092253.685000"]}, "41": {"vr": "TM", "Value": ["092253.833000"]}, "42": {"vr": "TM", "Value": ["092253.657000"]}, "43": {"vr": "TM", "Value": ["092253.759000"]}, "44": {"vr": "TM", "Value": ["092253.616000"]}, "45": {"vr": "TM", "Value": ["092253.915000"]}, "46": {"vr": "TM", "Value": ["092253.749000"]}, "47": {"vr": "TM", "Value": ["092253.920000"]}, "48": {"vr": "TM", "Value": ["092253.910000"]}, "49": {"vr": "TM", "Value": ["092253.913000"]}, "50": {"vr": "TM", "Value": ["092253.776000"]}, "51": {"vr": "TM", "Value": ["092253.945000"]}, "52": {"vr": "TM", "Value": ["092253.808000"]}, "53": {"vr": "TM", "Value": ["092253.949000"]}, "54": {"vr": "TM", "Value": ["092253.842000"]}, "55": {"vr": "TM", "Value": ["092253.986000"]}, "56": {"vr": "TM", "Value": ["092254.011000"]}, "57": {"vr": "TM", "Value": ["092254.006000"]}, "58": {"vr": "TM", "Value": ["092253.802000"]}, "59": {"vr": "TM", "Value": ["092253.650000"]}, "60": {"vr": "TM", "Value": ["092253.890000"]}, "61": {"vr": "TM", "Value": ["092253.592000"]}, "62": {"vr": "TM", "Value": ["092253.644000"]}, "63": {"vr": "TM", "Value": ["092253.752000"]}, "64": {"vr": "TM", "Value": ["092253.717000"]}, "65": {"vr": "TM", "Value": ["092253.980000"]}, "66": {"vr": "TM", "Value": ["092253.714000"]}, "67": {"vr": "TM", "Value": ["092253.695000"]}, "68": {"vr": "TM", "Value": ["092253.931000"]}, "69": {"vr": "TM", "Value": ["092253.984000"]}, "70": {"vr": "TM", "Value": ["092253.897000"]}, "71": {"vr": "TM", "Value": ["092253.875000"]}, "72": {"vr": "TM", "Value": ["092253.635000"]}, "73": {"vr": "TM", "Value": ["092254.035000"]}, "74": {"vr": "TM", "Value": ["092253.794000"]}, "75": {"vr": "TM", "Value": ["092253.868000"]}, "76": {"vr": "TM", "Value": ["092253.761000"]}, "77": {"vr": "TM", "Value": ["092253.710000"]}, "78": {"vr": "TM", "Value": ["092253.845000"]}, "79": {"vr": "TM", "Value": ["092253.866000"]}, "80": {"vr": "TM", "Value": ["092253.669000"]}, "81": {"vr": "TM", "Value": ["092253.637000"]}, "82": {"vr": "TM", "Value": ["092253.738000"]}, "83": {"vr": "TM", "Value": ["092253.666000"]}, "84": {"vr": "TM", "Value": ["092253.973000"]}, "85": {"vr": "TM", "Value": ["092253.883000"]}, "86": {"vr": "TM", "Value": ["092253.877000"]}, "87": {"vr": "TM", "Value": ["092253.641000"]}, "88": {"vr": "TM", "Value": ["092253.707000"]}, "89": {"vr": "TM", "Value": ["092253.683000"]}, "90": {"vr": "TM", "Value": ["092253.720000"]}, "91": {"vr": "TM", "Value": ["092253.702000"]}, "92": {"vr": "TM", "Value": ["092253.763000"]}, "93": {"vr": "TM", "Value": ["092254.002000"]}, "94": {"vr": "TM", "Value": ["092253.690000"]}, "95": {"vr": "TM", "Value": ["092253.947000"]}, "96": {"vr": "TM", "Value": ["092253.671000"]}, "97": {"vr": "TM", "Value": ["092253.726000"]}, "98": {"vr": "TM", "Value": ["092253.796000"]}, "99": {"vr": "TM", "Value": ["092253.838000"]}, "100": {"vr": "TM", "Value": ["092254.025000"]}, "101": {"vr": "TM", "Value": ["092253.824000"]}, "102": {"vr": "TM", "Value": ["092253.612000"]}, "103": {"vr": "TM", "Value": ["092253.879000"]}, "104": {"vr": "TM", "Value": ["092253.927000"]}, "105": {"vr": "TM", "Value": ["092253.810000"]}, "106": {"vr": "TM", "Value": ["092254.046000"]}, "107": {"vr": "TM", "Value": ["092253.581000"]}, "108": {"vr": "TM", "Value": ["092254.042000"]}, "109": {"vr": "TM", "Value": ["092253.975000"]}, "110": {"vr": "TM", "Value": ["092253.659000"]}, "111": {"vr": "TM", "Value": ["092254.020000"]}, "112": {"vr": "TM", "Value": ["092253.831000"]}, "113": {"vr": "TM", "Value": ["092253.822000"]}, "114": {"vr": "TM", "Value": ["092253.653000"]}, "115": {"vr": "TM", "Value": ["092253.888000"]}, "116": {"vr": "TM", "Value": ["092253.789000"]}, "117": {"vr": "TM", "Value": ["092253.607000"]}, "118": {"vr": "TM", "Value": ["092253.655000"]}, "119": {"vr": "TM", "Value": ["092253.908000"]}, "120": {"vr": "TM", "Value": ["092254.013000"]}, "121": {"vr": "TM", "Value": ["092253.588000"]}, "122": {"vr": "TM", "Value": ["092253.740000"]}, "123": {"vr": "TM", "Value": ["092253.700000"]}, "124": {"vr": "TM", "Value": ["092253.855000"]}, "125": {"vr": "TM", "Value": ["092253.872000"]}, "126": {"vr": "TM", "Value": ["092253.662000"]}, "127": {"vr": "TM", "Value": ["092253.892000"]}, "128": {"vr": "TM", "Value": ["092253.971000"]}, "129": {"vr": "TM", "Value": ["092253.791000"]}, "130": {"vr": "TM", "Value": ["092253.861000"]}, "131": {"vr": "TM", "Value": ["092253.731000"]}, "132": {"vr": "TM", "Value": ["092253.894000"]}, "133": {"vr": "TM", "Value": ["092253.600000"]}, "134": {"vr": "TM", "Value": ["092253.673000"]}, "135": {"vr": "TM", "Value": ["092254.008000"]}, "136": {"vr": "TM", "Value": ["092253.782000"]}, "137": {"vr": "TM", "Value": ["092253.827000"]}, "138": {"vr": "TM", "Value": ["092254.004000"]}, "139": {"vr": "TM", "Value": ["092253.840000"]}, "140": {"vr": "TM", "Value": ["092253.754000"]}, "141": {"vr": "TM", "Value": ["092253.850000"]}, "142": {"vr": "TM", "Value": ["092253.687000"]}, "143": {"vr": "TM", "Value": ["092253.956000"]}, "144": {"vr": "TM", "Value": ["092253.664000"]}, "145": {"vr": "TM", "Value": ["092253.962000"]}, "146": {"vr": "TM", "Value": ["092253.938000"]}, "147": {"vr": "TM", "Value": ["092254.027000"]}, "148": {"vr": "TM", "Value": ["092253.870000"]}, "149": {"vr": "TM", "Value": ["092253.747000"]}, "150": {"vr": "TM", "Value": ["092253.733000"]}, "151": {"vr": "TM", "Value": ["092253.681000"]}, "152": {"vr": "TM", "Value": ["092253.605000"]}, "153": {"vr": "TM", "Value": ["092254.022000"]}, "154": {"vr": "TM", "Value": ["092253.812000"]}, "155": {"vr": "TM", "Value": ["092253.997000"]}, "156": {"vr": "TM", "Value": ["092253.857000"]}, "157": {"vr": "TM", "Value": ["092253.586000"]}, "158": {"vr": "TM", "Value": ["092253.590000"]}, "159": {"vr": "TM", "Value": ["092253.798000"]}, "160": {"vr": "TM", "Value": ["092253.630000"]}, "161": {"vr": "TM", "Value": ["092253.603000"]}, "162": {"vr": "TM", "Value": ["092253.722000"]}, "163": {"vr": "TM", "Value": ["092253.735000"]}, "164": {"vr": "TM", "Value": ["092253.598000"]}, "165": {"vr": "TM", "Value": ["092253.933000"]}, "166": {"vr": "TM", "Value": ["092253.614000"]}, "167": {"vr": "TM", "Value": ["092253.697000"]}, "168": {"vr": "TM", "Value": ["092253.992000"]}, "169": {"vr": "TM", "Value": ["092253.774000"]}, "170": {"vr": "TM", "Value": ["092253.676000"]}, "171": {"vr": "TM", "Value": ["092253.646000"]}, "172": {"vr": "TM", "Value": ["092253.964000"]}, "173": {"vr": "TM", "Value": ["092253.814000"]}, "174": {"vr": "TM", "Value": ["092253.639000"]}, "175": {"vr": "TM", "Value": ["092253.712000"]}, "176": {"vr": "TM", "Value": ["092253.780000"]}, "177": {"vr": "TM", "Value": ["092253.924000"]}, "178": {"vr": "TM", "Value": ["092253.968000"]}, "179": {"vr": "TM", "Value": ["092254.037000"]}, "180": {"vr": "TM", "Value": ["092253.633000"]}, "181": {"vr": "TM", "Value": ["092253.744000"]}, "182": {"vr": "TM", "Value": ["092253.787000"]}, "183": {"vr": "TM", "Value": ["092253.729000"]}, "184": {"vr": "TM", "Value": ["092253.901000"]}, "185": {"vr": "TM", "Value": ["092253.982000"]}, "186": {"vr": "TM", "Value": ["092253.942000"]}, "187": {"vr": "TM", "Value": ["092253.772000"]}, "188": {"vr": "TM", "Value": ["092253.859000"]}, "189": {"vr": "TM", "Value": ["092253.756000"]}, "190": {"vr": "TM", "Value": ["092254.044000"]}, "191": {"vr": "TM", "Value": ["092253.977000"]}}, "00080018": {"0": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225144617101067"]}, "1": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225277336501217"]}, "2": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224961734500745"]}, "3": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225282004601227"]}, "4": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225117654801021"]}, "5": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225197692201151"]}, "6": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225070873400939"]}, "7": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225027292300855"]}, "8": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225177935601119"]}, "9": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225286060401229"]}, "10": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225296211101241"]}, "11": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922534393101253"]}, "12": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225336827701295"]}, "13": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224975446400767"]}, "14": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225151141801075"]}, "15": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225225225201175"]}, "16": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224976962400773"]}, "17": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225347072501311"]}, "18": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224973719300763"]}, "19": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922509432600829"]}, "20": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225178894801123"]}, "21": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225350911901319"]}, "22": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225338498101297"]}, "23": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225183372501129"]}, "24": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225292316601237"]}, "25": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225088616900967"]}, "26": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225248847401195"]}, "27": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225235222801185"]}, "28": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225268460001213"]}, "29": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225099771800985"]}, "30": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224978921800775"]}, "31": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225260050901207"]}, "32": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225166350901101"]}, "33": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224968608200755"]}, "34": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225319042401275"]}, "35": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225325866001279"]}, "36": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225190824701145"]}, "37": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225259422701205"]}, "38": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225216574201169"]}, "39": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225060588300919"]}, "40": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225049398900899"]}, "41": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225184912001131"]}, "42": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922505491800821"]}, "43": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225127470001033"]}, "44": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224956695600735"]}, "45": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225277830001220"]}, "46": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922515381600995"]}, "47": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225279425301224"]}, "48": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225269717401215"]}, "49": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225266988701211"]}, "50": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225137227301051"]}, "51": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225293452201239"]}, "52": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225166769101103"]}, "53": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922531997101249"]}, "54": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922526167201157"]}, "55": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225318824701273"]}, "56": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225330190401285"]}, "57": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225330562701289"]}, "58": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225162300601091"]}, "59": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922504049800819"]}, "60": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225249792901199"]}, "61": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224941893100709"]}, "62": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224998878100807"]}, "63": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922515346700993"]}, "64": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225080733900955"]}, "65": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225315852801267"]}, "66": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225068736000935"]}, "67": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225051403700903"]}, "68": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225287580901231"]}, "69": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225318133001271"]}, "70": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225248008001193"]}, "71": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225224035901171"]}, "72": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224988956900789"]}, "73": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225341938301303"]}, "74": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225151537301077"]}, "75": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225234743601181"]}, "76": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225122230401027"]}, "77": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225065977400929"]}, "78": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922528132301161"]}, "79": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225225076901173"]}, "80": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225029067300863"]}, "81": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922502783100815"]}, "82": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922511371600987"]}, "83": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225025272000853"]}, "84": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922539988001261"]}, "85": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225238137201189"]}, "86": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225237689401187"]}, "87": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224987795100787"]}, "88": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225071096600941"]}, "89": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225044560000891"]}, "90": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225083741000959"]}, "91": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225065514300927"]}, "92": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225118491101023"]}, "93": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225327636501281"]}, "94": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225054947800907"]}, "95": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225299102301245"]}, "96": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225029953400869"]}, "97": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225082529700957"]}, "98": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225155464701079"]}, "99": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922524783501155"]}, "100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225344640301309"]}, "101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225176216901115"]}, "102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224965743900751"]}, "103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225235190701183"]}, "104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225279475501225"]}, "105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225166991701105"]}, "106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225350392001315"]}, "107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224946385600721"]}, "108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225348430801313"]}, "109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225315620301265"]}, "110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225029388600867"]}, "111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225340737301299"]}, "112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225186557901137"]}, "113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225186182901133"]}, "114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922508830900825"]}, "115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225244858401191"]}, "116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225147112801069"]}, "117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224956433300733"]}, "118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922509334700827"]}, "119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225266335301209"]}, "120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225330985401293"]}, "121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224939212200701"]}, "122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922518889800999"]}, "123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225055369800909"]}, "124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225213563801167"]}, "125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225226311301177"]}, "126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225017971600839"]}, "127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225255846501201"]}, "128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922538699501259"]}, "129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225147709601071"]}, "130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225212626001165"]}, "131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225087235500961"]}, "132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225259190701203"]}, "133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224944944500713"]}, "134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225034879400875"]}, "135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225330919901291"]}, "136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225130887001037"]}, "137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225177405501117"]}, "138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225328832001283"]}, "139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225195066501149"]}, "140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225111693601003"]}, "141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922521208801153"]}, "142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225041972800889"]}, "143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922531972501247"]}, "144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225014249000835"]}, "145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922533564701251"]}, "146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225290536201235"]}, "147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225342419301305"]}, "148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225227530101179"]}, "149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922514401000991"]}, "150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922514156100989"]}, "151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225041695400885"]}, "152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224952571600729"]}, "153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225340903101301"]}, "154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225164260301095"]}, "155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225330342901287"]}, "156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922527687401159"]}, "157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224939396700705"]}, "158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224945050300717"]}, "159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225158825301081"]}, "160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224976283100771"]}, "161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224930651300689"]}, "162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225093631700981"]}, "163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225094035400983"]}, "164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224931652100693"]}, "165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225287897401233"]}, "166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224974763500765"]}, "167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225057614900915"]}, "168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225320484401277"]}, "169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225136708101047"]}, "170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225033657200873"]}, "171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224989735200793"]}, "172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922535256301255"]}, "173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225164744201097"]}, "174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525092250229700809"]}, "175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225078187800949"]}, "176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225132264901039"]}, "177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225278264701222"]}, "178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922537693601257"]}, "179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225343502601307"]}, "180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509224989643700791"]}, "181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225113234101013"]}, "182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225136801101049"]}, "183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225093621200980"]}, "184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225249202101197"]}, "185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225315995601269"]}, "186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225298421601243"]}, "187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225128912701035"]}, "188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250922529766401163"]}, "189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225125519901031"]}, "190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225350736501317"]}, "191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509225314211501263"]}}, "00080033": {"0": {"vr": "TM", "Value": ["092253.784000"]}, "1": {"vr": "TM", "Value": ["092253.922000"]}, "2": {"vr": "TM", "Value": ["092253.609000"]}, "3": {"vr": "TM", "Value": ["092253.929000"]}, "4": {"vr": "TM", "Value": ["092253.769000"]}, "5": {"vr": "TM", "Value": ["092253.848000"]}, "6": {"vr": "TM", "Value": ["092253.704000"]}, "7": {"vr": "TM", "Value": ["092253.678000"]}, "8": {"vr": "TM", "Value": ["092253.817000"]}, "9": {"vr": "TM", "Value": ["092253.918000"]}, "10": {"vr": "TM", "Value": ["092253.936000"]}, "11": {"vr": "TM", "Value": ["092253.966000"]}, "12": {"vr": "TM", "Value": ["092254.015000"]}, "13": {"vr": "TM", "Value": ["092253.618000"]}, "14": {"vr": "TM", "Value": ["092253.800000"]}, "15": {"vr": "TM", "Value": ["092253.864000"]}, "16": {"vr": "TM", "Value": ["092253.628000"]}, "17": {"vr": "TM", "Value": ["092254.039000"]}, "18": {"vr": "TM", "Value": ["092253.621000"]}, "19": {"vr": "TM", "Value": ["092253.648000"]}, "20": {"vr": "TM", "Value": ["092253.829000"]}, "21": {"vr": "TM", "Value": ["092254.049000"]}, "22": {"vr": "TM", "Value": ["092254.017000"]}, "23": {"vr": "TM", "Value": ["092253.820000"]}, "24": {"vr": "TM", "Value": ["092253.940000"]}, "25": {"vr": "TM", "Value": ["092253.724000"]}, "26": {"vr": "TM", "Value": ["092253.886000"]}, "27": {"vr": "TM", "Value": ["092253.881000"]}, "28": {"vr": "TM", "Value": ["092253.904000"]}, "29": {"vr": "TM", "Value": ["092253.742000"]}, "30": {"vr": "TM", "Value": ["092253.623000"]}, "31": {"vr": "TM", "Value": ["092253.906000"]}, "32": {"vr": "TM", "Value": ["092253.805000"]}, "33": {"vr": "TM", "Value": ["092253.626000"]}, "34": {"vr": "TM", "Value": ["092253.990000"]}, "35": {"vr": "TM", "Value": ["092253.994000"]}, "36": {"vr": "TM", "Value": ["092253.836000"]}, "37": {"vr": "TM", "Value": ["092253.899000"]}, "38": {"vr": "TM", "Value": ["092253.852000"]}, "39": {"vr": "TM", "Value": ["092253.693000"]}, "40": {"vr": "TM", "Value": ["092253.685000"]}, "41": {"vr": "TM", "Value": ["092253.833000"]}, "42": {"vr": "TM", "Value": ["092253.657000"]}, "43": {"vr": "TM", "Value": ["092253.759000"]}, "44": {"vr": "TM", "Value": ["092253.616000"]}, "45": {"vr": "TM", "Value": ["092253.915000"]}, "46": {"vr": "TM", "Value": ["092253.749000"]}, "47": {"vr": "TM", "Value": ["092253.920000"]}, "48": {"vr": "TM", "Value": ["092253.910000"]}, "49": {"vr": "TM", "Value": ["092253.913000"]}, "50": {"vr": "TM", "Value": ["092253.776000"]}, "51": {"vr": "TM", "Value": ["092253.945000"]}, "52": {"vr": "TM", "Value": ["092253.808000"]}, "53": {"vr": "TM", "Value": ["092253.949000"]}, "54": {"vr": "TM", "Value": ["092253.842000"]}, "55": {"vr": "TM", "Value": ["092253.986000"]}, "56": {"vr": "TM", "Value": ["092254.011000"]}, "57": {"vr": "TM", "Value": ["092254.006000"]}, "58": {"vr": "TM", "Value": ["092253.802000"]}, "59": {"vr": "TM", "Value": ["092253.650000"]}, "60": {"vr": "TM", "Value": ["092253.890000"]}, "61": {"vr": "TM", "Value": ["092253.592000"]}, "62": {"vr": "TM", "Value": ["092253.644000"]}, "63": {"vr": "TM", "Value": ["092253.752000"]}, "64": {"vr": "TM", "Value": ["092253.717000"]}, "65": {"vr": "TM", "Value": ["092253.980000"]}, "66": {"vr": "TM", "Value": ["092253.714000"]}, "67": {"vr": "TM", "Value": ["092253.695000"]}, "68": {"vr": "TM", "Value": ["092253.931000"]}, "69": {"vr": "TM", "Value": ["092253.984000"]}, "70": {"vr": "TM", "Value": ["092253.897000"]}, "71": {"vr": "TM", "Value": ["092253.875000"]}, "72": {"vr": "TM", "Value": ["092253.635000"]}, "73": {"vr": "TM", "Value": ["092254.035000"]}, "74": {"vr": "TM", "Value": ["092253.794000"]}, "75": {"vr": "TM", "Value": ["092253.868000"]}, "76": {"vr": "TM", "Value": ["092253.761000"]}, "77": {"vr": "TM", "Value": ["092253.710000"]}, "78": {"vr": "TM", "Value": ["092253.845000"]}, "79": {"vr": "TM", "Value": ["092253.866000"]}, "80": {"vr": "TM", "Value": ["092253.669000"]}, "81": {"vr": "TM", "Value": ["092253.637000"]}, "82": {"vr": "TM", "Value": ["092253.738000"]}, "83": {"vr": "TM", "Value": ["092253.666000"]}, "84": {"vr": "TM", "Value": ["092253.973000"]}, "85": {"vr": "TM", "Value": ["092253.883000"]}, "86": {"vr": "TM", "Value": ["092253.877000"]}, "87": {"vr": "TM", "Value": ["092253.641000"]}, "88": {"vr": "TM", "Value": ["092253.707000"]}, "89": {"vr": "TM", "Value": ["092253.683000"]}, "90": {"vr": "TM", "Value": ["092253.720000"]}, "91": {"vr": "TM", "Value": ["092253.702000"]}, "92": {"vr": "TM", "Value": ["092253.763000"]}, "93": {"vr": "TM", "Value": ["092254.002000"]}, "94": {"vr": "TM", "Value": ["092253.690000"]}, "95": {"vr": "TM", "Value": ["092253.947000"]}, "96": {"vr": "TM", "Value": ["092253.671000"]}, "97": {"vr": "TM", "Value": ["092253.726000"]}, "98": {"vr": "TM", "Value": ["092253.796000"]}, "99": {"vr": "TM", "Value": ["092253.838000"]}, "100": {"vr": "TM", "Value": ["092254.025000"]}, "101": {"vr": "TM", "Value": ["092253.824000"]}, "102": {"vr": "TM", "Value": ["092253.612000"]}, "103": {"vr": "TM", "Value": ["092253.879000"]}, "104": {"vr": "TM", "Value": ["092253.927000"]}, "105": {"vr": "TM", "Value": ["092253.810000"]}, "106": {"vr": "TM", "Value": ["092254.046000"]}, "107": {"vr": "TM", "Value": ["092253.581000"]}, "108": {"vr": "TM", "Value": ["092254.042000"]}, "109": {"vr": "TM", "Value": ["092253.975000"]}, "110": {"vr": "TM", "Value": ["092253.659000"]}, "111": {"vr": "TM", "Value": ["092254.020000"]}, "112": {"vr": "TM", "Value": ["092253.831000"]}, "113": {"vr": "TM", "Value": ["092253.822000"]}, "114": {"vr": "TM", "Value": ["092253.653000"]}, "115": {"vr": "TM", "Value": ["092253.888000"]}, "116": {"vr": "TM", "Value": ["092253.789000"]}, "117": {"vr": "TM", "Value": ["092253.607000"]}, "118": {"vr": "TM", "Value": ["092253.655000"]}, "119": {"vr": "TM", "Value": ["092253.908000"]}, "120": {"vr": "TM", "Value": ["092254.013000"]}, "121": {"vr": "TM", "Value": ["092253.588000"]}, "122": {"vr": "TM", "Value": ["092253.740000"]}, "123": {"vr": "TM", "Value": ["092253.700000"]}, "124": {"vr": "TM", "Value": ["092253.855000"]}, "125": {"vr": "TM", "Value": ["092253.872000"]}, "126": {"vr": "TM", "Value": ["092253.662000"]}, "127": {"vr": "TM", "Value": ["092253.892000"]}, "128": {"vr": "TM", "Value": ["092253.971000"]}, "129": {"vr": "TM", "Value": ["092253.791000"]}, "130": {"vr": "TM", "Value": ["092253.861000"]}, "131": {"vr": "TM", "Value": ["092253.731000"]}, "132": {"vr": "TM", "Value": ["092253.894000"]}, "133": {"vr": "TM", "Value": ["092253.600000"]}, "134": {"vr": "TM", "Value": ["092253.673000"]}, "135": {"vr": "TM", "Value": ["092254.008000"]}, "136": {"vr": "TM", "Value": ["092253.782000"]}, "137": {"vr": "TM", "Value": ["092253.827000"]}, "138": {"vr": "TM", "Value": ["092254.004000"]}, "139": {"vr": "TM", "Value": ["092253.840000"]}, "140": {"vr": "TM", "Value": ["092253.754000"]}, "141": {"vr": "TM", "Value": ["092253.850000"]}, "142": {"vr": "TM", "Value": ["092253.687000"]}, "143": {"vr": "TM", "Value": ["092253.956000"]}, "144": {"vr": "TM", "Value": ["092253.664000"]}, "145": {"vr": "TM", "Value": ["092253.962000"]}, "146": {"vr": "TM", "Value": ["092253.938000"]}, "147": {"vr": "TM", "Value": ["092254.027000"]}, "148": {"vr": "TM", "Value": ["092253.870000"]}, "149": {"vr": "TM", "Value": ["092253.747000"]}, "150": {"vr": "TM", "Value": ["092253.733000"]}, "151": {"vr": "TM", "Value": ["092253.681000"]}, "152": {"vr": "TM", "Value": ["092253.605000"]}, "153": {"vr": "TM", "Value": ["092254.022000"]}, "154": {"vr": "TM", "Value": ["092253.812000"]}, "155": {"vr": "TM", "Value": ["092253.997000"]}, "156": {"vr": "TM", "Value": ["092253.857000"]}, "157": {"vr": "TM", "Value": ["092253.586000"]}, "158": {"vr": "TM", "Value": ["092253.590000"]}, "159": {"vr": "TM", "Value": ["092253.798000"]}, "160": {"vr": "TM", "Value": ["092253.630000"]}, "161": {"vr": "TM", "Value": ["092253.603000"]}, "162": {"vr": "TM", "Value": ["092253.722000"]}, "163": {"vr": "TM", "Value": ["092253.735000"]}, "164": {"vr": "TM", "Value": ["092253.598000"]}, "165": {"vr": "TM", "Value": ["092253.933000"]}, "166": {"vr": "TM", "Value": ["092253.614000"]}, "167": {"vr": "TM", "Value": ["092253.697000"]}, "168": {"vr": "TM", "Value": ["092253.992000"]}, "169": {"vr": "TM", "Value": ["092253.774000"]}, "170": {"vr": "TM", "Value": ["092253.676000"]}, "171": {"vr": "TM", "Value": ["092253.646000"]}, "172": {"vr": "TM", "Value": ["092253.964000"]}, "173": {"vr": "TM", "Value": ["092253.814000"]}, "174": {"vr": "TM", "Value": ["092253.639000"]}, "175": {"vr": "TM", "Value": ["092253.712000"]}, "176": {"vr": "TM", "Value": ["092253.780000"]}, "177": {"vr": "TM", "Value": ["092253.924000"]}, "178": {"vr": "TM", "Value": ["092253.968000"]}, "179": {"vr": "TM", "Value": ["092254.037000"]}, "180": {"vr": "TM", "Value": ["092253.633000"]}, "181": {"vr": "TM", "Value": ["092253.744000"]}, "182": {"vr": "TM", "Value": ["092253.787000"]}, "183": {"vr": "TM", "Value": ["092253.729000"]}, "184": {"vr": "TM", "Value": ["092253.901000"]}, "185": {"vr": "TM", "Value": ["092253.982000"]}, "186": {"vr": "TM", "Value": ["092253.942000"]}, "187": {"vr": "TM", "Value": ["092253.772000"]}, "188": {"vr": "TM", "Value": ["092253.859000"]}, "189": {"vr": "TM", "Value": ["092253.756000"]}, "190": {"vr": "TM", "Value": ["092254.044000"]}, "191": {"vr": "TM", "Value": ["092253.977000"]}}, "00191015": {"0": {"vr": "FD", "Value": [-4.49874177, -107.42080035, 108.17160196]}, "1": {"vr": "FD", "Value": [55.47704743, -106.16467295, 107.01971011]}, "2": {"vr": "FD", "Value": [-77.46928528, -108.94908868, 109.57307038]}, "3": {"vr": "FD", "Value": [58.47583688, -106.10186658, 106.96211551]}, "4": {"vr": "FD", "Value": [-10.49632069, -107.54641309, 108.28679114]}, "5": {"vr": "FD", "Value": [22.49036337, -106.85554302, 107.65325062]}, "6": {"vr": "FD", "Value": [-36.48582934, -108.09073496, 108.78594428]}, "7": {"vr": "FD", "Value": [-47.48139069, -108.32102498, 108.99712445]}, "8": {"vr": "FD", "Value": [9.49560904, -107.12770396, 107.90282719]}, "9": {"vr": "FD", "Value": [53.47785445, -106.20654387, 107.0581065]}, "10": {"vr": "FD", "Value": [61.47462634, -106.03906021, 106.90452092]}, "11": {"vr": "FD", "Value": [71.47059121, -105.82970565, 106.71253894]}, "12": {"vr": "FD", "Value": [91.46252094, -105.41099652, 106.32857499]}, "13": {"vr": "FD", "Value": [-73.47089934, -108.86534685, 109.49627759]}, "14": {"vr": "FD", "Value": [2.49843364, -107.27425215, 108.03721457]}, "15": {"vr": "FD", "Value": [29.48753878, -106.70899482, 107.51886324]}, "16": {"vr": "FD", "Value": [-69.47251339, -108.78160502, 109.4194848]}, "17": {"vr": "FD", "Value": [99.45929283, -105.24351287, 106.17498941]}, "18": {"vr": "FD", "Value": [-72.47130285, -108.84441139, 109.47707939]}, "19": {"vr": "FD", "Value": [-60.47614501, -108.59318591, 109.24670102]}, "20": {"vr": "FD", "Value": [14.49359148, -107.02302667, 107.8068362]}, "21": {"vr": "FD", "Value": [103.45767878, -105.15977104, 106.09819662]}, "22": {"vr": "FD", "Value": [92.46211743, -105.39006106, 106.3093768]}, "23": {"vr": "FD", "Value": [10.49520553, -107.1067685, 107.88362899]}, "24": {"vr": "FD", "Value": [63.47381932, -105.9971893, 106.86612452]}, "25": {"vr": "FD", "Value": [-28.48905744, -107.9232513, 108.6323587]}, "26": {"vr": "FD", "Value": [39.48350364, -106.49964026, 107.32688127]}, "27": {"vr": "FD", "Value": [37.48431067, -106.54151117, 107.36527766]}, "28": {"vr": "FD", "Value": [47.48027553, -106.33215661, 107.17329569]}, "29": {"vr": "FD", "Value": [-20.49228555, -107.75576765, 108.47877312]}, "30": {"vr": "FD", "Value": [-71.47170636, -108.82347594, 109.45788119]}, "31": {"vr": "FD", "Value": [48.47987202, -106.31122115, 107.15409749]}, "32": {"vr": "FD", "Value": [4.49762661, -107.23238124, 107.99881818]}, "33": {"vr": "FD", "Value": [-70.47210988, -108.80254048, 109.43868299]}, "34": {"vr": "FD", "Value": [81.46655607, -105.62035108, 106.52055697]}, "35": {"vr": "FD", "Value": [83.46574905, -105.57848017, 106.48216057]}, "36": {"vr": "FD", "Value": [17.49238094, -106.9602203, 107.74924161]}, "37": {"vr": "FD", "Value": [45.48108256, -106.37402752, 107.21169208]}, "38": {"vr": "FD", "Value": [24.48955634, -106.81367211, 107.61485423]}, "39": {"vr": "FD", "Value": [-41.48381177, -108.19541224, 108.88193527]}, "40": {"vr": "FD", "Value": [-44.48260123, -108.25821861, 108.93952986]}, "41": {"vr": "FD", "Value": [16.49278445, -106.98115576, 107.76843981]}, "42": {"vr": "FD", "Value": [-56.47775907, -108.50944409, 109.16990823]}, "43": {"vr": "FD", "Value": [-13.49511015, -107.60921946, 108.34438574]}, "44": {"vr": "FD", "Value": [-74.47049582, -108.88628231, 109.51547578]}, "45": {"vr": "FD", "Value": [52.47825797, -106.22747932, 107.0773047]}, "46": {"vr": "FD", "Value": [-17.49349609, -107.69296128, 108.42117853]}, "47": {"vr": "FD", "Value": [54.47745094, -106.18560841, 107.0389083]}, "48": {"vr": "FD", "Value": [50.47906499, -106.26935024, 107.11570109]}, "49": {"vr": "FD", "Value": [51.47866148, -106.24841478, 107.0965029]}, "50": {"vr": "FD", "Value": [-7.49753123, -107.48360672, 108.22919655]}, "51": {"vr": "FD", "Value": [65.47301229, -105.95531839, 106.82772813]}, "52": {"vr": "FD", "Value": [5.4972231, -107.21144578, 107.97961998]}, "53": {"vr": "FD", "Value": [67.47220526, -105.91344748, 106.78933173]}, "54": {"vr": "FD", "Value": [20.4911704, -106.89741393, 107.69164702]}, "55": {"vr": "FD", "Value": [80.46695959, -105.64128654, 106.53975517]}, "56": {"vr": "FD", "Value": [89.46332797, -105.45286743, 106.36697139]}, "57": {"vr": "FD", "Value": [87.46413499, -105.49473834, 106.40536778]}, "58": {"vr": "FD", "Value": [3.49803013, -107.25331669, 108.01801638]}, "59": {"vr": "FD", "Value": [-59.47654853, -108.57225046, 109.22750282]}, "60": {"vr": "FD", "Value": [41.48269661, -106.45776935, 107.28848487]}, "61": {"vr": "FD", "Value": [-83.4668642, -109.07470141, 109.68825956]}, "62": {"vr": "FD", "Value": [-62.47533798, -108.63505683, 109.28509741]}, "63": {"vr": "FD", "Value": [-16.4938996, -107.67202583, 108.40198033]}, "64": {"vr": "FD", "Value": [-31.4878469, -107.98605767, 108.68995329]}, "65": {"vr": "FD", "Value": [77.46817013, -105.70409291, 106.59734976]}, "66": {"vr": "FD", "Value": [-32.48744339, -108.00699313, 108.70915149]}, "67": {"vr": "FD", "Value": [-40.48421528, -108.17447678, 108.86273707]}, "68": {"vr": "FD", "Value": [59.47543337, -106.08093113, 106.94291732]}, "69": {"vr": "FD", "Value": [79.4673631, -105.662222, 106.55895336]}, "70": {"vr": "FD", "Value": [44.48148607, -106.39496298, 107.23089028]}, "71": {"vr": "FD", "Value": [34.48552121, -106.60431754, 107.42287225]}, "72": {"vr": "FD", "Value": [-66.47372393, -108.71879865, 109.3618902]}, "73": {"vr": "FD", "Value": [97.46009986, -105.28538378, 106.21338581]}, "74": {"vr": "FD", "Value": [-0.50035582, -107.33705852, 108.09480917]}, "75": {"vr": "FD", "Value": [31.48673175, -106.66712391, 107.48046685]}, "76": {"vr": "FD", "Value": [-12.49551366, -107.588284, 108.32518754]}, "77": {"vr": "FD", "Value": [-34.48663636, -108.04886404, 108.74754788]}, "78": {"vr": "FD", "Value": [21.49076688, -106.87647848, 107.67244882]}, "79": {"vr": "FD", "Value": [30.48713526, -106.68805937, 107.49966504]}, "80": {"vr": "FD", "Value": [-51.47977663, -108.4047668, 109.07391724]}, "81": {"vr": "FD", "Value": [-65.47412744, -108.6978632, 109.34269201]}, "82": {"vr": "FD", "Value": [-22.49147852, -107.79763856, 108.51716951]}, "83": {"vr": "FD", "Value": [-52.47937312, -108.42570226, 109.09311544]}, "84": {"vr": "FD", "Value": [74.46938067, -105.76689928, 106.65494435]}, "85": {"vr": "FD", "Value": [38.48390715, -106.52057572, 107.34607946]}, "86": {"vr": "FD", "Value": [35.48511769, -106.58338208, 107.40367406]}, "87": {"vr": "FD", "Value": [-63.47493447, -108.65599228, 109.30429561]}, "88": {"vr": "FD", "Value": [-35.48623285, -108.0697995, 108.76674608]}, "89": {"vr": "FD", "Value": [-45.48219771, -108.27915407, 108.95872806]}, "90": {"vr": "FD", "Value": [-30.48825042, -107.96512222, 108.67075509]}, "91": {"vr": "FD", "Value": [-37.48542582, -108.11167041, 108.80514248]}, "92": {"vr": "FD", "Value": [-11.49591717, -107.56734854, 108.30598934]}, "93": {"vr": "FD", "Value": [85.46494202, -105.53660926, 106.44376418]}, "94": {"vr": "FD", "Value": [-42.48340825, -108.2163477, 108.90113346]}, "95": {"vr": "FD", "Value": [66.47260878, -105.93438293, 106.80852993]}, "96": {"vr": "FD", "Value": [-50.48018015, -108.38383135, 109.05471904]}, "97": {"vr": "FD", "Value": [-27.48946096, -107.90231585, 108.6131605]}, "98": {"vr": "FD", "Value": [0.49924067, -107.31612306, 108.07561097]}, "99": {"vr": "FD", "Value": [18.49197742, -106.93928485, 107.73004341]}, "100": {"vr": "FD", "Value": [95.46090689, -105.32725469, 106.2517822]}, "101": {"vr": "FD", "Value": [12.4943985, -107.06489759, 107.8452326]}, "102": {"vr": "FD", "Value": [-76.4696888, -108.92815322, 109.55387218]}, "103": {"vr": "FD", "Value": [36.48471418, -106.56244663, 107.38447586]}, "104": {"vr": "FD", "Value": [57.4762404, -106.12280204, 106.98131371]}, "105": {"vr": "FD", "Value": [6.49681959, -107.19051032, 107.96042178]}, "106": {"vr": "FD", "Value": [102.45808229, -105.1807065, 106.11739482]}, "107": {"vr": "FD", "Value": [-87.46525015, -109.15844324, 109.76505235]}, "108": {"vr": "FD", "Value": [100.45888932, -105.22257741, 106.15579122]}, "109": {"vr": "FD", "Value": [75.46897716, -105.74596382, 106.63574615]}, "110": {"vr": "FD", "Value": [-55.47816258, -108.48850863, 109.15071003]}, "111": {"vr": "FD", "Value": [93.46171391, -105.3691256, 106.2901786]}, "112": {"vr": "FD", "Value": [15.49318796, -107.00209122, 107.78763801]}, "113": {"vr": "FD", "Value": [11.49480202, -107.08583304, 107.8644308]}, "114": {"vr": "FD", "Value": [-58.47695204, -108.551315, 109.20830462]}, "115": {"vr": "FD", "Value": [40.48310013, -106.4787048, 107.30768307]}, "116": {"vr": "FD", "Value": [-2.49954879, -107.37892943, 108.13320556]}, "117": {"vr": "FD", "Value": [-78.46888177, -108.97002413, 109.59226857]}, "118": {"vr": "FD", "Value": [-57.47735555, -108.53037954, 109.18910643]}, "119": {"vr": "FD", "Value": [49.47946851, -106.29028569, 107.13489929]}, "120": {"vr": "FD", "Value": [90.46292445, -105.43193197, 106.34777319]}, "121": {"vr": "FD", "Value": [-85.46605717, -109.11657233, 109.72665596]}, "122": {"vr": "FD", "Value": [-21.49188204, -107.77670311, 108.49797132]}, "123": {"vr": "FD", "Value": [-38.48502231, -108.13260587, 108.82434067]}, "124": {"vr": "FD", "Value": [25.48915283, -106.79273665, 107.59565603]}, "125": {"vr": "FD", "Value": [33.48592472, -106.625253, 107.44207045]}, "126": {"vr": "FD", "Value": [-54.47856609, -108.46757317, 109.13151183]}, "127": {"vr": "FD", "Value": [42.4822931, -106.43683389, 107.26928667]}, "128": {"vr": "FD", "Value": [73.46978418, -105.78783474, 106.67414255]}, "129": {"vr": "FD", "Value": [-1.49995231, -107.35799398, 108.11400736]}, "130": {"vr": "FD", "Value": [28.48794229, -106.72993028, 107.53806144]}, "131": {"vr": "FD", "Value": [-25.49026798, -107.86044493, 108.57476411]}, "132": {"vr": "FD", "Value": [43.48188959, -106.41589843, 107.25008848]}, "133": {"vr": "FD", "Value": [-81.46767123, -109.0328305, 109.64986317]}, "134": {"vr": "FD", "Value": [-49.48058366, -108.36289589, 109.03552085]}, "135": {"vr": "FD", "Value": [88.46373148, -105.47380289, 106.38616959]}, "136": {"vr": "FD", "Value": [-5.49833825, -107.4417358, 108.19080015]}, "137": {"vr": "FD", "Value": [13.49399499, -107.04396213, 107.8260344]}, "138": {"vr": "FD", "Value": [86.46453851, -105.5156738, 106.42456598]}, "139": {"vr": "FD", "Value": [19.49157391, -106.91834939, 107.71084522]}, "140": {"vr": "FD", "Value": [-15.49430312, -107.65109037, 108.38278213]}, "141": {"vr": "FD", "Value": [23.48995986, -106.83460756, 107.63405243]}, "142": {"vr": "FD", "Value": [-43.48300474, -108.23728315, 108.92033166]}, "143": {"vr": "FD", "Value": [68.47180175, -105.89251202, 106.77013354]}, "144": {"vr": "FD", "Value": [-53.47896961, -108.44663772, 109.11231364]}, "145": {"vr": "FD", "Value": [69.47139824, -105.87157656, 106.75093534]}, "146": {"vr": "FD", "Value": [62.47422283, -106.01812476, 106.88532272]}, "147": {"vr": "FD", "Value": [96.46050337, -105.30631924, 106.23258401]}, "148": {"vr": "FD", "Value": [32.48632824, -106.64618845, 107.46126865]}, "149": {"vr": "FD", "Value": [-18.49309258, -107.71389674, 108.44037672]}, "150": {"vr": "FD", "Value": [-24.4906715, -107.83950948, 108.55556591]}, "151": {"vr": "FD", "Value": [-46.4817942, -108.30008952, 108.97792625]}, "152": {"vr": "FD", "Value": [-79.46847826, -108.99095959, 109.61146677]}, "153": {"vr": "FD", "Value": [94.4613104, -105.34819015, 106.2709804]}, "154": {"vr": "FD", "Value": [7.49641607, -107.16957487, 107.94122359]}, "155": {"vr": "FD", "Value": [84.46534553, -105.55754471, 106.46296238]}, "156": {"vr": "FD", "Value": [26.48874932, -106.77180119, 107.57645783]}, "157": {"vr": "FD", "Value": [-86.46565366, -109.13750778, 109.74585416]}, "158": {"vr": "FD", "Value": [-84.46646069, -109.09563687, 109.70745776]}, "159": {"vr": "FD", "Value": [1.49883715, -107.29518761, 108.05641277]}, "160": {"vr": "FD", "Value": [-68.4729169, -108.76066957, 109.4002866]}, "161": {"vr": "FD", "Value": [-80.46807474, -109.01189504, 109.63066497]}, "162": {"vr": "FD", "Value": [-29.48865393, -107.94418676, 108.6515569]}, "163": {"vr": "FD", "Value": [-23.49107501, -107.81857402, 108.53636771]}, "164": {"vr": "FD", "Value": [-82.46726772, -109.05376596, 109.66906136]}, "165": {"vr": "FD", "Value": [60.47502986, -106.05999567, 106.92371912]}, "166": {"vr": "FD", "Value": [-75.47009231, -108.90721776, 109.53467398]}, "167": {"vr": "FD", "Value": [-39.48461879, -108.15354133, 108.84353887]}, "168": {"vr": "FD", "Value": [82.46615256, -105.59941563, 106.50135877]}, "169": {"vr": "FD", "Value": [-8.49712771, -107.50454217, 108.24839475]}, "170": {"vr": "FD", "Value": [-48.48098717, -108.34196044, 109.01632265]}, "171": {"vr": "FD", "Value": [-61.4757415, -108.61412137, 109.26589922]}, "172": {"vr": "FD", "Value": [70.47099472, -105.85064111, 106.73173714]}, "173": {"vr": "FD", "Value": [8.49601256, -107.14863941, 107.92202539]}, "174": {"vr": "FD", "Value": [-64.47453096, -108.67692774, 109.32349381]}, "175": {"vr": "FD", "Value": [-33.48703988, -108.02792859, 108.72834969]}, "176": {"vr": "FD", "Value": [-6.49793474, -107.46267126, 108.20999835]}, "177": {"vr": "FD", "Value": [56.47664391, -106.1437375, 107.00051191]}, "178": {"vr": "FD", "Value": [72.4701877, -105.80877019, 106.69334075]}, "179": {"vr": "FD", "Value": [98.45969635, -105.26444832, 106.19418761]}, "180": {"vr": "FD", "Value": [-67.47332042, -108.73973411, 109.3810884]}, "181": {"vr": "FD", "Value": [-19.49268906, -107.7348322, 108.45957492]}, "182": {"vr": "FD", "Value": [-3.49914528, -107.39986489, 108.15240376]}, "183": {"vr": "FD", "Value": [-26.48986447, -107.88138039, 108.5939623]}, "184": {"vr": "FD", "Value": [46.48067905, -106.35309206, 107.19249388]}, "185": {"vr": "FD", "Value": [78.46776662, -105.68315745, 106.57815156]}, "186": {"vr": "FD", "Value": [64.4734158, -105.97625384, 106.84692633]}, "187": {"vr": "FD", "Value": [-9.4967242, -107.52547763, 108.26759294]}, "188": {"vr": "FD", "Value": [27.4883458, -106.75086574, 107.55725964]}, "189": {"vr": "FD", "Value": [-14.49470663, -107.63015491, 108.36358393]}, "190": {"vr": "FD", "Value": [101.45848581, -105.20164195, 106.13659302]}, "191": {"vr": "FD", "Value": [76.46857364, -105.72502837, 106.61654796]}}, "00200013": {"0": {"vr": "IS", "Value": [84]}, "1": {"vr": "IS", "Value": [144]}, "2": {"vr": "IS", "Value": [11]}, "3": {"vr": "IS", "Value": [147]}, "4": {"vr": "IS", "Value": [78]}, "5": {"vr": "IS", "Value": [111]}, "6": {"vr": "IS", "Value": [52]}, "7": {"vr": "IS", "Value": [41]}, "8": {"vr": "IS", "Value": [98]}, "9": {"vr": "IS", "Value": [142]}, "10": {"vr": "IS", "Value": [150]}, "11": {"vr": "IS", "Value": [160]}, "12": {"vr": "IS", "Value": [180]}, "13": {"vr": "IS", "Value": [15]}, "14": {"vr": "IS", "Value": [91]}, "15": {"vr": "IS", "Value": [118]}, "16": {"vr": "IS", "Value": [19]}, "17": {"vr": "IS", "Value": [188]}, "18": {"vr": "IS", "Value": [16]}, "19": {"vr": "IS", "Value": [28]}, "20": {"vr": "IS", "Value": [103]}, "21": {"vr": "IS", "Value": [192]}, "22": {"vr": "IS", "Value": [181]}, "23": {"vr": "IS", "Value": [99]}, "24": {"vr": "IS", "Value": [152]}, "25": {"vr": "IS", "Value": [60]}, "26": {"vr": "IS", "Value": [128]}, "27": {"vr": "IS", "Value": [126]}, "28": {"vr": "IS", "Value": [136]}, "29": {"vr": "IS", "Value": [68]}, "30": {"vr": "IS", "Value": [17]}, "31": {"vr": "IS", "Value": [137]}, "32": {"vr": "IS", "Value": [93]}, "33": {"vr": "IS", "Value": [18]}, "34": {"vr": "IS", "Value": [170]}, "35": {"vr": "IS", "Value": [172]}, "36": {"vr": "IS", "Value": [106]}, "37": {"vr": "IS", "Value": [134]}, "38": {"vr": "IS", "Value": [113]}, "39": {"vr": "IS", "Value": [47]}, "40": {"vr": "IS", "Value": [44]}, "41": {"vr": "IS", "Value": [105]}, "42": {"vr": "IS", "Value": [32]}, "43": {"vr": "IS", "Value": [75]}, "44": {"vr": "IS", "Value": [14]}, "45": {"vr": "IS", "Value": [141]}, "46": {"vr": "IS", "Value": [71]}, "47": {"vr": "IS", "Value": [143]}, "48": {"vr": "IS", "Value": [139]}, "49": {"vr": "IS", "Value": [140]}, "50": {"vr": "IS", "Value": [81]}, "51": {"vr": "IS", "Value": [154]}, "52": {"vr": "IS", "Value": [94]}, "53": {"vr": "IS", "Value": [156]}, "54": {"vr": "IS", "Value": [109]}, "55": {"vr": "IS", "Value": [169]}, "56": {"vr": "IS", "Value": [178]}, "57": {"vr": "IS", "Value": [176]}, "58": {"vr": "IS", "Value": [92]}, "59": {"vr": "IS", "Value": [29]}, "60": {"vr": "IS", "Value": [130]}, "61": {"vr": "IS", "Value": [5]}, "62": {"vr": "IS", "Value": [26]}, "63": {"vr": "IS", "Value": [72]}, "64": {"vr": "IS", "Value": [57]}, "65": {"vr": "IS", "Value": [166]}, "66": {"vr": "IS", "Value": [56]}, "67": {"vr": "IS", "Value": [48]}, "68": {"vr": "IS", "Value": [148]}, "69": {"vr": "IS", "Value": [168]}, "70": {"vr": "IS", "Value": [133]}, "71": {"vr": "IS", "Value": [123]}, "72": {"vr": "IS", "Value": [22]}, "73": {"vr": "IS", "Value": [186]}, "74": {"vr": "IS", "Value": [88]}, "75": {"vr": "IS", "Value": [120]}, "76": {"vr": "IS", "Value": [76]}, "77": {"vr": "IS", "Value": [54]}, "78": {"vr": "IS", "Value": [110]}, "79": {"vr": "IS", "Value": [119]}, "80": {"vr": "IS", "Value": [37]}, "81": {"vr": "IS", "Value": [23]}, "82": {"vr": "IS", "Value": [66]}, "83": {"vr": "IS", "Value": [36]}, "84": {"vr": "IS", "Value": [163]}, "85": {"vr": "IS", "Value": [127]}, "86": {"vr": "IS", "Value": [124]}, "87": {"vr": "IS", "Value": [25]}, "88": {"vr": "IS", "Value": [53]}, "89": {"vr": "IS", "Value": [43]}, "90": {"vr": "IS", "Value": [58]}, "91": {"vr": "IS", "Value": [51]}, "92": {"vr": "IS", "Value": [77]}, "93": {"vr": "IS", "Value": [174]}, "94": {"vr": "IS", "Value": [46]}, "95": {"vr": "IS", "Value": [155]}, "96": {"vr": "IS", "Value": [38]}, "97": {"vr": "IS", "Value": [61]}, "98": {"vr": "IS", "Value": [89]}, "99": {"vr": "IS", "Value": [107]}, "100": {"vr": "IS", "Value": [184]}, "101": {"vr": "IS", "Value": [101]}, "102": {"vr": "IS", "Value": [12]}, "103": {"vr": "IS", "Value": [125]}, "104": {"vr": "IS", "Value": [146]}, "105": {"vr": "IS", "Value": [95]}, "106": {"vr": "IS", "Value": [191]}, "107": {"vr": "IS", "Value": [1]}, "108": {"vr": "IS", "Value": [189]}, "109": {"vr": "IS", "Value": [164]}, "110": {"vr": "IS", "Value": [33]}, "111": {"vr": "IS", "Value": [182]}, "112": {"vr": "IS", "Value": [104]}, "113": {"vr": "IS", "Value": [100]}, "114": {"vr": "IS", "Value": [30]}, "115": {"vr": "IS", "Value": [129]}, "116": {"vr": "IS", "Value": [86]}, "117": {"vr": "IS", "Value": [10]}, "118": {"vr": "IS", "Value": [31]}, "119": {"vr": "IS", "Value": [138]}, "120": {"vr": "IS", "Value": [179]}, "121": {"vr": "IS", "Value": [3]}, "122": {"vr": "IS", "Value": [67]}, "123": {"vr": "IS", "Value": [50]}, "124": {"vr": "IS", "Value": [114]}, "125": {"vr": "IS", "Value": [122]}, "126": {"vr": "IS", "Value": [34]}, "127": {"vr": "IS", "Value": [131]}, "128": {"vr": "IS", "Value": [162]}, "129": {"vr": "IS", "Value": [87]}, "130": {"vr": "IS", "Value": [117]}, "131": {"vr": "IS", "Value": [63]}, "132": {"vr": "IS", "Value": [132]}, "133": {"vr": "IS", "Value": [7]}, "134": {"vr": "IS", "Value": [39]}, "135": {"vr": "IS", "Value": [177]}, "136": {"vr": "IS", "Value": [83]}, "137": {"vr": "IS", "Value": [102]}, "138": {"vr": "IS", "Value": [175]}, "139": {"vr": "IS", "Value": [108]}, "140": {"vr": "IS", "Value": [73]}, "141": {"vr": "IS", "Value": [112]}, "142": {"vr": "IS", "Value": [45]}, "143": {"vr": "IS", "Value": [157]}, "144": {"vr": "IS", "Value": [35]}, "145": {"vr": "IS", "Value": [158]}, "146": {"vr": "IS", "Value": [151]}, "147": {"vr": "IS", "Value": [185]}, "148": {"vr": "IS", "Value": [121]}, "149": {"vr": "IS", "Value": [70]}, "150": {"vr": "IS", "Value": [64]}, "151": {"vr": "IS", "Value": [42]}, "152": {"vr": "IS", "Value": [9]}, "153": {"vr": "IS", "Value": [183]}, "154": {"vr": "IS", "Value": [96]}, "155": {"vr": "IS", "Value": [173]}, "156": {"vr": "IS", "Value": [115]}, "157": {"vr": "IS", "Value": [2]}, "158": {"vr": "IS", "Value": [4]}, "159": {"vr": "IS", "Value": [90]}, "160": {"vr": "IS", "Value": [20]}, "161": {"vr": "IS", "Value": [8]}, "162": {"vr": "IS", "Value": [59]}, "163": {"vr": "IS", "Value": [65]}, "164": {"vr": "IS", "Value": [6]}, "165": {"vr": "IS", "Value": [149]}, "166": {"vr": "IS", "Value": [13]}, "167": {"vr": "IS", "Value": [49]}, "168": {"vr": "IS", "Value": [171]}, "169": {"vr": "IS", "Value": [80]}, "170": {"vr": "IS", "Value": [40]}, "171": {"vr": "IS", "Value": [27]}, "172": {"vr": "IS", "Value": [159]}, "173": {"vr": "IS", "Value": [97]}, "174": {"vr": "IS", "Value": [24]}, "175": {"vr": "IS", "Value": [55]}, "176": {"vr": "IS", "Value": [82]}, "177": {"vr": "IS", "Value": [145]}, "178": {"vr": "IS", "Value": [161]}, "179": {"vr": "IS", "Value": [187]}, "180": {"vr": "IS", "Value": [21]}, "181": {"vr": "IS", "Value": [69]}, "182": {"vr": "IS", "Value": [85]}, "183": {"vr": "IS", "Value": [62]}, "184": {"vr": "IS", "Value": [135]}, "185": {"vr": "IS", "Value": [167]}, "186": {"vr": "IS", "Value": [153]}, "187": {"vr": "IS", "Value": [79]}, "188": {"vr": "IS", "Value": [116]}, "189": {"vr": "IS", "Value": [74]}, "190": {"vr": "IS", "Value": [190]}, "191": {"vr": "IS", "Value": [165]}}, "00200032": {"0": {"vr": "DS", "Value": [-4.4987417663437, -107.42080034695, 108.17160195729]}, "1": {"vr": "DS", "Value": [55.477047425076, -106.1646729539, 107.01971010526]}, "2": {"vr": "DS", "Value": [-77.469285282571, -108.94908867516, 109.57307037727]}, "3": {"vr": "DS", "Value": [58.475836884647, -106.10186658424, 106.96211551266]}, "4": {"vr": "DS", "Value": [-10.496320685486, -107.54641308625, 108.2867911425]}, "5": {"vr": "DS", "Value": [22.490363369795, -106.85554302007, 107.65325062388]}, "6": {"vr": "DS", "Value": [-36.485829335101, -108.09073495657, 108.78594427838]}, "7": {"vr": "DS", "Value": [-47.481390686861, -108.32102497863, 108.99712445125]}, "8": {"vr": "DS", "Value": [9.4956090449876, -107.12770395524, 107.90282719182]}, "9": {"vr": "DS", "Value": [53.477854452029, -106.206543867, 107.05810650033]}, "10": {"vr": "DS", "Value": [61.474626344218, -106.03906021459, 106.90452092006]}, "11": {"vr": "DS", "Value": [71.470591209455, -105.82970564908, 106.71253894472]}, "12": {"vr": "DS", "Value": [91.462520939928, -105.41099651807, 106.32857499404]}, "13": {"vr": "DS", "Value": [-73.470899336477, -108.86534684896, 109.49627758713]}, "14": {"vr": "DS", "Value": [2.4984336393219, -107.27425215109, 108.03721457456]}, "15": {"vr": "DS", "Value": [29.487538775461, -106.70899482422, 107.51886324114]}, "16": {"vr": "DS", "Value": [-69.472513390382, -108.78160502275, 109.419484797]}, "17": {"vr": "DS", "Value": [99.459292832118, -105.24351286566, 106.17498941377]}, "18": {"vr": "DS", "Value": [-72.471302849953, -108.8444113924, 109.4770793896]}, "19": {"vr": "DS", "Value": [-60.476145011669, -108.59318591379, 109.24670101919]}, "20": {"vr": "DS", "Value": [14.493591477606, -107.02302667248, 107.80683620415]}, "21": {"vr": "DS", "Value": [103.45767877821, -105.15977103946, 106.09819662364]}, "22": {"vr": "DS", "Value": [92.462117426452, -105.39006106151, 106.30937679651]}, "23": {"vr": "DS", "Value": [10.495205531511, -107.10676849868, 107.88362899429]}, "24": {"vr": "DS", "Value": [63.473819317266, -105.99718930149, 106.86612452499]}, "25": {"vr": "DS", "Value": [-28.489057442912, -107.92325130417, 108.63235869811]}, "26": {"vr": "DS", "Value": [39.483503640698, -106.49964025871, 107.3268812658]}, "27": {"vr": "DS", "Value": [37.48431066765, -106.54151117181, 107.36527766087]}, "28": {"vr": "DS", "Value": [47.480275532887, -106.3321566063, 107.17329568553]}, "29": {"vr": "DS", "Value": [-20.492285550722, -107.75576765176, 108.47877311784]}, "30": {"vr": "DS", "Value": [-71.471706363429, -108.82347593585, 109.45788119206]}, "31": {"vr": "DS", "Value": [48.479872019411, -106.31122114975, 107.154097488]}, "32": {"vr": "DS", "Value": [4.4976266123693, -107.23238123799, 107.99881817949]}, "33": {"vr": "DS", "Value": [-70.472109876906, -108.8025404793, 109.43868299453]}, "34": {"vr": "DS", "Value": [81.466556074692, -105.62035108357, 106.52055696938]}, "35": {"vr": "DS", "Value": [83.465749047739, -105.57848017047, 106.48216057431]}, "36": {"vr": "DS", "Value": [17.492380937177, -106.96022030283, 107.74924161155]}, "37": {"vr": "DS", "Value": [45.48108255984, -106.3740275194, 107.2116920806]}, "38": {"vr": "DS", "Value": [24.489556342843, -106.81367210697, 107.61485422881]}, "39": {"vr": "DS", "Value": [-41.483811767719, -108.19541223933, 108.88193526605]}, "40": {"vr": "DS", "Value": [-44.48260122729, -108.25821860898, 108.93952985865]}, "41": {"vr": "DS", "Value": [16.492784450653, -106.98115575938, 107.76843980908]}, "42": {"vr": "DS", "Value": [-56.477759065574, -108.50944408759, 109.16990822906]}, "43": {"vr": "DS", "Value": [-13.495110145057, -107.6092194559, 108.3443857351]}, "44": {"vr": "DS", "Value": [-74.470495823, -108.88628230551, 109.51547578467]}, "45": {"vr": "DS", "Value": [52.478257965505, -106.22747932355, 107.07730469786]}, "46": {"vr": "DS", "Value": [-17.493496091151, -107.69296128211, 108.42117852524]}, "47": {"vr": "DS", "Value": [54.477450938553, -106.18560841045, 107.0389083028]}, "48": {"vr": "DS", "Value": [50.479064992458, -106.26935023665, 107.11570109293]}, "49": {"vr": "DS", "Value": [51.478661478982, -106.2484147801, 107.0965028954]}, "50": {"vr": "DS", "Value": [-7.4975312259147, -107.4836067166, 108.2291965499]}, "51": {"vr": "DS", "Value": [65.473012290313, -105.95531838839, 106.82772812992]}, "52": {"vr": "DS", "Value": [5.4972230988929, -107.21144578144, 107.97961998196]}, "53": {"vr": "DS", "Value": [67.47220526336, -105.91344747529, 106.78933173486]}, "54": {"vr": "DS", "Value": [20.491170396748, -106.89741393318, 107.69164701895]}, "55": {"vr": "DS", "Value": [80.466959588168, -105.64128654012, 106.53975516692]}, "56": {"vr": "DS", "Value": [89.463327966881, -105.45286743117, 106.36697138911]}, "57": {"vr": "DS", "Value": [87.464134993834, -105.49473834427, 106.40536778418]}, "58": {"vr": "DS", "Value": [3.4980301258456, -107.25331669454, 108.01801637702]}, "59": {"vr": "DS", "Value": [-59.476548525145, -108.57225045724, 109.22750282166]}, "60": {"vr": "DS", "Value": [41.482696613745, -106.45776934561, 107.28848487074]}, "61": {"vr": "DS", "Value": [-83.466864201713, -109.07470141446, 109.68825956247]}, "62": {"vr": "DS", "Value": [-62.475337984716, -108.6350568269, 109.28509741426]}, "63": {"vr": "DS", "Value": [-16.493899604628, -107.67202582556, 108.4019803277]}, "64": {"vr": "DS", "Value": [-31.487846902483, -107.98605767382, 108.68995329071]}, "65": {"vr": "DS", "Value": [77.468170128597, -105.70409290978, 106.59734975952]}, "66": {"vr": "DS", "Value": [-32.487443389006, -108.00699313037, 108.70915148824]}, "67": {"vr": "DS", "Value": [-40.484215281196, -108.17447678278, 108.86273706851]}, "68": {"vr": "DS", "Value": [59.475433371171, -106.08093112769, 106.94291731513]}, "69": {"vr": "DS", "Value": [79.467363101644, -105.66222199668, 106.55895336445]}, "70": {"vr": "DS", "Value": [44.481486073316, -106.39496297596, 107.23089027813]}, "71": {"vr": "DS", "Value": [34.485521208079, -106.60431754146, 107.42287225347]}, "72": {"vr": "DS", "Value": [-66.473723930811, -108.7187986531, 109.36189020439]}, "73": {"vr": "DS", "Value": [97.46009985907, -105.28538377876, 106.21338580884]}, "74": {"vr": "DS", "Value": [-0.5003558202491, -107.33705852074, 108.09480916716]}, "75": {"vr": "DS", "Value": [31.486731748508, -106.66712391112, 107.48046684608]}, "76": {"vr": "DS", "Value": [-12.495513658533, -107.58828399935, 108.32518753757]}, "77": {"vr": "DS", "Value": [-34.486636362054, -108.04886404347, 108.74754788331]}, "78": {"vr": "DS", "Value": [21.490766883272, -106.87647847662, 107.67244882141]}, "79": {"vr": "DS", "Value": [30.487135261985, -106.68805936767, 107.49966504361]}, "80": {"vr": "DS", "Value": [-51.479776632956, -108.40476680484, 109.07391724139]}, "81": {"vr": "DS", "Value": [-65.474127444287, -108.69786319655, 109.34269200686]}, "82": {"vr": "DS", "Value": [-22.49147852377, -107.79763856486, 108.5171695129]}, "83": {"vr": "DS", "Value": [-52.47937311948, -108.42570226139, 109.09311543892]}, "84": {"vr": "DS", "Value": [74.469380669026, -105.76689927943, 106.65494435212]}, "85": {"vr": "DS", "Value": [38.483907154174, -106.52057571526, 107.34607946334]}, "86": {"vr": "DS", "Value": [35.485117694603, -106.58338208491, 107.40367405594]}, "87": {"vr": "DS", "Value": [-63.47493447124, -108.65599228345, 109.30429561179]}, "88": {"vr": "DS", "Value": [-35.486232848577, -108.06979950002, 108.76674608084]}, "89": {"vr": "DS", "Value": [-45.482197713814, -108.27915406553, 108.95872805618]}, "90": {"vr": "DS", "Value": [-30.488250415959, -107.96512221727, 108.67075509318]}, "91": {"vr": "DS", "Value": [-37.485425821625, -108.11167041312, 108.80514247591]}, "92": {"vr": "DS", "Value": [-11.495917172009, -107.5673485428, 108.30598934003]}, "93": {"vr": "DS", "Value": [85.464942020786, -105.53660925737, 106.44376417925]}, "94": {"vr": "DS", "Value": [-42.483408254243, -108.21634769588, 108.90113346358]}, "95": {"vr": "DS", "Value": [66.472608776837, -105.93438293184, 106.80852993239]}, "96": {"vr": "DS", "Value": [-50.480180146432, -108.38383134829, 109.05471904385]}, "97": {"vr": "DS", "Value": [-27.489460956388, -107.90231584762, 108.61316050057]}, "98": {"vr": "DS", "Value": [0.4992406662746, -107.31612306419, 108.07561096963]}, "99": {"vr": "DS", "Value": [18.491977423701, -106.93928484628, 107.73004341402]}, "100": {"vr": "DS", "Value": [95.460906886023, -105.32725469186, 106.25178220391]}, "101": {"vr": "DS", "Value": [12.494398504559, -107.06489758558, 107.84523259922]}, "102": {"vr": "DS", "Value": [-76.469688796048, -108.92815321861, 109.55387217973]}, "103": {"vr": "DS", "Value": [36.484714181127, -106.56244662836, 107.38447585841]}, "104": {"vr": "DS", "Value": [57.476240398124, -106.12280204079, 106.98131371019]}, "105": {"vr": "DS", "Value": [6.4968195854166, -107.19051032489, 107.96042178442]}, "106": {"vr": "DS", "Value": [102.45808229169, -105.18070649601, 106.11739482117]}, "107": {"vr": "DS", "Value": [-87.465250147808, -109.15844324067, 109.76505235261]}, "108": {"vr": "DS", "Value": [100.45888931864, -105.22257740911, 106.15579121624]}, "109": {"vr": "DS", "Value": [75.46897715555, -105.74596382288, 106.63574615458]}, "110": {"vr": "DS", "Value": [-55.478162579051, -108.48850863104, 109.15071003152]}, "111": {"vr": "DS", "Value": [93.461713912976, -105.36912560496, 106.29017859898]}, "112": {"vr": "DS", "Value": [15.49318796413, -107.00209121593, 107.78763800662]}, "113": {"vr": "DS", "Value": [11.494802018035, -107.08583304213, 107.86443079675]}, "114": {"vr": "DS", "Value": [-58.476952038622, -108.55131500069, 109.20830462412]}, "115": {"vr": "DS", "Value": [40.483100127221, -106.47870480216, 107.30768306827]}, "116": {"vr": "DS", "Value": [-2.4995487932964, -107.37892943385, 108.13320556223]}, "117": {"vr": "DS", "Value": [-78.468881769095, -108.97002413171, 109.5922685748]}, "118": {"vr": "DS", "Value": [-57.477355552098, -108.53037954414, 109.18910642659]}, "119": {"vr": "DS", "Value": [49.479468505934, -106.2902856932, 107.13489929047]}, "120": {"vr": "DS", "Value": [90.462924453405, -105.43193197462, 106.34777319158]}, "121": {"vr": "DS", "Value": [-85.466057174761, -109.11657232757, 109.72665595754]}, "122": {"vr": "DS", "Value": [-21.491882037246, -107.77670310831, 108.49797131537]}, "123": {"vr": "DS", "Value": [-38.485022308148, -108.13260586968, 108.82434067345]}, "124": {"vr": "DS", "Value": [25.489152829366, -106.79273665042, 107.59565603128]}, "125": {"vr": "DS", "Value": [33.485924721556, -106.62525299801, 107.44207045101]}, "126": {"vr": "DS", "Value": [-54.478566092527, -108.46757317449, 109.13151183399]}, "127": {"vr": "DS", "Value": [42.482293100269, -106.43683388906, 107.2692866732]}, "128": {"vr": "DS", "Value": [73.469784182502, -105.78783473598, 106.67414254965]}, "129": {"vr": "DS", "Value": [-1.4999523067727, -107.35799397729, 108.11400736469]}, "130": {"vr": "DS", "Value": [28.487942288937, -106.72993028077, 107.53806143868]}, "131": {"vr": "DS", "Value": [-25.490267983341, -107.86044493451, 108.57476410551]}, "132": {"vr": "DS", "Value": [43.481889586792, -106.41589843251, 107.25008847567]}, "133": {"vr": "DS", "Value": [-81.467671228666, -109.03283050136, 109.6498631674]}, "134": {"vr": "DS", "Value": [-49.480583659909, -108.36289589174, 109.03552084632]}, "135": {"vr": "DS", "Value": [88.463731480357, -105.47380288772, 106.38616958664]}, "136": {"vr": "DS", "Value": [-5.4983382528674, -107.4417358035, 108.19080015483]}, "137": {"vr": "DS", "Value": [13.493994991082, -107.04396212903, 107.82603440168]}, "138": {"vr": "DS", "Value": [86.46453850731, -105.51567380082, 106.42456598171]}, "139": {"vr": "DS", "Value": [19.491573910224, -106.91834938973, 107.71084521648]}, "140": {"vr": "DS", "Value": [-15.494303118104, -107.65109036901, 108.38278213017]}, "141": {"vr": "DS", "Value": [23.489959856319, -106.83460756352, 107.63405242635]}, "142": {"vr": "DS", "Value": [-43.483004740767, -108.23728315243, 108.92033166112]}, "143": {"vr": "DS", "Value": [68.471801749884, -105.89251201873, 106.77013353732]}, "144": {"vr": "DS", "Value": [-53.478969606003, -108.44663771794, 109.11231363645]}, "145": {"vr": "DS", "Value": [69.471398236408, -105.87157656218, 106.75093533979]}, "146": {"vr": "DS", "Value": [62.474222830742, -106.01812475804, 106.88532272253]}, "147": {"vr": "DS", "Value": [96.460503372547, -105.30631923531, 106.23258400637]}, "148": {"vr": "DS", "Value": [32.486328235032, -106.64618845457, 107.46126864854]}, "149": {"vr": "DS", "Value": [-18.493092577675, -107.71389673866, 108.44037672277]}, "150": {"vr": "DS", "Value": [-24.490671496817, -107.83950947796, 108.55556590797]}, "151": {"vr": "DS", "Value": [-46.481794200338, -108.30008952208, 108.97792625372]}, "152": {"vr": "DS", "Value": [-79.468478255619, -108.99095958826, 109.61146677234]}, "153": {"vr": "DS", "Value": [94.461310399499, -105.34819014841, 106.27098040144]}, "154": {"vr": "DS", "Value": [7.4964160719403, -107.16957486834, 107.94122358689]}, "155": {"vr": "DS", "Value": [84.465345534263, -105.55754471392, 106.46296237678]}, "156": {"vr": "DS", "Value": [26.48874931589, -106.77180119387, 107.57645783374]}, "157": {"vr": "DS", "Value": [-86.465653661284, -109.13750778412, 109.74585415507]}, "158": {"vr": "DS", "Value": [-84.466460688237, -109.09563687101, 109.70745776]}, "159": {"vr": "DS", "Value": [1.4988371527983, -107.29518760764, 108.05641277209]}, "160": {"vr": "DS", "Value": [-68.472916903858, -108.7606695662, 109.40028659946]}, "161": {"vr": "DS", "Value": [-80.468074742142, -109.01189504481, 109.63066496987]}, "162": {"vr": "DS", "Value": [-29.488653929435, -107.94418676072, 108.65155689564]}, "163": {"vr": "DS", "Value": [-23.491075010293, -107.81857402141, 108.53636771044]}, "164": {"vr": "DS", "Value": [-82.46726771519, -109.05376595791, 109.66906136494]}, "165": {"vr": "DS", "Value": [60.475029857695, -106.05999567114, 106.92371911759]}, "166": {"vr": "DS", "Value": [-75.470092309524, -108.90721776206, 109.5346739822]}, "167": {"vr": "DS", "Value": [-39.484618794672, -108.15354132623, 108.84353887098]}, "168": {"vr": "DS", "Value": [82.466152561215, -105.59941562702, 106.50135877185]}, "169": {"vr": "DS", "Value": [-8.4971277124384, -107.50454217315, 108.24839474743]}, "170": {"vr": "DS", "Value": [-48.480987173385, -108.34196043518, 109.01632264879]}, "171": {"vr": "DS", "Value": [-61.475741498193, -108.61412137035, 109.26589921673]}, "172": {"vr": "DS", "Value": [70.470994722931, -105.85064110563, 106.73173714225]}, "173": {"vr": "DS", "Value": [8.4960125584639, -107.14863941179, 107.92202538935]}, "174": {"vr": "DS", "Value": [-64.474530957764, -108.67692774, 109.32349380933]}, "175": {"vr": "DS", "Value": [-33.48703987553, -108.02792858692, 108.72834968578]}, "176": {"vr": "DS", "Value": [-6.4979347393911, -107.46267126005, 108.20999835236]}, "177": {"vr": "DS", "Value": [56.4766439116, -106.14373749735, 107.00051190773]}, "178": {"vr": "DS", "Value": [72.470187695979, -105.80877019253, 106.69334074719]}, "179": {"vr": "DS", "Value": [98.459696345594, -105.26444832221, 106.19418761131]}, "180": {"vr": "DS", "Value": [-67.473320417335, -108.73973410965, 109.38108840193]}, "181": {"vr": "DS", "Value": [-19.492689064199, -107.73483219521, 108.4595749203]}, "182": {"vr": "DS", "Value": [-3.4991452798201, -107.3998648904, 108.15240375976]}, "183": {"vr": "DS", "Value": [-26.489864469864, -107.88138039107, 108.59396230304]}, "184": {"vr": "DS", "Value": [46.480679046363, -106.35309206285, 107.19249388307]}, "185": {"vr": "DS", "Value": [78.467766615121, -105.68315745323, 106.57815156198]}, "186": {"vr": "DS", "Value": [64.473415803789, -105.97625384494, 106.84692632746]}, "187": {"vr": "DS", "Value": [-9.4967241989621, -107.5254776297, 108.26759294496]}, "188": {"vr": "DS", "Value": [27.488345802414, -106.75086573732, 107.55725963621]}, "189": {"vr": "DS", "Value": [-14.49470663158, -107.63015491246, 108.36358393263]}, "190": {"vr": "DS", "Value": [101.45848580516, -105.20164195256, 106.1365930187]}, "191": {"vr": "DS", "Value": [76.468573642073, -105.72502836633, 106.61654795705]}}, "00201041": {"0": {"vr": "DS", "Value": [-8.8225297436671]}, "1": {"vr": "DS", "Value": [51.177470256333]}, "2": {"vr": "DS", "Value": [-81.822529743667]}, "3": {"vr": "DS", "Value": [54.177470256333]}, "4": {"vr": "DS", "Value": [-14.822529743667]}, "5": {"vr": "DS", "Value": [18.177470256333]}, "6": {"vr": "DS", "Value": [-40.822529743667]}, "7": {"vr": "DS", "Value": [-51.822529743667]}, "8": {"vr": "DS", "Value": [5.1774702563329]}, "9": {"vr": "DS", "Value": [49.177470256333]}, "10": {"vr": "DS", "Value": [57.177470256333]}, "11": {"vr": "DS", "Value": [67.177470256333]}, "12": {"vr": "DS", "Value": [87.177470256333]}, "13": {"vr": "DS", "Value": [-77.822529743667]}, "14": {"vr": "DS", "Value": [-1.8225297436671]}, "15": {"vr": "DS", "Value": [25.177470256333]}, "16": {"vr": "DS", "Value": [-73.822529743667]}, "17": {"vr": "DS", "Value": [95.177470256333]}, "18": {"vr": "DS", "Value": [-76.822529743667]}, "19": {"vr": "DS", "Value": [-64.822529743667]}, "20": {"vr": "DS", "Value": [10.177470256333]}, "21": {"vr": "DS", "Value": [99.177470256333]}, "22": {"vr": "DS", "Value": [88.177470256333]}, "23": {"vr": "DS", "Value": [6.1774702563329]}, "24": {"vr": "DS", "Value": [59.177470256333]}, "25": {"vr": "DS", "Value": [-32.822529743667]}, "26": {"vr": "DS", "Value": [35.177470256333]}, "27": {"vr": "DS", "Value": [33.177470256333]}, "28": {"vr": "DS", "Value": [43.177470256333]}, "29": {"vr": "DS", "Value": [-24.822529743667]}, "30": {"vr": "DS", "Value": [-75.822529743667]}, "31": {"vr": "DS", "Value": [44.177470256333]}, "32": {"vr": "DS", "Value": [0.17747025633286]}, "33": {"vr": "DS", "Value": [-74.822529743667]}, "34": {"vr": "DS", "Value": [77.177470256333]}, "35": {"vr": "DS", "Value": [79.177470256333]}, "36": {"vr": "DS", "Value": [13.177470256333]}, "37": {"vr": "DS", "Value": [41.177470256333]}, "38": {"vr": "DS", "Value": [20.177470256333]}, "39": {"vr": "DS", "Value": [-45.822529743667]}, "40": {"vr": "DS", "Value": [-48.822529743667]}, "41": {"vr": "DS", "Value": [12.177470256333]}, "42": {"vr": "DS", "Value": [-60.822529743667]}, "43": {"vr": "DS", "Value": [-17.822529743667]}, "44": {"vr": "DS", "Value": [-78.822529743667]}, "45": {"vr": "DS", "Value": [48.177470256333]}, "46": {"vr": "DS", "Value": [-21.822529743667]}, "47": {"vr": "DS", "Value": [50.177470256333]}, "48": {"vr": "DS", "Value": [46.177470256333]}, "49": {"vr": "DS", "Value": [47.177470256333]}, "50": {"vr": "DS", "Value": [-11.822529743667]}, "51": {"vr": "DS", "Value": [61.177470256333]}, "52": {"vr": "DS", "Value": [1.1774702563329]}, "53": {"vr": "DS", "Value": [63.177470256333]}, "54": {"vr": "DS", "Value": [16.177470256333]}, "55": {"vr": "DS", "Value": [76.177470256333]}, "56": {"vr": "DS", "Value": [85.177470256333]}, "57": {"vr": "DS", "Value": [83.177470256333]}, "58": {"vr": "DS", "Value": [-0.8225297436671]}, "59": {"vr": "DS", "Value": [-63.822529743667]}, "60": {"vr": "DS", "Value": [37.177470256333]}, "61": {"vr": "DS", "Value": [-87.822529743667]}, "62": {"vr": "DS", "Value": [-66.822529743667]}, "63": {"vr": "DS", "Value": [-20.822529743667]}, "64": {"vr": "DS", "Value": [-35.822529743667]}, "65": {"vr": "DS", "Value": [73.177470256333]}, "66": {"vr": "DS", "Value": [-36.822529743667]}, "67": {"vr": "DS", "Value": [-44.822529743667]}, "68": {"vr": "DS", "Value": [55.177470256333]}, "69": {"vr": "DS", "Value": [75.177470256333]}, "70": {"vr": "DS", "Value": [40.177470256333]}, "71": {"vr": "DS", "Value": [30.177470256333]}, "72": {"vr": "DS", "Value": [-70.822529743667]}, "73": {"vr": "DS", "Value": [93.177470256333]}, "74": {"vr": "DS", "Value": [-4.8225297436671]}, "75": {"vr": "DS", "Value": [27.177470256333]}, "76": {"vr": "DS", "Value": [-16.822529743667]}, "77": {"vr": "DS", "Value": [-38.822529743667]}, "78": {"vr": "DS", "Value": [17.177470256333]}, "79": {"vr": "DS", "Value": [26.177470256333]}, "80": {"vr": "DS", "Value": [-55.822529743667]}, "81": {"vr": "DS", "Value": [-69.822529743667]}, "82": {"vr": "DS", "Value": [-26.822529743667]}, "83": {"vr": "DS", "Value": [-56.822529743667]}, "84": {"vr": "DS", "Value": [70.177470256333]}, "85": {"vr": "DS", "Value": [34.177470256333]}, "86": {"vr": "DS", "Value": [31.177470256333]}, "87": {"vr": "DS", "Value": [-67.822529743667]}, "88": {"vr": "DS", "Value": [-39.822529743667]}, "89": {"vr": "DS", "Value": [-49.822529743667]}, "90": {"vr": "DS", "Value": [-34.822529743667]}, "91": {"vr": "DS", "Value": [-41.822529743667]}, "92": {"vr": "DS", "Value": [-15.822529743667]}, "93": {"vr": "DS", "Value": [81.177470256333]}, "94": {"vr": "DS", "Value": [-46.822529743667]}, "95": {"vr": "DS", "Value": [62.177470256333]}, "96": {"vr": "DS", "Value": [-54.822529743667]}, "97": {"vr": "DS", "Value": [-31.822529743667]}, "98": {"vr": "DS", "Value": [-3.8225297436671]}, "99": {"vr": "DS", "Value": [14.177470256333]}, "100": {"vr": "DS", "Value": [91.177470256333]}, "101": {"vr": "DS", "Value": [8.1774702563329]}, "102": {"vr": "DS", "Value": [-80.822529743667]}, "103": {"vr": "DS", "Value": [32.177470256333]}, "104": {"vr": "DS", "Value": [53.177470256333]}, "105": {"vr": "DS", "Value": [2.1774702563329]}, "106": {"vr": "DS", "Value": [98.177470256333]}, "107": {"vr": "DS", "Value": [-91.822529743667]}, "108": {"vr": "DS", "Value": [96.177470256333]}, "109": {"vr": "DS", "Value": [71.177470256333]}, "110": {"vr": "DS", "Value": [-59.822529743667]}, "111": {"vr": "DS", "Value": [89.177470256333]}, "112": {"vr": "DS", "Value": [11.177470256333]}, "113": {"vr": "DS", "Value": [7.1774702563329]}, "114": {"vr": "DS", "Value": [-62.822529743667]}, "115": {"vr": "DS", "Value": [36.177470256333]}, "116": {"vr": "DS", "Value": [-6.8225297436671]}, "117": {"vr": "DS", "Value": [-82.822529743667]}, "118": {"vr": "DS", "Value": [-61.822529743667]}, "119": {"vr": "DS", "Value": [45.177470256333]}, "120": {"vr": "DS", "Value": [86.177470256333]}, "121": {"vr": "DS", "Value": [-89.822529743667]}, "122": {"vr": "DS", "Value": [-25.822529743667]}, "123": {"vr": "DS", "Value": [-42.822529743667]}, "124": {"vr": "DS", "Value": [21.177470256333]}, "125": {"vr": "DS", "Value": [29.177470256333]}, "126": {"vr": "DS", "Value": [-58.822529743667]}, "127": {"vr": "DS", "Value": [38.177470256333]}, "128": {"vr": "DS", "Value": [69.177470256333]}, "129": {"vr": "DS", "Value": [-5.8225297436671]}, "130": {"vr": "DS", "Value": [24.177470256333]}, "131": {"vr": "DS", "Value": [-29.822529743667]}, "132": {"vr": "DS", "Value": [39.177470256333]}, "133": {"vr": "DS", "Value": [-85.822529743667]}, "134": {"vr": "DS", "Value": [-53.822529743667]}, "135": {"vr": "DS", "Value": [84.177470256333]}, "136": {"vr": "DS", "Value": [-9.8225297436671]}, "137": {"vr": "DS", "Value": [9.1774702563329]}, "138": {"vr": "DS", "Value": [82.177470256333]}, "139": {"vr": "DS", "Value": [15.177470256333]}, "140": {"vr": "DS", "Value": [-19.822529743667]}, "141": {"vr": "DS", "Value": [19.177470256333]}, "142": {"vr": "DS", "Value": [-47.822529743667]}, "143": {"vr": "DS", "Value": [64.177470256333]}, "144": {"vr": "DS", "Value": [-57.822529743667]}, "145": {"vr": "DS", "Value": [65.177470256333]}, "146": {"vr": "DS", "Value": [58.177470256333]}, "147": {"vr": "DS", "Value": [92.177470256333]}, "148": {"vr": "DS", "Value": [28.177470256333]}, "149": {"vr": "DS", "Value": [-22.822529743667]}, "150": {"vr": "DS", "Value": [-28.822529743667]}, "151": {"vr": "DS", "Value": [-50.822529743667]}, "152": {"vr": "DS", "Value": [-83.822529743667]}, "153": {"vr": "DS", "Value": [90.177470256333]}, "154": {"vr": "DS", "Value": [3.1774702563329]}, "155": {"vr": "DS", "Value": [80.177470256333]}, "156": {"vr": "DS", "Value": [22.177470256333]}, "157": {"vr": "DS", "Value": [-90.822529743667]}, "158": {"vr": "DS", "Value": [-88.822529743667]}, "159": {"vr": "DS", "Value": [-2.8225297436671]}, "160": {"vr": "DS", "Value": [-72.822529743667]}, "161": {"vr": "DS", "Value": [-84.822529743667]}, "162": {"vr": "DS", "Value": [-33.822529743667]}, "163": {"vr": "DS", "Value": [-27.822529743667]}, "164": {"vr": "DS", "Value": [-86.822529743667]}, "165": {"vr": "DS", "Value": [56.177470256333]}, "166": {"vr": "DS", "Value": [-79.822529743667]}, "167": {"vr": "DS", "Value": [-43.822529743667]}, "168": {"vr": "DS", "Value": [78.177470256333]}, "169": {"vr": "DS", "Value": [-12.822529743667]}, "170": {"vr": "DS", "Value": [-52.822529743667]}, "171": {"vr": "DS", "Value": [-65.822529743667]}, "172": {"vr": "DS", "Value": [66.177470256333]}, "173": {"vr": "DS", "Value": [4.1774702563329]}, "174": {"vr": "DS", "Value": [-68.822529743667]}, "175": {"vr": "DS", "Value": [-37.822529743667]}, "176": {"vr": "DS", "Value": [-10.822529743667]}, "177": {"vr": "DS", "Value": [52.177470256333]}, "178": {"vr": "DS", "Value": [68.177470256333]}, "179": {"vr": "DS", "Value": [94.177470256333]}, "180": {"vr": "DS", "Value": [-71.822529743667]}, "181": {"vr": "DS", "Value": [-23.822529743667]}, "182": {"vr": "DS", "Value": [-7.8225297436671]}, "183": {"vr": "DS", "Value": [-30.822529743667]}, "184": {"vr": "DS", "Value": [42.177470256333]}, "185": {"vr": "DS", "Value": [74.177470256333]}, "186": {"vr": "DS", "Value": [60.177470256333]}, "187": {"vr": "DS", "Value": [-13.822529743667]}, "188": {"vr": "DS", "Value": [23.177470256333]}, "189": {"vr": "DS", "Value": [-18.822529743667]}, "190": {"vr": "DS", "Value": [97.177470256333]}, "191": {"vr": "DS", "Value": [72.177470256333]}}, "00211106": {"0": {"vr": "LO", "Value": ["X_1_1_1_1_1_84_1_1_1_1_1_14"]}, "1": {"vr": "LO", "Value": ["X_1_1_1_1_1_144_1_1_1_1_1_14"]}, "2": {"vr": "LO", "Value": ["X_1_1_1_1_1_11_1_1_1_1_1_14"]}, "3": {"vr": "LO", "Value": ["X_1_1_1_1_1_147_1_1_1_1_1_14"]}, "4": {"vr": "LO", "Value": ["X_1_1_1_1_1_78_1_1_1_1_1_14"]}, "5": {"vr": "LO", "Value": ["X_1_1_1_1_1_111_1_1_1_1_1_14"]}, "6": {"vr": "LO", "Value": ["X_1_1_1_1_1_52_1_1_1_1_1_14"]}, "7": {"vr": "LO", "Value": ["X_1_1_1_1_1_41_1_1_1_1_1_14"]}, "8": {"vr": "LO", "Value": ["X_1_1_1_1_1_98_1_1_1_1_1_14"]}, "9": {"vr": "LO", "Value": ["X_1_1_1_1_1_142_1_1_1_1_1_14"]}, "10": {"vr": "LO", "Value": ["X_1_1_1_1_1_150_1_1_1_1_1_14"]}, "11": {"vr": "LO", "Value": ["X_1_1_1_1_1_160_1_1_1_1_1_14"]}, "12": {"vr": "LO", "Value": ["X_1_1_1_1_1_180_1_1_1_1_1_14"]}, "13": {"vr": "LO", "Value": ["X_1_1_1_1_1_15_1_1_1_1_1_14"]}, "14": {"vr": "LO", "Value": ["X_1_1_1_1_1_91_1_1_1_1_1_14"]}, "15": {"vr": "LO", "Value": ["X_1_1_1_1_1_118_1_1_1_1_1_14"]}, "16": {"vr": "LO", "Value": ["X_1_1_1_1_1_19_1_1_1_1_1_14"]}, "17": {"vr": "LO", "Value": ["X_1_1_1_1_1_188_1_1_1_1_1_14"]}, "18": {"vr": "LO", "Value": ["X_1_1_1_1_1_16_1_1_1_1_1_14"]}, "19": {"vr": "LO", "Value": ["X_1_1_1_1_1_28_1_1_1_1_1_14"]}, "20": {"vr": "LO", "Value": ["X_1_1_1_1_1_103_1_1_1_1_1_14"]}, "21": {"vr": "LO", "Value": ["X_1_1_1_1_1_192_1_1_1_1_1_14"]}, "22": {"vr": "LO", "Value": ["X_1_1_1_1_1_181_1_1_1_1_1_14"]}, "23": {"vr": "LO", "Value": ["X_1_1_1_1_1_99_1_1_1_1_1_14"]}, "24": {"vr": "LO", "Value": ["X_1_1_1_1_1_152_1_1_1_1_1_14"]}, "25": {"vr": "LO", "Value": ["X_1_1_1_1_1_60_1_1_1_1_1_14"]}, "26": {"vr": "LO", "Value": ["X_1_1_1_1_1_128_1_1_1_1_1_14"]}, "27": {"vr": "LO", "Value": ["X_1_1_1_1_1_126_1_1_1_1_1_14"]}, "28": {"vr": "LO", "Value": ["X_1_1_1_1_1_136_1_1_1_1_1_14"]}, "29": {"vr": "LO", "Value": ["X_1_1_1_1_1_68_1_1_1_1_1_14"]}, "30": {"vr": "LO", "Value": ["X_1_1_1_1_1_17_1_1_1_1_1_14"]}, "31": {"vr": "LO", "Value": ["X_1_1_1_1_1_137_1_1_1_1_1_14"]}, "32": {"vr": "LO", "Value": ["X_1_1_1_1_1_93_1_1_1_1_1_14"]}, "33": {"vr": "LO", "Value": ["X_1_1_1_1_1_18_1_1_1_1_1_14"]}, "34": {"vr": "LO", "Value": ["X_1_1_1_1_1_170_1_1_1_1_1_14"]}, "35": {"vr": "LO", "Value": ["X_1_1_1_1_1_172_1_1_1_1_1_14"]}, "36": {"vr": "LO", "Value": ["X_1_1_1_1_1_106_1_1_1_1_1_14"]}, "37": {"vr": "LO", "Value": ["X_1_1_1_1_1_134_1_1_1_1_1_14"]}, "38": {"vr": "LO", "Value": ["X_1_1_1_1_1_113_1_1_1_1_1_14"]}, "39": {"vr": "LO", "Value": ["X_1_1_1_1_1_47_1_1_1_1_1_14"]}, "40": {"vr": "LO", "Value": ["X_1_1_1_1_1_44_1_1_1_1_1_14"]}, "41": {"vr": "LO", "Value": ["X_1_1_1_1_1_105_1_1_1_1_1_14"]}, "42": {"vr": "LO", "Value": ["X_1_1_1_1_1_32_1_1_1_1_1_14"]}, "43": {"vr": "LO", "Value": ["X_1_1_1_1_1_75_1_1_1_1_1_14"]}, "44": {"vr": "LO", "Value": ["X_1_1_1_1_1_14_1_1_1_1_1_14"]}, "45": {"vr": "LO", "Value": ["X_1_1_1_1_1_141_1_1_1_1_1_14"]}, "46": {"vr": "LO", "Value": ["X_1_1_1_1_1_71_1_1_1_1_1_14"]}, "47": {"vr": "LO", "Value": ["X_1_1_1_1_1_143_1_1_1_1_1_14"]}, "48": {"vr": "LO", "Value": ["X_1_1_1_1_1_139_1_1_1_1_1_14"]}, "49": {"vr": "LO", "Value": ["X_1_1_1_1_1_140_1_1_1_1_1_14"]}, "50": {"vr": "LO", "Value": ["X_1_1_1_1_1_81_1_1_1_1_1_14"]}, "51": {"vr": "LO", "Value": ["X_1_1_1_1_1_154_1_1_1_1_1_14"]}, "52": {"vr": "LO", "Value": ["X_1_1_1_1_1_94_1_1_1_1_1_14"]}, "53": {"vr": "LO", "Value": ["X_1_1_1_1_1_156_1_1_1_1_1_14"]}, "54": {"vr": "LO", "Value": ["X_1_1_1_1_1_109_1_1_1_1_1_14"]}, "55": {"vr": "LO", "Value": ["X_1_1_1_1_1_169_1_1_1_1_1_14"]}, "56": {"vr": "LO", "Value": ["X_1_1_1_1_1_178_1_1_1_1_1_14"]}, "57": {"vr": "LO", "Value": ["X_1_1_1_1_1_176_1_1_1_1_1_14"]}, "58": {"vr": "LO", "Value": ["X_1_1_1_1_1_92_1_1_1_1_1_14"]}, "59": {"vr": "LO", "Value": ["X_1_1_1_1_1_29_1_1_1_1_1_14"]}, "60": {"vr": "LO", "Value": ["X_1_1_1_1_1_130_1_1_1_1_1_14"]}, "61": {"vr": "LO", "Value": ["X_1_1_1_1_1_5_1_1_1_1_1_14"]}, "62": {"vr": "LO", "Value": ["X_1_1_1_1_1_26_1_1_1_1_1_14"]}, "63": {"vr": "LO", "Value": ["X_1_1_1_1_1_72_1_1_1_1_1_14"]}, "64": {"vr": "LO", "Value": ["X_1_1_1_1_1_57_1_1_1_1_1_14"]}, "65": {"vr": "LO", "Value": ["X_1_1_1_1_1_166_1_1_1_1_1_14"]}, "66": {"vr": "LO", "Value": ["X_1_1_1_1_1_56_1_1_1_1_1_14"]}, "67": {"vr": "LO", "Value": ["X_1_1_1_1_1_48_1_1_1_1_1_14"]}, "68": {"vr": "LO", "Value": ["X_1_1_1_1_1_148_1_1_1_1_1_14"]}, "69": {"vr": "LO", "Value": ["X_1_1_1_1_1_168_1_1_1_1_1_14"]}, "70": {"vr": "LO", "Value": ["X_1_1_1_1_1_133_1_1_1_1_1_14"]}, "71": {"vr": "LO", "Value": ["X_1_1_1_1_1_123_1_1_1_1_1_14"]}, "72": {"vr": "LO", "Value": ["X_1_1_1_1_1_22_1_1_1_1_1_14"]}, "73": {"vr": "LO", "Value": ["X_1_1_1_1_1_186_1_1_1_1_1_14"]}, "74": {"vr": "LO", "Value": ["X_1_1_1_1_1_88_1_1_1_1_1_14"]}, "75": {"vr": "LO", "Value": ["X_1_1_1_1_1_120_1_1_1_1_1_14"]}, "76": {"vr": "LO", "Value": ["X_1_1_1_1_1_76_1_1_1_1_1_14"]}, "77": {"vr": "LO", "Value": ["X_1_1_1_1_1_54_1_1_1_1_1_14"]}, "78": {"vr": "LO", "Value": ["X_1_1_1_1_1_110_1_1_1_1_1_14"]}, "79": {"vr": "LO", "Value": ["X_1_1_1_1_1_119_1_1_1_1_1_14"]}, "80": {"vr": "LO", "Value": ["X_1_1_1_1_1_37_1_1_1_1_1_14"]}, "81": {"vr": "LO", "Value": ["X_1_1_1_1_1_23_1_1_1_1_1_14"]}, "82": {"vr": "LO", "Value": ["X_1_1_1_1_1_66_1_1_1_1_1_14"]}, "83": {"vr": "LO", "Value": ["X_1_1_1_1_1_36_1_1_1_1_1_14"]}, "84": {"vr": "LO", "Value": ["X_1_1_1_1_1_163_1_1_1_1_1_14"]}, "85": {"vr": "LO", "Value": ["X_1_1_1_1_1_127_1_1_1_1_1_14"]}, "86": {"vr": "LO", "Value": ["X_1_1_1_1_1_124_1_1_1_1_1_14"]}, "87": {"vr": "LO", "Value": ["X_1_1_1_1_1_25_1_1_1_1_1_14"]}, "88": {"vr": "LO", "Value": ["X_1_1_1_1_1_53_1_1_1_1_1_14"]}, "89": {"vr": "LO", "Value": ["X_1_1_1_1_1_43_1_1_1_1_1_14"]}, "90": {"vr": "LO", "Value": ["X_1_1_1_1_1_58_1_1_1_1_1_14"]}, "91": {"vr": "LO", "Value": ["X_1_1_1_1_1_51_1_1_1_1_1_14"]}, "92": {"vr": "LO", "Value": ["X_1_1_1_1_1_77_1_1_1_1_1_14"]}, "93": {"vr": "LO", "Value": ["X_1_1_1_1_1_174_1_1_1_1_1_14"]}, "94": {"vr": "LO", "Value": ["X_1_1_1_1_1_46_1_1_1_1_1_14"]}, "95": {"vr": "LO", "Value": ["X_1_1_1_1_1_155_1_1_1_1_1_14"]}, "96": {"vr": "LO", "Value": ["X_1_1_1_1_1_38_1_1_1_1_1_14"]}, "97": {"vr": "LO", "Value": ["X_1_1_1_1_1_61_1_1_1_1_1_14"]}, "98": {"vr": "LO", "Value": ["X_1_1_1_1_1_89_1_1_1_1_1_14"]}, "99": {"vr": "LO", "Value": ["X_1_1_1_1_1_107_1_1_1_1_1_14"]}, "100": {"vr": "LO", "Value": ["X_1_1_1_1_1_184_1_1_1_1_1_14"]}, "101": {"vr": "LO", "Value": ["X_1_1_1_1_1_101_1_1_1_1_1_14"]}, "102": {"vr": "LO", "Value": ["X_1_1_1_1_1_12_1_1_1_1_1_14"]}, "103": {"vr": "LO", "Value": ["X_1_1_1_1_1_125_1_1_1_1_1_14"]}, "104": {"vr": "LO", "Value": ["X_1_1_1_1_1_146_1_1_1_1_1_14"]}, "105": {"vr": "LO", "Value": ["X_1_1_1_1_1_95_1_1_1_1_1_14"]}, "106": {"vr": "LO", "Value": ["X_1_1_1_1_1_191_1_1_1_1_1_14"]}, "107": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_1_1_1_1_1_14"]}, "108": {"vr": "LO", "Value": ["X_1_1_1_1_1_189_1_1_1_1_1_14"]}, "109": {"vr": "LO", "Value": ["X_1_1_1_1_1_164_1_1_1_1_1_14"]}, "110": {"vr": "LO", "Value": ["X_1_1_1_1_1_33_1_1_1_1_1_14"]}, "111": {"vr": "LO", "Value": ["X_1_1_1_1_1_182_1_1_1_1_1_14"]}, "112": {"vr": "LO", "Value": ["X_1_1_1_1_1_104_1_1_1_1_1_14"]}, "113": {"vr": "LO", "Value": ["X_1_1_1_1_1_100_1_1_1_1_1_14"]}, "114": {"vr": "LO", "Value": ["X_1_1_1_1_1_30_1_1_1_1_1_14"]}, "115": {"vr": "LO", "Value": ["X_1_1_1_1_1_129_1_1_1_1_1_14"]}, "116": {"vr": "LO", "Value": ["X_1_1_1_1_1_86_1_1_1_1_1_14"]}, "117": {"vr": "LO", "Value": ["X_1_1_1_1_1_10_1_1_1_1_1_14"]}, "118": {"vr": "LO", "Value": ["X_1_1_1_1_1_31_1_1_1_1_1_14"]}, "119": {"vr": "LO", "Value": ["X_1_1_1_1_1_138_1_1_1_1_1_14"]}, "120": {"vr": "LO", "Value": ["X_1_1_1_1_1_179_1_1_1_1_1_14"]}, "121": {"vr": "LO", "Value": ["X_1_1_1_1_1_3_1_1_1_1_1_14"]}, "122": {"vr": "LO", "Value": ["X_1_1_1_1_1_67_1_1_1_1_1_14"]}, "123": {"vr": "LO", "Value": ["X_1_1_1_1_1_50_1_1_1_1_1_14"]}, "124": {"vr": "LO", "Value": ["X_1_1_1_1_1_114_1_1_1_1_1_14"]}, "125": {"vr": "LO", "Value": ["X_1_1_1_1_1_122_1_1_1_1_1_14"]}, "126": {"vr": "LO", "Value": ["X_1_1_1_1_1_34_1_1_1_1_1_14"]}, "127": {"vr": "LO", "Value": ["X_1_1_1_1_1_131_1_1_1_1_1_14"]}, "128": {"vr": "LO", "Value": ["X_1_1_1_1_1_162_1_1_1_1_1_14"]}, "129": {"vr": "LO", "Value": ["X_1_1_1_1_1_87_1_1_1_1_1_14"]}, "130": {"vr": "LO", "Value": ["X_1_1_1_1_1_117_1_1_1_1_1_14"]}, "131": {"vr": "LO", "Value": ["X_1_1_1_1_1_63_1_1_1_1_1_14"]}, "132": {"vr": "LO", "Value": ["X_1_1_1_1_1_132_1_1_1_1_1_14"]}, "133": {"vr": "LO", "Value": ["X_1_1_1_1_1_7_1_1_1_1_1_14"]}, "134": {"vr": "LO", "Value": ["X_1_1_1_1_1_39_1_1_1_1_1_14"]}, "135": {"vr": "LO", "Value": ["X_1_1_1_1_1_177_1_1_1_1_1_14"]}, "136": {"vr": "LO", "Value": ["X_1_1_1_1_1_83_1_1_1_1_1_14"]}, "137": {"vr": "LO", "Value": ["X_1_1_1_1_1_102_1_1_1_1_1_14"]}, "138": {"vr": "LO", "Value": ["X_1_1_1_1_1_175_1_1_1_1_1_14"]}, "139": {"vr": "LO", "Value": ["X_1_1_1_1_1_108_1_1_1_1_1_14"]}, "140": {"vr": "LO", "Value": ["X_1_1_1_1_1_73_1_1_1_1_1_14"]}, "141": {"vr": "LO", "Value": ["X_1_1_1_1_1_112_1_1_1_1_1_14"]}, "142": {"vr": "LO", "Value": ["X_1_1_1_1_1_45_1_1_1_1_1_14"]}, "143": {"vr": "LO", "Value": ["X_1_1_1_1_1_157_1_1_1_1_1_14"]}, "144": {"vr": "LO", "Value": ["X_1_1_1_1_1_35_1_1_1_1_1_14"]}, "145": {"vr": "LO", "Value": ["X_1_1_1_1_1_158_1_1_1_1_1_14"]}, "146": {"vr": "LO", "Value": ["X_1_1_1_1_1_151_1_1_1_1_1_14"]}, "147": {"vr": "LO", "Value": ["X_1_1_1_1_1_185_1_1_1_1_1_14"]}, "148": {"vr": "LO", "Value": ["X_1_1_1_1_1_121_1_1_1_1_1_14"]}, "149": {"vr": "LO", "Value": ["X_1_1_1_1_1_70_1_1_1_1_1_14"]}, "150": {"vr": "LO", "Value": ["X_1_1_1_1_1_64_1_1_1_1_1_14"]}, "151": {"vr": "LO", "Value": ["X_1_1_1_1_1_42_1_1_1_1_1_14"]}, "152": {"vr": "LO", "Value": ["X_1_1_1_1_1_9_1_1_1_1_1_14"]}, "153": {"vr": "LO", "Value": ["X_1_1_1_1_1_183_1_1_1_1_1_14"]}, "154": {"vr": "LO", "Value": ["X_1_1_1_1_1_96_1_1_1_1_1_14"]}, "155": {"vr": "LO", "Value": ["X_1_1_1_1_1_173_1_1_1_1_1_14"]}, "156": {"vr": "LO", "Value": ["X_1_1_1_1_1_115_1_1_1_1_1_14"]}, "157": {"vr": "LO", "Value": ["X_1_1_1_1_1_2_1_1_1_1_1_14"]}, "158": {"vr": "LO", "Value": ["X_1_1_1_1_1_4_1_1_1_1_1_14"]}, "159": {"vr": "LO", "Value": ["X_1_1_1_1_1_90_1_1_1_1_1_14"]}, "160": {"vr": "LO", "Value": ["X_1_1_1_1_1_20_1_1_1_1_1_14"]}, "161": {"vr": "LO", "Value": ["X_1_1_1_1_1_8_1_1_1_1_1_14"]}, "162": {"vr": "LO", "Value": ["X_1_1_1_1_1_59_1_1_1_1_1_14"]}, "163": {"vr": "LO", "Value": ["X_1_1_1_1_1_65_1_1_1_1_1_14"]}, "164": {"vr": "LO", "Value": ["X_1_1_1_1_1_6_1_1_1_1_1_14"]}, "165": {"vr": "LO", "Value": ["X_1_1_1_1_1_149_1_1_1_1_1_14"]}, "166": {"vr": "LO", "Value": ["X_1_1_1_1_1_13_1_1_1_1_1_14"]}, "167": {"vr": "LO", "Value": ["X_1_1_1_1_1_49_1_1_1_1_1_14"]}, "168": {"vr": "LO", "Value": ["X_1_1_1_1_1_171_1_1_1_1_1_14"]}, "169": {"vr": "LO", "Value": ["X_1_1_1_1_1_80_1_1_1_1_1_14"]}, "170": {"vr": "LO", "Value": ["X_1_1_1_1_1_40_1_1_1_1_1_14"]}, "171": {"vr": "LO", "Value": ["X_1_1_1_1_1_27_1_1_1_1_1_14"]}, "172": {"vr": "LO", "Value": ["X_1_1_1_1_1_159_1_1_1_1_1_14"]}, "173": {"vr": "LO", "Value": ["X_1_1_1_1_1_97_1_1_1_1_1_14"]}, "174": {"vr": "LO", "Value": ["X_1_1_1_1_1_24_1_1_1_1_1_14"]}, "175": {"vr": "LO", "Value": ["X_1_1_1_1_1_55_1_1_1_1_1_14"]}, "176": {"vr": "LO", "Value": ["X_1_1_1_1_1_82_1_1_1_1_1_14"]}, "177": {"vr": "LO", "Value": ["X_1_1_1_1_1_145_1_1_1_1_1_14"]}, "178": {"vr": "LO", "Value": ["X_1_1_1_1_1_161_1_1_1_1_1_14"]}, "179": {"vr": "LO", "Value": ["X_1_1_1_1_1_187_1_1_1_1_1_14"]}, "180": {"vr": "LO", "Value": ["X_1_1_1_1_1_21_1_1_1_1_1_14"]}, "181": {"vr": "LO", "Value": ["X_1_1_1_1_1_69_1_1_1_1_1_14"]}, "182": {"vr": "LO", "Value": ["X_1_1_1_1_1_85_1_1_1_1_1_14"]}, "183": {"vr": "LO", "Value": ["X_1_1_1_1_1_62_1_1_1_1_1_14"]}, "184": {"vr": "LO", "Value": ["X_1_1_1_1_1_135_1_1_1_1_1_14"]}, "185": {"vr": "LO", "Value": ["X_1_1_1_1_1_167_1_1_1_1_1_14"]}, "186": {"vr": "LO", "Value": ["X_1_1_1_1_1_153_1_1_1_1_1_14"]}, "187": {"vr": "LO", "Value": ["X_1_1_1_1_1_79_1_1_1_1_1_14"]}, "188": {"vr": "LO", "Value": ["X_1_1_1_1_1_116_1_1_1_1_1_14"]}, "189": {"vr": "LO", "Value": ["X_1_1_1_1_1_74_1_1_1_1_1_14"]}, "190": {"vr": "LO", "Value": ["X_1_1_1_1_1_190_1_1_1_1_1_14"]}, "191": {"vr": "LO", "Value": ["X_1_1_1_1_1_165_1_1_1_1_1_14"]}}, "0021111A": {"0": {"vr": "SH", "Value": ["measured"]}, "1": {"vr": "SH", "Value": ["measured"]}, "2": {"vr": "SH", "Value": ["predicted"]}, "3": {"vr": "SH", "Value": ["measured"]}, "4": {"vr": "SH", "Value": ["measured"]}, "5": {"vr": "SH", "Value": ["measured"]}, "6": {"vr": "SH", "Value": ["measured"]}, "7": {"vr": "SH", "Value": ["measured"]}, "8": {"vr": "SH", "Value": ["measured"]}, "9": {"vr": "SH", "Value": ["measured"]}, "10": {"vr": "SH", "Value": ["measured"]}, "11": {"vr": "SH", "Value": ["measured"]}, "12": {"vr": "SH", "Value": ["measured"]}, "13": {"vr": "SH", "Value": ["measured"]}, "14": {"vr": "SH", "Value": ["measured"]}, "15": {"vr": "SH", "Value": ["measured"]}, "16": {"vr": "SH", "Value": ["measured"]}, "17": {"vr": "SH", "Value": ["measured"]}, "18": {"vr": "SH", "Value": ["measured"]}, "19": {"vr": "SH", "Value": ["measured"]}, "20": {"vr": "SH", "Value": ["measured"]}, "21": {"vr": "SH", "Value": ["measured"]}, "22": {"vr": "SH", "Value": ["measured"]}, "23": {"vr": "SH", "Value": ["measured"]}, "24": {"vr": "SH", "Value": ["measured"]}, "25": {"vr": "SH", "Value": ["measured"]}, "26": {"vr": "SH", "Value": ["measured"]}, "27": {"vr": "SH", "Value": ["measured"]}, "28": {"vr": "SH", "Value": ["measured"]}, "29": {"vr": "SH", "Value": ["measured"]}, "30": {"vr": "SH", "Value": ["measured"]}, "31": {"vr": "SH", "Value": ["measured"]}, "32": {"vr": "SH", "Value": ["measured"]}, "33": {"vr": "SH", "Value": ["measured"]}, "34": {"vr": "SH", "Value": ["measured"]}, "35": {"vr": "SH", "Value": ["measured"]}, "36": {"vr": "SH", "Value": ["measured"]}, "37": {"vr": "SH", "Value": ["measured"]}, "38": {"vr": "SH", "Value": ["measured"]}, "39": {"vr": "SH", "Value": ["measured"]}, "40": {"vr": "SH", "Value": ["measured"]}, "41": {"vr": "SH", "Value": ["measured"]}, "42": {"vr": "SH", "Value": ["measured"]}, "43": {"vr": "SH", "Value": ["measured"]}, "44": {"vr": "SH", "Value": ["measured"]}, "45": {"vr": "SH", "Value": ["measured"]}, "46": {"vr": "SH", "Value": ["measured"]}, "47": {"vr": "SH", "Value": ["measured"]}, "48": {"vr": "SH", "Value": ["measured"]}, "49": {"vr": "SH", "Value": ["measured"]}, "50": {"vr": "SH", "Value": ["measured"]}, "51": {"vr": "SH", "Value": ["measured"]}, "52": {"vr": "SH", "Value": ["measured"]}, "53": {"vr": "SH", "Value": ["measured"]}, "54": {"vr": "SH", "Value": ["measured"]}, "55": {"vr": "SH", "Value": ["measured"]}, "56": {"vr": "SH", "Value": ["measured"]}, "57": {"vr": "SH", "Value": ["measured"]}, "58": {"vr": "SH", "Value": ["measured"]}, "59": {"vr": "SH", "Value": ["measured"]}, "60": {"vr": "SH", "Value": ["measured"]}, "61": {"vr": "SH", "Value": ["predicted"]}, "62": {"vr": "SH", "Value": ["measured"]}, "63": {"vr": "SH", "Value": ["measured"]}, "64": {"vr": "SH", "Value": ["measured"]}, "65": {"vr": "SH", "Value": ["measured"]}, "66": {"vr": "SH", "Value": ["measured"]}, "67": {"vr": "SH", "Value": ["measured"]}, "68": {"vr": "SH", "Value": ["measured"]}, "69": {"vr": "SH", "Value": ["measured"]}, "70": {"vr": "SH", "Value": ["measured"]}, "71": {"vr": "SH", "Value": ["measured"]}, "72": {"vr": "SH", "Value": ["measured"]}, "73": {"vr": "SH", "Value": ["measured"]}, "74": {"vr": "SH", "Value": ["measured"]}, "75": {"vr": "SH", "Value": ["measured"]}, "76": {"vr": "SH", "Value": ["measured"]}, "77": {"vr": "SH", "Value": ["measured"]}, "78": {"vr": "SH", "Value": ["measured"]}, "79": {"vr": "SH", "Value": ["measured"]}, "80": {"vr": "SH", "Value": ["measured"]}, "81": {"vr": "SH", "Value": ["measured"]}, "82": {"vr": "SH", "Value": ["measured"]}, "83": {"vr": "SH", "Value": ["measured"]}, "84": {"vr": "SH", "Value": ["measured"]}, "85": {"vr": "SH", "Value": ["measured"]}, "86": {"vr": "SH", "Value": ["measured"]}, "87": {"vr": "SH", "Value": ["measured"]}, "88": {"vr": "SH", "Value": ["measured"]}, "89": {"vr": "SH", "Value": ["measured"]}, "90": {"vr": "SH", "Value": ["measured"]}, "91": {"vr": "SH", "Value": ["measured"]}, "92": {"vr": "SH", "Value": ["measured"]}, "93": {"vr": "SH", "Value": ["measured"]}, "94": {"vr": "SH", "Value": ["measured"]}, "95": {"vr": "SH", "Value": ["measured"]}, "96": {"vr": "SH", "Value": ["measured"]}, "97": {"vr": "SH", "Value": ["measured"]}, "98": {"vr": "SH", "Value": ["measured"]}, "99": {"vr": "SH", "Value": ["measured"]}, "100": {"vr": "SH", "Value": ["measured"]}, "101": {"vr": "SH", "Value": ["measured"]}, "102": {"vr": "SH", "Value": ["predicted"]}, "103": {"vr": "SH", "Value": ["measured"]}, "104": {"vr": "SH", "Value": ["measured"]}, "105": {"vr": "SH", "Value": ["measured"]}, "106": {"vr": "SH", "Value": ["measured"]}, "107": {"vr": "SH", "Value": ["predicted"]}, "108": {"vr": "SH", "Value": ["measured"]}, "109": {"vr": "SH", "Value": ["measured"]}, "110": {"vr": "SH", "Value": ["measured"]}, "111": {"vr": "SH", "Value": ["measured"]}, "112": {"vr": "SH", "Value": ["measured"]}, "113": {"vr": "SH", "Value": ["measured"]}, "114": {"vr": "SH", "Value": ["measured"]}, "115": {"vr": "SH", "Value": ["measured"]}, "116": {"vr": "SH", "Value": ["measured"]}, "117": {"vr": "SH", "Value": ["predicted"]}, "118": {"vr": "SH", "Value": ["measured"]}, "119": {"vr": "SH", "Value": ["measured"]}, "120": {"vr": "SH", "Value": ["measured"]}, "121": {"vr": "SH", "Value": ["predicted"]}, "122": {"vr": "SH", "Value": ["measured"]}, "123": {"vr": "SH", "Value": ["measured"]}, "124": {"vr": "SH", "Value": ["measured"]}, "125": {"vr": "SH", "Value": ["measured"]}, "126": {"vr": "SH", "Value": ["measured"]}, "127": {"vr": "SH", "Value": ["measured"]}, "128": {"vr": "SH", "Value": ["measured"]}, "129": {"vr": "SH", "Value": ["measured"]}, "130": {"vr": "SH", "Value": ["measured"]}, "131": {"vr": "SH", "Value": ["measured"]}, "132": {"vr": "SH", "Value": ["measured"]}, "133": {"vr": "SH", "Value": ["predicted"]}, "134": {"vr": "SH", "Value": ["measured"]}, "135": {"vr": "SH", "Value": ["measured"]}, "136": {"vr": "SH", "Value": ["measured"]}, "137": {"vr": "SH", "Value": ["measured"]}, "138": {"vr": "SH", "Value": ["measured"]}, "139": {"vr": "SH", "Value": ["measured"]}, "140": {"vr": "SH", "Value": ["measured"]}, "141": {"vr": "SH", "Value": ["measured"]}, "142": {"vr": "SH", "Value": ["measured"]}, "143": {"vr": "SH", "Value": ["measured"]}, "144": {"vr": "SH", "Value": ["measured"]}, "145": {"vr": "SH", "Value": ["measured"]}, "146": {"vr": "SH", "Value": ["measured"]}, "147": {"vr": "SH", "Value": ["measured"]}, "148": {"vr": "SH", "Value": ["measured"]}, "149": {"vr": "SH", "Value": ["measured"]}, "150": {"vr": "SH", "Value": ["measured"]}, "151": {"vr": "SH", "Value": ["measured"]}, "152": {"vr": "SH", "Value": ["predicted"]}, "153": {"vr": "SH", "Value": ["measured"]}, "154": {"vr": "SH", "Value": ["measured"]}, "155": {"vr": "SH", "Value": ["measured"]}, "156": {"vr": "SH", "Value": ["measured"]}, "157": {"vr": "SH", "Value": ["predicted"]}, "158": {"vr": "SH", "Value": ["predicted"]}, "159": {"vr": "SH", "Value": ["measured"]}, "160": {"vr": "SH", "Value": ["measured"]}, "161": {"vr": "SH", "Value": ["predicted"]}, "162": {"vr": "SH", "Value": ["measured"]}, "163": {"vr": "SH", "Value": ["measured"]}, "164": {"vr": "SH", "Value": ["predicted"]}, "165": {"vr": "SH", "Value": ["measured"]}, "166": {"vr": "SH", "Value": ["measured"]}, "167": {"vr": "SH", "Value": ["measured"]}, "168": {"vr": "SH", "Value": ["measured"]}, "169": {"vr": "SH", "Value": ["measured"]}, "170": {"vr": "SH", "Value": ["measured"]}, "171": {"vr": "SH", "Value": ["measured"]}, "172": {"vr": "SH", "Value": ["measured"]}, "173": {"vr": "SH", "Value": ["measured"]}, "174": {"vr": "SH", "Value": ["measured"]}, "175": {"vr": "SH", "Value": ["measured"]}, "176": {"vr": "SH", "Value": ["measured"]}, "177": {"vr": "SH", "Value": ["measured"]}, "178": {"vr": "SH", "Value": ["measured"]}, "179": {"vr": "SH", "Value": ["measured"]}, "180": {"vr": "SH", "Value": ["measured"]}, "181": {"vr": "SH", "Value": ["measured"]}, "182": {"vr": "SH", "Value": ["measured"]}, "183": {"vr": "SH", "Value": ["measured"]}, "184": {"vr": "SH", "Value": ["measured"]}, "185": {"vr": "SH", "Value": ["measured"]}, "186": {"vr": "SH", "Value": ["measured"]}, "187": {"vr": "SH", "Value": ["measured"]}, "188": {"vr": "SH", "Value": ["measured"]}, "189": {"vr": "SH", "Value": ["measured"]}, "190": {"vr": "SH", "Value": ["measured"]}, "191": {"vr": "SH", "Value": ["measured"]}}, "00211141": {"0": {"vr": "SH", "Value": ["measured"]}, "1": {"vr": "SH", "Value": ["measured"]}, "2": {"vr": "SH", "Value": ["predicted"]}, "3": {"vr": "SH", "Value": ["measured"]}, "4": {"vr": "SH", "Value": ["measured"]}, "5": {"vr": "SH", "Value": ["measured"]}, "6": {"vr": "SH", "Value": ["measured"]}, "7": {"vr": "SH", "Value": ["measured"]}, "8": {"vr": "SH", "Value": ["measured"]}, "9": {"vr": "SH", "Value": ["measured"]}, "10": {"vr": "SH", "Value": ["measured"]}, "11": {"vr": "SH", "Value": ["measured"]}, "12": {"vr": "SH", "Value": ["measured"]}, "13": {"vr": "SH", "Value": ["measured"]}, "14": {"vr": "SH", "Value": ["measured"]}, "15": {"vr": "SH", "Value": ["measured"]}, "16": {"vr": "SH", "Value": ["measured"]}, "17": {"vr": "SH", "Value": ["measured"]}, "18": {"vr": "SH", "Value": ["measured"]}, "19": {"vr": "SH", "Value": ["measured"]}, "20": {"vr": "SH", "Value": ["measured"]}, "21": {"vr": "SH", "Value": ["measured"]}, "22": {"vr": "SH", "Value": ["measured"]}, "23": {"vr": "SH", "Value": ["measured"]}, "24": {"vr": "SH", "Value": ["measured"]}, "25": {"vr": "SH", "Value": ["measured"]}, "26": {"vr": "SH", "Value": ["measured"]}, "27": {"vr": "SH", "Value": ["measured"]}, "28": {"vr": "SH", "Value": ["measured"]}, "29": {"vr": "SH", "Value": ["measured"]}, "30": {"vr": "SH", "Value": ["measured"]}, "31": {"vr": "SH", "Value": ["measured"]}, "32": {"vr": "SH", "Value": ["measured"]}, "33": {"vr": "SH", "Value": ["measured"]}, "34": {"vr": "SH", "Value": ["measured"]}, "35": {"vr": "SH", "Value": ["measured"]}, "36": {"vr": "SH", "Value": ["measured"]}, "37": {"vr": "SH", "Value": ["measured"]}, "38": {"vr": "SH", "Value": ["measured"]}, "39": {"vr": "SH", "Value": ["measured"]}, "40": {"vr": "SH", "Value": ["measured"]}, "41": {"vr": "SH", "Value": ["measured"]}, "42": {"vr": "SH", "Value": ["measured"]}, "43": {"vr": "SH", "Value": ["measured"]}, "44": {"vr": "SH", "Value": ["measured"]}, "45": {"vr": "SH", "Value": ["measured"]}, "46": {"vr": "SH", "Value": ["measured"]}, "47": {"vr": "SH", "Value": ["measured"]}, "48": {"vr": "SH", "Value": ["measured"]}, "49": {"vr": "SH", "Value": ["measured"]}, "50": {"vr": "SH", "Value": ["measured"]}, "51": {"vr": "SH", "Value": ["measured"]}, "52": {"vr": "SH", "Value": ["measured"]}, "53": {"vr": "SH", "Value": ["measured"]}, "54": {"vr": "SH", "Value": ["measured"]}, "55": {"vr": "SH", "Value": ["measured"]}, "56": {"vr": "SH", "Value": ["measured"]}, "57": {"vr": "SH", "Value": ["measured"]}, "58": {"vr": "SH", "Value": ["measured"]}, "59": {"vr": "SH", "Value": ["measured"]}, "60": {"vr": "SH", "Value": ["measured"]}, "61": {"vr": "SH", "Value": ["predicted"]}, "62": {"vr": "SH", "Value": ["measured"]}, "63": {"vr": "SH", "Value": ["measured"]}, "64": {"vr": "SH", "Value": ["measured"]}, "65": {"vr": "SH", "Value": ["measured"]}, "66": {"vr": "SH", "Value": ["measured"]}, "67": {"vr": "SH", "Value": ["measured"]}, "68": {"vr": "SH", "Value": ["measured"]}, "69": {"vr": "SH", "Value": ["measured"]}, "70": {"vr": "SH", "Value": ["measured"]}, "71": {"vr": "SH", "Value": ["measured"]}, "72": {"vr": "SH", "Value": ["measured"]}, "73": {"vr": "SH", "Value": ["measured"]}, "74": {"vr": "SH", "Value": ["measured"]}, "75": {"vr": "SH", "Value": ["measured"]}, "76": {"vr": "SH", "Value": ["measured"]}, "77": {"vr": "SH", "Value": ["measured"]}, "78": {"vr": "SH", "Value": ["measured"]}, "79": {"vr": "SH", "Value": ["measured"]}, "80": {"vr": "SH", "Value": ["measured"]}, "81": {"vr": "SH", "Value": ["measured"]}, "82": {"vr": "SH", "Value": ["measured"]}, "83": {"vr": "SH", "Value": ["measured"]}, "84": {"vr": "SH", "Value": ["measured"]}, "85": {"vr": "SH", "Value": ["measured"]}, "86": {"vr": "SH", "Value": ["measured"]}, "87": {"vr": "SH", "Value": ["measured"]}, "88": {"vr": "SH", "Value": ["measured"]}, "89": {"vr": "SH", "Value": ["measured"]}, "90": {"vr": "SH", "Value": ["measured"]}, "91": {"vr": "SH", "Value": ["measured"]}, "92": {"vr": "SH", "Value": ["measured"]}, "93": {"vr": "SH", "Value": ["measured"]}, "94": {"vr": "SH", "Value": ["measured"]}, "95": {"vr": "SH", "Value": ["measured"]}, "96": {"vr": "SH", "Value": ["measured"]}, "97": {"vr": "SH", "Value": ["measured"]}, "98": {"vr": "SH", "Value": ["measured"]}, "99": {"vr": "SH", "Value": ["measured"]}, "100": {"vr": "SH", "Value": ["measured"]}, "101": {"vr": "SH", "Value": ["measured"]}, "102": {"vr": "SH", "Value": ["predicted"]}, "103": {"vr": "SH", "Value": ["measured"]}, "104": {"vr": "SH", "Value": ["measured"]}, "105": {"vr": "SH", "Value": ["measured"]}, "106": {"vr": "SH", "Value": ["measured"]}, "107": {"vr": "SH", "Value": ["predicted"]}, "108": {"vr": "SH", "Value": ["measured"]}, "109": {"vr": "SH", "Value": ["measured"]}, "110": {"vr": "SH", "Value": ["measured"]}, "111": {"vr": "SH", "Value": ["measured"]}, "112": {"vr": "SH", "Value": ["measured"]}, "113": {"vr": "SH", "Value": ["measured"]}, "114": {"vr": "SH", "Value": ["measured"]}, "115": {"vr": "SH", "Value": ["measured"]}, "116": {"vr": "SH", "Value": ["measured"]}, "117": {"vr": "SH", "Value": ["predicted"]}, "118": {"vr": "SH", "Value": ["measured"]}, "119": {"vr": "SH", "Value": ["measured"]}, "120": {"vr": "SH", "Value": ["measured"]}, "121": {"vr": "SH", "Value": ["predicted"]}, "122": {"vr": "SH", "Value": ["measured"]}, "123": {"vr": "SH", "Value": ["measured"]}, "124": {"vr": "SH", "Value": ["measured"]}, "125": {"vr": "SH", "Value": ["measured"]}, "126": {"vr": "SH", "Value": ["measured"]}, "127": {"vr": "SH", "Value": ["measured"]}, "128": {"vr": "SH", "Value": ["measured"]}, "129": {"vr": "SH", "Value": ["measured"]}, "130": {"vr": "SH", "Value": ["measured"]}, "131": {"vr": "SH", "Value": ["measured"]}, "132": {"vr": "SH", "Value": ["measured"]}, "133": {"vr": "SH", "Value": ["predicted"]}, "134": {"vr": "SH", "Value": ["measured"]}, "135": {"vr": "SH", "Value": ["measured"]}, "136": {"vr": "SH", "Value": ["measured"]}, "137": {"vr": "SH", "Value": ["measured"]}, "138": {"vr": "SH", "Value": ["measured"]}, "139": {"vr": "SH", "Value": ["measured"]}, "140": {"vr": "SH", "Value": ["measured"]}, "141": {"vr": "SH", "Value": ["measured"]}, "142": {"vr": "SH", "Value": ["measured"]}, "143": {"vr": "SH", "Value": ["measured"]}, "144": {"vr": "SH", "Value": ["measured"]}, "145": {"vr": "SH", "Value": ["measured"]}, "146": {"vr": "SH", "Value": ["measured"]}, "147": {"vr": "SH", "Value": ["measured"]}, "148": {"vr": "SH", "Value": ["measured"]}, "149": {"vr": "SH", "Value": ["measured"]}, "150": {"vr": "SH", "Value": ["measured"]}, "151": {"vr": "SH", "Value": ["measured"]}, "152": {"vr": "SH", "Value": ["predicted"]}, "153": {"vr": "SH", "Value": ["measured"]}, "154": {"vr": "SH", "Value": ["measured"]}, "155": {"vr": "SH", "Value": ["measured"]}, "156": {"vr": "SH", "Value": ["measured"]}, "157": {"vr": "SH", "Value": ["predicted"]}, "158": {"vr": "SH", "Value": ["predicted"]}, "159": {"vr": "SH", "Value": ["measured"]}, "160": {"vr": "SH", "Value": ["measured"]}, "161": {"vr": "SH", "Value": ["predicted"]}, "162": {"vr": "SH", "Value": ["measured"]}, "163": {"vr": "SH", "Value": ["measured"]}, "164": {"vr": "SH", "Value": ["predicted"]}, "165": {"vr": "SH", "Value": ["measured"]}, "166": {"vr": "SH", "Value": ["measured"]}, "167": {"vr": "SH", "Value": ["measured"]}, "168": {"vr": "SH", "Value": ["measured"]}, "169": {"vr": "SH", "Value": ["measured"]}, "170": {"vr": "SH", "Value": ["measured"]}, "171": {"vr": "SH", "Value": ["measured"]}, "172": {"vr": "SH", "Value": ["measured"]}, "173": {"vr": "SH", "Value": ["measured"]}, "174": {"vr": "SH", "Value": ["measured"]}, "175": {"vr": "SH", "Value": ["measured"]}, "176": {"vr": "SH", "Value": ["measured"]}, "177": {"vr": "SH", "Value": ["measured"]}, "178": {"vr": "SH", "Value": ["measured"]}, "179": {"vr": "SH", "Value": ["measured"]}, "180": {"vr": "SH", "Value": ["measured"]}, "181": {"vr": "SH", "Value": ["measured"]}, "182": {"vr": "SH", "Value": ["measured"]}, "183": {"vr": "SH", "Value": ["measured"]}, "184": {"vr": "SH", "Value": ["measured"]}, "185": {"vr": "SH", "Value": ["measured"]}, "186": {"vr": "SH", "Value": ["measured"]}, "187": {"vr": "SH", "Value": ["measured"]}, "188": {"vr": "SH", "Value": ["measured"]}, "189": {"vr": "SH", "Value": ["measured"]}, "190": {"vr": "SH", "Value": ["measured"]}, "191": {"vr": "SH", "Value": ["measured"]}}, "0021114E": {"0": {"vr": "IS", "Value": [83]}, "1": {"vr": "IS", "Value": [143]}, "2": {"vr": "IS", "Value": [10]}, "3": {"vr": "IS", "Value": [146]}, "4": {"vr": "IS", "Value": [77]}, "5": {"vr": "IS", "Value": [110]}, "6": {"vr": "IS", "Value": [51]}, "7": {"vr": "IS", "Value": [40]}, "8": {"vr": "IS", "Value": [97]}, "9": {"vr": "IS", "Value": [141]}, "10": {"vr": "IS", "Value": [149]}, "11": {"vr": "IS", "Value": [159]}, "12": {"vr": "IS", "Value": [179]}, "13": {"vr": "IS", "Value": [14]}, "14": {"vr": "IS", "Value": [90]}, "15": {"vr": "IS", "Value": [117]}, "16": {"vr": "IS", "Value": [18]}, "17": {"vr": "IS", "Value": [187]}, "18": {"vr": "IS", "Value": [15]}, "19": {"vr": "IS", "Value": [27]}, "20": {"vr": "IS", "Value": [102]}, "21": {"vr": "IS", "Value": [191]}, "22": {"vr": "IS", "Value": [180]}, "23": {"vr": "IS", "Value": [98]}, "24": {"vr": "IS", "Value": [151]}, "25": {"vr": "IS", "Value": [59]}, "26": {"vr": "IS", "Value": [127]}, "27": {"vr": "IS", "Value": [125]}, "28": {"vr": "IS", "Value": [135]}, "29": {"vr": "IS", "Value": [67]}, "30": {"vr": "IS", "Value": [16]}, "31": {"vr": "IS", "Value": [136]}, "32": {"vr": "IS", "Value": [92]}, "33": {"vr": "IS", "Value": [17]}, "34": {"vr": "IS", "Value": [169]}, "35": {"vr": "IS", "Value": [171]}, "36": {"vr": "IS", "Value": [105]}, "37": {"vr": "IS", "Value": [133]}, "38": {"vr": "IS", "Value": [112]}, "39": {"vr": "IS", "Value": [46]}, "40": {"vr": "IS", "Value": [43]}, "41": {"vr": "IS", "Value": [104]}, "42": {"vr": "IS", "Value": [31]}, "43": {"vr": "IS", "Value": [74]}, "44": {"vr": "IS", "Value": [13]}, "45": {"vr": "IS", "Value": [140]}, "46": {"vr": "IS", "Value": [70]}, "47": {"vr": "IS", "Value": [142]}, "48": {"vr": "IS", "Value": [138]}, "49": {"vr": "IS", "Value": [139]}, "50": {"vr": "IS", "Value": [80]}, "51": {"vr": "IS", "Value": [153]}, "52": {"vr": "IS", "Value": [93]}, "53": {"vr": "IS", "Value": [155]}, "54": {"vr": "IS", "Value": [108]}, "55": {"vr": "IS", "Value": [168]}, "56": {"vr": "IS", "Value": [177]}, "57": {"vr": "IS", "Value": [175]}, "58": {"vr": "IS", "Value": [91]}, "59": {"vr": "IS", "Value": [28]}, "60": {"vr": "IS", "Value": [129]}, "61": {"vr": "IS", "Value": [4]}, "62": {"vr": "IS", "Value": [25]}, "63": {"vr": "IS", "Value": [71]}, "64": {"vr": "IS", "Value": [56]}, "65": {"vr": "IS", "Value": [165]}, "66": {"vr": "IS", "Value": [55]}, "67": {"vr": "IS", "Value": [47]}, "68": {"vr": "IS", "Value": [147]}, "69": {"vr": "IS", "Value": [167]}, "70": {"vr": "IS", "Value": [132]}, "71": {"vr": "IS", "Value": [122]}, "72": {"vr": "IS", "Value": [21]}, "73": {"vr": "IS", "Value": [185]}, "74": {"vr": "IS", "Value": [87]}, "75": {"vr": "IS", "Value": [119]}, "76": {"vr": "IS", "Value": [75]}, "77": {"vr": "IS", "Value": [53]}, "78": {"vr": "IS", "Value": [109]}, "79": {"vr": "IS", "Value": [118]}, "80": {"vr": "IS", "Value": [36]}, "81": {"vr": "IS", "Value": [22]}, "82": {"vr": "IS", "Value": [65]}, "83": {"vr": "IS", "Value": [35]}, "84": {"vr": "IS", "Value": [162]}, "85": {"vr": "IS", "Value": [126]}, "86": {"vr": "IS", "Value": [123]}, "87": {"vr": "IS", "Value": [24]}, "88": {"vr": "IS", "Value": [52]}, "89": {"vr": "IS", "Value": [42]}, "90": {"vr": "IS", "Value": [57]}, "91": {"vr": "IS", "Value": [50]}, "92": {"vr": "IS", "Value": [76]}, "93": {"vr": "IS", "Value": [173]}, "94": {"vr": "IS", "Value": [45]}, "95": {"vr": "IS", "Value": [154]}, "96": {"vr": "IS", "Value": [37]}, "97": {"vr": "IS", "Value": [60]}, "98": {"vr": "IS", "Value": [88]}, "99": {"vr": "IS", "Value": [106]}, "100": {"vr": "IS", "Value": [183]}, "101": {"vr": "IS", "Value": [100]}, "102": {"vr": "IS", "Value": [11]}, "103": {"vr": "IS", "Value": [124]}, "104": {"vr": "IS", "Value": [145]}, "105": {"vr": "IS", "Value": [94]}, "106": {"vr": "IS", "Value": [190]}, "107": {"vr": "IS", "Value": [0]}, "108": {"vr": "IS", "Value": [188]}, "109": {"vr": "IS", "Value": [163]}, "110": {"vr": "IS", "Value": [32]}, "111": {"vr": "IS", "Value": [181]}, "112": {"vr": "IS", "Value": [103]}, "113": {"vr": "IS", "Value": [99]}, "114": {"vr": "IS", "Value": [29]}, "115": {"vr": "IS", "Value": [128]}, "116": {"vr": "IS", "Value": [85]}, "117": {"vr": "IS", "Value": [9]}, "118": {"vr": "IS", "Value": [30]}, "119": {"vr": "IS", "Value": [137]}, "120": {"vr": "IS", "Value": [178]}, "121": {"vr": "IS", "Value": [2]}, "122": {"vr": "IS", "Value": [66]}, "123": {"vr": "IS", "Value": [49]}, "124": {"vr": "IS", "Value": [113]}, "125": {"vr": "IS", "Value": [121]}, "126": {"vr": "IS", "Value": [33]}, "127": {"vr": "IS", "Value": [130]}, "128": {"vr": "IS", "Value": [161]}, "129": {"vr": "IS", "Value": [86]}, "130": {"vr": "IS", "Value": [116]}, "131": {"vr": "IS", "Value": [62]}, "132": {"vr": "IS", "Value": [131]}, "133": {"vr": "IS", "Value": [6]}, "134": {"vr": "IS", "Value": [38]}, "135": {"vr": "IS", "Value": [176]}, "136": {"vr": "IS", "Value": [82]}, "137": {"vr": "IS", "Value": [101]}, "138": {"vr": "IS", "Value": [174]}, "139": {"vr": "IS", "Value": [107]}, "140": {"vr": "IS", "Value": [72]}, "141": {"vr": "IS", "Value": [111]}, "142": {"vr": "IS", "Value": [44]}, "143": {"vr": "IS", "Value": [156]}, "144": {"vr": "IS", "Value": [34]}, "145": {"vr": "IS", "Value": [157]}, "146": {"vr": "IS", "Value": [150]}, "147": {"vr": "IS", "Value": [184]}, "148": {"vr": "IS", "Value": [120]}, "149": {"vr": "IS", "Value": [69]}, "150": {"vr": "IS", "Value": [63]}, "151": {"vr": "IS", "Value": [41]}, "152": {"vr": "IS", "Value": [8]}, "153": {"vr": "IS", "Value": [182]}, "154": {"vr": "IS", "Value": [95]}, "155": {"vr": "IS", "Value": [172]}, "156": {"vr": "IS", "Value": [114]}, "157": {"vr": "IS", "Value": [1]}, "158": {"vr": "IS", "Value": [3]}, "159": {"vr": "IS", "Value": [89]}, "160": {"vr": "IS", "Value": [19]}, "161": {"vr": "IS", "Value": [7]}, "162": {"vr": "IS", "Value": [58]}, "163": {"vr": "IS", "Value": [64]}, "164": {"vr": "IS", "Value": [5]}, "165": {"vr": "IS", "Value": [148]}, "166": {"vr": "IS", "Value": [12]}, "167": {"vr": "IS", "Value": [48]}, "168": {"vr": "IS", "Value": [170]}, "169": {"vr": "IS", "Value": [79]}, "170": {"vr": "IS", "Value": [39]}, "171": {"vr": "IS", "Value": [26]}, "172": {"vr": "IS", "Value": [158]}, "173": {"vr": "IS", "Value": [96]}, "174": {"vr": "IS", "Value": [23]}, "175": {"vr": "IS", "Value": [54]}, "176": {"vr": "IS", "Value": [81]}, "177": {"vr": "IS", "Value": [144]}, "178": {"vr": "IS", "Value": [160]}, "179": {"vr": "IS", "Value": [186]}, "180": {"vr": "IS", "Value": [20]}, "181": {"vr": "IS", "Value": [68]}, "182": {"vr": "IS", "Value": [84]}, "183": {"vr": "IS", "Value": [61]}, "184": {"vr": "IS", "Value": [134]}, "185": {"vr": "IS", "Value": [166]}, "186": {"vr": "IS", "Value": [152]}, "187": {"vr": "IS", "Value": [78]}, "188": {"vr": "IS", "Value": [115]}, "189": {"vr": "IS", "Value": [73]}, "190": {"vr": "IS", "Value": [189]}, "191": {"vr": "IS", "Value": [164]}}, "0021115B": {"0": {"vr": "FD", "Value": [-4.49874177, -107.42080035, 108.17160196]}, "1": {"vr": "FD", "Value": [55.47704743, -106.16467295, 107.01971011]}, "2": {"vr": "FD", "Value": [-77.46928528, -108.94908868, 109.57307038]}, "3": {"vr": "FD", "Value": [58.47583688, -106.10186658, 106.96211551]}, "4": {"vr": "FD", "Value": [-10.49632069, -107.54641309, 108.28679114]}, "5": {"vr": "FD", "Value": [22.49036337, -106.85554302, 107.65325062]}, "6": {"vr": "FD", "Value": [-36.48582934, -108.09073496, 108.78594428]}, "7": {"vr": "FD", "Value": [-47.48139069, -108.32102498, 108.99712445]}, "8": {"vr": "FD", "Value": [9.49560904, -107.12770396, 107.90282719]}, "9": {"vr": "FD", "Value": [53.47785445, -106.20654387, 107.0581065]}, "10": {"vr": "FD", "Value": [61.47462634, -106.03906021, 106.90452092]}, "11": {"vr": "FD", "Value": [71.47059121, -105.82970565, 106.71253894]}, "12": {"vr": "FD", "Value": [91.46252094, -105.41099652, 106.32857499]}, "13": {"vr": "FD", "Value": [-73.47089934, -108.86534685, 109.49627759]}, "14": {"vr": "FD", "Value": [2.49843364, -107.27425215, 108.03721457]}, "15": {"vr": "FD", "Value": [29.48753878, -106.70899482, 107.51886324]}, "16": {"vr": "FD", "Value": [-69.47251339, -108.78160502, 109.4194848]}, "17": {"vr": "FD", "Value": [99.45929283, -105.24351287, 106.17498941]}, "18": {"vr": "FD", "Value": [-72.47130285, -108.84441139, 109.47707939]}, "19": {"vr": "FD", "Value": [-60.47614501, -108.59318591, 109.24670102]}, "20": {"vr": "FD", "Value": [14.49359148, -107.02302667, 107.8068362]}, "21": {"vr": "FD", "Value": [103.45767878, -105.15977104, 106.09819662]}, "22": {"vr": "FD", "Value": [92.46211743, -105.39006106, 106.3093768]}, "23": {"vr": "FD", "Value": [10.49520553, -107.1067685, 107.88362899]}, "24": {"vr": "FD", "Value": [63.47381932, -105.9971893, 106.86612452]}, "25": {"vr": "FD", "Value": [-28.48905744, -107.9232513, 108.6323587]}, "26": {"vr": "FD", "Value": [39.48350364, -106.49964026, 107.32688127]}, "27": {"vr": "FD", "Value": [37.48431067, -106.54151117, 107.36527766]}, "28": {"vr": "FD", "Value": [47.48027553, -106.33215661, 107.17329569]}, "29": {"vr": "FD", "Value": [-20.49228555, -107.75576765, 108.47877312]}, "30": {"vr": "FD", "Value": [-71.47170636, -108.82347594, 109.45788119]}, "31": {"vr": "FD", "Value": [48.47987202, -106.31122115, 107.15409749]}, "32": {"vr": "FD", "Value": [4.49762661, -107.23238124, 107.99881818]}, "33": {"vr": "FD", "Value": [-70.47210988, -108.80254048, 109.43868299]}, "34": {"vr": "FD", "Value": [81.46655607, -105.62035108, 106.52055697]}, "35": {"vr": "FD", "Value": [83.46574905, -105.57848017, 106.48216057]}, "36": {"vr": "FD", "Value": [17.49238094, -106.9602203, 107.74924161]}, "37": {"vr": "FD", "Value": [45.48108256, -106.37402752, 107.21169208]}, "38": {"vr": "FD", "Value": [24.48955634, -106.81367211, 107.61485423]}, "39": {"vr": "FD", "Value": [-41.48381177, -108.19541224, 108.88193527]}, "40": {"vr": "FD", "Value": [-44.48260123, -108.25821861, 108.93952986]}, "41": {"vr": "FD", "Value": [16.49278445, -106.98115576, 107.76843981]}, "42": {"vr": "FD", "Value": [-56.47775907, -108.50944409, 109.16990823]}, "43": {"vr": "FD", "Value": [-13.49511015, -107.60921946, 108.34438574]}, "44": {"vr": "FD", "Value": [-74.47049582, -108.88628231, 109.51547578]}, "45": {"vr": "FD", "Value": [52.47825797, -106.22747932, 107.0773047]}, "46": {"vr": "FD", "Value": [-17.49349609, -107.69296128, 108.42117853]}, "47": {"vr": "FD", "Value": [54.47745094, -106.18560841, 107.0389083]}, "48": {"vr": "FD", "Value": [50.47906499, -106.26935024, 107.11570109]}, "49": {"vr": "FD", "Value": [51.47866148, -106.24841478, 107.0965029]}, "50": {"vr": "FD", "Value": [-7.49753123, -107.48360672, 108.22919655]}, "51": {"vr": "FD", "Value": [65.47301229, -105.95531839, 106.82772813]}, "52": {"vr": "FD", "Value": [5.4972231, -107.21144578, 107.97961998]}, "53": {"vr": "FD", "Value": [67.47220526, -105.91344748, 106.78933173]}, "54": {"vr": "FD", "Value": [20.4911704, -106.89741393, 107.69164702]}, "55": {"vr": "FD", "Value": [80.46695959, -105.64128654, 106.53975517]}, "56": {"vr": "FD", "Value": [89.46332797, -105.45286743, 106.36697139]}, "57": {"vr": "FD", "Value": [87.46413499, -105.49473834, 106.40536778]}, "58": {"vr": "FD", "Value": [3.49803013, -107.25331669, 108.01801638]}, "59": {"vr": "FD", "Value": [-59.47654853, -108.57225046, 109.22750282]}, "60": {"vr": "FD", "Value": [41.48269661, -106.45776935, 107.28848487]}, "61": {"vr": "FD", "Value": [-83.4668642, -109.07470141, 109.68825956]}, "62": {"vr": "FD", "Value": [-62.47533798, -108.63505683, 109.28509741]}, "63": {"vr": "FD", "Value": [-16.4938996, -107.67202583, 108.40198033]}, "64": {"vr": "FD", "Value": [-31.4878469, -107.98605767, 108.68995329]}, "65": {"vr": "FD", "Value": [77.46817013, -105.70409291, 106.59734976]}, "66": {"vr": "FD", "Value": [-32.48744339, -108.00699313, 108.70915149]}, "67": {"vr": "FD", "Value": [-40.48421528, -108.17447678, 108.86273707]}, "68": {"vr": "FD", "Value": [59.47543337, -106.08093113, 106.94291732]}, "69": {"vr": "FD", "Value": [79.4673631, -105.662222, 106.55895336]}, "70": {"vr": "FD", "Value": [44.48148607, -106.39496298, 107.23089028]}, "71": {"vr": "FD", "Value": [34.48552121, -106.60431754, 107.42287225]}, "72": {"vr": "FD", "Value": [-66.47372393, -108.71879865, 109.3618902]}, "73": {"vr": "FD", "Value": [97.46009986, -105.28538378, 106.21338581]}, "74": {"vr": "FD", "Value": [-0.50035582, -107.33705852, 108.09480917]}, "75": {"vr": "FD", "Value": [31.48673175, -106.66712391, 107.48046685]}, "76": {"vr": "FD", "Value": [-12.49551366, -107.588284, 108.32518754]}, "77": {"vr": "FD", "Value": [-34.48663636, -108.04886404, 108.74754788]}, "78": {"vr": "FD", "Value": [21.49076688, -106.87647848, 107.67244882]}, "79": {"vr": "FD", "Value": [30.48713526, -106.68805937, 107.49966504]}, "80": {"vr": "FD", "Value": [-51.47977663, -108.4047668, 109.07391724]}, "81": {"vr": "FD", "Value": [-65.47412744, -108.6978632, 109.34269201]}, "82": {"vr": "FD", "Value": [-22.49147852, -107.79763856, 108.51716951]}, "83": {"vr": "FD", "Value": [-52.47937312, -108.42570226, 109.09311544]}, "84": {"vr": "FD", "Value": [74.46938067, -105.76689928, 106.65494435]}, "85": {"vr": "FD", "Value": [38.48390715, -106.52057572, 107.34607946]}, "86": {"vr": "FD", "Value": [35.48511769, -106.58338208, 107.40367406]}, "87": {"vr": "FD", "Value": [-63.47493447, -108.65599228, 109.30429561]}, "88": {"vr": "FD", "Value": [-35.48623285, -108.0697995, 108.76674608]}, "89": {"vr": "FD", "Value": [-45.48219771, -108.27915407, 108.95872806]}, "90": {"vr": "FD", "Value": [-30.48825042, -107.96512222, 108.67075509]}, "91": {"vr": "FD", "Value": [-37.48542582, -108.11167041, 108.80514248]}, "92": {"vr": "FD", "Value": [-11.49591717, -107.56734854, 108.30598934]}, "93": {"vr": "FD", "Value": [85.46494202, -105.53660926, 106.44376418]}, "94": {"vr": "FD", "Value": [-42.48340825, -108.2163477, 108.90113346]}, "95": {"vr": "FD", "Value": [66.47260878, -105.93438293, 106.80852993]}, "96": {"vr": "FD", "Value": [-50.48018015, -108.38383135, 109.05471904]}, "97": {"vr": "FD", "Value": [-27.48946096, -107.90231585, 108.6131605]}, "98": {"vr": "FD", "Value": [0.49924067, -107.31612306, 108.07561097]}, "99": {"vr": "FD", "Value": [18.49197742, -106.93928485, 107.73004341]}, "100": {"vr": "FD", "Value": [95.46090689, -105.32725469, 106.2517822]}, "101": {"vr": "FD", "Value": [12.4943985, -107.06489759, 107.8452326]}, "102": {"vr": "FD", "Value": [-76.4696888, -108.92815322, 109.55387218]}, "103": {"vr": "FD", "Value": [36.48471418, -106.56244663, 107.38447586]}, "104": {"vr": "FD", "Value": [57.4762404, -106.12280204, 106.98131371]}, "105": {"vr": "FD", "Value": [6.49681959, -107.19051032, 107.96042178]}, "106": {"vr": "FD", "Value": [102.45808229, -105.1807065, 106.11739482]}, "107": {"vr": "FD", "Value": [-87.46525015, -109.15844324, 109.76505235]}, "108": {"vr": "FD", "Value": [100.45888932, -105.22257741, 106.15579122]}, "109": {"vr": "FD", "Value": [75.46897716, -105.74596382, 106.63574615]}, "110": {"vr": "FD", "Value": [-55.47816258, -108.48850863, 109.15071003]}, "111": {"vr": "FD", "Value": [93.46171391, -105.3691256, 106.2901786]}, "112": {"vr": "FD", "Value": [15.49318796, -107.00209122, 107.78763801]}, "113": {"vr": "FD", "Value": [11.49480202, -107.08583304, 107.8644308]}, "114": {"vr": "FD", "Value": [-58.47695204, -108.551315, 109.20830462]}, "115": {"vr": "FD", "Value": [40.48310013, -106.4787048, 107.30768307]}, "116": {"vr": "FD", "Value": [-2.49954879, -107.37892943, 108.13320556]}, "117": {"vr": "FD", "Value": [-78.46888177, -108.97002413, 109.59226857]}, "118": {"vr": "FD", "Value": [-57.47735555, -108.53037954, 109.18910643]}, "119": {"vr": "FD", "Value": [49.47946851, -106.29028569, 107.13489929]}, "120": {"vr": "FD", "Value": [90.46292445, -105.43193197, 106.34777319]}, "121": {"vr": "FD", "Value": [-85.46605717, -109.11657233, 109.72665596]}, "122": {"vr": "FD", "Value": [-21.49188204, -107.77670311, 108.49797132]}, "123": {"vr": "FD", "Value": [-38.48502231, -108.13260587, 108.82434067]}, "124": {"vr": "FD", "Value": [25.48915283, -106.79273665, 107.59565603]}, "125": {"vr": "FD", "Value": [33.48592472, -106.625253, 107.44207045]}, "126": {"vr": "FD", "Value": [-54.47856609, -108.46757317, 109.13151183]}, "127": {"vr": "FD", "Value": [42.4822931, -106.43683389, 107.26928667]}, "128": {"vr": "FD", "Value": [73.46978418, -105.78783474, 106.67414255]}, "129": {"vr": "FD", "Value": [-1.49995231, -107.35799398, 108.11400736]}, "130": {"vr": "FD", "Value": [28.48794229, -106.72993028, 107.53806144]}, "131": {"vr": "FD", "Value": [-25.49026798, -107.86044493, 108.57476411]}, "132": {"vr": "FD", "Value": [43.48188959, -106.41589843, 107.25008848]}, "133": {"vr": "FD", "Value": [-81.46767123, -109.0328305, 109.64986317]}, "134": {"vr": "FD", "Value": [-49.48058366, -108.36289589, 109.03552085]}, "135": {"vr": "FD", "Value": [88.46373148, -105.47380289, 106.38616959]}, "136": {"vr": "FD", "Value": [-5.49833825, -107.4417358, 108.19080015]}, "137": {"vr": "FD", "Value": [13.49399499, -107.04396213, 107.8260344]}, "138": {"vr": "FD", "Value": [86.46453851, -105.5156738, 106.42456598]}, "139": {"vr": "FD", "Value": [19.49157391, -106.91834939, 107.71084522]}, "140": {"vr": "FD", "Value": [-15.49430312, -107.65109037, 108.38278213]}, "141": {"vr": "FD", "Value": [23.48995986, -106.83460756, 107.63405243]}, "142": {"vr": "FD", "Value": [-43.48300474, -108.23728315, 108.92033166]}, "143": {"vr": "FD", "Value": [68.47180175, -105.89251202, 106.77013354]}, "144": {"vr": "FD", "Value": [-53.47896961, -108.44663772, 109.11231364]}, "145": {"vr": "FD", "Value": [69.47139824, -105.87157656, 106.75093534]}, "146": {"vr": "FD", "Value": [62.47422283, -106.01812476, 106.88532272]}, "147": {"vr": "FD", "Value": [96.46050337, -105.30631924, 106.23258401]}, "148": {"vr": "FD", "Value": [32.48632824, -106.64618845, 107.46126865]}, "149": {"vr": "FD", "Value": [-18.49309258, -107.71389674, 108.44037672]}, "150": {"vr": "FD", "Value": [-24.4906715, -107.83950948, 108.55556591]}, "151": {"vr": "FD", "Value": [-46.4817942, -108.30008952, 108.97792625]}, "152": {"vr": "FD", "Value": [-79.46847826, -108.99095959, 109.61146677]}, "153": {"vr": "FD", "Value": [94.4613104, -105.34819015, 106.2709804]}, "154": {"vr": "FD", "Value": [7.49641607, -107.16957487, 107.94122359]}, "155": {"vr": "FD", "Value": [84.46534553, -105.55754471, 106.46296238]}, "156": {"vr": "FD", "Value": [26.48874932, -106.77180119, 107.57645783]}, "157": {"vr": "FD", "Value": [-86.46565366, -109.13750778, 109.74585416]}, "158": {"vr": "FD", "Value": [-84.46646069, -109.09563687, 109.70745776]}, "159": {"vr": "FD", "Value": [1.49883715, -107.29518761, 108.05641277]}, "160": {"vr": "FD", "Value": [-68.4729169, -108.76066957, 109.4002866]}, "161": {"vr": "FD", "Value": [-80.46807474, -109.01189504, 109.63066497]}, "162": {"vr": "FD", "Value": [-29.48865393, -107.94418676, 108.6515569]}, "163": {"vr": "FD", "Value": [-23.49107501, -107.81857402, 108.53636771]}, "164": {"vr": "FD", "Value": [-82.46726772, -109.05376596, 109.66906136]}, "165": {"vr": "FD", "Value": [60.47502986, -106.05999567, 106.92371912]}, "166": {"vr": "FD", "Value": [-75.47009231, -108.90721776, 109.53467398]}, "167": {"vr": "FD", "Value": [-39.48461879, -108.15354133, 108.84353887]}, "168": {"vr": "FD", "Value": [82.46615256, -105.59941563, 106.50135877]}, "169": {"vr": "FD", "Value": [-8.49712771, -107.50454217, 108.24839475]}, "170": {"vr": "FD", "Value": [-48.48098717, -108.34196044, 109.01632265]}, "171": {"vr": "FD", "Value": [-61.4757415, -108.61412137, 109.26589922]}, "172": {"vr": "FD", "Value": [70.47099472, -105.85064111, 106.73173714]}, "173": {"vr": "FD", "Value": [8.49601256, -107.14863941, 107.92202539]}, "174": {"vr": "FD", "Value": [-64.47453096, -108.67692774, 109.32349381]}, "175": {"vr": "FD", "Value": [-33.48703988, -108.02792859, 108.72834969]}, "176": {"vr": "FD", "Value": [-6.49793474, -107.46267126, 108.20999835]}, "177": {"vr": "FD", "Value": [56.47664391, -106.1437375, 107.00051191]}, "178": {"vr": "FD", "Value": [72.4701877, -105.80877019, 106.69334075]}, "179": {"vr": "FD", "Value": [98.45969635, -105.26444832, 106.19418761]}, "180": {"vr": "FD", "Value": [-67.47332042, -108.73973411, 109.3810884]}, "181": {"vr": "FD", "Value": [-19.49268906, -107.7348322, 108.45957492]}, "182": {"vr": "FD", "Value": [-3.49914528, -107.39986489, 108.15240376]}, "183": {"vr": "FD", "Value": [-26.48986447, -107.88138039, 108.5939623]}, "184": {"vr": "FD", "Value": [46.48067905, -106.35309206, 107.19249388]}, "185": {"vr": "FD", "Value": [78.46776662, -105.68315745, 106.57815156]}, "186": {"vr": "FD", "Value": [64.4734158, -105.97625384, 106.84692633]}, "187": {"vr": "FD", "Value": [-9.4967242, -107.52547763, 108.26759294]}, "188": {"vr": "FD", "Value": [27.4883458, -106.75086574, 107.55725964]}, "189": {"vr": "FD", "Value": [-14.49470663, -107.63015491, 108.36358393]}, "190": {"vr": "FD", "Value": [101.45848581, -105.20164195, 106.13659302]}, "191": {"vr": "FD", "Value": [76.46857364, -105.72502837, 106.61654796]}}, "00280107": {"0": {"vr": "US", "Value": [617]}, "1": {"vr": "US", "Value": [595]}, "2": {"vr": "US", "Value": [255]}, "3": {"vr": "US", "Value": [579]}, "4": {"vr": "US", "Value": [760]}, "5": {"vr": "US", "Value": [623]}, "6": {"vr": "US", "Value": [567]}, "7": {"vr": "US", "Value": [568]}, "8": {"vr": "US", "Value": [635]}, "9": {"vr": "US", "Value": [587]}, "10": {"vr": "US", "Value": [633]}, "11": {"vr": "US", "Value": [660]}, "12": {"vr": "US", "Value": [694]}, "13": {"vr": "US", "Value": [559]}, "14": {"vr": "US", "Value": [597]}, "15": {"vr": "US", "Value": [676]}, "16": {"vr": "US", "Value": [609]}, "17": {"vr": "US", "Value": [28]}, "18": {"vr": "US", "Value": [560]}, "19": {"vr": "US", "Value": [532]}, "20": {"vr": "US", "Value": [626]}, "21": {"vr": "US", "Value": [34]}, "22": {"vr": "US", "Value": [725]}, "23": {"vr": "US", "Value": [603]}, "24": {"vr": "US", "Value": [647]}, "25": {"vr": "US", "Value": [636]}, "26": {"vr": "US", "Value": [670]}, "27": {"vr": "US", "Value": [674]}, "28": {"vr": "US", "Value": [638]}, "29": {"vr": "US", "Value": [699]}, "30": {"vr": "US", "Value": [635]}, "31": {"vr": "US", "Value": [606]}, "32": {"vr": "US", "Value": [648]}, "33": {"vr": "US", "Value": [703]}, "34": {"vr": "US", "Value": [604]}, "35": {"vr": "US", "Value": [592]}, "36": {"vr": "US", "Value": [804]}, "37": {"vr": "US", "Value": [672]}, "38": {"vr": "US", "Value": [607]}, "39": {"vr": "US", "Value": [562]}, "40": {"vr": "US", "Value": [559]}, "41": {"vr": "US", "Value": [646]}, "42": {"vr": "US", "Value": [521]}, "43": {"vr": "US", "Value": [621]}, "44": {"vr": "US", "Value": [574]}, "45": {"vr": "US", "Value": [608]}, "46": {"vr": "US", "Value": [647]}, "47": {"vr": "US", "Value": [580]}, "48": {"vr": "US", "Value": [572]}, "49": {"vr": "US", "Value": [595]}, "50": {"vr": "US", "Value": [666]}, "51": {"vr": "US", "Value": [643]}, "52": {"vr": "US", "Value": [614]}, "53": {"vr": "US", "Value": [654]}, "54": {"vr": "US", "Value": [674]}, "55": {"vr": "US", "Value": [586]}, "56": {"vr": "US", "Value": [578]}, "57": {"vr": "US", "Value": [576]}, "58": {"vr": "US", "Value": [622]}, "59": {"vr": "US", "Value": [526]}, "60": {"vr": "US", "Value": [740]}, "61": {"vr": "US", "Value": [25]}, "62": {"vr": "US", "Value": [574]}, "63": {"vr": "US", "Value": [653]}, "64": {"vr": "US", "Value": [588]}, "65": {"vr": "US", "Value": [571]}, "66": {"vr": "US", "Value": [563]}, "67": {"vr": "US", "Value": [567]}, "68": {"vr": "US", "Value": [609]}, "69": {"vr": "US", "Value": [556]}, "70": {"vr": "US", "Value": [652]}, "71": {"vr": "US", "Value": [650]}, "72": {"vr": "US", "Value": [612]}, "73": {"vr": "US", "Value": [141]}, "74": {"vr": "US", "Value": [636]}, "75": {"vr": "US", "Value": [708]}, "76": {"vr": "US", "Value": [652]}, "77": {"vr": "US", "Value": [611]}, "78": {"vr": "US", "Value": [663]}, "79": {"vr": "US", "Value": [619]}, "80": {"vr": "US", "Value": [572]}, "81": {"vr": "US", "Value": [566]}, "82": {"vr": "US", "Value": [688]}, "83": {"vr": "US", "Value": [557]}, "84": {"vr": "US", "Value": [584]}, "85": {"vr": "US", "Value": [665]}, "86": {"vr": "US", "Value": [614]}, "87": {"vr": "US", "Value": [590]}, "88": {"vr": "US", "Value": [567]}, "89": {"vr": "US", "Value": [553]}, "90": {"vr": "US", "Value": [615]}, "91": {"vr": "US", "Value": [552]}, "92": {"vr": "US", "Value": [725]}, "93": {"vr": "US", "Value": [587]}, "94": {"vr": "US", "Value": [587]}, "95": {"vr": "US", "Value": [666]}, "96": {"vr": "US", "Value": [564]}, "97": {"vr": "US", "Value": [593]}, "98": {"vr": "US", "Value": [618]}, "99": {"vr": "US", "Value": [836]}, "100": {"vr": "US", "Value": [450]}, "101": {"vr": "US", "Value": [604]}, "102": {"vr": "US", "Value": [433]}, "103": {"vr": "US", "Value": [692]}, "104": {"vr": "US", "Value": [578]}, "105": {"vr": "US", "Value": [612]}, "106": {"vr": "US", "Value": [31]}, "107": {"vr": "US", "Value": [23]}, "108": {"vr": "US", "Value": [31]}, "109": {"vr": "US", "Value": [610]}, "110": {"vr": "US", "Value": [574]}, "111": {"vr": "US", "Value": [630]}, "112": {"vr": "US", "Value": [620]}, "113": {"vr": "US", "Value": [597]}, "114": {"vr": "US", "Value": [513]}, "115": {"vr": "US", "Value": [737]}, "116": {"vr": "US", "Value": [601]}, "117": {"vr": "US", "Value": [166]}, "118": {"vr": "US", "Value": [517]}, "119": {"vr": "US", "Value": [578]}, "120": {"vr": "US", "Value": [523]}, "121": {"vr": "US", "Value": [22]}, "122": {"vr": "US", "Value": [596]}, "123": {"vr": "US", "Value": [557]}, "124": {"vr": "US", "Value": [727]}, "125": {"vr": "US", "Value": [720]}, "126": {"vr": "US", "Value": [535]}, "127": {"vr": "US", "Value": [722]}, "128": {"vr": "US", "Value": [586]}, "129": {"vr": "US", "Value": [657]}, "130": {"vr": "US", "Value": [665]}, "131": {"vr": "US", "Value": [612]}, "132": {"vr": "US", "Value": [717]}, "133": {"vr": "US", "Value": [26]}, "134": {"vr": "US", "Value": [584]}, "135": {"vr": "US", "Value": [520]}, "136": {"vr": "US", "Value": [619]}, "137": {"vr": "US", "Value": [632]}, "138": {"vr": "US", "Value": [620]}, "139": {"vr": "US", "Value": [732]}, "140": {"vr": "US", "Value": [694]}, "141": {"vr": "US", "Value": [599]}, "142": {"vr": "US", "Value": [578]}, "143": {"vr": "US", "Value": [638]}, "144": {"vr": "US", "Value": [530]}, "145": {"vr": "US", "Value": [625]}, "146": {"vr": "US", "Value": [597]}, "147": {"vr": "US", "Value": [415]}, "148": {"vr": "US", "Value": [699]}, "149": {"vr": "US", "Value": [657]}, "150": {"vr": "US", "Value": [642]}, "151": {"vr": "US", "Value": [574]}, "152": {"vr": "US", "Value": [38]}, "153": {"vr": "US", "Value": [539]}, "154": {"vr": "US", "Value": [712]}, "155": {"vr": "US", "Value": [591]}, "156": {"vr": "US", "Value": [664]}, "157": {"vr": "US", "Value": [21]}, "158": {"vr": "US", "Value": [22]}, "159": {"vr": "US", "Value": [617]}, "160": {"vr": "US", "Value": [601]}, "161": {"vr": "US", "Value": [26]}, "162": {"vr": "US", "Value": [632]}, "163": {"vr": "US", "Value": [637]}, "164": {"vr": "US", "Value": [22]}, "165": {"vr": "US", "Value": [601]}, "166": {"vr": "US", "Value": [590]}, "167": {"vr": "US", "Value": [548]}, "168": {"vr": "US", "Value": [602]}, "169": {"vr": "US", "Value": [706]}, "170": {"vr": "US", "Value": [585]}, "171": {"vr": "US", "Value": [543]}, "172": {"vr": "US", "Value": [605]}, "173": {"vr": "US", "Value": [629]}, "174": {"vr": "US", "Value": [521]}, "175": {"vr": "US", "Value": [626]}, "176": {"vr": "US", "Value": [595]}, "177": {"vr": "US", "Value": [601]}, "178": {"vr": "US", "Value": [591]}, "179": {"vr": "US", "Value": [32]}, "180": {"vr": "US", "Value": [548]}, "181": {"vr": "US", "Value": [717]}, "182": {"vr": "US", "Value": [616]}, "183": {"vr": "US", "Value": [604]}, "184": {"vr": "US", "Value": [564]}, "185": {"vr": "US", "Value": [598]}, "186": {"vr": "US", "Value": [614]}, "187": {"vr": "US", "Value": [733]}, "188": {"vr": "US", "Value": [635]}, "189": {"vr": "US", "Value": [643]}, "190": {"vr": "US", "Value": [30]}, "191": {"vr": "US", "Value": [564]}}, "00281050": {"0": {"vr": "DS", "Value": [276.0]}, "1": {"vr": "DS", "Value": [285.0]}, "2": {"vr": "DS", "Value": [46.0]}, "3": {"vr": "DS", "Value": [280.0]}, "4": {"vr": "DS", "Value": [280.0]}, "5": {"vr": "DS", "Value": [282.0]}, "6": {"vr": "DS", "Value": [288.0]}, "7": {"vr": "DS", "Value": [279.0]}, "8": {"vr": "DS", "Value": [266.0]}, "9": {"vr": "DS", "Value": [287.0]}, "10": {"vr": "DS", "Value": [292.0]}, "11": {"vr": "DS", "Value": [349.0]}, "12": {"vr": "DS", "Value": [230.0]}, "13": {"vr": "DS", "Value": [200.0]}, "14": {"vr": "DS", "Value": [270.0]}, "15": {"vr": "DS", "Value": [286.0]}, "16": {"vr": "DS", "Value": [320.0]}, "17": {"vr": "DS", "Value": [14.0]}, "18": {"vr": "DS", "Value": [219.0]}, "19": {"vr": "DS", "Value": [317.0]}, "20": {"vr": "DS", "Value": [274.0]}, "21": {"vr": "DS", "Value": [17.0]}, "22": {"vr": "DS", "Value": [233.0]}, "23": {"vr": "DS", "Value": [267.0]}, "24": {"vr": "DS", "Value": [299.0]}, "25": {"vr": "DS", "Value": [283.0]}, "26": {"vr": "DS", "Value": [290.0]}, "27": {"vr": "DS", "Value": [287.0]}, "28": {"vr": "DS", "Value": [301.0]}, "29": {"vr": "DS", "Value": [284.0]}, "30": {"vr": "DS", "Value": [255.0]}, "31": {"vr": "DS", "Value": [300.0]}, "32": {"vr": "DS", "Value": [269.0]}, "33": {"vr": "DS", "Value": [307.0]}, "34": {"vr": "DS", "Value": [331.0]}, "35": {"vr": "DS", "Value": [295.0]}, "36": {"vr": "DS", "Value": [281.0]}, "37": {"vr": "DS", "Value": [296.0]}, "38": {"vr": "DS", "Value": [283.0]}, "39": {"vr": "DS", "Value": [274.0]}, "40": {"vr": "DS", "Value": [273.0]}, "41": {"vr": "DS", "Value": [280.0]}, "42": {"vr": "DS", "Value": [306.0]}, "43": {"vr": "DS", "Value": [281.0]}, "44": {"vr": "DS", "Value": [196.0]}, "45": {"vr": "DS", "Value": [290.0]}, "46": {"vr": "DS", "Value": [278.0]}, "47": {"vr": "DS", "Value": [288.0]}, "48": {"vr": "DS", "Value": [293.0]}, "49": {"vr": "DS", "Value": [291.0]}, "50": {"vr": "DS", "Value": [278.0]}, "51": {"vr": "DS", "Value": [313.0]}, "52": {"vr": "DS", "Value": [265.0]}, "53": {"vr": "DS", "Value": [325.0]}, "54": {"vr": "DS", "Value": [282.0]}, "55": {"vr": "DS", "Value": [335.0]}, "56": {"vr": "DS", "Value": [217.0]}, "57": {"vr": "DS", "Value": [226.0]}, "58": {"vr": "DS", "Value": [272.0]}, "59": {"vr": "DS", "Value": [311.0]}, "60": {"vr": "DS", "Value": [290.0]}, "61": {"vr": "DS", "Value": [12.0]}, "62": {"vr": "DS", "Value": [343.0]}, "63": {"vr": "DS", "Value": [280.0]}, "64": {"vr": "DS", "Value": [285.0]}, "65": {"vr": "DS", "Value": [355.0]}, "66": {"vr": "DS", "Value": [288.0]}, "67": {"vr": "DS", "Value": [276.0]}, "68": {"vr": "DS", "Value": [285.0]}, "69": {"vr": "DS", "Value": [340.0]}, "70": {"vr": "DS", "Value": [294.0]}, "71": {"vr": "DS", "Value": [285.0]}, "72": {"vr": "DS", "Value": [334.0]}, "73": {"vr": "DS", "Value": [30.0]}, "74": {"vr": "DS", "Value": [272.0]}, "75": {"vr": "DS", "Value": [287.0]}, "76": {"vr": "DS", "Value": [280.0]}, "77": {"vr": "DS", "Value": [293.0]}, "78": {"vr": "DS", "Value": [282.0]}, "79": {"vr": "DS", "Value": [286.0]}, "80": {"vr": "DS", "Value": [280.0]}, "81": {"vr": "DS", "Value": [336.0]}, "82": {"vr": "DS", "Value": [284.0]}, "83": {"vr": "DS", "Value": [285.0]}, "84": {"vr": "DS", "Value": [354.0]}, "85": {"vr": "DS", "Value": [290.0]}, "86": {"vr": "DS", "Value": [286.0]}, "87": {"vr": "DS", "Value": [345.0]}, "88": {"vr": "DS", "Value": [291.0]}, "89": {"vr": "DS", "Value": [276.0]}, "90": {"vr": "DS", "Value": [284.0]}, "91": {"vr": "DS", "Value": [285.0]}, "92": {"vr": "DS", "Value": [280.0]}, "93": {"vr": "DS", "Value": [309.0]}, "94": {"vr": "DS", "Value": [274.0]}, "95": {"vr": "DS", "Value": [316.0]}, "96": {"vr": "DS", "Value": [277.0]}, "97": {"vr": "DS", "Value": [285.0]}, "98": {"vr": "DS", "Value": [270.0]}, "99": {"vr": "DS", "Value": [282.0]}, "100": {"vr": "DS", "Value": [180.0]}, "101": {"vr": "DS", "Value": [268.0]}, "102": {"vr": "DS", "Value": [190.0]}, "103": {"vr": "DS", "Value": [286.0]}, "104": {"vr": "DS", "Value": [280.0]}, "105": {"vr": "DS", "Value": [264.0]}, "106": {"vr": "DS", "Value": [15.0]}, "107": {"vr": "DS", "Value": [11.0]}, "108": {"vr": "DS", "Value": [15.0]}, "109": {"vr": "DS", "Value": [357.0]}, "110": {"vr": "DS", "Value": [304.0]}, "111": {"vr": "DS", "Value": [228.0]}, "112": {"vr": "DS", "Value": [276.0]}, "113": {"vr": "DS", "Value": [268.0]}, "114": {"vr": "DS", "Value": [310.0]}, "115": {"vr": "DS", "Value": [290.0]}, "116": {"vr": "DS", "Value": [273.0]}, "117": {"vr": "DS", "Value": [33.0]}, "118": {"vr": "DS", "Value": [309.0]}, "119": {"vr": "DS", "Value": [296.0]}, "120": {"vr": "DS", "Value": [220.0]}, "121": {"vr": "DS", "Value": [11.0]}, "122": {"vr": "DS", "Value": [283.0]}, "123": {"vr": "DS", "Value": [283.0]}, "124": {"vr": "DS", "Value": [285.0]}, "125": {"vr": "DS", "Value": [286.0]}, "126": {"vr": "DS", "Value": [299.0]}, "127": {"vr": "DS", "Value": [292.0]}, "128": {"vr": "DS", "Value": [352.0]}, "129": {"vr": "DS", "Value": [273.0]}, "130": {"vr": "DS", "Value": [287.0]}, "131": {"vr": "DS", "Value": [285.0]}, "132": {"vr": "DS", "Value": [293.0]}, "133": {"vr": "DS", "Value": [13.0]}, "134": {"vr": "DS", "Value": [277.0]}, "135": {"vr": "DS", "Value": [203.0]}, "136": {"vr": "DS", "Value": [276.0]}, "137": {"vr": "DS", "Value": [272.0]}, "138": {"vr": "DS", "Value": [273.0]}, "139": {"vr": "DS", "Value": [282.0]}, "140": {"vr": "DS", "Value": [281.0]}, "141": {"vr": "DS", "Value": [283.0]}, "142": {"vr": "DS", "Value": [274.0]}, "143": {"vr": "DS", "Value": [337.0]}, "144": {"vr": "DS", "Value": [290.0]}, "145": {"vr": "DS", "Value": [343.0]}, "146": {"vr": "DS", "Value": [296.0]}, "147": {"vr": "DS", "Value": [110.0]}, "148": {"vr": "DS", "Value": [286.0]}, "149": {"vr": "DS", "Value": [279.0]}, "150": {"vr": "DS", "Value": [285.0]}, "151": {"vr": "DS", "Value": [278.0]}, "152": {"vr": "DS", "Value": [19.0]}, "153": {"vr": "DS", "Value": [208.0]}, "154": {"vr": "DS", "Value": [264.0]}, "155": {"vr": "DS", "Value": [300.0]}, "156": {"vr": "DS", "Value": [283.0]}, "157": {"vr": "DS", "Value": [10.0]}, "158": {"vr": "DS", "Value": [11.0]}, "159": {"vr": "DS", "Value": [270.0]}, "160": {"vr": "DS", "Value": [328.0]}, "161": {"vr": "DS", "Value": [13.0]}, "162": {"vr": "DS", "Value": [283.0]}, "163": {"vr": "DS", "Value": [285.0]}, "164": {"vr": "DS", "Value": [11.0]}, "165": {"vr": "DS", "Value": [287.0]}, "166": {"vr": "DS", "Value": [200.0]}, "167": {"vr": "DS", "Value": [280.0]}, "168": {"vr": "DS", "Value": [305.0]}, "169": {"vr": "DS", "Value": [282.0]}, "170": {"vr": "DS", "Value": [280.0]}, "171": {"vr": "DS", "Value": [331.0]}, "172": {"vr": "DS", "Value": [346.0]}, "173": {"vr": "DS", "Value": [265.0]}, "174": {"vr": "DS", "Value": [338.0]}, "175": {"vr": "DS", "Value": [290.0]}, "176": {"vr": "DS", "Value": [277.0]}, "177": {"vr": "DS", "Value": [283.0]}, "178": {"vr": "DS", "Value": [349.0]}, "179": {"vr": "DS", "Value": [16.0]}, "180": {"vr": "DS", "Value": [329.0]}, "181": {"vr": "DS", "Value": [282.0]}, "182": {"vr": "DS", "Value": [274.0]}, "183": {"vr": "DS", "Value": [285.0]}, "184": {"vr": "DS", "Value": [295.0]}, "185": {"vr": "DS", "Value": [350.0]}, "186": {"vr": "DS", "Value": [306.0]}, "187": {"vr": "DS", "Value": [283.0]}, "188": {"vr": "DS", "Value": [284.0]}, "189": {"vr": "DS", "Value": [281.0]}, "190": {"vr": "DS", "Value": [15.0]}, "191": {"vr": "DS", "Value": [354.0]}}, "00281051": {"0": {"vr": "DS", "Value": [631.0]}, "1": {"vr": "DS", "Value": [658.0]}, "2": {"vr": "DS", "Value": [142.0]}, "3": {"vr": "DS", "Value": [648.0]}, "4": {"vr": "DS", "Value": [637.0]}, "5": {"vr": "DS", "Value": [640.0]}, "6": {"vr": "DS", "Value": [663.0]}, "7": {"vr": "DS", "Value": [640.0]}, "8": {"vr": "DS", "Value": [620.0]}, "9": {"vr": "DS", "Value": [661.0]}, "10": {"vr": "DS", "Value": [666.0]}, "11": {"vr": "DS", "Value": [752.0]}, "12": {"vr": "DS", "Value": [474.0]}, "13": {"vr": "DS", "Value": [455.0]}, "14": {"vr": "DS", "Value": [623.0]}, "15": {"vr": "DS", "Value": [644.0]}, "16": {"vr": "DS", "Value": [686.0]}, "17": {"vr": "DS", "Value": [28.0]}, "18": {"vr": "DS", "Value": [504.0]}, "19": {"vr": "DS", "Value": [692.0]}, "20": {"vr": "DS", "Value": [631.0]}, "21": {"vr": "DS", "Value": [34.0]}, "22": {"vr": "DS", "Value": [478.0]}, "23": {"vr": "DS", "Value": [624.0]}, "24": {"vr": "DS", "Value": [674.0]}, "25": {"vr": "DS", "Value": [650.0]}, "26": {"vr": "DS", "Value": [659.0]}, "27": {"vr": "DS", "Value": [654.0]}, "28": {"vr": "DS", "Value": [681.0]}, "29": {"vr": "DS", "Value": [650.0]}, "30": {"vr": "DS", "Value": [571.0]}, "31": {"vr": "DS", "Value": [683.0]}, "32": {"vr": "DS", "Value": [624.0]}, "33": {"vr": "DS", "Value": [663.0]}, "34": {"vr": "DS", "Value": [713.0]}, "35": {"vr": "DS", "Value": [646.0]}, "36": {"vr": "DS", "Value": [642.0]}, "37": {"vr": "DS", "Value": [671.0]}, "38": {"vr": "DS", "Value": [640.0]}, "39": {"vr": "DS", "Value": [635.0]}, "40": {"vr": "DS", "Value": [632.0]}, "41": {"vr": "DS", "Value": [640.0]}, "42": {"vr": "DS", "Value": [677.0]}, "43": {"vr": "DS", "Value": [638.0]}, "44": {"vr": "DS", "Value": [436.0]}, "45": {"vr": "DS", "Value": [666.0]}, "46": {"vr": "DS", "Value": [633.0]}, "47": {"vr": "DS", "Value": [661.0]}, "48": {"vr": "DS", "Value": [670.0]}, "49": {"vr": "DS", "Value": [669.0]}, "50": {"vr": "DS", "Value": [636.0]}, "51": {"vr": "DS", "Value": [697.0]}, "52": {"vr": "DS", "Value": [619.0]}, "53": {"vr": "DS", "Value": [716.0]}, "54": {"vr": "DS", "Value": [644.0]}, "55": {"vr": "DS", "Value": [723.0]}, "56": {"vr": "DS", "Value": [465.0]}, "57": {"vr": "DS", "Value": [494.0]}, "58": {"vr": "DS", "Value": [627.0]}, "59": {"vr": "DS", "Value": [683.0]}, "60": {"vr": "DS", "Value": [659.0]}, "61": {"vr": "DS", "Value": [25.0]}, "62": {"vr": "DS", "Value": [737.0]}, "63": {"vr": "DS", "Value": [636.0]}, "64": {"vr": "DS", "Value": [655.0]}, "65": {"vr": "DS", "Value": [759.0]}, "66": {"vr": "DS", "Value": [660.0]}, "67": {"vr": "DS", "Value": [641.0]}, "68": {"vr": "DS", "Value": [655.0]}, "69": {"vr": "DS", "Value": [731.0]}, "70": {"vr": "DS", "Value": [668.0]}, "71": {"vr": "DS", "Value": [646.0]}, "72": {"vr": "DS", "Value": [718.0]}, "73": {"vr": "DS", "Value": [84.0]}, "74": {"vr": "DS", "Value": [627.0]}, "75": {"vr": "DS", "Value": [649.0]}, "76": {"vr": "DS", "Value": [636.0]}, "77": {"vr": "DS", "Value": [669.0]}, "78": {"vr": "DS", "Value": [641.0]}, "79": {"vr": "DS", "Value": [645.0]}, "80": {"vr": "DS", "Value": [639.0]}, "81": {"vr": "DS", "Value": [722.0]}, "82": {"vr": "DS", "Value": [654.0]}, "83": {"vr": "DS", "Value": [645.0]}, "84": {"vr": "DS", "Value": [762.0]}, "85": {"vr": "DS", "Value": [659.0]}, "86": {"vr": "DS", "Value": [648.0]}, "87": {"vr": "DS", "Value": [738.0]}, "88": {"vr": "DS", "Value": [667.0]}, "89": {"vr": "DS", "Value": [636.0]}, "90": {"vr": "DS", "Value": [650.0]}, "91": {"vr": "DS", "Value": [656.0]}, "92": {"vr": "DS", "Value": [634.0]}, "93": {"vr": "DS", "Value": [659.0]}, "94": {"vr": "DS", "Value": [636.0]}, "95": {"vr": "DS", "Value": [700.0]}, "96": {"vr": "DS", "Value": [637.0]}, "97": {"vr": "DS", "Value": [655.0]}, "98": {"vr": "DS", "Value": [623.0]}, "99": {"vr": "DS", "Value": [644.0]}, "100": {"vr": "DS", "Value": [378.0]}, "101": {"vr": "DS", "Value": [623.0]}, "102": {"vr": "DS", "Value": [402.0]}, "103": {"vr": "DS", "Value": [651.0]}, "104": {"vr": "DS", "Value": [649.0]}, "105": {"vr": "DS", "Value": [618.0]}, "106": {"vr": "DS", "Value": [31.0]}, "107": {"vr": "DS", "Value": [23.0]}, "108": {"vr": "DS", "Value": [31.0]}, "109": {"vr": "DS", "Value": [766.0]}, "110": {"vr": "DS", "Value": [674.0]}, "111": {"vr": "DS", "Value": [464.0]}, "112": {"vr": "DS", "Value": [634.0]}, "113": {"vr": "DS", "Value": [624.0]}, "114": {"vr": "DS", "Value": [681.0]}, "115": {"vr": "DS", "Value": [660.0]}, "116": {"vr": "DS", "Value": [627.0]}, "117": {"vr": "DS", "Value": [94.0]}, "118": {"vr": "DS", "Value": [681.0]}, "119": {"vr": "DS", "Value": [674.0]}, "120": {"vr": "DS", "Value": [461.0]}, "121": {"vr": "DS", "Value": [22.0]}, "122": {"vr": "DS", "Value": [649.0]}, "123": {"vr": "DS", "Value": [653.0]}, "124": {"vr": "DS", "Value": [644.0]}, "125": {"vr": "DS", "Value": [648.0]}, "126": {"vr": "DS", "Value": [668.0]}, "127": {"vr": "DS", "Value": [662.0]}, "128": {"vr": "DS", "Value": [758.0]}, "129": {"vr": "DS", "Value": [628.0]}, "130": {"vr": "DS", "Value": [644.0]}, "131": {"vr": "DS", "Value": [656.0]}, "132": {"vr": "DS", "Value": [665.0]}, "133": {"vr": "DS", "Value": [26.0]}, "134": {"vr": "DS", "Value": [637.0]}, "135": {"vr": "DS", "Value": [451.0]}, "136": {"vr": "DS", "Value": [631.0]}, "137": {"vr": "DS", "Value": [629.0]}, "138": {"vr": "DS", "Value": [591.0]}, "139": {"vr": "DS", "Value": [645.0]}, "140": {"vr": "DS", "Value": [640.0]}, "141": {"vr": "DS", "Value": [642.0]}, "142": {"vr": "DS", "Value": [634.0]}, "143": {"vr": "DS", "Value": [736.0]}, "144": {"vr": "DS", "Value": [653.0]}, "145": {"vr": "DS", "Value": [745.0]}, "146": {"vr": "DS", "Value": [670.0]}, "147": {"vr": "DS", "Value": [262.0]}, "148": {"vr": "DS", "Value": [647.0]}, "149": {"vr": "DS", "Value": [636.0]}, "150": {"vr": "DS", "Value": [656.0]}, "151": {"vr": "DS", "Value": [639.0]}, "152": {"vr": "DS", "Value": [38.0]}, "153": {"vr": "DS", "Value": [426.0]}, "154": {"vr": "DS", "Value": [621.0]}, "155": {"vr": "DS", "Value": [648.0]}, "156": {"vr": "DS", "Value": [639.0]}, "157": {"vr": "DS", "Value": [21.0]}, "158": {"vr": "DS", "Value": [22.0]}, "159": {"vr": "DS", "Value": [624.0]}, "160": {"vr": "DS", "Value": [703.0]}, "161": {"vr": "DS", "Value": [26.0]}, "162": {"vr": "DS", "Value": [648.0]}, "163": {"vr": "DS", "Value": [656.0]}, "164": {"vr": "DS", "Value": [22.0]}, "165": {"vr": "DS", "Value": [658.0]}, "166": {"vr": "DS", "Value": [433.0]}, "167": {"vr": "DS", "Value": [647.0]}, "168": {"vr": "DS", "Value": [666.0]}, "169": {"vr": "DS", "Value": [645.0]}, "170": {"vr": "DS", "Value": [641.0]}, "171": {"vr": "DS", "Value": [716.0]}, "172": {"vr": "DS", "Value": [749.0]}, "173": {"vr": "DS", "Value": [621.0]}, "174": {"vr": "DS", "Value": [727.0]}, "175": {"vr": "DS", "Value": [665.0]}, "176": {"vr": "DS", "Value": [631.0]}, "177": {"vr": "DS", "Value": [655.0]}, "178": {"vr": "DS", "Value": [753.0]}, "179": {"vr": "DS", "Value": [32.0]}, "180": {"vr": "DS", "Value": [708.0]}, "181": {"vr": "DS", "Value": [646.0]}, "182": {"vr": "DS", "Value": [629.0]}, "183": {"vr": "DS", "Value": [655.0]}, "184": {"vr": "DS", "Value": [672.0]}, "185": {"vr": "DS", "Value": [748.0]}, "186": {"vr": "DS", "Value": [683.0]}, "187": {"vr": "DS", "Value": [645.0]}, "188": {"vr": "DS", "Value": [639.0]}, "189": {"vr": "DS", "Value": [640.0]}, "190": {"vr": "DS", "Value": [30.0]}, "191": {"vr": "DS", "Value": [759.0]}}, "0051100D": {"0": {"vr": "SH", "Value": ["SP R8.8"]}, "1": {"vr": "SH", "Value": ["SP L51.2"]}, "2": {"vr": "SH", "Value": ["SP R81.8"]}, "3": {"vr": "SH", "Value": ["SP L54.2"]}, "4": {"vr": "SH", "Value": ["SP R14.8"]}, "5": {"vr": "SH", "Value": ["SP L18.2"]}, "6": {"vr": "SH", "Value": ["SP R40.8"]}, "7": {"vr": "SH", "Value": ["SP R51.8"]}, "8": {"vr": "SH", "Value": ["SP L5.2"]}, "9": {"vr": "SH", "Value": ["SP L49.2"]}, "10": {"vr": "SH", "Value": ["SP L57.2"]}, "11": {"vr": "SH", "Value": ["SP L67.2"]}, "12": {"vr": "SH", "Value": ["SP L87.2"]}, "13": {"vr": "SH", "Value": ["SP R77.8"]}, "14": {"vr": "SH", "Value": ["SP R1.8"]}, "15": {"vr": "SH", "Value": ["SP L25.2"]}, "16": {"vr": "SH", "Value": ["SP R73.8"]}, "17": {"vr": "SH", "Value": ["SP L95.2"]}, "18": {"vr": "SH", "Value": ["SP R76.8"]}, "19": {"vr": "SH", "Value": ["SP R64.8"]}, "20": {"vr": "SH", "Value": ["SP L10.2"]}, "21": {"vr": "SH", "Value": ["SP L99.2"]}, "22": {"vr": "SH", "Value": ["SP L88.2"]}, "23": {"vr": "SH", "Value": ["SP L6.2"]}, "24": {"vr": "SH", "Value": ["SP L59.2"]}, "25": {"vr": "SH", "Value": ["SP R32.8"]}, "26": {"vr": "SH", "Value": ["SP L35.2"]}, "27": {"vr": "SH", "Value": ["SP L33.2"]}, "28": {"vr": "SH", "Value": ["SP L43.2"]}, "29": {"vr": "SH", "Value": ["SP R24.8"]}, "30": {"vr": "SH", "Value": ["SP R75.8"]}, "31": {"vr": "SH", "Value": ["SP L44.2"]}, "32": {"vr": "SH", "Value": ["SP L0.2"]}, "33": {"vr": "SH", "Value": ["SP R74.8"]}, "34": {"vr": "SH", "Value": ["SP L77.2"]}, "35": {"vr": "SH", "Value": ["SP L79.2"]}, "36": {"vr": "SH", "Value": ["SP L13.2"]}, "37": {"vr": "SH", "Value": ["SP L41.2"]}, "38": {"vr": "SH", "Value": ["SP L20.2"]}, "39": {"vr": "SH", "Value": ["SP R45.8"]}, "40": {"vr": "SH", "Value": ["SP R48.8"]}, "41": {"vr": "SH", "Value": ["SP L12.2"]}, "42": {"vr": "SH", "Value": ["SP R60.8"]}, "43": {"vr": "SH", "Value": ["SP R17.8"]}, "44": {"vr": "SH", "Value": ["SP R78.8"]}, "45": {"vr": "SH", "Value": ["SP L48.2"]}, "46": {"vr": "SH", "Value": ["SP R21.8"]}, "47": {"vr": "SH", "Value": ["SP L50.2"]}, "48": {"vr": "SH", "Value": ["SP L46.2"]}, "49": {"vr": "SH", "Value": ["SP L47.2"]}, "50": {"vr": "SH", "Value": ["SP R11.8"]}, "51": {"vr": "SH", "Value": ["SP L61.2"]}, "52": {"vr": "SH", "Value": ["SP L1.2"]}, "53": {"vr": "SH", "Value": ["SP L63.2"]}, "54": {"vr": "SH", "Value": ["SP L16.2"]}, "55": {"vr": "SH", "Value": ["SP L76.2"]}, "56": {"vr": "SH", "Value": ["SP L85.2"]}, "57": {"vr": "SH", "Value": ["SP L83.2"]}, "58": {"vr": "SH", "Value": ["SP R0.8"]}, "59": {"vr": "SH", "Value": ["SP R63.8"]}, "60": {"vr": "SH", "Value": ["SP L37.2"]}, "61": {"vr": "SH", "Value": ["SP R87.8"]}, "62": {"vr": "SH", "Value": ["SP R66.8"]}, "63": {"vr": "SH", "Value": ["SP R20.8"]}, "64": {"vr": "SH", "Value": ["SP R35.8"]}, "65": {"vr": "SH", "Value": ["SP L73.2"]}, "66": {"vr": "SH", "Value": ["SP R36.8"]}, "67": {"vr": "SH", "Value": ["SP R44.8"]}, "68": {"vr": "SH", "Value": ["SP L55.2"]}, "69": {"vr": "SH", "Value": ["SP L75.2"]}, "70": {"vr": "SH", "Value": ["SP L40.2"]}, "71": {"vr": "SH", "Value": ["SP L30.2"]}, "72": {"vr": "SH", "Value": ["SP R70.8"]}, "73": {"vr": "SH", "Value": ["SP L93.2"]}, "74": {"vr": "SH", "Value": ["SP R4.8"]}, "75": {"vr": "SH", "Value": ["SP L27.2"]}, "76": {"vr": "SH", "Value": ["SP R16.8"]}, "77": {"vr": "SH", "Value": ["SP R38.8"]}, "78": {"vr": "SH", "Value": ["SP L17.2"]}, "79": {"vr": "SH", "Value": ["SP L26.2"]}, "80": {"vr": "SH", "Value": ["SP R55.8"]}, "81": {"vr": "SH", "Value": ["SP R69.8"]}, "82": {"vr": "SH", "Value": ["SP R26.8"]}, "83": {"vr": "SH", "Value": ["SP R56.8"]}, "84": {"vr": "SH", "Value": ["SP L70.2"]}, "85": {"vr": "SH", "Value": ["SP L34.2"]}, "86": {"vr": "SH", "Value": ["SP L31.2"]}, "87": {"vr": "SH", "Value": ["SP R67.8"]}, "88": {"vr": "SH", "Value": ["SP R39.8"]}, "89": {"vr": "SH", "Value": ["SP R49.8"]}, "90": {"vr": "SH", "Value": ["SP R34.8"]}, "91": {"vr": "SH", "Value": ["SP R41.8"]}, "92": {"vr": "SH", "Value": ["SP R15.8"]}, "93": {"vr": "SH", "Value": ["SP L81.2"]}, "94": {"vr": "SH", "Value": ["SP R46.8"]}, "95": {"vr": "SH", "Value": ["SP L62.2"]}, "96": {"vr": "SH", "Value": ["SP R54.8"]}, "97": {"vr": "SH", "Value": ["SP R31.8"]}, "98": {"vr": "SH", "Value": ["SP R3.8"]}, "99": {"vr": "SH", "Value": ["SP L14.2"]}, "100": {"vr": "SH", "Value": ["SP L91.2"]}, "101": {"vr": "SH", "Value": ["SP L8.2"]}, "102": {"vr": "SH", "Value": ["SP R80.8"]}, "103": {"vr": "SH", "Value": ["SP L32.2"]}, "104": {"vr": "SH", "Value": ["SP L53.2"]}, "105": {"vr": "SH", "Value": ["SP L2.2"]}, "106": {"vr": "SH", "Value": ["SP L98.2"]}, "107": {"vr": "SH", "Value": ["SP R91.8"]}, "108": {"vr": "SH", "Value": ["SP L96.2"]}, "109": {"vr": "SH", "Value": ["SP L71.2"]}, "110": {"vr": "SH", "Value": ["SP R59.8"]}, "111": {"vr": "SH", "Value": ["SP L89.2"]}, "112": {"vr": "SH", "Value": ["SP L11.2"]}, "113": {"vr": "SH", "Value": ["SP L7.2"]}, "114": {"vr": "SH", "Value": ["SP R62.8"]}, "115": {"vr": "SH", "Value": ["SP L36.2"]}, "116": {"vr": "SH", "Value": ["SP R6.8"]}, "117": {"vr": "SH", "Value": ["SP R82.8"]}, "118": {"vr": "SH", "Value": ["SP R61.8"]}, "119": {"vr": "SH", "Value": ["SP L45.2"]}, "120": {"vr": "SH", "Value": ["SP L86.2"]}, "121": {"vr": "SH", "Value": ["SP R89.8"]}, "122": {"vr": "SH", "Value": ["SP R25.8"]}, "123": {"vr": "SH", "Value": ["SP R42.8"]}, "124": {"vr": "SH", "Value": ["SP L21.2"]}, "125": {"vr": "SH", "Value": ["SP L29.2"]}, "126": {"vr": "SH", "Value": ["SP R58.8"]}, "127": {"vr": "SH", "Value": ["SP L38.2"]}, "128": {"vr": "SH", "Value": ["SP L69.2"]}, "129": {"vr": "SH", "Value": ["SP R5.8"]}, "130": {"vr": "SH", "Value": ["SP L24.2"]}, "131": {"vr": "SH", "Value": ["SP R29.8"]}, "132": {"vr": "SH", "Value": ["SP L39.2"]}, "133": {"vr": "SH", "Value": ["SP R85.8"]}, "134": {"vr": "SH", "Value": ["SP R53.8"]}, "135": {"vr": "SH", "Value": ["SP L84.2"]}, "136": {"vr": "SH", "Value": ["SP R9.8"]}, "137": {"vr": "SH", "Value": ["SP L9.2"]}, "138": {"vr": "SH", "Value": ["SP L82.2"]}, "139": {"vr": "SH", "Value": ["SP L15.2"]}, "140": {"vr": "SH", "Value": ["SP R19.8"]}, "141": {"vr": "SH", "Value": ["SP L19.2"]}, "142": {"vr": "SH", "Value": ["SP R47.8"]}, "143": {"vr": "SH", "Value": ["SP L64.2"]}, "144": {"vr": "SH", "Value": ["SP R57.8"]}, "145": {"vr": "SH", "Value": ["SP L65.2"]}, "146": {"vr": "SH", "Value": ["SP L58.2"]}, "147": {"vr": "SH", "Value": ["SP L92.2"]}, "148": {"vr": "SH", "Value": ["SP L28.2"]}, "149": {"vr": "SH", "Value": ["SP R22.8"]}, "150": {"vr": "SH", "Value": ["SP R28.8"]}, "151": {"vr": "SH", "Value": ["SP R50.8"]}, "152": {"vr": "SH", "Value": ["SP R83.8"]}, "153": {"vr": "SH", "Value": ["SP L90.2"]}, "154": {"vr": "SH", "Value": ["SP L3.2"]}, "155": {"vr": "SH", "Value": ["SP L80.2"]}, "156": {"vr": "SH", "Value": ["SP L22.2"]}, "157": {"vr": "SH", "Value": ["SP R90.8"]}, "158": {"vr": "SH", "Value": ["SP R88.8"]}, "159": {"vr": "SH", "Value": ["SP R2.8"]}, "160": {"vr": "SH", "Value": ["SP R72.8"]}, "161": {"vr": "SH", "Value": ["SP R84.8"]}, "162": {"vr": "SH", "Value": ["SP R33.8"]}, "163": {"vr": "SH", "Value": ["SP R27.8"]}, "164": {"vr": "SH", "Value": ["SP R86.8"]}, "165": {"vr": "SH", "Value": ["SP L56.2"]}, "166": {"vr": "SH", "Value": ["SP R79.8"]}, "167": {"vr": "SH", "Value": ["SP R43.8"]}, "168": {"vr": "SH", "Value": ["SP L78.2"]}, "169": {"vr": "SH", "Value": ["SP R12.8"]}, "170": {"vr": "SH", "Value": ["SP R52.8"]}, "171": {"vr": "SH", "Value": ["SP R65.8"]}, "172": {"vr": "SH", "Value": ["SP L66.2"]}, "173": {"vr": "SH", "Value": ["SP L4.2"]}, "174": {"vr": "SH", "Value": ["SP R68.8"]}, "175": {"vr": "SH", "Value": ["SP R37.8"]}, "176": {"vr": "SH", "Value": ["SP R10.8"]}, "177": {"vr": "SH", "Value": ["SP L52.2"]}, "178": {"vr": "SH", "Value": ["SP L68.2"]}, "179": {"vr": "SH", "Value": ["SP L94.2"]}, "180": {"vr": "SH", "Value": ["SP R71.8"]}, "181": {"vr": "SH", "Value": ["SP R23.8"]}, "182": {"vr": "SH", "Value": ["SP R7.8"]}, "183": {"vr": "SH", "Value": ["SP R30.8"]}, "184": {"vr": "SH", "Value": ["SP L42.2"]}, "185": {"vr": "SH", "Value": ["SP L74.2"]}, "186": {"vr": "SH", "Value": ["SP L60.2"]}, "187": {"vr": "SH", "Value": ["SP R13.8"]}, "188": {"vr": "SH", "Value": ["SP L23.2"]}, "189": {"vr": "SH", "Value": ["SP R18.8"]}, "190": {"vr": "SH", "Value": ["SP L97.2"]}, "191": {"vr": "SH", "Value": ["SP L72.2"]}}}


collated_data = {"00211019": {"0": {"vr": "OB", "BinaryLength": 111304}, "1": {"vr": "OB", "BinaryLength": 111304}, "2": {"vr": "OB", "BinaryLength": 111304}, "3": {"vr": "OB", "BinaryLength": 111304}, "4": {"vr": "OB", "BinaryLength": 111304}, "5": {"vr": "OB", "BinaryLength": 111304}, "6": {"vr": "OB", "BinaryLength": 111304}, "7": {"vr": "OB", "BinaryLength": 111304}, "8": {"vr": "OB", "BinaryLength": 111304}, "9": {"vr": "OB", "BinaryLength": 111304}, "10": {"vr": "OB", "BinaryLength": 111304}, "11": {"vr": "OB", "BinaryLength": 111304}, "12": {"vr": "OB", "BinaryLength": 111304}, "13": {"vr": "OB", "BinaryLength": 111304}, "14": {"vr": "OB", "BinaryLength": 111304}, "15": {"vr": "OB", "BinaryLength": 111304}, "16": {"vr": "OB", "BinaryLength": 111304}, "17": {"vr": "OB", "BinaryLength": 111304}, "18": {"vr": "OB", "BinaryLength": 111304}, "19": {"vr": "OB", "BinaryLength": 111304}, "20": {"vr": "OB", "BinaryLength": 111304}, "21": {"vr": "OB", "BinaryLength": 111304}, "22": {"vr": "OB", "BinaryLength": 111304}, "23": {"vr": "OB", "BinaryLength": 111304}, "24": {"vr": "OB", "BinaryLength": 111304}, "25": {"vr": "OB", "BinaryLength": 111304}, "26": {"vr": "OB", "BinaryLength": 111304}, "27": {"vr": "OB", "BinaryLength": 111304}, "28": {"vr": "OB", "BinaryLength": 111304}, "29": {"vr": "OB", "BinaryLength": 111304}, "30": {"vr": "OB", "BinaryLength": 111304}, "31": {"vr": "OB", "BinaryLength": 111304}, "32": {"vr": "OB", "BinaryLength": 111304}, "33": {"vr": "OB", "BinaryLength": 111304}, "34": {"vr": "OB", "BinaryLength": 111304}, "35": {"vr": "OB", "BinaryLength": 111304}, "36": {"vr": "OB", "BinaryLength": 111304}, "37": {"vr": "OB", "BinaryLength": 111304}, "38": {"vr": "OB", "BinaryLength": 111304}, "39": {"vr": "OB", "BinaryLength": 111304}, "40": {"vr": "OB", "BinaryLength": 111304}, "41": {"vr": "OB", "BinaryLength": 111304}, "42": {"vr": "OB", "BinaryLength": 111304}, "43": {"vr": "OB", "BinaryLength": 111304}, "44": {"vr": "OB", "BinaryLength": 111304}, "45": {"vr": "OB", "BinaryLength": 111304}, "46": {"vr": "OB", "BinaryLength": 111304}, "47": {"vr": "OB", "BinaryLength": 111304}, "48": {"vr": "OB", "BinaryLength": 111304}, "49": {"vr": "OB", "BinaryLength": 111304}, "50": {"vr": "OB", "BinaryLength": 111304}, "51": {"vr": "OB", "BinaryLength": 111304}, "52": {"vr": "OB", "BinaryLength": 111304}, "53": {"vr": "OB", "BinaryLength": 111304}, "54": {"vr": "OB", "BinaryLength": 111304}, "55": {"vr": "OB", "BinaryLength": 111304}, "56": {"vr": "OB", "BinaryLength": 111304}, "57": {"vr": "OB", "BinaryLength": 111304}, "58": {"vr": "OB", "BinaryLength": 111304}, "59": {"vr": "OB", "BinaryLength": 111304}, "60": {"vr": "OB", "BinaryLength": 111304}, "61": {"vr": "OB", "BinaryLength": 111304}, "62": {"vr": "OB", "BinaryLength": 111304}, "63": {"vr": "OB", "BinaryLength": 111304}, "64": {"vr": "OB", "BinaryLength": 111304}, "65": {"vr": "OB", "BinaryLength": 111304}, "66": {"vr": "OB", "BinaryLength": 111304}, "67": {"vr": "OB", "BinaryLength": 111304}, "68": {"vr": "OB", "BinaryLength": 111304}, "69": {"vr": "OB", "BinaryLength": 111304}, "70": {"vr": "OB", "BinaryLength": 111304}, "71": {"vr": "OB", "BinaryLength": 111304}, "72": {"vr": "OB", "BinaryLength": 111304}, "73": {"vr": "OB", "BinaryLength": 111304}, "74": {"vr": "OB", "BinaryLength": 111304}, "75": {"vr": "OB", "BinaryLength": 111304}, "76": {"vr": "OB", "BinaryLength": 111304}, "77": {"vr": "OB", "BinaryLength": 111304}, "78": {"vr": "OB", "BinaryLength": 111304}, "79": {"vr": "OB", "BinaryLength": 111304}, "80": {"vr": "OB", "BinaryLength": 111304}, "81": {"vr": "OB", "BinaryLength": 111304}, "82": {"vr": "OB", "BinaryLength": 111304}, "83": {"vr": "OB", "BinaryLength": 111304}, "84": {"vr": "OB", "BinaryLength": 111304}, "85": {"vr": "OB", "BinaryLength": 111304}, "86": {"vr": "OB", "BinaryLength": 111304}, "87": {"vr": "OB", "BinaryLength": 111304}, "88": {"vr": "OB", "BinaryLength": 111304}, "89": {"vr": "OB", "BinaryLength": 111304}, "90": {"vr": "OB", "BinaryLength": 111304}, "91": {"vr": "OB", "BinaryLength": 111304}, "92": {"vr": "OB", "BinaryLength": 111304}, "93": {"vr": "OB", "BinaryLength": 111304}, "94": {"vr": "OB", "BinaryLength": 111304}, "95": {"vr": "OB", "BinaryLength": 111304}, "96": {"vr": "OB", "BinaryLength": 111304}, "97": {"vr": "OB", "BinaryLength": 111304}, "98": {"vr": "OB", "BinaryLength": 111304}, "99": {"vr": "OB", "BinaryLength": 111304}, "100": {"vr": "OB", "BinaryLength": 111304}, "101": {"vr": "OB", "BinaryLength": 111304}, "102": {"vr": "OB", "BinaryLength": 111304}, "103": {"vr": "OB", "BinaryLength": 111304}, "104": {"vr": "OB", "BinaryLength": 111304}, "105": {"vr": "OB", "BinaryLength": 111304}, "106": {"vr": "OB", "BinaryLength": 111304}, "107": {"vr": "OB", "BinaryLength": 111304}, "108": {"vr": "OB", "BinaryLength": 111304}, "109": {"vr": "OB", "BinaryLength": 111304}, "110": {"vr": "OB", "BinaryLength": 111304}, "111": {"vr": "OB", "BinaryLength": 111304}, "112": {"vr": "OB", "BinaryLength": 111304}, "113": {"vr": "OB", "BinaryLength": 111304}, "114": {"vr": "OB", "BinaryLength": 111304}, "115": {"vr": "OB", "BinaryLength": 111304}, "116": {"vr": "OB", "BinaryLength": 111304}, "117": {"vr": "OB", "BinaryLength": 111304}, "118": {"vr": "OB", "BinaryLength": 111304}, "119": {"vr": "OB", "BinaryLength": 111304}, "120": {"vr": "OB", "BinaryLength": 111304}, "121": {"vr": "OB", "BinaryLength": 111304}, "122": {"vr": "OB", "BinaryLength": 111304}, "123": {"vr": "OB", "BinaryLength": 111304}, "124": {"vr": "OB", "BinaryLength": 111304}, "125": {"vr": "OB", "BinaryLength": 111304}, "126": {"vr": "OB", "BinaryLength": 111304}, "127": {"vr": "OB", "BinaryLength": 111304}, "128": {"vr": "OB", "BinaryLength": 111304}, "129": {"vr": "OB", "BinaryLength": 111304}, "130": {"vr": "OB", "BinaryLength": 111304}, "131": {"vr": "OB", "BinaryLength": 111304}, "132": {"vr": "OB", "BinaryLength": 111304}, "133": {"vr": "OB", "BinaryLength": 111304}, "134": {"vr": "OB", "BinaryLength": 111304}, "135": {"vr": "OB", "BinaryLength": 111304}, "136": {"vr": "OB", "BinaryLength": 111304}, "137": {"vr": "OB", "BinaryLength": 111304}, "138": {"vr": "OB", "BinaryLength": 111304}, "139": {"vr": "OB", "BinaryLength": 111304}, "140": {"vr": "OB", "BinaryLength": 111304}, "141": {"vr": "OB", "BinaryLength": 111304}, "142": {"vr": "OB", "BinaryLength": 111304}, "143": {"vr": "OB", "BinaryLength": 111304}, "144": {"vr": "OB", "BinaryLength": 111304}, "145": {"vr": "OB", "BinaryLength": 111304}, "146": {"vr": "OB", "BinaryLength": 111304}, "147": {"vr": "OB", "BinaryLength": 111304}, "148": {"vr": "OB", "BinaryLength": 111304}, "149": {"vr": "OB", "BinaryLength": 111304}, "150": {"vr": "OB", "BinaryLength": 111304}, "151": {"vr": "OB", "BinaryLength": 111304}, "152": {"vr": "OB", "BinaryLength": 111304}, "153": {"vr": "OB", "BinaryLength": 111304}, "154": {"vr": "OB", "BinaryLength": 111304}, "155": {"vr": "OB", "BinaryLength": 111304}, "156": {"vr": "OB", "BinaryLength": 111304}, "157": {"vr": "OB", "BinaryLength": 111304}, "158": {"vr": "OB", "BinaryLength": 111304}, "159": {"vr": "OB", "BinaryLength": 111304}, "160": {"vr": "OB", "BinaryLength": 111304}, "161": {"vr": "OB", "BinaryLength": 111304}, "162": {"vr": "OB", "BinaryLength": 111304}, "163": {"vr": "OB", "BinaryLength": 111304}, "164": {"vr": "OB", "BinaryLength": 111304}, "165": {"vr": "OB", "BinaryLength": 111304}, "166": {"vr": "OB", "BinaryLength": 111304}, "167": {"vr": "OB", "BinaryLength": 111304}, "168": {"vr": "OB", "BinaryLength": 111304}, "169": {"vr": "OB", "BinaryLength": 111304}, "170": {"vr": "OB", "BinaryLength": 111304}, "171": {"vr": "OB", "BinaryLength": 111304}, "172": {"vr": "OB", "BinaryLength": 111304}, "173": {"vr": "OB", "BinaryLength": 111304}, "174": {"vr": "OB", "BinaryLength": 111304}, "175": {"vr": "OB", "BinaryLength": 111304}, "176": {"vr": "OB", "BinaryLength": 111304}, "177": {"vr": "OB", "BinaryLength": 111304}, "178": {"vr": "OB", "BinaryLength": 111304}, "179": {"vr": "OB", "BinaryLength": 111304}, "180": {"vr": "OB", "BinaryLength": 111304}, "181": {"vr": "OB", "BinaryLength": 111304}, "182": {"vr": "OB", "BinaryLength": 111304}, "183": {"vr": "OB", "BinaryLength": 111304}, "184": {"vr": "OB", "BinaryLength": 111304}, "185": {"vr": "OB", "BinaryLength": 111304}, "186": {"vr": "OB", "BinaryLength": 111304}, "187": {"vr": "OB", "BinaryLength": 111304}, "188": {"vr": "OB", "BinaryLength": 111304}, "189": {"vr": "OB", "BinaryLength": 111304}, "190": {"vr": "OB", "BinaryLength": 111304}, "191": {"vr": "OB", "BinaryLength": 111304}}, "00291010": {"0": {"vr": "OB", "BinaryLength": 14760}, "1": {"vr": "OB", "BinaryLength": 14764}, "2": {"vr": "OB", "BinaryLength": 14764}, "3": {"vr": "OB", "BinaryLength": 14764}, "4": {"vr": "OB", "BinaryLength": 14764}, "5": {"vr": "OB", "BinaryLength": 14764}, "6": {"vr": "OB", "BinaryLength": 14764}, "7": {"vr": "OB", "BinaryLength": 14764}, "8": {"vr": "OB", "BinaryLength": 14760}, "9": {"vr": "OB", "BinaryLength": 14764}, "10": {"vr": "OB", "BinaryLength": 14764}, "11": {"vr": "OB", "BinaryLength": 14764}, "12": {"vr": "OB", "BinaryLength": 14764}, "13": {"vr": "OB", "BinaryLength": 14764}, "14": {"vr": "OB", "BinaryLength": 14760}, "15": {"vr": "OB", "BinaryLength": 14764}, "16": {"vr": "OB", "BinaryLength": 14764}, "17": {"vr": "OB", "BinaryLength": 14764}, "18": {"vr": "OB", "BinaryLength": 14764}, "19": {"vr": "OB", "BinaryLength": 14764}, "20": {"vr": "OB", "BinaryLength": 14764}, "21": {"vr": "OB", "BinaryLength": 14768}, "22": {"vr": "OB", "BinaryLength": 14764}, "23": {"vr": "OB", "BinaryLength": 14760}, "24": {"vr": "OB", "BinaryLength": 14764}, "25": {"vr": "OB", "BinaryLength": 14764}, "26": {"vr": "OB", "BinaryLength": 14764}, "27": {"vr": "OB", "BinaryLength": 14764}, "28": {"vr": "OB", "BinaryLength": 14764}, "29": {"vr": "OB", "BinaryLength": 14764}, "30": {"vr": "OB", "BinaryLength": 14764}, "31": {"vr": "OB", "BinaryLength": 14764}, "32": {"vr": "OB", "BinaryLength": 14760}, "33": {"vr": "OB", "BinaryLength": 14764}, "34": {"vr": "OB", "BinaryLength": 14764}, "35": {"vr": "OB", "BinaryLength": 14764}, "36": {"vr": "OB", "BinaryLength": 14764}, "37": {"vr": "OB", "BinaryLength": 14764}, "38": {"vr": "OB", "BinaryLength": 14764}, "39": {"vr": "OB", "BinaryLength": 14764}, "40": {"vr": "OB", "BinaryLength": 14764}, "41": {"vr": "OB", "BinaryLength": 14764}, "42": {"vr": "OB", "BinaryLength": 14764}, "43": {"vr": "OB", "BinaryLength": 14764}, "44": {"vr": "OB", "BinaryLength": 14764}, "45": {"vr": "OB", "BinaryLength": 14764}, "46": {"vr": "OB", "BinaryLength": 14764}, "47": {"vr": "OB", "BinaryLength": 14764}, "48": {"vr": "OB", "BinaryLength": 14764}, "49": {"vr": "OB", "BinaryLength": 14764}, "50": {"vr": "OB", "BinaryLength": 14760}, "51": {"vr": "OB", "BinaryLength": 14764}, "52": {"vr": "OB", "BinaryLength": 14760}, "53": {"vr": "OB", "BinaryLength": 14764}, "54": {"vr": "OB", "BinaryLength": 14764}, "55": {"vr": "OB", "BinaryLength": 14764}, "56": {"vr": "OB", "BinaryLength": 14764}, "57": {"vr": "OB", "BinaryLength": 14764}, "58": {"vr": "OB", "BinaryLength": 14760}, "59": {"vr": "OB", "BinaryLength": 14764}, "60": {"vr": "OB", "BinaryLength": 14764}, "61": {"vr": "OB", "BinaryLength": 14764}, "62": {"vr": "OB", "BinaryLength": 14764}, "63": {"vr": "OB", "BinaryLength": 14764}, "64": {"vr": "OB", "BinaryLength": 14764}, "65": {"vr": "OB", "BinaryLength": 14764}, "66": {"vr": "OB", "BinaryLength": 14764}, "67": {"vr": "OB", "BinaryLength": 14764}, "68": {"vr": "OB", "BinaryLength": 14764}, "69": {"vr": "OB", "BinaryLength": 14764}, "70": {"vr": "OB", "BinaryLength": 14764}, "71": {"vr": "OB", "BinaryLength": 14764}, "72": {"vr": "OB", "BinaryLength": 14764}, "73": {"vr": "OB", "BinaryLength": 14764}, "74": {"vr": "OB", "BinaryLength": 14760}, "75": {"vr": "OB", "BinaryLength": 14764}, "76": {"vr": "OB", "BinaryLength": 14764}, "77": {"vr": "OB", "BinaryLength": 14764}, "78": {"vr": "OB", "BinaryLength": 14764}, "79": {"vr": "OB", "BinaryLength": 14764}, "80": {"vr": "OB", "BinaryLength": 14764}, "81": {"vr": "OB", "BinaryLength": 14764}, "82": {"vr": "OB", "BinaryLength": 14764}, "83": {"vr": "OB", "BinaryLength": 14764}, "84": {"vr": "OB", "BinaryLength": 14764}, "85": {"vr": "OB", "BinaryLength": 14764}, "86": {"vr": "OB", "BinaryLength": 14764}, "87": {"vr": "OB", "BinaryLength": 14764}, "88": {"vr": "OB", "BinaryLength": 14764}, "89": {"vr": "OB", "BinaryLength": 14764}, "90": {"vr": "OB", "BinaryLength": 14764}, "91": {"vr": "OB", "BinaryLength": 14764}, "92": {"vr": "OB", "BinaryLength": 14764}, "93": {"vr": "OB", "BinaryLength": 14764}, "94": {"vr": "OB", "BinaryLength": 14764}, "95": {"vr": "OB", "BinaryLength": 14764}, "96": {"vr": "OB", "BinaryLength": 14764}, "97": {"vr": "OB", "BinaryLength": 14764}, "98": {"vr": "OB", "BinaryLength": 14760}, "99": {"vr": "OB", "BinaryLength": 14764}, "100": {"vr": "OB", "BinaryLength": 14764}, "101": {"vr": "OB", "BinaryLength": 14764}, "102": {"vr": "OB", "BinaryLength": 14764}, "103": {"vr": "OB", "BinaryLength": 14764}, "104": {"vr": "OB", "BinaryLength": 14764}, "105": {"vr": "OB", "BinaryLength": 14760}, "106": {"vr": "OB", "BinaryLength": 14768}, "107": {"vr": "OB", "BinaryLength": 14764}, "108": {"vr": "OB", "BinaryLength": 14768}, "109": {"vr": "OB", "BinaryLength": 14764}, "110": {"vr": "OB", "BinaryLength": 14764}, "111": {"vr": "OB", "BinaryLength": 14764}, "112": {"vr": "OB", "BinaryLength": 14764}, "113": {"vr": "OB", "BinaryLength": 14764}, "114": {"vr": "OB", "BinaryLength": 14764}, "115": {"vr": "OB", "BinaryLength": 14764}, "116": {"vr": "OB", "BinaryLength": 14760}, "117": {"vr": "OB", "BinaryLength": 14764}, "118": {"vr": "OB", "BinaryLength": 14764}, "119": {"vr": "OB", "BinaryLength": 14764}, "120": {"vr": "OB", "BinaryLength": 14764}, "121": {"vr": "OB", "BinaryLength": 14764}, "122": {"vr": "OB", "BinaryLength": 14764}, "123": {"vr": "OB", "BinaryLength": 14764}, "124": {"vr": "OB", "BinaryLength": 14764}, "125": {"vr": "OB", "BinaryLength": 14764}, "126": {"vr": "OB", "BinaryLength": 14764}, "127": {"vr": "OB", "BinaryLength": 14764}, "128": {"vr": "OB", "BinaryLength": 14764}, "129": {"vr": "OB", "BinaryLength": 14760}, "130": {"vr": "OB", "BinaryLength": 14764}, "131": {"vr": "OB", "BinaryLength": 14764}, "132": {"vr": "OB", "BinaryLength": 14764}, "133": {"vr": "OB", "BinaryLength": 14764}, "134": {"vr": "OB", "BinaryLength": 14764}, "135": {"vr": "OB", "BinaryLength": 14764}, "136": {"vr": "OB", "BinaryLength": 14760}, "137": {"vr": "OB", "BinaryLength": 14764}, "138": {"vr": "OB", "BinaryLength": 14764}, "139": {"vr": "OB", "BinaryLength": 14764}, "140": {"vr": "OB", "BinaryLength": 14764}, "141": {"vr": "OB", "BinaryLength": 14764}, "142": {"vr": "OB", "BinaryLength": 14764}, "143": {"vr": "OB", "BinaryLength": 14764}, "144": {"vr": "OB", "BinaryLength": 14764}, "145": {"vr": "OB", "BinaryLength": 14764}, "146": {"vr": "OB", "BinaryLength": 14764}, "147": {"vr": "OB", "BinaryLength": 14764}, "148": {"vr": "OB", "BinaryLength": 14764}, "149": {"vr": "OB", "BinaryLength": 14764}, "150": {"vr": "OB", "BinaryLength": 14764}, "151": {"vr": "OB", "BinaryLength": 14764}, "152": {"vr": "OB", "BinaryLength": 14764}, "153": {"vr": "OB", "BinaryLength": 14764}, "154": {"vr": "OB", "BinaryLength": 14760}, "155": {"vr": "OB", "BinaryLength": 14764}, "156": {"vr": "OB", "BinaryLength": 14764}, "157": {"vr": "OB", "BinaryLength": 14764}, "158": {"vr": "OB", "BinaryLength": 14764}, "159": {"vr": "OB", "BinaryLength": 14760}, "160": {"vr": "OB", "BinaryLength": 14764}, "161": {"vr": "OB", "BinaryLength": 14764}, "162": {"vr": "OB", "BinaryLength": 14764}, "163": {"vr": "OB", "BinaryLength": 14764}, "164": {"vr": "OB", "BinaryLength": 14764}, "165": {"vr": "OB", "BinaryLength": 14764}, "166": {"vr": "OB", "BinaryLength": 14764}, "167": {"vr": "OB", "BinaryLength": 14764}, "168": {"vr": "OB", "BinaryLength": 14764}, "169": {"vr": "OB", "BinaryLength": 14760}, "170": {"vr": "OB", "BinaryLength": 14764}, "171": {"vr": "OB", "BinaryLength": 14764}, "172": {"vr": "OB", "BinaryLength": 14764}, "173": {"vr": "OB", "BinaryLength": 14760}, "174": {"vr": "OB", "BinaryLength": 14764}, "175": {"vr": "OB", "BinaryLength": 14764}, "176": {"vr": "OB", "BinaryLength": 14760}, "177": {"vr": "OB", "BinaryLength": 14764}, "178": {"vr": "OB", "BinaryLength": 14764}, "179": {"vr": "OB", "BinaryLength": 14764}, "180": {"vr": "OB", "BinaryLength": 14764}, "181": {"vr": "OB", "BinaryLength": 14764}, "182": {"vr": "OB", "BinaryLength": 14760}, "183": {"vr": "OB", "BinaryLength": 14764}, "184": {"vr": "OB", "BinaryLength": 14764}, "185": {"vr": "OB", "BinaryLength": 14764}, "186": {"vr": "OB", "BinaryLength": 14764}, "187": {"vr": "OB", "BinaryLength": 14760}, "188": {"vr": "OB", "BinaryLength": 14764}, "189": {"vr": "OB", "BinaryLength": 14764}, "190": {"vr": "OB", "BinaryLength": 14768}, "191": {"vr": "OB", "BinaryLength": 14764}}, "00291020": {"0": {"vr": "OB", "BinaryLength": 129596}, "1": {"vr": "OB", "BinaryLength": 129596}, "2": {"vr": "OB", "BinaryLength": 129596}, "3": {"vr": "OB", "BinaryLength": 129596}, "4": {"vr": "OB", "BinaryLength": 129596}, "5": {"vr": "OB", "BinaryLength": 129596}, "6": {"vr": "OB", "BinaryLength": 129596}, "7": {"vr": "OB", "BinaryLength": 129596}, "8": {"vr": "OB", "BinaryLength": 129596}, "9": {"vr": "OB", "BinaryLength": 129596}, "10": {"vr": "OB", "BinaryLength": 129596}, "11": {"vr": "OB", "BinaryLength": 129596}, "12": {"vr": "OB", "BinaryLength": 129596}, "13": {"vr": "OB", "BinaryLength": 129596}, "14": {"vr": "OB", "BinaryLength": 129596}, "15": {"vr": "OB", "BinaryLength": 129596}, "16": {"vr": "OB", "BinaryLength": 129596}, "17": {"vr": "OB", "BinaryLength": 129596}, "18": {"vr": "OB", "BinaryLength": 129596}, "19": {"vr": "OB", "BinaryLength": 129596}, "20": {"vr": "OB", "BinaryLength": 129596}, "21": {"vr": "OB", "BinaryLength": 129596}, "22": {"vr": "OB", "BinaryLength": 129596}, "23": {"vr": "OB", "BinaryLength": 129596}, "24": {"vr": "OB", "BinaryLength": 129596}, "25": {"vr": "OB", "BinaryLength": 129596}, "26": {"vr": "OB", "BinaryLength": 129596}, "27": {"vr": "OB", "BinaryLength": 129596}, "28": {"vr": "OB", "BinaryLength": 129596}, "29": {"vr": "OB", "BinaryLength": 129596}, "30": {"vr": "OB", "BinaryLength": 129596}, "31": {"vr": "OB", "BinaryLength": 129596}, "32": {"vr": "OB", "BinaryLength": 129596}, "33": {"vr": "OB", "BinaryLength": 129596}, "34": {"vr": "OB", "BinaryLength": 129596}, "35": {"vr": "OB", "BinaryLength": 129596}, "36": {"vr": "OB", "BinaryLength": 129596}, "37": {"vr": "OB", "BinaryLength": 129596}, "38": {"vr": "OB", "BinaryLength": 129596}, "39": {"vr": "OB", "BinaryLength": 129596}, "40": {"vr": "OB", "BinaryLength": 129596}, "41": {"vr": "OB", "BinaryLength": 129596}, "42": {"vr": "OB", "BinaryLength": 129596}, "43": {"vr": "OB", "BinaryLength": 129596}, "44": {"vr": "OB", "BinaryLength": 129596}, "45": {"vr": "OB", "BinaryLength": 129596}, "46": {"vr": "OB", "BinaryLength": 129596}, "47": {"vr": "OB", "BinaryLength": 129596}, "48": {"vr": "OB", "BinaryLength": 129596}, "49": {"vr": "OB", "BinaryLength": 129596}, "50": {"vr": "OB", "BinaryLength": 129596}, "51": {"vr": "OB", "BinaryLength": 129596}, "52": {"vr": "OB", "BinaryLength": 129596}, "53": {"vr": "OB", "BinaryLength": 129596}, "54": {"vr": "OB", "BinaryLength": 129596}, "55": {"vr": "OB", "BinaryLength": 129596}, "56": {"vr": "OB", "BinaryLength": 129596}, "57": {"vr": "OB", "BinaryLength": 129596}, "58": {"vr": "OB", "BinaryLength": 129596}, "59": {"vr": "OB", "BinaryLength": 129596}, "60": {"vr": "OB", "BinaryLength": 129596}, "61": {"vr": "OB", "BinaryLength": 129596}, "62": {"vr": "OB", "BinaryLength": 129596}, "63": {"vr": "OB", "BinaryLength": 129596}, "64": {"vr": "OB", "BinaryLength": 129596}, "65": {"vr": "OB", "BinaryLength": 129596}, "66": {"vr": "OB", "BinaryLength": 129596}, "67": {"vr": "OB", "BinaryLength": 129596}, "68": {"vr": "OB", "BinaryLength": 129596}, "69": {"vr": "OB", "BinaryLength": 129596}, "70": {"vr": "OB", "BinaryLength": 129596}, "71": {"vr": "OB", "BinaryLength": 129596}, "72": {"vr": "OB", "BinaryLength": 129596}, "73": {"vr": "OB", "BinaryLength": 129596}, "74": {"vr": "OB", "BinaryLength": 129596}, "75": {"vr": "OB", "BinaryLength": 129596}, "76": {"vr": "OB", "BinaryLength": 129596}, "77": {"vr": "OB", "BinaryLength": 129596}, "78": {"vr": "OB", "BinaryLength": 129596}, "79": {"vr": "OB", "BinaryLength": 129596}, "80": {"vr": "OB", "BinaryLength": 129596}, "81": {"vr": "OB", "BinaryLength": 129596}, "82": {"vr": "OB", "BinaryLength": 129596}, "83": {"vr": "OB", "BinaryLength": 129596}, "84": {"vr": "OB", "BinaryLength": 129596}, "85": {"vr": "OB", "BinaryLength": 129596}, "86": {"vr": "OB", "BinaryLength": 129596}, "87": {"vr": "OB", "BinaryLength": 129596}, "88": {"vr": "OB", "BinaryLength": 129596}, "89": {"vr": "OB", "BinaryLength": 129596}, "90": {"vr": "OB", "BinaryLength": 129596}, "91": {"vr": "OB", "BinaryLength": 129596}, "92": {"vr": "OB", "BinaryLength": 129596}, "93": {"vr": "OB", "BinaryLength": 129596}, "94": {"vr": "OB", "BinaryLength": 129596}, "95": {"vr": "OB", "BinaryLength": 129596}, "96": {"vr": "OB", "BinaryLength": 129596}, "97": {"vr": "OB", "BinaryLength": 129596}, "98": {"vr": "OB", "BinaryLength": 129596}, "99": {"vr": "OB", "BinaryLength": 129596}, "100": {"vr": "OB", "BinaryLength": 129596}, "101": {"vr": "OB", "BinaryLength": 129596}, "102": {"vr": "OB", "BinaryLength": 129596}, "103": {"vr": "OB", "BinaryLength": 129596}, "104": {"vr": "OB", "BinaryLength": 129596}, "105": {"vr": "OB", "BinaryLength": 129596}, "106": {"vr": "OB", "BinaryLength": 129596}, "107": {"vr": "OB", "BinaryLength": 129596}, "108": {"vr": "OB", "BinaryLength": 129596}, "109": {"vr": "OB", "BinaryLength": 129596}, "110": {"vr": "OB", "BinaryLength": 129596}, "111": {"vr": "OB", "BinaryLength": 129596}, "112": {"vr": "OB", "BinaryLength": 129596}, "113": {"vr": "OB", "BinaryLength": 129596}, "114": {"vr": "OB", "BinaryLength": 129596}, "115": {"vr": "OB", "BinaryLength": 129596}, "116": {"vr": "OB", "BinaryLength": 129596}, "117": {"vr": "OB", "BinaryLength": 129596}, "118": {"vr": "OB", "BinaryLength": 129596}, "119": {"vr": "OB", "BinaryLength": 129596}, "120": {"vr": "OB", "BinaryLength": 129596}, "121": {"vr": "OB", "BinaryLength": 129596}, "122": {"vr": "OB", "BinaryLength": 129596}, "123": {"vr": "OB", "BinaryLength": 129596}, "124": {"vr": "OB", "BinaryLength": 129596}, "125": {"vr": "OB", "BinaryLength": 129596}, "126": {"vr": "OB", "BinaryLength": 129596}, "127": {"vr": "OB", "BinaryLength": 129596}, "128": {"vr": "OB", "BinaryLength": 129596}, "129": {"vr": "OB", "BinaryLength": 129596}, "130": {"vr": "OB", "BinaryLength": 129596}, "131": {"vr": "OB", "BinaryLength": 129596}, "132": {"vr": "OB", "BinaryLength": 129596}, "133": {"vr": "OB", "BinaryLength": 129596}, "134": {"vr": "OB", "BinaryLength": 129596}, "135": {"vr": "OB", "BinaryLength": 129596}, "136": {"vr": "OB", "BinaryLength": 129596}, "137": {"vr": "OB", "BinaryLength": 129596}, "138": {"vr": "OB", "BinaryLength": 129596}, "139": {"vr": "OB", "BinaryLength": 129596}, "140": {"vr": "OB", "BinaryLength": 129596}, "141": {"vr": "OB", "BinaryLength": 129596}, "142": {"vr": "OB", "BinaryLength": 129596}, "143": {"vr": "OB", "BinaryLength": 129596}, "144": {"vr": "OB", "BinaryLength": 129596}, "145": {"vr": "OB", "BinaryLength": 129596}, "146": {"vr": "OB", "BinaryLength": 129596}, "147": {"vr": "OB", "BinaryLength": 129596}, "148": {"vr": "OB", "BinaryLength": 129596}, "149": {"vr": "OB", "BinaryLength": 129596}, "150": {"vr": "OB", "BinaryLength": 129596}, "151": {"vr": "OB", "BinaryLength": 129596}, "152": {"vr": "OB", "BinaryLength": 129596}, "153": {"vr": "OB", "BinaryLength": 129596}, "154": {"vr": "OB", "BinaryLength": 129596}, "155": {"vr": "OB", "BinaryLength": 129596}, "156": {"vr": "OB", "BinaryLength": 129596}, "157": {"vr": "OB", "BinaryLength": 129596}, "158": {"vr": "OB", "BinaryLength": 129596}, "159": {"vr": "OB", "BinaryLength": 129596}, "160": {"vr": "OB", "BinaryLength": 129596}, "161": {"vr": "OB", "BinaryLength": 129596}, "162": {"vr": "OB", "BinaryLength": 129596}, "163": {"vr": "OB", "BinaryLength": 129596}, "164": {"vr": "OB", "BinaryLength": 129596}, "165": {"vr": "OB", "BinaryLength": 129596}, "166": {"vr": "OB", "BinaryLength": 129596}, "167": {"vr": "OB", "BinaryLength": 129596}, "168": {"vr": "OB", "BinaryLength": 129596}, "169": {"vr": "OB", "BinaryLength": 129596}, "170": {"vr": "OB", "BinaryLength": 129596}, "171": {"vr": "OB", "BinaryLength": 129596}, "172": {"vr": "OB", "BinaryLength": 129596}, "173": {"vr": "OB", "BinaryLength": 129596}, "174": {"vr": "OB", "BinaryLength": 129596}, "175": {"vr": "OB", "BinaryLength": 129596}, "176": {"vr": "OB", "BinaryLength": 129596}, "177": {"vr": "OB", "BinaryLength": 129596}, "178": {"vr": "OB", "BinaryLength": 129596}, "179": {"vr": "OB", "BinaryLength": 129596}, "180": {"vr": "OB", "BinaryLength": 129596}, "181": {"vr": "OB", "BinaryLength": 129596}, "182": {"vr": "OB", "BinaryLength": 129596}, "183": {"vr": "OB", "BinaryLength": 129596}, "184": {"vr": "OB", "BinaryLength": 129596}, "185": {"vr": "OB", "BinaryLength": 129596}, "186": {"vr": "OB", "BinaryLength": 129596}, "187": {"vr": "OB", "BinaryLength": 129596}, "188": {"vr": "OB", "BinaryLength": 129596}, "189": {"vr": "OB", "BinaryLength": 129596}, "190": {"vr": "OB", "BinaryLength": 129596}, "191": {"vr": "OB", "BinaryLength": 129596}}, "7FE00010": {"0": {"vr": "OW", "BinaryLength": 163840}, "1": {"vr": "OW", "BinaryLength": 163840}, "2": {"vr": "OW", "BinaryLength": 163840}, "3": {"vr": "OW", "BinaryLength": 163840}, "4": {"vr": "OW", "BinaryLength": 163840}, "5": {"vr": "OW", "BinaryLength": 163840}, "6": {"vr": "OW", "BinaryLength": 163840}, "7": {"vr": "OW", "BinaryLength": 163840}, "8": {"vr": "OW", "BinaryLength": 163840}, "9": {"vr": "OW", "BinaryLength": 163840}, "10": {"vr": "OW", "BinaryLength": 163840}, "11": {"vr": "OW", "BinaryLength": 163840}, "12": {"vr": "OW", "BinaryLength": 163840}, "13": {"vr": "OW", "BinaryLength": 163840}, "14": {"vr": "OW", "BinaryLength": 163840}, "15": {"vr": "OW", "BinaryLength": 163840}, "16": {"vr": "OW", "BinaryLength": 163840}, "17": {"vr": "OW", "BinaryLength": 163840}, "18": {"vr": "OW", "BinaryLength": 163840}, "19": {"vr": "OW", "BinaryLength": 163840}, "20": {"vr": "OW", "BinaryLength": 163840}, "21": {"vr": "OW", "BinaryLength": 163840}, "22": {"vr": "OW", "BinaryLength": 163840}, "23": {"vr": "OW", "BinaryLength": 163840}, "24": {"vr": "OW", "BinaryLength": 163840}, "25": {"vr": "OW", "BinaryLength": 163840}, "26": {"vr": "OW", "BinaryLength": 163840}, "27": {"vr": "OW", "BinaryLength": 163840}, "28": {"vr": "OW", "BinaryLength": 163840}, "29": {"vr": "OW", "BinaryLength": 163840}, "30": {"vr": "OW", "BinaryLength": 163840}, "31": {"vr": "OW", "BinaryLength": 163840}, "32": {"vr": "OW", "BinaryLength": 163840}, "33": {"vr": "OW", "BinaryLength": 163840}, "34": {"vr": "OW", "BinaryLength": 163840}, "35": {"vr": "OW", "BinaryLength": 163840}, "36": {"vr": "OW", "BinaryLength": 163840}, "37": {"vr": "OW", "BinaryLength": 163840}, "38": {"vr": "OW", "BinaryLength": 163840}, "39": {"vr": "OW", "BinaryLength": 163840}, "40": {"vr": "OW", "BinaryLength": 163840}, "41": {"vr": "OW", "BinaryLength": 163840}, "42": {"vr": "OW", "BinaryLength": 163840}, "43": {"vr": "OW", "BinaryLength": 163840}, "44": {"vr": "OW", "BinaryLength": 163840}, "45": {"vr": "OW", "BinaryLength": 163840}, "46": {"vr": "OW", "BinaryLength": 163840}, "47": {"vr": "OW", "BinaryLength": 163840}, "48": {"vr": "OW", "BinaryLength": 163840}, "49": {"vr": "OW", "BinaryLength": 163840}, "50": {"vr": "OW", "BinaryLength": 163840}, "51": {"vr": "OW", "BinaryLength": 163840}, "52": {"vr": "OW", "BinaryLength": 163840}, "53": {"vr": "OW", "BinaryLength": 163840}, "54": {"vr": "OW", "BinaryLength": 163840}, "55": {"vr": "OW", "BinaryLength": 163840}, "56": {"vr": "OW", "BinaryLength": 163840}, "57": {"vr": "OW", "BinaryLength": 163840}, "58": {"vr": "OW", "BinaryLength": 163840}, "59": {"vr": "OW", "BinaryLength": 163840}, "60": {"vr": "OW", "BinaryLength": 163840}, "61": {"vr": "OW", "BinaryLength": 163840}, "62": {"vr": "OW", "BinaryLength": 163840}, "63": {"vr": "OW", "BinaryLength": 163840}, "64": {"vr": "OW", "BinaryLength": 163840}, "65": {"vr": "OW", "BinaryLength": 163840}, "66": {"vr": "OW", "BinaryLength": 163840}, "67": {"vr": "OW", "BinaryLength": 163840}, "68": {"vr": "OW", "BinaryLength": 163840}, "69": {"vr": "OW", "BinaryLength": 163840}, "70": {"vr": "OW", "BinaryLength": 163840}, "71": {"vr": "OW", "BinaryLength": 163840}, "72": {"vr": "OW", "BinaryLength": 163840}, "73": {"vr": "OW", "BinaryLength": 163840}, "74": {"vr": "OW", "BinaryLength": 163840}, "75": {"vr": "OW", "BinaryLength": 163840}, "76": {"vr": "OW", "BinaryLength": 163840}, "77": {"vr": "OW", "BinaryLength": 163840}, "78": {"vr": "OW", "BinaryLength": 163840}, "79": {"vr": "OW", "BinaryLength": 163840}, "80": {"vr": "OW", "BinaryLength": 163840}, "81": {"vr": "OW", "BinaryLength": 163840}, "82": {"vr": "OW", "BinaryLength": 163840}, "83": {"vr": "OW", "BinaryLength": 163840}, "84": {"vr": "OW", "BinaryLength": 163840}, "85": {"vr": "OW", "BinaryLength": 163840}, "86": {"vr": "OW", "BinaryLength": 163840}, "87": {"vr": "OW", "BinaryLength": 163840}, "88": {"vr": "OW", "BinaryLength": 163840}, "89": {"vr": "OW", "BinaryLength": 163840}, "90": {"vr": "OW", "BinaryLength": 163840}, "91": {"vr": "OW", "BinaryLength": 163840}, "92": {"vr": "OW", "BinaryLength": 163840}, "93": {"vr": "OW", "BinaryLength": 163840}, "94": {"vr": "OW", "BinaryLength": 163840}, "95": {"vr": "OW", "BinaryLength": 163840}, "96": {"vr": "OW", "BinaryLength": 163840}, "97": {"vr": "OW", "BinaryLength": 163840}, "98": {"vr": "OW", "BinaryLength": 163840}, "99": {"vr": "OW", "BinaryLength": 163840}, "100": {"vr": "OW", "BinaryLength": 163840}, "101": {"vr": "OW", "BinaryLength": 163840}, "102": {"vr": "OW", "BinaryLength": 163840}, "103": {"vr": "OW", "BinaryLength": 163840}, "104": {"vr": "OW", "BinaryLength": 163840}, "105": {"vr": "OW", "BinaryLength": 163840}, "106": {"vr": "OW", "BinaryLength": 163840}, "107": {"vr": "OW", "BinaryLength": 163840}, "108": {"vr": "OW", "BinaryLength": 163840}, "109": {"vr": "OW", "BinaryLength": 163840}, "110": {"vr": "OW", "BinaryLength": 163840}, "111": {"vr": "OW", "BinaryLength": 163840}, "112": {"vr": "OW", "BinaryLength": 163840}, "113": {"vr": "OW", "BinaryLength": 163840}, "114": {"vr": "OW", "BinaryLength": 163840}, "115": {"vr": "OW", "BinaryLength": 163840}, "116": {"vr": "OW", "BinaryLength": 163840}, "117": {"vr": "OW", "BinaryLength": 163840}, "118": {"vr": "OW", "BinaryLength": 163840}, "119": {"vr": "OW", "BinaryLength": 163840}, "120": {"vr": "OW", "BinaryLength": 163840}, "121": {"vr": "OW", "BinaryLength": 163840}, "122": {"vr": "OW", "BinaryLength": 163840}, "123": {"vr": "OW", "BinaryLength": 163840}, "124": {"vr": "OW", "BinaryLength": 163840}, "125": {"vr": "OW", "BinaryLength": 163840}, "126": {"vr": "OW", "BinaryLength": 163840}, "127": {"vr": "OW", "BinaryLength": 163840}, "128": {"vr": "OW", "BinaryLength": 163840}, "129": {"vr": "OW", "BinaryLength": 163840}, "130": {"vr": "OW", "BinaryLength": 163840}, "131": {"vr": "OW", "BinaryLength": 163840}, "132": {"vr": "OW", "BinaryLength": 163840}, "133": {"vr": "OW", "BinaryLength": 163840}, "134": {"vr": "OW", "BinaryLength": 163840}, "135": {"vr": "OW", "BinaryLength": 163840}, "136": {"vr": "OW", "BinaryLength": 163840}, "137": {"vr": "OW", "BinaryLength": 163840}, "138": {"vr": "OW", "BinaryLength": 163840}, "139": {"vr": "OW", "BinaryLength": 163840}, "140": {"vr": "OW", "BinaryLength": 163840}, "141": {"vr": "OW", "BinaryLength": 163840}, "142": {"vr": "OW", "BinaryLength": 163840}, "143": {"vr": "OW", "BinaryLength": 163840}, "144": {"vr": "OW", "BinaryLength": 163840}, "145": {"vr": "OW", "BinaryLength": 163840}, "146": {"vr": "OW", "BinaryLength": 163840}, "147": {"vr": "OW", "BinaryLength": 163840}, "148": {"vr": "OW", "BinaryLength": 163840}, "149": {"vr": "OW", "BinaryLength": 163840}, "150": {"vr": "OW", "BinaryLength": 163840}, "151": {"vr": "OW", "BinaryLength": 163840}, "152": {"vr": "OW", "BinaryLength": 163840}, "153": {"vr": "OW", "BinaryLength": 163840}, "154": {"vr": "OW", "BinaryLength": 163840}, "155": {"vr": "OW", "BinaryLength": 163840}, "156": {"vr": "OW", "BinaryLength": 163840}, "157": {"vr": "OW", "BinaryLength": 163840}, "158": {"vr": "OW", "BinaryLength": 163840}, "159": {"vr": "OW", "BinaryLength": 163840}, "160": {"vr": "OW", "BinaryLength": 163840}, "161": {"vr": "OW", "BinaryLength": 163840}, "162": {"vr": "OW", "BinaryLength": 163840}, "163": {"vr": "OW", "BinaryLength": 163840}, "164": {"vr": "OW", "BinaryLength": 163840}, "165": {"vr": "OW", "BinaryLength": 163840}, "166": {"vr": "OW", "BinaryLength": 163840}, "167": {"vr": "OW", "BinaryLength": 163840}, "168": {"vr": "OW", "BinaryLength": 163840}, "169": {"vr": "OW", "BinaryLength": 163840}, "170": {"vr": "OW", "BinaryLength": 163840}, "171": {"vr": "OW", "BinaryLength": 163840}, "172": {"vr": "OW", "BinaryLength": 163840}, "173": {"vr": "OW", "BinaryLength": 163840}, "174": {"vr": "OW", "BinaryLength": 163840}, "175": {"vr": "OW", "BinaryLength": 163840}, "176": {"vr": "OW", "BinaryLength": 163840}, "177": {"vr": "OW", "BinaryLength": 163840}, "178": {"vr": "OW", "BinaryLength": 163840}, "179": {"vr": "OW", "BinaryLength": 163840}, "180": {"vr": "OW", "BinaryLength": 163840}, "181": {"vr": "OW", "BinaryLength": 163840}, "182": {"vr": "OW", "BinaryLength": 163840}, "183": {"vr": "OW", "BinaryLength": 163840}, "184": {"vr": "OW", "BinaryLength": 163840}, "185": {"vr": "OW", "BinaryLength": 163840}, "186": {"vr": "OW", "BinaryLength": 163840}, "187": {"vr": "OW", "BinaryLength": 163840}, "188": {"vr": "OW", "BinaryLength": 163840}, "189": {"vr": "OW", "BinaryLength": 163840}, "190": {"vr": "OW", "BinaryLength": 163840}, "191": {"vr": "OW", "BinaryLength": 163840}}}
