from copy import copy
from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__), **kwargs):
    hdr = evolve_header(constant_hdr, **kwargs)
    return generate_dicom(out_dir, num_vols, hdr,
                          collated_data, varying_hdr)


num_vols = 1


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY",
            "LOCALIZER",
            "CT_SOM5 TOP"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.2"
        ]
    },
    "00080018": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082421141748900003652"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "0008002A": {
        "vr": "DT",
        "Value": [
            "20230825152208.766000"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "144927.519000"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "152201.564000"
        ]
    },
    "00080032": {
        "vr": "TM",
        "Value": [
            "152208.766000"
        ]
    },
    "00080033": {
        "vr": "TM",
        "Value": [
            "152208.766000"
        ]
    },
    "00080050": {
        "vr": "SH",
        "Value": [
            "987654321"
        ]
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "CT"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "SIEMENS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "Address of said institute"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "University"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "QUADRA10016"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^Project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "Topogram 0.6 Tr60"
        ]
    },
    "00081050": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Principal Investigator"
            }
        ]
    },
    "00081070": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Sydney Imaging"
            }
        ]
    },
    "00081080": {
        "vr": "LO",
        "Value": [
            "Physics"
        ]
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "Biograph128_Vision Quadra Edge"
        ]
    },
    "00083010": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422094374600000051"
        ]
    },
    "00090010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CT VA1 DUMMY"
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Session Identifier"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "Session Label"
        ]
    },
    "00100030": {
        "vr": "DA",
        "Value": [
            "19800228"
        ]
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "M"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "043Y"
        ]
    },
    "00101020": {
        "vr": "DS",
        "Value": [
            1.8
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            75.0
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "PARTIALBODY"
        ]
    },
    "00180050": {
        "vr": "DS"
    },
    "00180060": {
        "vr": "DS",
        "Value": [
            120.0
        ]
    },
    "00180090": {
        "vr": "DS",
        "Value": [
            500.0
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "10016"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "VR20B"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "U_FDG_SWB_LM"
        ]
    },
    "00181100": {
        "vr": "DS",
        "Value": [
            1536.0
        ]
    },
    "00181110": {
        "vr": "DS",
        "Value": [
            1085.6
        ]
    },
    "00181111": {
        "vr": "DS",
        "Value": [
            595.0
        ]
    },
    "00181120": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00181130": {
        "vr": "DS",
        "Value": [
            140.5
        ]
    },
    "00181140": {
        "vr": "CS",
        "Value": [
            "CW"
        ]
    },
    "00181150": {
        "vr": "IS",
        "Value": [
            8244
        ]
    },
    "00181151": {
        "vr": "IS",
        "Value": [
            35
        ]
    },
    "00181152": {
        "vr": "IS",
        "Value": [
            288
        ]
    },
    "00181160": {
        "vr": "SH",
        "Value": [
            "FLAT"
        ]
    },
    "00181170": {
        "vr": "IS",
        "Value": [
            4
        ]
    },
    "00181190": {
        "vr": "DS",
        "Value": [
            0.7
        ]
    },
    "00181200": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00181201": {
        "vr": "TM",
        "Value": [
            "071955.000000"
        ]
    },
    "00181210": {
        "vr": "SH",
        "Value": [
            "Tr60f"
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "00189306": {
        "vr": "FD",
        "Value": [
            0.6
        ]
    },
    "00189307": {
        "vr": "FD",
        "Value": [
            3.5999999999999996
        ]
    },
    "00189309": {
        "vr": "FD",
        "Value": [
            200.0
        ]
    },
    "00189311": {
        "vr": "FD",
        "Value": [
            0.0
        ]
    },
    "00189323": {
        "vr": "CS",
        "Value": [
            "NONE"
        ]
    },
    "00189324": {
        "vr": "FD",
        "Value": [
            0.0
        ]
    },
    "00189345": {
        "vr": "FD",
        "Value": [
            0.07443673279210142
        ]
    },
    "00189346": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "113691"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "DCM"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "IEC Body Dosimetry Phantom"
                    ]
                }
            }
        ]
    },
    "00189352": {
        "vr": "FL",
        "Value": [
            0.7900000214576721,
            0.8330000042915344,
            0.871999979019165
        ]
    },
    "00190010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CT VA0  COAD"
        ]
    },
    "00191090": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00191092": {
        "vr": "DS",
        "Value": [
            0.9236
        ]
    },
    "00191093": {
        "vr": "DS",
        "Value": [
            -1.6565
        ]
    },
    "00191096": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422093565300000019"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082421141748900003651"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "PROJECT_ID"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00200012": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00200013": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00200032": {
        "vr": "DS",
        "Value": [
            -766.50076650077,
            -140.5,
            222.50001650002
        ]
    },
    "00200037": {
        "vr": "DS",
        "Value": [
            1.0,
            -1.8369702e-16,
            0.0,
            0.0,
            0.0,
            -1.0
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422094374600000050"
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00201041": {
        "vr": "DS",
        "Value": [
            205.5
        ]
    },
    "00204000": {
        "vr": "LT"
    },
    "00210010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MED"
        ]
    },
    "00211011": {
        "vr": "DS",
        "Value": [
            0.0,
            0.0
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            512
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            512
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            3.0,
            3.0
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            12
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            11
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00281050": {
        "vr": "DS",
        "Value": [
            50.0,
            300.0
        ]
    },
    "00281051": {
        "vr": "DS",
        "Value": [
            350.0,
            2000.0
        ]
    },
    "00281052": {
        "vr": "DS",
        "Value": [
            -1024.0
        ]
    },
    "00281053": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00281054": {
        "vr": "LO",
        "Value": [
            "HU"
        ]
    },
    "00281055": {
        "vr": "LO",
        "Value": [
            "WINDOW1",
            "WINDOW2"
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CSA HEADER"
        ]
    },
    "00290011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MEDCOM HEADER"
        ]
    },
    "00291008": {
        "vr": "CS",
        "Value": [
            "SOM 5"
        ]
    },
    "00291009": {
        "vr": "LO",
        "Value": [
            "VA10A 971201"
        ]
    },
    "00291140": {
        "vr": "SQ",
        "Value": [
            {
                "00290010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MEDCOM HEADER"
                    ]
                },
                "00291041": {
                    "vr": "CS",
                    "Value": [
                        "VIA_CARE_KV_WIND"
                    ]
                },
                "00291042": {
                    "vr": "LO",
                    "Value": [
                        "ORIG WINDOW VALUES FROM CAREKV"
                    ]
                },
                "00291043": {
                    "vr": "LO",
                    "Value": [
                        "V1 20120914"
                    ]
                },
                "00291044": {
                    "vr": "OB",
                    "InlineBinary": "NQAwACMAMwA1ADAAAAA="
                }
            },
            {
                "00290010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MEDCOM HEADER"
                    ]
                },
                "00291041": {
                    "vr": "CS",
                    "Value": [
                        "SOM 5 TPOS"
                    ]
                },
                "00291042": {
                    "vr": "LO",
                    "Value": [
                        "SOM 5 NULLPOSITION"
                    ]
                },
                "00291043": {
                    "vr": "LO",
                    "Value": [
                        "VB10A 20030626"
                    ]
                },
                "00291044": {
                    "vr": "OB",
                    "InlineBinary": "LTAwMDAwMzcwMABT"
                }
            },
            {
                "00290010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MEDCOM HEADER"
                    ]
                },
                "00291041": {
                    "vr": "CS",
                    "Value": [
                        "SOM 7 AEC"
                    ]
                },
                "00291042": {
                    "vr": "LO",
                    "Value": [
                        "SOM 7 ATTENUATION"
                    ]
                },
                "00291043": {
                    "vr": "LO",
                    "Value": [
                        "VA10A 20060521"
                    ]
                },
                "00291044": {
                    "vr": "OB",
                    "InlineBinary": "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"
                }
            }
        ]
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            "Patient comments string"
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotype"
            }
        ]
    }
}


varying_hdr = {}


collated_data = {"00291010": {"0": {"vr": "OB", "BinaryLength": 1768}}, "7FE00010": {"0": {"vr": "OW", "BinaryLength": 699052}}}


