from copy import copy
from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__), **kwargs):
    hdr = evolve_header(constant_hdr, **kwargs)
    return generate_dicom(out_dir, num_vols, hdr,
                          collated_data, varying_hdr)



num_vols = 531


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.128"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "144927.519000"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "152419.000000"
        ]
    },
    "00080032": {
        "vr": "TM",
        "Value": [
            "152419.000000"
        ]
    },
    "00080050": {
        "vr": "SH",
        "Value": [
            "987654321"
        ]
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "PT"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "SIEMENS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "Address of said institute"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "University"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "QUADRA10016"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^Project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "PET SWB Uncorrected"
        ]
    },
    "00081040": {
        "vr": "LO",
        "Value": [
            "PET"
        ]
    },
    "00081050": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Principal Investigator"
            }
        ]
    },
    "00081070": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Sydney Imaging"
            }
        ]
    },
    "00081080": {
        "vr": "LO",
        "Value": [
            "Physics"
        ]
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "Biograph128_Vision Quadra Edge"
        ]
    },
    "00081250": {
        "vr": "SQ",
        "Value": [
            {
                "0020000D": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.30000023082422093565300000019"
                    ]
                },
                "0020000E": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.30000023082421255920000017965"
                    ]
                },
                "0040A170": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "122401"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "DCM"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "Same Anatomy"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20030619000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "7210"
                                ]
                            }
                        }
                    ]
                }
            }
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Session Identifier"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "Session Label"
        ]
    },
    "00100030": {
        "vr": "DA",
        "Value": [
            "19800228"
        ]
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "M"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "043Y"
        ]
    },
    "00101020": {
        "vr": "DS",
        "Value": [
            1.8
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            75.0
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "PARTIALBODY"
        ]
    },
    "00180050": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "10016"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "VR20B"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "U_FDG_SWB_LM (Adult)"
        ]
    },
    "00181181": {
        "vr": "CS",
        "Value": [
            "NONE"
        ]
    },
    "00181200": {
        "vr": "DA",
        "Value": [
            "20230825",
            "20230611"
        ]
    },
    "00181201": {
        "vr": "TM",
        "Value": [
            "010000.000000",
            "134228.000000"
        ]
    },
    "00181210": {
        "vr": "SH",
        "Value": [
            "All-pass"
        ]
    },
    "00181242": {
        "vr": "IS",
        "Value": [
            60000
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422093565300000019"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422262922600126865"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "PROJECT_ID"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            5
        ]
    },
    "00200012": {
        "vr": "IS",
        "Value": [
            2001
        ]
    },
    "00200037": {
        "vr": "DS",
        "Value": [
            1.0,
            0.0,
            0.0,
            0.0,
            1.0,
            0.0
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422094374600000050"
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00204000": {
        "vr": "LT",
        "Value": [
            "Volume Scaled"
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            440
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            440
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            1.65,
            1.65
        ]
    },
    "00280051": {
        "vr": "CS",
        "Value": [
            "NORM",
            "DTIM",
            "DECY",
            "RAN"
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            15
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00280106": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00281052": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00281053": {
        "vr": "DS",
        "Value": [
            0.496988
        ]
    },
    "00281054": {
        "vr": "LO",
        "Value": [
            "PROPCPS"
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CSA HEADER"
        ]
    },
    "00291018": {
        "vr": "CS",
        "Value": [
            "PET_REPLAY_PARAM"
        ]
    },
    "00291019": {
        "vr": "LO",
        "Value": [
            "1.3"
        ]
    },
    "00540013": {
        "vr": "SQ",
        "Value": [
            {
                "00540014": {
                    "vr": "DS",
                    "Value": [
                        435.0
                    ]
                },
                "00540015": {
                    "vr": "DS",
                    "Value": [
                        585.0
                    ]
                }
            }
        ]
    },
    "00540016": {
        "vr": "SQ",
        "Value": [
            {
                "00083012": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.20230825144942123"
                    ]
                },
                "00180031": {
                    "vr": "LO",
                    "Value": [
                        "Germanium"
                    ]
                },
                "00181072": {
                    "vr": "TM",
                    "Value": [
                        "144942.000000"
                    ]
                },
                "00181074": {
                    "vr": "DS",
                    "Value": [
                        85740000.0
                    ]
                },
                "00181075": {
                    "vr": "DS",
                    "Value": [
                        23410100.0
                    ]
                },
                "00181076": {
                    "vr": "DS",
                    "Value": [
                        0.8891
                    ]
                },
                "00181078": {
                    "vr": "DT",
                    "Value": [
                        "20230825144942.000000"
                    ]
                },
                "00181079": {
                    "vr": "DT",
                    "Value": [
                        "20230825144942.000000"
                    ]
                },
                "00540300": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "C-128A2"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "SRT"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "^68^Germanium"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20070625000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "4020"
                                ]
                            }
                        }
                    ]
                },
                "00540304": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "C-B1046"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "SRT"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "Germanium Ge^68^"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20070625000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "4021"
                                ]
                            }
                        }
                    ]
                }
            }
        ]
    },
    "00540081": {
        "vr": "US",
        "Value": [
            531
        ]
    },
    "00540410": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "F-10450"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "99SDM"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "recumbent"
                    ]
                },
                "00080105": {
                    "vr": "CS",
                    "Value": [
                        "DCMR"
                    ]
                },
                "00080106": {
                    "vr": "DT",
                    "Value": [
                        "20020904000000.000000"
                    ]
                },
                "0008010F": {
                    "vr": "CS",
                    "Value": [
                        "19"
                    ]
                },
                "00540412": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "F-10340"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "99SDM"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "supine"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20020904000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "20"
                                ]
                            }
                        }
                    ]
                }
            }
        ]
    },
    "00540414": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "F-10470"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "99SDM"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "headfirst"
                    ]
                },
                "00080105": {
                    "vr": "CS",
                    "Value": [
                        "DCMR"
                    ]
                },
                "00080106": {
                    "vr": "DT",
                    "Value": [
                        "20020904000000.000000"
                    ]
                },
                "0008010F": {
                    "vr": "CS",
                    "Value": [
                        "21"
                    ]
                }
            }
        ]
    },
    "00541000": {
        "vr": "CS",
        "Value": [
            "WHOLE BODY",
            "IMAGE"
        ]
    },
    "00541001": {
        "vr": "CS",
        "Value": [
            "PROPCPS"
        ]
    },
    "00541002": {
        "vr": "CS",
        "Value": [
            "EMISSION"
        ]
    },
    "00541100": {
        "vr": "CS",
        "Value": [
            "DLYD"
        ]
    },
    "00541102": {
        "vr": "CS",
        "Value": [
            "START"
        ]
    },
    "00541103": {
        "vr": "LO",
        "Value": [
            "PSF+TOF 4i5s RD322"
        ]
    },
    "00541200": {
        "vr": "DS",
        "Value": [
            322.0
        ]
    },
    "00541201": {
        "vr": "IS",
        "Value": [
            9,
            10
        ]
    },
    "00541300": {
        "vr": "DS",
        "Value": [
            30000.0
        ]
    },
    "00541321": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00541322": {
        "vr": "DS",
        "Value": [
            106642000.0
        ]
    },
    "00541323": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00710010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MED PT"
        ]
    },
    "00711022": {
        "vr": "DT",
        "Value": [
            "20230825152419.000000"
        ]
    },
    "00711024": {
        "vr": "CS",
        "Value": [
            "STATIC"
        ]
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            "Patient comments string"
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotype"
            }
        ]
    }
}


varying_hdr = {"00080018": {"0": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126866"]}, "1": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126867"]}, "2": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126868"]}, "3": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126869"]}, "4": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126870"]}, "5": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126871"]}, "6": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126872"]}, "7": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126873"]}, "8": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126874"]}, "9": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126875"]}, "10": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126876"]}, "11": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126877"]}, "12": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126878"]}, "13": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126879"]}, "14": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126880"]}, "15": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126881"]}, "16": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126882"]}, "17": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126883"]}, "18": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126884"]}, "19": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126885"]}, "20": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126886"]}, "21": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126887"]}, "22": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126888"]}, "23": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126889"]}, "24": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126890"]}, "25": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126891"]}, "26": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126892"]}, "27": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126893"]}, "28": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126894"]}, "29": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126895"]}, "30": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126896"]}, "31": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126897"]}, "32": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126898"]}, "33": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126899"]}, "34": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126900"]}, "35": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126901"]}, "36": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126902"]}, "37": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126903"]}, "38": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126904"]}, "39": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126905"]}, "40": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126906"]}, "41": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126907"]}, "42": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126908"]}, "43": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126909"]}, "44": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126910"]}, "45": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126911"]}, "46": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126912"]}, "47": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126913"]}, "48": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126914"]}, "49": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126915"]}, "50": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126916"]}, "51": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126917"]}, "52": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126918"]}, "53": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126919"]}, "54": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126920"]}, "55": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126921"]}, "56": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126922"]}, "57": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126923"]}, "58": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126924"]}, "59": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126925"]}, "60": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126926"]}, "61": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126927"]}, "62": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126928"]}, "63": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126929"]}, "64": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126930"]}, "65": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126931"]}, "66": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126932"]}, "67": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126933"]}, "68": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126934"]}, "69": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126935"]}, "70": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126936"]}, "71": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126937"]}, "72": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126938"]}, "73": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126939"]}, "74": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126940"]}, "75": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126941"]}, "76": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126942"]}, "77": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126943"]}, "78": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126944"]}, "79": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126945"]}, "80": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126946"]}, "81": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126947"]}, "82": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126948"]}, "83": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126949"]}, "84": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126950"]}, "85": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126951"]}, "86": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126952"]}, "87": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126953"]}, "88": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126954"]}, "89": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126955"]}, "90": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126956"]}, "91": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126957"]}, "92": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126958"]}, "93": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126959"]}, "94": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126960"]}, "95": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126961"]}, "96": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126962"]}, "97": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126963"]}, "98": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126964"]}, "99": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126965"]}, "100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126966"]}, "101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126967"]}, "102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126968"]}, "103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126969"]}, "104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126970"]}, "105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126971"]}, "106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126972"]}, "107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126973"]}, "108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126974"]}, "109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126975"]}, "110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126976"]}, "111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126977"]}, "112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126978"]}, "113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126979"]}, "114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126980"]}, "115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126981"]}, "116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126982"]}, "117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126983"]}, "118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126984"]}, "119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126985"]}, "120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126986"]}, "121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126987"]}, "122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126988"]}, "123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126989"]}, "124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126990"]}, "125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126991"]}, "126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126992"]}, "127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126993"]}, "128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126994"]}, "129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126995"]}, "130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126996"]}, "131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126997"]}, "132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126998"]}, "133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600126999"]}, "134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127000"]}, "135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127001"]}, "136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127002"]}, "137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127003"]}, "138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127004"]}, "139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127005"]}, "140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127006"]}, "141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127007"]}, "142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127008"]}, "143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127009"]}, "144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127010"]}, "145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127011"]}, "146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127012"]}, "147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127013"]}, "148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127014"]}, "149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127015"]}, "150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127016"]}, "151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127017"]}, "152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127018"]}, "153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127019"]}, "154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127020"]}, "155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127021"]}, "156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127022"]}, "157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127023"]}, "158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127024"]}, "159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127025"]}, "160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127026"]}, "161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127027"]}, "162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127028"]}, "163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127029"]}, "164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127030"]}, "165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127031"]}, "166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127032"]}, "167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127033"]}, "168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127034"]}, "169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127035"]}, "170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127036"]}, "171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127037"]}, "172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127038"]}, "173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127039"]}, "174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127040"]}, "175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127041"]}, "176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127042"]}, "177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127043"]}, "178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127044"]}, "179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127045"]}, "180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127046"]}, "181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127047"]}, "182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127048"]}, "183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127049"]}, "184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127050"]}, "185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127051"]}, "186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127052"]}, "187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127053"]}, "188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127054"]}, "189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127055"]}, "190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127056"]}, "191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127057"]}, "192": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127058"]}, "193": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127059"]}, "194": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127060"]}, "195": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127061"]}, "196": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127062"]}, "197": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127063"]}, "198": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127064"]}, "199": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127065"]}, "200": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127066"]}, "201": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127067"]}, "202": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127068"]}, "203": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127069"]}, "204": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127070"]}, "205": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127071"]}, "206": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127072"]}, "207": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127073"]}, "208": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127074"]}, "209": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127075"]}, "210": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127076"]}, "211": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127077"]}, "212": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127078"]}, "213": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127079"]}, "214": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127080"]}, "215": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127081"]}, "216": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127082"]}, "217": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127083"]}, "218": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127084"]}, "219": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127085"]}, "220": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127086"]}, "221": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127087"]}, "222": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127088"]}, "223": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127089"]}, "224": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127090"]}, "225": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127091"]}, "226": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127092"]}, "227": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127093"]}, "228": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127094"]}, "229": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127095"]}, "230": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127096"]}, "231": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127097"]}, "232": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127098"]}, "233": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127099"]}, "234": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127100"]}, "235": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127101"]}, "236": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127102"]}, "237": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127103"]}, "238": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127104"]}, "239": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127105"]}, "240": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127106"]}, "241": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127107"]}, "242": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127108"]}, "243": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127109"]}, "244": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127110"]}, "245": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127111"]}, "246": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127112"]}, "247": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127113"]}, "248": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127114"]}, "249": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127115"]}, "250": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127116"]}, "251": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127117"]}, "252": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127118"]}, "253": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127119"]}, "254": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127120"]}, "255": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127121"]}, "256": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127122"]}, "257": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127123"]}, "258": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127124"]}, "259": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127125"]}, "260": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127126"]}, "261": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127127"]}, "262": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127128"]}, "263": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127129"]}, "264": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127130"]}, "265": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127131"]}, "266": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127132"]}, "267": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127133"]}, "268": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127134"]}, "269": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127135"]}, "270": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127136"]}, "271": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127137"]}, "272": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127138"]}, "273": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127139"]}, "274": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127140"]}, "275": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127141"]}, "276": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127142"]}, "277": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127143"]}, "278": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127144"]}, "279": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127145"]}, "280": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127146"]}, "281": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127147"]}, "282": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127148"]}, "283": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127149"]}, "284": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127150"]}, "285": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127151"]}, "286": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127152"]}, "287": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127153"]}, "288": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127154"]}, "289": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127155"]}, "290": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127156"]}, "291": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127157"]}, "292": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127158"]}, "293": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127159"]}, "294": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127160"]}, "295": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127161"]}, "296": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127162"]}, "297": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127163"]}, "298": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127164"]}, "299": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127165"]}, "300": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127166"]}, "301": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127167"]}, "302": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127168"]}, "303": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127169"]}, "304": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127170"]}, "305": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127171"]}, "306": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127172"]}, "307": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127173"]}, "308": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127174"]}, "309": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127175"]}, "310": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127176"]}, "311": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127177"]}, "312": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127178"]}, "313": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127179"]}, "314": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127180"]}, "315": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127181"]}, "316": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127182"]}, "317": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127183"]}, "318": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127184"]}, "319": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127185"]}, "320": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127186"]}, "321": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127187"]}, "322": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127188"]}, "323": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127189"]}, "324": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127190"]}, "325": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127191"]}, "326": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127192"]}, "327": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127193"]}, "328": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127194"]}, "329": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127195"]}, "330": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127196"]}, "331": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127197"]}, "332": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127198"]}, "333": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127199"]}, "334": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127200"]}, "335": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127201"]}, "336": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127202"]}, "337": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127203"]}, "338": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127204"]}, "339": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127205"]}, "340": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127206"]}, "341": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127207"]}, "342": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127208"]}, "343": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127209"]}, "344": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127210"]}, "345": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127211"]}, "346": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127212"]}, "347": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127213"]}, "348": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127214"]}, "349": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127215"]}, "350": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127216"]}, "351": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127217"]}, "352": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127218"]}, "353": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127219"]}, "354": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127220"]}, "355": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127221"]}, "356": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127222"]}, "357": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127223"]}, "358": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127224"]}, "359": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127225"]}, "360": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127226"]}, "361": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127227"]}, "362": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127228"]}, "363": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127229"]}, "364": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127230"]}, "365": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127231"]}, "366": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127232"]}, "367": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127233"]}, "368": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127234"]}, "369": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127235"]}, "370": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127236"]}, "371": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127237"]}, "372": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127238"]}, "373": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127239"]}, "374": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127240"]}, "375": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127241"]}, "376": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127242"]}, "377": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127243"]}, "378": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127244"]}, "379": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127245"]}, "380": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127246"]}, "381": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127247"]}, "382": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127248"]}, "383": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127249"]}, "384": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127250"]}, "385": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127251"]}, "386": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127252"]}, "387": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127253"]}, "388": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127254"]}, "389": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127255"]}, "390": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127256"]}, "391": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127257"]}, "392": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127258"]}, "393": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127259"]}, "394": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127260"]}, "395": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127261"]}, "396": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127262"]}, "397": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127263"]}, "398": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127264"]}, "399": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127265"]}, "400": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127266"]}, "401": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127267"]}, "402": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127268"]}, "403": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127269"]}, "404": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127270"]}, "405": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127271"]}, "406": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127272"]}, "407": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127273"]}, "408": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127274"]}, "409": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127275"]}, "410": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127276"]}, "411": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127277"]}, "412": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127278"]}, "413": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127279"]}, "414": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127280"]}, "415": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127281"]}, "416": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127282"]}, "417": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127283"]}, "418": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127284"]}, "419": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127285"]}, "420": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127286"]}, "421": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127287"]}, "422": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127288"]}, "423": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127289"]}, "424": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127290"]}, "425": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127291"]}, "426": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127292"]}, "427": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127293"]}, "428": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127294"]}, "429": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127295"]}, "430": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127296"]}, "431": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127297"]}, "432": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127298"]}, "433": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127299"]}, "434": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127300"]}, "435": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127301"]}, "436": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127302"]}, "437": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127303"]}, "438": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127304"]}, "439": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127305"]}, "440": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127306"]}, "441": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127307"]}, "442": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127308"]}, "443": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127309"]}, "444": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127310"]}, "445": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127311"]}, "446": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127312"]}, "447": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127313"]}, "448": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127314"]}, "449": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127315"]}, "450": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127316"]}, "451": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127317"]}, "452": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127318"]}, "453": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127319"]}, "454": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127320"]}, "455": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127321"]}, "456": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127322"]}, "457": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127323"]}, "458": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127324"]}, "459": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127325"]}, "460": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127326"]}, "461": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127327"]}, "462": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127328"]}, "463": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127329"]}, "464": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127330"]}, "465": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127331"]}, "466": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127332"]}, "467": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127333"]}, "468": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127334"]}, "469": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127335"]}, "470": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127336"]}, "471": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127337"]}, "472": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127338"]}, "473": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127339"]}, "474": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127340"]}, "475": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127341"]}, "476": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127342"]}, "477": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127343"]}, "478": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127344"]}, "479": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127345"]}, "480": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127346"]}, "481": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127347"]}, "482": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127348"]}, "483": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127349"]}, "484": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127350"]}, "485": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127351"]}, "486": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127352"]}, "487": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127353"]}, "488": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127354"]}, "489": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127355"]}, "490": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127356"]}, "491": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127357"]}, "492": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127358"]}, "493": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127359"]}, "494": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127360"]}, "495": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127361"]}, "496": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127362"]}, "497": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127363"]}, "498": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127364"]}, "499": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127365"]}, "500": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127366"]}, "501": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127367"]}, "502": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127368"]}, "503": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127369"]}, "504": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127370"]}, "505": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127371"]}, "506": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127372"]}, "507": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127373"]}, "508": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127374"]}, "509": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127375"]}, "510": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127376"]}, "511": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127377"]}, "512": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127378"]}, "513": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127379"]}, "514": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127380"]}, "515": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127381"]}, "516": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127382"]}, "517": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127383"]}, "518": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127384"]}, "519": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127385"]}, "520": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127386"]}, "521": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127387"]}, "522": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127388"]}, "523": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127389"]}, "524": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127390"]}, "525": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127391"]}, "526": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127392"]}, "527": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127393"]}, "528": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127394"]}, "529": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127395"]}, "530": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127396"]}}, "00080033": {"0": {"vr": "TM", "Value": ["153056.081000"]}, "1": {"vr": "TM", "Value": ["153056.081000"]}, "2": {"vr": "TM", "Value": ["153056.081000"]}, "3": {"vr": "TM", "Value": ["153056.081000"]}, "4": {"vr": "TM", "Value": ["153056.081000"]}, "5": {"vr": "TM", "Value": ["153056.081000"]}, "6": {"vr": "TM", "Value": ["153056.081000"]}, "7": {"vr": "TM", "Value": ["153056.081000"]}, "8": {"vr": "TM", "Value": ["153056.081000"]}, "9": {"vr": "TM", "Value": ["153056.081000"]}, "10": {"vr": "TM", "Value": ["153056.081000"]}, "11": {"vr": "TM", "Value": ["153056.081000"]}, "12": {"vr": "TM", "Value": ["153056.081000"]}, "13": {"vr": "TM", "Value": ["153056.081000"]}, "14": {"vr": "TM", "Value": ["153056.081000"]}, "15": {"vr": "TM", "Value": ["153056.081000"]}, "16": {"vr": "TM", "Value": ["153056.081000"]}, "17": {"vr": "TM", "Value": ["153056.081000"]}, "18": {"vr": "TM", "Value": ["153056.081000"]}, "19": {"vr": "TM", "Value": ["153056.081000"]}, "20": {"vr": "TM", "Value": ["153056.081000"]}, "21": {"vr": "TM", "Value": ["153056.081000"]}, "22": {"vr": "TM", "Value": ["153056.081000"]}, "23": {"vr": "TM", "Value": ["153056.081000"]}, "24": {"vr": "TM", "Value": ["153056.081000"]}, "25": {"vr": "TM", "Value": ["153056.081000"]}, "26": {"vr": "TM", "Value": ["153056.081000"]}, "27": {"vr": "TM", "Value": ["153056.081000"]}, "28": {"vr": "TM", "Value": ["153056.081000"]}, "29": {"vr": "TM", "Value": ["153056.081000"]}, "30": {"vr": "TM", "Value": ["153056.081000"]}, "31": {"vr": "TM", "Value": ["153056.081000"]}, "32": {"vr": "TM", "Value": ["153056.081000"]}, "33": {"vr": "TM", "Value": ["153056.081000"]}, "34": {"vr": "TM", "Value": ["153056.081000"]}, "35": {"vr": "TM", "Value": ["153056.081000"]}, "36": {"vr": "TM", "Value": ["153056.081000"]}, "37": {"vr": "TM", "Value": ["153056.081000"]}, "38": {"vr": "TM", "Value": ["153056.081000"]}, "39": {"vr": "TM", "Value": ["153056.081000"]}, "40": {"vr": "TM", "Value": ["153056.081000"]}, "41": {"vr": "TM", "Value": ["153056.081000"]}, "42": {"vr": "TM", "Value": ["153056.081000"]}, "43": {"vr": "TM", "Value": ["153056.081000"]}, "44": {"vr": "TM", "Value": ["153056.081000"]}, "45": {"vr": "TM", "Value": ["153056.081000"]}, "46": {"vr": "TM", "Value": ["153056.081000"]}, "47": {"vr": "TM", "Value": ["153056.081000"]}, "48": {"vr": "TM", "Value": ["153056.081000"]}, "49": {"vr": "TM", "Value": ["153056.081000"]}, "50": {"vr": "TM", "Value": ["153056.229000"]}, "51": {"vr": "TM", "Value": ["153056.229000"]}, "52": {"vr": "TM", "Value": ["153056.229000"]}, "53": {"vr": "TM", "Value": ["153056.229000"]}, "54": {"vr": "TM", "Value": ["153056.229000"]}, "55": {"vr": "TM", "Value": ["153056.229000"]}, "56": {"vr": "TM", "Value": ["153056.229000"]}, "57": {"vr": "TM", "Value": ["153056.229000"]}, "58": {"vr": "TM", "Value": ["153056.229000"]}, "59": {"vr": "TM", "Value": ["153056.229000"]}, "60": {"vr": "TM", "Value": ["153056.229000"]}, "61": {"vr": "TM", "Value": ["153056.229000"]}, "62": {"vr": "TM", "Value": ["153056.229000"]}, "63": {"vr": "TM", "Value": ["153056.229000"]}, "64": {"vr": "TM", "Value": ["153056.229000"]}, "65": {"vr": "TM", "Value": ["153056.229000"]}, "66": {"vr": "TM", "Value": ["153056.229000"]}, "67": {"vr": "TM", "Value": ["153056.229000"]}, "68": {"vr": "TM", "Value": ["153056.229000"]}, "69": {"vr": "TM", "Value": ["153056.229000"]}, "70": {"vr": "TM", "Value": ["153056.229000"]}, "71": {"vr": "TM", "Value": ["153056.229000"]}, "72": {"vr": "TM", "Value": ["153056.229000"]}, "73": {"vr": "TM", "Value": ["153056.229000"]}, "74": {"vr": "TM", "Value": ["153056.229000"]}, "75": {"vr": "TM", "Value": ["153056.229000"]}, "76": {"vr": "TM", "Value": ["153056.229000"]}, "77": {"vr": "TM", "Value": ["153056.229000"]}, "78": {"vr": "TM", "Value": ["153056.229000"]}, "79": {"vr": "TM", "Value": ["153056.229000"]}, "80": {"vr": "TM", "Value": ["153056.229000"]}, "81": {"vr": "TM", "Value": ["153056.229000"]}, "82": {"vr": "TM", "Value": ["153056.229000"]}, "83": {"vr": "TM", "Value": ["153056.229000"]}, "84": {"vr": "TM", "Value": ["153056.229000"]}, "85": {"vr": "TM", "Value": ["153056.229000"]}, "86": {"vr": "TM", "Value": ["153056.229000"]}, "87": {"vr": "TM", "Value": ["153056.229000"]}, "88": {"vr": "TM", "Value": ["153056.229000"]}, "89": {"vr": "TM", "Value": ["153056.229000"]}, "90": {"vr": "TM", "Value": ["153056.229000"]}, "91": {"vr": "TM", "Value": ["153056.229000"]}, "92": {"vr": "TM", "Value": ["153056.229000"]}, "93": {"vr": "TM", "Value": ["153056.229000"]}, "94": {"vr": "TM", "Value": ["153056.229000"]}, "95": {"vr": "TM", "Value": ["153056.229000"]}, "96": {"vr": "TM", "Value": ["153056.229000"]}, "97": {"vr": "TM", "Value": ["153056.229000"]}, "98": {"vr": "TM", "Value": ["153056.229000"]}, "99": {"vr": "TM", "Value": ["153056.229000"]}, "100": {"vr": "TM", "Value": ["153056.380000"]}, "101": {"vr": "TM", "Value": ["153056.380000"]}, "102": {"vr": "TM", "Value": ["153056.380000"]}, "103": {"vr": "TM", "Value": ["153056.380000"]}, "104": {"vr": "TM", "Value": ["153056.380000"]}, "105": {"vr": "TM", "Value": ["153056.380000"]}, "106": {"vr": "TM", "Value": ["153056.380000"]}, "107": {"vr": "TM", "Value": ["153056.380000"]}, "108": {"vr": "TM", "Value": ["153056.380000"]}, "109": {"vr": "TM", "Value": ["153056.380000"]}, "110": {"vr": "TM", "Value": ["153056.380000"]}, "111": {"vr": "TM", "Value": ["153056.380000"]}, "112": {"vr": "TM", "Value": ["153056.380000"]}, "113": {"vr": "TM", "Value": ["153056.380000"]}, "114": {"vr": "TM", "Value": ["153056.380000"]}, "115": {"vr": "TM", "Value": ["153056.380000"]}, "116": {"vr": "TM", "Value": ["153056.380000"]}, "117": {"vr": "TM", "Value": ["153056.380000"]}, "118": {"vr": "TM", "Value": ["153056.380000"]}, "119": {"vr": "TM", "Value": ["153056.380000"]}, "120": {"vr": "TM", "Value": ["153056.380000"]}, "121": {"vr": "TM", "Value": ["153056.380000"]}, "122": {"vr": "TM", "Value": ["153056.380000"]}, "123": {"vr": "TM", "Value": ["153056.380000"]}, "124": {"vr": "TM", "Value": ["153056.380000"]}, "125": {"vr": "TM", "Value": ["153056.380000"]}, "126": {"vr": "TM", "Value": ["153056.380000"]}, "127": {"vr": "TM", "Value": ["153056.380000"]}, "128": {"vr": "TM", "Value": ["153056.380000"]}, "129": {"vr": "TM", "Value": ["153056.380000"]}, "130": {"vr": "TM", "Value": ["153056.380000"]}, "131": {"vr": "TM", "Value": ["153056.380000"]}, "132": {"vr": "TM", "Value": ["153056.380000"]}, "133": {"vr": "TM", "Value": ["153056.380000"]}, "134": {"vr": "TM", "Value": ["153056.380000"]}, "135": {"vr": "TM", "Value": ["153056.380000"]}, "136": {"vr": "TM", "Value": ["153056.380000"]}, "137": {"vr": "TM", "Value": ["153056.380000"]}, "138": {"vr": "TM", "Value": ["153056.380000"]}, "139": {"vr": "TM", "Value": ["153056.380000"]}, "140": {"vr": "TM", "Value": ["153056.380000"]}, "141": {"vr": "TM", "Value": ["153056.380000"]}, "142": {"vr": "TM", "Value": ["153056.380000"]}, "143": {"vr": "TM", "Value": ["153056.380000"]}, "144": {"vr": "TM", "Value": ["153056.380000"]}, "145": {"vr": "TM", "Value": ["153056.380000"]}, "146": {"vr": "TM", "Value": ["153056.380000"]}, "147": {"vr": "TM", "Value": ["153056.380000"]}, "148": {"vr": "TM", "Value": ["153056.380000"]}, "149": {"vr": "TM", "Value": ["153056.380000"]}, "150": {"vr": "TM", "Value": ["153056.532000"]}, "151": {"vr": "TM", "Value": ["153056.532000"]}, "152": {"vr": "TM", "Value": ["153056.532000"]}, "153": {"vr": "TM", "Value": ["153056.532000"]}, "154": {"vr": "TM", "Value": ["153056.532000"]}, "155": {"vr": "TM", "Value": ["153056.532000"]}, "156": {"vr": "TM", "Value": ["153056.532000"]}, "157": {"vr": "TM", "Value": ["153056.532000"]}, "158": {"vr": "TM", "Value": ["153056.532000"]}, "159": {"vr": "TM", "Value": ["153056.532000"]}, "160": {"vr": "TM", "Value": ["153056.532000"]}, "161": {"vr": "TM", "Value": ["153056.532000"]}, "162": {"vr": "TM", "Value": ["153056.532000"]}, "163": {"vr": "TM", "Value": ["153056.532000"]}, "164": {"vr": "TM", "Value": ["153056.532000"]}, "165": {"vr": "TM", "Value": ["153056.532000"]}, "166": {"vr": "TM", "Value": ["153056.532000"]}, "167": {"vr": "TM", "Value": ["153056.532000"]}, "168": {"vr": "TM", "Value": ["153056.532000"]}, "169": {"vr": "TM", "Value": ["153056.532000"]}, "170": {"vr": "TM", "Value": ["153056.532000"]}, "171": {"vr": "TM", "Value": ["153056.532000"]}, "172": {"vr": "TM", "Value": ["153056.532000"]}, "173": {"vr": "TM", "Value": ["153056.532000"]}, "174": {"vr": "TM", "Value": ["153056.532000"]}, "175": {"vr": "TM", "Value": ["153056.532000"]}, "176": {"vr": "TM", "Value": ["153056.532000"]}, "177": {"vr": "TM", "Value": ["153056.532000"]}, "178": {"vr": "TM", "Value": ["153056.532000"]}, "179": {"vr": "TM", "Value": ["153056.532000"]}, "180": {"vr": "TM", "Value": ["153056.532000"]}, "181": {"vr": "TM", "Value": ["153056.532000"]}, "182": {"vr": "TM", "Value": ["153056.532000"]}, "183": {"vr": "TM", "Value": ["153056.532000"]}, "184": {"vr": "TM", "Value": ["153056.532000"]}, "185": {"vr": "TM", "Value": ["153056.532000"]}, "186": {"vr": "TM", "Value": ["153056.532000"]}, "187": {"vr": "TM", "Value": ["153056.532000"]}, "188": {"vr": "TM", "Value": ["153056.532000"]}, "189": {"vr": "TM", "Value": ["153056.532000"]}, "190": {"vr": "TM", "Value": ["153056.532000"]}, "191": {"vr": "TM", "Value": ["153056.532000"]}, "192": {"vr": "TM", "Value": ["153056.532000"]}, "193": {"vr": "TM", "Value": ["153056.532000"]}, "194": {"vr": "TM", "Value": ["153056.532000"]}, "195": {"vr": "TM", "Value": ["153056.532000"]}, "196": {"vr": "TM", "Value": ["153056.532000"]}, "197": {"vr": "TM", "Value": ["153056.532000"]}, "198": {"vr": "TM", "Value": ["153056.532000"]}, "199": {"vr": "TM", "Value": ["153056.532000"]}, "200": {"vr": "TM", "Value": ["153056.661000"]}, "201": {"vr": "TM", "Value": ["153056.661000"]}, "202": {"vr": "TM", "Value": ["153056.661000"]}, "203": {"vr": "TM", "Value": ["153056.661000"]}, "204": {"vr": "TM", "Value": ["153056.661000"]}, "205": {"vr": "TM", "Value": ["153056.661000"]}, "206": {"vr": "TM", "Value": ["153056.661000"]}, "207": {"vr": "TM", "Value": ["153056.661000"]}, "208": {"vr": "TM", "Value": ["153056.661000"]}, "209": {"vr": "TM", "Value": ["153056.661000"]}, "210": {"vr": "TM", "Value": ["153056.661000"]}, "211": {"vr": "TM", "Value": ["153056.661000"]}, "212": {"vr": "TM", "Value": ["153056.661000"]}, "213": {"vr": "TM", "Value": ["153056.661000"]}, "214": {"vr": "TM", "Value": ["153056.661000"]}, "215": {"vr": "TM", "Value": ["153056.661000"]}, "216": {"vr": "TM", "Value": ["153056.661000"]}, "217": {"vr": "TM", "Value": ["153056.661000"]}, "218": {"vr": "TM", "Value": ["153056.661000"]}, "219": {"vr": "TM", "Value": ["153056.661000"]}, "220": {"vr": "TM", "Value": ["153056.661000"]}, "221": {"vr": "TM", "Value": ["153056.661000"]}, "222": {"vr": "TM", "Value": ["153056.661000"]}, "223": {"vr": "TM", "Value": ["153056.661000"]}, "224": {"vr": "TM", "Value": ["153056.661000"]}, "225": {"vr": "TM", "Value": ["153056.661000"]}, "226": {"vr": "TM", "Value": ["153056.661000"]}, "227": {"vr": "TM", "Value": ["153056.661000"]}, "228": {"vr": "TM", "Value": ["153056.661000"]}, "229": {"vr": "TM", "Value": ["153056.661000"]}, "230": {"vr": "TM", "Value": ["153056.661000"]}, "231": {"vr": "TM", "Value": ["153056.661000"]}, "232": {"vr": "TM", "Value": ["153056.661000"]}, "233": {"vr": "TM", "Value": ["153056.661000"]}, "234": {"vr": "TM", "Value": ["153056.661000"]}, "235": {"vr": "TM", "Value": ["153056.661000"]}, "236": {"vr": "TM", "Value": ["153056.661000"]}, "237": {"vr": "TM", "Value": ["153056.661000"]}, "238": {"vr": "TM", "Value": ["153056.661000"]}, "239": {"vr": "TM", "Value": ["153056.661000"]}, "240": {"vr": "TM", "Value": ["153056.661000"]}, "241": {"vr": "TM", "Value": ["153056.661000"]}, "242": {"vr": "TM", "Value": ["153056.661000"]}, "243": {"vr": "TM", "Value": ["153056.661000"]}, "244": {"vr": "TM", "Value": ["153056.661000"]}, "245": {"vr": "TM", "Value": ["153056.661000"]}, "246": {"vr": "TM", "Value": ["153056.661000"]}, "247": {"vr": "TM", "Value": ["153056.661000"]}, "248": {"vr": "TM", "Value": ["153056.661000"]}, "249": {"vr": "TM", "Value": ["153056.661000"]}, "250": {"vr": "TM", "Value": ["153056.797000"]}, "251": {"vr": "TM", "Value": ["153056.797000"]}, "252": {"vr": "TM", "Value": ["153056.797000"]}, "253": {"vr": "TM", "Value": ["153056.797000"]}, "254": {"vr": "TM", "Value": ["153056.797000"]}, "255": {"vr": "TM", "Value": ["153056.797000"]}, "256": {"vr": "TM", "Value": ["153056.797000"]}, "257": {"vr": "TM", "Value": ["153056.797000"]}, "258": {"vr": "TM", "Value": ["153056.797000"]}, "259": {"vr": "TM", "Value": ["153056.797000"]}, "260": {"vr": "TM", "Value": ["153056.797000"]}, "261": {"vr": "TM", "Value": ["153056.797000"]}, "262": {"vr": "TM", "Value": ["153056.797000"]}, "263": {"vr": "TM", "Value": ["153056.797000"]}, "264": {"vr": "TM", "Value": ["153056.797000"]}, "265": {"vr": "TM", "Value": ["153056.797000"]}, "266": {"vr": "TM", "Value": ["153056.797000"]}, "267": {"vr": "TM", "Value": ["153056.797000"]}, "268": {"vr": "TM", "Value": ["153056.797000"]}, "269": {"vr": "TM", "Value": ["153056.797000"]}, "270": {"vr": "TM", "Value": ["153056.797000"]}, "271": {"vr": "TM", "Value": ["153056.797000"]}, "272": {"vr": "TM", "Value": ["153056.797000"]}, "273": {"vr": "TM", "Value": ["153056.797000"]}, "274": {"vr": "TM", "Value": ["153056.797000"]}, "275": {"vr": "TM", "Value": ["153056.797000"]}, "276": {"vr": "TM", "Value": ["153056.797000"]}, "277": {"vr": "TM", "Value": ["153056.797000"]}, "278": {"vr": "TM", "Value": ["153056.797000"]}, "279": {"vr": "TM", "Value": ["153056.797000"]}, "280": {"vr": "TM", "Value": ["153056.797000"]}, "281": {"vr": "TM", "Value": ["153056.797000"]}, "282": {"vr": "TM", "Value": ["153056.797000"]}, "283": {"vr": "TM", "Value": ["153056.797000"]}, "284": {"vr": "TM", "Value": ["153056.797000"]}, "285": {"vr": "TM", "Value": ["153056.797000"]}, "286": {"vr": "TM", "Value": ["153056.797000"]}, "287": {"vr": "TM", "Value": ["153056.797000"]}, "288": {"vr": "TM", "Value": ["153056.797000"]}, "289": {"vr": "TM", "Value": ["153056.797000"]}, "290": {"vr": "TM", "Value": ["153056.797000"]}, "291": {"vr": "TM", "Value": ["153056.797000"]}, "292": {"vr": "TM", "Value": ["153056.797000"]}, "293": {"vr": "TM", "Value": ["153056.797000"]}, "294": {"vr": "TM", "Value": ["153056.797000"]}, "295": {"vr": "TM", "Value": ["153056.797000"]}, "296": {"vr": "TM", "Value": ["153056.797000"]}, "297": {"vr": "TM", "Value": ["153056.797000"]}, "298": {"vr": "TM", "Value": ["153056.797000"]}, "299": {"vr": "TM", "Value": ["153056.797000"]}, "300": {"vr": "TM", "Value": ["153056.979000"]}, "301": {"vr": "TM", "Value": ["153056.979000"]}, "302": {"vr": "TM", "Value": ["153056.979000"]}, "303": {"vr": "TM", "Value": ["153056.979000"]}, "304": {"vr": "TM", "Value": ["153056.979000"]}, "305": {"vr": "TM", "Value": ["153056.979000"]}, "306": {"vr": "TM", "Value": ["153056.979000"]}, "307": {"vr": "TM", "Value": ["153056.979000"]}, "308": {"vr": "TM", "Value": ["153056.979000"]}, "309": {"vr": "TM", "Value": ["153056.979000"]}, "310": {"vr": "TM", "Value": ["153056.979000"]}, "311": {"vr": "TM", "Value": ["153056.979000"]}, "312": {"vr": "TM", "Value": ["153056.979000"]}, "313": {"vr": "TM", "Value": ["153056.979000"]}, "314": {"vr": "TM", "Value": ["153056.979000"]}, "315": {"vr": "TM", "Value": ["153056.979000"]}, "316": {"vr": "TM", "Value": ["153056.979000"]}, "317": {"vr": "TM", "Value": ["153056.979000"]}, "318": {"vr": "TM", "Value": ["153056.979000"]}, "319": {"vr": "TM", "Value": ["153056.979000"]}, "320": {"vr": "TM", "Value": ["153056.979000"]}, "321": {"vr": "TM", "Value": ["153056.979000"]}, "322": {"vr": "TM", "Value": ["153056.979000"]}, "323": {"vr": "TM", "Value": ["153056.979000"]}, "324": {"vr": "TM", "Value": ["153056.979000"]}, "325": {"vr": "TM", "Value": ["153056.979000"]}, "326": {"vr": "TM", "Value": ["153056.979000"]}, "327": {"vr": "TM", "Value": ["153056.979000"]}, "328": {"vr": "TM", "Value": ["153056.979000"]}, "329": {"vr": "TM", "Value": ["153056.979000"]}, "330": {"vr": "TM", "Value": ["153056.979000"]}, "331": {"vr": "TM", "Value": ["153056.979000"]}, "332": {"vr": "TM", "Value": ["153056.979000"]}, "333": {"vr": "TM", "Value": ["153056.979000"]}, "334": {"vr": "TM", "Value": ["153056.979000"]}, "335": {"vr": "TM", "Value": ["153056.979000"]}, "336": {"vr": "TM", "Value": ["153056.979000"]}, "337": {"vr": "TM", "Value": ["153056.979000"]}, "338": {"vr": "TM", "Value": ["153056.979000"]}, "339": {"vr": "TM", "Value": ["153056.979000"]}, "340": {"vr": "TM", "Value": ["153056.979000"]}, "341": {"vr": "TM", "Value": ["153056.979000"]}, "342": {"vr": "TM", "Value": ["153056.979000"]}, "343": {"vr": "TM", "Value": ["153056.979000"]}, "344": {"vr": "TM", "Value": ["153056.979000"]}, "345": {"vr": "TM", "Value": ["153056.979000"]}, "346": {"vr": "TM", "Value": ["153056.979000"]}, "347": {"vr": "TM", "Value": ["153056.979000"]}, "348": {"vr": "TM", "Value": ["153056.979000"]}, "349": {"vr": "TM", "Value": ["153056.979000"]}, "350": {"vr": "TM", "Value": ["153057.105000"]}, "351": {"vr": "TM", "Value": ["153057.105000"]}, "352": {"vr": "TM", "Value": ["153057.105000"]}, "353": {"vr": "TM", "Value": ["153057.105000"]}, "354": {"vr": "TM", "Value": ["153057.105000"]}, "355": {"vr": "TM", "Value": ["153057.105000"]}, "356": {"vr": "TM", "Value": ["153057.105000"]}, "357": {"vr": "TM", "Value": ["153057.105000"]}, "358": {"vr": "TM", "Value": ["153057.105000"]}, "359": {"vr": "TM", "Value": ["153057.105000"]}, "360": {"vr": "TM", "Value": ["153057.105000"]}, "361": {"vr": "TM", "Value": ["153057.105000"]}, "362": {"vr": "TM", "Value": ["153057.105000"]}, "363": {"vr": "TM", "Value": ["153057.105000"]}, "364": {"vr": "TM", "Value": ["153057.105000"]}, "365": {"vr": "TM", "Value": ["153057.105000"]}, "366": {"vr": "TM", "Value": ["153057.105000"]}, "367": {"vr": "TM", "Value": ["153057.105000"]}, "368": {"vr": "TM", "Value": ["153057.105000"]}, "369": {"vr": "TM", "Value": ["153057.105000"]}, "370": {"vr": "TM", "Value": ["153057.105000"]}, "371": {"vr": "TM", "Value": ["153057.105000"]}, "372": {"vr": "TM", "Value": ["153057.105000"]}, "373": {"vr": "TM", "Value": ["153057.105000"]}, "374": {"vr": "TM", "Value": ["153057.105000"]}, "375": {"vr": "TM", "Value": ["153057.105000"]}, "376": {"vr": "TM", "Value": ["153057.105000"]}, "377": {"vr": "TM", "Value": ["153057.105000"]}, "378": {"vr": "TM", "Value": ["153057.105000"]}, "379": {"vr": "TM", "Value": ["153057.105000"]}, "380": {"vr": "TM", "Value": ["153057.105000"]}, "381": {"vr": "TM", "Value": ["153057.105000"]}, "382": {"vr": "TM", "Value": ["153057.105000"]}, "383": {"vr": "TM", "Value": ["153057.105000"]}, "384": {"vr": "TM", "Value": ["153057.105000"]}, "385": {"vr": "TM", "Value": ["153057.105000"]}, "386": {"vr": "TM", "Value": ["153057.105000"]}, "387": {"vr": "TM", "Value": ["153057.105000"]}, "388": {"vr": "TM", "Value": ["153057.105000"]}, "389": {"vr": "TM", "Value": ["153057.105000"]}, "390": {"vr": "TM", "Value": ["153057.105000"]}, "391": {"vr": "TM", "Value": ["153057.105000"]}, "392": {"vr": "TM", "Value": ["153057.105000"]}, "393": {"vr": "TM", "Value": ["153057.105000"]}, "394": {"vr": "TM", "Value": ["153057.105000"]}, "395": {"vr": "TM", "Value": ["153057.105000"]}, "396": {"vr": "TM", "Value": ["153057.105000"]}, "397": {"vr": "TM", "Value": ["153057.105000"]}, "398": {"vr": "TM", "Value": ["153057.105000"]}, "399": {"vr": "TM", "Value": ["153057.105000"]}, "400": {"vr": "TM", "Value": ["153057.258000"]}, "401": {"vr": "TM", "Value": ["153057.258000"]}, "402": {"vr": "TM", "Value": ["153057.258000"]}, "403": {"vr": "TM", "Value": ["153057.258000"]}, "404": {"vr": "TM", "Value": ["153057.258000"]}, "405": {"vr": "TM", "Value": ["153057.258000"]}, "406": {"vr": "TM", "Value": ["153057.258000"]}, "407": {"vr": "TM", "Value": ["153057.258000"]}, "408": {"vr": "TM", "Value": ["153057.258000"]}, "409": {"vr": "TM", "Value": ["153057.258000"]}, "410": {"vr": "TM", "Value": ["153057.258000"]}, "411": {"vr": "TM", "Value": ["153057.258000"]}, "412": {"vr": "TM", "Value": ["153057.258000"]}, "413": {"vr": "TM", "Value": ["153057.258000"]}, "414": {"vr": "TM", "Value": ["153057.258000"]}, "415": {"vr": "TM", "Value": ["153057.258000"]}, "416": {"vr": "TM", "Value": ["153057.258000"]}, "417": {"vr": "TM", "Value": ["153057.258000"]}, "418": {"vr": "TM", "Value": ["153057.258000"]}, "419": {"vr": "TM", "Value": ["153057.258000"]}, "420": {"vr": "TM", "Value": ["153057.258000"]}, "421": {"vr": "TM", "Value": ["153057.258000"]}, "422": {"vr": "TM", "Value": ["153057.258000"]}, "423": {"vr": "TM", "Value": ["153057.258000"]}, "424": {"vr": "TM", "Value": ["153057.258000"]}, "425": {"vr": "TM", "Value": ["153057.258000"]}, "426": {"vr": "TM", "Value": ["153057.258000"]}, "427": {"vr": "TM", "Value": ["153057.258000"]}, "428": {"vr": "TM", "Value": ["153057.258000"]}, "429": {"vr": "TM", "Value": ["153057.258000"]}, "430": {"vr": "TM", "Value": ["153057.258000"]}, "431": {"vr": "TM", "Value": ["153057.258000"]}, "432": {"vr": "TM", "Value": ["153057.258000"]}, "433": {"vr": "TM", "Value": ["153057.258000"]}, "434": {"vr": "TM", "Value": ["153057.258000"]}, "435": {"vr": "TM", "Value": ["153057.258000"]}, "436": {"vr": "TM", "Value": ["153057.261000"]}, "437": {"vr": "TM", "Value": ["153057.261000"]}, "438": {"vr": "TM", "Value": ["153057.261000"]}, "439": {"vr": "TM", "Value": ["153057.261000"]}, "440": {"vr": "TM", "Value": ["153057.261000"]}, "441": {"vr": "TM", "Value": ["153057.261000"]}, "442": {"vr": "TM", "Value": ["153057.261000"]}, "443": {"vr": "TM", "Value": ["153057.261000"]}, "444": {"vr": "TM", "Value": ["153057.261000"]}, "445": {"vr": "TM", "Value": ["153057.261000"]}, "446": {"vr": "TM", "Value": ["153057.261000"]}, "447": {"vr": "TM", "Value": ["153057.261000"]}, "448": {"vr": "TM", "Value": ["153057.261000"]}, "449": {"vr": "TM", "Value": ["153057.261000"]}, "450": {"vr": "TM", "Value": ["153057.390000"]}, "451": {"vr": "TM", "Value": ["153057.390000"]}, "452": {"vr": "TM", "Value": ["153057.390000"]}, "453": {"vr": "TM", "Value": ["153057.390000"]}, "454": {"vr": "TM", "Value": ["153057.390000"]}, "455": {"vr": "TM", "Value": ["153057.390000"]}, "456": {"vr": "TM", "Value": ["153057.390000"]}, "457": {"vr": "TM", "Value": ["153057.390000"]}, "458": {"vr": "TM", "Value": ["153057.390000"]}, "459": {"vr": "TM", "Value": ["153057.390000"]}, "460": {"vr": "TM", "Value": ["153057.390000"]}, "461": {"vr": "TM", "Value": ["153057.390000"]}, "462": {"vr": "TM", "Value": ["153057.390000"]}, "463": {"vr": "TM", "Value": ["153057.390000"]}, "464": {"vr": "TM", "Value": ["153057.390000"]}, "465": {"vr": "TM", "Value": ["153057.390000"]}, "466": {"vr": "TM", "Value": ["153057.390000"]}, "467": {"vr": "TM", "Value": ["153057.390000"]}, "468": {"vr": "TM", "Value": ["153057.390000"]}, "469": {"vr": "TM", "Value": ["153057.390000"]}, "470": {"vr": "TM", "Value": ["153057.390000"]}, "471": {"vr": "TM", "Value": ["153057.390000"]}, "472": {"vr": "TM", "Value": ["153057.390000"]}, "473": {"vr": "TM", "Value": ["153057.390000"]}, "474": {"vr": "TM", "Value": ["153057.390000"]}, "475": {"vr": "TM", "Value": ["153057.390000"]}, "476": {"vr": "TM", "Value": ["153057.390000"]}, "477": {"vr": "TM", "Value": ["153057.390000"]}, "478": {"vr": "TM", "Value": ["153057.390000"]}, "479": {"vr": "TM", "Value": ["153057.390000"]}, "480": {"vr": "TM", "Value": ["153057.390000"]}, "481": {"vr": "TM", "Value": ["153057.390000"]}, "482": {"vr": "TM", "Value": ["153057.390000"]}, "483": {"vr": "TM", "Value": ["153057.390000"]}, "484": {"vr": "TM", "Value": ["153057.390000"]}, "485": {"vr": "TM", "Value": ["153057.390000"]}, "486": {"vr": "TM", "Value": ["153057.390000"]}, "487": {"vr": "TM", "Value": ["153057.390000"]}, "488": {"vr": "TM", "Value": ["153057.390000"]}, "489": {"vr": "TM", "Value": ["153057.390000"]}, "490": {"vr": "TM", "Value": ["153057.390000"]}, "491": {"vr": "TM", "Value": ["153057.390000"]}, "492": {"vr": "TM", "Value": ["153057.390000"]}, "493": {"vr": "TM", "Value": ["153057.390000"]}, "494": {"vr": "TM", "Value": ["153057.390000"]}, "495": {"vr": "TM", "Value": ["153057.390000"]}, "496": {"vr": "TM", "Value": ["153057.390000"]}, "497": {"vr": "TM", "Value": ["153057.390000"]}, "498": {"vr": "TM", "Value": ["153057.390000"]}, "499": {"vr": "TM", "Value": ["153057.390000"]}, "500": {"vr": "TM", "Value": ["153057.500000"]}, "501": {"vr": "TM", "Value": ["153057.500000"]}, "502": {"vr": "TM", "Value": ["153057.500000"]}, "503": {"vr": "TM", "Value": ["153057.500000"]}, "504": {"vr": "TM", "Value": ["153057.500000"]}, "505": {"vr": "TM", "Value": ["153057.500000"]}, "506": {"vr": "TM", "Value": ["153057.500000"]}, "507": {"vr": "TM", "Value": ["153057.500000"]}, "508": {"vr": "TM", "Value": ["153057.500000"]}, "509": {"vr": "TM", "Value": ["153057.500000"]}, "510": {"vr": "TM", "Value": ["153057.500000"]}, "511": {"vr": "TM", "Value": ["153057.500000"]}, "512": {"vr": "TM", "Value": ["153057.500000"]}, "513": {"vr": "TM", "Value": ["153057.500000"]}, "514": {"vr": "TM", "Value": ["153057.500000"]}, "515": {"vr": "TM", "Value": ["153057.500000"]}, "516": {"vr": "TM", "Value": ["153057.500000"]}, "517": {"vr": "TM", "Value": ["153057.500000"]}, "518": {"vr": "TM", "Value": ["153057.500000"]}, "519": {"vr": "TM", "Value": ["153057.500000"]}, "520": {"vr": "TM", "Value": ["153057.500000"]}, "521": {"vr": "TM", "Value": ["153057.500000"]}, "522": {"vr": "TM", "Value": ["153057.500000"]}, "523": {"vr": "TM", "Value": ["153057.500000"]}, "524": {"vr": "TM", "Value": ["153057.500000"]}, "525": {"vr": "TM", "Value": ["153057.500000"]}, "526": {"vr": "TM", "Value": ["153057.500000"]}, "527": {"vr": "TM", "Value": ["153057.500000"]}, "528": {"vr": "TM", "Value": ["153057.500000"]}, "529": {"vr": "TM", "Value": ["153057.500000"]}, "530": {"vr": "TM", "Value": ["153057.500000"]}}, "00200013": {"0": {"vr": "IS", "Value": [1]}, "1": {"vr": "IS", "Value": [2]}, "2": {"vr": "IS", "Value": [3]}, "3": {"vr": "IS", "Value": [4]}, "4": {"vr": "IS", "Value": [5]}, "5": {"vr": "IS", "Value": [6]}, "6": {"vr": "IS", "Value": [7]}, "7": {"vr": "IS", "Value": [8]}, "8": {"vr": "IS", "Value": [9]}, "9": {"vr": "IS", "Value": [10]}, "10": {"vr": "IS", "Value": [11]}, "11": {"vr": "IS", "Value": [12]}, "12": {"vr": "IS", "Value": [13]}, "13": {"vr": "IS", "Value": [14]}, "14": {"vr": "IS", "Value": [15]}, "15": {"vr": "IS", "Value": [16]}, "16": {"vr": "IS", "Value": [17]}, "17": {"vr": "IS", "Value": [18]}, "18": {"vr": "IS", "Value": [19]}, "19": {"vr": "IS", "Value": [20]}, "20": {"vr": "IS", "Value": [21]}, "21": {"vr": "IS", "Value": [22]}, "22": {"vr": "IS", "Value": [23]}, "23": {"vr": "IS", "Value": [24]}, "24": {"vr": "IS", "Value": [25]}, "25": {"vr": "IS", "Value": [26]}, "26": {"vr": "IS", "Value": [27]}, "27": {"vr": "IS", "Value": [28]}, "28": {"vr": "IS", "Value": [29]}, "29": {"vr": "IS", "Value": [30]}, "30": {"vr": "IS", "Value": [31]}, "31": {"vr": "IS", "Value": [32]}, "32": {"vr": "IS", "Value": [33]}, "33": {"vr": "IS", "Value": [34]}, "34": {"vr": "IS", "Value": [35]}, "35": {"vr": "IS", "Value": [36]}, "36": {"vr": "IS", "Value": [37]}, "37": {"vr": "IS", "Value": [38]}, "38": {"vr": "IS", "Value": [39]}, "39": {"vr": "IS", "Value": [40]}, "40": {"vr": "IS", "Value": [41]}, "41": {"vr": "IS", "Value": [42]}, "42": {"vr": "IS", "Value": [43]}, "43": {"vr": "IS", "Value": [44]}, "44": {"vr": "IS", "Value": [45]}, "45": {"vr": "IS", "Value": [46]}, "46": {"vr": "IS", "Value": [47]}, "47": {"vr": "IS", "Value": [48]}, "48": {"vr": "IS", "Value": [49]}, "49": {"vr": "IS", "Value": [50]}, "50": {"vr": "IS", "Value": [51]}, "51": {"vr": "IS", "Value": [52]}, "52": {"vr": "IS", "Value": [53]}, "53": {"vr": "IS", "Value": [54]}, "54": {"vr": "IS", "Value": [55]}, "55": {"vr": "IS", "Value": [56]}, "56": {"vr": "IS", "Value": [57]}, "57": {"vr": "IS", "Value": [58]}, "58": {"vr": "IS", "Value": [59]}, "59": {"vr": "IS", "Value": [60]}, "60": {"vr": "IS", "Value": [61]}, "61": {"vr": "IS", "Value": [62]}, "62": {"vr": "IS", "Value": [63]}, "63": {"vr": "IS", "Value": [64]}, "64": {"vr": "IS", "Value": [65]}, "65": {"vr": "IS", "Value": [66]}, "66": {"vr": "IS", "Value": [67]}, "67": {"vr": "IS", "Value": [68]}, "68": {"vr": "IS", "Value": [69]}, "69": {"vr": "IS", "Value": [70]}, "70": {"vr": "IS", "Value": [71]}, "71": {"vr": "IS", "Value": [72]}, "72": {"vr": "IS", "Value": [73]}, "73": {"vr": "IS", "Value": [74]}, "74": {"vr": "IS", "Value": [75]}, "75": {"vr": "IS", "Value": [76]}, "76": {"vr": "IS", "Value": [77]}, "77": {"vr": "IS", "Value": [78]}, "78": {"vr": "IS", "Value": [79]}, "79": {"vr": "IS", "Value": [80]}, "80": {"vr": "IS", "Value": [81]}, "81": {"vr": "IS", "Value": [82]}, "82": {"vr": "IS", "Value": [83]}, "83": {"vr": "IS", "Value": [84]}, "84": {"vr": "IS", "Value": [85]}, "85": {"vr": "IS", "Value": [86]}, "86": {"vr": "IS", "Value": [87]}, "87": {"vr": "IS", "Value": [88]}, "88": {"vr": "IS", "Value": [89]}, "89": {"vr": "IS", "Value": [90]}, "90": {"vr": "IS", "Value": [91]}, "91": {"vr": "IS", "Value": [92]}, "92": {"vr": "IS", "Value": [93]}, "93": {"vr": "IS", "Value": [94]}, "94": {"vr": "IS", "Value": [95]}, "95": {"vr": "IS", "Value": [96]}, "96": {"vr": "IS", "Value": [97]}, "97": {"vr": "IS", "Value": [98]}, "98": {"vr": "IS", "Value": [99]}, "99": {"vr": "IS", "Value": [100]}, "100": {"vr": "IS", "Value": [101]}, "101": {"vr": "IS", "Value": [102]}, "102": {"vr": "IS", "Value": [103]}, "103": {"vr": "IS", "Value": [104]}, "104": {"vr": "IS", "Value": [105]}, "105": {"vr": "IS", "Value": [106]}, "106": {"vr": "IS", "Value": [107]}, "107": {"vr": "IS", "Value": [108]}, "108": {"vr": "IS", "Value": [109]}, "109": {"vr": "IS", "Value": [110]}, "110": {"vr": "IS", "Value": [111]}, "111": {"vr": "IS", "Value": [112]}, "112": {"vr": "IS", "Value": [113]}, "113": {"vr": "IS", "Value": [114]}, "114": {"vr": "IS", "Value": [115]}, "115": {"vr": "IS", "Value": [116]}, "116": {"vr": "IS", "Value": [117]}, "117": {"vr": "IS", "Value": [118]}, "118": {"vr": "IS", "Value": [119]}, "119": {"vr": "IS", "Value": [120]}, "120": {"vr": "IS", "Value": [121]}, "121": {"vr": "IS", "Value": [122]}, "122": {"vr": "IS", "Value": [123]}, "123": {"vr": "IS", "Value": [124]}, "124": {"vr": "IS", "Value": [125]}, "125": {"vr": "IS", "Value": [126]}, "126": {"vr": "IS", "Value": [127]}, "127": {"vr": "IS", "Value": [128]}, "128": {"vr": "IS", "Value": [129]}, "129": {"vr": "IS", "Value": [130]}, "130": {"vr": "IS", "Value": [131]}, "131": {"vr": "IS", "Value": [132]}, "132": {"vr": "IS", "Value": [133]}, "133": {"vr": "IS", "Value": [134]}, "134": {"vr": "IS", "Value": [135]}, "135": {"vr": "IS", "Value": [136]}, "136": {"vr": "IS", "Value": [137]}, "137": {"vr": "IS", "Value": [138]}, "138": {"vr": "IS", "Value": [139]}, "139": {"vr": "IS", "Value": [140]}, "140": {"vr": "IS", "Value": [141]}, "141": {"vr": "IS", "Value": [142]}, "142": {"vr": "IS", "Value": [143]}, "143": {"vr": "IS", "Value": [144]}, "144": {"vr": "IS", "Value": [145]}, "145": {"vr": "IS", "Value": [146]}, "146": {"vr": "IS", "Value": [147]}, "147": {"vr": "IS", "Value": [148]}, "148": {"vr": "IS", "Value": [149]}, "149": {"vr": "IS", "Value": [150]}, "150": {"vr": "IS", "Value": [151]}, "151": {"vr": "IS", "Value": [152]}, "152": {"vr": "IS", "Value": [153]}, "153": {"vr": "IS", "Value": [154]}, "154": {"vr": "IS", "Value": [155]}, "155": {"vr": "IS", "Value": [156]}, "156": {"vr": "IS", "Value": [157]}, "157": {"vr": "IS", "Value": [158]}, "158": {"vr": "IS", "Value": [159]}, "159": {"vr": "IS", "Value": [160]}, "160": {"vr": "IS", "Value": [161]}, "161": {"vr": "IS", "Value": [162]}, "162": {"vr": "IS", "Value": [163]}, "163": {"vr": "IS", "Value": [164]}, "164": {"vr": "IS", "Value": [165]}, "165": {"vr": "IS", "Value": [166]}, "166": {"vr": "IS", "Value": [167]}, "167": {"vr": "IS", "Value": [168]}, "168": {"vr": "IS", "Value": [169]}, "169": {"vr": "IS", "Value": [170]}, "170": {"vr": "IS", "Value": [171]}, "171": {"vr": "IS", "Value": [172]}, "172": {"vr": "IS", "Value": [173]}, "173": {"vr": "IS", "Value": [174]}, "174": {"vr": "IS", "Value": [175]}, "175": {"vr": "IS", "Value": [176]}, "176": {"vr": "IS", "Value": [177]}, "177": {"vr": "IS", "Value": [178]}, "178": {"vr": "IS", "Value": [179]}, "179": {"vr": "IS", "Value": [180]}, "180": {"vr": "IS", "Value": [181]}, "181": {"vr": "IS", "Value": [182]}, "182": {"vr": "IS", "Value": [183]}, "183": {"vr": "IS", "Value": [184]}, "184": {"vr": "IS", "Value": [185]}, "185": {"vr": "IS", "Value": [186]}, "186": {"vr": "IS", "Value": [187]}, "187": {"vr": "IS", "Value": [188]}, "188": {"vr": "IS", "Value": [189]}, "189": {"vr": "IS", "Value": [190]}, "190": {"vr": "IS", "Value": [191]}, "191": {"vr": "IS", "Value": [192]}, "192": {"vr": "IS", "Value": [193]}, "193": {"vr": "IS", "Value": [194]}, "194": {"vr": "IS", "Value": [195]}, "195": {"vr": "IS", "Value": [196]}, "196": {"vr": "IS", "Value": [197]}, "197": {"vr": "IS", "Value": [198]}, "198": {"vr": "IS", "Value": [199]}, "199": {"vr": "IS", "Value": [200]}, "200": {"vr": "IS", "Value": [201]}, "201": {"vr": "IS", "Value": [202]}, "202": {"vr": "IS", "Value": [203]}, "203": {"vr": "IS", "Value": [204]}, "204": {"vr": "IS", "Value": [205]}, "205": {"vr": "IS", "Value": [206]}, "206": {"vr": "IS", "Value": [207]}, "207": {"vr": "IS", "Value": [208]}, "208": {"vr": "IS", "Value": [209]}, "209": {"vr": "IS", "Value": [210]}, "210": {"vr": "IS", "Value": [211]}, "211": {"vr": "IS", "Value": [212]}, "212": {"vr": "IS", "Value": [213]}, "213": {"vr": "IS", "Value": [214]}, "214": {"vr": "IS", "Value": [215]}, "215": {"vr": "IS", "Value": [216]}, "216": {"vr": "IS", "Value": [217]}, "217": {"vr": "IS", "Value": [218]}, "218": {"vr": "IS", "Value": [219]}, "219": {"vr": "IS", "Value": [220]}, "220": {"vr": "IS", "Value": [221]}, "221": {"vr": "IS", "Value": [222]}, "222": {"vr": "IS", "Value": [223]}, "223": {"vr": "IS", "Value": [224]}, "224": {"vr": "IS", "Value": [225]}, "225": {"vr": "IS", "Value": [226]}, "226": {"vr": "IS", "Value": [227]}, "227": {"vr": "IS", "Value": [228]}, "228": {"vr": "IS", "Value": [229]}, "229": {"vr": "IS", "Value": [230]}, "230": {"vr": "IS", "Value": [231]}, "231": {"vr": "IS", "Value": [232]}, "232": {"vr": "IS", "Value": [233]}, "233": {"vr": "IS", "Value": [234]}, "234": {"vr": "IS", "Value": [235]}, "235": {"vr": "IS", "Value": [236]}, "236": {"vr": "IS", "Value": [237]}, "237": {"vr": "IS", "Value": [238]}, "238": {"vr": "IS", "Value": [239]}, "239": {"vr": "IS", "Value": [240]}, "240": {"vr": "IS", "Value": [241]}, "241": {"vr": "IS", "Value": [242]}, "242": {"vr": "IS", "Value": [243]}, "243": {"vr": "IS", "Value": [244]}, "244": {"vr": "IS", "Value": [245]}, "245": {"vr": "IS", "Value": [246]}, "246": {"vr": "IS", "Value": [247]}, "247": {"vr": "IS", "Value": [248]}, "248": {"vr": "IS", "Value": [249]}, "249": {"vr": "IS", "Value": [250]}, "250": {"vr": "IS", "Value": [251]}, "251": {"vr": "IS", "Value": [252]}, "252": {"vr": "IS", "Value": [253]}, "253": {"vr": "IS", "Value": [254]}, "254": {"vr": "IS", "Value": [255]}, "255": {"vr": "IS", "Value": [256]}, "256": {"vr": "IS", "Value": [257]}, "257": {"vr": "IS", "Value": [258]}, "258": {"vr": "IS", "Value": [259]}, "259": {"vr": "IS", "Value": [260]}, "260": {"vr": "IS", "Value": [261]}, "261": {"vr": "IS", "Value": [262]}, "262": {"vr": "IS", "Value": [263]}, "263": {"vr": "IS", "Value": [264]}, "264": {"vr": "IS", "Value": [265]}, "265": {"vr": "IS", "Value": [266]}, "266": {"vr": "IS", "Value": [267]}, "267": {"vr": "IS", "Value": [268]}, "268": {"vr": "IS", "Value": [269]}, "269": {"vr": "IS", "Value": [270]}, "270": {"vr": "IS", "Value": [271]}, "271": {"vr": "IS", "Value": [272]}, "272": {"vr": "IS", "Value": [273]}, "273": {"vr": "IS", "Value": [274]}, "274": {"vr": "IS", "Value": [275]}, "275": {"vr": "IS", "Value": [276]}, "276": {"vr": "IS", "Value": [277]}, "277": {"vr": "IS", "Value": [278]}, "278": {"vr": "IS", "Value": [279]}, "279": {"vr": "IS", "Value": [280]}, "280": {"vr": "IS", "Value": [281]}, "281": {"vr": "IS", "Value": [282]}, "282": {"vr": "IS", "Value": [283]}, "283": {"vr": "IS", "Value": [284]}, "284": {"vr": "IS", "Value": [285]}, "285": {"vr": "IS", "Value": [286]}, "286": {"vr": "IS", "Value": [287]}, "287": {"vr": "IS", "Value": [288]}, "288": {"vr": "IS", "Value": [289]}, "289": {"vr": "IS", "Value": [290]}, "290": {"vr": "IS", "Value": [291]}, "291": {"vr": "IS", "Value": [292]}, "292": {"vr": "IS", "Value": [293]}, "293": {"vr": "IS", "Value": [294]}, "294": {"vr": "IS", "Value": [295]}, "295": {"vr": "IS", "Value": [296]}, "296": {"vr": "IS", "Value": [297]}, "297": {"vr": "IS", "Value": [298]}, "298": {"vr": "IS", "Value": [299]}, "299": {"vr": "IS", "Value": [300]}, "300": {"vr": "IS", "Value": [301]}, "301": {"vr": "IS", "Value": [302]}, "302": {"vr": "IS", "Value": [303]}, "303": {"vr": "IS", "Value": [304]}, "304": {"vr": "IS", "Value": [305]}, "305": {"vr": "IS", "Value": [306]}, "306": {"vr": "IS", "Value": [307]}, "307": {"vr": "IS", "Value": [308]}, "308": {"vr": "IS", "Value": [309]}, "309": {"vr": "IS", "Value": [310]}, "310": {"vr": "IS", "Value": [311]}, "311": {"vr": "IS", "Value": [312]}, "312": {"vr": "IS", "Value": [313]}, "313": {"vr": "IS", "Value": [314]}, "314": {"vr": "IS", "Value": [315]}, "315": {"vr": "IS", "Value": [316]}, "316": {"vr": "IS", "Value": [317]}, "317": {"vr": "IS", "Value": [318]}, "318": {"vr": "IS", "Value": [319]}, "319": {"vr": "IS", "Value": [320]}, "320": {"vr": "IS", "Value": [321]}, "321": {"vr": "IS", "Value": [322]}, "322": {"vr": "IS", "Value": [323]}, "323": {"vr": "IS", "Value": [324]}, "324": {"vr": "IS", "Value": [325]}, "325": {"vr": "IS", "Value": [326]}, "326": {"vr": "IS", "Value": [327]}, "327": {"vr": "IS", "Value": [328]}, "328": {"vr": "IS", "Value": [329]}, "329": {"vr": "IS", "Value": [330]}, "330": {"vr": "IS", "Value": [331]}, "331": {"vr": "IS", "Value": [332]}, "332": {"vr": "IS", "Value": [333]}, "333": {"vr": "IS", "Value": [334]}, "334": {"vr": "IS", "Value": [335]}, "335": {"vr": "IS", "Value": [336]}, "336": {"vr": "IS", "Value": [337]}, "337": {"vr": "IS", "Value": [338]}, "338": {"vr": "IS", "Value": [339]}, "339": {"vr": "IS", "Value": [340]}, "340": {"vr": "IS", "Value": [341]}, "341": {"vr": "IS", "Value": [342]}, "342": {"vr": "IS", "Value": [343]}, "343": {"vr": "IS", "Value": [344]}, "344": {"vr": "IS", "Value": [345]}, "345": {"vr": "IS", "Value": [346]}, "346": {"vr": "IS", "Value": [347]}, "347": {"vr": "IS", "Value": [348]}, "348": {"vr": "IS", "Value": [349]}, "349": {"vr": "IS", "Value": [350]}, "350": {"vr": "IS", "Value": [351]}, "351": {"vr": "IS", "Value": [352]}, "352": {"vr": "IS", "Value": [353]}, "353": {"vr": "IS", "Value": [354]}, "354": {"vr": "IS", "Value": [355]}, "355": {"vr": "IS", "Value": [356]}, "356": {"vr": "IS", "Value": [357]}, "357": {"vr": "IS", "Value": [358]}, "358": {"vr": "IS", "Value": [359]}, "359": {"vr": "IS", "Value": [360]}, "360": {"vr": "IS", "Value": [361]}, "361": {"vr": "IS", "Value": [362]}, "362": {"vr": "IS", "Value": [363]}, "363": {"vr": "IS", "Value": [364]}, "364": {"vr": "IS", "Value": [365]}, "365": {"vr": "IS", "Value": [366]}, "366": {"vr": "IS", "Value": [367]}, "367": {"vr": "IS", "Value": [368]}, "368": {"vr": "IS", "Value": [369]}, "369": {"vr": "IS", "Value": [370]}, "370": {"vr": "IS", "Value": [371]}, "371": {"vr": "IS", "Value": [372]}, "372": {"vr": "IS", "Value": [373]}, "373": {"vr": "IS", "Value": [374]}, "374": {"vr": "IS", "Value": [375]}, "375": {"vr": "IS", "Value": [376]}, "376": {"vr": "IS", "Value": [377]}, "377": {"vr": "IS", "Value": [378]}, "378": {"vr": "IS", "Value": [379]}, "379": {"vr": "IS", "Value": [380]}, "380": {"vr": "IS", "Value": [381]}, "381": {"vr": "IS", "Value": [382]}, "382": {"vr": "IS", "Value": [383]}, "383": {"vr": "IS", "Value": [384]}, "384": {"vr": "IS", "Value": [385]}, "385": {"vr": "IS", "Value": [386]}, "386": {"vr": "IS", "Value": [387]}, "387": {"vr": "IS", "Value": [388]}, "388": {"vr": "IS", "Value": [389]}, "389": {"vr": "IS", "Value": [390]}, "390": {"vr": "IS", "Value": [391]}, "391": {"vr": "IS", "Value": [392]}, "392": {"vr": "IS", "Value": [393]}, "393": {"vr": "IS", "Value": [394]}, "394": {"vr": "IS", "Value": [395]}, "395": {"vr": "IS", "Value": [396]}, "396": {"vr": "IS", "Value": [397]}, "397": {"vr": "IS", "Value": [398]}, "398": {"vr": "IS", "Value": [399]}, "399": {"vr": "IS", "Value": [400]}, "400": {"vr": "IS", "Value": [401]}, "401": {"vr": "IS", "Value": [402]}, "402": {"vr": "IS", "Value": [403]}, "403": {"vr": "IS", "Value": [404]}, "404": {"vr": "IS", "Value": [405]}, "405": {"vr": "IS", "Value": [406]}, "406": {"vr": "IS", "Value": [407]}, "407": {"vr": "IS", "Value": [408]}, "408": {"vr": "IS", "Value": [409]}, "409": {"vr": "IS", "Value": [410]}, "410": {"vr": "IS", "Value": [411]}, "411": {"vr": "IS", "Value": [412]}, "412": {"vr": "IS", "Value": [413]}, "413": {"vr": "IS", "Value": [414]}, "414": {"vr": "IS", "Value": [415]}, "415": {"vr": "IS", "Value": [416]}, "416": {"vr": "IS", "Value": [417]}, "417": {"vr": "IS", "Value": [418]}, "418": {"vr": "IS", "Value": [419]}, "419": {"vr": "IS", "Value": [420]}, "420": {"vr": "IS", "Value": [421]}, "421": {"vr": "IS", "Value": [422]}, "422": {"vr": "IS", "Value": [423]}, "423": {"vr": "IS", "Value": [424]}, "424": {"vr": "IS", "Value": [425]}, "425": {"vr": "IS", "Value": [426]}, "426": {"vr": "IS", "Value": [427]}, "427": {"vr": "IS", "Value": [428]}, "428": {"vr": "IS", "Value": [429]}, "429": {"vr": "IS", "Value": [430]}, "430": {"vr": "IS", "Value": [431]}, "431": {"vr": "IS", "Value": [432]}, "432": {"vr": "IS", "Value": [433]}, "433": {"vr": "IS", "Value": [434]}, "434": {"vr": "IS", "Value": [435]}, "435": {"vr": "IS", "Value": [436]}, "436": {"vr": "IS", "Value": [437]}, "437": {"vr": "IS", "Value": [438]}, "438": {"vr": "IS", "Value": [439]}, "439": {"vr": "IS", "Value": [440]}, "440": {"vr": "IS", "Value": [441]}, "441": {"vr": "IS", "Value": [442]}, "442": {"vr": "IS", "Value": [443]}, "443": {"vr": "IS", "Value": [444]}, "444": {"vr": "IS", "Value": [445]}, "445": {"vr": "IS", "Value": [446]}, "446": {"vr": "IS", "Value": [447]}, "447": {"vr": "IS", "Value": [448]}, "448": {"vr": "IS", "Value": [449]}, "449": {"vr": "IS", "Value": [450]}, "450": {"vr": "IS", "Value": [451]}, "451": {"vr": "IS", "Value": [452]}, "452": {"vr": "IS", "Value": [453]}, "453": {"vr": "IS", "Value": [454]}, "454": {"vr": "IS", "Value": [455]}, "455": {"vr": "IS", "Value": [456]}, "456": {"vr": "IS", "Value": [457]}, "457": {"vr": "IS", "Value": [458]}, "458": {"vr": "IS", "Value": [459]}, "459": {"vr": "IS", "Value": [460]}, "460": {"vr": "IS", "Value": [461]}, "461": {"vr": "IS", "Value": [462]}, "462": {"vr": "IS", "Value": [463]}, "463": {"vr": "IS", "Value": [464]}, "464": {"vr": "IS", "Value": [465]}, "465": {"vr": "IS", "Value": [466]}, "466": {"vr": "IS", "Value": [467]}, "467": {"vr": "IS", "Value": [468]}, "468": {"vr": "IS", "Value": [469]}, "469": {"vr": "IS", "Value": [470]}, "470": {"vr": "IS", "Value": [471]}, "471": {"vr": "IS", "Value": [472]}, "472": {"vr": "IS", "Value": [473]}, "473": {"vr": "IS", "Value": [474]}, "474": {"vr": "IS", "Value": [475]}, "475": {"vr": "IS", "Value": [476]}, "476": {"vr": "IS", "Value": [477]}, "477": {"vr": "IS", "Value": [478]}, "478": {"vr": "IS", "Value": [479]}, "479": {"vr": "IS", "Value": [480]}, "480": {"vr": "IS", "Value": [481]}, "481": {"vr": "IS", "Value": [482]}, "482": {"vr": "IS", "Value": [483]}, "483": {"vr": "IS", "Value": [484]}, "484": {"vr": "IS", "Value": [485]}, "485": {"vr": "IS", "Value": [486]}, "486": {"vr": "IS", "Value": [487]}, "487": {"vr": "IS", "Value": [488]}, "488": {"vr": "IS", "Value": [489]}, "489": {"vr": "IS", "Value": [490]}, "490": {"vr": "IS", "Value": [491]}, "491": {"vr": "IS", "Value": [492]}, "492": {"vr": "IS", "Value": [493]}, "493": {"vr": "IS", "Value": [494]}, "494": {"vr": "IS", "Value": [495]}, "495": {"vr": "IS", "Value": [496]}, "496": {"vr": "IS", "Value": [497]}, "497": {"vr": "IS", "Value": [498]}, "498": {"vr": "IS", "Value": [499]}, "499": {"vr": "IS", "Value": [500]}, "500": {"vr": "IS", "Value": [501]}, "501": {"vr": "IS", "Value": [502]}, "502": {"vr": "IS", "Value": [503]}, "503": {"vr": "IS", "Value": [504]}, "504": {"vr": "IS", "Value": [505]}, "505": {"vr": "IS", "Value": [506]}, "506": {"vr": "IS", "Value": [507]}, "507": {"vr": "IS", "Value": [508]}, "508": {"vr": "IS", "Value": [509]}, "509": {"vr": "IS", "Value": [510]}, "510": {"vr": "IS", "Value": [511]}, "511": {"vr": "IS", "Value": [512]}, "512": {"vr": "IS", "Value": [513]}, "513": {"vr": "IS", "Value": [514]}, "514": {"vr": "IS", "Value": [515]}, "515": {"vr": "IS", "Value": [516]}, "516": {"vr": "IS", "Value": [517]}, "517": {"vr": "IS", "Value": [518]}, "518": {"vr": "IS", "Value": [519]}, "519": {"vr": "IS", "Value": [520]}, "520": {"vr": "IS", "Value": [521]}, "521": {"vr": "IS", "Value": [522]}, "522": {"vr": "IS", "Value": [523]}, "523": {"vr": "IS", "Value": [524]}, "524": {"vr": "IS", "Value": [525]}, "525": {"vr": "IS", "Value": [526]}, "526": {"vr": "IS", "Value": [527]}, "527": {"vr": "IS", "Value": [528]}, "528": {"vr": "IS", "Value": [529]}, "529": {"vr": "IS", "Value": [530]}, "530": {"vr": "IS", "Value": [531]}}, "00200032": {"0": {"vr": "DS", "Value": [-362.847, -503.29, -891.5]}, "1": {"vr": "DS", "Value": [-362.847, -503.29, -889.5]}, "2": {"vr": "DS", "Value": [-362.847, -503.29, -887.5]}, "3": {"vr": "DS", "Value": [-362.847, -503.29, -885.5]}, "4": {"vr": "DS", "Value": [-362.847, -503.29, -883.5]}, "5": {"vr": "DS", "Value": [-362.847, -503.29, -881.5]}, "6": {"vr": "DS", "Value": [-362.847, -503.29, -879.5]}, "7": {"vr": "DS", "Value": [-362.847, -503.29, -877.5]}, "8": {"vr": "DS", "Value": [-362.847, -503.29, -875.5]}, "9": {"vr": "DS", "Value": [-362.847, -503.29, -873.5]}, "10": {"vr": "DS", "Value": [-362.847, -503.29, -871.5]}, "11": {"vr": "DS", "Value": [-362.847, -503.29, -869.5]}, "12": {"vr": "DS", "Value": [-362.847, -503.29, -867.5]}, "13": {"vr": "DS", "Value": [-362.847, -503.29, -865.5]}, "14": {"vr": "DS", "Value": [-362.847, -503.29, -863.5]}, "15": {"vr": "DS", "Value": [-362.847, -503.29, -861.5]}, "16": {"vr": "DS", "Value": [-362.847, -503.29, -859.5]}, "17": {"vr": "DS", "Value": [-362.847, -503.29, -857.5]}, "18": {"vr": "DS", "Value": [-362.847, -503.29, -855.5]}, "19": {"vr": "DS", "Value": [-362.847, -503.29, -853.5]}, "20": {"vr": "DS", "Value": [-362.847, -503.29, -851.5]}, "21": {"vr": "DS", "Value": [-362.847, -503.29, -849.5]}, "22": {"vr": "DS", "Value": [-362.847, -503.29, -847.5]}, "23": {"vr": "DS", "Value": [-362.847, -503.29, -845.5]}, "24": {"vr": "DS", "Value": [-362.847, -503.29, -843.5]}, "25": {"vr": "DS", "Value": [-362.847, -503.29, -841.5]}, "26": {"vr": "DS", "Value": [-362.847, -503.29, -839.5]}, "27": {"vr": "DS", "Value": [-362.847, -503.29, -837.5]}, "28": {"vr": "DS", "Value": [-362.847, -503.29, -835.5]}, "29": {"vr": "DS", "Value": [-362.847, -503.29, -833.5]}, "30": {"vr": "DS", "Value": [-362.847, -503.29, -831.5]}, "31": {"vr": "DS", "Value": [-362.847, -503.29, -829.5]}, "32": {"vr": "DS", "Value": [-362.847, -503.29, -827.5]}, "33": {"vr": "DS", "Value": [-362.847, -503.29, -825.5]}, "34": {"vr": "DS", "Value": [-362.847, -503.29, -823.5]}, "35": {"vr": "DS", "Value": [-362.847, -503.29, -821.5]}, "36": {"vr": "DS", "Value": [-362.847, -503.29, -819.5]}, "37": {"vr": "DS", "Value": [-362.847, -503.29, -817.5]}, "38": {"vr": "DS", "Value": [-362.847, -503.29, -815.5]}, "39": {"vr": "DS", "Value": [-362.847, -503.29, -813.5]}, "40": {"vr": "DS", "Value": [-362.847, -503.29, -811.5]}, "41": {"vr": "DS", "Value": [-362.847, -503.29, -809.5]}, "42": {"vr": "DS", "Value": [-362.847, -503.29, -807.5]}, "43": {"vr": "DS", "Value": [-362.847, -503.29, -805.5]}, "44": {"vr": "DS", "Value": [-362.847, -503.29, -803.5]}, "45": {"vr": "DS", "Value": [-362.847, -503.29, -801.5]}, "46": {"vr": "DS", "Value": [-362.847, -503.29, -799.5]}, "47": {"vr": "DS", "Value": [-362.847, -503.29, -797.5]}, "48": {"vr": "DS", "Value": [-362.847, -503.29, -795.5]}, "49": {"vr": "DS", "Value": [-362.847, -503.29, -793.5]}, "50": {"vr": "DS", "Value": [-362.847, -503.29, -791.5]}, "51": {"vr": "DS", "Value": [-362.847, -503.29, -789.5]}, "52": {"vr": "DS", "Value": [-362.847, -503.29, -787.5]}, "53": {"vr": "DS", "Value": [-362.847, -503.29, -785.5]}, "54": {"vr": "DS", "Value": [-362.847, -503.29, -783.5]}, "55": {"vr": "DS", "Value": [-362.847, -503.29, -781.5]}, "56": {"vr": "DS", "Value": [-362.847, -503.29, -779.5]}, "57": {"vr": "DS", "Value": [-362.847, -503.29, -777.5]}, "58": {"vr": "DS", "Value": [-362.847, -503.29, -775.5]}, "59": {"vr": "DS", "Value": [-362.847, -503.29, -773.5]}, "60": {"vr": "DS", "Value": [-362.847, -503.29, -771.5]}, "61": {"vr": "DS", "Value": [-362.847, -503.29, -769.5]}, "62": {"vr": "DS", "Value": [-362.847, -503.29, -767.5]}, "63": {"vr": "DS", "Value": [-362.847, -503.29, -765.5]}, "64": {"vr": "DS", "Value": [-362.847, -503.29, -763.5]}, "65": {"vr": "DS", "Value": [-362.847, -503.29, -761.5]}, "66": {"vr": "DS", "Value": [-362.847, -503.29, -759.5]}, "67": {"vr": "DS", "Value": [-362.847, -503.29, -757.5]}, "68": {"vr": "DS", "Value": [-362.847, -503.29, -755.5]}, "69": {"vr": "DS", "Value": [-362.847, -503.29, -753.5]}, "70": {"vr": "DS", "Value": [-362.847, -503.29, -751.5]}, "71": {"vr": "DS", "Value": [-362.847, -503.29, -749.5]}, "72": {"vr": "DS", "Value": [-362.847, -503.29, -747.5]}, "73": {"vr": "DS", "Value": [-362.847, -503.29, -745.5]}, "74": {"vr": "DS", "Value": [-362.847, -503.29, -743.5]}, "75": {"vr": "DS", "Value": [-362.847, -503.29, -741.5]}, "76": {"vr": "DS", "Value": [-362.847, -503.29, -739.5]}, "77": {"vr": "DS", "Value": [-362.847, -503.29, -737.5]}, "78": {"vr": "DS", "Value": [-362.847, -503.29, -735.5]}, "79": {"vr": "DS", "Value": [-362.847, -503.29, -733.5]}, "80": {"vr": "DS", "Value": [-362.847, -503.29, -731.5]}, "81": {"vr": "DS", "Value": [-362.847, -503.29, -729.5]}, "82": {"vr": "DS", "Value": [-362.847, -503.29, -727.5]}, "83": {"vr": "DS", "Value": [-362.847, -503.29, -725.5]}, "84": {"vr": "DS", "Value": [-362.847, -503.29, -723.5]}, "85": {"vr": "DS", "Value": [-362.847, -503.29, -721.5]}, "86": {"vr": "DS", "Value": [-362.847, -503.29, -719.5]}, "87": {"vr": "DS", "Value": [-362.847, -503.29, -717.5]}, "88": {"vr": "DS", "Value": [-362.847, -503.29, -715.5]}, "89": {"vr": "DS", "Value": [-362.847, -503.29, -713.5]}, "90": {"vr": "DS", "Value": [-362.847, -503.29, -711.5]}, "91": {"vr": "DS", "Value": [-362.847, -503.29, -709.5]}, "92": {"vr": "DS", "Value": [-362.847, -503.29, -707.5]}, "93": {"vr": "DS", "Value": [-362.847, -503.29, -705.5]}, "94": {"vr": "DS", "Value": [-362.847, -503.29, -703.5]}, "95": {"vr": "DS", "Value": [-362.847, -503.29, -701.5]}, "96": {"vr": "DS", "Value": [-362.847, -503.29, -699.5]}, "97": {"vr": "DS", "Value": [-362.847, -503.29, -697.5]}, "98": {"vr": "DS", "Value": [-362.847, -503.29, -695.5]}, "99": {"vr": "DS", "Value": [-362.847, -503.29, -693.5]}, "100": {"vr": "DS", "Value": [-362.847, -503.29, -691.5]}, "101": {"vr": "DS", "Value": [-362.847, -503.29, -689.5]}, "102": {"vr": "DS", "Value": [-362.847, -503.29, -687.5]}, "103": {"vr": "DS", "Value": [-362.847, -503.29, -685.5]}, "104": {"vr": "DS", "Value": [-362.847, -503.29, -683.5]}, "105": {"vr": "DS", "Value": [-362.847, -503.29, -681.5]}, "106": {"vr": "DS", "Value": [-362.847, -503.29, -679.5]}, "107": {"vr": "DS", "Value": [-362.847, -503.29, -677.5]}, "108": {"vr": "DS", "Value": [-362.847, -503.29, -675.5]}, "109": {"vr": "DS", "Value": [-362.847, -503.29, -673.5]}, "110": {"vr": "DS", "Value": [-362.847, -503.29, -671.5]}, "111": {"vr": "DS", "Value": [-362.847, -503.29, -669.5]}, "112": {"vr": "DS", "Value": [-362.847, -503.29, -667.5]}, "113": {"vr": "DS", "Value": [-362.847, -503.29, -665.5]}, "114": {"vr": "DS", "Value": [-362.847, -503.29, -663.5]}, "115": {"vr": "DS", "Value": [-362.847, -503.29, -661.5]}, "116": {"vr": "DS", "Value": [-362.847, -503.29, -659.5]}, "117": {"vr": "DS", "Value": [-362.847, -503.29, -657.5]}, "118": {"vr": "DS", "Value": [-362.847, -503.29, -655.5]}, "119": {"vr": "DS", "Value": [-362.847, -503.29, -653.5]}, "120": {"vr": "DS", "Value": [-362.847, -503.29, -651.5]}, "121": {"vr": "DS", "Value": [-362.847, -503.29, -649.5]}, "122": {"vr": "DS", "Value": [-362.847, -503.29, -647.5]}, "123": {"vr": "DS", "Value": [-362.847, -503.29, -645.5]}, "124": {"vr": "DS", "Value": [-362.847, -503.29, -643.5]}, "125": {"vr": "DS", "Value": [-362.847, -503.29, -641.5]}, "126": {"vr": "DS", "Value": [-362.847, -503.29, -639.5]}, "127": {"vr": "DS", "Value": [-362.847, -503.29, -637.5]}, "128": {"vr": "DS", "Value": [-362.847, -503.29, -635.5]}, "129": {"vr": "DS", "Value": [-362.847, -503.29, -633.5]}, "130": {"vr": "DS", "Value": [-362.847, -503.29, -631.5]}, "131": {"vr": "DS", "Value": [-362.847, -503.29, -629.5]}, "132": {"vr": "DS", "Value": [-362.847, -503.29, -627.5]}, "133": {"vr": "DS", "Value": [-362.847, -503.29, -625.5]}, "134": {"vr": "DS", "Value": [-362.847, -503.29, -623.5]}, "135": {"vr": "DS", "Value": [-362.847, -503.29, -621.5]}, "136": {"vr": "DS", "Value": [-362.847, -503.29, -619.5]}, "137": {"vr": "DS", "Value": [-362.847, -503.29, -617.5]}, "138": {"vr": "DS", "Value": [-362.847, -503.29, -615.5]}, "139": {"vr": "DS", "Value": [-362.847, -503.29, -613.5]}, "140": {"vr": "DS", "Value": [-362.847, -503.29, -611.5]}, "141": {"vr": "DS", "Value": [-362.847, -503.29, -609.5]}, "142": {"vr": "DS", "Value": [-362.847, -503.29, -607.5]}, "143": {"vr": "DS", "Value": [-362.847, -503.29, -605.5]}, "144": {"vr": "DS", "Value": [-362.847, -503.29, -603.5]}, "145": {"vr": "DS", "Value": [-362.847, -503.29, -601.5]}, "146": {"vr": "DS", "Value": [-362.847, -503.29, -599.5]}, "147": {"vr": "DS", "Value": [-362.847, -503.29, -597.5]}, "148": {"vr": "DS", "Value": [-362.847, -503.29, -595.5]}, "149": {"vr": "DS", "Value": [-362.847, -503.29, -593.5]}, "150": {"vr": "DS", "Value": [-362.847, -503.29, -591.5]}, "151": {"vr": "DS", "Value": [-362.847, -503.29, -589.5]}, "152": {"vr": "DS", "Value": [-362.847, -503.29, -587.5]}, "153": {"vr": "DS", "Value": [-362.847, -503.29, -585.5]}, "154": {"vr": "DS", "Value": [-362.847, -503.29, -583.5]}, "155": {"vr": "DS", "Value": [-362.847, -503.29, -581.5]}, "156": {"vr": "DS", "Value": [-362.847, -503.29, -579.5]}, "157": {"vr": "DS", "Value": [-362.847, -503.29, -577.5]}, "158": {"vr": "DS", "Value": [-362.847, -503.29, -575.5]}, "159": {"vr": "DS", "Value": [-362.847, -503.29, -573.5]}, "160": {"vr": "DS", "Value": [-362.847, -503.29, -571.5]}, "161": {"vr": "DS", "Value": [-362.847, -503.29, -569.5]}, "162": {"vr": "DS", "Value": [-362.847, -503.29, -567.5]}, "163": {"vr": "DS", "Value": [-362.847, -503.29, -565.5]}, "164": {"vr": "DS", "Value": [-362.847, -503.29, -563.5]}, "165": {"vr": "DS", "Value": [-362.847, -503.29, -561.5]}, "166": {"vr": "DS", "Value": [-362.847, -503.29, -559.5]}, "167": {"vr": "DS", "Value": [-362.847, -503.29, -557.5]}, "168": {"vr": "DS", "Value": [-362.847, -503.29, -555.5]}, "169": {"vr": "DS", "Value": [-362.847, -503.29, -553.5]}, "170": {"vr": "DS", "Value": [-362.847, -503.29, -551.5]}, "171": {"vr": "DS", "Value": [-362.847, -503.29, -549.5]}, "172": {"vr": "DS", "Value": [-362.847, -503.29, -547.5]}, "173": {"vr": "DS", "Value": [-362.847, -503.29, -545.5]}, "174": {"vr": "DS", "Value": [-362.847, -503.29, -543.5]}, "175": {"vr": "DS", "Value": [-362.847, -503.29, -541.5]}, "176": {"vr": "DS", "Value": [-362.847, -503.29, -539.5]}, "177": {"vr": "DS", "Value": [-362.847, -503.29, -537.5]}, "178": {"vr": "DS", "Value": [-362.847, -503.29, -535.5]}, "179": {"vr": "DS", "Value": [-362.847, -503.29, -533.5]}, "180": {"vr": "DS", "Value": [-362.847, -503.29, -531.5]}, "181": {"vr": "DS", "Value": [-362.847, -503.29, -529.5]}, "182": {"vr": "DS", "Value": [-362.847, -503.29, -527.5]}, "183": {"vr": "DS", "Value": [-362.847, -503.29, -525.5]}, "184": {"vr": "DS", "Value": [-362.847, -503.29, -523.5]}, "185": {"vr": "DS", "Value": [-362.847, -503.29, -521.5]}, "186": {"vr": "DS", "Value": [-362.847, -503.29, -519.5]}, "187": {"vr": "DS", "Value": [-362.847, -503.29, -517.5]}, "188": {"vr": "DS", "Value": [-362.847, -503.29, -515.5]}, "189": {"vr": "DS", "Value": [-362.847, -503.29, -513.5]}, "190": {"vr": "DS", "Value": [-362.847, -503.29, -511.5]}, "191": {"vr": "DS", "Value": [-362.847, -503.29, -509.5]}, "192": {"vr": "DS", "Value": [-362.847, -503.29, -507.5]}, "193": {"vr": "DS", "Value": [-362.847, -503.29, -505.5]}, "194": {"vr": "DS", "Value": [-362.847, -503.29, -503.5]}, "195": {"vr": "DS", "Value": [-362.847, -503.29, -501.5]}, "196": {"vr": "DS", "Value": [-362.847, -503.29, -499.5]}, "197": {"vr": "DS", "Value": [-362.847, -503.29, -497.5]}, "198": {"vr": "DS", "Value": [-362.847, -503.29, -495.5]}, "199": {"vr": "DS", "Value": [-362.847, -503.29, -493.5]}, "200": {"vr": "DS", "Value": [-362.847, -503.29, -491.5]}, "201": {"vr": "DS", "Value": [-362.847, -503.29, -489.5]}, "202": {"vr": "DS", "Value": [-362.847, -503.29, -487.5]}, "203": {"vr": "DS", "Value": [-362.847, -503.29, -485.5]}, "204": {"vr": "DS", "Value": [-362.847, -503.29, -483.5]}, "205": {"vr": "DS", "Value": [-362.847, -503.29, -481.5]}, "206": {"vr": "DS", "Value": [-362.847, -503.29, -479.5]}, "207": {"vr": "DS", "Value": [-362.847, -503.29, -477.5]}, "208": {"vr": "DS", "Value": [-362.847, -503.29, -475.5]}, "209": {"vr": "DS", "Value": [-362.847, -503.29, -473.5]}, "210": {"vr": "DS", "Value": [-362.847, -503.29, -471.5]}, "211": {"vr": "DS", "Value": [-362.847, -503.29, -469.5]}, "212": {"vr": "DS", "Value": [-362.847, -503.29, -467.5]}, "213": {"vr": "DS", "Value": [-362.847, -503.29, -465.5]}, "214": {"vr": "DS", "Value": [-362.847, -503.29, -463.5]}, "215": {"vr": "DS", "Value": [-362.847, -503.29, -461.5]}, "216": {"vr": "DS", "Value": [-362.847, -503.29, -459.5]}, "217": {"vr": "DS", "Value": [-362.847, -503.29, -457.5]}, "218": {"vr": "DS", "Value": [-362.847, -503.29, -455.5]}, "219": {"vr": "DS", "Value": [-362.847, -503.29, -453.5]}, "220": {"vr": "DS", "Value": [-362.847, -503.29, -451.5]}, "221": {"vr": "DS", "Value": [-362.847, -503.29, -449.5]}, "222": {"vr": "DS", "Value": [-362.847, -503.29, -447.5]}, "223": {"vr": "DS", "Value": [-362.847, -503.29, -445.5]}, "224": {"vr": "DS", "Value": [-362.847, -503.29, -443.5]}, "225": {"vr": "DS", "Value": [-362.847, -503.29, -441.5]}, "226": {"vr": "DS", "Value": [-362.847, -503.29, -439.5]}, "227": {"vr": "DS", "Value": [-362.847, -503.29, -437.5]}, "228": {"vr": "DS", "Value": [-362.847, -503.29, -435.5]}, "229": {"vr": "DS", "Value": [-362.847, -503.29, -433.5]}, "230": {"vr": "DS", "Value": [-362.847, -503.29, -431.5]}, "231": {"vr": "DS", "Value": [-362.847, -503.29, -429.5]}, "232": {"vr": "DS", "Value": [-362.847, -503.29, -427.5]}, "233": {"vr": "DS", "Value": [-362.847, -503.29, -425.5]}, "234": {"vr": "DS", "Value": [-362.847, -503.29, -423.5]}, "235": {"vr": "DS", "Value": [-362.847, -503.29, -421.5]}, "236": {"vr": "DS", "Value": [-362.847, -503.29, -419.5]}, "237": {"vr": "DS", "Value": [-362.847, -503.29, -417.5]}, "238": {"vr": "DS", "Value": [-362.847, -503.29, -415.5]}, "239": {"vr": "DS", "Value": [-362.847, -503.29, -413.5]}, "240": {"vr": "DS", "Value": [-362.847, -503.29, -411.5]}, "241": {"vr": "DS", "Value": [-362.847, -503.29, -409.5]}, "242": {"vr": "DS", "Value": [-362.847, -503.29, -407.5]}, "243": {"vr": "DS", "Value": [-362.847, -503.29, -405.5]}, "244": {"vr": "DS", "Value": [-362.847, -503.29, -403.5]}, "245": {"vr": "DS", "Value": [-362.847, -503.29, -401.5]}, "246": {"vr": "DS", "Value": [-362.847, -503.29, -399.5]}, "247": {"vr": "DS", "Value": [-362.847, -503.29, -397.5]}, "248": {"vr": "DS", "Value": [-362.847, -503.29, -395.5]}, "249": {"vr": "DS", "Value": [-362.847, -503.29, -393.5]}, "250": {"vr": "DS", "Value": [-362.847, -503.29, -391.5]}, "251": {"vr": "DS", "Value": [-362.847, -503.29, -389.5]}, "252": {"vr": "DS", "Value": [-362.847, -503.29, -387.5]}, "253": {"vr": "DS", "Value": [-362.847, -503.29, -385.5]}, "254": {"vr": "DS", "Value": [-362.847, -503.29, -383.5]}, "255": {"vr": "DS", "Value": [-362.847, -503.29, -381.5]}, "256": {"vr": "DS", "Value": [-362.847, -503.29, -379.5]}, "257": {"vr": "DS", "Value": [-362.847, -503.29, -377.5]}, "258": {"vr": "DS", "Value": [-362.847, -503.29, -375.5]}, "259": {"vr": "DS", "Value": [-362.847, -503.29, -373.5]}, "260": {"vr": "DS", "Value": [-362.847, -503.29, -371.5]}, "261": {"vr": "DS", "Value": [-362.847, -503.29, -369.5]}, "262": {"vr": "DS", "Value": [-362.847, -503.29, -367.5]}, "263": {"vr": "DS", "Value": [-362.847, -503.29, -365.5]}, "264": {"vr": "DS", "Value": [-362.847, -503.29, -363.5]}, "265": {"vr": "DS", "Value": [-362.847, -503.29, -361.5]}, "266": {"vr": "DS", "Value": [-362.847, -503.29, -359.5]}, "267": {"vr": "DS", "Value": [-362.847, -503.29, -357.5]}, "268": {"vr": "DS", "Value": [-362.847, -503.29, -355.5]}, "269": {"vr": "DS", "Value": [-362.847, -503.29, -353.5]}, "270": {"vr": "DS", "Value": [-362.847, -503.29, -351.5]}, "271": {"vr": "DS", "Value": [-362.847, -503.29, -349.5]}, "272": {"vr": "DS", "Value": [-362.847, -503.29, -347.5]}, "273": {"vr": "DS", "Value": [-362.847, -503.29, -345.5]}, "274": {"vr": "DS", "Value": [-362.847, -503.29, -343.5]}, "275": {"vr": "DS", "Value": [-362.847, -503.29, -341.5]}, "276": {"vr": "DS", "Value": [-362.847, -503.29, -339.5]}, "277": {"vr": "DS", "Value": [-362.847, -503.29, -337.5]}, "278": {"vr": "DS", "Value": [-362.847, -503.29, -335.5]}, "279": {"vr": "DS", "Value": [-362.847, -503.29, -333.5]}, "280": {"vr": "DS", "Value": [-362.847, -503.29, -331.5]}, "281": {"vr": "DS", "Value": [-362.847, -503.29, -329.5]}, "282": {"vr": "DS", "Value": [-362.847, -503.29, -327.5]}, "283": {"vr": "DS", "Value": [-362.847, -503.29, -325.5]}, "284": {"vr": "DS", "Value": [-362.847, -503.29, -323.5]}, "285": {"vr": "DS", "Value": [-362.847, -503.29, -321.5]}, "286": {"vr": "DS", "Value": [-362.847, -503.29, -319.5]}, "287": {"vr": "DS", "Value": [-362.847, -503.29, -317.5]}, "288": {"vr": "DS", "Value": [-362.847, -503.29, -315.5]}, "289": {"vr": "DS", "Value": [-362.847, -503.29, -313.5]}, "290": {"vr": "DS", "Value": [-362.847, -503.29, -311.5]}, "291": {"vr": "DS", "Value": [-362.847, -503.29, -309.5]}, "292": {"vr": "DS", "Value": [-362.847, -503.29, -307.5]}, "293": {"vr": "DS", "Value": [-362.847, -503.29, -305.5]}, "294": {"vr": "DS", "Value": [-362.847, -503.29, -303.5]}, "295": {"vr": "DS", "Value": [-362.847, -503.29, -301.5]}, "296": {"vr": "DS", "Value": [-362.847, -503.29, -299.5]}, "297": {"vr": "DS", "Value": [-362.847, -503.29, -297.5]}, "298": {"vr": "DS", "Value": [-362.847, -503.29, -295.5]}, "299": {"vr": "DS", "Value": [-362.847, -503.29, -293.5]}, "300": {"vr": "DS", "Value": [-362.847, -503.29, -291.5]}, "301": {"vr": "DS", "Value": [-362.847, -503.29, -289.5]}, "302": {"vr": "DS", "Value": [-362.847, -503.29, -287.5]}, "303": {"vr": "DS", "Value": [-362.847, -503.29, -285.5]}, "304": {"vr": "DS", "Value": [-362.847, -503.29, -283.5]}, "305": {"vr": "DS", "Value": [-362.847, -503.29, -281.5]}, "306": {"vr": "DS", "Value": [-362.847, -503.29, -279.5]}, "307": {"vr": "DS", "Value": [-362.847, -503.29, -277.5]}, "308": {"vr": "DS", "Value": [-362.847, -503.29, -275.5]}, "309": {"vr": "DS", "Value": [-362.847, -503.29, -273.5]}, "310": {"vr": "DS", "Value": [-362.847, -503.29, -271.5]}, "311": {"vr": "DS", "Value": [-362.847, -503.29, -269.5]}, "312": {"vr": "DS", "Value": [-362.847, -503.29, -267.5]}, "313": {"vr": "DS", "Value": [-362.847, -503.29, -265.5]}, "314": {"vr": "DS", "Value": [-362.847, -503.29, -263.5]}, "315": {"vr": "DS", "Value": [-362.847, -503.29, -261.5]}, "316": {"vr": "DS", "Value": [-362.847, -503.29, -259.5]}, "317": {"vr": "DS", "Value": [-362.847, -503.29, -257.5]}, "318": {"vr": "DS", "Value": [-362.847, -503.29, -255.5]}, "319": {"vr": "DS", "Value": [-362.847, -503.29, -253.5]}, "320": {"vr": "DS", "Value": [-362.847, -503.29, -251.5]}, "321": {"vr": "DS", "Value": [-362.847, -503.29, -249.5]}, "322": {"vr": "DS", "Value": [-362.847, -503.29, -247.5]}, "323": {"vr": "DS", "Value": [-362.847, -503.29, -245.5]}, "324": {"vr": "DS", "Value": [-362.847, -503.29, -243.5]}, "325": {"vr": "DS", "Value": [-362.847, -503.29, -241.5]}, "326": {"vr": "DS", "Value": [-362.847, -503.29, -239.5]}, "327": {"vr": "DS", "Value": [-362.847, -503.29, -237.5]}, "328": {"vr": "DS", "Value": [-362.847, -503.29, -235.5]}, "329": {"vr": "DS", "Value": [-362.847, -503.29, -233.5]}, "330": {"vr": "DS", "Value": [-362.847, -503.29, -231.5]}, "331": {"vr": "DS", "Value": [-362.847, -503.29, -229.5]}, "332": {"vr": "DS", "Value": [-362.847, -503.29, -227.5]}, "333": {"vr": "DS", "Value": [-362.847, -503.29, -225.5]}, "334": {"vr": "DS", "Value": [-362.847, -503.29, -223.5]}, "335": {"vr": "DS", "Value": [-362.847, -503.29, -221.5]}, "336": {"vr": "DS", "Value": [-362.847, -503.29, -219.5]}, "337": {"vr": "DS", "Value": [-362.847, -503.29, -217.5]}, "338": {"vr": "DS", "Value": [-362.847, -503.29, -215.5]}, "339": {"vr": "DS", "Value": [-362.847, -503.29, -213.5]}, "340": {"vr": "DS", "Value": [-362.847, -503.29, -211.5]}, "341": {"vr": "DS", "Value": [-362.847, -503.29, -209.5]}, "342": {"vr": "DS", "Value": [-362.847, -503.29, -207.5]}, "343": {"vr": "DS", "Value": [-362.847, -503.29, -205.5]}, "344": {"vr": "DS", "Value": [-362.847, -503.29, -203.5]}, "345": {"vr": "DS", "Value": [-362.847, -503.29, -201.5]}, "346": {"vr": "DS", "Value": [-362.847, -503.29, -199.5]}, "347": {"vr": "DS", "Value": [-362.847, -503.29, -197.5]}, "348": {"vr": "DS", "Value": [-362.847, -503.29, -195.5]}, "349": {"vr": "DS", "Value": [-362.847, -503.29, -193.5]}, "350": {"vr": "DS", "Value": [-362.847, -503.29, -191.5]}, "351": {"vr": "DS", "Value": [-362.847, -503.29, -189.5]}, "352": {"vr": "DS", "Value": [-362.847, -503.29, -187.5]}, "353": {"vr": "DS", "Value": [-362.847, -503.29, -185.5]}, "354": {"vr": "DS", "Value": [-362.847, -503.29, -183.5]}, "355": {"vr": "DS", "Value": [-362.847, -503.29, -181.5]}, "356": {"vr": "DS", "Value": [-362.847, -503.29, -179.5]}, "357": {"vr": "DS", "Value": [-362.847, -503.29, -177.5]}, "358": {"vr": "DS", "Value": [-362.847, -503.29, -175.5]}, "359": {"vr": "DS", "Value": [-362.847, -503.29, -173.5]}, "360": {"vr": "DS", "Value": [-362.847, -503.29, -171.5]}, "361": {"vr": "DS", "Value": [-362.847, -503.29, -169.5]}, "362": {"vr": "DS", "Value": [-362.847, -503.29, -167.5]}, "363": {"vr": "DS", "Value": [-362.847, -503.29, -165.5]}, "364": {"vr": "DS", "Value": [-362.847, -503.29, -163.5]}, "365": {"vr": "DS", "Value": [-362.847, -503.29, -161.5]}, "366": {"vr": "DS", "Value": [-362.847, -503.29, -159.5]}, "367": {"vr": "DS", "Value": [-362.847, -503.29, -157.5]}, "368": {"vr": "DS", "Value": [-362.847, -503.29, -155.5]}, "369": {"vr": "DS", "Value": [-362.847, -503.29, -153.5]}, "370": {"vr": "DS", "Value": [-362.847, -503.29, -151.5]}, "371": {"vr": "DS", "Value": [-362.847, -503.29, -149.5]}, "372": {"vr": "DS", "Value": [-362.847, -503.29, -147.5]}, "373": {"vr": "DS", "Value": [-362.847, -503.29, -145.5]}, "374": {"vr": "DS", "Value": [-362.847, -503.29, -143.5]}, "375": {"vr": "DS", "Value": [-362.847, -503.29, -141.5]}, "376": {"vr": "DS", "Value": [-362.847, -503.29, -139.5]}, "377": {"vr": "DS", "Value": [-362.847, -503.29, -137.5]}, "378": {"vr": "DS", "Value": [-362.847, -503.29, -135.5]}, "379": {"vr": "DS", "Value": [-362.847, -503.29, -133.5]}, "380": {"vr": "DS", "Value": [-362.847, -503.29, -131.5]}, "381": {"vr": "DS", "Value": [-362.847, -503.29, -129.5]}, "382": {"vr": "DS", "Value": [-362.847, -503.29, -127.5]}, "383": {"vr": "DS", "Value": [-362.847, -503.29, -125.5]}, "384": {"vr": "DS", "Value": [-362.847, -503.29, -123.5]}, "385": {"vr": "DS", "Value": [-362.847, -503.29, -121.5]}, "386": {"vr": "DS", "Value": [-362.847, -503.29, -119.5]}, "387": {"vr": "DS", "Value": [-362.847, -503.29, -117.5]}, "388": {"vr": "DS", "Value": [-362.847, -503.29, -115.5]}, "389": {"vr": "DS", "Value": [-362.847, -503.29, -113.5]}, "390": {"vr": "DS", "Value": [-362.847, -503.29, -111.5]}, "391": {"vr": "DS", "Value": [-362.847, -503.29, -109.5]}, "392": {"vr": "DS", "Value": [-362.847, -503.29, -107.5]}, "393": {"vr": "DS", "Value": [-362.847, -503.29, -105.5]}, "394": {"vr": "DS", "Value": [-362.847, -503.29, -103.5]}, "395": {"vr": "DS", "Value": [-362.847, -503.29, -101.5]}, "396": {"vr": "DS", "Value": [-362.847, -503.29, -99.5]}, "397": {"vr": "DS", "Value": [-362.847, -503.29, -97.5]}, "398": {"vr": "DS", "Value": [-362.847, -503.29, -95.5]}, "399": {"vr": "DS", "Value": [-362.847, -503.29, -93.5]}, "400": {"vr": "DS", "Value": [-362.847, -503.29, -91.5]}, "401": {"vr": "DS", "Value": [-362.847, -503.29, -89.5]}, "402": {"vr": "DS", "Value": [-362.847, -503.29, -87.5]}, "403": {"vr": "DS", "Value": [-362.847, -503.29, -85.5]}, "404": {"vr": "DS", "Value": [-362.847, -503.29, -83.5]}, "405": {"vr": "DS", "Value": [-362.847, -503.29, -81.5]}, "406": {"vr": "DS", "Value": [-362.847, -503.29, -79.5]}, "407": {"vr": "DS", "Value": [-362.847, -503.29, -77.5]}, "408": {"vr": "DS", "Value": [-362.847, -503.29, -75.5]}, "409": {"vr": "DS", "Value": [-362.847, -503.29, -73.5]}, "410": {"vr": "DS", "Value": [-362.847, -503.29, -71.5]}, "411": {"vr": "DS", "Value": [-362.847, -503.29, -69.5]}, "412": {"vr": "DS", "Value": [-362.847, -503.29, -67.5]}, "413": {"vr": "DS", "Value": [-362.847, -503.29, -65.5]}, "414": {"vr": "DS", "Value": [-362.847, -503.29, -63.5]}, "415": {"vr": "DS", "Value": [-362.847, -503.29, -61.5]}, "416": {"vr": "DS", "Value": [-362.847, -503.29, -59.5]}, "417": {"vr": "DS", "Value": [-362.847, -503.29, -57.5]}, "418": {"vr": "DS", "Value": [-362.847, -503.29, -55.5]}, "419": {"vr": "DS", "Value": [-362.847, -503.29, -53.5]}, "420": {"vr": "DS", "Value": [-362.847, -503.29, -51.5]}, "421": {"vr": "DS", "Value": [-362.847, -503.29, -49.5]}, "422": {"vr": "DS", "Value": [-362.847, -503.29, -47.5]}, "423": {"vr": "DS", "Value": [-362.847, -503.29, -45.5]}, "424": {"vr": "DS", "Value": [-362.847, -503.29, -43.5]}, "425": {"vr": "DS", "Value": [-362.847, -503.29, -41.5]}, "426": {"vr": "DS", "Value": [-362.847, -503.29, -39.5]}, "427": {"vr": "DS", "Value": [-362.847, -503.29, -37.5]}, "428": {"vr": "DS", "Value": [-362.847, -503.29, -35.5]}, "429": {"vr": "DS", "Value": [-362.847, -503.29, -33.5]}, "430": {"vr": "DS", "Value": [-362.847, -503.29, -31.5]}, "431": {"vr": "DS", "Value": [-362.847, -503.29, -29.5]}, "432": {"vr": "DS", "Value": [-362.847, -503.29, -27.5]}, "433": {"vr": "DS", "Value": [-362.847, -503.29, -25.5]}, "434": {"vr": "DS", "Value": [-362.847, -503.29, -23.5]}, "435": {"vr": "DS", "Value": [-362.847, -503.29, -21.5]}, "436": {"vr": "DS", "Value": [-362.847, -503.29, -19.5]}, "437": {"vr": "DS", "Value": [-362.847, -503.29, -17.5]}, "438": {"vr": "DS", "Value": [-362.847, -503.29, -15.5]}, "439": {"vr": "DS", "Value": [-362.847, -503.29, -13.5]}, "440": {"vr": "DS", "Value": [-362.847, -503.29, -11.5]}, "441": {"vr": "DS", "Value": [-362.847, -503.29, -9.5]}, "442": {"vr": "DS", "Value": [-362.847, -503.29, -7.5]}, "443": {"vr": "DS", "Value": [-362.847, -503.29, -5.5]}, "444": {"vr": "DS", "Value": [-362.847, -503.29, -3.5]}, "445": {"vr": "DS", "Value": [-362.847, -503.29, -1.5]}, "446": {"vr": "DS", "Value": [-362.847, -503.29, 0.5]}, "447": {"vr": "DS", "Value": [-362.847, -503.29, 2.5]}, "448": {"vr": "DS", "Value": [-362.847, -503.29, 4.5]}, "449": {"vr": "DS", "Value": [-362.847, -503.29, 6.5]}, "450": {"vr": "DS", "Value": [-362.847, -503.29, 8.5]}, "451": {"vr": "DS", "Value": [-362.847, -503.29, 10.5]}, "452": {"vr": "DS", "Value": [-362.847, -503.29, 12.5]}, "453": {"vr": "DS", "Value": [-362.847, -503.29, 14.5]}, "454": {"vr": "DS", "Value": [-362.847, -503.29, 16.5]}, "455": {"vr": "DS", "Value": [-362.847, -503.29, 18.5]}, "456": {"vr": "DS", "Value": [-362.847, -503.29, 20.5]}, "457": {"vr": "DS", "Value": [-362.847, -503.29, 22.5]}, "458": {"vr": "DS", "Value": [-362.847, -503.29, 24.5]}, "459": {"vr": "DS", "Value": [-362.847, -503.29, 26.5]}, "460": {"vr": "DS", "Value": [-362.847, -503.29, 28.5]}, "461": {"vr": "DS", "Value": [-362.847, -503.29, 30.5]}, "462": {"vr": "DS", "Value": [-362.847, -503.29, 32.5]}, "463": {"vr": "DS", "Value": [-362.847, -503.29, 34.5]}, "464": {"vr": "DS", "Value": [-362.847, -503.29, 36.5]}, "465": {"vr": "DS", "Value": [-362.847, -503.29, 38.5]}, "466": {"vr": "DS", "Value": [-362.847, -503.29, 40.5]}, "467": {"vr": "DS", "Value": [-362.847, -503.29, 42.5]}, "468": {"vr": "DS", "Value": [-362.847, -503.29, 44.5]}, "469": {"vr": "DS", "Value": [-362.847, -503.29, 46.5]}, "470": {"vr": "DS", "Value": [-362.847, -503.29, 48.5]}, "471": {"vr": "DS", "Value": [-362.847, -503.29, 50.5]}, "472": {"vr": "DS", "Value": [-362.847, -503.29, 52.5]}, "473": {"vr": "DS", "Value": [-362.847, -503.29, 54.5]}, "474": {"vr": "DS", "Value": [-362.847, -503.29, 56.5]}, "475": {"vr": "DS", "Value": [-362.847, -503.29, 58.5]}, "476": {"vr": "DS", "Value": [-362.847, -503.29, 60.5]}, "477": {"vr": "DS", "Value": [-362.847, -503.29, 62.5]}, "478": {"vr": "DS", "Value": [-362.847, -503.29, 64.5]}, "479": {"vr": "DS", "Value": [-362.847, -503.29, 66.5]}, "480": {"vr": "DS", "Value": [-362.847, -503.29, 68.5]}, "481": {"vr": "DS", "Value": [-362.847, -503.29, 70.5]}, "482": {"vr": "DS", "Value": [-362.847, -503.29, 72.5]}, "483": {"vr": "DS", "Value": [-362.847, -503.29, 74.5]}, "484": {"vr": "DS", "Value": [-362.847, -503.29, 76.5]}, "485": {"vr": "DS", "Value": [-362.847, -503.29, 78.5]}, "486": {"vr": "DS", "Value": [-362.847, -503.29, 80.5]}, "487": {"vr": "DS", "Value": [-362.847, -503.29, 82.5]}, "488": {"vr": "DS", "Value": [-362.847, -503.29, 84.5]}, "489": {"vr": "DS", "Value": [-362.847, -503.29, 86.5]}, "490": {"vr": "DS", "Value": [-362.847, -503.29, 88.5]}, "491": {"vr": "DS", "Value": [-362.847, -503.29, 90.5]}, "492": {"vr": "DS", "Value": [-362.847, -503.29, 92.5]}, "493": {"vr": "DS", "Value": [-362.847, -503.29, 94.5]}, "494": {"vr": "DS", "Value": [-362.847, -503.29, 96.5]}, "495": {"vr": "DS", "Value": [-362.847, -503.29, 98.5]}, "496": {"vr": "DS", "Value": [-362.847, -503.29, 100.5]}, "497": {"vr": "DS", "Value": [-362.847, -503.29, 102.5]}, "498": {"vr": "DS", "Value": [-362.847, -503.29, 104.5]}, "499": {"vr": "DS", "Value": [-362.847, -503.29, 106.5]}, "500": {"vr": "DS", "Value": [-362.847, -503.29, 108.5]}, "501": {"vr": "DS", "Value": [-362.847, -503.29, 110.5]}, "502": {"vr": "DS", "Value": [-362.847, -503.29, 112.5]}, "503": {"vr": "DS", "Value": [-362.847, -503.29, 114.5]}, "504": {"vr": "DS", "Value": [-362.847, -503.29, 116.5]}, "505": {"vr": "DS", "Value": [-362.847, -503.29, 118.5]}, "506": {"vr": "DS", "Value": [-362.847, -503.29, 120.5]}, "507": {"vr": "DS", "Value": [-362.847, -503.29, 122.5]}, "508": {"vr": "DS", "Value": [-362.847, -503.29, 124.5]}, "509": {"vr": "DS", "Value": [-362.847, -503.29, 126.5]}, "510": {"vr": "DS", "Value": [-362.847, -503.29, 128.5]}, "511": {"vr": "DS", "Value": [-362.847, -503.29, 130.5]}, "512": {"vr": "DS", "Value": [-362.847, -503.29, 132.5]}, "513": {"vr": "DS", "Value": [-362.847, -503.29, 134.5]}, "514": {"vr": "DS", "Value": [-362.847, -503.29, 136.5]}, "515": {"vr": "DS", "Value": [-362.847, -503.29, 138.5]}, "516": {"vr": "DS", "Value": [-362.847, -503.29, 140.5]}, "517": {"vr": "DS", "Value": [-362.847, -503.29, 142.5]}, "518": {"vr": "DS", "Value": [-362.847, -503.29, 144.5]}, "519": {"vr": "DS", "Value": [-362.847, -503.29, 146.5]}, "520": {"vr": "DS", "Value": [-362.847, -503.29, 148.5]}, "521": {"vr": "DS", "Value": [-362.847, -503.29, 150.5]}, "522": {"vr": "DS", "Value": [-362.847, -503.29, 152.5]}, "523": {"vr": "DS", "Value": [-362.847, -503.29, 154.5]}, "524": {"vr": "DS", "Value": [-362.847, -503.29, 156.5]}, "525": {"vr": "DS", "Value": [-362.847, -503.29, 158.5]}, "526": {"vr": "DS", "Value": [-362.847, -503.29, 160.5]}, "527": {"vr": "DS", "Value": [-362.847, -503.29, 162.5]}, "528": {"vr": "DS", "Value": [-362.847, -503.29, 164.5]}, "529": {"vr": "DS", "Value": [-362.847, -503.29, 166.5]}, "530": {"vr": "DS", "Value": [-362.847, -503.29, 168.5]}}, "00201041": {"0": {"vr": "DS", "Value": [-891.5]}, "1": {"vr": "DS", "Value": [-889.5]}, "2": {"vr": "DS", "Value": [-887.5]}, "3": {"vr": "DS", "Value": [-885.5]}, "4": {"vr": "DS", "Value": [-883.5]}, "5": {"vr": "DS", "Value": [-881.5]}, "6": {"vr": "DS", "Value": [-879.5]}, "7": {"vr": "DS", "Value": [-877.5]}, "8": {"vr": "DS", "Value": [-875.5]}, "9": {"vr": "DS", "Value": [-873.5]}, "10": {"vr": "DS", "Value": [-871.5]}, "11": {"vr": "DS", "Value": [-869.5]}, "12": {"vr": "DS", "Value": [-867.5]}, "13": {"vr": "DS", "Value": [-865.5]}, "14": {"vr": "DS", "Value": [-863.5]}, "15": {"vr": "DS", "Value": [-861.5]}, "16": {"vr": "DS", "Value": [-859.5]}, "17": {"vr": "DS", "Value": [-857.5]}, "18": {"vr": "DS", "Value": [-855.5]}, "19": {"vr": "DS", "Value": [-853.5]}, "20": {"vr": "DS", "Value": [-851.5]}, "21": {"vr": "DS", "Value": [-849.5]}, "22": {"vr": "DS", "Value": [-847.5]}, "23": {"vr": "DS", "Value": [-845.5]}, "24": {"vr": "DS", "Value": [-843.5]}, "25": {"vr": "DS", "Value": [-841.5]}, "26": {"vr": "DS", "Value": [-839.5]}, "27": {"vr": "DS", "Value": [-837.5]}, "28": {"vr": "DS", "Value": [-835.5]}, "29": {"vr": "DS", "Value": [-833.5]}, "30": {"vr": "DS", "Value": [-831.5]}, "31": {"vr": "DS", "Value": [-829.5]}, "32": {"vr": "DS", "Value": [-827.5]}, "33": {"vr": "DS", "Value": [-825.5]}, "34": {"vr": "DS", "Value": [-823.5]}, "35": {"vr": "DS", "Value": [-821.5]}, "36": {"vr": "DS", "Value": [-819.5]}, "37": {"vr": "DS", "Value": [-817.5]}, "38": {"vr": "DS", "Value": [-815.5]}, "39": {"vr": "DS", "Value": [-813.5]}, "40": {"vr": "DS", "Value": [-811.5]}, "41": {"vr": "DS", "Value": [-809.5]}, "42": {"vr": "DS", "Value": [-807.5]}, "43": {"vr": "DS", "Value": [-805.5]}, "44": {"vr": "DS", "Value": [-803.5]}, "45": {"vr": "DS", "Value": [-801.5]}, "46": {"vr": "DS", "Value": [-799.5]}, "47": {"vr": "DS", "Value": [-797.5]}, "48": {"vr": "DS", "Value": [-795.5]}, "49": {"vr": "DS", "Value": [-793.5]}, "50": {"vr": "DS", "Value": [-791.5]}, "51": {"vr": "DS", "Value": [-789.5]}, "52": {"vr": "DS", "Value": [-787.5]}, "53": {"vr": "DS", "Value": [-785.5]}, "54": {"vr": "DS", "Value": [-783.5]}, "55": {"vr": "DS", "Value": [-781.5]}, "56": {"vr": "DS", "Value": [-779.5]}, "57": {"vr": "DS", "Value": [-777.5]}, "58": {"vr": "DS", "Value": [-775.5]}, "59": {"vr": "DS", "Value": [-773.5]}, "60": {"vr": "DS", "Value": [-771.5]}, "61": {"vr": "DS", "Value": [-769.5]}, "62": {"vr": "DS", "Value": [-767.5]}, "63": {"vr": "DS", "Value": [-765.5]}, "64": {"vr": "DS", "Value": [-763.5]}, "65": {"vr": "DS", "Value": [-761.5]}, "66": {"vr": "DS", "Value": [-759.5]}, "67": {"vr": "DS", "Value": [-757.5]}, "68": {"vr": "DS", "Value": [-755.5]}, "69": {"vr": "DS", "Value": [-753.5]}, "70": {"vr": "DS", "Value": [-751.5]}, "71": {"vr": "DS", "Value": [-749.5]}, "72": {"vr": "DS", "Value": [-747.5]}, "73": {"vr": "DS", "Value": [-745.5]}, "74": {"vr": "DS", "Value": [-743.5]}, "75": {"vr": "DS", "Value": [-741.5]}, "76": {"vr": "DS", "Value": [-739.5]}, "77": {"vr": "DS", "Value": [-737.5]}, "78": {"vr": "DS", "Value": [-735.5]}, "79": {"vr": "DS", "Value": [-733.5]}, "80": {"vr": "DS", "Value": [-731.5]}, "81": {"vr": "DS", "Value": [-729.5]}, "82": {"vr": "DS", "Value": [-727.5]}, "83": {"vr": "DS", "Value": [-725.5]}, "84": {"vr": "DS", "Value": [-723.5]}, "85": {"vr": "DS", "Value": [-721.5]}, "86": {"vr": "DS", "Value": [-719.5]}, "87": {"vr": "DS", "Value": [-717.5]}, "88": {"vr": "DS", "Value": [-715.5]}, "89": {"vr": "DS", "Value": [-713.5]}, "90": {"vr": "DS", "Value": [-711.5]}, "91": {"vr": "DS", "Value": [-709.5]}, "92": {"vr": "DS", "Value": [-707.5]}, "93": {"vr": "DS", "Value": [-705.5]}, "94": {"vr": "DS", "Value": [-703.5]}, "95": {"vr": "DS", "Value": [-701.5]}, "96": {"vr": "DS", "Value": [-699.5]}, "97": {"vr": "DS", "Value": [-697.5]}, "98": {"vr": "DS", "Value": [-695.5]}, "99": {"vr": "DS", "Value": [-693.5]}, "100": {"vr": "DS", "Value": [-691.5]}, "101": {"vr": "DS", "Value": [-689.5]}, "102": {"vr": "DS", "Value": [-687.5]}, "103": {"vr": "DS", "Value": [-685.5]}, "104": {"vr": "DS", "Value": [-683.5]}, "105": {"vr": "DS", "Value": [-681.5]}, "106": {"vr": "DS", "Value": [-679.5]}, "107": {"vr": "DS", "Value": [-677.5]}, "108": {"vr": "DS", "Value": [-675.5]}, "109": {"vr": "DS", "Value": [-673.5]}, "110": {"vr": "DS", "Value": [-671.5]}, "111": {"vr": "DS", "Value": [-669.5]}, "112": {"vr": "DS", "Value": [-667.5]}, "113": {"vr": "DS", "Value": [-665.5]}, "114": {"vr": "DS", "Value": [-663.5]}, "115": {"vr": "DS", "Value": [-661.5]}, "116": {"vr": "DS", "Value": [-659.5]}, "117": {"vr": "DS", "Value": [-657.5]}, "118": {"vr": "DS", "Value": [-655.5]}, "119": {"vr": "DS", "Value": [-653.5]}, "120": {"vr": "DS", "Value": [-651.5]}, "121": {"vr": "DS", "Value": [-649.5]}, "122": {"vr": "DS", "Value": [-647.5]}, "123": {"vr": "DS", "Value": [-645.5]}, "124": {"vr": "DS", "Value": [-643.5]}, "125": {"vr": "DS", "Value": [-641.5]}, "126": {"vr": "DS", "Value": [-639.5]}, "127": {"vr": "DS", "Value": [-637.5]}, "128": {"vr": "DS", "Value": [-635.5]}, "129": {"vr": "DS", "Value": [-633.5]}, "130": {"vr": "DS", "Value": [-631.5]}, "131": {"vr": "DS", "Value": [-629.5]}, "132": {"vr": "DS", "Value": [-627.5]}, "133": {"vr": "DS", "Value": [-625.5]}, "134": {"vr": "DS", "Value": [-623.5]}, "135": {"vr": "DS", "Value": [-621.5]}, "136": {"vr": "DS", "Value": [-619.5]}, "137": {"vr": "DS", "Value": [-617.5]}, "138": {"vr": "DS", "Value": [-615.5]}, "139": {"vr": "DS", "Value": [-613.5]}, "140": {"vr": "DS", "Value": [-611.5]}, "141": {"vr": "DS", "Value": [-609.5]}, "142": {"vr": "DS", "Value": [-607.5]}, "143": {"vr": "DS", "Value": [-605.5]}, "144": {"vr": "DS", "Value": [-603.5]}, "145": {"vr": "DS", "Value": [-601.5]}, "146": {"vr": "DS", "Value": [-599.5]}, "147": {"vr": "DS", "Value": [-597.5]}, "148": {"vr": "DS", "Value": [-595.5]}, "149": {"vr": "DS", "Value": [-593.5]}, "150": {"vr": "DS", "Value": [-591.5]}, "151": {"vr": "DS", "Value": [-589.5]}, "152": {"vr": "DS", "Value": [-587.5]}, "153": {"vr": "DS", "Value": [-585.5]}, "154": {"vr": "DS", "Value": [-583.5]}, "155": {"vr": "DS", "Value": [-581.5]}, "156": {"vr": "DS", "Value": [-579.5]}, "157": {"vr": "DS", "Value": [-577.5]}, "158": {"vr": "DS", "Value": [-575.5]}, "159": {"vr": "DS", "Value": [-573.5]}, "160": {"vr": "DS", "Value": [-571.5]}, "161": {"vr": "DS", "Value": [-569.5]}, "162": {"vr": "DS", "Value": [-567.5]}, "163": {"vr": "DS", "Value": [-565.5]}, "164": {"vr": "DS", "Value": [-563.5]}, "165": {"vr": "DS", "Value": [-561.5]}, "166": {"vr": "DS", "Value": [-559.5]}, "167": {"vr": "DS", "Value": [-557.5]}, "168": {"vr": "DS", "Value": [-555.5]}, "169": {"vr": "DS", "Value": [-553.5]}, "170": {"vr": "DS", "Value": [-551.5]}, "171": {"vr": "DS", "Value": [-549.5]}, "172": {"vr": "DS", "Value": [-547.5]}, "173": {"vr": "DS", "Value": [-545.5]}, "174": {"vr": "DS", "Value": [-543.5]}, "175": {"vr": "DS", "Value": [-541.5]}, "176": {"vr": "DS", "Value": [-539.5]}, "177": {"vr": "DS", "Value": [-537.5]}, "178": {"vr": "DS", "Value": [-535.5]}, "179": {"vr": "DS", "Value": [-533.5]}, "180": {"vr": "DS", "Value": [-531.5]}, "181": {"vr": "DS", "Value": [-529.5]}, "182": {"vr": "DS", "Value": [-527.5]}, "183": {"vr": "DS", "Value": [-525.5]}, "184": {"vr": "DS", "Value": [-523.5]}, "185": {"vr": "DS", "Value": [-521.5]}, "186": {"vr": "DS", "Value": [-519.5]}, "187": {"vr": "DS", "Value": [-517.5]}, "188": {"vr": "DS", "Value": [-515.5]}, "189": {"vr": "DS", "Value": [-513.5]}, "190": {"vr": "DS", "Value": [-511.5]}, "191": {"vr": "DS", "Value": [-509.5]}, "192": {"vr": "DS", "Value": [-507.5]}, "193": {"vr": "DS", "Value": [-505.5]}, "194": {"vr": "DS", "Value": [-503.5]}, "195": {"vr": "DS", "Value": [-501.5]}, "196": {"vr": "DS", "Value": [-499.5]}, "197": {"vr": "DS", "Value": [-497.5]}, "198": {"vr": "DS", "Value": [-495.5]}, "199": {"vr": "DS", "Value": [-493.5]}, "200": {"vr": "DS", "Value": [-491.5]}, "201": {"vr": "DS", "Value": [-489.5]}, "202": {"vr": "DS", "Value": [-487.5]}, "203": {"vr": "DS", "Value": [-485.5]}, "204": {"vr": "DS", "Value": [-483.5]}, "205": {"vr": "DS", "Value": [-481.5]}, "206": {"vr": "DS", "Value": [-479.5]}, "207": {"vr": "DS", "Value": [-477.5]}, "208": {"vr": "DS", "Value": [-475.5]}, "209": {"vr": "DS", "Value": [-473.5]}, "210": {"vr": "DS", "Value": [-471.5]}, "211": {"vr": "DS", "Value": [-469.5]}, "212": {"vr": "DS", "Value": [-467.5]}, "213": {"vr": "DS", "Value": [-465.5]}, "214": {"vr": "DS", "Value": [-463.5]}, "215": {"vr": "DS", "Value": [-461.5]}, "216": {"vr": "DS", "Value": [-459.5]}, "217": {"vr": "DS", "Value": [-457.5]}, "218": {"vr": "DS", "Value": [-455.5]}, "219": {"vr": "DS", "Value": [-453.5]}, "220": {"vr": "DS", "Value": [-451.5]}, "221": {"vr": "DS", "Value": [-449.5]}, "222": {"vr": "DS", "Value": [-447.5]}, "223": {"vr": "DS", "Value": [-445.5]}, "224": {"vr": "DS", "Value": [-443.5]}, "225": {"vr": "DS", "Value": [-441.5]}, "226": {"vr": "DS", "Value": [-439.5]}, "227": {"vr": "DS", "Value": [-437.5]}, "228": {"vr": "DS", "Value": [-435.5]}, "229": {"vr": "DS", "Value": [-433.5]}, "230": {"vr": "DS", "Value": [-431.5]}, "231": {"vr": "DS", "Value": [-429.5]}, "232": {"vr": "DS", "Value": [-427.5]}, "233": {"vr": "DS", "Value": [-425.5]}, "234": {"vr": "DS", "Value": [-423.5]}, "235": {"vr": "DS", "Value": [-421.5]}, "236": {"vr": "DS", "Value": [-419.5]}, "237": {"vr": "DS", "Value": [-417.5]}, "238": {"vr": "DS", "Value": [-415.5]}, "239": {"vr": "DS", "Value": [-413.5]}, "240": {"vr": "DS", "Value": [-411.5]}, "241": {"vr": "DS", "Value": [-409.5]}, "242": {"vr": "DS", "Value": [-407.5]}, "243": {"vr": "DS", "Value": [-405.5]}, "244": {"vr": "DS", "Value": [-403.5]}, "245": {"vr": "DS", "Value": [-401.5]}, "246": {"vr": "DS", "Value": [-399.5]}, "247": {"vr": "DS", "Value": [-397.5]}, "248": {"vr": "DS", "Value": [-395.5]}, "249": {"vr": "DS", "Value": [-393.5]}, "250": {"vr": "DS", "Value": [-391.5]}, "251": {"vr": "DS", "Value": [-389.5]}, "252": {"vr": "DS", "Value": [-387.5]}, "253": {"vr": "DS", "Value": [-385.5]}, "254": {"vr": "DS", "Value": [-383.5]}, "255": {"vr": "DS", "Value": [-381.5]}, "256": {"vr": "DS", "Value": [-379.5]}, "257": {"vr": "DS", "Value": [-377.5]}, "258": {"vr": "DS", "Value": [-375.5]}, "259": {"vr": "DS", "Value": [-373.5]}, "260": {"vr": "DS", "Value": [-371.5]}, "261": {"vr": "DS", "Value": [-369.5]}, "262": {"vr": "DS", "Value": [-367.5]}, "263": {"vr": "DS", "Value": [-365.5]}, "264": {"vr": "DS", "Value": [-363.5]}, "265": {"vr": "DS", "Value": [-361.5]}, "266": {"vr": "DS", "Value": [-359.5]}, "267": {"vr": "DS", "Value": [-357.5]}, "268": {"vr": "DS", "Value": [-355.5]}, "269": {"vr": "DS", "Value": [-353.5]}, "270": {"vr": "DS", "Value": [-351.5]}, "271": {"vr": "DS", "Value": [-349.5]}, "272": {"vr": "DS", "Value": [-347.5]}, "273": {"vr": "DS", "Value": [-345.5]}, "274": {"vr": "DS", "Value": [-343.5]}, "275": {"vr": "DS", "Value": [-341.5]}, "276": {"vr": "DS", "Value": [-339.5]}, "277": {"vr": "DS", "Value": [-337.5]}, "278": {"vr": "DS", "Value": [-335.5]}, "279": {"vr": "DS", "Value": [-333.5]}, "280": {"vr": "DS", "Value": [-331.5]}, "281": {"vr": "DS", "Value": [-329.5]}, "282": {"vr": "DS", "Value": [-327.5]}, "283": {"vr": "DS", "Value": [-325.5]}, "284": {"vr": "DS", "Value": [-323.5]}, "285": {"vr": "DS", "Value": [-321.5]}, "286": {"vr": "DS", "Value": [-319.5]}, "287": {"vr": "DS", "Value": [-317.5]}, "288": {"vr": "DS", "Value": [-315.5]}, "289": {"vr": "DS", "Value": [-313.5]}, "290": {"vr": "DS", "Value": [-311.5]}, "291": {"vr": "DS", "Value": [-309.5]}, "292": {"vr": "DS", "Value": [-307.5]}, "293": {"vr": "DS", "Value": [-305.5]}, "294": {"vr": "DS", "Value": [-303.5]}, "295": {"vr": "DS", "Value": [-301.5]}, "296": {"vr": "DS", "Value": [-299.5]}, "297": {"vr": "DS", "Value": [-297.5]}, "298": {"vr": "DS", "Value": [-295.5]}, "299": {"vr": "DS", "Value": [-293.5]}, "300": {"vr": "DS", "Value": [-291.5]}, "301": {"vr": "DS", "Value": [-289.5]}, "302": {"vr": "DS", "Value": [-287.5]}, "303": {"vr": "DS", "Value": [-285.5]}, "304": {"vr": "DS", "Value": [-283.5]}, "305": {"vr": "DS", "Value": [-281.5]}, "306": {"vr": "DS", "Value": [-279.5]}, "307": {"vr": "DS", "Value": [-277.5]}, "308": {"vr": "DS", "Value": [-275.5]}, "309": {"vr": "DS", "Value": [-273.5]}, "310": {"vr": "DS", "Value": [-271.5]}, "311": {"vr": "DS", "Value": [-269.5]}, "312": {"vr": "DS", "Value": [-267.5]}, "313": {"vr": "DS", "Value": [-265.5]}, "314": {"vr": "DS", "Value": [-263.5]}, "315": {"vr": "DS", "Value": [-261.5]}, "316": {"vr": "DS", "Value": [-259.5]}, "317": {"vr": "DS", "Value": [-257.5]}, "318": {"vr": "DS", "Value": [-255.5]}, "319": {"vr": "DS", "Value": [-253.5]}, "320": {"vr": "DS", "Value": [-251.5]}, "321": {"vr": "DS", "Value": [-249.5]}, "322": {"vr": "DS", "Value": [-247.5]}, "323": {"vr": "DS", "Value": [-245.5]}, "324": {"vr": "DS", "Value": [-243.5]}, "325": {"vr": "DS", "Value": [-241.5]}, "326": {"vr": "DS", "Value": [-239.5]}, "327": {"vr": "DS", "Value": [-237.5]}, "328": {"vr": "DS", "Value": [-235.5]}, "329": {"vr": "DS", "Value": [-233.5]}, "330": {"vr": "DS", "Value": [-231.5]}, "331": {"vr": "DS", "Value": [-229.5]}, "332": {"vr": "DS", "Value": [-227.5]}, "333": {"vr": "DS", "Value": [-225.5]}, "334": {"vr": "DS", "Value": [-223.5]}, "335": {"vr": "DS", "Value": [-221.5]}, "336": {"vr": "DS", "Value": [-219.5]}, "337": {"vr": "DS", "Value": [-217.5]}, "338": {"vr": "DS", "Value": [-215.5]}, "339": {"vr": "DS", "Value": [-213.5]}, "340": {"vr": "DS", "Value": [-211.5]}, "341": {"vr": "DS", "Value": [-209.5]}, "342": {"vr": "DS", "Value": [-207.5]}, "343": {"vr": "DS", "Value": [-205.5]}, "344": {"vr": "DS", "Value": [-203.5]}, "345": {"vr": "DS", "Value": [-201.5]}, "346": {"vr": "DS", "Value": [-199.5]}, "347": {"vr": "DS", "Value": [-197.5]}, "348": {"vr": "DS", "Value": [-195.5]}, "349": {"vr": "DS", "Value": [-193.5]}, "350": {"vr": "DS", "Value": [-191.5]}, "351": {"vr": "DS", "Value": [-189.5]}, "352": {"vr": "DS", "Value": [-187.5]}, "353": {"vr": "DS", "Value": [-185.5]}, "354": {"vr": "DS", "Value": [-183.5]}, "355": {"vr": "DS", "Value": [-181.5]}, "356": {"vr": "DS", "Value": [-179.5]}, "357": {"vr": "DS", "Value": [-177.5]}, "358": {"vr": "DS", "Value": [-175.5]}, "359": {"vr": "DS", "Value": [-173.5]}, "360": {"vr": "DS", "Value": [-171.5]}, "361": {"vr": "DS", "Value": [-169.5]}, "362": {"vr": "DS", "Value": [-167.5]}, "363": {"vr": "DS", "Value": [-165.5]}, "364": {"vr": "DS", "Value": [-163.5]}, "365": {"vr": "DS", "Value": [-161.5]}, "366": {"vr": "DS", "Value": [-159.5]}, "367": {"vr": "DS", "Value": [-157.5]}, "368": {"vr": "DS", "Value": [-155.5]}, "369": {"vr": "DS", "Value": [-153.5]}, "370": {"vr": "DS", "Value": [-151.5]}, "371": {"vr": "DS", "Value": [-149.5]}, "372": {"vr": "DS", "Value": [-147.5]}, "373": {"vr": "DS", "Value": [-145.5]}, "374": {"vr": "DS", "Value": [-143.5]}, "375": {"vr": "DS", "Value": [-141.5]}, "376": {"vr": "DS", "Value": [-139.5]}, "377": {"vr": "DS", "Value": [-137.5]}, "378": {"vr": "DS", "Value": [-135.5]}, "379": {"vr": "DS", "Value": [-133.5]}, "380": {"vr": "DS", "Value": [-131.5]}, "381": {"vr": "DS", "Value": [-129.5]}, "382": {"vr": "DS", "Value": [-127.5]}, "383": {"vr": "DS", "Value": [-125.5]}, "384": {"vr": "DS", "Value": [-123.5]}, "385": {"vr": "DS", "Value": [-121.5]}, "386": {"vr": "DS", "Value": [-119.5]}, "387": {"vr": "DS", "Value": [-117.5]}, "388": {"vr": "DS", "Value": [-115.5]}, "389": {"vr": "DS", "Value": [-113.5]}, "390": {"vr": "DS", "Value": [-111.5]}, "391": {"vr": "DS", "Value": [-109.5]}, "392": {"vr": "DS", "Value": [-107.5]}, "393": {"vr": "DS", "Value": [-105.5]}, "394": {"vr": "DS", "Value": [-103.5]}, "395": {"vr": "DS", "Value": [-101.5]}, "396": {"vr": "DS", "Value": [-99.5]}, "397": {"vr": "DS", "Value": [-97.5]}, "398": {"vr": "DS", "Value": [-95.5]}, "399": {"vr": "DS", "Value": [-93.5]}, "400": {"vr": "DS", "Value": [-91.5]}, "401": {"vr": "DS", "Value": [-89.5]}, "402": {"vr": "DS", "Value": [-87.5]}, "403": {"vr": "DS", "Value": [-85.5]}, "404": {"vr": "DS", "Value": [-83.5]}, "405": {"vr": "DS", "Value": [-81.5]}, "406": {"vr": "DS", "Value": [-79.5]}, "407": {"vr": "DS", "Value": [-77.5]}, "408": {"vr": "DS", "Value": [-75.5]}, "409": {"vr": "DS", "Value": [-73.5]}, "410": {"vr": "DS", "Value": [-71.5]}, "411": {"vr": "DS", "Value": [-69.5]}, "412": {"vr": "DS", "Value": [-67.5]}, "413": {"vr": "DS", "Value": [-65.5]}, "414": {"vr": "DS", "Value": [-63.5]}, "415": {"vr": "DS", "Value": [-61.5]}, "416": {"vr": "DS", "Value": [-59.5]}, "417": {"vr": "DS", "Value": [-57.5]}, "418": {"vr": "DS", "Value": [-55.5]}, "419": {"vr": "DS", "Value": [-53.5]}, "420": {"vr": "DS", "Value": [-51.5]}, "421": {"vr": "DS", "Value": [-49.5]}, "422": {"vr": "DS", "Value": [-47.5]}, "423": {"vr": "DS", "Value": [-45.5]}, "424": {"vr": "DS", "Value": [-43.5]}, "425": {"vr": "DS", "Value": [-41.5]}, "426": {"vr": "DS", "Value": [-39.5]}, "427": {"vr": "DS", "Value": [-37.5]}, "428": {"vr": "DS", "Value": [-35.5]}, "429": {"vr": "DS", "Value": [-33.5]}, "430": {"vr": "DS", "Value": [-31.5]}, "431": {"vr": "DS", "Value": [-29.5]}, "432": {"vr": "DS", "Value": [-27.5]}, "433": {"vr": "DS", "Value": [-25.5]}, "434": {"vr": "DS", "Value": [-23.5]}, "435": {"vr": "DS", "Value": [-21.5]}, "436": {"vr": "DS", "Value": [-19.5]}, "437": {"vr": "DS", "Value": [-17.5]}, "438": {"vr": "DS", "Value": [-15.5]}, "439": {"vr": "DS", "Value": [-13.5]}, "440": {"vr": "DS", "Value": [-11.5]}, "441": {"vr": "DS", "Value": [-9.5]}, "442": {"vr": "DS", "Value": [-7.5]}, "443": {"vr": "DS", "Value": [-5.5]}, "444": {"vr": "DS", "Value": [-3.5]}, "445": {"vr": "DS", "Value": [-1.5]}, "446": {"vr": "DS", "Value": [0.5]}, "447": {"vr": "DS", "Value": [2.5]}, "448": {"vr": "DS", "Value": [4.5]}, "449": {"vr": "DS", "Value": [6.5]}, "450": {"vr": "DS", "Value": [8.5]}, "451": {"vr": "DS", "Value": [10.5]}, "452": {"vr": "DS", "Value": [12.5]}, "453": {"vr": "DS", "Value": [14.5]}, "454": {"vr": "DS", "Value": [16.5]}, "455": {"vr": "DS", "Value": [18.5]}, "456": {"vr": "DS", "Value": [20.5]}, "457": {"vr": "DS", "Value": [22.5]}, "458": {"vr": "DS", "Value": [24.5]}, "459": {"vr": "DS", "Value": [26.5]}, "460": {"vr": "DS", "Value": [28.5]}, "461": {"vr": "DS", "Value": [30.5]}, "462": {"vr": "DS", "Value": [32.5]}, "463": {"vr": "DS", "Value": [34.5]}, "464": {"vr": "DS", "Value": [36.5]}, "465": {"vr": "DS", "Value": [38.5]}, "466": {"vr": "DS", "Value": [40.5]}, "467": {"vr": "DS", "Value": [42.5]}, "468": {"vr": "DS", "Value": [44.5]}, "469": {"vr": "DS", "Value": [46.5]}, "470": {"vr": "DS", "Value": [48.5]}, "471": {"vr": "DS", "Value": [50.5]}, "472": {"vr": "DS", "Value": [52.5]}, "473": {"vr": "DS", "Value": [54.5]}, "474": {"vr": "DS", "Value": [56.5]}, "475": {"vr": "DS", "Value": [58.5]}, "476": {"vr": "DS", "Value": [60.5]}, "477": {"vr": "DS", "Value": [62.5]}, "478": {"vr": "DS", "Value": [64.5]}, "479": {"vr": "DS", "Value": [66.5]}, "480": {"vr": "DS", "Value": [68.5]}, "481": {"vr": "DS", "Value": [70.5]}, "482": {"vr": "DS", "Value": [72.5]}, "483": {"vr": "DS", "Value": [74.5]}, "484": {"vr": "DS", "Value": [76.5]}, "485": {"vr": "DS", "Value": [78.5]}, "486": {"vr": "DS", "Value": [80.5]}, "487": {"vr": "DS", "Value": [82.5]}, "488": {"vr": "DS", "Value": [84.5]}, "489": {"vr": "DS", "Value": [86.5]}, "490": {"vr": "DS", "Value": [88.5]}, "491": {"vr": "DS", "Value": [90.5]}, "492": {"vr": "DS", "Value": [92.5]}, "493": {"vr": "DS", "Value": [94.5]}, "494": {"vr": "DS", "Value": [96.5]}, "495": {"vr": "DS", "Value": [98.5]}, "496": {"vr": "DS", "Value": [100.5]}, "497": {"vr": "DS", "Value": [102.5]}, "498": {"vr": "DS", "Value": [104.5]}, "499": {"vr": "DS", "Value": [106.5]}, "500": {"vr": "DS", "Value": [108.5]}, "501": {"vr": "DS", "Value": [110.5]}, "502": {"vr": "DS", "Value": [112.5]}, "503": {"vr": "DS", "Value": [114.5]}, "504": {"vr": "DS", "Value": [116.5]}, "505": {"vr": "DS", "Value": [118.5]}, "506": {"vr": "DS", "Value": [120.5]}, "507": {"vr": "DS", "Value": [122.5]}, "508": {"vr": "DS", "Value": [124.5]}, "509": {"vr": "DS", "Value": [126.5]}, "510": {"vr": "DS", "Value": [128.5]}, "511": {"vr": "DS", "Value": [130.5]}, "512": {"vr": "DS", "Value": [132.5]}, "513": {"vr": "DS", "Value": [134.5]}, "514": {"vr": "DS", "Value": [136.5]}, "515": {"vr": "DS", "Value": [138.5]}, "516": {"vr": "DS", "Value": [140.5]}, "517": {"vr": "DS", "Value": [142.5]}, "518": {"vr": "DS", "Value": [144.5]}, "519": {"vr": "DS", "Value": [146.5]}, "520": {"vr": "DS", "Value": [148.5]}, "521": {"vr": "DS", "Value": [150.5]}, "522": {"vr": "DS", "Value": [152.5]}, "523": {"vr": "DS", "Value": [154.5]}, "524": {"vr": "DS", "Value": [156.5]}, "525": {"vr": "DS", "Value": [158.5]}, "526": {"vr": "DS", "Value": [160.5]}, "527": {"vr": "DS", "Value": [162.5]}, "528": {"vr": "DS", "Value": [164.5]}, "529": {"vr": "DS", "Value": [166.5]}, "530": {"vr": "DS", "Value": [168.5]}}, "00280107": {"0": {"vr": "US", "Value": [0]}, "1": {"vr": "US", "Value": [0]}, "2": {"vr": "US", "Value": [0]}, "3": {"vr": "US", "Value": [0]}, "4": {"vr": "US", "Value": [0]}, "5": {"vr": "US", "Value": [0]}, "6": {"vr": "US", "Value": [0]}, "7": {"vr": "US", "Value": [0]}, "8": {"vr": "US", "Value": [0]}, "9": {"vr": "US", "Value": [0]}, "10": {"vr": "US", "Value": [0]}, "11": {"vr": "US", "Value": [0]}, "12": {"vr": "US", "Value": [0]}, "13": {"vr": "US", "Value": [0]}, "14": {"vr": "US", "Value": [0]}, "15": {"vr": "US", "Value": [0]}, "16": {"vr": "US", "Value": [0]}, "17": {"vr": "US", "Value": [0]}, "18": {"vr": "US", "Value": [0]}, "19": {"vr": "US", "Value": [0]}, "20": {"vr": "US", "Value": [0]}, "21": {"vr": "US", "Value": [0]}, "22": {"vr": "US", "Value": [0]}, "23": {"vr": "US", "Value": [0]}, "24": {"vr": "US", "Value": [0]}, "25": {"vr": "US", "Value": [0]}, "26": {"vr": "US", "Value": [0]}, "27": {"vr": "US", "Value": [0]}, "28": {"vr": "US", "Value": [0]}, "29": {"vr": "US", "Value": [0]}, "30": {"vr": "US", "Value": [0]}, "31": {"vr": "US", "Value": [0]}, "32": {"vr": "US", "Value": [0]}, "33": {"vr": "US", "Value": [0]}, "34": {"vr": "US", "Value": [0]}, "35": {"vr": "US", "Value": [0]}, "36": {"vr": "US", "Value": [0]}, "37": {"vr": "US", "Value": [0]}, "38": {"vr": "US", "Value": [0]}, "39": {"vr": "US", "Value": [0]}, "40": {"vr": "US", "Value": [0]}, "41": {"vr": "US", "Value": [0]}, "42": {"vr": "US", "Value": [0]}, "43": {"vr": "US", "Value": [0]}, "44": {"vr": "US", "Value": [0]}, "45": {"vr": "US", "Value": [0]}, "46": {"vr": "US", "Value": [0]}, "47": {"vr": "US", "Value": [0]}, "48": {"vr": "US", "Value": [0]}, "49": {"vr": "US", "Value": [0]}, "50": {"vr": "US", "Value": [0]}, "51": {"vr": "US", "Value": [0]}, "52": {"vr": "US", "Value": [0]}, "53": {"vr": "US", "Value": [0]}, "54": {"vr": "US", "Value": [0]}, "55": {"vr": "US", "Value": [0]}, "56": {"vr": "US", "Value": [0]}, "57": {"vr": "US", "Value": [0]}, "58": {"vr": "US", "Value": [0]}, "59": {"vr": "US", "Value": [0]}, "60": {"vr": "US", "Value": [0]}, "61": {"vr": "US", "Value": [0]}, "62": {"vr": "US", "Value": [0]}, "63": {"vr": "US", "Value": [0]}, "64": {"vr": "US", "Value": [0]}, "65": {"vr": "US", "Value": [0]}, "66": {"vr": "US", "Value": [0]}, "67": {"vr": "US", "Value": [0]}, "68": {"vr": "US", "Value": [0]}, "69": {"vr": "US", "Value": [0]}, "70": {"vr": "US", "Value": [0]}, "71": {"vr": "US", "Value": [0]}, "72": {"vr": "US", "Value": [0]}, "73": {"vr": "US", "Value": [0]}, "74": {"vr": "US", "Value": [0]}, "75": {"vr": "US", "Value": [0]}, "76": {"vr": "US", "Value": [0]}, "77": {"vr": "US", "Value": [0]}, "78": {"vr": "US", "Value": [0]}, "79": {"vr": "US", "Value": [0]}, "80": {"vr": "US", "Value": [0]}, "81": {"vr": "US", "Value": [0]}, "82": {"vr": "US", "Value": [0]}, "83": {"vr": "US", "Value": [0]}, "84": {"vr": "US", "Value": [0]}, "85": {"vr": "US", "Value": [0]}, "86": {"vr": "US", "Value": [0]}, "87": {"vr": "US", "Value": [0]}, "88": {"vr": "US", "Value": [0]}, "89": {"vr": "US", "Value": [0]}, "90": {"vr": "US", "Value": [0]}, "91": {"vr": "US", "Value": [0]}, "92": {"vr": "US", "Value": [0]}, "93": {"vr": "US", "Value": [0]}, "94": {"vr": "US", "Value": [0]}, "95": {"vr": "US", "Value": [0]}, "96": {"vr": "US", "Value": [0]}, "97": {"vr": "US", "Value": [0]}, "98": {"vr": "US", "Value": [0]}, "99": {"vr": "US", "Value": [0]}, "100": {"vr": "US", "Value": [0]}, "101": {"vr": "US", "Value": [0]}, "102": {"vr": "US", "Value": [0]}, "103": {"vr": "US", "Value": [0]}, "104": {"vr": "US", "Value": [0]}, "105": {"vr": "US", "Value": [0]}, "106": {"vr": "US", "Value": [0]}, "107": {"vr": "US", "Value": [0]}, "108": {"vr": "US", "Value": [0]}, "109": {"vr": "US", "Value": [0]}, "110": {"vr": "US", "Value": [0]}, "111": {"vr": "US", "Value": [0]}, "112": {"vr": "US", "Value": [0]}, "113": {"vr": "US", "Value": [0]}, "114": {"vr": "US", "Value": [0]}, "115": {"vr": "US", "Value": [0]}, "116": {"vr": "US", "Value": [0]}, "117": {"vr": "US", "Value": [0]}, "118": {"vr": "US", "Value": [0]}, "119": {"vr": "US", "Value": [0]}, "120": {"vr": "US", "Value": [0]}, "121": {"vr": "US", "Value": [0]}, "122": {"vr": "US", "Value": [0]}, "123": {"vr": "US", "Value": [0]}, "124": {"vr": "US", "Value": [0]}, "125": {"vr": "US", "Value": [0]}, "126": {"vr": "US", "Value": [3]}, "127": {"vr": "US", "Value": [12]}, "128": {"vr": "US", "Value": [51]}, "129": {"vr": "US", "Value": [24]}, "130": {"vr": "US", "Value": [14]}, "131": {"vr": "US", "Value": [26]}, "132": {"vr": "US", "Value": [29]}, "133": {"vr": "US", "Value": [49]}, "134": {"vr": "US", "Value": [74]}, "135": {"vr": "US", "Value": [107]}, "136": {"vr": "US", "Value": [63]}, "137": {"vr": "US", "Value": [127]}, "138": {"vr": "US", "Value": [150]}, "139": {"vr": "US", "Value": [110]}, "140": {"vr": "US", "Value": [153]}, "141": {"vr": "US", "Value": [136]}, "142": {"vr": "US", "Value": [73]}, "143": {"vr": "US", "Value": [64]}, "144": {"vr": "US", "Value": [84]}, "145": {"vr": "US", "Value": [98]}, "146": {"vr": "US", "Value": [102]}, "147": {"vr": "US", "Value": [151]}, "148": {"vr": "US", "Value": [148]}, "149": {"vr": "US", "Value": [112]}, "150": {"vr": "US", "Value": [142]}, "151": {"vr": "US", "Value": [117]}, "152": {"vr": "US", "Value": [163]}, "153": {"vr": "US", "Value": [156]}, "154": {"vr": "US", "Value": [133]}, "155": {"vr": "US", "Value": [110]}, "156": {"vr": "US", "Value": [111]}, "157": {"vr": "US", "Value": [83]}, "158": {"vr": "US", "Value": [107]}, "159": {"vr": "US", "Value": [89]}, "160": {"vr": "US", "Value": [78]}, "161": {"vr": "US", "Value": [163]}, "162": {"vr": "US", "Value": [209]}, "163": {"vr": "US", "Value": [124]}, "164": {"vr": "US", "Value": [132]}, "165": {"vr": "US", "Value": [122]}, "166": {"vr": "US", "Value": [130]}, "167": {"vr": "US", "Value": [108]}, "168": {"vr": "US", "Value": [133]}, "169": {"vr": "US", "Value": [100]}, "170": {"vr": "US", "Value": [132]}, "171": {"vr": "US", "Value": [131]}, "172": {"vr": "US", "Value": [111]}, "173": {"vr": "US", "Value": [91]}, "174": {"vr": "US", "Value": [99]}, "175": {"vr": "US", "Value": [142]}, "176": {"vr": "US", "Value": [95]}, "177": {"vr": "US", "Value": [128]}, "178": {"vr": "US", "Value": [144]}, "179": {"vr": "US", "Value": [113]}, "180": {"vr": "US", "Value": [94]}, "181": {"vr": "US", "Value": [138]}, "182": {"vr": "US", "Value": [111]}, "183": {"vr": "US", "Value": [82]}, "184": {"vr": "US", "Value": [113]}, "185": {"vr": "US", "Value": [122]}, "186": {"vr": "US", "Value": [91]}, "187": {"vr": "US", "Value": [105]}, "188": {"vr": "US", "Value": [87]}, "189": {"vr": "US", "Value": [120]}, "190": {"vr": "US", "Value": [150]}, "191": {"vr": "US", "Value": [140]}, "192": {"vr": "US", "Value": [109]}, "193": {"vr": "US", "Value": [102]}, "194": {"vr": "US", "Value": [108]}, "195": {"vr": "US", "Value": [109]}, "196": {"vr": "US", "Value": [105]}, "197": {"vr": "US", "Value": [106]}, "198": {"vr": "US", "Value": [88]}, "199": {"vr": "US", "Value": [132]}, "200": {"vr": "US", "Value": [148]}, "201": {"vr": "US", "Value": [107]}, "202": {"vr": "US", "Value": [119]}, "203": {"vr": "US", "Value": [134]}, "204": {"vr": "US", "Value": [97]}, "205": {"vr": "US", "Value": [118]}, "206": {"vr": "US", "Value": [148]}, "207": {"vr": "US", "Value": [147]}, "208": {"vr": "US", "Value": [110]}, "209": {"vr": "US", "Value": [211]}, "210": {"vr": "US", "Value": [203]}, "211": {"vr": "US", "Value": [116]}, "212": {"vr": "US", "Value": [133]}, "213": {"vr": "US", "Value": [233]}, "214": {"vr": "US", "Value": [199]}, "215": {"vr": "US", "Value": [129]}, "216": {"vr": "US", "Value": [119]}, "217": {"vr": "US", "Value": [140]}, "218": {"vr": "US", "Value": [122]}, "219": {"vr": "US", "Value": [136]}, "220": {"vr": "US", "Value": [134]}, "221": {"vr": "US", "Value": [146]}, "222": {"vr": "US", "Value": [119]}, "223": {"vr": "US", "Value": [150]}, "224": {"vr": "US", "Value": [197]}, "225": {"vr": "US", "Value": [159]}, "226": {"vr": "US", "Value": [138]}, "227": {"vr": "US", "Value": [137]}, "228": {"vr": "US", "Value": [183]}, "229": {"vr": "US", "Value": [278]}, "230": {"vr": "US", "Value": [269]}, "231": {"vr": "US", "Value": [189]}, "232": {"vr": "US", "Value": [206]}, "233": {"vr": "US", "Value": [320]}, "234": {"vr": "US", "Value": [201]}, "235": {"vr": "US", "Value": [178]}, "236": {"vr": "US", "Value": [218]}, "237": {"vr": "US", "Value": [240]}, "238": {"vr": "US", "Value": [237]}, "239": {"vr": "US", "Value": [233]}, "240": {"vr": "US", "Value": [246]}, "241": {"vr": "US", "Value": [272]}, "242": {"vr": "US", "Value": [267]}, "243": {"vr": "US", "Value": [282]}, "244": {"vr": "US", "Value": [272]}, "245": {"vr": "US", "Value": [365]}, "246": {"vr": "US", "Value": [360]}, "247": {"vr": "US", "Value": [396]}, "248": {"vr": "US", "Value": [340]}, "249": {"vr": "US", "Value": [310]}, "250": {"vr": "US", "Value": [359]}, "251": {"vr": "US", "Value": [556]}, "252": {"vr": "US", "Value": [383]}, "253": {"vr": "US", "Value": [387]}, "254": {"vr": "US", "Value": [471]}, "255": {"vr": "US", "Value": [557]}, "256": {"vr": "US", "Value": [419]}, "257": {"vr": "US", "Value": [409]}, "258": {"vr": "US", "Value": [491]}, "259": {"vr": "US", "Value": [481]}, "260": {"vr": "US", "Value": [531]}, "261": {"vr": "US", "Value": [500]}, "262": {"vr": "US", "Value": [501]}, "263": {"vr": "US", "Value": [548]}, "264": {"vr": "US", "Value": [673]}, "265": {"vr": "US", "Value": [621]}, "266": {"vr": "US", "Value": [543]}, "267": {"vr": "US", "Value": [582]}, "268": {"vr": "US", "Value": [610]}, "269": {"vr": "US", "Value": [691]}, "270": {"vr": "US", "Value": [786]}, "271": {"vr": "US", "Value": [662]}, "272": {"vr": "US", "Value": [641]}, "273": {"vr": "US", "Value": [761]}, "274": {"vr": "US", "Value": [756]}, "275": {"vr": "US", "Value": [781]}, "276": {"vr": "US", "Value": [730]}, "277": {"vr": "US", "Value": [737]}, "278": {"vr": "US", "Value": [775]}, "279": {"vr": "US", "Value": [870]}, "280": {"vr": "US", "Value": [877]}, "281": {"vr": "US", "Value": [993]}, "282": {"vr": "US", "Value": [1085]}, "283": {"vr": "US", "Value": [903]}, "284": {"vr": "US", "Value": [953]}, "285": {"vr": "US", "Value": [1015]}, "286": {"vr": "US", "Value": [973]}, "287": {"vr": "US", "Value": [1158]}, "288": {"vr": "US", "Value": [1859]}, "289": {"vr": "US", "Value": [3707]}, "290": {"vr": "US", "Value": [5886]}, "291": {"vr": "US", "Value": [7238]}, "292": {"vr": "US", "Value": [7337]}, "293": {"vr": "US", "Value": [7605]}, "294": {"vr": "US", "Value": [7229]}, "295": {"vr": "US", "Value": [7341]}, "296": {"vr": "US", "Value": [7385]}, "297": {"vr": "US", "Value": [7179]}, "298": {"vr": "US", "Value": [7154]}, "299": {"vr": "US", "Value": [7124]}, "300": {"vr": "US", "Value": [7017]}, "301": {"vr": "US", "Value": [7288]}, "302": {"vr": "US", "Value": [7206]}, "303": {"vr": "US", "Value": [6953]}, "304": {"vr": "US", "Value": [6998]}, "305": {"vr": "US", "Value": [6863]}, "306": {"vr": "US", "Value": [6750]}, "307": {"vr": "US", "Value": [7102]}, "308": {"vr": "US", "Value": [6507]}, "309": {"vr": "US", "Value": [6755]}, "310": {"vr": "US", "Value": [6974]}, "311": {"vr": "US", "Value": [6787]}, "312": {"vr": "US", "Value": [6820]}, "313": {"vr": "US", "Value": [6880]}, "314": {"vr": "US", "Value": [6626]}, "315": {"vr": "US", "Value": [6772]}, "316": {"vr": "US", "Value": [6756]}, "317": {"vr": "US", "Value": [6750]}, "318": {"vr": "US", "Value": [6557]}, "319": {"vr": "US", "Value": [6455]}, "320": {"vr": "US", "Value": [6725]}, "321": {"vr": "US", "Value": [6834]}, "322": {"vr": "US", "Value": [6750]}, "323": {"vr": "US", "Value": [6574]}, "324": {"vr": "US", "Value": [6754]}, "325": {"vr": "US", "Value": [6604]}, "326": {"vr": "US", "Value": [6541]}, "327": {"vr": "US", "Value": [6733]}, "328": {"vr": "US", "Value": [6603]}, "329": {"vr": "US", "Value": [6545]}, "330": {"vr": "US", "Value": [6388]}, "331": {"vr": "US", "Value": [6558]}, "332": {"vr": "US", "Value": [6967]}, "333": {"vr": "US", "Value": [6689]}, "334": {"vr": "US", "Value": [6746]}, "335": {"vr": "US", "Value": [6452]}, "336": {"vr": "US", "Value": [6600]}, "337": {"vr": "US", "Value": [6534]}, "338": {"vr": "US", "Value": [6513]}, "339": {"vr": "US", "Value": [6518]}, "340": {"vr": "US", "Value": [6840]}, "341": {"vr": "US", "Value": [6601]}, "342": {"vr": "US", "Value": [6444]}, "343": {"vr": "US", "Value": [6439]}, "344": {"vr": "US", "Value": [6459]}, "345": {"vr": "US", "Value": [6490]}, "346": {"vr": "US", "Value": [6565]}, "347": {"vr": "US", "Value": [6451]}, "348": {"vr": "US", "Value": [6416]}, "349": {"vr": "US", "Value": [6821]}, "350": {"vr": "US", "Value": [6794]}, "351": {"vr": "US", "Value": [6416]}, "352": {"vr": "US", "Value": [6593]}, "353": {"vr": "US", "Value": [6451]}, "354": {"vr": "US", "Value": [6480]}, "355": {"vr": "US", "Value": [6360]}, "356": {"vr": "US", "Value": [6370]}, "357": {"vr": "US", "Value": [6660]}, "358": {"vr": "US", "Value": [7013]}, "359": {"vr": "US", "Value": [6566]}, "360": {"vr": "US", "Value": [6299]}, "361": {"vr": "US", "Value": [6510]}, "362": {"vr": "US", "Value": [6576]}, "363": {"vr": "US", "Value": [6578]}, "364": {"vr": "US", "Value": [6416]}, "365": {"vr": "US", "Value": [6780]}, "366": {"vr": "US", "Value": [6833]}, "367": {"vr": "US", "Value": [6730]}, "368": {"vr": "US", "Value": [6733]}, "369": {"vr": "US", "Value": [6653]}, "370": {"vr": "US", "Value": [6895]}, "371": {"vr": "US", "Value": [6652]}, "372": {"vr": "US", "Value": [6566]}, "373": {"vr": "US", "Value": [6748]}, "374": {"vr": "US", "Value": [6920]}, "375": {"vr": "US", "Value": [6567]}, "376": {"vr": "US", "Value": [6681]}, "377": {"vr": "US", "Value": [6592]}, "378": {"vr": "US", "Value": [6728]}, "379": {"vr": "US", "Value": [6908]}, "380": {"vr": "US", "Value": [6775]}, "381": {"vr": "US", "Value": [6773]}, "382": {"vr": "US", "Value": [6777]}, "383": {"vr": "US", "Value": [6892]}, "384": {"vr": "US", "Value": [6697]}, "385": {"vr": "US", "Value": [6548]}, "386": {"vr": "US", "Value": [6474]}, "387": {"vr": "US", "Value": [6657]}, "388": {"vr": "US", "Value": [6743]}, "389": {"vr": "US", "Value": [6554]}, "390": {"vr": "US", "Value": [6738]}, "391": {"vr": "US", "Value": [6637]}, "392": {"vr": "US", "Value": [6598]}, "393": {"vr": "US", "Value": [6894]}, "394": {"vr": "US", "Value": [6664]}, "395": {"vr": "US", "Value": [6931]}, "396": {"vr": "US", "Value": [7109]}, "397": {"vr": "US", "Value": [7150]}, "398": {"vr": "US", "Value": [6760]}, "399": {"vr": "US", "Value": [6631]}, "400": {"vr": "US", "Value": [7074]}, "401": {"vr": "US", "Value": [6847]}, "402": {"vr": "US", "Value": [6953]}, "403": {"vr": "US", "Value": [6819]}, "404": {"vr": "US", "Value": [6781]}, "405": {"vr": "US", "Value": [7020]}, "406": {"vr": "US", "Value": [7871]}, "407": {"vr": "US", "Value": [7454]}, "408": {"vr": "US", "Value": [6819]}, "409": {"vr": "US", "Value": [6843]}, "410": {"vr": "US", "Value": [6613]}, "411": {"vr": "US", "Value": [6791]}, "412": {"vr": "US", "Value": [6572]}, "413": {"vr": "US", "Value": [6909]}, "414": {"vr": "US", "Value": [7098]}, "415": {"vr": "US", "Value": [6643]}, "416": {"vr": "US", "Value": [6613]}, "417": {"vr": "US", "Value": [6938]}, "418": {"vr": "US", "Value": [6907]}, "419": {"vr": "US", "Value": [7026]}, "420": {"vr": "US", "Value": [7110]}, "421": {"vr": "US", "Value": [7151]}, "422": {"vr": "US", "Value": [6946]}, "423": {"vr": "US", "Value": [7492]}, "424": {"vr": "US", "Value": [6881]}, "425": {"vr": "US", "Value": [7172]}, "426": {"vr": "US", "Value": [7017]}, "427": {"vr": "US", "Value": [7589]}, "428": {"vr": "US", "Value": [7484]}, "429": {"vr": "US", "Value": [7545]}, "430": {"vr": "US", "Value": [7774]}, "431": {"vr": "US", "Value": [7778]}, "432": {"vr": "US", "Value": [8167]}, "433": {"vr": "US", "Value": [7636]}, "434": {"vr": "US", "Value": [7824]}, "435": {"vr": "US", "Value": [8008]}, "436": {"vr": "US", "Value": [7133]}, "437": {"vr": "US", "Value": [4547]}, "438": {"vr": "US", "Value": [2083]}, "439": {"vr": "US", "Value": [1412]}, "440": {"vr": "US", "Value": [1867]}, "441": {"vr": "US", "Value": [1839]}, "442": {"vr": "US", "Value": [1949]}, "443": {"vr": "US", "Value": [1613]}, "444": {"vr": "US", "Value": [2005]}, "445": {"vr": "US", "Value": [2186]}, "446": {"vr": "US", "Value": [2310]}, "447": {"vr": "US", "Value": [1671]}, "448": {"vr": "US", "Value": [1114]}, "449": {"vr": "US", "Value": [1201]}, "450": {"vr": "US", "Value": [1315]}, "451": {"vr": "US", "Value": [1050]}, "452": {"vr": "US", "Value": [1176]}, "453": {"vr": "US", "Value": [1057]}, "454": {"vr": "US", "Value": [1016]}, "455": {"vr": "US", "Value": [1117]}, "456": {"vr": "US", "Value": [1022]}, "457": {"vr": "US", "Value": [1088]}, "458": {"vr": "US", "Value": [892]}, "459": {"vr": "US", "Value": [1098]}, "460": {"vr": "US", "Value": [943]}, "461": {"vr": "US", "Value": [943]}, "462": {"vr": "US", "Value": [956]}, "463": {"vr": "US", "Value": [990]}, "464": {"vr": "US", "Value": [918]}, "465": {"vr": "US", "Value": [934]}, "466": {"vr": "US", "Value": [834]}, "467": {"vr": "US", "Value": [806]}, "468": {"vr": "US", "Value": [958]}, "469": {"vr": "US", "Value": [965]}, "470": {"vr": "US", "Value": [933]}, "471": {"vr": "US", "Value": [829]}, "472": {"vr": "US", "Value": [840]}, "473": {"vr": "US", "Value": [721]}, "474": {"vr": "US", "Value": [760]}, "475": {"vr": "US", "Value": [938]}, "476": {"vr": "US", "Value": [783]}, "477": {"vr": "US", "Value": [721]}, "478": {"vr": "US", "Value": [656]}, "479": {"vr": "US", "Value": [802]}, "480": {"vr": "US", "Value": [652]}, "481": {"vr": "US", "Value": [840]}, "482": {"vr": "US", "Value": [707]}, "483": {"vr": "US", "Value": [628]}, "484": {"vr": "US", "Value": [806]}, "485": {"vr": "US", "Value": [748]}, "486": {"vr": "US", "Value": [684]}, "487": {"vr": "US", "Value": [668]}, "488": {"vr": "US", "Value": [790]}, "489": {"vr": "US", "Value": [1247]}, "490": {"vr": "US", "Value": [778]}, "491": {"vr": "US", "Value": [663]}, "492": {"vr": "US", "Value": [814]}, "493": {"vr": "US", "Value": [748]}, "494": {"vr": "US", "Value": [744]}, "495": {"vr": "US", "Value": [719]}, "496": {"vr": "US", "Value": [864]}, "497": {"vr": "US", "Value": [756]}, "498": {"vr": "US", "Value": [702]}, "499": {"vr": "US", "Value": [814]}, "500": {"vr": "US", "Value": [686]}, "501": {"vr": "US", "Value": [573]}, "502": {"vr": "US", "Value": [990]}, "503": {"vr": "US", "Value": [1158]}, "504": {"vr": "US", "Value": [936]}, "505": {"vr": "US", "Value": [740]}, "506": {"vr": "US", "Value": [809]}, "507": {"vr": "US", "Value": [1326]}, "508": {"vr": "US", "Value": [960]}, "509": {"vr": "US", "Value": [889]}, "510": {"vr": "US", "Value": [1063]}, "511": {"vr": "US", "Value": [1071]}, "512": {"vr": "US", "Value": [927]}, "513": {"vr": "US", "Value": [1052]}, "514": {"vr": "US", "Value": [1724]}, "515": {"vr": "US", "Value": [881]}, "516": {"vr": "US", "Value": [1753]}, "517": {"vr": "US", "Value": [1513]}, "518": {"vr": "US", "Value": [1469]}, "519": {"vr": "US", "Value": [2098]}, "520": {"vr": "US", "Value": [2456]}, "521": {"vr": "US", "Value": [2044]}, "522": {"vr": "US", "Value": [2011]}, "523": {"vr": "US", "Value": [2012]}, "524": {"vr": "US", "Value": [3917]}, "525": {"vr": "US", "Value": [3578]}, "526": {"vr": "US", "Value": [9096]}, "527": {"vr": "US", "Value": [5167]}, "528": {"vr": "US", "Value": [8912]}, "529": {"vr": "US", "Value": [18126]}, "530": {"vr": "US", "Value": [32767]}}, "00281050": {"0": {"vr": "DS", "Value": [0.0]}, "1": {"vr": "DS", "Value": [0.0]}, "2": {"vr": "DS", "Value": [0.0]}, "3": {"vr": "DS", "Value": [0.0]}, "4": {"vr": "DS", "Value": [0.0]}, "5": {"vr": "DS", "Value": [0.0]}, "6": {"vr": "DS", "Value": [0.0]}, "7": {"vr": "DS", "Value": [0.0]}, "8": {"vr": "DS", "Value": [0.0]}, "9": {"vr": "DS", "Value": [0.0]}, "10": {"vr": "DS", "Value": [0.0]}, "11": {"vr": "DS", "Value": [0.0]}, "12": {"vr": "DS", "Value": [0.0]}, "13": {"vr": "DS", "Value": [0.0]}, "14": {"vr": "DS", "Value": [0.0]}, "15": {"vr": "DS", "Value": [0.0]}, "16": {"vr": "DS", "Value": [0.0]}, "17": {"vr": "DS", "Value": [0.0]}, "18": {"vr": "DS", "Value": [0.0]}, "19": {"vr": "DS", "Value": [0.0]}, "20": {"vr": "DS", "Value": [0.0]}, "21": {"vr": "DS", "Value": [0.0]}, "22": {"vr": "DS", "Value": [0.0]}, "23": {"vr": "DS", "Value": [0.0]}, "24": {"vr": "DS", "Value": [0.0]}, "25": {"vr": "DS", "Value": [0.0]}, "26": {"vr": "DS", "Value": [0.0]}, "27": {"vr": "DS", "Value": [0.0]}, "28": {"vr": "DS", "Value": [0.0]}, "29": {"vr": "DS", "Value": [0.0]}, "30": {"vr": "DS", "Value": [0.0]}, "31": {"vr": "DS", "Value": [0.0]}, "32": {"vr": "DS", "Value": [0.0]}, "33": {"vr": "DS", "Value": [0.0]}, "34": {"vr": "DS", "Value": [0.0]}, "35": {"vr": "DS", "Value": [0.0]}, "36": {"vr": "DS", "Value": [0.0]}, "37": {"vr": "DS", "Value": [0.0]}, "38": {"vr": "DS", "Value": [0.0]}, "39": {"vr": "DS", "Value": [0.0]}, "40": {"vr": "DS", "Value": [0.0]}, "41": {"vr": "DS", "Value": [0.0]}, "42": {"vr": "DS", "Value": [0.0]}, "43": {"vr": "DS", "Value": [0.0]}, "44": {"vr": "DS", "Value": [0.0]}, "45": {"vr": "DS", "Value": [0.0]}, "46": {"vr": "DS", "Value": [0.0]}, "47": {"vr": "DS", "Value": [0.0]}, "48": {"vr": "DS", "Value": [0.0]}, "49": {"vr": "DS", "Value": [0.0]}, "50": {"vr": "DS", "Value": [0.0]}, "51": {"vr": "DS", "Value": [0.0]}, "52": {"vr": "DS", "Value": [0.0]}, "53": {"vr": "DS", "Value": [0.0]}, "54": {"vr": "DS", "Value": [0.0]}, "55": {"vr": "DS", "Value": [0.0]}, "56": {"vr": "DS", "Value": [0.0]}, "57": {"vr": "DS", "Value": [0.0]}, "58": {"vr": "DS", "Value": [0.0]}, "59": {"vr": "DS", "Value": [0.0]}, "60": {"vr": "DS", "Value": [0.0]}, "61": {"vr": "DS", "Value": [0.0]}, "62": {"vr": "DS", "Value": [0.0]}, "63": {"vr": "DS", "Value": [0.0]}, "64": {"vr": "DS", "Value": [0.0]}, "65": {"vr": "DS", "Value": [0.0]}, "66": {"vr": "DS", "Value": [0.0]}, "67": {"vr": "DS", "Value": [0.0]}, "68": {"vr": "DS", "Value": [0.0]}, "69": {"vr": "DS", "Value": [0.0]}, "70": {"vr": "DS", "Value": [0.0]}, "71": {"vr": "DS", "Value": [0.0]}, "72": {"vr": "DS", "Value": [0.0]}, "73": {"vr": "DS", "Value": [0.0]}, "74": {"vr": "DS", "Value": [0.0]}, "75": {"vr": "DS", "Value": [0.0]}, "76": {"vr": "DS", "Value": [0.0]}, "77": {"vr": "DS", "Value": [0.0]}, "78": {"vr": "DS", "Value": [0.0]}, "79": {"vr": "DS", "Value": [0.0]}, "80": {"vr": "DS", "Value": [0.0]}, "81": {"vr": "DS", "Value": [0.0]}, "82": {"vr": "DS", "Value": [0.0]}, "83": {"vr": "DS", "Value": [0.0]}, "84": {"vr": "DS", "Value": [0.0]}, "85": {"vr": "DS", "Value": [0.0]}, "86": {"vr": "DS", "Value": [0.0]}, "87": {"vr": "DS", "Value": [0.0]}, "88": {"vr": "DS", "Value": [0.0]}, "89": {"vr": "DS", "Value": [0.0]}, "90": {"vr": "DS", "Value": [0.0]}, "91": {"vr": "DS", "Value": [0.0]}, "92": {"vr": "DS", "Value": [0.0]}, "93": {"vr": "DS", "Value": [0.0]}, "94": {"vr": "DS", "Value": [0.0]}, "95": {"vr": "DS", "Value": [0.0]}, "96": {"vr": "DS", "Value": [0.0]}, "97": {"vr": "DS", "Value": [0.0]}, "98": {"vr": "DS", "Value": [0.0]}, "99": {"vr": "DS", "Value": [0.0]}, "100": {"vr": "DS", "Value": [0.0]}, "101": {"vr": "DS", "Value": [0.0]}, "102": {"vr": "DS", "Value": [0.0]}, "103": {"vr": "DS", "Value": [0.0]}, "104": {"vr": "DS", "Value": [0.0]}, "105": {"vr": "DS", "Value": [0.0]}, "106": {"vr": "DS", "Value": [0.0]}, "107": {"vr": "DS", "Value": [0.0]}, "108": {"vr": "DS", "Value": [0.0]}, "109": {"vr": "DS", "Value": [0.0]}, "110": {"vr": "DS", "Value": [0.0]}, "111": {"vr": "DS", "Value": [0.0]}, "112": {"vr": "DS", "Value": [0.0]}, "113": {"vr": "DS", "Value": [0.0]}, "114": {"vr": "DS", "Value": [0.0]}, "115": {"vr": "DS", "Value": [0.0]}, "116": {"vr": "DS", "Value": [0.0]}, "117": {"vr": "DS", "Value": [0.0]}, "118": {"vr": "DS", "Value": [0.0]}, "119": {"vr": "DS", "Value": [0.0]}, "120": {"vr": "DS", "Value": [0.0]}, "121": {"vr": "DS", "Value": [0.0]}, "122": {"vr": "DS", "Value": [0.0]}, "123": {"vr": "DS", "Value": [0.0]}, "124": {"vr": "DS", "Value": [0.0]}, "125": {"vr": "DS", "Value": [0.0]}, "126": {"vr": "DS", "Value": [1.0]}, "127": {"vr": "DS", "Value": [3.0]}, "128": {"vr": "DS", "Value": [13.0]}, "129": {"vr": "DS", "Value": [6.0]}, "130": {"vr": "DS", "Value": [3.0]}, "131": {"vr": "DS", "Value": [6.0]}, "132": {"vr": "DS", "Value": [7.0]}, "133": {"vr": "DS", "Value": [12.0]}, "134": {"vr": "DS", "Value": [18.0]}, "135": {"vr": "DS", "Value": [27.0]}, "136": {"vr": "DS", "Value": [16.0]}, "137": {"vr": "DS", "Value": [32.0]}, "138": {"vr": "DS", "Value": [37.0]}, "139": {"vr": "DS", "Value": [27.0]}, "140": {"vr": "DS", "Value": [38.0]}, "141": {"vr": "DS", "Value": [34.0]}, "142": {"vr": "DS", "Value": [18.0]}, "143": {"vr": "DS", "Value": [16.0]}, "144": {"vr": "DS", "Value": [21.0]}, "145": {"vr": "DS", "Value": [24.0]}, "146": {"vr": "DS", "Value": [25.0]}, "147": {"vr": "DS", "Value": [38.0]}, "148": {"vr": "DS", "Value": [37.0]}, "149": {"vr": "DS", "Value": [28.0]}, "150": {"vr": "DS", "Value": [35.0]}, "151": {"vr": "DS", "Value": [29.0]}, "152": {"vr": "DS", "Value": [41.0]}, "153": {"vr": "DS", "Value": [39.0]}, "154": {"vr": "DS", "Value": [33.0]}, "155": {"vr": "DS", "Value": [27.0]}, "156": {"vr": "DS", "Value": [28.0]}, "157": {"vr": "DS", "Value": [21.0]}, "158": {"vr": "DS", "Value": [27.0]}, "159": {"vr": "DS", "Value": [22.0]}, "160": {"vr": "DS", "Value": [19.0]}, "161": {"vr": "DS", "Value": [41.0]}, "162": {"vr": "DS", "Value": [52.0]}, "163": {"vr": "DS", "Value": [31.0]}, "164": {"vr": "DS", "Value": [33.0]}, "165": {"vr": "DS", "Value": [30.0]}, "166": {"vr": "DS", "Value": [32.0]}, "167": {"vr": "DS", "Value": [27.0]}, "168": {"vr": "DS", "Value": [33.0]}, "169": {"vr": "DS", "Value": [25.0]}, "170": {"vr": "DS", "Value": [33.0]}, "171": {"vr": "DS", "Value": [33.0]}, "172": {"vr": "DS", "Value": [28.0]}, "173": {"vr": "DS", "Value": [23.0]}, "174": {"vr": "DS", "Value": [25.0]}, "175": {"vr": "DS", "Value": [35.0]}, "176": {"vr": "DS", "Value": [24.0]}, "177": {"vr": "DS", "Value": [32.0]}, "178": {"vr": "DS", "Value": [36.0]}, "179": {"vr": "DS", "Value": [28.0]}, "180": {"vr": "DS", "Value": [23.0]}, "181": {"vr": "DS", "Value": [34.0]}, "182": {"vr": "DS", "Value": [28.0]}, "183": {"vr": "DS", "Value": [20.0]}, "184": {"vr": "DS", "Value": [28.0]}, "185": {"vr": "DS", "Value": [30.0]}, "186": {"vr": "DS", "Value": [23.0]}, "187": {"vr": "DS", "Value": [26.0]}, "188": {"vr": "DS", "Value": [22.0]}, "189": {"vr": "DS", "Value": [30.0]}, "190": {"vr": "DS", "Value": [37.0]}, "191": {"vr": "DS", "Value": [35.0]}, "192": {"vr": "DS", "Value": [27.0]}, "193": {"vr": "DS", "Value": [25.0]}, "194": {"vr": "DS", "Value": [27.0]}, "195": {"vr": "DS", "Value": [27.0]}, "196": {"vr": "DS", "Value": [26.0]}, "197": {"vr": "DS", "Value": [26.0]}, "198": {"vr": "DS", "Value": [22.0]}, "199": {"vr": "DS", "Value": [33.0]}, "200": {"vr": "DS", "Value": [37.0]}, "201": {"vr": "DS", "Value": [27.0]}, "202": {"vr": "DS", "Value": [30.0]}, "203": {"vr": "DS", "Value": [33.0]}, "204": {"vr": "DS", "Value": [24.0]}, "205": {"vr": "DS", "Value": [29.0]}, "206": {"vr": "DS", "Value": [37.0]}, "207": {"vr": "DS", "Value": [37.0]}, "208": {"vr": "DS", "Value": [27.0]}, "209": {"vr": "DS", "Value": [52.0]}, "210": {"vr": "DS", "Value": [50.0]}, "211": {"vr": "DS", "Value": [29.0]}, "212": {"vr": "DS", "Value": [33.0]}, "213": {"vr": "DS", "Value": [58.0]}, "214": {"vr": "DS", "Value": [49.0]}, "215": {"vr": "DS", "Value": [32.0]}, "216": {"vr": "DS", "Value": [30.0]}, "217": {"vr": "DS", "Value": [35.0]}, "218": {"vr": "DS", "Value": [30.0]}, "219": {"vr": "DS", "Value": [34.0]}, "220": {"vr": "DS", "Value": [33.0]}, "221": {"vr": "DS", "Value": [36.0]}, "222": {"vr": "DS", "Value": [30.0]}, "223": {"vr": "DS", "Value": [37.0]}, "224": {"vr": "DS", "Value": [49.0]}, "225": {"vr": "DS", "Value": [40.0]}, "226": {"vr": "DS", "Value": [34.0]}, "227": {"vr": "DS", "Value": [34.0]}, "228": {"vr": "DS", "Value": [45.0]}, "229": {"vr": "DS", "Value": [69.0]}, "230": {"vr": "DS", "Value": [67.0]}, "231": {"vr": "DS", "Value": [47.0]}, "232": {"vr": "DS", "Value": [51.0]}, "233": {"vr": "DS", "Value": [80.0]}, "234": {"vr": "DS", "Value": [50.0]}, "235": {"vr": "DS", "Value": [44.0]}, "236": {"vr": "DS", "Value": [54.0]}, "237": {"vr": "DS", "Value": [60.0]}, "238": {"vr": "DS", "Value": [59.0]}, "239": {"vr": "DS", "Value": [58.0]}, "240": {"vr": "DS", "Value": [61.0]}, "241": {"vr": "DS", "Value": [68.0]}, "242": {"vr": "DS", "Value": [66.0]}, "243": {"vr": "DS", "Value": [70.0]}, "244": {"vr": "DS", "Value": [68.0]}, "245": {"vr": "DS", "Value": [91.0]}, "246": {"vr": "DS", "Value": [89.0]}, "247": {"vr": "DS", "Value": [98.0]}, "248": {"vr": "DS", "Value": [84.0]}, "249": {"vr": "DS", "Value": [77.0]}, "250": {"vr": "DS", "Value": [89.0]}, "251": {"vr": "DS", "Value": [138.0]}, "252": {"vr": "DS", "Value": [95.0]}, "253": {"vr": "DS", "Value": [96.0]}, "254": {"vr": "DS", "Value": [117.0]}, "255": {"vr": "DS", "Value": [138.0]}, "256": {"vr": "DS", "Value": [104.0]}, "257": {"vr": "DS", "Value": [102.0]}, "258": {"vr": "DS", "Value": [122.0]}, "259": {"vr": "DS", "Value": [120.0]}, "260": {"vr": "DS", "Value": [132.0]}, "261": {"vr": "DS", "Value": [124.0]}, "262": {"vr": "DS", "Value": [124.0]}, "263": {"vr": "DS", "Value": [136.0]}, "264": {"vr": "DS", "Value": [167.0]}, "265": {"vr": "DS", "Value": [154.0]}, "266": {"vr": "DS", "Value": [135.0]}, "267": {"vr": "DS", "Value": [145.0]}, "268": {"vr": "DS", "Value": [152.0]}, "269": {"vr": "DS", "Value": [172.0]}, "270": {"vr": "DS", "Value": [195.0]}, "271": {"vr": "DS", "Value": [165.0]}, "272": {"vr": "DS", "Value": [159.0]}, "273": {"vr": "DS", "Value": [189.0]}, "274": {"vr": "DS", "Value": [188.0]}, "275": {"vr": "DS", "Value": [194.0]}, "276": {"vr": "DS", "Value": [181.0]}, "277": {"vr": "DS", "Value": [183.0]}, "278": {"vr": "DS", "Value": [193.0]}, "279": {"vr": "DS", "Value": [216.0]}, "280": {"vr": "DS", "Value": [218.0]}, "281": {"vr": "DS", "Value": [247.0]}, "282": {"vr": "DS", "Value": [270.0]}, "283": {"vr": "DS", "Value": [224.0]}, "284": {"vr": "DS", "Value": [237.0]}, "285": {"vr": "DS", "Value": [252.0]}, "286": {"vr": "DS", "Value": [242.0]}, "287": {"vr": "DS", "Value": [288.0]}, "288": {"vr": "DS", "Value": [462.0]}, "289": {"vr": "DS", "Value": [921.0]}, "290": {"vr": "DS", "Value": [1463.0]}, "291": {"vr": "DS", "Value": [1799.0]}, "292": {"vr": "DS", "Value": [1823.0]}, "293": {"vr": "DS", "Value": [1890.0]}, "294": {"vr": "DS", "Value": [1796.0]}, "295": {"vr": "DS", "Value": [1824.0]}, "296": {"vr": "DS", "Value": [1835.0]}, "297": {"vr": "DS", "Value": [1784.0]}, "298": {"vr": "DS", "Value": [1778.0]}, "299": {"vr": "DS", "Value": [1770.0]}, "300": {"vr": "DS", "Value": [1744.0]}, "301": {"vr": "DS", "Value": [1811.0]}, "302": {"vr": "DS", "Value": [1791.0]}, "303": {"vr": "DS", "Value": [1728.0]}, "304": {"vr": "DS", "Value": [1739.0]}, "305": {"vr": "DS", "Value": [1705.0]}, "306": {"vr": "DS", "Value": [1677.0]}, "307": {"vr": "DS", "Value": [1765.0]}, "308": {"vr": "DS", "Value": [1617.0]}, "309": {"vr": "DS", "Value": [1679.0]}, "310": {"vr": "DS", "Value": [1733.0]}, "311": {"vr": "DS", "Value": [1687.0]}, "312": {"vr": "DS", "Value": [1695.0]}, "313": {"vr": "DS", "Value": [1710.0]}, "314": {"vr": "DS", "Value": [1647.0]}, "315": {"vr": "DS", "Value": [1683.0]}, "316": {"vr": "DS", "Value": [1679.0]}, "317": {"vr": "DS", "Value": [1677.0]}, "318": {"vr": "DS", "Value": [1629.0]}, "319": {"vr": "DS", "Value": [1604.0]}, "320": {"vr": "DS", "Value": [1671.0]}, "321": {"vr": "DS", "Value": [1698.0]}, "322": {"vr": "DS", "Value": [1677.0]}, "323": {"vr": "DS", "Value": [1634.0]}, "324": {"vr": "DS", "Value": [1678.0]}, "325": {"vr": "DS", "Value": [1641.0]}, "326": {"vr": "DS", "Value": [1625.0]}, "327": {"vr": "DS", "Value": [1673.0]}, "328": {"vr": "DS", "Value": [1641.0]}, "329": {"vr": "DS", "Value": [1626.0]}, "330": {"vr": "DS", "Value": [1587.0]}, "331": {"vr": "DS", "Value": [1630.0]}, "332": {"vr": "DS", "Value": [1731.0]}, "333": {"vr": "DS", "Value": [1662.0]}, "334": {"vr": "DS", "Value": [1676.0]}, "335": {"vr": "DS", "Value": [1603.0]}, "336": {"vr": "DS", "Value": [1640.0]}, "337": {"vr": "DS", "Value": [1624.0]}, "338": {"vr": "DS", "Value": [1618.0]}, "339": {"vr": "DS", "Value": [1620.0]}, "340": {"vr": "DS", "Value": [1700.0]}, "341": {"vr": "DS", "Value": [1640.0]}, "342": {"vr": "DS", "Value": [1601.0]}, "343": {"vr": "DS", "Value": [1600.0]}, "344": {"vr": "DS", "Value": [1605.0]}, "345": {"vr": "DS", "Value": [1613.0]}, "346": {"vr": "DS", "Value": [1631.0]}, "347": {"vr": "DS", "Value": [1603.0]}, "348": {"vr": "DS", "Value": [1594.0]}, "349": {"vr": "DS", "Value": [1695.0]}, "350": {"vr": "DS", "Value": [1688.0]}, "351": {"vr": "DS", "Value": [1594.0]}, "352": {"vr": "DS", "Value": [1638.0]}, "353": {"vr": "DS", "Value": [1603.0]}, "354": {"vr": "DS", "Value": [1610.0]}, "355": {"vr": "DS", "Value": [1580.0]}, "356": {"vr": "DS", "Value": [1583.0]}, "357": {"vr": "DS", "Value": [1655.0]}, "358": {"vr": "DS", "Value": [1743.0]}, "359": {"vr": "DS", "Value": [1632.0]}, "360": {"vr": "DS", "Value": [1565.0]}, "361": {"vr": "DS", "Value": [1618.0]}, "362": {"vr": "DS", "Value": [1634.0]}, "363": {"vr": "DS", "Value": [1635.0]}, "364": {"vr": "DS", "Value": [1594.0]}, "365": {"vr": "DS", "Value": [1685.0]}, "366": {"vr": "DS", "Value": [1698.0]}, "367": {"vr": "DS", "Value": [1672.0]}, "368": {"vr": "DS", "Value": [1673.0]}, "369": {"vr": "DS", "Value": [1653.0]}, "370": {"vr": "DS", "Value": [1713.0]}, "371": {"vr": "DS", "Value": [1653.0]}, "372": {"vr": "DS", "Value": [1632.0]}, "373": {"vr": "DS", "Value": [1677.0]}, "374": {"vr": "DS", "Value": [1720.0]}, "375": {"vr": "DS", "Value": [1632.0]}, "376": {"vr": "DS", "Value": [1660.0]}, "377": {"vr": "DS", "Value": [1638.0]}, "378": {"vr": "DS", "Value": [1672.0]}, "379": {"vr": "DS", "Value": [1717.0]}, "380": {"vr": "DS", "Value": [1684.0]}, "381": {"vr": "DS", "Value": [1683.0]}, "382": {"vr": "DS", "Value": [1684.0]}, "383": {"vr": "DS", "Value": [1713.0]}, "384": {"vr": "DS", "Value": [1664.0]}, "385": {"vr": "DS", "Value": [1627.0]}, "386": {"vr": "DS", "Value": [1609.0]}, "387": {"vr": "DS", "Value": [1654.0]}, "388": {"vr": "DS", "Value": [1676.0]}, "389": {"vr": "DS", "Value": [1629.0]}, "390": {"vr": "DS", "Value": [1674.0]}, "391": {"vr": "DS", "Value": [1649.0]}, "392": {"vr": "DS", "Value": [1640.0]}, "393": {"vr": "DS", "Value": [1713.0]}, "394": {"vr": "DS", "Value": [1656.0]}, "395": {"vr": "DS", "Value": [1722.0]}, "396": {"vr": "DS", "Value": [1767.0]}, "397": {"vr": "DS", "Value": [1777.0]}, "398": {"vr": "DS", "Value": [1680.0]}, "399": {"vr": "DS", "Value": [1648.0]}, "400": {"vr": "DS", "Value": [1758.0]}, "401": {"vr": "DS", "Value": [1701.0]}, "402": {"vr": "DS", "Value": [1728.0]}, "403": {"vr": "DS", "Value": [1694.0]}, "404": {"vr": "DS", "Value": [1685.0]}, "405": {"vr": "DS", "Value": [1744.0]}, "406": {"vr": "DS", "Value": [1956.0]}, "407": {"vr": "DS", "Value": [1852.0]}, "408": {"vr": "DS", "Value": [1694.0]}, "409": {"vr": "DS", "Value": [1700.0]}, "410": {"vr": "DS", "Value": [1643.0]}, "411": {"vr": "DS", "Value": [1688.0]}, "412": {"vr": "DS", "Value": [1633.0]}, "413": {"vr": "DS", "Value": [1717.0]}, "414": {"vr": "DS", "Value": [1764.0]}, "415": {"vr": "DS", "Value": [1651.0]}, "416": {"vr": "DS", "Value": [1643.0]}, "417": {"vr": "DS", "Value": [1724.0]}, "418": {"vr": "DS", "Value": [1716.0]}, "419": {"vr": "DS", "Value": [1746.0]}, "420": {"vr": "DS", "Value": [1767.0]}, "421": {"vr": "DS", "Value": [1777.0]}, "422": {"vr": "DS", "Value": [1726.0]}, "423": {"vr": "DS", "Value": [1862.0]}, "424": {"vr": "DS", "Value": [1710.0]}, "425": {"vr": "DS", "Value": [1782.0]}, "426": {"vr": "DS", "Value": [1744.0]}, "427": {"vr": "DS", "Value": [1886.0]}, "428": {"vr": "DS", "Value": [1860.0]}, "429": {"vr": "DS", "Value": [1875.0]}, "430": {"vr": "DS", "Value": [1932.0]}, "431": {"vr": "DS", "Value": [1933.0]}, "432": {"vr": "DS", "Value": [2029.0]}, "433": {"vr": "DS", "Value": [1898.0]}, "434": {"vr": "DS", "Value": [1944.0]}, "435": {"vr": "DS", "Value": [1990.0]}, "436": {"vr": "DS", "Value": [1773.0]}, "437": {"vr": "DS", "Value": [1130.0]}, "438": {"vr": "DS", "Value": [518.0]}, "439": {"vr": "DS", "Value": [351.0]}, "440": {"vr": "DS", "Value": [464.0]}, "441": {"vr": "DS", "Value": [457.0]}, "442": {"vr": "DS", "Value": [484.0]}, "443": {"vr": "DS", "Value": [401.0]}, "444": {"vr": "DS", "Value": [498.0]}, "445": {"vr": "DS", "Value": [543.0]}, "446": {"vr": "DS", "Value": [574.0]}, "447": {"vr": "DS", "Value": [415.0]}, "448": {"vr": "DS", "Value": [277.0]}, "449": {"vr": "DS", "Value": [298.0]}, "450": {"vr": "DS", "Value": [327.0]}, "451": {"vr": "DS", "Value": [261.0]}, "452": {"vr": "DS", "Value": [292.0]}, "453": {"vr": "DS", "Value": [263.0]}, "454": {"vr": "DS", "Value": [252.0]}, "455": {"vr": "DS", "Value": [278.0]}, "456": {"vr": "DS", "Value": [254.0]}, "457": {"vr": "DS", "Value": [270.0]}, "458": {"vr": "DS", "Value": [222.0]}, "459": {"vr": "DS", "Value": [273.0]}, "460": {"vr": "DS", "Value": [234.0]}, "461": {"vr": "DS", "Value": [234.0]}, "462": {"vr": "DS", "Value": [238.0]}, "463": {"vr": "DS", "Value": [246.0]}, "464": {"vr": "DS", "Value": [228.0]}, "465": {"vr": "DS", "Value": [232.0]}, "466": {"vr": "DS", "Value": [207.0]}, "467": {"vr": "DS", "Value": [200.0]}, "468": {"vr": "DS", "Value": [238.0]}, "469": {"vr": "DS", "Value": [240.0]}, "470": {"vr": "DS", "Value": [232.0]}, "471": {"vr": "DS", "Value": [206.0]}, "472": {"vr": "DS", "Value": [209.0]}, "473": {"vr": "DS", "Value": [179.0]}, "474": {"vr": "DS", "Value": [189.0]}, "475": {"vr": "DS", "Value": [233.0]}, "476": {"vr": "DS", "Value": [195.0]}, "477": {"vr": "DS", "Value": [179.0]}, "478": {"vr": "DS", "Value": [163.0]}, "479": {"vr": "DS", "Value": [199.0]}, "480": {"vr": "DS", "Value": [162.0]}, "481": {"vr": "DS", "Value": [209.0]}, "482": {"vr": "DS", "Value": [176.0]}, "483": {"vr": "DS", "Value": [156.0]}, "484": {"vr": "DS", "Value": [200.0]}, "485": {"vr": "DS", "Value": [186.0]}, "486": {"vr": "DS", "Value": [170.0]}, "487": {"vr": "DS", "Value": [166.0]}, "488": {"vr": "DS", "Value": [196.0]}, "489": {"vr": "DS", "Value": [310.0]}, "490": {"vr": "DS", "Value": [193.0]}, "491": {"vr": "DS", "Value": [165.0]}, "492": {"vr": "DS", "Value": [202.0]}, "493": {"vr": "DS", "Value": [186.0]}, "494": {"vr": "DS", "Value": [185.0]}, "495": {"vr": "DS", "Value": [179.0]}, "496": {"vr": "DS", "Value": [215.0]}, "497": {"vr": "DS", "Value": [188.0]}, "498": {"vr": "DS", "Value": [174.0]}, "499": {"vr": "DS", "Value": [202.0]}, "500": {"vr": "DS", "Value": [170.0]}, "501": {"vr": "DS", "Value": [142.0]}, "502": {"vr": "DS", "Value": [246.0]}, "503": {"vr": "DS", "Value": [288.0]}, "504": {"vr": "DS", "Value": [233.0]}, "505": {"vr": "DS", "Value": [184.0]}, "506": {"vr": "DS", "Value": [201.0]}, "507": {"vr": "DS", "Value": [330.0]}, "508": {"vr": "DS", "Value": [239.0]}, "509": {"vr": "DS", "Value": [221.0]}, "510": {"vr": "DS", "Value": [264.0]}, "511": {"vr": "DS", "Value": [266.0]}, "512": {"vr": "DS", "Value": [230.0]}, "513": {"vr": "DS", "Value": [261.0]}, "514": {"vr": "DS", "Value": [428.0]}, "515": {"vr": "DS", "Value": [219.0]}, "516": {"vr": "DS", "Value": [436.0]}, "517": {"vr": "DS", "Value": [376.0]}, "518": {"vr": "DS", "Value": [365.0]}, "519": {"vr": "DS", "Value": [521.0]}, "520": {"vr": "DS", "Value": [610.0]}, "521": {"vr": "DS", "Value": [508.0]}, "522": {"vr": "DS", "Value": [500.0]}, "523": {"vr": "DS", "Value": [500.0]}, "524": {"vr": "DS", "Value": [973.0]}, "525": {"vr": "DS", "Value": [889.0]}, "526": {"vr": "DS", "Value": [2260.0]}, "527": {"vr": "DS", "Value": [1284.0]}, "528": {"vr": "DS", "Value": [2215.0]}, "529": {"vr": "DS", "Value": [4504.0]}, "530": {"vr": "DS", "Value": [8142.0]}}, "00281051": {"0": {"vr": "DS", "Value": [1.0]}, "1": {"vr": "DS", "Value": [1.0]}, "2": {"vr": "DS", "Value": [1.0]}, "3": {"vr": "DS", "Value": [1.0]}, "4": {"vr": "DS", "Value": [1.0]}, "5": {"vr": "DS", "Value": [1.0]}, "6": {"vr": "DS", "Value": [1.0]}, "7": {"vr": "DS", "Value": [1.0]}, "8": {"vr": "DS", "Value": [1.0]}, "9": {"vr": "DS", "Value": [1.0]}, "10": {"vr": "DS", "Value": [1.0]}, "11": {"vr": "DS", "Value": [1.0]}, "12": {"vr": "DS", "Value": [1.0]}, "13": {"vr": "DS", "Value": [1.0]}, "14": {"vr": "DS", "Value": [1.0]}, "15": {"vr": "DS", "Value": [1.0]}, "16": {"vr": "DS", "Value": [1.0]}, "17": {"vr": "DS", "Value": [1.0]}, "18": {"vr": "DS", "Value": [1.0]}, "19": {"vr": "DS", "Value": [1.0]}, "20": {"vr": "DS", "Value": [1.0]}, "21": {"vr": "DS", "Value": [1.0]}, "22": {"vr": "DS", "Value": [1.0]}, "23": {"vr": "DS", "Value": [1.0]}, "24": {"vr": "DS", "Value": [1.0]}, "25": {"vr": "DS", "Value": [1.0]}, "26": {"vr": "DS", "Value": [1.0]}, "27": {"vr": "DS", "Value": [1.0]}, "28": {"vr": "DS", "Value": [1.0]}, "29": {"vr": "DS", "Value": [1.0]}, "30": {"vr": "DS", "Value": [1.0]}, "31": {"vr": "DS", "Value": [1.0]}, "32": {"vr": "DS", "Value": [1.0]}, "33": {"vr": "DS", "Value": [1.0]}, "34": {"vr": "DS", "Value": [1.0]}, "35": {"vr": "DS", "Value": [1.0]}, "36": {"vr": "DS", "Value": [1.0]}, "37": {"vr": "DS", "Value": [1.0]}, "38": {"vr": "DS", "Value": [1.0]}, "39": {"vr": "DS", "Value": [1.0]}, "40": {"vr": "DS", "Value": [1.0]}, "41": {"vr": "DS", "Value": [1.0]}, "42": {"vr": "DS", "Value": [1.0]}, "43": {"vr": "DS", "Value": [1.0]}, "44": {"vr": "DS", "Value": [1.0]}, "45": {"vr": "DS", "Value": [1.0]}, "46": {"vr": "DS", "Value": [1.0]}, "47": {"vr": "DS", "Value": [1.0]}, "48": {"vr": "DS", "Value": [1.0]}, "49": {"vr": "DS", "Value": [1.0]}, "50": {"vr": "DS", "Value": [1.0]}, "51": {"vr": "DS", "Value": [1.0]}, "52": {"vr": "DS", "Value": [1.0]}, "53": {"vr": "DS", "Value": [1.0]}, "54": {"vr": "DS", "Value": [1.0]}, "55": {"vr": "DS", "Value": [1.0]}, "56": {"vr": "DS", "Value": [1.0]}, "57": {"vr": "DS", "Value": [1.0]}, "58": {"vr": "DS", "Value": [1.0]}, "59": {"vr": "DS", "Value": [1.0]}, "60": {"vr": "DS", "Value": [1.0]}, "61": {"vr": "DS", "Value": [1.0]}, "62": {"vr": "DS", "Value": [1.0]}, "63": {"vr": "DS", "Value": [1.0]}, "64": {"vr": "DS", "Value": [1.0]}, "65": {"vr": "DS", "Value": [1.0]}, "66": {"vr": "DS", "Value": [1.0]}, "67": {"vr": "DS", "Value": [1.0]}, "68": {"vr": "DS", "Value": [1.0]}, "69": {"vr": "DS", "Value": [1.0]}, "70": {"vr": "DS", "Value": [1.0]}, "71": {"vr": "DS", "Value": [1.0]}, "72": {"vr": "DS", "Value": [1.0]}, "73": {"vr": "DS", "Value": [1.0]}, "74": {"vr": "DS", "Value": [1.0]}, "75": {"vr": "DS", "Value": [1.0]}, "76": {"vr": "DS", "Value": [1.0]}, "77": {"vr": "DS", "Value": [1.0]}, "78": {"vr": "DS", "Value": [1.0]}, "79": {"vr": "DS", "Value": [1.0]}, "80": {"vr": "DS", "Value": [1.0]}, "81": {"vr": "DS", "Value": [1.0]}, "82": {"vr": "DS", "Value": [1.0]}, "83": {"vr": "DS", "Value": [1.0]}, "84": {"vr": "DS", "Value": [1.0]}, "85": {"vr": "DS", "Value": [1.0]}, "86": {"vr": "DS", "Value": [1.0]}, "87": {"vr": "DS", "Value": [1.0]}, "88": {"vr": "DS", "Value": [1.0]}, "89": {"vr": "DS", "Value": [1.0]}, "90": {"vr": "DS", "Value": [1.0]}, "91": {"vr": "DS", "Value": [1.0]}, "92": {"vr": "DS", "Value": [1.0]}, "93": {"vr": "DS", "Value": [1.0]}, "94": {"vr": "DS", "Value": [1.0]}, "95": {"vr": "DS", "Value": [1.0]}, "96": {"vr": "DS", "Value": [1.0]}, "97": {"vr": "DS", "Value": [1.0]}, "98": {"vr": "DS", "Value": [1.0]}, "99": {"vr": "DS", "Value": [1.0]}, "100": {"vr": "DS", "Value": [1.0]}, "101": {"vr": "DS", "Value": [1.0]}, "102": {"vr": "DS", "Value": [1.0]}, "103": {"vr": "DS", "Value": [1.0]}, "104": {"vr": "DS", "Value": [1.0]}, "105": {"vr": "DS", "Value": [1.0]}, "106": {"vr": "DS", "Value": [1.0]}, "107": {"vr": "DS", "Value": [1.0]}, "108": {"vr": "DS", "Value": [1.0]}, "109": {"vr": "DS", "Value": [1.0]}, "110": {"vr": "DS", "Value": [1.0]}, "111": {"vr": "DS", "Value": [1.0]}, "112": {"vr": "DS", "Value": [1.0]}, "113": {"vr": "DS", "Value": [1.0]}, "114": {"vr": "DS", "Value": [1.0]}, "115": {"vr": "DS", "Value": [1.0]}, "116": {"vr": "DS", "Value": [1.0]}, "117": {"vr": "DS", "Value": [1.0]}, "118": {"vr": "DS", "Value": [1.0]}, "119": {"vr": "DS", "Value": [1.0]}, "120": {"vr": "DS", "Value": [1.0]}, "121": {"vr": "DS", "Value": [1.0]}, "122": {"vr": "DS", "Value": [1.0]}, "123": {"vr": "DS", "Value": [1.0]}, "124": {"vr": "DS", "Value": [1.0]}, "125": {"vr": "DS", "Value": [1.0]}, "126": {"vr": "DS", "Value": [1.0]}, "127": {"vr": "DS", "Value": [5.0]}, "128": {"vr": "DS", "Value": [25.0]}, "129": {"vr": "DS", "Value": [11.0]}, "130": {"vr": "DS", "Value": [6.0]}, "131": {"vr": "DS", "Value": [12.0]}, "132": {"vr": "DS", "Value": [14.0]}, "133": {"vr": "DS", "Value": [24.0]}, "134": {"vr": "DS", "Value": [36.0]}, "135": {"vr": "DS", "Value": [53.0]}, "136": {"vr": "DS", "Value": [31.0]}, "137": {"vr": "DS", "Value": [63.0]}, "138": {"vr": "DS", "Value": [74.0]}, "139": {"vr": "DS", "Value": [54.0]}, "140": {"vr": "DS", "Value": [76.0]}, "141": {"vr": "DS", "Value": [67.0]}, "142": {"vr": "DS", "Value": [36.0]}, "143": {"vr": "DS", "Value": [31.0]}, "144": {"vr": "DS", "Value": [41.0]}, "145": {"vr": "DS", "Value": [48.0]}, "146": {"vr": "DS", "Value": [50.0]}, "147": {"vr": "DS", "Value": [75.0]}, "148": {"vr": "DS", "Value": [73.0]}, "149": {"vr": "DS", "Value": [55.0]}, "150": {"vr": "DS", "Value": [70.0]}, "151": {"vr": "DS", "Value": [58.0]}, "152": {"vr": "DS", "Value": [81.0]}, "153": {"vr": "DS", "Value": [77.0]}, "154": {"vr": "DS", "Value": [66.0]}, "155": {"vr": "DS", "Value": [54.0]}, "156": {"vr": "DS", "Value": [55.0]}, "157": {"vr": "DS", "Value": [41.0]}, "158": {"vr": "DS", "Value": [53.0]}, "159": {"vr": "DS", "Value": [44.0]}, "160": {"vr": "DS", "Value": [38.0]}, "161": {"vr": "DS", "Value": [81.0]}, "162": {"vr": "DS", "Value": [103.0]}, "163": {"vr": "DS", "Value": [61.0]}, "164": {"vr": "DS", "Value": [65.0]}, "165": {"vr": "DS", "Value": [60.0]}, "166": {"vr": "DS", "Value": [64.0]}, "167": {"vr": "DS", "Value": [53.0]}, "168": {"vr": "DS", "Value": [66.0]}, "169": {"vr": "DS", "Value": [49.0]}, "170": {"vr": "DS", "Value": [65.0]}, "171": {"vr": "DS", "Value": [65.0]}, "172": {"vr": "DS", "Value": [55.0]}, "173": {"vr": "DS", "Value": [45.0]}, "174": {"vr": "DS", "Value": [49.0]}, "175": {"vr": "DS", "Value": [70.0]}, "176": {"vr": "DS", "Value": [47.0]}, "177": {"vr": "DS", "Value": [63.0]}, "178": {"vr": "DS", "Value": [71.0]}, "179": {"vr": "DS", "Value": [56.0]}, "180": {"vr": "DS", "Value": [46.0]}, "181": {"vr": "DS", "Value": [68.0]}, "182": {"vr": "DS", "Value": [55.0]}, "183": {"vr": "DS", "Value": [40.0]}, "184": {"vr": "DS", "Value": [56.0]}, "185": {"vr": "DS", "Value": [60.0]}, "186": {"vr": "DS", "Value": [45.0]}, "187": {"vr": "DS", "Value": [52.0]}, "188": {"vr": "DS", "Value": [43.0]}, "189": {"vr": "DS", "Value": [59.0]}, "190": {"vr": "DS", "Value": [74.0]}, "191": {"vr": "DS", "Value": [69.0]}, "192": {"vr": "DS", "Value": [54.0]}, "193": {"vr": "DS", "Value": [50.0]}, "194": {"vr": "DS", "Value": [53.0]}, "195": {"vr": "DS", "Value": [54.0]}, "196": {"vr": "DS", "Value": [52.0]}, "197": {"vr": "DS", "Value": [52.0]}, "198": {"vr": "DS", "Value": [43.0]}, "199": {"vr": "DS", "Value": [65.0]}, "200": {"vr": "DS", "Value": [73.0]}, "201": {"vr": "DS", "Value": [53.0]}, "202": {"vr": "DS", "Value": [59.0]}, "203": {"vr": "DS", "Value": [66.0]}, "204": {"vr": "DS", "Value": [48.0]}, "205": {"vr": "DS", "Value": [58.0]}, "206": {"vr": "DS", "Value": [73.0]}, "207": {"vr": "DS", "Value": [73.0]}, "208": {"vr": "DS", "Value": [54.0]}, "209": {"vr": "DS", "Value": [104.0]}, "210": {"vr": "DS", "Value": [100.0]}, "211": {"vr": "DS", "Value": [57.0]}, "212": {"vr": "DS", "Value": [66.0]}, "213": {"vr": "DS", "Value": [115.0]}, "214": {"vr": "DS", "Value": [98.0]}, "215": {"vr": "DS", "Value": [64.0]}, "216": {"vr": "DS", "Value": [59.0]}, "217": {"vr": "DS", "Value": [69.0]}, "218": {"vr": "DS", "Value": [60.0]}, "219": {"vr": "DS", "Value": [67.0]}, "220": {"vr": "DS", "Value": [66.0]}, "221": {"vr": "DS", "Value": [72.0]}, "222": {"vr": "DS", "Value": [59.0]}, "223": {"vr": "DS", "Value": [74.0]}, "224": {"vr": "DS", "Value": [97.0]}, "225": {"vr": "DS", "Value": [79.0]}, "226": {"vr": "DS", "Value": [68.0]}, "227": {"vr": "DS", "Value": [68.0]}, "228": {"vr": "DS", "Value": [90.0]}, "229": {"vr": "DS", "Value": [138.0]}, "230": {"vr": "DS", "Value": [133.0]}, "231": {"vr": "DS", "Value": [93.0]}, "232": {"vr": "DS", "Value": [102.0]}, "233": {"vr": "DS", "Value": [159.0]}, "234": {"vr": "DS", "Value": [99.0]}, "235": {"vr": "DS", "Value": [88.0]}, "236": {"vr": "DS", "Value": [108.0]}, "237": {"vr": "DS", "Value": [119.0]}, "238": {"vr": "DS", "Value": [117.0]}, "239": {"vr": "DS", "Value": [115.0]}, "240": {"vr": "DS", "Value": [122.0]}, "241": {"vr": "DS", "Value": [135.0]}, "242": {"vr": "DS", "Value": [132.0]}, "243": {"vr": "DS", "Value": [140.0]}, "244": {"vr": "DS", "Value": [135.0]}, "245": {"vr": "DS", "Value": [181.0]}, "246": {"vr": "DS", "Value": [178.0]}, "247": {"vr": "DS", "Value": [196.0]}, "248": {"vr": "DS", "Value": [168.0]}, "249": {"vr": "DS", "Value": [154.0]}, "250": {"vr": "DS", "Value": [178.0]}, "251": {"vr": "DS", "Value": [276.0]}, "252": {"vr": "DS", "Value": [190.0]}, "253": {"vr": "DS", "Value": [192.0]}, "254": {"vr": "DS", "Value": [234.0]}, "255": {"vr": "DS", "Value": [276.0]}, "256": {"vr": "DS", "Value": [208.0]}, "257": {"vr": "DS", "Value": [203.0]}, "258": {"vr": "DS", "Value": [244.0]}, "259": {"vr": "DS", "Value": [239.0]}, "260": {"vr": "DS", "Value": [263.0]}, "261": {"vr": "DS", "Value": [248.0]}, "262": {"vr": "DS", "Value": [248.0]}, "263": {"vr": "DS", "Value": [272.0]}, "264": {"vr": "DS", "Value": [334.0]}, "265": {"vr": "DS", "Value": [308.0]}, "266": {"vr": "DS", "Value": [269.0]}, "267": {"vr": "DS", "Value": [289.0]}, "268": {"vr": "DS", "Value": [303.0]}, "269": {"vr": "DS", "Value": [343.0]}, "270": {"vr": "DS", "Value": [390.0]}, "271": {"vr": "DS", "Value": [329.0]}, "272": {"vr": "DS", "Value": [318.0]}, "273": {"vr": "DS", "Value": [378.0]}, "274": {"vr": "DS", "Value": [375.0]}, "275": {"vr": "DS", "Value": [388.0]}, "276": {"vr": "DS", "Value": [362.0]}, "277": {"vr": "DS", "Value": [366.0]}, "278": {"vr": "DS", "Value": [385.0]}, "279": {"vr": "DS", "Value": [432.0]}, "280": {"vr": "DS", "Value": [435.0]}, "281": {"vr": "DS", "Value": [493.0]}, "282": {"vr": "DS", "Value": [539.0]}, "283": {"vr": "DS", "Value": [448.0]}, "284": {"vr": "DS", "Value": [473.0]}, "285": {"vr": "DS", "Value": [504.0]}, "286": {"vr": "DS", "Value": [483.0]}, "287": {"vr": "DS", "Value": [575.0]}, "288": {"vr": "DS", "Value": [923.0]}, "289": {"vr": "DS", "Value": [1842.0]}, "290": {"vr": "DS", "Value": [2925.0]}, "291": {"vr": "DS", "Value": [3597.0]}, "292": {"vr": "DS", "Value": [3646.0]}, "293": {"vr": "DS", "Value": [3779.0]}, "294": {"vr": "DS", "Value": [3592.0]}, "295": {"vr": "DS", "Value": [3648.0]}, "296": {"vr": "DS", "Value": [3670.0]}, "297": {"vr": "DS", "Value": [3567.0]}, "298": {"vr": "DS", "Value": [3555.0]}, "299": {"vr": "DS", "Value": [3540.0]}, "300": {"vr": "DS", "Value": [3487.0]}, "301": {"vr": "DS", "Value": [3622.0]}, "302": {"vr": "DS", "Value": [3581.0]}, "303": {"vr": "DS", "Value": [3455.0]}, "304": {"vr": "DS", "Value": [3477.0]}, "305": {"vr": "DS", "Value": [3410.0]}, "306": {"vr": "DS", "Value": [3354.0]}, "307": {"vr": "DS", "Value": [3529.0]}, "308": {"vr": "DS", "Value": [3233.0]}, "309": {"vr": "DS", "Value": [3357.0]}, "310": {"vr": "DS", "Value": [3465.0]}, "311": {"vr": "DS", "Value": [3373.0]}, "312": {"vr": "DS", "Value": [3389.0]}, "313": {"vr": "DS", "Value": [3419.0]}, "314": {"vr": "DS", "Value": [3293.0]}, "315": {"vr": "DS", "Value": [3365.0]}, "316": {"vr": "DS", "Value": [3357.0]}, "317": {"vr": "DS", "Value": [3354.0]}, "318": {"vr": "DS", "Value": [3258.0]}, "319": {"vr": "DS", "Value": [3208.0]}, "320": {"vr": "DS", "Value": [3342.0]}, "321": {"vr": "DS", "Value": [3396.0]}, "322": {"vr": "DS", "Value": [3354.0]}, "323": {"vr": "DS", "Value": [3267.0]}, "324": {"vr": "DS", "Value": [3356.0]}, "325": {"vr": "DS", "Value": [3282.0]}, "326": {"vr": "DS", "Value": [3250.0]}, "327": {"vr": "DS", "Value": [3346.0]}, "328": {"vr": "DS", "Value": [3281.0]}, "329": {"vr": "DS", "Value": [3252.0]}, "330": {"vr": "DS", "Value": [3174.0]}, "331": {"vr": "DS", "Value": [3259.0]}, "332": {"vr": "DS", "Value": [3462.0]}, "333": {"vr": "DS", "Value": [3324.0]}, "334": {"vr": "DS", "Value": [3352.0]}, "335": {"vr": "DS", "Value": [3206.0]}, "336": {"vr": "DS", "Value": [3280.0]}, "337": {"vr": "DS", "Value": [3247.0]}, "338": {"vr": "DS", "Value": [3236.0]}, "339": {"vr": "DS", "Value": [3239.0]}, "340": {"vr": "DS", "Value": [3399.0]}, "341": {"vr": "DS", "Value": [3280.0]}, "342": {"vr": "DS", "Value": [3202.0]}, "343": {"vr": "DS", "Value": [3200.0]}, "344": {"vr": "DS", "Value": [3210.0]}, "345": {"vr": "DS", "Value": [3225.0]}, "346": {"vr": "DS", "Value": [3262.0]}, "347": {"vr": "DS", "Value": [3206.0]}, "348": {"vr": "DS", "Value": [3188.0]}, "349": {"vr": "DS", "Value": [3389.0]}, "350": {"vr": "DS", "Value": [3376.0]}, "351": {"vr": "DS", "Value": [3188.0]}, "352": {"vr": "DS", "Value": [3276.0]}, "353": {"vr": "DS", "Value": [3206.0]}, "354": {"vr": "DS", "Value": [3220.0]}, "355": {"vr": "DS", "Value": [3160.0]}, "356": {"vr": "DS", "Value": [3165.0]}, "357": {"vr": "DS", "Value": [3309.0]}, "358": {"vr": "DS", "Value": [3485.0]}, "359": {"vr": "DS", "Value": [3263.0]}, "360": {"vr": "DS", "Value": [3130.0]}, "361": {"vr": "DS", "Value": [3235.0]}, "362": {"vr": "DS", "Value": [3268.0]}, "363": {"vr": "DS", "Value": [3269.0]}, "364": {"vr": "DS", "Value": [3188.0]}, "365": {"vr": "DS", "Value": [3369.0]}, "366": {"vr": "DS", "Value": [3395.0]}, "367": {"vr": "DS", "Value": [3344.0]}, "368": {"vr": "DS", "Value": [3346.0]}, "369": {"vr": "DS", "Value": [3306.0]}, "370": {"vr": "DS", "Value": [3426.0]}, "371": {"vr": "DS", "Value": [3305.0]}, "372": {"vr": "DS", "Value": [3263.0]}, "373": {"vr": "DS", "Value": [3353.0]}, "374": {"vr": "DS", "Value": [3439.0]}, "375": {"vr": "DS", "Value": [3263.0]}, "376": {"vr": "DS", "Value": [3320.0]}, "377": {"vr": "DS", "Value": [3276.0]}, "378": {"vr": "DS", "Value": [3343.0]}, "379": {"vr": "DS", "Value": [3433.0]}, "380": {"vr": "DS", "Value": [3367.0]}, "381": {"vr": "DS", "Value": [3366.0]}, "382": {"vr": "DS", "Value": [3368.0]}, "383": {"vr": "DS", "Value": [3425.0]}, "384": {"vr": "DS", "Value": [3328.0]}, "385": {"vr": "DS", "Value": [3254.0]}, "386": {"vr": "DS", "Value": [3217.0]}, "387": {"vr": "DS", "Value": [3308.0]}, "388": {"vr": "DS", "Value": [3351.0]}, "389": {"vr": "DS", "Value": [3257.0]}, "390": {"vr": "DS", "Value": [3348.0]}, "391": {"vr": "DS", "Value": [3298.0]}, "392": {"vr": "DS", "Value": [3279.0]}, "393": {"vr": "DS", "Value": [3426.0]}, "394": {"vr": "DS", "Value": [3311.0]}, "395": {"vr": "DS", "Value": [3444.0]}, "396": {"vr": "DS", "Value": [3533.0]}, "397": {"vr": "DS", "Value": [3553.0]}, "398": {"vr": "DS", "Value": [3359.0]}, "399": {"vr": "DS", "Value": [3295.0]}, "400": {"vr": "DS", "Value": [3515.0]}, "401": {"vr": "DS", "Value": [3402.0]}, "402": {"vr": "DS", "Value": [3455.0]}, "403": {"vr": "DS", "Value": [3388.0]}, "404": {"vr": "DS", "Value": [3370.0]}, "405": {"vr": "DS", "Value": [3488.0]}, "406": {"vr": "DS", "Value": [3911.0]}, "407": {"vr": "DS", "Value": [3704.0]}, "408": {"vr": "DS", "Value": [3388.0]}, "409": {"vr": "DS", "Value": [3400.0]}, "410": {"vr": "DS", "Value": [3286.0]}, "411": {"vr": "DS", "Value": [3375.0]}, "412": {"vr": "DS", "Value": [3266.0]}, "413": {"vr": "DS", "Value": [3433.0]}, "414": {"vr": "DS", "Value": [3527.0]}, "415": {"vr": "DS", "Value": [3301.0]}, "416": {"vr": "DS", "Value": [3286.0]}, "417": {"vr": "DS", "Value": [3448.0]}, "418": {"vr": "DS", "Value": [3432.0]}, "419": {"vr": "DS", "Value": [3491.0]}, "420": {"vr": "DS", "Value": [3533.0]}, "421": {"vr": "DS", "Value": [3553.0]}, "422": {"vr": "DS", "Value": [3452.0]}, "423": {"vr": "DS", "Value": [3723.0]}, "424": {"vr": "DS", "Value": [3419.0]}, "425": {"vr": "DS", "Value": [3564.0]}, "426": {"vr": "DS", "Value": [3487.0]}, "427": {"vr": "DS", "Value": [3771.0]}, "428": {"vr": "DS", "Value": [3719.0]}, "429": {"vr": "DS", "Value": [3749.0]}, "430": {"vr": "DS", "Value": [3863.0]}, "431": {"vr": "DS", "Value": [3865.0]}, "432": {"vr": "DS", "Value": [4058.0]}, "433": {"vr": "DS", "Value": [3795.0]}, "434": {"vr": "DS", "Value": [3888.0]}, "435": {"vr": "DS", "Value": [3979.0]}, "436": {"vr": "DS", "Value": [3545.0]}, "437": {"vr": "DS", "Value": [2259.0]}, "438": {"vr": "DS", "Value": [1035.0]}, "439": {"vr": "DS", "Value": [701.0]}, "440": {"vr": "DS", "Value": [927.0]}, "441": {"vr": "DS", "Value": [913.0]}, "442": {"vr": "DS", "Value": [968.0]}, "443": {"vr": "DS", "Value": [801.0]}, "444": {"vr": "DS", "Value": [996.0]}, "445": {"vr": "DS", "Value": [1086.0]}, "446": {"vr": "DS", "Value": [1148.0]}, "447": {"vr": "DS", "Value": [830.0]}, "448": {"vr": "DS", "Value": [553.0]}, "449": {"vr": "DS", "Value": [596.0]}, "450": {"vr": "DS", "Value": [653.0]}, "451": {"vr": "DS", "Value": [521.0]}, "452": {"vr": "DS", "Value": [584.0]}, "453": {"vr": "DS", "Value": [525.0]}, "454": {"vr": "DS", "Value": [504.0]}, "455": {"vr": "DS", "Value": [555.0]}, "456": {"vr": "DS", "Value": [507.0]}, "457": {"vr": "DS", "Value": [540.0]}, "458": {"vr": "DS", "Value": [443.0]}, "459": {"vr": "DS", "Value": [545.0]}, "460": {"vr": "DS", "Value": [468.0]}, "461": {"vr": "DS", "Value": [468.0]}, "462": {"vr": "DS", "Value": [475.0]}, "463": {"vr": "DS", "Value": [492.0]}, "464": {"vr": "DS", "Value": [456.0]}, "465": {"vr": "DS", "Value": [464.0]}, "466": {"vr": "DS", "Value": [414.0]}, "467": {"vr": "DS", "Value": [400.0]}, "468": {"vr": "DS", "Value": [476.0]}, "469": {"vr": "DS", "Value": [479.0]}, "470": {"vr": "DS", "Value": [463.0]}, "471": {"vr": "DS", "Value": [412.0]}, "472": {"vr": "DS", "Value": [417.0]}, "473": {"vr": "DS", "Value": [358.0]}, "474": {"vr": "DS", "Value": [377.0]}, "475": {"vr": "DS", "Value": [466.0]}, "476": {"vr": "DS", "Value": [389.0]}, "477": {"vr": "DS", "Value": [358.0]}, "478": {"vr": "DS", "Value": [326.0]}, "479": {"vr": "DS", "Value": [398.0]}, "480": {"vr": "DS", "Value": [324.0]}, "481": {"vr": "DS", "Value": [417.0]}, "482": {"vr": "DS", "Value": [351.0]}, "483": {"vr": "DS", "Value": [312.0]}, "484": {"vr": "DS", "Value": [400.0]}, "485": {"vr": "DS", "Value": [371.0]}, "486": {"vr": "DS", "Value": [339.0]}, "487": {"vr": "DS", "Value": [331.0]}, "488": {"vr": "DS", "Value": [392.0]}, "489": {"vr": "DS", "Value": [619.0]}, "490": {"vr": "DS", "Value": [386.0]}, "491": {"vr": "DS", "Value": [329.0]}, "492": {"vr": "DS", "Value": [404.0]}, "493": {"vr": "DS", "Value": [371.0]}, "494": {"vr": "DS", "Value": [369.0]}, "495": {"vr": "DS", "Value": [357.0]}, "496": {"vr": "DS", "Value": [429.0]}, "497": {"vr": "DS", "Value": [375.0]}, "498": {"vr": "DS", "Value": [348.0]}, "499": {"vr": "DS", "Value": [404.0]}, "500": {"vr": "DS", "Value": [340.0]}, "501": {"vr": "DS", "Value": [284.0]}, "502": {"vr": "DS", "Value": [492.0]}, "503": {"vr": "DS", "Value": [575.0]}, "504": {"vr": "DS", "Value": [465.0]}, "505": {"vr": "DS", "Value": [367.0]}, "506": {"vr": "DS", "Value": [402.0]}, "507": {"vr": "DS", "Value": [659.0]}, "508": {"vr": "DS", "Value": [477.0]}, "509": {"vr": "DS", "Value": [441.0]}, "510": {"vr": "DS", "Value": [528.0]}, "511": {"vr": "DS", "Value": [532.0]}, "512": {"vr": "DS", "Value": [460.0]}, "513": {"vr": "DS", "Value": [522.0]}, "514": {"vr": "DS", "Value": [856.0]}, "515": {"vr": "DS", "Value": [437.0]}, "516": {"vr": "DS", "Value": [871.0]}, "517": {"vr": "DS", "Value": [751.0]}, "518": {"vr": "DS", "Value": [730.0]}, "519": {"vr": "DS", "Value": [1042.0]}, "520": {"vr": "DS", "Value": [1220.0]}, "521": {"vr": "DS", "Value": [1015.0]}, "522": {"vr": "DS", "Value": [999.0]}, "523": {"vr": "DS", "Value": [999.0]}, "524": {"vr": "DS", "Value": [1946.0]}, "525": {"vr": "DS", "Value": [1778.0]}, "526": {"vr": "DS", "Value": [4520.0]}, "527": {"vr": "DS", "Value": [2567.0]}, "528": {"vr": "DS", "Value": [4429.0]}, "529": {"vr": "DS", "Value": [9008.0]}, "530": {"vr": "DS", "Value": [16284.0]}}, "00541330": {"0": {"vr": "US", "Value": [1]}, "1": {"vr": "US", "Value": [2]}, "2": {"vr": "US", "Value": [3]}, "3": {"vr": "US", "Value": [4]}, "4": {"vr": "US", "Value": [5]}, "5": {"vr": "US", "Value": [6]}, "6": {"vr": "US", "Value": [7]}, "7": {"vr": "US", "Value": [8]}, "8": {"vr": "US", "Value": [9]}, "9": {"vr": "US", "Value": [10]}, "10": {"vr": "US", "Value": [11]}, "11": {"vr": "US", "Value": [12]}, "12": {"vr": "US", "Value": [13]}, "13": {"vr": "US", "Value": [14]}, "14": {"vr": "US", "Value": [15]}, "15": {"vr": "US", "Value": [16]}, "16": {"vr": "US", "Value": [17]}, "17": {"vr": "US", "Value": [18]}, "18": {"vr": "US", "Value": [19]}, "19": {"vr": "US", "Value": [20]}, "20": {"vr": "US", "Value": [21]}, "21": {"vr": "US", "Value": [22]}, "22": {"vr": "US", "Value": [23]}, "23": {"vr": "US", "Value": [24]}, "24": {"vr": "US", "Value": [25]}, "25": {"vr": "US", "Value": [26]}, "26": {"vr": "US", "Value": [27]}, "27": {"vr": "US", "Value": [28]}, "28": {"vr": "US", "Value": [29]}, "29": {"vr": "US", "Value": [30]}, "30": {"vr": "US", "Value": [31]}, "31": {"vr": "US", "Value": [32]}, "32": {"vr": "US", "Value": [33]}, "33": {"vr": "US", "Value": [34]}, "34": {"vr": "US", "Value": [35]}, "35": {"vr": "US", "Value": [36]}, "36": {"vr": "US", "Value": [37]}, "37": {"vr": "US", "Value": [38]}, "38": {"vr": "US", "Value": [39]}, "39": {"vr": "US", "Value": [40]}, "40": {"vr": "US", "Value": [41]}, "41": {"vr": "US", "Value": [42]}, "42": {"vr": "US", "Value": [43]}, "43": {"vr": "US", "Value": [44]}, "44": {"vr": "US", "Value": [45]}, "45": {"vr": "US", "Value": [46]}, "46": {"vr": "US", "Value": [47]}, "47": {"vr": "US", "Value": [48]}, "48": {"vr": "US", "Value": [49]}, "49": {"vr": "US", "Value": [50]}, "50": {"vr": "US", "Value": [51]}, "51": {"vr": "US", "Value": [52]}, "52": {"vr": "US", "Value": [53]}, "53": {"vr": "US", "Value": [54]}, "54": {"vr": "US", "Value": [55]}, "55": {"vr": "US", "Value": [56]}, "56": {"vr": "US", "Value": [57]}, "57": {"vr": "US", "Value": [58]}, "58": {"vr": "US", "Value": [59]}, "59": {"vr": "US", "Value": [60]}, "60": {"vr": "US", "Value": [61]}, "61": {"vr": "US", "Value": [62]}, "62": {"vr": "US", "Value": [63]}, "63": {"vr": "US", "Value": [64]}, "64": {"vr": "US", "Value": [65]}, "65": {"vr": "US", "Value": [66]}, "66": {"vr": "US", "Value": [67]}, "67": {"vr": "US", "Value": [68]}, "68": {"vr": "US", "Value": [69]}, "69": {"vr": "US", "Value": [70]}, "70": {"vr": "US", "Value": [71]}, "71": {"vr": "US", "Value": [72]}, "72": {"vr": "US", "Value": [73]}, "73": {"vr": "US", "Value": [74]}, "74": {"vr": "US", "Value": [75]}, "75": {"vr": "US", "Value": [76]}, "76": {"vr": "US", "Value": [77]}, "77": {"vr": "US", "Value": [78]}, "78": {"vr": "US", "Value": [79]}, "79": {"vr": "US", "Value": [80]}, "80": {"vr": "US", "Value": [81]}, "81": {"vr": "US", "Value": [82]}, "82": {"vr": "US", "Value": [83]}, "83": {"vr": "US", "Value": [84]}, "84": {"vr": "US", "Value": [85]}, "85": {"vr": "US", "Value": [86]}, "86": {"vr": "US", "Value": [87]}, "87": {"vr": "US", "Value": [88]}, "88": {"vr": "US", "Value": [89]}, "89": {"vr": "US", "Value": [90]}, "90": {"vr": "US", "Value": [91]}, "91": {"vr": "US", "Value": [92]}, "92": {"vr": "US", "Value": [93]}, "93": {"vr": "US", "Value": [94]}, "94": {"vr": "US", "Value": [95]}, "95": {"vr": "US", "Value": [96]}, "96": {"vr": "US", "Value": [97]}, "97": {"vr": "US", "Value": [98]}, "98": {"vr": "US", "Value": [99]}, "99": {"vr": "US", "Value": [100]}, "100": {"vr": "US", "Value": [101]}, "101": {"vr": "US", "Value": [102]}, "102": {"vr": "US", "Value": [103]}, "103": {"vr": "US", "Value": [104]}, "104": {"vr": "US", "Value": [105]}, "105": {"vr": "US", "Value": [106]}, "106": {"vr": "US", "Value": [107]}, "107": {"vr": "US", "Value": [108]}, "108": {"vr": "US", "Value": [109]}, "109": {"vr": "US", "Value": [110]}, "110": {"vr": "US", "Value": [111]}, "111": {"vr": "US", "Value": [112]}, "112": {"vr": "US", "Value": [113]}, "113": {"vr": "US", "Value": [114]}, "114": {"vr": "US", "Value": [115]}, "115": {"vr": "US", "Value": [116]}, "116": {"vr": "US", "Value": [117]}, "117": {"vr": "US", "Value": [118]}, "118": {"vr": "US", "Value": [119]}, "119": {"vr": "US", "Value": [120]}, "120": {"vr": "US", "Value": [121]}, "121": {"vr": "US", "Value": [122]}, "122": {"vr": "US", "Value": [123]}, "123": {"vr": "US", "Value": [124]}, "124": {"vr": "US", "Value": [125]}, "125": {"vr": "US", "Value": [126]}, "126": {"vr": "US", "Value": [127]}, "127": {"vr": "US", "Value": [128]}, "128": {"vr": "US", "Value": [129]}, "129": {"vr": "US", "Value": [130]}, "130": {"vr": "US", "Value": [131]}, "131": {"vr": "US", "Value": [132]}, "132": {"vr": "US", "Value": [133]}, "133": {"vr": "US", "Value": [134]}, "134": {"vr": "US", "Value": [135]}, "135": {"vr": "US", "Value": [136]}, "136": {"vr": "US", "Value": [137]}, "137": {"vr": "US", "Value": [138]}, "138": {"vr": "US", "Value": [139]}, "139": {"vr": "US", "Value": [140]}, "140": {"vr": "US", "Value": [141]}, "141": {"vr": "US", "Value": [142]}, "142": {"vr": "US", "Value": [143]}, "143": {"vr": "US", "Value": [144]}, "144": {"vr": "US", "Value": [145]}, "145": {"vr": "US", "Value": [146]}, "146": {"vr": "US", "Value": [147]}, "147": {"vr": "US", "Value": [148]}, "148": {"vr": "US", "Value": [149]}, "149": {"vr": "US", "Value": [150]}, "150": {"vr": "US", "Value": [151]}, "151": {"vr": "US", "Value": [152]}, "152": {"vr": "US", "Value": [153]}, "153": {"vr": "US", "Value": [154]}, "154": {"vr": "US", "Value": [155]}, "155": {"vr": "US", "Value": [156]}, "156": {"vr": "US", "Value": [157]}, "157": {"vr": "US", "Value": [158]}, "158": {"vr": "US", "Value": [159]}, "159": {"vr": "US", "Value": [160]}, "160": {"vr": "US", "Value": [161]}, "161": {"vr": "US", "Value": [162]}, "162": {"vr": "US", "Value": [163]}, "163": {"vr": "US", "Value": [164]}, "164": {"vr": "US", "Value": [165]}, "165": {"vr": "US", "Value": [166]}, "166": {"vr": "US", "Value": [167]}, "167": {"vr": "US", "Value": [168]}, "168": {"vr": "US", "Value": [169]}, "169": {"vr": "US", "Value": [170]}, "170": {"vr": "US", "Value": [171]}, "171": {"vr": "US", "Value": [172]}, "172": {"vr": "US", "Value": [173]}, "173": {"vr": "US", "Value": [174]}, "174": {"vr": "US", "Value": [175]}, "175": {"vr": "US", "Value": [176]}, "176": {"vr": "US", "Value": [177]}, "177": {"vr": "US", "Value": [178]}, "178": {"vr": "US", "Value": [179]}, "179": {"vr": "US", "Value": [180]}, "180": {"vr": "US", "Value": [181]}, "181": {"vr": "US", "Value": [182]}, "182": {"vr": "US", "Value": [183]}, "183": {"vr": "US", "Value": [184]}, "184": {"vr": "US", "Value": [185]}, "185": {"vr": "US", "Value": [186]}, "186": {"vr": "US", "Value": [187]}, "187": {"vr": "US", "Value": [188]}, "188": {"vr": "US", "Value": [189]}, "189": {"vr": "US", "Value": [190]}, "190": {"vr": "US", "Value": [191]}, "191": {"vr": "US", "Value": [192]}, "192": {"vr": "US", "Value": [193]}, "193": {"vr": "US", "Value": [194]}, "194": {"vr": "US", "Value": [195]}, "195": {"vr": "US", "Value": [196]}, "196": {"vr": "US", "Value": [197]}, "197": {"vr": "US", "Value": [198]}, "198": {"vr": "US", "Value": [199]}, "199": {"vr": "US", "Value": [200]}, "200": {"vr": "US", "Value": [201]}, "201": {"vr": "US", "Value": [202]}, "202": {"vr": "US", "Value": [203]}, "203": {"vr": "US", "Value": [204]}, "204": {"vr": "US", "Value": [205]}, "205": {"vr": "US", "Value": [206]}, "206": {"vr": "US", "Value": [207]}, "207": {"vr": "US", "Value": [208]}, "208": {"vr": "US", "Value": [209]}, "209": {"vr": "US", "Value": [210]}, "210": {"vr": "US", "Value": [211]}, "211": {"vr": "US", "Value": [212]}, "212": {"vr": "US", "Value": [213]}, "213": {"vr": "US", "Value": [214]}, "214": {"vr": "US", "Value": [215]}, "215": {"vr": "US", "Value": [216]}, "216": {"vr": "US", "Value": [217]}, "217": {"vr": "US", "Value": [218]}, "218": {"vr": "US", "Value": [219]}, "219": {"vr": "US", "Value": [220]}, "220": {"vr": "US", "Value": [221]}, "221": {"vr": "US", "Value": [222]}, "222": {"vr": "US", "Value": [223]}, "223": {"vr": "US", "Value": [224]}, "224": {"vr": "US", "Value": [225]}, "225": {"vr": "US", "Value": [226]}, "226": {"vr": "US", "Value": [227]}, "227": {"vr": "US", "Value": [228]}, "228": {"vr": "US", "Value": [229]}, "229": {"vr": "US", "Value": [230]}, "230": {"vr": "US", "Value": [231]}, "231": {"vr": "US", "Value": [232]}, "232": {"vr": "US", "Value": [233]}, "233": {"vr": "US", "Value": [234]}, "234": {"vr": "US", "Value": [235]}, "235": {"vr": "US", "Value": [236]}, "236": {"vr": "US", "Value": [237]}, "237": {"vr": "US", "Value": [238]}, "238": {"vr": "US", "Value": [239]}, "239": {"vr": "US", "Value": [240]}, "240": {"vr": "US", "Value": [241]}, "241": {"vr": "US", "Value": [242]}, "242": {"vr": "US", "Value": [243]}, "243": {"vr": "US", "Value": [244]}, "244": {"vr": "US", "Value": [245]}, "245": {"vr": "US", "Value": [246]}, "246": {"vr": "US", "Value": [247]}, "247": {"vr": "US", "Value": [248]}, "248": {"vr": "US", "Value": [249]}, "249": {"vr": "US", "Value": [250]}, "250": {"vr": "US", "Value": [251]}, "251": {"vr": "US", "Value": [252]}, "252": {"vr": "US", "Value": [253]}, "253": {"vr": "US", "Value": [254]}, "254": {"vr": "US", "Value": [255]}, "255": {"vr": "US", "Value": [256]}, "256": {"vr": "US", "Value": [257]}, "257": {"vr": "US", "Value": [258]}, "258": {"vr": "US", "Value": [259]}, "259": {"vr": "US", "Value": [260]}, "260": {"vr": "US", "Value": [261]}, "261": {"vr": "US", "Value": [262]}, "262": {"vr": "US", "Value": [263]}, "263": {"vr": "US", "Value": [264]}, "264": {"vr": "US", "Value": [265]}, "265": {"vr": "US", "Value": [266]}, "266": {"vr": "US", "Value": [267]}, "267": {"vr": "US", "Value": [268]}, "268": {"vr": "US", "Value": [269]}, "269": {"vr": "US", "Value": [270]}, "270": {"vr": "US", "Value": [271]}, "271": {"vr": "US", "Value": [272]}, "272": {"vr": "US", "Value": [273]}, "273": {"vr": "US", "Value": [274]}, "274": {"vr": "US", "Value": [275]}, "275": {"vr": "US", "Value": [276]}, "276": {"vr": "US", "Value": [277]}, "277": {"vr": "US", "Value": [278]}, "278": {"vr": "US", "Value": [279]}, "279": {"vr": "US", "Value": [280]}, "280": {"vr": "US", "Value": [281]}, "281": {"vr": "US", "Value": [282]}, "282": {"vr": "US", "Value": [283]}, "283": {"vr": "US", "Value": [284]}, "284": {"vr": "US", "Value": [285]}, "285": {"vr": "US", "Value": [286]}, "286": {"vr": "US", "Value": [287]}, "287": {"vr": "US", "Value": [288]}, "288": {"vr": "US", "Value": [289]}, "289": {"vr": "US", "Value": [290]}, "290": {"vr": "US", "Value": [291]}, "291": {"vr": "US", "Value": [292]}, "292": {"vr": "US", "Value": [293]}, "293": {"vr": "US", "Value": [294]}, "294": {"vr": "US", "Value": [295]}, "295": {"vr": "US", "Value": [296]}, "296": {"vr": "US", "Value": [297]}, "297": {"vr": "US", "Value": [298]}, "298": {"vr": "US", "Value": [299]}, "299": {"vr": "US", "Value": [300]}, "300": {"vr": "US", "Value": [301]}, "301": {"vr": "US", "Value": [302]}, "302": {"vr": "US", "Value": [303]}, "303": {"vr": "US", "Value": [304]}, "304": {"vr": "US", "Value": [305]}, "305": {"vr": "US", "Value": [306]}, "306": {"vr": "US", "Value": [307]}, "307": {"vr": "US", "Value": [308]}, "308": {"vr": "US", "Value": [309]}, "309": {"vr": "US", "Value": [310]}, "310": {"vr": "US", "Value": [311]}, "311": {"vr": "US", "Value": [312]}, "312": {"vr": "US", "Value": [313]}, "313": {"vr": "US", "Value": [314]}, "314": {"vr": "US", "Value": [315]}, "315": {"vr": "US", "Value": [316]}, "316": {"vr": "US", "Value": [317]}, "317": {"vr": "US", "Value": [318]}, "318": {"vr": "US", "Value": [319]}, "319": {"vr": "US", "Value": [320]}, "320": {"vr": "US", "Value": [321]}, "321": {"vr": "US", "Value": [322]}, "322": {"vr": "US", "Value": [323]}, "323": {"vr": "US", "Value": [324]}, "324": {"vr": "US", "Value": [325]}, "325": {"vr": "US", "Value": [326]}, "326": {"vr": "US", "Value": [327]}, "327": {"vr": "US", "Value": [328]}, "328": {"vr": "US", "Value": [329]}, "329": {"vr": "US", "Value": [330]}, "330": {"vr": "US", "Value": [331]}, "331": {"vr": "US", "Value": [332]}, "332": {"vr": "US", "Value": [333]}, "333": {"vr": "US", "Value": [334]}, "334": {"vr": "US", "Value": [335]}, "335": {"vr": "US", "Value": [336]}, "336": {"vr": "US", "Value": [337]}, "337": {"vr": "US", "Value": [338]}, "338": {"vr": "US", "Value": [339]}, "339": {"vr": "US", "Value": [340]}, "340": {"vr": "US", "Value": [341]}, "341": {"vr": "US", "Value": [342]}, "342": {"vr": "US", "Value": [343]}, "343": {"vr": "US", "Value": [344]}, "344": {"vr": "US", "Value": [345]}, "345": {"vr": "US", "Value": [346]}, "346": {"vr": "US", "Value": [347]}, "347": {"vr": "US", "Value": [348]}, "348": {"vr": "US", "Value": [349]}, "349": {"vr": "US", "Value": [350]}, "350": {"vr": "US", "Value": [351]}, "351": {"vr": "US", "Value": [352]}, "352": {"vr": "US", "Value": [353]}, "353": {"vr": "US", "Value": [354]}, "354": {"vr": "US", "Value": [355]}, "355": {"vr": "US", "Value": [356]}, "356": {"vr": "US", "Value": [357]}, "357": {"vr": "US", "Value": [358]}, "358": {"vr": "US", "Value": [359]}, "359": {"vr": "US", "Value": [360]}, "360": {"vr": "US", "Value": [361]}, "361": {"vr": "US", "Value": [362]}, "362": {"vr": "US", "Value": [363]}, "363": {"vr": "US", "Value": [364]}, "364": {"vr": "US", "Value": [365]}, "365": {"vr": "US", "Value": [366]}, "366": {"vr": "US", "Value": [367]}, "367": {"vr": "US", "Value": [368]}, "368": {"vr": "US", "Value": [369]}, "369": {"vr": "US", "Value": [370]}, "370": {"vr": "US", "Value": [371]}, "371": {"vr": "US", "Value": [372]}, "372": {"vr": "US", "Value": [373]}, "373": {"vr": "US", "Value": [374]}, "374": {"vr": "US", "Value": [375]}, "375": {"vr": "US", "Value": [376]}, "376": {"vr": "US", "Value": [377]}, "377": {"vr": "US", "Value": [378]}, "378": {"vr": "US", "Value": [379]}, "379": {"vr": "US", "Value": [380]}, "380": {"vr": "US", "Value": [381]}, "381": {"vr": "US", "Value": [382]}, "382": {"vr": "US", "Value": [383]}, "383": {"vr": "US", "Value": [384]}, "384": {"vr": "US", "Value": [385]}, "385": {"vr": "US", "Value": [386]}, "386": {"vr": "US", "Value": [387]}, "387": {"vr": "US", "Value": [388]}, "388": {"vr": "US", "Value": [389]}, "389": {"vr": "US", "Value": [390]}, "390": {"vr": "US", "Value": [391]}, "391": {"vr": "US", "Value": [392]}, "392": {"vr": "US", "Value": [393]}, "393": {"vr": "US", "Value": [394]}, "394": {"vr": "US", "Value": [395]}, "395": {"vr": "US", "Value": [396]}, "396": {"vr": "US", "Value": [397]}, "397": {"vr": "US", "Value": [398]}, "398": {"vr": "US", "Value": [399]}, "399": {"vr": "US", "Value": [400]}, "400": {"vr": "US", "Value": [401]}, "401": {"vr": "US", "Value": [402]}, "402": {"vr": "US", "Value": [403]}, "403": {"vr": "US", "Value": [404]}, "404": {"vr": "US", "Value": [405]}, "405": {"vr": "US", "Value": [406]}, "406": {"vr": "US", "Value": [407]}, "407": {"vr": "US", "Value": [408]}, "408": {"vr": "US", "Value": [409]}, "409": {"vr": "US", "Value": [410]}, "410": {"vr": "US", "Value": [411]}, "411": {"vr": "US", "Value": [412]}, "412": {"vr": "US", "Value": [413]}, "413": {"vr": "US", "Value": [414]}, "414": {"vr": "US", "Value": [415]}, "415": {"vr": "US", "Value": [416]}, "416": {"vr": "US", "Value": [417]}, "417": {"vr": "US", "Value": [418]}, "418": {"vr": "US", "Value": [419]}, "419": {"vr": "US", "Value": [420]}, "420": {"vr": "US", "Value": [421]}, "421": {"vr": "US", "Value": [422]}, "422": {"vr": "US", "Value": [423]}, "423": {"vr": "US", "Value": [424]}, "424": {"vr": "US", "Value": [425]}, "425": {"vr": "US", "Value": [426]}, "426": {"vr": "US", "Value": [427]}, "427": {"vr": "US", "Value": [428]}, "428": {"vr": "US", "Value": [429]}, "429": {"vr": "US", "Value": [430]}, "430": {"vr": "US", "Value": [431]}, "431": {"vr": "US", "Value": [432]}, "432": {"vr": "US", "Value": [433]}, "433": {"vr": "US", "Value": [434]}, "434": {"vr": "US", "Value": [435]}, "435": {"vr": "US", "Value": [436]}, "436": {"vr": "US", "Value": [437]}, "437": {"vr": "US", "Value": [438]}, "438": {"vr": "US", "Value": [439]}, "439": {"vr": "US", "Value": [440]}, "440": {"vr": "US", "Value": [441]}, "441": {"vr": "US", "Value": [442]}, "442": {"vr": "US", "Value": [443]}, "443": {"vr": "US", "Value": [444]}, "444": {"vr": "US", "Value": [445]}, "445": {"vr": "US", "Value": [446]}, "446": {"vr": "US", "Value": [447]}, "447": {"vr": "US", "Value": [448]}, "448": {"vr": "US", "Value": [449]}, "449": {"vr": "US", "Value": [450]}, "450": {"vr": "US", "Value": [451]}, "451": {"vr": "US", "Value": [452]}, "452": {"vr": "US", "Value": [453]}, "453": {"vr": "US", "Value": [454]}, "454": {"vr": "US", "Value": [455]}, "455": {"vr": "US", "Value": [456]}, "456": {"vr": "US", "Value": [457]}, "457": {"vr": "US", "Value": [458]}, "458": {"vr": "US", "Value": [459]}, "459": {"vr": "US", "Value": [460]}, "460": {"vr": "US", "Value": [461]}, "461": {"vr": "US", "Value": [462]}, "462": {"vr": "US", "Value": [463]}, "463": {"vr": "US", "Value": [464]}, "464": {"vr": "US", "Value": [465]}, "465": {"vr": "US", "Value": [466]}, "466": {"vr": "US", "Value": [467]}, "467": {"vr": "US", "Value": [468]}, "468": {"vr": "US", "Value": [469]}, "469": {"vr": "US", "Value": [470]}, "470": {"vr": "US", "Value": [471]}, "471": {"vr": "US", "Value": [472]}, "472": {"vr": "US", "Value": [473]}, "473": {"vr": "US", "Value": [474]}, "474": {"vr": "US", "Value": [475]}, "475": {"vr": "US", "Value": [476]}, "476": {"vr": "US", "Value": [477]}, "477": {"vr": "US", "Value": [478]}, "478": {"vr": "US", "Value": [479]}, "479": {"vr": "US", "Value": [480]}, "480": {"vr": "US", "Value": [481]}, "481": {"vr": "US", "Value": [482]}, "482": {"vr": "US", "Value": [483]}, "483": {"vr": "US", "Value": [484]}, "484": {"vr": "US", "Value": [485]}, "485": {"vr": "US", "Value": [486]}, "486": {"vr": "US", "Value": [487]}, "487": {"vr": "US", "Value": [488]}, "488": {"vr": "US", "Value": [489]}, "489": {"vr": "US", "Value": [490]}, "490": {"vr": "US", "Value": [491]}, "491": {"vr": "US", "Value": [492]}, "492": {"vr": "US", "Value": [493]}, "493": {"vr": "US", "Value": [494]}, "494": {"vr": "US", "Value": [495]}, "495": {"vr": "US", "Value": [496]}, "496": {"vr": "US", "Value": [497]}, "497": {"vr": "US", "Value": [498]}, "498": {"vr": "US", "Value": [499]}, "499": {"vr": "US", "Value": [500]}, "500": {"vr": "US", "Value": [501]}, "501": {"vr": "US", "Value": [502]}, "502": {"vr": "US", "Value": [503]}, "503": {"vr": "US", "Value": [504]}, "504": {"vr": "US", "Value": [505]}, "505": {"vr": "US", "Value": [506]}, "506": {"vr": "US", "Value": [507]}, "507": {"vr": "US", "Value": [508]}, "508": {"vr": "US", "Value": [509]}, "509": {"vr": "US", "Value": [510]}, "510": {"vr": "US", "Value": [511]}, "511": {"vr": "US", "Value": [512]}, "512": {"vr": "US", "Value": [513]}, "513": {"vr": "US", "Value": [514]}, "514": {"vr": "US", "Value": [515]}, "515": {"vr": "US", "Value": [516]}, "516": {"vr": "US", "Value": [517]}, "517": {"vr": "US", "Value": [518]}, "518": {"vr": "US", "Value": [519]}, "519": {"vr": "US", "Value": [520]}, "520": {"vr": "US", "Value": [521]}, "521": {"vr": "US", "Value": [522]}, "522": {"vr": "US", "Value": [523]}, "523": {"vr": "US", "Value": [524]}, "524": {"vr": "US", "Value": [525]}, "525": {"vr": "US", "Value": [526]}, "526": {"vr": "US", "Value": [527]}, "527": {"vr": "US", "Value": [528]}, "528": {"vr": "US", "Value": [529]}, "529": {"vr": "US", "Value": [530]}, "530": {"vr": "US", "Value": [531]}}}


collated_data = {"00291020": {"0": {"vr": "OB", "BinaryLength": 536}, "1": {"vr": "OB", "BinaryLength": 536}, "2": {"vr": "OB", "BinaryLength": 536}, "3": {"vr": "OB", "BinaryLength": 536}, "4": {"vr": "OB", "BinaryLength": 536}, "5": {"vr": "OB", "BinaryLength": 536}, "6": {"vr": "OB", "BinaryLength": 536}, "7": {"vr": "OB", "BinaryLength": 536}, "8": {"vr": "OB", "BinaryLength": 536}, "9": {"vr": "OB", "BinaryLength": 536}, "10": {"vr": "OB", "BinaryLength": 536}, "11": {"vr": "OB", "BinaryLength": 536}, "12": {"vr": "OB", "BinaryLength": 536}, "13": {"vr": "OB", "BinaryLength": 536}, "14": {"vr": "OB", "BinaryLength": 536}, "15": {"vr": "OB", "BinaryLength": 536}, "16": {"vr": "OB", "BinaryLength": 536}, "17": {"vr": "OB", "BinaryLength": 536}, "18": {"vr": "OB", "BinaryLength": 536}, "19": {"vr": "OB", "BinaryLength": 536}, "20": {"vr": "OB", "BinaryLength": 536}, "21": {"vr": "OB", "BinaryLength": 536}, "22": {"vr": "OB", "BinaryLength": 536}, "23": {"vr": "OB", "BinaryLength": 536}, "24": {"vr": "OB", "BinaryLength": 536}, "25": {"vr": "OB", "BinaryLength": 536}, "26": {"vr": "OB", "BinaryLength": 536}, "27": {"vr": "OB", "BinaryLength": 536}, "28": {"vr": "OB", "BinaryLength": 536}, "29": {"vr": "OB", "BinaryLength": 536}, "30": {"vr": "OB", "BinaryLength": 536}, "31": {"vr": "OB", "BinaryLength": 536}, "32": {"vr": "OB", "BinaryLength": 536}, "33": {"vr": "OB", "BinaryLength": 536}, "34": {"vr": "OB", "BinaryLength": 536}, "35": {"vr": "OB", "BinaryLength": 536}, "36": {"vr": "OB", "BinaryLength": 536}, "37": {"vr": "OB", "BinaryLength": 536}, "38": {"vr": "OB", "BinaryLength": 536}, "39": {"vr": "OB", "BinaryLength": 536}, "40": {"vr": "OB", "BinaryLength": 536}, "41": {"vr": "OB", "BinaryLength": 536}, "42": {"vr": "OB", "BinaryLength": 536}, "43": {"vr": "OB", "BinaryLength": 536}, "44": {"vr": "OB", "BinaryLength": 536}, "45": {"vr": "OB", "BinaryLength": 536}, "46": {"vr": "OB", "BinaryLength": 536}, "47": {"vr": "OB", "BinaryLength": 536}, "48": {"vr": "OB", "BinaryLength": 536}, "49": {"vr": "OB", "BinaryLength": 536}, "50": {"vr": "OB", "BinaryLength": 536}, "51": {"vr": "OB", "BinaryLength": 536}, "52": {"vr": "OB", "BinaryLength": 536}, "53": {"vr": "OB", "BinaryLength": 536}, "54": {"vr": "OB", "BinaryLength": 536}, "55": {"vr": "OB", "BinaryLength": 536}, "56": {"vr": "OB", "BinaryLength": 536}, "57": {"vr": "OB", "BinaryLength": 536}, "58": {"vr": "OB", "BinaryLength": 536}, "59": {"vr": "OB", "BinaryLength": 536}, "60": {"vr": "OB", "BinaryLength": 536}, "61": {"vr": "OB", "BinaryLength": 536}, "62": {"vr": "OB", "BinaryLength": 536}, "63": {"vr": "OB", "BinaryLength": 536}, "64": {"vr": "OB", "BinaryLength": 536}, "65": {"vr": "OB", "BinaryLength": 536}, "66": {"vr": "OB", "BinaryLength": 536}, "67": {"vr": "OB", "BinaryLength": 536}, "68": {"vr": "OB", "BinaryLength": 536}, "69": {"vr": "OB", "BinaryLength": 536}, "70": {"vr": "OB", "BinaryLength": 536}, "71": {"vr": "OB", "BinaryLength": 536}, "72": {"vr": "OB", "BinaryLength": 536}, "73": {"vr": "OB", "BinaryLength": 536}, "74": {"vr": "OB", "BinaryLength": 536}, "75": {"vr": "OB", "BinaryLength": 536}, "76": {"vr": "OB", "BinaryLength": 536}, "77": {"vr": "OB", "BinaryLength": 536}, "78": {"vr": "OB", "BinaryLength": 536}, "79": {"vr": "OB", "BinaryLength": 536}, "80": {"vr": "OB", "BinaryLength": 536}, "81": {"vr": "OB", "BinaryLength": 536}, "82": {"vr": "OB", "BinaryLength": 536}, "83": {"vr": "OB", "BinaryLength": 536}, "84": {"vr": "OB", "BinaryLength": 536}, "85": {"vr": "OB", "BinaryLength": 536}, "86": {"vr": "OB", "BinaryLength": 536}, "87": {"vr": "OB", "BinaryLength": 536}, "88": {"vr": "OB", "BinaryLength": 536}, "89": {"vr": "OB", "BinaryLength": 536}, "90": {"vr": "OB", "BinaryLength": 536}, "91": {"vr": "OB", "BinaryLength": 536}, "92": {"vr": "OB", "BinaryLength": 536}, "93": {"vr": "OB", "BinaryLength": 536}, "94": {"vr": "OB", "BinaryLength": 536}, "95": {"vr": "OB", "BinaryLength": 536}, "96": {"vr": "OB", "BinaryLength": 536}, "97": {"vr": "OB", "BinaryLength": 536}, "98": {"vr": "OB", "BinaryLength": 536}, "99": {"vr": "OB", "BinaryLength": 536}, "100": {"vr": "OB", "BinaryLength": 536}, "101": {"vr": "OB", "BinaryLength": 536}, "102": {"vr": "OB", "BinaryLength": 536}, "103": {"vr": "OB", "BinaryLength": 536}, "104": {"vr": "OB", "BinaryLength": 536}, "105": {"vr": "OB", "BinaryLength": 536}, "106": {"vr": "OB", "BinaryLength": 536}, "107": {"vr": "OB", "BinaryLength": 536}, "108": {"vr": "OB", "BinaryLength": 536}, "109": {"vr": "OB", "BinaryLength": 536}, "110": {"vr": "OB", "BinaryLength": 536}, "111": {"vr": "OB", "BinaryLength": 536}, "112": {"vr": "OB", "BinaryLength": 536}, "113": {"vr": "OB", "BinaryLength": 536}, "114": {"vr": "OB", "BinaryLength": 536}, "115": {"vr": "OB", "BinaryLength": 536}, "116": {"vr": "OB", "BinaryLength": 536}, "117": {"vr": "OB", "BinaryLength": 536}, "118": {"vr": "OB", "BinaryLength": 536}, "119": {"vr": "OB", "BinaryLength": 536}, "120": {"vr": "OB", "BinaryLength": 536}, "121": {"vr": "OB", "BinaryLength": 536}, "122": {"vr": "OB", "BinaryLength": 536}, "123": {"vr": "OB", "BinaryLength": 536}, "124": {"vr": "OB", "BinaryLength": 536}, "125": {"vr": "OB", "BinaryLength": 536}, "126": {"vr": "OB", "BinaryLength": 536}, "127": {"vr": "OB", "BinaryLength": 536}, "128": {"vr": "OB", "BinaryLength": 536}, "129": {"vr": "OB", "BinaryLength": 536}, "130": {"vr": "OB", "BinaryLength": 536}, "131": {"vr": "OB", "BinaryLength": 536}, "132": {"vr": "OB", "BinaryLength": 536}, "133": {"vr": "OB", "BinaryLength": 536}, "134": {"vr": "OB", "BinaryLength": 536}, "135": {"vr": "OB", "BinaryLength": 536}, "136": {"vr": "OB", "BinaryLength": 536}, "137": {"vr": "OB", "BinaryLength": 536}, "138": {"vr": "OB", "BinaryLength": 536}, "139": {"vr": "OB", "BinaryLength": 536}, "140": {"vr": "OB", "BinaryLength": 536}, "141": {"vr": "OB", "BinaryLength": 536}, "142": {"vr": "OB", "BinaryLength": 536}, "143": {"vr": "OB", "BinaryLength": 536}, "144": {"vr": "OB", "BinaryLength": 536}, "145": {"vr": "OB", "BinaryLength": 536}, "146": {"vr": "OB", "BinaryLength": 536}, "147": {"vr": "OB", "BinaryLength": 536}, "148": {"vr": "OB", "BinaryLength": 536}, "149": {"vr": "OB", "BinaryLength": 536}, "150": {"vr": "OB", "BinaryLength": 536}, "151": {"vr": "OB", "BinaryLength": 536}, "152": {"vr": "OB", "BinaryLength": 536}, "153": {"vr": "OB", "BinaryLength": 536}, "154": {"vr": "OB", "BinaryLength": 536}, "155": {"vr": "OB", "BinaryLength": 536}, "156": {"vr": "OB", "BinaryLength": 536}, "157": {"vr": "OB", "BinaryLength": 536}, "158": {"vr": "OB", "BinaryLength": 536}, "159": {"vr": "OB", "BinaryLength": 536}, "160": {"vr": "OB", "BinaryLength": 536}, "161": {"vr": "OB", "BinaryLength": 536}, "162": {"vr": "OB", "BinaryLength": 536}, "163": {"vr": "OB", "BinaryLength": 536}, "164": {"vr": "OB", "BinaryLength": 536}, "165": {"vr": "OB", "BinaryLength": 536}, "166": {"vr": "OB", "BinaryLength": 536}, "167": {"vr": "OB", "BinaryLength": 536}, "168": {"vr": "OB", "BinaryLength": 536}, "169": {"vr": "OB", "BinaryLength": 536}, "170": {"vr": "OB", "BinaryLength": 536}, "171": {"vr": "OB", "BinaryLength": 536}, "172": {"vr": "OB", "BinaryLength": 536}, "173": {"vr": "OB", "BinaryLength": 536}, "174": {"vr": "OB", "BinaryLength": 536}, "175": {"vr": "OB", "BinaryLength": 536}, "176": {"vr": "OB", "BinaryLength": 536}, "177": {"vr": "OB", "BinaryLength": 536}, "178": {"vr": "OB", "BinaryLength": 536}, "179": {"vr": "OB", "BinaryLength": 536}, "180": {"vr": "OB", "BinaryLength": 536}, "181": {"vr": "OB", "BinaryLength": 536}, "182": {"vr": "OB", "BinaryLength": 536}, "183": {"vr": "OB", "BinaryLength": 536}, "184": {"vr": "OB", "BinaryLength": 536}, "185": {"vr": "OB", "BinaryLength": 536}, "186": {"vr": "OB", "BinaryLength": 536}, "187": {"vr": "OB", "BinaryLength": 536}, "188": {"vr": "OB", "BinaryLength": 536}, "189": {"vr": "OB", "BinaryLength": 536}, "190": {"vr": "OB", "BinaryLength": 536}, "191": {"vr": "OB", "BinaryLength": 536}, "192": {"vr": "OB", "BinaryLength": 536}, "193": {"vr": "OB", "BinaryLength": 536}, "194": {"vr": "OB", "BinaryLength": 536}, "195": {"vr": "OB", "BinaryLength": 536}, "196": {"vr": "OB", "BinaryLength": 536}, "197": {"vr": "OB", "BinaryLength": 536}, "198": {"vr": "OB", "BinaryLength": 536}, "199": {"vr": "OB", "BinaryLength": 536}, "200": {"vr": "OB", "BinaryLength": 536}, "201": {"vr": "OB", "BinaryLength": 536}, "202": {"vr": "OB", "BinaryLength": 536}, "203": {"vr": "OB", "BinaryLength": 536}, "204": {"vr": "OB", "BinaryLength": 536}, "205": {"vr": "OB", "BinaryLength": 536}, "206": {"vr": "OB", "BinaryLength": 536}, "207": {"vr": "OB", "BinaryLength": 536}, "208": {"vr": "OB", "BinaryLength": 536}, "209": {"vr": "OB", "BinaryLength": 536}, "210": {"vr": "OB", "BinaryLength": 536}, "211": {"vr": "OB", "BinaryLength": 536}, "212": {"vr": "OB", "BinaryLength": 536}, "213": {"vr": "OB", "BinaryLength": 536}, "214": {"vr": "OB", "BinaryLength": 536}, "215": {"vr": "OB", "BinaryLength": 536}, "216": {"vr": "OB", "BinaryLength": 536}, "217": {"vr": "OB", "BinaryLength": 536}, "218": {"vr": "OB", "BinaryLength": 536}, "219": {"vr": "OB", "BinaryLength": 536}, "220": {"vr": "OB", "BinaryLength": 536}, "221": {"vr": "OB", "BinaryLength": 536}, "222": {"vr": "OB", "BinaryLength": 536}, "223": {"vr": "OB", "BinaryLength": 536}, "224": {"vr": "OB", "BinaryLength": 536}, "225": {"vr": "OB", "BinaryLength": 536}, "226": {"vr": "OB", "BinaryLength": 536}, "227": {"vr": "OB", "BinaryLength": 536}, "228": {"vr": "OB", "BinaryLength": 536}, "229": {"vr": "OB", "BinaryLength": 536}, "230": {"vr": "OB", "BinaryLength": 536}, "231": {"vr": "OB", "BinaryLength": 536}, "232": {"vr": "OB", "BinaryLength": 536}, "233": {"vr": "OB", "BinaryLength": 536}, "234": {"vr": "OB", "BinaryLength": 536}, "235": {"vr": "OB", "BinaryLength": 536}, "236": {"vr": "OB", "BinaryLength": 536}, "237": {"vr": "OB", "BinaryLength": 536}, "238": {"vr": "OB", "BinaryLength": 536}, "239": {"vr": "OB", "BinaryLength": 536}, "240": {"vr": "OB", "BinaryLength": 536}, "241": {"vr": "OB", "BinaryLength": 536}, "242": {"vr": "OB", "BinaryLength": 536}, "243": {"vr": "OB", "BinaryLength": 536}, "244": {"vr": "OB", "BinaryLength": 536}, "245": {"vr": "OB", "BinaryLength": 536}, "246": {"vr": "OB", "BinaryLength": 536}, "247": {"vr": "OB", "BinaryLength": 536}, "248": {"vr": "OB", "BinaryLength": 536}, "249": {"vr": "OB", "BinaryLength": 536}, "250": {"vr": "OB", "BinaryLength": 536}, "251": {"vr": "OB", "BinaryLength": 536}, "252": {"vr": "OB", "BinaryLength": 536}, "253": {"vr": "OB", "BinaryLength": 536}, "254": {"vr": "OB", "BinaryLength": 536}, "255": {"vr": "OB", "BinaryLength": 536}, "256": {"vr": "OB", "BinaryLength": 536}, "257": {"vr": "OB", "BinaryLength": 536}, "258": {"vr": "OB", "BinaryLength": 536}, "259": {"vr": "OB", "BinaryLength": 536}, "260": {"vr": "OB", "BinaryLength": 536}, "261": {"vr": "OB", "BinaryLength": 536}, "262": {"vr": "OB", "BinaryLength": 536}, "263": {"vr": "OB", "BinaryLength": 536}, "264": {"vr": "OB", "BinaryLength": 536}, "265": {"vr": "OB", "BinaryLength": 536}, "266": {"vr": "OB", "BinaryLength": 536}, "267": {"vr": "OB", "BinaryLength": 536}, "268": {"vr": "OB", "BinaryLength": 536}, "269": {"vr": "OB", "BinaryLength": 536}, "270": {"vr": "OB", "BinaryLength": 536}, "271": {"vr": "OB", "BinaryLength": 536}, "272": {"vr": "OB", "BinaryLength": 536}, "273": {"vr": "OB", "BinaryLength": 536}, "274": {"vr": "OB", "BinaryLength": 536}, "275": {"vr": "OB", "BinaryLength": 536}, "276": {"vr": "OB", "BinaryLength": 536}, "277": {"vr": "OB", "BinaryLength": 536}, "278": {"vr": "OB", "BinaryLength": 536}, "279": {"vr": "OB", "BinaryLength": 536}, "280": {"vr": "OB", "BinaryLength": 536}, "281": {"vr": "OB", "BinaryLength": 536}, "282": {"vr": "OB", "BinaryLength": 536}, "283": {"vr": "OB", "BinaryLength": 536}, "284": {"vr": "OB", "BinaryLength": 536}, "285": {"vr": "OB", "BinaryLength": 536}, "286": {"vr": "OB", "BinaryLength": 536}, "287": {"vr": "OB", "BinaryLength": 536}, "288": {"vr": "OB", "BinaryLength": 536}, "289": {"vr": "OB", "BinaryLength": 536}, "290": {"vr": "OB", "BinaryLength": 536}, "291": {"vr": "OB", "BinaryLength": 536}, "292": {"vr": "OB", "BinaryLength": 536}, "293": {"vr": "OB", "BinaryLength": 536}, "294": {"vr": "OB", "BinaryLength": 536}, "295": {"vr": "OB", "BinaryLength": 536}, "296": {"vr": "OB", "BinaryLength": 536}, "297": {"vr": "OB", "BinaryLength": 536}, "298": {"vr": "OB", "BinaryLength": 536}, "299": {"vr": "OB", "BinaryLength": 536}, "300": {"vr": "OB", "BinaryLength": 536}, "301": {"vr": "OB", "BinaryLength": 536}, "302": {"vr": "OB", "BinaryLength": 536}, "303": {"vr": "OB", "BinaryLength": 536}, "304": {"vr": "OB", "BinaryLength": 536}, "305": {"vr": "OB", "BinaryLength": 536}, "306": {"vr": "OB", "BinaryLength": 536}, "307": {"vr": "OB", "BinaryLength": 536}, "308": {"vr": "OB", "BinaryLength": 536}, "309": {"vr": "OB", "BinaryLength": 536}, "310": {"vr": "OB", "BinaryLength": 536}, "311": {"vr": "OB", "BinaryLength": 536}, "312": {"vr": "OB", "BinaryLength": 536}, "313": {"vr": "OB", "BinaryLength": 536}, "314": {"vr": "OB", "BinaryLength": 536}, "315": {"vr": "OB", "BinaryLength": 536}, "316": {"vr": "OB", "BinaryLength": 536}, "317": {"vr": "OB", "BinaryLength": 536}, "318": {"vr": "OB", "BinaryLength": 536}, "319": {"vr": "OB", "BinaryLength": 536}, "320": {"vr": "OB", "BinaryLength": 536}, "321": {"vr": "OB", "BinaryLength": 536}, "322": {"vr": "OB", "BinaryLength": 536}, "323": {"vr": "OB", "BinaryLength": 536}, "324": {"vr": "OB", "BinaryLength": 536}, "325": {"vr": "OB", "BinaryLength": 536}, "326": {"vr": "OB", "BinaryLength": 536}, "327": {"vr": "OB", "BinaryLength": 536}, "328": {"vr": "OB", "BinaryLength": 536}, "329": {"vr": "OB", "BinaryLength": 536}, "330": {"vr": "OB", "BinaryLength": 536}, "331": {"vr": "OB", "BinaryLength": 536}, "332": {"vr": "OB", "BinaryLength": 536}, "333": {"vr": "OB", "BinaryLength": 536}, "334": {"vr": "OB", "BinaryLength": 536}, "335": {"vr": "OB", "BinaryLength": 536}, "336": {"vr": "OB", "BinaryLength": 536}, "337": {"vr": "OB", "BinaryLength": 536}, "338": {"vr": "OB", "BinaryLength": 536}, "339": {"vr": "OB", "BinaryLength": 536}, "340": {"vr": "OB", "BinaryLength": 536}, "341": {"vr": "OB", "BinaryLength": 536}, "342": {"vr": "OB", "BinaryLength": 536}, "343": {"vr": "OB", "BinaryLength": 536}, "344": {"vr": "OB", "BinaryLength": 536}, "345": {"vr": "OB", "BinaryLength": 536}, "346": {"vr": "OB", "BinaryLength": 536}, "347": {"vr": "OB", "BinaryLength": 536}, "348": {"vr": "OB", "BinaryLength": 536}, "349": {"vr": "OB", "BinaryLength": 536}, "350": {"vr": "OB", "BinaryLength": 536}, "351": {"vr": "OB", "BinaryLength": 536}, "352": {"vr": "OB", "BinaryLength": 536}, "353": {"vr": "OB", "BinaryLength": 536}, "354": {"vr": "OB", "BinaryLength": 536}, "355": {"vr": "OB", "BinaryLength": 536}, "356": {"vr": "OB", "BinaryLength": 536}, "357": {"vr": "OB", "BinaryLength": 536}, "358": {"vr": "OB", "BinaryLength": 536}, "359": {"vr": "OB", "BinaryLength": 536}, "360": {"vr": "OB", "BinaryLength": 536}, "361": {"vr": "OB", "BinaryLength": 536}, "362": {"vr": "OB", "BinaryLength": 536}, "363": {"vr": "OB", "BinaryLength": 536}, "364": {"vr": "OB", "BinaryLength": 536}, "365": {"vr": "OB", "BinaryLength": 536}, "366": {"vr": "OB", "BinaryLength": 536}, "367": {"vr": "OB", "BinaryLength": 536}, "368": {"vr": "OB", "BinaryLength": 536}, "369": {"vr": "OB", "BinaryLength": 536}, "370": {"vr": "OB", "BinaryLength": 536}, "371": {"vr": "OB", "BinaryLength": 536}, "372": {"vr": "OB", "BinaryLength": 536}, "373": {"vr": "OB", "BinaryLength": 536}, "374": {"vr": "OB", "BinaryLength": 536}, "375": {"vr": "OB", "BinaryLength": 536}, "376": {"vr": "OB", "BinaryLength": 536}, "377": {"vr": "OB", "BinaryLength": 536}, "378": {"vr": "OB", "BinaryLength": 536}, "379": {"vr": "OB", "BinaryLength": 536}, "380": {"vr": "OB", "BinaryLength": 536}, "381": {"vr": "OB", "BinaryLength": 536}, "382": {"vr": "OB", "BinaryLength": 536}, "383": {"vr": "OB", "BinaryLength": 536}, "384": {"vr": "OB", "BinaryLength": 536}, "385": {"vr": "OB", "BinaryLength": 536}, "386": {"vr": "OB", "BinaryLength": 536}, "387": {"vr": "OB", "BinaryLength": 536}, "388": {"vr": "OB", "BinaryLength": 536}, "389": {"vr": "OB", "BinaryLength": 536}, "390": {"vr": "OB", "BinaryLength": 536}, "391": {"vr": "OB", "BinaryLength": 536}, "392": {"vr": "OB", "BinaryLength": 536}, "393": {"vr": "OB", "BinaryLength": 536}, "394": {"vr": "OB", "BinaryLength": 536}, "395": {"vr": "OB", "BinaryLength": 536}, "396": {"vr": "OB", "BinaryLength": 536}, "397": {"vr": "OB", "BinaryLength": 536}, "398": {"vr": "OB", "BinaryLength": 536}, "399": {"vr": "OB", "BinaryLength": 536}, "400": {"vr": "OB", "BinaryLength": 536}, "401": {"vr": "OB", "BinaryLength": 536}, "402": {"vr": "OB", "BinaryLength": 536}, "403": {"vr": "OB", "BinaryLength": 536}, "404": {"vr": "OB", "BinaryLength": 536}, "405": {"vr": "OB", "BinaryLength": 536}, "406": {"vr": "OB", "BinaryLength": 536}, "407": {"vr": "OB", "BinaryLength": 536}, "408": {"vr": "OB", "BinaryLength": 536}, "409": {"vr": "OB", "BinaryLength": 536}, "410": {"vr": "OB", "BinaryLength": 536}, "411": {"vr": "OB", "BinaryLength": 536}, "412": {"vr": "OB", "BinaryLength": 536}, "413": {"vr": "OB", "BinaryLength": 536}, "414": {"vr": "OB", "BinaryLength": 536}, "415": {"vr": "OB", "BinaryLength": 536}, "416": {"vr": "OB", "BinaryLength": 536}, "417": {"vr": "OB", "BinaryLength": 536}, "418": {"vr": "OB", "BinaryLength": 536}, "419": {"vr": "OB", "BinaryLength": 536}, "420": {"vr": "OB", "BinaryLength": 536}, "421": {"vr": "OB", "BinaryLength": 536}, "422": {"vr": "OB", "BinaryLength": 536}, "423": {"vr": "OB", "BinaryLength": 536}, "424": {"vr": "OB", "BinaryLength": 536}, "425": {"vr": "OB", "BinaryLength": 536}, "426": {"vr": "OB", "BinaryLength": 536}, "427": {"vr": "OB", "BinaryLength": 536}, "428": {"vr": "OB", "BinaryLength": 536}, "429": {"vr": "OB", "BinaryLength": 536}, "430": {"vr": "OB", "BinaryLength": 536}, "431": {"vr": "OB", "BinaryLength": 536}, "432": {"vr": "OB", "BinaryLength": 536}, "433": {"vr": "OB", "BinaryLength": 536}, "434": {"vr": "OB", "BinaryLength": 536}, "435": {"vr": "OB", "BinaryLength": 536}, "436": {"vr": "OB", "BinaryLength": 536}, "437": {"vr": "OB", "BinaryLength": 536}, "438": {"vr": "OB", "BinaryLength": 536}, "439": {"vr": "OB", "BinaryLength": 536}, "440": {"vr": "OB", "BinaryLength": 536}, "441": {"vr": "OB", "BinaryLength": 536}, "442": {"vr": "OB", "BinaryLength": 536}, "443": {"vr": "OB", "BinaryLength": 536}, "444": {"vr": "OB", "BinaryLength": 536}, "445": {"vr": "OB", "BinaryLength": 536}, "446": {"vr": "OB", "BinaryLength": 536}, "447": {"vr": "OB", "BinaryLength": 536}, "448": {"vr": "OB", "BinaryLength": 536}, "449": {"vr": "OB", "BinaryLength": 536}, "450": {"vr": "OB", "BinaryLength": 536}, "451": {"vr": "OB", "BinaryLength": 536}, "452": {"vr": "OB", "BinaryLength": 536}, "453": {"vr": "OB", "BinaryLength": 536}, "454": {"vr": "OB", "BinaryLength": 536}, "455": {"vr": "OB", "BinaryLength": 536}, "456": {"vr": "OB", "BinaryLength": 536}, "457": {"vr": "OB", "BinaryLength": 536}, "458": {"vr": "OB", "BinaryLength": 536}, "459": {"vr": "OB", "BinaryLength": 536}, "460": {"vr": "OB", "BinaryLength": 536}, "461": {"vr": "OB", "BinaryLength": 536}, "462": {"vr": "OB", "BinaryLength": 536}, "463": {"vr": "OB", "BinaryLength": 536}, "464": {"vr": "OB", "BinaryLength": 536}, "465": {"vr": "OB", "BinaryLength": 536}, "466": {"vr": "OB", "BinaryLength": 536}, "467": {"vr": "OB", "BinaryLength": 536}, "468": {"vr": "OB", "BinaryLength": 536}, "469": {"vr": "OB", "BinaryLength": 536}, "470": {"vr": "OB", "BinaryLength": 536}, "471": {"vr": "OB", "BinaryLength": 536}, "472": {"vr": "OB", "BinaryLength": 536}, "473": {"vr": "OB", "BinaryLength": 536}, "474": {"vr": "OB", "BinaryLength": 536}, "475": {"vr": "OB", "BinaryLength": 536}, "476": {"vr": "OB", "BinaryLength": 536}, "477": {"vr": "OB", "BinaryLength": 536}, "478": {"vr": "OB", "BinaryLength": 536}, "479": {"vr": "OB", "BinaryLength": 536}, "480": {"vr": "OB", "BinaryLength": 536}, "481": {"vr": "OB", "BinaryLength": 536}, "482": {"vr": "OB", "BinaryLength": 536}, "483": {"vr": "OB", "BinaryLength": 536}, "484": {"vr": "OB", "BinaryLength": 536}, "485": {"vr": "OB", "BinaryLength": 536}, "486": {"vr": "OB", "BinaryLength": 536}, "487": {"vr": "OB", "BinaryLength": 536}, "488": {"vr": "OB", "BinaryLength": 536}, "489": {"vr": "OB", "BinaryLength": 536}, "490": {"vr": "OB", "BinaryLength": 536}, "491": {"vr": "OB", "BinaryLength": 536}, "492": {"vr": "OB", "BinaryLength": 536}, "493": {"vr": "OB", "BinaryLength": 536}, "494": {"vr": "OB", "BinaryLength": 536}, "495": {"vr": "OB", "BinaryLength": 536}, "496": {"vr": "OB", "BinaryLength": 536}, "497": {"vr": "OB", "BinaryLength": 536}, "498": {"vr": "OB", "BinaryLength": 536}, "499": {"vr": "OB", "BinaryLength": 536}, "500": {"vr": "OB", "BinaryLength": 536}, "501": {"vr": "OB", "BinaryLength": 536}, "502": {"vr": "OB", "BinaryLength": 536}, "503": {"vr": "OB", "BinaryLength": 536}, "504": {"vr": "OB", "BinaryLength": 536}, "505": {"vr": "OB", "BinaryLength": 536}, "506": {"vr": "OB", "BinaryLength": 536}, "507": {"vr": "OB", "BinaryLength": 536}, "508": {"vr": "OB", "BinaryLength": 536}, "509": {"vr": "OB", "BinaryLength": 536}, "510": {"vr": "OB", "BinaryLength": 536}, "511": {"vr": "OB", "BinaryLength": 536}, "512": {"vr": "OB", "BinaryLength": 536}, "513": {"vr": "OB", "BinaryLength": 536}, "514": {"vr": "OB", "BinaryLength": 536}, "515": {"vr": "OB", "BinaryLength": 536}, "516": {"vr": "OB", "BinaryLength": 536}, "517": {"vr": "OB", "BinaryLength": 536}, "518": {"vr": "OB", "BinaryLength": 536}, "519": {"vr": "OB", "BinaryLength": 536}, "520": {"vr": "OB", "BinaryLength": 536}, "521": {"vr": "OB", "BinaryLength": 536}, "522": {"vr": "OB", "BinaryLength": 536}, "523": {"vr": "OB", "BinaryLength": 536}, "524": {"vr": "OB", "BinaryLength": 536}, "525": {"vr": "OB", "BinaryLength": 536}, "526": {"vr": "OB", "BinaryLength": 536}, "527": {"vr": "OB", "BinaryLength": 536}, "528": {"vr": "OB", "BinaryLength": 536}, "529": {"vr": "OB", "BinaryLength": 536}, "530": {"vr": "OB", "BinaryLength": 536}}, "7FE00010": {"0": {"vr": "OW", "BinaryLength": 516268}, "1": {"vr": "OW", "BinaryLength": 516268}, "2": {"vr": "OW", "BinaryLength": 516268}, "3": {"vr": "OW", "BinaryLength": 516268}, "4": {"vr": "OW", "BinaryLength": 516268}, "5": {"vr": "OW", "BinaryLength": 516268}, "6": {"vr": "OW", "BinaryLength": 516268}, "7": {"vr": "OW", "BinaryLength": 516268}, "8": {"vr": "OW", "BinaryLength": 516268}, "9": {"vr": "OW", "BinaryLength": 516268}, "10": {"vr": "OW", "BinaryLength": 516268}, "11": {"vr": "OW", "BinaryLength": 516268}, "12": {"vr": "OW", "BinaryLength": 516268}, "13": {"vr": "OW", "BinaryLength": 516268}, "14": {"vr": "OW", "BinaryLength": 516268}, "15": {"vr": "OW", "BinaryLength": 516268}, "16": {"vr": "OW", "BinaryLength": 516268}, "17": {"vr": "OW", "BinaryLength": 516268}, "18": {"vr": "OW", "BinaryLength": 516268}, "19": {"vr": "OW", "BinaryLength": 516268}, "20": {"vr": "OW", "BinaryLength": 516268}, "21": {"vr": "OW", "BinaryLength": 516268}, "22": {"vr": "OW", "BinaryLength": 516268}, "23": {"vr": "OW", "BinaryLength": 516268}, "24": {"vr": "OW", "BinaryLength": 516268}, "25": {"vr": "OW", "BinaryLength": 516268}, "26": {"vr": "OW", "BinaryLength": 516268}, "27": {"vr": "OW", "BinaryLength": 516268}, "28": {"vr": "OW", "BinaryLength": 516268}, "29": {"vr": "OW", "BinaryLength": 516268}, "30": {"vr": "OW", "BinaryLength": 516268}, "31": {"vr": "OW", "BinaryLength": 516268}, "32": {"vr": "OW", "BinaryLength": 516268}, "33": {"vr": "OW", "BinaryLength": 516268}, "34": {"vr": "OW", "BinaryLength": 516268}, "35": {"vr": "OW", "BinaryLength": 516268}, "36": {"vr": "OW", "BinaryLength": 516268}, "37": {"vr": "OW", "BinaryLength": 516268}, "38": {"vr": "OW", "BinaryLength": 516268}, "39": {"vr": "OW", "BinaryLength": 516268}, "40": {"vr": "OW", "BinaryLength": 516268}, "41": {"vr": "OW", "BinaryLength": 516268}, "42": {"vr": "OW", "BinaryLength": 516268}, "43": {"vr": "OW", "BinaryLength": 516268}, "44": {"vr": "OW", "BinaryLength": 516268}, "45": {"vr": "OW", "BinaryLength": 516268}, "46": {"vr": "OW", "BinaryLength": 516268}, "47": {"vr": "OW", "BinaryLength": 516268}, "48": {"vr": "OW", "BinaryLength": 516268}, "49": {"vr": "OW", "BinaryLength": 516268}, "50": {"vr": "OW", "BinaryLength": 516268}, "51": {"vr": "OW", "BinaryLength": 516268}, "52": {"vr": "OW", "BinaryLength": 516268}, "53": {"vr": "OW", "BinaryLength": 516268}, "54": {"vr": "OW", "BinaryLength": 516268}, "55": {"vr": "OW", "BinaryLength": 516268}, "56": {"vr": "OW", "BinaryLength": 516268}, "57": {"vr": "OW", "BinaryLength": 516268}, "58": {"vr": "OW", "BinaryLength": 516268}, "59": {"vr": "OW", "BinaryLength": 516268}, "60": {"vr": "OW", "BinaryLength": 516268}, "61": {"vr": "OW", "BinaryLength": 516268}, "62": {"vr": "OW", "BinaryLength": 516268}, "63": {"vr": "OW", "BinaryLength": 516268}, "64": {"vr": "OW", "BinaryLength": 516268}, "65": {"vr": "OW", "BinaryLength": 516268}, "66": {"vr": "OW", "BinaryLength": 516268}, "67": {"vr": "OW", "BinaryLength": 516268}, "68": {"vr": "OW", "BinaryLength": 516268}, "69": {"vr": "OW", "BinaryLength": 516268}, "70": {"vr": "OW", "BinaryLength": 516268}, "71": {"vr": "OW", "BinaryLength": 516268}, "72": {"vr": "OW", "BinaryLength": 516268}, "73": {"vr": "OW", "BinaryLength": 516268}, "74": {"vr": "OW", "BinaryLength": 516268}, "75": {"vr": "OW", "BinaryLength": 516268}, "76": {"vr": "OW", "BinaryLength": 516268}, "77": {"vr": "OW", "BinaryLength": 516268}, "78": {"vr": "OW", "BinaryLength": 516268}, "79": {"vr": "OW", "BinaryLength": 516268}, "80": {"vr": "OW", "BinaryLength": 516268}, "81": {"vr": "OW", "BinaryLength": 516268}, "82": {"vr": "OW", "BinaryLength": 516268}, "83": {"vr": "OW", "BinaryLength": 516268}, "84": {"vr": "OW", "BinaryLength": 516268}, "85": {"vr": "OW", "BinaryLength": 516268}, "86": {"vr": "OW", "BinaryLength": 516268}, "87": {"vr": "OW", "BinaryLength": 516268}, "88": {"vr": "OW", "BinaryLength": 516268}, "89": {"vr": "OW", "BinaryLength": 516268}, "90": {"vr": "OW", "BinaryLength": 516268}, "91": {"vr": "OW", "BinaryLength": 516268}, "92": {"vr": "OW", "BinaryLength": 516268}, "93": {"vr": "OW", "BinaryLength": 516268}, "94": {"vr": "OW", "BinaryLength": 516268}, "95": {"vr": "OW", "BinaryLength": 516268}, "96": {"vr": "OW", "BinaryLength": 516268}, "97": {"vr": "OW", "BinaryLength": 516268}, "98": {"vr": "OW", "BinaryLength": 516268}, "99": {"vr": "OW", "BinaryLength": 516268}, "100": {"vr": "OW", "BinaryLength": 516268}, "101": {"vr": "OW", "BinaryLength": 516268}, "102": {"vr": "OW", "BinaryLength": 516268}, "103": {"vr": "OW", "BinaryLength": 516268}, "104": {"vr": "OW", "BinaryLength": 516268}, "105": {"vr": "OW", "BinaryLength": 516268}, "106": {"vr": "OW", "BinaryLength": 516268}, "107": {"vr": "OW", "BinaryLength": 516268}, "108": {"vr": "OW", "BinaryLength": 516268}, "109": {"vr": "OW", "BinaryLength": 516268}, "110": {"vr": "OW", "BinaryLength": 516268}, "111": {"vr": "OW", "BinaryLength": 516268}, "112": {"vr": "OW", "BinaryLength": 516268}, "113": {"vr": "OW", "BinaryLength": 516268}, "114": {"vr": "OW", "BinaryLength": 516268}, "115": {"vr": "OW", "BinaryLength": 516268}, "116": {"vr": "OW", "BinaryLength": 516268}, "117": {"vr": "OW", "BinaryLength": 516268}, "118": {"vr": "OW", "BinaryLength": 516268}, "119": {"vr": "OW", "BinaryLength": 516268}, "120": {"vr": "OW", "BinaryLength": 516268}, "121": {"vr": "OW", "BinaryLength": 516268}, "122": {"vr": "OW", "BinaryLength": 516268}, "123": {"vr": "OW", "BinaryLength": 516268}, "124": {"vr": "OW", "BinaryLength": 516268}, "125": {"vr": "OW", "BinaryLength": 516268}, "126": {"vr": "OW", "BinaryLength": 516268}, "127": {"vr": "OW", "BinaryLength": 516268}, "128": {"vr": "OW", "BinaryLength": 516268}, "129": {"vr": "OW", "BinaryLength": 516268}, "130": {"vr": "OW", "BinaryLength": 516268}, "131": {"vr": "OW", "BinaryLength": 516268}, "132": {"vr": "OW", "BinaryLength": 516268}, "133": {"vr": "OW", "BinaryLength": 516268}, "134": {"vr": "OW", "BinaryLength": 516268}, "135": {"vr": "OW", "BinaryLength": 516268}, "136": {"vr": "OW", "BinaryLength": 516268}, "137": {"vr": "OW", "BinaryLength": 516268}, "138": {"vr": "OW", "BinaryLength": 516268}, "139": {"vr": "OW", "BinaryLength": 516268}, "140": {"vr": "OW", "BinaryLength": 516268}, "141": {"vr": "OW", "BinaryLength": 516268}, "142": {"vr": "OW", "BinaryLength": 516268}, "143": {"vr": "OW", "BinaryLength": 516268}, "144": {"vr": "OW", "BinaryLength": 516268}, "145": {"vr": "OW", "BinaryLength": 516268}, "146": {"vr": "OW", "BinaryLength": 516268}, "147": {"vr": "OW", "BinaryLength": 516268}, "148": {"vr": "OW", "BinaryLength": 516268}, "149": {"vr": "OW", "BinaryLength": 516268}, "150": {"vr": "OW", "BinaryLength": 516268}, "151": {"vr": "OW", "BinaryLength": 516268}, "152": {"vr": "OW", "BinaryLength": 516268}, "153": {"vr": "OW", "BinaryLength": 516268}, "154": {"vr": "OW", "BinaryLength": 516268}, "155": {"vr": "OW", "BinaryLength": 516268}, "156": {"vr": "OW", "BinaryLength": 516268}, "157": {"vr": "OW", "BinaryLength": 516268}, "158": {"vr": "OW", "BinaryLength": 516268}, "159": {"vr": "OW", "BinaryLength": 516268}, "160": {"vr": "OW", "BinaryLength": 516268}, "161": {"vr": "OW", "BinaryLength": 516268}, "162": {"vr": "OW", "BinaryLength": 516268}, "163": {"vr": "OW", "BinaryLength": 516268}, "164": {"vr": "OW", "BinaryLength": 516268}, "165": {"vr": "OW", "BinaryLength": 516268}, "166": {"vr": "OW", "BinaryLength": 516268}, "167": {"vr": "OW", "BinaryLength": 516268}, "168": {"vr": "OW", "BinaryLength": 516268}, "169": {"vr": "OW", "BinaryLength": 516268}, "170": {"vr": "OW", "BinaryLength": 516268}, "171": {"vr": "OW", "BinaryLength": 516268}, "172": {"vr": "OW", "BinaryLength": 516268}, "173": {"vr": "OW", "BinaryLength": 516268}, "174": {"vr": "OW", "BinaryLength": 516268}, "175": {"vr": "OW", "BinaryLength": 516268}, "176": {"vr": "OW", "BinaryLength": 516268}, "177": {"vr": "OW", "BinaryLength": 516268}, "178": {"vr": "OW", "BinaryLength": 516268}, "179": {"vr": "OW", "BinaryLength": 516268}, "180": {"vr": "OW", "BinaryLength": 516268}, "181": {"vr": "OW", "BinaryLength": 516268}, "182": {"vr": "OW", "BinaryLength": 516268}, "183": {"vr": "OW", "BinaryLength": 516268}, "184": {"vr": "OW", "BinaryLength": 516268}, "185": {"vr": "OW", "BinaryLength": 516268}, "186": {"vr": "OW", "BinaryLength": 516268}, "187": {"vr": "OW", "BinaryLength": 516268}, "188": {"vr": "OW", "BinaryLength": 516268}, "189": {"vr": "OW", "BinaryLength": 516268}, "190": {"vr": "OW", "BinaryLength": 516268}, "191": {"vr": "OW", "BinaryLength": 516268}, "192": {"vr": "OW", "BinaryLength": 516268}, "193": {"vr": "OW", "BinaryLength": 516268}, "194": {"vr": "OW", "BinaryLength": 516268}, "195": {"vr": "OW", "BinaryLength": 516268}, "196": {"vr": "OW", "BinaryLength": 516268}, "197": {"vr": "OW", "BinaryLength": 516268}, "198": {"vr": "OW", "BinaryLength": 516268}, "199": {"vr": "OW", "BinaryLength": 516268}, "200": {"vr": "OW", "BinaryLength": 516268}, "201": {"vr": "OW", "BinaryLength": 516268}, "202": {"vr": "OW", "BinaryLength": 516268}, "203": {"vr": "OW", "BinaryLength": 516268}, "204": {"vr": "OW", "BinaryLength": 516268}, "205": {"vr": "OW", "BinaryLength": 516268}, "206": {"vr": "OW", "BinaryLength": 516268}, "207": {"vr": "OW", "BinaryLength": 516268}, "208": {"vr": "OW", "BinaryLength": 516268}, "209": {"vr": "OW", "BinaryLength": 516268}, "210": {"vr": "OW", "BinaryLength": 516268}, "211": {"vr": "OW", "BinaryLength": 516268}, "212": {"vr": "OW", "BinaryLength": 516268}, "213": {"vr": "OW", "BinaryLength": 516268}, "214": {"vr": "OW", "BinaryLength": 516268}, "215": {"vr": "OW", "BinaryLength": 516268}, "216": {"vr": "OW", "BinaryLength": 516268}, "217": {"vr": "OW", "BinaryLength": 516268}, "218": {"vr": "OW", "BinaryLength": 516268}, "219": {"vr": "OW", "BinaryLength": 516268}, "220": {"vr": "OW", "BinaryLength": 516268}, "221": {"vr": "OW", "BinaryLength": 516268}, "222": {"vr": "OW", "BinaryLength": 516268}, "223": {"vr": "OW", "BinaryLength": 516268}, "224": {"vr": "OW", "BinaryLength": 516268}, "225": {"vr": "OW", "BinaryLength": 516268}, "226": {"vr": "OW", "BinaryLength": 516268}, "227": {"vr": "OW", "BinaryLength": 516268}, "228": {"vr": "OW", "BinaryLength": 516268}, "229": {"vr": "OW", "BinaryLength": 516268}, "230": {"vr": "OW", "BinaryLength": 516268}, "231": {"vr": "OW", "BinaryLength": 516268}, "232": {"vr": "OW", "BinaryLength": 516268}, "233": {"vr": "OW", "BinaryLength": 516268}, "234": {"vr": "OW", "BinaryLength": 516268}, "235": {"vr": "OW", "BinaryLength": 516268}, "236": {"vr": "OW", "BinaryLength": 516268}, "237": {"vr": "OW", "BinaryLength": 516268}, "238": {"vr": "OW", "BinaryLength": 516268}, "239": {"vr": "OW", "BinaryLength": 516268}, "240": {"vr": "OW", "BinaryLength": 516268}, "241": {"vr": "OW", "BinaryLength": 516268}, "242": {"vr": "OW", "BinaryLength": 516268}, "243": {"vr": "OW", "BinaryLength": 516268}, "244": {"vr": "OW", "BinaryLength": 516268}, "245": {"vr": "OW", "BinaryLength": 516268}, "246": {"vr": "OW", "BinaryLength": 516268}, "247": {"vr": "OW", "BinaryLength": 516268}, "248": {"vr": "OW", "BinaryLength": 516268}, "249": {"vr": "OW", "BinaryLength": 516268}, "250": {"vr": "OW", "BinaryLength": 516268}, "251": {"vr": "OW", "BinaryLength": 516268}, "252": {"vr": "OW", "BinaryLength": 516268}, "253": {"vr": "OW", "BinaryLength": 516268}, "254": {"vr": "OW", "BinaryLength": 516268}, "255": {"vr": "OW", "BinaryLength": 516268}, "256": {"vr": "OW", "BinaryLength": 516268}, "257": {"vr": "OW", "BinaryLength": 516268}, "258": {"vr": "OW", "BinaryLength": 516268}, "259": {"vr": "OW", "BinaryLength": 516268}, "260": {"vr": "OW", "BinaryLength": 516268}, "261": {"vr": "OW", "BinaryLength": 516268}, "262": {"vr": "OW", "BinaryLength": 516268}, "263": {"vr": "OW", "BinaryLength": 516268}, "264": {"vr": "OW", "BinaryLength": 516268}, "265": {"vr": "OW", "BinaryLength": 516268}, "266": {"vr": "OW", "BinaryLength": 516268}, "267": {"vr": "OW", "BinaryLength": 516268}, "268": {"vr": "OW", "BinaryLength": 516268}, "269": {"vr": "OW", "BinaryLength": 516268}, "270": {"vr": "OW", "BinaryLength": 516268}, "271": {"vr": "OW", "BinaryLength": 516268}, "272": {"vr": "OW", "BinaryLength": 516268}, "273": {"vr": "OW", "BinaryLength": 516268}, "274": {"vr": "OW", "BinaryLength": 516268}, "275": {"vr": "OW", "BinaryLength": 516268}, "276": {"vr": "OW", "BinaryLength": 516268}, "277": {"vr": "OW", "BinaryLength": 516268}, "278": {"vr": "OW", "BinaryLength": 516268}, "279": {"vr": "OW", "BinaryLength": 516268}, "280": {"vr": "OW", "BinaryLength": 516268}, "281": {"vr": "OW", "BinaryLength": 516268}, "282": {"vr": "OW", "BinaryLength": 516268}, "283": {"vr": "OW", "BinaryLength": 516268}, "284": {"vr": "OW", "BinaryLength": 516268}, "285": {"vr": "OW", "BinaryLength": 516268}, "286": {"vr": "OW", "BinaryLength": 516268}, "287": {"vr": "OW", "BinaryLength": 516268}, "288": {"vr": "OW", "BinaryLength": 516268}, "289": {"vr": "OW", "BinaryLength": 516268}, "290": {"vr": "OW", "BinaryLength": 516268}, "291": {"vr": "OW", "BinaryLength": 516268}, "292": {"vr": "OW", "BinaryLength": 516268}, "293": {"vr": "OW", "BinaryLength": 516268}, "294": {"vr": "OW", "BinaryLength": 516268}, "295": {"vr": "OW", "BinaryLength": 516268}, "296": {"vr": "OW", "BinaryLength": 516268}, "297": {"vr": "OW", "BinaryLength": 516268}, "298": {"vr": "OW", "BinaryLength": 516268}, "299": {"vr": "OW", "BinaryLength": 516268}, "300": {"vr": "OW", "BinaryLength": 516268}, "301": {"vr": "OW", "BinaryLength": 516268}, "302": {"vr": "OW", "BinaryLength": 516268}, "303": {"vr": "OW", "BinaryLength": 516268}, "304": {"vr": "OW", "BinaryLength": 516268}, "305": {"vr": "OW", "BinaryLength": 516268}, "306": {"vr": "OW", "BinaryLength": 516268}, "307": {"vr": "OW", "BinaryLength": 516268}, "308": {"vr": "OW", "BinaryLength": 516268}, "309": {"vr": "OW", "BinaryLength": 516268}, "310": {"vr": "OW", "BinaryLength": 516268}, "311": {"vr": "OW", "BinaryLength": 516268}, "312": {"vr": "OW", "BinaryLength": 516268}, "313": {"vr": "OW", "BinaryLength": 516268}, "314": {"vr": "OW", "BinaryLength": 516268}, "315": {"vr": "OW", "BinaryLength": 516268}, "316": {"vr": "OW", "BinaryLength": 516268}, "317": {"vr": "OW", "BinaryLength": 516268}, "318": {"vr": "OW", "BinaryLength": 516268}, "319": {"vr": "OW", "BinaryLength": 516268}, "320": {"vr": "OW", "BinaryLength": 516268}, "321": {"vr": "OW", "BinaryLength": 516268}, "322": {"vr": "OW", "BinaryLength": 516268}, "323": {"vr": "OW", "BinaryLength": 516268}, "324": {"vr": "OW", "BinaryLength": 516268}, "325": {"vr": "OW", "BinaryLength": 516268}, "326": {"vr": "OW", "BinaryLength": 516268}, "327": {"vr": "OW", "BinaryLength": 516268}, "328": {"vr": "OW", "BinaryLength": 516268}, "329": {"vr": "OW", "BinaryLength": 516268}, "330": {"vr": "OW", "BinaryLength": 516268}, "331": {"vr": "OW", "BinaryLength": 516268}, "332": {"vr": "OW", "BinaryLength": 516268}, "333": {"vr": "OW", "BinaryLength": 516268}, "334": {"vr": "OW", "BinaryLength": 516268}, "335": {"vr": "OW", "BinaryLength": 516268}, "336": {"vr": "OW", "BinaryLength": 516268}, "337": {"vr": "OW", "BinaryLength": 516268}, "338": {"vr": "OW", "BinaryLength": 516268}, "339": {"vr": "OW", "BinaryLength": 516268}, "340": {"vr": "OW", "BinaryLength": 516268}, "341": {"vr": "OW", "BinaryLength": 516268}, "342": {"vr": "OW", "BinaryLength": 516268}, "343": {"vr": "OW", "BinaryLength": 516268}, "344": {"vr": "OW", "BinaryLength": 516268}, "345": {"vr": "OW", "BinaryLength": 516268}, "346": {"vr": "OW", "BinaryLength": 516268}, "347": {"vr": "OW", "BinaryLength": 516268}, "348": {"vr": "OW", "BinaryLength": 516268}, "349": {"vr": "OW", "BinaryLength": 516268}, "350": {"vr": "OW", "BinaryLength": 516268}, "351": {"vr": "OW", "BinaryLength": 516268}, "352": {"vr": "OW", "BinaryLength": 516268}, "353": {"vr": "OW", "BinaryLength": 516268}, "354": {"vr": "OW", "BinaryLength": 516268}, "355": {"vr": "OW", "BinaryLength": 516268}, "356": {"vr": "OW", "BinaryLength": 516268}, "357": {"vr": "OW", "BinaryLength": 516268}, "358": {"vr": "OW", "BinaryLength": 516268}, "359": {"vr": "OW", "BinaryLength": 516268}, "360": {"vr": "OW", "BinaryLength": 516268}, "361": {"vr": "OW", "BinaryLength": 516268}, "362": {"vr": "OW", "BinaryLength": 516268}, "363": {"vr": "OW", "BinaryLength": 516268}, "364": {"vr": "OW", "BinaryLength": 516268}, "365": {"vr": "OW", "BinaryLength": 516268}, "366": {"vr": "OW", "BinaryLength": 516268}, "367": {"vr": "OW", "BinaryLength": 516268}, "368": {"vr": "OW", "BinaryLength": 516268}, "369": {"vr": "OW", "BinaryLength": 516268}, "370": {"vr": "OW", "BinaryLength": 516268}, "371": {"vr": "OW", "BinaryLength": 516268}, "372": {"vr": "OW", "BinaryLength": 516268}, "373": {"vr": "OW", "BinaryLength": 516268}, "374": {"vr": "OW", "BinaryLength": 516268}, "375": {"vr": "OW", "BinaryLength": 516268}, "376": {"vr": "OW", "BinaryLength": 516268}, "377": {"vr": "OW", "BinaryLength": 516268}, "378": {"vr": "OW", "BinaryLength": 516268}, "379": {"vr": "OW", "BinaryLength": 516268}, "380": {"vr": "OW", "BinaryLength": 516268}, "381": {"vr": "OW", "BinaryLength": 516268}, "382": {"vr": "OW", "BinaryLength": 516268}, "383": {"vr": "OW", "BinaryLength": 516268}, "384": {"vr": "OW", "BinaryLength": 516268}, "385": {"vr": "OW", "BinaryLength": 516268}, "386": {"vr": "OW", "BinaryLength": 516268}, "387": {"vr": "OW", "BinaryLength": 516268}, "388": {"vr": "OW", "BinaryLength": 516268}, "389": {"vr": "OW", "BinaryLength": 516268}, "390": {"vr": "OW", "BinaryLength": 516268}, "391": {"vr": "OW", "BinaryLength": 516268}, "392": {"vr": "OW", "BinaryLength": 516268}, "393": {"vr": "OW", "BinaryLength": 516268}, "394": {"vr": "OW", "BinaryLength": 516268}, "395": {"vr": "OW", "BinaryLength": 516268}, "396": {"vr": "OW", "BinaryLength": 516268}, "397": {"vr": "OW", "BinaryLength": 516268}, "398": {"vr": "OW", "BinaryLength": 516268}, "399": {"vr": "OW", "BinaryLength": 516268}, "400": {"vr": "OW", "BinaryLength": 516268}, "401": {"vr": "OW", "BinaryLength": 516268}, "402": {"vr": "OW", "BinaryLength": 516268}, "403": {"vr": "OW", "BinaryLength": 516268}, "404": {"vr": "OW", "BinaryLength": 516268}, "405": {"vr": "OW", "BinaryLength": 516268}, "406": {"vr": "OW", "BinaryLength": 516268}, "407": {"vr": "OW", "BinaryLength": 516268}, "408": {"vr": "OW", "BinaryLength": 516268}, "409": {"vr": "OW", "BinaryLength": 516268}, "410": {"vr": "OW", "BinaryLength": 516268}, "411": {"vr": "OW", "BinaryLength": 516268}, "412": {"vr": "OW", "BinaryLength": 516268}, "413": {"vr": "OW", "BinaryLength": 516268}, "414": {"vr": "OW", "BinaryLength": 516268}, "415": {"vr": "OW", "BinaryLength": 516268}, "416": {"vr": "OW", "BinaryLength": 516268}, "417": {"vr": "OW", "BinaryLength": 516268}, "418": {"vr": "OW", "BinaryLength": 516268}, "419": {"vr": "OW", "BinaryLength": 516268}, "420": {"vr": "OW", "BinaryLength": 516268}, "421": {"vr": "OW", "BinaryLength": 516268}, "422": {"vr": "OW", "BinaryLength": 516268}, "423": {"vr": "OW", "BinaryLength": 516268}, "424": {"vr": "OW", "BinaryLength": 516268}, "425": {"vr": "OW", "BinaryLength": 516268}, "426": {"vr": "OW", "BinaryLength": 516268}, "427": {"vr": "OW", "BinaryLength": 516268}, "428": {"vr": "OW", "BinaryLength": 516268}, "429": {"vr": "OW", "BinaryLength": 516268}, "430": {"vr": "OW", "BinaryLength": 516268}, "431": {"vr": "OW", "BinaryLength": 516268}, "432": {"vr": "OW", "BinaryLength": 516268}, "433": {"vr": "OW", "BinaryLength": 516268}, "434": {"vr": "OW", "BinaryLength": 516268}, "435": {"vr": "OW", "BinaryLength": 516268}, "436": {"vr": "OW", "BinaryLength": 516268}, "437": {"vr": "OW", "BinaryLength": 516268}, "438": {"vr": "OW", "BinaryLength": 516268}, "439": {"vr": "OW", "BinaryLength": 516268}, "440": {"vr": "OW", "BinaryLength": 516268}, "441": {"vr": "OW", "BinaryLength": 516268}, "442": {"vr": "OW", "BinaryLength": 516268}, "443": {"vr": "OW", "BinaryLength": 516268}, "444": {"vr": "OW", "BinaryLength": 516268}, "445": {"vr": "OW", "BinaryLength": 516268}, "446": {"vr": "OW", "BinaryLength": 516268}, "447": {"vr": "OW", "BinaryLength": 516268}, "448": {"vr": "OW", "BinaryLength": 516268}, "449": {"vr": "OW", "BinaryLength": 516268}, "450": {"vr": "OW", "BinaryLength": 516268}, "451": {"vr": "OW", "BinaryLength": 516268}, "452": {"vr": "OW", "BinaryLength": 516268}, "453": {"vr": "OW", "BinaryLength": 516268}, "454": {"vr": "OW", "BinaryLength": 516268}, "455": {"vr": "OW", "BinaryLength": 516268}, "456": {"vr": "OW", "BinaryLength": 516268}, "457": {"vr": "OW", "BinaryLength": 516268}, "458": {"vr": "OW", "BinaryLength": 516268}, "459": {"vr": "OW", "BinaryLength": 516268}, "460": {"vr": "OW", "BinaryLength": 516268}, "461": {"vr": "OW", "BinaryLength": 516268}, "462": {"vr": "OW", "BinaryLength": 516268}, "463": {"vr": "OW", "BinaryLength": 516268}, "464": {"vr": "OW", "BinaryLength": 516268}, "465": {"vr": "OW", "BinaryLength": 516268}, "466": {"vr": "OW", "BinaryLength": 516268}, "467": {"vr": "OW", "BinaryLength": 516268}, "468": {"vr": "OW", "BinaryLength": 516268}, "469": {"vr": "OW", "BinaryLength": 516268}, "470": {"vr": "OW", "BinaryLength": 516268}, "471": {"vr": "OW", "BinaryLength": 516268}, "472": {"vr": "OW", "BinaryLength": 516268}, "473": {"vr": "OW", "BinaryLength": 516268}, "474": {"vr": "OW", "BinaryLength": 516268}, "475": {"vr": "OW", "BinaryLength": 516268}, "476": {"vr": "OW", "BinaryLength": 516268}, "477": {"vr": "OW", "BinaryLength": 516268}, "478": {"vr": "OW", "BinaryLength": 516268}, "479": {"vr": "OW", "BinaryLength": 516268}, "480": {"vr": "OW", "BinaryLength": 516268}, "481": {"vr": "OW", "BinaryLength": 516268}, "482": {"vr": "OW", "BinaryLength": 516268}, "483": {"vr": "OW", "BinaryLength": 516268}, "484": {"vr": "OW", "BinaryLength": 516268}, "485": {"vr": "OW", "BinaryLength": 516268}, "486": {"vr": "OW", "BinaryLength": 516268}, "487": {"vr": "OW", "BinaryLength": 516268}, "488": {"vr": "OW", "BinaryLength": 516268}, "489": {"vr": "OW", "BinaryLength": 516268}, "490": {"vr": "OW", "BinaryLength": 516268}, "491": {"vr": "OW", "BinaryLength": 516268}, "492": {"vr": "OW", "BinaryLength": 516268}, "493": {"vr": "OW", "BinaryLength": 516268}, "494": {"vr": "OW", "BinaryLength": 516268}, "495": {"vr": "OW", "BinaryLength": 516268}, "496": {"vr": "OW", "BinaryLength": 516268}, "497": {"vr": "OW", "BinaryLength": 516268}, "498": {"vr": "OW", "BinaryLength": 516268}, "499": {"vr": "OW", "BinaryLength": 516268}, "500": {"vr": "OW", "BinaryLength": 516268}, "501": {"vr": "OW", "BinaryLength": 516268}, "502": {"vr": "OW", "BinaryLength": 516268}, "503": {"vr": "OW", "BinaryLength": 516268}, "504": {"vr": "OW", "BinaryLength": 516268}, "505": {"vr": "OW", "BinaryLength": 516268}, "506": {"vr": "OW", "BinaryLength": 516268}, "507": {"vr": "OW", "BinaryLength": 516268}, "508": {"vr": "OW", "BinaryLength": 516268}, "509": {"vr": "OW", "BinaryLength": 516268}, "510": {"vr": "OW", "BinaryLength": 516268}, "511": {"vr": "OW", "BinaryLength": 516268}, "512": {"vr": "OW", "BinaryLength": 516268}, "513": {"vr": "OW", "BinaryLength": 516268}, "514": {"vr": "OW", "BinaryLength": 516268}, "515": {"vr": "OW", "BinaryLength": 516268}, "516": {"vr": "OW", "BinaryLength": 516268}, "517": {"vr": "OW", "BinaryLength": 516268}, "518": {"vr": "OW", "BinaryLength": 516268}, "519": {"vr": "OW", "BinaryLength": 516268}, "520": {"vr": "OW", "BinaryLength": 516268}, "521": {"vr": "OW", "BinaryLength": 516268}, "522": {"vr": "OW", "BinaryLength": 516268}, "523": {"vr": "OW", "BinaryLength": 516268}, "524": {"vr": "OW", "BinaryLength": 516268}, "525": {"vr": "OW", "BinaryLength": 516268}, "526": {"vr": "OW", "BinaryLength": 516268}, "527": {"vr": "OW", "BinaryLength": 516268}, "528": {"vr": "OW", "BinaryLength": 516268}, "529": {"vr": "OW", "BinaryLength": 516268}, "530": {"vr": "OW", "BinaryLength": 516268}}}


