from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__), **kwargs):
    hdr = evolve_header(constant_hdr, **kwargs)
    return generate_dicom(out_dir, num_vols, hdr,
                          collated_data, varying_hdr)


num_vols = 531


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.128"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20230825"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "144927.519000"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "152419.000000"
        ]
    },
    "00080032": {
        "vr": "TM",
        "Value": [
            "152419.000000"
        ]
    },
    "00080050": {
        "vr": "SH",
        "Value": [
            "987654321"
        ]
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "PT"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "SIEMENS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "Address of said institute"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "University"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "QUADRA10016"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^Project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "PET SWB 8MIN"
        ]
    },
    "00081040": {
        "vr": "LO",
        "Value": [
            "PET"
        ]
    },
    "00081050": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Principal Investigator"
            }
        ]
    },
    "00081070": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Sydney Imaging"
            }
        ]
    },
    "00081080": {
        "vr": "LO",
        "Value": [
            "Physics"
        ]
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "Biograph128_Vision Quadra Edge"
        ]
    },
    "00081250": {
        "vr": "SQ",
        "Value": [
            {
                "0020000D": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.30000023082422093565300000019"
                    ]
                },
                "0020000E": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.30000023082421255920000017965"
                    ]
                },
                "0040A170": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "122401"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "DCM"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "Same Anatomy"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20030619000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "7210"
                                ]
                            }
                        },
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "122403"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "DCM"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "For Attenuation Correction"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20030619000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "7210"
                                ]
                            }
                        }
                    ]
                }
            }
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Session Identifier"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "Session Label"
        ]
    },
    "00100030": {
        "vr": "DA",
        "Value": [
            "19800228"
        ]
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "M"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "043Y"
        ]
    },
    "00101020": {
        "vr": "DS",
        "Value": [
            1.8
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            75.0
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "PARTIALBODY"
        ]
    },
    "00180050": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "10016"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "VR20B"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "U_FDG_SWB_LM (Adult)"
        ]
    },
    "00181181": {
        "vr": "CS",
        "Value": [
            "NONE"
        ]
    },
    "00181200": {
        "vr": "DA",
        "Value": [
            "20230825",
            "20230611"
        ]
    },
    "00181201": {
        "vr": "TM",
        "Value": [
            "010000.000000",
            "134228.000000"
        ]
    },
    "00181210": {
        "vr": "SH",
        "Value": [
            "All-pass"
        ]
    },
    "00181242": {
        "vr": "IS",
        "Value": [
            60000
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422093565300000019"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422262922600127929"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "PROJECT_ID"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            4
        ]
    },
    "00200012": {
        "vr": "IS",
        "Value": [
            2001
        ]
    },
    "00200037": {
        "vr": "DS",
        "Value": [
            1.0,
            0.0,
            0.0,
            0.0,
            1.0,
            0.0
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.1.4.10016.30000023082422094374600000050"
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00204000": {
        "vr": "LT",
        "Value": [
            "AC CT 3.0  SWB HD_FoV, Volume Scaled"
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            440
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            440
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            1.65,
            1.65
        ]
    },
    "00280051": {
        "vr": "CS",
        "Value": [
            "NORM",
            "DTIM",
            "ATTN",
            "SCAT",
            "DECY",
            "RAN"
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            15
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00280106": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00281052": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00281053": {
        "vr": "DS",
        "Value": [
            0.46850314889981
        ]
    },
    "00281054": {
        "vr": "LO",
        "Value": [
            "BQML"
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CSA HEADER"
        ]
    },
    "00291018": {
        "vr": "CS",
        "Value": [
            "PET_REPLAY_PARAM"
        ]
    },
    "00291019": {
        "vr": "LO",
        "Value": [
            "1.3"
        ]
    },
    "00540013": {
        "vr": "SQ",
        "Value": [
            {
                "00540014": {
                    "vr": "DS",
                    "Value": [
                        435.0
                    ]
                },
                "00540015": {
                    "vr": "DS",
                    "Value": [
                        585.0
                    ]
                }
            }
        ]
    },
    "00540016": {
        "vr": "SQ",
        "Value": [
            {
                "00083012": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.1.4.10016.20230825144942123"
                    ]
                },
                "00180031": {
                    "vr": "LO",
                    "Value": [
                        "Germanium"
                    ]
                },
                "00181072": {
                    "vr": "TM",
                    "Value": [
                        "144942.000000"
                    ]
                },
                "00181074": {
                    "vr": "DS",
                    "Value": [
                        85740000.0
                    ]
                },
                "00181075": {
                    "vr": "DS",
                    "Value": [
                        23410100.0
                    ]
                },
                "00181076": {
                    "vr": "DS",
                    "Value": [
                        0.8891
                    ]
                },
                "00181078": {
                    "vr": "DT",
                    "Value": [
                        "20230825144942.000000"
                    ]
                },
                "00181079": {
                    "vr": "DT",
                    "Value": [
                        "20230825144942.000000"
                    ]
                },
                "00540300": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "C-128A2"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "SRT"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "^68^Germanium"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20070625000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "4020"
                                ]
                            }
                        }
                    ]
                },
                "00540304": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "C-B1046"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "SRT"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "Germanium Ge^68^"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20070625000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "4021"
                                ]
                            }
                        }
                    ]
                }
            }
        ]
    },
    "00540081": {
        "vr": "US",
        "Value": [
            531
        ]
    },
    "00540410": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "F-10450"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "99SDM"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "recumbent"
                    ]
                },
                "00080105": {
                    "vr": "CS",
                    "Value": [
                        "DCMR"
                    ]
                },
                "00080106": {
                    "vr": "DT",
                    "Value": [
                        "20020904000000.000000"
                    ]
                },
                "0008010F": {
                    "vr": "CS",
                    "Value": [
                        "19"
                    ]
                },
                "00540412": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "F-10340"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "99SDM"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "supine"
                                ]
                            },
                            "00080105": {
                                "vr": "CS",
                                "Value": [
                                    "DCMR"
                                ]
                            },
                            "00080106": {
                                "vr": "DT",
                                "Value": [
                                    "20020904000000.000000"
                                ]
                            },
                            "0008010F": {
                                "vr": "CS",
                                "Value": [
                                    "20"
                                ]
                            }
                        }
                    ]
                }
            }
        ]
    },
    "00540414": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "F-10470"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "99SDM"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "headfirst"
                    ]
                },
                "00080105": {
                    "vr": "CS",
                    "Value": [
                        "DCMR"
                    ]
                },
                "00080106": {
                    "vr": "DT",
                    "Value": [
                        "20020904000000.000000"
                    ]
                },
                "0008010F": {
                    "vr": "CS",
                    "Value": [
                        "21"
                    ]
                }
            }
        ]
    },
    "00541000": {
        "vr": "CS",
        "Value": [
            "WHOLE BODY",
            "IMAGE"
        ]
    },
    "00541001": {
        "vr": "CS",
        "Value": [
            "BQML"
        ]
    },
    "00541002": {
        "vr": "CS",
        "Value": [
            "EMISSION"
        ]
    },
    "00541100": {
        "vr": "CS",
        "Value": [
            "DLYD"
        ]
    },
    "00541101": {
        "vr": "LO",
        "Value": [
            "measured,AC CT 3.0  SWB HD_FoV"
        ]
    },
    "00541102": {
        "vr": "CS",
        "Value": [
            "START"
        ]
    },
    "00541103": {
        "vr": "LO",
        "Value": [
            "WB PSF+TOF 4i5s RD322"
        ]
    },
    "00541105": {
        "vr": "LO",
        "Value": [
            "2DSSS+3Dres Model-based, relative scaling, WB"
        ]
    },
    "00541200": {
        "vr": "DS",
        "Value": [
            322.0
        ]
    },
    "00541201": {
        "vr": "IS",
        "Value": [
            9,
            10
        ]
    },
    "00541300": {
        "vr": "DS",
        "Value": [
            30000.0
        ]
    },
    "00541321": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00541322": {
        "vr": "DS",
        "Value": [
            106642000.0
        ]
    },
    "00541323": {
        "vr": "DS",
        "Value": [
            0.367984
        ]
    },
    "00710010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MED PT"
        ]
    },
    "00711022": {
        "vr": "DT",
        "Value": [
            "20230825152419.000000"
        ]
    },
    "00711024": {
        "vr": "CS",
        "Value": [
            "STATIC"
        ]
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            "Patient comments string"
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotype"
            }
        ]
    }
}


varying_hdr = {"00080018": {"0": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128460"]}, "1": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128459"]}, "2": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128458"]}, "3": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128457"]}, "4": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128456"]}, "5": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128455"]}, "6": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128454"]}, "7": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128453"]}, "8": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128452"]}, "9": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128451"]}, "10": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128450"]}, "11": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128449"]}, "12": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128448"]}, "13": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128447"]}, "14": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128446"]}, "15": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128445"]}, "16": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128444"]}, "17": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128443"]}, "18": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128442"]}, "19": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128441"]}, "20": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128440"]}, "21": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128439"]}, "22": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128438"]}, "23": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128437"]}, "24": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128436"]}, "25": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128435"]}, "26": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128434"]}, "27": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128433"]}, "28": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128432"]}, "29": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128431"]}, "30": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128430"]}, "31": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128429"]}, "32": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128428"]}, "33": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128427"]}, "34": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128426"]}, "35": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128425"]}, "36": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128424"]}, "37": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128423"]}, "38": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128422"]}, "39": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128421"]}, "40": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128420"]}, "41": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128419"]}, "42": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128418"]}, "43": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128417"]}, "44": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128416"]}, "45": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128415"]}, "46": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128414"]}, "47": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128413"]}, "48": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128412"]}, "49": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128411"]}, "50": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128410"]}, "51": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128409"]}, "52": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128408"]}, "53": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128407"]}, "54": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128406"]}, "55": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128405"]}, "56": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128404"]}, "57": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128403"]}, "58": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128402"]}, "59": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128401"]}, "60": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128400"]}, "61": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128399"]}, "62": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128398"]}, "63": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128397"]}, "64": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128396"]}, "65": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128395"]}, "66": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128394"]}, "67": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128393"]}, "68": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128392"]}, "69": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128391"]}, "70": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128390"]}, "71": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128389"]}, "72": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128388"]}, "73": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128387"]}, "74": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128386"]}, "75": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128385"]}, "76": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128384"]}, "77": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128383"]}, "78": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128382"]}, "79": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128381"]}, "80": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128380"]}, "81": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128379"]}, "82": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128378"]}, "83": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128377"]}, "84": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128376"]}, "85": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128375"]}, "86": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128374"]}, "87": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128373"]}, "88": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128372"]}, "89": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128371"]}, "90": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128370"]}, "91": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128369"]}, "92": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128368"]}, "93": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128367"]}, "94": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128366"]}, "95": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128365"]}, "96": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128364"]}, "97": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128363"]}, "98": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128362"]}, "99": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128361"]}, "100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128360"]}, "101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128359"]}, "102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128358"]}, "103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128357"]}, "104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128356"]}, "105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128355"]}, "106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128354"]}, "107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128353"]}, "108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128352"]}, "109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128351"]}, "110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128350"]}, "111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128349"]}, "112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128348"]}, "113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128347"]}, "114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128346"]}, "115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128345"]}, "116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128344"]}, "117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128343"]}, "118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128342"]}, "119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128341"]}, "120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128340"]}, "121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128339"]}, "122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128338"]}, "123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128337"]}, "124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128336"]}, "125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128335"]}, "126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128334"]}, "127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128333"]}, "128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128332"]}, "129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128331"]}, "130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128330"]}, "131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128329"]}, "132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128328"]}, "133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128327"]}, "134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128326"]}, "135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128325"]}, "136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128324"]}, "137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128323"]}, "138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128322"]}, "139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128321"]}, "140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128320"]}, "141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128319"]}, "142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128318"]}, "143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128317"]}, "144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128316"]}, "145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128315"]}, "146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128314"]}, "147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128313"]}, "148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128312"]}, "149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128311"]}, "150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128310"]}, "151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128309"]}, "152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128308"]}, "153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128307"]}, "154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128306"]}, "155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128305"]}, "156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128304"]}, "157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128303"]}, "158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128302"]}, "159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128301"]}, "160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128300"]}, "161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128299"]}, "162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128298"]}, "163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128297"]}, "164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128296"]}, "165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128295"]}, "166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128294"]}, "167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128293"]}, "168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128292"]}, "169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128291"]}, "170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128290"]}, "171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128289"]}, "172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128288"]}, "173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128287"]}, "174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128286"]}, "175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128285"]}, "176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128284"]}, "177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128283"]}, "178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128282"]}, "179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128281"]}, "180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128280"]}, "181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128279"]}, "182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128278"]}, "183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128277"]}, "184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128276"]}, "185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128275"]}, "186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128274"]}, "187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128273"]}, "188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128272"]}, "189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128271"]}, "190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128270"]}, "191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128269"]}, "192": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128268"]}, "193": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128267"]}, "194": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128266"]}, "195": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128265"]}, "196": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128264"]}, "197": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128263"]}, "198": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128262"]}, "199": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128261"]}, "200": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128260"]}, "201": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128259"]}, "202": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128258"]}, "203": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128257"]}, "204": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128256"]}, "205": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128255"]}, "206": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128254"]}, "207": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128253"]}, "208": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128252"]}, "209": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128251"]}, "210": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128250"]}, "211": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128249"]}, "212": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128248"]}, "213": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128247"]}, "214": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128246"]}, "215": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128245"]}, "216": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128244"]}, "217": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128243"]}, "218": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128242"]}, "219": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128241"]}, "220": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128240"]}, "221": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128239"]}, "222": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128238"]}, "223": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128237"]}, "224": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128236"]}, "225": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128235"]}, "226": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128234"]}, "227": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128233"]}, "228": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128232"]}, "229": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128231"]}, "230": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128230"]}, "231": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128229"]}, "232": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128228"]}, "233": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128227"]}, "234": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128226"]}, "235": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128225"]}, "236": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128224"]}, "237": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128223"]}, "238": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128222"]}, "239": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128221"]}, "240": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128220"]}, "241": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128219"]}, "242": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128218"]}, "243": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128217"]}, "244": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128216"]}, "245": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128215"]}, "246": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128214"]}, "247": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128213"]}, "248": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128212"]}, "249": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128211"]}, "250": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128210"]}, "251": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128209"]}, "252": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128208"]}, "253": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128207"]}, "254": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128206"]}, "255": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128205"]}, "256": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128204"]}, "257": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128203"]}, "258": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128202"]}, "259": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128201"]}, "260": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128200"]}, "261": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128199"]}, "262": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128198"]}, "263": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128197"]}, "264": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128196"]}, "265": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128195"]}, "266": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128194"]}, "267": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128193"]}, "268": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128192"]}, "269": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128191"]}, "270": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128190"]}, "271": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128189"]}, "272": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128188"]}, "273": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128187"]}, "274": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128186"]}, "275": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128185"]}, "276": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128184"]}, "277": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128183"]}, "278": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128182"]}, "279": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128181"]}, "280": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128180"]}, "281": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128179"]}, "282": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128178"]}, "283": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128177"]}, "284": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128176"]}, "285": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128175"]}, "286": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128174"]}, "287": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128173"]}, "288": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128172"]}, "289": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128171"]}, "290": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128170"]}, "291": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128169"]}, "292": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128168"]}, "293": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128167"]}, "294": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128166"]}, "295": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128165"]}, "296": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128164"]}, "297": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128163"]}, "298": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128162"]}, "299": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128161"]}, "300": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128160"]}, "301": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128159"]}, "302": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128158"]}, "303": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128157"]}, "304": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128156"]}, "305": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128155"]}, "306": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128154"]}, "307": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128153"]}, "308": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128152"]}, "309": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128151"]}, "310": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128150"]}, "311": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128149"]}, "312": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128148"]}, "313": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128147"]}, "314": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128146"]}, "315": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128145"]}, "316": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128144"]}, "317": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128143"]}, "318": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128142"]}, "319": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128141"]}, "320": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128140"]}, "321": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128139"]}, "322": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128138"]}, "323": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128137"]}, "324": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128136"]}, "325": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128135"]}, "326": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128134"]}, "327": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128133"]}, "328": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128132"]}, "329": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128131"]}, "330": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128130"]}, "331": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128129"]}, "332": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128128"]}, "333": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128127"]}, "334": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128126"]}, "335": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128125"]}, "336": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128124"]}, "337": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128123"]}, "338": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128122"]}, "339": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128121"]}, "340": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128120"]}, "341": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128119"]}, "342": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128118"]}, "343": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128117"]}, "344": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128116"]}, "345": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128115"]}, "346": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128114"]}, "347": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128113"]}, "348": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128112"]}, "349": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128111"]}, "350": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128110"]}, "351": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128109"]}, "352": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128108"]}, "353": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128107"]}, "354": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128106"]}, "355": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128105"]}, "356": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128104"]}, "357": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128103"]}, "358": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128102"]}, "359": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128101"]}, "360": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128100"]}, "361": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128099"]}, "362": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128098"]}, "363": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128097"]}, "364": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128096"]}, "365": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128095"]}, "366": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128094"]}, "367": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128093"]}, "368": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128092"]}, "369": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128091"]}, "370": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128090"]}, "371": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128089"]}, "372": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128088"]}, "373": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128087"]}, "374": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128086"]}, "375": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128085"]}, "376": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128084"]}, "377": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128083"]}, "378": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128082"]}, "379": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128081"]}, "380": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128080"]}, "381": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128079"]}, "382": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128078"]}, "383": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128077"]}, "384": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128076"]}, "385": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128075"]}, "386": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128074"]}, "387": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128073"]}, "388": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128072"]}, "389": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128071"]}, "390": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128070"]}, "391": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128069"]}, "392": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128068"]}, "393": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128067"]}, "394": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128066"]}, "395": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128065"]}, "396": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128064"]}, "397": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128063"]}, "398": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128062"]}, "399": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128061"]}, "400": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128060"]}, "401": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128059"]}, "402": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128058"]}, "403": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128057"]}, "404": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128056"]}, "405": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128055"]}, "406": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128054"]}, "407": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128053"]}, "408": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128052"]}, "409": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128051"]}, "410": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128050"]}, "411": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128049"]}, "412": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128048"]}, "413": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128047"]}, "414": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128046"]}, "415": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128045"]}, "416": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128044"]}, "417": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128043"]}, "418": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128042"]}, "419": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128041"]}, "420": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128040"]}, "421": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128039"]}, "422": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128038"]}, "423": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128037"]}, "424": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128036"]}, "425": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128035"]}, "426": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128034"]}, "427": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128033"]}, "428": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128032"]}, "429": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128031"]}, "430": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128030"]}, "431": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128029"]}, "432": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128028"]}, "433": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128027"]}, "434": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128026"]}, "435": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128025"]}, "436": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128024"]}, "437": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128023"]}, "438": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128022"]}, "439": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128021"]}, "440": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128020"]}, "441": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128019"]}, "442": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128018"]}, "443": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128017"]}, "444": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128016"]}, "445": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128015"]}, "446": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128014"]}, "447": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128013"]}, "448": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128012"]}, "449": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128011"]}, "450": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128010"]}, "451": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128009"]}, "452": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128008"]}, "453": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128007"]}, "454": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128006"]}, "455": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128005"]}, "456": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128004"]}, "457": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128003"]}, "458": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128002"]}, "459": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128001"]}, "460": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600128000"]}, "461": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127999"]}, "462": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127998"]}, "463": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127997"]}, "464": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127996"]}, "465": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127995"]}, "466": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127994"]}, "467": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127993"]}, "468": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127992"]}, "469": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127991"]}, "470": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127990"]}, "471": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127989"]}, "472": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127988"]}, "473": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127987"]}, "474": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127986"]}, "475": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127985"]}, "476": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127984"]}, "477": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127983"]}, "478": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127982"]}, "479": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127981"]}, "480": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127980"]}, "481": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127979"]}, "482": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127978"]}, "483": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127977"]}, "484": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127976"]}, "485": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127975"]}, "486": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127974"]}, "487": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127973"]}, "488": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127972"]}, "489": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127971"]}, "490": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127970"]}, "491": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127969"]}, "492": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127968"]}, "493": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127967"]}, "494": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127966"]}, "495": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127965"]}, "496": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127964"]}, "497": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127963"]}, "498": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127962"]}, "499": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127961"]}, "500": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127960"]}, "501": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127959"]}, "502": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127958"]}, "503": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127957"]}, "504": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127956"]}, "505": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127955"]}, "506": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127954"]}, "507": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127953"]}, "508": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127952"]}, "509": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127951"]}, "510": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127950"]}, "511": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127949"]}, "512": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127948"]}, "513": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127947"]}, "514": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127946"]}, "515": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127945"]}, "516": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127944"]}, "517": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127943"]}, "518": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127942"]}, "519": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127941"]}, "520": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127940"]}, "521": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127939"]}, "522": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127938"]}, "523": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127937"]}, "524": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127936"]}, "525": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127935"]}, "526": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127934"]}, "527": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127933"]}, "528": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127932"]}, "529": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127931"]}, "530": {"vr": "UI", "Value": ["1.3.12.2.1107.5.1.4.10016.30000023082422262922600127930"]}}, "00080033": {"0": {"vr": "TM", "Value": ["153214.440000"]}, "1": {"vr": "TM", "Value": ["153214.440000"]}, "2": {"vr": "TM", "Value": ["153214.440000"]}, "3": {"vr": "TM", "Value": ["153214.440000"]}, "4": {"vr": "TM", "Value": ["153214.440000"]}, "5": {"vr": "TM", "Value": ["153214.440000"]}, "6": {"vr": "TM", "Value": ["153214.440000"]}, "7": {"vr": "TM", "Value": ["153214.440000"]}, "8": {"vr": "TM", "Value": ["153214.440000"]}, "9": {"vr": "TM", "Value": ["153214.440000"]}, "10": {"vr": "TM", "Value": ["153214.440000"]}, "11": {"vr": "TM", "Value": ["153214.440000"]}, "12": {"vr": "TM", "Value": ["153214.440000"]}, "13": {"vr": "TM", "Value": ["153214.440000"]}, "14": {"vr": "TM", "Value": ["153214.440000"]}, "15": {"vr": "TM", "Value": ["153214.440000"]}, "16": {"vr": "TM", "Value": ["153214.440000"]}, "17": {"vr": "TM", "Value": ["153214.440000"]}, "18": {"vr": "TM", "Value": ["153214.440000"]}, "19": {"vr": "TM", "Value": ["153214.440000"]}, "20": {"vr": "TM", "Value": ["153214.440000"]}, "21": {"vr": "TM", "Value": ["153214.440000"]}, "22": {"vr": "TM", "Value": ["153214.440000"]}, "23": {"vr": "TM", "Value": ["153214.440000"]}, "24": {"vr": "TM", "Value": ["153214.440000"]}, "25": {"vr": "TM", "Value": ["153214.440000"]}, "26": {"vr": "TM", "Value": ["153214.440000"]}, "27": {"vr": "TM", "Value": ["153214.440000"]}, "28": {"vr": "TM", "Value": ["153214.440000"]}, "29": {"vr": "TM", "Value": ["153214.440000"]}, "30": {"vr": "TM", "Value": ["153214.440000"]}, "31": {"vr": "TM", "Value": ["153214.338000"]}, "32": {"vr": "TM", "Value": ["153214.338000"]}, "33": {"vr": "TM", "Value": ["153214.338000"]}, "34": {"vr": "TM", "Value": ["153214.338000"]}, "35": {"vr": "TM", "Value": ["153214.338000"]}, "36": {"vr": "TM", "Value": ["153214.338000"]}, "37": {"vr": "TM", "Value": ["153214.338000"]}, "38": {"vr": "TM", "Value": ["153214.338000"]}, "39": {"vr": "TM", "Value": ["153214.338000"]}, "40": {"vr": "TM", "Value": ["153214.338000"]}, "41": {"vr": "TM", "Value": ["153214.338000"]}, "42": {"vr": "TM", "Value": ["153214.338000"]}, "43": {"vr": "TM", "Value": ["153214.338000"]}, "44": {"vr": "TM", "Value": ["153214.338000"]}, "45": {"vr": "TM", "Value": ["153214.335000"]}, "46": {"vr": "TM", "Value": ["153214.335000"]}, "47": {"vr": "TM", "Value": ["153214.335000"]}, "48": {"vr": "TM", "Value": ["153214.335000"]}, "49": {"vr": "TM", "Value": ["153214.335000"]}, "50": {"vr": "TM", "Value": ["153214.335000"]}, "51": {"vr": "TM", "Value": ["153214.335000"]}, "52": {"vr": "TM", "Value": ["153214.335000"]}, "53": {"vr": "TM", "Value": ["153214.335000"]}, "54": {"vr": "TM", "Value": ["153214.335000"]}, "55": {"vr": "TM", "Value": ["153214.335000"]}, "56": {"vr": "TM", "Value": ["153214.335000"]}, "57": {"vr": "TM", "Value": ["153214.335000"]}, "58": {"vr": "TM", "Value": ["153214.335000"]}, "59": {"vr": "TM", "Value": ["153214.335000"]}, "60": {"vr": "TM", "Value": ["153214.335000"]}, "61": {"vr": "TM", "Value": ["153214.335000"]}, "62": {"vr": "TM", "Value": ["153214.335000"]}, "63": {"vr": "TM", "Value": ["153214.335000"]}, "64": {"vr": "TM", "Value": ["153214.335000"]}, "65": {"vr": "TM", "Value": ["153214.335000"]}, "66": {"vr": "TM", "Value": ["153214.335000"]}, "67": {"vr": "TM", "Value": ["153214.335000"]}, "68": {"vr": "TM", "Value": ["153214.335000"]}, "69": {"vr": "TM", "Value": ["153214.335000"]}, "70": {"vr": "TM", "Value": ["153214.335000"]}, "71": {"vr": "TM", "Value": ["153214.335000"]}, "72": {"vr": "TM", "Value": ["153214.335000"]}, "73": {"vr": "TM", "Value": ["153214.335000"]}, "74": {"vr": "TM", "Value": ["153214.335000"]}, "75": {"vr": "TM", "Value": ["153214.335000"]}, "76": {"vr": "TM", "Value": ["153214.335000"]}, "77": {"vr": "TM", "Value": ["153214.335000"]}, "78": {"vr": "TM", "Value": ["153214.335000"]}, "79": {"vr": "TM", "Value": ["153214.335000"]}, "80": {"vr": "TM", "Value": ["153214.335000"]}, "81": {"vr": "TM", "Value": ["153214.205000"]}, "82": {"vr": "TM", "Value": ["153214.205000"]}, "83": {"vr": "TM", "Value": ["153214.205000"]}, "84": {"vr": "TM", "Value": ["153214.205000"]}, "85": {"vr": "TM", "Value": ["153214.205000"]}, "86": {"vr": "TM", "Value": ["153214.205000"]}, "87": {"vr": "TM", "Value": ["153214.205000"]}, "88": {"vr": "TM", "Value": ["153214.205000"]}, "89": {"vr": "TM", "Value": ["153214.205000"]}, "90": {"vr": "TM", "Value": ["153214.205000"]}, "91": {"vr": "TM", "Value": ["153214.205000"]}, "92": {"vr": "TM", "Value": ["153214.205000"]}, "93": {"vr": "TM", "Value": ["153214.205000"]}, "94": {"vr": "TM", "Value": ["153214.205000"]}, "95": {"vr": "TM", "Value": ["153214.205000"]}, "96": {"vr": "TM", "Value": ["153214.205000"]}, "97": {"vr": "TM", "Value": ["153214.205000"]}, "98": {"vr": "TM", "Value": ["153214.205000"]}, "99": {"vr": "TM", "Value": ["153214.205000"]}, "100": {"vr": "TM", "Value": ["153214.205000"]}, "101": {"vr": "TM", "Value": ["153214.205000"]}, "102": {"vr": "TM", "Value": ["153214.205000"]}, "103": {"vr": "TM", "Value": ["153214.205000"]}, "104": {"vr": "TM", "Value": ["153214.205000"]}, "105": {"vr": "TM", "Value": ["153214.205000"]}, "106": {"vr": "TM", "Value": ["153214.205000"]}, "107": {"vr": "TM", "Value": ["153214.205000"]}, "108": {"vr": "TM", "Value": ["153214.205000"]}, "109": {"vr": "TM", "Value": ["153214.205000"]}, "110": {"vr": "TM", "Value": ["153214.205000"]}, "111": {"vr": "TM", "Value": ["153214.205000"]}, "112": {"vr": "TM", "Value": ["153214.205000"]}, "113": {"vr": "TM", "Value": ["153214.205000"]}, "114": {"vr": "TM", "Value": ["153214.205000"]}, "115": {"vr": "TM", "Value": ["153214.205000"]}, "116": {"vr": "TM", "Value": ["153214.205000"]}, "117": {"vr": "TM", "Value": ["153214.205000"]}, "118": {"vr": "TM", "Value": ["153214.205000"]}, "119": {"vr": "TM", "Value": ["153214.205000"]}, "120": {"vr": "TM", "Value": ["153214.205000"]}, "121": {"vr": "TM", "Value": ["153214.205000"]}, "122": {"vr": "TM", "Value": ["153214.205000"]}, "123": {"vr": "TM", "Value": ["153214.205000"]}, "124": {"vr": "TM", "Value": ["153214.205000"]}, "125": {"vr": "TM", "Value": ["153214.205000"]}, "126": {"vr": "TM", "Value": ["153214.205000"]}, "127": {"vr": "TM", "Value": ["153214.205000"]}, "128": {"vr": "TM", "Value": ["153214.205000"]}, "129": {"vr": "TM", "Value": ["153214.205000"]}, "130": {"vr": "TM", "Value": ["153214.205000"]}, "131": {"vr": "TM", "Value": ["153214.112000"]}, "132": {"vr": "TM", "Value": ["153214.112000"]}, "133": {"vr": "TM", "Value": ["153214.112000"]}, "134": {"vr": "TM", "Value": ["153214.112000"]}, "135": {"vr": "TM", "Value": ["153214.112000"]}, "136": {"vr": "TM", "Value": ["153214.112000"]}, "137": {"vr": "TM", "Value": ["153214.112000"]}, "138": {"vr": "TM", "Value": ["153214.112000"]}, "139": {"vr": "TM", "Value": ["153214.112000"]}, "140": {"vr": "TM", "Value": ["153214.112000"]}, "141": {"vr": "TM", "Value": ["153214.112000"]}, "142": {"vr": "TM", "Value": ["153214.112000"]}, "143": {"vr": "TM", "Value": ["153214.112000"]}, "144": {"vr": "TM", "Value": ["153214.112000"]}, "145": {"vr": "TM", "Value": ["153214.112000"]}, "146": {"vr": "TM", "Value": ["153214.112000"]}, "147": {"vr": "TM", "Value": ["153214.112000"]}, "148": {"vr": "TM", "Value": ["153214.112000"]}, "149": {"vr": "TM", "Value": ["153214.112000"]}, "150": {"vr": "TM", "Value": ["153214.112000"]}, "151": {"vr": "TM", "Value": ["153214.112000"]}, "152": {"vr": "TM", "Value": ["153214.112000"]}, "153": {"vr": "TM", "Value": ["153214.112000"]}, "154": {"vr": "TM", "Value": ["153214.112000"]}, "155": {"vr": "TM", "Value": ["153214.112000"]}, "156": {"vr": "TM", "Value": ["153214.112000"]}, "157": {"vr": "TM", "Value": ["153214.112000"]}, "158": {"vr": "TM", "Value": ["153214.112000"]}, "159": {"vr": "TM", "Value": ["153214.112000"]}, "160": {"vr": "TM", "Value": ["153214.112000"]}, "161": {"vr": "TM", "Value": ["153214.112000"]}, "162": {"vr": "TM", "Value": ["153214.112000"]}, "163": {"vr": "TM", "Value": ["153214.112000"]}, "164": {"vr": "TM", "Value": ["153214.112000"]}, "165": {"vr": "TM", "Value": ["153214.112000"]}, "166": {"vr": "TM", "Value": ["153214.112000"]}, "167": {"vr": "TM", "Value": ["153214.112000"]}, "168": {"vr": "TM", "Value": ["153214.112000"]}, "169": {"vr": "TM", "Value": ["153214.112000"]}, "170": {"vr": "TM", "Value": ["153214.112000"]}, "171": {"vr": "TM", "Value": ["153214.112000"]}, "172": {"vr": "TM", "Value": ["153214.112000"]}, "173": {"vr": "TM", "Value": ["153214.112000"]}, "174": {"vr": "TM", "Value": ["153214.112000"]}, "175": {"vr": "TM", "Value": ["153214.112000"]}, "176": {"vr": "TM", "Value": ["153214.112000"]}, "177": {"vr": "TM", "Value": ["153214.112000"]}, "178": {"vr": "TM", "Value": ["153214.112000"]}, "179": {"vr": "TM", "Value": ["153214.112000"]}, "180": {"vr": "TM", "Value": ["153214.112000"]}, "181": {"vr": "TM", "Value": ["153214.019000"]}, "182": {"vr": "TM", "Value": ["153214.019000"]}, "183": {"vr": "TM", "Value": ["153214.019000"]}, "184": {"vr": "TM", "Value": ["153214.019000"]}, "185": {"vr": "TM", "Value": ["153214.019000"]}, "186": {"vr": "TM", "Value": ["153214.019000"]}, "187": {"vr": "TM", "Value": ["153214.019000"]}, "188": {"vr": "TM", "Value": ["153214.019000"]}, "189": {"vr": "TM", "Value": ["153214.019000"]}, "190": {"vr": "TM", "Value": ["153214.019000"]}, "191": {"vr": "TM", "Value": ["153214.019000"]}, "192": {"vr": "TM", "Value": ["153214.019000"]}, "193": {"vr": "TM", "Value": ["153214.019000"]}, "194": {"vr": "TM", "Value": ["153214.019000"]}, "195": {"vr": "TM", "Value": ["153214.019000"]}, "196": {"vr": "TM", "Value": ["153214.019000"]}, "197": {"vr": "TM", "Value": ["153214.019000"]}, "198": {"vr": "TM", "Value": ["153214.019000"]}, "199": {"vr": "TM", "Value": ["153214.019000"]}, "200": {"vr": "TM", "Value": ["153214.019000"]}, "201": {"vr": "TM", "Value": ["153214.019000"]}, "202": {"vr": "TM", "Value": ["153214.019000"]}, "203": {"vr": "TM", "Value": ["153214.019000"]}, "204": {"vr": "TM", "Value": ["153214.019000"]}, "205": {"vr": "TM", "Value": ["153214.019000"]}, "206": {"vr": "TM", "Value": ["153214.019000"]}, "207": {"vr": "TM", "Value": ["153214.019000"]}, "208": {"vr": "TM", "Value": ["153214.019000"]}, "209": {"vr": "TM", "Value": ["153214.019000"]}, "210": {"vr": "TM", "Value": ["153214.019000"]}, "211": {"vr": "TM", "Value": ["153214.019000"]}, "212": {"vr": "TM", "Value": ["153214.019000"]}, "213": {"vr": "TM", "Value": ["153214.019000"]}, "214": {"vr": "TM", "Value": ["153214.019000"]}, "215": {"vr": "TM", "Value": ["153214.019000"]}, "216": {"vr": "TM", "Value": ["153214.019000"]}, "217": {"vr": "TM", "Value": ["153214.019000"]}, "218": {"vr": "TM", "Value": ["153214.019000"]}, "219": {"vr": "TM", "Value": ["153214.019000"]}, "220": {"vr": "TM", "Value": ["153214.019000"]}, "221": {"vr": "TM", "Value": ["153214.019000"]}, "222": {"vr": "TM", "Value": ["153214.019000"]}, "223": {"vr": "TM", "Value": ["153214.019000"]}, "224": {"vr": "TM", "Value": ["153214.019000"]}, "225": {"vr": "TM", "Value": ["153214.019000"]}, "226": {"vr": "TM", "Value": ["153214.019000"]}, "227": {"vr": "TM", "Value": ["153214.019000"]}, "228": {"vr": "TM", "Value": ["153214.019000"]}, "229": {"vr": "TM", "Value": ["153214.019000"]}, "230": {"vr": "TM", "Value": ["153214.019000"]}, "231": {"vr": "TM", "Value": ["153213.926000"]}, "232": {"vr": "TM", "Value": ["153213.926000"]}, "233": {"vr": "TM", "Value": ["153213.926000"]}, "234": {"vr": "TM", "Value": ["153213.926000"]}, "235": {"vr": "TM", "Value": ["153213.926000"]}, "236": {"vr": "TM", "Value": ["153213.926000"]}, "237": {"vr": "TM", "Value": ["153213.926000"]}, "238": {"vr": "TM", "Value": ["153213.926000"]}, "239": {"vr": "TM", "Value": ["153213.926000"]}, "240": {"vr": "TM", "Value": ["153213.926000"]}, "241": {"vr": "TM", "Value": ["153213.926000"]}, "242": {"vr": "TM", "Value": ["153213.926000"]}, "243": {"vr": "TM", "Value": ["153213.926000"]}, "244": {"vr": "TM", "Value": ["153213.926000"]}, "245": {"vr": "TM", "Value": ["153213.926000"]}, "246": {"vr": "TM", "Value": ["153213.926000"]}, "247": {"vr": "TM", "Value": ["153213.926000"]}, "248": {"vr": "TM", "Value": ["153213.926000"]}, "249": {"vr": "TM", "Value": ["153213.926000"]}, "250": {"vr": "TM", "Value": ["153213.926000"]}, "251": {"vr": "TM", "Value": ["153213.926000"]}, "252": {"vr": "TM", "Value": ["153213.926000"]}, "253": {"vr": "TM", "Value": ["153213.926000"]}, "254": {"vr": "TM", "Value": ["153213.926000"]}, "255": {"vr": "TM", "Value": ["153213.926000"]}, "256": {"vr": "TM", "Value": ["153213.926000"]}, "257": {"vr": "TM", "Value": ["153213.926000"]}, "258": {"vr": "TM", "Value": ["153213.926000"]}, "259": {"vr": "TM", "Value": ["153213.926000"]}, "260": {"vr": "TM", "Value": ["153213.926000"]}, "261": {"vr": "TM", "Value": ["153213.926000"]}, "262": {"vr": "TM", "Value": ["153213.926000"]}, "263": {"vr": "TM", "Value": ["153213.926000"]}, "264": {"vr": "TM", "Value": ["153213.926000"]}, "265": {"vr": "TM", "Value": ["153213.923000"]}, "266": {"vr": "TM", "Value": ["153213.923000"]}, "267": {"vr": "TM", "Value": ["153213.923000"]}, "268": {"vr": "TM", "Value": ["153213.923000"]}, "269": {"vr": "TM", "Value": ["153213.923000"]}, "270": {"vr": "TM", "Value": ["153213.923000"]}, "271": {"vr": "TM", "Value": ["153213.923000"]}, "272": {"vr": "TM", "Value": ["153213.923000"]}, "273": {"vr": "TM", "Value": ["153213.923000"]}, "274": {"vr": "TM", "Value": ["153213.923000"]}, "275": {"vr": "TM", "Value": ["153213.923000"]}, "276": {"vr": "TM", "Value": ["153213.923000"]}, "277": {"vr": "TM", "Value": ["153213.923000"]}, "278": {"vr": "TM", "Value": ["153213.923000"]}, "279": {"vr": "TM", "Value": ["153213.923000"]}, "280": {"vr": "TM", "Value": ["153213.923000"]}, "281": {"vr": "TM", "Value": ["153213.806000"]}, "282": {"vr": "TM", "Value": ["153213.806000"]}, "283": {"vr": "TM", "Value": ["153213.806000"]}, "284": {"vr": "TM", "Value": ["153213.806000"]}, "285": {"vr": "TM", "Value": ["153213.806000"]}, "286": {"vr": "TM", "Value": ["153213.806000"]}, "287": {"vr": "TM", "Value": ["153213.806000"]}, "288": {"vr": "TM", "Value": ["153213.806000"]}, "289": {"vr": "TM", "Value": ["153213.806000"]}, "290": {"vr": "TM", "Value": ["153213.806000"]}, "291": {"vr": "TM", "Value": ["153213.806000"]}, "292": {"vr": "TM", "Value": ["153213.806000"]}, "293": {"vr": "TM", "Value": ["153213.806000"]}, "294": {"vr": "TM", "Value": ["153213.806000"]}, "295": {"vr": "TM", "Value": ["153213.806000"]}, "296": {"vr": "TM", "Value": ["153213.806000"]}, "297": {"vr": "TM", "Value": ["153213.806000"]}, "298": {"vr": "TM", "Value": ["153213.806000"]}, "299": {"vr": "TM", "Value": ["153213.806000"]}, "300": {"vr": "TM", "Value": ["153213.806000"]}, "301": {"vr": "TM", "Value": ["153213.806000"]}, "302": {"vr": "TM", "Value": ["153213.806000"]}, "303": {"vr": "TM", "Value": ["153213.806000"]}, "304": {"vr": "TM", "Value": ["153213.806000"]}, "305": {"vr": "TM", "Value": ["153213.806000"]}, "306": {"vr": "TM", "Value": ["153213.806000"]}, "307": {"vr": "TM", "Value": ["153213.806000"]}, "308": {"vr": "TM", "Value": ["153213.806000"]}, "309": {"vr": "TM", "Value": ["153213.806000"]}, "310": {"vr": "TM", "Value": ["153213.806000"]}, "311": {"vr": "TM", "Value": ["153213.806000"]}, "312": {"vr": "TM", "Value": ["153213.806000"]}, "313": {"vr": "TM", "Value": ["153213.806000"]}, "314": {"vr": "TM", "Value": ["153213.803000"]}, "315": {"vr": "TM", "Value": ["153213.803000"]}, "316": {"vr": "TM", "Value": ["153213.803000"]}, "317": {"vr": "TM", "Value": ["153213.803000"]}, "318": {"vr": "TM", "Value": ["153213.803000"]}, "319": {"vr": "TM", "Value": ["153213.803000"]}, "320": {"vr": "TM", "Value": ["153213.803000"]}, "321": {"vr": "TM", "Value": ["153213.803000"]}, "322": {"vr": "TM", "Value": ["153213.803000"]}, "323": {"vr": "TM", "Value": ["153213.803000"]}, "324": {"vr": "TM", "Value": ["153213.803000"]}, "325": {"vr": "TM", "Value": ["153213.803000"]}, "326": {"vr": "TM", "Value": ["153213.803000"]}, "327": {"vr": "TM", "Value": ["153213.803000"]}, "328": {"vr": "TM", "Value": ["153213.803000"]}, "329": {"vr": "TM", "Value": ["153213.803000"]}, "330": {"vr": "TM", "Value": ["153213.803000"]}, "331": {"vr": "TM", "Value": ["153213.695000"]}, "332": {"vr": "TM", "Value": ["153213.695000"]}, "333": {"vr": "TM", "Value": ["153213.695000"]}, "334": {"vr": "TM", "Value": ["153213.695000"]}, "335": {"vr": "TM", "Value": ["153213.695000"]}, "336": {"vr": "TM", "Value": ["153213.695000"]}, "337": {"vr": "TM", "Value": ["153213.695000"]}, "338": {"vr": "TM", "Value": ["153213.695000"]}, "339": {"vr": "TM", "Value": ["153213.695000"]}, "340": {"vr": "TM", "Value": ["153213.695000"]}, "341": {"vr": "TM", "Value": ["153213.695000"]}, "342": {"vr": "TM", "Value": ["153213.695000"]}, "343": {"vr": "TM", "Value": ["153213.695000"]}, "344": {"vr": "TM", "Value": ["153213.695000"]}, "345": {"vr": "TM", "Value": ["153213.692000"]}, "346": {"vr": "TM", "Value": ["153213.692000"]}, "347": {"vr": "TM", "Value": ["153213.692000"]}, "348": {"vr": "TM", "Value": ["153213.692000"]}, "349": {"vr": "TM", "Value": ["153213.692000"]}, "350": {"vr": "TM", "Value": ["153213.692000"]}, "351": {"vr": "TM", "Value": ["153213.692000"]}, "352": {"vr": "TM", "Value": ["153213.692000"]}, "353": {"vr": "TM", "Value": ["153213.692000"]}, "354": {"vr": "TM", "Value": ["153213.692000"]}, "355": {"vr": "TM", "Value": ["153213.692000"]}, "356": {"vr": "TM", "Value": ["153213.692000"]}, "357": {"vr": "TM", "Value": ["153213.692000"]}, "358": {"vr": "TM", "Value": ["153213.692000"]}, "359": {"vr": "TM", "Value": ["153213.692000"]}, "360": {"vr": "TM", "Value": ["153213.692000"]}, "361": {"vr": "TM", "Value": ["153213.692000"]}, "362": {"vr": "TM", "Value": ["153213.692000"]}, "363": {"vr": "TM", "Value": ["153213.692000"]}, "364": {"vr": "TM", "Value": ["153213.692000"]}, "365": {"vr": "TM", "Value": ["153213.692000"]}, "366": {"vr": "TM", "Value": ["153213.692000"]}, "367": {"vr": "TM", "Value": ["153213.692000"]}, "368": {"vr": "TM", "Value": ["153213.692000"]}, "369": {"vr": "TM", "Value": ["153213.692000"]}, "370": {"vr": "TM", "Value": ["153213.692000"]}, "371": {"vr": "TM", "Value": ["153213.692000"]}, "372": {"vr": "TM", "Value": ["153213.692000"]}, "373": {"vr": "TM", "Value": ["153213.692000"]}, "374": {"vr": "TM", "Value": ["153213.692000"]}, "375": {"vr": "TM", "Value": ["153213.692000"]}, "376": {"vr": "TM", "Value": ["153213.692000"]}, "377": {"vr": "TM", "Value": ["153213.692000"]}, "378": {"vr": "TM", "Value": ["153213.692000"]}, "379": {"vr": "TM", "Value": ["153213.692000"]}, "380": {"vr": "TM", "Value": ["153213.692000"]}, "381": {"vr": "TM", "Value": ["153213.581000"]}, "382": {"vr": "TM", "Value": ["153213.581000"]}, "383": {"vr": "TM", "Value": ["153213.581000"]}, "384": {"vr": "TM", "Value": ["153213.581000"]}, "385": {"vr": "TM", "Value": ["153213.581000"]}, "386": {"vr": "TM", "Value": ["153213.581000"]}, "387": {"vr": "TM", "Value": ["153213.581000"]}, "388": {"vr": "TM", "Value": ["153213.581000"]}, "389": {"vr": "TM", "Value": ["153213.581000"]}, "390": {"vr": "TM", "Value": ["153213.578000"]}, "391": {"vr": "TM", "Value": ["153213.578000"]}, "392": {"vr": "TM", "Value": ["153213.578000"]}, "393": {"vr": "TM", "Value": ["153213.578000"]}, "394": {"vr": "TM", "Value": ["153213.578000"]}, "395": {"vr": "TM", "Value": ["153213.578000"]}, "396": {"vr": "TM", "Value": ["153213.578000"]}, "397": {"vr": "TM", "Value": ["153213.578000"]}, "398": {"vr": "TM", "Value": ["153213.578000"]}, "399": {"vr": "TM", "Value": ["153213.578000"]}, "400": {"vr": "TM", "Value": ["153213.578000"]}, "401": {"vr": "TM", "Value": ["153213.578000"]}, "402": {"vr": "TM", "Value": ["153213.578000"]}, "403": {"vr": "TM", "Value": ["153213.578000"]}, "404": {"vr": "TM", "Value": ["153213.578000"]}, "405": {"vr": "TM", "Value": ["153213.578000"]}, "406": {"vr": "TM", "Value": ["153213.578000"]}, "407": {"vr": "TM", "Value": ["153213.578000"]}, "408": {"vr": "TM", "Value": ["153213.578000"]}, "409": {"vr": "TM", "Value": ["153213.578000"]}, "410": {"vr": "TM", "Value": ["153213.578000"]}, "411": {"vr": "TM", "Value": ["153213.578000"]}, "412": {"vr": "TM", "Value": ["153213.578000"]}, "413": {"vr": "TM", "Value": ["153213.578000"]}, "414": {"vr": "TM", "Value": ["153213.578000"]}, "415": {"vr": "TM", "Value": ["153213.578000"]}, "416": {"vr": "TM", "Value": ["153213.578000"]}, "417": {"vr": "TM", "Value": ["153213.578000"]}, "418": {"vr": "TM", "Value": ["153213.578000"]}, "419": {"vr": "TM", "Value": ["153213.578000"]}, "420": {"vr": "TM", "Value": ["153213.578000"]}, "421": {"vr": "TM", "Value": ["153213.578000"]}, "422": {"vr": "TM", "Value": ["153213.578000"]}, "423": {"vr": "TM", "Value": ["153213.578000"]}, "424": {"vr": "TM", "Value": ["153213.578000"]}, "425": {"vr": "TM", "Value": ["153213.578000"]}, "426": {"vr": "TM", "Value": ["153213.578000"]}, "427": {"vr": "TM", "Value": ["153213.578000"]}, "428": {"vr": "TM", "Value": ["153213.578000"]}, "429": {"vr": "TM", "Value": ["153213.578000"]}, "430": {"vr": "TM", "Value": ["153213.578000"]}, "431": {"vr": "TM", "Value": ["153213.449000"]}, "432": {"vr": "TM", "Value": ["153213.449000"]}, "433": {"vr": "TM", "Value": ["153213.449000"]}, "434": {"vr": "TM", "Value": ["153213.449000"]}, "435": {"vr": "TM", "Value": ["153213.449000"]}, "436": {"vr": "TM", "Value": ["153213.449000"]}, "437": {"vr": "TM", "Value": ["153213.449000"]}, "438": {"vr": "TM", "Value": ["153213.449000"]}, "439": {"vr": "TM", "Value": ["153213.449000"]}, "440": {"vr": "TM", "Value": ["153213.449000"]}, "441": {"vr": "TM", "Value": ["153213.449000"]}, "442": {"vr": "TM", "Value": ["153213.449000"]}, "443": {"vr": "TM", "Value": ["153213.449000"]}, "444": {"vr": "TM", "Value": ["153213.449000"]}, "445": {"vr": "TM", "Value": ["153213.449000"]}, "446": {"vr": "TM", "Value": ["153213.449000"]}, "447": {"vr": "TM", "Value": ["153213.449000"]}, "448": {"vr": "TM", "Value": ["153213.449000"]}, "449": {"vr": "TM", "Value": ["153213.449000"]}, "450": {"vr": "TM", "Value": ["153213.449000"]}, "451": {"vr": "TM", "Value": ["153213.449000"]}, "452": {"vr": "TM", "Value": ["153213.449000"]}, "453": {"vr": "TM", "Value": ["153213.449000"]}, "454": {"vr": "TM", "Value": ["153213.449000"]}, "455": {"vr": "TM", "Value": ["153213.449000"]}, "456": {"vr": "TM", "Value": ["153213.449000"]}, "457": {"vr": "TM", "Value": ["153213.449000"]}, "458": {"vr": "TM", "Value": ["153213.449000"]}, "459": {"vr": "TM", "Value": ["153213.449000"]}, "460": {"vr": "TM", "Value": ["153213.449000"]}, "461": {"vr": "TM", "Value": ["153213.449000"]}, "462": {"vr": "TM", "Value": ["153213.449000"]}, "463": {"vr": "TM", "Value": ["153213.449000"]}, "464": {"vr": "TM", "Value": ["153213.449000"]}, "465": {"vr": "TM", "Value": ["153213.449000"]}, "466": {"vr": "TM", "Value": ["153213.449000"]}, "467": {"vr": "TM", "Value": ["153213.449000"]}, "468": {"vr": "TM", "Value": ["153213.449000"]}, "469": {"vr": "TM", "Value": ["153213.449000"]}, "470": {"vr": "TM", "Value": ["153213.449000"]}, "471": {"vr": "TM", "Value": ["153213.449000"]}, "472": {"vr": "TM", "Value": ["153213.449000"]}, "473": {"vr": "TM", "Value": ["153213.449000"]}, "474": {"vr": "TM", "Value": ["153213.449000"]}, "475": {"vr": "TM", "Value": ["153213.449000"]}, "476": {"vr": "TM", "Value": ["153213.449000"]}, "477": {"vr": "TM", "Value": ["153213.449000"]}, "478": {"vr": "TM", "Value": ["153213.449000"]}, "479": {"vr": "TM", "Value": ["153213.449000"]}, "480": {"vr": "TM", "Value": ["153213.449000"]}, "481": {"vr": "TM", "Value": ["153213.329000"]}, "482": {"vr": "TM", "Value": ["153213.329000"]}, "483": {"vr": "TM", "Value": ["153213.329000"]}, "484": {"vr": "TM", "Value": ["153213.329000"]}, "485": {"vr": "TM", "Value": ["153213.329000"]}, "486": {"vr": "TM", "Value": ["153213.329000"]}, "487": {"vr": "TM", "Value": ["153213.329000"]}, "488": {"vr": "TM", "Value": ["153213.329000"]}, "489": {"vr": "TM", "Value": ["153213.329000"]}, "490": {"vr": "TM", "Value": ["153213.329000"]}, "491": {"vr": "TM", "Value": ["153213.329000"]}, "492": {"vr": "TM", "Value": ["153213.329000"]}, "493": {"vr": "TM", "Value": ["153213.329000"]}, "494": {"vr": "TM", "Value": ["153213.329000"]}, "495": {"vr": "TM", "Value": ["153213.329000"]}, "496": {"vr": "TM", "Value": ["153213.329000"]}, "497": {"vr": "TM", "Value": ["153213.329000"]}, "498": {"vr": "TM", "Value": ["153213.329000"]}, "499": {"vr": "TM", "Value": ["153213.329000"]}, "500": {"vr": "TM", "Value": ["153213.329000"]}, "501": {"vr": "TM", "Value": ["153213.329000"]}, "502": {"vr": "TM", "Value": ["153213.329000"]}, "503": {"vr": "TM", "Value": ["153213.329000"]}, "504": {"vr": "TM", "Value": ["153213.329000"]}, "505": {"vr": "TM", "Value": ["153213.329000"]}, "506": {"vr": "TM", "Value": ["153213.329000"]}, "507": {"vr": "TM", "Value": ["153213.329000"]}, "508": {"vr": "TM", "Value": ["153213.329000"]}, "509": {"vr": "TM", "Value": ["153213.329000"]}, "510": {"vr": "TM", "Value": ["153213.329000"]}, "511": {"vr": "TM", "Value": ["153213.329000"]}, "512": {"vr": "TM", "Value": ["153213.329000"]}, "513": {"vr": "TM", "Value": ["153213.329000"]}, "514": {"vr": "TM", "Value": ["153213.329000"]}, "515": {"vr": "TM", "Value": ["153213.329000"]}, "516": {"vr": "TM", "Value": ["153213.329000"]}, "517": {"vr": "TM", "Value": ["153213.329000"]}, "518": {"vr": "TM", "Value": ["153213.329000"]}, "519": {"vr": "TM", "Value": ["153213.329000"]}, "520": {"vr": "TM", "Value": ["153213.329000"]}, "521": {"vr": "TM", "Value": ["153213.329000"]}, "522": {"vr": "TM", "Value": ["153213.329000"]}, "523": {"vr": "TM", "Value": ["153213.329000"]}, "524": {"vr": "TM", "Value": ["153213.329000"]}, "525": {"vr": "TM", "Value": ["153213.329000"]}, "526": {"vr": "TM", "Value": ["153213.329000"]}, "527": {"vr": "TM", "Value": ["153213.329000"]}, "528": {"vr": "TM", "Value": ["153213.329000"]}, "529": {"vr": "TM", "Value": ["153213.329000"]}, "530": {"vr": "TM", "Value": ["153213.329000"]}}, "00200013": {"0": {"vr": "IS", "Value": [1]}, "1": {"vr": "IS", "Value": [2]}, "2": {"vr": "IS", "Value": [3]}, "3": {"vr": "IS", "Value": [4]}, "4": {"vr": "IS", "Value": [5]}, "5": {"vr": "IS", "Value": [6]}, "6": {"vr": "IS", "Value": [7]}, "7": {"vr": "IS", "Value": [8]}, "8": {"vr": "IS", "Value": [9]}, "9": {"vr": "IS", "Value": [10]}, "10": {"vr": "IS", "Value": [11]}, "11": {"vr": "IS", "Value": [12]}, "12": {"vr": "IS", "Value": [13]}, "13": {"vr": "IS", "Value": [14]}, "14": {"vr": "IS", "Value": [15]}, "15": {"vr": "IS", "Value": [16]}, "16": {"vr": "IS", "Value": [17]}, "17": {"vr": "IS", "Value": [18]}, "18": {"vr": "IS", "Value": [19]}, "19": {"vr": "IS", "Value": [20]}, "20": {"vr": "IS", "Value": [21]}, "21": {"vr": "IS", "Value": [22]}, "22": {"vr": "IS", "Value": [23]}, "23": {"vr": "IS", "Value": [24]}, "24": {"vr": "IS", "Value": [25]}, "25": {"vr": "IS", "Value": [26]}, "26": {"vr": "IS", "Value": [27]}, "27": {"vr": "IS", "Value": [28]}, "28": {"vr": "IS", "Value": [29]}, "29": {"vr": "IS", "Value": [30]}, "30": {"vr": "IS", "Value": [31]}, "31": {"vr": "IS", "Value": [32]}, "32": {"vr": "IS", "Value": [33]}, "33": {"vr": "IS", "Value": [34]}, "34": {"vr": "IS", "Value": [35]}, "35": {"vr": "IS", "Value": [36]}, "36": {"vr": "IS", "Value": [37]}, "37": {"vr": "IS", "Value": [38]}, "38": {"vr": "IS", "Value": [39]}, "39": {"vr": "IS", "Value": [40]}, "40": {"vr": "IS", "Value": [41]}, "41": {"vr": "IS", "Value": [42]}, "42": {"vr": "IS", "Value": [43]}, "43": {"vr": "IS", "Value": [44]}, "44": {"vr": "IS", "Value": [45]}, "45": {"vr": "IS", "Value": [46]}, "46": {"vr": "IS", "Value": [47]}, "47": {"vr": "IS", "Value": [48]}, "48": {"vr": "IS", "Value": [49]}, "49": {"vr": "IS", "Value": [50]}, "50": {"vr": "IS", "Value": [51]}, "51": {"vr": "IS", "Value": [52]}, "52": {"vr": "IS", "Value": [53]}, "53": {"vr": "IS", "Value": [54]}, "54": {"vr": "IS", "Value": [55]}, "55": {"vr": "IS", "Value": [56]}, "56": {"vr": "IS", "Value": [57]}, "57": {"vr": "IS", "Value": [58]}, "58": {"vr": "IS", "Value": [59]}, "59": {"vr": "IS", "Value": [60]}, "60": {"vr": "IS", "Value": [61]}, "61": {"vr": "IS", "Value": [62]}, "62": {"vr": "IS", "Value": [63]}, "63": {"vr": "IS", "Value": [64]}, "64": {"vr": "IS", "Value": [65]}, "65": {"vr": "IS", "Value": [66]}, "66": {"vr": "IS", "Value": [67]}, "67": {"vr": "IS", "Value": [68]}, "68": {"vr": "IS", "Value": [69]}, "69": {"vr": "IS", "Value": [70]}, "70": {"vr": "IS", "Value": [71]}, "71": {"vr": "IS", "Value": [72]}, "72": {"vr": "IS", "Value": [73]}, "73": {"vr": "IS", "Value": [74]}, "74": {"vr": "IS", "Value": [75]}, "75": {"vr": "IS", "Value": [76]}, "76": {"vr": "IS", "Value": [77]}, "77": {"vr": "IS", "Value": [78]}, "78": {"vr": "IS", "Value": [79]}, "79": {"vr": "IS", "Value": [80]}, "80": {"vr": "IS", "Value": [81]}, "81": {"vr": "IS", "Value": [82]}, "82": {"vr": "IS", "Value": [83]}, "83": {"vr": "IS", "Value": [84]}, "84": {"vr": "IS", "Value": [85]}, "85": {"vr": "IS", "Value": [86]}, "86": {"vr": "IS", "Value": [87]}, "87": {"vr": "IS", "Value": [88]}, "88": {"vr": "IS", "Value": [89]}, "89": {"vr": "IS", "Value": [90]}, "90": {"vr": "IS", "Value": [91]}, "91": {"vr": "IS", "Value": [92]}, "92": {"vr": "IS", "Value": [93]}, "93": {"vr": "IS", "Value": [94]}, "94": {"vr": "IS", "Value": [95]}, "95": {"vr": "IS", "Value": [96]}, "96": {"vr": "IS", "Value": [97]}, "97": {"vr": "IS", "Value": [98]}, "98": {"vr": "IS", "Value": [99]}, "99": {"vr": "IS", "Value": [100]}, "100": {"vr": "IS", "Value": [101]}, "101": {"vr": "IS", "Value": [102]}, "102": {"vr": "IS", "Value": [103]}, "103": {"vr": "IS", "Value": [104]}, "104": {"vr": "IS", "Value": [105]}, "105": {"vr": "IS", "Value": [106]}, "106": {"vr": "IS", "Value": [107]}, "107": {"vr": "IS", "Value": [108]}, "108": {"vr": "IS", "Value": [109]}, "109": {"vr": "IS", "Value": [110]}, "110": {"vr": "IS", "Value": [111]}, "111": {"vr": "IS", "Value": [112]}, "112": {"vr": "IS", "Value": [113]}, "113": {"vr": "IS", "Value": [114]}, "114": {"vr": "IS", "Value": [115]}, "115": {"vr": "IS", "Value": [116]}, "116": {"vr": "IS", "Value": [117]}, "117": {"vr": "IS", "Value": [118]}, "118": {"vr": "IS", "Value": [119]}, "119": {"vr": "IS", "Value": [120]}, "120": {"vr": "IS", "Value": [121]}, "121": {"vr": "IS", "Value": [122]}, "122": {"vr": "IS", "Value": [123]}, "123": {"vr": "IS", "Value": [124]}, "124": {"vr": "IS", "Value": [125]}, "125": {"vr": "IS", "Value": [126]}, "126": {"vr": "IS", "Value": [127]}, "127": {"vr": "IS", "Value": [128]}, "128": {"vr": "IS", "Value": [129]}, "129": {"vr": "IS", "Value": [130]}, "130": {"vr": "IS", "Value": [131]}, "131": {"vr": "IS", "Value": [132]}, "132": {"vr": "IS", "Value": [133]}, "133": {"vr": "IS", "Value": [134]}, "134": {"vr": "IS", "Value": [135]}, "135": {"vr": "IS", "Value": [136]}, "136": {"vr": "IS", "Value": [137]}, "137": {"vr": "IS", "Value": [138]}, "138": {"vr": "IS", "Value": [139]}, "139": {"vr": "IS", "Value": [140]}, "140": {"vr": "IS", "Value": [141]}, "141": {"vr": "IS", "Value": [142]}, "142": {"vr": "IS", "Value": [143]}, "143": {"vr": "IS", "Value": [144]}, "144": {"vr": "IS", "Value": [145]}, "145": {"vr": "IS", "Value": [146]}, "146": {"vr": "IS", "Value": [147]}, "147": {"vr": "IS", "Value": [148]}, "148": {"vr": "IS", "Value": [149]}, "149": {"vr": "IS", "Value": [150]}, "150": {"vr": "IS", "Value": [151]}, "151": {"vr": "IS", "Value": [152]}, "152": {"vr": "IS", "Value": [153]}, "153": {"vr": "IS", "Value": [154]}, "154": {"vr": "IS", "Value": [155]}, "155": {"vr": "IS", "Value": [156]}, "156": {"vr": "IS", "Value": [157]}, "157": {"vr": "IS", "Value": [158]}, "158": {"vr": "IS", "Value": [159]}, "159": {"vr": "IS", "Value": [160]}, "160": {"vr": "IS", "Value": [161]}, "161": {"vr": "IS", "Value": [162]}, "162": {"vr": "IS", "Value": [163]}, "163": {"vr": "IS", "Value": [164]}, "164": {"vr": "IS", "Value": [165]}, "165": {"vr": "IS", "Value": [166]}, "166": {"vr": "IS", "Value": [167]}, "167": {"vr": "IS", "Value": [168]}, "168": {"vr": "IS", "Value": [169]}, "169": {"vr": "IS", "Value": [170]}, "170": {"vr": "IS", "Value": [171]}, "171": {"vr": "IS", "Value": [172]}, "172": {"vr": "IS", "Value": [173]}, "173": {"vr": "IS", "Value": [174]}, "174": {"vr": "IS", "Value": [175]}, "175": {"vr": "IS", "Value": [176]}, "176": {"vr": "IS", "Value": [177]}, "177": {"vr": "IS", "Value": [178]}, "178": {"vr": "IS", "Value": [179]}, "179": {"vr": "IS", "Value": [180]}, "180": {"vr": "IS", "Value": [181]}, "181": {"vr": "IS", "Value": [182]}, "182": {"vr": "IS", "Value": [183]}, "183": {"vr": "IS", "Value": [184]}, "184": {"vr": "IS", "Value": [185]}, "185": {"vr": "IS", "Value": [186]}, "186": {"vr": "IS", "Value": [187]}, "187": {"vr": "IS", "Value": [188]}, "188": {"vr": "IS", "Value": [189]}, "189": {"vr": "IS", "Value": [190]}, "190": {"vr": "IS", "Value": [191]}, "191": {"vr": "IS", "Value": [192]}, "192": {"vr": "IS", "Value": [193]}, "193": {"vr": "IS", "Value": [194]}, "194": {"vr": "IS", "Value": [195]}, "195": {"vr": "IS", "Value": [196]}, "196": {"vr": "IS", "Value": [197]}, "197": {"vr": "IS", "Value": [198]}, "198": {"vr": "IS", "Value": [199]}, "199": {"vr": "IS", "Value": [200]}, "200": {"vr": "IS", "Value": [201]}, "201": {"vr": "IS", "Value": [202]}, "202": {"vr": "IS", "Value": [203]}, "203": {"vr": "IS", "Value": [204]}, "204": {"vr": "IS", "Value": [205]}, "205": {"vr": "IS", "Value": [206]}, "206": {"vr": "IS", "Value": [207]}, "207": {"vr": "IS", "Value": [208]}, "208": {"vr": "IS", "Value": [209]}, "209": {"vr": "IS", "Value": [210]}, "210": {"vr": "IS", "Value": [211]}, "211": {"vr": "IS", "Value": [212]}, "212": {"vr": "IS", "Value": [213]}, "213": {"vr": "IS", "Value": [214]}, "214": {"vr": "IS", "Value": [215]}, "215": {"vr": "IS", "Value": [216]}, "216": {"vr": "IS", "Value": [217]}, "217": {"vr": "IS", "Value": [218]}, "218": {"vr": "IS", "Value": [219]}, "219": {"vr": "IS", "Value": [220]}, "220": {"vr": "IS", "Value": [221]}, "221": {"vr": "IS", "Value": [222]}, "222": {"vr": "IS", "Value": [223]}, "223": {"vr": "IS", "Value": [224]}, "224": {"vr": "IS", "Value": [225]}, "225": {"vr": "IS", "Value": [226]}, "226": {"vr": "IS", "Value": [227]}, "227": {"vr": "IS", "Value": [228]}, "228": {"vr": "IS", "Value": [229]}, "229": {"vr": "IS", "Value": [230]}, "230": {"vr": "IS", "Value": [231]}, "231": {"vr": "IS", "Value": [232]}, "232": {"vr": "IS", "Value": [233]}, "233": {"vr": "IS", "Value": [234]}, "234": {"vr": "IS", "Value": [235]}, "235": {"vr": "IS", "Value": [236]}, "236": {"vr": "IS", "Value": [237]}, "237": {"vr": "IS", "Value": [238]}, "238": {"vr": "IS", "Value": [239]}, "239": {"vr": "IS", "Value": [240]}, "240": {"vr": "IS", "Value": [241]}, "241": {"vr": "IS", "Value": [242]}, "242": {"vr": "IS", "Value": [243]}, "243": {"vr": "IS", "Value": [244]}, "244": {"vr": "IS", "Value": [245]}, "245": {"vr": "IS", "Value": [246]}, "246": {"vr": "IS", "Value": [247]}, "247": {"vr": "IS", "Value": [248]}, "248": {"vr": "IS", "Value": [249]}, "249": {"vr": "IS", "Value": [250]}, "250": {"vr": "IS", "Value": [251]}, "251": {"vr": "IS", "Value": [252]}, "252": {"vr": "IS", "Value": [253]}, "253": {"vr": "IS", "Value": [254]}, "254": {"vr": "IS", "Value": [255]}, "255": {"vr": "IS", "Value": [256]}, "256": {"vr": "IS", "Value": [257]}, "257": {"vr": "IS", "Value": [258]}, "258": {"vr": "IS", "Value": [259]}, "259": {"vr": "IS", "Value": [260]}, "260": {"vr": "IS", "Value": [261]}, "261": {"vr": "IS", "Value": [262]}, "262": {"vr": "IS", "Value": [263]}, "263": {"vr": "IS", "Value": [264]}, "264": {"vr": "IS", "Value": [265]}, "265": {"vr": "IS", "Value": [266]}, "266": {"vr": "IS", "Value": [267]}, "267": {"vr": "IS", "Value": [268]}, "268": {"vr": "IS", "Value": [269]}, "269": {"vr": "IS", "Value": [270]}, "270": {"vr": "IS", "Value": [271]}, "271": {"vr": "IS", "Value": [272]}, "272": {"vr": "IS", "Value": [273]}, "273": {"vr": "IS", "Value": [274]}, "274": {"vr": "IS", "Value": [275]}, "275": {"vr": "IS", "Value": [276]}, "276": {"vr": "IS", "Value": [277]}, "277": {"vr": "IS", "Value": [278]}, "278": {"vr": "IS", "Value": [279]}, "279": {"vr": "IS", "Value": [280]}, "280": {"vr": "IS", "Value": [281]}, "281": {"vr": "IS", "Value": [282]}, "282": {"vr": "IS", "Value": [283]}, "283": {"vr": "IS", "Value": [284]}, "284": {"vr": "IS", "Value": [285]}, "285": {"vr": "IS", "Value": [286]}, "286": {"vr": "IS", "Value": [287]}, "287": {"vr": "IS", "Value": [288]}, "288": {"vr": "IS", "Value": [289]}, "289": {"vr": "IS", "Value": [290]}, "290": {"vr": "IS", "Value": [291]}, "291": {"vr": "IS", "Value": [292]}, "292": {"vr": "IS", "Value": [293]}, "293": {"vr": "IS", "Value": [294]}, "294": {"vr": "IS", "Value": [295]}, "295": {"vr": "IS", "Value": [296]}, "296": {"vr": "IS", "Value": [297]}, "297": {"vr": "IS", "Value": [298]}, "298": {"vr": "IS", "Value": [299]}, "299": {"vr": "IS", "Value": [300]}, "300": {"vr": "IS", "Value": [301]}, "301": {"vr": "IS", "Value": [302]}, "302": {"vr": "IS", "Value": [303]}, "303": {"vr": "IS", "Value": [304]}, "304": {"vr": "IS", "Value": [305]}, "305": {"vr": "IS", "Value": [306]}, "306": {"vr": "IS", "Value": [307]}, "307": {"vr": "IS", "Value": [308]}, "308": {"vr": "IS", "Value": [309]}, "309": {"vr": "IS", "Value": [310]}, "310": {"vr": "IS", "Value": [311]}, "311": {"vr": "IS", "Value": [312]}, "312": {"vr": "IS", "Value": [313]}, "313": {"vr": "IS", "Value": [314]}, "314": {"vr": "IS", "Value": [315]}, "315": {"vr": "IS", "Value": [316]}, "316": {"vr": "IS", "Value": [317]}, "317": {"vr": "IS", "Value": [318]}, "318": {"vr": "IS", "Value": [319]}, "319": {"vr": "IS", "Value": [320]}, "320": {"vr": "IS", "Value": [321]}, "321": {"vr": "IS", "Value": [322]}, "322": {"vr": "IS", "Value": [323]}, "323": {"vr": "IS", "Value": [324]}, "324": {"vr": "IS", "Value": [325]}, "325": {"vr": "IS", "Value": [326]}, "326": {"vr": "IS", "Value": [327]}, "327": {"vr": "IS", "Value": [328]}, "328": {"vr": "IS", "Value": [329]}, "329": {"vr": "IS", "Value": [330]}, "330": {"vr": "IS", "Value": [331]}, "331": {"vr": "IS", "Value": [332]}, "332": {"vr": "IS", "Value": [333]}, "333": {"vr": "IS", "Value": [334]}, "334": {"vr": "IS", "Value": [335]}, "335": {"vr": "IS", "Value": [336]}, "336": {"vr": "IS", "Value": [337]}, "337": {"vr": "IS", "Value": [338]}, "338": {"vr": "IS", "Value": [339]}, "339": {"vr": "IS", "Value": [340]}, "340": {"vr": "IS", "Value": [341]}, "341": {"vr": "IS", "Value": [342]}, "342": {"vr": "IS", "Value": [343]}, "343": {"vr": "IS", "Value": [344]}, "344": {"vr": "IS", "Value": [345]}, "345": {"vr": "IS", "Value": [346]}, "346": {"vr": "IS", "Value": [347]}, "347": {"vr": "IS", "Value": [348]}, "348": {"vr": "IS", "Value": [349]}, "349": {"vr": "IS", "Value": [350]}, "350": {"vr": "IS", "Value": [351]}, "351": {"vr": "IS", "Value": [352]}, "352": {"vr": "IS", "Value": [353]}, "353": {"vr": "IS", "Value": [354]}, "354": {"vr": "IS", "Value": [355]}, "355": {"vr": "IS", "Value": [356]}, "356": {"vr": "IS", "Value": [357]}, "357": {"vr": "IS", "Value": [358]}, "358": {"vr": "IS", "Value": [359]}, "359": {"vr": "IS", "Value": [360]}, "360": {"vr": "IS", "Value": [361]}, "361": {"vr": "IS", "Value": [362]}, "362": {"vr": "IS", "Value": [363]}, "363": {"vr": "IS", "Value": [364]}, "364": {"vr": "IS", "Value": [365]}, "365": {"vr": "IS", "Value": [366]}, "366": {"vr": "IS", "Value": [367]}, "367": {"vr": "IS", "Value": [368]}, "368": {"vr": "IS", "Value": [369]}, "369": {"vr": "IS", "Value": [370]}, "370": {"vr": "IS", "Value": [371]}, "371": {"vr": "IS", "Value": [372]}, "372": {"vr": "IS", "Value": [373]}, "373": {"vr": "IS", "Value": [374]}, "374": {"vr": "IS", "Value": [375]}, "375": {"vr": "IS", "Value": [376]}, "376": {"vr": "IS", "Value": [377]}, "377": {"vr": "IS", "Value": [378]}, "378": {"vr": "IS", "Value": [379]}, "379": {"vr": "IS", "Value": [380]}, "380": {"vr": "IS", "Value": [381]}, "381": {"vr": "IS", "Value": [382]}, "382": {"vr": "IS", "Value": [383]}, "383": {"vr": "IS", "Value": [384]}, "384": {"vr": "IS", "Value": [385]}, "385": {"vr": "IS", "Value": [386]}, "386": {"vr": "IS", "Value": [387]}, "387": {"vr": "IS", "Value": [388]}, "388": {"vr": "IS", "Value": [389]}, "389": {"vr": "IS", "Value": [390]}, "390": {"vr": "IS", "Value": [391]}, "391": {"vr": "IS", "Value": [392]}, "392": {"vr": "IS", "Value": [393]}, "393": {"vr": "IS", "Value": [394]}, "394": {"vr": "IS", "Value": [395]}, "395": {"vr": "IS", "Value": [396]}, "396": {"vr": "IS", "Value": [397]}, "397": {"vr": "IS", "Value": [398]}, "398": {"vr": "IS", "Value": [399]}, "399": {"vr": "IS", "Value": [400]}, "400": {"vr": "IS", "Value": [401]}, "401": {"vr": "IS", "Value": [402]}, "402": {"vr": "IS", "Value": [403]}, "403": {"vr": "IS", "Value": [404]}, "404": {"vr": "IS", "Value": [405]}, "405": {"vr": "IS", "Value": [406]}, "406": {"vr": "IS", "Value": [407]}, "407": {"vr": "IS", "Value": [408]}, "408": {"vr": "IS", "Value": [409]}, "409": {"vr": "IS", "Value": [410]}, "410": {"vr": "IS", "Value": [411]}, "411": {"vr": "IS", "Value": [412]}, "412": {"vr": "IS", "Value": [413]}, "413": {"vr": "IS", "Value": [414]}, "414": {"vr": "IS", "Value": [415]}, "415": {"vr": "IS", "Value": [416]}, "416": {"vr": "IS", "Value": [417]}, "417": {"vr": "IS", "Value": [418]}, "418": {"vr": "IS", "Value": [419]}, "419": {"vr": "IS", "Value": [420]}, "420": {"vr": "IS", "Value": [421]}, "421": {"vr": "IS", "Value": [422]}, "422": {"vr": "IS", "Value": [423]}, "423": {"vr": "IS", "Value": [424]}, "424": {"vr": "IS", "Value": [425]}, "425": {"vr": "IS", "Value": [426]}, "426": {"vr": "IS", "Value": [427]}, "427": {"vr": "IS", "Value": [428]}, "428": {"vr": "IS", "Value": [429]}, "429": {"vr": "IS", "Value": [430]}, "430": {"vr": "IS", "Value": [431]}, "431": {"vr": "IS", "Value": [432]}, "432": {"vr": "IS", "Value": [433]}, "433": {"vr": "IS", "Value": [434]}, "434": {"vr": "IS", "Value": [435]}, "435": {"vr": "IS", "Value": [436]}, "436": {"vr": "IS", "Value": [437]}, "437": {"vr": "IS", "Value": [438]}, "438": {"vr": "IS", "Value": [439]}, "439": {"vr": "IS", "Value": [440]}, "440": {"vr": "IS", "Value": [441]}, "441": {"vr": "IS", "Value": [442]}, "442": {"vr": "IS", "Value": [443]}, "443": {"vr": "IS", "Value": [444]}, "444": {"vr": "IS", "Value": [445]}, "445": {"vr": "IS", "Value": [446]}, "446": {"vr": "IS", "Value": [447]}, "447": {"vr": "IS", "Value": [448]}, "448": {"vr": "IS", "Value": [449]}, "449": {"vr": "IS", "Value": [450]}, "450": {"vr": "IS", "Value": [451]}, "451": {"vr": "IS", "Value": [452]}, "452": {"vr": "IS", "Value": [453]}, "453": {"vr": "IS", "Value": [454]}, "454": {"vr": "IS", "Value": [455]}, "455": {"vr": "IS", "Value": [456]}, "456": {"vr": "IS", "Value": [457]}, "457": {"vr": "IS", "Value": [458]}, "458": {"vr": "IS", "Value": [459]}, "459": {"vr": "IS", "Value": [460]}, "460": {"vr": "IS", "Value": [461]}, "461": {"vr": "IS", "Value": [462]}, "462": {"vr": "IS", "Value": [463]}, "463": {"vr": "IS", "Value": [464]}, "464": {"vr": "IS", "Value": [465]}, "465": {"vr": "IS", "Value": [466]}, "466": {"vr": "IS", "Value": [467]}, "467": {"vr": "IS", "Value": [468]}, "468": {"vr": "IS", "Value": [469]}, "469": {"vr": "IS", "Value": [470]}, "470": {"vr": "IS", "Value": [471]}, "471": {"vr": "IS", "Value": [472]}, "472": {"vr": "IS", "Value": [473]}, "473": {"vr": "IS", "Value": [474]}, "474": {"vr": "IS", "Value": [475]}, "475": {"vr": "IS", "Value": [476]}, "476": {"vr": "IS", "Value": [477]}, "477": {"vr": "IS", "Value": [478]}, "478": {"vr": "IS", "Value": [479]}, "479": {"vr": "IS", "Value": [480]}, "480": {"vr": "IS", "Value": [481]}, "481": {"vr": "IS", "Value": [482]}, "482": {"vr": "IS", "Value": [483]}, "483": {"vr": "IS", "Value": [484]}, "484": {"vr": "IS", "Value": [485]}, "485": {"vr": "IS", "Value": [486]}, "486": {"vr": "IS", "Value": [487]}, "487": {"vr": "IS", "Value": [488]}, "488": {"vr": "IS", "Value": [489]}, "489": {"vr": "IS", "Value": [490]}, "490": {"vr": "IS", "Value": [491]}, "491": {"vr": "IS", "Value": [492]}, "492": {"vr": "IS", "Value": [493]}, "493": {"vr": "IS", "Value": [494]}, "494": {"vr": "IS", "Value": [495]}, "495": {"vr": "IS", "Value": [496]}, "496": {"vr": "IS", "Value": [497]}, "497": {"vr": "IS", "Value": [498]}, "498": {"vr": "IS", "Value": [499]}, "499": {"vr": "IS", "Value": [500]}, "500": {"vr": "IS", "Value": [501]}, "501": {"vr": "IS", "Value": [502]}, "502": {"vr": "IS", "Value": [503]}, "503": {"vr": "IS", "Value": [504]}, "504": {"vr": "IS", "Value": [505]}, "505": {"vr": "IS", "Value": [506]}, "506": {"vr": "IS", "Value": [507]}, "507": {"vr": "IS", "Value": [508]}, "508": {"vr": "IS", "Value": [509]}, "509": {"vr": "IS", "Value": [510]}, "510": {"vr": "IS", "Value": [511]}, "511": {"vr": "IS", "Value": [512]}, "512": {"vr": "IS", "Value": [513]}, "513": {"vr": "IS", "Value": [514]}, "514": {"vr": "IS", "Value": [515]}, "515": {"vr": "IS", "Value": [516]}, "516": {"vr": "IS", "Value": [517]}, "517": {"vr": "IS", "Value": [518]}, "518": {"vr": "IS", "Value": [519]}, "519": {"vr": "IS", "Value": [520]}, "520": {"vr": "IS", "Value": [521]}, "521": {"vr": "IS", "Value": [522]}, "522": {"vr": "IS", "Value": [523]}, "523": {"vr": "IS", "Value": [524]}, "524": {"vr": "IS", "Value": [525]}, "525": {"vr": "IS", "Value": [526]}, "526": {"vr": "IS", "Value": [527]}, "527": {"vr": "IS", "Value": [528]}, "528": {"vr": "IS", "Value": [529]}, "529": {"vr": "IS", "Value": [530]}, "530": {"vr": "IS", "Value": [531]}}, "00200032": {"0": {"vr": "DS", "Value": [-362.847, -503.29, 168.5]}, "1": {"vr": "DS", "Value": [-362.847, -503.29, 166.5]}, "2": {"vr": "DS", "Value": [-362.847, -503.29, 164.5]}, "3": {"vr": "DS", "Value": [-362.847, -503.29, 162.5]}, "4": {"vr": "DS", "Value": [-362.847, -503.29, 160.5]}, "5": {"vr": "DS", "Value": [-362.847, -503.29, 158.5]}, "6": {"vr": "DS", "Value": [-362.847, -503.29, 156.5]}, "7": {"vr": "DS", "Value": [-362.847, -503.29, 154.5]}, "8": {"vr": "DS", "Value": [-362.847, -503.29, 152.5]}, "9": {"vr": "DS", "Value": [-362.847, -503.29, 150.5]}, "10": {"vr": "DS", "Value": [-362.847, -503.29, 148.5]}, "11": {"vr": "DS", "Value": [-362.847, -503.29, 146.5]}, "12": {"vr": "DS", "Value": [-362.847, -503.29, 144.5]}, "13": {"vr": "DS", "Value": [-362.847, -503.29, 142.5]}, "14": {"vr": "DS", "Value": [-362.847, -503.29, 140.5]}, "15": {"vr": "DS", "Value": [-362.847, -503.29, 138.5]}, "16": {"vr": "DS", "Value": [-362.847, -503.29, 136.5]}, "17": {"vr": "DS", "Value": [-362.847, -503.29, 134.5]}, "18": {"vr": "DS", "Value": [-362.847, -503.29, 132.5]}, "19": {"vr": "DS", "Value": [-362.847, -503.29, 130.5]}, "20": {"vr": "DS", "Value": [-362.847, -503.29, 128.5]}, "21": {"vr": "DS", "Value": [-362.847, -503.29, 126.5]}, "22": {"vr": "DS", "Value": [-362.847, -503.29, 124.5]}, "23": {"vr": "DS", "Value": [-362.847, -503.29, 122.5]}, "24": {"vr": "DS", "Value": [-362.847, -503.29, 120.5]}, "25": {"vr": "DS", "Value": [-362.847, -503.29, 118.5]}, "26": {"vr": "DS", "Value": [-362.847, -503.29, 116.5]}, "27": {"vr": "DS", "Value": [-362.847, -503.29, 114.5]}, "28": {"vr": "DS", "Value": [-362.847, -503.29, 112.5]}, "29": {"vr": "DS", "Value": [-362.847, -503.29, 110.5]}, "30": {"vr": "DS", "Value": [-362.847, -503.29, 108.5]}, "31": {"vr": "DS", "Value": [-362.847, -503.29, 106.5]}, "32": {"vr": "DS", "Value": [-362.847, -503.29, 104.5]}, "33": {"vr": "DS", "Value": [-362.847, -503.29, 102.5]}, "34": {"vr": "DS", "Value": [-362.847, -503.29, 100.5]}, "35": {"vr": "DS", "Value": [-362.847, -503.29, 98.5]}, "36": {"vr": "DS", "Value": [-362.847, -503.29, 96.5]}, "37": {"vr": "DS", "Value": [-362.847, -503.29, 94.5]}, "38": {"vr": "DS", "Value": [-362.847, -503.29, 92.5]}, "39": {"vr": "DS", "Value": [-362.847, -503.29, 90.5]}, "40": {"vr": "DS", "Value": [-362.847, -503.29, 88.5]}, "41": {"vr": "DS", "Value": [-362.847, -503.29, 86.5]}, "42": {"vr": "DS", "Value": [-362.847, -503.29, 84.5]}, "43": {"vr": "DS", "Value": [-362.847, -503.29, 82.5]}, "44": {"vr": "DS", "Value": [-362.847, -503.29, 80.5]}, "45": {"vr": "DS", "Value": [-362.847, -503.29, 78.5]}, "46": {"vr": "DS", "Value": [-362.847, -503.29, 76.5]}, "47": {"vr": "DS", "Value": [-362.847, -503.29, 74.5]}, "48": {"vr": "DS", "Value": [-362.847, -503.29, 72.5]}, "49": {"vr": "DS", "Value": [-362.847, -503.29, 70.5]}, "50": {"vr": "DS", "Value": [-362.847, -503.29, 68.5]}, "51": {"vr": "DS", "Value": [-362.847, -503.29, 66.5]}, "52": {"vr": "DS", "Value": [-362.847, -503.29, 64.5]}, "53": {"vr": "DS", "Value": [-362.847, -503.29, 62.5]}, "54": {"vr": "DS", "Value": [-362.847, -503.29, 60.5]}, "55": {"vr": "DS", "Value": [-362.847, -503.29, 58.5]}, "56": {"vr": "DS", "Value": [-362.847, -503.29, 56.5]}, "57": {"vr": "DS", "Value": [-362.847, -503.29, 54.5]}, "58": {"vr": "DS", "Value": [-362.847, -503.29, 52.5]}, "59": {"vr": "DS", "Value": [-362.847, -503.29, 50.5]}, "60": {"vr": "DS", "Value": [-362.847, -503.29, 48.5]}, "61": {"vr": "DS", "Value": [-362.847, -503.29, 46.5]}, "62": {"vr": "DS", "Value": [-362.847, -503.29, 44.5]}, "63": {"vr": "DS", "Value": [-362.847, -503.29, 42.5]}, "64": {"vr": "DS", "Value": [-362.847, -503.29, 40.5]}, "65": {"vr": "DS", "Value": [-362.847, -503.29, 38.5]}, "66": {"vr": "DS", "Value": [-362.847, -503.29, 36.5]}, "67": {"vr": "DS", "Value": [-362.847, -503.29, 34.5]}, "68": {"vr": "DS", "Value": [-362.847, -503.29, 32.5]}, "69": {"vr": "DS", "Value": [-362.847, -503.29, 30.5]}, "70": {"vr": "DS", "Value": [-362.847, -503.29, 28.5]}, "71": {"vr": "DS", "Value": [-362.847, -503.29, 26.5]}, "72": {"vr": "DS", "Value": [-362.847, -503.29, 24.5]}, "73": {"vr": "DS", "Value": [-362.847, -503.29, 22.5]}, "74": {"vr": "DS", "Value": [-362.847, -503.29, 20.5]}, "75": {"vr": "DS", "Value": [-362.847, -503.29, 18.5]}, "76": {"vr": "DS", "Value": [-362.847, -503.29, 16.5]}, "77": {"vr": "DS", "Value": [-362.847, -503.29, 14.5]}, "78": {"vr": "DS", "Value": [-362.847, -503.29, 12.5]}, "79": {"vr": "DS", "Value": [-362.847, -503.29, 10.5]}, "80": {"vr": "DS", "Value": [-362.847, -503.29, 8.5]}, "81": {"vr": "DS", "Value": [-362.847, -503.29, 6.5]}, "82": {"vr": "DS", "Value": [-362.847, -503.29, 4.5]}, "83": {"vr": "DS", "Value": [-362.847, -503.29, 2.5]}, "84": {"vr": "DS", "Value": [-362.847, -503.29, 0.5]}, "85": {"vr": "DS", "Value": [-362.847, -503.29, -1.5]}, "86": {"vr": "DS", "Value": [-362.847, -503.29, -3.5]}, "87": {"vr": "DS", "Value": [-362.847, -503.29, -5.5]}, "88": {"vr": "DS", "Value": [-362.847, -503.29, -7.5]}, "89": {"vr": "DS", "Value": [-362.847, -503.29, -9.5]}, "90": {"vr": "DS", "Value": [-362.847, -503.29, -11.5]}, "91": {"vr": "DS", "Value": [-362.847, -503.29, -13.5]}, "92": {"vr": "DS", "Value": [-362.847, -503.29, -15.5]}, "93": {"vr": "DS", "Value": [-362.847, -503.29, -17.5]}, "94": {"vr": "DS", "Value": [-362.847, -503.29, -19.5]}, "95": {"vr": "DS", "Value": [-362.847, -503.29, -21.5]}, "96": {"vr": "DS", "Value": [-362.847, -503.29, -23.5]}, "97": {"vr": "DS", "Value": [-362.847, -503.29, -25.5]}, "98": {"vr": "DS", "Value": [-362.847, -503.29, -27.5]}, "99": {"vr": "DS", "Value": [-362.847, -503.29, -29.5]}, "100": {"vr": "DS", "Value": [-362.847, -503.29, -31.5]}, "101": {"vr": "DS", "Value": [-362.847, -503.29, -33.5]}, "102": {"vr": "DS", "Value": [-362.847, -503.29, -35.5]}, "103": {"vr": "DS", "Value": [-362.847, -503.29, -37.5]}, "104": {"vr": "DS", "Value": [-362.847, -503.29, -39.5]}, "105": {"vr": "DS", "Value": [-362.847, -503.29, -41.5]}, "106": {"vr": "DS", "Value": [-362.847, -503.29, -43.5]}, "107": {"vr": "DS", "Value": [-362.847, -503.29, -45.5]}, "108": {"vr": "DS", "Value": [-362.847, -503.29, -47.5]}, "109": {"vr": "DS", "Value": [-362.847, -503.29, -49.5]}, "110": {"vr": "DS", "Value": [-362.847, -503.29, -51.5]}, "111": {"vr": "DS", "Value": [-362.847, -503.29, -53.5]}, "112": {"vr": "DS", "Value": [-362.847, -503.29, -55.5]}, "113": {"vr": "DS", "Value": [-362.847, -503.29, -57.5]}, "114": {"vr": "DS", "Value": [-362.847, -503.29, -59.5]}, "115": {"vr": "DS", "Value": [-362.847, -503.29, -61.5]}, "116": {"vr": "DS", "Value": [-362.847, -503.29, -63.5]}, "117": {"vr": "DS", "Value": [-362.847, -503.29, -65.5]}, "118": {"vr": "DS", "Value": [-362.847, -503.29, -67.5]}, "119": {"vr": "DS", "Value": [-362.847, -503.29, -69.5]}, "120": {"vr": "DS", "Value": [-362.847, -503.29, -71.5]}, "121": {"vr": "DS", "Value": [-362.847, -503.29, -73.5]}, "122": {"vr": "DS", "Value": [-362.847, -503.29, -75.5]}, "123": {"vr": "DS", "Value": [-362.847, -503.29, -77.5]}, "124": {"vr": "DS", "Value": [-362.847, -503.29, -79.5]}, "125": {"vr": "DS", "Value": [-362.847, -503.29, -81.5]}, "126": {"vr": "DS", "Value": [-362.847, -503.29, -83.5]}, "127": {"vr": "DS", "Value": [-362.847, -503.29, -85.5]}, "128": {"vr": "DS", "Value": [-362.847, -503.29, -87.5]}, "129": {"vr": "DS", "Value": [-362.847, -503.29, -89.5]}, "130": {"vr": "DS", "Value": [-362.847, -503.29, -91.5]}, "131": {"vr": "DS", "Value": [-362.847, -503.29, -93.5]}, "132": {"vr": "DS", "Value": [-362.847, -503.29, -95.5]}, "133": {"vr": "DS", "Value": [-362.847, -503.29, -97.5]}, "134": {"vr": "DS", "Value": [-362.847, -503.29, -99.5]}, "135": {"vr": "DS", "Value": [-362.847, -503.29, -101.5]}, "136": {"vr": "DS", "Value": [-362.847, -503.29, -103.5]}, "137": {"vr": "DS", "Value": [-362.847, -503.29, -105.5]}, "138": {"vr": "DS", "Value": [-362.847, -503.29, -107.5]}, "139": {"vr": "DS", "Value": [-362.847, -503.29, -109.5]}, "140": {"vr": "DS", "Value": [-362.847, -503.29, -111.5]}, "141": {"vr": "DS", "Value": [-362.847, -503.29, -113.5]}, "142": {"vr": "DS", "Value": [-362.847, -503.29, -115.5]}, "143": {"vr": "DS", "Value": [-362.847, -503.29, -117.5]}, "144": {"vr": "DS", "Value": [-362.847, -503.29, -119.5]}, "145": {"vr": "DS", "Value": [-362.847, -503.29, -121.5]}, "146": {"vr": "DS", "Value": [-362.847, -503.29, -123.5]}, "147": {"vr": "DS", "Value": [-362.847, -503.29, -125.5]}, "148": {"vr": "DS", "Value": [-362.847, -503.29, -127.5]}, "149": {"vr": "DS", "Value": [-362.847, -503.29, -129.5]}, "150": {"vr": "DS", "Value": [-362.847, -503.29, -131.5]}, "151": {"vr": "DS", "Value": [-362.847, -503.29, -133.5]}, "152": {"vr": "DS", "Value": [-362.847, -503.29, -135.5]}, "153": {"vr": "DS", "Value": [-362.847, -503.29, -137.5]}, "154": {"vr": "DS", "Value": [-362.847, -503.29, -139.5]}, "155": {"vr": "DS", "Value": [-362.847, -503.29, -141.5]}, "156": {"vr": "DS", "Value": [-362.847, -503.29, -143.5]}, "157": {"vr": "DS", "Value": [-362.847, -503.29, -145.5]}, "158": {"vr": "DS", "Value": [-362.847, -503.29, -147.5]}, "159": {"vr": "DS", "Value": [-362.847, -503.29, -149.5]}, "160": {"vr": "DS", "Value": [-362.847, -503.29, -151.5]}, "161": {"vr": "DS", "Value": [-362.847, -503.29, -153.5]}, "162": {"vr": "DS", "Value": [-362.847, -503.29, -155.5]}, "163": {"vr": "DS", "Value": [-362.847, -503.29, -157.5]}, "164": {"vr": "DS", "Value": [-362.847, -503.29, -159.5]}, "165": {"vr": "DS", "Value": [-362.847, -503.29, -161.5]}, "166": {"vr": "DS", "Value": [-362.847, -503.29, -163.5]}, "167": {"vr": "DS", "Value": [-362.847, -503.29, -165.5]}, "168": {"vr": "DS", "Value": [-362.847, -503.29, -167.5]}, "169": {"vr": "DS", "Value": [-362.847, -503.29, -169.5]}, "170": {"vr": "DS", "Value": [-362.847, -503.29, -171.5]}, "171": {"vr": "DS", "Value": [-362.847, -503.29, -173.5]}, "172": {"vr": "DS", "Value": [-362.847, -503.29, -175.5]}, "173": {"vr": "DS", "Value": [-362.847, -503.29, -177.5]}, "174": {"vr": "DS", "Value": [-362.847, -503.29, -179.5]}, "175": {"vr": "DS", "Value": [-362.847, -503.29, -181.5]}, "176": {"vr": "DS", "Value": [-362.847, -503.29, -183.5]}, "177": {"vr": "DS", "Value": [-362.847, -503.29, -185.5]}, "178": {"vr": "DS", "Value": [-362.847, -503.29, -187.5]}, "179": {"vr": "DS", "Value": [-362.847, -503.29, -189.5]}, "180": {"vr": "DS", "Value": [-362.847, -503.29, -191.5]}, "181": {"vr": "DS", "Value": [-362.847, -503.29, -193.5]}, "182": {"vr": "DS", "Value": [-362.847, -503.29, -195.5]}, "183": {"vr": "DS", "Value": [-362.847, -503.29, -197.5]}, "184": {"vr": "DS", "Value": [-362.847, -503.29, -199.5]}, "185": {"vr": "DS", "Value": [-362.847, -503.29, -201.5]}, "186": {"vr": "DS", "Value": [-362.847, -503.29, -203.5]}, "187": {"vr": "DS", "Value": [-362.847, -503.29, -205.5]}, "188": {"vr": "DS", "Value": [-362.847, -503.29, -207.5]}, "189": {"vr": "DS", "Value": [-362.847, -503.29, -209.5]}, "190": {"vr": "DS", "Value": [-362.847, -503.29, -211.5]}, "191": {"vr": "DS", "Value": [-362.847, -503.29, -213.5]}, "192": {"vr": "DS", "Value": [-362.847, -503.29, -215.5]}, "193": {"vr": "DS", "Value": [-362.847, -503.29, -217.5]}, "194": {"vr": "DS", "Value": [-362.847, -503.29, -219.5]}, "195": {"vr": "DS", "Value": [-362.847, -503.29, -221.5]}, "196": {"vr": "DS", "Value": [-362.847, -503.29, -223.5]}, "197": {"vr": "DS", "Value": [-362.847, -503.29, -225.5]}, "198": {"vr": "DS", "Value": [-362.847, -503.29, -227.5]}, "199": {"vr": "DS", "Value": [-362.847, -503.29, -229.5]}, "200": {"vr": "DS", "Value": [-362.847, -503.29, -231.5]}, "201": {"vr": "DS", "Value": [-362.847, -503.29, -233.5]}, "202": {"vr": "DS", "Value": [-362.847, -503.29, -235.5]}, "203": {"vr": "DS", "Value": [-362.847, -503.29, -237.5]}, "204": {"vr": "DS", "Value": [-362.847, -503.29, -239.5]}, "205": {"vr": "DS", "Value": [-362.847, -503.29, -241.5]}, "206": {"vr": "DS", "Value": [-362.847, -503.29, -243.5]}, "207": {"vr": "DS", "Value": [-362.847, -503.29, -245.5]}, "208": {"vr": "DS", "Value": [-362.847, -503.29, -247.5]}, "209": {"vr": "DS", "Value": [-362.847, -503.29, -249.5]}, "210": {"vr": "DS", "Value": [-362.847, -503.29, -251.5]}, "211": {"vr": "DS", "Value": [-362.847, -503.29, -253.5]}, "212": {"vr": "DS", "Value": [-362.847, -503.29, -255.5]}, "213": {"vr": "DS", "Value": [-362.847, -503.29, -257.5]}, "214": {"vr": "DS", "Value": [-362.847, -503.29, -259.5]}, "215": {"vr": "DS", "Value": [-362.847, -503.29, -261.5]}, "216": {"vr": "DS", "Value": [-362.847, -503.29, -263.5]}, "217": {"vr": "DS", "Value": [-362.847, -503.29, -265.5]}, "218": {"vr": "DS", "Value": [-362.847, -503.29, -267.5]}, "219": {"vr": "DS", "Value": [-362.847, -503.29, -269.5]}, "220": {"vr": "DS", "Value": [-362.847, -503.29, -271.5]}, "221": {"vr": "DS", "Value": [-362.847, -503.29, -273.5]}, "222": {"vr": "DS", "Value": [-362.847, -503.29, -275.5]}, "223": {"vr": "DS", "Value": [-362.847, -503.29, -277.5]}, "224": {"vr": "DS", "Value": [-362.847, -503.29, -279.5]}, "225": {"vr": "DS", "Value": [-362.847, -503.29, -281.5]}, "226": {"vr": "DS", "Value": [-362.847, -503.29, -283.5]}, "227": {"vr": "DS", "Value": [-362.847, -503.29, -285.5]}, "228": {"vr": "DS", "Value": [-362.847, -503.29, -287.5]}, "229": {"vr": "DS", "Value": [-362.847, -503.29, -289.5]}, "230": {"vr": "DS", "Value": [-362.847, -503.29, -291.5]}, "231": {"vr": "DS", "Value": [-362.847, -503.29, -293.5]}, "232": {"vr": "DS", "Value": [-362.847, -503.29, -295.5]}, "233": {"vr": "DS", "Value": [-362.847, -503.29, -297.5]}, "234": {"vr": "DS", "Value": [-362.847, -503.29, -299.5]}, "235": {"vr": "DS", "Value": [-362.847, -503.29, -301.5]}, "236": {"vr": "DS", "Value": [-362.847, -503.29, -303.5]}, "237": {"vr": "DS", "Value": [-362.847, -503.29, -305.5]}, "238": {"vr": "DS", "Value": [-362.847, -503.29, -307.5]}, "239": {"vr": "DS", "Value": [-362.847, -503.29, -309.5]}, "240": {"vr": "DS", "Value": [-362.847, -503.29, -311.5]}, "241": {"vr": "DS", "Value": [-362.847, -503.29, -313.5]}, "242": {"vr": "DS", "Value": [-362.847, -503.29, -315.5]}, "243": {"vr": "DS", "Value": [-362.847, -503.29, -317.5]}, "244": {"vr": "DS", "Value": [-362.847, -503.29, -319.5]}, "245": {"vr": "DS", "Value": [-362.847, -503.29, -321.5]}, "246": {"vr": "DS", "Value": [-362.847, -503.29, -323.5]}, "247": {"vr": "DS", "Value": [-362.847, -503.29, -325.5]}, "248": {"vr": "DS", "Value": [-362.847, -503.29, -327.5]}, "249": {"vr": "DS", "Value": [-362.847, -503.29, -329.5]}, "250": {"vr": "DS", "Value": [-362.847, -503.29, -331.5]}, "251": {"vr": "DS", "Value": [-362.847, -503.29, -333.5]}, "252": {"vr": "DS", "Value": [-362.847, -503.29, -335.5]}, "253": {"vr": "DS", "Value": [-362.847, -503.29, -337.5]}, "254": {"vr": "DS", "Value": [-362.847, -503.29, -339.5]}, "255": {"vr": "DS", "Value": [-362.847, -503.29, -341.5]}, "256": {"vr": "DS", "Value": [-362.847, -503.29, -343.5]}, "257": {"vr": "DS", "Value": [-362.847, -503.29, -345.5]}, "258": {"vr": "DS", "Value": [-362.847, -503.29, -347.5]}, "259": {"vr": "DS", "Value": [-362.847, -503.29, -349.5]}, "260": {"vr": "DS", "Value": [-362.847, -503.29, -351.5]}, "261": {"vr": "DS", "Value": [-362.847, -503.29, -353.5]}, "262": {"vr": "DS", "Value": [-362.847, -503.29, -355.5]}, "263": {"vr": "DS", "Value": [-362.847, -503.29, -357.5]}, "264": {"vr": "DS", "Value": [-362.847, -503.29, -359.5]}, "265": {"vr": "DS", "Value": [-362.847, -503.29, -361.5]}, "266": {"vr": "DS", "Value": [-362.847, -503.29, -363.5]}, "267": {"vr": "DS", "Value": [-362.847, -503.29, -365.5]}, "268": {"vr": "DS", "Value": [-362.847, -503.29, -367.5]}, "269": {"vr": "DS", "Value": [-362.847, -503.29, -369.5]}, "270": {"vr": "DS", "Value": [-362.847, -503.29, -371.5]}, "271": {"vr": "DS", "Value": [-362.847, -503.29, -373.5]}, "272": {"vr": "DS", "Value": [-362.847, -503.29, -375.5]}, "273": {"vr": "DS", "Value": [-362.847, -503.29, -377.5]}, "274": {"vr": "DS", "Value": [-362.847, -503.29, -379.5]}, "275": {"vr": "DS", "Value": [-362.847, -503.29, -381.5]}, "276": {"vr": "DS", "Value": [-362.847, -503.29, -383.5]}, "277": {"vr": "DS", "Value": [-362.847, -503.29, -385.5]}, "278": {"vr": "DS", "Value": [-362.847, -503.29, -387.5]}, "279": {"vr": "DS", "Value": [-362.847, -503.29, -389.5]}, "280": {"vr": "DS", "Value": [-362.847, -503.29, -391.5]}, "281": {"vr": "DS", "Value": [-362.847, -503.29, -393.5]}, "282": {"vr": "DS", "Value": [-362.847, -503.29, -395.5]}, "283": {"vr": "DS", "Value": [-362.847, -503.29, -397.5]}, "284": {"vr": "DS", "Value": [-362.847, -503.29, -399.5]}, "285": {"vr": "DS", "Value": [-362.847, -503.29, -401.5]}, "286": {"vr": "DS", "Value": [-362.847, -503.29, -403.5]}, "287": {"vr": "DS", "Value": [-362.847, -503.29, -405.5]}, "288": {"vr": "DS", "Value": [-362.847, -503.29, -407.5]}, "289": {"vr": "DS", "Value": [-362.847, -503.29, -409.5]}, "290": {"vr": "DS", "Value": [-362.847, -503.29, -411.5]}, "291": {"vr": "DS", "Value": [-362.847, -503.29, -413.5]}, "292": {"vr": "DS", "Value": [-362.847, -503.29, -415.5]}, "293": {"vr": "DS", "Value": [-362.847, -503.29, -417.5]}, "294": {"vr": "DS", "Value": [-362.847, -503.29, -419.5]}, "295": {"vr": "DS", "Value": [-362.847, -503.29, -421.5]}, "296": {"vr": "DS", "Value": [-362.847, -503.29, -423.5]}, "297": {"vr": "DS", "Value": [-362.847, -503.29, -425.5]}, "298": {"vr": "DS", "Value": [-362.847, -503.29, -427.5]}, "299": {"vr": "DS", "Value": [-362.847, -503.29, -429.5]}, "300": {"vr": "DS", "Value": [-362.847, -503.29, -431.5]}, "301": {"vr": "DS", "Value": [-362.847, -503.29, -433.5]}, "302": {"vr": "DS", "Value": [-362.847, -503.29, -435.5]}, "303": {"vr": "DS", "Value": [-362.847, -503.29, -437.5]}, "304": {"vr": "DS", "Value": [-362.847, -503.29, -439.5]}, "305": {"vr": "DS", "Value": [-362.847, -503.29, -441.5]}, "306": {"vr": "DS", "Value": [-362.847, -503.29, -443.5]}, "307": {"vr": "DS", "Value": [-362.847, -503.29, -445.5]}, "308": {"vr": "DS", "Value": [-362.847, -503.29, -447.5]}, "309": {"vr": "DS", "Value": [-362.847, -503.29, -449.5]}, "310": {"vr": "DS", "Value": [-362.847, -503.29, -451.5]}, "311": {"vr": "DS", "Value": [-362.847, -503.29, -453.5]}, "312": {"vr": "DS", "Value": [-362.847, -503.29, -455.5]}, "313": {"vr": "DS", "Value": [-362.847, -503.29, -457.5]}, "314": {"vr": "DS", "Value": [-362.847, -503.29, -459.5]}, "315": {"vr": "DS", "Value": [-362.847, -503.29, -461.5]}, "316": {"vr": "DS", "Value": [-362.847, -503.29, -463.5]}, "317": {"vr": "DS", "Value": [-362.847, -503.29, -465.5]}, "318": {"vr": "DS", "Value": [-362.847, -503.29, -467.5]}, "319": {"vr": "DS", "Value": [-362.847, -503.29, -469.5]}, "320": {"vr": "DS", "Value": [-362.847, -503.29, -471.5]}, "321": {"vr": "DS", "Value": [-362.847, -503.29, -473.5]}, "322": {"vr": "DS", "Value": [-362.847, -503.29, -475.5]}, "323": {"vr": "DS", "Value": [-362.847, -503.29, -477.5]}, "324": {"vr": "DS", "Value": [-362.847, -503.29, -479.5]}, "325": {"vr": "DS", "Value": [-362.847, -503.29, -481.5]}, "326": {"vr": "DS", "Value": [-362.847, -503.29, -483.5]}, "327": {"vr": "DS", "Value": [-362.847, -503.29, -485.5]}, "328": {"vr": "DS", "Value": [-362.847, -503.29, -487.5]}, "329": {"vr": "DS", "Value": [-362.847, -503.29, -489.5]}, "330": {"vr": "DS", "Value": [-362.847, -503.29, -491.5]}, "331": {"vr": "DS", "Value": [-362.847, -503.29, -493.5]}, "332": {"vr": "DS", "Value": [-362.847, -503.29, -495.5]}, "333": {"vr": "DS", "Value": [-362.847, -503.29, -497.5]}, "334": {"vr": "DS", "Value": [-362.847, -503.29, -499.5]}, "335": {"vr": "DS", "Value": [-362.847, -503.29, -501.5]}, "336": {"vr": "DS", "Value": [-362.847, -503.29, -503.5]}, "337": {"vr": "DS", "Value": [-362.847, -503.29, -505.5]}, "338": {"vr": "DS", "Value": [-362.847, -503.29, -507.5]}, "339": {"vr": "DS", "Value": [-362.847, -503.29, -509.5]}, "340": {"vr": "DS", "Value": [-362.847, -503.29, -511.5]}, "341": {"vr": "DS", "Value": [-362.847, -503.29, -513.5]}, "342": {"vr": "DS", "Value": [-362.847, -503.29, -515.5]}, "343": {"vr": "DS", "Value": [-362.847, -503.29, -517.5]}, "344": {"vr": "DS", "Value": [-362.847, -503.29, -519.5]}, "345": {"vr": "DS", "Value": [-362.847, -503.29, -521.5]}, "346": {"vr": "DS", "Value": [-362.847, -503.29, -523.5]}, "347": {"vr": "DS", "Value": [-362.847, -503.29, -525.5]}, "348": {"vr": "DS", "Value": [-362.847, -503.29, -527.5]}, "349": {"vr": "DS", "Value": [-362.847, -503.29, -529.5]}, "350": {"vr": "DS", "Value": [-362.847, -503.29, -531.5]}, "351": {"vr": "DS", "Value": [-362.847, -503.29, -533.5]}, "352": {"vr": "DS", "Value": [-362.847, -503.29, -535.5]}, "353": {"vr": "DS", "Value": [-362.847, -503.29, -537.5]}, "354": {"vr": "DS", "Value": [-362.847, -503.29, -539.5]}, "355": {"vr": "DS", "Value": [-362.847, -503.29, -541.5]}, "356": {"vr": "DS", "Value": [-362.847, -503.29, -543.5]}, "357": {"vr": "DS", "Value": [-362.847, -503.29, -545.5]}, "358": {"vr": "DS", "Value": [-362.847, -503.29, -547.5]}, "359": {"vr": "DS", "Value": [-362.847, -503.29, -549.5]}, "360": {"vr": "DS", "Value": [-362.847, -503.29, -551.5]}, "361": {"vr": "DS", "Value": [-362.847, -503.29, -553.5]}, "362": {"vr": "DS", "Value": [-362.847, -503.29, -555.5]}, "363": {"vr": "DS", "Value": [-362.847, -503.29, -557.5]}, "364": {"vr": "DS", "Value": [-362.847, -503.29, -559.5]}, "365": {"vr": "DS", "Value": [-362.847, -503.29, -561.5]}, "366": {"vr": "DS", "Value": [-362.847, -503.29, -563.5]}, "367": {"vr": "DS", "Value": [-362.847, -503.29, -565.5]}, "368": {"vr": "DS", "Value": [-362.847, -503.29, -567.5]}, "369": {"vr": "DS", "Value": [-362.847, -503.29, -569.5]}, "370": {"vr": "DS", "Value": [-362.847, -503.29, -571.5]}, "371": {"vr": "DS", "Value": [-362.847, -503.29, -573.5]}, "372": {"vr": "DS", "Value": [-362.847, -503.29, -575.5]}, "373": {"vr": "DS", "Value": [-362.847, -503.29, -577.5]}, "374": {"vr": "DS", "Value": [-362.847, -503.29, -579.5]}, "375": {"vr": "DS", "Value": [-362.847, -503.29, -581.5]}, "376": {"vr": "DS", "Value": [-362.847, -503.29, -583.5]}, "377": {"vr": "DS", "Value": [-362.847, -503.29, -585.5]}, "378": {"vr": "DS", "Value": [-362.847, -503.29, -587.5]}, "379": {"vr": "DS", "Value": [-362.847, -503.29, -589.5]}, "380": {"vr": "DS", "Value": [-362.847, -503.29, -591.5]}, "381": {"vr": "DS", "Value": [-362.847, -503.29, -593.5]}, "382": {"vr": "DS", "Value": [-362.847, -503.29, -595.5]}, "383": {"vr": "DS", "Value": [-362.847, -503.29, -597.5]}, "384": {"vr": "DS", "Value": [-362.847, -503.29, -599.5]}, "385": {"vr": "DS", "Value": [-362.847, -503.29, -601.5]}, "386": {"vr": "DS", "Value": [-362.847, -503.29, -603.5]}, "387": {"vr": "DS", "Value": [-362.847, -503.29, -605.5]}, "388": {"vr": "DS", "Value": [-362.847, -503.29, -607.5]}, "389": {"vr": "DS", "Value": [-362.847, -503.29, -609.5]}, "390": {"vr": "DS", "Value": [-362.847, -503.29, -611.5]}, "391": {"vr": "DS", "Value": [-362.847, -503.29, -613.5]}, "392": {"vr": "DS", "Value": [-362.847, -503.29, -615.5]}, "393": {"vr": "DS", "Value": [-362.847, -503.29, -617.5]}, "394": {"vr": "DS", "Value": [-362.847, -503.29, -619.5]}, "395": {"vr": "DS", "Value": [-362.847, -503.29, -621.5]}, "396": {"vr": "DS", "Value": [-362.847, -503.29, -623.5]}, "397": {"vr": "DS", "Value": [-362.847, -503.29, -625.5]}, "398": {"vr": "DS", "Value": [-362.847, -503.29, -627.5]}, "399": {"vr": "DS", "Value": [-362.847, -503.29, -629.5]}, "400": {"vr": "DS", "Value": [-362.847, -503.29, -631.5]}, "401": {"vr": "DS", "Value": [-362.847, -503.29, -633.5]}, "402": {"vr": "DS", "Value": [-362.847, -503.29, -635.5]}, "403": {"vr": "DS", "Value": [-362.847, -503.29, -637.5]}, "404": {"vr": "DS", "Value": [-362.847, -503.29, -639.5]}, "405": {"vr": "DS", "Value": [-362.847, -503.29, -641.5]}, "406": {"vr": "DS", "Value": [-362.847, -503.29, -643.5]}, "407": {"vr": "DS", "Value": [-362.847, -503.29, -645.5]}, "408": {"vr": "DS", "Value": [-362.847, -503.29, -647.5]}, "409": {"vr": "DS", "Value": [-362.847, -503.29, -649.5]}, "410": {"vr": "DS", "Value": [-362.847, -503.29, -651.5]}, "411": {"vr": "DS", "Value": [-362.847, -503.29, -653.5]}, "412": {"vr": "DS", "Value": [-362.847, -503.29, -655.5]}, "413": {"vr": "DS", "Value": [-362.847, -503.29, -657.5]}, "414": {"vr": "DS", "Value": [-362.847, -503.29, -659.5]}, "415": {"vr": "DS", "Value": [-362.847, -503.29, -661.5]}, "416": {"vr": "DS", "Value": [-362.847, -503.29, -663.5]}, "417": {"vr": "DS", "Value": [-362.847, -503.29, -665.5]}, "418": {"vr": "DS", "Value": [-362.847, -503.29, -667.5]}, "419": {"vr": "DS", "Value": [-362.847, -503.29, -669.5]}, "420": {"vr": "DS", "Value": [-362.847, -503.29, -671.5]}, "421": {"vr": "DS", "Value": [-362.847, -503.29, -673.5]}, "422": {"vr": "DS", "Value": [-362.847, -503.29, -675.5]}, "423": {"vr": "DS", "Value": [-362.847, -503.29, -677.5]}, "424": {"vr": "DS", "Value": [-362.847, -503.29, -679.5]}, "425": {"vr": "DS", "Value": [-362.847, -503.29, -681.5]}, "426": {"vr": "DS", "Value": [-362.847, -503.29, -683.5]}, "427": {"vr": "DS", "Value": [-362.847, -503.29, -685.5]}, "428": {"vr": "DS", "Value": [-362.847, -503.29, -687.5]}, "429": {"vr": "DS", "Value": [-362.847, -503.29, -689.5]}, "430": {"vr": "DS", "Value": [-362.847, -503.29, -691.5]}, "431": {"vr": "DS", "Value": [-362.847, -503.29, -693.5]}, "432": {"vr": "DS", "Value": [-362.847, -503.29, -695.5]}, "433": {"vr": "DS", "Value": [-362.847, -503.29, -697.5]}, "434": {"vr": "DS", "Value": [-362.847, -503.29, -699.5]}, "435": {"vr": "DS", "Value": [-362.847, -503.29, -701.5]}, "436": {"vr": "DS", "Value": [-362.847, -503.29, -703.5]}, "437": {"vr": "DS", "Value": [-362.847, -503.29, -705.5]}, "438": {"vr": "DS", "Value": [-362.847, -503.29, -707.5]}, "439": {"vr": "DS", "Value": [-362.847, -503.29, -709.5]}, "440": {"vr": "DS", "Value": [-362.847, -503.29, -711.5]}, "441": {"vr": "DS", "Value": [-362.847, -503.29, -713.5]}, "442": {"vr": "DS", "Value": [-362.847, -503.29, -715.5]}, "443": {"vr": "DS", "Value": [-362.847, -503.29, -717.5]}, "444": {"vr": "DS", "Value": [-362.847, -503.29, -719.5]}, "445": {"vr": "DS", "Value": [-362.847, -503.29, -721.5]}, "446": {"vr": "DS", "Value": [-362.847, -503.29, -723.5]}, "447": {"vr": "DS", "Value": [-362.847, -503.29, -725.5]}, "448": {"vr": "DS", "Value": [-362.847, -503.29, -727.5]}, "449": {"vr": "DS", "Value": [-362.847, -503.29, -729.5]}, "450": {"vr": "DS", "Value": [-362.847, -503.29, -731.5]}, "451": {"vr": "DS", "Value": [-362.847, -503.29, -733.5]}, "452": {"vr": "DS", "Value": [-362.847, -503.29, -735.5]}, "453": {"vr": "DS", "Value": [-362.847, -503.29, -737.5]}, "454": {"vr": "DS", "Value": [-362.847, -503.29, -739.5]}, "455": {"vr": "DS", "Value": [-362.847, -503.29, -741.5]}, "456": {"vr": "DS", "Value": [-362.847, -503.29, -743.5]}, "457": {"vr": "DS", "Value": [-362.847, -503.29, -745.5]}, "458": {"vr": "DS", "Value": [-362.847, -503.29, -747.5]}, "459": {"vr": "DS", "Value": [-362.847, -503.29, -749.5]}, "460": {"vr": "DS", "Value": [-362.847, -503.29, -751.5]}, "461": {"vr": "DS", "Value": [-362.847, -503.29, -753.5]}, "462": {"vr": "DS", "Value": [-362.847, -503.29, -755.5]}, "463": {"vr": "DS", "Value": [-362.847, -503.29, -757.5]}, "464": {"vr": "DS", "Value": [-362.847, -503.29, -759.5]}, "465": {"vr": "DS", "Value": [-362.847, -503.29, -761.5]}, "466": {"vr": "DS", "Value": [-362.847, -503.29, -763.5]}, "467": {"vr": "DS", "Value": [-362.847, -503.29, -765.5]}, "468": {"vr": "DS", "Value": [-362.847, -503.29, -767.5]}, "469": {"vr": "DS", "Value": [-362.847, -503.29, -769.5]}, "470": {"vr": "DS", "Value": [-362.847, -503.29, -771.5]}, "471": {"vr": "DS", "Value": [-362.847, -503.29, -773.5]}, "472": {"vr": "DS", "Value": [-362.847, -503.29, -775.5]}, "473": {"vr": "DS", "Value": [-362.847, -503.29, -777.5]}, "474": {"vr": "DS", "Value": [-362.847, -503.29, -779.5]}, "475": {"vr": "DS", "Value": [-362.847, -503.29, -781.5]}, "476": {"vr": "DS", "Value": [-362.847, -503.29, -783.5]}, "477": {"vr": "DS", "Value": [-362.847, -503.29, -785.5]}, "478": {"vr": "DS", "Value": [-362.847, -503.29, -787.5]}, "479": {"vr": "DS", "Value": [-362.847, -503.29, -789.5]}, "480": {"vr": "DS", "Value": [-362.847, -503.29, -791.5]}, "481": {"vr": "DS", "Value": [-362.847, -503.29, -793.5]}, "482": {"vr": "DS", "Value": [-362.847, -503.29, -795.5]}, "483": {"vr": "DS", "Value": [-362.847, -503.29, -797.5]}, "484": {"vr": "DS", "Value": [-362.847, -503.29, -799.5]}, "485": {"vr": "DS", "Value": [-362.847, -503.29, -801.5]}, "486": {"vr": "DS", "Value": [-362.847, -503.29, -803.5]}, "487": {"vr": "DS", "Value": [-362.847, -503.29, -805.5]}, "488": {"vr": "DS", "Value": [-362.847, -503.29, -807.5]}, "489": {"vr": "DS", "Value": [-362.847, -503.29, -809.5]}, "490": {"vr": "DS", "Value": [-362.847, -503.29, -811.5]}, "491": {"vr": "DS", "Value": [-362.847, -503.29, -813.5]}, "492": {"vr": "DS", "Value": [-362.847, -503.29, -815.5]}, "493": {"vr": "DS", "Value": [-362.847, -503.29, -817.5]}, "494": {"vr": "DS", "Value": [-362.847, -503.29, -819.5]}, "495": {"vr": "DS", "Value": [-362.847, -503.29, -821.5]}, "496": {"vr": "DS", "Value": [-362.847, -503.29, -823.5]}, "497": {"vr": "DS", "Value": [-362.847, -503.29, -825.5]}, "498": {"vr": "DS", "Value": [-362.847, -503.29, -827.5]}, "499": {"vr": "DS", "Value": [-362.847, -503.29, -829.5]}, "500": {"vr": "DS", "Value": [-362.847, -503.29, -831.5]}, "501": {"vr": "DS", "Value": [-362.847, -503.29, -833.5]}, "502": {"vr": "DS", "Value": [-362.847, -503.29, -835.5]}, "503": {"vr": "DS", "Value": [-362.847, -503.29, -837.5]}, "504": {"vr": "DS", "Value": [-362.847, -503.29, -839.5]}, "505": {"vr": "DS", "Value": [-362.847, -503.29, -841.5]}, "506": {"vr": "DS", "Value": [-362.847, -503.29, -843.5]}, "507": {"vr": "DS", "Value": [-362.847, -503.29, -845.5]}, "508": {"vr": "DS", "Value": [-362.847, -503.29, -847.5]}, "509": {"vr": "DS", "Value": [-362.847, -503.29, -849.5]}, "510": {"vr": "DS", "Value": [-362.847, -503.29, -851.5]}, "511": {"vr": "DS", "Value": [-362.847, -503.29, -853.5]}, "512": {"vr": "DS", "Value": [-362.847, -503.29, -855.5]}, "513": {"vr": "DS", "Value": [-362.847, -503.29, -857.5]}, "514": {"vr": "DS", "Value": [-362.847, -503.29, -859.5]}, "515": {"vr": "DS", "Value": [-362.847, -503.29, -861.5]}, "516": {"vr": "DS", "Value": [-362.847, -503.29, -863.5]}, "517": {"vr": "DS", "Value": [-362.847, -503.29, -865.5]}, "518": {"vr": "DS", "Value": [-362.847, -503.29, -867.5]}, "519": {"vr": "DS", "Value": [-362.847, -503.29, -869.5]}, "520": {"vr": "DS", "Value": [-362.847, -503.29, -871.5]}, "521": {"vr": "DS", "Value": [-362.847, -503.29, -873.5]}, "522": {"vr": "DS", "Value": [-362.847, -503.29, -875.5]}, "523": {"vr": "DS", "Value": [-362.847, -503.29, -877.5]}, "524": {"vr": "DS", "Value": [-362.847, -503.29, -879.5]}, "525": {"vr": "DS", "Value": [-362.847, -503.29, -881.5]}, "526": {"vr": "DS", "Value": [-362.847, -503.29, -883.5]}, "527": {"vr": "DS", "Value": [-362.847, -503.29, -885.5]}, "528": {"vr": "DS", "Value": [-362.847, -503.29, -887.5]}, "529": {"vr": "DS", "Value": [-362.847, -503.29, -889.5]}, "530": {"vr": "DS", "Value": [-362.847, -503.29, -891.5]}}, "00201041": {"0": {"vr": "DS", "Value": [168.5]}, "1": {"vr": "DS", "Value": [166.5]}, "2": {"vr": "DS", "Value": [164.5]}, "3": {"vr": "DS", "Value": [162.5]}, "4": {"vr": "DS", "Value": [160.5]}, "5": {"vr": "DS", "Value": [158.5]}, "6": {"vr": "DS", "Value": [156.5]}, "7": {"vr": "DS", "Value": [154.5]}, "8": {"vr": "DS", "Value": [152.5]}, "9": {"vr": "DS", "Value": [150.5]}, "10": {"vr": "DS", "Value": [148.5]}, "11": {"vr": "DS", "Value": [146.5]}, "12": {"vr": "DS", "Value": [144.5]}, "13": {"vr": "DS", "Value": [142.5]}, "14": {"vr": "DS", "Value": [140.5]}, "15": {"vr": "DS", "Value": [138.5]}, "16": {"vr": "DS", "Value": [136.5]}, "17": {"vr": "DS", "Value": [134.5]}, "18": {"vr": "DS", "Value": [132.5]}, "19": {"vr": "DS", "Value": [130.5]}, "20": {"vr": "DS", "Value": [128.5]}, "21": {"vr": "DS", "Value": [126.5]}, "22": {"vr": "DS", "Value": [124.5]}, "23": {"vr": "DS", "Value": [122.5]}, "24": {"vr": "DS", "Value": [120.5]}, "25": {"vr": "DS", "Value": [118.5]}, "26": {"vr": "DS", "Value": [116.5]}, "27": {"vr": "DS", "Value": [114.5]}, "28": {"vr": "DS", "Value": [112.5]}, "29": {"vr": "DS", "Value": [110.5]}, "30": {"vr": "DS", "Value": [108.5]}, "31": {"vr": "DS", "Value": [106.5]}, "32": {"vr": "DS", "Value": [104.5]}, "33": {"vr": "DS", "Value": [102.5]}, "34": {"vr": "DS", "Value": [100.5]}, "35": {"vr": "DS", "Value": [98.5]}, "36": {"vr": "DS", "Value": [96.5]}, "37": {"vr": "DS", "Value": [94.5]}, "38": {"vr": "DS", "Value": [92.5]}, "39": {"vr": "DS", "Value": [90.5]}, "40": {"vr": "DS", "Value": [88.5]}, "41": {"vr": "DS", "Value": [86.5]}, "42": {"vr": "DS", "Value": [84.5]}, "43": {"vr": "DS", "Value": [82.5]}, "44": {"vr": "DS", "Value": [80.5]}, "45": {"vr": "DS", "Value": [78.5]}, "46": {"vr": "DS", "Value": [76.5]}, "47": {"vr": "DS", "Value": [74.5]}, "48": {"vr": "DS", "Value": [72.5]}, "49": {"vr": "DS", "Value": [70.5]}, "50": {"vr": "DS", "Value": [68.5]}, "51": {"vr": "DS", "Value": [66.5]}, "52": {"vr": "DS", "Value": [64.5]}, "53": {"vr": "DS", "Value": [62.5]}, "54": {"vr": "DS", "Value": [60.5]}, "55": {"vr": "DS", "Value": [58.5]}, "56": {"vr": "DS", "Value": [56.5]}, "57": {"vr": "DS", "Value": [54.5]}, "58": {"vr": "DS", "Value": [52.5]}, "59": {"vr": "DS", "Value": [50.5]}, "60": {"vr": "DS", "Value": [48.5]}, "61": {"vr": "DS", "Value": [46.5]}, "62": {"vr": "DS", "Value": [44.5]}, "63": {"vr": "DS", "Value": [42.5]}, "64": {"vr": "DS", "Value": [40.5]}, "65": {"vr": "DS", "Value": [38.5]}, "66": {"vr": "DS", "Value": [36.5]}, "67": {"vr": "DS", "Value": [34.5]}, "68": {"vr": "DS", "Value": [32.5]}, "69": {"vr": "DS", "Value": [30.5]}, "70": {"vr": "DS", "Value": [28.5]}, "71": {"vr": "DS", "Value": [26.5]}, "72": {"vr": "DS", "Value": [24.5]}, "73": {"vr": "DS", "Value": [22.5]}, "74": {"vr": "DS", "Value": [20.5]}, "75": {"vr": "DS", "Value": [18.5]}, "76": {"vr": "DS", "Value": [16.5]}, "77": {"vr": "DS", "Value": [14.5]}, "78": {"vr": "DS", "Value": [12.5]}, "79": {"vr": "DS", "Value": [10.5]}, "80": {"vr": "DS", "Value": [8.5]}, "81": {"vr": "DS", "Value": [6.5]}, "82": {"vr": "DS", "Value": [4.5]}, "83": {"vr": "DS", "Value": [2.5]}, "84": {"vr": "DS", "Value": [0.5]}, "85": {"vr": "DS", "Value": [-1.5]}, "86": {"vr": "DS", "Value": [-3.5]}, "87": {"vr": "DS", "Value": [-5.5]}, "88": {"vr": "DS", "Value": [-7.5]}, "89": {"vr": "DS", "Value": [-9.5]}, "90": {"vr": "DS", "Value": [-11.5]}, "91": {"vr": "DS", "Value": [-13.5]}, "92": {"vr": "DS", "Value": [-15.5]}, "93": {"vr": "DS", "Value": [-17.5]}, "94": {"vr": "DS", "Value": [-19.5]}, "95": {"vr": "DS", "Value": [-21.5]}, "96": {"vr": "DS", "Value": [-23.5]}, "97": {"vr": "DS", "Value": [-25.5]}, "98": {"vr": "DS", "Value": [-27.5]}, "99": {"vr": "DS", "Value": [-29.5]}, "100": {"vr": "DS", "Value": [-31.5]}, "101": {"vr": "DS", "Value": [-33.5]}, "102": {"vr": "DS", "Value": [-35.5]}, "103": {"vr": "DS", "Value": [-37.5]}, "104": {"vr": "DS", "Value": [-39.5]}, "105": {"vr": "DS", "Value": [-41.5]}, "106": {"vr": "DS", "Value": [-43.5]}, "107": {"vr": "DS", "Value": [-45.5]}, "108": {"vr": "DS", "Value": [-47.5]}, "109": {"vr": "DS", "Value": [-49.5]}, "110": {"vr": "DS", "Value": [-51.5]}, "111": {"vr": "DS", "Value": [-53.5]}, "112": {"vr": "DS", "Value": [-55.5]}, "113": {"vr": "DS", "Value": [-57.5]}, "114": {"vr": "DS", "Value": [-59.5]}, "115": {"vr": "DS", "Value": [-61.5]}, "116": {"vr": "DS", "Value": [-63.5]}, "117": {"vr": "DS", "Value": [-65.5]}, "118": {"vr": "DS", "Value": [-67.5]}, "119": {"vr": "DS", "Value": [-69.5]}, "120": {"vr": "DS", "Value": [-71.5]}, "121": {"vr": "DS", "Value": [-73.5]}, "122": {"vr": "DS", "Value": [-75.5]}, "123": {"vr": "DS", "Value": [-77.5]}, "124": {"vr": "DS", "Value": [-79.5]}, "125": {"vr": "DS", "Value": [-81.5]}, "126": {"vr": "DS", "Value": [-83.5]}, "127": {"vr": "DS", "Value": [-85.5]}, "128": {"vr": "DS", "Value": [-87.5]}, "129": {"vr": "DS", "Value": [-89.5]}, "130": {"vr": "DS", "Value": [-91.5]}, "131": {"vr": "DS", "Value": [-93.5]}, "132": {"vr": "DS", "Value": [-95.5]}, "133": {"vr": "DS", "Value": [-97.5]}, "134": {"vr": "DS", "Value": [-99.5]}, "135": {"vr": "DS", "Value": [-101.5]}, "136": {"vr": "DS", "Value": [-103.5]}, "137": {"vr": "DS", "Value": [-105.5]}, "138": {"vr": "DS", "Value": [-107.5]}, "139": {"vr": "DS", "Value": [-109.5]}, "140": {"vr": "DS", "Value": [-111.5]}, "141": {"vr": "DS", "Value": [-113.5]}, "142": {"vr": "DS", "Value": [-115.5]}, "143": {"vr": "DS", "Value": [-117.5]}, "144": {"vr": "DS", "Value": [-119.5]}, "145": {"vr": "DS", "Value": [-121.5]}, "146": {"vr": "DS", "Value": [-123.5]}, "147": {"vr": "DS", "Value": [-125.5]}, "148": {"vr": "DS", "Value": [-127.5]}, "149": {"vr": "DS", "Value": [-129.5]}, "150": {"vr": "DS", "Value": [-131.5]}, "151": {"vr": "DS", "Value": [-133.5]}, "152": {"vr": "DS", "Value": [-135.5]}, "153": {"vr": "DS", "Value": [-137.5]}, "154": {"vr": "DS", "Value": [-139.5]}, "155": {"vr": "DS", "Value": [-141.5]}, "156": {"vr": "DS", "Value": [-143.5]}, "157": {"vr": "DS", "Value": [-145.5]}, "158": {"vr": "DS", "Value": [-147.5]}, "159": {"vr": "DS", "Value": [-149.5]}, "160": {"vr": "DS", "Value": [-151.5]}, "161": {"vr": "DS", "Value": [-153.5]}, "162": {"vr": "DS", "Value": [-155.5]}, "163": {"vr": "DS", "Value": [-157.5]}, "164": {"vr": "DS", "Value": [-159.5]}, "165": {"vr": "DS", "Value": [-161.5]}, "166": {"vr": "DS", "Value": [-163.5]}, "167": {"vr": "DS", "Value": [-165.5]}, "168": {"vr": "DS", "Value": [-167.5]}, "169": {"vr": "DS", "Value": [-169.5]}, "170": {"vr": "DS", "Value": [-171.5]}, "171": {"vr": "DS", "Value": [-173.5]}, "172": {"vr": "DS", "Value": [-175.5]}, "173": {"vr": "DS", "Value": [-177.5]}, "174": {"vr": "DS", "Value": [-179.5]}, "175": {"vr": "DS", "Value": [-181.5]}, "176": {"vr": "DS", "Value": [-183.5]}, "177": {"vr": "DS", "Value": [-185.5]}, "178": {"vr": "DS", "Value": [-187.5]}, "179": {"vr": "DS", "Value": [-189.5]}, "180": {"vr": "DS", "Value": [-191.5]}, "181": {"vr": "DS", "Value": [-193.5]}, "182": {"vr": "DS", "Value": [-195.5]}, "183": {"vr": "DS", "Value": [-197.5]}, "184": {"vr": "DS", "Value": [-199.5]}, "185": {"vr": "DS", "Value": [-201.5]}, "186": {"vr": "DS", "Value": [-203.5]}, "187": {"vr": "DS", "Value": [-205.5]}, "188": {"vr": "DS", "Value": [-207.5]}, "189": {"vr": "DS", "Value": [-209.5]}, "190": {"vr": "DS", "Value": [-211.5]}, "191": {"vr": "DS", "Value": [-213.5]}, "192": {"vr": "DS", "Value": [-215.5]}, "193": {"vr": "DS", "Value": [-217.5]}, "194": {"vr": "DS", "Value": [-219.5]}, "195": {"vr": "DS", "Value": [-221.5]}, "196": {"vr": "DS", "Value": [-223.5]}, "197": {"vr": "DS", "Value": [-225.5]}, "198": {"vr": "DS", "Value": [-227.5]}, "199": {"vr": "DS", "Value": [-229.5]}, "200": {"vr": "DS", "Value": [-231.5]}, "201": {"vr": "DS", "Value": [-233.5]}, "202": {"vr": "DS", "Value": [-235.5]}, "203": {"vr": "DS", "Value": [-237.5]}, "204": {"vr": "DS", "Value": [-239.5]}, "205": {"vr": "DS", "Value": [-241.5]}, "206": {"vr": "DS", "Value": [-243.5]}, "207": {"vr": "DS", "Value": [-245.5]}, "208": {"vr": "DS", "Value": [-247.5]}, "209": {"vr": "DS", "Value": [-249.5]}, "210": {"vr": "DS", "Value": [-251.5]}, "211": {"vr": "DS", "Value": [-253.5]}, "212": {"vr": "DS", "Value": [-255.5]}, "213": {"vr": "DS", "Value": [-257.5]}, "214": {"vr": "DS", "Value": [-259.5]}, "215": {"vr": "DS", "Value": [-261.5]}, "216": {"vr": "DS", "Value": [-263.5]}, "217": {"vr": "DS", "Value": [-265.5]}, "218": {"vr": "DS", "Value": [-267.5]}, "219": {"vr": "DS", "Value": [-269.5]}, "220": {"vr": "DS", "Value": [-271.5]}, "221": {"vr": "DS", "Value": [-273.5]}, "222": {"vr": "DS", "Value": [-275.5]}, "223": {"vr": "DS", "Value": [-277.5]}, "224": {"vr": "DS", "Value": [-279.5]}, "225": {"vr": "DS", "Value": [-281.5]}, "226": {"vr": "DS", "Value": [-283.5]}, "227": {"vr": "DS", "Value": [-285.5]}, "228": {"vr": "DS", "Value": [-287.5]}, "229": {"vr": "DS", "Value": [-289.5]}, "230": {"vr": "DS", "Value": [-291.5]}, "231": {"vr": "DS", "Value": [-293.5]}, "232": {"vr": "DS", "Value": [-295.5]}, "233": {"vr": "DS", "Value": [-297.5]}, "234": {"vr": "DS", "Value": [-299.5]}, "235": {"vr": "DS", "Value": [-301.5]}, "236": {"vr": "DS", "Value": [-303.5]}, "237": {"vr": "DS", "Value": [-305.5]}, "238": {"vr": "DS", "Value": [-307.5]}, "239": {"vr": "DS", "Value": [-309.5]}, "240": {"vr": "DS", "Value": [-311.5]}, "241": {"vr": "DS", "Value": [-313.5]}, "242": {"vr": "DS", "Value": [-315.5]}, "243": {"vr": "DS", "Value": [-317.5]}, "244": {"vr": "DS", "Value": [-319.5]}, "245": {"vr": "DS", "Value": [-321.5]}, "246": {"vr": "DS", "Value": [-323.5]}, "247": {"vr": "DS", "Value": [-325.5]}, "248": {"vr": "DS", "Value": [-327.5]}, "249": {"vr": "DS", "Value": [-329.5]}, "250": {"vr": "DS", "Value": [-331.5]}, "251": {"vr": "DS", "Value": [-333.5]}, "252": {"vr": "DS", "Value": [-335.5]}, "253": {"vr": "DS", "Value": [-337.5]}, "254": {"vr": "DS", "Value": [-339.5]}, "255": {"vr": "DS", "Value": [-341.5]}, "256": {"vr": "DS", "Value": [-343.5]}, "257": {"vr": "DS", "Value": [-345.5]}, "258": {"vr": "DS", "Value": [-347.5]}, "259": {"vr": "DS", "Value": [-349.5]}, "260": {"vr": "DS", "Value": [-351.5]}, "261": {"vr": "DS", "Value": [-353.5]}, "262": {"vr": "DS", "Value": [-355.5]}, "263": {"vr": "DS", "Value": [-357.5]}, "264": {"vr": "DS", "Value": [-359.5]}, "265": {"vr": "DS", "Value": [-361.5]}, "266": {"vr": "DS", "Value": [-363.5]}, "267": {"vr": "DS", "Value": [-365.5]}, "268": {"vr": "DS", "Value": [-367.5]}, "269": {"vr": "DS", "Value": [-369.5]}, "270": {"vr": "DS", "Value": [-371.5]}, "271": {"vr": "DS", "Value": [-373.5]}, "272": {"vr": "DS", "Value": [-375.5]}, "273": {"vr": "DS", "Value": [-377.5]}, "274": {"vr": "DS", "Value": [-379.5]}, "275": {"vr": "DS", "Value": [-381.5]}, "276": {"vr": "DS", "Value": [-383.5]}, "277": {"vr": "DS", "Value": [-385.5]}, "278": {"vr": "DS", "Value": [-387.5]}, "279": {"vr": "DS", "Value": [-389.5]}, "280": {"vr": "DS", "Value": [-391.5]}, "281": {"vr": "DS", "Value": [-393.5]}, "282": {"vr": "DS", "Value": [-395.5]}, "283": {"vr": "DS", "Value": [-397.5]}, "284": {"vr": "DS", "Value": [-399.5]}, "285": {"vr": "DS", "Value": [-401.5]}, "286": {"vr": "DS", "Value": [-403.5]}, "287": {"vr": "DS", "Value": [-405.5]}, "288": {"vr": "DS", "Value": [-407.5]}, "289": {"vr": "DS", "Value": [-409.5]}, "290": {"vr": "DS", "Value": [-411.5]}, "291": {"vr": "DS", "Value": [-413.5]}, "292": {"vr": "DS", "Value": [-415.5]}, "293": {"vr": "DS", "Value": [-417.5]}, "294": {"vr": "DS", "Value": [-419.5]}, "295": {"vr": "DS", "Value": [-421.5]}, "296": {"vr": "DS", "Value": [-423.5]}, "297": {"vr": "DS", "Value": [-425.5]}, "298": {"vr": "DS", "Value": [-427.5]}, "299": {"vr": "DS", "Value": [-429.5]}, "300": {"vr": "DS", "Value": [-431.5]}, "301": {"vr": "DS", "Value": [-433.5]}, "302": {"vr": "DS", "Value": [-435.5]}, "303": {"vr": "DS", "Value": [-437.5]}, "304": {"vr": "DS", "Value": [-439.5]}, "305": {"vr": "DS", "Value": [-441.5]}, "306": {"vr": "DS", "Value": [-443.5]}, "307": {"vr": "DS", "Value": [-445.5]}, "308": {"vr": "DS", "Value": [-447.5]}, "309": {"vr": "DS", "Value": [-449.5]}, "310": {"vr": "DS", "Value": [-451.5]}, "311": {"vr": "DS", "Value": [-453.5]}, "312": {"vr": "DS", "Value": [-455.5]}, "313": {"vr": "DS", "Value": [-457.5]}, "314": {"vr": "DS", "Value": [-459.5]}, "315": {"vr": "DS", "Value": [-461.5]}, "316": {"vr": "DS", "Value": [-463.5]}, "317": {"vr": "DS", "Value": [-465.5]}, "318": {"vr": "DS", "Value": [-467.5]}, "319": {"vr": "DS", "Value": [-469.5]}, "320": {"vr": "DS", "Value": [-471.5]}, "321": {"vr": "DS", "Value": [-473.5]}, "322": {"vr": "DS", "Value": [-475.5]}, "323": {"vr": "DS", "Value": [-477.5]}, "324": {"vr": "DS", "Value": [-479.5]}, "325": {"vr": "DS", "Value": [-481.5]}, "326": {"vr": "DS", "Value": [-483.5]}, "327": {"vr": "DS", "Value": [-485.5]}, "328": {"vr": "DS", "Value": [-487.5]}, "329": {"vr": "DS", "Value": [-489.5]}, "330": {"vr": "DS", "Value": [-491.5]}, "331": {"vr": "DS", "Value": [-493.5]}, "332": {"vr": "DS", "Value": [-495.5]}, "333": {"vr": "DS", "Value": [-497.5]}, "334": {"vr": "DS", "Value": [-499.5]}, "335": {"vr": "DS", "Value": [-501.5]}, "336": {"vr": "DS", "Value": [-503.5]}, "337": {"vr": "DS", "Value": [-505.5]}, "338": {"vr": "DS", "Value": [-507.5]}, "339": {"vr": "DS", "Value": [-509.5]}, "340": {"vr": "DS", "Value": [-511.5]}, "341": {"vr": "DS", "Value": [-513.5]}, "342": {"vr": "DS", "Value": [-515.5]}, "343": {"vr": "DS", "Value": [-517.5]}, "344": {"vr": "DS", "Value": [-519.5]}, "345": {"vr": "DS", "Value": [-521.5]}, "346": {"vr": "DS", "Value": [-523.5]}, "347": {"vr": "DS", "Value": [-525.5]}, "348": {"vr": "DS", "Value": [-527.5]}, "349": {"vr": "DS", "Value": [-529.5]}, "350": {"vr": "DS", "Value": [-531.5]}, "351": {"vr": "DS", "Value": [-533.5]}, "352": {"vr": "DS", "Value": [-535.5]}, "353": {"vr": "DS", "Value": [-537.5]}, "354": {"vr": "DS", "Value": [-539.5]}, "355": {"vr": "DS", "Value": [-541.5]}, "356": {"vr": "DS", "Value": [-543.5]}, "357": {"vr": "DS", "Value": [-545.5]}, "358": {"vr": "DS", "Value": [-547.5]}, "359": {"vr": "DS", "Value": [-549.5]}, "360": {"vr": "DS", "Value": [-551.5]}, "361": {"vr": "DS", "Value": [-553.5]}, "362": {"vr": "DS", "Value": [-555.5]}, "363": {"vr": "DS", "Value": [-557.5]}, "364": {"vr": "DS", "Value": [-559.5]}, "365": {"vr": "DS", "Value": [-561.5]}, "366": {"vr": "DS", "Value": [-563.5]}, "367": {"vr": "DS", "Value": [-565.5]}, "368": {"vr": "DS", "Value": [-567.5]}, "369": {"vr": "DS", "Value": [-569.5]}, "370": {"vr": "DS", "Value": [-571.5]}, "371": {"vr": "DS", "Value": [-573.5]}, "372": {"vr": "DS", "Value": [-575.5]}, "373": {"vr": "DS", "Value": [-577.5]}, "374": {"vr": "DS", "Value": [-579.5]}, "375": {"vr": "DS", "Value": [-581.5]}, "376": {"vr": "DS", "Value": [-583.5]}, "377": {"vr": "DS", "Value": [-585.5]}, "378": {"vr": "DS", "Value": [-587.5]}, "379": {"vr": "DS", "Value": [-589.5]}, "380": {"vr": "DS", "Value": [-591.5]}, "381": {"vr": "DS", "Value": [-593.5]}, "382": {"vr": "DS", "Value": [-595.5]}, "383": {"vr": "DS", "Value": [-597.5]}, "384": {"vr": "DS", "Value": [-599.5]}, "385": {"vr": "DS", "Value": [-601.5]}, "386": {"vr": "DS", "Value": [-603.5]}, "387": {"vr": "DS", "Value": [-605.5]}, "388": {"vr": "DS", "Value": [-607.5]}, "389": {"vr": "DS", "Value": [-609.5]}, "390": {"vr": "DS", "Value": [-611.5]}, "391": {"vr": "DS", "Value": [-613.5]}, "392": {"vr": "DS", "Value": [-615.5]}, "393": {"vr": "DS", "Value": [-617.5]}, "394": {"vr": "DS", "Value": [-619.5]}, "395": {"vr": "DS", "Value": [-621.5]}, "396": {"vr": "DS", "Value": [-623.5]}, "397": {"vr": "DS", "Value": [-625.5]}, "398": {"vr": "DS", "Value": [-627.5]}, "399": {"vr": "DS", "Value": [-629.5]}, "400": {"vr": "DS", "Value": [-631.5]}, "401": {"vr": "DS", "Value": [-633.5]}, "402": {"vr": "DS", "Value": [-635.5]}, "403": {"vr": "DS", "Value": [-637.5]}, "404": {"vr": "DS", "Value": [-639.5]}, "405": {"vr": "DS", "Value": [-641.5]}, "406": {"vr": "DS", "Value": [-643.5]}, "407": {"vr": "DS", "Value": [-645.5]}, "408": {"vr": "DS", "Value": [-647.5]}, "409": {"vr": "DS", "Value": [-649.5]}, "410": {"vr": "DS", "Value": [-651.5]}, "411": {"vr": "DS", "Value": [-653.5]}, "412": {"vr": "DS", "Value": [-655.5]}, "413": {"vr": "DS", "Value": [-657.5]}, "414": {"vr": "DS", "Value": [-659.5]}, "415": {"vr": "DS", "Value": [-661.5]}, "416": {"vr": "DS", "Value": [-663.5]}, "417": {"vr": "DS", "Value": [-665.5]}, "418": {"vr": "DS", "Value": [-667.5]}, "419": {"vr": "DS", "Value": [-669.5]}, "420": {"vr": "DS", "Value": [-671.5]}, "421": {"vr": "DS", "Value": [-673.5]}, "422": {"vr": "DS", "Value": [-675.5]}, "423": {"vr": "DS", "Value": [-677.5]}, "424": {"vr": "DS", "Value": [-679.5]}, "425": {"vr": "DS", "Value": [-681.5]}, "426": {"vr": "DS", "Value": [-683.5]}, "427": {"vr": "DS", "Value": [-685.5]}, "428": {"vr": "DS", "Value": [-687.5]}, "429": {"vr": "DS", "Value": [-689.5]}, "430": {"vr": "DS", "Value": [-691.5]}, "431": {"vr": "DS", "Value": [-693.5]}, "432": {"vr": "DS", "Value": [-695.5]}, "433": {"vr": "DS", "Value": [-697.5]}, "434": {"vr": "DS", "Value": [-699.5]}, "435": {"vr": "DS", "Value": [-701.5]}, "436": {"vr": "DS", "Value": [-703.5]}, "437": {"vr": "DS", "Value": [-705.5]}, "438": {"vr": "DS", "Value": [-707.5]}, "439": {"vr": "DS", "Value": [-709.5]}, "440": {"vr": "DS", "Value": [-711.5]}, "441": {"vr": "DS", "Value": [-713.5]}, "442": {"vr": "DS", "Value": [-715.5]}, "443": {"vr": "DS", "Value": [-717.5]}, "444": {"vr": "DS", "Value": [-719.5]}, "445": {"vr": "DS", "Value": [-721.5]}, "446": {"vr": "DS", "Value": [-723.5]}, "447": {"vr": "DS", "Value": [-725.5]}, "448": {"vr": "DS", "Value": [-727.5]}, "449": {"vr": "DS", "Value": [-729.5]}, "450": {"vr": "DS", "Value": [-731.5]}, "451": {"vr": "DS", "Value": [-733.5]}, "452": {"vr": "DS", "Value": [-735.5]}, "453": {"vr": "DS", "Value": [-737.5]}, "454": {"vr": "DS", "Value": [-739.5]}, "455": {"vr": "DS", "Value": [-741.5]}, "456": {"vr": "DS", "Value": [-743.5]}, "457": {"vr": "DS", "Value": [-745.5]}, "458": {"vr": "DS", "Value": [-747.5]}, "459": {"vr": "DS", "Value": [-749.5]}, "460": {"vr": "DS", "Value": [-751.5]}, "461": {"vr": "DS", "Value": [-753.5]}, "462": {"vr": "DS", "Value": [-755.5]}, "463": {"vr": "DS", "Value": [-757.5]}, "464": {"vr": "DS", "Value": [-759.5]}, "465": {"vr": "DS", "Value": [-761.5]}, "466": {"vr": "DS", "Value": [-763.5]}, "467": {"vr": "DS", "Value": [-765.5]}, "468": {"vr": "DS", "Value": [-767.5]}, "469": {"vr": "DS", "Value": [-769.5]}, "470": {"vr": "DS", "Value": [-771.5]}, "471": {"vr": "DS", "Value": [-773.5]}, "472": {"vr": "DS", "Value": [-775.5]}, "473": {"vr": "DS", "Value": [-777.5]}, "474": {"vr": "DS", "Value": [-779.5]}, "475": {"vr": "DS", "Value": [-781.5]}, "476": {"vr": "DS", "Value": [-783.5]}, "477": {"vr": "DS", "Value": [-785.5]}, "478": {"vr": "DS", "Value": [-787.5]}, "479": {"vr": "DS", "Value": [-789.5]}, "480": {"vr": "DS", "Value": [-791.5]}, "481": {"vr": "DS", "Value": [-793.5]}, "482": {"vr": "DS", "Value": [-795.5]}, "483": {"vr": "DS", "Value": [-797.5]}, "484": {"vr": "DS", "Value": [-799.5]}, "485": {"vr": "DS", "Value": [-801.5]}, "486": {"vr": "DS", "Value": [-803.5]}, "487": {"vr": "DS", "Value": [-805.5]}, "488": {"vr": "DS", "Value": [-807.5]}, "489": {"vr": "DS", "Value": [-809.5]}, "490": {"vr": "DS", "Value": [-811.5]}, "491": {"vr": "DS", "Value": [-813.5]}, "492": {"vr": "DS", "Value": [-815.5]}, "493": {"vr": "DS", "Value": [-817.5]}, "494": {"vr": "DS", "Value": [-819.5]}, "495": {"vr": "DS", "Value": [-821.5]}, "496": {"vr": "DS", "Value": [-823.5]}, "497": {"vr": "DS", "Value": [-825.5]}, "498": {"vr": "DS", "Value": [-827.5]}, "499": {"vr": "DS", "Value": [-829.5]}, "500": {"vr": "DS", "Value": [-831.5]}, "501": {"vr": "DS", "Value": [-833.5]}, "502": {"vr": "DS", "Value": [-835.5]}, "503": {"vr": "DS", "Value": [-837.5]}, "504": {"vr": "DS", "Value": [-839.5]}, "505": {"vr": "DS", "Value": [-841.5]}, "506": {"vr": "DS", "Value": [-843.5]}, "507": {"vr": "DS", "Value": [-845.5]}, "508": {"vr": "DS", "Value": [-847.5]}, "509": {"vr": "DS", "Value": [-849.5]}, "510": {"vr": "DS", "Value": [-851.5]}, "511": {"vr": "DS", "Value": [-853.5]}, "512": {"vr": "DS", "Value": [-855.5]}, "513": {"vr": "DS", "Value": [-857.5]}, "514": {"vr": "DS", "Value": [-859.5]}, "515": {"vr": "DS", "Value": [-861.5]}, "516": {"vr": "DS", "Value": [-863.5]}, "517": {"vr": "DS", "Value": [-865.5]}, "518": {"vr": "DS", "Value": [-867.5]}, "519": {"vr": "DS", "Value": [-869.5]}, "520": {"vr": "DS", "Value": [-871.5]}, "521": {"vr": "DS", "Value": [-873.5]}, "522": {"vr": "DS", "Value": [-875.5]}, "523": {"vr": "DS", "Value": [-877.5]}, "524": {"vr": "DS", "Value": [-879.5]}, "525": {"vr": "DS", "Value": [-881.5]}, "526": {"vr": "DS", "Value": [-883.5]}, "527": {"vr": "DS", "Value": [-885.5]}, "528": {"vr": "DS", "Value": [-887.5]}, "529": {"vr": "DS", "Value": [-889.5]}, "530": {"vr": "DS", "Value": [-891.5]}}, "00280107": {"0": {"vr": "US", "Value": [30697]}, "1": {"vr": "US", "Value": [17714]}, "2": {"vr": "US", "Value": [9703]}, "3": {"vr": "US", "Value": [3589]}, "4": {"vr": "US", "Value": [5556]}, "5": {"vr": "US", "Value": [3974]}, "6": {"vr": "US", "Value": [3477]}, "7": {"vr": "US", "Value": [1819]}, "8": {"vr": "US", "Value": [1733]}, "9": {"vr": "US", "Value": [1872]}, "10": {"vr": "US", "Value": [2553]}, "11": {"vr": "US", "Value": [2023]}, "12": {"vr": "US", "Value": [1900]}, "13": {"vr": "US", "Value": [995]}, "14": {"vr": "US", "Value": [1394]}, "15": {"vr": "US", "Value": [1077]}, "16": {"vr": "US", "Value": [1313]}, "17": {"vr": "US", "Value": [1220]}, "18": {"vr": "US", "Value": [915]}, "19": {"vr": "US", "Value": [700]}, "20": {"vr": "US", "Value": [563]}, "21": {"vr": "US", "Value": [484]}, "22": {"vr": "US", "Value": [517]}, "23": {"vr": "US", "Value": [604]}, "24": {"vr": "US", "Value": [599]}, "25": {"vr": "US", "Value": [446]}, "26": {"vr": "US", "Value": [407]}, "27": {"vr": "US", "Value": [525]}, "28": {"vr": "US", "Value": [442]}, "29": {"vr": "US", "Value": [351]}, "30": {"vr": "US", "Value": [360]}, "31": {"vr": "US", "Value": [237]}, "32": {"vr": "US", "Value": [292]}, "33": {"vr": "US", "Value": [306]}, "34": {"vr": "US", "Value": [358]}, "35": {"vr": "US", "Value": [277]}, "36": {"vr": "US", "Value": [272]}, "37": {"vr": "US", "Value": [308]}, "38": {"vr": "US", "Value": [264]}, "39": {"vr": "US", "Value": [151]}, "40": {"vr": "US", "Value": [220]}, "41": {"vr": "US", "Value": [322]}, "42": {"vr": "US", "Value": [199]}, "43": {"vr": "US", "Value": [146]}, "44": {"vr": "US", "Value": [141]}, "45": {"vr": "US", "Value": [168]}, "46": {"vr": "US", "Value": [154]}, "47": {"vr": "US", "Value": [179]}, "48": {"vr": "US", "Value": [140]}, "49": {"vr": "US", "Value": [235]}, "50": {"vr": "US", "Value": [140]}, "51": {"vr": "US", "Value": [248]}, "52": {"vr": "US", "Value": [153]}, "53": {"vr": "US", "Value": [114]}, "54": {"vr": "US", "Value": [162]}, "55": {"vr": "US", "Value": [244]}, "56": {"vr": "US", "Value": [270]}, "57": {"vr": "US", "Value": [158]}, "58": {"vr": "US", "Value": [164]}, "59": {"vr": "US", "Value": [106]}, "60": {"vr": "US", "Value": [111]}, "61": {"vr": "US", "Value": [111]}, "62": {"vr": "US", "Value": [105]}, "63": {"vr": "US", "Value": [119]}, "64": {"vr": "US", "Value": [123]}, "65": {"vr": "US", "Value": [99]}, "66": {"vr": "US", "Value": [166]}, "67": {"vr": "US", "Value": [117]}, "68": {"vr": "US", "Value": [133]}, "69": {"vr": "US", "Value": [128]}, "70": {"vr": "US", "Value": [157]}, "71": {"vr": "US", "Value": [174]}, "72": {"vr": "US", "Value": [136]}, "73": {"vr": "US", "Value": [152]}, "74": {"vr": "US", "Value": [161]}, "75": {"vr": "US", "Value": [170]}, "76": {"vr": "US", "Value": [208]}, "77": {"vr": "US", "Value": [246]}, "78": {"vr": "US", "Value": [265]}, "79": {"vr": "US", "Value": [356]}, "80": {"vr": "US", "Value": [454]}, "81": {"vr": "US", "Value": [572]}, "82": {"vr": "US", "Value": [964]}, "83": {"vr": "US", "Value": [2779]}, "84": {"vr": "US", "Value": [4493]}, "85": {"vr": "US", "Value": [3720]}, "86": {"vr": "US", "Value": [2549]}, "87": {"vr": "US", "Value": [2423]}, "88": {"vr": "US", "Value": [2932]}, "89": {"vr": "US", "Value": [3211]}, "90": {"vr": "US", "Value": [2897]}, "91": {"vr": "US", "Value": [2000]}, "92": {"vr": "US", "Value": [2892]}, "93": {"vr": "US", "Value": [11554]}, "94": {"vr": "US", "Value": [24176]}, "95": {"vr": "US", "Value": [30563]}, "96": {"vr": "US", "Value": [30586]}, "97": {"vr": "US", "Value": [28876]}, "98": {"vr": "US", "Value": [29317]}, "99": {"vr": "US", "Value": [29484]}, "100": {"vr": "US", "Value": [29049]}, "101": {"vr": "US", "Value": [29121]}, "102": {"vr": "US", "Value": [30456]}, "103": {"vr": "US", "Value": [29512]}, "104": {"vr": "US", "Value": [30295]}, "105": {"vr": "US", "Value": [29372]}, "106": {"vr": "US", "Value": [29308]}, "107": {"vr": "US", "Value": [31158]}, "108": {"vr": "US", "Value": [31592]}, "109": {"vr": "US", "Value": [30358]}, "110": {"vr": "US", "Value": [32641]}, "111": {"vr": "US", "Value": [29776]}, "112": {"vr": "US", "Value": [29279]}, "113": {"vr": "US", "Value": [28771]}, "114": {"vr": "US", "Value": [29149]}, "115": {"vr": "US", "Value": [29290]}, "116": {"vr": "US", "Value": [28680]}, "117": {"vr": "US", "Value": [30133]}, "118": {"vr": "US", "Value": [32766]}, "119": {"vr": "US", "Value": [29860]}, "120": {"vr": "US", "Value": [30070]}, "121": {"vr": "US", "Value": [29523]}, "122": {"vr": "US", "Value": [28702]}, "123": {"vr": "US", "Value": [29955]}, "124": {"vr": "US", "Value": [30221]}, "125": {"vr": "US", "Value": [30529]}, "126": {"vr": "US", "Value": [29874]}, "127": {"vr": "US", "Value": [28078]}, "128": {"vr": "US", "Value": [28712]}, "129": {"vr": "US", "Value": [30374]}, "130": {"vr": "US", "Value": [29798]}, "131": {"vr": "US", "Value": [29902]}, "132": {"vr": "US", "Value": [28690]}, "133": {"vr": "US", "Value": [28757]}, "134": {"vr": "US", "Value": [29399]}, "135": {"vr": "US", "Value": [28596]}, "136": {"vr": "US", "Value": [29434]}, "137": {"vr": "US", "Value": [28645]}, "138": {"vr": "US", "Value": [29497]}, "139": {"vr": "US", "Value": [28709]}, "140": {"vr": "US", "Value": [28974]}, "141": {"vr": "US", "Value": [29171]}, "142": {"vr": "US", "Value": [29947]}, "143": {"vr": "US", "Value": [29789]}, "144": {"vr": "US", "Value": [29255]}, "145": {"vr": "US", "Value": [30403]}, "146": {"vr": "US", "Value": [28224]}, "147": {"vr": "US", "Value": [28510]}, "148": {"vr": "US", "Value": [28530]}, "149": {"vr": "US", "Value": [28500]}, "150": {"vr": "US", "Value": [28022]}, "151": {"vr": "US", "Value": [27804]}, "152": {"vr": "US", "Value": [28235]}, "153": {"vr": "US", "Value": [30334]}, "154": {"vr": "US", "Value": [29455]}, "155": {"vr": "US", "Value": [27699]}, "156": {"vr": "US", "Value": [28950]}, "157": {"vr": "US", "Value": [28403]}, "158": {"vr": "US", "Value": [29133]}, "159": {"vr": "US", "Value": [27960]}, "160": {"vr": "US", "Value": [28653]}, "161": {"vr": "US", "Value": [28984]}, "162": {"vr": "US", "Value": [27509]}, "163": {"vr": "US", "Value": [29989]}, "164": {"vr": "US", "Value": [28427]}, "165": {"vr": "US", "Value": [28187]}, "166": {"vr": "US", "Value": [28108]}, "167": {"vr": "US", "Value": [28025]}, "168": {"vr": "US", "Value": [28127]}, "169": {"vr": "US", "Value": [29418]}, "170": {"vr": "US", "Value": [28462]}, "171": {"vr": "US", "Value": [29071]}, "172": {"vr": "US", "Value": [29268]}, "173": {"vr": "US", "Value": [27931]}, "174": {"vr": "US", "Value": [28226]}, "175": {"vr": "US", "Value": [27966]}, "176": {"vr": "US", "Value": [28374]}, "177": {"vr": "US", "Value": [28219]}, "178": {"vr": "US", "Value": [28478]}, "179": {"vr": "US", "Value": [27817]}, "180": {"vr": "US", "Value": [28622]}, "181": {"vr": "US", "Value": [28936]}, "182": {"vr": "US", "Value": [30296]}, "183": {"vr": "US", "Value": [28182]}, "184": {"vr": "US", "Value": [28318]}, "185": {"vr": "US", "Value": [28801]}, "186": {"vr": "US", "Value": [28094]}, "187": {"vr": "US", "Value": [28565]}, "188": {"vr": "US", "Value": [27842]}, "189": {"vr": "US", "Value": [28339]}, "190": {"vr": "US", "Value": [29238]}, "191": {"vr": "US", "Value": [28605]}, "192": {"vr": "US", "Value": [28330]}, "193": {"vr": "US", "Value": [28843]}, "194": {"vr": "US", "Value": [28050]}, "195": {"vr": "US", "Value": [27753]}, "196": {"vr": "US", "Value": [27987]}, "197": {"vr": "US", "Value": [27209]}, "198": {"vr": "US", "Value": [28846]}, "199": {"vr": "US", "Value": [28546]}, "200": {"vr": "US", "Value": [30106]}, "201": {"vr": "US", "Value": [29600]}, "202": {"vr": "US", "Value": [29006]}, "203": {"vr": "US", "Value": [29937]}, "204": {"vr": "US", "Value": [28256]}, "205": {"vr": "US", "Value": [27893]}, "206": {"vr": "US", "Value": [28318]}, "207": {"vr": "US", "Value": [28606]}, "208": {"vr": "US", "Value": [29313]}, "209": {"vr": "US", "Value": [29564]}, "210": {"vr": "US", "Value": [29741]}, "211": {"vr": "US", "Value": [28960]}, "212": {"vr": "US", "Value": [28941]}, "213": {"vr": "US", "Value": [28849]}, "214": {"vr": "US", "Value": [28756]}, "215": {"vr": "US", "Value": [28677]}, "216": {"vr": "US", "Value": [27612]}, "217": {"vr": "US", "Value": [28401]}, "218": {"vr": "US", "Value": [29634]}, "219": {"vr": "US", "Value": [28808]}, "220": {"vr": "US", "Value": [27918]}, "221": {"vr": "US", "Value": [27968]}, "222": {"vr": "US", "Value": [29449]}, "223": {"vr": "US", "Value": [28314]}, "224": {"vr": "US", "Value": [28253]}, "225": {"vr": "US", "Value": [27548]}, "226": {"vr": "US", "Value": [28336]}, "227": {"vr": "US", "Value": [30091]}, "228": {"vr": "US", "Value": [29121]}, "229": {"vr": "US", "Value": [28439]}, "230": {"vr": "US", "Value": [27683]}, "231": {"vr": "US", "Value": [28618]}, "232": {"vr": "US", "Value": [28841]}, "233": {"vr": "US", "Value": [28707]}, "234": {"vr": "US", "Value": [29228]}, "235": {"vr": "US", "Value": [28727]}, "236": {"vr": "US", "Value": [28813]}, "237": {"vr": "US", "Value": [28654]}, "238": {"vr": "US", "Value": [26968]}, "239": {"vr": "US", "Value": [24746]}, "240": {"vr": "US", "Value": [17698]}, "241": {"vr": "US", "Value": [9362]}, "242": {"vr": "US", "Value": [4203]}, "243": {"vr": "US", "Value": [1781]}, "244": {"vr": "US", "Value": [1106]}, "245": {"vr": "US", "Value": [679]}, "246": {"vr": "US", "Value": [551]}, "247": {"vr": "US", "Value": [391]}, "248": {"vr": "US", "Value": [339]}, "249": {"vr": "US", "Value": [275]}, "250": {"vr": "US", "Value": [197]}, "251": {"vr": "US", "Value": [167]}, "252": {"vr": "US", "Value": [151]}, "253": {"vr": "US", "Value": [164]}, "254": {"vr": "US", "Value": [124]}, "255": {"vr": "US", "Value": [135]}, "256": {"vr": "US", "Value": [101]}, "257": {"vr": "US", "Value": [115]}, "258": {"vr": "US", "Value": [95]}, "259": {"vr": "US", "Value": [90]}, "260": {"vr": "US", "Value": [97]}, "261": {"vr": "US", "Value": [85]}, "262": {"vr": "US", "Value": [74]}, "263": {"vr": "US", "Value": [69]}, "264": {"vr": "US", "Value": [85]}, "265": {"vr": "US", "Value": [93]}, "266": {"vr": "US", "Value": [96]}, "267": {"vr": "US", "Value": [93]}, "268": {"vr": "US", "Value": [76]}, "269": {"vr": "US", "Value": [69]}, "270": {"vr": "US", "Value": [74]}, "271": {"vr": "US", "Value": [65]}, "272": {"vr": "US", "Value": [78]}, "273": {"vr": "US", "Value": [83]}, "274": {"vr": "US", "Value": [77]}, "275": {"vr": "US", "Value": [82]}, "276": {"vr": "US", "Value": [72]}, "277": {"vr": "US", "Value": [57]}, "278": {"vr": "US", "Value": [52]}, "279": {"vr": "US", "Value": [66]}, "280": {"vr": "US", "Value": [52]}, "281": {"vr": "US", "Value": [69]}, "282": {"vr": "US", "Value": [59]}, "283": {"vr": "US", "Value": [58]}, "284": {"vr": "US", "Value": [42]}, "285": {"vr": "US", "Value": [45]}, "286": {"vr": "US", "Value": [57]}, "287": {"vr": "US", "Value": [47]}, "288": {"vr": "US", "Value": [55]}, "289": {"vr": "US", "Value": [45]}, "290": {"vr": "US", "Value": [70]}, "291": {"vr": "US", "Value": [43]}, "292": {"vr": "US", "Value": [41]}, "293": {"vr": "US", "Value": [54]}, "294": {"vr": "US", "Value": [49]}, "295": {"vr": "US", "Value": [58]}, "296": {"vr": "US", "Value": [86]}, "297": {"vr": "US", "Value": [46]}, "298": {"vr": "US", "Value": [81]}, "299": {"vr": "US", "Value": [93]}, "300": {"vr": "US", "Value": [46]}, "301": {"vr": "US", "Value": [51]}, "302": {"vr": "US", "Value": [46]}, "303": {"vr": "US", "Value": [71]}, "304": {"vr": "US", "Value": [81]}, "305": {"vr": "US", "Value": [37]}, "306": {"vr": "US", "Value": [55]}, "307": {"vr": "US", "Value": [51]}, "308": {"vr": "US", "Value": [41]}, "309": {"vr": "US", "Value": [39]}, "310": {"vr": "US", "Value": [43]}, "311": {"vr": "US", "Value": [44]}, "312": {"vr": "US", "Value": [40]}, "313": {"vr": "US", "Value": [51]}, "314": {"vr": "US", "Value": [50]}, "315": {"vr": "US", "Value": [43]}, "316": {"vr": "US", "Value": [66]}, "317": {"vr": "US", "Value": [54]}, "318": {"vr": "US", "Value": [45]}, "319": {"vr": "US", "Value": [43]}, "320": {"vr": "US", "Value": [44]}, "321": {"vr": "US", "Value": [55]}, "322": {"vr": "US", "Value": [50]}, "323": {"vr": "US", "Value": [62]}, "324": {"vr": "US", "Value": [52]}, "325": {"vr": "US", "Value": [66]}, "326": {"vr": "US", "Value": [41]}, "327": {"vr": "US", "Value": [41]}, "328": {"vr": "US", "Value": [51]}, "329": {"vr": "US", "Value": [47]}, "330": {"vr": "US", "Value": [47]}, "331": {"vr": "US", "Value": [77]}, "332": {"vr": "US", "Value": [44]}, "333": {"vr": "US", "Value": [50]}, "334": {"vr": "US", "Value": [60]}, "335": {"vr": "US", "Value": [40]}, "336": {"vr": "US", "Value": [47]}, "337": {"vr": "US", "Value": [65]}, "338": {"vr": "US", "Value": [53]}, "339": {"vr": "US", "Value": [54]}, "340": {"vr": "US", "Value": [43]}, "341": {"vr": "US", "Value": [76]}, "342": {"vr": "US", "Value": [50]}, "343": {"vr": "US", "Value": [36]}, "344": {"vr": "US", "Value": [42]}, "345": {"vr": "US", "Value": [39]}, "346": {"vr": "US", "Value": [55]}, "347": {"vr": "US", "Value": [42]}, "348": {"vr": "US", "Value": [44]}, "349": {"vr": "US", "Value": [47]}, "350": {"vr": "US", "Value": [55]}, "351": {"vr": "US", "Value": [61]}, "352": {"vr": "US", "Value": [69]}, "353": {"vr": "US", "Value": [73]}, "354": {"vr": "US", "Value": [61]}, "355": {"vr": "US", "Value": [86]}, "356": {"vr": "US", "Value": [43]}, "357": {"vr": "US", "Value": [47]}, "358": {"vr": "US", "Value": [57]}, "359": {"vr": "US", "Value": [55]}, "360": {"vr": "US", "Value": [44]}, "361": {"vr": "US", "Value": [65]}, "362": {"vr": "US", "Value": [76]}, "363": {"vr": "US", "Value": [48]}, "364": {"vr": "US", "Value": [61]}, "365": {"vr": "US", "Value": [52]}, "366": {"vr": "US", "Value": [46]}, "367": {"vr": "US", "Value": [61]}, "368": {"vr": "US", "Value": [61]}, "369": {"vr": "US", "Value": [55]}, "370": {"vr": "US", "Value": [61]}, "371": {"vr": "US", "Value": [44]}, "372": {"vr": "US", "Value": [69]}, "373": {"vr": "US", "Value": [58]}, "374": {"vr": "US", "Value": [56]}, "375": {"vr": "US", "Value": [74]}, "376": {"vr": "US", "Value": [116]}, "377": {"vr": "US", "Value": [66]}, "378": {"vr": "US", "Value": [76]}, "379": {"vr": "US", "Value": [41]}, "380": {"vr": "US", "Value": [62]}, "381": {"vr": "US", "Value": [127]}, "382": {"vr": "US", "Value": [110]}, "383": {"vr": "US", "Value": [87]}, "384": {"vr": "US", "Value": [55]}, "385": {"vr": "US", "Value": [52]}, "386": {"vr": "US", "Value": [49]}, "387": {"vr": "US", "Value": [53]}, "388": {"vr": "US", "Value": [69]}, "389": {"vr": "US", "Value": [112]}, "390": {"vr": "US", "Value": [46]}, "391": {"vr": "US", "Value": [66]}, "392": {"vr": "US", "Value": [164]}, "393": {"vr": "US", "Value": [96]}, "394": {"vr": "US", "Value": [114]}, "395": {"vr": "US", "Value": [96]}, "396": {"vr": "US", "Value": [62]}, "397": {"vr": "US", "Value": [42]}, "398": {"vr": "US", "Value": [43]}, "399": {"vr": "US", "Value": [127]}, "400": {"vr": "US", "Value": [127]}, "401": {"vr": "US", "Value": [49]}, "402": {"vr": "US", "Value": [163]}, "403": {"vr": "US", "Value": [56]}, "404": {"vr": "US", "Value": [51]}, "405": {"vr": "US", "Value": [98]}, "406": {"vr": "US", "Value": [194]}, "407": {"vr": "US", "Value": [113]}, "408": {"vr": "US", "Value": [6]}, "409": {"vr": "US", "Value": [6]}, "410": {"vr": "US", "Value": [4]}, "411": {"vr": "US", "Value": [7]}, "412": {"vr": "US", "Value": [3]}, "413": {"vr": "US", "Value": [2]}, "414": {"vr": "US", "Value": [0]}, "415": {"vr": "US", "Value": [0]}, "416": {"vr": "US", "Value": [0]}, "417": {"vr": "US", "Value": [0]}, "418": {"vr": "US", "Value": [0]}, "419": {"vr": "US", "Value": [0]}, "420": {"vr": "US", "Value": [0]}, "421": {"vr": "US", "Value": [1]}, "422": {"vr": "US", "Value": [0]}, "423": {"vr": "US", "Value": [0]}, "424": {"vr": "US", "Value": [0]}, "425": {"vr": "US", "Value": [0]}, "426": {"vr": "US", "Value": [0]}, "427": {"vr": "US", "Value": [0]}, "428": {"vr": "US", "Value": [0]}, "429": {"vr": "US", "Value": [0]}, "430": {"vr": "US", "Value": [0]}, "431": {"vr": "US", "Value": [0]}, "432": {"vr": "US", "Value": [0]}, "433": {"vr": "US", "Value": [0]}, "434": {"vr": "US", "Value": [0]}, "435": {"vr": "US", "Value": [0]}, "436": {"vr": "US", "Value": [0]}, "437": {"vr": "US", "Value": [0]}, "438": {"vr": "US", "Value": [0]}, "439": {"vr": "US", "Value": [0]}, "440": {"vr": "US", "Value": [0]}, "441": {"vr": "US", "Value": [0]}, "442": {"vr": "US", "Value": [0]}, "443": {"vr": "US", "Value": [0]}, "444": {"vr": "US", "Value": [0]}, "445": {"vr": "US", "Value": [0]}, "446": {"vr": "US", "Value": [0]}, "447": {"vr": "US", "Value": [0]}, "448": {"vr": "US", "Value": [0]}, "449": {"vr": "US", "Value": [0]}, "450": {"vr": "US", "Value": [0]}, "451": {"vr": "US", "Value": [0]}, "452": {"vr": "US", "Value": [0]}, "453": {"vr": "US", "Value": [0]}, "454": {"vr": "US", "Value": [0]}, "455": {"vr": "US", "Value": [0]}, "456": {"vr": "US", "Value": [0]}, "457": {"vr": "US", "Value": [0]}, "458": {"vr": "US", "Value": [0]}, "459": {"vr": "US", "Value": [0]}, "460": {"vr": "US", "Value": [0]}, "461": {"vr": "US", "Value": [0]}, "462": {"vr": "US", "Value": [0]}, "463": {"vr": "US", "Value": [0]}, "464": {"vr": "US", "Value": [0]}, "465": {"vr": "US", "Value": [0]}, "466": {"vr": "US", "Value": [0]}, "467": {"vr": "US", "Value": [0]}, "468": {"vr": "US", "Value": [0]}, "469": {"vr": "US", "Value": [0]}, "470": {"vr": "US", "Value": [0]}, "471": {"vr": "US", "Value": [0]}, "472": {"vr": "US", "Value": [0]}, "473": {"vr": "US", "Value": [0]}, "474": {"vr": "US", "Value": [0]}, "475": {"vr": "US", "Value": [0]}, "476": {"vr": "US", "Value": [0]}, "477": {"vr": "US", "Value": [0]}, "478": {"vr": "US", "Value": [0]}, "479": {"vr": "US", "Value": [0]}, "480": {"vr": "US", "Value": [0]}, "481": {"vr": "US", "Value": [0]}, "482": {"vr": "US", "Value": [0]}, "483": {"vr": "US", "Value": [0]}, "484": {"vr": "US", "Value": [0]}, "485": {"vr": "US", "Value": [0]}, "486": {"vr": "US", "Value": [0]}, "487": {"vr": "US", "Value": [0]}, "488": {"vr": "US", "Value": [0]}, "489": {"vr": "US", "Value": [0]}, "490": {"vr": "US", "Value": [0]}, "491": {"vr": "US", "Value": [0]}, "492": {"vr": "US", "Value": [0]}, "493": {"vr": "US", "Value": [0]}, "494": {"vr": "US", "Value": [0]}, "495": {"vr": "US", "Value": [0]}, "496": {"vr": "US", "Value": [0]}, "497": {"vr": "US", "Value": [0]}, "498": {"vr": "US", "Value": [0]}, "499": {"vr": "US", "Value": [0]}, "500": {"vr": "US", "Value": [0]}, "501": {"vr": "US", "Value": [0]}, "502": {"vr": "US", "Value": [0]}, "503": {"vr": "US", "Value": [0]}, "504": {"vr": "US", "Value": [0]}, "505": {"vr": "US", "Value": [0]}, "506": {"vr": "US", "Value": [0]}, "507": {"vr": "US", "Value": [0]}, "508": {"vr": "US", "Value": [0]}, "509": {"vr": "US", "Value": [0]}, "510": {"vr": "US", "Value": [0]}, "511": {"vr": "US", "Value": [0]}, "512": {"vr": "US", "Value": [0]}, "513": {"vr": "US", "Value": [0]}, "514": {"vr": "US", "Value": [0]}, "515": {"vr": "US", "Value": [0]}, "516": {"vr": "US", "Value": [0]}, "517": {"vr": "US", "Value": [0]}, "518": {"vr": "US", "Value": [0]}, "519": {"vr": "US", "Value": [0]}, "520": {"vr": "US", "Value": [0]}, "521": {"vr": "US", "Value": [0]}, "522": {"vr": "US", "Value": [0]}, "523": {"vr": "US", "Value": [0]}, "524": {"vr": "US", "Value": [0]}, "525": {"vr": "US", "Value": [0]}, "526": {"vr": "US", "Value": [0]}, "527": {"vr": "US", "Value": [0]}, "528": {"vr": "US", "Value": [0]}, "529": {"vr": "US", "Value": [0]}, "530": {"vr": "US", "Value": [0]}}, "00281050": {"0": {"vr": "DS", "Value": [7191.0]}, "1": {"vr": "DS", "Value": [4150.0]}, "2": {"vr": "DS", "Value": [2273.0]}, "3": {"vr": "DS", "Value": [841.0]}, "4": {"vr": "DS", "Value": [1302.0]}, "5": {"vr": "DS", "Value": [931.0]}, "6": {"vr": "DS", "Value": [814.0]}, "7": {"vr": "DS", "Value": [426.0]}, "8": {"vr": "DS", "Value": [406.0]}, "9": {"vr": "DS", "Value": [439.0]}, "10": {"vr": "DS", "Value": [598.0]}, "11": {"vr": "DS", "Value": [474.0]}, "12": {"vr": "DS", "Value": [445.0]}, "13": {"vr": "DS", "Value": [233.0]}, "14": {"vr": "DS", "Value": [327.0]}, "15": {"vr": "DS", "Value": [252.0]}, "16": {"vr": "DS", "Value": [308.0]}, "17": {"vr": "DS", "Value": [286.0]}, "18": {"vr": "DS", "Value": [214.0]}, "19": {"vr": "DS", "Value": [164.0]}, "20": {"vr": "DS", "Value": [132.0]}, "21": {"vr": "DS", "Value": [113.0]}, "22": {"vr": "DS", "Value": [121.0]}, "23": {"vr": "DS", "Value": [141.0]}, "24": {"vr": "DS", "Value": [140.0]}, "25": {"vr": "DS", "Value": [104.0]}, "26": {"vr": "DS", "Value": [95.0]}, "27": {"vr": "DS", "Value": [123.0]}, "28": {"vr": "DS", "Value": [104.0]}, "29": {"vr": "DS", "Value": [82.0]}, "30": {"vr": "DS", "Value": [84.0]}, "31": {"vr": "DS", "Value": [56.0]}, "32": {"vr": "DS", "Value": [68.0]}, "33": {"vr": "DS", "Value": [72.0]}, "34": {"vr": "DS", "Value": [84.0]}, "35": {"vr": "DS", "Value": [65.0]}, "36": {"vr": "DS", "Value": [64.0]}, "37": {"vr": "DS", "Value": [72.0]}, "38": {"vr": "DS", "Value": [62.0]}, "39": {"vr": "DS", "Value": [35.0]}, "40": {"vr": "DS", "Value": [52.0]}, "41": {"vr": "DS", "Value": [75.0]}, "42": {"vr": "DS", "Value": [47.0]}, "43": {"vr": "DS", "Value": [34.0]}, "44": {"vr": "DS", "Value": [33.0]}, "45": {"vr": "DS", "Value": [39.0]}, "46": {"vr": "DS", "Value": [36.0]}, "47": {"vr": "DS", "Value": [42.0]}, "48": {"vr": "DS", "Value": [33.0]}, "49": {"vr": "DS", "Value": [55.0]}, "50": {"vr": "DS", "Value": [33.0]}, "51": {"vr": "DS", "Value": [58.0]}, "52": {"vr": "DS", "Value": [36.0]}, "53": {"vr": "DS", "Value": [27.0]}, "54": {"vr": "DS", "Value": [38.0]}, "55": {"vr": "DS", "Value": [57.0]}, "56": {"vr": "DS", "Value": [63.0]}, "57": {"vr": "DS", "Value": [37.0]}, "58": {"vr": "DS", "Value": [38.0]}, "59": {"vr": "DS", "Value": [25.0]}, "60": {"vr": "DS", "Value": [26.0]}, "61": {"vr": "DS", "Value": [26.0]}, "62": {"vr": "DS", "Value": [25.0]}, "63": {"vr": "DS", "Value": [28.0]}, "64": {"vr": "DS", "Value": [29.0]}, "65": {"vr": "DS", "Value": [23.0]}, "66": {"vr": "DS", "Value": [39.0]}, "67": {"vr": "DS", "Value": [27.0]}, "68": {"vr": "DS", "Value": [31.0]}, "69": {"vr": "DS", "Value": [30.0]}, "70": {"vr": "DS", "Value": [37.0]}, "71": {"vr": "DS", "Value": [41.0]}, "72": {"vr": "DS", "Value": [32.0]}, "73": {"vr": "DS", "Value": [36.0]}, "74": {"vr": "DS", "Value": [38.0]}, "75": {"vr": "DS", "Value": [40.0]}, "76": {"vr": "DS", "Value": [49.0]}, "77": {"vr": "DS", "Value": [58.0]}, "78": {"vr": "DS", "Value": [62.0]}, "79": {"vr": "DS", "Value": [83.0]}, "80": {"vr": "DS", "Value": [106.0]}, "81": {"vr": "DS", "Value": [134.0]}, "82": {"vr": "DS", "Value": [226.0]}, "83": {"vr": "DS", "Value": [651.0]}, "84": {"vr": "DS", "Value": [1052.0]}, "85": {"vr": "DS", "Value": [871.0]}, "86": {"vr": "DS", "Value": [597.0]}, "87": {"vr": "DS", "Value": [568.0]}, "88": {"vr": "DS", "Value": [687.0]}, "89": {"vr": "DS", "Value": [752.0]}, "90": {"vr": "DS", "Value": [679.0]}, "91": {"vr": "DS", "Value": [469.0]}, "92": {"vr": "DS", "Value": [677.0]}, "93": {"vr": "DS", "Value": [2707.0]}, "94": {"vr": "DS", "Value": [5663.0]}, "95": {"vr": "DS", "Value": [7159.0]}, "96": {"vr": "DS", "Value": [7165.0]}, "97": {"vr": "DS", "Value": [6764.0]}, "98": {"vr": "DS", "Value": [6868.0]}, "99": {"vr": "DS", "Value": [6907.0]}, "100": {"vr": "DS", "Value": [6805.0]}, "101": {"vr": "DS", "Value": [6822.0]}, "102": {"vr": "DS", "Value": [7134.0]}, "103": {"vr": "DS", "Value": [6913.0]}, "104": {"vr": "DS", "Value": [7097.0]}, "105": {"vr": "DS", "Value": [6880.0]}, "106": {"vr": "DS", "Value": [6865.0]}, "107": {"vr": "DS", "Value": [7299.0]}, "108": {"vr": "DS", "Value": [7400.0]}, "109": {"vr": "DS", "Value": [7111.0]}, "110": {"vr": "DS", "Value": [7646.0]}, "111": {"vr": "DS", "Value": [6975.0]}, "112": {"vr": "DS", "Value": [6859.0]}, "113": {"vr": "DS", "Value": [6740.0]}, "114": {"vr": "DS", "Value": [6828.0]}, "115": {"vr": "DS", "Value": [6861.0]}, "116": {"vr": "DS", "Value": [6718.0]}, "117": {"vr": "DS", "Value": [7059.0]}, "118": {"vr": "DS", "Value": [7675.0]}, "119": {"vr": "DS", "Value": [6995.0]}, "120": {"vr": "DS", "Value": [7044.0]}, "121": {"vr": "DS", "Value": [6916.0]}, "122": {"vr": "DS", "Value": [6723.0]}, "123": {"vr": "DS", "Value": [7017.0]}, "124": {"vr": "DS", "Value": [7079.0]}, "125": {"vr": "DS", "Value": [7151.0]}, "126": {"vr": "DS", "Value": [6998.0]}, "127": {"vr": "DS", "Value": [6577.0]}, "128": {"vr": "DS", "Value": [6726.0]}, "129": {"vr": "DS", "Value": [7115.0]}, "130": {"vr": "DS", "Value": [6980.0]}, "131": {"vr": "DS", "Value": [7005.0]}, "132": {"vr": "DS", "Value": [6721.0]}, "133": {"vr": "DS", "Value": [6736.0]}, "134": {"vr": "DS", "Value": [6887.0]}, "135": {"vr": "DS", "Value": [6699.0]}, "136": {"vr": "DS", "Value": [6895.0]}, "137": {"vr": "DS", "Value": [6710.0]}, "138": {"vr": "DS", "Value": [6910.0]}, "139": {"vr": "DS", "Value": [6725.0]}, "140": {"vr": "DS", "Value": [6787.0]}, "141": {"vr": "DS", "Value": [6833.0]}, "142": {"vr": "DS", "Value": [7015.0]}, "143": {"vr": "DS", "Value": [6978.0]}, "144": {"vr": "DS", "Value": [6853.0]}, "145": {"vr": "DS", "Value": [7122.0]}, "146": {"vr": "DS", "Value": [6612.0]}, "147": {"vr": "DS", "Value": [6679.0]}, "148": {"vr": "DS", "Value": [6683.0]}, "149": {"vr": "DS", "Value": [6676.0]}, "150": {"vr": "DS", "Value": [6564.0]}, "151": {"vr": "DS", "Value": [6513.0]}, "152": {"vr": "DS", "Value": [6614.0]}, "153": {"vr": "DS", "Value": [7106.0]}, "154": {"vr": "DS", "Value": [6900.0]}, "155": {"vr": "DS", "Value": [6489.0]}, "156": {"vr": "DS", "Value": [6782.0]}, "157": {"vr": "DS", "Value": [6653.0]}, "158": {"vr": "DS", "Value": [6824.0]}, "159": {"vr": "DS", "Value": [6550.0]}, "160": {"vr": "DS", "Value": [6712.0]}, "161": {"vr": "DS", "Value": [6790.0]}, "162": {"vr": "DS", "Value": [6444.0]}, "163": {"vr": "DS", "Value": [7025.0]}, "164": {"vr": "DS", "Value": [6659.0]}, "165": {"vr": "DS", "Value": [6603.0]}, "166": {"vr": "DS", "Value": [6584.0]}, "167": {"vr": "DS", "Value": [6565.0]}, "168": {"vr": "DS", "Value": [6589.0]}, "169": {"vr": "DS", "Value": [6891.0]}, "170": {"vr": "DS", "Value": [6667.0]}, "171": {"vr": "DS", "Value": [6810.0]}, "172": {"vr": "DS", "Value": [6856.0]}, "173": {"vr": "DS", "Value": [6543.0]}, "174": {"vr": "DS", "Value": [6612.0]}, "175": {"vr": "DS", "Value": [6551.0]}, "176": {"vr": "DS", "Value": [6647.0]}, "177": {"vr": "DS", "Value": [6610.0]}, "178": {"vr": "DS", "Value": [6671.0]}, "179": {"vr": "DS", "Value": [6516.0]}, "180": {"vr": "DS", "Value": [6705.0]}, "181": {"vr": "DS", "Value": [6778.0]}, "182": {"vr": "DS", "Value": [7097.0]}, "183": {"vr": "DS", "Value": [6602.0]}, "184": {"vr": "DS", "Value": [6634.0]}, "185": {"vr": "DS", "Value": [6747.0]}, "186": {"vr": "DS", "Value": [6581.0]}, "187": {"vr": "DS", "Value": [6691.0]}, "188": {"vr": "DS", "Value": [6522.0]}, "189": {"vr": "DS", "Value": [6638.0]}, "190": {"vr": "DS", "Value": [6849.0]}, "191": {"vr": "DS", "Value": [6701.0]}, "192": {"vr": "DS", "Value": [6636.0]}, "193": {"vr": "DS", "Value": [6757.0]}, "194": {"vr": "DS", "Value": [6571.0]}, "195": {"vr": "DS", "Value": [6501.0]}, "196": {"vr": "DS", "Value": [6556.0]}, "197": {"vr": "DS", "Value": [6374.0]}, "198": {"vr": "DS", "Value": [6757.0]}, "199": {"vr": "DS", "Value": [6687.0]}, "200": {"vr": "DS", "Value": [7052.0]}, "201": {"vr": "DS", "Value": [6934.0]}, "202": {"vr": "DS", "Value": [6795.0]}, "203": {"vr": "DS", "Value": [7013.0]}, "204": {"vr": "DS", "Value": [6619.0]}, "205": {"vr": "DS", "Value": [6534.0]}, "206": {"vr": "DS", "Value": [6634.0]}, "207": {"vr": "DS", "Value": [6701.0]}, "208": {"vr": "DS", "Value": [6867.0]}, "209": {"vr": "DS", "Value": [6925.0]}, "210": {"vr": "DS", "Value": [6967.0]}, "211": {"vr": "DS", "Value": [6784.0]}, "212": {"vr": "DS", "Value": [6779.0]}, "213": {"vr": "DS", "Value": [6758.0]}, "214": {"vr": "DS", "Value": [6736.0]}, "215": {"vr": "DS", "Value": [6718.0]}, "216": {"vr": "DS", "Value": [6468.0]}, "217": {"vr": "DS", "Value": [6653.0]}, "218": {"vr": "DS", "Value": [6942.0]}, "219": {"vr": "DS", "Value": [6748.0]}, "220": {"vr": "DS", "Value": [6540.0]}, "221": {"vr": "DS", "Value": [6552.0]}, "222": {"vr": "DS", "Value": [6898.0]}, "223": {"vr": "DS", "Value": [6633.0]}, "224": {"vr": "DS", "Value": [6618.0]}, "225": {"vr": "DS", "Value": [6453.0]}, "226": {"vr": "DS", "Value": [6638.0]}, "227": {"vr": "DS", "Value": [7049.0]}, "228": {"vr": "DS", "Value": [6822.0]}, "229": {"vr": "DS", "Value": [6662.0]}, "230": {"vr": "DS", "Value": [6485.0]}, "231": {"vr": "DS", "Value": [6704.0]}, "232": {"vr": "DS", "Value": [6756.0]}, "233": {"vr": "DS", "Value": [6725.0]}, "234": {"vr": "DS", "Value": [6847.0]}, "235": {"vr": "DS", "Value": [6729.0]}, "236": {"vr": "DS", "Value": [6749.0]}, "237": {"vr": "DS", "Value": [6712.0]}, "238": {"vr": "DS", "Value": [6317.0]}, "239": {"vr": "DS", "Value": [5797.0]}, "240": {"vr": "DS", "Value": [4146.0]}, "241": {"vr": "DS", "Value": [2193.0]}, "242": {"vr": "DS", "Value": [985.0]}, "243": {"vr": "DS", "Value": [417.0]}, "244": {"vr": "DS", "Value": [259.0]}, "245": {"vr": "DS", "Value": [159.0]}, "246": {"vr": "DS", "Value": [129.0]}, "247": {"vr": "DS", "Value": [92.0]}, "248": {"vr": "DS", "Value": [79.0]}, "249": {"vr": "DS", "Value": [64.0]}, "250": {"vr": "DS", "Value": [46.0]}, "251": {"vr": "DS", "Value": [39.0]}, "252": {"vr": "DS", "Value": [35.0]}, "253": {"vr": "DS", "Value": [38.0]}, "254": {"vr": "DS", "Value": [29.0]}, "255": {"vr": "DS", "Value": [32.0]}, "256": {"vr": "DS", "Value": [24.0]}, "257": {"vr": "DS", "Value": [27.0]}, "258": {"vr": "DS", "Value": [22.0]}, "259": {"vr": "DS", "Value": [21.0]}, "260": {"vr": "DS", "Value": [23.0]}, "261": {"vr": "DS", "Value": [20.0]}, "262": {"vr": "DS", "Value": [17.0]}, "263": {"vr": "DS", "Value": [16.0]}, "264": {"vr": "DS", "Value": [20.0]}, "265": {"vr": "DS", "Value": [22.0]}, "266": {"vr": "DS", "Value": [22.0]}, "267": {"vr": "DS", "Value": [22.0]}, "268": {"vr": "DS", "Value": [18.0]}, "269": {"vr": "DS", "Value": [16.0]}, "270": {"vr": "DS", "Value": [17.0]}, "271": {"vr": "DS", "Value": [15.0]}, "272": {"vr": "DS", "Value": [18.0]}, "273": {"vr": "DS", "Value": [19.0]}, "274": {"vr": "DS", "Value": [18.0]}, "275": {"vr": "DS", "Value": [19.0]}, "276": {"vr": "DS", "Value": [17.0]}, "277": {"vr": "DS", "Value": [13.0]}, "278": {"vr": "DS", "Value": [12.0]}, "279": {"vr": "DS", "Value": [15.0]}, "280": {"vr": "DS", "Value": [12.0]}, "281": {"vr": "DS", "Value": [16.0]}, "282": {"vr": "DS", "Value": [14.0]}, "283": {"vr": "DS", "Value": [14.0]}, "284": {"vr": "DS", "Value": [10.0]}, "285": {"vr": "DS", "Value": [11.0]}, "286": {"vr": "DS", "Value": [13.0]}, "287": {"vr": "DS", "Value": [11.0]}, "288": {"vr": "DS", "Value": [13.0]}, "289": {"vr": "DS", "Value": [11.0]}, "290": {"vr": "DS", "Value": [16.0]}, "291": {"vr": "DS", "Value": [10.0]}, "292": {"vr": "DS", "Value": [10.0]}, "293": {"vr": "DS", "Value": [13.0]}, "294": {"vr": "DS", "Value": [11.0]}, "295": {"vr": "DS", "Value": [14.0]}, "296": {"vr": "DS", "Value": [20.0]}, "297": {"vr": "DS", "Value": [11.0]}, "298": {"vr": "DS", "Value": [19.0]}, "299": {"vr": "DS", "Value": [22.0]}, "300": {"vr": "DS", "Value": [11.0]}, "301": {"vr": "DS", "Value": [12.0]}, "302": {"vr": "DS", "Value": [11.0]}, "303": {"vr": "DS", "Value": [17.0]}, "304": {"vr": "DS", "Value": [19.0]}, "305": {"vr": "DS", "Value": [9.0]}, "306": {"vr": "DS", "Value": [13.0]}, "307": {"vr": "DS", "Value": [12.0]}, "308": {"vr": "DS", "Value": [10.0]}, "309": {"vr": "DS", "Value": [9.0]}, "310": {"vr": "DS", "Value": [10.0]}, "311": {"vr": "DS", "Value": [10.0]}, "312": {"vr": "DS", "Value": [9.0]}, "313": {"vr": "DS", "Value": [12.0]}, "314": {"vr": "DS", "Value": [12.0]}, "315": {"vr": "DS", "Value": [10.0]}, "316": {"vr": "DS", "Value": [15.0]}, "317": {"vr": "DS", "Value": [13.0]}, "318": {"vr": "DS", "Value": [11.0]}, "319": {"vr": "DS", "Value": [10.0]}, "320": {"vr": "DS", "Value": [10.0]}, "321": {"vr": "DS", "Value": [13.0]}, "322": {"vr": "DS", "Value": [12.0]}, "323": {"vr": "DS", "Value": [15.0]}, "324": {"vr": "DS", "Value": [12.0]}, "325": {"vr": "DS", "Value": [15.0]}, "326": {"vr": "DS", "Value": [10.0]}, "327": {"vr": "DS", "Value": [10.0]}, "328": {"vr": "DS", "Value": [12.0]}, "329": {"vr": "DS", "Value": [11.0]}, "330": {"vr": "DS", "Value": [11.0]}, "331": {"vr": "DS", "Value": [18.0]}, "332": {"vr": "DS", "Value": [10.0]}, "333": {"vr": "DS", "Value": [12.0]}, "334": {"vr": "DS", "Value": [14.0]}, "335": {"vr": "DS", "Value": [9.0]}, "336": {"vr": "DS", "Value": [11.0]}, "337": {"vr": "DS", "Value": [15.0]}, "338": {"vr": "DS", "Value": [12.0]}, "339": {"vr": "DS", "Value": [13.0]}, "340": {"vr": "DS", "Value": [10.0]}, "341": {"vr": "DS", "Value": [18.0]}, "342": {"vr": "DS", "Value": [12.0]}, "343": {"vr": "DS", "Value": [8.0]}, "344": {"vr": "DS", "Value": [10.0]}, "345": {"vr": "DS", "Value": [9.0]}, "346": {"vr": "DS", "Value": [13.0]}, "347": {"vr": "DS", "Value": [10.0]}, "348": {"vr": "DS", "Value": [10.0]}, "349": {"vr": "DS", "Value": [11.0]}, "350": {"vr": "DS", "Value": [13.0]}, "351": {"vr": "DS", "Value": [14.0]}, "352": {"vr": "DS", "Value": [16.0]}, "353": {"vr": "DS", "Value": [17.0]}, "354": {"vr": "DS", "Value": [14.0]}, "355": {"vr": "DS", "Value": [20.0]}, "356": {"vr": "DS", "Value": [10.0]}, "357": {"vr": "DS", "Value": [11.0]}, "358": {"vr": "DS", "Value": [13.0]}, "359": {"vr": "DS", "Value": [13.0]}, "360": {"vr": "DS", "Value": [10.0]}, "361": {"vr": "DS", "Value": [15.0]}, "362": {"vr": "DS", "Value": [18.0]}, "363": {"vr": "DS", "Value": [11.0]}, "364": {"vr": "DS", "Value": [14.0]}, "365": {"vr": "DS", "Value": [12.0]}, "366": {"vr": "DS", "Value": [11.0]}, "367": {"vr": "DS", "Value": [14.0]}, "368": {"vr": "DS", "Value": [14.0]}, "369": {"vr": "DS", "Value": [13.0]}, "370": {"vr": "DS", "Value": [14.0]}, "371": {"vr": "DS", "Value": [10.0]}, "372": {"vr": "DS", "Value": [16.0]}, "373": {"vr": "DS", "Value": [14.0]}, "374": {"vr": "DS", "Value": [13.0]}, "375": {"vr": "DS", "Value": [17.0]}, "376": {"vr": "DS", "Value": [27.0]}, "377": {"vr": "DS", "Value": [15.0]}, "378": {"vr": "DS", "Value": [18.0]}, "379": {"vr": "DS", "Value": [10.0]}, "380": {"vr": "DS", "Value": [15.0]}, "381": {"vr": "DS", "Value": [30.0]}, "382": {"vr": "DS", "Value": [26.0]}, "383": {"vr": "DS", "Value": [20.0]}, "384": {"vr": "DS", "Value": [13.0]}, "385": {"vr": "DS", "Value": [12.0]}, "386": {"vr": "DS", "Value": [11.0]}, "387": {"vr": "DS", "Value": [12.0]}, "388": {"vr": "DS", "Value": [16.0]}, "389": {"vr": "DS", "Value": [26.0]}, "390": {"vr": "DS", "Value": [11.0]}, "391": {"vr": "DS", "Value": [15.0]}, "392": {"vr": "DS", "Value": [38.0]}, "393": {"vr": "DS", "Value": [22.0]}, "394": {"vr": "DS", "Value": [27.0]}, "395": {"vr": "DS", "Value": [22.0]}, "396": {"vr": "DS", "Value": [15.0]}, "397": {"vr": "DS", "Value": [10.0]}, "398": {"vr": "DS", "Value": [10.0]}, "399": {"vr": "DS", "Value": [30.0]}, "400": {"vr": "DS", "Value": [30.0]}, "401": {"vr": "DS", "Value": [11.0]}, "402": {"vr": "DS", "Value": [38.0]}, "403": {"vr": "DS", "Value": [13.0]}, "404": {"vr": "DS", "Value": [12.0]}, "405": {"vr": "DS", "Value": [23.0]}, "406": {"vr": "DS", "Value": [45.0]}, "407": {"vr": "DS", "Value": [26.0]}, "408": {"vr": "DS", "Value": [1.0]}, "409": {"vr": "DS", "Value": [1.0]}, "410": {"vr": "DS", "Value": [1.0]}, "411": {"vr": "DS", "Value": [2.0]}, "412": {"vr": "DS", "Value": [1.0]}, "413": {"vr": "DS", "Value": [0.0]}, "414": {"vr": "DS", "Value": [0.0]}, "415": {"vr": "DS", "Value": [0.0]}, "416": {"vr": "DS", "Value": [0.0]}, "417": {"vr": "DS", "Value": [0.0]}, "418": {"vr": "DS", "Value": [0.0]}, "419": {"vr": "DS", "Value": [0.0]}, "420": {"vr": "DS", "Value": [0.0]}, "421": {"vr": "DS", "Value": [0.0]}, "422": {"vr": "DS", "Value": [0.0]}, "423": {"vr": "DS", "Value": [0.0]}, "424": {"vr": "DS", "Value": [0.0]}, "425": {"vr": "DS", "Value": [0.0]}, "426": {"vr": "DS", "Value": [0.0]}, "427": {"vr": "DS", "Value": [0.0]}, "428": {"vr": "DS", "Value": [0.0]}, "429": {"vr": "DS", "Value": [0.0]}, "430": {"vr": "DS", "Value": [0.0]}, "431": {"vr": "DS", "Value": [0.0]}, "432": {"vr": "DS", "Value": [0.0]}, "433": {"vr": "DS", "Value": [0.0]}, "434": {"vr": "DS", "Value": [0.0]}, "435": {"vr": "DS", "Value": [0.0]}, "436": {"vr": "DS", "Value": [0.0]}, "437": {"vr": "DS", "Value": [0.0]}, "438": {"vr": "DS", "Value": [0.0]}, "439": {"vr": "DS", "Value": [0.0]}, "440": {"vr": "DS", "Value": [0.0]}, "441": {"vr": "DS", "Value": [0.0]}, "442": {"vr": "DS", "Value": [0.0]}, "443": {"vr": "DS", "Value": [0.0]}, "444": {"vr": "DS", "Value": [0.0]}, "445": {"vr": "DS", "Value": [0.0]}, "446": {"vr": "DS", "Value": [0.0]}, "447": {"vr": "DS", "Value": [0.0]}, "448": {"vr": "DS", "Value": [0.0]}, "449": {"vr": "DS", "Value": [0.0]}, "450": {"vr": "DS", "Value": [0.0]}, "451": {"vr": "DS", "Value": [0.0]}, "452": {"vr": "DS", "Value": [0.0]}, "453": {"vr": "DS", "Value": [0.0]}, "454": {"vr": "DS", "Value": [0.0]}, "455": {"vr": "DS", "Value": [0.0]}, "456": {"vr": "DS", "Value": [0.0]}, "457": {"vr": "DS", "Value": [0.0]}, "458": {"vr": "DS", "Value": [0.0]}, "459": {"vr": "DS", "Value": [0.0]}, "460": {"vr": "DS", "Value": [0.0]}, "461": {"vr": "DS", "Value": [0.0]}, "462": {"vr": "DS", "Value": [0.0]}, "463": {"vr": "DS", "Value": [0.0]}, "464": {"vr": "DS", "Value": [0.0]}, "465": {"vr": "DS", "Value": [0.0]}, "466": {"vr": "DS", "Value": [0.0]}, "467": {"vr": "DS", "Value": [0.0]}, "468": {"vr": "DS", "Value": [0.0]}, "469": {"vr": "DS", "Value": [0.0]}, "470": {"vr": "DS", "Value": [0.0]}, "471": {"vr": "DS", "Value": [0.0]}, "472": {"vr": "DS", "Value": [0.0]}, "473": {"vr": "DS", "Value": [0.0]}, "474": {"vr": "DS", "Value": [0.0]}, "475": {"vr": "DS", "Value": [0.0]}, "476": {"vr": "DS", "Value": [0.0]}, "477": {"vr": "DS", "Value": [0.0]}, "478": {"vr": "DS", "Value": [0.0]}, "479": {"vr": "DS", "Value": [0.0]}, "480": {"vr": "DS", "Value": [0.0]}, "481": {"vr": "DS", "Value": [0.0]}, "482": {"vr": "DS", "Value": [0.0]}, "483": {"vr": "DS", "Value": [0.0]}, "484": {"vr": "DS", "Value": [0.0]}, "485": {"vr": "DS", "Value": [0.0]}, "486": {"vr": "DS", "Value": [0.0]}, "487": {"vr": "DS", "Value": [0.0]}, "488": {"vr": "DS", "Value": [0.0]}, "489": {"vr": "DS", "Value": [0.0]}, "490": {"vr": "DS", "Value": [0.0]}, "491": {"vr": "DS", "Value": [0.0]}, "492": {"vr": "DS", "Value": [0.0]}, "493": {"vr": "DS", "Value": [0.0]}, "494": {"vr": "DS", "Value": [0.0]}, "495": {"vr": "DS", "Value": [0.0]}, "496": {"vr": "DS", "Value": [0.0]}, "497": {"vr": "DS", "Value": [0.0]}, "498": {"vr": "DS", "Value": [0.0]}, "499": {"vr": "DS", "Value": [0.0]}, "500": {"vr": "DS", "Value": [0.0]}, "501": {"vr": "DS", "Value": [0.0]}, "502": {"vr": "DS", "Value": [0.0]}, "503": {"vr": "DS", "Value": [0.0]}, "504": {"vr": "DS", "Value": [0.0]}, "505": {"vr": "DS", "Value": [0.0]}, "506": {"vr": "DS", "Value": [0.0]}, "507": {"vr": "DS", "Value": [0.0]}, "508": {"vr": "DS", "Value": [0.0]}, "509": {"vr": "DS", "Value": [0.0]}, "510": {"vr": "DS", "Value": [0.0]}, "511": {"vr": "DS", "Value": [0.0]}, "512": {"vr": "DS", "Value": [0.0]}, "513": {"vr": "DS", "Value": [0.0]}, "514": {"vr": "DS", "Value": [0.0]}, "515": {"vr": "DS", "Value": [0.0]}, "516": {"vr": "DS", "Value": [0.0]}, "517": {"vr": "DS", "Value": [0.0]}, "518": {"vr": "DS", "Value": [0.0]}, "519": {"vr": "DS", "Value": [0.0]}, "520": {"vr": "DS", "Value": [0.0]}, "521": {"vr": "DS", "Value": [0.0]}, "522": {"vr": "DS", "Value": [0.0]}, "523": {"vr": "DS", "Value": [0.0]}, "524": {"vr": "DS", "Value": [0.0]}, "525": {"vr": "DS", "Value": [0.0]}, "526": {"vr": "DS", "Value": [0.0]}, "527": {"vr": "DS", "Value": [0.0]}, "528": {"vr": "DS", "Value": [0.0]}, "529": {"vr": "DS", "Value": [0.0]}, "530": {"vr": "DS", "Value": [0.0]}}, "00281051": {"0": {"vr": "DS", "Value": [14381.0]}, "1": {"vr": "DS", "Value": [8299.0]}, "2": {"vr": "DS", "Value": [4545.0]}, "3": {"vr": "DS", "Value": [1681.0]}, "4": {"vr": "DS", "Value": [2603.0]}, "5": {"vr": "DS", "Value": [1861.0]}, "6": {"vr": "DS", "Value": [1628.0]}, "7": {"vr": "DS", "Value": [852.0]}, "8": {"vr": "DS", "Value": [811.0]}, "9": {"vr": "DS", "Value": [877.0]}, "10": {"vr": "DS", "Value": [1196.0]}, "11": {"vr": "DS", "Value": [947.0]}, "12": {"vr": "DS", "Value": [890.0]}, "13": {"vr": "DS", "Value": [466.0]}, "14": {"vr": "DS", "Value": [653.0]}, "15": {"vr": "DS", "Value": [504.0]}, "16": {"vr": "DS", "Value": [615.0]}, "17": {"vr": "DS", "Value": [571.0]}, "18": {"vr": "DS", "Value": [428.0]}, "19": {"vr": "DS", "Value": [327.0]}, "20": {"vr": "DS", "Value": [263.0]}, "21": {"vr": "DS", "Value": [226.0]}, "22": {"vr": "DS", "Value": [242.0]}, "23": {"vr": "DS", "Value": [282.0]}, "24": {"vr": "DS", "Value": [280.0]}, "25": {"vr": "DS", "Value": [208.0]}, "26": {"vr": "DS", "Value": [190.0]}, "27": {"vr": "DS", "Value": [245.0]}, "28": {"vr": "DS", "Value": [207.0]}, "29": {"vr": "DS", "Value": [164.0]}, "30": {"vr": "DS", "Value": [168.0]}, "31": {"vr": "DS", "Value": [111.0]}, "32": {"vr": "DS", "Value": [136.0]}, "33": {"vr": "DS", "Value": [143.0]}, "34": {"vr": "DS", "Value": [167.0]}, "35": {"vr": "DS", "Value": [129.0]}, "36": {"vr": "DS", "Value": [127.0]}, "37": {"vr": "DS", "Value": [144.0]}, "38": {"vr": "DS", "Value": [123.0]}, "39": {"vr": "DS", "Value": [70.0]}, "40": {"vr": "DS", "Value": [103.0]}, "41": {"vr": "DS", "Value": [150.0]}, "42": {"vr": "DS", "Value": [93.0]}, "43": {"vr": "DS", "Value": [68.0]}, "44": {"vr": "DS", "Value": [66.0]}, "45": {"vr": "DS", "Value": [78.0]}, "46": {"vr": "DS", "Value": [72.0]}, "47": {"vr": "DS", "Value": [83.0]}, "48": {"vr": "DS", "Value": [65.0]}, "49": {"vr": "DS", "Value": [110.0]}, "50": {"vr": "DS", "Value": [65.0]}, "51": {"vr": "DS", "Value": [116.0]}, "52": {"vr": "DS", "Value": [71.0]}, "53": {"vr": "DS", "Value": [53.0]}, "54": {"vr": "DS", "Value": [75.0]}, "55": {"vr": "DS", "Value": [114.0]}, "56": {"vr": "DS", "Value": [126.0]}, "57": {"vr": "DS", "Value": [74.0]}, "58": {"vr": "DS", "Value": [76.0]}, "59": {"vr": "DS", "Value": [49.0]}, "60": {"vr": "DS", "Value": [52.0]}, "61": {"vr": "DS", "Value": [52.0]}, "62": {"vr": "DS", "Value": [49.0]}, "63": {"vr": "DS", "Value": [55.0]}, "64": {"vr": "DS", "Value": [57.0]}, "65": {"vr": "DS", "Value": [46.0]}, "66": {"vr": "DS", "Value": [77.0]}, "67": {"vr": "DS", "Value": [54.0]}, "68": {"vr": "DS", "Value": [62.0]}, "69": {"vr": "DS", "Value": [59.0]}, "70": {"vr": "DS", "Value": [73.0]}, "71": {"vr": "DS", "Value": [81.0]}, "72": {"vr": "DS", "Value": [63.0]}, "73": {"vr": "DS", "Value": [71.0]}, "74": {"vr": "DS", "Value": [75.0]}, "75": {"vr": "DS", "Value": [79.0]}, "76": {"vr": "DS", "Value": [97.0]}, "77": {"vr": "DS", "Value": [115.0]}, "78": {"vr": "DS", "Value": [124.0]}, "79": {"vr": "DS", "Value": [166.0]}, "80": {"vr": "DS", "Value": [212.0]}, "81": {"vr": "DS", "Value": [267.0]}, "82": {"vr": "DS", "Value": [451.0]}, "83": {"vr": "DS", "Value": [1301.0]}, "84": {"vr": "DS", "Value": [2104.0]}, "85": {"vr": "DS", "Value": [1742.0]}, "86": {"vr": "DS", "Value": [1194.0]}, "87": {"vr": "DS", "Value": [1135.0]}, "88": {"vr": "DS", "Value": [1373.0]}, "89": {"vr": "DS", "Value": [1504.0]}, "90": {"vr": "DS", "Value": [1357.0]}, "91": {"vr": "DS", "Value": [937.0]}, "92": {"vr": "DS", "Value": [1354.0]}, "93": {"vr": "DS", "Value": [5413.0]}, "94": {"vr": "DS", "Value": [11326.0]}, "95": {"vr": "DS", "Value": [14318.0]}, "96": {"vr": "DS", "Value": [14329.0]}, "97": {"vr": "DS", "Value": [13528.0]}, "98": {"vr": "DS", "Value": [13735.0]}, "99": {"vr": "DS", "Value": [13813.0]}, "100": {"vr": "DS", "Value": [13609.0]}, "101": {"vr": "DS", "Value": [13643.0]}, "102": {"vr": "DS", "Value": [14268.0]}, "103": {"vr": "DS", "Value": [13826.0]}, "104": {"vr": "DS", "Value": [14193.0]}, "105": {"vr": "DS", "Value": [13760.0]}, "106": {"vr": "DS", "Value": [13730.0]}, "107": {"vr": "DS", "Value": [14597.0]}, "108": {"vr": "DS", "Value": [14800.0]}, "109": {"vr": "DS", "Value": [14222.0]}, "110": {"vr": "DS", "Value": [15292.0]}, "111": {"vr": "DS", "Value": [13950.0]}, "112": {"vr": "DS", "Value": [13717.0]}, "113": {"vr": "DS", "Value": [13479.0]}, "114": {"vr": "DS", "Value": [13656.0]}, "115": {"vr": "DS", "Value": [13722.0]}, "116": {"vr": "DS", "Value": [13436.0]}, "117": {"vr": "DS", "Value": [14117.0]}, "118": {"vr": "DS", "Value": [15350.0]}, "119": {"vr": "DS", "Value": [13989.0]}, "120": {"vr": "DS", "Value": [14087.0]}, "121": {"vr": "DS", "Value": [13831.0]}, "122": {"vr": "DS", "Value": [13446.0]}, "123": {"vr": "DS", "Value": [14034.0]}, "124": {"vr": "DS", "Value": [14158.0]}, "125": {"vr": "DS", "Value": [14302.0]}, "126": {"vr": "DS", "Value": [13996.0]}, "127": {"vr": "DS", "Value": [13154.0]}, "128": {"vr": "DS", "Value": [13451.0]}, "129": {"vr": "DS", "Value": [14230.0]}, "130": {"vr": "DS", "Value": [13960.0]}, "131": {"vr": "DS", "Value": [14009.0]}, "132": {"vr": "DS", "Value": [13441.0]}, "133": {"vr": "DS", "Value": [13472.0]}, "134": {"vr": "DS", "Value": [13773.0]}, "135": {"vr": "DS", "Value": [13397.0]}, "136": {"vr": "DS", "Value": [13789.0]}, "137": {"vr": "DS", "Value": [13420.0]}, "138": {"vr": "DS", "Value": [13819.0]}, "139": {"vr": "DS", "Value": [13450.0]}, "140": {"vr": "DS", "Value": [13574.0]}, "141": {"vr": "DS", "Value": [13666.0]}, "142": {"vr": "DS", "Value": [14030.0]}, "143": {"vr": "DS", "Value": [13956.0]}, "144": {"vr": "DS", "Value": [13706.0]}, "145": {"vr": "DS", "Value": [14243.0]}, "146": {"vr": "DS", "Value": [13223.0]}, "147": {"vr": "DS", "Value": [13357.0]}, "148": {"vr": "DS", "Value": [13366.0]}, "149": {"vr": "DS", "Value": [13352.0]}, "150": {"vr": "DS", "Value": [13128.0]}, "151": {"vr": "DS", "Value": [13026.0]}, "152": {"vr": "DS", "Value": [13228.0]}, "153": {"vr": "DS", "Value": [14211.0]}, "154": {"vr": "DS", "Value": [13799.0]}, "155": {"vr": "DS", "Value": [12977.0]}, "156": {"vr": "DS", "Value": [13563.0]}, "157": {"vr": "DS", "Value": [13306.0]}, "158": {"vr": "DS", "Value": [13648.0]}, "159": {"vr": "DS", "Value": [13099.0]}, "160": {"vr": "DS", "Value": [13424.0]}, "161": {"vr": "DS", "Value": [13579.0]}, "162": {"vr": "DS", "Value": [12888.0]}, "163": {"vr": "DS", "Value": [14049.0]}, "164": {"vr": "DS", "Value": [13318.0]}, "165": {"vr": "DS", "Value": [13205.0]}, "166": {"vr": "DS", "Value": [13168.0]}, "167": {"vr": "DS", "Value": [13129.0]}, "168": {"vr": "DS", "Value": [13177.0]}, "169": {"vr": "DS", "Value": [13782.0]}, "170": {"vr": "DS", "Value": [13334.0]}, "171": {"vr": "DS", "Value": [13619.0]}, "172": {"vr": "DS", "Value": [13712.0]}, "173": {"vr": "DS", "Value": [13085.0]}, "174": {"vr": "DS", "Value": [13223.0]}, "175": {"vr": "DS", "Value": [13102.0]}, "176": {"vr": "DS", "Value": [13293.0]}, "177": {"vr": "DS", "Value": [13220.0]}, "178": {"vr": "DS", "Value": [13342.0]}, "179": {"vr": "DS", "Value": [13032.0]}, "180": {"vr": "DS", "Value": [13409.0]}, "181": {"vr": "DS", "Value": [13556.0]}, "182": {"vr": "DS", "Value": [14193.0]}, "183": {"vr": "DS", "Value": [13203.0]}, "184": {"vr": "DS", "Value": [13267.0]}, "185": {"vr": "DS", "Value": [13493.0]}, "186": {"vr": "DS", "Value": [13162.0]}, "187": {"vr": "DS", "Value": [13382.0]}, "188": {"vr": "DS", "Value": [13044.0]}, "189": {"vr": "DS", "Value": [13276.0]}, "190": {"vr": "DS", "Value": [13698.0]}, "191": {"vr": "DS", "Value": [13401.0]}, "192": {"vr": "DS", "Value": [13272.0]}, "193": {"vr": "DS", "Value": [13513.0]}, "194": {"vr": "DS", "Value": [13141.0]}, "195": {"vr": "DS", "Value": [13002.0]}, "196": {"vr": "DS", "Value": [13111.0]}, "197": {"vr": "DS", "Value": [12747.0]}, "198": {"vr": "DS", "Value": [13514.0]}, "199": {"vr": "DS", "Value": [13373.0]}, "200": {"vr": "DS", "Value": [14104.0]}, "201": {"vr": "DS", "Value": [13867.0]}, "202": {"vr": "DS", "Value": [13589.0]}, "203": {"vr": "DS", "Value": [14025.0]}, "204": {"vr": "DS", "Value": [13238.0]}, "205": {"vr": "DS", "Value": [13067.0]}, "206": {"vr": "DS", "Value": [13267.0]}, "207": {"vr": "DS", "Value": [13402.0]}, "208": {"vr": "DS", "Value": [13733.0]}, "209": {"vr": "DS", "Value": [13850.0]}, "210": {"vr": "DS", "Value": [13933.0]}, "211": {"vr": "DS", "Value": [13567.0]}, "212": {"vr": "DS", "Value": [13558.0]}, "213": {"vr": "DS", "Value": [13515.0]}, "214": {"vr": "DS", "Value": [13472.0]}, "215": {"vr": "DS", "Value": [13435.0]}, "216": {"vr": "DS", "Value": [12936.0]}, "217": {"vr": "DS", "Value": [13305.0]}, "218": {"vr": "DS", "Value": [13883.0]}, "219": {"vr": "DS", "Value": [13496.0]}, "220": {"vr": "DS", "Value": [13079.0]}, "221": {"vr": "DS", "Value": [13103.0]}, "222": {"vr": "DS", "Value": [13796.0]}, "223": {"vr": "DS", "Value": [13265.0]}, "224": {"vr": "DS", "Value": [13236.0]}, "225": {"vr": "DS", "Value": [12906.0]}, "226": {"vr": "DS", "Value": [13275.0]}, "227": {"vr": "DS", "Value": [14097.0]}, "228": {"vr": "DS", "Value": [13643.0]}, "229": {"vr": "DS", "Value": [13323.0]}, "230": {"vr": "DS", "Value": [12969.0]}, "231": {"vr": "DS", "Value": [13407.0]}, "232": {"vr": "DS", "Value": [13512.0]}, "233": {"vr": "DS", "Value": [13449.0]}, "234": {"vr": "DS", "Value": [13693.0]}, "235": {"vr": "DS", "Value": [13458.0]}, "236": {"vr": "DS", "Value": [13498.0]}, "237": {"vr": "DS", "Value": [13424.0]}, "238": {"vr": "DS", "Value": [12634.0]}, "239": {"vr": "DS", "Value": [11593.0]}, "240": {"vr": "DS", "Value": [8291.0]}, "241": {"vr": "DS", "Value": [4386.0]}, "242": {"vr": "DS", "Value": [1969.0]}, "243": {"vr": "DS", "Value": [834.0]}, "244": {"vr": "DS", "Value": [518.0]}, "245": {"vr": "DS", "Value": [318.0]}, "246": {"vr": "DS", "Value": [258.0]}, "247": {"vr": "DS", "Value": [183.0]}, "248": {"vr": "DS", "Value": [158.0]}, "249": {"vr": "DS", "Value": [128.0]}, "250": {"vr": "DS", "Value": [92.0]}, "251": {"vr": "DS", "Value": [78.0]}, "252": {"vr": "DS", "Value": [70.0]}, "253": {"vr": "DS", "Value": [76.0]}, "254": {"vr": "DS", "Value": [58.0]}, "255": {"vr": "DS", "Value": [63.0]}, "256": {"vr": "DS", "Value": [47.0]}, "257": {"vr": "DS", "Value": [53.0]}, "258": {"vr": "DS", "Value": [44.0]}, "259": {"vr": "DS", "Value": [42.0]}, "260": {"vr": "DS", "Value": [45.0]}, "261": {"vr": "DS", "Value": [39.0]}, "262": {"vr": "DS", "Value": [34.0]}, "263": {"vr": "DS", "Value": [32.0]}, "264": {"vr": "DS", "Value": [39.0]}, "265": {"vr": "DS", "Value": [43.0]}, "266": {"vr": "DS", "Value": [44.0]}, "267": {"vr": "DS", "Value": [43.0]}, "268": {"vr": "DS", "Value": [35.0]}, "269": {"vr": "DS", "Value": [32.0]}, "270": {"vr": "DS", "Value": [34.0]}, "271": {"vr": "DS", "Value": [30.0]}, "272": {"vr": "DS", "Value": [36.0]}, "273": {"vr": "DS", "Value": [38.0]}, "274": {"vr": "DS", "Value": [36.0]}, "275": {"vr": "DS", "Value": [38.0]}, "276": {"vr": "DS", "Value": [33.0]}, "277": {"vr": "DS", "Value": [26.0]}, "278": {"vr": "DS", "Value": [24.0]}, "279": {"vr": "DS", "Value": [30.0]}, "280": {"vr": "DS", "Value": [24.0]}, "281": {"vr": "DS", "Value": [32.0]}, "282": {"vr": "DS", "Value": [27.0]}, "283": {"vr": "DS", "Value": [27.0]}, "284": {"vr": "DS", "Value": [19.0]}, "285": {"vr": "DS", "Value": [21.0]}, "286": {"vr": "DS", "Value": [26.0]}, "287": {"vr": "DS", "Value": [22.0]}, "288": {"vr": "DS", "Value": [25.0]}, "289": {"vr": "DS", "Value": [21.0]}, "290": {"vr": "DS", "Value": [32.0]}, "291": {"vr": "DS", "Value": [20.0]}, "292": {"vr": "DS", "Value": [19.0]}, "293": {"vr": "DS", "Value": [25.0]}, "294": {"vr": "DS", "Value": [22.0]}, "295": {"vr": "DS", "Value": [27.0]}, "296": {"vr": "DS", "Value": [40.0]}, "297": {"vr": "DS", "Value": [21.0]}, "298": {"vr": "DS", "Value": [37.0]}, "299": {"vr": "DS", "Value": [43.0]}, "300": {"vr": "DS", "Value": [21.0]}, "301": {"vr": "DS", "Value": [23.0]}, "302": {"vr": "DS", "Value": [21.0]}, "303": {"vr": "DS", "Value": [33.0]}, "304": {"vr": "DS", "Value": [37.0]}, "305": {"vr": "DS", "Value": [17.0]}, "306": {"vr": "DS", "Value": [25.0]}, "307": {"vr": "DS", "Value": [23.0]}, "308": {"vr": "DS", "Value": [19.0]}, "309": {"vr": "DS", "Value": [18.0]}, "310": {"vr": "DS", "Value": [20.0]}, "311": {"vr": "DS", "Value": [20.0]}, "312": {"vr": "DS", "Value": [18.0]}, "313": {"vr": "DS", "Value": [23.0]}, "314": {"vr": "DS", "Value": [23.0]}, "315": {"vr": "DS", "Value": [20.0]}, "316": {"vr": "DS", "Value": [30.0]}, "317": {"vr": "DS", "Value": [25.0]}, "318": {"vr": "DS", "Value": [21.0]}, "319": {"vr": "DS", "Value": [20.0]}, "320": {"vr": "DS", "Value": [20.0]}, "321": {"vr": "DS", "Value": [25.0]}, "322": {"vr": "DS", "Value": [23.0]}, "323": {"vr": "DS", "Value": [29.0]}, "324": {"vr": "DS", "Value": [24.0]}, "325": {"vr": "DS", "Value": [30.0]}, "326": {"vr": "DS", "Value": [19.0]}, "327": {"vr": "DS", "Value": [19.0]}, "328": {"vr": "DS", "Value": [23.0]}, "329": {"vr": "DS", "Value": [22.0]}, "330": {"vr": "DS", "Value": [22.0]}, "331": {"vr": "DS", "Value": [36.0]}, "332": {"vr": "DS", "Value": [20.0]}, "333": {"vr": "DS", "Value": [23.0]}, "334": {"vr": "DS", "Value": [28.0]}, "335": {"vr": "DS", "Value": [18.0]}, "336": {"vr": "DS", "Value": [22.0]}, "337": {"vr": "DS", "Value": [30.0]}, "338": {"vr": "DS", "Value": [24.0]}, "339": {"vr": "DS", "Value": [25.0]}, "340": {"vr": "DS", "Value": [20.0]}, "341": {"vr": "DS", "Value": [35.0]}, "342": {"vr": "DS", "Value": [23.0]}, "343": {"vr": "DS", "Value": [16.0]}, "344": {"vr": "DS", "Value": [19.0]}, "345": {"vr": "DS", "Value": [18.0]}, "346": {"vr": "DS", "Value": [25.0]}, "347": {"vr": "DS", "Value": [19.0]}, "348": {"vr": "DS", "Value": [20.0]}, "349": {"vr": "DS", "Value": [22.0]}, "350": {"vr": "DS", "Value": [25.0]}, "351": {"vr": "DS", "Value": [28.0]}, "352": {"vr": "DS", "Value": [32.0]}, "353": {"vr": "DS", "Value": [34.0]}, "354": {"vr": "DS", "Value": [28.0]}, "355": {"vr": "DS", "Value": [40.0]}, "356": {"vr": "DS", "Value": [20.0]}, "357": {"vr": "DS", "Value": [22.0]}, "358": {"vr": "DS", "Value": [26.0]}, "359": {"vr": "DS", "Value": [25.0]}, "360": {"vr": "DS", "Value": [20.0]}, "361": {"vr": "DS", "Value": [30.0]}, "362": {"vr": "DS", "Value": [35.0]}, "363": {"vr": "DS", "Value": [22.0]}, "364": {"vr": "DS", "Value": [28.0]}, "365": {"vr": "DS", "Value": [24.0]}, "366": {"vr": "DS", "Value": [21.0]}, "367": {"vr": "DS", "Value": [28.0]}, "368": {"vr": "DS", "Value": [28.0]}, "369": {"vr": "DS", "Value": [25.0]}, "370": {"vr": "DS", "Value": [28.0]}, "371": {"vr": "DS", "Value": [20.0]}, "372": {"vr": "DS", "Value": [32.0]}, "373": {"vr": "DS", "Value": [27.0]}, "374": {"vr": "DS", "Value": [26.0]}, "375": {"vr": "DS", "Value": [34.0]}, "376": {"vr": "DS", "Value": [54.0]}, "377": {"vr": "DS", "Value": [30.0]}, "378": {"vr": "DS", "Value": [35.0]}, "379": {"vr": "DS", "Value": [19.0]}, "380": {"vr": "DS", "Value": [29.0]}, "381": {"vr": "DS", "Value": [59.0]}, "382": {"vr": "DS", "Value": [51.0]}, "383": {"vr": "DS", "Value": [40.0]}, "384": {"vr": "DS", "Value": [25.0]}, "385": {"vr": "DS", "Value": [24.0]}, "386": {"vr": "DS", "Value": [22.0]}, "387": {"vr": "DS", "Value": [24.0]}, "388": {"vr": "DS", "Value": [32.0]}, "389": {"vr": "DS", "Value": [52.0]}, "390": {"vr": "DS", "Value": [21.0]}, "391": {"vr": "DS", "Value": [30.0]}, "392": {"vr": "DS", "Value": [76.0]}, "393": {"vr": "DS", "Value": [44.0]}, "394": {"vr": "DS", "Value": [53.0]}, "395": {"vr": "DS", "Value": [44.0]}, "396": {"vr": "DS", "Value": [29.0]}, "397": {"vr": "DS", "Value": [19.0]}, "398": {"vr": "DS", "Value": [20.0]}, "399": {"vr": "DS", "Value": [59.0]}, "400": {"vr": "DS", "Value": [59.0]}, "401": {"vr": "DS", "Value": [22.0]}, "402": {"vr": "DS", "Value": [76.0]}, "403": {"vr": "DS", "Value": [26.0]}, "404": {"vr": "DS", "Value": [23.0]}, "405": {"vr": "DS", "Value": [45.0]}, "406": {"vr": "DS", "Value": [90.0]}, "407": {"vr": "DS", "Value": [52.0]}, "408": {"vr": "DS", "Value": [2.0]}, "409": {"vr": "DS", "Value": [2.0]}, "410": {"vr": "DS", "Value": [1.0]}, "411": {"vr": "DS", "Value": [3.0]}, "412": {"vr": "DS", "Value": [1.0]}, "413": {"vr": "DS", "Value": [1.0]}, "414": {"vr": "DS", "Value": [1.0]}, "415": {"vr": "DS", "Value": [1.0]}, "416": {"vr": "DS", "Value": [1.0]}, "417": {"vr": "DS", "Value": [1.0]}, "418": {"vr": "DS", "Value": [1.0]}, "419": {"vr": "DS", "Value": [1.0]}, "420": {"vr": "DS", "Value": [1.0]}, "421": {"vr": "DS", "Value": [1.0]}, "422": {"vr": "DS", "Value": [1.0]}, "423": {"vr": "DS", "Value": [1.0]}, "424": {"vr": "DS", "Value": [1.0]}, "425": {"vr": "DS", "Value": [1.0]}, "426": {"vr": "DS", "Value": [1.0]}, "427": {"vr": "DS", "Value": [1.0]}, "428": {"vr": "DS", "Value": [1.0]}, "429": {"vr": "DS", "Value": [1.0]}, "430": {"vr": "DS", "Value": [1.0]}, "431": {"vr": "DS", "Value": [1.0]}, "432": {"vr": "DS", "Value": [1.0]}, "433": {"vr": "DS", "Value": [1.0]}, "434": {"vr": "DS", "Value": [1.0]}, "435": {"vr": "DS", "Value": [1.0]}, "436": {"vr": "DS", "Value": [1.0]}, "437": {"vr": "DS", "Value": [1.0]}, "438": {"vr": "DS", "Value": [1.0]}, "439": {"vr": "DS", "Value": [1.0]}, "440": {"vr": "DS", "Value": [1.0]}, "441": {"vr": "DS", "Value": [1.0]}, "442": {"vr": "DS", "Value": [1.0]}, "443": {"vr": "DS", "Value": [1.0]}, "444": {"vr": "DS", "Value": [1.0]}, "445": {"vr": "DS", "Value": [1.0]}, "446": {"vr": "DS", "Value": [1.0]}, "447": {"vr": "DS", "Value": [1.0]}, "448": {"vr": "DS", "Value": [1.0]}, "449": {"vr": "DS", "Value": [1.0]}, "450": {"vr": "DS", "Value": [1.0]}, "451": {"vr": "DS", "Value": [1.0]}, "452": {"vr": "DS", "Value": [1.0]}, "453": {"vr": "DS", "Value": [1.0]}, "454": {"vr": "DS", "Value": [1.0]}, "455": {"vr": "DS", "Value": [1.0]}, "456": {"vr": "DS", "Value": [1.0]}, "457": {"vr": "DS", "Value": [1.0]}, "458": {"vr": "DS", "Value": [1.0]}, "459": {"vr": "DS", "Value": [1.0]}, "460": {"vr": "DS", "Value": [1.0]}, "461": {"vr": "DS", "Value": [1.0]}, "462": {"vr": "DS", "Value": [1.0]}, "463": {"vr": "DS", "Value": [1.0]}, "464": {"vr": "DS", "Value": [1.0]}, "465": {"vr": "DS", "Value": [1.0]}, "466": {"vr": "DS", "Value": [1.0]}, "467": {"vr": "DS", "Value": [1.0]}, "468": {"vr": "DS", "Value": [1.0]}, "469": {"vr": "DS", "Value": [1.0]}, "470": {"vr": "DS", "Value": [1.0]}, "471": {"vr": "DS", "Value": [1.0]}, "472": {"vr": "DS", "Value": [1.0]}, "473": {"vr": "DS", "Value": [1.0]}, "474": {"vr": "DS", "Value": [1.0]}, "475": {"vr": "DS", "Value": [1.0]}, "476": {"vr": "DS", "Value": [1.0]}, "477": {"vr": "DS", "Value": [1.0]}, "478": {"vr": "DS", "Value": [1.0]}, "479": {"vr": "DS", "Value": [1.0]}, "480": {"vr": "DS", "Value": [1.0]}, "481": {"vr": "DS", "Value": [1.0]}, "482": {"vr": "DS", "Value": [1.0]}, "483": {"vr": "DS", "Value": [1.0]}, "484": {"vr": "DS", "Value": [1.0]}, "485": {"vr": "DS", "Value": [1.0]}, "486": {"vr": "DS", "Value": [1.0]}, "487": {"vr": "DS", "Value": [1.0]}, "488": {"vr": "DS", "Value": [1.0]}, "489": {"vr": "DS", "Value": [1.0]}, "490": {"vr": "DS", "Value": [1.0]}, "491": {"vr": "DS", "Value": [1.0]}, "492": {"vr": "DS", "Value": [1.0]}, "493": {"vr": "DS", "Value": [1.0]}, "494": {"vr": "DS", "Value": [1.0]}, "495": {"vr": "DS", "Value": [1.0]}, "496": {"vr": "DS", "Value": [1.0]}, "497": {"vr": "DS", "Value": [1.0]}, "498": {"vr": "DS", "Value": [1.0]}, "499": {"vr": "DS", "Value": [1.0]}, "500": {"vr": "DS", "Value": [1.0]}, "501": {"vr": "DS", "Value": [1.0]}, "502": {"vr": "DS", "Value": [1.0]}, "503": {"vr": "DS", "Value": [1.0]}, "504": {"vr": "DS", "Value": [1.0]}, "505": {"vr": "DS", "Value": [1.0]}, "506": {"vr": "DS", "Value": [1.0]}, "507": {"vr": "DS", "Value": [1.0]}, "508": {"vr": "DS", "Value": [1.0]}, "509": {"vr": "DS", "Value": [1.0]}, "510": {"vr": "DS", "Value": [1.0]}, "511": {"vr": "DS", "Value": [1.0]}, "512": {"vr": "DS", "Value": [1.0]}, "513": {"vr": "DS", "Value": [1.0]}, "514": {"vr": "DS", "Value": [1.0]}, "515": {"vr": "DS", "Value": [1.0]}, "516": {"vr": "DS", "Value": [1.0]}, "517": {"vr": "DS", "Value": [1.0]}, "518": {"vr": "DS", "Value": [1.0]}, "519": {"vr": "DS", "Value": [1.0]}, "520": {"vr": "DS", "Value": [1.0]}, "521": {"vr": "DS", "Value": [1.0]}, "522": {"vr": "DS", "Value": [1.0]}, "523": {"vr": "DS", "Value": [1.0]}, "524": {"vr": "DS", "Value": [1.0]}, "525": {"vr": "DS", "Value": [1.0]}, "526": {"vr": "DS", "Value": [1.0]}, "527": {"vr": "DS", "Value": [1.0]}, "528": {"vr": "DS", "Value": [1.0]}, "529": {"vr": "DS", "Value": [1.0]}, "530": {"vr": "DS", "Value": [1.0]}}, "00541330": {"0": {"vr": "US", "Value": [531]}, "1": {"vr": "US", "Value": [530]}, "2": {"vr": "US", "Value": [529]}, "3": {"vr": "US", "Value": [528]}, "4": {"vr": "US", "Value": [527]}, "5": {"vr": "US", "Value": [526]}, "6": {"vr": "US", "Value": [525]}, "7": {"vr": "US", "Value": [524]}, "8": {"vr": "US", "Value": [523]}, "9": {"vr": "US", "Value": [522]}, "10": {"vr": "US", "Value": [521]}, "11": {"vr": "US", "Value": [520]}, "12": {"vr": "US", "Value": [519]}, "13": {"vr": "US", "Value": [518]}, "14": {"vr": "US", "Value": [517]}, "15": {"vr": "US", "Value": [516]}, "16": {"vr": "US", "Value": [515]}, "17": {"vr": "US", "Value": [514]}, "18": {"vr": "US", "Value": [513]}, "19": {"vr": "US", "Value": [512]}, "20": {"vr": "US", "Value": [511]}, "21": {"vr": "US", "Value": [510]}, "22": {"vr": "US", "Value": [509]}, "23": {"vr": "US", "Value": [508]}, "24": {"vr": "US", "Value": [507]}, "25": {"vr": "US", "Value": [506]}, "26": {"vr": "US", "Value": [505]}, "27": {"vr": "US", "Value": [504]}, "28": {"vr": "US", "Value": [503]}, "29": {"vr": "US", "Value": [502]}, "30": {"vr": "US", "Value": [501]}, "31": {"vr": "US", "Value": [500]}, "32": {"vr": "US", "Value": [499]}, "33": {"vr": "US", "Value": [498]}, "34": {"vr": "US", "Value": [497]}, "35": {"vr": "US", "Value": [496]}, "36": {"vr": "US", "Value": [495]}, "37": {"vr": "US", "Value": [494]}, "38": {"vr": "US", "Value": [493]}, "39": {"vr": "US", "Value": [492]}, "40": {"vr": "US", "Value": [491]}, "41": {"vr": "US", "Value": [490]}, "42": {"vr": "US", "Value": [489]}, "43": {"vr": "US", "Value": [488]}, "44": {"vr": "US", "Value": [487]}, "45": {"vr": "US", "Value": [486]}, "46": {"vr": "US", "Value": [485]}, "47": {"vr": "US", "Value": [484]}, "48": {"vr": "US", "Value": [483]}, "49": {"vr": "US", "Value": [482]}, "50": {"vr": "US", "Value": [481]}, "51": {"vr": "US", "Value": [480]}, "52": {"vr": "US", "Value": [479]}, "53": {"vr": "US", "Value": [478]}, "54": {"vr": "US", "Value": [477]}, "55": {"vr": "US", "Value": [476]}, "56": {"vr": "US", "Value": [475]}, "57": {"vr": "US", "Value": [474]}, "58": {"vr": "US", "Value": [473]}, "59": {"vr": "US", "Value": [472]}, "60": {"vr": "US", "Value": [471]}, "61": {"vr": "US", "Value": [470]}, "62": {"vr": "US", "Value": [469]}, "63": {"vr": "US", "Value": [468]}, "64": {"vr": "US", "Value": [467]}, "65": {"vr": "US", "Value": [466]}, "66": {"vr": "US", "Value": [465]}, "67": {"vr": "US", "Value": [464]}, "68": {"vr": "US", "Value": [463]}, "69": {"vr": "US", "Value": [462]}, "70": {"vr": "US", "Value": [461]}, "71": {"vr": "US", "Value": [460]}, "72": {"vr": "US", "Value": [459]}, "73": {"vr": "US", "Value": [458]}, "74": {"vr": "US", "Value": [457]}, "75": {"vr": "US", "Value": [456]}, "76": {"vr": "US", "Value": [455]}, "77": {"vr": "US", "Value": [454]}, "78": {"vr": "US", "Value": [453]}, "79": {"vr": "US", "Value": [452]}, "80": {"vr": "US", "Value": [451]}, "81": {"vr": "US", "Value": [450]}, "82": {"vr": "US", "Value": [449]}, "83": {"vr": "US", "Value": [448]}, "84": {"vr": "US", "Value": [447]}, "85": {"vr": "US", "Value": [446]}, "86": {"vr": "US", "Value": [445]}, "87": {"vr": "US", "Value": [444]}, "88": {"vr": "US", "Value": [443]}, "89": {"vr": "US", "Value": [442]}, "90": {"vr": "US", "Value": [441]}, "91": {"vr": "US", "Value": [440]}, "92": {"vr": "US", "Value": [439]}, "93": {"vr": "US", "Value": [438]}, "94": {"vr": "US", "Value": [437]}, "95": {"vr": "US", "Value": [436]}, "96": {"vr": "US", "Value": [435]}, "97": {"vr": "US", "Value": [434]}, "98": {"vr": "US", "Value": [433]}, "99": {"vr": "US", "Value": [432]}, "100": {"vr": "US", "Value": [431]}, "101": {"vr": "US", "Value": [430]}, "102": {"vr": "US", "Value": [429]}, "103": {"vr": "US", "Value": [428]}, "104": {"vr": "US", "Value": [427]}, "105": {"vr": "US", "Value": [426]}, "106": {"vr": "US", "Value": [425]}, "107": {"vr": "US", "Value": [424]}, "108": {"vr": "US", "Value": [423]}, "109": {"vr": "US", "Value": [422]}, "110": {"vr": "US", "Value": [421]}, "111": {"vr": "US", "Value": [420]}, "112": {"vr": "US", "Value": [419]}, "113": {"vr": "US", "Value": [418]}, "114": {"vr": "US", "Value": [417]}, "115": {"vr": "US", "Value": [416]}, "116": {"vr": "US", "Value": [415]}, "117": {"vr": "US", "Value": [414]}, "118": {"vr": "US", "Value": [413]}, "119": {"vr": "US", "Value": [412]}, "120": {"vr": "US", "Value": [411]}, "121": {"vr": "US", "Value": [410]}, "122": {"vr": "US", "Value": [409]}, "123": {"vr": "US", "Value": [408]}, "124": {"vr": "US", "Value": [407]}, "125": {"vr": "US", "Value": [406]}, "126": {"vr": "US", "Value": [405]}, "127": {"vr": "US", "Value": [404]}, "128": {"vr": "US", "Value": [403]}, "129": {"vr": "US", "Value": [402]}, "130": {"vr": "US", "Value": [401]}, "131": {"vr": "US", "Value": [400]}, "132": {"vr": "US", "Value": [399]}, "133": {"vr": "US", "Value": [398]}, "134": {"vr": "US", "Value": [397]}, "135": {"vr": "US", "Value": [396]}, "136": {"vr": "US", "Value": [395]}, "137": {"vr": "US", "Value": [394]}, "138": {"vr": "US", "Value": [393]}, "139": {"vr": "US", "Value": [392]}, "140": {"vr": "US", "Value": [391]}, "141": {"vr": "US", "Value": [390]}, "142": {"vr": "US", "Value": [389]}, "143": {"vr": "US", "Value": [388]}, "144": {"vr": "US", "Value": [387]}, "145": {"vr": "US", "Value": [386]}, "146": {"vr": "US", "Value": [385]}, "147": {"vr": "US", "Value": [384]}, "148": {"vr": "US", "Value": [383]}, "149": {"vr": "US", "Value": [382]}, "150": {"vr": "US", "Value": [381]}, "151": {"vr": "US", "Value": [380]}, "152": {"vr": "US", "Value": [379]}, "153": {"vr": "US", "Value": [378]}, "154": {"vr": "US", "Value": [377]}, "155": {"vr": "US", "Value": [376]}, "156": {"vr": "US", "Value": [375]}, "157": {"vr": "US", "Value": [374]}, "158": {"vr": "US", "Value": [373]}, "159": {"vr": "US", "Value": [372]}, "160": {"vr": "US", "Value": [371]}, "161": {"vr": "US", "Value": [370]}, "162": {"vr": "US", "Value": [369]}, "163": {"vr": "US", "Value": [368]}, "164": {"vr": "US", "Value": [367]}, "165": {"vr": "US", "Value": [366]}, "166": {"vr": "US", "Value": [365]}, "167": {"vr": "US", "Value": [364]}, "168": {"vr": "US", "Value": [363]}, "169": {"vr": "US", "Value": [362]}, "170": {"vr": "US", "Value": [361]}, "171": {"vr": "US", "Value": [360]}, "172": {"vr": "US", "Value": [359]}, "173": {"vr": "US", "Value": [358]}, "174": {"vr": "US", "Value": [357]}, "175": {"vr": "US", "Value": [356]}, "176": {"vr": "US", "Value": [355]}, "177": {"vr": "US", "Value": [354]}, "178": {"vr": "US", "Value": [353]}, "179": {"vr": "US", "Value": [352]}, "180": {"vr": "US", "Value": [351]}, "181": {"vr": "US", "Value": [350]}, "182": {"vr": "US", "Value": [349]}, "183": {"vr": "US", "Value": [348]}, "184": {"vr": "US", "Value": [347]}, "185": {"vr": "US", "Value": [346]}, "186": {"vr": "US", "Value": [345]}, "187": {"vr": "US", "Value": [344]}, "188": {"vr": "US", "Value": [343]}, "189": {"vr": "US", "Value": [342]}, "190": {"vr": "US", "Value": [341]}, "191": {"vr": "US", "Value": [340]}, "192": {"vr": "US", "Value": [339]}, "193": {"vr": "US", "Value": [338]}, "194": {"vr": "US", "Value": [337]}, "195": {"vr": "US", "Value": [336]}, "196": {"vr": "US", "Value": [335]}, "197": {"vr": "US", "Value": [334]}, "198": {"vr": "US", "Value": [333]}, "199": {"vr": "US", "Value": [332]}, "200": {"vr": "US", "Value": [331]}, "201": {"vr": "US", "Value": [330]}, "202": {"vr": "US", "Value": [329]}, "203": {"vr": "US", "Value": [328]}, "204": {"vr": "US", "Value": [327]}, "205": {"vr": "US", "Value": [326]}, "206": {"vr": "US", "Value": [325]}, "207": {"vr": "US", "Value": [324]}, "208": {"vr": "US", "Value": [323]}, "209": {"vr": "US", "Value": [322]}, "210": {"vr": "US", "Value": [321]}, "211": {"vr": "US", "Value": [320]}, "212": {"vr": "US", "Value": [319]}, "213": {"vr": "US", "Value": [318]}, "214": {"vr": "US", "Value": [317]}, "215": {"vr": "US", "Value": [316]}, "216": {"vr": "US", "Value": [315]}, "217": {"vr": "US", "Value": [314]}, "218": {"vr": "US", "Value": [313]}, "219": {"vr": "US", "Value": [312]}, "220": {"vr": "US", "Value": [311]}, "221": {"vr": "US", "Value": [310]}, "222": {"vr": "US", "Value": [309]}, "223": {"vr": "US", "Value": [308]}, "224": {"vr": "US", "Value": [307]}, "225": {"vr": "US", "Value": [306]}, "226": {"vr": "US", "Value": [305]}, "227": {"vr": "US", "Value": [304]}, "228": {"vr": "US", "Value": [303]}, "229": {"vr": "US", "Value": [302]}, "230": {"vr": "US", "Value": [301]}, "231": {"vr": "US", "Value": [300]}, "232": {"vr": "US", "Value": [299]}, "233": {"vr": "US", "Value": [298]}, "234": {"vr": "US", "Value": [297]}, "235": {"vr": "US", "Value": [296]}, "236": {"vr": "US", "Value": [295]}, "237": {"vr": "US", "Value": [294]}, "238": {"vr": "US", "Value": [293]}, "239": {"vr": "US", "Value": [292]}, "240": {"vr": "US", "Value": [291]}, "241": {"vr": "US", "Value": [290]}, "242": {"vr": "US", "Value": [289]}, "243": {"vr": "US", "Value": [288]}, "244": {"vr": "US", "Value": [287]}, "245": {"vr": "US", "Value": [286]}, "246": {"vr": "US", "Value": [285]}, "247": {"vr": "US", "Value": [284]}, "248": {"vr": "US", "Value": [283]}, "249": {"vr": "US", "Value": [282]}, "250": {"vr": "US", "Value": [281]}, "251": {"vr": "US", "Value": [280]}, "252": {"vr": "US", "Value": [279]}, "253": {"vr": "US", "Value": [278]}, "254": {"vr": "US", "Value": [277]}, "255": {"vr": "US", "Value": [276]}, "256": {"vr": "US", "Value": [275]}, "257": {"vr": "US", "Value": [274]}, "258": {"vr": "US", "Value": [273]}, "259": {"vr": "US", "Value": [272]}, "260": {"vr": "US", "Value": [271]}, "261": {"vr": "US", "Value": [270]}, "262": {"vr": "US", "Value": [269]}, "263": {"vr": "US", "Value": [268]}, "264": {"vr": "US", "Value": [267]}, "265": {"vr": "US", "Value": [266]}, "266": {"vr": "US", "Value": [265]}, "267": {"vr": "US", "Value": [264]}, "268": {"vr": "US", "Value": [263]}, "269": {"vr": "US", "Value": [262]}, "270": {"vr": "US", "Value": [261]}, "271": {"vr": "US", "Value": [260]}, "272": {"vr": "US", "Value": [259]}, "273": {"vr": "US", "Value": [258]}, "274": {"vr": "US", "Value": [257]}, "275": {"vr": "US", "Value": [256]}, "276": {"vr": "US", "Value": [255]}, "277": {"vr": "US", "Value": [254]}, "278": {"vr": "US", "Value": [253]}, "279": {"vr": "US", "Value": [252]}, "280": {"vr": "US", "Value": [251]}, "281": {"vr": "US", "Value": [250]}, "282": {"vr": "US", "Value": [249]}, "283": {"vr": "US", "Value": [248]}, "284": {"vr": "US", "Value": [247]}, "285": {"vr": "US", "Value": [246]}, "286": {"vr": "US", "Value": [245]}, "287": {"vr": "US", "Value": [244]}, "288": {"vr": "US", "Value": [243]}, "289": {"vr": "US", "Value": [242]}, "290": {"vr": "US", "Value": [241]}, "291": {"vr": "US", "Value": [240]}, "292": {"vr": "US", "Value": [239]}, "293": {"vr": "US", "Value": [238]}, "294": {"vr": "US", "Value": [237]}, "295": {"vr": "US", "Value": [236]}, "296": {"vr": "US", "Value": [235]}, "297": {"vr": "US", "Value": [234]}, "298": {"vr": "US", "Value": [233]}, "299": {"vr": "US", "Value": [232]}, "300": {"vr": "US", "Value": [231]}, "301": {"vr": "US", "Value": [230]}, "302": {"vr": "US", "Value": [229]}, "303": {"vr": "US", "Value": [228]}, "304": {"vr": "US", "Value": [227]}, "305": {"vr": "US", "Value": [226]}, "306": {"vr": "US", "Value": [225]}, "307": {"vr": "US", "Value": [224]}, "308": {"vr": "US", "Value": [223]}, "309": {"vr": "US", "Value": [222]}, "310": {"vr": "US", "Value": [221]}, "311": {"vr": "US", "Value": [220]}, "312": {"vr": "US", "Value": [219]}, "313": {"vr": "US", "Value": [218]}, "314": {"vr": "US", "Value": [217]}, "315": {"vr": "US", "Value": [216]}, "316": {"vr": "US", "Value": [215]}, "317": {"vr": "US", "Value": [214]}, "318": {"vr": "US", "Value": [213]}, "319": {"vr": "US", "Value": [212]}, "320": {"vr": "US", "Value": [211]}, "321": {"vr": "US", "Value": [210]}, "322": {"vr": "US", "Value": [209]}, "323": {"vr": "US", "Value": [208]}, "324": {"vr": "US", "Value": [207]}, "325": {"vr": "US", "Value": [206]}, "326": {"vr": "US", "Value": [205]}, "327": {"vr": "US", "Value": [204]}, "328": {"vr": "US", "Value": [203]}, "329": {"vr": "US", "Value": [202]}, "330": {"vr": "US", "Value": [201]}, "331": {"vr": "US", "Value": [200]}, "332": {"vr": "US", "Value": [199]}, "333": {"vr": "US", "Value": [198]}, "334": {"vr": "US", "Value": [197]}, "335": {"vr": "US", "Value": [196]}, "336": {"vr": "US", "Value": [195]}, "337": {"vr": "US", "Value": [194]}, "338": {"vr": "US", "Value": [193]}, "339": {"vr": "US", "Value": [192]}, "340": {"vr": "US", "Value": [191]}, "341": {"vr": "US", "Value": [190]}, "342": {"vr": "US", "Value": [189]}, "343": {"vr": "US", "Value": [188]}, "344": {"vr": "US", "Value": [187]}, "345": {"vr": "US", "Value": [186]}, "346": {"vr": "US", "Value": [185]}, "347": {"vr": "US", "Value": [184]}, "348": {"vr": "US", "Value": [183]}, "349": {"vr": "US", "Value": [182]}, "350": {"vr": "US", "Value": [181]}, "351": {"vr": "US", "Value": [180]}, "352": {"vr": "US", "Value": [179]}, "353": {"vr": "US", "Value": [178]}, "354": {"vr": "US", "Value": [177]}, "355": {"vr": "US", "Value": [176]}, "356": {"vr": "US", "Value": [175]}, "357": {"vr": "US", "Value": [174]}, "358": {"vr": "US", "Value": [173]}, "359": {"vr": "US", "Value": [172]}, "360": {"vr": "US", "Value": [171]}, "361": {"vr": "US", "Value": [170]}, "362": {"vr": "US", "Value": [169]}, "363": {"vr": "US", "Value": [168]}, "364": {"vr": "US", "Value": [167]}, "365": {"vr": "US", "Value": [166]}, "366": {"vr": "US", "Value": [165]}, "367": {"vr": "US", "Value": [164]}, "368": {"vr": "US", "Value": [163]}, "369": {"vr": "US", "Value": [162]}, "370": {"vr": "US", "Value": [161]}, "371": {"vr": "US", "Value": [160]}, "372": {"vr": "US", "Value": [159]}, "373": {"vr": "US", "Value": [158]}, "374": {"vr": "US", "Value": [157]}, "375": {"vr": "US", "Value": [156]}, "376": {"vr": "US", "Value": [155]}, "377": {"vr": "US", "Value": [154]}, "378": {"vr": "US", "Value": [153]}, "379": {"vr": "US", "Value": [152]}, "380": {"vr": "US", "Value": [151]}, "381": {"vr": "US", "Value": [150]}, "382": {"vr": "US", "Value": [149]}, "383": {"vr": "US", "Value": [148]}, "384": {"vr": "US", "Value": [147]}, "385": {"vr": "US", "Value": [146]}, "386": {"vr": "US", "Value": [145]}, "387": {"vr": "US", "Value": [144]}, "388": {"vr": "US", "Value": [143]}, "389": {"vr": "US", "Value": [142]}, "390": {"vr": "US", "Value": [141]}, "391": {"vr": "US", "Value": [140]}, "392": {"vr": "US", "Value": [139]}, "393": {"vr": "US", "Value": [138]}, "394": {"vr": "US", "Value": [137]}, "395": {"vr": "US", "Value": [136]}, "396": {"vr": "US", "Value": [135]}, "397": {"vr": "US", "Value": [134]}, "398": {"vr": "US", "Value": [133]}, "399": {"vr": "US", "Value": [132]}, "400": {"vr": "US", "Value": [131]}, "401": {"vr": "US", "Value": [130]}, "402": {"vr": "US", "Value": [129]}, "403": {"vr": "US", "Value": [128]}, "404": {"vr": "US", "Value": [127]}, "405": {"vr": "US", "Value": [126]}, "406": {"vr": "US", "Value": [125]}, "407": {"vr": "US", "Value": [124]}, "408": {"vr": "US", "Value": [123]}, "409": {"vr": "US", "Value": [122]}, "410": {"vr": "US", "Value": [121]}, "411": {"vr": "US", "Value": [120]}, "412": {"vr": "US", "Value": [119]}, "413": {"vr": "US", "Value": [118]}, "414": {"vr": "US", "Value": [117]}, "415": {"vr": "US", "Value": [116]}, "416": {"vr": "US", "Value": [115]}, "417": {"vr": "US", "Value": [114]}, "418": {"vr": "US", "Value": [113]}, "419": {"vr": "US", "Value": [112]}, "420": {"vr": "US", "Value": [111]}, "421": {"vr": "US", "Value": [110]}, "422": {"vr": "US", "Value": [109]}, "423": {"vr": "US", "Value": [108]}, "424": {"vr": "US", "Value": [107]}, "425": {"vr": "US", "Value": [106]}, "426": {"vr": "US", "Value": [105]}, "427": {"vr": "US", "Value": [104]}, "428": {"vr": "US", "Value": [103]}, "429": {"vr": "US", "Value": [102]}, "430": {"vr": "US", "Value": [101]}, "431": {"vr": "US", "Value": [100]}, "432": {"vr": "US", "Value": [99]}, "433": {"vr": "US", "Value": [98]}, "434": {"vr": "US", "Value": [97]}, "435": {"vr": "US", "Value": [96]}, "436": {"vr": "US", "Value": [95]}, "437": {"vr": "US", "Value": [94]}, "438": {"vr": "US", "Value": [93]}, "439": {"vr": "US", "Value": [92]}, "440": {"vr": "US", "Value": [91]}, "441": {"vr": "US", "Value": [90]}, "442": {"vr": "US", "Value": [89]}, "443": {"vr": "US", "Value": [88]}, "444": {"vr": "US", "Value": [87]}, "445": {"vr": "US", "Value": [86]}, "446": {"vr": "US", "Value": [85]}, "447": {"vr": "US", "Value": [84]}, "448": {"vr": "US", "Value": [83]}, "449": {"vr": "US", "Value": [82]}, "450": {"vr": "US", "Value": [81]}, "451": {"vr": "US", "Value": [80]}, "452": {"vr": "US", "Value": [79]}, "453": {"vr": "US", "Value": [78]}, "454": {"vr": "US", "Value": [77]}, "455": {"vr": "US", "Value": [76]}, "456": {"vr": "US", "Value": [75]}, "457": {"vr": "US", "Value": [74]}, "458": {"vr": "US", "Value": [73]}, "459": {"vr": "US", "Value": [72]}, "460": {"vr": "US", "Value": [71]}, "461": {"vr": "US", "Value": [70]}, "462": {"vr": "US", "Value": [69]}, "463": {"vr": "US", "Value": [68]}, "464": {"vr": "US", "Value": [67]}, "465": {"vr": "US", "Value": [66]}, "466": {"vr": "US", "Value": [65]}, "467": {"vr": "US", "Value": [64]}, "468": {"vr": "US", "Value": [63]}, "469": {"vr": "US", "Value": [62]}, "470": {"vr": "US", "Value": [61]}, "471": {"vr": "US", "Value": [60]}, "472": {"vr": "US", "Value": [59]}, "473": {"vr": "US", "Value": [58]}, "474": {"vr": "US", "Value": [57]}, "475": {"vr": "US", "Value": [56]}, "476": {"vr": "US", "Value": [55]}, "477": {"vr": "US", "Value": [54]}, "478": {"vr": "US", "Value": [53]}, "479": {"vr": "US", "Value": [52]}, "480": {"vr": "US", "Value": [51]}, "481": {"vr": "US", "Value": [50]}, "482": {"vr": "US", "Value": [49]}, "483": {"vr": "US", "Value": [48]}, "484": {"vr": "US", "Value": [47]}, "485": {"vr": "US", "Value": [46]}, "486": {"vr": "US", "Value": [45]}, "487": {"vr": "US", "Value": [44]}, "488": {"vr": "US", "Value": [43]}, "489": {"vr": "US", "Value": [42]}, "490": {"vr": "US", "Value": [41]}, "491": {"vr": "US", "Value": [40]}, "492": {"vr": "US", "Value": [39]}, "493": {"vr": "US", "Value": [38]}, "494": {"vr": "US", "Value": [37]}, "495": {"vr": "US", "Value": [36]}, "496": {"vr": "US", "Value": [35]}, "497": {"vr": "US", "Value": [34]}, "498": {"vr": "US", "Value": [33]}, "499": {"vr": "US", "Value": [32]}, "500": {"vr": "US", "Value": [31]}, "501": {"vr": "US", "Value": [30]}, "502": {"vr": "US", "Value": [29]}, "503": {"vr": "US", "Value": [28]}, "504": {"vr": "US", "Value": [27]}, "505": {"vr": "US", "Value": [26]}, "506": {"vr": "US", "Value": [25]}, "507": {"vr": "US", "Value": [24]}, "508": {"vr": "US", "Value": [23]}, "509": {"vr": "US", "Value": [22]}, "510": {"vr": "US", "Value": [21]}, "511": {"vr": "US", "Value": [20]}, "512": {"vr": "US", "Value": [19]}, "513": {"vr": "US", "Value": [18]}, "514": {"vr": "US", "Value": [17]}, "515": {"vr": "US", "Value": [16]}, "516": {"vr": "US", "Value": [15]}, "517": {"vr": "US", "Value": [14]}, "518": {"vr": "US", "Value": [13]}, "519": {"vr": "US", "Value": [12]}, "520": {"vr": "US", "Value": [11]}, "521": {"vr": "US", "Value": [10]}, "522": {"vr": "US", "Value": [9]}, "523": {"vr": "US", "Value": [8]}, "524": {"vr": "US", "Value": [7]}, "525": {"vr": "US", "Value": [6]}, "526": {"vr": "US", "Value": [5]}, "527": {"vr": "US", "Value": [4]}, "528": {"vr": "US", "Value": [3]}, "529": {"vr": "US", "Value": [2]}, "530": {"vr": "US", "Value": [1]}}}


collated_data = {"00291020": {"0": {"vr": "OB", "BinaryLength": 536}, "1": {"vr": "OB", "BinaryLength": 536}, "2": {"vr": "OB", "BinaryLength": 536}, "3": {"vr": "OB", "BinaryLength": 536}, "4": {"vr": "OB", "BinaryLength": 536}, "5": {"vr": "OB", "BinaryLength": 536}, "6": {"vr": "OB", "BinaryLength": 536}, "7": {"vr": "OB", "BinaryLength": 536}, "8": {"vr": "OB", "BinaryLength": 536}, "9": {"vr": "OB", "BinaryLength": 536}, "10": {"vr": "OB", "BinaryLength": 536}, "11": {"vr": "OB", "BinaryLength": 536}, "12": {"vr": "OB", "BinaryLength": 536}, "13": {"vr": "OB", "BinaryLength": 536}, "14": {"vr": "OB", "BinaryLength": 536}, "15": {"vr": "OB", "BinaryLength": 536}, "16": {"vr": "OB", "BinaryLength": 536}, "17": {"vr": "OB", "BinaryLength": 536}, "18": {"vr": "OB", "BinaryLength": 536}, "19": {"vr": "OB", "BinaryLength": 536}, "20": {"vr": "OB", "BinaryLength": 536}, "21": {"vr": "OB", "BinaryLength": 536}, "22": {"vr": "OB", "BinaryLength": 536}, "23": {"vr": "OB", "BinaryLength": 536}, "24": {"vr": "OB", "BinaryLength": 536}, "25": {"vr": "OB", "BinaryLength": 536}, "26": {"vr": "OB", "BinaryLength": 536}, "27": {"vr": "OB", "BinaryLength": 536}, "28": {"vr": "OB", "BinaryLength": 536}, "29": {"vr": "OB", "BinaryLength": 536}, "30": {"vr": "OB", "BinaryLength": 536}, "31": {"vr": "OB", "BinaryLength": 536}, "32": {"vr": "OB", "BinaryLength": 536}, "33": {"vr": "OB", "BinaryLength": 536}, "34": {"vr": "OB", "BinaryLength": 536}, "35": {"vr": "OB", "BinaryLength": 536}, "36": {"vr": "OB", "BinaryLength": 536}, "37": {"vr": "OB", "BinaryLength": 536}, "38": {"vr": "OB", "BinaryLength": 536}, "39": {"vr": "OB", "BinaryLength": 536}, "40": {"vr": "OB", "BinaryLength": 536}, "41": {"vr": "OB", "BinaryLength": 536}, "42": {"vr": "OB", "BinaryLength": 536}, "43": {"vr": "OB", "BinaryLength": 536}, "44": {"vr": "OB", "BinaryLength": 536}, "45": {"vr": "OB", "BinaryLength": 536}, "46": {"vr": "OB", "BinaryLength": 536}, "47": {"vr": "OB", "BinaryLength": 536}, "48": {"vr": "OB", "BinaryLength": 536}, "49": {"vr": "OB", "BinaryLength": 536}, "50": {"vr": "OB", "BinaryLength": 536}, "51": {"vr": "OB", "BinaryLength": 536}, "52": {"vr": "OB", "BinaryLength": 536}, "53": {"vr": "OB", "BinaryLength": 536}, "54": {"vr": "OB", "BinaryLength": 536}, "55": {"vr": "OB", "BinaryLength": 536}, "56": {"vr": "OB", "BinaryLength": 536}, "57": {"vr": "OB", "BinaryLength": 536}, "58": {"vr": "OB", "BinaryLength": 536}, "59": {"vr": "OB", "BinaryLength": 536}, "60": {"vr": "OB", "BinaryLength": 536}, "61": {"vr": "OB", "BinaryLength": 536}, "62": {"vr": "OB", "BinaryLength": 536}, "63": {"vr": "OB", "BinaryLength": 536}, "64": {"vr": "OB", "BinaryLength": 536}, "65": {"vr": "OB", "BinaryLength": 536}, "66": {"vr": "OB", "BinaryLength": 536}, "67": {"vr": "OB", "BinaryLength": 536}, "68": {"vr": "OB", "BinaryLength": 536}, "69": {"vr": "OB", "BinaryLength": 536}, "70": {"vr": "OB", "BinaryLength": 536}, "71": {"vr": "OB", "BinaryLength": 536}, "72": {"vr": "OB", "BinaryLength": 536}, "73": {"vr": "OB", "BinaryLength": 536}, "74": {"vr": "OB", "BinaryLength": 536}, "75": {"vr": "OB", "BinaryLength": 536}, "76": {"vr": "OB", "BinaryLength": 536}, "77": {"vr": "OB", "BinaryLength": 536}, "78": {"vr": "OB", "BinaryLength": 536}, "79": {"vr": "OB", "BinaryLength": 536}, "80": {"vr": "OB", "BinaryLength": 536}, "81": {"vr": "OB", "BinaryLength": 536}, "82": {"vr": "OB", "BinaryLength": 536}, "83": {"vr": "OB", "BinaryLength": 536}, "84": {"vr": "OB", "BinaryLength": 536}, "85": {"vr": "OB", "BinaryLength": 536}, "86": {"vr": "OB", "BinaryLength": 536}, "87": {"vr": "OB", "BinaryLength": 536}, "88": {"vr": "OB", "BinaryLength": 536}, "89": {"vr": "OB", "BinaryLength": 536}, "90": {"vr": "OB", "BinaryLength": 536}, "91": {"vr": "OB", "BinaryLength": 536}, "92": {"vr": "OB", "BinaryLength": 536}, "93": {"vr": "OB", "BinaryLength": 536}, "94": {"vr": "OB", "BinaryLength": 536}, "95": {"vr": "OB", "BinaryLength": 536}, "96": {"vr": "OB", "BinaryLength": 536}, "97": {"vr": "OB", "BinaryLength": 536}, "98": {"vr": "OB", "BinaryLength": 536}, "99": {"vr": "OB", "BinaryLength": 536}, "100": {"vr": "OB", "BinaryLength": 536}, "101": {"vr": "OB", "BinaryLength": 536}, "102": {"vr": "OB", "BinaryLength": 536}, "103": {"vr": "OB", "BinaryLength": 536}, "104": {"vr": "OB", "BinaryLength": 536}, "105": {"vr": "OB", "BinaryLength": 536}, "106": {"vr": "OB", "BinaryLength": 536}, "107": {"vr": "OB", "BinaryLength": 536}, "108": {"vr": "OB", "BinaryLength": 536}, "109": {"vr": "OB", "BinaryLength": 536}, "110": {"vr": "OB", "BinaryLength": 536}, "111": {"vr": "OB", "BinaryLength": 536}, "112": {"vr": "OB", "BinaryLength": 536}, "113": {"vr": "OB", "BinaryLength": 536}, "114": {"vr": "OB", "BinaryLength": 536}, "115": {"vr": "OB", "BinaryLength": 536}, "116": {"vr": "OB", "BinaryLength": 536}, "117": {"vr": "OB", "BinaryLength": 536}, "118": {"vr": "OB", "BinaryLength": 536}, "119": {"vr": "OB", "BinaryLength": 536}, "120": {"vr": "OB", "BinaryLength": 536}, "121": {"vr": "OB", "BinaryLength": 536}, "122": {"vr": "OB", "BinaryLength": 536}, "123": {"vr": "OB", "BinaryLength": 536}, "124": {"vr": "OB", "BinaryLength": 536}, "125": {"vr": "OB", "BinaryLength": 536}, "126": {"vr": "OB", "BinaryLength": 536}, "127": {"vr": "OB", "BinaryLength": 536}, "128": {"vr": "OB", "BinaryLength": 536}, "129": {"vr": "OB", "BinaryLength": 536}, "130": {"vr": "OB", "BinaryLength": 536}, "131": {"vr": "OB", "BinaryLength": 536}, "132": {"vr": "OB", "BinaryLength": 536}, "133": {"vr": "OB", "BinaryLength": 536}, "134": {"vr": "OB", "BinaryLength": 536}, "135": {"vr": "OB", "BinaryLength": 536}, "136": {"vr": "OB", "BinaryLength": 536}, "137": {"vr": "OB", "BinaryLength": 536}, "138": {"vr": "OB", "BinaryLength": 536}, "139": {"vr": "OB", "BinaryLength": 536}, "140": {"vr": "OB", "BinaryLength": 536}, "141": {"vr": "OB", "BinaryLength": 536}, "142": {"vr": "OB", "BinaryLength": 536}, "143": {"vr": "OB", "BinaryLength": 536}, "144": {"vr": "OB", "BinaryLength": 536}, "145": {"vr": "OB", "BinaryLength": 536}, "146": {"vr": "OB", "BinaryLength": 536}, "147": {"vr": "OB", "BinaryLength": 536}, "148": {"vr": "OB", "BinaryLength": 536}, "149": {"vr": "OB", "BinaryLength": 536}, "150": {"vr": "OB", "BinaryLength": 536}, "151": {"vr": "OB", "BinaryLength": 536}, "152": {"vr": "OB", "BinaryLength": 536}, "153": {"vr": "OB", "BinaryLength": 536}, "154": {"vr": "OB", "BinaryLength": 536}, "155": {"vr": "OB", "BinaryLength": 536}, "156": {"vr": "OB", "BinaryLength": 536}, "157": {"vr": "OB", "BinaryLength": 536}, "158": {"vr": "OB", "BinaryLength": 536}, "159": {"vr": "OB", "BinaryLength": 536}, "160": {"vr": "OB", "BinaryLength": 536}, "161": {"vr": "OB", "BinaryLength": 536}, "162": {"vr": "OB", "BinaryLength": 536}, "163": {"vr": "OB", "BinaryLength": 536}, "164": {"vr": "OB", "BinaryLength": 536}, "165": {"vr": "OB", "BinaryLength": 536}, "166": {"vr": "OB", "BinaryLength": 536}, "167": {"vr": "OB", "BinaryLength": 536}, "168": {"vr": "OB", "BinaryLength": 536}, "169": {"vr": "OB", "BinaryLength": 536}, "170": {"vr": "OB", "BinaryLength": 536}, "171": {"vr": "OB", "BinaryLength": 536}, "172": {"vr": "OB", "BinaryLength": 536}, "173": {"vr": "OB", "BinaryLength": 536}, "174": {"vr": "OB", "BinaryLength": 536}, "175": {"vr": "OB", "BinaryLength": 536}, "176": {"vr": "OB", "BinaryLength": 536}, "177": {"vr": "OB", "BinaryLength": 536}, "178": {"vr": "OB", "BinaryLength": 536}, "179": {"vr": "OB", "BinaryLength": 536}, "180": {"vr": "OB", "BinaryLength": 536}, "181": {"vr": "OB", "BinaryLength": 536}, "182": {"vr": "OB", "BinaryLength": 536}, "183": {"vr": "OB", "BinaryLength": 536}, "184": {"vr": "OB", "BinaryLength": 536}, "185": {"vr": "OB", "BinaryLength": 536}, "186": {"vr": "OB", "BinaryLength": 536}, "187": {"vr": "OB", "BinaryLength": 536}, "188": {"vr": "OB", "BinaryLength": 536}, "189": {"vr": "OB", "BinaryLength": 536}, "190": {"vr": "OB", "BinaryLength": 536}, "191": {"vr": "OB", "BinaryLength": 536}, "192": {"vr": "OB", "BinaryLength": 536}, "193": {"vr": "OB", "BinaryLength": 536}, "194": {"vr": "OB", "BinaryLength": 536}, "195": {"vr": "OB", "BinaryLength": 536}, "196": {"vr": "OB", "BinaryLength": 536}, "197": {"vr": "OB", "BinaryLength": 536}, "198": {"vr": "OB", "BinaryLength": 536}, "199": {"vr": "OB", "BinaryLength": 536}, "200": {"vr": "OB", "BinaryLength": 536}, "201": {"vr": "OB", "BinaryLength": 536}, "202": {"vr": "OB", "BinaryLength": 536}, "203": {"vr": "OB", "BinaryLength": 536}, "204": {"vr": "OB", "BinaryLength": 536}, "205": {"vr": "OB", "BinaryLength": 536}, "206": {"vr": "OB", "BinaryLength": 536}, "207": {"vr": "OB", "BinaryLength": 536}, "208": {"vr": "OB", "BinaryLength": 536}, "209": {"vr": "OB", "BinaryLength": 536}, "210": {"vr": "OB", "BinaryLength": 536}, "211": {"vr": "OB", "BinaryLength": 536}, "212": {"vr": "OB", "BinaryLength": 536}, "213": {"vr": "OB", "BinaryLength": 536}, "214": {"vr": "OB", "BinaryLength": 536}, "215": {"vr": "OB", "BinaryLength": 536}, "216": {"vr": "OB", "BinaryLength": 536}, "217": {"vr": "OB", "BinaryLength": 536}, "218": {"vr": "OB", "BinaryLength": 536}, "219": {"vr": "OB", "BinaryLength": 536}, "220": {"vr": "OB", "BinaryLength": 536}, "221": {"vr": "OB", "BinaryLength": 536}, "222": {"vr": "OB", "BinaryLength": 536}, "223": {"vr": "OB", "BinaryLength": 536}, "224": {"vr": "OB", "BinaryLength": 536}, "225": {"vr": "OB", "BinaryLength": 536}, "226": {"vr": "OB", "BinaryLength": 536}, "227": {"vr": "OB", "BinaryLength": 536}, "228": {"vr": "OB", "BinaryLength": 536}, "229": {"vr": "OB", "BinaryLength": 536}, "230": {"vr": "OB", "BinaryLength": 536}, "231": {"vr": "OB", "BinaryLength": 536}, "232": {"vr": "OB", "BinaryLength": 536}, "233": {"vr": "OB", "BinaryLength": 536}, "234": {"vr": "OB", "BinaryLength": 536}, "235": {"vr": "OB", "BinaryLength": 536}, "236": {"vr": "OB", "BinaryLength": 536}, "237": {"vr": "OB", "BinaryLength": 536}, "238": {"vr": "OB", "BinaryLength": 536}, "239": {"vr": "OB", "BinaryLength": 536}, "240": {"vr": "OB", "BinaryLength": 536}, "241": {"vr": "OB", "BinaryLength": 536}, "242": {"vr": "OB", "BinaryLength": 536}, "243": {"vr": "OB", "BinaryLength": 536}, "244": {"vr": "OB", "BinaryLength": 536}, "245": {"vr": "OB", "BinaryLength": 536}, "246": {"vr": "OB", "BinaryLength": 536}, "247": {"vr": "OB", "BinaryLength": 536}, "248": {"vr": "OB", "BinaryLength": 536}, "249": {"vr": "OB", "BinaryLength": 536}, "250": {"vr": "OB", "BinaryLength": 536}, "251": {"vr": "OB", "BinaryLength": 536}, "252": {"vr": "OB", "BinaryLength": 536}, "253": {"vr": "OB", "BinaryLength": 536}, "254": {"vr": "OB", "BinaryLength": 536}, "255": {"vr": "OB", "BinaryLength": 536}, "256": {"vr": "OB", "BinaryLength": 536}, "257": {"vr": "OB", "BinaryLength": 536}, "258": {"vr": "OB", "BinaryLength": 536}, "259": {"vr": "OB", "BinaryLength": 536}, "260": {"vr": "OB", "BinaryLength": 536}, "261": {"vr": "OB", "BinaryLength": 536}, "262": {"vr": "OB", "BinaryLength": 536}, "263": {"vr": "OB", "BinaryLength": 536}, "264": {"vr": "OB", "BinaryLength": 536}, "265": {"vr": "OB", "BinaryLength": 536}, "266": {"vr": "OB", "BinaryLength": 536}, "267": {"vr": "OB", "BinaryLength": 536}, "268": {"vr": "OB", "BinaryLength": 536}, "269": {"vr": "OB", "BinaryLength": 536}, "270": {"vr": "OB", "BinaryLength": 536}, "271": {"vr": "OB", "BinaryLength": 536}, "272": {"vr": "OB", "BinaryLength": 536}, "273": {"vr": "OB", "BinaryLength": 536}, "274": {"vr": "OB", "BinaryLength": 536}, "275": {"vr": "OB", "BinaryLength": 536}, "276": {"vr": "OB", "BinaryLength": 536}, "277": {"vr": "OB", "BinaryLength": 536}, "278": {"vr": "OB", "BinaryLength": 536}, "279": {"vr": "OB", "BinaryLength": 536}, "280": {"vr": "OB", "BinaryLength": 536}, "281": {"vr": "OB", "BinaryLength": 536}, "282": {"vr": "OB", "BinaryLength": 536}, "283": {"vr": "OB", "BinaryLength": 536}, "284": {"vr": "OB", "BinaryLength": 536}, "285": {"vr": "OB", "BinaryLength": 536}, "286": {"vr": "OB", "BinaryLength": 536}, "287": {"vr": "OB", "BinaryLength": 536}, "288": {"vr": "OB", "BinaryLength": 536}, "289": {"vr": "OB", "BinaryLength": 536}, "290": {"vr": "OB", "BinaryLength": 536}, "291": {"vr": "OB", "BinaryLength": 536}, "292": {"vr": "OB", "BinaryLength": 536}, "293": {"vr": "OB", "BinaryLength": 536}, "294": {"vr": "OB", "BinaryLength": 536}, "295": {"vr": "OB", "BinaryLength": 536}, "296": {"vr": "OB", "BinaryLength": 536}, "297": {"vr": "OB", "BinaryLength": 536}, "298": {"vr": "OB", "BinaryLength": 536}, "299": {"vr": "OB", "BinaryLength": 536}, "300": {"vr": "OB", "BinaryLength": 536}, "301": {"vr": "OB", "BinaryLength": 536}, "302": {"vr": "OB", "BinaryLength": 536}, "303": {"vr": "OB", "BinaryLength": 536}, "304": {"vr": "OB", "BinaryLength": 536}, "305": {"vr": "OB", "BinaryLength": 536}, "306": {"vr": "OB", "BinaryLength": 536}, "307": {"vr": "OB", "BinaryLength": 536}, "308": {"vr": "OB", "BinaryLength": 536}, "309": {"vr": "OB", "BinaryLength": 536}, "310": {"vr": "OB", "BinaryLength": 536}, "311": {"vr": "OB", "BinaryLength": 536}, "312": {"vr": "OB", "BinaryLength": 536}, "313": {"vr": "OB", "BinaryLength": 536}, "314": {"vr": "OB", "BinaryLength": 536}, "315": {"vr": "OB", "BinaryLength": 536}, "316": {"vr": "OB", "BinaryLength": 536}, "317": {"vr": "OB", "BinaryLength": 536}, "318": {"vr": "OB", "BinaryLength": 536}, "319": {"vr": "OB", "BinaryLength": 536}, "320": {"vr": "OB", "BinaryLength": 536}, "321": {"vr": "OB", "BinaryLength": 536}, "322": {"vr": "OB", "BinaryLength": 536}, "323": {"vr": "OB", "BinaryLength": 536}, "324": {"vr": "OB", "BinaryLength": 536}, "325": {"vr": "OB", "BinaryLength": 536}, "326": {"vr": "OB", "BinaryLength": 536}, "327": {"vr": "OB", "BinaryLength": 536}, "328": {"vr": "OB", "BinaryLength": 536}, "329": {"vr": "OB", "BinaryLength": 536}, "330": {"vr": "OB", "BinaryLength": 536}, "331": {"vr": "OB", "BinaryLength": 536}, "332": {"vr": "OB", "BinaryLength": 536}, "333": {"vr": "OB", "BinaryLength": 536}, "334": {"vr": "OB", "BinaryLength": 536}, "335": {"vr": "OB", "BinaryLength": 536}, "336": {"vr": "OB", "BinaryLength": 536}, "337": {"vr": "OB", "BinaryLength": 536}, "338": {"vr": "OB", "BinaryLength": 536}, "339": {"vr": "OB", "BinaryLength": 536}, "340": {"vr": "OB", "BinaryLength": 536}, "341": {"vr": "OB", "BinaryLength": 536}, "342": {"vr": "OB", "BinaryLength": 536}, "343": {"vr": "OB", "BinaryLength": 536}, "344": {"vr": "OB", "BinaryLength": 536}, "345": {"vr": "OB", "BinaryLength": 536}, "346": {"vr": "OB", "BinaryLength": 536}, "347": {"vr": "OB", "BinaryLength": 536}, "348": {"vr": "OB", "BinaryLength": 536}, "349": {"vr": "OB", "BinaryLength": 536}, "350": {"vr": "OB", "BinaryLength": 536}, "351": {"vr": "OB", "BinaryLength": 536}, "352": {"vr": "OB", "BinaryLength": 536}, "353": {"vr": "OB", "BinaryLength": 536}, "354": {"vr": "OB", "BinaryLength": 536}, "355": {"vr": "OB", "BinaryLength": 536}, "356": {"vr": "OB", "BinaryLength": 536}, "357": {"vr": "OB", "BinaryLength": 536}, "358": {"vr": "OB", "BinaryLength": 536}, "359": {"vr": "OB", "BinaryLength": 536}, "360": {"vr": "OB", "BinaryLength": 536}, "361": {"vr": "OB", "BinaryLength": 536}, "362": {"vr": "OB", "BinaryLength": 536}, "363": {"vr": "OB", "BinaryLength": 536}, "364": {"vr": "OB", "BinaryLength": 536}, "365": {"vr": "OB", "BinaryLength": 536}, "366": {"vr": "OB", "BinaryLength": 536}, "367": {"vr": "OB", "BinaryLength": 536}, "368": {"vr": "OB", "BinaryLength": 536}, "369": {"vr": "OB", "BinaryLength": 536}, "370": {"vr": "OB", "BinaryLength": 536}, "371": {"vr": "OB", "BinaryLength": 536}, "372": {"vr": "OB", "BinaryLength": 536}, "373": {"vr": "OB", "BinaryLength": 536}, "374": {"vr": "OB", "BinaryLength": 536}, "375": {"vr": "OB", "BinaryLength": 536}, "376": {"vr": "OB", "BinaryLength": 536}, "377": {"vr": "OB", "BinaryLength": 536}, "378": {"vr": "OB", "BinaryLength": 536}, "379": {"vr": "OB", "BinaryLength": 536}, "380": {"vr": "OB", "BinaryLength": 536}, "381": {"vr": "OB", "BinaryLength": 536}, "382": {"vr": "OB", "BinaryLength": 536}, "383": {"vr": "OB", "BinaryLength": 536}, "384": {"vr": "OB", "BinaryLength": 536}, "385": {"vr": "OB", "BinaryLength": 536}, "386": {"vr": "OB", "BinaryLength": 536}, "387": {"vr": "OB", "BinaryLength": 536}, "388": {"vr": "OB", "BinaryLength": 536}, "389": {"vr": "OB", "BinaryLength": 536}, "390": {"vr": "OB", "BinaryLength": 536}, "391": {"vr": "OB", "BinaryLength": 536}, "392": {"vr": "OB", "BinaryLength": 536}, "393": {"vr": "OB", "BinaryLength": 536}, "394": {"vr": "OB", "BinaryLength": 536}, "395": {"vr": "OB", "BinaryLength": 536}, "396": {"vr": "OB", "BinaryLength": 536}, "397": {"vr": "OB", "BinaryLength": 536}, "398": {"vr": "OB", "BinaryLength": 536}, "399": {"vr": "OB", "BinaryLength": 536}, "400": {"vr": "OB", "BinaryLength": 536}, "401": {"vr": "OB", "BinaryLength": 536}, "402": {"vr": "OB", "BinaryLength": 536}, "403": {"vr": "OB", "BinaryLength": 536}, "404": {"vr": "OB", "BinaryLength": 536}, "405": {"vr": "OB", "BinaryLength": 536}, "406": {"vr": "OB", "BinaryLength": 536}, "407": {"vr": "OB", "BinaryLength": 536}, "408": {"vr": "OB", "BinaryLength": 536}, "409": {"vr": "OB", "BinaryLength": 536}, "410": {"vr": "OB", "BinaryLength": 536}, "411": {"vr": "OB", "BinaryLength": 536}, "412": {"vr": "OB", "BinaryLength": 536}, "413": {"vr": "OB", "BinaryLength": 536}, "414": {"vr": "OB", "BinaryLength": 536}, "415": {"vr": "OB", "BinaryLength": 536}, "416": {"vr": "OB", "BinaryLength": 536}, "417": {"vr": "OB", "BinaryLength": 536}, "418": {"vr": "OB", "BinaryLength": 536}, "419": {"vr": "OB", "BinaryLength": 536}, "420": {"vr": "OB", "BinaryLength": 536}, "421": {"vr": "OB", "BinaryLength": 536}, "422": {"vr": "OB", "BinaryLength": 536}, "423": {"vr": "OB", "BinaryLength": 536}, "424": {"vr": "OB", "BinaryLength": 536}, "425": {"vr": "OB", "BinaryLength": 536}, "426": {"vr": "OB", "BinaryLength": 536}, "427": {"vr": "OB", "BinaryLength": 536}, "428": {"vr": "OB", "BinaryLength": 536}, "429": {"vr": "OB", "BinaryLength": 536}, "430": {"vr": "OB", "BinaryLength": 536}, "431": {"vr": "OB", "BinaryLength": 536}, "432": {"vr": "OB", "BinaryLength": 536}, "433": {"vr": "OB", "BinaryLength": 536}, "434": {"vr": "OB", "BinaryLength": 536}, "435": {"vr": "OB", "BinaryLength": 536}, "436": {"vr": "OB", "BinaryLength": 536}, "437": {"vr": "OB", "BinaryLength": 536}, "438": {"vr": "OB", "BinaryLength": 536}, "439": {"vr": "OB", "BinaryLength": 536}, "440": {"vr": "OB", "BinaryLength": 536}, "441": {"vr": "OB", "BinaryLength": 536}, "442": {"vr": "OB", "BinaryLength": 536}, "443": {"vr": "OB", "BinaryLength": 536}, "444": {"vr": "OB", "BinaryLength": 536}, "445": {"vr": "OB", "BinaryLength": 536}, "446": {"vr": "OB", "BinaryLength": 536}, "447": {"vr": "OB", "BinaryLength": 536}, "448": {"vr": "OB", "BinaryLength": 536}, "449": {"vr": "OB", "BinaryLength": 536}, "450": {"vr": "OB", "BinaryLength": 536}, "451": {"vr": "OB", "BinaryLength": 536}, "452": {"vr": "OB", "BinaryLength": 536}, "453": {"vr": "OB", "BinaryLength": 536}, "454": {"vr": "OB", "BinaryLength": 536}, "455": {"vr": "OB", "BinaryLength": 536}, "456": {"vr": "OB", "BinaryLength": 536}, "457": {"vr": "OB", "BinaryLength": 536}, "458": {"vr": "OB", "BinaryLength": 536}, "459": {"vr": "OB", "BinaryLength": 536}, "460": {"vr": "OB", "BinaryLength": 536}, "461": {"vr": "OB", "BinaryLength": 536}, "462": {"vr": "OB", "BinaryLength": 536}, "463": {"vr": "OB", "BinaryLength": 536}, "464": {"vr": "OB", "BinaryLength": 536}, "465": {"vr": "OB", "BinaryLength": 536}, "466": {"vr": "OB", "BinaryLength": 536}, "467": {"vr": "OB", "BinaryLength": 536}, "468": {"vr": "OB", "BinaryLength": 536}, "469": {"vr": "OB", "BinaryLength": 536}, "470": {"vr": "OB", "BinaryLength": 536}, "471": {"vr": "OB", "BinaryLength": 536}, "472": {"vr": "OB", "BinaryLength": 536}, "473": {"vr": "OB", "BinaryLength": 536}, "474": {"vr": "OB", "BinaryLength": 536}, "475": {"vr": "OB", "BinaryLength": 536}, "476": {"vr": "OB", "BinaryLength": 536}, "477": {"vr": "OB", "BinaryLength": 536}, "478": {"vr": "OB", "BinaryLength": 536}, "479": {"vr": "OB", "BinaryLength": 536}, "480": {"vr": "OB", "BinaryLength": 536}, "481": {"vr": "OB", "BinaryLength": 536}, "482": {"vr": "OB", "BinaryLength": 536}, "483": {"vr": "OB", "BinaryLength": 536}, "484": {"vr": "OB", "BinaryLength": 536}, "485": {"vr": "OB", "BinaryLength": 536}, "486": {"vr": "OB", "BinaryLength": 536}, "487": {"vr": "OB", "BinaryLength": 536}, "488": {"vr": "OB", "BinaryLength": 536}, "489": {"vr": "OB", "BinaryLength": 536}, "490": {"vr": "OB", "BinaryLength": 536}, "491": {"vr": "OB", "BinaryLength": 536}, "492": {"vr": "OB", "BinaryLength": 536}, "493": {"vr": "OB", "BinaryLength": 536}, "494": {"vr": "OB", "BinaryLength": 536}, "495": {"vr": "OB", "BinaryLength": 536}, "496": {"vr": "OB", "BinaryLength": 536}, "497": {"vr": "OB", "BinaryLength": 536}, "498": {"vr": "OB", "BinaryLength": 536}, "499": {"vr": "OB", "BinaryLength": 536}, "500": {"vr": "OB", "BinaryLength": 536}, "501": {"vr": "OB", "BinaryLength": 536}, "502": {"vr": "OB", "BinaryLength": 536}, "503": {"vr": "OB", "BinaryLength": 536}, "504": {"vr": "OB", "BinaryLength": 536}, "505": {"vr": "OB", "BinaryLength": 536}, "506": {"vr": "OB", "BinaryLength": 536}, "507": {"vr": "OB", "BinaryLength": 536}, "508": {"vr": "OB", "BinaryLength": 536}, "509": {"vr": "OB", "BinaryLength": 536}, "510": {"vr": "OB", "BinaryLength": 536}, "511": {"vr": "OB", "BinaryLength": 536}, "512": {"vr": "OB", "BinaryLength": 536}, "513": {"vr": "OB", "BinaryLength": 536}, "514": {"vr": "OB", "BinaryLength": 536}, "515": {"vr": "OB", "BinaryLength": 536}, "516": {"vr": "OB", "BinaryLength": 536}, "517": {"vr": "OB", "BinaryLength": 536}, "518": {"vr": "OB", "BinaryLength": 536}, "519": {"vr": "OB", "BinaryLength": 536}, "520": {"vr": "OB", "BinaryLength": 536}, "521": {"vr": "OB", "BinaryLength": 536}, "522": {"vr": "OB", "BinaryLength": 536}, "523": {"vr": "OB", "BinaryLength": 536}, "524": {"vr": "OB", "BinaryLength": 536}, "525": {"vr": "OB", "BinaryLength": 536}, "526": {"vr": "OB", "BinaryLength": 536}, "527": {"vr": "OB", "BinaryLength": 536}, "528": {"vr": "OB", "BinaryLength": 536}, "529": {"vr": "OB", "BinaryLength": 536}, "530": {"vr": "OB", "BinaryLength": 536}}, "7FE00010": {"0": {"vr": "OW", "BinaryLength": 516268}, "1": {"vr": "OW", "BinaryLength": 516268}, "2": {"vr": "OW", "BinaryLength": 516268}, "3": {"vr": "OW", "BinaryLength": 516268}, "4": {"vr": "OW", "BinaryLength": 516268}, "5": {"vr": "OW", "BinaryLength": 516268}, "6": {"vr": "OW", "BinaryLength": 516268}, "7": {"vr": "OW", "BinaryLength": 516268}, "8": {"vr": "OW", "BinaryLength": 516268}, "9": {"vr": "OW", "BinaryLength": 516268}, "10": {"vr": "OW", "BinaryLength": 516268}, "11": {"vr": "OW", "BinaryLength": 516268}, "12": {"vr": "OW", "BinaryLength": 516268}, "13": {"vr": "OW", "BinaryLength": 516268}, "14": {"vr": "OW", "BinaryLength": 516268}, "15": {"vr": "OW", "BinaryLength": 516268}, "16": {"vr": "OW", "BinaryLength": 516268}, "17": {"vr": "OW", "BinaryLength": 516268}, "18": {"vr": "OW", "BinaryLength": 516268}, "19": {"vr": "OW", "BinaryLength": 516268}, "20": {"vr": "OW", "BinaryLength": 516268}, "21": {"vr": "OW", "BinaryLength": 516268}, "22": {"vr": "OW", "BinaryLength": 516268}, "23": {"vr": "OW", "BinaryLength": 516268}, "24": {"vr": "OW", "BinaryLength": 516268}, "25": {"vr": "OW", "BinaryLength": 516268}, "26": {"vr": "OW", "BinaryLength": 516268}, "27": {"vr": "OW", "BinaryLength": 516268}, "28": {"vr": "OW", "BinaryLength": 516268}, "29": {"vr": "OW", "BinaryLength": 516268}, "30": {"vr": "OW", "BinaryLength": 516268}, "31": {"vr": "OW", "BinaryLength": 516268}, "32": {"vr": "OW", "BinaryLength": 516268}, "33": {"vr": "OW", "BinaryLength": 516268}, "34": {"vr": "OW", "BinaryLength": 516268}, "35": {"vr": "OW", "BinaryLength": 516268}, "36": {"vr": "OW", "BinaryLength": 516268}, "37": {"vr": "OW", "BinaryLength": 516268}, "38": {"vr": "OW", "BinaryLength": 516268}, "39": {"vr": "OW", "BinaryLength": 516268}, "40": {"vr": "OW", "BinaryLength": 516268}, "41": {"vr": "OW", "BinaryLength": 516268}, "42": {"vr": "OW", "BinaryLength": 516268}, "43": {"vr": "OW", "BinaryLength": 516268}, "44": {"vr": "OW", "BinaryLength": 516268}, "45": {"vr": "OW", "BinaryLength": 516268}, "46": {"vr": "OW", "BinaryLength": 516268}, "47": {"vr": "OW", "BinaryLength": 516268}, "48": {"vr": "OW", "BinaryLength": 516268}, "49": {"vr": "OW", "BinaryLength": 516268}, "50": {"vr": "OW", "BinaryLength": 516268}, "51": {"vr": "OW", "BinaryLength": 516268}, "52": {"vr": "OW", "BinaryLength": 516268}, "53": {"vr": "OW", "BinaryLength": 516268}, "54": {"vr": "OW", "BinaryLength": 516268}, "55": {"vr": "OW", "BinaryLength": 516268}, "56": {"vr": "OW", "BinaryLength": 516268}, "57": {"vr": "OW", "BinaryLength": 516268}, "58": {"vr": "OW", "BinaryLength": 516268}, "59": {"vr": "OW", "BinaryLength": 516268}, "60": {"vr": "OW", "BinaryLength": 516268}, "61": {"vr": "OW", "BinaryLength": 516268}, "62": {"vr": "OW", "BinaryLength": 516268}, "63": {"vr": "OW", "BinaryLength": 516268}, "64": {"vr": "OW", "BinaryLength": 516268}, "65": {"vr": "OW", "BinaryLength": 516268}, "66": {"vr": "OW", "BinaryLength": 516268}, "67": {"vr": "OW", "BinaryLength": 516268}, "68": {"vr": "OW", "BinaryLength": 516268}, "69": {"vr": "OW", "BinaryLength": 516268}, "70": {"vr": "OW", "BinaryLength": 516268}, "71": {"vr": "OW", "BinaryLength": 516268}, "72": {"vr": "OW", "BinaryLength": 516268}, "73": {"vr": "OW", "BinaryLength": 516268}, "74": {"vr": "OW", "BinaryLength": 516268}, "75": {"vr": "OW", "BinaryLength": 516268}, "76": {"vr": "OW", "BinaryLength": 516268}, "77": {"vr": "OW", "BinaryLength": 516268}, "78": {"vr": "OW", "BinaryLength": 516268}, "79": {"vr": "OW", "BinaryLength": 516268}, "80": {"vr": "OW", "BinaryLength": 516268}, "81": {"vr": "OW", "BinaryLength": 516268}, "82": {"vr": "OW", "BinaryLength": 516268}, "83": {"vr": "OW", "BinaryLength": 516268}, "84": {"vr": "OW", "BinaryLength": 516268}, "85": {"vr": "OW", "BinaryLength": 516268}, "86": {"vr": "OW", "BinaryLength": 516268}, "87": {"vr": "OW", "BinaryLength": 516268}, "88": {"vr": "OW", "BinaryLength": 516268}, "89": {"vr": "OW", "BinaryLength": 516268}, "90": {"vr": "OW", "BinaryLength": 516268}, "91": {"vr": "OW", "BinaryLength": 516268}, "92": {"vr": "OW", "BinaryLength": 516268}, "93": {"vr": "OW", "BinaryLength": 516268}, "94": {"vr": "OW", "BinaryLength": 516268}, "95": {"vr": "OW", "BinaryLength": 516268}, "96": {"vr": "OW", "BinaryLength": 516268}, "97": {"vr": "OW", "BinaryLength": 516268}, "98": {"vr": "OW", "BinaryLength": 516268}, "99": {"vr": "OW", "BinaryLength": 516268}, "100": {"vr": "OW", "BinaryLength": 516268}, "101": {"vr": "OW", "BinaryLength": 516268}, "102": {"vr": "OW", "BinaryLength": 516268}, "103": {"vr": "OW", "BinaryLength": 516268}, "104": {"vr": "OW", "BinaryLength": 516268}, "105": {"vr": "OW", "BinaryLength": 516268}, "106": {"vr": "OW", "BinaryLength": 516268}, "107": {"vr": "OW", "BinaryLength": 516268}, "108": {"vr": "OW", "BinaryLength": 516268}, "109": {"vr": "OW", "BinaryLength": 516268}, "110": {"vr": "OW", "BinaryLength": 516268}, "111": {"vr": "OW", "BinaryLength": 516268}, "112": {"vr": "OW", "BinaryLength": 516268}, "113": {"vr": "OW", "BinaryLength": 516268}, "114": {"vr": "OW", "BinaryLength": 516268}, "115": {"vr": "OW", "BinaryLength": 516268}, "116": {"vr": "OW", "BinaryLength": 516268}, "117": {"vr": "OW", "BinaryLength": 516268}, "118": {"vr": "OW", "BinaryLength": 516268}, "119": {"vr": "OW", "BinaryLength": 516268}, "120": {"vr": "OW", "BinaryLength": 516268}, "121": {"vr": "OW", "BinaryLength": 516268}, "122": {"vr": "OW", "BinaryLength": 516268}, "123": {"vr": "OW", "BinaryLength": 516268}, "124": {"vr": "OW", "BinaryLength": 516268}, "125": {"vr": "OW", "BinaryLength": 516268}, "126": {"vr": "OW", "BinaryLength": 516268}, "127": {"vr": "OW", "BinaryLength": 516268}, "128": {"vr": "OW", "BinaryLength": 516268}, "129": {"vr": "OW", "BinaryLength": 516268}, "130": {"vr": "OW", "BinaryLength": 516268}, "131": {"vr": "OW", "BinaryLength": 516268}, "132": {"vr": "OW", "BinaryLength": 516268}, "133": {"vr": "OW", "BinaryLength": 516268}, "134": {"vr": "OW", "BinaryLength": 516268}, "135": {"vr": "OW", "BinaryLength": 516268}, "136": {"vr": "OW", "BinaryLength": 516268}, "137": {"vr": "OW", "BinaryLength": 516268}, "138": {"vr": "OW", "BinaryLength": 516268}, "139": {"vr": "OW", "BinaryLength": 516268}, "140": {"vr": "OW", "BinaryLength": 516268}, "141": {"vr": "OW", "BinaryLength": 516268}, "142": {"vr": "OW", "BinaryLength": 516268}, "143": {"vr": "OW", "BinaryLength": 516268}, "144": {"vr": "OW", "BinaryLength": 516268}, "145": {"vr": "OW", "BinaryLength": 516268}, "146": {"vr": "OW", "BinaryLength": 516268}, "147": {"vr": "OW", "BinaryLength": 516268}, "148": {"vr": "OW", "BinaryLength": 516268}, "149": {"vr": "OW", "BinaryLength": 516268}, "150": {"vr": "OW", "BinaryLength": 516268}, "151": {"vr": "OW", "BinaryLength": 516268}, "152": {"vr": "OW", "BinaryLength": 516268}, "153": {"vr": "OW", "BinaryLength": 516268}, "154": {"vr": "OW", "BinaryLength": 516268}, "155": {"vr": "OW", "BinaryLength": 516268}, "156": {"vr": "OW", "BinaryLength": 516268}, "157": {"vr": "OW", "BinaryLength": 516268}, "158": {"vr": "OW", "BinaryLength": 516268}, "159": {"vr": "OW", "BinaryLength": 516268}, "160": {"vr": "OW", "BinaryLength": 516268}, "161": {"vr": "OW", "BinaryLength": 516268}, "162": {"vr": "OW", "BinaryLength": 516268}, "163": {"vr": "OW", "BinaryLength": 516268}, "164": {"vr": "OW", "BinaryLength": 516268}, "165": {"vr": "OW", "BinaryLength": 516268}, "166": {"vr": "OW", "BinaryLength": 516268}, "167": {"vr": "OW", "BinaryLength": 516268}, "168": {"vr": "OW", "BinaryLength": 516268}, "169": {"vr": "OW", "BinaryLength": 516268}, "170": {"vr": "OW", "BinaryLength": 516268}, "171": {"vr": "OW", "BinaryLength": 516268}, "172": {"vr": "OW", "BinaryLength": 516268}, "173": {"vr": "OW", "BinaryLength": 516268}, "174": {"vr": "OW", "BinaryLength": 516268}, "175": {"vr": "OW", "BinaryLength": 516268}, "176": {"vr": "OW", "BinaryLength": 516268}, "177": {"vr": "OW", "BinaryLength": 516268}, "178": {"vr": "OW", "BinaryLength": 516268}, "179": {"vr": "OW", "BinaryLength": 516268}, "180": {"vr": "OW", "BinaryLength": 516268}, "181": {"vr": "OW", "BinaryLength": 516268}, "182": {"vr": "OW", "BinaryLength": 516268}, "183": {"vr": "OW", "BinaryLength": 516268}, "184": {"vr": "OW", "BinaryLength": 516268}, "185": {"vr": "OW", "BinaryLength": 516268}, "186": {"vr": "OW", "BinaryLength": 516268}, "187": {"vr": "OW", "BinaryLength": 516268}, "188": {"vr": "OW", "BinaryLength": 516268}, "189": {"vr": "OW", "BinaryLength": 516268}, "190": {"vr": "OW", "BinaryLength": 516268}, "191": {"vr": "OW", "BinaryLength": 516268}, "192": {"vr": "OW", "BinaryLength": 516268}, "193": {"vr": "OW", "BinaryLength": 516268}, "194": {"vr": "OW", "BinaryLength": 516268}, "195": {"vr": "OW", "BinaryLength": 516268}, "196": {"vr": "OW", "BinaryLength": 516268}, "197": {"vr": "OW", "BinaryLength": 516268}, "198": {"vr": "OW", "BinaryLength": 516268}, "199": {"vr": "OW", "BinaryLength": 516268}, "200": {"vr": "OW", "BinaryLength": 516268}, "201": {"vr": "OW", "BinaryLength": 516268}, "202": {"vr": "OW", "BinaryLength": 516268}, "203": {"vr": "OW", "BinaryLength": 516268}, "204": {"vr": "OW", "BinaryLength": 516268}, "205": {"vr": "OW", "BinaryLength": 516268}, "206": {"vr": "OW", "BinaryLength": 516268}, "207": {"vr": "OW", "BinaryLength": 516268}, "208": {"vr": "OW", "BinaryLength": 516268}, "209": {"vr": "OW", "BinaryLength": 516268}, "210": {"vr": "OW", "BinaryLength": 516268}, "211": {"vr": "OW", "BinaryLength": 516268}, "212": {"vr": "OW", "BinaryLength": 516268}, "213": {"vr": "OW", "BinaryLength": 516268}, "214": {"vr": "OW", "BinaryLength": 516268}, "215": {"vr": "OW", "BinaryLength": 516268}, "216": {"vr": "OW", "BinaryLength": 516268}, "217": {"vr": "OW", "BinaryLength": 516268}, "218": {"vr": "OW", "BinaryLength": 516268}, "219": {"vr": "OW", "BinaryLength": 516268}, "220": {"vr": "OW", "BinaryLength": 516268}, "221": {"vr": "OW", "BinaryLength": 516268}, "222": {"vr": "OW", "BinaryLength": 516268}, "223": {"vr": "OW", "BinaryLength": 516268}, "224": {"vr": "OW", "BinaryLength": 516268}, "225": {"vr": "OW", "BinaryLength": 516268}, "226": {"vr": "OW", "BinaryLength": 516268}, "227": {"vr": "OW", "BinaryLength": 516268}, "228": {"vr": "OW", "BinaryLength": 516268}, "229": {"vr": "OW", "BinaryLength": 516268}, "230": {"vr": "OW", "BinaryLength": 516268}, "231": {"vr": "OW", "BinaryLength": 516268}, "232": {"vr": "OW", "BinaryLength": 516268}, "233": {"vr": "OW", "BinaryLength": 516268}, "234": {"vr": "OW", "BinaryLength": 516268}, "235": {"vr": "OW", "BinaryLength": 516268}, "236": {"vr": "OW", "BinaryLength": 516268}, "237": {"vr": "OW", "BinaryLength": 516268}, "238": {"vr": "OW", "BinaryLength": 516268}, "239": {"vr": "OW", "BinaryLength": 516268}, "240": {"vr": "OW", "BinaryLength": 516268}, "241": {"vr": "OW", "BinaryLength": 516268}, "242": {"vr": "OW", "BinaryLength": 516268}, "243": {"vr": "OW", "BinaryLength": 516268}, "244": {"vr": "OW", "BinaryLength": 516268}, "245": {"vr": "OW", "BinaryLength": 516268}, "246": {"vr": "OW", "BinaryLength": 516268}, "247": {"vr": "OW", "BinaryLength": 516268}, "248": {"vr": "OW", "BinaryLength": 516268}, "249": {"vr": "OW", "BinaryLength": 516268}, "250": {"vr": "OW", "BinaryLength": 516268}, "251": {"vr": "OW", "BinaryLength": 516268}, "252": {"vr": "OW", "BinaryLength": 516268}, "253": {"vr": "OW", "BinaryLength": 516268}, "254": {"vr": "OW", "BinaryLength": 516268}, "255": {"vr": "OW", "BinaryLength": 516268}, "256": {"vr": "OW", "BinaryLength": 516268}, "257": {"vr": "OW", "BinaryLength": 516268}, "258": {"vr": "OW", "BinaryLength": 516268}, "259": {"vr": "OW", "BinaryLength": 516268}, "260": {"vr": "OW", "BinaryLength": 516268}, "261": {"vr": "OW", "BinaryLength": 516268}, "262": {"vr": "OW", "BinaryLength": 516268}, "263": {"vr": "OW", "BinaryLength": 516268}, "264": {"vr": "OW", "BinaryLength": 516268}, "265": {"vr": "OW", "BinaryLength": 516268}, "266": {"vr": "OW", "BinaryLength": 516268}, "267": {"vr": "OW", "BinaryLength": 516268}, "268": {"vr": "OW", "BinaryLength": 516268}, "269": {"vr": "OW", "BinaryLength": 516268}, "270": {"vr": "OW", "BinaryLength": 516268}, "271": {"vr": "OW", "BinaryLength": 516268}, "272": {"vr": "OW", "BinaryLength": 516268}, "273": {"vr": "OW", "BinaryLength": 516268}, "274": {"vr": "OW", "BinaryLength": 516268}, "275": {"vr": "OW", "BinaryLength": 516268}, "276": {"vr": "OW", "BinaryLength": 516268}, "277": {"vr": "OW", "BinaryLength": 516268}, "278": {"vr": "OW", "BinaryLength": 516268}, "279": {"vr": "OW", "BinaryLength": 516268}, "280": {"vr": "OW", "BinaryLength": 516268}, "281": {"vr": "OW", "BinaryLength": 516268}, "282": {"vr": "OW", "BinaryLength": 516268}, "283": {"vr": "OW", "BinaryLength": 516268}, "284": {"vr": "OW", "BinaryLength": 516268}, "285": {"vr": "OW", "BinaryLength": 516268}, "286": {"vr": "OW", "BinaryLength": 516268}, "287": {"vr": "OW", "BinaryLength": 516268}, "288": {"vr": "OW", "BinaryLength": 516268}, "289": {"vr": "OW", "BinaryLength": 516268}, "290": {"vr": "OW", "BinaryLength": 516268}, "291": {"vr": "OW", "BinaryLength": 516268}, "292": {"vr": "OW", "BinaryLength": 516268}, "293": {"vr": "OW", "BinaryLength": 516268}, "294": {"vr": "OW", "BinaryLength": 516268}, "295": {"vr": "OW", "BinaryLength": 516268}, "296": {"vr": "OW", "BinaryLength": 516268}, "297": {"vr": "OW", "BinaryLength": 516268}, "298": {"vr": "OW", "BinaryLength": 516268}, "299": {"vr": "OW", "BinaryLength": 516268}, "300": {"vr": "OW", "BinaryLength": 516268}, "301": {"vr": "OW", "BinaryLength": 516268}, "302": {"vr": "OW", "BinaryLength": 516268}, "303": {"vr": "OW", "BinaryLength": 516268}, "304": {"vr": "OW", "BinaryLength": 516268}, "305": {"vr": "OW", "BinaryLength": 516268}, "306": {"vr": "OW", "BinaryLength": 516268}, "307": {"vr": "OW", "BinaryLength": 516268}, "308": {"vr": "OW", "BinaryLength": 516268}, "309": {"vr": "OW", "BinaryLength": 516268}, "310": {"vr": "OW", "BinaryLength": 516268}, "311": {"vr": "OW", "BinaryLength": 516268}, "312": {"vr": "OW", "BinaryLength": 516268}, "313": {"vr": "OW", "BinaryLength": 516268}, "314": {"vr": "OW", "BinaryLength": 516268}, "315": {"vr": "OW", "BinaryLength": 516268}, "316": {"vr": "OW", "BinaryLength": 516268}, "317": {"vr": "OW", "BinaryLength": 516268}, "318": {"vr": "OW", "BinaryLength": 516268}, "319": {"vr": "OW", "BinaryLength": 516268}, "320": {"vr": "OW", "BinaryLength": 516268}, "321": {"vr": "OW", "BinaryLength": 516268}, "322": {"vr": "OW", "BinaryLength": 516268}, "323": {"vr": "OW", "BinaryLength": 516268}, "324": {"vr": "OW", "BinaryLength": 516268}, "325": {"vr": "OW", "BinaryLength": 516268}, "326": {"vr": "OW", "BinaryLength": 516268}, "327": {"vr": "OW", "BinaryLength": 516268}, "328": {"vr": "OW", "BinaryLength": 516268}, "329": {"vr": "OW", "BinaryLength": 516268}, "330": {"vr": "OW", "BinaryLength": 516268}, "331": {"vr": "OW", "BinaryLength": 516268}, "332": {"vr": "OW", "BinaryLength": 516268}, "333": {"vr": "OW", "BinaryLength": 516268}, "334": {"vr": "OW", "BinaryLength": 516268}, "335": {"vr": "OW", "BinaryLength": 516268}, "336": {"vr": "OW", "BinaryLength": 516268}, "337": {"vr": "OW", "BinaryLength": 516268}, "338": {"vr": "OW", "BinaryLength": 516268}, "339": {"vr": "OW", "BinaryLength": 516268}, "340": {"vr": "OW", "BinaryLength": 516268}, "341": {"vr": "OW", "BinaryLength": 516268}, "342": {"vr": "OW", "BinaryLength": 516268}, "343": {"vr": "OW", "BinaryLength": 516268}, "344": {"vr": "OW", "BinaryLength": 516268}, "345": {"vr": "OW", "BinaryLength": 516268}, "346": {"vr": "OW", "BinaryLength": 516268}, "347": {"vr": "OW", "BinaryLength": 516268}, "348": {"vr": "OW", "BinaryLength": 516268}, "349": {"vr": "OW", "BinaryLength": 516268}, "350": {"vr": "OW", "BinaryLength": 516268}, "351": {"vr": "OW", "BinaryLength": 516268}, "352": {"vr": "OW", "BinaryLength": 516268}, "353": {"vr": "OW", "BinaryLength": 516268}, "354": {"vr": "OW", "BinaryLength": 516268}, "355": {"vr": "OW", "BinaryLength": 516268}, "356": {"vr": "OW", "BinaryLength": 516268}, "357": {"vr": "OW", "BinaryLength": 516268}, "358": {"vr": "OW", "BinaryLength": 516268}, "359": {"vr": "OW", "BinaryLength": 516268}, "360": {"vr": "OW", "BinaryLength": 516268}, "361": {"vr": "OW", "BinaryLength": 516268}, "362": {"vr": "OW", "BinaryLength": 516268}, "363": {"vr": "OW", "BinaryLength": 516268}, "364": {"vr": "OW", "BinaryLength": 516268}, "365": {"vr": "OW", "BinaryLength": 516268}, "366": {"vr": "OW", "BinaryLength": 516268}, "367": {"vr": "OW", "BinaryLength": 516268}, "368": {"vr": "OW", "BinaryLength": 516268}, "369": {"vr": "OW", "BinaryLength": 516268}, "370": {"vr": "OW", "BinaryLength": 516268}, "371": {"vr": "OW", "BinaryLength": 516268}, "372": {"vr": "OW", "BinaryLength": 516268}, "373": {"vr": "OW", "BinaryLength": 516268}, "374": {"vr": "OW", "BinaryLength": 516268}, "375": {"vr": "OW", "BinaryLength": 516268}, "376": {"vr": "OW", "BinaryLength": 516268}, "377": {"vr": "OW", "BinaryLength": 516268}, "378": {"vr": "OW", "BinaryLength": 516268}, "379": {"vr": "OW", "BinaryLength": 516268}, "380": {"vr": "OW", "BinaryLength": 516268}, "381": {"vr": "OW", "BinaryLength": 516268}, "382": {"vr": "OW", "BinaryLength": 516268}, "383": {"vr": "OW", "BinaryLength": 516268}, "384": {"vr": "OW", "BinaryLength": 516268}, "385": {"vr": "OW", "BinaryLength": 516268}, "386": {"vr": "OW", "BinaryLength": 516268}, "387": {"vr": "OW", "BinaryLength": 516268}, "388": {"vr": "OW", "BinaryLength": 516268}, "389": {"vr": "OW", "BinaryLength": 516268}, "390": {"vr": "OW", "BinaryLength": 516268}, "391": {"vr": "OW", "BinaryLength": 516268}, "392": {"vr": "OW", "BinaryLength": 516268}, "393": {"vr": "OW", "BinaryLength": 516268}, "394": {"vr": "OW", "BinaryLength": 516268}, "395": {"vr": "OW", "BinaryLength": 516268}, "396": {"vr": "OW", "BinaryLength": 516268}, "397": {"vr": "OW", "BinaryLength": 516268}, "398": {"vr": "OW", "BinaryLength": 516268}, "399": {"vr": "OW", "BinaryLength": 516268}, "400": {"vr": "OW", "BinaryLength": 516268}, "401": {"vr": "OW", "BinaryLength": 516268}, "402": {"vr": "OW", "BinaryLength": 516268}, "403": {"vr": "OW", "BinaryLength": 516268}, "404": {"vr": "OW", "BinaryLength": 516268}, "405": {"vr": "OW", "BinaryLength": 516268}, "406": {"vr": "OW", "BinaryLength": 516268}, "407": {"vr": "OW", "BinaryLength": 516268}, "408": {"vr": "OW", "BinaryLength": 516268}, "409": {"vr": "OW", "BinaryLength": 516268}, "410": {"vr": "OW", "BinaryLength": 516268}, "411": {"vr": "OW", "BinaryLength": 516268}, "412": {"vr": "OW", "BinaryLength": 516268}, "413": {"vr": "OW", "BinaryLength": 516268}, "414": {"vr": "OW", "BinaryLength": 516268}, "415": {"vr": "OW", "BinaryLength": 516268}, "416": {"vr": "OW", "BinaryLength": 516268}, "417": {"vr": "OW", "BinaryLength": 516268}, "418": {"vr": "OW", "BinaryLength": 516268}, "419": {"vr": "OW", "BinaryLength": 516268}, "420": {"vr": "OW", "BinaryLength": 516268}, "421": {"vr": "OW", "BinaryLength": 516268}, "422": {"vr": "OW", "BinaryLength": 516268}, "423": {"vr": "OW", "BinaryLength": 516268}, "424": {"vr": "OW", "BinaryLength": 516268}, "425": {"vr": "OW", "BinaryLength": 516268}, "426": {"vr": "OW", "BinaryLength": 516268}, "427": {"vr": "OW", "BinaryLength": 516268}, "428": {"vr": "OW", "BinaryLength": 516268}, "429": {"vr": "OW", "BinaryLength": 516268}, "430": {"vr": "OW", "BinaryLength": 516268}, "431": {"vr": "OW", "BinaryLength": 516268}, "432": {"vr": "OW", "BinaryLength": 516268}, "433": {"vr": "OW", "BinaryLength": 516268}, "434": {"vr": "OW", "BinaryLength": 516268}, "435": {"vr": "OW", "BinaryLength": 516268}, "436": {"vr": "OW", "BinaryLength": 516268}, "437": {"vr": "OW", "BinaryLength": 516268}, "438": {"vr": "OW", "BinaryLength": 516268}, "439": {"vr": "OW", "BinaryLength": 516268}, "440": {"vr": "OW", "BinaryLength": 516268}, "441": {"vr": "OW", "BinaryLength": 516268}, "442": {"vr": "OW", "BinaryLength": 516268}, "443": {"vr": "OW", "BinaryLength": 516268}, "444": {"vr": "OW", "BinaryLength": 516268}, "445": {"vr": "OW", "BinaryLength": 516268}, "446": {"vr": "OW", "BinaryLength": 516268}, "447": {"vr": "OW", "BinaryLength": 516268}, "448": {"vr": "OW", "BinaryLength": 516268}, "449": {"vr": "OW", "BinaryLength": 516268}, "450": {"vr": "OW", "BinaryLength": 516268}, "451": {"vr": "OW", "BinaryLength": 516268}, "452": {"vr": "OW", "BinaryLength": 516268}, "453": {"vr": "OW", "BinaryLength": 516268}, "454": {"vr": "OW", "BinaryLength": 516268}, "455": {"vr": "OW", "BinaryLength": 516268}, "456": {"vr": "OW", "BinaryLength": 516268}, "457": {"vr": "OW", "BinaryLength": 516268}, "458": {"vr": "OW", "BinaryLength": 516268}, "459": {"vr": "OW", "BinaryLength": 516268}, "460": {"vr": "OW", "BinaryLength": 516268}, "461": {"vr": "OW", "BinaryLength": 516268}, "462": {"vr": "OW", "BinaryLength": 516268}, "463": {"vr": "OW", "BinaryLength": 516268}, "464": {"vr": "OW", "BinaryLength": 516268}, "465": {"vr": "OW", "BinaryLength": 516268}, "466": {"vr": "OW", "BinaryLength": 516268}, "467": {"vr": "OW", "BinaryLength": 516268}, "468": {"vr": "OW", "BinaryLength": 516268}, "469": {"vr": "OW", "BinaryLength": 516268}, "470": {"vr": "OW", "BinaryLength": 516268}, "471": {"vr": "OW", "BinaryLength": 516268}, "472": {"vr": "OW", "BinaryLength": 516268}, "473": {"vr": "OW", "BinaryLength": 516268}, "474": {"vr": "OW", "BinaryLength": 516268}, "475": {"vr": "OW", "BinaryLength": 516268}, "476": {"vr": "OW", "BinaryLength": 516268}, "477": {"vr": "OW", "BinaryLength": 516268}, "478": {"vr": "OW", "BinaryLength": 516268}, "479": {"vr": "OW", "BinaryLength": 516268}, "480": {"vr": "OW", "BinaryLength": 516268}, "481": {"vr": "OW", "BinaryLength": 516268}, "482": {"vr": "OW", "BinaryLength": 516268}, "483": {"vr": "OW", "BinaryLength": 516268}, "484": {"vr": "OW", "BinaryLength": 516268}, "485": {"vr": "OW", "BinaryLength": 516268}, "486": {"vr": "OW", "BinaryLength": 516268}, "487": {"vr": "OW", "BinaryLength": 516268}, "488": {"vr": "OW", "BinaryLength": 516268}, "489": {"vr": "OW", "BinaryLength": 516268}, "490": {"vr": "OW", "BinaryLength": 516268}, "491": {"vr": "OW", "BinaryLength": 516268}, "492": {"vr": "OW", "BinaryLength": 516268}, "493": {"vr": "OW", "BinaryLength": 516268}, "494": {"vr": "OW", "BinaryLength": 516268}, "495": {"vr": "OW", "BinaryLength": 516268}, "496": {"vr": "OW", "BinaryLength": 516268}, "497": {"vr": "OW", "BinaryLength": 516268}, "498": {"vr": "OW", "BinaryLength": 516268}, "499": {"vr": "OW", "BinaryLength": 516268}, "500": {"vr": "OW", "BinaryLength": 516268}, "501": {"vr": "OW", "BinaryLength": 516268}, "502": {"vr": "OW", "BinaryLength": 516268}, "503": {"vr": "OW", "BinaryLength": 516268}, "504": {"vr": "OW", "BinaryLength": 516268}, "505": {"vr": "OW", "BinaryLength": 516268}, "506": {"vr": "OW", "BinaryLength": 516268}, "507": {"vr": "OW", "BinaryLength": 516268}, "508": {"vr": "OW", "BinaryLength": 516268}, "509": {"vr": "OW", "BinaryLength": 516268}, "510": {"vr": "OW", "BinaryLength": 516268}, "511": {"vr": "OW", "BinaryLength": 516268}, "512": {"vr": "OW", "BinaryLength": 516268}, "513": {"vr": "OW", "BinaryLength": 516268}, "514": {"vr": "OW", "BinaryLength": 516268}, "515": {"vr": "OW", "BinaryLength": 516268}, "516": {"vr": "OW", "BinaryLength": 516268}, "517": {"vr": "OW", "BinaryLength": 516268}, "518": {"vr": "OW", "BinaryLength": 516268}, "519": {"vr": "OW", "BinaryLength": 516268}, "520": {"vr": "OW", "BinaryLength": 516268}, "521": {"vr": "OW", "BinaryLength": 516268}, "522": {"vr": "OW", "BinaryLength": 516268}, "523": {"vr": "OW", "BinaryLength": 516268}, "524": {"vr": "OW", "BinaryLength": 516268}, "525": {"vr": "OW", "BinaryLength": 516268}, "526": {"vr": "OW", "BinaryLength": 516268}, "527": {"vr": "OW", "BinaryLength": 516268}, "528": {"vr": "OW", "BinaryLength": 516268}, "529": {"vr": "OW", "BinaryLength": 516268}, "530": {"vr": "OW", "BinaryLength": 516268}}}


