
from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__)):
    return generate_dicom(out_dir, num_vols, constant_hdr,
                          collated_data, varying_hdr)


num_vols = 4020


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY",
            "DIFFUSION",
            "NONE",
            "ND",
            "NORM"
        ]
    },
    "00080012": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.4"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "091331.137000"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "094527.609000"
        ]
    },
    "00080050": {
        "vr": "SH"
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "MR"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "SIEMENS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "An address"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "XNAT"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "AWP45193"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "R-L MRtrix 60 directions interleaved B0 ep2d_diff_p2"
        ]
    },
    "00081040": {
        "vr": "LO",
        "Value": [
            "Department"
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotypes"
            }
        ]
    },
    "00081050": {
        "vr": "PN"
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "Skyra"
        ]
    },
    "00081140": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509141726605700537"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509142519936700545"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509142122884100541"
                    ]
                }
            }
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "SUBJECTID^STUDYID"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "SESSION_LABEL"
        ]
    },
    "00100021": {
        "vr": "LO",
        "Value": [
            "2"
        ]
    },
    "00100030": {
        "vr": "DA",
        "Value": [
            "19800824"
        ]
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "M"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "037Y"
        ]
    },
    "00101020": {
        "vr": "DS",
        "Value": [
            1.82
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            90.0
        ]
    },
    "00102000": {
        "vr": "LO",
        "Value": [
            "None"
        ]
    },
    "00102110": {
        "vr": "LO",
        "Value": [
            "None"
        ]
    },
    "001021C0": {
        "vr": "US",
        "Value": [
            4
        ]
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            "Comments"
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "BRAIN"
        ]
    },
    "00180020": {
        "vr": "CS",
        "Value": [
            "EP"
        ]
    },
    "00180021": {
        "vr": "CS",
        "Value": [
            "SK",
            "SP"
        ]
    },
    "00180022": {
        "vr": "CS",
        "Value": [
            "PFP",
            "FS"
        ]
    },
    "00180023": {
        "vr": "CS",
        "Value": [
            "2D"
        ]
    },
    "00180025": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00180050": {
        "vr": "DS",
        "Value": [
            2.5
        ]
    },
    "00180080": {
        "vr": "DS",
        "Value": [
            8800.0
        ]
    },
    "00180081": {
        "vr": "DS",
        "Value": [
            110.0
        ]
    },
    "00180083": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00180084": {
        "vr": "DS",
        "Value": [
            123.251961
        ]
    },
    "00180085": {
        "vr": "SH",
        "Value": [
            "1H"
        ]
    },
    "00180086": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00180087": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00180088": {
        "vr": "DS",
        "Value": [
            2.5
        ]
    },
    "00180089": {
        "vr": "IS",
        "Value": [
            72
        ]
    },
    "00180091": {
        "vr": "IS",
        "Value": [
            36
        ]
    },
    "00180093": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "00180094": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "00180095": {
        "vr": "DS",
        "Value": [
            2365.0
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "45193"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "syngo MR D13C"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "R-L MRtrix 60 directions interleaved B0 ep2d_diff_p2"
        ]
    },
    "00181200": {
        "vr": "DA",
        "Value": [
            "20090304",
            "20090304"
        ]
    },
    "00181201": {
        "vr": "TM",
        "Value": [
            "123723.000000",
            "123723.000000"
        ]
    },
    "00181251": {
        "vr": "SH",
        "Value": [
            "Body"
        ]
    },
    "00181310": {
        "vr": "US",
        "Value": [
            0,
            96,
            96,
            0
        ]
    },
    "00181312": {
        "vr": "CS",
        "Value": [
            "ROW"
        ]
    },
    "00181314": {
        "vr": "DS",
        "Value": [
            90.0
        ]
    },
    "00181315": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00181316": {
        "vr": "DS",
        "Value": [
            0.29777722647054
        ]
    },
    "00181318": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "00190010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR HEADER"
        ]
    },
    "00191008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00191009": {
        "vr": "LO",
        "Value": [
            "1.0"
        ]
    },
    "0019100F": {
        "vr": "SH",
        "Value": [
            "Fast*"
        ]
    },
    "00191011": {
        "vr": "SH",
        "Value": [
            "No"
        ]
    },
    "00191012": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00191013": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00191014": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00191017": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00191018": {
        "vr": "IS",
        "Value": [
            2200
        ]
    },
    "00191028": {
        "vr": "FD",
        "Value": [
            34.153
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.2.826.0.1.3680043.8.498.35939304416003656006618747446767853539"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.2.19.45193.2018052509443854768758767.0.0.0"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "MRH060"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            13
        ]
    },
    "00200037": {
        "vr": "DS",
        "Value": [
            1.0,
            0.0,
            0.0,
            0.0,
            0.97667227753657,
            -0.2147353307947
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.2.19.45193.1.20180525091331822.0.0.0"
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00210010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR SDS 01"
        ]
    },
    "00210011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR SDI 02"
        ]
    },
    "00211001": {
        "vr": "IS",
        "Value": [
            90
        ]
    },
    "00211004": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00211005": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00211006": {
        "vr": "LO",
        "Value": [
            "void"
        ]
    },
    "00211007": {
        "vr": "LO",
        "Value": [
            "NUMARIS/4"
        ]
    },
    "00211008": {
        "vr": "SH",
        "Value": [
            "Fast*"
        ]
    },
    "00211009": {
        "vr": "LO",
        "Value": [
            "p2"
        ]
    },
    "0021100A": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "0021100C": {
        "vr": "SH",
        "Value": [
            "+LPH"
        ]
    },
    "0021100D": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "0021100F": {
        "vr": "DS",
        "Value": [
            27.8939991,
            23.26799965,
            38.05500031
        ]
    },
    "00211010": {
        "vr": "IS",
        "Value": [
            41330004
        ]
    },
    "00211011": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211012": {
        "vr": "FD",
        "Value": [
            2.0
        ]
    },
    "00211013": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211014": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211016": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211017": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211018": {
        "vr": "SH",
        "Value": [
            "Head"
        ]
    },
    "0021101A": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "0021101B": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "0021101C": {
        "vr": "DS",
        "Value": [
            0.89755648,
            22.62391663,
            4.19425821
        ]
    },
    "0021101D": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "00211022": {
        "vr": "SH",
        "Value": [
            "SIEMENS"
        ]
    },
    "00211023": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211025": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00211026": {
        "vr": "IS",
        "Value": [
            40,
            67,
            67,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            524288,
            0,
            0,
            0,
            0,
            0,
            2,
            11505,
            0,
            0,
            0,
            0,
            0,
            0
        ]
    },
    "00211027": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "0021102A": {
        "vr": "IS",
        "Value": [
            255,
            0,
            0,
            0,
            0,
            0,
            0,
            4865,
            4866,
            0,
            0
        ]
    },
    "0021102B": {
        "vr": "ST",
        "Value": [
            "1;HFS;90.00;37.75;2;0;2;-2057087971"
        ]
    },
    "0021102C": {
        "vr": "DS",
        "Value": [
            1000000.0,
            340.42637744,
            340.42637744
        ]
    },
    "0021102D": {
        "vr": "DS",
        "Value": [
            3.2,
            1.35078298,
            0.0
        ]
    },
    "0021102E": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "0021102F": {
        "vr": "DS",
        "Value": [
            37.0,
            37.0,
            38.0
        ]
    },
    "00211030": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211031": {
        "vr": "IS",
        "Value": [
            -1098
        ]
    },
    "00211032": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00211033": {
        "vr": "SH",
        "Value": [
            "GC99"
        ]
    },
    "00211034": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00211035": {
        "vr": "DS",
        "Value": [
            0.97907454
        ]
    },
    "00211036": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211038": {
        "vr": "DS",
        "Value": [
            365.746003
        ]
    },
    "0021103B": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0021103D": {
        "vr": "CS",
        "Value": [
            "NONE"
        ]
    },
    "00211044": {
        "vr": "DS",
        "Value": [
            7.07106781,
            1.56484153
        ]
    },
    "00211045": {
        "vr": "CS",
        "Value": [
            "NO"
        ]
    },
    "00211046": {
        "vr": "DS",
        "Value": [
            2275.846875
        ]
    },
    "00211047": {
        "vr": "CS",
        "Value": [
            "IEC"
        ]
    },
    "00211048": {
        "vr": "CS"
    },
    "00211049": {
        "vr": "CS"
    },
    "00211050": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00211051": {
        "vr": "US",
        "Value": [
            36
        ]
    },
    "00211053": {
        "vr": "CS",
        "Value": [
            "U"
        ]
    },
    "0021111A": {
        "vr": "SH",
        "Value": [
            "predicted"
        ]
    },
    "0021111C": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00211124": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211133": {
        "vr": "IS",
        "Value": [
            48
        ]
    },
    "00211135": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211141": {
        "vr": "SH",
        "Value": [
            "predicted"
        ]
    },
    "00211142": {
        "vr": "IS",
        "Value": [
            2200
        ]
    },
    "00211145": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00211148": {
        "vr": "IS",
        "Value": [
            32
        ]
    },
    "00211149": {
        "vr": "IS",
        "Value": [
            48
        ]
    },
    "0021114F": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "00211151": {
        "vr": "UL",
        "Value": [
            134217732
        ]
    },
    "00211153": {
        "vr": "FD",
        "Value": [
            34.153
        ]
    },
    "00211154": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00211156": {
        "vr": "LO",
        "Value": [
            "p2"
        ]
    },
    "00211158": {
        "vr": "SH",
        "Value": [
            "96p*96s"
        ]
    },
    "00211159": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00211171": {
        "vr": "UT",
        "Value": [
            "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
        ]
    },
    "00211175": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY",
            "DIFFUSION",
            "NONE"
        ]
    },
    "00211176": {
        "vr": "LO",
        "Value": [
            "ChannelMixing:ND=true_CMM=1_CDM=1",
            "ACC1",
            "NormalizeAlgo:PreScan"
        ]
    },
    "00250010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR EXTRACTED CSA HEADER"
        ]
    },
    "00251001": {
        "vr": "SQ",
        "Value": [
            {
                "00250010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MR EXTRACTED CSA HEADER"
                    ]
                },
                "00251002": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS CSA HEADER"
                    ]
                },
                "00251003": {
                    "vr": "AT",
                    "Value": [
                        "00290010"
                    ]
                }
            },
            {
                "00250010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MR EXTRACTED CSA HEADER"
                    ]
                },
                "00251002": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS CSA HEADER"
                    ]
                },
                "00251003": {
                    "vr": "AT",
                    "Value": [
                        "00290020"
                    ]
                }
            }
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            96
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            96
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            2.5,
            2.5
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            12
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            11
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00280106": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00281055": {
        "vr": "LO",
        "Value": [
            "Algo1"
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CSA HEADER"
        ]
    },
    "00290011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MEDCOM HEADER2"
        ]
    },
    "00291008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00291009": {
        "vr": "LO",
        "Value": [
            "20180525"
        ]
    },
    "00291018": {
        "vr": "CS",
        "Value": [
            "MR"
        ]
    },
    "00291019": {
        "vr": "LO",
        "Value": [
            "20180525"
        ]
    },
    "00291160": {
        "vr": "LO",
        "Value": [
            "com"
        ]
    },
    "00321032": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "MND Phenotypes"
            }
        ]
    },
    "00321060": {
        "vr": "LO",
        "Value": [
            "MR_EXAM"
        ]
    },
    "00400244": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00400245": {
        "vr": "TM",
        "Value": [
            "091331.375000"
        ]
    },
    "00400253": {
        "vr": "SH",
        "Value": [
            "001"
        ]
    },
    "00400254": {
        "vr": "LO",
        "Value": [
            "MR Scan"
        ]
    },
    "00400275": {
        "vr": "SQ",
        "Value": [
            {
                "00400007": {
                    "vr": "LO",
                    "Value": [
                        "MR Scan"
                    ]
                },
                "00400009": {
                    "vr": "SH",
                    "Value": [
                        "001"
                    ]
                },
                "00401001": {
                    "vr": "SH",
                    "Value": [
                        "MRH060"
                    ]
                }
            }
        ]
    },
    "00400280": {
        "vr": "ST"
    },
    "00510010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR HEADER"
        ]
    },
    "00511008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00511009": {
        "vr": "LO",
        "Value": [
            "1.0"
        ]
    },
    "0051100A": {
        "vr": "LO",
        "Value": [
            "TA 00.02"
        ]
    },
    "0051100B": {
        "vr": "LO",
        "Value": [
            "96p*96s"
        ]
    },
    "0051100C": {
        "vr": "LO",
        "Value": [
            "FoV 240*240"
        ]
    },
    "0051100E": {
        "vr": "LO",
        "Value": [
            "Tra>Cor(-12.4)"
        ]
    },
    "0051100F": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "00511011": {
        "vr": "LO",
        "Value": [
            "p2"
        ]
    },
    "00511012": {
        "vr": "SH",
        "Value": [
            "TP 0"
        ]
    },
    "00511013": {
        "vr": "SH",
        "Value": [
            "+LPH"
        ]
    },
    "00511015": {
        "vr": "SH",
        "Value": [
            "R"
        ]
    },
    "00511016": {
        "vr": "LO",
        "Value": [
            "p2 DIFFUSION/NONE/ND/NORM"
        ]
    },
    "00511017": {
        "vr": "SH",
        "Value": [
            "SL 2.5"
        ]
    },
    "00511019": {
        "vr": "LO",
        "Value": [
            "A1/PFP/FS"
        ]
    }
}


varying_hdr = {"00080013": {"0": {"vr": "TM", "Value": ["094827.811000"]}, "1": {"vr": "TM", "Value": ["094947.660000"]}, "2": {"vr": "TM", "Value": ["095127.776000"]}, "3": {"vr": "TM", "Value": ["095147.804000"]}, "4": {"vr": "TM", "Value": ["095107.672000"]}, "5": {"vr": "TM", "Value": ["095047.889000"]}, "6": {"vr": "TM", "Value": ["095307.863000"]}, "7": {"vr": "TM", "Value": ["095327.829000"]}, "8": {"vr": "TM", "Value": ["094847.667000"]}, "9": {"vr": "TM", "Value": ["094707.827000"]}, "10": {"vr": "TM", "Value": ["095307.825000"]}, "11": {"vr": "TM", "Value": ["094847.852000"]}, "12": {"vr": "TM", "Value": ["094847.774000"]}, "13": {"vr": "TM", "Value": ["094527.681000"]}, "14": {"vr": "TM", "Value": ["095007.805000"]}, "15": {"vr": "TM", "Value": ["095207.670000"]}, "16": {"vr": "TM", "Value": ["095247.920000"]}, "17": {"vr": "TM", "Value": ["094607.854000"]}, "18": {"vr": "TM", "Value": ["094807.810000"]}, "19": {"vr": "TM", "Value": ["095207.729000"]}, "20": {"vr": "TM", "Value": ["094727.655000"]}, "21": {"vr": "TM", "Value": ["095207.916000"]}, "22": {"vr": "TM", "Value": ["095227.930000"]}, "23": {"vr": "TM", "Value": ["095407.705000"]}, "24": {"vr": "TM", "Value": ["095227.666000"]}, "25": {"vr": "TM", "Value": ["094807.770000"]}, "26": {"vr": "TM", "Value": ["094947.815000"]}, "27": {"vr": "TM", "Value": ["094727.896000"]}, "28": {"vr": "TM", "Value": ["094747.949000"]}, "29": {"vr": "TM", "Value": ["095147.882000"]}, "30": {"vr": "TM", "Value": ["094947.846000"]}, "31": {"vr": "TM", "Value": ["094827.939000"]}, "32": {"vr": "TM", "Value": ["095027.864000"]}, "33": {"vr": "TM", "Value": ["094747.821000"]}, "34": {"vr": "TM", "Value": ["095456.546000"]}, "35": {"vr": "TM", "Value": ["094527.618000"]}, "36": {"vr": "TM", "Value": ["094647.883000"]}, "37": {"vr": "TM", "Value": ["094807.723000"]}, "38": {"vr": "TM", "Value": ["095107.925000"]}, "39": {"vr": "TM", "Value": ["094927.742000"]}, "40": {"vr": "TM", "Value": ["095327.790000"]}, "41": {"vr": "TM", "Value": ["095427.944000"]}, "42": {"vr": "TM", "Value": ["095447.685000"]}, "43": {"vr": "TM", "Value": ["094807.812000"]}, "44": {"vr": "TM", "Value": ["095307.634000"]}, "45": {"vr": "TM", "Value": ["094627.764000"]}, "46": {"vr": "TM", "Value": ["095307.845000"]}, "47": {"vr": "TM", "Value": ["095427.881000"]}, "48": {"vr": "TM", "Value": ["094927.616000"]}, "49": {"vr": "TM", "Value": ["094547.697000"]}, "50": {"vr": "TM", "Value": ["095247.637000"]}, "51": {"vr": "TM", "Value": ["095247.775000"]}, "52": {"vr": "TM", "Value": ["095307.608000"]}, "53": {"vr": "TM", "Value": ["094827.763000"]}, "54": {"vr": "TM", "Value": ["094647.710000"]}, "55": {"vr": "TM", "Value": ["094907.641000"]}, "56": {"vr": "TM", "Value": ["095047.915000"]}, "57": {"vr": "TM", "Value": ["094907.946000"]}, "58": {"vr": "TM", "Value": ["094847.651000"]}, "59": {"vr": "TM", "Value": ["094747.612000"]}, "60": {"vr": "TM", "Value": ["095147.849000"]}, "61": {"vr": "TM", "Value": ["095327.697000"]}, "62": {"vr": "TM", "Value": ["094827.760000"]}, "63": {"vr": "TM", "Value": ["095447.788000"]}, "64": {"vr": "TM", "Value": ["095047.838000"]}, "65": {"vr": "TM", "Value": ["095447.811000"]}, "66": {"vr": "TM", "Value": ["094827.784000"]}, "67": {"vr": "TM", "Value": ["094847.900000"]}, "68": {"vr": "TM", "Value": ["094707.680000"]}, "69": {"vr": "TM", "Value": ["094727.761000"]}, "70": {"vr": "TM", "Value": ["094647.606000"]}, "71": {"vr": "TM", "Value": ["095107.642000"]}, "72": {"vr": "TM", "Value": ["095047.907000"]}, "73": {"vr": "TM", "Value": ["095207.918000"]}, "74": {"vr": "TM", "Value": ["094607.931000"]}, "75": {"vr": "TM", "Value": ["095427.619000"]}, "76": {"vr": "TM", "Value": ["095207.859000"]}, "77": {"vr": "TM", "Value": ["094947.870000"]}, "78": {"vr": "TM", "Value": ["095147.892000"]}, "79": {"vr": "TM", "Value": ["094747.806000"]}, "80": {"vr": "TM", "Value": ["095456.515000"]}, "81": {"vr": "TM", "Value": ["094607.923000"]}, "82": {"vr": "TM", "Value": ["095127.678000"]}, "83": {"vr": "TM", "Value": ["095027.862000"]}, "84": {"vr": "TM", "Value": ["094527.933000"]}, "85": {"vr": "TM", "Value": ["095207.639000"]}, "86": {"vr": "TM", "Value": ["095247.855000"]}, "87": {"vr": "TM", "Value": ["095207.900000"]}, "88": {"vr": "TM", "Value": ["094907.934000"]}, "89": {"vr": "TM", "Value": ["095347.923000"]}, "90": {"vr": "TM", "Value": ["094527.655000"]}, "91": {"vr": "TM", "Value": ["094707.634000"]}, "92": {"vr": "TM", "Value": ["095227.817000"]}, "93": {"vr": "TM", "Value": ["094627.962000"]}, "94": {"vr": "TM", "Value": ["095347.853000"]}, "95": {"vr": "TM", "Value": ["094727.929000"]}, "96": {"vr": "TM", "Value": ["094747.759000"]}, "97": {"vr": "TM", "Value": ["095447.901000"]}, "98": {"vr": "TM", "Value": ["094527.851000"]}, "99": {"vr": "TM", "Value": ["094527.865000"]}, "100": {"vr": "TM", "Value": ["094627.756000"]}, "101": {"vr": "TM", "Value": ["094907.693000"]}, "102": {"vr": "TM", "Value": ["094627.812000"]}, "103": {"vr": "TM", "Value": ["095027.739000"]}, "104": {"vr": "TM", "Value": ["095307.751000"]}, "105": {"vr": "TM", "Value": ["095347.802000"]}, "106": {"vr": "TM", "Value": ["095227.671000"]}, "107": {"vr": "TM", "Value": ["095347.666000"]}, "108": {"vr": "TM", "Value": ["094727.721000"]}, "109": {"vr": "TM", "Value": ["094727.748000"]}, "110": {"vr": "TM", "Value": ["095447.773000"]}, "111": {"vr": "TM", "Value": ["095307.809000"]}, "112": {"vr": "TM", "Value": ["094827.854000"]}, "113": {"vr": "TM", "Value": ["095447.693000"]}, "114": {"vr": "TM", "Value": ["095007.882000"]}, "115": {"vr": "TM", "Value": ["095227.830000"]}, "116": {"vr": "TM", "Value": ["095327.630000"]}, "117": {"vr": "TM", "Value": ["094707.922000"]}, "118": {"vr": "TM", "Value": ["095147.632000"]}, "119": {"vr": "TM", "Value": ["095447.945000"]}, "120": {"vr": "TM", "Value": ["094607.654000"]}, "121": {"vr": "TM", "Value": ["094547.687000"]}, "122": {"vr": "TM", "Value": ["095247.863000"]}, "123": {"vr": "TM", "Value": ["094527.820000"]}, "124": {"vr": "TM", "Value": ["095227.747000"]}, "125": {"vr": "TM", "Value": ["095007.946000"]}, "126": {"vr": "TM", "Value": ["095447.634000"]}, "127": {"vr": "TM", "Value": ["094927.804000"]}, "128": {"vr": "TM", "Value": ["095147.731000"]}, "129": {"vr": "TM", "Value": ["094827.636000"]}, "130": {"vr": "TM", "Value": ["094627.694000"]}, "131": {"vr": "TM", "Value": ["095147.898000"]}, "132": {"vr": "TM", "Value": ["095347.794000"]}, "133": {"vr": "TM", "Value": ["095427.899000"]}, "134": {"vr": "TM", "Value": ["095347.820000"]}, "135": {"vr": "TM", "Value": ["094747.900000"]}, "136": {"vr": "TM", "Value": ["094947.853000"]}, "137": {"vr": "TM", "Value": ["095047.882000"]}, "138": {"vr": "TM", "Value": ["094627.741000"]}, "139": {"vr": "TM", "Value": ["094807.836000"]}, "140": {"vr": "TM", "Value": ["094847.793000"]}, "141": {"vr": "TM", "Value": ["094547.822000"]}, "142": {"vr": "TM", "Value": ["095027.800000"]}, "143": {"vr": "TM", "Value": ["095247.875000"]}, "144": {"vr": "TM", "Value": ["095027.910000"]}, "145": {"vr": "TM", "Value": ["095307.656000"]}, "146": {"vr": "TM", "Value": ["094607.861000"]}, "147": {"vr": "TM", "Value": ["094727.891000"]}, "148": {"vr": "TM", "Value": ["095307.868000"]}, "149": {"vr": "TM", "Value": ["095247.843000"]}, "150": {"vr": "TM", "Value": ["095007.753000"]}, "151": {"vr": "TM", "Value": ["094727.789000"]}, "152": {"vr": "TM", "Value": ["095447.793000"]}, "153": {"vr": "TM", "Value": ["094747.704000"]}, "154": {"vr": "TM", "Value": ["094527.796000"]}, "155": {"vr": "TM", "Value": ["095207.780000"]}, "156": {"vr": "TM", "Value": ["094807.611000"]}, "157": {"vr": "TM", "Value": ["094907.832000"]}, "158": {"vr": "TM", "Value": ["095047.607000"]}, "159": {"vr": "TM", "Value": ["094607.776000"]}, "160": {"vr": "TM", "Value": ["095456.529000"]}, "161": {"vr": "TM", "Value": ["095307.771000"]}, "162": {"vr": "TM", "Value": ["094747.770000"]}, "163": {"vr": "TM", "Value": ["095247.822000"]}, "164": {"vr": "TM", "Value": ["094707.830000"]}, "165": {"vr": "TM", "Value": ["095247.608000"]}, "166": {"vr": "TM", "Value": ["095107.637000"]}, "167": {"vr": "TM", "Value": ["094927.611000"]}, "168": {"vr": "TM", "Value": ["094647.702000"]}, "169": {"vr": "TM", "Value": ["094807.950000"]}, "170": {"vr": "TM", "Value": ["094607.710000"]}, "171": {"vr": "TM", "Value": ["094807.795000"]}, "172": {"vr": "TM", "Value": ["094547.869000"]}, "173": {"vr": "TM", "Value": ["095427.949000"]}, "174": {"vr": "TM", "Value": ["094727.703000"]}, "175": {"vr": "TM", "Value": ["094827.802000"]}, "176": {"vr": "TM", "Value": ["094527.982000"]}, "177": {"vr": "TM", "Value": ["095307.704000"]}, "178": {"vr": "TM", "Value": ["095427.633000"]}, "179": {"vr": "TM", "Value": ["095247.930000"]}, "180": {"vr": "TM", "Value": ["094707.892000"]}, "181": {"vr": "TM", "Value": ["094827.839000"]}, "182": {"vr": "TM", "Value": ["095247.642000"]}, "183": {"vr": "TM", "Value": ["095127.734000"]}, "184": {"vr": "TM", "Value": ["094547.717000"]}, "185": {"vr": "TM", "Value": ["094807.651000"]}, "186": {"vr": "TM", "Value": ["095227.811000"]}, "187": {"vr": "TM", "Value": ["095227.837000"]}, "188": {"vr": "TM", "Value": ["095427.910000"]}, "189": {"vr": "TM", "Value": ["094907.819000"]}, "190": {"vr": "TM", "Value": ["095027.844000"]}, "191": {"vr": "TM", "Value": ["094527.772000"]}, "192": {"vr": "TM", "Value": ["095207.908000"]}, "193": {"vr": "TM", "Value": ["094627.684000"]}, "194": {"vr": "TM", "Value": ["095427.708000"]}, "195": {"vr": "TM", "Value": ["095047.633000"]}, "196": {"vr": "TM", "Value": ["095127.611000"]}, "197": {"vr": "TM", "Value": ["094907.864000"]}, "198": {"vr": "TM", "Value": ["094527.663000"]}, "199": {"vr": "TM", "Value": ["095127.696000"]}, "200": {"vr": "TM", "Value": ["094547.679000"]}, "201": {"vr": "TM", "Value": ["095147.885000"]}, "202": {"vr": "TM", "Value": ["095227.694000"]}, "203": {"vr": "TM", "Value": ["094807.645000"]}, "204": {"vr": "TM", "Value": ["094927.727000"]}, "205": {"vr": "TM", "Value": ["095227.901000"]}, "206": {"vr": "TM", "Value": ["095247.758000"]}, "207": {"vr": "TM", "Value": ["095047.863000"]}, "208": {"vr": "TM", "Value": ["094547.847000"]}, "209": {"vr": "TM", "Value": ["094627.837000"]}, "210": {"vr": "TM", "Value": ["095007.885000"]}, "211": {"vr": "TM", "Value": ["095047.736000"]}, "212": {"vr": "TM", "Value": ["095347.925000"]}, "213": {"vr": "TM", "Value": ["095347.946000"]}, "214": {"vr": "TM", "Value": ["095227.607000"]}, "215": {"vr": "TM", "Value": ["095107.721000"]}, "216": {"vr": "TM", "Value": ["094727.675000"]}, "217": {"vr": "TM", "Value": ["094707.845000"]}, "218": {"vr": "TM", "Value": ["095427.727000"]}, "219": {"vr": "TM", "Value": ["094947.663000"]}, "220": {"vr": "TM", "Value": ["094847.680000"]}, "221": {"vr": "TM", "Value": ["095027.682000"]}, "222": {"vr": "TM", "Value": ["095027.870000"]}, "223": {"vr": "TM", "Value": ["094547.850000"]}, "224": {"vr": "TM", "Value": ["094607.636000"]}, "225": {"vr": "TM", "Value": ["094607.705000"]}, "226": {"vr": "TM", "Value": ["095127.630000"]}, "227": {"vr": "TM", "Value": ["094707.621000"]}, "228": {"vr": "TM", "Value": ["095047.825000"]}, "229": {"vr": "TM", "Value": ["094827.633000"]}, "230": {"vr": "TM", "Value": ["094727.650000"]}, "231": {"vr": "TM", "Value": ["094707.820000"]}, "232": {"vr": "TM", "Value": ["095227.944000"]}, "233": {"vr": "TM", "Value": ["095247.772000"]}, "234": {"vr": "TM", "Value": ["094807.958000"]}, "235": {"vr": "TM", "Value": ["095247.753000"]}, "236": {"vr": "TM", "Value": ["095407.676000"]}, "237": {"vr": "TM", "Value": ["094547.845000"]}, "238": {"vr": "TM", "Value": ["095027.662000"]}, "239": {"vr": "TM", "Value": ["095247.933000"]}, "240": {"vr": "TM", "Value": ["094907.801000"]}, "241": {"vr": "TM", "Value": ["095027.659000"]}, "242": {"vr": "TM", "Value": ["095127.867000"]}, "243": {"vr": "TM", "Value": ["094827.894000"]}, "244": {"vr": "TM", "Value": ["095427.827000"]}, "245": {"vr": "TM", "Value": ["095327.888000"]}, "246": {"vr": "TM", "Value": ["094527.678000"]}, "247": {"vr": "TM", "Value": ["094627.810000"]}, "248": {"vr": "TM", "Value": ["095047.782000"]}, "249": {"vr": "TM", "Value": ["095047.953000"]}, "250": {"vr": "TM", "Value": ["095147.710000"]}, "251": {"vr": "TM", "Value": ["094807.763000"]}, "252": {"vr": "TM", "Value": ["095027.788000"]}, "253": {"vr": "TM", "Value": ["095027.890000"]}, "254": {"vr": "TM", "Value": ["095107.781000"]}, "255": {"vr": "TM", "Value": ["094847.943000"]}, "256": {"vr": "TM", "Value": ["095327.772000"]}, "257": {"vr": "TM", "Value": ["095407.888000"]}, "258": {"vr": "TM", "Value": ["094907.768000"]}, "259": {"vr": "TM", "Value": ["094907.705000"]}, "260": {"vr": "TM", "Value": ["094647.849000"]}, "261": {"vr": "TM", "Value": ["095327.621000"]}, "262": {"vr": "TM", "Value": ["094807.745000"]}, "263": {"vr": "TM", "Value": ["094627.729000"]}, "264": {"vr": "TM", "Value": ["095347.644000"]}, "265": {"vr": "TM", "Value": ["095427.876000"]}, "266": {"vr": "TM", "Value": ["095447.727000"]}, "267": {"vr": "TM", "Value": ["094847.714000"]}, "268": {"vr": "TM", "Value": ["094627.947000"]}, "269": {"vr": "TM", "Value": ["095207.795000"]}, "270": {"vr": "TM", "Value": ["095456.551000"]}, "271": {"vr": "TM", "Value": ["095227.868000"]}, "272": {"vr": "TM", "Value": ["095427.683000"]}, "273": {"vr": "TM", "Value": ["094947.888000"]}, "274": {"vr": "TM", "Value": ["094627.974000"]}, "275": {"vr": "TM", "Value": ["094707.637000"]}, "276": {"vr": "TM", "Value": ["095227.923000"]}, "277": {"vr": "TM", "Value": ["095407.768000"]}, "278": {"vr": "TM", "Value": ["094847.664000"]}, "279": {"vr": "TM", "Value": ["094807.827000"]}, "280": {"vr": "TM", "Value": ["095107.891000"]}, "281": {"vr": "TM", "Value": ["094907.748000"]}, "282": {"vr": "TM", "Value": ["094547.804000"]}, "283": {"vr": "TM", "Value": ["095007.618000"]}, "284": {"vr": "TM", "Value": ["095427.695000"]}, "285": {"vr": "TM", "Value": ["095227.892000"]}, "286": {"vr": "TM", "Value": ["095027.877000"]}, "287": {"vr": "TM", "Value": ["094627.709000"]}, "288": {"vr": "TM", "Value": ["094727.751000"]}, "289": {"vr": "TM", "Value": ["095447.796000"]}, "290": {"vr": "TM", "Value": ["095456.412000"]}, "291": {"vr": "TM", "Value": ["094907.855000"]}, "292": {"vr": "TM", "Value": ["094947.917000"]}, "293": {"vr": "TM", "Value": ["094727.865000"]}, "294": {"vr": "TM", "Value": ["095427.842000"]}, "295": {"vr": "TM", "Value": ["095147.649000"]}, "296": {"vr": "TM", "Value": ["094747.772000"]}, "297": {"vr": "TM", "Value": ["094527.953000"]}, "298": {"vr": "TM", "Value": ["094547.634000"]}, "299": {"vr": "TM", "Value": ["094527.902000"]}, "300": {"vr": "TM", "Value": ["095427.884000"]}, "301": {"vr": "TM", "Value": ["095456.473000"]}, "302": {"vr": "TM", "Value": ["095127.632000"]}, "303": {"vr": "TM", "Value": ["094927.938000"]}, "304": {"vr": "TM", "Value": ["094947.723000"]}, "305": {"vr": "TM", "Value": ["094707.889000"]}, "306": {"vr": "TM", "Value": ["095407.870000"]}, "307": {"vr": "TM", "Value": ["094947.612000"]}, "308": {"vr": "TM", "Value": ["095407.620000"]}, "309": {"vr": "TM", "Value": ["095047.961000"]}, "310": {"vr": "TM", "Value": ["095027.948000"]}, "311": {"vr": "TM", "Value": ["094647.925000"]}, "312": {"vr": "TM", "Value": ["095147.672000"]}, "313": {"vr": "TM", "Value": ["095456.490000"]}, "314": {"vr": "TM", "Value": ["095447.664000"]}, "315": {"vr": "TM", "Value": ["094727.784000"]}, "316": {"vr": "TM", "Value": ["094647.935000"]}, "317": {"vr": "TM", "Value": ["095407.718000"]}, "318": {"vr": "TM", "Value": ["094847.706000"]}, "319": {"vr": "TM", "Value": ["095047.615000"]}, "320": {"vr": "TM", "Value": ["095127.770000"]}, "321": {"vr": "TM", "Value": ["094727.738000"]}, "322": {"vr": "TM", "Value": ["095407.943000"]}, "323": {"vr": "TM", "Value": ["094947.784000"]}, "324": {"vr": "TM", "Value": ["094927.909000"]}, "325": {"vr": "TM", "Value": ["094727.662000"]}, "326": {"vr": "TM", "Value": ["094607.730000"]}, "327": {"vr": "TM", "Value": ["095127.708000"]}, "328": {"vr": "TM", "Value": ["095327.637000"]}, "329": {"vr": "TM", "Value": ["095127.727000"]}, "330": {"vr": "TM", "Value": ["094547.812000"]}, "331": {"vr": "TM", "Value": ["094947.903000"]}, "332": {"vr": "TM", "Value": ["094727.624000"]}, "333": {"vr": "TM", "Value": ["095247.701000"]}, "334": {"vr": "TM", "Value": ["094927.666000"]}, "335": {"vr": "TM", "Value": ["094807.931000"]}, "336": {"vr": "TM", "Value": ["094727.870000"]}, "337": {"vr": "TM", "Value": ["094907.882000"]}, "338": {"vr": "TM", "Value": ["094547.796000"]}, "339": {"vr": "TM", "Value": ["094847.771000"]}, "340": {"vr": "TM", "Value": ["094647.612000"]}, "341": {"vr": "TM", "Value": ["095447.672000"]}, "342": {"vr": "TM", "Value": ["094807.875000"]}, "343": {"vr": "TM", "Value": ["095347.743000"]}, "344": {"vr": "TM", "Value": ["094847.811000"]}, "345": {"vr": "TM", "Value": ["095207.856000"]}, "346": {"vr": "TM", "Value": ["094627.831000"]}, "347": {"vr": "TM", "Value": ["094707.807000"]}, "348": {"vr": "TM", "Value": ["095007.667000"]}, "349": {"vr": "TM", "Value": ["094527.675000"]}, "350": {"vr": "TM", "Value": ["095147.813000"]}, "351": {"vr": "TM", "Value": ["095407.842000"]}, "352": {"vr": "TM", "Value": ["095007.694000"]}, "353": {"vr": "TM", "Value": ["095007.646000"]}, "354": {"vr": "TM", "Value": ["094927.886000"]}, "355": {"vr": "TM", "Value": ["095327.827000"]}, "356": {"vr": "TM", "Value": ["094747.895000"]}, "357": {"vr": "TM", "Value": ["094547.674000"]}, "358": {"vr": "TM", "Value": ["095227.925000"]}, "359": {"vr": "TM", "Value": ["094707.945000"]}, "360": {"vr": "TM", "Value": ["094547.714000"]}, "361": {"vr": "TM", "Value": ["095007.848000"]}, "362": {"vr": "TM", "Value": ["095227.699000"]}, "363": {"vr": "TM", "Value": ["095007.924000"]}, "364": {"vr": "TM", "Value": ["095327.824000"]}, "365": {"vr": "TM", "Value": ["095007.939000"]}, "366": {"vr": "TM", "Value": ["095427.892000"]}, "367": {"vr": "TM", "Value": ["094707.805000"]}, "368": {"vr": "TM", "Value": ["094647.951000"]}, "369": {"vr": "TM", "Value": ["095307.899000"]}, "370": {"vr": "TM", "Value": ["095227.856000"]}, "371": {"vr": "TM", "Value": ["095227.691000"]}, "372": {"vr": "TM", "Value": ["095207.813000"]}, "373": {"vr": "TM", "Value": ["095107.916000"]}, "374": {"vr": "TM", "Value": ["094927.916000"]}, "375": {"vr": "TM", "Value": ["095107.807000"]}, "376": {"vr": "TM", "Value": ["094947.886000"]}, "377": {"vr": "TM", "Value": ["095327.644000"]}, "378": {"vr": "TM", "Value": ["094927.758000"]}, "379": {"vr": "TM", "Value": ["094747.748000"]}, "380": {"vr": "TM", "Value": ["094907.898000"]}, "381": {"vr": "TM", "Value": ["094727.881000"]}, "382": {"vr": "TM", "Value": ["094847.908000"]}, "383": {"vr": "TM", "Value": ["094527.726000"]}, "384": {"vr": "TM", "Value": ["095007.827000"]}, "385": {"vr": "TM", "Value": ["095347.843000"]}, "386": {"vr": "TM", "Value": ["095347.861000"]}, "387": {"vr": "TM", "Value": ["095107.833000"]}, "388": {"vr": "TM", "Value": ["095407.825000"]}, "389": {"vr": "TM", "Value": ["094907.924000"]}, "390": {"vr": "TM", "Value": ["094707.755000"]}, "391": {"vr": "TM", "Value": ["095347.943000"]}, "392": {"vr": "TM", "Value": ["094807.897000"]}, "393": {"vr": "TM", "Value": ["095127.673000"]}, "394": {"vr": "TM", "Value": ["095107.660000"]}, "395": {"vr": "TM", "Value": ["095007.751000"]}, "396": {"vr": "TM", "Value": ["094827.914000"]}, "397": {"vr": "TM", "Value": ["095007.631000"]}, "398": {"vr": "TM", "Value": ["094607.737000"]}, "399": {"vr": "TM", "Value": ["094707.654000"]}, "400": {"vr": "TM", "Value": ["094907.913000"]}, "401": {"vr": "TM", "Value": ["094647.881000"]}, "402": {"vr": "TM", "Value": ["094807.684000"]}, "403": {"vr": "TM", "Value": ["095047.805000"]}, "404": {"vr": "TM", "Value": ["094607.681000"]}, "405": {"vr": "TM", "Value": ["095227.742000"]}, "406": {"vr": "TM", "Value": ["094727.779000"]}, "407": {"vr": "TM", "Value": ["094807.760000"]}, "408": {"vr": "TM", "Value": ["095027.693000"]}, "409": {"vr": "TM", "Value": ["095107.649000"]}, "410": {"vr": "TM", "Value": ["094747.709000"]}, "411": {"vr": "TM", "Value": ["095347.682000"]}, "412": {"vr": "TM", "Value": ["094547.640000"]}, "413": {"vr": "TM", "Value": ["094707.794000"]}, "414": {"vr": "TM", "Value": ["094607.763000"]}, "415": {"vr": "TM", "Value": ["095307.789000"]}, "416": {"vr": "TM", "Value": ["094947.810000"]}, "417": {"vr": "TM", "Value": ["094607.895000"]}, "418": {"vr": "TM", "Value": ["094527.742000"]}, "419": {"vr": "TM", "Value": ["094607.771000"]}, "420": {"vr": "TM", "Value": ["095447.763000"]}, "421": {"vr": "TM", "Value": ["094627.817000"]}, "422": {"vr": "TM", "Value": ["094747.840000"]}, "423": {"vr": "TM", "Value": ["095327.894000"]}, "424": {"vr": "TM", "Value": ["095147.767000"]}, "425": {"vr": "TM", "Value": ["095427.750000"]}, "426": {"vr": "TM", "Value": ["095207.711000"]}, "427": {"vr": "TM", "Value": ["095127.924000"]}, "428": {"vr": "TM", "Value": ["095407.830000"]}, "429": {"vr": "TM", "Value": ["095207.765000"]}, "430": {"vr": "TM", "Value": ["095047.679000"]}, "431": {"vr": "TM", "Value": ["094647.878000"]}, "432": {"vr": "TM", "Value": ["095427.758000"]}, "433": {"vr": "TM", "Value": ["095127.883000"]}, "434": {"vr": "TM", "Value": ["094707.863000"]}, "435": {"vr": "TM", "Value": ["095447.734000"]}, "436": {"vr": "TM", "Value": ["094527.790000"]}, "437": {"vr": "TM", "Value": ["094827.768000"]}, "438": {"vr": "TM", "Value": ["095107.713000"]}, "439": {"vr": "TM", "Value": ["095307.791000"]}, "440": {"vr": "TM", "Value": ["095407.753000"]}, "441": {"vr": "TM", "Value": ["094627.825000"]}, "442": {"vr": "TM", "Value": ["094647.785000"]}, "443": {"vr": "TM", "Value": ["095347.697000"]}, "444": {"vr": "TM", "Value": ["095147.662000"]}, "445": {"vr": "TM", "Value": ["095147.763000"]}, "446": {"vr": "TM", "Value": ["095247.894000"]}, "447": {"vr": "TM", "Value": ["094527.883000"]}, "448": {"vr": "TM", "Value": ["095327.802000"]}, "449": {"vr": "TM", "Value": ["095047.731000"]}, "450": {"vr": "TM", "Value": ["095407.689000"]}, "451": {"vr": "TM", "Value": ["094707.948000"]}, "452": {"vr": "TM", "Value": ["095247.626000"]}, "453": {"vr": "TM", "Value": ["094547.824000"]}, "454": {"vr": "TM", "Value": ["094807.948000"]}, "455": {"vr": "TM", "Value": ["095107.684000"]}, "456": {"vr": "TM", "Value": ["094807.829000"]}, "457": {"vr": "TM", "Value": ["094827.730000"]}, "458": {"vr": "TM", "Value": ["094927.639000"]}, "459": {"vr": "TM", "Value": ["094807.805000"]}, "460": {"vr": "TM", "Value": ["094847.703000"]}, "461": {"vr": "TM", "Value": ["095107.682000"]}, "462": {"vr": "TM", "Value": ["094927.898000"]}, "463": {"vr": "TM", "Value": ["095107.882000"]}, "464": {"vr": "TM", "Value": ["095307.873000"]}, "465": {"vr": "TM", "Value": ["094747.943000"]}, "466": {"vr": "TM", "Value": ["094707.760000"]}, "467": {"vr": "TM", "Value": ["095027.723000"]}, "468": {"vr": "TM", "Value": ["094547.814000"]}, "469": {"vr": "TM", "Value": ["095456.425000"]}, "470": {"vr": "TM", "Value": ["095047.841000"]}, "471": {"vr": "TM", "Value": ["095047.690000"]}, "472": {"vr": "TM", "Value": ["094707.853000"]}, "473": {"vr": "TM", "Value": ["095347.958000"]}, "474": {"vr": "TM", "Value": ["095347.702000"]}, "475": {"vr": "TM", "Value": ["094527.711000"]}, "476": {"vr": "TM", "Value": ["095347.858000"]}, "477": {"vr": "TM", "Value": ["094727.942000"]}, "478": {"vr": "TM", "Value": ["095427.673000"]}, "479": {"vr": "TM", "Value": ["095307.730000"]}, "480": {"vr": "TM", "Value": ["094947.829000"]}, "481": {"vr": "TM", "Value": ["094527.887000"]}, "482": {"vr": "TM", "Value": ["094707.932000"]}, "483": {"vr": "TM", "Value": ["095327.735000"]}, "484": {"vr": "TM", "Value": ["095127.620000"]}, "485": {"vr": "TM", "Value": ["095227.722000"]}, "486": {"vr": "TM", "Value": ["094827.735000"]}, "487": {"vr": "TM", "Value": ["094847.842000"]}, "488": {"vr": "TM", "Value": ["094907.634000"]}, "489": {"vr": "TM", "Value": ["095307.618000"]}, "490": {"vr": "TM", "Value": ["095047.638000"]}, "491": {"vr": "TM", "Value": ["094947.930000"]}, "492": {"vr": "TM", "Value": ["094727.923000"]}, "493": {"vr": "TM", "Value": ["095307.781000"]}, "494": {"vr": "TM", "Value": ["095327.930000"]}, "495": {"vr": "TM", "Value": ["094827.774000"]}, "496": {"vr": "TM", "Value": ["095007.723000"]}, "497": {"vr": "TM", "Value": ["094527.769000"]}, "498": {"vr": "TM", "Value": ["095427.809000"]}, "499": {"vr": "TM", "Value": ["094607.703000"]}, "500": {"vr": "TM", "Value": ["094627.689000"]}, "501": {"vr": "TM", "Value": ["095456.541000"]}, "502": {"vr": "TM", "Value": ["095027.834000"]}, "503": {"vr": "TM", "Value": ["094907.750000"]}, "504": {"vr": "TM", "Value": ["094847.690000"]}, "505": {"vr": "TM", "Value": ["094607.757000"]}, "506": {"vr": "TM", "Value": ["094727.728000"]}, "507": {"vr": "TM", "Value": ["094707.629000"]}, "508": {"vr": "TM", "Value": ["094747.837000"]}, "509": {"vr": "TM", "Value": ["094947.675000"]}, "510": {"vr": "TM", "Value": ["095347.951000"]}, "511": {"vr": "TM", "Value": ["094927.948000"]}, "512": {"vr": "TM", "Value": ["094807.710000"]}, "513": {"vr": "TM", "Value": ["095227.737000"]}, "514": {"vr": "TM", "Value": ["094647.990000"]}, "515": {"vr": "TM", "Value": ["094827.887000"]}, "516": {"vr": "TM", "Value": ["094527.799000"]}, "517": {"vr": "TM", "Value": ["095347.812000"]}, "518": {"vr": "TM", "Value": ["094907.654000"]}, "519": {"vr": "TM", "Value": ["094707.935000"]}, "520": {"vr": "TM", "Value": ["095147.847000"]}, "521": {"vr": "TM", "Value": ["094547.642000"]}, "522": {"vr": "TM", "Value": ["094947.768000"]}, "523": {"vr": "TM", "Value": ["095447.848000"]}, "524": {"vr": "TM", "Value": ["094707.858000"]}, "525": {"vr": "TM", "Value": ["094947.813000"]}, "526": {"vr": "TM", "Value": ["095427.835000"]}, "527": {"vr": "TM", "Value": ["095407.774000"]}, "528": {"vr": "TM", "Value": ["095407.713000"]}, "529": {"vr": "TM", "Value": ["094547.627000"]}, "530": {"vr": "TM", "Value": ["094727.888000"]}, "531": {"vr": "TM", "Value": ["094847.621000"]}, "532": {"vr": "TM", "Value": ["094527.994000"]}, "533": {"vr": "TM", "Value": ["094747.644000"]}, "534": {"vr": "TM", "Value": ["095027.777000"]}, "535": {"vr": "TM", "Value": ["095227.773000"]}, "536": {"vr": "TM", "Value": ["095207.664000"]}, "537": {"vr": "TM", "Value": ["095027.651000"]}, "538": {"vr": "TM", "Value": ["095107.716000"]}, "539": {"vr": "TM", "Value": ["094527.633000"]}, "540": {"vr": "TM", "Value": ["094827.610000"]}, "541": {"vr": "TM", "Value": ["095407.945000"]}, "542": {"vr": "TM", "Value": ["095007.909000"]}, "543": {"vr": "TM", "Value": ["095447.947000"]}, "544": {"vr": "TM", "Value": ["094647.943000"]}, "545": {"vr": "TM", "Value": ["094947.614000"]}, "546": {"vr": "TM", "Value": ["095407.807000"]}, "547": {"vr": "TM", "Value": ["095407.763000"]}, "548": {"vr": "TM", "Value": ["094847.617000"]}, "549": {"vr": "TM", "Value": ["095127.784000"]}, "550": {"vr": "TM", "Value": ["095047.951000"]}, "551": {"vr": "TM", "Value": ["095307.804000"]}, "552": {"vr": "TM", "Value": ["095107.726000"]}, "553": {"vr": "TM", "Value": ["094647.977000"]}, "554": {"vr": "TM", "Value": ["095007.914000"]}, "555": {"vr": "TM", "Value": ["094527.657000"]}, "556": {"vr": "TM", "Value": ["094747.630000"]}, "557": {"vr": "TM", "Value": ["095427.933000"]}, "558": {"vr": "TM", "Value": ["095107.814000"]}, "559": {"vr": "TM", "Value": ["095247.899000"]}, "560": {"vr": "TM", "Value": ["095107.772000"]}, "561": {"vr": "TM", "Value": ["095347.907000"]}, "562": {"vr": "TM", "Value": ["095207.823000"]}, "563": {"vr": "TM", "Value": ["094807.743000"]}, "564": {"vr": "TM", "Value": ["095107.779000"]}, "565": {"vr": "TM", "Value": ["094907.869000"]}, "566": {"vr": "TM", "Value": ["095127.816000"]}, "567": {"vr": "TM", "Value": ["094847.614000"]}, "568": {"vr": "TM", "Value": ["095207.656000"]}, "569": {"vr": "TM", "Value": ["094927.740000"]}, "570": {"vr": "TM", "Value": ["094827.686000"]}, "571": {"vr": "TM", "Value": ["095327.628000"]}, "572": {"vr": "TM", "Value": ["095347.931000"]}, "573": {"vr": "TM", "Value": ["095427.654000"]}, "574": {"vr": "TM", "Value": ["095407.679000"]}, "575": {"vr": "TM", "Value": ["095127.634000"]}, "576": {"vr": "TM", "Value": ["095127.824000"]}, "577": {"vr": "TM", "Value": ["095347.700000"]}, "578": {"vr": "TM", "Value": ["095027.690000"]}, "579": {"vr": "TM", "Value": ["095307.712000"]}, "580": {"vr": "TM", "Value": ["095307.779000"]}, "581": {"vr": "TM", "Value": ["095147.918000"]}, "582": {"vr": "TM", "Value": ["095027.620000"]}, "583": {"vr": "TM", "Value": ["095127.809000"]}, "584": {"vr": "TM", "Value": ["095227.776000"]}, "585": {"vr": "TM", "Value": ["094527.709000"]}, "586": {"vr": "TM", "Value": ["095347.730000"]}, "587": {"vr": "TM", "Value": ["094647.920000"]}, "588": {"vr": "TM", "Value": ["094727.875000"]}, "589": {"vr": "TM", "Value": ["095327.837000"]}, "590": {"vr": "TM", "Value": ["094907.710000"]}, "591": {"vr": "TM", "Value": ["095047.764000"]}, "592": {"vr": "TM", "Value": ["095347.792000"]}, "593": {"vr": "TM", "Value": ["095247.656000"]}, "594": {"vr": "TM", "Value": ["094527.827000"]}, "595": {"vr": "TM", "Value": ["094527.960000"]}, "596": {"vr": "TM", "Value": ["094947.928000"]}, "597": {"vr": "TM", "Value": ["094907.785000"]}, "598": {"vr": "TM", "Value": ["095347.608000"]}, "599": {"vr": "TM", "Value": ["094747.804000"]}, "600": {"vr": "TM", "Value": ["094847.612000"]}, "601": {"vr": "TM", "Value": ["095147.872000"]}, "602": {"vr": "TM", "Value": ["095007.720000"]}, "603": {"vr": "TM", "Value": ["095407.901000"]}, "604": {"vr": "TM", "Value": ["094627.622000"]}, "605": {"vr": "TM", "Value": ["095427.768000"]}, "606": {"vr": "TM", "Value": ["095227.946000"]}, "607": {"vr": "TM", "Value": ["095127.898000"]}, "608": {"vr": "TM", "Value": ["095407.748000"]}, "609": {"vr": "TM", "Value": ["095227.681000"]}, "610": {"vr": "TM", "Value": ["095427.928000"]}, "611": {"vr": "TM", "Value": ["095007.875000"]}, "612": {"vr": "TM", "Value": ["094547.632000"]}, "613": {"vr": "TM", "Value": ["095307.649000"]}, "614": {"vr": "TM", "Value": ["095007.758000"]}, "615": {"vr": "TM", "Value": ["095207.677000"]}, "616": {"vr": "TM", "Value": ["095207.831000"]}, "617": {"vr": "TM", "Value": ["094607.908000"]}, "618": {"vr": "TM", "Value": ["094707.843000"]}, "619": {"vr": "TM", "Value": ["095027.872000"]}, "620": {"vr": "TM", "Value": ["095027.824000"]}, "621": {"vr": "TM", "Value": ["094647.724000"]}, "622": {"vr": "TM", "Value": ["094527.871000"]}, "623": {"vr": "TM", "Value": ["095407.730000"]}, "624": {"vr": "TM", "Value": ["095456.441000"]}, "625": {"vr": "TM", "Value": ["095307.832000"]}, "626": {"vr": "TM", "Value": ["094727.810000"]}, "627": {"vr": "TM", "Value": ["094707.742000"]}, "628": {"vr": "TM", "Value": ["094527.950000"]}, "629": {"vr": "TM", "Value": ["094907.936000"]}, "630": {"vr": "TM", "Value": ["095227.846000"]}, "631": {"vr": "TM", "Value": ["094807.797000"]}, "632": {"vr": "TM", "Value": ["094607.893000"]}, "633": {"vr": "TM", "Value": ["095027.852000"]}, "634": {"vr": "TM", "Value": ["094807.895000"]}, "635": {"vr": "TM", "Value": ["095247.663000"]}, "636": {"vr": "TM", "Value": ["094707.687000"]}, "637": {"vr": "TM", "Value": ["094707.876000"]}, "638": {"vr": "TM", "Value": ["095207.689000"]}, "639": {"vr": "TM", "Value": ["095447.688000"]}, "640": {"vr": "TM", "Value": ["094627.936000"]}, "641": {"vr": "TM", "Value": ["094627.657000"]}, "642": {"vr": "TM", "Value": ["094807.768000"]}, "643": {"vr": "TM", "Value": ["095227.794000"]}, "644": {"vr": "TM", "Value": ["095307.938000"]}, "645": {"vr": "TM", "Value": ["094927.832000"]}, "646": {"vr": "TM", "Value": ["095327.661000"]}, "647": {"vr": "TM", "Value": ["095107.821000"]}, "648": {"vr": "TM", "Value": ["095427.678000"]}, "649": {"vr": "TM", "Value": ["094927.699000"]}, "650": {"vr": "TM", "Value": ["094627.858000"]}, "651": {"vr": "TM", "Value": ["094747.775000"]}, "652": {"vr": "TM", "Value": ["095307.892000"]}, "653": {"vr": "TM", "Value": ["094747.615000"]}, "654": {"vr": "TM", "Value": ["095147.695000"]}, "655": {"vr": "TM", "Value": ["094827.727000"]}, "656": {"vr": "TM", "Value": ["095127.842000"]}, "657": {"vr": "TM", "Value": ["094547.794000"]}, "658": {"vr": "TM", "Value": ["095207.866000"]}, "659": {"vr": "TM", "Value": ["094647.700000"]}, "660": {"vr": "TM", "Value": ["095027.908000"]}, "661": {"vr": "TM", "Value": ["095307.884000"]}, "662": {"vr": "TM", "Value": ["094647.864000"]}, "663": {"vr": "TM", "Value": ["095456.556000"]}, "664": {"vr": "TM", "Value": ["095207.703000"]}, "665": {"vr": "TM", "Value": ["095207.691000"]}, "666": {"vr": "TM", "Value": ["094947.896000"]}, "667": {"vr": "TM", "Value": ["094627.879000"]}, "668": {"vr": "TM", "Value": ["095007.834000"]}, "669": {"vr": "TM", "Value": ["094527.958000"]}, "670": {"vr": "TM", "Value": ["094627.749000"]}, "671": {"vr": "TM", "Value": ["095107.861000"]}, "672": {"vr": "TM", "Value": ["095407.812000"]}, "673": {"vr": "TM", "Value": ["094607.745000"]}, "674": {"vr": "TM", "Value": ["095327.618000"]}, "675": {"vr": "TM", "Value": ["094847.948000"]}, "676": {"vr": "TM", "Value": ["094847.672000"]}, "677": {"vr": "TM", "Value": ["094907.845000"]}, "678": {"vr": "TM", "Value": ["094647.712000"]}, "679": {"vr": "TM", "Value": ["095007.824000"]}, "680": {"vr": "TM", "Value": ["095147.655000"]}, "681": {"vr": "TM", "Value": ["095447.711000"]}, "682": {"vr": "TM", "Value": ["095247.750000"]}, "683": {"vr": "TM", "Value": ["095447.647000"]}, "684": {"vr": "TM", "Value": ["095227.707000"]}, "685": {"vr": "TM", "Value": ["094607.828000"]}, "686": {"vr": "TM", "Value": ["094907.879000"]}, "687": {"vr": "TM", "Value": ["095147.794000"]}, "688": {"vr": "TM", "Value": ["094947.756000"]}, "689": {"vr": "TM", "Value": ["094527.880000"]}, "690": {"vr": "TM", "Value": ["095007.788000"]}, "691": {"vr": "TM", "Value": ["094547.726000"]}, "692": {"vr": "TM", "Value": ["094547.859000"]}, "693": {"vr": "TM", "Value": ["094547.942000"]}, "694": {"vr": "TM", "Value": ["094947.642000"]}, "695": {"vr": "TM", "Value": ["094607.799000"]}, "696": {"vr": "TM", "Value": ["095227.904000"]}, "697": {"vr": "TM", "Value": ["094927.632000"]}, "698": {"vr": "TM", "Value": ["095107.803000"]}, "699": {"vr": "TM", "Value": ["094847.626000"]}, "700": {"vr": "TM", "Value": ["094607.727000"]}, "701": {"vr": "TM", "Value": ["095227.915000"]}, "702": {"vr": "TM", "Value": ["094547.739000"]}, "703": {"vr": "TM", "Value": ["095307.671000"]}, "704": {"vr": "TM", "Value": ["094807.788000"]}, "705": {"vr": "TM", "Value": ["094827.641000"]}, "706": {"vr": "TM", "Value": ["095127.618000"]}, "707": {"vr": "TM", "Value": ["094707.649000"]}, "708": {"vr": "TM", "Value": ["094847.719000"]}, "709": {"vr": "TM", "Value": ["095247.815000"]}, "710": {"vr": "TM", "Value": ["095307.830000"]}, "711": {"vr": "TM", "Value": ["095227.615000"]}, "712": {"vr": "TM", "Value": ["094527.848000"]}, "713": {"vr": "TM", "Value": ["095047.887000"]}, "714": {"vr": "TM", "Value": ["094827.879000"]}, "715": {"vr": "TM", "Value": ["095147.751000"]}, "716": {"vr": "TM", "Value": ["095207.874000"]}, "717": {"vr": "TM", "Value": ["095307.931000"]}, "718": {"vr": "TM", "Value": ["095407.666000"]}, "719": {"vr": "TM", "Value": ["094947.900000"]}, "720": {"vr": "TM", "Value": ["094607.946000"]}, "721": {"vr": "TM", "Value": ["095107.786000"]}, "722": {"vr": "TM", "Value": ["094647.735000"]}, "723": {"vr": "TM", "Value": ["095447.642000"]}, "724": {"vr": "TM", "Value": ["095247.708000"]}, "725": {"vr": "TM", "Value": ["094547.661000"]}, "726": {"vr": "TM", "Value": ["095407.929000"]}, "727": {"vr": "TM", "Value": ["095407.623000"]}, "728": {"vr": "TM", "Value": ["094527.990000"]}, "729": {"vr": "TM", "Value": ["095407.940000"]}, "730": {"vr": "TM", "Value": ["095027.622000"]}, "731": {"vr": "TM", "Value": ["094907.782000"]}, "732": {"vr": "TM", "Value": ["094647.962000"]}, "733": {"vr": "TM", "Value": ["095427.916000"]}, "734": {"vr": "TM", "Value": ["094547.936000"]}, "735": {"vr": "TM", "Value": ["094907.728000"]}, "736": {"vr": "TM", "Value": ["094727.855000"]}, "737": {"vr": "TM", "Value": ["094627.712000"]}, "738": {"vr": "TM", "Value": ["095307.745000"]}, "739": {"vr": "TM", "Value": ["094527.779000"]}, "740": {"vr": "TM", "Value": ["094647.875000"]}, "741": {"vr": "TM", "Value": ["094607.683000"]}, "742": {"vr": "TM", "Value": ["094707.825000"]}, "743": {"vr": "TM", "Value": ["095327.914000"]}, "744": {"vr": "TM", "Value": ["095107.757000"]}, "745": {"vr": "TM", "Value": ["094707.714000"]}, "746": {"vr": "TM", "Value": ["094707.787000"]}, "747": {"vr": "TM", "Value": ["095047.858000"]}, "748": {"vr": "TM", "Value": ["095147.667000"]}, "749": {"vr": "TM", "Value": ["095207.696000"]}, "750": {"vr": "TM", "Value": ["095447.819000"]}, "751": {"vr": "TM", "Value": ["094807.824000"]}, "752": {"vr": "TM", "Value": ["095247.729000"]}, "753": {"vr": "TM", "Value": ["094627.672000"]}, "754": {"vr": "TM", "Value": ["095207.759000"]}, "755": {"vr": "TM", "Value": ["094947.820000"]}, "756": {"vr": "TM", "Value": ["094827.829000"]}, "757": {"vr": "TM", "Value": ["095456.493000"]}, "758": {"vr": "TM", "Value": ["094747.951000"]}, "759": {"vr": "TM", "Value": ["094547.891000"]}, "760": {"vr": "TM", "Value": ["094727.906000"]}, "761": {"vr": "TM", "Value": ["094747.927000"]}, "762": {"vr": "TM", "Value": ["095447.623000"]}, "763": {"vr": "TM", "Value": ["095147.670000"]}, "764": {"vr": "TM", "Value": ["095007.651000"]}, "765": {"vr": "TM", "Value": ["094727.630000"]}, "766": {"vr": "TM", "Value": ["094727.716000"]}, "767": {"vr": "TM", "Value": ["095327.842000"]}, "768": {"vr": "TM", "Value": ["095047.787000"]}, "769": {"vr": "TM", "Value": ["095227.858000"]}, "770": {"vr": "TM", "Value": ["094827.799000"]}, "771": {"vr": "TM", "Value": ["095456.510000"]}, "772": {"vr": "TM", "Value": ["094907.758000"]}, "773": {"vr": "TM", "Value": ["095407.927000"]}, "774": {"vr": "TM", "Value": ["094747.869000"]}, "775": {"vr": "TM", "Value": ["094727.652000"]}, "776": {"vr": "TM", "Value": ["094847.882000"]}, "777": {"vr": "TM", "Value": ["095007.839000"]}, "778": {"vr": "TM", "Value": ["095447.724000"]}, "779": {"vr": "TM", "Value": ["094547.832000"]}, "780": {"vr": "TM", "Value": ["095047.921000"]}, "781": {"vr": "TM", "Value": ["094907.698000"]}, "782": {"vr": "TM", "Value": ["095427.628000"]}, "783": {"vr": "TM", "Value": ["095207.892000"]}, "784": {"vr": "TM", "Value": ["094527.910000"]}, "785": {"vr": "TM", "Value": ["095207.654000"]}, "786": {"vr": "TM", "Value": ["095047.871000"]}, "787": {"vr": "TM", "Value": ["094707.763000"]}, "788": {"vr": "TM", "Value": ["095327.716000"]}, "789": {"vr": "TM", "Value": ["094827.670000"]}, "790": {"vr": "TM", "Value": ["095407.802000"]}, "791": {"vr": "TM", "Value": ["095327.755000"]}, "792": {"vr": "TM", "Value": ["094607.626000"]}, "793": {"vr": "TM", "Value": ["095207.698000"]}, "794": {"vr": "TM", "Value": ["094827.659000"]}, "795": {"vr": "TM", "Value": ["094907.858000"]}, "796": {"vr": "TM", "Value": ["094747.892000"]}, "797": {"vr": "TM", "Value": ["095107.840000"]}, "798": {"vr": "TM", "Value": ["095207.785000"]}, "799": {"vr": "TM", "Value": ["094547.779000"]}, "800": {"vr": "TM", "Value": ["094627.960000"]}, "801": {"vr": "TM", "Value": ["094527.781000"]}, "802": {"vr": "TM", "Value": ["094627.704000"]}, "803": {"vr": "TM", "Value": ["095247.770000"]}, "804": {"vr": "TM", "Value": ["095247.691000"]}, "805": {"vr": "TM", "Value": ["094807.834000"]}, "806": {"vr": "TM", "Value": ["095107.864000"]}, "807": {"vr": "TM", "Value": ["095227.824000"]}, "808": {"vr": "TM", "Value": ["094807.661000"]}, "809": {"vr": "TM", "Value": ["095027.826000"]}, "810": {"vr": "TM", "Value": ["095007.899000"]}, "811": {"vr": "TM", "Value": ["095207.861000"]}, "812": {"vr": "TM", "Value": ["094927.628000"]}, "813": {"vr": "TM", "Value": ["095047.628000"]}, "814": {"vr": "TM", "Value": ["095107.810000"]}, "815": {"vr": "TM", "Value": ["095447.611000"]}, "816": {"vr": "TM", "Value": ["095327.782000"]}, "817": {"vr": "TM", "Value": ["095447.765000"]}, "818": {"vr": "TM", "Value": ["095047.676000"]}, "819": {"vr": "TM", "Value": ["094927.931000"]}, "820": {"vr": "TM", "Value": ["095327.689000"]}, "821": {"vr": "TM", "Value": ["095327.652000"]}, "822": {"vr": "TM", "Value": ["094847.743000"]}, "823": {"vr": "TM", "Value": ["095127.741000"]}, "824": {"vr": "TM", "Value": ["095247.912000"]}, "825": {"vr": "TM", "Value": ["095127.637000"]}, "826": {"vr": "TM", "Value": ["094807.955000"]}, "827": {"vr": "TM", "Value": ["095456.462000"]}, "828": {"vr": "TM", "Value": ["094947.690000"]}, "829": {"vr": "TM", "Value": ["095147.753000"]}, "830": {"vr": "TM", "Value": ["094607.885000"]}, "831": {"vr": "TM", "Value": ["094827.722000"]}, "832": {"vr": "TM", "Value": ["094747.787000"]}, "833": {"vr": "TM", "Value": ["094647.663000"]}, "834": {"vr": "TM", "Value": ["094627.702000"]}, "835": {"vr": "TM", "Value": ["095447.842000"]}, "836": {"vr": "TM", "Value": ["094827.823000"]}, "837": {"vr": "TM", "Value": ["094627.724000"]}, "838": {"vr": "TM", "Value": ["094547.895000"]}, "839": {"vr": "TM", "Value": ["094727.746000"]}, "840": {"vr": "TM", "Value": ["095307.946000"]}, "841": {"vr": "TM", "Value": ["095147.866000"]}, "842": {"vr": "TM", "Value": ["094607.698000"]}, "843": {"vr": "TM", "Value": ["095007.748000"]}, "844": {"vr": "TM", "Value": ["094807.616000"]}, "845": {"vr": "TM", "Value": ["094547.766000"]}, "846": {"vr": "TM", "Value": ["095007.858000"]}, "847": {"vr": "TM", "Value": ["095207.770000"]}, "848": {"vr": "TM", "Value": ["094947.877000"]}, "849": {"vr": "TM", "Value": ["094627.751000"]}, "850": {"vr": "TM", "Value": ["095147.719000"]}, "851": {"vr": "TM", "Value": ["095047.625000"]}, "852": {"vr": "TM", "Value": ["095027.946000"]}, "853": {"vr": "TM", "Value": ["095227.739000"]}, "854": {"vr": "TM", "Value": ["094747.734000"]}, "855": {"vr": "TM", "Value": ["094727.841000"]}, "856": {"vr": "TM", "Value": ["094927.801000"]}, "857": {"vr": "TM", "Value": ["095107.921000"]}, "858": {"vr": "TM", "Value": ["094807.643000"]}, "859": {"vr": "TM", "Value": ["094607.874000"]}, "860": {"vr": "TM", "Value": ["094847.701000"]}, "861": {"vr": "TM", "Value": ["095456.414000"]}, "862": {"vr": "TM", "Value": ["095347.881000"]}, "863": {"vr": "TM", "Value": ["095127.865000"]}, "864": {"vr": "TM", "Value": ["095447.804000"]}, "865": {"vr": "TM", "Value": ["094907.658000"]}, "866": {"vr": "TM", "Value": ["095207.931000"]}, "867": {"vr": "TM", "Value": ["094707.632000"]}, "868": {"vr": "TM", "Value": ["095147.743000"]}, "869": {"vr": "TM", "Value": ["094707.753000"]}, "870": {"vr": "TM", "Value": ["094827.909000"]}, "871": {"vr": "TM", "Value": ["094927.842000"]}, "872": {"vr": "TM", "Value": ["094547.659000"]}, "873": {"vr": "TM", "Value": ["095347.735000"]}, "874": {"vr": "TM", "Value": ["095207.624000"]}, "875": {"vr": "TM", "Value": ["094527.758000"]}, "876": {"vr": "TM", "Value": ["094707.835000"]}, "877": {"vr": "TM", "Value": ["094607.911000"]}, "878": {"vr": "TM", "Value": ["095347.815000"]}, "879": {"vr": "TM", "Value": ["094547.734000"]}, "880": {"vr": "TM", "Value": ["094607.794000"]}, "881": {"vr": "TM", "Value": ["094727.610000"]}, "882": {"vr": "TM", "Value": ["094607.866000"]}, "883": {"vr": "TM", "Value": ["094707.856000"]}, "884": {"vr": "TM", "Value": ["095327.904000"]}, "885": {"vr": "TM", "Value": ["095456.544000"]}, "886": {"vr": "TM", "Value": ["094727.786000"]}, "887": {"vr": "TM", "Value": ["094947.910000"]}, "888": {"vr": "TM", "Value": ["094707.750000"]}, "889": {"vr": "TM", "Value": ["094607.666000"]}, "890": {"vr": "TM", "Value": ["094747.954000"]}, "891": {"vr": "TM", "Value": ["095007.776000"]}, "892": {"vr": "TM", "Value": ["095427.649000"]}, "893": {"vr": "TM", "Value": ["095047.813000"]}, "894": {"vr": "TM", "Value": ["094747.819000"]}, "895": {"vr": "TM", "Value": ["095007.634000"]}, "896": {"vr": "TM", "Value": ["094647.727000"]}, "897": {"vr": "TM", "Value": ["095007.641000"]}, "898": {"vr": "TM", "Value": ["095027.867000"]}, "899": {"vr": "TM", "Value": ["094907.628000"]}, "900": {"vr": "TM", "Value": ["094927.893000"]}, "901": {"vr": "TM", "Value": ["094607.941000"]}, "902": {"vr": "TM", "Value": ["095027.941000"]}, "903": {"vr": "TM", "Value": ["095447.928000"]}, "904": {"vr": "TM", "Value": ["094627.677000"]}, "905": {"vr": "TM", "Value": ["094727.919000"]}, "906": {"vr": "TM", "Value": ["094627.645000"]}, "907": {"vr": "TM", "Value": ["095207.772000"]}, "908": {"vr": "TM", "Value": ["095007.656000"]}, "909": {"vr": "TM", "Value": ["095447.742000"]}, "910": {"vr": "TM", "Value": ["095107.859000"]}, "911": {"vr": "TM", "Value": ["094907.780000"]}, "912": {"vr": "TM", "Value": ["095427.830000"]}, "913": {"vr": "TM", "Value": ["095127.608000"]}, "914": {"vr": "TM", "Value": ["094727.857000"]}, "915": {"vr": "TM", "Value": ["095047.792000"]}, "916": {"vr": "TM", "Value": ["095427.921000"]}, "917": {"vr": "TM", "Value": ["095147.864000"]}, "918": {"vr": "TM", "Value": ["095307.676000"]}, "919": {"vr": "TM", "Value": ["094527.700000"]}, "920": {"vr": "TM", "Value": ["094647.816000"]}, "921": {"vr": "TM", "Value": ["094807.753000"]}, "922": {"vr": "TM", "Value": ["095307.663000"]}, "923": {"vr": "TM", "Value": ["095227.932000"]}, "924": {"vr": "TM", "Value": ["094527.622000"]}, "925": {"vr": "TM", "Value": ["094547.893000"]}, "926": {"vr": "TM", "Value": ["095456.427000"]}, "927": {"vr": "TM", "Value": ["095207.747000"]}, "928": {"vr": "TM", "Value": ["095347.626000"]}, "929": {"vr": "TM", "Value": ["095047.620000"]}, "930": {"vr": "TM", "Value": ["094947.778000"]}, "931": {"vr": "TM", "Value": ["095007.768000"]}, "932": {"vr": "TM", "Value": ["095456.476000"]}, "933": {"vr": "TM", "Value": ["095127.644000"]}, "934": {"vr": "TM", "Value": ["094547.753000"]}, "935": {"vr": "TM", "Value": ["094927.840000"]}, "936": {"vr": "TM", "Value": ["095147.825000"]}, "937": {"vr": "TM", "Value": ["094927.819000"]}, "938": {"vr": "TM", "Value": ["095456.404000"]}, "939": {"vr": "TM", "Value": ["094907.691000"]}, "940": {"vr": "TM", "Value": ["095307.820000"]}, "941": {"vr": "TM", "Value": ["095307.773000"]}, "942": {"vr": "TM", "Value": ["094707.953000"]}, "943": {"vr": "TM", "Value": ["094927.822000"]}, "944": {"vr": "TM", "Value": ["095127.772000"]}, "945": {"vr": "TM", "Value": ["095407.862000"]}, "946": {"vr": "TM", "Value": ["095127.658000"]}, "947": {"vr": "TM", "Value": ["094907.929000"]}, "948": {"vr": "TM", "Value": ["095147.823000"]}, "949": {"vr": "TM", "Value": ["094827.709000"]}, "950": {"vr": "TM", "Value": ["095247.928000"]}, "951": {"vr": "TM", "Value": ["094907.919000"]}, "952": {"vr": "TM", "Value": ["094727.677000"]}, "953": {"vr": "TM", "Value": ["095027.842000"]}, "954": {"vr": "TM", "Value": ["095227.630000"]}, "955": {"vr": "TM", "Value": ["094607.830000"]}, "956": {"vr": "TM", "Value": ["095147.840000"]}, "957": {"vr": "TM", "Value": ["094907.861000"]}, "958": {"vr": "TM", "Value": ["095247.891000"]}, "959": {"vr": "TM", "Value": ["094827.688000"]}, "960": {"vr": "TM", "Value": ["094927.768000"]}, "961": {"vr": "TM", "Value": ["095007.831000"]}, "962": {"vr": "TM", "Value": ["095307.840000"]}, "963": {"vr": "TM", "Value": ["095207.798000"]}, "964": {"vr": "TM", "Value": ["094647.862000"]}, "965": {"vr": "TM", "Value": ["094747.816000"]}, "966": {"vr": "TM", "Value": ["094927.702000"]}, "967": {"vr": "TM", "Value": ["095407.735000"]}, "968": {"vr": "TM", "Value": ["094707.938000"]}, "969": {"vr": "TM", "Value": ["094727.642000"]}, "970": {"vr": "TM", "Value": ["094527.977000"]}, "971": {"vr": "TM", "Value": ["094727.768000"]}, "972": {"vr": "TM", "Value": ["095407.867000"]}, "973": {"vr": "TM", "Value": ["095327.876000"]}, "974": {"vr": "TM", "Value": ["095047.693000"]}, "975": {"vr": "TM", "Value": ["095127.919000"]}, "976": {"vr": "TM", "Value": ["094807.614000"]}, "977": {"vr": "TM", "Value": ["094947.773000"]}, "978": {"vr": "TM", "Value": ["095456.507000"]}, "979": {"vr": "TM", "Value": ["095147.895000"]}, "980": {"vr": "TM", "Value": ["095207.686000"]}, "981": {"vr": "TM", "Value": ["095347.766000"]}, "982": {"vr": "TM", "Value": ["094907.842000"]}, "983": {"vr": "TM", "Value": ["095147.837000"]}, "984": {"vr": "TM", "Value": ["095307.641000"]}, "985": {"vr": "TM", "Value": ["094947.770000"]}, "986": {"vr": "TM", "Value": ["094847.725000"]}, "987": {"vr": "TM", "Value": ["094527.987000"]}, "988": {"vr": "TM", "Value": ["095347.618000"]}, "989": {"vr": "TM", "Value": ["094927.704000"]}, "990": {"vr": "TM", "Value": ["094947.801000"]}, "991": {"vr": "TM", "Value": ["095407.852000"]}, "992": {"vr": "TM", "Value": ["094827.631000"]}, "993": {"vr": "TM", "Value": ["095427.807000"]}, "994": {"vr": "TM", "Value": ["094647.751000"]}, "995": {"vr": "TM", "Value": ["095307.827000"]}, "996": {"vr": "TM", "Value": ["095456.410000"]}, "997": {"vr": "TM", "Value": ["095227.709000"]}, "998": {"vr": "TM", "Value": ["095307.613000"]}, "999": {"vr": "TM", "Value": ["095427.951000"]}, "1000": {"vr": "TM", "Value": ["095007.636000"]}, "1001": {"vr": "TM", "Value": ["095447.616000"]}, "1002": {"vr": "TM", "Value": ["094607.715000"]}, "1003": {"vr": "TM", "Value": ["094747.657000"]}, "1004": {"vr": "TM", "Value": ["095347.764000"]}, "1005": {"vr": "TM", "Value": ["095207.614000"]}, "1006": {"vr": "TM", "Value": ["095227.801000"]}, "1007": {"vr": "TM", "Value": ["094727.673000"]}, "1008": {"vr": "TM", "Value": ["094627.679000"]}, "1009": {"vr": "TM", "Value": ["094727.794000"]}, "1010": {"vr": "TM", "Value": ["095347.677000"]}, "1011": {"vr": "TM", "Value": ["095447.866000"]}, "1012": {"vr": "TM", "Value": ["095227.653000"]}, "1013": {"vr": "TM", "Value": ["095227.806000"]}, "1014": {"vr": "TM", "Value": ["095147.907000"]}, "1015": {"vr": "TM", "Value": ["095456.522000"]}, "1016": {"vr": "TM", "Value": ["094827.949000"]}, "1017": {"vr": "TM", "Value": ["095447.659000"]}, "1018": {"vr": "TM", "Value": ["094807.635000"]}, "1019": {"vr": "TM", "Value": ["095347.894000"]}, "1020": {"vr": "TM", "Value": ["095207.884000"]}, "1021": {"vr": "TM", "Value": ["095427.797000"]}, "1022": {"vr": "TM", "Value": ["094847.803000"]}, "1023": {"vr": "TM", "Value": ["094907.909000"]}, "1024": {"vr": "TM", "Value": ["095227.696000"]}, "1025": {"vr": "TM", "Value": ["094547.751000"]}, "1026": {"vr": "TM", "Value": ["094547.879000"]}, "1027": {"vr": "TM", "Value": ["095207.905000"]}, "1028": {"vr": "TM", "Value": ["095347.715000"]}, "1029": {"vr": "TM", "Value": ["095047.923000"]}, "1030": {"vr": "TM", "Value": ["094527.753000"]}, "1031": {"vr": "TM", "Value": ["094647.698000"]}, "1032": {"vr": "TM", "Value": ["094827.868000"]}, "1033": {"vr": "TM", "Value": ["094947.624000"]}, "1034": {"vr": "TM", "Value": ["094647.873000"]}, "1035": {"vr": "TM", "Value": ["095407.674000"]}, "1036": {"vr": "TM", "Value": ["094847.867000"]}, "1037": {"vr": "TM", "Value": ["095107.736000"]}, "1038": {"vr": "TM", "Value": ["094627.945000"]}, "1039": {"vr": "TM", "Value": ["094847.607000"]}, "1040": {"vr": "TM", "Value": ["094827.712000"]}, "1041": {"vr": "TM", "Value": ["095207.879000"]}, "1042": {"vr": "TM", "Value": ["094827.747000"]}, "1043": {"vr": "TM", "Value": ["095027.751000"]}, "1044": {"vr": "TM", "Value": ["094807.792000"]}, "1045": {"vr": "TM", "Value": ["094607.708000"]}, "1046": {"vr": "TM", "Value": ["095107.791000"]}, "1047": {"vr": "TM", "Value": ["095407.903000"]}, "1048": {"vr": "TM", "Value": ["095427.766000"]}, "1049": {"vr": "TM", "Value": ["094547.756000"]}, "1050": {"vr": "TM", "Value": ["095047.777000"]}, "1051": {"vr": "TM", "Value": ["095007.616000"]}, "1052": {"vr": "TM", "Value": ["094647.693000"]}, "1053": {"vr": "TM", "Value": ["095107.796000"]}, "1054": {"vr": "TM", "Value": ["094627.918000"]}, "1055": {"vr": "TM", "Value": ["094847.662000"]}, "1056": {"vr": "TM", "Value": ["095307.812000"]}, "1057": {"vr": "TM", "Value": ["095427.690000"]}, "1058": {"vr": "TM", "Value": ["095227.712000"]}, "1059": {"vr": "TM", "Value": ["094907.762000"]}, "1060": {"vr": "TM", "Value": ["094527.735000"]}, "1061": {"vr": "TM", "Value": ["094547.862000"]}, "1062": {"vr": "TM", "Value": ["094727.833000"]}, "1063": {"vr": "TM", "Value": ["094847.716000"]}, "1064": {"vr": "TM", "Value": ["094727.921000"]}, "1065": {"vr": "TM", "Value": ["094847.610000"]}, "1066": {"vr": "TM", "Value": ["094907.616000"]}, "1067": {"vr": "TM", "Value": ["095207.841000"]}, "1068": {"vr": "TM", "Value": ["095307.951000"]}, "1069": {"vr": "TM", "Value": ["095047.963000"]}, "1070": {"vr": "TM", "Value": ["094727.660000"]}, "1071": {"vr": "TM", "Value": ["095307.761000"]}, "1072": {"vr": "TM", "Value": ["095207.921000"]}, "1073": {"vr": "TM", "Value": ["095456.478000"]}, "1074": {"vr": "TM", "Value": ["095447.935000"]}, "1075": {"vr": "TM", "Value": ["094647.759000"]}, "1076": {"vr": "TM", "Value": ["095107.653000"]}, "1077": {"vr": "TM", "Value": ["095227.939000"]}, "1078": {"vr": "TM", "Value": ["094727.647000"]}, "1079": {"vr": "TM", "Value": ["095307.856000"]}, "1080": {"vr": "TM", "Value": ["094827.766000"]}, "1081": {"vr": "TM", "Value": ["094647.960000"]}, "1082": {"vr": "TM", "Value": ["095207.894000"]}, "1083": {"vr": "TM", "Value": ["095207.936000"]}, "1084": {"vr": "TM", "Value": ["094627.697000"]}, "1085": {"vr": "TM", "Value": ["095307.799000"]}, "1086": {"vr": "TM", "Value": ["095207.838000"]}, "1087": {"vr": "TM", "Value": ["095207.872000"]}, "1088": {"vr": "TM", "Value": ["095327.792000"]}, "1089": {"vr": "TM", "Value": ["095207.661000"]}, "1090": {"vr": "TM", "Value": ["095007.808000"]}, "1091": {"vr": "TM", "Value": ["094847.624000"]}, "1092": {"vr": "TM", "Value": ["095147.923000"]}, "1093": {"vr": "TM", "Value": ["094627.773000"]}, "1094": {"vr": "TM", "Value": ["095447.627000"]}, "1095": {"vr": "TM", "Value": ["095227.734000"]}, "1096": {"vr": "TM", "Value": ["095127.623000"]}, "1097": {"vr": "TM", "Value": ["094827.947000"]}, "1098": {"vr": "TM", "Value": ["095347.615000"]}, "1099": {"vr": "TM", "Value": ["095127.903000"]}, "1100": {"vr": "TM", "Value": ["094947.905000"]}, "1101": {"vr": "TM", "Value": ["095127.829000"]}, "1102": {"vr": "TM", "Value": ["095127.694000"]}, "1103": {"vr": "TM", "Value": ["095307.886000"]}, "1104": {"vr": "TM", "Value": ["094647.690000"]}, "1105": {"vr": "TM", "Value": ["095147.741000"]}, "1106": {"vr": "TM", "Value": ["094647.714000"]}, "1107": {"vr": "TM", "Value": ["095007.669000"]}, "1108": {"vr": "TM", "Value": ["094747.620000"]}, "1109": {"vr": "TM", "Value": ["095427.871000"]}, "1110": {"vr": "TM", "Value": ["095327.664000"]}, "1111": {"vr": "TM", "Value": ["094807.778000"]}, "1112": {"vr": "TM", "Value": ["094727.741000"]}, "1113": {"vr": "TM", "Value": ["095207.667000"]}, "1114": {"vr": "TM", "Value": ["094947.935000"]}, "1115": {"vr": "TM", "Value": ["095427.693000"]}, "1116": {"vr": "TM", "Value": ["094527.907000"]}, "1117": {"vr": "TM", "Value": ["095247.687000"]}, "1118": {"vr": "TM", "Value": ["094727.690000"]}, "1119": {"vr": "TM", "Value": ["095427.671000"]}, "1120": {"vr": "TM", "Value": ["095427.931000"]}, "1121": {"vr": "TM", "Value": ["094947.808000"]}, "1122": {"vr": "TM", "Value": ["094727.640000"]}, "1123": {"vr": "TM", "Value": ["094627.632000"]}, "1124": {"vr": "TM", "Value": ["094947.658000"]}, "1125": {"vr": "TM", "Value": ["094927.651000"]}, "1126": {"vr": "TM", "Value": ["095447.911000"]}, "1127": {"vr": "TM", "Value": ["094647.833000"]}, "1128": {"vr": "TM", "Value": ["095127.779000"]}, "1129": {"vr": "TM", "Value": ["094847.819000"]}, "1130": {"vr": "TM", "Value": ["095427.873000"]}, "1131": {"vr": "TM", "Value": ["094707.678000"]}, "1132": {"vr": "TM", "Value": ["094647.857000"]}, "1133": {"vr": "TM", "Value": ["095107.706000"]}, "1134": {"vr": "TM", "Value": ["095227.637000"]}, "1135": {"vr": "TM", "Value": ["094927.719000"]}, "1136": {"vr": "TM", "Value": ["094827.929000"]}, "1137": {"vr": "TM", "Value": ["095307.627000"]}, "1138": {"vr": "TM", "Value": ["094647.680000"]}, "1139": {"vr": "TM", "Value": ["095027.632000"]}, "1140": {"vr": "TM", "Value": ["094607.641000"]}, "1141": {"vr": "TM", "Value": ["094907.725000"]}, "1142": {"vr": "TM", "Value": ["094627.607000"]}, "1143": {"vr": "TM", "Value": ["094647.675000"]}, "1144": {"vr": "TM", "Value": ["094747.617000"]}, "1145": {"vr": "TM", "Value": ["095007.743000"]}, "1146": {"vr": "TM", "Value": ["094827.615000"]}, "1147": {"vr": "TM", "Value": ["095456.502000"]}, "1148": {"vr": "TM", "Value": ["094707.651000"]}, "1149": {"vr": "TM", "Value": ["094527.666000"]}, "1150": {"vr": "TM", "Value": ["095447.721000"]}, "1151": {"vr": "TM", "Value": ["094927.858000"]}, "1152": {"vr": "TM", "Value": ["095047.674000"]}, "1153": {"vr": "TM", "Value": ["095007.733000"]}, "1154": {"vr": "TM", "Value": ["095107.613000"]}, "1155": {"vr": "TM", "Value": ["095047.723000"]}, "1156": {"vr": "TM", "Value": ["094647.846000"]}, "1157": {"vr": "TM", "Value": ["094547.657000"]}, "1158": {"vr": "TM", "Value": ["095247.901000"]}, "1159": {"vr": "TM", "Value": ["095007.674000"]}, "1160": {"vr": "TM", "Value": ["095107.741000"]}, "1161": {"vr": "TM", "Value": ["094707.727000"]}, "1162": {"vr": "TM", "Value": ["095127.827000"]}, "1163": {"vr": "TM", "Value": ["095127.744000"]}, "1164": {"vr": "TM", "Value": ["094927.770000"]}, "1165": {"vr": "TM", "Value": ["095327.765000"]}, "1166": {"vr": "TM", "Value": ["094527.740000"]}, "1167": {"vr": "TM", "Value": ["095227.849000"]}, "1168": {"vr": "TM", "Value": ["094607.804000"]}, "1169": {"vr": "TM", "Value": ["095307.794000"]}, "1170": {"vr": "TM", "Value": ["095327.873000"]}, "1171": {"vr": "TM", "Value": ["094627.881000"]}, "1172": {"vr": "TM", "Value": ["095147.913000"]}, "1173": {"vr": "TM", "Value": ["095407.924000"]}, "1174": {"vr": "TM", "Value": ["095207.619000"]}, "1175": {"vr": "TM", "Value": ["095247.746000"]}, "1176": {"vr": "TM", "Value": ["095247.635000"]}, "1177": {"vr": "TM", "Value": ["095347.684000"]}, "1178": {"vr": "TM", "Value": ["094527.767000"]}, "1179": {"vr": "TM", "Value": ["094747.654000"]}, "1180": {"vr": "TM", "Value": ["094907.738000"]}, "1181": {"vr": "TM", "Value": ["094847.787000"]}, "1182": {"vr": "TM", "Value": ["094547.918000"]}, "1183": {"vr": "TM", "Value": ["095027.847000"]}, "1184": {"vr": "TM", "Value": ["095307.758000"]}, "1185": {"vr": "TM", "Value": ["094907.806000"]}, "1186": {"vr": "TM", "Value": ["094547.712000"]}, "1187": {"vr": "TM", "Value": ["094947.796000"]}, "1188": {"vr": "TM", "Value": ["095247.841000"]}, "1189": {"vr": "TM", "Value": ["095327.694000"]}, "1190": {"vr": "TM", "Value": ["095407.817000"]}, "1191": {"vr": "TM", "Value": ["094527.729000"]}, "1192": {"vr": "TM", "Value": ["094707.745000"]}, "1193": {"vr": "TM", "Value": ["095007.861000"]}, "1194": {"vr": "TM", "Value": ["095447.894000"]}, "1195": {"vr": "TM", "Value": ["094927.735000"]}, "1196": {"vr": "TM", "Value": ["094547.691000"]}, "1197": {"vr": "TM", "Value": ["095427.666000"]}, "1198": {"vr": "TM", "Value": ["094847.641000"]}, "1199": {"vr": "TM", "Value": ["095207.869000"]}, "1200": {"vr": "TM", "Value": ["095307.889000"]}, "1201": {"vr": "TM", "Value": ["094527.689000"]}, "1202": {"vr": "TM", "Value": ["094707.609000"]}, "1203": {"vr": "TM", "Value": ["095447.737000"]}, "1204": {"vr": "TM", "Value": ["095227.899000"]}, "1205": {"vr": "TM", "Value": ["095047.941000"]}, "1206": {"vr": "TM", "Value": ["095327.922000"]}, "1207": {"vr": "TM", "Value": ["095127.748000"]}, "1208": {"vr": "TM", "Value": ["094547.610000"]}, "1209": {"vr": "TM", "Value": ["094547.920000"]}, "1210": {"vr": "TM", "Value": ["095047.635000"]}, "1211": {"vr": "TM", "Value": ["095447.675000"]}, "1212": {"vr": "TM", "Value": ["094727.939000"]}, "1213": {"vr": "TM", "Value": ["095027.700000"]}, "1214": {"vr": "TM", "Value": ["095407.723000"]}, "1215": {"vr": "TM", "Value": ["095047.810000"]}, "1216": {"vr": "TM", "Value": ["095207.902000"]}, "1217": {"vr": "TM", "Value": ["095227.871000"]}, "1218": {"vr": "TM", "Value": ["094527.943000"]}, "1219": {"vr": "TM", "Value": ["095327.699000"]}, "1220": {"vr": "TM", "Value": ["095327.777000"]}, "1221": {"vr": "TM", "Value": ["095427.724000"]}, "1222": {"vr": "TM", "Value": ["094707.943000"]}, "1223": {"vr": "TM", "Value": ["095407.656000"]}, "1224": {"vr": "TM", "Value": ["094847.930000"]}, "1225": {"vr": "TM", "Value": ["094547.731000"]}, "1226": {"vr": "TM", "Value": ["094527.955000"]}, "1227": {"vr": "TM", "Value": ["095427.773000"]}, "1228": {"vr": "TM", "Value": ["095427.700000"]}, "1229": {"vr": "TM", "Value": ["095207.611000"]}, "1230": {"vr": "TM", "Value": ["095127.862000"]}, "1231": {"vr": "TM", "Value": ["095347.776000"]}, "1232": {"vr": "TM", "Value": ["095407.951000"]}, "1233": {"vr": "TM", "Value": ["094747.731000"]}, "1234": {"vr": "TM", "Value": ["094647.614000"]}, "1235": {"vr": "TM", "Value": ["094827.740000"]}, "1236": {"vr": "TM", "Value": ["094547.689000"]}, "1237": {"vr": "TM", "Value": ["095447.814000"]}, "1238": {"vr": "TM", "Value": ["094827.733000"]}, "1239": {"vr": "TM", "Value": ["094707.692000"]}, "1240": {"vr": "TM", "Value": ["094707.912000"]}, "1241": {"vr": "TM", "Value": ["094527.857000"]}, "1242": {"vr": "TM", "Value": ["095207.631000"]}, "1243": {"vr": "TM", "Value": ["095247.763000"]}, "1244": {"vr": "TM", "Value": ["095047.800000"]}, "1245": {"vr": "TM", "Value": ["094907.619000"]}, "1246": {"vr": "TM", "Value": ["095247.755000"]}, "1247": {"vr": "TM", "Value": ["094747.662000"]}, "1248": {"vr": "TM", "Value": ["095007.687000"]}, "1249": {"vr": "TM", "Value": ["095347.779000"]}, "1250": {"vr": "TM", "Value": ["094547.928000"]}, "1251": {"vr": "TM", "Value": ["095127.934000"]}, "1252": {"vr": "TM", "Value": ["095007.679000"]}, "1253": {"vr": "TM", "Value": ["095327.909000"]}, "1254": {"vr": "TM", "Value": ["094847.649000"]}, "1255": {"vr": "TM", "Value": ["094847.887000"]}, "1256": {"vr": "TM", "Value": ["095227.640000"]}, "1257": {"vr": "TM", "Value": ["094527.916000"]}, "1258": {"vr": "TM", "Value": ["094607.864000"]}, "1259": {"vr": "TM", "Value": ["095307.611000"]}, "1260": {"vr": "TM", "Value": ["095147.727000"]}, "1261": {"vr": "TM", "Value": ["094647.732000"]}, "1262": {"vr": "TM", "Value": ["094747.636000"]}, "1263": {"vr": "TM", "Value": ["095147.910000"]}, "1264": {"vr": "TM", "Value": ["094707.656000"]}, "1265": {"vr": "TM", "Value": ["094727.665000"]}, "1266": {"vr": "TM", "Value": ["094807.666000"]}, "1267": {"vr": "TM", "Value": ["095047.759000"]}, "1268": {"vr": "TM", "Value": ["095007.629000"]}, "1269": {"vr": "TM", "Value": ["094607.812000"]}, "1270": {"vr": "TM", "Value": ["094627.916000"]}, "1271": {"vr": "TM", "Value": ["095456.495000"]}, "1272": {"vr": "TM", "Value": ["094927.860000"]}, "1273": {"vr": "TM", "Value": ["094727.723000"]}, "1274": {"vr": "TM", "Value": ["095207.718000"]}, "1275": {"vr": "TM", "Value": ["095307.639000"]}, "1276": {"vr": "TM", "Value": ["095407.794000"]}, "1277": {"vr": "TM", "Value": ["095427.743000"]}, "1278": {"vr": "TM", "Value": ["094927.714000"]}, "1279": {"vr": "TM", "Value": ["094907.730000"]}, "1280": {"vr": "TM", "Value": ["094607.740000"]}, "1281": {"vr": "TM", "Value": ["095207.793000"]}, "1282": {"vr": "TM", "Value": ["094707.682000"]}, "1283": {"vr": "TM", "Value": ["095207.749000"]}, "1284": {"vr": "TM", "Value": ["095207.941000"]}, "1285": {"vr": "TM", "Value": ["094907.837000"]}, "1286": {"vr": "TM", "Value": ["094907.743000"]}, "1287": {"vr": "TM", "Value": ["094907.916000"]}, "1288": {"vr": "TM", "Value": ["094807.926000"]}, "1289": {"vr": "TM", "Value": ["095247.682000"]}, "1290": {"vr": "TM", "Value": ["094807.755000"]}, "1291": {"vr": "TM", "Value": ["094527.692000"]}, "1292": {"vr": "TM", "Value": ["094927.793000"]}, "1293": {"vr": "TM", "Value": ["095027.608000"]}, "1294": {"vr": "TM", "Value": ["095347.674000"]}, "1295": {"vr": "TM", "Value": ["094927.923000"]}, "1296": {"vr": "TM", "Value": ["094727.688000"]}, "1297": {"vr": "TM", "Value": ["094707.917000"]}, "1298": {"vr": "TM", "Value": ["094527.895000"]}, "1299": {"vr": "TM", "Value": ["094627.868000"]}, "1300": {"vr": "TM", "Value": ["095007.836000"]}, "1301": {"vr": "TM", "Value": ["094947.834000"]}, "1302": {"vr": "TM", "Value": ["094527.948000"]}, "1303": {"vr": "TM", "Value": ["095407.664000"]}, "1304": {"vr": "TM", "Value": ["094927.664000"]}, "1305": {"vr": "TM", "Value": ["095007.703000"]}, "1306": {"vr": "TM", "Value": ["094547.947000"]}, "1307": {"vr": "TM", "Value": ["095307.897000"]}, "1308": {"vr": "TM", "Value": ["094627.921000"]}, "1309": {"vr": "TM", "Value": ["094647.922000"]}, "1310": {"vr": "TM", "Value": ["094527.914000"]}, "1311": {"vr": "TM", "Value": ["094947.848000"]}, "1312": {"vr": "TM", "Value": ["095407.890000"]}, "1313": {"vr": "TM", "Value": ["094947.617000"]}, "1314": {"vr": "TM", "Value": ["094727.901000"]}, "1315": {"vr": "TM", "Value": ["094527.928000"]}, "1316": {"vr": "TM", "Value": ["095027.936000"]}, "1317": {"vr": "TM", "Value": ["094907.644000"]}, "1318": {"vr": "TM", "Value": ["094607.671000"]}, "1319": {"vr": "TM", "Value": ["094647.620000"]}, "1320": {"vr": "TM", "Value": ["095247.865000"]}, "1321": {"vr": "TM", "Value": ["094947.855000"]}, "1322": {"vr": "TM", "Value": ["094627.615000"]}, "1323": {"vr": "TM", "Value": ["094747.890000"]}, "1324": {"vr": "TM", "Value": ["094827.863000"]}, "1325": {"vr": "TM", "Value": ["094547.652000"]}, "1326": {"vr": "TM", "Value": ["094827.846000"]}, "1327": {"vr": "TM", "Value": ["095407.837000"]}, "1328": {"vr": "TM", "Value": ["094727.756000"]}, "1329": {"vr": "TM", "Value": ["095147.905000"]}, "1330": {"vr": "TM", "Value": ["095456.488000"]}, "1331": {"vr": "TM", "Value": ["094927.669000"]}, "1332": {"vr": "TM", "Value": ["095347.897000"]}, "1333": {"vr": "TM", "Value": ["095327.794000"]}, "1334": {"vr": "TM", "Value": ["095247.694000"]}, "1335": {"vr": "TM", "Value": ["094747.938000"]}, "1336": {"vr": "TM", "Value": ["095027.685000"]}, "1337": {"vr": "TM", "Value": ["094727.828000"]}, "1338": {"vr": "TM", "Value": ["094847.849000"]}, "1339": {"vr": "TM", "Value": ["095227.781000"]}, "1340": {"vr": "TM", "Value": ["094607.789000"]}, "1341": {"vr": "TM", "Value": ["095427.647000"]}, "1342": {"vr": "TM", "Value": ["094627.650000"]}, "1343": {"vr": "TM", "Value": ["095247.832000"]}, "1344": {"vr": "TM", "Value": ["094727.753000"]}, "1345": {"vr": "TM", "Value": ["094727.792000"]}, "1346": {"vr": "TM", "Value": ["094627.759000"]}, "1347": {"vr": "TM", "Value": ["094527.747000"]}, "1348": {"vr": "TM", "Value": ["095127.858000"]}, "1349": {"vr": "TM", "Value": ["094627.761000"]}, "1350": {"vr": "TM", "Value": ["095127.835000"]}, "1351": {"vr": "TM", "Value": ["094607.618000"]}, "1352": {"vr": "TM", "Value": ["095007.735000"]}, "1353": {"vr": "TM", "Value": ["095247.806000"]}, "1354": {"vr": "TM", "Value": ["095427.776000"]}, "1355": {"vr": "TM", "Value": ["094827.717000"]}, "1356": {"vr": "TM", "Value": ["094947.761000"]}, "1357": {"vr": "TM", "Value": ["095027.926000"]}, "1358": {"vr": "TM", "Value": ["094707.614000"]}, "1359": {"vr": "TM", "Value": ["095407.700000"]}, "1360": {"vr": "TM", "Value": ["095407.702000"]}, "1361": {"vr": "TM", "Value": ["094607.856000"]}, "1362": {"vr": "TM", "Value": ["094527.817000"]}, "1363": {"vr": "TM", "Value": ["094707.866000"]}, "1364": {"vr": "TM", "Value": ["094727.883000"]}, "1365": {"vr": "TM", "Value": ["095047.713000"]}, "1366": {"vr": "TM", "Value": ["094847.822000"]}, "1367": {"vr": "TM", "Value": ["094607.695000"]}, "1368": {"vr": "TM", "Value": ["094807.953000"]}, "1369": {"vr": "TM", "Value": ["094847.685000"]}, "1370": {"vr": "TM", "Value": ["094947.860000"]}, "1371": {"vr": "TM", "Value": ["094627.861000"]}, "1372": {"vr": "TM", "Value": ["094607.750000"]}, "1373": {"vr": "TM", "Value": ["095227.617000"]}, "1374": {"vr": "TM", "Value": ["095027.746000"]}, "1375": {"vr": "TM", "Value": ["094827.936000"]}, "1376": {"vr": "TM", "Value": ["094627.886000"]}, "1377": {"vr": "TM", "Value": ["094647.678000"]}, "1378": {"vr": "TM", "Value": ["095447.613000"]}, "1379": {"vr": "TM", "Value": ["095447.768000"]}, "1380": {"vr": "TM", "Value": ["095047.866000"]}, "1381": {"vr": "TM", "Value": ["095327.726000"]}, "1382": {"vr": "TM", "Value": ["095327.840000"]}, "1383": {"vr": "TM", "Value": ["094727.926000"]}, "1384": {"vr": "TM", "Value": ["094627.768000"]}, "1385": {"vr": "TM", "Value": ["094847.940000"]}, "1386": {"vr": "TM", "Value": ["095207.649000"]}, "1387": {"vr": "TM", "Value": ["094847.892000"]}, "1388": {"vr": "TM", "Value": ["095047.933000"]}, "1389": {"vr": "TM", "Value": ["094627.665000"]}, "1390": {"vr": "TM", "Value": ["094907.683000"]}, "1391": {"vr": "TM", "Value": ["094527.810000"]}, "1392": {"vr": "TM", "Value": ["095407.746000"]}, "1393": {"vr": "TM", "Value": ["094847.920000"]}, "1394": {"vr": "TM", "Value": ["095027.708000"]}, "1395": {"vr": "TM", "Value": ["094927.921000"]}, "1396": {"vr": "TM", "Value": ["095127.706000"]}, "1397": {"vr": "TM", "Value": ["094947.680000"]}, "1398": {"vr": "TM", "Value": ["094807.682000"]}, "1399": {"vr": "TM", "Value": ["094827.808000"]}, "1400": {"vr": "TM", "Value": ["095047.956000"]}, "1401": {"vr": "TM", "Value": ["094747.778000"]}, "1402": {"vr": "TM", "Value": ["095347.910000"]}, "1403": {"vr": "TM", "Value": ["095007.725000"]}, "1404": {"vr": "TM", "Value": ["094527.636000"]}, "1405": {"vr": "TM", "Value": ["094547.667000"]}, "1406": {"vr": "TM", "Value": ["094727.950000"]}, "1407": {"vr": "TM", "Value": ["094707.884000"]}, "1408": {"vr": "TM", "Value": ["094827.771000"]}, "1409": {"vr": "TM", "Value": ["094727.627000"]}, "1410": {"vr": "TM", "Value": ["095347.933000"]}, "1411": {"vr": "TM", "Value": ["094647.657000"]}, "1412": {"vr": "TM", "Value": ["095047.815000"]}, "1413": {"vr": "TM", "Value": ["095327.775000"]}, "1414": {"vr": "TM", "Value": ["095127.837000"]}, "1415": {"vr": "TM", "Value": ["094547.791000"]}, "1416": {"vr": "TM", "Value": ["094727.825000"]}, "1417": {"vr": "TM", "Value": ["094647.933000"]}, "1418": {"vr": "TM", "Value": ["095027.785000"]}, "1419": {"vr": "TM", "Value": ["095347.827000"]}, "1420": {"vr": "TM", "Value": ["095247.705000"]}, "1421": {"vr": "TM", "Value": ["094727.868000"]}, "1422": {"vr": "TM", "Value": ["095327.865000"]}, "1423": {"vr": "TM", "Value": ["094947.747000"]}, "1424": {"vr": "TM", "Value": ["095407.919000"]}, "1425": {"vr": "TM", "Value": ["094907.663000"]}, "1426": {"vr": "TM", "Value": ["095307.622000"]}, "1427": {"vr": "TM", "Value": ["095227.714000"]}, "1428": {"vr": "TM", "Value": ["094927.732000"]}, "1429": {"vr": "TM", "Value": ["095347.641000"]}, "1430": {"vr": "TM", "Value": ["095327.787000"]}, "1431": {"vr": "TM", "Value": ["095427.926000"]}, "1432": {"vr": "TM", "Value": ["094947.745000"]}, "1433": {"vr": "TM", "Value": ["095247.640000"]}, "1434": {"vr": "TM", "Value": ["095147.629000"]}, "1435": {"vr": "TM", "Value": ["095047.772000"]}, "1436": {"vr": "TM", "Value": ["095307.684000"]}, "1437": {"vr": "TM", "Value": ["095127.895000"]}, "1438": {"vr": "TM", "Value": ["094607.735000"]}, "1439": {"vr": "TM", "Value": ["095027.705000"]}, "1440": {"vr": "TM", "Value": ["095447.745000"]}, "1441": {"vr": "TM", "Value": ["095047.610000"]}, "1442": {"vr": "TM", "Value": ["094527.628000"]}, "1443": {"vr": "TM", "Value": ["095447.690000"]}, "1444": {"vr": "TM", "Value": ["095047.646000"]}, "1445": {"vr": "TM", "Value": ["095407.720000"]}, "1446": {"vr": "TM", "Value": ["095207.810000"]}, "1447": {"vr": "TM", "Value": ["094747.842000"]}, "1448": {"vr": "TM", "Value": ["094547.933000"]}, "1449": {"vr": "TM", "Value": ["094647.931000"]}, "1450": {"vr": "TM", "Value": ["094807.707000"]}, "1451": {"vr": "TM", "Value": ["094947.687000"]}, "1452": {"vr": "TM", "Value": ["094527.815000"]}, "1453": {"vr": "TM", "Value": ["095207.836000"]}, "1454": {"vr": "TM", "Value": ["095427.740000"]}, "1455": {"vr": "TM", "Value": ["095456.500000"]}, "1456": {"vr": "TM", "Value": ["095047.823000"]}, "1457": {"vr": "TM", "Value": ["094707.792000"]}, "1458": {"vr": "TM", "Value": ["095447.801000"]}, "1459": {"vr": "TM", "Value": ["094627.637000"]}, "1460": {"vr": "TM", "Value": ["095327.731000"]}, "1461": {"vr": "TM", "Value": ["094707.644000"]}, "1462": {"vr": "TM", "Value": ["094947.622000"]}, "1463": {"vr": "TM", "Value": ["094927.891000"]}, "1464": {"vr": "TM", "Value": ["095307.920000"]}, "1465": {"vr": "TM", "Value": ["095107.824000"]}, "1466": {"vr": "TM", "Value": ["094747.767000"]}, "1467": {"vr": "TM", "Value": ["094727.685000"]}, "1468": {"vr": "TM", "Value": ["095207.684000"]}, "1469": {"vr": "TM", "Value": ["095407.766000"]}, "1470": {"vr": "TM", "Value": ["095107.754000"]}, "1471": {"vr": "TM", "Value": ["095327.819000"]}, "1472": {"vr": "TM", "Value": ["094727.934000"]}, "1473": {"vr": "TM", "Value": ["094747.649000"]}, "1474": {"vr": "TM", "Value": ["095147.801000"]}, "1475": {"vr": "TM", "Value": ["095327.896000"]}, "1476": {"vr": "TM", "Value": ["094847.777000"]}, "1477": {"vr": "TM", "Value": ["094547.888000"]}, "1478": {"vr": "TM", "Value": ["094847.857000"]}, "1479": {"vr": "TM", "Value": ["095127.758000"]}, "1480": {"vr": "TM", "Value": ["095247.719000"]}, "1481": {"vr": "TM", "Value": ["095307.850000"]}, "1482": {"vr": "TM", "Value": ["095247.710000"]}, "1483": {"vr": "TM", "Value": ["095227.906000"]}, "1484": {"vr": "TM", "Value": ["095047.818000"]}, "1485": {"vr": "TM", "Value": ["094907.824000"]}, "1486": {"vr": "TM", "Value": ["094647.757000"]}, "1487": {"vr": "TM", "Value": ["095447.625000"]}, "1488": {"vr": "TM", "Value": ["095147.777000"]}, "1489": {"vr": "TM", "Value": ["094927.618000"]}, "1490": {"vr": "TM", "Value": ["095047.658000"]}, "1491": {"vr": "TM", "Value": ["094807.905000"]}, "1492": {"vr": "TM", "Value": ["095107.770000"]}, "1493": {"vr": "TM", "Value": ["094707.607000"]}, "1494": {"vr": "TM", "Value": ["095407.898000"]}, "1495": {"vr": "TM", "Value": ["095207.621000"]}, "1496": {"vr": "TM", "Value": ["095347.784000"]}, "1497": {"vr": "TM", "Value": ["094707.914000"]}, "1498": {"vr": "TM", "Value": ["094927.837000"]}, "1499": {"vr": "TM", "Value": ["095347.789000"]}, "1500": {"vr": "TM", "Value": ["095127.801000"]}, "1501": {"vr": "TM", "Value": ["094747.695000"]}, "1502": {"vr": "TM", "Value": ["095107.805000"]}, "1503": {"vr": "TM", "Value": ["095327.899000"]}, "1504": {"vr": "TM", "Value": ["095107.878000"]}, "1505": {"vr": "TM", "Value": ["094807.712000"]}, "1506": {"vr": "TM", "Value": ["094927.613000"]}, "1507": {"vr": "TM", "Value": ["094807.668000"]}, "1508": {"vr": "TM", "Value": ["094607.869000"]}, "1509": {"vr": "TM", "Value": ["094707.702000"]}, "1510": {"vr": "TM", "Value": ["095127.877000"]}, "1511": {"vr": "TM", "Value": ["095327.817000"]}, "1512": {"vr": "TM", "Value": ["095147.796000"]}, "1513": {"vr": "TM", "Value": ["094547.874000"]}, "1514": {"vr": "TM", "Value": ["094727.813000"]}, "1515": {"vr": "TM", "Value": ["094527.649000"]}, "1516": {"vr": "TM", "Value": ["094527.970000"]}, "1517": {"vr": "TM", "Value": ["095327.767000"]}, "1518": {"vr": "TM", "Value": ["095307.689000"]}, "1519": {"vr": "TM", "Value": ["095027.829000"]}, "1520": {"vr": "TM", "Value": ["094847.722000"]}, "1521": {"vr": "TM", "Value": ["095327.656000"]}, "1522": {"vr": "TM", "Value": ["094807.679000"]}, "1523": {"vr": "TM", "Value": ["094847.748000"]}, "1524": {"vr": "TM", "Value": ["094927.776000"]}, "1525": {"vr": "TM", "Value": ["094627.822000"]}, "1526": {"vr": "TM", "Value": ["094747.607000"]}, "1527": {"vr": "TM", "Value": ["095247.904000"]}, "1528": {"vr": "TM", "Value": ["094547.637000"]}, "1529": {"vr": "TM", "Value": ["094907.871000"]}, "1530": {"vr": "TM", "Value": ["095227.885000"]}, "1531": {"vr": "TM", "Value": ["094947.670000"]}, "1532": {"vr": "TM", "Value": ["095407.917000"]}, "1533": {"vr": "TM", "Value": ["094747.715000"]}, "1534": {"vr": "TM", "Value": ["094847.862000"]}, "1535": {"vr": "TM", "Value": ["094727.830000"]}, "1536": {"vr": "TM", "Value": ["095007.822000"]}, "1537": {"vr": "TM", "Value": ["094607.613000"]}, "1538": {"vr": "TM", "Value": ["094547.913000"]}, "1539": {"vr": "TM", "Value": ["094647.799000"]}, "1540": {"vr": "TM", "Value": ["095027.757000"]}, "1541": {"vr": "TM", "Value": ["095047.757000"]}, "1542": {"vr": "TM", "Value": ["094747.884000"]}, "1543": {"vr": "TM", "Value": ["094847.835000"]}, "1544": {"vr": "TM", "Value": ["095007.771000"]}, "1545": {"vr": "TM", "Value": ["094947.694000"]}, "1546": {"vr": "TM", "Value": ["095047.958000"]}, "1547": {"vr": "TM", "Value": ["095047.653000"]}, "1548": {"vr": "TM", "Value": ["095027.715000"]}, "1549": {"vr": "TM", "Value": ["094907.853000"]}, "1550": {"vr": "TM", "Value": ["094807.814000"]}, "1551": {"vr": "TM", "Value": ["094827.667000"]}, "1552": {"vr": "TM", "Value": ["094907.723000"]}, "1553": {"vr": "TM", "Value": ["094647.972000"]}, "1554": {"vr": "TM", "Value": ["095007.654000"]}, "1555": {"vr": "TM", "Value": ["094527.724000"]}, "1556": {"vr": "TM", "Value": ["095107.679000"]}, "1557": {"vr": "TM", "Value": ["094947.872000"]}, "1558": {"vr": "TM", "Value": ["094927.694000"]}, "1559": {"vr": "TM", "Value": ["095147.755000"]}, "1560": {"vr": "TM", "Value": ["095427.853000"]}, "1561": {"vr": "TM", "Value": ["095027.654000"]}, "1562": {"vr": "TM", "Value": ["095327.677000"]}, "1563": {"vr": "TM", "Value": ["094727.944000"]}, "1564": {"vr": "TM", "Value": ["094747.682000"]}, "1565": {"vr": "TM", "Value": ["094627.754000"]}, "1566": {"vr": "TM", "Value": ["095027.892000"]}, "1567": {"vr": "TM", "Value": ["094807.902000"]}, "1568": {"vr": "TM", "Value": ["095027.733000"]}, "1569": {"vr": "TM", "Value": ["095327.941000"]}, "1570": {"vr": "TM", "Value": ["095107.812000"]}, "1571": {"vr": "TM", "Value": ["094547.744000"]}, "1572": {"vr": "TM", "Value": ["094847.870000"]}, "1573": {"vr": "TM", "Value": ["095047.868000"]}, "1574": {"vr": "TM", "Value": ["095007.843000"]}, "1575": {"vr": "TM", "Value": ["095107.789000"]}, "1576": {"vr": "TM", "Value": ["094647.705000"]}, "1577": {"vr": "TM", "Value": ["095127.739000"]}, "1578": {"vr": "TM", "Value": ["095447.752000"]}, "1579": {"vr": "TM", "Value": ["095447.770000"]}, "1580": {"vr": "TM", "Value": ["095207.910000"]}, "1581": {"vr": "TM", "Value": ["094927.896000"]}, "1582": {"vr": "TM", "Value": ["095227.878000"]}, "1583": {"vr": "TM", "Value": ["095107.618000"]}, "1584": {"vr": "TM", "Value": ["094727.823000"]}, "1585": {"vr": "TM", "Value": ["095347.748000"]}, "1586": {"vr": "TM", "Value": ["095247.910000"]}, "1587": {"vr": "TM", "Value": ["095107.625000"]}, "1588": {"vr": "TM", "Value": ["095147.689000"]}, "1589": {"vr": "TM", "Value": ["094707.851000"]}, "1590": {"vr": "TM", "Value": ["094847.634000"]}, "1591": {"vr": "TM", "Value": ["094727.916000"]}, "1592": {"vr": "TM", "Value": ["095347.664000"]}, "1593": {"vr": "TM", "Value": ["095047.774000"]}, "1594": {"vr": "TM", "Value": ["095327.701000"]}, "1595": {"vr": "TM", "Value": ["095427.802000"]}, "1596": {"vr": "TM", "Value": ["094607.817000"]}, "1597": {"vr": "TM", "Value": ["094927.812000"]}, "1598": {"vr": "TM", "Value": ["095407.642000"]}, "1599": {"vr": "TM", "Value": ["095227.655000"]}, "1600": {"vr": "TM", "Value": ["095147.775000"]}, "1601": {"vr": "TM", "Value": ["094527.764000"]}, "1602": {"vr": "TM", "Value": ["095407.789000"]}, "1603": {"vr": "TM", "Value": ["095456.455000"]}, "1604": {"vr": "TM", "Value": ["094707.671000"]}, "1605": {"vr": "TM", "Value": ["095107.850000"]}, "1606": {"vr": "TM", "Value": ["095427.897000"]}, "1607": {"vr": "TM", "Value": ["094847.756000"]}, "1608": {"vr": "TM", "Value": ["095307.861000"]}, "1609": {"vr": "TM", "Value": ["094947.609000"]}, "1610": {"vr": "TM", "Value": ["095007.901000"]}, "1611": {"vr": "TM", "Value": ["095247.736000"]}, "1612": {"vr": "TM", "Value": ["094947.803000"]}, "1613": {"vr": "TM", "Value": ["095247.794000"]}, "1614": {"vr": "TM", "Value": ["094727.909000"]}, "1615": {"vr": "TM", "Value": ["095307.681000"]}, "1616": {"vr": "TM", "Value": ["094727.838000"]}, "1617": {"vr": "TM", "Value": ["095007.710000"]}, "1618": {"vr": "TM", "Value": ["094947.891000"]}, "1619": {"vr": "TM", "Value": ["094547.702000"]}, "1620": {"vr": "TM", "Value": ["094727.735000"]}, "1621": {"vr": "TM", "Value": ["095007.639000"]}, "1622": {"vr": "TM", "Value": ["095127.855000"]}, "1623": {"vr": "TM", "Value": ["094947.782000"]}, "1624": {"vr": "TM", "Value": ["095407.797000"]}, "1625": {"vr": "TM", "Value": ["094827.875000"]}, "1626": {"vr": "TM", "Value": ["095027.929000"]}, "1627": {"vr": "TM", "Value": ["094847.695000"]}, "1628": {"vr": "TM", "Value": ["095047.648000"]}, "1629": {"vr": "TM", "Value": ["095247.696000"]}, "1630": {"vr": "TM", "Value": ["095447.701000"]}, "1631": {"vr": "TM", "Value": ["094707.712000"]}, "1632": {"vr": "TM", "Value": ["095147.644000"]}, "1633": {"vr": "TM", "Value": ["095047.630000"]}, "1634": {"vr": "TM", "Value": ["094547.758000"]}, "1635": {"vr": "TM", "Value": ["095227.724000"]}, "1636": {"vr": "TM", "Value": ["094607.786000"]}, "1637": {"vr": "TM", "Value": ["095207.679000"]}, "1638": {"vr": "TM", "Value": ["094907.921000"]}, "1639": {"vr": "TM", "Value": ["095327.855000"]}, "1640": {"vr": "TM", "Value": ["094647.886000"]}, "1641": {"vr": "TM", "Value": ["095447.940000"]}, "1642": {"vr": "TM", "Value": ["094547.644000"]}, "1643": {"vr": "TM", "Value": ["095456.481000"]}, "1644": {"vr": "TM", "Value": ["095007.815000"]}, "1645": {"vr": "TM", "Value": ["095407.710000"]}, "1646": {"vr": "TM", "Value": ["095247.633000"]}, "1647": {"vr": "TM", "Value": ["095347.656000"]}, "1648": {"vr": "TM", "Value": ["094747.679000"]}, "1649": {"vr": "TM", "Value": ["094827.952000"]}, "1650": {"vr": "TM", "Value": ["095007.705000"]}, "1651": {"vr": "TM", "Value": ["095247.860000"]}, "1652": {"vr": "TM", "Value": ["094927.625000"]}, "1653": {"vr": "TM", "Value": ["094947.754000"]}, "1654": {"vr": "TM", "Value": ["094807.638000"]}, "1655": {"vr": "TM", "Value": ["095147.869000"]}, "1656": {"vr": "TM", "Value": ["094947.714000"]}, "1657": {"vr": "TM", "Value": ["095147.715000"]}, "1658": {"vr": "TM", "Value": ["095227.676000"]}, "1659": {"vr": "TM", "Value": ["094907.745000"]}, "1660": {"vr": "TM", "Value": ["095127.798000"]}, "1661": {"vr": "TM", "Value": ["094527.837000"]}, "1662": {"vr": "TM", "Value": ["095107.774000"]}, "1663": {"vr": "TM", "Value": ["094827.704000"]}, "1664": {"vr": "TM", "Value": ["095307.766000"]}, "1665": {"vr": "TM", "Value": ["095227.778000"]}, "1666": {"vr": "TM", "Value": ["094927.692000"]}, "1667": {"vr": "TM", "Value": ["095227.927000"]}, "1668": {"vr": "TM", "Value": ["094707.815000"]}, "1669": {"vr": "TM", "Value": ["095247.661000"]}, "1670": {"vr": "TM", "Value": ["094927.745000"]}, "1671": {"vr": "TM", "Value": ["095147.707000"]}, "1672": {"vr": "TM", "Value": ["094607.825000"]}, "1673": {"vr": "TM", "Value": ["094827.725000"]}, "1674": {"vr": "TM", "Value": ["095027.882000"]}, "1675": {"vr": "TM", "Value": ["094747.701000"]}, "1676": {"vr": "TM", "Value": ["094527.996000"]}, "1677": {"vr": "TM", "Value": ["095427.703000"]}, "1678": {"vr": "TM", "Value": ["094847.806000"]}, "1679": {"vr": "TM", "Value": ["094907.892000"]}, "1680": {"vr": "TM", "Value": ["095247.623000"]}, "1681": {"vr": "TM", "Value": ["094647.746000"]}, "1682": {"vr": "TM", "Value": ["095227.686000"]}, "1683": {"vr": "TM", "Value": ["095127.906000"]}, "1684": {"vr": "TM", "Value": ["095407.613000"]}, "1685": {"vr": "TM", "Value": ["095307.699000"]}, "1686": {"vr": "TM", "Value": ["094547.630000"]}, "1687": {"vr": "TM", "Value": ["095207.767000"]}, "1688": {"vr": "TM", "Value": ["094807.873000"]}, "1689": {"vr": "TM", "Value": ["094827.858000"]}, "1690": {"vr": "TM", "Value": ["095027.885000"]}, "1691": {"vr": "TM", "Value": ["095327.714000"]}, "1692": {"vr": "TM", "Value": ["094847.659000"]}, "1693": {"vr": "TM", "Value": ["094907.631000"]}, "1694": {"vr": "TM", "Value": ["095307.881000"]}, "1695": {"vr": "TM", "Value": ["094727.733000"]}, "1696": {"vr": "TM", "Value": ["094547.771000"]}, "1697": {"vr": "TM", "Value": ["095047.751000"]}, "1698": {"vr": "TM", "Value": ["095427.781000"]}, "1699": {"vr": "TM", "Value": ["095047.895000"]}, "1700": {"vr": "TM", "Value": ["094527.686000"]}, "1701": {"vr": "TM", "Value": ["095307.815000"]}, "1702": {"vr": "TM", "Value": ["094727.657000"]}, "1703": {"vr": "TM", "Value": ["094547.857000"]}, "1704": {"vr": "TM", "Value": ["095407.781000"]}, "1705": {"vr": "TM", "Value": ["094547.768000"]}, "1706": {"vr": "TM", "Value": ["094547.784000"]}, "1707": {"vr": "TM", "Value": ["094847.639000"]}, "1708": {"vr": "TM", "Value": ["095227.834000"]}, "1709": {"vr": "TM", "Value": ["095027.749000"]}, "1710": {"vr": "TM", "Value": ["094927.722000"]}, "1711": {"vr": "TM", "Value": ["094547.699000"]}, "1712": {"vr": "TM", "Value": ["095207.641000"]}, "1713": {"vr": "TM", "Value": ["094747.781000"]}, "1714": {"vr": "TM", "Value": ["095407.832000"]}, "1715": {"vr": "TM", "Value": ["095247.853000"]}, "1716": {"vr": "TM", "Value": ["094607.933000"]}, "1717": {"vr": "TM", "Value": ["094647.918000"]}, "1718": {"vr": "TM", "Value": ["094947.898000"]}, "1719": {"vr": "TM", "Value": ["095427.710000"]}, "1720": {"vr": "TM", "Value": ["095456.553000"]}, "1721": {"vr": "TM", "Value": ["095407.872000"]}, "1722": {"vr": "TM", "Value": ["094747.623000"]}, "1723": {"vr": "TM", "Value": ["095427.786000"]}, "1724": {"vr": "TM", "Value": ["095307.651000"]}, "1725": {"vr": "TM", "Value": ["094747.856000"]}, "1726": {"vr": "TM", "Value": ["095407.611000"]}, "1727": {"vr": "TM", "Value": ["094927.786000"]}, "1728": {"vr": "TM", "Value": ["094747.970000"]}, "1729": {"vr": "TM", "Value": ["095007.756000"]}, "1730": {"vr": "TM", "Value": ["094547.776000"]}, "1731": {"vr": "TM", "Value": ["094847.798000"]}, "1732": {"vr": "TM", "Value": ["094547.647000"]}, "1733": {"vr": "TM", "Value": ["094527.834000"]}, "1734": {"vr": "TM", "Value": ["095407.819000"]}, "1735": {"vr": "TM", "Value": ["095307.902000"]}, "1736": {"vr": "TM", "Value": ["094827.917000"]}, "1737": {"vr": "TM", "Value": ["094707.887000"]}, "1738": {"vr": "TM", "Value": ["095147.782000"]}, "1739": {"vr": "TM", "Value": ["094847.877000"]}, "1740": {"vr": "TM", "Value": ["095407.784000"]}, "1741": {"vr": "TM", "Value": ["094807.702000"]}, "1742": {"vr": "TM", "Value": ["094627.911000"]}, "1743": {"vr": "TM", "Value": ["094747.832000"]}, "1744": {"vr": "TM", "Value": ["095147.634000"]}, "1745": {"vr": "TM", "Value": ["095107.868000"]}, "1746": {"vr": "TM", "Value": ["095247.848000"]}, "1747": {"vr": "TM", "Value": ["095107.611000"]}, "1748": {"vr": "TM", "Value": ["095227.763000"]}, "1749": {"vr": "TM", "Value": ["095307.858000"]}, "1750": {"vr": "TM", "Value": ["095427.907000"]}, "1751": {"vr": "TM", "Value": ["095447.740000"]}, "1752": {"vr": "TM", "Value": ["094627.647000"]}, "1753": {"vr": "TM", "Value": ["094747.745000"]}, "1754": {"vr": "TM", "Value": ["094947.841000"]}, "1755": {"vr": "TM", "Value": ["095147.620000"]}, "1756": {"vr": "TM", "Value": ["094747.827000"]}, "1757": {"vr": "TM", "Value": ["095127.840000"]}, "1758": {"vr": "TM", "Value": ["094527.842000"]}, "1759": {"vr": "TM", "Value": ["094547.620000"]}, "1760": {"vr": "TM", "Value": ["095127.848000"]}, "1761": {"vr": "TM", "Value": ["094547.931000"]}, "1762": {"vr": "TM", "Value": ["094527.823000"]}, "1763": {"vr": "TM", "Value": ["094607.836000"]}, "1764": {"vr": "TM", "Value": ["094947.629000"]}, "1765": {"vr": "TM", "Value": ["094647.907000"]}, "1766": {"vr": "TM", "Value": ["094847.732000"]}, "1767": {"vr": "TM", "Value": ["094907.626000"]}, "1768": {"vr": "TM", "Value": ["094907.701000"]}, "1769": {"vr": "TM", "Value": ["094527.807000"]}, "1770": {"vr": "TM", "Value": ["095127.909000"]}, "1771": {"vr": "TM", "Value": ["094947.749000"]}, "1772": {"vr": "TM", "Value": ["094947.865000"]}, "1773": {"vr": "TM", "Value": ["095407.738000"]}, "1774": {"vr": "TM", "Value": ["094607.646000"]}, "1775": {"vr": "TM", "Value": ["094647.948000"]}, "1776": {"vr": "TM", "Value": ["095447.747000"]}, "1777": {"vr": "TM", "Value": ["094747.762000"]}, "1778": {"vr": "TM", "Value": ["094747.924000"]}, "1779": {"vr": "TM", "Value": ["095247.881000"]}, "1780": {"vr": "TM", "Value": ["094807.929000"]}, "1781": {"vr": "TM", "Value": ["095307.644000"]}, "1782": {"vr": "TM", "Value": ["094707.871000"]}, "1783": {"vr": "TM", "Value": ["094747.785000"]}, "1784": {"vr": "TM", "Value": ["095247.618000"]}, "1785": {"vr": "TM", "Value": ["094847.890000"]}, "1786": {"vr": "TM", "Value": ["095147.875000"]}, "1787": {"vr": "TM", "Value": ["095447.891000"]}, "1788": {"vr": "TM", "Value": ["094807.699000"]}, "1789": {"vr": "TM", "Value": ["095247.673000"]}, "1790": {"vr": "TM", "Value": ["094727.730000"]}, "1791": {"vr": "TM", "Value": ["094647.633000"]}, "1792": {"vr": "TM", "Value": ["095027.916000"]}, "1793": {"vr": "TM", "Value": ["094947.677000"]}, "1794": {"vr": "TM", "Value": ["094947.632000"]}, "1795": {"vr": "TM", "Value": ["094747.651000"]}, "1796": {"vr": "TM", "Value": ["094527.671000"]}, "1797": {"vr": "TM", "Value": ["095047.846000"]}, "1798": {"vr": "TM", "Value": ["094727.613000"]}, "1799": {"vr": "TM", "Value": ["095107.831000"]}, "1800": {"vr": "TM", "Value": ["095127.666000"]}, "1801": {"vr": "TM", "Value": ["095347.636000"]}, "1802": {"vr": "TM", "Value": ["094827.861000"]}, "1803": {"vr": "TM", "Value": ["095427.755000"]}, "1804": {"vr": "TM", "Value": ["095427.760000"]}, "1805": {"vr": "TM", "Value": ["095456.531000"]}, "1806": {"vr": "TM", "Value": ["094607.890000"]}, "1807": {"vr": "TM", "Value": ["095427.640000"]}, "1808": {"vr": "TM", "Value": ["095247.727000"]}, "1809": {"vr": "TM", "Value": ["094747.764000"]}, "1810": {"vr": "TM", "Value": ["095047.926000"]}, "1811": {"vr": "TM", "Value": ["094947.794000"]}, "1812": {"vr": "TM", "Value": ["094907.688000"]}, "1813": {"vr": "TM", "Value": ["094847.837000"]}, "1814": {"vr": "TM", "Value": ["095327.623000"]}, "1815": {"vr": "TM", "Value": ["095427.946000"]}, "1816": {"vr": "TM", "Value": ["095027.880000"]}, "1817": {"vr": "TM", "Value": ["095047.938000"]}, "1818": {"vr": "TM", "Value": ["095047.643000"]}, "1819": {"vr": "TM", "Value": ["094927.845000"]}, "1820": {"vr": "TM", "Value": ["094847.656000"]}, "1821": {"vr": "TM", "Value": ["095147.717000"]}, "1822": {"vr": "TM", "Value": ["095247.811000"]}, "1823": {"vr": "TM", "Value": ["095147.697000"]}, "1824": {"vr": "TM", "Value": ["094727.873000"]}, "1825": {"vr": "TM", "Value": ["095107.622000"]}, "1826": {"vr": "TM", "Value": ["094747.853000"]}, "1827": {"vr": "TM", "Value": ["095327.779000"]}, "1828": {"vr": "TM", "Value": ["094907.890000"]}, "1829": {"vr": "TM", "Value": ["094627.625000"]}, "1830": {"vr": "TM", "Value": ["094747.646000"]}, "1831": {"vr": "TM", "Value": ["095047.918000"]}, "1832": {"vr": "TM", "Value": ["094907.661000"]}, "1833": {"vr": "TM", "Value": ["095027.923000"]}, "1834": {"vr": "TM", "Value": ["094707.950000"]}, "1835": {"vr": "TM", "Value": ["095027.790000"]}, "1836": {"vr": "TM", "Value": ["095127.793000"]}, "1837": {"vr": "TM", "Value": ["094847.619000"]}, "1838": {"vr": "TM", "Value": ["095327.799000"]}, "1839": {"vr": "TM", "Value": ["095227.822000"]}, "1840": {"vr": "TM", "Value": ["094607.742000"]}, "1841": {"vr": "TM", "Value": ["095107.691000"]}, "1842": {"vr": "TM", "Value": ["094947.792000"]}, "1843": {"vr": "TM", "Value": ["094707.904000"]}, "1844": {"vr": "TM", "Value": ["095127.888000"]}, "1845": {"vr": "TM", "Value": ["094827.842000"]}, "1846": {"vr": "TM", "Value": ["094827.625000"]}, "1847": {"vr": "TM", "Value": ["094807.878000"]}, "1848": {"vr": "TM", "Value": ["095007.682000"]}, "1849": {"vr": "TM", "Value": ["095247.724000"]}, "1850": {"vr": "TM", "Value": ["095027.764000"]}, "1851": {"vr": "TM", "Value": ["095247.741000"]}, "1852": {"vr": "TM", "Value": ["095127.671000"]}, "1853": {"vr": "TM", "Value": ["094527.885000"]}, "1854": {"vr": "TM", "Value": ["094627.889000"]}, "1855": {"vr": "TM", "Value": ["094947.913000"]}, "1856": {"vr": "TM", "Value": ["094647.774000"]}, "1857": {"vr": "TM", "Value": ["095427.845000"]}, "1858": {"vr": "TM", "Value": ["094827.805000"]}, "1859": {"vr": "TM", "Value": ["094647.777000"]}, "1860": {"vr": "TM", "Value": ["095047.828000"]}, "1861": {"vr": "TM", "Value": ["095107.708000"]}, "1862": {"vr": "TM", "Value": ["094747.625000"]}, "1863": {"vr": "TM", "Value": ["095327.858000"]}, "1864": {"vr": "TM", "Value": ["094607.877000"]}, "1865": {"vr": "TM", "Value": ["095007.766000"]}, "1866": {"vr": "TM", "Value": ["095047.820000"]}, "1867": {"vr": "TM", "Value": ["095107.928000"]}, "1868": {"vr": "TM", "Value": ["095447.881000"]}, "1869": {"vr": "TM", "Value": ["095207.788000"]}, "1870": {"vr": "TM", "Value": ["094607.639000"]}, "1871": {"vr": "TM", "Value": ["095227.678000"]}, "1872": {"vr": "TM", "Value": ["095456.517000"]}, "1873": {"vr": "TM", "Value": ["094527.702000"]}, "1874": {"vr": "TM", "Value": ["094747.793000"]}, "1875": {"vr": "TM", "Value": ["095427.837000"]}, "1876": {"vr": "TM", "Value": ["094607.921000"]}, "1877": {"vr": "TM", "Value": ["094627.800000"]}, "1878": {"vr": "TM", "Value": ["095447.871000"]}, "1879": {"vr": "TM", "Value": ["094827.745000"]}, "1880": {"vr": "TM", "Value": ["094747.887000"]}, "1881": {"vr": "TM", "Value": ["095247.734000"]}, "1882": {"vr": "TM", "Value": ["094927.881000"]}, "1883": {"vr": "TM", "Value": ["094547.852000"]}, "1884": {"vr": "TM", "Value": ["094807.750000"]}, "1885": {"vr": "TM", "Value": ["095427.680000"]}, "1886": {"vr": "TM", "Value": ["095027.611000"]}, "1887": {"vr": "TM", "Value": ["095307.620000"]}, "1888": {"vr": "TM", "Value": ["095427.889000"]}, "1889": {"vr": "TM", "Value": ["095327.684000"]}, "1890": {"vr": "TM", "Value": ["095107.675000"]}, "1891": {"vr": "TM", "Value": ["095047.613000"]}, "1892": {"vr": "TM", "Value": ["095407.654000"]}, "1893": {"vr": "TM", "Value": ["094547.867000"]}, "1894": {"vr": "TM", "Value": ["095407.896000"]}, "1895": {"vr": "TM", "Value": ["095407.658000"]}, "1896": {"vr": "TM", "Value": ["095207.651000"]}, "1897": {"vr": "TM", "Value": ["094807.656000"]}, "1898": {"vr": "TM", "Value": ["095447.791000"]}, "1899": {"vr": "TM", "Value": ["094547.837000"]}, "1900": {"vr": "TM", "Value": ["094707.695000"]}, "1901": {"vr": "TM", "Value": ["095407.850000"]}, "1902": {"vr": "TM", "Value": ["094907.609000"]}, "1903": {"vr": "TM", "Value": ["094747.882000"]}, "1904": {"vr": "TM", "Value": ["094927.620000"]}, "1905": {"vr": "TM", "Value": ["095247.649000"]}, "1906": {"vr": "TM", "Value": ["094847.709000"]}, "1907": {"vr": "TM", "Value": ["094907.611000"]}, "1908": {"vr": "TM", "Value": ["094907.949000"]}, "1909": {"vr": "TM", "Value": ["095327.770000"]}, "1910": {"vr": "TM", "Value": ["094747.801000"]}, "1911": {"vr": "TM", "Value": ["094607.848000"]}, "1912": {"vr": "TM", "Value": ["094627.876000"]}, "1913": {"vr": "TM", "Value": ["095247.846000"]}, "1914": {"vr": "TM", "Value": ["095327.760000"]}, "1915": {"vr": "TM", "Value": ["094527.761000"]}, "1916": {"vr": "TM", "Value": ["095007.894000"]}, "1917": {"vr": "TM", "Value": ["095247.611000"]}, "1918": {"vr": "TM", "Value": ["095007.868000"]}, "1919": {"vr": "TM", "Value": ["095447.879000"]}, "1920": {"vr": "TM", "Value": ["094827.919000"]}, "1921": {"vr": "TM", "Value": ["094847.955000"]}, "1922": {"vr": "TM", "Value": ["094927.763000"]}, "1923": {"vr": "TM", "Value": ["094927.671000"]}, "1924": {"vr": "TM", "Value": ["094547.916000"]}, "1925": {"vr": "TM", "Value": ["094807.819000"]}, "1926": {"vr": "TM", "Value": ["095327.635000"]}, "1927": {"vr": "TM", "Value": ["094927.778000"]}, "1928": {"vr": "TM", "Value": ["094807.783000"]}, "1929": {"vr": "TM", "Value": ["094947.836000"]}, "1930": {"vr": "TM", "Value": ["095227.799000"]}, "1931": {"vr": "TM", "Value": ["094907.926000"]}, "1932": {"vr": "TM", "Value": ["095347.633000"]}, "1933": {"vr": "TM", "Value": ["095147.830000"]}, "1934": {"vr": "TM", "Value": ["094627.617000"]}, "1935": {"vr": "TM", "Value": ["095347.756000"]}, "1936": {"vr": "TM", "Value": ["094647.902000"]}, "1937": {"vr": "TM", "Value": ["095227.768000"]}, "1938": {"vr": "TM", "Value": ["095347.879000"]}, "1939": {"vr": "TM", "Value": ["094947.682000"]}, "1940": {"vr": "TM", "Value": ["094827.678000"]}, "1941": {"vr": "TM", "Value": ["094847.677000"]}, "1942": {"vr": "TM", "Value": ["095127.723000"]}, "1943": {"vr": "TM", "Value": ["094627.803000"]}, "1944": {"vr": "TM", "Value": ["095127.732000"]}, "1945": {"vr": "TM", "Value": ["095207.616000"]}, "1946": {"vr": "TM", "Value": ["094907.614000"]}, "1947": {"vr": "TM", "Value": ["094907.708000"]}, "1948": {"vr": "TM", "Value": ["095347.761000"]}, "1949": {"vr": "TM", "Value": ["094707.647000"]}, "1950": {"vr": "TM", "Value": ["095227.796000"]}, "1951": {"vr": "TM", "Value": ["095107.608000"]}, "1952": {"vr": "TM", "Value": ["095127.760000"]}, "1953": {"vr": "TM", "Value": ["094947.799000"]}, "1954": {"vr": "TM", "Value": ["094607.631000"]}, "1955": {"vr": "TM", "Value": ["094727.696000"]}, "1956": {"vr": "TM", "Value": ["095247.789000"]}, "1957": {"vr": "TM", "Value": ["095027.780000"]}, "1958": {"vr": "TM", "Value": ["095127.751000"]}, "1959": {"vr": "TM", "Value": ["094947.701000"]}, "1960": {"vr": "TM", "Value": ["094827.673000"]}, "1961": {"vr": "TM", "Value": ["094527.652000"]}, "1962": {"vr": "TM", "Value": ["095207.775000"]}, "1963": {"vr": "TM", "Value": ["095127.875000"]}, "1964": {"vr": "TM", "Value": ["095007.728000"]}, "1965": {"vr": "TM", "Value": ["094907.696000"]}, "1966": {"vr": "TM", "Value": ["095227.673000"]}, "1967": {"vr": "TM", "Value": ["095456.485000"]}, "1968": {"vr": "TM", "Value": ["095147.647000"]}, "1969": {"vr": "TM", "Value": ["095447.709000"]}, "1970": {"vr": "TM", "Value": ["094807.621000"]}, "1971": {"vr": "TM", "Value": ["094847.911000"]}, "1972": {"vr": "TM", "Value": ["095027.687000"]}, "1973": {"vr": "TM", "Value": ["095456.420000"]}, "1974": {"vr": "TM", "Value": ["094807.870000"]}, "1975": {"vr": "TM", "Value": ["095307.786000"]}, "1976": {"vr": "TM", "Value": ["094607.616000"]}, "1977": {"vr": "TM", "Value": ["095027.695000"]}, "1978": {"vr": "TM", "Value": ["094647.854000"]}, "1979": {"vr": "TM", "Value": ["095227.645000"]}, "1980": {"vr": "TM", "Value": ["094847.795000"]}, "1981": {"vr": "TM", "Value": ["095107.793000"]}, "1982": {"vr": "TM", "Value": ["095247.717000"]}, "1983": {"vr": "TM", "Value": ["095027.641000"]}, "1984": {"vr": "TM", "Value": ["094627.901000"]}, "1985": {"vr": "TM", "Value": ["095027.634000"]}, "1986": {"vr": "TM", "Value": ["095327.806000"]}, "1987": {"vr": "TM", "Value": ["095427.954000"]}, "1988": {"vr": "TM", "Value": ["094547.724000"]}, "1989": {"vr": "TM", "Value": ["095027.657000"]}, "1990": {"vr": "TM", "Value": ["095227.758000"]}, "1991": {"vr": "TM", "Value": ["094927.835000"]}, "1992": {"vr": "TM", "Value": ["094747.922000"]}, "1993": {"vr": "TM", "Value": ["095007.887000"]}, "1994": {"vr": "TM", "Value": ["095407.639000"]}, "1995": {"vr": "TM", "Value": ["095427.645000"]}, "1996": {"vr": "TM", "Value": ["095007.800000"]}, "1997": {"vr": "TM", "Value": ["094607.718000"]}, "1998": {"vr": "TM", "Value": ["095127.613000"]}, "1999": {"vr": "TM", "Value": ["095147.627000"]}, "2000": {"vr": "TM", "Value": ["095247.907000"]}, "2001": {"vr": "TM", "Value": ["095456.471000"]}, "2002": {"vr": "TM", "Value": ["095227.920000"]}, "2003": {"vr": "TM", "Value": ["094547.736000"]}, "2004": {"vr": "TM", "Value": ["095207.636000"]}, "2005": {"vr": "TM", "Value": ["094647.787000"]}, "2006": {"vr": "TM", "Value": ["094947.883000"]}, "2007": {"vr": "TM", "Value": ["094607.882000"]}, "2008": {"vr": "TM", "Value": ["094707.823000"]}, "2009": {"vr": "TM", "Value": ["095447.845000"]}, "2010": {"vr": "TM", "Value": ["094627.972000"]}, "2011": {"vr": "TM", "Value": ["095347.918000"]}, "2012": {"vr": "TM", "Value": ["094527.641000"]}, "2013": {"vr": "TM", "Value": ["095307.843000"]}, "2014": {"vr": "TM", "Value": ["094907.798000"]}, "2015": {"vr": "TM", "Value": ["095247.748000"]}, "2016": {"vr": "TM", "Value": ["095027.675000"]}, "2017": {"vr": "TM", "Value": ["095007.778000"]}, "2018": {"vr": "TM", "Value": ["095347.725000"]}, "2019": {"vr": "TM", "Value": ["095007.713000"]}, "2020": {"vr": "TM", "Value": ["095447.781000"]}, "2021": {"vr": "TM", "Value": ["094847.737000"]}, "2022": {"vr": "TM", "Value": ["095107.887000"]}, "2023": {"vr": "TM", "Value": ["094827.755000"]}, "2024": {"vr": "TM", "Value": ["095427.656000"]}, "2025": {"vr": "TM", "Value": ["094707.675000"]}, "2026": {"vr": "TM", "Value": ["095407.822000"]}, "2027": {"vr": "TM", "Value": ["094807.765000"]}, "2028": {"vr": "TM", "Value": ["095127.937000"]}, "2029": {"vr": "TM", "Value": ["094707.666000"]}, "2030": {"vr": "TM", "Value": ["095447.827000"]}, "2031": {"vr": "TM", "Value": ["095027.806000"]}, "2032": {"vr": "TM", "Value": ["094647.683000"]}, "2033": {"vr": "TM", "Value": ["095447.620000"]}, "2034": {"vr": "TM", "Value": ["095047.897000"]}, "2035": {"vr": "TM", "Value": ["095027.618000"]}, "2036": {"vr": "TM", "Value": ["094827.639000"]}, "2037": {"vr": "TM", "Value": ["094747.756000"]}, "2038": {"vr": "TM", "Value": ["095247.808000"]}, "2039": {"vr": "TM", "Value": ["095007.740000"]}, "2040": {"vr": "TM", "Value": ["094627.815000"]}, "2041": {"vr": "TM", "Value": ["095127.646000"]}, "2042": {"vr": "TM", "Value": ["094627.855000"]}, "2043": {"vr": "TM", "Value": ["095307.740000"]}, "2044": {"vr": "TM", "Value": ["094907.887000"]}, "2045": {"vr": "TM", "Value": ["095107.752000"]}, "2046": {"vr": "TM", "Value": ["094747.959000"]}, "2047": {"vr": "TM", "Value": ["095447.732000"]}, "2048": {"vr": "TM", "Value": ["094827.818000"]}, "2049": {"vr": "TM", "Value": ["095027.677000"]}, "2050": {"vr": "TM", "Value": ["094547.903000"]}, "2051": {"vr": "TM", "Value": ["094927.654000"]}, "2052": {"vr": "TM", "Value": ["094627.692000"]}, "2053": {"vr": "TM", "Value": ["095227.663000"]}, "2054": {"vr": "TM", "Value": ["094947.893000"]}, "2055": {"vr": "TM", "Value": ["094847.832000"]}, "2056": {"vr": "TM", "Value": ["095127.753000"]}, "2057": {"vr": "TM", "Value": ["095427.676000"]}, "2058": {"vr": "TM", "Value": ["095447.933000"]}, "2059": {"vr": "TM", "Value": ["095347.869000"]}, "2060": {"vr": "TM", "Value": ["094707.725000"]}, "2061": {"vr": "TM", "Value": ["095047.803000"]}, "2062": {"vr": "TM", "Value": ["094747.798000"]}, "2063": {"vr": "TM", "Value": ["095107.677000"]}, "2064": {"vr": "TM", "Value": ["095327.687000"]}, "2065": {"vr": "TM", "Value": ["095407.922000"]}, "2066": {"vr": "TM", "Value": ["095047.718000"]}, "2067": {"vr": "TM", "Value": ["094847.923000"]}, "2068": {"vr": "TM", "Value": ["094847.914000"]}, "2069": {"vr": "TM", "Value": ["095407.628000"]}, "2070": {"vr": "TM", "Value": ["095107.627000"]}, "2071": {"vr": "TM", "Value": ["095227.913000"]}, "2072": {"vr": "TM", "Value": ["095007.944000"]}, "2073": {"vr": "TM", "Value": ["095127.845000"]}, "2074": {"vr": "TM", "Value": ["094747.720000"]}, "2075": {"vr": "TM", "Value": ["094827.877000"]}, "2076": {"vr": "TM", "Value": ["095127.668000"]}, "2077": {"vr": "TM", "Value": ["095307.943000"]}, "2078": {"vr": "TM", "Value": ["094807.631000"]}, "2079": {"vr": "TM", "Value": ["094827.944000"]}, "2080": {"vr": "TM", "Value": ["094827.683000"]}, "2081": {"vr": "TM", "Value": ["095407.697000"]}, "2082": {"vr": "TM", "Value": ["094827.931000"]}, "2083": {"vr": "TM", "Value": ["095007.803000"]}, "2084": {"vr": "TM", "Value": ["095007.819000"]}, "2085": {"vr": "TM", "Value": ["094727.903000"]}, "2086": {"vr": "TM", "Value": ["095327.723000"]}, "2087": {"vr": "TM", "Value": ["095427.638000"]}, "2088": {"vr": "TM", "Value": ["095207.706000"]}, "2089": {"vr": "TM", "Value": ["094807.626000"]}, "2090": {"vr": "TM", "Value": ["095027.636000"]}, "2091": {"vr": "TM", "Value": ["095047.905000"]}, "2092": {"vr": "TM", "Value": ["095147.925000"]}, "2093": {"vr": "TM", "Value": ["095447.863000"]}, "2094": {"vr": "TM", "Value": ["095447.716000"]}, "2095": {"vr": "TM", "Value": ["094907.720000"]}, "2096": {"vr": "TM", "Value": ["094707.737000"]}, "2097": {"vr": "TM", "Value": ["094707.803000"]}, "2098": {"vr": "TM", "Value": ["094527.638000"]}, "2099": {"vr": "TM", "Value": ["095307.691000"]}, "2100": {"vr": "TM", "Value": ["095127.746000"]}, "2101": {"vr": "TM", "Value": ["095307.637000"]}, "2102": {"vr": "TM", "Value": ["094947.619000"]}, "2103": {"vr": "TM", "Value": ["094527.830000"]}, "2104": {"vr": "TM", "Value": ["095247.886000"]}, "2105": {"vr": "TM", "Value": ["094607.624000"]}, "2106": {"vr": "TM", "Value": ["094747.687000"]}, "2107": {"vr": "TM", "Value": ["095107.847000"]}, "2108": {"vr": "TM", "Value": ["094627.870000"]}, "2109": {"vr": "TM", "Value": ["095327.668000"]}, "2110": {"vr": "TM", "Value": ["095407.715000"]}, "2111": {"vr": "TM", "Value": ["094707.730000"]}, "2112": {"vr": "TM", "Value": ["094807.718000"]}, "2113": {"vr": "TM", "Value": ["095027.859000"]}, "2114": {"vr": "TM", "Value": ["095327.878000"]}, "2115": {"vr": "TM", "Value": ["094547.923000"]}, "2116": {"vr": "TM", "Value": ["095027.744000"]}, "2117": {"vr": "TM", "Value": ["094827.665000"]}, "2118": {"vr": "TM", "Value": ["094727.773000"]}, "2119": {"vr": "TM", "Value": ["095047.856000"]}, "2120": {"vr": "TM", "Value": ["095447.876000"]}, "2121": {"vr": "TM", "Value": ["094647.790000"]}, "2122": {"vr": "TM", "Value": ["094527.839000"]}, "2123": {"vr": "TM", "Value": ["094647.722000"]}, "2124": {"vr": "TM", "Value": ["094547.944000"]}, "2125": {"vr": "TM", "Value": ["094827.649000"]}, "2126": {"vr": "TM", "Value": ["094547.819000"]}, "2127": {"vr": "TM", "Value": ["094927.729000"]}, "2128": {"vr": "TM", "Value": ["095107.703000"]}, "2129": {"vr": "TM", "Value": ["095407.758000"]}, "2130": {"vr": "TM", "Value": ["094927.724000"]}, "2131": {"vr": "TM", "Value": ["095427.729000"]}, "2132": {"vr": "TM", "Value": ["095147.828000"]}, "2133": {"vr": "TM", "Value": ["094627.612000"]}, "2134": {"vr": "TM", "Value": ["094707.719000"]}, "2135": {"vr": "TM", "Value": ["094727.898000"]}, "2136": {"vr": "TM", "Value": ["094647.804000"]}, "2137": {"vr": "TM", "Value": ["094847.646000"]}, "2138": {"vr": "TM", "Value": ["094907.941000"]}, "2139": {"vr": "TM", "Value": ["095027.644000"]}, "2140": {"vr": "TM", "Value": ["095007.929000"]}, "2141": {"vr": "TM", "Value": ["095127.656000"]}, "2142": {"vr": "TM", "Value": ["094947.789000"]}, "2143": {"vr": "TM", "Value": ["095447.775000"]}, "2144": {"vr": "TM", "Value": ["095107.744000"]}, "2145": {"vr": "TM", "Value": ["094747.905000"]}, "2146": {"vr": "TM", "Value": ["095456.459000"]}, "2147": {"vr": "TM", "Value": ["094647.647000"]}, "2148": {"vr": "TM", "Value": ["094647.665000"]}, "2149": {"vr": "TM", "Value": ["095427.661000"]}, "2150": {"vr": "TM", "Value": ["095427.814000"]}, "2151": {"vr": "TM", "Value": ["095027.811000"]}, "2152": {"vr": "TM", "Value": ["094607.791000"]}, "2153": {"vr": "TM", "Value": ["094727.952000"]}, "2154": {"vr": "TM", "Value": ["095147.687000"]}, "2155": {"vr": "TM", "Value": ["095107.668000"]}, "2156": {"vr": "TM", "Value": ["095207.782000"]}, "2157": {"vr": "TM", "Value": ["095007.649000"]}, "2158": {"vr": "TM", "Value": ["095147.760000"]}, "2159": {"vr": "TM", "Value": ["095007.718000"]}, "2160": {"vr": "TM", "Value": ["095007.613000"]}, "2161": {"vr": "TM", "Value": ["094707.955000"]}, "2162": {"vr": "TM", "Value": ["094607.712000"]}, "2163": {"vr": "TM", "Value": ["094947.699000"]}, "2164": {"vr": "TM", "Value": ["095107.911000"]}, "2165": {"vr": "TM", "Value": ["094827.844000"]}, "2166": {"vr": "TM", "Value": ["094927.875000"]}, "2167": {"vr": "TM", "Value": ["095127.765000"]}, "2168": {"vr": "TM", "Value": ["095447.649000"]}, "2169": {"vr": "TM", "Value": ["094747.957000"]}, "2170": {"vr": "TM", "Value": ["095007.889000"]}, "2171": {"vr": "TM", "Value": ["095427.817000"]}, "2172": {"vr": "TM", "Value": ["094707.789000"]}, "2173": {"vr": "TM", "Value": ["095247.827000"]}, "2174": {"vr": "TM", "Value": ["095007.916000"]}, "2175": {"vr": "TM", "Value": ["094807.841000"]}, "2176": {"vr": "TM", "Value": ["095107.933000"]}, "2177": {"vr": "TM", "Value": ["095447.921000"]}, "2178": {"vr": "TM", "Value": ["094707.765000"]}, "2179": {"vr": "TM", "Value": ["095127.698000"]}, "2180": {"vr": "TM", "Value": ["094627.848000"]}, "2181": {"vr": "TM", "Value": ["094747.670000"]}, "2182": {"vr": "TM", "Value": ["095147.900000"]}, "2183": {"vr": "TM", "Value": ["095347.649000"]}, "2184": {"vr": "TM", "Value": ["095227.727000"]}, "2185": {"vr": "TM", "Value": ["095007.692000"]}, "2186": {"vr": "TM", "Value": ["095247.801000"]}, "2187": {"vr": "TM", "Value": ["095456.407000"]}, "2188": {"vr": "TM", "Value": ["095127.781000"]}, "2189": {"vr": "TM", "Value": ["094807.674000"]}, "2190": {"vr": "TM", "Value": ["094607.606000"]}, "2191": {"vr": "TM", "Value": ["094647.814000"]}, "2192": {"vr": "TM", "Value": ["094827.851000"]}, "2193": {"vr": "TM", "Value": ["095307.694000"]}, "2194": {"vr": "TM", "Value": ["094547.763000"]}, "2195": {"vr": "TM", "Value": ["094907.850000"]}, "2196": {"vr": "TM", "Value": ["095127.716000"]}, "2197": {"vr": "TM", "Value": ["095007.662000"]}, "2198": {"vr": "TM", "Value": ["095407.646000"]}, "2199": {"vr": "TM", "Value": ["095247.820000"]}, "2200": {"vr": "TM", "Value": ["094707.699000"]}, "2201": {"vr": "TM", "Value": ["094807.720000"]}, "2202": {"vr": "TM", "Value": ["095327.809000"]}, "2203": {"vr": "TM", "Value": ["095207.851000"]}, "2204": {"vr": "TM", "Value": ["095456.464000"]}, "2205": {"vr": "TM", "Value": ["094607.833000"]}, "2206": {"vr": "TM", "Value": ["095127.914000"]}, "2207": {"vr": "TM", "Value": ["095107.765000"]}, "2208": {"vr": "TM", "Value": ["095447.856000"]}, "2209": {"vr": "TM", "Value": ["095307.797000"]}, "2210": {"vr": "TM", "Value": ["094707.940000"]}, "2211": {"vr": "TM", "Value": ["094547.854000"]}, "2212": {"vr": "TM", "Value": ["095227.661000"]}, "2213": {"vr": "TM", "Value": ["095227.622000"]}, "2214": {"vr": "TM", "Value": ["094827.646000"]}, "2215": {"vr": "TM", "Value": ["095327.632000"]}, "2216": {"vr": "TM", "Value": ["095007.949000"]}, "2217": {"vr": "TM", "Value": ["095207.724000"]}, "2218": {"vr": "TM", "Value": ["094907.944000"]}, "2219": {"vr": "TM", "Value": ["094727.718000"]}, "2220": {"vr": "TM", "Value": ["094527.719000"]}, "2221": {"vr": "TM", "Value": ["094647.811000"]}, "2222": {"vr": "TM", "Value": ["095307.728000"]}, "2223": {"vr": "TM", "Value": ["095047.843000"]}, "2224": {"vr": "TM", "Value": ["094607.948000"]}, "2225": {"vr": "TM", "Value": ["095107.646000"]}, "2226": {"vr": "TM", "Value": ["094847.730000"]}, "2227": {"vr": "TM", "Value": ["095407.855000"]}, "2228": {"vr": "TM", "Value": ["094547.829000"]}, "2229": {"vr": "TM", "Value": ["095427.687000"]}, "2230": {"vr": "TM", "Value": ["095207.674000"]}, "2231": {"vr": "TM", "Value": ["095247.666000"]}, "2232": {"vr": "TM", "Value": ["095127.651000"]}, "2233": {"vr": "TM", "Value": ["095447.923000"]}, "2234": {"vr": "TM", "Value": ["095027.939000"]}, "2235": {"vr": "TM", "Value": ["095207.864000"]}, "2236": {"vr": "TM", "Value": ["095227.851000"]}, "2237": {"vr": "TM", "Value": ["095107.908000"]}, "2238": {"vr": "TM", "Value": ["095227.937000"]}, "2239": {"vr": "TM", "Value": ["094707.642000"]}, "2240": {"vr": "TM", "Value": ["094807.933000"]}, "2241": {"vr": "TM", "Value": ["094647.905000"]}, "2242": {"vr": "TM", "Value": ["095127.711000"]}, "2243": {"vr": "TM", "Value": ["094627.635000"]}, "2244": {"vr": "TM", "Value": ["094547.901000"]}, "2245": {"vr": "TM", "Value": ["094927.814000"]}, "2246": {"vr": "TM", "Value": ["094547.613000"]}, "2247": {"vr": "TM", "Value": ["095107.866000"]}, "2248": {"vr": "TM", "Value": ["094627.674000"]}, "2249": {"vr": "TM", "Value": ["095347.631000"]}, "2250": {"vr": "TM", "Value": ["095307.853000"]}, "2251": {"vr": "TM", "Value": ["094707.897000"]}, "2252": {"vr": "TM", "Value": ["094527.868000"]}, "2253": {"vr": "TM", "Value": ["095347.646000"]}, "2254": {"vr": "TM", "Value": ["095456.536000"]}, "2255": {"vr": "TM", "Value": ["094827.753000"]}, "2256": {"vr": "TM", "Value": ["095447.809000"]}, "2257": {"vr": "TM", "Value": ["095207.818000"]}, "2258": {"vr": "TM", "Value": ["094647.609000"]}, "2259": {"vr": "TM", "Value": ["094647.967000"]}, "2260": {"vr": "TM", "Value": ["095027.736000"]}, "2261": {"vr": "TM", "Value": ["094747.962000"]}, "2262": {"vr": "TM", "Value": ["095447.714000"]}, "2263": {"vr": "TM", "Value": ["095327.743000"]}, "2264": {"vr": "TM", "Value": ["095207.734000"]}, "2265": {"vr": "TM", "Value": ["094947.780000"]}, "2266": {"vr": "TM", "Value": ["095147.665000"]}, "2267": {"vr": "TM", "Value": ["095427.763000"]}, "2268": {"vr": "TM", "Value": ["095107.935000"]}, "2269": {"vr": "TM", "Value": ["094627.957000"]}, "2270": {"vr": "TM", "Value": ["095207.737000"]}, "2271": {"vr": "TM", "Value": ["094827.719000"]}, "2272": {"vr": "TM", "Value": ["095427.753000"]}, "2273": {"vr": "TM", "Value": ["094907.808000"]}, "2274": {"vr": "TM", "Value": ["095327.625000"]}, "2275": {"vr": "TM", "Value": ["095047.669000"]}, "2276": {"vr": "TM", "Value": ["095107.873000"]}, "2277": {"vr": "TM", "Value": ["095027.798000"]}, "2278": {"vr": "TM", "Value": ["095327.745000"]}, "2279": {"vr": "TM", "Value": ["095447.667000"]}, "2280": {"vr": "TM", "Value": ["094647.806000"]}, "2281": {"vr": "TM", "Value": ["095227.861000"]}, "2282": {"vr": "TM", "Value": ["094747.712000"]}, "2283": {"vr": "TM", "Value": ["094747.908000"]}, "2284": {"vr": "TM", "Value": ["095007.708000"]}, "2285": {"vr": "TM", "Value": ["095307.720000"]}, "2286": {"vr": "TM", "Value": ["095347.807000"]}, "2287": {"vr": "TM", "Value": ["094527.694000"]}, "2288": {"vr": "TM", "Value": ["095447.868000"]}, "2289": {"vr": "TM", "Value": ["094547.649000"]}, "2290": {"vr": "TM", "Value": ["094707.894000"]}, "2291": {"vr": "TM", "Value": ["095147.816000"]}, "2292": {"vr": "TM", "Value": ["095407.618000"]}, "2293": {"vr": "TM", "Value": ["094727.766000"]}, "2294": {"vr": "TM", "Value": ["095027.769000"]}, "2295": {"vr": "TM", "Value": ["095007.846000"]}, "2296": {"vr": "TM", "Value": ["095147.729000"]}, "2297": {"vr": "TM", "Value": ["095407.684000"]}, "2298": {"vr": "TM", "Value": ["095147.639000"]}, "2299": {"vr": "TM", "Value": ["095427.923000"]}, "2300": {"vr": "TM", "Value": ["095307.658000"]}, "2301": {"vr": "TM", "Value": ["095127.850000"]}, "2302": {"vr": "TM", "Value": ["094727.781000"]}, "2303": {"vr": "TM", "Value": ["095147.915000"]}, "2304": {"vr": "TM", "Value": ["095047.734000"]}, "2305": {"vr": "TM", "Value": ["094527.854000"]}, "2306": {"vr": "TM", "Value": ["094547.707000"]}, "2307": {"vr": "TM", "Value": ["095227.620000"]}, "2308": {"vr": "TM", "Value": ["095227.854000"]}, "2309": {"vr": "TM", "Value": ["094927.926000"]}, "2310": {"vr": "TM", "Value": ["094907.656000"]}, "2311": {"vr": "TM", "Value": ["095207.889000"]}, "2312": {"vr": "TM", "Value": ["095347.613000"]}, "2313": {"vr": "TM", "Value": ["094527.630000"]}, "2314": {"vr": "TM", "Value": ["094927.781000"]}, "2315": {"vr": "TM", "Value": ["095447.884000"]}, "2316": {"vr": "TM", "Value": ["094547.669000"]}, "2317": {"vr": "TM", "Value": ["095227.827000"]}, "2318": {"vr": "TM", "Value": ["095147.950000"]}, "2319": {"vr": "TM", "Value": ["094747.903000"]}, "2320": {"vr": "TM", "Value": ["094947.655000"]}, "2321": {"vr": "TM", "Value": ["094807.733000"]}, "2322": {"vr": "TM", "Value": ["094607.608000"]}, "2323": {"vr": "TM", "Value": ["095347.825000"]}, "2324": {"vr": "TM", "Value": ["095207.739000"]}, "2325": {"vr": "TM", "Value": ["095427.863000"]}, "2326": {"vr": "TM", "Value": ["094747.913000"]}, "2327": {"vr": "TM", "Value": ["094927.941000"]}, "2328": {"vr": "TM", "Value": ["094807.936000"]}, "2329": {"vr": "TM", "Value": ["094927.630000"]}, "2330": {"vr": "TM", "Value": ["095227.809000"]}, "2331": {"vr": "TM", "Value": ["094727.693000"]}, "2332": {"vr": "TM", "Value": ["095207.742000"]}, "2333": {"vr": "TM", "Value": ["095127.730000"]}, "2334": {"vr": "TM", "Value": ["095027.772000"]}, "2335": {"vr": "TM", "Value": ["094847.785000"]}, "2336": {"vr": "TM", "Value": ["094607.673000"]}, "2337": {"vr": "TM", "Value": ["095147.700000"]}, "2338": {"vr": "TM", "Value": ["094627.682000"]}, "2339": {"vr": "TM", "Value": ["094807.738000"]}, "2340": {"vr": "TM", "Value": ["095327.762000"]}, "2341": {"vr": "TM", "Value": ["095047.943000"]}, "2342": {"vr": "TM", "Value": ["095327.920000"]}, "2343": {"vr": "TM", "Value": ["094907.772000"]}, "2344": {"vr": "TM", "Value": ["094847.745000"]}, "2345": {"vr": "TM", "Value": ["094927.659000"]}, "2346": {"vr": "TM", "Value": ["095327.753000"]}, "2347": {"vr": "TM", "Value": ["094707.817000"]}, "2348": {"vr": "TM", "Value": ["095107.800000"]}, "2349": {"vr": "TM", "Value": ["094727.893000"]}, "2350": {"vr": "TM", "Value": ["094607.859000"]}, "2351": {"vr": "TM", "Value": ["095207.626000"]}, "2352": {"vr": "TM", "Value": ["094827.644000"]}, "2353": {"vr": "TM", "Value": ["095347.876000"]}, "2354": {"vr": "TM", "Value": ["094627.843000"]}, "2355": {"vr": "TM", "Value": ["094527.922000"]}, "2356": {"vr": "TM", "Value": ["094847.727000"]}, "2357": {"vr": "TM", "Value": ["095447.630000"]}, "2358": {"vr": "TM", "Value": ["094827.781000"]}, "2359": {"vr": "TM", "Value": ["095327.733000"]}, "2360": {"vr": "TM", "Value": ["094647.987000"]}, "2361": {"vr": "TM", "Value": ["095447.829000"]}, "2362": {"vr": "TM", "Value": ["095307.679000"]}, "2363": {"vr": "TM", "Value": ["095447.698000"]}, "2364": {"vr": "TM", "Value": ["095407.799000"]}, "2365": {"vr": "TM", "Value": ["094607.778000"]}, "2366": {"vr": "TM", "Value": ["094847.753000"]}, "2367": {"vr": "TM", "Value": ["095047.910000"]}, "2368": {"vr": "TM", "Value": ["095247.858000"]}, "2369": {"vr": "TM", "Value": ["094527.673000"]}, "2370": {"vr": "TM", "Value": ["094607.634000"]}, "2371": {"vr": "TM", "Value": ["095107.615000"]}, "2372": {"vr": "TM", "Value": ["094827.834000"]}, "2373": {"vr": "TM", "Value": ["094627.828000"]}, "2374": {"vr": "TM", "Value": ["094607.725000"]}, "2375": {"vr": "TM", "Value": ["095007.626000"]}, "2376": {"vr": "TM", "Value": ["094707.639000"]}, "2377": {"vr": "TM", "Value": ["094547.817000"]}, "2378": {"vr": "TM", "Value": ["095307.933000"]}, "2379": {"vr": "TM", "Value": ["094627.736000"]}, "2380": {"vr": "TM", "Value": ["095347.623000"]}, "2381": {"vr": "TM", "Value": ["095147.835000"]}, "2382": {"vr": "TM", "Value": ["095147.808000"]}, "2383": {"vr": "TM", "Value": ["094907.911000"]}, "2384": {"vr": "TM", "Value": ["094947.822000"]}, "2385": {"vr": "TM", "Value": ["095007.865000"]}, "2386": {"vr": "TM", "Value": ["095347.771000"]}, "2387": {"vr": "TM", "Value": ["094747.723000"]}, "2388": {"vr": "TM", "Value": ["095427.840000"]}, "2389": {"vr": "TM", "Value": ["094607.720000"]}, "2390": {"vr": "TM", "Value": ["095447.897000"]}, "2391": {"vr": "TM", "Value": ["094747.930000"]}, "2392": {"vr": "TM", "Value": ["094747.754000"]}, "2393": {"vr": "TM", "Value": ["094547.883000"]}, "2394": {"vr": "TM", "Value": ["095147.739000"]}, "2395": {"vr": "TM", "Value": ["095347.848000"]}, "2396": {"vr": "TM", "Value": ["094907.753000"]}, "2397": {"vr": "TM", "Value": ["095347.759000"]}, "2398": {"vr": "TM", "Value": ["095307.835000"]}, "2399": {"vr": "TM", "Value": ["095407.835000"]}, "2400": {"vr": "TM", "Value": ["095327.675000"]}, "2401": {"vr": "TM", "Value": ["094847.865000"]}, "2402": {"vr": "TM", "Value": ["095327.928000"]}, "2403": {"vr": "TM", "Value": ["095227.752000"]}, "2404": {"vr": "TM", "Value": ["095147.903000"]}, "2405": {"vr": "TM", "Value": ["095207.803000"]}, "2406": {"vr": "TM", "Value": ["094647.638000"]}, "2407": {"vr": "TM", "Value": ["094807.907000"]}, "2408": {"vr": "TM", "Value": ["094547.906000"]}, "2409": {"vr": "TM", "Value": ["094847.953000"]}, "2410": {"vr": "TM", "Value": ["095447.755000"]}, "2411": {"vr": "TM", "Value": ["095127.720000"]}, "2412": {"vr": "TM", "Value": ["095147.953000"]}, "2413": {"vr": "TM", "Value": ["095307.653000"]}, "2414": {"vr": "TM", "Value": ["095047.785000"]}, "2415": {"vr": "TM", "Value": ["094627.619000"]}, "2416": {"vr": "TM", "Value": ["094627.924000"]}, "2417": {"vr": "TM", "Value": ["095456.524000"]}, "2418": {"vr": "TM", "Value": ["095147.724000"]}, "2419": {"vr": "TM", "Value": ["094807.715000"]}, "2420": {"vr": "TM", "Value": ["095227.643000"]}, "2421": {"vr": "TM", "Value": ["095207.777000"]}, "2422": {"vr": "TM", "Value": ["095227.889000"]}, "2423": {"vr": "TM", "Value": ["094547.694000"]}, "2424": {"vr": "TM", "Value": ["094627.776000"]}, "2425": {"vr": "TM", "Value": ["095127.625000"]}, "2426": {"vr": "TM", "Value": ["094547.749000"]}, "2427": {"vr": "TM", "Value": ["094747.866000"]}, "2428": {"vr": "TM", "Value": ["095107.731000"]}, "2429": {"vr": "TM", "Value": ["094927.906000"]}, "2430": {"vr": "TM", "Value": ["094927.681000"]}, "2431": {"vr": "TM", "Value": ["094547.786000"]}, "2432": {"vr": "TM", "Value": ["094547.839000"]}, "2433": {"vr": "TM", "Value": ["094827.882000"]}, "2434": {"vr": "TM", "Value": ["094807.945000"]}, "2435": {"vr": "TM", "Value": ["095407.875000"]}, "2436": {"vr": "TM", "Value": ["094707.797000"]}, "2437": {"vr": "TM", "Value": ["095147.677000"]}, "2438": {"vr": "TM", "Value": ["094627.716000"]}, "2439": {"vr": "TM", "Value": ["095127.860000"]}, "2440": {"vr": "TM", "Value": ["095107.762000"]}, "2441": {"vr": "TM", "Value": ["095347.741000"]}, "2442": {"vr": "TM", "Value": ["095207.828000"]}, "2443": {"vr": "TM", "Value": ["095247.839000"]}, "2444": {"vr": "TM", "Value": ["095107.884000"]}, "2445": {"vr": "TM", "Value": ["095207.805000"]}, "2446": {"vr": "TM", "Value": ["094627.969000"]}, "2447": {"vr": "TM", "Value": ["094927.946000"]}, "2448": {"vr": "TM", "Value": ["095347.871000"]}, "2449": {"vr": "TM", "Value": ["094547.842000"]}, "2450": {"vr": "TM", "Value": ["095227.668000"]}, "2451": {"vr": "TM", "Value": ["095027.918000"]}, "2452": {"vr": "TM", "Value": ["094607.846000"]}, "2453": {"vr": "TM", "Value": ["094927.809000"]}, "2454": {"vr": "TM", "Value": ["095427.878000"]}, "2455": {"vr": "TM", "Value": ["094747.845000"]}, "2456": {"vr": "TM", "Value": ["095027.793000"]}, "2457": {"vr": "TM", "Value": ["095027.698000"]}, "2458": {"vr": "TM", "Value": ["095027.832000"]}, "2459": {"vr": "TM", "Value": ["095427.936000"]}, "2460": {"vr": "TM", "Value": ["094847.674000"]}, "2461": {"vr": "TM", "Value": ["094807.735000"]}, "2462": {"vr": "TM", "Value": ["095247.647000"]}, "2463": {"vr": "TM", "Value": ["095407.761000"]}, "2464": {"vr": "TM", "Value": ["095307.807000"]}, "2465": {"vr": "TM", "Value": ["095147.880000"]}, "2466": {"vr": "TM", "Value": ["094927.697000"]}, "2467": {"vr": "TM", "Value": ["095027.913000"]}, "2468": {"vr": "TM", "Value": ["095307.879000"]}, "2469": {"vr": "TM", "Value": ["094947.858000"]}, "2470": {"vr": "TM", "Value": ["094707.775000"]}, "2471": {"vr": "TM", "Value": ["095147.615000"]}, "2472": {"vr": "TM", "Value": ["094947.844000"]}, "2473": {"vr": "TM", "Value": ["094807.962000"]}, "2474": {"vr": "TM", "Value": ["094527.936000"]}, "2475": {"vr": "TM", "Value": ["095147.642000"]}, "2476": {"vr": "TM", "Value": ["095127.725000"]}, "2477": {"vr": "TM", "Value": ["095447.618000"]}, "2478": {"vr": "TM", "Value": ["094627.909000"]}, "2479": {"vr": "TM", "Value": ["094647.940000"]}, "2480": {"vr": "TM", "Value": ["095327.728000"]}, "2481": {"vr": "TM", "Value": ["095347.751000"]}, "2482": {"vr": "TM", "Value": ["094847.875000"]}, "2483": {"vr": "TM", "Value": ["095327.935000"]}, "2484": {"vr": "TM", "Value": ["094627.687000"]}, "2485": {"vr": "TM", "Value": ["094827.620000"]}, "2486": {"vr": "TM", "Value": ["094807.941000"]}, "2487": {"vr": "TM", "Value": ["095327.659000"]}, "2488": {"vr": "TM", "Value": ["095447.639000"]}, "2489": {"vr": "TM", "Value": ["095427.794000"]}, "2490": {"vr": "TM", "Value": ["095207.946000"]}, "2491": {"vr": "TM", "Value": ["094627.933000"]}, "2492": {"vr": "TM", "Value": ["095027.849000"]}, "2493": {"vr": "TM", "Value": ["095107.835000"]}, "2494": {"vr": "TM", "Value": ["095427.832000"]}, "2495": {"vr": "TM", "Value": ["094827.737000"]}, "2496": {"vr": "TM", "Value": ["094707.874000"]}, "2497": {"vr": "TM", "Value": ["095327.925000"]}, "2498": {"vr": "TM", "Value": ["095207.634000"]}, "2499": {"vr": "TM", "Value": ["094847.903000"]}, "2500": {"vr": "TM", "Value": ["095347.915000"]}, "2501": {"vr": "TM", "Value": ["094947.737000"]}, "2502": {"vr": "TM", "Value": ["094607.913000"]}, "2503": {"vr": "TM", "Value": ["095327.639000"]}, "2504": {"vr": "TM", "Value": ["094727.680000"]}, "2505": {"vr": "TM", "Value": ["095147.930000"]}, "2506": {"vr": "TM", "Value": ["094907.671000"]}, "2507": {"vr": "TM", "Value": ["095147.607000"]}, "2508": {"vr": "TM", "Value": ["095107.777000"]}, "2509": {"vr": "TM", "Value": ["094727.947000"]}, "2510": {"vr": "TM", "Value": ["095227.789000"]}, "2511": {"vr": "TM", "Value": ["094907.777000"]}, "2512": {"vr": "TM", "Value": ["095107.694000"]}, "2513": {"vr": "TM", "Value": ["095427.722000"]}, "2514": {"vr": "TM", "Value": ["094827.691000"]}, "2515": {"vr": "TM", "Value": ["094607.802000"]}, "2516": {"vr": "TM", "Value": ["094607.691000"]}, "2517": {"vr": "TM", "Value": ["095347.941000"]}, "2518": {"vr": "TM", "Value": ["094927.888000"]}, "2519": {"vr": "TM", "Value": ["094847.808000"]}, "2520": {"vr": "TM", "Value": ["095147.792000"]}, "2521": {"vr": "TM", "Value": ["095327.642000"]}, "2522": {"vr": "TM", "Value": ["095456.435000"]}, "2523": {"vr": "TM", "Value": ["094627.642000"]}, "2524": {"vr": "TM", "Value": ["095047.651000"]}, "2525": {"vr": "TM", "Value": ["095456.505000"]}, "2526": {"vr": "TM", "Value": ["094807.910000"]}, "2527": {"vr": "TM", "Value": ["094807.888000"]}, "2528": {"vr": "TM", "Value": ["095347.610000"]}, "2529": {"vr": "TM", "Value": ["094847.758000"]}, "2530": {"vr": "TM", "Value": ["095307.696000"]}, "2531": {"vr": "TM", "Value": ["095247.658000"]}, "2532": {"vr": "TM", "Value": ["095107.686000"]}, "2533": {"vr": "TM", "Value": ["094547.926000"]}, "2534": {"vr": "TM", "Value": ["095147.857000"]}, "2535": {"vr": "TM", "Value": ["095107.845000"]}, "2536": {"vr": "TM", "Value": ["094927.848000"]}, "2537": {"vr": "TM", "Value": ["095007.911000"]}, "2538": {"vr": "TM", "Value": ["095207.681000"]}, "2539": {"vr": "TM", "Value": ["095456.417000"]}, "2540": {"vr": "TM", "Value": ["095447.816000"]}, "2541": {"vr": "TM", "Value": ["095027.808000"]}, "2542": {"vr": "TM", "Value": ["094827.779000"]}, "2543": {"vr": "TM", "Value": ["095247.675000"]}, "2544": {"vr": "TM", "Value": ["094647.719000"]}, "2545": {"vr": "TM", "Value": ["095107.739000"]}, "2546": {"vr": "TM", "Value": ["095147.748000"]}, "2547": {"vr": "TM", "Value": ["094707.810000"]}, "2548": {"vr": "TM", "Value": ["094827.872000"]}, "2549": {"vr": "TM", "Value": ["095027.803000"]}, "2550": {"vr": "TM", "Value": ["095407.909000"]}, "2551": {"vr": "TM", "Value": ["095247.935000"]}, "2552": {"vr": "TM", "Value": ["095447.696000"]}, "2553": {"vr": "TM", "Value": ["094607.951000"]}, "2554": {"vr": "TM", "Value": ["094807.839000"]}, "2555": {"vr": "TM", "Value": ["095127.703000"]}, "2556": {"vr": "TM", "Value": ["095407.649000"]}, "2557": {"vr": "TM", "Value": ["095327.758000"]}, "2558": {"vr": "TM", "Value": ["095047.851000"]}, "2559": {"vr": "TM", "Value": ["095327.886000"]}, "2560": {"vr": "TM", "Value": ["095427.735000"]}, "2561": {"vr": "TM", "Value": ["094927.760000"]}, "2562": {"vr": "TM", "Value": ["095127.767000"]}, "2563": {"vr": "TM", "Value": ["094847.885000"]}, "2564": {"vr": "TM", "Value": ["094747.660000"]}, "2565": {"vr": "TM", "Value": ["095347.738000"]}, "2566": {"vr": "TM", "Value": ["095227.908000"]}, "2567": {"vr": "TM", "Value": ["095147.702000"]}, "2568": {"vr": "TM", "Value": ["095427.855000"]}, "2569": {"vr": "TM", "Value": ["094647.764000"]}, "2570": {"vr": "TM", "Value": ["095427.652000"]}, "2571": {"vr": "TM", "Value": ["094707.627000"]}, "2572": {"vr": "TM", "Value": ["095456.548000"]}, "2573": {"vr": "TM", "Value": ["094547.898000"]}, "2574": {"vr": "TM", "Value": ["095127.774000"]}, "2575": {"vr": "TM", "Value": ["094627.707000"]}, "2576": {"vr": "TM", "Value": ["095247.804000"]}, "2577": {"vr": "TM", "Value": ["094807.938000"]}, "2578": {"vr": "TM", "Value": ["094527.967000"]}, "2579": {"vr": "TM", "Value": ["094527.786000"]}, "2580": {"vr": "TM", "Value": ["095447.930000"]}, "2581": {"vr": "TM", "Value": ["095027.669000"]}, "2582": {"vr": "TM", "Value": ["095027.728000"]}, "2583": {"vr": "TM", "Value": ["094927.661000"]}, "2584": {"vr": "TM", "Value": ["094827.954000"]}, "2585": {"vr": "TM", "Value": ["095327.797000"]}, "2586": {"vr": "TM", "Value": ["095127.900000"]}, "2587": {"vr": "TM", "Value": ["095227.875000"]}, "2588": {"vr": "TM", "Value": ["094527.897000"]}, "2589": {"vr": "TM", "Value": ["095447.918000"]}, "2590": {"vr": "TM", "Value": ["095107.918000"]}, "2591": {"vr": "TM", "Value": ["095407.906000"]}, "2592": {"vr": "TM", "Value": ["094907.713000"]}, "2593": {"vr": "TM", "Value": ["094927.855000"]}, "2594": {"vr": "TM", "Value": ["094807.731000"]}, "2595": {"vr": "TM", "Value": ["095347.956000"]}, "2596": {"vr": "TM", "Value": ["094807.880000"]}, "2597": {"vr": "TM", "Value": ["095427.913000"]}, "2598": {"vr": "TM", "Value": ["094747.946000"]}, "2599": {"vr": "TM", "Value": ["095107.875000"]}, "2600": {"vr": "TM", "Value": ["095247.782000"]}, "2601": {"vr": "TM", "Value": ["095327.860000"]}, "2602": {"vr": "TM", "Value": ["094947.645000"]}, "2603": {"vr": "TM", "Value": ["095247.792000"]}, "2604": {"vr": "TM", "Value": ["095347.902000"]}, "2605": {"vr": "TM", "Value": ["095207.808000"]}, "2606": {"vr": "TM", "Value": ["095307.738000"]}, "2607": {"vr": "TM", "Value": ["095207.821000"]}, "2608": {"vr": "TM", "Value": ["095447.654000"]}, "2609": {"vr": "TM", "Value": ["095147.734000"]}, "2610": {"vr": "TM", "Value": ["094807.689000"]}, "2611": {"vr": "TM", "Value": ["094827.884000"]}, "2612": {"vr": "TM", "Value": ["094727.698000"]}, "2613": {"vr": "TM", "Value": ["094627.669000"]}, "2614": {"vr": "TM", "Value": ["095147.617000"]}, "2615": {"vr": "TM", "Value": ["095347.864000"]}, "2616": {"vr": "TM", "Value": ["094807.740000"]}, "2617": {"vr": "TM", "Value": ["095207.951000"]}, "2618": {"vr": "TM", "Value": ["095147.799000"]}, "2619": {"vr": "TM", "Value": ["094927.674000"]}, "2620": {"vr": "TM", "Value": ["094807.648000"]}, "2621": {"vr": "TM", "Value": ["095027.905000"]}, "2622": {"vr": "TM", "Value": ["095407.615000"]}, "2623": {"vr": "TM", "Value": ["095327.832000"]}, "2624": {"vr": "TM", "Value": ["095327.822000"]}, "2625": {"vr": "TM", "Value": ["094847.839000"]}, "2626": {"vr": "TM", "Value": ["095447.853000"]}, "2627": {"vr": "TM", "Value": ["095327.649000"]}, "2628": {"vr": "TM", "Value": ["095456.432000"]}, "2629": {"vr": "TM", "Value": ["094707.668000"]}, "2630": {"vr": "TM", "Value": ["094947.818000"]}, "2631": {"vr": "TM", "Value": ["094947.647000"]}, "2632": {"vr": "TM", "Value": ["094727.713000"]}, "2633": {"vr": "TM", "Value": ["095007.738000"]}, "2634": {"vr": "TM", "Value": ["094847.779000"]}, "2635": {"vr": "TM", "Value": ["094547.746000"]}, "2636": {"vr": "TM", "Value": ["095327.740000"]}, "2637": {"vr": "TM", "Value": ["094947.775000"]}, "2638": {"vr": "TM", "Value": ["094527.979000"]}, "2639": {"vr": "TM", "Value": ["095147.758000"]}, "2640": {"vr": "TM", "Value": ["094527.737000"]}, "2641": {"vr": "TM", "Value": ["094627.952000"]}, "2642": {"vr": "TM", "Value": ["094927.644000"]}, "2643": {"vr": "TM", "Value": ["095447.886000"]}, "2644": {"vr": "TM", "Value": ["095107.658000"]}, "2645": {"vr": "TM", "Value": ["095327.616000"]}, "2646": {"vr": "TM", "Value": ["095047.661000"]}, "2647": {"vr": "TM", "Value": ["095227.648000"]}, "2648": {"vr": "TM", "Value": ["095147.637000"]}, "2649": {"vr": "TM", "Value": ["094707.927000"]}, "2650": {"vr": "TM", "Value": ["094747.698000"]}, "2651": {"vr": "TM", "Value": ["094827.836000"]}, "2652": {"vr": "TM", "Value": ["094647.749000"]}, "2653": {"vr": "TM", "Value": ["095427.668000"]}, "2654": {"vr": "TM", "Value": ["095307.743000"]}, "2655": {"vr": "TM", "Value": ["094547.834000"]}, "2656": {"vr": "TM", "Value": ["094627.930000"]}, "2657": {"vr": "TM", "Value": ["094747.863000"]}, "2658": {"vr": "TM", "Value": ["095456.539000"]}, "2659": {"vr": "TM", "Value": ["094847.879000"]}, "2660": {"vr": "TM", "Value": ["095207.726000"]}, "2661": {"vr": "TM", "Value": ["095347.695000"]}, "2662": {"vr": "TM", "Value": ["095407.937000"]}, "2663": {"vr": "TM", "Value": ["094607.754000"]}, "2664": {"vr": "TM", "Value": ["094627.652000"]}, "2665": {"vr": "TM", "Value": ["094627.766000"]}, "2666": {"vr": "TM", "Value": ["095347.651000"]}, "2667": {"vr": "TM", "Value": ["094747.972000"]}, "2668": {"vr": "TM", "Value": ["094607.888000"]}, "2669": {"vr": "TM", "Value": ["094647.670000"]}, "2670": {"vr": "TM", "Value": ["094927.918000"]}, "2671": {"vr": "TM", "Value": ["094847.801000"]}, "2672": {"vr": "TM", "Value": ["095247.878000"]}, "2673": {"vr": "TM", "Value": ["094707.773000"]}, "2674": {"vr": "TM", "Value": ["094627.610000"]}, "2675": {"vr": "TM", "Value": ["094627.927000"]}, "2676": {"vr": "TM", "Value": ["094607.838000"]}, "2677": {"vr": "TM", "Value": ["094947.637000"]}, "2678": {"vr": "TM", "Value": ["095247.896000"]}, "2679": {"vr": "TM", "Value": ["095007.892000"]}, "2680": {"vr": "TM", "Value": ["094527.774000"]}, "2681": {"vr": "TM", "Value": ["095207.938000"]}, "2682": {"vr": "TM", "Value": ["095027.857000"]}, "2683": {"vr": "TM", "Value": ["095227.839000"]}, "2684": {"vr": "TM", "Value": ["094927.656000"]}, "2685": {"vr": "TM", "Value": ["095147.692000"]}, "2686": {"vr": "TM", "Value": ["094727.706000"]}, "2687": {"vr": "TM", "Value": ["095107.630000"]}, "2688": {"vr": "TM", "Value": ["095107.826000"]}, "2689": {"vr": "TM", "Value": ["094847.750000"]}, "2690": {"vr": "TM", "Value": ["094927.755000"]}, "2691": {"vr": "TM", "Value": ["094647.673000"]}, "2692": {"vr": "TM", "Value": ["094647.859000"]}, "2693": {"vr": "TM", "Value": ["095107.838000"]}, "2694": {"vr": "TM", "Value": ["095247.868000"]}, "2695": {"vr": "TM", "Value": ["095227.717000"]}, "2696": {"vr": "TM", "Value": ["094627.845000"]}, "2697": {"vr": "TM", "Value": ["095427.616000"]}, "2698": {"vr": "TM", "Value": ["095107.852000"]}, "2699": {"vr": "TM", "Value": ["094727.836000"]}, "2700": {"vr": "TM", "Value": ["094547.709000"]}, "2701": {"vr": "TM", "Value": ["094907.788000"]}, "2702": {"vr": "TM", "Value": ["094847.631000"]}, "2703": {"vr": "TM", "Value": ["095427.886000"]}, "2704": {"vr": "TM", "Value": ["094907.840000"]}, "2705": {"vr": "TM", "Value": ["094607.688000"]}, "2706": {"vr": "TM", "Value": ["094707.833000"]}, "2707": {"vr": "TM", "Value": ["095407.814000"]}, "2708": {"vr": "TM", "Value": ["095347.787000"]}, "2709": {"vr": "TM", "Value": ["095327.647000"]}, "2710": {"vr": "TM", "Value": ["095127.616000"]}, "2711": {"vr": "TM", "Value": ["094607.905000"]}, "2712": {"vr": "TM", "Value": ["094907.621000"]}, "2713": {"vr": "TM", "Value": ["095427.905000"]}, "2714": {"vr": "TM", "Value": ["095347.621000"]}, "2715": {"vr": "TM", "Value": ["095107.634000"]}, "2716": {"vr": "TM", "Value": ["095107.734000"]}, "2717": {"vr": "TM", "Value": ["094847.829000"]}, "2718": {"vr": "TM", "Value": ["094527.878000"]}, "2719": {"vr": "TM", "Value": ["095047.746000"]}, "2720": {"vr": "TM", "Value": ["094847.636000"]}, "2721": {"vr": "TM", "Value": ["095407.932000"]}, "2722": {"vr": "TM", "Value": ["094847.763000"]}, "2723": {"vr": "TM", "Value": ["095447.821000"]}, "2724": {"vr": "TM", "Value": ["095247.825000"]}, "2725": {"vr": "TM", "Value": ["095247.613000"]}, "2726": {"vr": "TM", "Value": ["095327.709000"]}, "2727": {"vr": "TM", "Value": ["094927.676000"]}, "2728": {"vr": "TM", "Value": ["094727.913000"]}, "2729": {"vr": "TM", "Value": ["094927.853000"]}, "2730": {"vr": "TM", "Value": ["095047.797000"]}, "2731": {"vr": "TM", "Value": ["094907.666000"]}, "2732": {"vr": "TM", "Value": ["095447.683000"]}, "2733": {"vr": "TM", "Value": ["095407.827000"]}, "2734": {"vr": "TM", "Value": ["094927.850000"]}, "2735": {"vr": "TM", "Value": ["094647.644000"]}, "2736": {"vr": "TM", "Value": ["095007.877000"]}, "2737": {"vr": "TM", "Value": ["094927.712000"]}, "2738": {"vr": "TM", "Value": ["094527.875000"]}, "2739": {"vr": "TM", "Value": ["095047.767000"]}, "2740": {"vr": "TM", "Value": ["094747.898000"]}, "2741": {"vr": "TM", "Value": ["095456.457000"]}, "2742": {"vr": "TM", "Value": ["095447.850000"]}, "2743": {"vr": "TM", "Value": ["095407.840000"]}, "2744": {"vr": "TM", "Value": ["095207.708000"]}, "2745": {"vr": "TM", "Value": ["094547.615000"]}, "2746": {"vr": "TM", "Value": ["095147.770000"]}, "2747": {"vr": "TM", "Value": ["095247.923000"]}, "2748": {"vr": "TM", "Value": ["095107.639000"]}, "2749": {"vr": "TM", "Value": ["094847.782000"]}, "2750": {"vr": "TM", "Value": ["094647.938000"]}, "2751": {"vr": "TM", "Value": ["095247.621000"]}, "2752": {"vr": "TM", "Value": ["094727.886000"]}, "2753": {"vr": "TM", "Value": ["094527.900000"]}, "2754": {"vr": "TM", "Value": ["095407.804000"]}, "2755": {"vr": "TM", "Value": ["094727.937000"]}, "2756": {"vr": "TM", "Value": ["095327.881000"]}, "2757": {"vr": "TM", "Value": ["094827.892000"]}, "2758": {"vr": "TM", "Value": ["094607.820000"]}, "2759": {"vr": "TM", "Value": ["094647.782000"]}, "2760": {"vr": "TM", "Value": ["095107.696000"]}, "2761": {"vr": "TM", "Value": ["094927.689000"]}, "2762": {"vr": "TM", "Value": ["095127.922000"]}, "2763": {"vr": "TM", "Value": ["094707.840000"]}, "2764": {"vr": "TM", "Value": ["094607.872000"]}, "2765": {"vr": "TM", "Value": ["095007.781000"]}, "2766": {"vr": "TM", "Value": ["094747.706000"]}, "2767": {"vr": "TM", "Value": ["095027.615000"]}, "2768": {"vr": "TM", "Value": ["095127.939000"]}, "2769": {"vr": "TM", "Value": ["094627.884000"]}, "2770": {"vr": "TM", "Value": ["095147.746000"]}, "2771": {"vr": "TM", "Value": ["094547.774000"]}, "2772": {"vr": "TM", "Value": ["094627.965000"]}, "2773": {"vr": "TM", "Value": ["095347.712000"]}, "2774": {"vr": "TM", "Value": ["094927.707000"]}, "2775": {"vr": "TM", "Value": ["094527.801000"]}, "2776": {"vr": "TM", "Value": ["094627.726000"]}, "2777": {"vr": "TM", "Value": ["095147.811000"]}, "2778": {"vr": "TM", "Value": ["095007.951000"]}, "2779": {"vr": "TM", "Value": ["095247.698000"]}, "2780": {"vr": "TM", "Value": ["095047.848000"]}, "2781": {"vr": "TM", "Value": ["095456.448000"]}, "2782": {"vr": "TM", "Value": ["094727.634000"]}, "2783": {"vr": "TM", "Value": ["094627.863000"]}, "2784": {"vr": "TM", "Value": ["094907.900000"]}, "2785": {"vr": "TM", "Value": ["095007.941000"]}, "2786": {"vr": "TM", "Value": ["094947.832000"]}, "2787": {"vr": "TM", "Value": ["095427.732000"]}, "2788": {"vr": "TM", "Value": ["095107.723000"]}, "2789": {"vr": "TM", "Value": ["095127.932000"]}, "2790": {"vr": "TM", "Value": ["094727.701000"]}, "2791": {"vr": "TM", "Value": ["095207.844000"]}, "2792": {"vr": "TM", "Value": ["095327.706000"]}, "2793": {"vr": "TM", "Value": ["095247.739000"]}, "2794": {"vr": "TM", "Value": ["094807.913000"]}, "2795": {"vr": "TM", "Value": ["094747.690000"]}, "2796": {"vr": "TM", "Value": ["095047.698000"]}, "2797": {"vr": "TM", "Value": ["095147.842000"]}, "2798": {"vr": "TM", "Value": ["095227.882000"]}, "2799": {"vr": "TM", "Value": ["095347.628000"]}, "2800": {"vr": "TM", "Value": ["095147.890000"]}, "2801": {"vr": "TM", "Value": ["094907.668000"]}, "2802": {"vr": "TM", "Value": ["095407.893000"]}, "2803": {"vr": "TM", "Value": ["094947.697000"]}, "2804": {"vr": "TM", "Value": ["095047.790000"]}, "2805": {"vr": "TM", "Value": ["095127.821000"]}, "2806": {"vr": "TM", "Value": ["094647.737000"]}, "2807": {"vr": "TM", "Value": ["095427.748000"]}, "2808": {"vr": "TM", "Value": ["095407.791000"]}, "2809": {"vr": "TM", "Value": ["094907.903000"]}, "2810": {"vr": "TM", "Value": ["095047.671000"]}, "2811": {"vr": "TM", "Value": ["095447.950000"]}, "2812": {"vr": "TM", "Value": ["094947.709000"]}, "2813": {"vr": "TM", "Value": ["094747.871000"]}, "2814": {"vr": "TM", "Value": ["094607.747000"]}, "2815": {"vr": "TM", "Value": ["095047.769000"]}, "2816": {"vr": "TM", "Value": ["094707.882000"]}, "2817": {"vr": "TM", "Value": ["095127.642000"]}, "2818": {"vr": "TM", "Value": ["094827.896000"]}, "2819": {"vr": "TM", "Value": ["095407.741000"]}, "2820": {"vr": "TM", "Value": ["094947.839000"]}, "2821": {"vr": "TM", "Value": ["095407.786000"]}, "2822": {"vr": "TM", "Value": ["095147.722000"]}, "2823": {"vr": "TM", "Value": ["095347.928000"]}, "2824": {"vr": "TM", "Value": ["095347.938000"]}, "2825": {"vr": "TM", "Value": ["094827.826000"]}, "2826": {"vr": "TM", "Value": ["094607.686000"]}, "2827": {"vr": "TM", "Value": ["094727.878000"]}, "2828": {"vr": "TM", "Value": ["095427.614000"]}, "2829": {"vr": "TM", "Value": ["095307.707000"]}, "2830": {"vr": "TM", "Value": ["095007.921000"]}, "2831": {"vr": "TM", "Value": ["095327.945000"]}, "2832": {"vr": "TM", "Value": ["095107.729000"]}, "2833": {"vr": "TM", "Value": ["094947.733000"]}, "2834": {"vr": "TM", "Value": ["095127.713000"]}, "2835": {"vr": "TM", "Value": ["094907.765000"]}, "2836": {"vr": "TM", "Value": ["095107.767000"]}, "2837": {"vr": "TM", "Value": ["094707.800000"]}, "2838": {"vr": "TM", "Value": ["094827.791000"]}, "2839": {"vr": "TM", "Value": ["095047.640000"]}, "2840": {"vr": "TM", "Value": ["094927.943000"]}, "2841": {"vr": "TM", "Value": ["095247.780000"]}, "2842": {"vr": "TM", "Value": ["095247.703000"]}, "2843": {"vr": "TM", "Value": ["094947.652000"]}, "2844": {"vr": "TM", "Value": ["094747.728000"]}, "2845": {"vr": "TM", "Value": ["094827.694000"]}, "2846": {"vr": "TM", "Value": ["094747.911000"]}, "2847": {"vr": "TM", "Value": ["095327.907000"]}, "2848": {"vr": "TM", "Value": ["095447.644000"]}, "2849": {"vr": "TM", "Value": ["095307.926000"]}, "2850": {"vr": "TM", "Value": ["095147.682000"]}, "2851": {"vr": "TM", "Value": ["095247.616000"]}, "2852": {"vr": "TM", "Value": ["095007.783000"]}, "2853": {"vr": "TM", "Value": ["094727.818000"]}, "2854": {"vr": "TM", "Value": ["094807.892000"]}, "2855": {"vr": "TM", "Value": ["094527.625000"]}, "2856": {"vr": "TM", "Value": ["094907.793000"]}, "2857": {"vr": "TM", "Value": ["094807.943000"]}, "2858": {"vr": "TM", "Value": ["094907.678000"]}, "2859": {"vr": "TM", "Value": ["095227.745000"]}, "2860": {"vr": "TM", "Value": ["095307.928000"]}, "2861": {"vr": "TM", "Value": ["094807.633000"]}, "2862": {"vr": "TM", "Value": ["094527.721000"]}, "2863": {"vr": "TM", "Value": ["095007.672000"]}, "2864": {"vr": "TM", "Value": ["094627.662000"]}, "2865": {"vr": "TM", "Value": ["095247.712000"]}, "2866": {"vr": "TM", "Value": ["094827.612000"]}, "2867": {"vr": "TM", "Value": ["095207.826000"]}, "2868": {"vr": "TM", "Value": ["095327.850000"]}, "2869": {"vr": "TM", "Value": ["094807.915000"]}, "2870": {"vr": "TM", "Value": ["094727.800000"]}, "2871": {"vr": "TM", "Value": ["094547.607000"]}, "2872": {"vr": "TM", "Value": ["095247.799000"]}, "2873": {"vr": "TM", "Value": ["095207.716000"]}, "2874": {"vr": "TM", "Value": ["094847.917000"]}, "2875": {"vr": "TM", "Value": ["095407.687000"]}, "2876": {"vr": "TM", "Value": ["094947.862000"]}, "2877": {"vr": "TM", "Value": ["095047.900000"]}, "2878": {"vr": "TM", "Value": ["095327.672000"]}, "2879": {"vr": "TM", "Value": ["095047.946000"]}, "2880": {"vr": "TM", "Value": ["095047.874000"]}, "2881": {"vr": "TM", "Value": ["094947.763000"]}, "2882": {"vr": "TM", "Value": ["094647.980000"]}, "2883": {"vr": "TM", "Value": ["094607.938000"]}, "2884": {"vr": "TM", "Value": ["094607.678000"]}, "2885": {"vr": "TM", "Value": ["094847.824000"]}, "2886": {"vr": "TM", "Value": ["095047.710000"]}, "2887": {"vr": "TM", "Value": ["094907.906000"]}, "2888": {"vr": "TM", "Value": ["094907.816000"]}, "2889": {"vr": "TM", "Value": ["095447.670000"]}, "2890": {"vr": "TM", "Value": ["094627.939000"]}, "2891": {"vr": "TM", "Value": ["094707.899000"]}, "2892": {"vr": "TM", "Value": ["095307.871000"]}, "2893": {"vr": "TM", "Value": ["094827.628000"]}, "2894": {"vr": "TM", "Value": ["095007.624000"]}, "2895": {"vr": "TM", "Value": ["094547.806000"]}, "2896": {"vr": "TM", "Value": ["095327.943000"]}, "2897": {"vr": "TM", "Value": ["094947.673000"]}, "2898": {"vr": "TM", "Value": ["095027.839000"]}, "2899": {"vr": "TM", "Value": ["094747.751000"]}, "2900": {"vr": "TM", "Value": ["095127.661000"]}, "2901": {"vr": "TM", "Value": ["094627.655000"]}, "2902": {"vr": "TM", "Value": ["095407.756000"]}, "2903": {"vr": "TM", "Value": ["095127.796000"]}, "2904": {"vr": "TM", "Value": ["095127.687000"]}, "2905": {"vr": "TM", "Value": ["094747.941000"]}, "2906": {"vr": "TM", "Value": ["094527.644000"]}, "2907": {"vr": "TM", "Value": ["095456.422000"]}, "2908": {"vr": "TM", "Value": ["094647.668000"]}, "2909": {"vr": "TM", "Value": ["095427.737000"]}, "2910": {"vr": "TM", "Value": ["094807.890000"]}, "2911": {"vr": "TM", "Value": ["095407.743000"]}, "2912": {"vr": "TM", "Value": ["094627.733000"]}, "2913": {"vr": "TM", "Value": ["094927.791000"]}, "2914": {"vr": "TM", "Value": ["094647.625000"]}, "2915": {"vr": "TM", "Value": ["095027.951000"]}, "2916": {"vr": "TM", "Value": ["095007.810000"]}, "2917": {"vr": "TM", "Value": ["094807.883000"]}, "2918": {"vr": "TM", "Value": ["094527.714000"]}, "2919": {"vr": "TM", "Value": ["095456.519000"]}, "2920": {"vr": "TM", "Value": ["095227.770000"]}, "2921": {"vr": "TM", "Value": ["095147.625000"]}, "2922": {"vr": "TM", "Value": ["095207.672000"]}, "2923": {"vr": "TM", "Value": ["095007.829000"]}, "2924": {"vr": "TM", "Value": ["095127.762000"]}, "2925": {"vr": "TM", "Value": ["094607.732000"]}, "2926": {"vr": "TM", "Value": ["094707.717000"]}, "2927": {"vr": "TM", "Value": ["095307.822000"]}, "2928": {"vr": "TM", "Value": ["094747.964000"]}, "2929": {"vr": "TM", "Value": ["094527.919000"]}, "2930": {"vr": "TM", "Value": ["094707.617000"]}, "2931": {"vr": "TM", "Value": ["095447.899000"]}, "2932": {"vr": "TM", "Value": ["095427.939000"]}, "2933": {"vr": "TM", "Value": ["094647.627000"]}, "2934": {"vr": "TM", "Value": ["095107.651000"]}, "2935": {"vr": "TM", "Value": ["094707.685000"]}, "2936": {"vr": "TM", "Value": ["095207.752000"]}, "2937": {"vr": "TM", "Value": ["095307.866000"]}, "2938": {"vr": "TM", "Value": ["095307.905000"]}, "2939": {"vr": "TM", "Value": ["094847.827000"]}, "2940": {"vr": "TM", "Value": ["094927.608000"]}, "2941": {"vr": "TM", "Value": ["094727.860000"]}, "2942": {"vr": "TM", "Value": ["095347.733000"]}, "2943": {"vr": "TM", "Value": ["095207.659000"]}, "2944": {"vr": "TM", "Value": ["095407.865000"]}, "2945": {"vr": "TM", "Value": ["095447.926000"]}, "2946": {"vr": "TM", "Value": ["094827.856000"]}, "2947": {"vr": "TM", "Value": ["095307.912000"]}, "2948": {"vr": "TM", "Value": ["094947.728000"]}, "2949": {"vr": "TM", "Value": ["094527.705000"]}, "2950": {"vr": "TM", "Value": ["094707.838000"]}, "2951": {"vr": "TM", "Value": ["095107.817000"]}, "2952": {"vr": "TM", "Value": ["095407.857000"]}, "2953": {"vr": "TM", "Value": ["094907.813000"]}, "2954": {"vr": "TM", "Value": ["095007.880000"]}, "2955": {"vr": "TM", "Value": ["095147.854000"]}, "2956": {"vr": "TM", "Value": ["095227.750000"]}, "2957": {"vr": "TM", "Value": ["094627.899000"]}, "2958": {"vr": "TM", "Value": ["094647.652000"]}, "2959": {"vr": "TM", "Value": ["094747.829000"]}, "2960": {"vr": "TM", "Value": ["094807.748000"]}, "2961": {"vr": "TM", "Value": ["094747.935000"]}, "2962": {"vr": "TM", "Value": ["094747.916000"]}, "2963": {"vr": "TM", "Value": ["095347.654000"]}, "2964": {"vr": "TM", "Value": ["094707.722000"]}, "2965": {"vr": "TM", "Value": ["095327.863000"]}, "2966": {"vr": "TM", "Value": ["094847.855000"]}, "2967": {"vr": "TM", "Value": ["094607.841000"]}, "2968": {"vr": "TM", "Value": ["094827.957000"]}, "2969": {"vr": "TM", "Value": ["094707.879000"]}, "2970": {"vr": "TM", "Value": ["095247.851000"]}, "2971": {"vr": "TM", "Value": ["095447.861000"]}, "2972": {"vr": "TM", "Value": ["095327.912000"]}, "2973": {"vr": "TM", "Value": ["095047.728000"]}, "2974": {"vr": "TM", "Value": ["094707.902000"]}, "2975": {"vr": "TM", "Value": ["094547.886000"]}, "2976": {"vr": "TM", "Value": ["094747.877000"]}, "2977": {"vr": "TM", "Value": ["095107.699000"]}, "2978": {"vr": "TM", "Value": ["094647.636000"]}, "2979": {"vr": "TM", "Value": ["095307.625000"]}, "2980": {"vr": "TM", "Value": ["095027.762000"]}, "2981": {"vr": "TM", "Value": ["095227.814000"]}, "2982": {"vr": "TM", "Value": ["095107.913000"]}, "2983": {"vr": "TM", "Value": ["094627.744000"]}, "2984": {"vr": "TM", "Value": ["095307.710000"]}, "2985": {"vr": "TM", "Value": ["094847.629000"]}, "2986": {"vr": "TM", "Value": ["094827.816000"]}, "2987": {"vr": "TM", "Value": ["095127.682000"]}, "2988": {"vr": "TM", "Value": ["095127.789000"]}, "2989": {"vr": "TM", "Value": ["095247.670000"]}, "2990": {"vr": "TM", "Value": ["094547.704000"]}, "2991": {"vr": "TM", "Value": ["095207.629000"]}, "2992": {"vr": "TM", "Value": ["095127.791000"]}, "2993": {"vr": "TM", "Value": ["095027.795000"]}, "2994": {"vr": "TM", "Value": ["095247.787000"]}, "2995": {"vr": "TM", "Value": ["095347.774000"]}, "2996": {"vr": "TM", "Value": ["094927.901000"]}, "2997": {"vr": "TM", "Value": ["094807.697000"]}, "2998": {"vr": "TM", "Value": ["095047.749000"]}, "2999": {"vr": "TM", "Value": ["095027.814000"]}, "3000": {"vr": "TM", "Value": ["095247.918000"]}, "3001": {"vr": "TM", "Value": ["094627.731000"]}, "3002": {"vr": "TM", "Value": ["095327.932000"]}, "3003": {"vr": "TM", "Value": ["095127.737000"]}, "3004": {"vr": "TM", "Value": ["095227.880000"]}, "3005": {"vr": "TM", "Value": ["095456.430000"]}, "3006": {"vr": "TM", "Value": ["095227.866000"]}, "3007": {"vr": "TM", "Value": ["095307.753000"]}, "3008": {"vr": "TM", "Value": ["094607.898000"]}, "3009": {"vr": "TM", "Value": ["094707.740000"]}, "3010": {"vr": "TM", "Value": ["095207.948000"]}, "3011": {"vr": "TM", "Value": ["094847.814000"]}, "3012": {"vr": "TM", "Value": ["094847.925000"]}, "3013": {"vr": "TM", "Value": ["094727.763000"]}, "3014": {"vr": "TM", "Value": ["095447.729000"]}, "3015": {"vr": "TM", "Value": ["094907.954000"]}, "3016": {"vr": "TM", "Value": ["094947.908000"]}, "3017": {"vr": "TM", "Value": ["095047.807000"]}, "3018": {"vr": "TM", "Value": ["095347.817000"]}, "3019": {"vr": "TM", "Value": ["094527.744000"]}, "3020": {"vr": "TM", "Value": ["094927.647000"]}, "3021": {"vr": "TM", "Value": ["095047.623000"]}, "3022": {"vr": "TM", "Value": ["094827.786000"]}, "3023": {"vr": "TM", "Value": ["095127.755000"]}, "3024": {"vr": "TM", "Value": ["095027.934000"]}, "3025": {"vr": "TM", "Value": ["095307.629000"]}, "3026": {"vr": "TM", "Value": ["094527.892000"]}, "3027": {"vr": "TM", "Value": ["094727.670000"]}, "3028": {"vr": "TM", "Value": ["094927.873000"]}, "3029": {"vr": "TM", "Value": ["095147.845000"]}, "3030": {"vr": "TM", "Value": ["095307.748000"]}, "3031": {"vr": "TM", "Value": ["095307.923000"]}, "3032": {"vr": "TM", "Value": ["095447.783000"]}, "3033": {"vr": "TM", "Value": ["094647.754000"]}, "3034": {"vr": "TM", "Value": ["094807.726000"]}, "3035": {"vr": "TM", "Value": ["094907.673000"]}, "3036": {"vr": "TM", "Value": ["095347.679000"]}, "3037": {"vr": "TM", "Value": ["095047.948000"]}, "3038": {"vr": "TM", "Value": ["094647.835000"]}, "3039": {"vr": "TM", "Value": ["094647.827000"]}, "3040": {"vr": "TM", "Value": ["094647.841000"]}, "3041": {"vr": "TM", "Value": ["094747.879000"]}, "3042": {"vr": "TM", "Value": ["095127.689000"]}, "3043": {"vr": "TM", "Value": ["095247.715000"]}, "3044": {"vr": "TM", "Value": ["095307.949000"]}, "3045": {"vr": "TM", "Value": ["094627.840000"]}, "3046": {"vr": "TM", "Value": ["094727.667000"]}, "3047": {"vr": "TM", "Value": ["094947.706000"]}, "3048": {"vr": "TM", "Value": ["094927.635000"]}, "3049": {"vr": "TM", "Value": ["095407.948000"]}, "3050": {"vr": "TM", "Value": ["095127.890000"]}, "3051": {"vr": "TM", "Value": ["095027.819000"]}, "3052": {"vr": "TM", "Value": ["094727.931000"]}, "3053": {"vr": "TM", "Value": ["094647.912000"]}, "3054": {"vr": "TM", "Value": ["095327.611000"]}, "3055": {"vr": "TM", "Value": ["094607.629000"]}, "3056": {"vr": "TM", "Value": ["095407.692000"]}, "3057": {"vr": "TM", "Value": ["094607.815000"]}, "3058": {"vr": "TM", "Value": ["094727.797000"]}, "3059": {"vr": "TM", "Value": ["094727.802000"]}, "3060": {"vr": "TM", "Value": ["095127.870000"]}, "3061": {"vr": "TM", "Value": ["094827.758000"]}, "3062": {"vr": "TM", "Value": ["095427.804000"]}, "3063": {"vr": "TM", "Value": ["095407.608000"]}, "3064": {"vr": "TM", "Value": ["094927.788000"]}, "3065": {"vr": "TM", "Value": ["095127.639000"]}, "3066": {"vr": "TM", "Value": ["095227.760000"]}, "3067": {"vr": "TM", "Value": ["095027.710000"]}, "3068": {"vr": "TM", "Value": ["095207.762000"]}, "3069": {"vr": "TM", "Value": ["095027.897000"]}, "3070": {"vr": "TM", "Value": ["095427.848000"]}, "3071": {"vr": "TM", "Value": ["095027.672000"]}, "3072": {"vr": "TM", "Value": ["095147.818000"]}, "3073": {"vr": "TM", "Value": ["094747.684000"]}, "3074": {"vr": "TM", "Value": ["094647.928000"]}, "3075": {"vr": "TM", "Value": ["095447.706000"]}, "3076": {"vr": "TM", "Value": ["094547.729000"]}, "3077": {"vr": "TM", "Value": ["095147.765000"]}, "3078": {"vr": "TM", "Value": ["095047.762000"]}, "3079": {"vr": "TM", "Value": ["094927.679000"]}, "3080": {"vr": "TM", "Value": ["094547.881000"]}, "3081": {"vr": "TM", "Value": ["095327.938000"]}, "3082": {"vr": "TM", "Value": ["095347.948000"]}, "3083": {"vr": "TM", "Value": ["094847.898000"]}, "3084": {"vr": "TM", "Value": ["095047.739000"]}, "3085": {"vr": "TM", "Value": ["094847.895000"]}, "3086": {"vr": "TM", "Value": ["095047.726000"]}, "3087": {"vr": "TM", "Value": ["094547.781000"]}, "3088": {"vr": "TM", "Value": ["095227.873000"]}, "3089": {"vr": "TM", "Value": ["094527.668000"]}, "3090": {"vr": "TM", "Value": ["095407.733000"]}, "3091": {"vr": "TM", "Value": ["095107.901000"]}, "3092": {"vr": "TM", "Value": ["094707.624000"]}, "3093": {"vr": "TM", "Value": ["094807.607000"]}, "3094": {"vr": "TM", "Value": ["095247.796000"]}, "3095": {"vr": "TM", "Value": ["095247.743000"]}, "3096": {"vr": "TM", "Value": ["095107.656000"]}, "3097": {"vr": "TM", "Value": ["095007.931000"]}, "3098": {"vr": "TM", "Value": ["094927.747000"]}, "3099": {"vr": "TM", "Value": ["094827.821000"]}, "3100": {"vr": "TM", "Value": ["094727.820000"]}, "3101": {"vr": "TM", "Value": ["094827.618000"]}, "3102": {"vr": "TM", "Value": ["095147.772000"]}, "3103": {"vr": "TM", "Value": ["095147.613000"]}, "3104": {"vr": "TM", "Value": ["095127.627000"]}, "3105": {"vr": "TM", "Value": ["094907.895000"]}, "3106": {"vr": "TM", "Value": ["094807.694000"]}, "3107": {"vr": "TM", "Value": ["095407.728000"]}, "3108": {"vr": "TM", "Value": ["095447.906000"]}, "3109": {"vr": "TM", "Value": ["095427.868000"]}, "3110": {"vr": "TM", "Value": ["094907.703000"]}, "3111": {"vr": "TM", "Value": ["094827.623000"]}, "3112": {"vr": "TM", "Value": ["094827.662000"]}, "3113": {"vr": "TM", "Value": ["095227.863000"]}, "3114": {"vr": "TM", "Value": ["094807.775000"]}, "3115": {"vr": "TM", "Value": ["094527.845000"]}, "3116": {"vr": "TM", "Value": ["094707.689000"]}, "3117": {"vr": "TM", "Value": ["094907.686000"]}, "3118": {"vr": "TM", "Value": ["094907.718000"]}, "3119": {"vr": "TM", "Value": ["094647.888000"]}, "3120": {"vr": "TM", "Value": ["095427.902000"]}, "3121": {"vr": "TM", "Value": ["094847.946000"]}, "3122": {"vr": "TM", "Value": ["094627.834000"]}, "3123": {"vr": "TM", "Value": ["095307.848000"]}, "3124": {"vr": "TM", "Value": ["094547.719000"]}, "3125": {"vr": "TM", "Value": ["095247.784000"]}, "3126": {"vr": "TM", "Value": ["095307.876000"]}, "3127": {"vr": "TM", "Value": ["095207.790000"]}, "3128": {"vr": "TM", "Value": ["095307.768000"]}, "3129": {"vr": "TM", "Value": ["094607.796000"]}, "3130": {"vr": "TM", "Value": ["094807.758000"]}, "3131": {"vr": "TM", "Value": ["094847.644000"]}, "3132": {"vr": "TM", "Value": ["094527.716000"]}, "3133": {"vr": "TM", "Value": ["095207.943000"]}, "3134": {"vr": "TM", "Value": ["095027.900000"]}, "3135": {"vr": "TM", "Value": ["095347.797000"]}, "3136": {"vr": "TM", "Value": ["094547.721000"]}, "3137": {"vr": "TM", "Value": ["095407.914000"]}, "3138": {"vr": "TM", "Value": ["094607.668000"]}, "3139": {"vr": "TM", "Value": ["094547.672000"]}, "3140": {"vr": "TM", "Value": ["095047.708000"]}, "3141": {"vr": "TM", "Value": ["094807.802000"]}, "3142": {"vr": "TM", "Value": ["095327.814000"]}, "3143": {"vr": "TM", "Value": ["094627.914000"]}, "3144": {"vr": "TM", "Value": ["094727.711000"]}, "3145": {"vr": "TM", "Value": ["094527.945000"]}, "3146": {"vr": "TM", "Value": ["095027.713000"]}, "3147": {"vr": "TM", "Value": ["094727.771000"]}, "3148": {"vr": "TM", "Value": ["094807.692000"]}, "3149": {"vr": "TM", "Value": ["095147.948000"]}, "3150": {"vr": "TM", "Value": ["095047.780000"]}, "3151": {"vr": "TM", "Value": ["094707.747000"]}, "3152": {"vr": "TM", "Value": ["095107.701000"]}, "3153": {"vr": "TM", "Value": ["095307.686000"]}, "3154": {"vr": "TM", "Value": ["094747.933000"]}, "3155": {"vr": "TM", "Value": ["095427.822000"]}, "3156": {"vr": "TM", "Value": ["094727.807000"]}, "3157": {"vr": "TM", "Value": ["095247.873000"]}, "3158": {"vr": "TM", "Value": ["095027.759000"]}, "3159": {"vr": "TM", "Value": ["094807.658000"]}, "3160": {"vr": "TM", "Value": ["094527.750000"]}, "3161": {"vr": "TM", "Value": ["095007.761000"]}, "3162": {"vr": "TM", "Value": ["094947.759000"]}, "3163": {"vr": "TM", "Value": ["094607.916000"]}, "3164": {"vr": "TM", "Value": ["094747.665000"]}, "3165": {"vr": "TM", "Value": ["094527.646000"]}, "3166": {"vr": "TM", "Value": ["094647.762000"]}, "3167": {"vr": "TM", "Value": ["094647.617000"]}, "3168": {"vr": "TM", "Value": ["095307.646000"]}, "3169": {"vr": "TM", "Value": ["095007.773000"]}, "3170": {"vr": "TM", "Value": ["095447.799000"]}, "3171": {"vr": "TM", "Value": ["095027.782000"]}, "3172": {"vr": "TM", "Value": ["095456.512000"]}, "3173": {"vr": "TM", "Value": ["095327.883000"]}, "3174": {"vr": "TM", "Value": ["094827.680000"]}, "3175": {"vr": "TM", "Value": ["095007.746000"]}, "3176": {"vr": "TM", "Value": ["095447.943000"]}, "3177": {"vr": "TM", "Value": ["094927.709000"]}, "3178": {"vr": "TM", "Value": ["095107.857000"]}, "3179": {"vr": "TM", "Value": ["094907.822000"]}, "3180": {"vr": "TM", "Value": ["095247.888000"]}, "3181": {"vr": "TM", "Value": ["095307.733000"]}, "3182": {"vr": "TM", "Value": ["095307.666000"]}, "3183": {"vr": "TM", "Value": ["094807.676000"]}, "3184": {"vr": "TM", "Value": ["094647.830000"]}, "3185": {"vr": "TM", "Value": ["095307.756000"]}, "3186": {"vr": "TM", "Value": ["095227.658000"]}, "3187": {"vr": "TM", "Value": ["094927.737000"]}, "3188": {"vr": "TM", "Value": ["094747.835000"]}, "3189": {"vr": "TM", "Value": ["094747.850000"]}, "3190": {"vr": "TM", "Value": ["095347.963000"]}, "3191": {"vr": "TM", "Value": ["095307.918000"]}, "3192": {"vr": "TM", "Value": ["095127.680000"]}, "3193": {"vr": "TM", "Value": ["095007.841000"]}, "3194": {"vr": "TM", "Value": ["094527.756000"]}, "3195": {"vr": "TM", "Value": ["094927.868000"]}, "3196": {"vr": "TM", "Value": ["094647.794000"]}, "3197": {"vr": "TM", "Value": ["095247.883000"]}, "3198": {"vr": "TM", "Value": ["095027.680000"]}, "3199": {"vr": "TM", "Value": ["094907.770000"]}, "3200": {"vr": "TM", "Value": ["094527.904000"]}, "3201": {"vr": "TM", "Value": ["095247.836000"]}, "3202": {"vr": "TM", "Value": ["095447.824000"]}, "3203": {"vr": "TM", "Value": ["094947.806000"]}, "3204": {"vr": "TM", "Value": ["094947.825000"]}, "3205": {"vr": "TM", "Value": ["095447.760000"]}, "3206": {"vr": "TM", "Value": ["094647.685000"]}, "3207": {"vr": "TM", "Value": ["094907.755000"]}, "3208": {"vr": "TM", "Value": ["094927.750000"]}, "3209": {"vr": "TM", "Value": ["095227.783000"]}, "3210": {"vr": "TM", "Value": ["094627.967000"]}, "3211": {"vr": "TM", "Value": ["095047.912000"]}, "3212": {"vr": "TM", "Value": ["095007.697000"]}, "3213": {"vr": "TM", "Value": ["095307.894000"]}, "3214": {"vr": "TM", "Value": ["095456.483000"]}, "3215": {"vr": "TM", "Value": ["095407.695000"]}, "3216": {"vr": "TM", "Value": ["095147.946000"]}, "3217": {"vr": "TM", "Value": ["094627.891000"]}, "3218": {"vr": "TM", "Value": ["094527.697000"]}, "3219": {"vr": "TM", "Value": ["094747.824000"]}, "3220": {"vr": "TM", "Value": ["095027.639000"]}, "3221": {"vr": "TM", "Value": ["094727.615000"]}, "3222": {"vr": "TM", "Value": ["095347.856000"]}, "3223": {"vr": "TM", "Value": ["094907.676000"]}, "3224": {"vr": "TM", "Value": ["094527.863000"]}, "3225": {"vr": "TM", "Value": ["095147.674000"]}, "3226": {"vr": "TM", "Value": ["095127.806000"]}, "3227": {"vr": "TM", "Value": ["094747.814000"]}, "3228": {"vr": "TM", "Value": ["095227.729000"]}, "3229": {"vr": "TM", "Value": ["094627.807000"]}, "3230": {"vr": "TM", "Value": ["094827.922000"]}, "3231": {"vr": "TM", "Value": ["095207.700000"]}, "3232": {"vr": "TM", "Value": ["094747.796000"]}, "3233": {"vr": "TM", "Value": ["095427.858000"]}, "3234": {"vr": "TM", "Value": ["094747.967000"]}, "3235": {"vr": "TM", "Value": ["095147.622000"]}, "3236": {"vr": "TM", "Value": ["094907.624000"]}, "3237": {"vr": "TM", "Value": ["094927.933000"]}, "3238": {"vr": "TM", "Value": ["095347.840000"]}, "3239": {"vr": "TM", "Value": ["095307.735000"]}, "3240": {"vr": "TM", "Value": ["095447.904000"]}, "3241": {"vr": "TM", "Value": ["095227.842000"]}, "3242": {"vr": "TM", "Value": ["094747.717000"]}, "3243": {"vr": "TM", "Value": ["095007.904000"]}, "3244": {"vr": "TM", "Value": ["094647.622000"]}, "3245": {"vr": "TM", "Value": ["094527.873000"]}, "3246": {"vr": "TM", "Value": ["095347.705000"]}, "3247": {"vr": "TM", "Value": ["094927.753000"]}, "3248": {"vr": "TM", "Value": ["095127.885000"]}, "3249": {"vr": "TM", "Value": ["094847.935000"]}, "3250": {"vr": "TM", "Value": ["095347.753000"]}, "3251": {"vr": "TM", "Value": ["095107.632000"]}, "3252": {"vr": "TM", "Value": ["095047.892000"]}, "3253": {"vr": "TM", "Value": ["095307.817000"]}, "3254": {"vr": "TM", "Value": ["095327.811000"]}, "3255": {"vr": "TM", "Value": ["095447.938000"]}, "3256": {"vr": "TM", "Value": ["095147.821000"]}, "3257": {"vr": "TM", "Value": ["095307.668000"]}, "3258": {"vr": "TM", "Value": ["095007.870000"]}, "3259": {"vr": "TM", "Value": ["094607.781000"]}, "3260": {"vr": "TM", "Value": ["095047.741000"]}, "3261": {"vr": "TM", "Value": ["094927.637000"]}, "3262": {"vr": "TM", "Value": ["094927.717000"]}, "3263": {"vr": "TM", "Value": ["094827.789000"]}, "3264": {"vr": "TM", "Value": ["095007.907000"]}, "3265": {"vr": "TM", "Value": ["095347.830000"]}, "3266": {"vr": "TM", "Value": ["095407.847000"]}, "3267": {"vr": "TM", "Value": ["094927.765000"]}, "3268": {"vr": "TM", "Value": ["094827.831000"]}, "3269": {"vr": "TM", "Value": ["095227.804000"]}, "3270": {"vr": "TM", "Value": ["095456.437000"]}, "3271": {"vr": "TM", "Value": ["094747.919000"]}, "3272": {"vr": "TM", "Value": ["095407.934000"]}, "3273": {"vr": "TM", "Value": ["095447.680000"]}, "3274": {"vr": "TM", "Value": ["095447.913000"]}, "3275": {"vr": "TM", "Value": ["094727.863000"]}, "3276": {"vr": "TM", "Value": ["094747.673000"]}, "3277": {"vr": "TM", "Value": ["095047.754000"]}, "3278": {"vr": "TM", "Value": ["095347.687000"]}, "3279": {"vr": "TM", "Value": ["095347.707000"]}, "3280": {"vr": "TM", "Value": ["094827.942000"]}, "3281": {"vr": "TM", "Value": ["094747.809000"]}, "3282": {"vr": "TM", "Value": ["094827.797000"]}, "3283": {"vr": "TM", "Value": ["094647.717000"]}, "3284": {"vr": "TM", "Value": ["095207.713000"]}, "3285": {"vr": "TM", "Value": ["095047.884000"]}, "3286": {"vr": "TM", "Value": ["095127.701000"]}, "3287": {"vr": "TM", "Value": ["095327.845000"]}, "3288": {"vr": "TM", "Value": ["094807.671000"]}, "3289": {"vr": "TM", "Value": ["094647.729000"]}, "3290": {"vr": "TM", "Value": ["094647.642000"]}, "3291": {"vr": "TM", "Value": ["095107.644000"]}, "3292": {"vr": "TM", "Value": ["095427.865000"]}, "3293": {"vr": "TM", "Value": ["095007.621000"]}, "3294": {"vr": "TM", "Value": ["095027.921000"]}, "3295": {"vr": "TM", "Value": ["095127.654000"]}, "3296": {"vr": "TM", "Value": ["094747.743000"]}, "3297": {"vr": "TM", "Value": ["094747.676000"]}, "3298": {"vr": "TM", "Value": ["094907.606000"]}, "3299": {"vr": "TM", "Value": ["094627.865000"]}, "3300": {"vr": "TM", "Value": ["094947.665000"]}, "3301": {"vr": "TM", "Value": ["094947.875000"]}, "3302": {"vr": "TM", "Value": ["095127.649000"]}, "3303": {"vr": "TM", "Value": ["095447.874000"]}, "3304": {"vr": "TM", "Value": ["094727.632000"]}, "3305": {"vr": "TM", "Value": ["094927.904000"]}, "3306": {"vr": "TM", "Value": ["095427.664000"]}, "3307": {"vr": "TM", "Value": ["094607.809000"]}, "3308": {"vr": "TM", "Value": ["094807.900000"]}, "3309": {"vr": "TM", "Value": ["095207.933000"]}, "3310": {"vr": "TM", "Value": ["094607.693000"]}, "3311": {"vr": "TM", "Value": ["094847.740000"]}, "3312": {"vr": "TM", "Value": ["095107.930000"]}, "3313": {"vr": "TM", "Value": ["094527.804000"]}, "3314": {"vr": "TM", "Value": ["094947.735000"]}, "3315": {"vr": "TM", "Value": ["095007.926000"]}, "3316": {"vr": "TM", "Value": ["094727.805000"]}, "3317": {"vr": "TM", "Value": ["095407.625000"]}, "3318": {"vr": "TM", "Value": ["095027.774000"]}, "3319": {"vr": "TM", "Value": ["095307.838000"]}, "3320": {"vr": "TM", "Value": ["095427.685000"]}, "3321": {"vr": "TM", "Value": ["095227.918000"]}, "3322": {"vr": "TM", "Value": ["095127.853000"]}, "3323": {"vr": "TM", "Value": ["095047.695000"]}, "3324": {"vr": "TM", "Value": ["095007.689000"]}, "3325": {"vr": "TM", "Value": ["094727.708000"]}, "3326": {"vr": "TM", "Value": ["094847.933000"]}, "3327": {"vr": "TM", "Value": ["094947.650000"]}, "3328": {"vr": "TM", "Value": ["095327.704000"]}, "3329": {"vr": "TM", "Value": ["094807.780000"]}, "3330": {"vr": "TM", "Value": ["094607.644000"]}, "3331": {"vr": "TM", "Value": ["095447.837000"]}, "3332": {"vr": "TM", "Value": ["095407.771000"]}, "3333": {"vr": "TM", "Value": ["094807.868000"]}, "3334": {"vr": "TM", "Value": ["095107.689000"]}, "3335": {"vr": "TM", "Value": ["094947.851000"]}, "3336": {"vr": "TM", "Value": ["094647.809000"]}, "3337": {"vr": "TM", "Value": ["094527.776000"]}, "3338": {"vr": "TM", "Value": ["094707.861000"]}, "3339": {"vr": "TM", "Value": ["095107.843000"]}, "3340": {"vr": "TM", "Value": ["094947.668000"]}, "3341": {"vr": "TM", "Value": ["095127.927000"]}, "3342": {"vr": "TM", "Value": ["095307.722000"]}, "3343": {"vr": "TM", "Value": ["095007.853000"]}, "3344": {"vr": "TM", "Value": ["094547.664000"]}, "3345": {"vr": "TM", "Value": ["095107.899000"]}, "3346": {"vr": "TM", "Value": ["095347.810000"]}, "3347": {"vr": "TM", "Value": ["094827.901000"]}, "3348": {"vr": "TM", "Value": ["094907.775000"]}, "3349": {"vr": "TM", "Value": ["095427.789000"]}, "3350": {"vr": "TM", "Value": ["094707.848000"]}, "3351": {"vr": "TM", "Value": ["094627.820000"]}, "3352": {"vr": "TM", "Value": ["094747.861000"]}, "3353": {"vr": "TM", "Value": ["095327.868000"]}, "3354": {"vr": "TM", "Value": ["094907.811000"]}, "3355": {"vr": "TM", "Value": ["095007.700000"]}, "3356": {"vr": "TM", "Value": ["095027.821000"]}, "3357": {"vr": "TM", "Value": ["094547.799000"]}, "3358": {"vr": "TM", "Value": ["094807.822000"]}, "3359": {"vr": "TM", "Value": ["095407.669000"]}, "3360": {"vr": "TM", "Value": ["095347.672000"]}, "3361": {"vr": "TM", "Value": ["094907.636000"]}, "3362": {"vr": "TM", "Value": ["094927.870000"]}, "3363": {"vr": "TM", "Value": ["095347.769000"]}, "3364": {"vr": "TM", "Value": ["095247.834000"]}, "3365": {"vr": "TM", "Value": ["095456.497000"]}, "3366": {"vr": "TM", "Value": ["095427.745000"]}, "3367": {"vr": "TM", "Value": ["095347.833000"]}, "3368": {"vr": "TM", "Value": ["094727.622000"]}, "3369": {"vr": "TM", "Value": ["095247.654000"]}, "3370": {"vr": "TM", "Value": ["095147.887000"]}, "3371": {"vr": "TM", "Value": ["094927.796000"]}, "3372": {"vr": "TM", "Value": ["095247.767000"]}, "3373": {"vr": "TM", "Value": ["095207.928000"]}, "3374": {"vr": "TM", "Value": ["095047.879000"]}, "3375": {"vr": "TM", "Value": ["095227.911000"]}, "3376": {"vr": "TM", "Value": ["094827.912000"]}, "3377": {"vr": "TM", "Value": ["095247.925000"]}, "3378": {"vr": "TM", "Value": ["094907.740000"]}, "3379": {"vr": "TM", "Value": ["095027.613000"]}, "3380": {"vr": "TM", "Value": ["094747.811000"]}, "3381": {"vr": "TM", "Value": ["095227.684000"]}, "3382": {"vr": "TM", "Value": ["095007.851000"]}, "3383": {"vr": "TM", "Value": ["094607.936000"]}, "3384": {"vr": "TM", "Value": ["095007.812000"]}, "3385": {"vr": "TM", "Value": ["094807.921000"]}, "3386": {"vr": "TM", "Value": ["095207.923000"]}, "3387": {"vr": "TM", "Value": ["095447.834000"]}, "3388": {"vr": "TM", "Value": ["094947.938000"]}, "3389": {"vr": "TM", "Value": ["095327.682000"]}, "3390": {"vr": "TM", "Value": ["095327.901000"]}, "3391": {"vr": "TM", "Value": ["094827.714000"]}, "3392": {"vr": "TM", "Value": ["094807.663000"]}, "3393": {"vr": "TM", "Value": ["095007.763000"]}, "3394": {"vr": "TM", "Value": ["094607.676000"]}, "3395": {"vr": "TM", "Value": ["095207.926000"]}, "3396": {"vr": "TM", "Value": ["094707.919000"]}, "3397": {"vr": "TM", "Value": ["094807.924000"]}, "3398": {"vr": "TM", "Value": ["094647.740000"]}, "3399": {"vr": "TM", "Value": ["095227.832000"]}, "3400": {"vr": "TM", "Value": ["095027.837000"]}, "3401": {"vr": "TM", "Value": ["095007.611000"]}, "3402": {"vr": "TM", "Value": ["095127.684000"]}, "3403": {"vr": "TM", "Value": ["094907.649000"]}, "3404": {"vr": "TM", "Value": ["094807.618000"]}, "3405": {"vr": "TM", "Value": ["095007.863000"]}, "3406": {"vr": "TM", "Value": ["095247.829000"]}, "3407": {"vr": "TM", "Value": ["094727.619000"]}, "3408": {"vr": "TM", "Value": ["094627.906000"]}, "3409": {"vr": "TM", "Value": ["095207.754000"]}, "3410": {"vr": "TM", "Value": ["095107.889000"]}, "3411": {"vr": "TM", "Value": ["095227.704000"]}, "3412": {"vr": "TM", "Value": ["095407.809000"]}, "3413": {"vr": "TM", "Value": ["095427.719000"]}, "3414": {"vr": "TM", "Value": ["095307.717000"]}, "3415": {"vr": "TM", "Value": ["095327.853000"]}, "3416": {"vr": "TM", "Value": ["094927.953000"]}, "3417": {"vr": "TM", "Value": ["095127.819000"]}, "3418": {"vr": "TM", "Value": ["094547.677000"]}, "3419": {"vr": "TM", "Value": ["095347.720000"]}, "3420": {"vr": "TM", "Value": ["094747.740000"]}, "3421": {"vr": "TM", "Value": ["094647.660000"]}, "3422": {"vr": "TM", "Value": ["095407.634000"]}, "3423": {"vr": "TM", "Value": ["095427.705000"]}, "3424": {"vr": "TM", "Value": ["095027.718000"]}, "3425": {"vr": "TM", "Value": ["095007.684000"]}, "3426": {"vr": "TM", "Value": ["095347.710000"]}, "3427": {"vr": "TM", "Value": ["095127.675000"]}, "3428": {"vr": "TM", "Value": ["094927.928000"]}, "3429": {"vr": "TM", "Value": ["094947.719000"]}, "3430": {"vr": "TM", "Value": ["095107.871000"]}, "3431": {"vr": "TM", "Value": ["095327.719000"]}, "3432": {"vr": "TM", "Value": ["094627.771000"]}, "3433": {"vr": "TM", "Value": ["094627.721000"]}, "3434": {"vr": "TM", "Value": ["095227.942000"]}, "3435": {"vr": "TM", "Value": ["095207.744000"]}, "3436": {"vr": "TM", "Value": ["095327.748000"]}, "3437": {"vr": "TM", "Value": ["095347.799000"]}, "3438": {"vr": "TM", "Value": ["094827.656000"]}, "3439": {"vr": "TM", "Value": ["095147.657000"]}, "3440": {"vr": "TM", "Value": ["095247.765000"]}, "3441": {"vr": "TM", "Value": ["095307.941000"]}, "3442": {"vr": "TM", "Value": ["095207.731000"]}, "3443": {"vr": "TM", "Value": ["095347.822000"]}, "3444": {"vr": "TM", "Value": ["095027.664000"]}, "3445": {"vr": "TM", "Value": ["094547.625000"]}, "3446": {"vr": "TM", "Value": ["094527.660000"]}, "3447": {"vr": "TM", "Value": ["095427.621000"]}, "3448": {"vr": "TM", "Value": ["094947.742000"]}, "3449": {"vr": "TM", "Value": ["094907.790000"]}, "3450": {"vr": "TM", "Value": ["095247.813000"]}, "3451": {"vr": "TM", "Value": ["095027.931000"]}, "3452": {"vr": "TM", "Value": ["094847.761000"]}, "3453": {"vr": "TM", "Value": ["094907.931000"]}, "3454": {"vr": "TM", "Value": ["094827.870000"]}, "3455": {"vr": "TM", "Value": ["094627.851000"]}, "3456": {"vr": "TM", "Value": ["094927.936000"]}, "3457": {"vr": "TM", "Value": ["095247.668000"]}, "3458": {"vr": "TM", "Value": ["095107.854000"]}, "3459": {"vr": "TM", "Value": ["095407.779000"]}, "3460": {"vr": "TM", "Value": ["095107.711000"]}, "3461": {"vr": "TM", "Value": ["094647.631000"]}, "3462": {"vr": "TM", "Value": ["094807.831000"]}, "3463": {"vr": "TM", "Value": ["095127.814000"]}, "3464": {"vr": "TM", "Value": ["095447.662000"]}, "3465": {"vr": "TM", "Value": ["095127.880000"]}, "3466": {"vr": "TM", "Value": ["094847.906000"]}, "3467": {"vr": "TM", "Value": ["095347.692000"]}, "3468": {"vr": "TM", "Value": ["094827.743000"]}, "3469": {"vr": "TM", "Value": ["094727.776000"]}, "3470": {"vr": "TM", "Value": ["095127.718000"]}, "3471": {"vr": "TM", "Value": ["095107.828000"]}, "3472": {"vr": "TM", "Value": ["095347.874000"]}, "3473": {"vr": "TM", "Value": ["094607.823000"]}, "3474": {"vr": "TM", "Value": ["094707.661000"]}, "3475": {"vr": "TM", "Value": ["094927.863000"]}, "3476": {"vr": "TM", "Value": ["094547.871000"]}, "3477": {"vr": "TM", "Value": ["094527.860000"]}, "3478": {"vr": "TM", "Value": ["095347.936000"]}, "3479": {"vr": "TM", "Value": ["095107.749000"]}, "3480": {"vr": "TM", "Value": ["094727.607000"]}, "3481": {"vr": "TM", "Value": ["095456.451000"]}, "3482": {"vr": "TM", "Value": ["095307.632000"]}, "3483": {"vr": "TM", "Value": ["095347.905000"]}, "3484": {"vr": "TM", "Value": ["095407.661000"]}, "3485": {"vr": "TM", "Value": ["095127.803000"]}, "3486": {"vr": "TM", "Value": ["095247.818000"]}, "3487": {"vr": "TM", "Value": ["095447.889000"]}, "3488": {"vr": "TM", "Value": ["094547.827000"]}, "3489": {"vr": "TM", "Value": ["095227.819000"]}, "3490": {"vr": "TM", "Value": ["094607.722000"]}, "3491": {"vr": "TM", "Value": ["095347.661000"]}, "3492": {"vr": "TM", "Value": ["094827.924000"]}, "3493": {"vr": "TM", "Value": ["095427.771000"]}, "3494": {"vr": "TM", "Value": ["095047.928000"]}, "3495": {"vr": "TM", "Value": ["095227.894000"]}, "3496": {"vr": "TM", "Value": ["094927.687000"]}, "3497": {"vr": "TM", "Value": ["095127.786000"]}, "3498": {"vr": "TM", "Value": ["095327.738000"]}, "3499": {"vr": "TM", "Value": ["094907.877000"]}, "3500": {"vr": "TM", "Value": ["095307.784000"]}, "3501": {"vr": "TM", "Value": ["095007.919000"]}, "3502": {"vr": "TM", "Value": ["095007.934000"]}, "3503": {"vr": "TM", "Value": ["095327.711000"]}, "3504": {"vr": "TM", "Value": ["094547.802000"]}, "3505": {"vr": "TM", "Value": ["094807.773000"]}, "3506": {"vr": "TM", "Value": ["094847.950000"]}, "3507": {"vr": "TM", "Value": ["095047.795000"]}, "3508": {"vr": "TM", "Value": ["095307.661000"]}, "3509": {"vr": "TM", "Value": ["095207.644000"]}, "3510": {"vr": "TM", "Value": ["095027.629000"]}, "3511": {"vr": "TM", "Value": ["094527.683000"]}, "3512": {"vr": "TM", "Value": ["094927.807000"]}, "3513": {"vr": "TM", "Value": ["095107.670000"]}, "3514": {"vr": "TM", "Value": ["095407.644000"]}, "3515": {"vr": "TM", "Value": ["095027.726000"]}, "3516": {"vr": "TM", "Value": ["094527.931000"]}, "3517": {"vr": "TM", "Value": ["095427.631000"]}, "3518": {"vr": "TM", "Value": ["094727.911000"]}, "3519": {"vr": "TM", "Value": ["095027.767000"]}, "3520": {"vr": "TM", "Value": ["095207.913000"]}, "3521": {"vr": "TM", "Value": ["095456.469000"]}, "3522": {"vr": "TM", "Value": ["094527.613000"]}, "3523": {"vr": "TM", "Value": ["095447.757000"]}, "3524": {"vr": "TM", "Value": ["095147.660000"]}, "3525": {"vr": "TM", "Value": ["095007.659000"]}, "3526": {"vr": "TM", "Value": ["094847.698000"]}, "3527": {"vr": "TM", "Value": ["095427.713000"]}, "3528": {"vr": "TM", "Value": ["094807.653000"]}, "3529": {"vr": "TM", "Value": ["095456.445000"]}, "3530": {"vr": "TM", "Value": ["094827.607000"]}, "3531": {"vr": "TM", "Value": ["094647.688000"]}, "3532": {"vr": "TM", "Value": ["094827.849000"]}, "3533": {"vr": "TM", "Value": ["094827.813000"]}, "3534": {"vr": "TM", "Value": ["095407.682000"]}, "3535": {"vr": "TM", "Value": ["095227.632000"]}, "3536": {"vr": "TM", "Value": ["094727.637000"]}, "3537": {"vr": "TM", "Value": ["094627.630000"]}, "3538": {"vr": "TM", "Value": ["095207.800000"]}, "3539": {"vr": "TM", "Value": ["095456.527000"]}, "3540": {"vr": "TM", "Value": ["095047.861000"]}, "3541": {"vr": "TM", "Value": ["095207.833000"]}, "3542": {"vr": "TM", "Value": ["094807.628000"]}, "3543": {"vr": "TM", "Value": ["094907.885000"]}, "3544": {"vr": "TM", "Value": ["094947.692000"]}, "3545": {"vr": "TM", "Value": ["094847.872000"]}, "3546": {"vr": "TM", "Value": ["095007.715000"]}, "3547": {"vr": "TM", "Value": ["094847.682000"]}, "3548": {"vr": "TM", "Value": ["095107.784000"]}, "3549": {"vr": "TM", "Value": ["094627.627000"]}, "3550": {"vr": "TM", "Value": ["095147.652000"]}, "3551": {"vr": "TM", "Value": ["094627.667000"]}, "3552": {"vr": "TM", "Value": ["095407.860000"]}, "3553": {"vr": "TM", "Value": ["094947.726000"]}, "3554": {"vr": "TM", "Value": ["094847.669000"]}, "3555": {"vr": "TM", "Value": ["094947.627000"]}, "3556": {"vr": "TM", "Value": ["094807.960000"]}, "3557": {"vr": "TM", "Value": ["094747.668000"]}, "3558": {"vr": "TM", "Value": ["094607.943000"]}, "3559": {"vr": "TM", "Value": ["095047.703000"]}, "3560": {"vr": "TM", "Value": ["094927.865000"]}, "3561": {"vr": "TM", "Value": ["095247.684000"]}, "3562": {"vr": "TM", "Value": ["094907.834000"]}, "3563": {"vr": "TM", "Value": ["095227.701000"]}, "3564": {"vr": "TM", "Value": ["094927.623000"]}, "3565": {"vr": "TM", "Value": ["095327.654000"]}, "3566": {"vr": "TM", "Value": ["095047.721000"]}, "3567": {"vr": "TM", "Value": ["094607.918000"]}, "3568": {"vr": "TM", "Value": ["094527.965000"]}, "3569": {"vr": "TM", "Value": ["094707.930000"]}, "3570": {"vr": "TM", "Value": ["094827.794000"]}, "3571": {"vr": "TM", "Value": ["094607.656000"]}, "3572": {"vr": "TM", "Value": ["095047.705000"]}, "3573": {"vr": "TM", "Value": ["094547.864000"]}, "3574": {"vr": "TM", "Value": ["094627.805000"]}, "3575": {"vr": "TM", "Value": ["094707.663000"]}, "3576": {"vr": "TM", "Value": ["095147.684000"]}, "3577": {"vr": "TM", "Value": ["094947.711000"]}, "3578": {"vr": "TM", "Value": ["094647.825000"]}, "3579": {"vr": "TM", "Value": ["095007.677000"]}, "3580": {"vr": "TM", "Value": ["095427.784000"]}, "3581": {"vr": "TM", "Value": ["095307.802000"]}, "3582": {"vr": "TM", "Value": ["095027.754000"]}, "3583": {"vr": "TM", "Value": ["095447.839000"]}, "3584": {"vr": "TM", "Value": ["094707.813000"]}, "3585": {"vr": "TM", "Value": ["095047.700000"]}, "3586": {"vr": "TM", "Value": ["095347.953000"]}, "3587": {"vr": "TM", "Value": ["095347.835000"]}, "3588": {"vr": "TM", "Value": ["094907.760000"]}, "3589": {"vr": "TM", "Value": ["095327.721000"]}, "3590": {"vr": "TM", "Value": ["094847.766000"]}, "3591": {"vr": "TM", "Value": ["095307.673000"]}, "3592": {"vr": "TM", "Value": ["094907.866000"]}, "3593": {"vr": "TM", "Value": ["095307.907000"]}, "3594": {"vr": "TM", "Value": ["095247.760000"]}, "3595": {"vr": "TM", "Value": ["094727.815000"]}, "3596": {"vr": "TM", "Value": ["094827.899000"]}, "3597": {"vr": "TM", "Value": ["094747.628000"]}, "3598": {"vr": "TM", "Value": ["094827.934000"]}, "3599": {"vr": "TM", "Value": ["094547.761000"]}, "3600": {"vr": "TM", "Value": ["095127.911000"]}, "3601": {"vr": "TM", "Value": ["095227.934000"]}, "3602": {"vr": "TM", "Value": ["094947.730000"]}, "3603": {"vr": "TM", "Value": ["094827.675000"]}, "3604": {"vr": "TM", "Value": ["094907.874000"]}, "3605": {"vr": "TM", "Value": ["094927.827000"]}, "3606": {"vr": "TM", "Value": ["095047.618000"]}, "3607": {"vr": "TM", "Value": ["095447.652000"]}, "3608": {"vr": "TM", "Value": ["094727.954000"]}, "3609": {"vr": "TM", "Value": ["095407.651000"]}, "3610": {"vr": "TM", "Value": ["095327.680000"]}, "3611": {"vr": "TM", "Value": ["094607.773000"]}, "3612": {"vr": "TM", "Value": ["095027.627000"]}, "3613": {"vr": "TM", "Value": ["095247.689000"]}, "3614": {"vr": "TM", "Value": ["095327.666000"]}, "3615": {"vr": "TM", "Value": ["094627.746000"]}, "3616": {"vr": "TM", "Value": ["094947.685000"]}, "3617": {"vr": "TM", "Value": ["094707.707000"]}, "3618": {"vr": "TM", "Value": ["094627.714000"]}, "3619": {"vr": "TM", "Value": ["094527.972000"]}, "3620": {"vr": "TM", "Value": ["094807.817000"]}, "3621": {"vr": "TM", "Value": ["094847.688000"]}, "3622": {"vr": "TM", "Value": ["094607.768000"]}, "3623": {"vr": "TM", "Value": ["094647.870000"]}, "3624": {"vr": "TM", "Value": ["095447.806000"]}, "3625": {"vr": "TM", "Value": ["095447.703000"]}, "3626": {"vr": "TM", "Value": ["094927.783000"]}, "3627": {"vr": "TM", "Value": ["095347.804000"]}, "3628": {"vr": "TM", "Value": ["095147.852000"]}, "3629": {"vr": "TM", "Value": ["094547.950000"]}, "3630": {"vr": "TM", "Value": ["095347.912000"]}, "3631": {"vr": "TM", "Value": ["095407.880000"]}, "3632": {"vr": "TM", "Value": ["094747.638000"]}, "3633": {"vr": "TM", "Value": ["095227.650000"]}, "3634": {"vr": "TM", "Value": ["095407.632000"]}, "3635": {"vr": "TM", "Value": ["094927.649000"]}, "3636": {"vr": "TM", "Value": ["095447.778000"]}, "3637": {"vr": "TM", "Value": ["094547.910000"]}, "3638": {"vr": "TM", "Value": ["094647.975000"]}, "3639": {"vr": "TM", "Value": ["095427.941000"]}, "3640": {"vr": "TM", "Value": ["095007.817000"]}, "3641": {"vr": "TM", "Value": ["094847.816000"]}, "3642": {"vr": "TM", "Value": ["095427.918000"]}, "3643": {"vr": "TM", "Value": ["094947.739000"]}, "3644": {"vr": "TM", "Value": ["095107.896000"]}, "3645": {"vr": "TM", "Value": ["094627.896000"]}, "3646": {"vr": "TM", "Value": ["094707.925000"]}, "3647": {"vr": "TM", "Value": ["095247.731000"]}, "3648": {"vr": "TM", "Value": ["095227.719000"]}, "3649": {"vr": "TM", "Value": ["095027.667000"]}, "3650": {"vr": "TM", "Value": ["094907.639000"]}, "3651": {"vr": "TM", "Value": ["094807.785000"]}, "3652": {"vr": "TM", "Value": ["095027.816000"]}, "3653": {"vr": "TM", "Value": ["095327.784000"]}, "3654": {"vr": "TM", "Value": ["095007.856000"]}, "3655": {"vr": "TM", "Value": ["094707.709000"]}, "3656": {"vr": "TM", "Value": ["095147.877000"]}, "3657": {"vr": "TM", "Value": ["095407.877000"]}, "3658": {"vr": "TM", "Value": ["094607.807000"]}, "3659": {"vr": "TM", "Value": ["095407.911000"]}, "3660": {"vr": "TM", "Value": ["094627.955000"]}, "3661": {"vr": "TM", "Value": ["094747.610000"]}, "3662": {"vr": "TM", "Value": ["095347.669000"]}, "3663": {"vr": "TM", "Value": ["095347.723000"]}, "3664": {"vr": "TM", "Value": ["094627.904000"]}, "3665": {"vr": "TM", "Value": ["094727.957000"]}, "3666": {"vr": "TM", "Value": ["095227.791000"]}, "3667": {"vr": "TM", "Value": ["094927.825000"]}, "3668": {"vr": "TM", "Value": ["094707.619000"]}, "3669": {"vr": "TM", "Value": ["094807.728000"]}, "3670": {"vr": "TM", "Value": ["094807.641000"]}, "3671": {"vr": "TM", "Value": ["094947.787000"]}, "3672": {"vr": "TM", "Value": ["094547.908000"]}, "3673": {"vr": "TM", "Value": ["095456.534000"]}, "3674": {"vr": "TM", "Value": ["094627.738000"]}, "3675": {"vr": "TM", "Value": ["094907.681000"]}, "3676": {"vr": "TM", "Value": ["095227.765000"]}, "3677": {"vr": "TM", "Value": ["094607.928000"]}, "3678": {"vr": "TM", "Value": ["095227.689000"]}, "3679": {"vr": "TM", "Value": ["095227.755000"]}, "3680": {"vr": "TM", "Value": ["095127.917000"]}, "3681": {"vr": "TM", "Value": ["094707.697000"]}, "3682": {"vr": "TM", "Value": ["094807.790000"]}, "3683": {"vr": "TM", "Value": ["094947.827000"]}, "3684": {"vr": "TM", "Value": ["094627.894000"]}, "3685": {"vr": "TM", "Value": ["095207.849000"]}, "3686": {"vr": "TM", "Value": ["094847.768000"]}, "3687": {"vr": "TM", "Value": ["095147.779000"]}, "3688": {"vr": "TM", "Value": ["095107.718000"]}, "3689": {"vr": "TM", "Value": ["095247.630000"]}, "3690": {"vr": "TM", "Value": ["094547.741000"]}, "3691": {"vr": "TM", "Value": ["094847.735000"]}, "3692": {"vr": "TM", "Value": ["094607.851000"]}, "3693": {"vr": "TM", "Value": ["095047.666000"]}, "3694": {"vr": "TM", "Value": ["095427.642000"]}, "3695": {"vr": "TM", "Value": ["094627.640000"]}, "3696": {"vr": "TM", "Value": ["095007.798000"]}, "3697": {"vr": "TM", "Value": ["094907.829000"]}, "3698": {"vr": "TM", "Value": ["094647.946000"]}, "3699": {"vr": "TM", "Value": ["094807.918000"]}, "3700": {"vr": "TM", "Value": ["095447.719000"]}, "3701": {"vr": "TM", "Value": ["094647.695000"]}, "3702": {"vr": "TM", "Value": ["094747.726000"]}, "3703": {"vr": "TM", "Value": ["095427.860000"]}, "3704": {"vr": "TM", "Value": ["095147.928000"]}, "3705": {"vr": "TM", "Value": ["094607.843000"]}, "3706": {"vr": "TM", "Value": ["095047.902000"]}, "3707": {"vr": "TM", "Value": ["094707.868000"]}, "3708": {"vr": "TM", "Value": ["095227.732000"]}, "3709": {"vr": "TM", "Value": ["094827.699000"]}, "3710": {"vr": "TM", "Value": ["095247.722000"]}, "3711": {"vr": "TM", "Value": ["095327.835000"]}, "3712": {"vr": "TM", "Value": ["094907.716000"]}, "3713": {"vr": "TM", "Value": ["094527.941000"]}, "3714": {"vr": "TM", "Value": ["095427.894000"]}, "3715": {"vr": "TM", "Value": ["095047.833000"]}, "3716": {"vr": "TM", "Value": ["095147.784000"]}, "3717": {"vr": "TM", "Value": ["095427.609000"]}, "3718": {"vr": "TM", "Value": ["095347.746000"]}, "3719": {"vr": "TM", "Value": ["094607.765000"]}, "3720": {"vr": "TM", "Value": ["095247.870000"]}, "3721": {"vr": "TM", "Value": ["094947.880000"]}, "3722": {"vr": "TM", "Value": ["094907.796000"]}, "3723": {"vr": "TM", "Value": ["094827.907000"]}, "3724": {"vr": "TM", "Value": ["094727.743000"]}, "3725": {"vr": "TM", "Value": ["094647.769000"]}, "3726": {"vr": "TM", "Value": ["095227.627000"]}, "3727": {"vr": "TM", "Value": ["095047.876000"]}, "3728": {"vr": "TM", "Value": ["095207.646000"]}, "3729": {"vr": "TM", "Value": ["095327.692000"]}, "3730": {"vr": "TM", "Value": ["094627.660000"]}, "3731": {"vr": "TM", "Value": ["095127.691000"]}, "3732": {"vr": "TM", "Value": ["094707.907000"]}, "3733": {"vr": "TM", "Value": ["094547.684000"]}, "3734": {"vr": "TM", "Value": ["095427.626000"]}, "3735": {"vr": "TM", "Value": ["095327.804000"]}, "3736": {"vr": "TM", "Value": ["095407.751000"]}, "3737": {"vr": "TM", "Value": ["094847.928000"]}, "3738": {"vr": "TM", "Value": ["095447.632000"]}, "3739": {"vr": "TM", "Value": ["095047.830000"]}, "3740": {"vr": "TM", "Value": ["094807.885000"]}, "3741": {"vr": "TM", "Value": ["095127.811000"]}, "3742": {"vr": "TM", "Value": ["095007.795000"]}, "3743": {"vr": "TM", "Value": ["095247.644000"]}, "3744": {"vr": "TM", "Value": ["094527.732000"]}, "3745": {"vr": "TM", "Value": ["094547.618000"]}, "3746": {"vr": "TM", "Value": ["094807.687000"]}, "3747": {"vr": "TM", "Value": ["095407.776000"]}, "3748": {"vr": "TM", "Value": ["095347.850000"]}, "3749": {"vr": "TM", "Value": ["094827.750000"]}, "3750": {"vr": "TM", "Value": ["094847.847000"]}, "3751": {"vr": "TM", "Value": ["094807.807000"]}, "3752": {"vr": "TM", "Value": ["094807.848000"]}, "3753": {"vr": "TM", "Value": ["094947.640000"]}, "3754": {"vr": "TM", "Value": ["095007.664000"]}, "3755": {"vr": "TM", "Value": ["095027.703000"]}, "3756": {"vr": "TM", "Value": ["095147.736000"]}, "3757": {"vr": "TM", "Value": ["094627.950000"]}, "3758": {"vr": "TM", "Value": ["095327.871000"]}, "3759": {"vr": "TM", "Value": ["094927.883000"]}, "3760": {"vr": "TM", "Value": ["094647.707000"]}, "3761": {"vr": "TM", "Value": ["094927.684000"]}, "3762": {"vr": "TM", "Value": ["094607.651000"]}, "3763": {"vr": "TM", "Value": ["095147.833000"]}, "3764": {"vr": "TM", "Value": ["095107.665000"]}, "3765": {"vr": "TM", "Value": ["095447.858000"]}, "3766": {"vr": "TM", "Value": ["094947.867000"]}, "3767": {"vr": "TM", "Value": ["095127.832000"]}, "3768": {"vr": "TM", "Value": ["095327.891000"]}, "3769": {"vr": "TM", "Value": ["094647.899000"]}, "3770": {"vr": "TM", "Value": ["094747.633000"]}, "3771": {"vr": "TM", "Value": ["095447.608000"]}, "3772": {"vr": "TM", "Value": ["095027.625000"]}, "3773": {"vr": "TM", "Value": ["095327.613000"]}, "3774": {"vr": "TM", "Value": ["094927.830000"]}, "3775": {"vr": "TM", "Value": ["095107.894000"]}, "3776": {"vr": "TM", "Value": ["094527.925000"]}, "3777": {"vr": "TM", "Value": ["095027.646000"]}, "3778": {"vr": "TM", "Value": ["094607.700000"]}, "3779": {"vr": "TM", "Value": ["094847.654000"]}, "3780": {"vr": "TM", "Value": ["094607.661000"]}, "3781": {"vr": "TM", "Value": ["095347.728000"]}, "3782": {"vr": "TM", "Value": ["094647.655000"]}, "3783": {"vr": "TM", "Value": ["094647.838000"]}, "3784": {"vr": "TM", "Value": ["095447.786000"]}, "3785": {"vr": "TM", "Value": ["094647.910000"]}, "3786": {"vr": "TM", "Value": ["095027.721000"]}, "3787": {"vr": "TM", "Value": ["094527.890000"]}, "3788": {"vr": "TM", "Value": ["094707.612000"]}, "3789": {"vr": "TM", "Value": ["095307.776000"]}, "3790": {"vr": "TM", "Value": ["094707.735000"]}, "3791": {"vr": "TM", "Value": ["094627.853000"]}, "3792": {"vr": "TM", "Value": ["094747.693000"]}, "3793": {"vr": "TM", "Value": ["094947.716000"]}, "3794": {"vr": "TM", "Value": ["094527.938000"]}, "3795": {"vr": "TM", "Value": ["095147.789000"]}, "3796": {"vr": "TM", "Value": ["095427.819000"]}, "3797": {"vr": "TM", "Value": ["094747.858000"]}, "3798": {"vr": "TM", "Value": ["095147.679000"]}, "3799": {"vr": "TM", "Value": ["094747.737000"]}, "3800": {"vr": "TM", "Value": ["095427.635000"]}, "3801": {"vr": "TM", "Value": ["094947.721000"]}, "3802": {"vr": "TM", "Value": ["095407.671000"]}, "3803": {"vr": "TM", "Value": ["094647.772000"]}, "3804": {"vr": "TM", "Value": ["095127.872000"]}, "3805": {"vr": "TM", "Value": ["095147.787000"]}, "3806": {"vr": "TM", "Value": ["095147.859000"]}, "3807": {"vr": "TM", "Value": ["095307.702000"]}, "3808": {"vr": "TM", "Value": ["095427.716000"]}, "3809": {"vr": "TM", "Value": ["094707.768000"]}, "3810": {"vr": "TM", "Value": ["095327.917000"]}, "3811": {"vr": "TM", "Value": ["095227.897000"]}, "3812": {"vr": "TM", "Value": ["095447.832000"]}, "3813": {"vr": "TM", "Value": ["095227.610000"]}, "3814": {"vr": "TM", "Value": ["094847.938000"]}, "3815": {"vr": "TM", "Value": ["095107.906000"]}, "3816": {"vr": "TM", "Value": ["095207.721000"]}, "3817": {"vr": "TM", "Value": ["095207.608000"]}, "3818": {"vr": "TM", "Value": ["094647.851000"]}, "3819": {"vr": "TM", "Value": ["094827.776000"]}, "3820": {"vr": "TM", "Value": ["095127.929000"]}, "3821": {"vr": "TM", "Value": ["095047.931000"]}, "3822": {"vr": "TM", "Value": ["095427.778000"]}, "3823": {"vr": "TM", "Value": ["095207.882000"]}, "3824": {"vr": "TM", "Value": ["095447.909000"]}, "3825": {"vr": "TM", "Value": ["094827.865000"]}, "3826": {"vr": "TM", "Value": ["094547.876000"]}, "3827": {"vr": "TM", "Value": ["095027.887000"]}, "3828": {"vr": "TM", "Value": ["094827.701000"]}, "3829": {"vr": "TM", "Value": ["095307.910000"]}, "3830": {"vr": "TM", "Value": ["094907.848000"]}, "3831": {"vr": "TM", "Value": ["095107.663000"]}, "3832": {"vr": "TM", "Value": ["095007.896000"]}, "3833": {"vr": "TM", "Value": ["094947.704000"]}, "3834": {"vr": "TM", "Value": ["094607.784000"]}, "3835": {"vr": "TM", "Value": ["095407.708000"]}, "3836": {"vr": "TM", "Value": ["095227.786000"]}, "3837": {"vr": "TM", "Value": ["094727.847000"]}, "3838": {"vr": "TM", "Value": ["094527.783000"]}, "3839": {"vr": "TM", "Value": ["094527.793000"]}, "3840": {"vr": "TM", "Value": ["095307.725000"]}, "3841": {"vr": "TM", "Value": ["094707.784000"]}, "3842": {"vr": "TM", "Value": ["094607.663000"]}, "3843": {"vr": "TM", "Value": ["095107.819000"]}, "3844": {"vr": "TM", "Value": ["094707.770000"]}, "3845": {"vr": "TM", "Value": ["094827.889000"]}, "3846": {"vr": "TM", "Value": ["095207.846000"]}, "3847": {"vr": "TM", "Value": ["095127.893000"]}, "3848": {"vr": "TM", "Value": ["095147.610000"]}, "3849": {"vr": "TM", "Value": ["095427.659000"]}, "3850": {"vr": "TM", "Value": ["095027.731000"]}, "3851": {"vr": "TM", "Value": ["095207.815000"]}, "3852": {"vr": "TM", "Value": ["094727.645000"]}, "3853": {"vr": "TM", "Value": ["094607.649000"]}, "3854": {"vr": "TM", "Value": ["094847.790000"]}, "3855": {"vr": "TM", "Value": ["095456.466000"]}, "3856": {"vr": "TM", "Value": ["094547.654000"]}, "3857": {"vr": "TM", "Value": ["094707.909000"]}, "3858": {"vr": "TM", "Value": ["094547.622000"]}, "3859": {"vr": "TM", "Value": ["095027.943000"]}, "3860": {"vr": "TM", "Value": ["094727.844000"]}, "3861": {"vr": "TM", "Value": ["094947.925000"]}, "3862": {"vr": "TM", "Value": ["094747.848000"]}, "3863": {"vr": "TM", "Value": ["095327.670000"]}, "3864": {"vr": "TM", "Value": ["094907.651000"]}, "3865": {"vr": "TM", "Value": ["095107.903000"]}, "3866": {"vr": "TM", "Value": ["094927.951000"]}, "3867": {"vr": "TM", "Value": ["094607.926000"]}, "3868": {"vr": "TM", "Value": ["094707.732000"]}, "3869": {"vr": "TM", "Value": ["095247.680000"]}, "3870": {"vr": "TM", "Value": ["095447.657000"]}, "3871": {"vr": "TM", "Value": ["095347.659000"]}, "3872": {"vr": "TM", "Value": ["094607.903000"]}, "3873": {"vr": "TM", "Value": ["095307.715000"]}, "3874": {"vr": "TM", "Value": ["095147.712000"]}, "3875": {"vr": "TM", "Value": ["095407.845000"]}, "3876": {"vr": "TM", "Value": ["094747.790000"]}, "3877": {"vr": "TM", "Value": ["095407.725000"]}, "3878": {"vr": "TM", "Value": ["095327.750000"]}, "3879": {"vr": "TM", "Value": ["094727.852000"]}, "3880": {"vr": "TM", "Value": ["095207.757000"]}, "3881": {"vr": "TM", "Value": ["094907.733000"]}, "3882": {"vr": "TM", "Value": ["095147.861000"]}, "3883": {"vr": "TM", "Value": ["094927.878000"]}, "3884": {"vr": "TM", "Value": ["095007.936000"]}, "3885": {"vr": "TM", "Value": ["094647.982000"]}, "3886": {"vr": "TM", "Value": ["095307.936000"]}, "3887": {"vr": "TM", "Value": ["095027.854000"]}, "3888": {"vr": "TM", "Value": ["094807.846000"]}, "3889": {"vr": "TM", "Value": ["094547.789000"]}, "3890": {"vr": "TM", "Value": ["094927.773000"]}, "3891": {"vr": "TM", "Value": ["095107.923000"]}, "3892": {"vr": "TM", "Value": ["095427.698000"]}, "3893": {"vr": "TM", "Value": ["095147.943000"]}, "3894": {"vr": "TM", "Value": ["094607.611000"]}, "3895": {"vr": "TM", "Value": ["094747.641000"]}, "3896": {"vr": "TM", "Value": ["095427.799000"]}, "3897": {"vr": "TM", "Value": ["095347.781000"]}, "3898": {"vr": "TM", "Value": ["095107.798000"]}, "3899": {"vr": "TM", "Value": ["095207.854000"]}, "3900": {"vr": "TM", "Value": ["094647.965000"]}, "3901": {"vr": "TM", "Value": ["095307.615000"]}, "3902": {"vr": "TM", "Value": ["095027.875000"]}, "3903": {"vr": "TM", "Value": ["095227.887000"]}, "3904": {"vr": "TM", "Value": ["094947.922000"]}, "3905": {"vr": "TM", "Value": ["095447.677000"]}, "3906": {"vr": "TM", "Value": ["095047.715000"]}, "3907": {"vr": "TM", "Value": ["095347.866000"]}, "3908": {"vr": "TM", "Value": ["094807.843000"]}, "3909": {"vr": "TM", "Value": ["094647.801000"]}, "3910": {"vr": "TM", "Value": ["094607.621000"]}, "3911": {"vr": "TM", "Value": ["094847.859000"]}, "3912": {"vr": "TM", "Value": ["095407.885000"]}, "3913": {"vr": "TM", "Value": ["094927.817000"]}, "3914": {"vr": "TM", "Value": ["095107.620000"]}, "3915": {"vr": "TM", "Value": ["094527.963000"]}, "3916": {"vr": "TM", "Value": ["094827.904000"]}, "3917": {"vr": "TM", "Value": ["094607.901000"]}, "3918": {"vr": "TM", "Value": ["095007.644000"]}, "3919": {"vr": "TM", "Value": ["094927.642000"]}, "3920": {"vr": "TM", "Value": ["094807.623000"]}, "3921": {"vr": "TM", "Value": ["095327.848000"]}, "3922": {"vr": "TM", "Value": ["095427.850000"]}, "3923": {"vr": "TM", "Value": ["094647.649000"]}, "3924": {"vr": "TM", "Value": ["094527.975000"]}, "3925": {"vr": "TM", "Value": ["094807.705000"]}, "3926": {"vr": "TM", "Value": ["095227.635000"]}, "3927": {"vr": "TM", "Value": ["095227.844000"]}, "3928": {"vr": "TM", "Value": ["095007.872000"]}, "3929": {"vr": "TM", "Value": ["095307.915000"]}, "3930": {"vr": "TM", "Value": ["095247.651000"]}, "3931": {"vr": "TM", "Value": ["094947.915000"]}, "3932": {"vr": "TM", "Value": ["095147.920000"]}, "3933": {"vr": "TM", "Value": ["095347.920000"]}, "3934": {"vr": "TM", "Value": ["095027.902000"]}, "3935": {"vr": "TM", "Value": ["095347.899000"]}, "3936": {"vr": "TM", "Value": ["095047.656000"]}, "3937": {"vr": "TM", "Value": ["095147.806000"]}, "3938": {"vr": "TM", "Value": ["095427.791000"]}, "3939": {"vr": "TM", "Value": ["094647.894000"]}, "3940": {"vr": "TM", "Value": ["094907.952000"]}, "3941": {"vr": "TM", "Value": ["095347.638000"]}, "3942": {"vr": "TM", "Value": ["095207.877000"]}, "3943": {"vr": "TM", "Value": ["095427.612000"]}, "3944": {"vr": "TM", "Value": ["095047.853000"]}, "3945": {"vr": "TM", "Value": ["094827.927000"]}, "3946": {"vr": "TM", "Value": ["095427.624000"]}, "3947": {"vr": "TM", "Value": ["094647.897000"]}, "3948": {"vr": "TM", "Value": ["094827.706000"]}, "3949": {"vr": "TM", "Value": ["095347.961000"]}, "3950": {"vr": "TM", "Value": ["095127.663000"]}, "3951": {"vr": "TM", "Value": ["094907.646000"]}, "3952": {"vr": "TM", "Value": ["095027.895000"]}, "3953": {"vr": "TM", "Value": ["095047.664000"]}, "3954": {"vr": "TM", "Value": ["094627.719000"]}, "3955": {"vr": "TM", "Value": ["095447.916000"]}, "3956": {"vr": "TM", "Value": ["095027.741000"]}, "3957": {"vr": "TM", "Value": ["095007.730000"]}, "3958": {"vr": "TM", "Value": ["094847.693000"]}, "3959": {"vr": "TM", "Value": ["095347.845000"]}, "3960": {"vr": "TM", "Value": ["095147.705000"]}, "3961": {"vr": "TM", "Value": ["095207.897000"]}, "3962": {"vr": "TM", "Value": ["095327.608000"]}, "3963": {"vr": "TM", "Value": ["094727.758000"]}, "3964": {"vr": "TM", "Value": ["095207.693000"]}, "3965": {"vr": "TM", "Value": ["095447.750000"]}, "3966": {"vr": "TM", "Value": ["094707.758000"]}, "3967": {"vr": "TM", "Value": ["094907.803000"]}, "3968": {"vr": "TM", "Value": ["094707.659000"]}, "3969": {"vr": "TM", "Value": ["094607.659000"]}, "3970": {"vr": "TM", "Value": ["094947.635000"]}, "3971": {"vr": "TM", "Value": ["094607.879000"]}, "3972": {"vr": "TM", "Value": ["095247.677000"]}, "3973": {"vr": "TM", "Value": ["094907.735000"]}, "3974": {"vr": "TM", "Value": ["094807.800000"]}, "3975": {"vr": "TM", "Value": ["095247.915000"]}, "3976": {"vr": "TM", "Value": ["094547.682000"]}, "3977": {"vr": "TM", "Value": ["094627.942000"]}, "3978": {"vr": "TM", "Value": ["095447.637000"]}, "3979": {"vr": "TM", "Value": ["094927.799000"]}, "3980": {"vr": "TM", "Value": ["094647.822000"]}, "3981": {"vr": "TM", "Value": ["095227.625000"]}, "3982": {"vr": "TM", "Value": ["094947.933000"]}, "3983": {"vr": "TM", "Value": ["094547.809000"]}, "3984": {"vr": "TM", "Value": ["094747.874000"]}, "3985": {"vr": "TM", "Value": ["095047.936000"]}, "3986": {"vr": "TM", "Value": ["095427.825000"]}, "3987": {"vr": "TM", "Value": ["094907.939000"]}, "3988": {"vr": "TM", "Value": ["095007.608000"]}, "3989": {"vr": "TM", "Value": ["094847.845000"]}, "3990": {"vr": "TM", "Value": ["095047.744000"]}, "3991": {"vr": "TM", "Value": ["095047.835000"]}, "3992": {"vr": "TM", "Value": ["095427.812000"]}, "3993": {"vr": "TM", "Value": ["095347.690000"]}, "3994": {"vr": "TM", "Value": ["094947.766000"]}, "3995": {"vr": "TM", "Value": ["094707.704000"]}, "3996": {"vr": "TM", "Value": ["094607.752000"]}, "3997": {"vr": "TM", "Value": ["095347.838000"]}, "3998": {"vr": "TM", "Value": ["094947.752000"]}, "3999": {"vr": "TM", "Value": ["095227.613000"]}, "4000": {"vr": "TM", "Value": ["095407.637000"]}, "4001": {"vr": "TM", "Value": ["095207.887000"]}, "4002": {"vr": "TM", "Value": ["095247.777000"]}, "4003": {"vr": "TM", "Value": ["094847.711000"]}, "4004": {"vr": "TM", "Value": ["095347.718000"]}, "4005": {"vr": "TM", "Value": ["094727.849000"]}, "4006": {"vr": "TM", "Value": ["094627.699000"]}, "4007": {"vr": "TM", "Value": ["095107.759000"]}, "4008": {"vr": "TM", "Value": ["094727.683000"]}, "4009": {"vr": "TM", "Value": ["095007.786000"]}, "4010": {"vr": "TM", "Value": ["095027.649000"]}, "4011": {"vr": "TM", "Value": ["094647.985000"]}, "4012": {"vr": "TM", "Value": ["095307.763000"]}, "4013": {"vr": "TM", "Value": ["094647.796000"]}, "4014": {"vr": "TM", "Value": ["094827.696000"]}, "4015": {"vr": "TM", "Value": ["095407.883000"]}, "4016": {"vr": "TM", "Value": ["095407.630000"]}, "4017": {"vr": "TM", "Value": ["094947.920000"]}, "4018": {"vr": "TM", "Value": ["095247.628000"]}, "4019": {"vr": "TM", "Value": ["095107.747000"]}}, "00080018": {"0": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481869288465334"]}, "1": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493043786867779"]}, "2": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951186426671444"]}, "3": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513932806972169"]}, "4": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505156166170544"]}, "5": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504319990370259"]}, "6": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530249890375004"]}, "7": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532097791675634"]}, "8": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483115074865754"]}, "9": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470020140562654"]}, "10": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530028133974929"]}, "11": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484146026666109"]}, "12": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483715618465959"]}, "13": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451052518358914"]}, "14": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495861388668739"]}, "15": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515119790572574"]}, "16": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524654876174464"]}, "17": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460188420160669"]}, "18": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475946517564674"]}, "19": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515460085172694"]}, "20": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471033735562999"]}, "21": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520532910273059"]}, "22": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522644106673779"]}, "23": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535327104176739"]}, "24": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952111313973249"]}, "25": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475712540364594"]}, "26": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949409391168104"]}, "27": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472396862363464"]}, "28": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474616955764224"]}, "29": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951443431672329"]}, "30": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494199915068169"]}, "31": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482644806065594"]}, "32": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502236234569549"]}, "33": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473912629063984"]}, "34": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545585417778869"]}, "35": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450716039158799"]}, "36": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464231292362044"]}, "37": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475423973164499"]}, "38": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510690448271064"]}, "39": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491559618067269"]}, "40": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531861541975554"]}, "41": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542696971277884"]}, "42": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543215081278064"]}, "43": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475960897764679"]}, "44": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524928427974554"]}, "45": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461693509361179"]}, "46": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530145615774969"]}, "47": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542345434877764"]}, "48": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490798443867014"]}, "49": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453293294159679"]}, "50": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522948929373879"]}, "51": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523894374169"]}, "52": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524757306374499"]}, "53": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481619101465244"]}, "54": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463340627261744"]}, "55": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484952896666384"]}, "56": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504476811570309"]}, "57": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490698293466979"]}, "58": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483027676765724"]}, "59": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472794245063599"]}, "60": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514210840472264"]}, "61": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953135235175364"]}, "62": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948163987165239"]}, "63": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543810872978264"]}, "64": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504035844970159"]}, "65": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543944601278309"]}, "66": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481735870665284"]}, "67": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484434686966204"]}, "68": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465185838662374"]}, "69": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471634097463204"]}, "70": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462765587461544"]}, "71": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504974395870479"]}, "72": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504419968070294"]}, "73": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520557943373064"]}, "74": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460627265060819"]}, "75": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540819652477244"]}, "76": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520221414672949"]}, "77": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494345913668219"]}, "78": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514451022772349"]}, "79": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473835159163954"]}, "80": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545395037078804"]}, "81": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460593594060804"]}, "82": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511189971571234"]}, "83": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502231872669544"]}, "84": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452398509359374"]}, "85": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514944280072514"]}, "86": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524286982874339"]}, "87": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520455767373029"]}, "88": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490635378866954"]}, "89": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534516112876459"]}, "90": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450895758658864"]}, "91": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464935477462284"]}, "92": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521966758373544"]}, "93": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462677576061514"]}, "94": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534179826276344"]}, "95": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472587446663529"]}, "96": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473574068263869"]}, "97": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544456495178484"]}, "98": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451934505359219"]}, "99": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452018479659244"]}, "100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461649726561164"]}, "101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485271004466489"]}, "102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461856725361234"]}, "103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501529878069304"]}, "104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525593442274784"]}, "105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533886732176244"]}, "106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521130629373259"]}, "107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953319358075979"]}, "108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471414844263129"]}, "109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471561060663179"]}, "110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543722715278234"]}, "111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525930039474899"]}, "112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482133128865419"]}, "113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543269456678079"]}, "114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500329621268899"]}, "115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522040161873569"]}, "116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530893750875224"]}, "117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470563985062839"]}, "118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951296242671819"]}, "119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544720072078574"]}, "120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455053151960279"]}, "121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453234733459659"]}, "122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524341463974354"]}, "123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451798576459169"]}, "124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521569387173409"]}, "125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500722700969029"]}, "126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542930931877964"]}, "127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094919441667389"]}, "128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513483044772019"]}, "129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480929012165009"]}, "130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461283715061039"]}, "131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514490416772359"]}, "132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533842958976229"]}, "133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542448059277799"]}, "134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533989140376279"]}, "135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474349217764134"]}, "136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494243542968184"]}, "137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504286362770244"]}, "138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461561506161134"]}, "139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948017584764729"]}, "140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483819960365994"]}, "141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454027416459929"]}, "142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501870433569424"]}, "143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524414429174379"]}, "144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502511955669639"]}, "145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525060407474599"]}, "146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460242852460684"]}, "147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472367650363454"]}, "148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530266030475014"]}, "149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524223916674314"]}, "150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495591587068644"]}, "151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471795025963259"]}, "152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543840112478274"]}, "153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473291807563769"]}, "154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451681853159129"]}, "155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515765335372794"]}, "156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474788073364279"]}, "157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490062714766759"]}, "158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502760741969724"]}, "159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455757452060519"]}, "160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545483140878834"]}, "161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525721004674824"]}, "162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473645083663889"]}, "163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524082370374269"]}, "164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470024429662659"]}, "165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522773877573819"]}, "166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504945091670469"]}, "167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490781958567004"]}, "168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946337078761729"]}, "169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480680729764924"]}, "170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455391635960394"]}, "171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475858477964644"]}, "172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945436980760024"]}, "173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542712953677894"]}, "174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471299096763094"]}, "175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481838104565319"]}, "176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452693304259474"]}, "177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525327685874694"]}, "178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954097071077274"]}, "179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524723642274484"]}, "180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470388124762779"]}, "181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482034863365389"]}, "182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522978242873889"]}, "183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511540940271354"]}, "184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453412177259719"]}, "185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475022271164359"]}, "186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521937357173534"]}, "187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522073503373584"]}, "188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954256674977819"]}, "189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485993855766739"]}, "190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502129517969509"]}, "191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451550440559084"]}, "192": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520499390473044"]}, "193": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461225029361019"]}, "194": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541362954177429"]}, "195": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950296903069774"]}, "196": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510767322271094"]}, "197": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490228035466819"]}, "198": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450950267858879"]}, "199": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951136751471274"]}, "200": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453191293359644"]}, "201": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514417795972334"]}, "202": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521262738373304"]}, "203": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474982871564349"]}, "204": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491471496167239"]}, "205": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522479084773719"]}, "206": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523684556974134"]}, "207": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504183915270209"]}, "208": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454173468259979"]}, "209": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461988257461279"]}, "210": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500354745768904"]}, "211": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503450681269959"]}, "212": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534520446976464"]}, "213": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534649915776504"]}, "214": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520762756373134"]}, "215": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505459200870644"]}, "216": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471151224963039"]}, "217": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470124622962689"]}, "218": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541465496377464"]}, "219": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493068767067784"]}, "220": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483178207665779"]}, "221": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950125266069194"]}, "222": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502275585169559"]}, "223": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454177618459984"]}, "224": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454950602560244"]}, "225": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455352269160384"]}, "226": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510897361271134"]}, "227": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464851715462259"]}, "228": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503949642570134"]}, "229": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480914702965004"]}, "230": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470994401362989"]}, "231": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465976437462639"]}, "232": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522744526073809"]}, "233": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523785117174164"]}, "234": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480724426664939"]}, "235": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523668470374124"]}, "236": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535176755476684"]}, "237": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454145812559974"]}, "238": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501088520069154"]}, "239": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524738710774489"]}, "240": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485891499866704"]}, "241": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501063423669149"]}, "242": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512333442371624"]}, "243": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482371417065504"]}, "244": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542036444177659"]}, "245": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532434256675749"]}, "246": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451027682958909"]}, "247": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461831492261229"]}, "248": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503713800270049"]}, "249": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504685857470384"]}, "250": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513346842771974"]}, "251": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475657907964579"]}, "252": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950187609969399"]}, "253": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502395056169599"]}, "254": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505810646770764"]}, "255": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484669736866284"]}, "256": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531759270075519"]}, "257": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540395224377099"]}, "258": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485711866466639"]}, "259": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485343884666514"]}, "260": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464044958261984"]}, "261": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530834827875204"]}, "262": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475555709064544"]}, "263": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461488480161109"]}, "264": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532977904375934"]}, "265": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542315899777754"]}, "266": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543449408678144"]}, "267": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483379257865844"]}, "268": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462588132161484"]}, "269": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515853447472824"]}, "270": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545614786078879"]}, "271": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522273890073649"]}, "272": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954124173077379"]}, "273": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494448155368254"]}, "274": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462740547561539"]}, "275": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464949934662289"]}, "276": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522610727073764"]}, "277": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535694957376864"]}, "278": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094831929165749"]}, "279": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480048939864709"]}, "280": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510485740870994"]}, "281": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485594456866599"]}, "282": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453911584559894"]}, "283": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494814138868379"]}, "284": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541290037677404"]}, "285": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952249885673699"]}, "286": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950236829969574"]}, "287": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461361041761069"]}, "288": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471565092263184"]}, "289": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543854492978279"]}, "290": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544810160878604"]}, "291": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490194382066804"]}, "292": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494623648368314"]}, "293": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472221603763404"]}, "294": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542126349277689"]}, "295": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951308737471854"]}, "296": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473646804463894"]}, "297": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945254890259414"]}, "298": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452927505259554"]}, "299": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452237365959319"]}, "300": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542360677877769"]}, "301": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545146567278719"]}, "302": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951091517471139"]}, "303": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492659590467644"]}, "304": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493436759467909"]}, "305": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470360524862774"]}, "306": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540290864377064"]}, "307": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492775936867684"]}, "308": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534840243876569"]}, "309": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504740179770399"]}, "310": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502731493469714"]}, "311": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464438122862114"]}, "312": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513140606571899"]}, "313": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545248843078754"]}, "314": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954318299978024"]}, "315": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471765862463249"]}, "316": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464483450262134"]}, "317": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535410863676764"]}, "318": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483335394665829"]}, "319": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950284499769739"]}, "320": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511762789771429"]}, "321": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947152312663159"]}, "322": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954072602477204"]}, "323": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493816796668039"]}, "324": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492512396467594"]}, "325": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471064980663014"]}, "326": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945559020360434"]}, "327": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511369875671299"]}, "328": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530937210675239"]}, "329": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511497268571339"]}, "330": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453968395859909"]}, "331": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494536390568284"]}, "332": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470856410662939"]}, "333": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523344188474014"]}, "334": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491118636967119"]}, "335": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480562873164884"]}, "336": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472237808563414"]}, "337": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490328044866854"]}, "338": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453880301959879"]}, "339": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948371148865954"]}, "340": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462794956961554"]}, "341": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543151929578039"]}, "342": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480226217664774"]}, "343": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533548200576129"]}, "344": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483912046466029"]}, "345": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520196302172944"]}, "346": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461958832761269"]}, "347": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465890236762614"]}, "348": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495093913468474"]}, "349": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451023187858904"]}, "350": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513980643372189"]}, "351": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540129680177009"]}, "352": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495255360768529"]}, "353": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494977210068434"]}, "354": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492370636167549"]}, "355": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532072682775629"]}, "356": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474333136364124"]}, "357": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453161846059634"]}, "358": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522625607973769"]}, "359": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470695725962884"]}, "360": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453397850259714"]}, "361": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500124931968829"]}, "362": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521291916373314"]}, "363": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500588793468984"]}, "364": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532068379575624"]}, "365": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500665777369014"]}, "366": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954244378977784"]}, "367": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465888421162609"]}, "368": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464584040462164"]}, "369": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530454691075074"]}, "370": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095222721773624"]}, "371": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521237294773299"]}, "372": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515955805272859"]}, "373": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510631702571044"]}, "374": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492527548067599"]}, "375": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505962967270819"]}, "376": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494433854968249"]}, "377": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530968460775254"]}, "378": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491636857667299"]}, "379": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473526106563849"]}, "380": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490428377666884"]}, "381": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947239288263434"]}, "382": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484478242866219"]}, "383": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945131166858999"]}, "384": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495993131168784"]}, "385": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534120891576324"]}, "386": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534223435076359"]}, "387": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510134508170874"]}, "388": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540027233776974"]}, "389": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490564183366934"]}, "390": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465639840762524"]}, "391": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534624846476499"]}, "392": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480362356964819"]}, "393": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511160638671224"]}, "394": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505093046170519"]}, "395": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495577164668639"]}, "396": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482498767865544"]}, "397": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494889157368404"]}, "398": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455552686060449"]}, "399": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465052425962324"]}, "400": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490518563766914"]}, "401": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464216200562039"]}, "402": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475212860264424"]}, "403": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503845355870094"]}, "404": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455216414660334"]}, "405": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521540012173399"]}, "406": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471736350763239"]}, "407": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475653700764574"]}, "408": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501264046169214"]}, "409": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505020245970494"]}, "410": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473310431963779"]}, "411": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533197220976009"]}, "412": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452956862759564"]}, "413": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465819796662589"]}, "414": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455684411460494"]}, "415": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525823253574859"]}, "416": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493980040468094"]}, "417": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460422576160749"]}, "418": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451388989559029"]}, "419": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455718166160509"]}, "420": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543651643478214"]}, "421": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461885894661244"]}, "422": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474015050264019"]}, "423": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532463560675759"]}, "424": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513712833972094"]}, "425": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541597195377509"]}, "426": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515360092972659"]}, "427": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512644454271734"]}, "428": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540056613676984"]}, "429": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515678447572764"]}, "430": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503170353469864"]}, "431": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946421798462034"]}, "432": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541640984877524"]}, "433": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951248312271654"]}, "434": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470226883462724"]}, "435": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954353734178159"]}, "436": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451652363159119"]}, "437": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481635328365254"]}, "438": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505415550270629"]}, "439": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525827580774864"]}, "440": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535617690476834"]}, "441": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461929424761259"]}, "442": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463733777361874"]}, "443": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533284693976039"]}, "444": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513081864771879"]}, "445": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513683659372084"]}, "446": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524518839174414"]}, "447": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452120721959279"]}, "448": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531934595075579"]}, "449": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503410864069949"]}, "450": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535249759676709"]}, "451": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470710334262889"]}, "452": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522875897373854"]}, "453": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454041888959934"]}, "454": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480665751564919"]}, "455": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505239891170569"]}, "456": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480063219564714"]}, "457": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481428616065179"]}, "458": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490957781167064"]}, "459": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475917081264664"]}, "460": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948339987465824"]}, "461": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505224836670564"]}, "462": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492441270367574"]}, "463": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510426932370974"]}, "464": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530297853575024"]}, "465": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474585214064214"]}, "466": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465656124962534"]}, "467": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501439886469274"]}, "468": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453983123459914"]}, "469": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544883274278629"]}, "470": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504050164870164"]}, "471": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503174771269869"]}, "472": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470158213962704"]}, "473": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534723042176529"]}, "474": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533314089076049"]}, "475": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451213700358969"]}, "476": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953429022476354"]}, "477": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472660628663554"]}, "478": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541156450877359"]}, "479": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525486866274744"]}, "480": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494084250768134"]}, "481": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452150067259289"]}, "482": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470622618462859"]}, "483": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531539523575444"]}, "484": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510838476471114"]}, "485": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521423513273359"]}, "486": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481458058065189"]}, "487": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484098020766089"]}, "488": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484919322466369"]}, "489": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524826063274519"]}, "490": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502936229569784"]}, "491": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494686648868339"]}, "492": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472558074263519"]}, "493": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525779548874844"]}, "494": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532668362275829"]}, "495": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481667064065264"]}, "496": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495416075768584"]}, "497": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451535355959079"]}, "498": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541934054277624"]}, "499": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455348141260379"]}, "500": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461254384761029"]}, "501": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545556189878859"]}, "502": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502070788969489"]}, "503": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948569517066604"]}, "504": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483247199065799"]}, "505": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455670011660489"]}, "506": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471433367863139"]}, "507": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946496105862274"]}, "508": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474011128664014"]}, "509": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493144084067809"]}, "510": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534679238876514"]}, "511": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949277201267664"]}, "512": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475358876264474"]}, "513": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095215735473389"]}, "514": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464749385662224"]}, "515": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482337763365489"]}, "516": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451696077859134"]}, "517": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533945509976264"]}, "518": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485036644466409"]}, "519": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470626591962864"]}, "520": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514185518372259"]}, "521": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452971149559569"]}, "522": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493714446768004"]}, "523": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544149534678379"]}, "524": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470197593262714"]}, "525": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493984278268099"]}, "526": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542080148877674"]}, "527": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535734405076874"]}, "528": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535381575076754"]}, "529": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452873057359539"]}, "530": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472353163263449"]}, "531": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482839548465664"]}, "532": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452737083259489"]}, "533": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472969672763659"]}, "534": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501738585569379"]}, "535": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952175478273459"]}, "536": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515090457772564"]}, "537": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501029703869134"]}, "538": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505429707870634"]}, "539": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450788969258824"]}, "540": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480782922464959"]}, "541": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540717485877209"]}, "542": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095005728268954"]}, "543": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544724264578579"]}, "544": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464540419362149"]}, "545": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492791030667689"]}, "546": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535924751376939"]}, "547": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535663233676854"]}, "548": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948287778465654"]}, "549": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511840068671459"]}, "550": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504681683070379"]}, "551": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525911310874889"]}, "552": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505488698570654"]}, "553": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464686434062199"]}, "554": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500530172968964"]}, "555": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450920735658869"]}, "556": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472896575163634"]}, "557": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542638025477864"]}, "558": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510017395470834"]}, "559": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524548288574424"]}, "560": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505751877370744"]}, "561": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534418009776429"]}, "562": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520014656572879"]}, "563": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475551643764539"]}, "564": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505795543170759"]}, "565": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490257462066829"]}, "566": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512040649371524"]}, "567": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948285979965649"]}, "568": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515046583172549"]}, "569": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491534477067264"]}, "570": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481167026765094"]}, "571": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530868480775219"]}, "572": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534559806676474"]}, "573": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541038765177319"]}, "574": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535191049176689"]}, "575": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510926571971144"]}, "576": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512074186971539"]}, "577": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533299834076044"]}, "578": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501249669269209"]}, "579": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525384519074709"]}, "580": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525764578174839"]}, "581": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951467765372399"]}, "582": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500829386569069"]}, "583": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511997054771509"]}, "584": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521730551373464"]}, "585": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451198905058964"]}, "586": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533475167576104"]}, "587": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946448592962104"]}, "588": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472269570663424"]}, "589": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532141584275649"]}, "590": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485373311666524"]}, "591": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503611246970014"]}, "592": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533817977376224"]}, "593": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523066257473919"]}, "594": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451827912659179"]}, "595": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452561633459429"]}, "596": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494682417068334"]}, "597": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485814265666674"]}, "598": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532770880175864"]}, "599": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473810115063949"]}, "600": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482791667165644"]}, "601": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514344293272309"]}, "602": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495391082468579"]}, "603": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540468165177124"]}, "604": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460859201760894"]}, "605": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541699608777544"]}, "606": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522746132573814"]}, "607": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951258679371684"]}, "608": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535588310976824"]}, "609": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521189435073279"]}, "610": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954268759777854"]}, "611": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500296069468884"]}, "612": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945292458859549"]}, "613": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525016783874584"]}, "614": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495620928168654"]}, "615": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515155475972589"]}, "616": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520060194172894"]}, "617": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460493113760774"]}, "618": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947018218162684"]}, "619": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502290573069564"]}, "620": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950201989769469"]}, "621": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463439053861774"]}, "622": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452034583159254"]}, "623": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535486050776789"]}, "624": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544960412278659"]}, "625": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530061674874944"]}, "626": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947193748463299"]}, "627": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465556126762499"]}, "628": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945253226159409"]}, "629": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490650332166959"]}, "630": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522142081273604"]}, "631": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475873441764649"]}, "632": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460418361160744"]}, "633": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502173200269524"]}, "634": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480358205264814"]}, "635": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523110045373934"]}, "636": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465244737662389"]}, "637": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470289989562749"]}, "638": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515226084372614"]}, "639": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543240182878069"]}, "640": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462529497561464"]}, "641": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461063919360964"]}, "642": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475687508964589"]}, "643": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521834929173499"]}, "644": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530663739075149"]}, "645": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492071461967444"]}, "646": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531086027275289"]}, "647": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510060993970849"]}, "648": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541185597277369"]}, "649": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491298344767184"]}, "650": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946214985461319"]}, "651": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473674255563899"]}, "652": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095304205475059"]}, "653": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947288516763604"]}, "654": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513272083071944"]}, "655": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948141109265174"]}, "656": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512174184271574"]}, "657": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453866019759874"]}, "658": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520265058172964"]}, "659": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463292822861724"]}, "660": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502497612269634"]}, "661": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530366559375044"]}, "662": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464143077862014"]}, "663": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545633645878889"]}, "664": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515326491372644"]}, "665": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515253502472619"]}, "666": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494481917968269"]}, "667": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946227475161354"]}, "668": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500047461868799"]}, "669": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452536504959424"]}, "670": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461595228461149"]}, "671": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510297215670934"]}, "672": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535954272776949"]}, "673": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455586354960464"]}, "674": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530820446375199"]}, "675": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484687004766294"]}, "676": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483144692165764"]}, "677": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490125682666784"]}, "678": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463365722861749"]}, "679": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495988833468779"]}, "680": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513038060871864"]}, "681": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543371902178114"]}, "682": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523653296674119"]}, "683": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954306410077989"]}, "684": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521335353073329"]}, "685": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460052498160619"]}, "686": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490326438566849"]}, "687": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513874025572149"]}, "688": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493641485367979"]}, "689": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945216053559274"]}, "690": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495798353868714"]}, "691": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453470826459739"]}, "692": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454248323960004"]}, "693": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454716572560164"]}, "694": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492941333067744"]}, "695": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455889150860564"]}, "696": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522493929973724"]}, "697": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490913987667049"]}, "698": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505944485170809"]}, "699": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482878951865674"]}, "700": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455483976460429"]}, "701": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522567011073749"]}, "702": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453543767359764"]}, "703": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525148495874629"]}, "704": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475814662564629"]}, "705": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480958284165019"]}, "706": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510824165371109"]}, "707": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465022884362314"]}, "708": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948348357865854"]}, "709": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524048700574254"]}, "710": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530057496474939"]}, "711": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520796352773149"]}, "712": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451930394159214"]}, "713": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504315670170254"]}, "714": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482294047665474"]}, "715": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513610764472059"]}, "716": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520298657172979"]}, "717": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530630150775134"]}, "718": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535118144276664"]}, "719": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494521265968279"]}, "720": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460725289660849"]}, "721": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505826774570774"]}, "722": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463499520761794"]}, "723": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542974775977979"]}, "724": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523377863174029"]}, "725": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453088594259609"]}, "726": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540629302977179"]}, "727": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534854665176574"]}, "728": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452722809959484"]}, "729": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540688211577199"]}, "730": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500854376169074"]}, "731": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485789204366669"]}, "732": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464613306462174"]}, "733": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542536096677829"]}, "734": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945472352960159"]}, "735": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485475618266559"]}, "736": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472162883263384"]}, "737": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461386057261074"]}, "738": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525561663174774"]}, "739": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451593752259099"]}, "740": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464176674562029"]}, "741": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455220553060339"]}, "742": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947005861162649"]}, "743": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532580196175799"]}, "744": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505663948470714"]}, "745": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946545881962444"]}, "746": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465786132162574"]}, "747": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504154519170199"]}, "748": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513111078371889"]}, "749": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515282949172629"]}, "750": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543988250078324"]}, "751": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480023845664704"]}, "752": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523519597574074"]}, "753": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461151995960994"]}, "754": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515648852672754"]}, "755": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494038678468114"]}, "756": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481984958665369"]}, "757": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545263220678759"]}, "758": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474642080664229"]}, "759": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454438780060069"]}, "760": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472455659263484"]}, "761": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947458182564184"]}, "762": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542847108577939"]}, "763": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513112903571894"]}, "764": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949506597268444"]}, "765": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470885893862949"]}, "766": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471385433263119"]}, "767": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532170959675659"]}, "768": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503743074470059"]}, "769": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952225119473629"]}, "770": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481823782965314"]}, "771": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545365658578794"]}, "772": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485653224466619"]}, "773": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954061764877174"]}, "774": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474186384464074"]}, "775": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471019459562994"]}, "776": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484332171466169"]}, "777": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500076860468809"]}, "778": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543445303178139"]}, "779": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454075241659949"]}, "780": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950456218170319"]}, "781": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485289603466499"]}, "782": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540867633477264"]}, "783": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520398939973014"]}, "784": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452268607759334"]}, "785": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515021619872544"]}, "786": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504217626970224"]}, "787": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465683592562539"]}, "788": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531422538475404"]}, "789": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481090188365064"]}, "790": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535895486576929"]}, "791": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531656794875484"]}, "792": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454881930160224"]}, "793": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515297215972634"]}, "794": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481031389665044"]}, "795": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949029487266809"]}, "796": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474318032264119"]}, "797": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510178820470889"]}, "798": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515794701972804"]}, "799": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453778039059844"]}, "800": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462663218961509"]}, "801": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451597985159104"]}, "802": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461331687761059"]}, "803": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523770761374159"]}, "804": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523285360873994"]}, "805": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480092585364724"]}, "806": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510324922270939"]}, "807": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522010910973559"]}, "808": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475081069664379"]}, "809": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502027067069474"]}, "810": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500429595068934"]}, "811": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520235621772954"]}, "812": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490884581767039"]}, "813": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502877571769764"]}, "814": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505988025870824"]}, "815": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542784175777914"]}, "816": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953187047275539"]}, "817": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543679439978219"]}, "818": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503145293769859"]}, "819": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949264976167629"]}, "820": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531261473875349"]}, "821": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531025439475269"]}, "822": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483540037565899"]}, "823": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511585309571369"]}, "824": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524621272774449"]}, "825": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510930877471149"]}, "826": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480696610064934"]}, "827": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545060330478694"]}, "828": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493231830467839"]}, "829": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513614873472064"]}, "830": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460374531760729"]}, "831": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481384964865164"]}, "832": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473732793563919"]}, "833": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463072803661649"]}, "834": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461327429761054"]}, "835": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544120207978369"]}, "836": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481955550365359"]}, "837": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461459237361099"]}, "838": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454468146360079"]}, "839": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471533379563174"]}, "840": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530718084775164"]}, "841": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514314943272299"]}, "842": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455318701260369"]}, "843": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495562135568634"]}, "844": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474817423064289"]}, "845": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945374980959819"]}, "846": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500193637568849"]}, "847": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515694341172774"]}, "848": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494389537268234"]}, "849": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461620250261154"]}, "850": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513420090271994"]}, "851": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502863528969759"]}, "852": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950276415569709"]}, "853": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521525755373394"]}, "854": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473442232263824"]}, "855": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472090020163359"]}, "856": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491896081967384"]}, "857": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510661052871054"]}, "858": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474978642664344"]}, "859": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460315928360709"]}, "860": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948335886165819"]}, "861": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544824334778609"]}, "862": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534340755776399"]}, "863": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951238308471619"]}, "864": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543887685978294"]}, "865": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485055266466419"]}, "866": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520631033773089"]}, "867": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464920523562279"]}, "868": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513566944272044"]}, "869": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465624884162519"]}, "870": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482469487365534"]}, "871": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492130204067464"]}, "872": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453073554859604"]}, "873": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953354484276114"]}, "874": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514856188172484"]}, "875": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451466406259059"]}, "876": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470053877962669"]}, "877": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460520610260779"]}, "878": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533949792476269"]}, "879": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453514459059754"]}, "880": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455859795160554"]}, "881": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470783279262914"]}, "882": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460258974560694"]}, "883": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470183260962709"]}, "884": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532511490475779"]}, "885": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545560447278864"]}, "886": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471767626863254"]}, "887": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494580025868299"]}, "888": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465610510162514"]}, "889": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455118206460304"]}, "890": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474656439364234"]}, "891": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495725413568689"]}, "892": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540999456077309"]}, "893": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503879089970109"]}, "894": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947398299563979"]}, "895": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949494277468409"]}, "896": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463442996561779"]}, "897": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494947933668424"]}, "898": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502261399469554"]}, "899": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484890191366359"]}, "900": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492425098867564"]}, "901": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460696032160839"]}, "902": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502677034469699"]}, "903": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544618095778539"]}, "904": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461181293961004"]}, "905": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472528730763509"]}, "906": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460991003460939"]}, "907": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515721959372779"]}, "908": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495022822268454"]}, "909": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543547636178174"]}, "910": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510295669670929"]}, "911": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485784901566664"]}, "912": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542040456177664"]}, "913": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510765462171089"]}, "914": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472167274663389"]}, "915": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503772366470069"]}, "916": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542565059477839"]}, "917": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514287447772294"]}, "918": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525177765674639"]}, "919": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451155122058949"]}, "920": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946399001861934"]}, "921": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475610322864559"]}, "922": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525091518974614"]}, "923": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522669262973784"]}, "924": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450730610458804"]}, "925": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454453032860074"]}, "926": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544897879578634"]}, "927": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515575790472729"]}, "928": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532875274575899"]}, "929": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502834040369749"]}, "930": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493773225468024"]}, "931": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495679701068674"]}, "932": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545160846578724"]}, "933": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510985256871164"]}, "934": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453631928459794"]}, "935": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949215129867459"]}, "936": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514051225272214"]}, "937": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491998440667419"]}, "938": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544755744878589"]}, "939": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485256037966484"]}, "940": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525998843574919"]}, "941": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525725209374829"]}, "942": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470728832962899"]}, "943": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949202747767424"]}, "944": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511777116771434"]}, "945": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540247274777049"]}, "946": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511072658671194"]}, "947": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490595981466944"]}, "948": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514049383872209"]}, "949": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948131149565139"]}, "950": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952479334674479"]}, "951": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490547921266924"]}, "952": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471165539663044"]}, "953": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950214492069504"]}, "954": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520894605173179"]}, "955": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460056746760624"]}, "956": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514152196172244"]}, "957": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490223695766814"]}, "958": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952454548174409"]}, "959": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481194456365099"]}, "960": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949175585867319"]}, "961": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500032511768794"]}, "962": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530116089474959"]}, "963": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515857732972829"]}, "964": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464128777262009"]}, "965": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473880810763974"]}, "966": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491325568967189"]}, "967": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535515288576799"]}, "968": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470651909962869"]}, "969": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470958752162974"]}, "970": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452663949859464"]}, "971": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471667554963219"]}, "972": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540265728277059"]}, "973": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532361179075724"]}, "974": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503199804769874"]}, "975": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512628241271724"]}, "976": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947483106664284"]}, "977": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493743819968014"]}, "978": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545351401378789"]}, "979": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514476325272354"]}, "980": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515224211472609"]}, "981": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533679934776174"]}, "982": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490121470166779"]}, "983": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514137759572239"]}, "984": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524972917874569"]}, "985": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493729532668009"]}, "986": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483437710065864"]}, "987": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945277770559479"]}, "988": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532829582675884"]}, "989": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491339739967194"]}, "990": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493919253368074"]}, "991": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540188465177029"]}, "992": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480899586064999"]}, "993": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954198710677619"]}, "994": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463572501261819"]}, "995": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530030063874934"]}, "996": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544795093778599"]}, "997": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521337256573334"]}, "998": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524786632274509"]}, "999": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542740540377899"]}, "1000": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494918601068414"]}, "1001": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542813518477924"]}, "1002": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455420944360404"]}, "1003": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473042648163684"]}, "1004": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533665489176169"]}, "1005": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514787489972464"]}, "1006": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521878628473514"]}, "1007": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471136123563034"]}, "1008": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461195597561009"]}, "1009": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471824412763269"]}, "1010": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533167974075999"]}, "1011": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544252026778414"]}, "1012": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521028596073224"]}, "1013": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952197968873524"]}, "1014": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514549006772379"]}, "1015": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545428632778819"]}, "1016": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948273612965614"]}, "1017": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543079095378014"]}, "1018": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474934970864329"]}, "1019": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534355075376404"]}, "1020": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520367378872999"]}, "1021": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541860629277599"]}, "1022": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483878419366014"]}, "1023": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490489243666904"]}, "1024": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521266813073309"]}, "1025": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945366871059789"]}, "1026": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454365800060044"]}, "1027": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520485060873039"]}, "1028": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533387026176074"]}, "1029": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504520542370324"]}, "1030": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451448020559049"]}, "1031": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463277605361719"]}, "1032": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482221062665449"]}, "1033": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492838957767709"]}, "1034": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464172495962024"]}, "1035": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535161726376679"]}, "1036": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484244222166139"]}, "1037": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505547282470674"]}, "1038": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462573037561479"]}, "1039": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482762182765634"]}, "1040": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481326246065144"]}, "1041": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520328026672989"]}, "1042": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481531094865214"]}, "1043": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950162922369329"]}, "1044": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475844090064639"]}, "1045": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455377410060389"]}, "1046": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505858554470784"]}, "1047": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540483192377129"]}, "1048": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541674530177539"]}, "1049": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453646219459799"]}, "1050": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503684277370039"]}, "1051": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494786628468374"]}, "1052": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463238263761709"]}, "1053": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505899926470794"]}, "1054": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462441864961434"]}, "1055": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483075747165744"]}, "1056": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525955183774904"]}, "1057": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541260645177394"]}, "1058": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521364843973339"]}, "1059": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485682584766629"]}, "1060": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451332856559014"]}, "1061": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454263440560009"]}, "1062": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472035487163344"]}, "1063": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483393922265849"]}, "1064": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472542996763514"]}, "1065": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482776589465639"]}, "1066": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484817247866334"]}, "1067": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520118938672914"]}, "1068": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530734325475174"]}, "1069": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504754569670404"]}, "1070": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471063137063009"]}, "1071": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525662213574804"]}, "1072": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520562303773069"]}, "1073": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545175933678729"]}, "1074": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544661163178554"]}, "1075": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463616267261834"]}, "1076": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505049508070504"]}, "1077": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522715187973799"]}, "1078": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470987972262984"]}, "1079": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530195515374989"]}, "1080": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481633563765249"]}, "1081": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464599082462169"]}, "1082": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520426324073019"]}, "1083": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520660379273099"]}, "1084": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461298052161044"]}, "1085": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525882006474879"]}, "1086": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520093886372909"]}, "1087": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520294442672974"]}, "1088": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531875772175559"]}, "1089": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515075995472559"]}, "1090": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495886464268744"]}, "1091": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482864806765669"]}, "1092": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514637245272409"]}, "1093": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461754347361199"]}, "1094": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542876550177949"]}, "1095": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521496551673384"]}, "1096": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510853565771119"]}, "1097": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482689135765609"]}, "1098": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532814723975879"]}, "1099": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512540273471694"]}, "1100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494550655468289"]}, "1101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951213531771549"]}, "1102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511292453871269"]}, "1103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530381674875049"]}, "1104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463233852061704"]}, "1105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513551896872039"]}, "1106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463380102961754"]}, "1107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949518952868479"]}, "1108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472837898963614"]}, "1109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542276483477744"]}, "1110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095311375275294"]}, "1111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475755956364609"]}, "1112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471517456163164"]}, "1113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951515598272569"]}, "1114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494716029168349"]}, "1115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541274960777399"]}, "1116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452266688259329"]}, "1117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523246058773984"]}, "1118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471228482363069"]}, "1119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541141635477354"]}, "1120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542613017577859"]}, "1121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493965666768089"]}, "1122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470944483562969"]}, "1123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460917925960914"]}, "1124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493039773567774"]}, "1125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491030506967089"]}, "1126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544515392278504"]}, "1127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463982405161959"]}, "1128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511821570971449"]}, "1129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483966385766044"]}, "1130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954231545577749"]}, "1131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465184048562369"]}, "1132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464099450061999"]}, "1133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505358597270614"]}, "1134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520940615373194"]}, "1135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491427738867224"]}, "1136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482573631165574"]}, "1137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524884808774539"]}, "1138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463175147761684"]}, "1139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500899936169094"]}, "1140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454980239160254"]}, "1141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485460620066554"]}, "1142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460759018960864"]}, "1143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463145762661674"]}, "1144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472823593563609"]}, "1145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495522849968624"]}, "1146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480812280864969"]}, "1147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545321993478779"]}, "1148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465037922362319"]}, "1149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450964656858884"]}, "1150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543417488078134"]}, "1151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949227180467494"]}, "1152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503140966369854"]}, "1153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495474791868604"]}, "1154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504788270970419"]}, "1155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503377306569934"]}, "1156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464040696361979"]}, "1157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453059206559599"]}, "1158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524552507774429"]}, "1159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495138335268489"]}, "1160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505576576870684"]}, "1161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465479027162469"]}, "1162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512099317971544"]}, "1163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511599589571374"]}, "1164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491720592967324"]}, "1165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953174673475504"]}, "1166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451363988359024"]}, "1167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522157069073609"]}, "1168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455918572260574"]}, "1169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525852663274869"]}, "1170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532346122075719"]}, "1171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462222478661359"]}, "1172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514578377272389"]}, "1173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540599947077169"]}, "1174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514826835272474"]}, "1175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523614003174109"]}, "1176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522934663973874"]}, "1177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533211620976014"]}, "1178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451520844759074"]}, "1179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473028374563679"]}, "1180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485523568066579"]}, "1181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483778205965984"]}, "1182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454599863260124"]}, "1183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502143918169514"]}, "1184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525647923774799"]}, "1185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485930928766714"]}, "1186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453372732459709"]}, "1187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493879847268064"]}, "1188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952429740874309"]}, "1189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531290844575359"]}, "1190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535983468976959"]}, "1191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451316031959004"]}, "1192": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465581267462504"]}, "1193": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500195531068854"]}, "1194": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544412686878469"]}, "1195": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949152732567254"]}, "1196": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453264064159669"]}, "1197": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954111854577344"]}, "1198": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482969025765704"]}, "1199": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520279999872969"]}, "1200": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530395957375054"]}, "1201": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451096600158931"]}, "1202": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464788810462234"]}, "1203": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543518070678164"]}, "1204": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522464595373714"]}, "1205": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504622897070359"]}, "1206": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532611459775814"]}, "1207": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511628986871384"]}, "1208": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452770723559504"]}, "1209": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454614070460129"]}, "1210": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502911190969779"]}, "1211": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543167111578044"]}, "1212": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472635410363549"]}, "1213": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501297727369229"]}, "1214": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535427069876774"]}, "1215": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503874800470104"]}, "1216": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520470120073034"]}, "1217": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522275735573654"]}, "1218": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452459315659394"]}, "1219": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531320126275369"]}, "1220": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531788724275529"]}, "1221": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541440287177459"]}, "1222": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470681337962879"]}, "1223": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535059337376644"]}, "1224": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484584984466259"]}, "1225": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094535155959749"]}, "1226": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452532488859419"]}, "1227": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541729069677554"]}, "1228": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954136191977414"]}, "1229": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514783217972459"]}, "1230": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951234041671614"]}, "1231": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533740670276194"]}, "1232": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540735910577219"]}, "1233": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473437870563819"]}, "1234": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946289330961559"]}, "1235": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481487322265199"]}, "1236": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453238936259664"]}, "1237": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543958800778314"]}, "1238": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481432875465184"]}, "1239": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465274188362399"]}, "1240": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470494726362819"]}, "1241": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451963923359229"]}, "1242": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514889821672499"]}, "1243": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523716298174144"]}, "1244": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503816039870084"]}, "1245": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484821270366339"]}, "1246": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523682698174129"]}, "1247": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473072017463694"]}, "1248": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495211401268514"]}, "1249": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533754938776199"]}, "1250": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454647799060144"]}, "1251": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512715640371754"]}, "1252": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495156952368499"]}, "1253": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532540954775789"]}, "1254": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483012681965719"]}, "1255": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484350824366179"]}, "1256": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520955376673199"]}, "1257": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094523419359344"]}, "1258": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460257109360689"]}, "1259": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524782330874504"]}, "1260": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513464375772009"]}, "1261": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463474400161789"]}, "1262": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472925993563644"]}, "1263": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514553358772384"]}, "1264": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465067603962329"]}, "1265": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471092422263019"]}, "1266": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475110541564389"]}, "1267": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503581924170004"]}, "1268": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494874784368399"]}, "1269": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455954355760589"]}, "1270": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462428030861429"]}, "1271": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545278305678764"]}, "1272": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492234674067499"]}, "1273": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471429098463134"]}, "1274": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515414504672674"]}, "1275": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524957802774564"]}, "1276": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535851810976914"]}, "1277": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541540411777494"]}, "1278": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491398546767214"]}, "1279": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485490098366564"]}, "1280": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455554565960454"]}, "1281": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515828348772819"]}, "1282": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465213231962379"]}, "1283": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515590005972734"]}, "1284": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520689729673109"]}, "1285": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490092011166769"]}, "1286": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485554936666589"]}, "1287": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490532910566919"]}, "1288": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480533496664874"]}, "1289": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523214283173974"]}, "1290": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475624792264564"]}, "1291": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451098885558934"]}, "1292": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491852457867369"]}, "1293": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500766238469044"]}, "1294": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533152973175994"]}, "1295": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492571675867614"]}, "1296": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471224190463064"]}, "1297": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470524144862829"]}, "1298": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452193746459304"]}, "1299": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462163666361339"]}, "1300": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500061822768804"]}, "1301": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494116016368144"]}, "1302": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452488758059404"]}, "1303": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535092931676659"]}, "1304": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949113488367114"]}, "1305": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495288800168544"]}, "1306": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454745902760174"]}, "1307": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530429606875069"]}, "1308": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462456837361439"]}, "1309": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464413019862109"]}, "1310": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452296073759339"]}, "1311": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494214160368174"]}, "1312": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540399501877104"]}, "1313": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949285312167694"]}, "1314": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472426267863474"]}, "1315": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452369100959364"]}, "1316": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502658509469689"]}, "1317": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484978098966389"]}, "1318": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455157540360314"]}, "1319": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462838703761569"]}, "1320": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524355723974359"]}, "1321": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494247799068189"]}, "1322": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460813454360879"]}, "1323": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947433633464114"]}, "1324": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482191798865439"]}, "1325": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453029819459589"]}, "1326": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482089333865404"]}, "1327": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095401326376999"]}, "1328": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947164768163194"]}, "1329": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514521533172374"]}, "1330": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545223891578749"]}, "1331": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491132883767124"]}, "1332": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534370142576409"]}, "1333": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531890796575564"]}, "1334": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095233543173999"]}, "1335": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474568956564204"]}, "1336": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501220424469199"]}, "1337": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947203776863334"]}, "1338": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484141734966104"]}, "1339": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521759956473474"]}, "1340": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455820475060544"]}, "1341": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540995154977304"]}, "1342": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461020387260949"]}, "1343": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524150949874289"]}, "1344": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471590359163189"]}, "1345": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471799354663264"]}, "1346": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461664312561169"]}, "1347": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451418686759039"]}, "1348": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512274685671604"]}, "1349": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461665929061174"]}, "1350": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512142953271559"]}, "1351": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454848292860209"]}, "1352": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495489210268609"]}, "1353": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523989928774234"]}, "1354": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541743452377559"]}, "1355": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481355657665154"]}, "1356": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493670787867989"]}, "1357": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502599907969669"]}, "1358": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464818076962244"]}, "1359": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953538553276729"]}, "1360": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535322898976734"]}, "1361": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460213497960674"]}, "1362": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451784230259164"]}, "1363": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470242057362729"]}, "1364": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472324232463439"]}, "1365": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503318426869914"]}, "1366": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483980683166049"]}, "1367": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945534351360364"]}, "1368": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480695017964929"]}, "1369": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948327555765789"]}, "1370": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494287166868199"]}, "1371": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462120088061324"]}, "1372": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455625671460474"]}, "1373": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520821472773154"]}, "1374": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501573451269319"]}, "1375": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482630587165589"]}, "1376": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462251849461369"]}, "1377": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463160782761679"]}, "1378": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542799165177919"]}, "1379": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543683426378224"]}, "1380": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504185855270214"]}, "1381": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531470554675424"]}, "1382": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532143325375654"]}, "1383": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472572341563524"]}, "1384": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461724995761189"]}, "1385": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484653710266279"]}, "1386": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514989807172534"]}, "1387": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484380271666189"]}, "1388": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504579308770344"]}, "1389": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461097542560979"]}, "1390": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485212429466469"]}, "1391": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451754922659154"]}, "1392": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535563238976819"]}, "1393": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484537184666239"]}, "1394": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501352363169244"]}, "1395": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492557002667609"]}, "1396": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511365796771294"]}, "1397": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493173427867819"]}, "1398": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475187641364419"]}, "1399": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481867487165329"]}, "1400": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504710966670389"]}, "1401": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473678392963904"]}, "1402": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534443159276434"]}, "1403": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495420446868589"]}, "1404": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450793401658829"]}, "1405": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945317205759619"]}, "1406": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947274225063569"]}, "1407": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470344283262764"]}, "1408": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481662993565259"]}, "1409": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470860689762944"]}, "1410": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534574772376479"]}, "1411": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463043374861639"]}, "1412": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950394061170114"]}, "1413": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531773882275524"]}, "1414": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512158041071564"]}, "1415": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453840991359869"]}, "1416": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947201921563329"]}, "1417": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464481734862129"]}, "1418": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501793102069394"]}, "1419": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534020386876294"]}, "1420": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523373550174024"]}, "1421": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472236036963409"]}, "1422": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953232798975704"]}, "1423": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493582778367959"]}, "1424": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540570532077159"]}, "1425": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485084689966429"]}, "1426": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524855514874529"]}, "1427": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521369105573344"]}, "1428": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094915822667249"]}, "1429": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532963407275929"]}, "1430": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531836446875549"]}, "1431": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542594547377849"]}, "1432": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493568462667954"]}, "1433": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522963980273884"]}, "1434": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512878735371814"]}, "1435": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503644944570029"]}, "1436": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525221427874654"]}, "1437": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512494664971679"]}, "1438": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455538380160444"]}, "1439": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501337412369239"]}, "1440": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543551623778179"]}, "1441": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502775131969729"]}, "1442": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450759975258814"]}, "1443": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543254443578074"]}, "1444": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502979998069799"]}, "1445": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535425210776769"]}, "1446": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515928343472854"]}, "1447": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474040434464024"]}, "1448": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454687117960154"]}, "1449": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464467368562124"]}, "1450": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475344579764469"]}, "1451": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493216858067834"]}, "1452": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451769165959159"]}, "1453": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520089529772904"]}, "1454": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541538972977491"]}, "1455": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545294468678774"]}, "1456": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503947827070129"]}, "1457": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465815499462584"]}, "1458": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543885818178289"]}, "1459": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460947275860924"]}, "1460": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953159941675434"]}, "1461": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464983500062304"]}, "1462": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492834619567704"]}, "1463": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949249996067559"]}, "1464": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530571323475114"]}, "1465": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510062902370854"]}, "1466": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473628506363884"]}, "1467": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471199120763059"]}, "1468": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951529919072604"]}, "1469": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535690675276859"]}, "1470": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505649692570709"]}, "1471": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532039066975614"]}, "1472": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947265996363539"]}, "1473": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472998924063669"]}, "1474": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513917622172164"]}, "1475": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532477839075764"]}, "1476": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483730613465964"]}, "1477": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454413674660064"]}, "1478": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484185442966119"]}, "1479": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511689725771404"]}, "1480": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523448429574054"]}, "1481": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530164080774979"]}, "1482": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952342922774034"]}, "1483": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952258477973729"]}, "1484": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503918428970119"]}, "1485": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490023325866749"]}, "1486": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946361994161829"]}, "1487": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542872192077944"]}, "1488": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513771595972114"]}, "1489": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490826031767019"]}, "1490": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503042959969824"]}, "1491": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480416778464834"]}, "1492": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505726825570739"]}, "1493": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464774436362229"]}, "1494": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540454022477119"]}, "1495": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514841934472479"]}, "1496": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533784312576209"]}, "1497": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470519847562824"]}, "1498": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094921959167454"]}, "1499": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533813777776219"]}, "1500": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511940052871494"]}, "1501": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473247489263754"]}, "1502": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505958765470814"]}, "1503": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532492953175769"]}, "1504": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510412654470969"]}, "1505": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475373925564479"]}, "1506": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490796484467009"]}, "1507": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475124769464394"]}, "1508": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460286527160699"]}, "1509": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465322015762419"]}, "1510": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512392157671644"]}, "1511": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532024585975609"]}, "1512": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513888374672154"]}, "1513": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454336336160034"]}, "1514": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471928899363304"]}, "1515": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450864633058854"]}, "1516": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452620363959449"]}, "1517": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531729729075509"]}, "1518": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525250828174664"]}, "1519": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502041325269479"]}, "1520": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483412322865859"]}, "1521": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531054601775279"]}, "1522": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475183471464414"]}, "1523": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483569274965909"]}, "1524": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491736849167334"]}, "1525": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946191942161254"]}, "1526": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472764893163589"]}, "1527": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524577635374434"]}, "1528": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452941754259559"]}, "1529": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490282521766834"]}, "1530": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522376222073684"]}, "1531": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493114739167799"]}, "1532": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540556238377154"]}, "1533": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473339871063789"]}, "1534": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484214772366129"]}, "1535": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472031343763339"]}, "1536": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495961366768774"]}, "1537": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454818841860199"]}, "1538": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454570443560114"]}, "1539": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946386655661899"]}, "1540": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501632304669339"]}, "1541": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503567545969999"]}, "1542": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474274259364104"]}, "1543": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484053753366074"]}, "1544": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495693939468679"]}, "1545": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493261244267849"]}, "1546": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504725211570394"]}, "1547": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503011137769814"]}, "1548": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501396161869259"]}, "1549": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490180128066799"]}, "1550": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475975734264684"]}, "1551": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481064985565059"]}, "1552": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485446276466549"]}, "1553": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464646962262189"]}, "1554": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495020974568449"]}, "1555": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451286655558994"]}, "1556": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505210687470559"]}, "1557": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494350187868224"]}, "1558": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491266569667174"]}, "1559": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513640011672069"]}, "1560": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542174375577709"]}, "1561": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501034047369139"]}, "1562": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531188517175324"]}, "1563": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472674812663559"]}, "1564": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473174396663729"]}, "1565": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461634553861159"]}, "1566": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950249542169604"]}, "1567": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480391768464829"]}, "1568": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095015416469294"]}, "1569": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532727204375849"]}, "1570": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505992295370829"]}, "1571": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453573197759774"]}, "1572": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484248457866144"]}, "1573": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504213342370219"]}, "1574": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500095510768819"]}, "1575": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505854313670779"]}, "1576": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946338896461734"]}, "1577": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511570252071364"]}, "1578": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954366242378194"]}, "1579": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954378700478229"]}, "1580": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520514362473049"]}, "1581": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492439400867569"]}, "1582": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522332624673669"]}, "1583": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504817604270429"]}, "1584": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471987647363324"]}, "1585": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533577743576139"]}, "1586": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952466979374444"]}, "1587": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504872072470444"]}, "1588": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513242643971934"]}, "1589": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470153979962699"]}, "1590": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482925379765689"]}, "1591": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947253624663504"]}, "1592": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533081853075974"]}, "1593": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503670061770034"]}, "1594": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531334493075374"]}, "1595": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541890229377609"]}, "1596": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455993874060599"]}, "1597": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491954804767404"]}, "1598": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534958792076614"]}, "1599": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521032638773229"]}, "1600": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513746546672109"]}, "1601": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451495840059069"]}, "1602": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535822557976904"]}, "1603": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545029088478679"]}, "1604": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465154662462359"]}, "1605": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510226562470909"]}, "1606": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542433621077794"]}, "1607": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483613049965924"]}, "1608": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530234859274999"]}, "1609": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492761553967679"]}, "1610": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500457079368939"]}, "1611": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523565935174089"]}, "1612": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493934264768079"]}, "1613": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523916805574209"]}, "1614": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472469925763489"]}, "1615": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952527185774649"]}, "1616": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472074999363354"]}, "1617": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495343050468559"]}, "1618": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494452474768259"]}, "1619": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453324671759689"]}, "1620": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471488209263154"]}, "1621": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494922813068419"]}, "1622": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512260293071599"]}, "1623": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949382552968034"]}, "1624": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535866043976919"]}, "1625": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482264797765464"]}, "1626": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502614277269674"]}, "1627": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483276647365809"]}, "1628": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502995106169804"]}, "1629": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523314793274004"]}, "1630": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543313180478094"]}, "1631": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465390904962439"]}, "1632": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512979213971844"]}, "1633": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502892691869769"]}, "1634": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453661369259804"]}, "1635": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521437831273364"]}, "1636": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455816120560539"]}, "1637": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515180529872594"]}, "1638": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490562244466929"]}, "1639": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532243948675684"]}, "1640": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464245471562049"]}, "1641": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544690648278564"]}, "1642": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452973017359574"]}, "1643": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545190181578734"]}, "1644": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495930127068759"]}, "1645": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535356498676749"]}, "1646": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952299552773869"]}, "1647": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533051020575959"]}, "1648": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473160162363724"]}, "1649": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948277782865619"]}, "1650": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495314110368549"]}, "1651": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524316376674349"]}, "1652": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490869711267034"]}, "1653": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493613991467974"]}, "1654": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474949369264334"]}, "1655": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514319234772304"]}, "1656": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493377971867889"]}, "1657": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513378621971984"]}, "1658": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521160079273269"]}, "1659": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485580062666594"]}, "1660": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511938285571489"]}, "1661": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451871506959194"]}, "1662": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505756159570749"]}, "1663": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481282670965129"]}, "1664": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525691560074814"]}, "1665": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521734921573469"]}, "1666": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491264728867169"]}, "1667": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522640013273774"]}, "1668": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465947096862629"]}, "1669": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523095606673929"]}, "1670": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491573854067274"]}, "1671": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513344979471969"]}, "1672": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460025022360614"]}, "1673": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481399194265169"]}, "1674": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502338600369584"]}, "1675": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473276791263764"]}, "1676": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452738899859494"]}, "1677": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541333649077419"]}, "1678": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483882647766019"]}, "1679": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490399225966874"]}, "1680": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522861538173849"]}, "1681": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463543206761809"]}, "1682": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521218709973289"]}, "1683": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512544476571699"]}, "1684": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534796106676554"]}, "1685": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952539696374684"]}, "1686": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452898143659544"]}, "1687": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515692897172771"]}, "1688": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480224372464769"]}, "1689": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482162395265429"]}, "1690": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502365709969589"]}, "1691": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953147556575399"]}, "1692": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483071428765739"]}, "1693": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948494907966364"]}, "1694": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530352353475039"]}, "1695": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471462829463149"]}, "1696": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453734376359829"]}, "1697": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503538268069989"]}, "1698": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541772840277569"]}, "1699": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504349336870269"]}, "1700": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451082005958924"]}, "1701": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525959437774909"]}, "1702": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471048887263004"]}, "1703": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454233954259999"]}, "1704": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535778707376889"]}, "1705": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945379254159824"]}, "1706": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945387314859854"]}, "1707": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482943954865699"]}, "1708": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522069453873579"]}, "1709": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501588551969324"]}, "1710": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491432093567229"]}, "1711": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945337904659684"]}, "1712": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514958509872519"]}, "1713": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947373363263909"]}, "1714": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540060935476989"]}, "1715": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524282805074334"]}, "1716": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460652465360824"]}, "1717": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464383491062099"]}, "1718": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949457012468274"]}, "1719": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541377381577434"]}, "1720": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545629105178884"]}, "1721": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540295134177069"]}, "1722": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472842160263619"]}, "1723": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954182140277579"]}, "1724": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525020937174589"]}, "1725": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474113462064049"]}, "1726": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534781687576549"]}, "1727": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949187886367354"]}, "1728": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474744525164264"]}, "1729": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949566567768649"]}, "1730": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453763660959839"]}, "1731": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483848965066004"]}, "1732": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094530446459579"]}, "1733": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451857204459189"]}, "1734": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535997928276964"]}, "1735": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530469004175079"]}, "1736": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948253079865549"]}, "1737": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470358645362769"]}, "1738": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095138946772124"]}, "1739": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948432853466159"]}, "1740": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535793090776894"]}, "1741": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475315390164459"]}, "1742": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462397881661419"]}, "1743": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473981309364004"]}, "1744": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512910472671824"]}, "1745": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510354174770949"]}, "1746": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524253464974324"]}, "1747": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504783980870414"]}, "1748": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521657537973439"]}, "1749": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530220551974994"]}, "1750": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542478989577814"]}, "1751": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543533304778169"]}, "1752": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460995217460944"]}, "1753": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473511037963844"]}, "1754": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494170507368159"]}, "1755": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512833017671794"]}, "1756": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473952045263994"]}, "1757": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512172223171569"]}, "1758": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094519921459204"]}, "1759": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452839473159524"]}, "1760": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951225928071584"]}, "1761": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454672972960149"]}, "1762": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094518359559174"]}, "1763": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460095954960634"]}, "1764": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492878340467719"]}, "1765": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464347956162084"]}, "1766": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483481443265879"]}, "1767": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484875916966354"]}, "1768": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485314749966504"]}, "1769": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451729776459149"]}, "1770": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512569653771704"]}, "1771": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493597748867964"]}, "1772": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494316630568209"]}, "1773": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535529680876804"]}, "1774": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945509590560264"]}, "1775": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464569574062159"]}, "1776": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543577034878184"]}, "1777": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473599116663874"]}, "1778": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474483203764179"]}, "1779": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524445837274389"]}, "1780": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480548487364879"]}, "1781": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524987337574574"]}, "1782": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470260580962739"]}, "1783": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473717723363914"]}, "1784": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522832262873839"]}, "1785": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484375927066184"]}, "1786": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514358562372314"]}, "1787": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544387692078464"]}, "1788": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475287793064454"]}, "1789": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523168687473954"]}, "1790": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471458526863144"]}, "1791": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462911563261594"]}, "1792": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502541393169649"]}, "1793": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493145908467814"]}, "1794": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492893385267724"]}, "1795": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473013314563674"]}, "1796": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450993998858894"]}, "1797": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504079544670174"]}, "1798": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470797570562919"]}, "1799": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510120082670869"]}, "1800": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511116935071209"]}, "1801": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532933997575919"]}, "1802": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482176642865434"]}, "1803": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541626647077519"]}, "1804": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541656000277529"]}, "1805": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545497407078839"]}, "1806": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460393137860739"]}, "1807": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540951495677289"]}, "1808": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952355233774069"]}, "1809": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473613443463879"]}, "1810": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504535435570329"]}, "1811": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493875619468059"]}, "1812": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485241571566479"]}, "1813": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484068832966079"]}, "1814": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530849864875209"]}, "1815": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542711476377889"]}, "1816": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502334392269579"]}, "1817": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950468628870354"]}, "1818": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502965668769794"]}, "1819": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492134523567469"]}, "1820": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483043946965734"]}, "1821": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951345722571989"]}, "1822": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524019357174244"]}, "1823": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513276218571949"]}, "1824": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472265421263419"]}, "1825": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504856968170439"]}, "1826": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474099101964044"]}, "1827": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953182732275534"]}, "1828": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490384901666869"]}, "1829": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460863425260899"]}, "1830": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472973939563664"]}, "1831": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504491121470314"]}, "1832": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485080339066424"]}, "1833": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502574823469664"]}, "1834": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470724550362894"]}, "1835": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501822553669404"]}, "1836": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951198867771479"]}, "1837": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482835291065659"]}, "1838": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953197089175574"]}, "1839": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521996113173554"]}, "1840": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455582013260459"]}, "1841": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505284016770584"]}, "1842": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493848088368054"]}, "1843": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470461131662804"]}, "1844": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512440112071664"]}, "1845": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482059925365394"]}, "1846": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480860178364989"]}, "1847": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480253722164779"]}, "1848": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495182072768504"]}, "1849": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523480211374064"]}, "1850": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501675625869354"]}, "1851": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523584591274099"]}, "1852": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511135609971219"]}, "1853": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452135020659284"]}, "1854": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462266287761374"]}, "1855": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494584297568304"]}, "1856": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463679154561859"]}, "1857": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542140549377694"]}, "1858": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481853111065324"]}, "1859": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946374408061864"]}, "1860": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503977129570139"]}, "1861": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505386169470619"]}, "1862": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472867225363624"]}, "1863": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532259031175689"]}, "1864": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460330138860714"]}, "1865": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495654680168669"]}, "1866": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503933415170124"]}, "1867": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510694796871069"]}, "1868": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544340001278444"]}, "1869": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951589792472809"]}, "1870": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454965712660249"]}, "1871": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521174278973274"]}, "1872": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545410132378809"]}, "1873": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451169497958954"]}, "1874": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473762092663929"]}, "1875": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542095032577679"]}, "1876": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460579326960799"]}, "1877": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461783655061209"]}, "1878": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544281469778424"]}, "1879": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481516704665209"]}, "1880": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474278583964109"]}, "1881": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523548810774084"]}, "1882": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492341291567539"]}, "1883": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945424797159989"]}, "1884": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475595469964554"]}, "1885": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541199878277374"]}, "1886": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500781277869049"]}, "1887": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524841179074524"]}, "1888": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542378977077779"]}, "1889": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531232196375339"]}, "1890": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505181276270549"]}, "1891": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502776984569734"]}, "1892": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535045151676639"]}, "1893": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454281930260019"]}, "1894": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540439331177114"]}, "1895": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535074309376649"]}, "1896": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515017355772539"]}, "1897": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475051557064369"]}, "1898": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543815113378269"]}, "1899": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454114870659959"]}, "1900": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465288477262404"]}, "1901": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540163375677024"]}, "1902": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484773501966319"]}, "1903": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474249233764099"]}, "1904": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490830185967024"]}, "1905": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523011959073904"]}, "1906": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483349801165834"]}, "1907": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484787781466324"]}, "1908": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490723408966984"]}, "1909": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531744131675514"]}, "1910": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947385831163944"]}, "1911": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460159017660659"]}, "1912": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462193066161349"]}, "1913": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524239079374319"]}, "1914": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531672923375494"]}, "1915": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451491524759064"]}, "1916": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500413495068924"]}, "1917": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522777866373824"]}, "1918": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500252289968869"]}, "1919": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544325179778439"]}, "1920": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482528104265554"]}, "1921": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484743847266309"]}, "1922": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491666247567309"]}, "1923": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491147976667129"]}, "1924": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454584804160119"]}, "1925": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475992020364694"]}, "1926": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530922880375234"]}, "1927": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491764296867339"]}, "1928": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475785388164619"]}, "1929": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494141117168149"]}, "1930": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521864356273509"]}, "1931": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490591651566939"]}, "1932": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532918876875914"]}, "1933": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514083058572224"]}, "1934": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460827699960884"]}, "1935": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533621397876154"]}, "1936": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464318413562074"]}, "1937": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521686932673449"]}, "1938": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534325710176394"]}, "1939": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493177464467824"]}, "1940": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481133639265079"]}, "1941": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483173954865774"]}, "1942": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511467841071329"]}, "1943": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461797985361214"]}, "1944": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511526583771349"]}, "1945": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514812550472469"]}, "1946": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948483012966329"]}, "1947": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485358211066519"]}, "1948": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533650476076164"]}, "1949": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946508609162309"]}, "1950": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521839278773504"]}, "1951": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504769636670409"]}, "1952": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951174042871409"]}, "1953": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949394847368069"]}, "1954": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454921257860234"]}, "1955": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471267882563079"]}, "1956": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523887380774199"]}, "1957": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501763736569384"]}, "1958": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511635310171389"]}, "1959": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949334934567864"]}, "1960": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481094370665069"]}, "1961": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450891460358859"]}, "1962": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515725975872784"]}, "1963": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512377023371639"]}, "1964": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495445496568594"]}, "1965": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485285408066494"]}, "1966": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521134922973264"]}, "1967": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545219740978744"]}, "1968": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512994362671849"]}, "1969": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543346785278109"]}, "1970": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474846733364299"]}, "1971": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484482556466224"]}, "1972": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501234704969204"]}, "1973": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544853664278619"]}, "1974": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948029951764764"]}, "1975": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525795771174854"]}, "1976": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454833911260204"]}, "1977": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501268246069219"]}, "1978": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464084317461994"]}, "1979": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520984780973209"]}, "1980": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483834727865999"]}, "1981": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505885695570789"]}, "1982": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523446604674049"]}, "1983": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500971011069114"]}, "1984": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462339160761399"]}, "1985": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500927323169099"]}, "1986": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531965879375589"]}, "1987": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542744758177904"]}, "1988": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453443357359734"]}, "1989": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501059093669144"]}, "1990": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521628143573429"]}, "1991": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492086718467449"]}, "1992": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474478821164174"]}, "1993": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500359014968909"]}, "1994": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534957036976609"]}, "1995": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540970045577299"]}, "1996": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495842756168729"]}, "1997": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455435911060409"]}, "1998": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510794838071099"]}, "1999": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512876871671809"]}, "2000": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524591810274439"]}, "2001": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545131521478714"]}, "2002": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522596337673759"]}, "2003": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453529555159759"]}, "2004": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514919259072509"]}, "2005": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463748246861879"]}, "2006": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494418822568244"]}, "2007": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460359536460724"]}, "2008": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465990765762644"]}, "2009": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544122023378374"]}, "2010": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462736411961534"]}, "2011": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534486827676449"]}, "2012": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450832923458839"]}, "2013": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530130469874964"]}, "2014": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485887280066699"]}, "2015": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523639091474114"]}, "2016": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501161599969179"]}, "2017": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495727232368694"]}, "2018": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533445838176094"]}, "2019": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495357394368564"]}, "2020": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543766979378249"]}, "2021": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483510529065889"]}, "2022": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510456344970984"]}, "2023": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481564662065229"]}, "2024": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541053797577324"]}, "2025": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465169664962364"]}, "2026": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540012778076969"]}, "2027": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475683115764584"]}, "2028": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512730660171759"]}, "2029": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465115278962349"]}, "2030": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544021790478339"]}, "2031": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950199570269434"]}, "2032": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463190227561689"]}, "2033": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542842863677934"]}, "2034": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504374379870274"]}, "2035": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500825053469064"]}, "2036": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480930902365014"]}, "2037": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473569880463864"]}, "2038": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952404956274239"]}, "2039": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495518473968619"]}, "2040": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461870722661239"]}, "2041": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510999635171169"]}, "2042": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462090781861314"]}, "2043": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525545380774764"]}, "2044": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490359819266864"]}, "2045": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505624545670704"]}, "2046": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474685663864244"]}, "2047": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543488846578154"]}, "2048": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481926244465349"]}, "2049": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501165846469184"]}, "2050": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454511836960094"]}, "2051": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491032390167094"]}, "2052": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461268706061034"]}, "2053": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521087244873244"]}, "2054": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494477554068264"]}, "2055": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484039451366069"]}, "2056": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511660401471394"]}, "2057": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541170519777364"]}, "2058": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544647158778549"]}, "2059": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534254546876374"]}, "2060": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465453817162464"]}, "2061": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503831127270089"]}, "2062": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473780758763939"]}, "2063": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505195552070554"]}, "2064": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531236434375344"]}, "2065": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540585612577164"]}, "2066": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503347885069924"]}, "2067": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484551347166244"]}, "2068": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948457626366229"]}, "2069": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534883945276584"]}, "2070": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504886391670449"]}, "2071": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522541791973744"]}, "2072": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500697535069024"]}, "2073": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951221629771579"]}, "2074": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473379276063799"]}, "2075": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482269003965469"]}, "2076": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511131341871214"]}, "2077": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953073125375159"]}, "2078": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947495538264319"]}, "2079": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482674255165604"]}, "2080": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481165111565089"]}, "2081": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535293453376724"]}, "2082": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948261113265579"]}, "2083": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495857154368734"]}, "2084": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495959495468769"]}, "2085": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472440687163479"]}, "2086": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531466232775419"]}, "2087": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540936506577284"]}, "2088": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515341572572649"]}, "2089": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474876214264309"]}, "2090": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500931673169104"]}, "2091": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504418161970289"]}, "2092": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514651386472414"]}, "2093": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544237714878409"]}, "2094": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954341546078124"]}, "2095": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485421154466544"]}, "2096": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465537545562489"]}, "2097": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465874259362604"]}, "2098": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450818648358834"]}, "2099": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525255144874669"]}, "2100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951163889671379"]}, "2101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524943421874559"]}, "2102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949289545667699"]}, "2103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451832117559184"]}, "2104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524475263174399"]}, "2105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454877536560219"]}, "2106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947323795863739"]}, "2107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510222624370904"]}, "2108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462168052961344"]}, "2109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531129665875304"]}, "2110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535395858176759"]}, "2111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465493170462474"]}, "2112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947545440764489"]}, "2113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950226845369539"]}, "2114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532375494575729"]}, "2115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454615990560134"]}, "2116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501559133069314"]}, "2117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481060838165054"]}, "2118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471697039563229"]}, "2119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504140179270194"]}, "2120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544310811978434"]}, "2121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463763187861884"]}, "2122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451886553359199"]}, "2123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463424655161769"]}, "2124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454731544160169"]}, "2125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948102125665034"]}, "2126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454012663259924"]}, "2127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491486625567244"]}, "2128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505356713170609"]}, "2129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535647107276844"]}, "2130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491457147267234"]}, "2131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541469693277469"]}, "2132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514078719672219"]}, "2133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460798459960874"]}, "2134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465422012262454"]}, "2135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947241272563469"]}, "2136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463835987461909"]}, "2137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482998270565714"]}, "2138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490679737966969"]}, "2139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500986029769119"]}, "2140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500620274768994"]}, "2141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511058263171189"]}, "2142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493846242868049"]}, "2143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543737733278239"]}, "2144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505591005670689"]}, "2145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474380936464144"]}, "2146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545058453878689"]}, "2147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462974637161619"]}, "2148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463074609561654"]}, "2149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541069999177334"]}, "2150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541963454177634"]}, "2151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501939048569444"]}, "2152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455845563760549"]}, "2153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947275988763574"]}, "2154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513228450871929"]}, "2155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505124389470534"]}, "2156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515780517972799"]}, "2157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494991597868439"]}, "2158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513669438572079"]}, "2159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495386857768574"]}, "2160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494784751168369"]}, "2161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470754029362904"]}, "2162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945546512460399"]}, "2163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493279873167859"]}, "2164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951062354471034"]}, "2165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482074353065399"]}, "2166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492322641067529"]}, "2167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511733406571419"]}, "2168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543020709877994"]}, "2169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474671376764239"]}, "2170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500384117368914"]}, "2171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541977836277639"]}, "2172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465790382062579"]}, "2173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524121681974279"]}, "2174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500545194568969"]}, "2175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480126201564739"]}, "2176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510734032471079"]}, "2177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544574215978524"]}, "2178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465687915262544"]}, "2179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511321783071279"]}, "2180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462036101961299"]}, "2181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947315711863709"]}, "2182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951455326772364"]}, "2183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953307290675944"]}, "2184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521452827773369"]}, "2185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495240718568524"]}, "2186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523950477174224"]}, "2187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544780804578594"]}, "2188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511835718071454"]}, "2189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475153977464404"]}, "2190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454775352960184"]}, "2191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463894798761929"]}, "2192": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948215534265414"]}, "2193": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525280233774674"]}, "2194": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453677456059814"]}, "2195": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490165071766794"]}, "2196": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511424301571314"]}, "2197": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495054583268464"]}, "2198": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534990587276624"]}, "2199": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524078039074264"]}, "2200": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465317744462414"]}, "2201": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475419736064494"]}, "2202": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531980278075594"]}, "2203": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520164486772934"]}, "2204": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545087862878699"]}, "2205": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460081942460629"]}, "2206": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512598857771714"]}, "2207": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950578232870729"]}, "2208": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544193490978394"]}, "2209": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525866935474874"]}, "2210": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470666329562874"]}, "2211": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454218922859994"]}, "2212": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521072433273239"]}, "2213": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520851071773164"]}, "2214": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480987644965029"]}, "2215": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530897857575229"]}, "2216": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500736897369034"]}, "2217": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515444163672684"]}, "2218": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490694033866974"]}, "2219": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471399772063124"]}, "2220": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451257405858984"]}, "2221": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463879674961924"]}, "2222": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525461677174739"]}, "2223": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504065181970169"]}, "2224": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460727275860854"]}, "2225": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950505771070489"]}, "2226": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483466981365874"]}, "2227": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954022808277034"]}, "2228": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454071184159944"]}, "2229": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541235596177389"]}, "2230": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515149158372584"]}, "2231": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523114299373939"]}, "2232": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511028959371179"]}, "2233": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544588714078531"]}, "2234": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502672731369694"]}, "2235": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520250759072959"]}, "2236": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522171536473614"]}, "2237": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510588046571029"]}, "2238": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095227796773794"]}, "2239": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464979259462299"]}, "2240": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480577991264889"]}, "2241": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464333502462079"]}, "2242": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511395019071304"]}, "2243": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460932295560919"]}, "2244": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454497449760089"]}, "2245": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491969135967409"]}, "2246": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452795764859509"]}, "2247": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510328987070944"]}, "2248": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461166278460999"]}, "2249": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953294571875909"]}, "2250": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530189181074984"]}, "2251": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470417386462789"]}, "2252": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452032746659249"]}, "2253": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532981823475939"]}, "2254": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545526771378849"]}, "2255": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481560344665224"]}, "2256": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543919436278304"]}, "2257": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515985234972869"]}, "2258": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462769928361549"]}, "2259": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464642690862184"]}, "2260": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950154456969299"]}, "2261": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094747755164249"]}, "2262": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543386334578119"]}, "2263": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531572872175459"]}, "2264": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515491867772704"]}, "2265": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493777488968029"]}, "2266": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513096759371884"]}, "2267": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541670237277534"]}, "2268": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510749085971084"]}, "2269": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462638177861504"]}, "2270": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515516923272709"]}, "2271": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481369968865159"]}, "2272": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541611583877514"]}, "2273": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485945918966719"]}, "2274": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530864169475214"]}, "2275": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503111681469844"]}, "2276": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510383291070959"]}, "2277": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501866098269419"]}, "2278": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531597949075464"]}, "2279": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543112684578029"]}, "2280": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463850410461914"]}, "2281": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522230130273634"]}, "2282": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473335436263784"]}, "2283": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947446099864149"]}, "2284": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495328495368554"]}, "2285": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525428135774724"]}, "2286": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533916139176254"]}, "2287": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451125537958939"]}, "2288": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544256059678419"]}, "2289": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945304796459584"]}, "2290": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470392337162784"]}, "2291": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951405786272194"]}, "2292": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534825489376564"]}, "2293": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471663370863214"]}, "2294": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950175278269364"]}, "2295": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500120605768824"]}, "2296": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513478752572014"]}, "2297": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535220398576699"]}, "2298": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512949853771834"]}, "2299": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542579404977844"]}, "2300": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525075478374604"]}, "2301": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512231005371589"]}, "2302": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471751396563244"]}, "2303": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514592663672394"]}, "2304": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503436081369954"]}, "2305": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451959603459224"]}, "2306": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453343352659699"]}, "2307": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520836250473159"]}, "2308": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522175730373619"]}, "2309": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492575553667619"]}, "2310": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485050889966414"]}, "2311": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520397042473009"]}, "2312": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095328396575874"]}, "2313": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450764135958819"]}, "2314": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491768630667344"]}, "2315": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544354117778449"]}, "2316": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453132398759624"]}, "2317": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522025803673564"]}, "2318": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514739423172444"]}, "2319": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474376693464139"]}, "2320": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493025369767769"]}, "2321": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475492671164519"]}, "2322": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454779559660189"]}, "2323": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534018691676289"]}, "2324": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515531203772714"]}, "2325": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542242914577729"]}, "2326": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474435388064159"]}, "2327": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492673977767649"]}, "2328": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480592340464894"]}, "2329": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490898981167044"]}, "2330": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521922952773529"]}, "2331": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471253530463074"]}, "2332": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515546192672719"]}, "2333": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951151539671344"]}, "2334": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501720063069369"]}, "2335": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483774127965979"]}, "2336": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455172706160319"]}, "2337": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951331379271954"]}, "2338": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461197498261014"]}, "2339": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475522172664529"]}, "2340": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095317424175499"]}, "2341": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504637948970364"]}, "2342": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953269557375809"]}, "2343": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485741258566649"]}, "2344": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483544234565904"]}, "2345": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491064174267104"]}, "2346": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531641703175479"]}, "2347": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465962054762634"]}, "2348": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505929294970804"]}, "2349": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472371911863459"]}, "2350": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460227801960679"]}, "2351": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514871340772489"]}, "2352": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480962589465024"]}, "2353": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534311659176389"]}, "2354": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462017639861289"]}, "2355": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452339736259354"]}, "2356": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483441693965869"]}, "2357": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954291613777954"]}, "2358": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481721366665279"]}, "2359": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531525106775439"]}, "2360": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464745013162219"]}, "2361": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544046872978344"]}, "2362": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525192106074644"]}, "2363": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543298918778089"]}, "2364": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535881234176924"]}, "2365": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455772470360524"]}, "2366": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483598681765919"]}, "2367": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504447420270299"]}, "2368": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524312188474344"]}, "2369": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450998257958899"]}, "2370": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454936261260239"]}, "2371": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504813366270424"]}, "2372": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948203425465379"]}, "2373": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461933713661264"]}, "2374": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455479703860424"]}, "2375": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494859827268394"]}, "2376": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464951735462294"]}, "2377": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453998158259919"]}, "2378": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530634390075139"]}, "2379": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461532217361124"]}, "2380": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532847658675894"]}, "2381": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514122553172234"]}, "2382": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513951309472179"]}, "2383": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490493580466909"]}, "2384": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494053031468119"]}, "2385": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500227275668864"]}, "2386": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953379174076184"]}, "2387": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473394247463804"]}, "2388": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954219628877684"]}, "2389": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455450379160414"]}, "2390": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544427069678474"]}, "2391": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474514606664189"]}, "2392": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473544681363859"]}, "2393": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454381903460054"]}, "2394": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513537617972034"]}, "2395": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534150248276334"]}, "2396": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485623787466609"]}, "2397": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533636206376159"]}, "2398": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530086707674949"]}, "2399": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540085942076994"]}, "2400": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531173359875319"]}, "2401": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484216715266134"]}, "2402": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532643253575824"]}, "2403": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521598899673419"]}, "2404": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514519579472369"]}, "2405": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515897117472839"]}, "2406": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462941123761604"]}, "2407": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480431196664839"]}, "2408": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454516013860099"]}, "2409": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484718813666304"]}, "2410": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543620730178199"]}, "2411": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511453686171324"]}, "2412": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514753766972449"]}, "2413": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525046126674594"]}, "2414": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503715562970054"]}, "2415": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460844823660889"]}, "2416": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462471371261444"]}, "2417": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545453689078824"]}, "2418": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513449475072004"]}, "2419": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475388225464484"]}, "2420": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520969813773204"]}, "2421": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515751205672789"]}, "2422": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952245609273694"]}, "2423": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453278335759674"]}, "2424": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461768758761204"]}, "2425": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510867950271124"]}, "2426": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945362647259784"]}, "2427": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474172187864069"]}, "2428": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505517991570664"]}, "2429": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492498055067589"]}, "2430": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491196002567149"]}, "2431": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453811595259859"]}, "2432": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454129791159964"]}, "2433": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948238384365479"]}, "2434": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480651193364914"]}, "2435": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540320214377074"]}, "2436": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465844810562594"]}, "2437": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513169960271909"]}, "2438": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461415414561084"]}, "2439": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512289734371609"]}, "2440": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505693157470724"]}, "2441": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533533831376124"]}, "2442": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520045817572889"]}, "2443": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524184577174304"]}, "2444": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510431208670979"]}, "2445": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515912228972844"]}, "2446": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462722033261529"]}, "2447": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949273218167659"]}, "2448": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534282278676379"]}, "2449": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454144180259969"]}, "2450": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952113162073254"]}, "2451": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502543146769654"]}, "2452": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460154747060654"]}, "2453": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491939741167399"]}, "2454": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542330937077759"]}, "2455": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474044369264029"]}, "2456": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501836936869409"]}, "2457": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501293372269224"]}, "2458": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502056461469484"]}, "2459": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542642359277869"]}, "2460": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483159700865769"]}, "2461": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947557762064524"]}, "2462": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952307741073899"]}, "2463": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535661341276849"]}, "2464": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525925729674894"]}, "2465": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514388237872324"]}, "2466": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491294057367179"]}, "2467": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502526922169644"]}, "2468": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530337220275034"]}, "2469": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494272882768194"]}, "2470": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465757179162564"]}, "2471": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951283702971784"]}, "2472": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494184829768164"]}, "2473": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480753732964949"]}, "2474": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945242846159379"]}, "2475": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512964938871839"]}, "2476": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511469715871334"]}, "2477": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542828519077929"]}, "2478": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462370363561414"]}, "2479": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464515200862144"]}, "2480": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531495612875429"]}, "2481": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533581879076144"]}, "2482": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484287800566154"]}, "2483": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532697678775839"]}, "2484": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461229309761024"]}, "2485": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480830824964979"]}, "2486": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480621871964904"]}, "2487": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531068952875284"]}, "2488": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542947097277974"]}, "2489": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541845728977594"]}, "2490": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520719082373119"]}, "2491": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946254495361459"]}, "2492": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502158881669519"]}, "2493": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510149418270879"]}, "2494": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542065716277669"]}, "2495": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481472219565194"]}, "2496": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470285683462744"]}, "2497": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532639003175819"]}, "2498": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514914986172504"]}, "2499": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484448961566209"]}, "2500": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534472468076444"]}, "2501": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493514000267939"]}, "2502": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460524857160784"]}, "2503": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530952440275244"]}, "2504": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471180459263049"]}, "2505": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514680887972424"]}, "2506": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485139115366444"]}, "2507": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512760043171769"]}, "2508": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505781228670754"]}, "2509": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472689839663564"]}, "2510": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952185638573489"]}, "2511": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485759801766659"]}, "2512": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505288049370589"]}, "2513": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541436065877454"]}, "2514": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481198739265104"]}, "2515": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945594256460569"]}, "2516": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455275076960354"]}, "2517": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534620708676494"]}, "2518": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492395613667554"]}, "2519": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948397788866024"]}, "2520": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513848884272144"]}, "2521": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530966667575249"]}, "2522": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544941821378649"]}, "2523": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460963400060934"]}, "2524": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950309275069809"]}, "2525": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545326244478784"]}, "2526": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480446147264844"]}, "2527": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480314393664799"]}, "2528": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532775021475869"]}, "2529": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483627958965929"]}, "2530": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525294587574679"]}, "2531": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523080674673924"]}, "2532": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505254448870574"]}, "2533": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454643592160139"]}, "2534": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514254139672279"]}, "2535": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510197183970899"]}, "2536": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492159578267474"]}, "2537": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500515853468959"]}, "2538": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515194860472599"]}, "2539": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544826226578614"]}, "2540": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543973917278319"]}, "2541": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501924643569439"]}, "2542": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948176238765274"]}, "2543": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523183064473959"]}, "2544": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946349404561764"]}, "2545": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505561561370679"]}, "2546": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513583116172054"]}, "2547": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465917767762619"]}, "2548": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482239635865459"]}, "2549": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501895404169429"]}, "2550": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954051786277139"]}, "2551": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524753036274494"]}, "2552": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543283761478084"]}, "2553": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460754687060859"]}, "2554": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480122017864734"]}, "2555": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511351543471289"]}, "2556": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535015658376629"]}, "2557": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531671024875489"]}, "2558": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950418959470184"]}, "2559": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953249132375744"]}, "2560": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954159528977479"]}, "2561": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491661980767304"]}, "2562": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511737709971424"]}, "2563": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484346606566174"]}, "2564": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473057743863689"]}, "2565": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533518752376119"]}, "2566": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952259965873734"]}, "2567": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513315561071959"]}, "2568": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542199338577714"]}, "2569": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463645539661844"]}, "2570": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541024449077314"]}, "2571": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464881133762269"]}, "2572": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545599718778874"]}, "2573": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454482391960084"]}, "2574": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511792114671439"]}, "2575": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461356859861064"]}, "2576": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523975629874229"]}, "2577": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480596681064899"]}, "2578": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945265415459444"]}, "2579": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451637398759114"]}, "2580": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544621993678544"]}, "2581": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501132150069169"]}, "2582": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501471345669284"]}, "2583": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491089308267109"]}, "2584": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482732885765624"]}, "2585": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953195237375569"]}, "2586": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512525979271689"]}, "2587": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952237534373664"]}, "2588": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452198060359309"]}, "2589": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544559150078519"]}, "2590": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510646671471049"]}, "2591": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540497543677134"]}, "2592": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485387514566529"]}, "2593": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949225330867489"]}, "2594": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475478473364514"]}, "2595": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953478620576524"]}, "2596": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480257971864784"]}, "2597": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542510740977824"]}, "2598": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474612643164219"]}, "2599": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510397662370964"]}, "2600": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523843820474184"]}, "2601": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532273063975694"]}, "2602": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492966349967749"]}, "2603": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952392505074204"]}, "2604": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534388715576419"]}, "2605": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515926447372849"]}, "2606": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525530423374759"]}, "2607": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515999524272874"]}, "2608": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543049694378004"]}, "2609": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951358200872024"]}, "2610": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475242235764434"]}, "2611": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482323450165484"]}, "2612": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471282947163084"]}, "2613": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461126980860989"]}, "2614": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951287947071789"]}, "2615": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534238383376364"]}, "2616": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475523959564534"]}, "2617": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520748399073129"]}, "2618": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951393319872159"]}, "2619": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491162257067134"]}, "2620": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947508037664354"]}, "2621": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502472495669629"]}, "2622": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534811036876559"]}, "2623": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532112186975639"]}, "2624": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532043317875619"]}, "2625": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484083163366084"]}, "2626": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544179033178389"]}, "2627": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095310227875264"]}, "2628": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544927029078644"]}, "2629": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465140314962354"]}, "2630": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494013605268109"]}, "2631": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492981029667754"]}, "2632": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471370216563114"]}, "2633": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495491093768614"]}, "2634": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483744928665969"]}, "2635": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453577492859779"]}, "2636": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531568585175454"]}, "2637": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493748072668019"]}, "2638": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452668373459469"]}, "2639": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513654475972074"]}, "2640": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451359721359019"]}, "2641": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946266390661494"]}, "2642": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490986836667074"]}, "2643": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544355906478454"]}, "2644": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505078794770514"]}, "2645": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953085432075194"]}, "2646": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503068013269829"]}, "2647": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520999249673214"]}, "2648": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512935599371829"]}, "2649": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470593277862849"]}, "2650": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473262539563759"]}, "2651": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482029443865384"]}, "2652": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463545028361814"]}, "2653": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541127089777349"]}, "2654": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525559784674769"]}, "2655": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094541506559954"]}, "2656": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094625493261454"]}, "2657": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474146783564064"]}, "2658": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545528640878854"]}, "2659": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484317099966164"]}, "2660": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515458214972689"]}, "2661": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533270348376034"]}, "2662": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540673150777194"]}, "2663": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455655139760484"]}, "2664": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461034532660954"]}, "2665": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461697711561184"]}, "2666": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533011238575949"]}, "2667": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474748719964269"]}, "2668": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460388936460734"]}, "2669": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946316457861664"]}, "2670": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492541972667604"]}, "2671": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483864116666009"]}, "2672": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524418773474384"]}, "2673": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465742618162559"]}, "2674": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460784072660869"]}, "2675": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462486176261449"]}, "2676": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460111003960639"]}, "2677": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949299511967734"]}, "2678": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524523110474419"]}, "2679": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500398358168919"]}, "2680": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451566850559091"]}, "2681": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520664635073104"]}, "2682": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950222707469534"]}, "2683": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522098702973589"]}, "2684": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491059870767099"]}, "2685": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513246955071939"]}, "2686": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471326592363099"]}, "2687": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504888268170454"]}, "2688": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510090528570859"]}, "2689": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483583629565914"]}, "2690": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491632635067294"]}, "2691": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463131468261669"]}, "2692": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464113676962004"]}, "2693": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510163763470884"]}, "2694": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524370861174364"]}, "2695": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521394162373349"]}, "2696": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462031816161294"]}, "2697": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954084622177239"]}, "2698": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510251932970914"]}, "2699": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472060650763349"]}, "2700": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453368386759704"]}, "2701": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485828554766679"]}, "2702": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948299253865684"]}, "2703": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542375021977774"]}, "2704": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490093854966774"]}, "2705": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455249955260349"]}, "2706": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470049513962664"]}, "2707": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535968561476954"]}, "2708": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533786169776214"]}, "2709": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530996101375259"]}, "2710": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510799108171104"]}, "2711": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460491178060769"]}, "2712": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484846546566344"]}, "2713": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542477459177809"]}, "2714": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532845873975889"]}, "2715": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504920040670464"]}, "2716": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505522168570669"]}, "2717": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484014339466064"]}, "2718": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452091545259269"]}, "2719": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950358938769979"]}, "2720": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482939685565694"]}, "2721": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540633557177184"]}, "2722": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483646508565939"]}, "2723": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954403283578329"]}, "2724": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952417361574274"]}, "2725": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952283126273829"]}, "2726": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531368197475389"]}, "2727": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491166542067139"]}, "2728": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472499293863499"]}, "2729": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492188847867484"]}, "2730": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950381689670079"]}, "2731": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948519731366434"]}, "2732": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543210863478059"]}, "2733": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540031494976979"]}, "2734": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492173879867479"]}, "2735": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462970376761614"]}, "2736": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500310999968889"]}, "2737": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491384169767209"]}, "2738": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452066358259264"]}, "2739": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503615585670019"]}, "2740": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474347317464129"]}, "2741": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545044240278684"]}, "2742": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544153861178384"]}, "2743": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540115283777004"]}, "2744": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515355787572654"]}, "2745": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452810043659514"]}, "2746": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513717138672099"]}, "2747": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524679982674469"]}, "2748": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504959366470474"]}, "2749": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483746476165974"]}, "2750": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464511034562139"]}, "2751": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522846588773844"]}, "2752": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472338215163444"]}, "2753": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452223303759314"]}, "2754": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535897378776934"]}, "2755": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472631149663544"]}, "2756": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532377327475734"]}, "2757": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482367246165499"]}, "2758": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946008881460604"]}, "2759": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946378577461869"]}, "2760": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505313350270594"]}, "2761": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491250477667164"]}, "2762": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512642524971729"]}, "2763": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470093146662679"]}, "2764": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460290775860704"]}, "2765": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495754795468699"]}, "2766": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947336177263774"]}, "2767": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500799910669059"]}, "2768": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512744957971764"]}, "2769": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462236717961364"]}, "2770": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513581222672049"]}, "2771": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453748606459834"]}, "2772": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462692563861519"]}, "2773": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533372738676069"]}, "2774": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491354730167199"]}, "2775": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094517407359139"]}, "2776": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461463495261104"]}, "2777": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513976351472184"]}, "2778": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500751955269039"]}, "2779": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523329855174009"]}, "2780": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504083828470179"]}, "2781": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544989774778669"]}, "2782": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470915230862959"]}, "2783": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462134337761329"]}, "2784": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490445633466889"]}, "2785": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500693249669019"]}, "2786": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494111775468139"]}, "2787": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541494845077474"]}, "2788": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505474354370649"]}, "2789": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951271173471749"]}, "2790": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471297236363089"]}, "2791": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520133200372919"]}, "2792": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531363811675384"]}, "2793": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523580373074094"]}, "2794": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480460508264849"]}, "2795": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947328083963744"]}, "2796": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503229050269884"]}, "2797": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514167166772249"]}, "2798": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522361913873679"]}, "2799": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532879485075904"]}, "2800": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514446968072344"]}, "2801": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485124042466439"]}, "2802": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540424710377109"]}, "2803": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493275536167854"]}, "2804": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503747327070064"]}, "2805": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512069908071534"]}, "2806": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463513822061799"]}, "2807": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541572184277504"]}, "2808": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535826829676909"]}, "2809": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490459845166894"]}, "2810": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503126726369849"]}, "2811": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544749417678584"]}, "2812": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493348651667879"]}, "2813": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947421215964079"]}, "2814": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455611416460469"]}, "2815": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503640621670024"]}, "2816": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470329337262759"]}, "2817": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510970237771159"]}, "2818": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482396478165509"]}, "2819": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535544716976809"]}, "2820": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494155392468154"]}, "2821": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535797346476899"]}, "2822": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513435144571999"]}, "2823": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534545615476469"]}, "2824": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953466332276489"]}, "2825": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481969976165364"]}, "2826": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455245735660344"]}, "2827": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472294936463429"]}, "2828": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540790362077234"]}, "2829": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525355361274699"]}, "2830": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500563754868979"]}, "2831": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532745623375859"]}, "2832": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505492794370659"]}, "2833": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493495389867929"]}, "2834": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511399256371309"]}, "2835": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485696736066634"]}, "2836": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505722497970734"]}, "2837": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465859270462599"]}, "2838": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481769323365299"]}, "2839": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502940579769789"]}, "2840": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492675553767654"]}, "2841": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523818711374179"]}, "2842": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523348443074019"]}, "2843": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493010407867764"]}, "2844": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473410430563814"]}, "2845": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481223981065109"]}, "2846": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474420390164154"]}, "2847": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532536670775784"]}, "2848": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542979034077984"]}, "2849": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095306730375124"]}, "2850": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513199250671919"]}, "2851": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522817107973834"]}, "2852": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495758967868704"]}, "2853": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471958170863314"]}, "2854": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480343708764809"]}, "2855": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450745484858809"]}, "2856": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485857962466689"]}, "2857": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480626070864909"]}, "2858": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485183159766459"]}, "2859": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521555047373404"]}, "2860": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530615710075129"]}, "2861": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474919843064324"]}, "2862": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451261731558989"]}, "2863": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495123290268484"]}, "2864": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461093339060974"]}, "2865": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523417202374039"]}, "2866": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480797412664964"]}, "2867": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520029176172884"]}, "2868": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532214531275674"]}, "2869": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480462354564854"]}, "2870": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471853689663279"]}, "2871": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452766384359499"]}, "2872": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523946131074219"]}, "2873": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515389470672669"]}, "2874": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484521946866234"]}, "2875": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535224699076704"]}, "2876": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949432302468204"]}, "2877": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504388720070279"]}, "2878": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531159121675314"]}, "2879": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504652218070369"]}, "2880": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504242716370229"]}, "2881": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493685081267994"]}, "2882": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946471471562204"]}, "2883": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460681638360834"]}, "2884": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945522023260329"]}, "2885": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483982534166054"]}, "2886": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950334206869909"]}, "2887": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490464120466899"]}, "2888": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485989590466734"]}, "2889": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543137725778034"]}, "2890": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462533723761469"]}, "2891": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470431675162794"]}, "2892": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530293514875019"]}, "2893": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480885271064994"]}, "2894": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494845503668389"]}, "2895": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453939138559899"]}, "2896": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532741655275854"]}, "2897": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493129682967804"]}, "2898": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095021151969499"]}, "2899": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473540442163854"]}, "2900": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511087606371199"]}, "2901": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461049566460959"]}, "2902": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535631911576839"]}, "2903": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511923923371484"]}, "2904": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511235655671254"]}, "2905": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474583362564209"]}, "2906": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450847716658844"]}, "2907": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544857977178624"]}, "2908": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946312165961659"]}, "2909": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541524482877484"]}, "2910": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480328807464804"]}, "2911": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535559025676814"]}, "2912": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461517918161119"]}, "2913": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491837461467364"]}, "2914": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462867983161579"]}, "2915": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502745734769719"]}, "2916": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495890810268749"]}, "2917": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480285068764789"]}, "2918": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451228001858974"]}, "2919": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545424519878814"]}, "2920": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952171252473454"]}, "2921": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512862463271804"]}, "2922": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515124081372579"]}, "2923": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500018241268789"]}, "2924": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951175902471414"]}, "2925": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455523344560439"]}, "2926": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465420142762449"]}, "2927": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530013904774924"]}, "2928": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474715142864254"]}, "2929": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452325546559349"]}, "2930": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464833113062249"]}, "2931": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544442202678479"]}, "2932": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542667442777874"]}, "2933": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462872299361584"]}, "2934": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505024396970499"]}, "2935": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465217617662384"]}, "2936": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515594353272739"]}, "2937": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530264215575009"]}, "2938": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530484049275084"]}, "2939": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484010156966059"]}, "2940": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490767032266999"]}, "2941": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472192380963394"]}, "2942": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533479483976109"]}, "2943": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515061112072554"]}, "2944": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540261482977054"]}, "2945": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544590196278534"]}, "2946": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482137267265424"]}, "2947": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530527682575099"]}, "2948": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493465979867919"]}, "2949": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451184531358959"]}, "2950": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470079000762674"]}, "2951": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510031663170839"]}, "2952": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540217857477039"]}, "2953": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485975343966729"]}, "2954": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500325304168894"]}, "2955": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514240071672274"]}, "2956": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521571300673414"]}, "2957": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462324943061394"]}, "2958": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946304047561629"]}, "2959": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473967060763999"]}, "2960": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475581111264549"]}, "2961": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474553965364199"]}, "2962": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474449869564164"]}, "2963": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533036467975954"]}, "2964": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465449539662459"]}, "2965": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532277351275699"]}, "2966": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484171123166114"]}, "2967": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460125343860644"]}, "2968": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482737149165629"]}, "2969": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470314981262754"]}, "2970": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524268505574329"]}, "2971": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544222841078404"]}, "2972": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532565925175794"]}, "2973": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950346596969944"]}, "2974": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470446771562799"]}, "2975": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945449446660059"]}, "2976": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474230567964089"]}, "2977": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505327768170599"]}, "2978": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462926660161599"]}, "2979": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524857274174534"]}, "2980": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501661592769349"]}, "2981": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521941613973539"]}, "2982": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510617307971039"]}, "2983": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461565777061139"]}, "2984": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525359464374704"]}, "2985": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482894028265679"]}, "2986": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948191078565344"]}, "2987": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511219355671244"]}, "2988": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511869458171469"]}, "2989": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523143689973949"]}, "2990": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453339107159694"]}, "2991": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514885646172494"]}, "2992": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511894414371474"]}, "2993": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501838636769414"]}, "2994": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523873212574194"]}, "2995": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533715622076189"]}, "2996": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492468887667579"]}, "2997": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475285885464449"]}, "2998": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503513192469984"]}, "2999": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501954100469449"]}, "3000": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524650659474459"]}, "3001": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946152909261114"]}, "3002": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532682698775834"]}, "3003": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511555935071359"]}, "3004": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522346829273674"]}, "3005": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544912821878639"]}, "3006": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522259518573644"]}, "3007": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525618509274789"]}, "3008": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460447565360754"]}, "3009": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465551871562494"]}, "3010": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520733473273124"]}, "3011": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483936997366034"]}, "3012": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484566416566249"]}, "3013": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471649084863209"]}, "3014": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543474583778149"]}, "3015": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490752701766994"]}, "3016": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494552509068294"]}, "3017": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503849722670099"]}, "3018": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533974920676274"]}, "3019": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945143569759034"]}, "3020": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949101240067079"]}, "3021": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502848704069754"]}, "3022": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481750846265289"]}, "3023": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511674775471399"]}, "3024": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502643563869684"]}, "3025": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524889039974544"]}, "3026": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452168618459299"]}, "3027": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471122003163029"]}, "3028": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949237583367524"]}, "3029": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514181452772254"]}, "3030": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525589266074779"]}, "3031": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530586374375119"]}, "3032": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543781495778254"]}, "3033": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463576809861824"]}, "3034": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475449095164504"]}, "3035": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485153818466449"]}, "3036": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533182255576004"]}, "3037": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504654091270374"]}, "3038": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463997250361964"]}, "3039": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463942727161949"]}, "3040": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464013198161974"]}, "3041": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474244858364094"]}, "3042": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511263110771259"]}, "3043": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523432186174044"]}, "3044": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530732480075169"]}, "3045": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946202466661284"]}, "3046": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471096746263024"]}, "3047": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493334331467874"]}, "3048": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490928362567054"]}, "3049": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540731787377214"]}, "3050": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512465116671669"]}, "3051": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501972607369459"]}, "3052": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947261722063534"]}, "3053": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464379155262094"]}, "3054": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530766113975184"]}, "3055": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945496946560229"]}, "3056": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535264114576714"]}, "3057": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455979456160594"]}, "3058": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471838636663274"]}, "3059": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471869006363284"]}, "3060": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512337701471629"]}, "3061": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481589712465234"]}, "3062": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954194711077614"]}, "3063": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534756676876544"]}, "3064": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491823170667359"]}, "3065": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510955941771154"]}, "3066": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521642469473434"]}, "3067": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501366765969249"]}, "3068": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515663463572759"]}, "3069": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502438939769614"]}, "3070": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542144915277699"]}, "3071": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501134026269174"]}, "3072": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514020078872199"]}, "3073": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473176300163734"]}, "3074": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464452403262119"]}, "3075": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543342578278104"]}, "3076": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453475103859744"]}, "3077": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513698541572089"]}, "3078": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503597002370009"]}, "3079": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491191632467144"]}, "3080": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454380053160049"]}, "3081": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532711980175844"]}, "3082": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534654300276509"]}, "3083": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484419561966199"]}, "3084": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503465486869964"]}, "3085": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948445286166194"]}, "3086": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503381527369939"]}, "3087": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453793021259849"]}, "3088": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952233318873659"]}, "3089": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450979628258889"]}, "3090": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095355242276794"]}, "3091": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510531174571014"]}, "3092": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464876835162264"]}, "3093": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474773872764274"]}, "3094": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523918687374214"]}, "3095": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952369661274104"]}, "3096": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505053756670509"]}, "3097": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500634640068999"]}, "3098": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491588884167279"]}, "3099": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481940591865354"]}, "3100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471972489363319"]}, "3101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480826604264974"]}, "3102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513742272372104"]}, "3103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512778603871779"]}, "3104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510882867771129"]}, "3105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490414591966879"]}, "3106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475271695364444"]}, "3107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535458857476784"]}, "3108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544485974578494"]}, "3109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542272202577739"]}, "3110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485318865466509"]}, "3111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480855903764984"]}, "3112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481046379365049"]}, "3113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522244467673639"]}, "3114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475742037464604"]}, "3115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451915982459209"]}, "3116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465258952362394"]}, "3117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485226600266474"]}, "3118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485416939266539"]}, "3119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464247322562054"]}, "3120": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542463019077804"]}, "3121": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484685115266289"]}, "3122": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461973165161274"]}, "3123": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530160032674974"]}, "3124": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453427189659724"]}, "3125": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523848054674189"]}, "3126": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530322917075029"]}, "3127": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515824027772814"]}, "3128": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525695791674819"]}, "3129": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455874787460559"]}, "3130": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475639314264569"]}, "3131": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482973377865709"]}, "3132": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451232301158979"]}, "3133": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952074096473114"]}, "3134": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502443087069619"]}, "3135": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533857356876234"]}, "3136": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453441533359729"]}, "3137": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540531127477149"]}, "3138": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455143217460309"]}, "3139": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453136756659629"]}, "3140": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503279063369904"]}, "3141": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475892093264659"]}, "3142": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953209588475604"]}, "3143": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946242148161424"]}, "3144": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471355958363109"]}, "3145": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452473686759399"]}, "3146": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501368295669254"]}, "3147": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471692869063224"]}, "3148": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475256567864439"]}, "3149": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514724417472439"]}, "3150": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503699292070044"]}, "3151": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465585564662509"]}, "3152": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505342688470604"]}, "3153": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525225694374659"]}, "3154": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474539687564194"]}, "3155": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954207163377649"]}, "3156": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471899532663294"]}, "3157": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524386978074374"]}, "3158": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501636313969344"]}, "3159": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475053441364374"]}, "3160": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451433074659044"]}, "3161": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495625235168659"]}, "3162": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493645744967984"]}, "3163": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460550089360789"]}, "3164": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473076295763699"]}, "3165": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450862386658851"]}, "3166": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463631324061839"]}, "3167": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462824172561564"]}, "3168": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524991578574579"]}, "3169": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949578923368684"]}, "3170": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543869425778284"]}, "3171": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501768035569389"]}, "3172": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545380721178799"]}, "3173": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953244774675739"]}, "3174": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481148597565084"]}, "3175": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495547883868629"]}, "3176": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954475723978569"]}, "3177": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491369148867204"]}, "3178": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510281255270924"]}, "3179": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490018975666744"]}, "3180": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524489527474404"]}, "3181": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525491065574749"]}, "3182": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525119051574619"]}, "3183": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475169153064409"]}, "3184": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463968020161954"]}, "3185": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525632757574794"]}, "3186": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521057971973234"]}, "3187": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491530211067259"]}, "3188": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473996531564009"]}, "3189": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474084230464039"]}, "3190": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534752310476539"]}, "3191": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530557034675109"]}, "3192": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951124317771239"]}, "3193": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500091210868814"]}, "3194": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451462213359054"]}, "3195": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492278268967514"]}, "3196": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463777259261889"]}, "3197": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524460135074394"]}, "3198": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501190923969189"]}, "3199": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485726215466644"]}, "3200": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452252383059324"]}, "3201": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524180336074299"]}, "3202": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544017589978334"]}, "3203": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493949473968084"]}, "3204": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494068084668124"]}, "3205": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543649860678209"]}, "3206": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946324590961694"]}, "3207": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485625599266614"]}, "3208": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949163241367284"]}, "3209": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521774200873479"]}, "3210": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946276982961524"]}, "3211": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504451776070304"]}, "3212": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495257047168534"]}, "3213": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530425401975064"]}, "3214": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545194515878739"]}, "3215": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535279097876719"]}, "3216": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514710146172434"]}, "3217": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462270385561379"]}, "3218": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451129934358944"]}, "3219": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473937739563989"]}, "3220": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500957016969109"]}, "3221": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470812710262924"]}, "3222": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534183917876349"]}, "3223": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485155362366454"]}, "3224": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945203409559239"]}, "3225": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513144654771904"]}, "3226": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511971844571504"]}, "3227": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473878941963969"]}, "3228": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521467130773374"]}, "3229": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461827455461224"]}, "3230": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482542464765559"]}, "3231": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515312305872639"]}, "3232": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473776576463934"]}, "3233": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542213636177719"]}, "3234": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474719353364259"]}, "3235": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512847372971799"]}, "3236": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484850639366349"]}, "3237": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492630311367634"]}, "3238": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953416619876319"]}, "3239": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525516174574754"]}, "3240": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544471651578489"]}, "3241": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522112831073594"]}, "3242": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473364843663794"]}, "3243": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500461408668944"]}, "3244": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462840470261574"]}, "3245": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452062210659259"]}, "3246": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533315910576054"]}, "3247": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491618145767289"]}, "3248": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512435875771659"]}, "3249": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484614382066269"]}, "3250": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953367248976149"]}, "3251": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504915747270459"]}, "3252": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504345084370264"]}, "3253": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525984708274914"]}, "3254": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531995195275599"]}, "3255": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544676170378559"]}, "3256": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514035098972204"]}, "3257": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525123384174624"]}, "3258": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500266605468874"]}, "3259": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455786946460529"]}, "3260": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503479547169969"]}, "3261": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490932538867059"]}, "3262": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949142745967219"]}, "3263": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481765084565294"]}, "3264": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500486445468949"]}, "3265": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534048042076299"]}, "3266": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540159176377019"]}, "3267": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491691441467314"]}, "3268": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481999216365374"]}, "3269": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521893719973519"]}, "3270": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544956224778654"]}, "3271": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474464553664169"]}, "3272": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540658880077189"]}, "3273": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543183250478054"]}, "3274": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544519712378509"]}, "3275": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947226663063399"]}, "3276": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473130749863714"]}, "3277": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503552504969994"]}, "3278": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533215874876019"]}, "3279": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533343439276059"]}, "3280": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482659824065599"]}, "3281": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473849424663959"]}, "3282": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481798727765309"]}, "3283": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463395063261759"]}, "3284": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515385121372664"]}, "3285": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950431291570249"]}, "3286": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511336456571284"]}, "3287": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532175119775664"]}, "3288": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475139779364399"]}, "3289": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463468322361784"]}, "3290": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462956052761609"]}, "3291": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504989504170484"]}, "3292": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542244764277734"]}, "3293": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494818407268384"]}, "3294": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502570548869659"]}, "3295": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511033276071184"]}, "3296": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473496766763839"]}, "3297": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473145064763719"]}, "3298": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484758362366314"]}, "3299": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462136229661334"]}, "3300": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493075230767789"]}, "3301": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494375190068229"]}, "3302": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951101451571174"]}, "3303": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544285501578429"]}, "3304": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470975762954"]}, "3305": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492473078067584"]}, "3306": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541097552477339"]}, "3307": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455947943160584"]}, "3308": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480387416664824"]}, "3309": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520632880373094"]}, "3310": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455289422260359"]}, "3311": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483512410665894"]}, "3312": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510719809171074"]}, "3313": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451725464859144"]}, "3314": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949359717467934"]}, "3315": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500595212368989"]}, "3316": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471885271963289"]}, "3317": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534858839176579"]}, "3318": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501734265969374"]}, "3319": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953011029674954"]}, "3320": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541229124577384"]}, "3321": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522581396673754"]}, "3322": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512245276171594"]}, "3323": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503214006569879"]}, "3324": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495225685668519"]}, "3325": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471330906363104"]}, "3326": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484610028466264"]}, "3327": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492996171567759"]}, "3328": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531338763175379"]}, "3329": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475757880864614"]}, "3330": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454984400060259"]}, "3331": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544090527678359"]}, "3332": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535720096876869"]}, "3333": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480194936964759"]}, "3334": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505258666770579"]}, "3335": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494218361368179"]}, "3336": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463865548461919"]}, "3337": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451567910359094"]}, "3338": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470212534462719"]}, "3339": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510192931870894"]}, "3340": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094931505267794"]}, "3341": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512671995171739"]}, "3342": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525443056374729"]}, "3343": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500164332068839"]}, "3344": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945313010759614"]}, "3345": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510529448571009"]}, "3346": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533920325476259"]}, "3347": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482426108065519"]}, "3348": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485755580066654"]}, "3349": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954186411277584"]}, "3350": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470126457562694"]}, "3351": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461997061249"]}, "3352": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474142814864059"]}, "3353": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953236851175709"]}, "3354": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485960236566724"]}, "3355": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495284721168539"]}, "3356": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501997776569464"]}, "3357": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453895404959884"]}, "3358": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480019557764699"]}, "3359": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535122342776669"]}, "3360": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533138662375989"]}, "3361": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484921125466374"]}, "3362": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492293311167519"]}, "3363": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533684194676179"]}, "3364": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524152805374294"]}, "3365": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545292641978769"]}, "3366": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541567869777499"]}, "3367": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534052200376304"]}, "3368": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470828913762934"]}, "3369": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523051302773914"]}, "3370": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514421695972339"]}, "3371": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491866700567374"]}, "3372": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523755726274154"]}, "3373": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520616719273084"]}, "3374": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504272084870239"]}, "3375": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522537799273739"]}, "3376": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482473660065539"]}, "3377": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524694253674474"]}, "3378": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485548570366584"]}, "3379": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500795602669054"]}, "3380": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473864506663964"]}, "3381": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952123675773284"]}, "3382": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500149954368834"]}, "3383": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460656665360829"]}, "3384": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495915822468754"]}, "3385": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480494138564864"]}, "3386": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520587344073074"]}, "3387": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544076341078354"]}, "3388": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494741010068354"]}, "3389": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953124630175334"]}, "3390": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953257216375774"]}, "3391": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481330483065149"]}, "3392": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475085326764384"]}, "3393": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495650341868664"]}, "3394": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455186902860324"]}, "3395": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952061721173079"]}, "3396": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470549334062834"]}, "3397": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480519241464869"]}, "3398": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463528906161804"]}, "3399": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522041757273574"]}, "3400": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502072706769494"]}, "3401": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494770413768364"]}, "3402": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511233746571249"]}, "3403": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948507296666399"]}, "3404": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474819297964294"]}, "3405": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500222971468859"]}, "3406": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524136659974284"]}, "3407": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470827018962929"]}, "3408": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462368639161409"]}, "3409": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515619446672744"]}, "3410": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510460591470989"]}, "3411": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521321202173324"]}, "3412": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535929118076944"]}, "3413": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541421633477449"]}, "3414": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525413872074719"]}, "3415": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532229605175679"]}, "3416": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492746547267674"]}, "3417": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512055605371529"]}, "3418": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453176087359639"]}, "3419": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533416389476084"]}, "3420": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473481813163834"]}, "3421": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463058426061644"]}, "3422": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534927537276599"]}, "3423": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541337936877424"]}, "3424": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501481069264"]}, "3425": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495186339368509"]}, "3426": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533347668576064"]}, "3427": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511165029571229"]}, "3428": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949261110067624"]}, "3429": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949347348867899"]}, "3430": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510368180870954"]}, "3431": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531436906975409"]}, "3432": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461739483061194"]}, "3433": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461431669361094"]}, "3434": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522730152973804"]}, "3435": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515560641372724"]}, "3436": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953162310675469"]}, "3437": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533872304976239"]}, "3438": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481017051065039"]}, "3439": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513042300171869"]}, "3440": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523741456974149"]}, "3441": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530688766575154"]}, "3442": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515487574672699"]}, "3443": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953404432676284"]}, "3444": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950112772469159"]}, "3445": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452868680059534"]}, "3446": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509450935290458874"]}, "3447": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540834140777249"]}, "3448": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493543399967949"]}, "3449": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485843603866684"]}, "3450": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524034451674249"]}, "3451": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502629343269679"]}, "3452": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483642483465934"]}, "3453": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490621049866949"]}, "3454": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482235477565454"]}, "3455": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462061353361304"]}, "3456": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492644681767639"]}, "3457": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523139353373944"]}, "3458": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510266323270919"]}, "3459": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535763675076884"]}, "3460": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505390407170624"]}, "3461": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462897362561589"]}, "3462": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480078154864719"]}, "3463": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512026203571519"]}, "3464": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543083287078019"]}, "3465": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951246355271649"]}, "3466": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484450789666214"]}, "3467": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533245277176029"]}, "3468": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948151576965204"]}, "3469": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471722026363234"]}, "3470": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511438658871319"]}, "3471": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510094787670864"]}, "3472": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534286251276384"]}, "3473": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460023132960609"]}, "3474": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465085879662339"]}, "3475": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492238932467504"]}, "3476": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454311290260029"]}, "3477": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451989059659234"]}, "3478": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534590025076484"]}, "3479": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505620253670699"]}, "3480": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470758278562909"]}, "3481": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545014858878674"]}, "3482": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524914104074549"]}, "3483": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534413815976424"]}, "3484": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535088765576654"]}, "3485": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511967598471499"]}, "3486": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524052945174259"]}, "3487": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544383448378459"]}, "3488": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454045855259939"]}, "3489": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521971124473549"]}, "3490": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455454601660419"]}, "3491": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533080310975969"]}, "3492": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482557476765564"]}, "3493": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954173958577549"]}, "3494": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504549823270334"]}, "3495": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522435192473704"]}, "3496": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491235323567159"]}, "3497": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511865203871464"]}, "3498": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531554601875449"]}, "3499": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490311935066844"]}, "3500": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525793976274849"]}, "3501": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500559427368974"]}, "3502": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500649599369004"]}, "3503": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531393173675394"]}, "3504": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945399749859889"]}, "3505": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475727071264599"]}, "3506": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484714563966299"]}, "3507": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503786627470074"]}, "3508": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525089685974609"]}, "3509": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514973816172524"]}, "3510": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500898080169089"]}, "3511": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451067065358919"]}, "3512": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491925479167394"]}, "3513": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505151898570539"]}, "3514": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534986346076619"]}, "3515": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501454611869279"]}, "3516": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452384229359369"]}, "3517": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540892727577269"]}, "3518": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472471847963494"]}, "3519": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501690678869359"]}, "3520": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520528618473054"]}, "3521": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545117226978709"]}, "3522": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945072198358794"]}, "3523": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543635513678204"]}, "3524": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513067371671874"]}, "3525": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495050290968459"]}, "3526": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483278191665814"]}, "3527": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541392324077439"]}, "3528": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475037327264364"]}, "3529": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544985496678664"]}, "3530": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480768088564954"]}, "3531": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946328796061699"]}, "3532": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948213807365409"]}, "3533": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481896884165339"]}, "3534": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535192894276694"]}, "3535": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520898766373184"]}, "3536": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470929291162964"]}, "3537": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460892824660909"]}, "3538": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515882819872834"]}, "3539": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545458057378829"]}, "3540": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504169739270204"]}, "3541": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520064494072899"]}, "3542": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474890471864314"]}, "3543": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490355622866859"]}, "3544": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493246166767844"]}, "3545": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484273482866149"]}, "3546": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495372447868569"]}, "3547": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948323429465784"]}, "3548": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505824904070769"]}, "3549": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460888500960904"]}, "3550": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513012937871859"]}, "3551": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461122670560984"]}, "3552": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540232164177044"]}, "3553": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493450990867914"]}, "3554": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483130114865759"]}, "3555": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492864104067714"]}, "3556": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480728373264944"]}, "3557": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947311490463704"]}, "3558": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460711067760844"]}, "3559": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503247290669894"]}, "3560": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492263969267509"]}, "3561": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523241750073979"]}, "3562": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490077739066764"]}, "3563": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952136099173319"]}, "3564": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490855522267029"]}, "3565": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531039648575274"]}, "3566": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503362972269929"]}, "3567": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460564271360794"]}, "3568": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452590994559439"]}, "3569": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470594797162854"]}, "3570": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481794497865304"]}, "3571": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455068218360284"]}, "3572": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503274903869899"]}, "3573": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454277692460014"]}, "3574": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946182059461219"]}, "3575": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465111010262344"]}, "3576": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513213390871924"]}, "3577": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493363598467884"]}, "3578": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463938375161944"]}, "3579": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495152682268494"]}, "3580": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541774628277574"]}, "3581": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525896287474884"]}, "3582": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950164462369334"]}, "3583": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954415749278364"]}, "3584": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465922044762624"]}, "3585": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503245390969889"]}, "3586": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534693884476519"]}, "3587": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534077262876309"]}, "3588": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485657401366624"]}, "3589": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531438769075414"]}, "3590": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483671821865944"]}, "3591": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525162764774634"]}, "3592": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490253217566824"]}, "3593": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530498423575089"]}, "3594": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523712130774139"]}, "3595": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471933197363309"]}, "3596": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482411179265514"]}, "3597": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472871528463629"]}, "3598": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948265445265584"]}, "3599": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453675681159809"]}, "3600": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512573861971709"]}, "3601": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522675572973789"]}, "3602": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493480306867924"]}, "3603": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481119367465074"]}, "3604": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490296845266839"]}, "3605": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492042072167434"]}, "3606": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950288832069744"]}, "3607": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543035425077999"]}, "3608": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472733417463579"]}, "3609": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535030022176634"]}, "3610": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953122861175329"]}, "3611": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455743131660514"]}, "3612": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500883736669084"]}, "3613": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523271227273989"]}, "3614": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953114624575299"]}, "3615": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461590945461144"]}, "3616": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949322530467829"]}, "3617": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465351439662429"]}, "3618": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094614525761079"]}, "3619": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452634686559454"]}, "3620": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475990230164689"]}, "3621": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483233034465794"]}, "3622": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455713826660504"]}, "3623": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464147356762019"]}, "3624": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543915197378299"]}, "3625": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543317417678099"]}, "3626": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491793642267349"]}, "3627": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953391817276249"]}, "3628": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514214976272269"]}, "3629": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454750181060179"]}, "3630": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534457405376439"]}, "3631": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540349550277084"]}, "3632": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472940292963649"]}, "3633": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952103191673219"]}, "3634": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534913245976594"]}, "3635": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491016216767084"]}, "3636": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543752043778244"]}, "3637": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454545441860109"]}, "3638": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464672034062194"]}, "3639": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542681746477879"]}, "3640": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495945166968764"]}, "3641": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483951339366039"]}, "3642": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542550461877834"]}, "3643": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493539127967944"]}, "3644": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510515021771004"]}, "3645": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462299744461389"]}, "3646": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470578752162844"]}, "3647": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523534512674079"]}, "3648": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952148368473354"]}, "3649": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501117866469164"]}, "3650": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484948565566379"]}, "3651": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475789688964624"]}, "3652": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501968287669454"]}, "3653": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531832129975544"]}, "3654": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500179370568844"]}, "3655": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465376518662434"]}, "3656": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514373738272319"]}, "3657": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540334657077079"]}, "3658": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455922850660579"]}, "3659": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540526890577144"]}, "3660": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462633912061499"]}, "3661": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472779565763594"]}, "3662": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533113535375984"]}, "3663": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533431489976089"]}, "3664": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462354264661404"]}, "3665": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472737757363584"]}, "3666": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952187491873494"]}, "3667": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492027879867429"]}, "3668": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464847468662254"]}, "3669": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475453329864509"]}, "3670": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474953453564339"]}, "3671": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493831998168044"]}, "3672": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454541209260104"]}, "3673": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545512466378844"]}, "3674": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461547316961129"]}, "3675": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485187166366464"]}, "3676": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521671839873444"]}, "3677": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460622920360814"]}, "3678": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521233055673294"]}, "3679": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952163163573424"]}, "3680": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512613157471719"]}, "3681": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946533545962409"]}, "3682": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475829019364634"]}, "3683": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494082365868129"]}, "3684": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462295616761384"]}, "3685": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520162565472929"]}, "3686": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483675846665949"]}, "3687": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513785874472119"]}, "3688": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505444848570639"]}, "3689": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250952295295973864"]}, "3690": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453558865459769"]}, "3691": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483496273365884"]}, "3692": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460184118560664"]}, "3693": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503097304369839"]}, "3694": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540965899577294"]}, "3695": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460961640260929"]}, "3696": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495827735368724"]}, "3697": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490048466266754"]}, "3698": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464554612762154"]}, "3699": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480489915564859"]}, "3700": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543416017278131"]}, "3701": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463263431561714"]}, "3702": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947348558763809"]}, "3703": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542228539777724"]}, "3704": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514655695572419"]}, "3705": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460140543860649"]}, "3706": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950443760370284"]}, "3707": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470256365962734"]}, "3708": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521471438373379"]}, "3709": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481253161565119"]}, "3710": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523476052374059"]}, "3711": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532127158575644"]}, "3712": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485389402466534"]}, "3713": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452434299159389"]}, "3714": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954248371177789"]}, "3715": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950406475170149"]}, "3716": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513815233072129"]}, "3717": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540760995577224"]}, "3718": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533550126276134"]}, "3719": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455688718960499"]}, "3720": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524385136274369"]}, "3721": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949444610168239"]}, "3722": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485859759066694"]}, "3723": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482455121465529"]}, "3724": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471532028763171"]}, "3725": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463660662761849"]}, "3726": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520867039273174"]}, "3727": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504256955170234"]}, "3728": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514988124472529"]}, "3729": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531275756375354"]}, "3730": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461078863360969"]}, "3731": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509511267426371264"]}, "3732": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470476089062809"]}, "3733": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945327205559654"]}, "3734": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540863351677259"]}, "3735": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531938831475584"]}, "3736": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535592639676829"]}, "3737": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484580744666254"]}, "3738": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542915857477959"]}, "3739": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503981440970144"]}, "3740": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480299349564794"]}, "3741": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512011153871514"]}, "3742": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495813511768719"]}, "3743": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522980144073894"]}, "3744": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451330614859011"]}, "3745": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452825100559519"]}, "3746": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475217171464429"]}, "3747": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535749400376879"]}, "3748": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534154585176339"]}, "3749": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481535281165219"]}, "3750": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484116686066099"]}, "3751": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475921452264669"]}, "3752": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480180637764754"]}, "3753": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492937066567739"]}, "3754": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495079632168469"]}, "3755": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501322988969234"]}, "3756": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513512497872029"]}, "3757": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946264520961489"]}, "3758": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532332035875714"]}, "3759": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492366305667544"]}, "3760": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463336556861739"]}, "3761": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491221051767154"]}, "3762": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455038859560274"]}, "3763": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951418111172229"]}, "3764": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505122535570529"]}, "3765": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954428351178399"]}, "3766": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494318391868214"]}, "3767": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512128708971554"]}, "3768": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532448436975754"]}, "3769": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946434175062069"]}, "3770": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472910825663639"]}, "3771": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542769759677909"]}, "3772": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500868619669079"]}, "3773": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530791193975189"]}, "3774": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492057281267439"]}, "3775": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510499949570999"]}, "3776": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452354804959359"]}, "3777": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095010448269124"]}, "3778": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455320536260374"]}, "3779": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483042037265729"]}, "3780": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455086407960294"]}, "3781": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533450050676099"]}, "3782": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463029088361634"]}, "3783": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464011528161969"]}, "3784": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543785800978259"]}, "3785": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464364845562089"]}, "3786": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501425403969269"]}, "3787": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452164416759294"]}, "3788": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946483863262239"]}, "3789": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525750180674834"]}, "3790": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465522640362484"]}, "3791": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462065633761309"]}, "3792": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473233102063749"]}, "3793": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493379807667894"]}, "3794": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452428026959384"]}, "3795": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513844767172139"]}, "3796": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541992772577644"]}, "3797": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474115062364054"]}, "3798": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513184396171914"]}, "3799": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473467335063829"]}, "3800": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540922057277279"]}, "3801": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493411612367904"]}, "3802": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535147427976674"]}, "3803": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463675131761854"]}, "3804": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512362816571634"]}, "3805": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513817145972134"]}, "3806": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514269133172284"]}, "3807": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525326208774691"]}, "3808": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954146716577444"]}, "3809": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465712977762549"]}, "3810": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532595299275804"]}, "3811": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522439361673709"]}, "3812": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544051233878349"]}, "3813": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520767025573139"]}, "3814": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484639354866274"]}, "3815": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510562996171024"]}, "3816": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515429115872679"]}, "3817": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514755672772454"]}, "3818": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464069968961989"]}, "3819": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481692157365269"]}, "3820": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512676222971744"]}, "3821": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504554138770339"]}, "3822": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541758473077564"]}, "3823": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520353019572994"]}, "3824": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544490180078499"]}, "3825": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948226082665444"]}, "3826": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454350656360039"]}, "3827": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502380009369594"]}, "3828": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481267625765124"]}, "3829": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095305233875094"]}, "3830": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490150812366789"]}, "3831": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950518167370524"]}, "3832": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500427690368929"]}, "3833": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949339254167869"]}, "3834": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455788715160534"]}, "3835": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535352154976744"]}, "3836": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509521789299273484"]}, "3837": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472119319463369"]}, "3838": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451623000859109"]}, "3839": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509451666804059124"]}, "3840": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525457442774734"]}, "3841": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465772074662569"]}, "3842": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455113945660299"]}, "3843": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510046731470844"]}, "3844": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465727437262554"]}, "3845": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482339589465494"]}, "3846": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520148311872924"]}, "3847": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512479605771674"]}, "3848": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509512774364071774"]}, "3849": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541068170177329"]}, "3850": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501486070569289"]}, "3851": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515960124072864"]}, "3852": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470962978662979"]}, "3853": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455013802060269"]}, "3854": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948385707965989"]}, "3855": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509545092152178704"]}, "3856": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453044141859594"]}, "3857": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509470490392862814"]}, "3858": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452854472759529"]}, "3859": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950272132369704"]}, "3860": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250947214312363364"]}, "3861": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494668073968329"]}, "3862": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474069844164034"]}, "3863": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531134093775309"]}, "3864": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485021635066404"]}, "3865": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510558701971019"]}, "3866": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492732216667669"]}, "3867": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946068646060809"]}, "3868": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250946558279662479"]}, "3869": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523212371873969"]}, "3870": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543064694978009"]}, "3871": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533065898775964"]}, "3872": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460476941760764"]}, "3873": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525398828074714"]}, "3874": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513374314271979"]}, "3875": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540131464377014"]}, "3876": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509473747197663924"]}, "3877": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509535454612776779"]}, "3878": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509531627291475474"]}, "3879": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472137793263379"]}, "3880": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515623716572749"]}, "3881": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250948555092166569"]}, "3882": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514285482172289"]}, "3883": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509492336933967534"]}, "3884": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500663967969009"]}, "3885": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464715729562209"]}, "3886": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530659427175144"]}, "3887": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502188216269529"]}, "3888": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480155570664749"]}, "3889": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453836743059864"]}, "3890": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491735100567329"]}, "3891": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509510665346171059"]}, "3892": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954134226077409"]}, "3893": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514685076672429"]}, "3894": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945484649260194"]}, "3895": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472942147563654"]}, "3896": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541875051377604"]}, "3897": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533769903376204"]}, "3898": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505914976070799"]}, "3899": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520192022572939"]}, "3900": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464617598362179"]}, "3901": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524811739974514"]}, "3902": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250950235013269569"]}, "3903": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522391392273689"]}, "3904": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494653069168324"]}, "3905": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543181345778049"]}, "3906": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503333447269919"]}, "3907": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534252722476369"]}, "3908": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509480151361964744"]}, "3909": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463810899461904"]}, "3910": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509454850127260214"]}, "3911": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525094842448866124"]}, "3912": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540367750477094"]}, "3913": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491970984267414"]}, "3914": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504842700570434"]}, "3915": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452575927259434"]}, "3916": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482440279765524"]}, "3917": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460461903060759"]}, "3918": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494952247768429"]}, "3919": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490961789867069"]}, "3920": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474851108964304"]}, "3921": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525095322156675669"]}, "3922": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542170050577704"]}, "3923": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462999717261624"]}, "3924": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509452638953059459"]}, "3925": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475319531864464"]}, "3926": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520926148873189"]}, "3927": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522127878373599"]}, "3928": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509500281712668879"]}, "3929": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530531964675104"]}, "3930": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523036932173909"]}, "3931": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949469330268309"]}, "3932": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509514622096872404"]}, "3933": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534488721476454"]}, "3934": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502468257769624"]}, "3935": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534384582076414"]}, "3936": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503038649069819"]}, "3937": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513947066372174"]}, "3938": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541831405077589"]}, "3939": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464274820162059"]}, "3940": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490727697766989"]}, "3941": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509532948235375924"]}, "3942": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520323743572984"]}, "3943": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540765325377229"]}, "3944": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504115218670189"]}, "3945": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509482571787465569"]}, "3946": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540835888977254"]}, "3947": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464279096662064"]}, "3948": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481296968965134"]}, "3949": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534724871776534"]}, "3950": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250951112032471204"]}, "3951": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484992363466394"]}, "3952": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509502424560569609"]}, "3953": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503082260969834"]}, "3954": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461429780061089"]}, "3955": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509544544722678514"]}, "3956": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501533803869309"]}, "3957": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495459754468599"]}, "3958": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483262223365804"]}, "3959": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534135988676329"]}, "3960": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509513330595771964"]}, "3961": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520430571873024"]}, "3962": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509530761893975179"]}, "3963": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471619747463199"]}, "3964": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509515257794972624"]}, "3965": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509543581000478189"]}, "3966": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465654328062529"]}, "3967": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485916650966709"]}, "3968": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465081550062334"]}, "3969": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455084622160289"]}, "3970": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250949297805167729"]}, "3971": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509460345131260719"]}, "3972": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523198037873964"]}, "3973": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509485519419966574"]}, "3974": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509475887806364654"]}, "3975": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509524623095674454"]}, "3976": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250945325358059649"]}, "3977": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509462558794261474"]}, "3978": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509542945265877969"]}, "3979": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509491871010467379"]}, "3980": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463913304361939"]}, "3981": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520865261573169"]}, "3982": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494711703768344"]}, "3983": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509453943417459904"]}, "3984": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509474215652664084"]}, "3985": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504583551270349"]}, "3986": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250954208662077654"]}, "3987": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509490664652866964"]}, "3988": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494755367668359"]}, "3989": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509484112431666094"]}, "3990": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509503481417469974"]}, "3991": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509504020762970154"]}, "3992": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509541938083477629"]}, "3993": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509533241119376024"]}, "3994": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493796667999"]}, "3995": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509465347237562424"]}, "3996": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509455640633860479"]}, "3997": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534091554576314"]}, "3998": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509493612163667969"]}, "3999": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520792118573144"]}, "4000": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534942574776604"]}, "4001": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509520382729773004"]}, "4002": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509523814416274174"]}, "4003": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509483364701465839"]}, "4004": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250953342063876079"]}, "4005": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509472133751863374"]}, "4006": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509461313045861049"]}, "4007": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505678919170719"]}, "4008": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509471194775363054"]}, "4009": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509495784029968709"]}, "4010": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509501015383269129"]}, "4011": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509464717548462214"]}, "4012": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509525677203274809"]}, "4013": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509463779121361894"]}, "4014": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509481238227265114"]}, "4015": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509540365992177089"]}, "4016": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509534888224576589"]}, "4017": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509494638761168319"]}, "4018": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509522880141173859"]}, "4019": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509505592789670694"]}}, "00080032": {"0": {"vr": "TM", "Value": ["094817.767500"]}, "1": {"vr": "TM", "Value": ["094929.485000"]}, "2": {"vr": "TM", "Value": ["095117.007500"]}, "3": {"vr": "TM", "Value": ["095138.265000"]}, "4": {"vr": "TM", "Value": ["095050.607500"]}, "5": {"vr": "TM", "Value": ["095042.247500"]}, "6": {"vr": "TM", "Value": ["095301.437500"]}, "7": {"vr": "TM", "Value": ["095319.915000"]}, "8": {"vr": "TM", "Value": ["094830.100000"]}, "9": {"vr": "TM", "Value": ["094659.152500"]}, "10": {"vr": "TM", "Value": ["095259.222500"]}, "11": {"vr": "TM", "Value": ["094840.510000"]}, "12": {"vr": "TM", "Value": ["094836.100000"]}, "13": {"vr": "TM", "Value": ["094509.455000"]}, "14": {"vr": "TM", "Value": ["094957.660000"]}, "15": {"vr": "TM", "Value": ["095150.137500"]}, "16": {"vr": "TM", "Value": ["095245.592500"]}, "17": {"vr": "TM", "Value": ["094600.937500"]}, "18": {"vr": "TM", "Value": ["094758.412500"]}, "19": {"vr": "TM", "Value": ["095153.670000"]}, "20": {"vr": "TM", "Value": ["094709.290000"]}, "21": {"vr": "TM", "Value": ["095204.372500"]}, "22": {"vr": "TM", "Value": ["095225.485000"]}, "23": {"vr": "TM", "Value": ["095352.315000"]}, "24": {"vr": "TM", "Value": ["095209.955000"]}, "25": {"vr": "TM", "Value": ["094756.070000"]}, "26": {"vr": "TM", "Value": ["094939.037500"]}, "27": {"vr": "TM", "Value": ["094722.920000"]}, "28": {"vr": "TM", "Value": ["094745.222500"]}, "29": {"vr": "TM", "Value": ["095142.967500"]}, "30": {"vr": "TM", "Value": ["094940.940000"]}, "31": {"vr": "TM", "Value": ["094825.397500"]}, "32": {"vr": "TM", "Value": ["095021.407500"]}, "33": {"vr": "TM", "Value": ["094738.177500"]}, "34": {"vr": "TM", "Value": ["095454.792500"]}, "35": {"vr": "TM", "Value": ["094506.090000"]}, "36": {"vr": "TM", "Value": ["094641.260000"]}, "37": {"vr": "TM", "Value": ["094753.290000"]}, "38": {"vr": "TM", "Value": ["095105.845000"]}, "39": {"vr": "TM", "Value": ["094914.540000"]}, "40": {"vr": "TM", "Value": ["095317.552500"]}, "41": {"vr": "TM", "Value": ["095425.905000"]}, "42": {"vr": "TM", "Value": ["095431.192500"]}, "43": {"vr": "TM", "Value": ["094758.557500"]}, "44": {"vr": "TM", "Value": ["095248.227500"]}, "45": {"vr": "TM", "Value": ["094615.885000"]}, "46": {"vr": "TM", "Value": ["095300.392500"]}, "47": {"vr": "TM", "Value": ["095422.392500"]}, "48": {"vr": "TM", "Value": ["094907.055000"]}, "49": {"vr": "TM", "Value": ["094531.885000"]}, "50": {"vr": "TM", "Value": ["095228.432500"]}, "51": {"vr": "TM", "Value": ["095236.940000"]}, "52": {"vr": "TM", "Value": ["095246.617500"]}, "53": {"vr": "TM", "Value": ["094815.135000"]}, "54": {"vr": "TM", "Value": ["094632.460000"]}, "55": {"vr": "TM", "Value": ["094848.577500"]}, "56": {"vr": "TM", "Value": ["095043.710000"]}, "57": {"vr": "TM", "Value": ["094906.032500"]}, "58": {"vr": "TM", "Value": ["094829.222500"]}, "59": {"vr": "TM", "Value": ["094726.890000"]}, "60": {"vr": "TM", "Value": ["095141.045000"]}, "61": {"vr": "TM", "Value": ["095311.992500"]}, "62": {"vr": "TM", "Value": ["094814.987500"]}, "63": {"vr": "TM", "Value": ["095437.045000"]}, "64": {"vr": "TM", "Value": ["095039.300000"]}, "65": {"vr": "TM", "Value": ["095438.382500"]}, "66": {"vr": "TM", "Value": ["094816.305000"]}, "67": {"vr": "TM", "Value": ["094843.290000"]}, "68": {"vr": "TM", "Value": ["094650.937500"]}, "69": {"vr": "TM", "Value": ["094715.290000"]}, "70": {"vr": "TM", "Value": ["094626.607500"]}, "71": {"vr": "TM", "Value": ["095048.685000"]}, "72": {"vr": "TM", "Value": ["095043.270000"]}, "73": {"vr": "TM", "Value": ["095204.520000"]}, "74": {"vr": "TM", "Value": ["094605.327500"]}, "75": {"vr": "TM", "Value": ["095407.135000"]}, "76": {"vr": "TM", "Value": ["095201.155000"]}, "77": {"vr": "TM", "Value": ["094942.402500"]}, "78": {"vr": "TM", "Value": ["095143.555000"]}, "79": {"vr": "TM", "Value": ["094737.300000"]}, "80": {"vr": "TM", "Value": ["095452.890000"]}, "81": {"vr": "TM", "Value": ["094604.890000"]}, "82": {"vr": "TM", "Value": ["095110.842500"]}, "83": {"vr": "TM", "Value": ["095021.260000"]}, "84": {"vr": "TM", "Value": ["094522.937500"]}, "85": {"vr": "TM", "Value": ["095148.382500"]}, "86": {"vr": "TM", "Value": ["095241.915000"]}, "87": {"vr": "TM", "Value": ["095203.495000"]}, "88": {"vr": "TM", "Value": ["094905.300000"]}, "89": {"vr": "TM", "Value": ["095344.100000"]}, "90": {"vr": "TM", "Value": ["094507.992500"]}, "91": {"vr": "TM", "Value": ["094648.305000"]}, "92": {"vr": "TM", "Value": ["095218.607500"]}, "93": {"vr": "TM", "Value": ["094625.730000"]}, "94": {"vr": "TM", "Value": ["095340.735000"]}, "95": {"vr": "TM", "Value": ["094724.822500"]}, "96": {"vr": "TM", "Value": ["094734.792500"]}, "97": {"vr": "TM", "Value": ["095443.505000"]}, "98": {"vr": "TM", "Value": ["094518.402500"]}, "99": {"vr": "TM", "Value": ["094519.132500"]}, "100": {"vr": "TM", "Value": ["094615.445000"]}, "101": {"vr": "TM", "Value": ["094851.650000"]}, "102": {"vr": "TM", "Value": ["094617.515000"]}, "103": {"vr": "TM", "Value": ["095014.237500"]}, "104": {"vr": "TM", "Value": ["095254.977500"]}, "105": {"vr": "TM", "Value": ["095337.807500"]}, "106": {"vr": "TM", "Value": ["095210.247500"]}, "107": {"vr": "TM", "Value": ["095330.032500"]}, "108": {"vr": "TM", "Value": ["094713.095000"]}, "109": {"vr": "TM", "Value": ["094714.557500"]}, "110": {"vr": "TM", "Value": ["095436.167500"]}, "111": {"vr": "TM", "Value": ["095258.345000"]}, "112": {"vr": "TM", "Value": ["094820.275000"]}, "113": {"vr": "TM", "Value": ["095431.632500"]}, "114": {"vr": "TM", "Value": ["095002.342500"]}, "115": {"vr": "TM", "Value": ["095219.340000"]}, "116": {"vr": "TM", "Value": ["095307.875000"]}, "117": {"vr": "TM", "Value": ["094704.587500"]}, "118": {"vr": "TM", "Value": ["095128.002500"]}, "119": {"vr": "TM", "Value": ["095446.140000"]}, "120": {"vr": "TM", "Value": ["094549.485000"]}, "121": {"vr": "TM", "Value": ["094531.300000"]}, "122": {"vr": "TM", "Value": ["095242.352500"]}, "123": {"vr": "TM", "Value": ["094516.937500"]}, "124": {"vr": "TM", "Value": ["095214.637500"]}, "125": {"vr": "TM", "Value": ["095006.167500"]}, "126": {"vr": "TM", "Value": ["095428.245000"]}, "127": {"vr": "TM", "Value": ["094918.050000"]}, "128": {"vr": "TM", "Value": ["095133.875000"]}, "129": {"vr": "TM", "Value": ["094808.235000"]}, "130": {"vr": "TM", "Value": ["094611.787500"]}, "131": {"vr": "TM", "Value": ["095143.847500"]}, "132": {"vr": "TM", "Value": ["095337.367500"]}, "133": {"vr": "TM", "Value": ["095423.417500"]}, "134": {"vr": "TM", "Value": ["095338.832500"]}, "135": {"vr": "TM", "Value": ["094742.567500"]}, "136": {"vr": "TM", "Value": ["094941.377500"]}, "137": {"vr": "TM", "Value": ["095041.807500"]}, "138": {"vr": "TM", "Value": ["094614.567500"]}, "139": {"vr": "TM", "Value": ["094800.022500"]}, "140": {"vr": "TM", "Value": ["094837.145000"]}, "141": {"vr": "TM", "Value": ["094539.220000"]}, "142": {"vr": "TM", "Value": ["095017.747500"]}, "143": {"vr": "TM", "Value": ["095243.085000"]}, "144": {"vr": "TM", "Value": ["095024.060000"]}, "145": {"vr": "TM", "Value": ["095249.545000"]}, "146": {"vr": "TM", "Value": ["094601.377500"]}, "147": {"vr": "TM", "Value": ["094722.627500"]}, "148": {"vr": "TM", "Value": ["095301.730000"]}, "149": {"vr": "TM", "Value": ["095241.182500"]}, "150": {"vr": "TM", "Value": ["094954.860000"]}, "151": {"vr": "TM", "Value": ["094716.900000"]}, "152": {"vr": "TM", "Value": ["095437.340000"]}, "153": {"vr": "TM", "Value": ["094731.865000"]}, "154": {"vr": "TM", "Value": ["094515.767500"]}, "155": {"vr": "TM", "Value": ["095156.597500"]}, "156": {"vr": "TM", "Value": ["094746.832500"]}, "157": {"vr": "TM", "Value": ["094859.572500"]}, "158": {"vr": "TM", "Value": ["095026.547500"]}, "159": {"vr": "TM", "Value": ["094556.527500"]}, "160": {"vr": "TM", "Value": ["095453.767500"]}, "161": {"vr": "TM", "Value": ["095256.150000"]}, "162": {"vr": "TM", "Value": ["094735.377500"]}, "163": {"vr": "TM", "Value": ["095239.865000"]}, "164": {"vr": "TM", "Value": ["094659.300000"]}, "165": {"vr": "TM", "Value": ["095226.675000"]}, "166": {"vr": "TM", "Value": ["095048.392500"]}, "167": {"vr": "TM", "Value": ["094906.762500"]}, "168": {"vr": "TM", "Value": ["094632.022500"]}, "169": {"vr": "TM", "Value": ["094805.747500"]}, "170": {"vr": "TM", "Value": ["094552.870000"]}, "171": {"vr": "TM", "Value": ["094757.535000"]}, "172": {"vr": "TM", "Value": ["094542.022500"]}, "173": {"vr": "TM", "Value": ["095426.197500"]}, "174": {"vr": "TM", "Value": ["094712.070000"]}, "175": {"vr": "TM", "Value": ["094817.330000"]}, "176": {"vr": "TM", "Value": ["094525.885000"]}, "177": {"vr": "TM", "Value": ["095252.345000"]}, "178": {"vr": "TM", "Value": ["095408.012500"]}, "179": {"vr": "TM", "Value": ["095246.177500"]}, "180": {"vr": "TM", "Value": ["094702.832500"]}, "181": {"vr": "TM", "Value": ["094819.377500"]}, "182": {"vr": "TM", "Value": ["095228.725000"]}, "183": {"vr": "TM", "Value": ["095114.352500"]}, "184": {"vr": "TM", "Value": ["094533.075000"]}, "185": {"vr": "TM", "Value": ["094749.172500"]}, "186": {"vr": "TM", "Value": ["095218.315000"]}, "187": {"vr": "TM", "Value": ["095219.777500"]}, "188": {"vr": "TM", "Value": ["095424.002500"]}, "189": {"vr": "TM", "Value": ["094858.987500"]}, "190": {"vr": "TM", "Value": ["095020.235000"]}, "191": {"vr": "TM", "Value": ["094514.430000"]}, "192": {"vr": "TM", "Value": ["095203.935000"]}, "193": {"vr": "TM", "Value": ["094611.202500"]}, "194": {"vr": "TM", "Value": ["095412.567500"]}, "195": {"vr": "TM", "Value": ["095028.012500"]}, "196": {"vr": "TM", "Value": ["095106.745000"]}, "197": {"vr": "TM", "Value": ["094901.330000"]}, "198": {"vr": "TM", "Value": ["094508.432500"]}, "199": {"vr": "TM", "Value": ["095112.012500"]}, "200": {"vr": "TM", "Value": ["094530.860000"]}, "201": {"vr": "TM", "Value": ["095143.115000"]}, "202": {"vr": "TM", "Value": ["095211.562500"]}, "203": {"vr": "TM", "Value": ["094748.880000"]}, "204": {"vr": "TM", "Value": ["094913.660000"]}, "205": {"vr": "TM", "Value": ["095223.730000"]}, "206": {"vr": "TM", "Value": ["095235.915000"]}, "207": {"vr": "TM", "Value": ["095040.782500"]}, "208": {"vr": "TM", "Value": ["094540.685000"]}, "209": {"vr": "TM", "Value": ["094618.832500"]}, "210": {"vr": "TM", "Value": ["095002.490000"]}, "211": {"vr": "TM", "Value": ["095033.447500"]}, "212": {"vr": "TM", "Value": ["095344.245000"]}, "213": {"vr": "TM", "Value": ["095345.437500"]}, "214": {"vr": "TM", "Value": ["095206.567500"]}, "215": {"vr": "TM", "Value": ["095053.535000"]}, "216": {"vr": "TM", "Value": ["094710.460000"]}, "217": {"vr": "TM", "Value": ["094700.177500"]}, "218": {"vr": "TM", "Value": ["095413.592500"]}, "219": {"vr": "TM", "Value": ["094929.630000"]}, "220": {"vr": "TM", "Value": ["094830.832500"]}, "221": {"vr": "TM", "Value": ["095010.997500"]}, "222": {"vr": "TM", "Value": ["095021.700000"]}, "223": {"vr": "TM", "Value": ["094540.830000"]}, "224": {"vr": "TM", "Value": ["094548.460000"]}, "225": {"vr": "TM", "Value": ["094552.577500"]}, "226": {"vr": "TM", "Value": ["095107.915000"]}, "227": {"vr": "TM", "Value": ["094647.572500"]}, "228": {"vr": "TM", "Value": ["095038.567500"]}, "229": {"vr": "TM", "Value": ["094808.090000"]}, "230": {"vr": "TM", "Value": ["094708.977500"]}, "231": {"vr": "TM", "Value": ["094658.715000"]}, "232": {"vr": "TM", "Value": ["095226.382500"]}, "233": {"vr": "TM", "Value": ["095236.792500"]}, "234": {"vr": "TM", "Value": ["094806.187500"]}, "235": {"vr": "TM", "Value": ["095235.622500"]}, "236": {"vr": "TM", "Value": ["095350.705000"]}, "237": {"vr": "TM", "Value": ["094540.537500"]}, "238": {"vr": "TM", "Value": ["095009.827500"]}, "239": {"vr": "TM", "Value": ["095246.325000"]}, "240": {"vr": "TM", "Value": ["094857.962500"]}, "241": {"vr": "TM", "Value": ["095009.680000"]}, "242": {"vr": "TM", "Value": ["095122.275000"]}, "243": {"vr": "TM", "Value": ["094822.762500"]}, "244": {"vr": "TM", "Value": ["095419.300000"]}, "245": {"vr": "TM", "Value": ["095323.280000"]}, "246": {"vr": "TM", "Value": ["094509.310000"]}, "247": {"vr": "TM", "Value": ["094617.367500"]}, "248": {"vr": "TM", "Value": ["095036.080000"]}, "249": {"vr": "TM", "Value": ["095045.905000"]}, "250": {"vr": "TM", "Value": ["095132.537500"]}, "251": {"vr": "TM", "Value": ["094755.632500"]}, "252": {"vr": "TM", "Value": ["095017.017500"]}, "253": {"vr": "TM", "Value": ["095022.890000"]}, "254": {"vr": "TM", "Value": ["095057.045000"]}, "255": {"vr": "TM", "Value": ["094845.630000"]}, "256": {"vr": "TM", "Value": ["095316.530000"]}, "257": {"vr": "TM", "Value": ["095402.890000"]}, "258": {"vr": "TM", "Value": ["094856.060000"]}, "259": {"vr": "TM", "Value": ["094852.382500"]}, "260": {"vr": "TM", "Value": ["094639.505000"]}, "261": {"vr": "TM", "Value": ["095307.290000"]}, "262": {"vr": "TM", "Value": ["094754.607500"]}, "263": {"vr": "TM", "Value": ["094613.835000"]}, "264": {"vr": "TM", "Value": ["095328.715000"]}, "265": {"vr": "TM", "Value": ["095422.100000"]}, "266": {"vr": "TM", "Value": ["095433.535000"]}, "267": {"vr": "TM", "Value": ["094832.735000"]}, "268": {"vr": "TM", "Value": ["094624.830000"]}, "269": {"vr": "TM", "Value": ["095157.475000"]}, "270": {"vr": "TM", "Value": ["095455.085000"]}, "271": {"vr": "TM", "Value": ["095221.680000"]}, "272": {"vr": "TM", "Value": ["095411.085000"]}, "273": {"vr": "TM", "Value": ["094943.427500"]}, "274": {"vr": "TM", "Value": ["094626.460000"]}, "275": {"vr": "TM", "Value": ["094648.450000"]}, "276": {"vr": "TM", "Value": ["095225.045000"]}, "277": {"vr": "TM", "Value": ["095355.992500"]}, "278": {"vr": "TM", "Value": ["094829.952500"]}, "279": {"vr": "TM", "Value": ["094759.435000"]}, "280": {"vr": "TM", "Value": ["095103.797500"]}, "281": {"vr": "TM", "Value": ["094854.890000"]}, "282": {"vr": "TM", "Value": ["094538.197500"]}, "283": {"vr": "TM", "Value": ["094947.085000"]}, "284": {"vr": "TM", "Value": ["095411.837500"]}, "285": {"vr": "TM", "Value": ["095223.142500"]}, "286": {"vr": "TM", "Value": ["095022.137500"]}, "287": {"vr": "TM", "Value": ["094612.665000"]}, "288": {"vr": "TM", "Value": ["094714.705000"]}, "289": {"vr": "TM", "Value": ["095437.485000"]}, "290": {"vr": "TM", "Value": ["095447.037500"]}, "291": {"vr": "TM", "Value": ["094900.890000"]}, "292": {"vr": "TM", "Value": ["094945.182500"]}, "293": {"vr": "TM", "Value": ["094721.162500"]}, "294": {"vr": "TM", "Value": ["095420.177500"]}, "295": {"vr": "TM", "Value": ["095129.027500"]}, "296": {"vr": "TM", "Value": ["094735.545000"]}, "297": {"vr": "TM", "Value": ["094524.130000"]}, "298": {"vr": "TM", "Value": ["094528.227500"]}, "299": {"vr": "TM", "Value": ["094521.327500"]}, "300": {"vr": "TM", "Value": ["095422.540000"]}, "301": {"vr": "TM", "Value": ["095450.402500"]}, "302": {"vr": "TM", "Value": ["095108.060000"]}, "303": {"vr": "TM", "Value": ["094925.535000"]}, "304": {"vr": "TM", "Value": ["094933.310000"]}, "305": {"vr": "TM", "Value": ["094702.685000"]}, "306": {"vr": "TM", "Value": ["095401.845000"]}, "307": {"vr": "TM", "Value": ["094926.705000"]}, "308": {"vr": "TM", "Value": ["095347.340000"]}, "309": {"vr": "TM", "Value": ["095046.342500"]}, "310": {"vr": "TM", "Value": ["095026.255000"]}, "311": {"vr": "TM", "Value": ["094643.330000"]}, "312": {"vr": "TM", "Value": ["095130.342500"]}, "313": {"vr": "TM", "Value": ["095451.427500"]}, "314": {"vr": "TM", "Value": ["095430.022500"]}, "315": {"vr": "TM", "Value": ["094716.607500"]}, "316": {"vr": "TM", "Value": ["094643.915000"]}, "317": {"vr": "TM", "Value": ["095353.045000"]}, "318": {"vr": "TM", "Value": ["094832.295000"]}, "319": {"vr": "TM", "Value": ["095026.987500"]}, "320": {"vr": "TM", "Value": ["095116.567500"]}, "321": {"vr": "TM", "Value": ["094713.972500"]}, "322": {"vr": "TM", "Value": ["095405.962500"]}, "323": {"vr": "TM", "Value": ["094937.115000"]}, "324": {"vr": "TM", "Value": ["094924.070000"]}, "325": {"vr": "TM", "Value": ["094709.730000"]}, "326": {"vr": "TM", "Value": ["094554.040000"]}, "327": {"vr": "TM", "Value": ["095112.742500"]}, "328": {"vr": "TM", "Value": ["095308.315000"]}, "329": {"vr": "TM", "Value": ["095113.915000"]}, "330": {"vr": "TM", "Value": ["094538.635000"]}, "331": {"vr": "TM", "Value": ["094944.305000"]}, "332": {"vr": "TM", "Value": ["094707.515000"]}, "333": {"vr": "TM", "Value": ["095232.382500"]}, "334": {"vr": "TM", "Value": ["094910.130000"]}, "335": {"vr": "TM", "Value": ["094804.577500"]}, "336": {"vr": "TM", "Value": ["094721.455000"]}, "337": {"vr": "TM", "Value": ["094902.352500"]}, "338": {"vr": "TM", "Value": ["094537.757500"]}, "339": {"vr": "TM", "Value": ["094835.952500"]}, "340": {"vr": "TM", "Value": ["094626.900000"]}, "341": {"vr": "TM", "Value": ["095430.462500"]}, "342": {"vr": "TM", "Value": ["094801.337500"]}, "343": {"vr": "TM", "Value": ["095334.422500"]}, "344": {"vr": "TM", "Value": ["094838.167500"]}, "345": {"vr": "TM", "Value": ["095201.007500"]}, "346": {"vr": "TM", "Value": ["094618.537500"]}, "347": {"vr": "TM", "Value": ["094657.982500"]}, "348": {"vr": "TM", "Value": ["094949.885000"]}, "349": {"vr": "TM", "Value": ["094509.162500"]}, "350": {"vr": "TM", "Value": ["095138.850000"]}, "351": {"vr": "TM", "Value": ["095400.237500"]}, "352": {"vr": "TM", "Value": ["094951.495000"]}, "353": {"vr": "TM", "Value": ["094948.715000"]}, "354": {"vr": "TM", "Value": ["094922.752500"]}, "355": {"vr": "TM", "Value": ["095319.767500"]}, "356": {"vr": "TM", "Value": ["094742.275000"]}, "357": {"vr": "TM", "Value": ["094530.567500"]}, "358": {"vr": "TM", "Value": ["095225.192500"]}, "359": {"vr": "TM", "Value": ["094705.905000"]}, "360": {"vr": "TM", "Value": ["094532.930000"]}, "361": {"vr": "TM", "Value": ["095000.295000"]}, "362": {"vr": "TM", "Value": ["095211.855000"]}, "363": {"vr": "TM", "Value": ["095004.830000"]}, "364": {"vr": "TM", "Value": ["095319.622500"]}, "365": {"vr": "TM", "Value": ["095005.730000"]}, "366": {"vr": "TM", "Value": ["095422.977500"]}, "367": {"vr": "TM", "Value": ["094657.835000"]}, "368": {"vr": "TM", "Value": ["094644.792500"]}, "369": {"vr": "TM", "Value": ["095303.485000"]}, "370": {"vr": "TM", "Value": ["095220.950000"]}, "371": {"vr": "TM", "Value": ["095211.417500"]}, "372": {"vr": "TM", "Value": ["095158.500000"]}, "373": {"vr": "TM", "Value": ["095105.260000"]}, "374": {"vr": "TM", "Value": ["094924.217500"]}, "375": {"vr": "TM", "Value": ["095058.675000"]}, "376": {"vr": "TM", "Value": ["094943.280000"]}, "377": {"vr": "TM", "Value": ["095308.752500"]}, "378": {"vr": "TM", "Value": ["094915.417500"]}, "379": {"vr": "TM", "Value": ["094734.207500"]}, "380": {"vr": "TM", "Value": ["094903.230000"]}, "381": {"vr": "TM", "Value": ["094722.040000"]}, "382": {"vr": "TM", "Value": ["094843.730000"]}, "383": {"vr": "TM", "Value": ["094511.942500"]}, "384": {"vr": "TM", "Value": ["094958.977500"]}, "385": {"vr": "TM", "Value": ["095340.150000"]}, "386": {"vr": "TM", "Value": ["095341.172500"]}, "387": {"vr": "TM", "Value": ["095100.285000"]}, "388": {"vr": "TM", "Value": ["095359.212500"]}, "389": {"vr": "TM", "Value": ["094904.715000"]}, "390": {"vr": "TM", "Value": ["094655.347500"]}, "391": {"vr": "TM", "Value": ["095345.290000"]}, "392": {"vr": "TM", "Value": ["094802.675000"]}, "393": {"vr": "TM", "Value": ["095110.547500"]}, "394": {"vr": "TM", "Value": ["095049.875000"]}, "395": {"vr": "TM", "Value": ["094954.715000"]}, "396": {"vr": "TM", "Value": ["094823.935000"]}, "397": {"vr": "TM", "Value": ["094947.837500"]}, "398": {"vr": "TM", "Value": ["094554.480000"]}, "399": {"vr": "TM", "Value": ["094649.475000"]}, "400": {"vr": "TM", "Value": ["094904.130000"]}, "401": {"vr": "TM", "Value": ["094641.115000"]}, "402": {"vr": "TM", "Value": ["094751.075000"]}, "403": {"vr": "TM", "Value": ["095037.397500"]}, "404": {"vr": "TM", "Value": ["094551.115000"]}, "405": {"vr": "TM", "Value": ["095214.342500"]}, "406": {"vr": "TM", "Value": ["094716.315000"]}, "407": {"vr": "TM", "Value": ["094755.485000"]}, "408": {"vr": "TM", "Value": ["095011.582500"]}, "409": {"vr": "TM", "Value": ["095049.145000"]}, "410": {"vr": "TM", "Value": ["094732.157500"]}, "411": {"vr": "TM", "Value": ["095330.910000"]}, "412": {"vr": "TM", "Value": ["094528.520000"]}, "413": {"vr": "TM", "Value": ["094657.250000"]}, "414": {"vr": "TM", "Value": ["094555.797500"]}, "415": {"vr": "TM", "Value": ["095257.172500"]}, "416": {"vr": "TM", "Value": ["094938.745000"]}, "417": {"vr": "TM", "Value": ["094603.280000"]}, "418": {"vr": "TM", "Value": ["094512.820000"]}, "419": {"vr": "TM", "Value": ["094556.235000"]}, "420": {"vr": "TM", "Value": ["095435.582500"]}, "421": {"vr": "TM", "Value": ["094617.807500"]}, "422": {"vr": "TM", "Value": ["094739.202500"]}, "423": {"vr": "TM", "Value": ["095323.572500"]}, "424": {"vr": "TM", "Value": ["095136.070000"]}, "425": {"vr": "TM", "Value": ["095414.910000"]}, "426": {"vr": "TM", "Value": ["095152.647500"]}, "427": {"vr": "TM", "Value": ["095125.515000"]}, "428": {"vr": "TM", "Value": ["095359.505000"]}, "429": {"vr": "TM", "Value": ["095155.720000"]}, "430": {"vr": "TM", "Value": ["095030.645000"]}, "431": {"vr": "TM", "Value": ["094640.967500"]}, "432": {"vr": "TM", "Value": ["095415.350000"]}, "433": {"vr": "TM", "Value": ["095123.152500"]}, "434": {"vr": "TM", "Value": ["094701.222500"]}, "435": {"vr": "TM", "Value": ["095433.972500"]}, "436": {"vr": "TM", "Value": ["094515.475000"]}, "437": {"vr": "TM", "Value": ["094815.427500"]}, "438": {"vr": "TM", "Value": ["095053.095000"]}, "439": {"vr": "TM", "Value": ["095257.320000"]}, "440": {"vr": "TM", "Value": ["095355.115000"]}, "441": {"vr": "TM", "Value": ["094618.245000"]}, "442": {"vr": "TM", "Value": ["094636.285000"]}, "443": {"vr": "TM", "Value": ["095331.787500"]}, "444": {"vr": "TM", "Value": ["095129.757500"]}, "445": {"vr": "TM", "Value": ["095135.777500"]}, "446": {"vr": "TM", "Value": ["095244.130000"]}, "447": {"vr": "TM", "Value": ["094520.157500"]}, "448": {"vr": "TM", "Value": ["095318.285000"]}, "449": {"vr": "TM", "Value": ["095033.152500"]}, "450": {"vr": "TM", "Value": ["095351.437500"]}, "451": {"vr": "TM", "Value": ["094706.050000"]}, "452": {"vr": "TM", "Value": ["095227.700000"]}, "453": {"vr": "TM", "Value": ["094539.367500"]}, "454": {"vr": "TM", "Value": ["094805.602500"]}, "455": {"vr": "TM", "Value": ["095051.340000"]}, "456": {"vr": "TM", "Value": ["094759.582500"]}, "457": {"vr": "TM", "Value": ["094813.232500"]}, "458": {"vr": "TM", "Value": ["094908.520000"]}, "459": {"vr": "TM", "Value": ["094758.120000"]}, "460": {"vr": "TM", "Value": ["094832.147500"]}, "461": {"vr": "TM", "Value": ["095051.192500"]}, "462": {"vr": "TM", "Value": ["094923.485000"]}, "463": {"vr": "TM", "Value": ["095103.212500"]}, "464": {"vr": "TM", "Value": ["095302.022500"]}, "465": {"vr": "TM", "Value": ["094744.930000"]}, "466": {"vr": "TM", "Value": ["094655.640000"]}, "467": {"vr": "TM", "Value": ["095013.337500"]}, "468": {"vr": "TM", "Value": ["094538.782500"]}, "469": {"vr": "TM", "Value": ["095447.767500"]}, "470": {"vr": "TM", "Value": ["095039.445000"]}, "471": {"vr": "TM", "Value": ["095030.792500"]}, "472": {"vr": "TM", "Value": ["094700.637500"]}, "473": {"vr": "TM", "Value": ["095346.167500"]}, "474": {"vr": "TM", "Value": ["095332.080000"]}, "475": {"vr": "TM", "Value": ["094511.065000"]}, "476": {"vr": "TM", "Value": ["095341.027500"]}, "477": {"vr": "TM", "Value": ["094725.552500"]}, "478": {"vr": "TM", "Value": ["095410.500000"]}, "479": {"vr": "TM", "Value": ["095253.807500"]}, "480": {"vr": "TM", "Value": ["094939.915000"]}, "481": {"vr": "TM", "Value": ["094520.450000"]}, "482": {"vr": "TM", "Value": ["094705.172500"]}, "483": {"vr": "TM", "Value": ["095314.335000"]}, "484": {"vr": "TM", "Value": ["095107.330000"]}, "485": {"vr": "TM", "Value": ["095213.172500"]}, "486": {"vr": "TM", "Value": ["094813.525000"]}, "487": {"vr": "TM", "Value": ["094839.925000"]}, "488": {"vr": "TM", "Value": ["094848.140000"]}, "489": {"vr": "TM", "Value": ["095247.202500"]}, "490": {"vr": "TM", "Value": ["095028.305000"]}, "491": {"vr": "TM", "Value": ["094945.915000"]}, "492": {"vr": "TM", "Value": ["094724.527500"]}, "493": {"vr": "TM", "Value": ["095256.735000"]}, "494": {"vr": "TM", "Value": ["095325.622500"]}, "495": {"vr": "TM", "Value": ["094815.720000"]}, "496": {"vr": "TM", "Value": ["094953.105000"]}, "497": {"vr": "TM", "Value": ["094514.285000"]}, "498": {"vr": "TM", "Value": ["095418.275000"]}, "499": {"vr": "TM", "Value": ["094552.432500"]}, "500": {"vr": "TM", "Value": ["094611.495000"]}, "501": {"vr": "TM", "Value": ["095454.500000"]}, "502": {"vr": "TM", "Value": ["095019.650000"]}, "503": {"vr": "TM", "Value": ["094855.037500"]}, "504": {"vr": "TM", "Value": ["094831.417500"]}, "505": {"vr": "TM", "Value": ["094555.650000"]}, "506": {"vr": "TM", "Value": ["094713.387500"]}, "507": {"vr": "TM", "Value": ["094648.012500"]}, "508": {"vr": "TM", "Value": ["094739.055000"]}, "509": {"vr": "TM", "Value": ["094930.382500"]}, "510": {"vr": "TM", "Value": ["095345.730000"]}, "511": {"vr": "TM", "Value": ["094926.120000"]}, "512": {"vr": "TM", "Value": ["094752.537500"]}, "513": {"vr": "TM", "Value": ["095214.050000"]}, "514": {"vr": "TM", "Value": ["094646.547500"]}, "515": {"vr": "TM", "Value": ["094822.325000"]}, "516": {"vr": "TM", "Value": ["094515.915000"]}, "517": {"vr": "TM", "Value": ["095338.392500"]}, "518": {"vr": "TM", "Value": ["094849.310000"]}, "519": {"vr": "TM", "Value": ["094705.320000"]}, "520": {"vr": "TM", "Value": ["095140.900000"]}, "521": {"vr": "TM", "Value": ["094528.665000"]}, "522": {"vr": "TM", "Value": ["094936.090000"]}, "523": {"vr": "TM", "Value": ["095440.432500"]}, "524": {"vr": "TM", "Value": ["094700.930000"]}, "525": {"vr": "TM", "Value": ["094938.890000"]}, "526": {"vr": "TM", "Value": ["095419.740000"]}, "527": {"vr": "TM", "Value": ["095356.285000"]}, "528": {"vr": "TM", "Value": ["095352.752500"]}, "529": {"vr": "TM", "Value": ["094527.787500"]}, "530": {"vr": "TM", "Value": ["094722.480000"]}, "531": {"vr": "TM", "Value": ["094827.445000"]}, "532": {"vr": "TM", "Value": ["094526.325000"]}, "533": {"vr": "TM", "Value": ["094728.645000"]}, "534": {"vr": "TM", "Value": ["095016.432500"]}, "535": {"vr": "TM", "Value": ["095216.100000"]}, "536": {"vr": "TM", "Value": ["095149.845000"]}, "537": {"vr": "TM", "Value": ["095009.242500"]}, "538": {"vr": "TM", "Value": ["095053.242500"]}, "539": {"vr": "TM", "Value": ["094506.822500"]}, "540": {"vr": "TM", "Value": ["094806.772500"]}, "541": {"vr": "TM", "Value": ["095406.110000"]}, "542": {"vr": "TM", "Value": ["095003.952500"]}, "543": {"vr": "TM", "Value": ["095446.285000"]}, "544": {"vr": "TM", "Value": ["094644.352500"]}, "545": {"vr": "TM", "Value": ["094926.850000"]}, "546": {"vr": "TM", "Value": ["095358.187500"]}, "547": {"vr": "TM", "Value": ["095355.700000"]}, "548": {"vr": "TM", "Value": ["094827.152500"]}, "549": {"vr": "TM", "Value": ["095117.447500"]}, "550": {"vr": "TM", "Value": ["095045.757500"]}, "551": {"vr": "TM", "Value": ["095258.050000"]}, "552": {"vr": "TM", "Value": ["095053.827500"]}, "553": {"vr": "TM", "Value": ["094645.817500"]}, "554": {"vr": "TM", "Value": ["095004.245000"]}, "555": {"vr": "TM", "Value": ["094508.137500"]}, "556": {"vr": "TM", "Value": ["094727.915000"]}, "557": {"vr": "TM", "Value": ["095425.320000"]}, "558": {"vr": "TM", "Value": ["095059.115000"]}, "559": {"vr": "TM", "Value": ["095244.422500"]}, "560": {"vr": "TM", "Value": ["095056.460000"]}, "561": {"vr": "TM", "Value": ["095343.222500"]}, "562": {"vr": "TM", "Value": ["095159.085000"]}, "563": {"vr": "TM", "Value": ["094754.460000"]}, "564": {"vr": "TM", "Value": ["095056.900000"]}, "565": {"vr": "TM", "Value": ["094901.622500"]}, "566": {"vr": "TM", "Value": ["095119.347500"]}, "567": {"vr": "TM", "Value": ["094827.007500"]}, "568": {"vr": "TM", "Value": ["095149.407500"]}, "569": {"vr": "TM", "Value": ["094914.392500"]}, "570": {"vr": "TM", "Value": ["094810.745000"]}, "571": {"vr": "TM", "Value": ["095307.730000"]}, "572": {"vr": "TM", "Value": ["095344.540000"]}, "573": {"vr": "TM", "Value": ["095409.330000"]}, "574": {"vr": "TM", "Value": ["095350.850000"]}, "575": {"vr": "TM", "Value": ["095108.207500"]}, "576": {"vr": "TM", "Value": ["095119.787500"]}, "577": {"vr": "TM", "Value": ["095331.935000"]}, "578": {"vr": "TM", "Value": ["095011.435000"]}, "579": {"vr": "TM", "Value": ["095252.782500"]}, "580": {"vr": "TM", "Value": ["095256.587500"]}, "581": {"vr": "TM", "Value": ["095145.017500"]}, "582": {"vr": "TM", "Value": ["095007.340000"]}, "583": {"vr": "TM", "Value": ["095118.910000"]}, "584": {"vr": "TM", "Value": ["095216.245000"]}, "585": {"vr": "TM", "Value": ["094510.920000"]}, "586": {"vr": "TM", "Value": ["095333.690000"]}, "587": {"vr": "TM", "Value": ["094643.037500"]}, "588": {"vr": "TM", "Value": ["094721.747500"]}, "589": {"vr": "TM", "Value": ["095320.355000"]}, "590": {"vr": "TM", "Value": ["094852.675000"]}, "591": {"vr": "TM", "Value": ["095035.055000"]}, "592": {"vr": "TM", "Value": ["095337.222500"]}, "593": {"vr": "TM", "Value": ["095229.602500"]}, "594": {"vr": "TM", "Value": ["094517.232500"]}, "595": {"vr": "TM", "Value": ["094524.567500"]}, "596": {"vr": "TM", "Value": ["094945.767500"]}, "597": {"vr": "TM", "Value": ["094857.085000"]}, "598": {"vr": "TM", "Value": ["095326.645000"]}, "599": {"vr": "TM", "Value": ["094737.152500"]}, "600": {"vr": "TM", "Value": ["094826.860000"]}, "601": {"vr": "TM", "Value": ["095142.382500"]}, "602": {"vr": "TM", "Value": ["094952.957500"]}, "603": {"vr": "TM", "Value": ["095403.622500"]}, "604": {"vr": "TM", "Value": ["094607.545000"]}, "605": {"vr": "TM", "Value": ["095415.935000"]}, "606": {"vr": "TM", "Value": ["095226.530000"]}, "607": {"vr": "TM", "Value": ["095124.032500"]}, "608": {"vr": "TM", "Value": ["095354.822500"]}, "609": {"vr": "TM", "Value": ["095210.832500"]}, "610": {"vr": "TM", "Value": ["095425.027500"]}, "611": {"vr": "TM", "Value": ["095001.905000"]}, "612": {"vr": "TM", "Value": ["094528.080000"]}, "613": {"vr": "TM", "Value": ["095249.105000"]}, "614": {"vr": "TM", "Value": ["094955.152500"]}, "615": {"vr": "TM", "Value": ["095150.577500"]}, "616": {"vr": "TM", "Value": ["095159.545000"]}, "617": {"vr": "TM", "Value": ["094604.012500"]}, "618": {"vr": "TM", "Value": ["094700.030000"]}, "619": {"vr": "TM", "Value": ["095021.845000"]}, "620": {"vr": "TM", "Value": ["095019.065000"]}, "621": {"vr": "TM", "Value": ["094633.337500"]}, "622": {"vr": "TM", "Value": ["094519.427500"]}, "623": {"vr": "TM", "Value": ["095353.777500"]}, "624": {"vr": "TM", "Value": ["095448.647500"]}, "625": {"vr": "TM", "Value": ["095259.660000"]}, "626": {"vr": "TM", "Value": ["094718.090000"]}, "627": {"vr": "TM", "Value": ["094654.617500"]}, "628": {"vr": "TM", "Value": ["094523.982500"]}, "629": {"vr": "TM", "Value": ["094905.447500"]}, "630": {"vr": "TM", "Value": ["095220.362500"]}, "631": {"vr": "TM", "Value": ["094757.680000"]}, "632": {"vr": "TM", "Value": ["094603.132500"]}, "633": {"vr": "TM", "Value": ["095020.675000"]}, "634": {"vr": "TM", "Value": ["094802.530000"]}, "635": {"vr": "TM", "Value": ["095230.042500"]}, "636": {"vr": "TM", "Value": ["094651.377500"]}, "637": {"vr": "TM", "Value": ["094701.952500"]}, "638": {"vr": "TM", "Value": ["095151.330000"]}, "639": {"vr": "TM", "Value": ["095431.340000"]}, "640": {"vr": "TM", "Value": ["094624.245000"]}, "641": {"vr": "TM", "Value": ["094609.592500"]}, "642": {"vr": "TM", "Value": ["094755.925000"]}, "643": {"vr": "TM", "Value": ["095217.290000"]}, "644": {"vr": "TM", "Value": ["095305.680000"]}, "645": {"vr": "TM", "Value": ["094919.660000"]}, "646": {"vr": "TM", "Value": ["095309.777500"]}, "647": {"vr": "TM", "Value": ["095059.552500"]}, "648": {"vr": "TM", "Value": ["095410.792500"]}, "649": {"vr": "TM", "Value": ["094912.030000"]}, "650": {"vr": "TM", "Value": ["094620.002500"]}, "651": {"vr": "TM", "Value": ["094735.690000"]}, "652": {"vr": "TM", "Value": ["095303.047500"]}, "653": {"vr": "TM", "Value": ["094727.037500"]}, "654": {"vr": "TM", "Value": ["095131.660000"]}, "655": {"vr": "TM", "Value": ["094813.085000"]}, "656": {"vr": "TM", "Value": ["095120.812500"]}, "657": {"vr": "TM", "Value": ["094537.612500"]}, "658": {"vr": "TM", "Value": ["095201.592500"]}, "659": {"vr": "TM", "Value": ["094631.875000"]}, "660": {"vr": "TM", "Value": ["095023.915000"]}, "661": {"vr": "TM", "Value": ["095302.607500"]}, "662": {"vr": "TM", "Value": ["094640.382500"]}, "663": {"vr": "TM", "Value": ["095455.377500"]}, "664": {"vr": "TM", "Value": ["095152.207500"]}, "665": {"vr": "TM", "Value": ["095151.475000"]}, "666": {"vr": "TM", "Value": ["094943.865000"]}, "667": {"vr": "TM", "Value": ["094621.027500"]}, "668": {"vr": "TM", "Value": ["094959.417500"]}, "669": {"vr": "TM", "Value": ["094524.422500"]}, "670": {"vr": "TM", "Value": ["094615.007500"]}, "671": {"vr": "TM", "Value": ["095102.042500"]}, "672": {"vr": "TM", "Value": ["095358.480000"]}, "673": {"vr": "TM", "Value": ["094554.920000"]}, "674": {"vr": "TM", "Value": ["095307.145000"]}, "675": {"vr": "TM", "Value": ["094845.945000"]}, "676": {"vr": "TM", "Value": ["094830.392500"]}, "677": {"vr": "TM", "Value": ["094900.305000"]}, "678": {"vr": "TM", "Value": ["094632.607500"]}, "679": {"vr": "TM", "Value": ["094958.832500"]}, "680": {"vr": "TM", "Value": ["095129.320000"]}, "681": {"vr": "TM", "Value": ["095432.657500"]}, "682": {"vr": "TM", "Value": ["095235.475000"]}, "683": {"vr": "TM", "Value": ["095428.977500"]}, "684": {"vr": "TM", "Value": ["095212.295000"]}, "685": {"vr": "TM", "Value": ["094559.475000"]}, "686": {"vr": "TM", "Value": ["094902.207500"]}, "687": {"vr": "TM", "Value": ["095137.680000"]}, "688": {"vr": "TM", "Value": ["094935.357500"]}, "689": {"vr": "TM", "Value": ["094520.012500"]}, "690": {"vr": "TM", "Value": ["094956.930000"]}, "691": {"vr": "TM", "Value": ["094533.660000"]}, "692": {"vr": "TM", "Value": ["094541.437500"]}, "693": {"vr": "TM", "Value": ["094546.120000"]}, "694": {"vr": "TM", "Value": ["094928.460000"]}, "695": {"vr": "TM", "Value": ["094557.845000"]}, "696": {"vr": "TM", "Value": ["095223.875000"]}, "697": {"vr": "TM", "Value": ["094908.080000"]}, "698": {"vr": "TM", "Value": ["095058.382500"]}, "699": {"vr": "TM", "Value": ["094827.737500"]}, "700": {"vr": "TM", "Value": ["094553.895000"]}, "701": {"vr": "TM", "Value": ["095224.607500"]}, "702": {"vr": "TM", "Value": ["094534.392500"]}, "703": {"vr": "TM", "Value": ["095250.422500"]}, "704": {"vr": "TM", "Value": ["094757.095000"]}, "705": {"vr": "TM", "Value": ["094808.530000"]}, "706": {"vr": "TM", "Value": ["095107.182500"]}, "707": {"vr": "TM", "Value": ["094649.182500"]}, "708": {"vr": "TM", "Value": ["094833.027500"]}, "709": {"vr": "TM", "Value": ["095239.427500"]}, "710": {"vr": "TM", "Value": ["095259.515000"]}, "711": {"vr": "TM", "Value": ["095207.007500"]}, "712": {"vr": "TM", "Value": ["094518.255000"]}, "713": {"vr": "TM", "Value": ["095042.100000"]}, "714": {"vr": "TM", "Value": ["094821.885000"]}, "715": {"vr": "TM", "Value": ["095135.047500"]}, "716": {"vr": "TM", "Value": ["095202.032500"]}, "717": {"vr": "TM", "Value": ["095305.242500"]}, "718": {"vr": "TM", "Value": ["095350.120000"]}, "719": {"vr": "TM", "Value": ["094944.157500"]}, "720": {"vr": "TM", "Value": ["094606.207500"]}, "721": {"vr": "TM", "Value": ["095057.337500"]}, "722": {"vr": "TM", "Value": ["094633.945000"]}, "723": {"vr": "TM", "Value": ["095428.685000"]}, "724": {"vr": "TM", "Value": ["095232.822500"]}, "725": {"vr": "TM", "Value": ["094529.835000"]}, "726": {"vr": "TM", "Value": ["095405.232500"]}, "727": {"vr": "TM", "Value": ["095347.485000"]}, "728": {"vr": "TM", "Value": ["094526.177500"]}, "729": {"vr": "TM", "Value": ["095405.817500"]}, "730": {"vr": "TM", "Value": ["095007.485000"]}, "731": {"vr": "TM", "Value": ["094856.940000"]}, "732": {"vr": "TM", "Value": ["094645.085000"]}, "733": {"vr": "TM", "Value": ["095424.295000"]}, "734": {"vr": "TM", "Value": ["094545.972500"]}, "735": {"vr": "TM", "Value": ["094853.700000"]}, "736": {"vr": "TM", "Value": ["094720.577500"]}, "737": {"vr": "TM", "Value": ["094612.812500"]}, "738": {"vr": "TM", "Value": ["095254.685000"]}, "739": {"vr": "TM", "Value": ["094514.890000"]}, "740": {"vr": "TM", "Value": ["094640.822500"]}, "741": {"vr": "TM", "Value": ["094551.260000"]}, "742": {"vr": "TM", "Value": ["094659.007500"]}, "743": {"vr": "TM", "Value": ["095324.745000"]}, "744": {"vr": "TM", "Value": ["095055.582500"]}, "745": {"vr": "TM", "Value": ["094653.007500"]}, "746": {"vr": "TM", "Value": ["094656.812500"]}, "747": {"vr": "TM", "Value": ["095040.490000"]}, "748": {"vr": "TM", "Value": ["095130.050000"]}, "749": {"vr": "TM", "Value": ["095151.767500"]}, "750": {"vr": "TM", "Value": ["095438.822500"]}, "751": {"vr": "TM", "Value": ["094759.290000"]}, "752": {"vr": "TM", "Value": ["095234.137500"]}, "753": {"vr": "TM", "Value": ["094610.470000"]}, "754": {"vr": "TM", "Value": ["095155.427500"]}, "755": {"vr": "TM", "Value": ["094939.330000"]}, "756": {"vr": "TM", "Value": ["094818.792500"]}, "757": {"vr": "TM", "Value": ["095451.572500"]}, "758": {"vr": "TM", "Value": ["094745.367500"]}, "759": {"vr": "TM", "Value": ["094543.337500"]}, "760": {"vr": "TM", "Value": ["094723.505000"]}, "761": {"vr": "TM", "Value": ["094744.030000"]}, "762": {"vr": "TM", "Value": ["095427.515000"]}, "763": {"vr": "TM", "Value": ["095130.197500"]}, "764": {"vr": "TM", "Value": ["094949.007500"]}, "765": {"vr": "TM", "Value": ["094707.807500"]}, "766": {"vr": "TM", "Value": ["094712.802500"]}, "767": {"vr": "TM", "Value": ["095320.647500"]}, "768": {"vr": "TM", "Value": ["095036.372500"]}, "769": {"vr": "TM", "Value": ["095221.095000"]}, "770": {"vr": "TM", "Value": ["094817.182500"]}, "771": {"vr": "TM", "Value": ["095452.597500"]}, "772": {"vr": "TM", "Value": ["094855.475000"]}, "773": {"vr": "TM", "Value": ["095405.085000"]}, "774": {"vr": "TM", "Value": ["094740.812500"]}, "775": {"vr": "TM", "Value": ["094709.145000"]}, "776": {"vr": "TM", "Value": ["094842.265000"]}, "777": {"vr": "TM", "Value": ["094959.710000"]}, "778": {"vr": "TM", "Value": ["095433.387500"]}, "779": {"vr": "TM", "Value": ["094539.807500"]}, "780": {"vr": "TM", "Value": ["095044.002500"]}, "781": {"vr": "TM", "Value": ["094851.942500"]}, "782": {"vr": "TM", "Value": ["095407.720000"]}, "783": {"vr": "TM", "Value": ["095203.055000"]}, "784": {"vr": "TM", "Value": ["094521.767500"]}, "785": {"vr": "TM", "Value": ["095149.260000"]}, "786": {"vr": "TM", "Value": ["095041.222500"]}, "787": {"vr": "TM", "Value": ["094655.787500"]}, "788": {"vr": "TM", "Value": ["095313.162500"]}, "789": {"vr": "TM", "Value": ["094809.845000"]}, "790": {"vr": "TM", "Value": ["095357.895000"]}, "791": {"vr": "TM", "Value": ["095315.505000"]}, "792": {"vr": "TM", "Value": ["094547.875000"]}, "793": {"vr": "TM", "Value": ["095151.915000"]}, "794": {"vr": "TM", "Value": ["094809.260000"]}, "795": {"vr": "TM", "Value": ["094901.035000"]}, "796": {"vr": "TM", "Value": ["094742.127500"]}, "797": {"vr": "TM", "Value": ["095100.725000"]}, "798": {"vr": "TM", "Value": ["095156.890000"]}, "799": {"vr": "TM", "Value": ["094536.732500"]}, "800": {"vr": "TM", "Value": ["094625.582500"]}, "801": {"vr": "TM", "Value": ["094515.037500"]}, "802": {"vr": "TM", "Value": ["094612.372500"]}, "803": {"vr": "TM", "Value": ["095236.647500"]}, "804": {"vr": "TM", "Value": ["095231.797500"]}, "805": {"vr": "TM", "Value": ["094759.875000"]}, "806": {"vr": "TM", "Value": ["095102.187500"]}, "807": {"vr": "TM", "Value": ["095219.047500"]}, "808": {"vr": "TM", "Value": ["094749.757500"]}, "809": {"vr": "TM", "Value": ["095019.212500"]}, "810": {"vr": "TM", "Value": ["095003.367500"]}, "811": {"vr": "TM", "Value": ["095201.300000"]}, "812": {"vr": "TM", "Value": ["094907.787500"]}, "813": {"vr": "TM", "Value": ["095027.720000"]}, "814": {"vr": "TM", "Value": ["095058.822500"]}, "815": {"vr": "TM", "Value": ["095426.782500"]}, "816": {"vr": "TM", "Value": ["095317.115000"]}, "817": {"vr": "TM", "Value": ["095435.730000"]}, "818": {"vr": "TM", "Value": ["095030.500000"]}, "819": {"vr": "TM", "Value": ["094925.095000"]}, "820": {"vr": "TM", "Value": ["095311.555000"]}, "821": {"vr": "TM", "Value": ["095309.192500"]}, "822": {"vr": "TM", "Value": ["094834.342500"]}, "823": {"vr": "TM", "Value": ["095114.792500"]}, "824": {"vr": "TM", "Value": ["095245.155000"]}, "825": {"vr": "TM", "Value": ["095108.352500"]}, "826": {"vr": "TM", "Value": ["094806.040000"]}, "827": {"vr": "TM", "Value": ["095449.670000"]}, "828": {"vr": "TM", "Value": ["094931.260000"]}, "829": {"vr": "TM", "Value": ["095135.192500"]}, "830": {"vr": "TM", "Value": ["094602.695000"]}, "831": {"vr": "TM", "Value": ["094812.792500"]}, "832": {"vr": "TM", "Value": ["094736.275000"]}, "833": {"vr": "TM", "Value": ["094629.680000"]}, "834": {"vr": "TM", "Value": ["094612.227500"]}, "835": {"vr": "TM", "Value": ["095440.140000"]}, "836": {"vr": "TM", "Value": ["094818.500000"]}, "837": {"vr": "TM", "Value": ["094613.542500"]}, "838": {"vr": "TM", "Value": ["094543.632500"]}, "839": {"vr": "TM", "Value": ["094714.412500"]}, "840": {"vr": "TM", "Value": ["095306.120000"]}, "841": {"vr": "TM", "Value": ["095142.090000"]}, "842": {"vr": "TM", "Value": ["094552.137500"]}, "843": {"vr": "TM", "Value": ["094954.567500"]}, "844": {"vr": "TM", "Value": ["094747.125000"]}, "845": {"vr": "TM", "Value": ["094536.002500"]}, "846": {"vr": "TM", "Value": ["095000.880000"]}, "847": {"vr": "TM", "Value": ["095156.012500"]}, "848": {"vr": "TM", "Value": ["094942.842500"]}, "849": {"vr": "TM", "Value": ["094615.152500"]}, "850": {"vr": "TM", "Value": ["095133.145000"]}, "851": {"vr": "TM", "Value": ["095027.572500"]}, "852": {"vr": "TM", "Value": ["095026.110000"]}, "853": {"vr": "TM", "Value": ["095214.197500"]}, "854": {"vr": "TM", "Value": ["094733.475000"]}, "855": {"vr": "TM", "Value": ["094719.845000"]}, "856": {"vr": "TM", "Value": ["094917.905000"]}, "857": {"vr": "TM", "Value": ["095105.552500"]}, "858": {"vr": "TM", "Value": ["094748.735000"]}, "859": {"vr": "TM", "Value": ["094602.110000"]}, "860": {"vr": "TM", "Value": ["094832.002500"]}, "861": {"vr": "TM", "Value": ["095447.182500"]}, "862": {"vr": "TM", "Value": ["095342.345000"]}, "863": {"vr": "TM", "Value": ["095122.130000"]}, "864": {"vr": "TM", "Value": ["095437.945000"]}, "865": {"vr": "TM", "Value": ["094849.602500"]}, "866": {"vr": "TM", "Value": ["095205.250000"]}, "867": {"vr": "TM", "Value": ["094648.157500"]}, "868": {"vr": "TM", "Value": ["095134.607500"]}, "869": {"vr": "TM", "Value": ["094655.202500"]}, "870": {"vr": "TM", "Value": ["094823.640000"]}, "871": {"vr": "TM", "Value": ["094920.245000"]}, "872": {"vr": "TM", "Value": ["094529.690000"]}, "873": {"vr": "TM", "Value": ["095333.982500"]}, "874": {"vr": "TM", "Value": ["095147.505000"]}, "875": {"vr": "TM", "Value": ["094513.700000"]}, "876": {"vr": "TM", "Value": ["094659.592500"]}, "877": {"vr": "TM", "Value": ["094604.157500"]}, "878": {"vr": "TM", "Value": ["095338.540000"]}, "879": {"vr": "TM", "Value": ["094534.100000"]}, "880": {"vr": "TM", "Value": ["094557.552500"]}, "881": {"vr": "TM", "Value": ["094706.782500"]}, "882": {"vr": "TM", "Value": ["094601.670000"]}, "883": {"vr": "TM", "Value": ["094700.782500"]}, "884": {"vr": "TM", "Value": ["095324.157500"]}, "885": {"vr": "TM", "Value": ["095454.645000"]}, "886": {"vr": "TM", "Value": ["094716.752500"]}, "887": {"vr": "TM", "Value": ["094944.742500"]}, "888": {"vr": "TM", "Value": ["094655.055000"]}, "889": {"vr": "TM", "Value": ["094550.237500"]}, "890": {"vr": "TM", "Value": ["094745.515000"]}, "891": {"vr": "TM", "Value": ["094956.177500"]}, "892": {"vr": "TM", "Value": ["095409.037500"]}, "893": {"vr": "TM", "Value": ["095037.837500"]}, "894": {"vr": "TM", "Value": ["094738.032500"]}, "895": {"vr": "TM", "Value": ["094947.982500"]}, "896": {"vr": "TM", "Value": ["094633.485000"]}, "897": {"vr": "TM", "Value": ["094948.422500"]}, "898": {"vr": "TM", "Value": ["095021.552500"]}, "899": {"vr": "TM", "Value": ["094847.845000"]}, "900": {"vr": "TM", "Value": ["094923.192500"]}, "901": {"vr": "TM", "Value": ["094605.915000"]}, "902": {"vr": "TM", "Value": ["095025.817500"]}, "903": {"vr": "TM", "Value": ["095445.115000"]}, "904": {"vr": "TM", "Value": ["094610.762500"]}, "905": {"vr": "TM", "Value": ["094724.235000"]}, "906": {"vr": "TM", "Value": ["094608.860000"]}, "907": {"vr": "TM", "Value": ["095156.157500"]}, "908": {"vr": "TM", "Value": ["094949.300000"]}, "909": {"vr": "TM", "Value": ["095434.412500"]}, "910": {"vr": "TM", "Value": ["095101.895000"]}, "911": {"vr": "TM", "Value": ["094856.792500"]}, "912": {"vr": "TM", "Value": ["095419.445000"]}, "913": {"vr": "TM", "Value": ["095106.577500"]}, "914": {"vr": "TM", "Value": ["094720.725000"]}, "915": {"vr": "TM", "Value": ["095036.665000"]}, "916": {"vr": "TM", "Value": ["095424.587500"]}, "917": {"vr": "TM", "Value": ["095141.945000"]}, "918": {"vr": "TM", "Value": ["095250.715000"]}, "919": {"vr": "TM", "Value": ["094510.480000"]}, "920": {"vr": "TM", "Value": ["094638.040000"]}, "921": {"vr": "TM", "Value": ["094755.045000"]}, "922": {"vr": "TM", "Value": ["095249.982500"]}, "923": {"vr": "TM", "Value": ["095225.632500"]}, "924": {"vr": "TM", "Value": ["094506.237500"]}, "925": {"vr": "TM", "Value": ["094543.485000"]}, "926": {"vr": "TM", "Value": ["095447.915000"]}, "927": {"vr": "TM", "Value": ["095154.695000"]}, "928": {"vr": "TM", "Value": ["095327.690000"]}, "929": {"vr": "TM", "Value": ["095027.280000"]}, "930": {"vr": "TM", "Value": ["094936.675000"]}, "931": {"vr": "TM", "Value": ["094955.737500"]}, "932": {"vr": "TM", "Value": ["095450.550000"]}, "933": {"vr": "TM", "Value": ["095108.792500"]}, "934": {"vr": "TM", "Value": ["094535.270000"]}, "935": {"vr": "TM", "Value": ["094920.100000"]}, "936": {"vr": "TM", "Value": ["095139.582500"]}, "937": {"vr": "TM", "Value": ["094918.930000"]}, "938": {"vr": "TM", "Value": ["095446.577500"]}, "939": {"vr": "TM", "Value": ["094851.505000"]}, "940": {"vr": "TM", "Value": ["095258.930000"]}, "941": {"vr": "TM", "Value": ["095256.295000"]}, "942": {"vr": "TM", "Value": ["094706.342500"]}, "943": {"vr": "TM", "Value": ["094919.075000"]}, "944": {"vr": "TM", "Value": ["095116.715000"]}, "945": {"vr": "TM", "Value": ["095401.407500"]}, "946": {"vr": "TM", "Value": ["095109.670000"]}, "947": {"vr": "TM", "Value": ["094905.007500"]}, "948": {"vr": "TM", "Value": ["095139.437500"]}, "949": {"vr": "TM", "Value": ["094812.060000"]}, "950": {"vr": "TM", "Value": ["095246.032500"]}, "951": {"vr": "TM", "Value": ["094904.422500"]}, "952": {"vr": "TM", "Value": ["094710.607500"]}, "953": {"vr": "TM", "Value": ["095020.090000"]}, "954": {"vr": "TM", "Value": ["095207.885000"]}, "955": {"vr": "TM", "Value": ["094559.622500"]}, "956": {"vr": "TM", "Value": ["095140.460000"]}, "957": {"vr": "TM", "Value": ["094901.182500"]}, "958": {"vr": "TM", "Value": ["095243.982500"]}, "959": {"vr": "TM", "Value": ["094810.890000"]}, "960": {"vr": "TM", "Value": ["094916.002500"]}, "961": {"vr": "TM", "Value": ["094959.270000"]}, "962": {"vr": "TM", "Value": ["095300.100000"]}, "963": {"vr": "TM", "Value": ["095157.622500"]}, "964": {"vr": "TM", "Value": ["094640.235000"]}, "965": {"vr": "TM", "Value": ["094737.885000"]}, "966": {"vr": "TM", "Value": ["094912.177500"]}, "967": {"vr": "TM", "Value": ["095354.090000"]}, "968": {"vr": "TM", "Value": ["094705.465000"]}, "969": {"vr": "TM", "Value": ["094708.537500"]}, "970": {"vr": "TM", "Value": ["094525.592500"]}, "971": {"vr": "TM", "Value": ["094715.727500"]}, "972": {"vr": "TM", "Value": ["095401.700000"]}, "973": {"vr": "TM", "Value": ["095322.550000"]}, "974": {"vr": "TM", "Value": ["095030.937500"]}, "975": {"vr": "TM", "Value": ["095125.222500"]}, "976": {"vr": "TM", "Value": ["094746.977500"]}, "977": {"vr": "TM", "Value": ["094936.382500"]}, "978": {"vr": "TM", "Value": ["095452.450000"]}, "979": {"vr": "TM", "Value": ["095143.700000"]}, "980": {"vr": "TM", "Value": ["095151.182500"]}, "981": {"vr": "TM", "Value": ["095335.740000"]}, "982": {"vr": "TM", "Value": ["094900.157500"]}, "983": {"vr": "TM", "Value": ["095140.315000"]}, "984": {"vr": "TM", "Value": ["095248.665000"]}, "985": {"vr": "TM", "Value": ["094936.235000"]}, "986": {"vr": "TM", "Value": ["094833.320000"]}, "987": {"vr": "TM", "Value": ["094526.032500"]}, "988": {"vr": "TM", "Value": ["095327.232500"]}, "989": {"vr": "TM", "Value": ["094912.345000"]}, "990": {"vr": "TM", "Value": ["094938.137500"]}, "991": {"vr": "TM", "Value": ["095400.822500"]}, "992": {"vr": "TM", "Value": ["094807.942500"]}, "993": {"vr": "TM", "Value": ["095418.130000"]}, "994": {"vr": "TM", "Value": ["094634.675000"]}, "995": {"vr": "TM", "Value": ["095259.367500"]}, "996": {"vr": "TM", "Value": ["095446.890000"]}, "997": {"vr": "TM", "Value": ["095212.442500"]}, "998": {"vr": "TM", "Value": ["095246.910000"]}, "999": {"vr": "TM", "Value": ["095426.345000"]}, "1000": {"vr": "TM", "Value": ["094948.130000"]}, "1001": {"vr": "TM", "Value": ["095427.075000"]}, "1002": {"vr": "TM", "Value": ["094553.162500"]}, "1003": {"vr": "TM", "Value": ["094729.377500"]}, "1004": {"vr": "TM", "Value": ["095335.592500"]}, "1005": {"vr": "TM", "Value": ["095146.920000"]}, "1006": {"vr": "TM", "Value": ["095217.730000"]}, "1007": {"vr": "TM", "Value": ["094710.315000"]}, "1008": {"vr": "TM", "Value": ["094610.910000"]}, "1009": {"vr": "TM", "Value": ["094717.192500"]}, "1010": {"vr": "TM", "Value": ["095330.617500"]}, "1011": {"vr": "TM", "Value": ["095441.457500"]}, "1012": {"vr": "TM", "Value": ["095209.222500"]}, "1013": {"vr": "TM", "Value": ["095218.022500"]}, "1014": {"vr": "TM", "Value": ["095144.432500"]}, "1015": {"vr": "TM", "Value": ["095453.330000"]}, "1016": {"vr": "TM", "Value": ["094825.982500"]}, "1017": {"vr": "TM", "Value": ["095429.730000"]}, "1018": {"vr": "TM", "Value": ["094748.295000"]}, "1019": {"vr": "TM", "Value": ["095342.490000"]}, "1020": {"vr": "TM", "Value": ["095202.617500"]}, "1021": {"vr": "TM", "Value": ["095417.545000"]}, "1022": {"vr": "TM", "Value": ["094837.730000"]}, "1023": {"vr": "TM", "Value": ["094903.837500"]}, "1024": {"vr": "TM", "Value": ["095211.710000"]}, "1025": {"vr": "TM", "Value": ["094535.125000"]}, "1026": {"vr": "TM", "Value": ["094542.607500"]}, "1027": {"vr": "TM", "Value": ["095203.787500"]}, "1028": {"vr": "TM", "Value": ["095332.812500"]}, "1029": {"vr": "TM", "Value": ["095044.147500"]}, "1030": {"vr": "TM", "Value": ["094513.407500"]}, "1031": {"vr": "TM", "Value": ["094631.727500"]}, "1032": {"vr": "TM", "Value": ["094821.152500"]}, "1033": {"vr": "TM", "Value": ["094927.435000"]}, "1034": {"vr": "TM", "Value": ["094640.675000"]}, "1035": {"vr": "TM", "Value": ["095350.557500"]}, "1036": {"vr": "TM", "Value": ["094841.387500"]}, "1037": {"vr": "TM", "Value": ["095054.412500"]}, "1038": {"vr": "TM", "Value": ["094624.685000"]}, "1039": {"vr": "TM", "Value": ["094826.567500"]}, "1040": {"vr": "TM", "Value": ["094812.207500"]}, "1041": {"vr": "TM", "Value": ["095202.325000"]}, "1042": {"vr": "TM", "Value": ["094814.255000"]}, "1043": {"vr": "TM", "Value": ["095014.967500"]}, "1044": {"vr": "TM", "Value": ["094757.387500"]}, "1045": {"vr": "TM", "Value": ["094552.725000"]}, "1046": {"vr": "TM", "Value": ["095057.630000"]}, "1047": {"vr": "TM", "Value": ["095403.767500"]}, "1048": {"vr": "TM", "Value": ["095415.787500"]}, "1049": {"vr": "TM", "Value": ["094535.417500"]}, "1050": {"vr": "TM", "Value": ["095035.787500"]}, "1051": {"vr": "TM", "Value": ["094946.937500"]}, "1052": {"vr": "TM", "Value": ["094631.435000"]}, "1053": {"vr": "TM", "Value": ["095057.945000"]}, "1054": {"vr": "TM", "Value": ["094623.367500"]}, "1055": {"vr": "TM", "Value": ["094829.807500"]}, "1056": {"vr": "TM", "Value": ["095258.490000"]}, "1057": {"vr": "TM", "Value": ["095411.545000"]}, "1058": {"vr": "TM", "Value": ["095212.587500"]}, "1059": {"vr": "TM", "Value": ["094855.767500"]}, "1060": {"vr": "TM", "Value": ["094512.382500"]}, "1061": {"vr": "TM", "Value": ["094541.582500"]}, "1062": {"vr": "TM", "Value": ["094719.407500"]}, "1063": {"vr": "TM", "Value": ["094832.880000"]}, "1064": {"vr": "TM", "Value": ["094724.382500"]}, "1065": {"vr": "TM", "Value": ["094826.715000"]}, "1066": {"vr": "TM", "Value": ["094847.115000"]}, "1067": {"vr": "TM", "Value": ["095200.130000"]}, "1068": {"vr": "TM", "Value": ["095306.412500"]}, "1069": {"vr": "TM", "Value": ["095046.490000"]}, "1070": {"vr": "TM", "Value": ["094709.582500"]}, "1071": {"vr": "TM", "Value": ["095255.562500"]}, "1072": {"vr": "TM", "Value": ["095204.665000"]}, "1073": {"vr": "TM", "Value": ["095450.695000"]}, "1074": {"vr": "TM", "Value": ["095445.552500"]}, "1075": {"vr": "TM", "Value": ["094635.115000"]}, "1076": {"vr": "TM", "Value": ["095049.437500"]}, "1077": {"vr": "TM", "Value": ["095226.090000"]}, "1078": {"vr": "TM", "Value": ["094708.830000"]}, "1079": {"vr": "TM", "Value": ["095300.977500"]}, "1080": {"vr": "TM", "Value": ["094815.280000"]}, "1081": {"vr": "TM", "Value": ["094644.940000"]}, "1082": {"vr": "TM", "Value": ["095203.202500"]}, "1083": {"vr": "TM", "Value": ["095205.542500"]}, "1084": {"vr": "TM", "Value": ["094611.932500"]}, "1085": {"vr": "TM", "Value": ["095257.757500"]}, "1086": {"vr": "TM", "Value": ["095159.982500"]}, "1087": {"vr": "TM", "Value": ["095201.885000"]}, "1088": {"vr": "TM", "Value": ["095317.700000"]}, "1089": {"vr": "TM", "Value": ["095149.700000"]}, "1090": {"vr": "TM", "Value": ["094957.807500"]}, "1091": {"vr": "TM", "Value": ["094827.592500"]}, "1092": {"vr": "TM", "Value": ["095145.310000"]}, "1093": {"vr": "TM", "Value": ["094616.490000"]}, "1094": {"vr": "TM", "Value": ["095427.807500"]}, "1095": {"vr": "TM", "Value": ["095213.905000"]}, "1096": {"vr": "TM", "Value": ["095107.475000"]}, "1097": {"vr": "TM", "Value": ["094825.835000"]}, "1098": {"vr": "TM", "Value": ["095327.085000"]}, "1099": {"vr": "TM", "Value": ["095124.345000"]}, "1100": {"vr": "TM", "Value": ["094944.450000"]}, "1101": {"vr": "TM", "Value": ["095120.080000"]}, "1102": {"vr": "TM", "Value": ["095111.865000"]}, "1103": {"vr": "TM", "Value": ["095302.755000"]}, "1104": {"vr": "TM", "Value": ["094631.290000"]}, "1105": {"vr": "TM", "Value": ["095134.460000"]}, "1106": {"vr": "TM", "Value": ["094632.752500"]}, "1107": {"vr": "TM", "Value": ["094950.032500"]}, "1108": {"vr": "TM", "Value": ["094727.330000"]}, "1109": {"vr": "TM", "Value": ["095421.807500"]}, "1110": {"vr": "TM", "Value": ["095309.945000"]}, "1111": {"vr": "TM", "Value": ["094756.510000"]}, "1112": {"vr": "TM", "Value": ["094714.120000"]}, "1113": {"vr": "TM", "Value": ["095149.992500"]}, "1114": {"vr": "TM", "Value": ["094946.207500"]}, "1115": {"vr": "TM", "Value": ["095411.690000"]}, "1116": {"vr": "TM", "Value": ["094521.620000"]}, "1117": {"vr": "TM", "Value": ["095231.505000"]}, "1118": {"vr": "TM", "Value": ["094711.340000"]}, "1119": {"vr": "TM", "Value": ["095410.352500"]}, "1120": {"vr": "TM", "Value": ["095425.172500"]}, "1121": {"vr": "TM", "Value": ["094938.577500"]}, "1122": {"vr": "TM", "Value": ["094708.392500"]}, "1123": {"vr": "TM", "Value": ["094608.130000"]}, "1124": {"vr": "TM", "Value": ["094929.337500"]}, "1125": {"vr": "TM", "Value": ["094909.250000"]}, "1126": {"vr": "TM", "Value": ["095444.090000"]}, "1127": {"vr": "TM", "Value": ["094638.772500"]}, "1128": {"vr": "TM", "Value": ["095117.155000"]}, "1129": {"vr": "TM", "Value": ["094838.607500"]}, "1130": {"vr": "TM", "Value": ["095421.955000"]}, "1131": {"vr": "TM", "Value": ["094650.792500"]}, "1132": {"vr": "TM", "Value": ["094639.942500"]}, "1133": {"vr": "TM", "Value": ["095052.655000"]}, "1134": {"vr": "TM", "Value": ["095208.345000"]}, "1135": {"vr": "TM", "Value": ["094913.222500"]}, "1136": {"vr": "TM", "Value": ["094824.812500"]}, "1137": {"vr": "TM", "Value": ["095247.787500"]}, "1138": {"vr": "TM", "Value": ["094630.705000"]}, "1139": {"vr": "TM", "Value": ["095008.070000"]}, "1140": {"vr": "TM", "Value": ["094548.752500"]}, "1141": {"vr": "TM", "Value": ["094853.552500"]}, "1142": {"vr": "TM", "Value": ["094606.645000"]}, "1143": {"vr": "TM", "Value": ["094630.412500"]}, "1144": {"vr": "TM", "Value": ["094727.182500"]}, "1145": {"vr": "TM", "Value": ["094954.275000"]}, "1146": {"vr": "TM", "Value": ["094807.065000"]}, "1147": {"vr": "TM", "Value": ["095452.157500"]}, "1148": {"vr": "TM", "Value": ["094649.327500"]}, "1149": {"vr": "TM", "Value": ["094508.577500"]}, "1150": {"vr": "TM", "Value": ["095433.242500"]}, "1151": {"vr": "TM", "Value": ["094921.145000"]}, "1152": {"vr": "TM", "Value": ["095030.352500"]}, "1153": {"vr": "TM", "Value": ["094953.690000"]}, "1154": {"vr": "TM", "Value": ["095046.930000"]}, "1155": {"vr": "TM", "Value": ["095032.715000"]}, "1156": {"vr": "TM", "Value": ["094639.357500"]}, "1157": {"vr": "TM", "Value": ["094529.542500"]}, "1158": {"vr": "TM", "Value": ["095244.567500"]}, "1159": {"vr": "TM", "Value": ["094950.325000"]}, "1160": {"vr": "TM", "Value": ["095054.705000"]}, "1161": {"vr": "TM", "Value": ["094653.740000"]}, "1162": {"vr": "TM", "Value": ["095119.935000"]}, "1163": {"vr": "TM", "Value": ["095114.937500"]}, "1164": {"vr": "TM", "Value": ["094916.147500"]}, "1165": {"vr": "TM", "Value": ["095316.090000"]}, "1166": {"vr": "TM", "Value": ["094512.675000"]}, "1167": {"vr": "TM", "Value": ["095220.510000"]}, "1168": {"vr": "TM", "Value": ["094558.137500"]}, "1169": {"vr": "TM", "Value": ["095257.465000"]}, "1170": {"vr": "TM", "Value": ["095322.402500"]}, "1171": {"vr": "TM", "Value": ["094621.172500"]}, "1172": {"vr": "TM", "Value": ["095144.725000"]}, "1173": {"vr": "TM", "Value": ["095404.940000"]}, "1174": {"vr": "TM", "Value": ["095147.212500"]}, "1175": {"vr": "TM", "Value": ["095235.182500"]}, "1176": {"vr": "TM", "Value": ["095228.285000"]}, "1177": {"vr": "TM", "Value": ["095331.055000"]}, "1178": {"vr": "TM", "Value": ["094514.137500"]}, "1179": {"vr": "TM", "Value": ["094729.232500"]}, "1180": {"vr": "TM", "Value": ["094854.285000"]}, "1181": {"vr": "TM", "Value": ["094836.830000"]}, "1182": {"vr": "TM", "Value": ["094544.947500"]}, "1183": {"vr": "TM", "Value": ["095020.382500"]}, "1184": {"vr": "TM", "Value": ["095255.417500"]}, "1185": {"vr": "TM", "Value": ["094858.255000"]}, "1186": {"vr": "TM", "Value": ["094532.782500"]}, "1187": {"vr": "TM", "Value": ["094937.845000"]}, "1188": {"vr": "TM", "Value": ["095241.037500"]}, "1189": {"vr": "TM", "Value": ["095311.847500"]}, "1190": {"vr": "TM", "Value": ["095358.772500"]}, "1191": {"vr": "TM", "Value": ["094512.090000"]}, "1192": {"vr": "TM", "Value": ["094654.762500"]}, "1193": {"vr": "TM", "Value": ["095001.027500"]}, "1194": {"vr": "TM", "Value": ["095443.065000"]}, "1195": {"vr": "TM", "Value": ["094914.100000"]}, "1196": {"vr": "TM", "Value": ["094531.592500"]}, "1197": {"vr": "TM", "Value": ["095410.060000"]}, "1198": {"vr": "TM", "Value": ["094828.637500"]}, "1199": {"vr": "TM", "Value": ["095201.740000"]}, "1200": {"vr": "TM", "Value": ["095302.900000"]}, "1201": {"vr": "TM", "Value": ["094509.895000"]}, "1202": {"vr": "TM", "Value": ["094646.840000"]}, "1203": {"vr": "TM", "Value": ["095434.120000"]}, "1204": {"vr": "TM", "Value": ["095223.582500"]}, "1205": {"vr": "TM", "Value": ["095045.172500"]}, "1206": {"vr": "TM", "Value": ["095325.182500"]}, "1207": {"vr": "TM", "Value": ["095115.232500"]}, "1208": {"vr": "TM", "Value": ["094526.762500"]}, "1209": {"vr": "TM", "Value": ["094545.095000"]}, "1210": {"vr": "TM", "Value": ["095028.157500"]}, "1211": {"vr": "TM", "Value": ["095430.607500"]}, "1212": {"vr": "TM", "Value": ["094725.407500"]}, "1213": {"vr": "TM", "Value": ["095012.022500"]}, "1214": {"vr": "TM", "Value": ["095353.340000"]}, "1215": {"vr": "TM", "Value": ["095037.690000"]}, "1216": {"vr": "TM", "Value": ["095203.642500"]}, "1217": {"vr": "TM", "Value": ["095221.827500"]}, "1218": {"vr": "TM", "Value": ["094523.542500"]}, "1219": {"vr": "TM", "Value": ["095312.140000"]}, "1220": {"vr": "TM", "Value": ["095316.822500"]}, "1221": {"vr": "TM", "Value": ["095413.447500"]}, "1222": {"vr": "TM", "Value": ["094705.757500"]}, "1223": {"vr": "TM", "Value": ["095349.535000"]}, "1224": {"vr": "TM", "Value": ["094844.900000"]}, "1225": {"vr": "TM", "Value": ["094533.952500"]}, "1226": {"vr": "TM", "Value": ["094524.275000"]}, "1227": {"vr": "TM", "Value": ["095416.227500"]}, "1228": {"vr": "TM", "Value": ["095412.130000"]}, "1229": {"vr": "TM", "Value": ["095146.772500"]}, "1230": {"vr": "TM", "Value": ["095121.982500"]}, "1231": {"vr": "TM", "Value": ["095336.345000"]}, "1232": {"vr": "TM", "Value": ["095406.402500"]}, "1233": {"vr": "TM", "Value": ["094733.327500"]}, "1234": {"vr": "TM", "Value": ["094627.045000"]}, "1235": {"vr": "TM", "Value": ["094813.817500"]}, "1236": {"vr": "TM", "Value": ["094531.445000"]}, "1237": {"vr": "TM", "Value": ["095438.530000"]}, "1238": {"vr": "TM", "Value": ["094813.377500"]}, "1239": {"vr": "TM", "Value": ["094651.690000"]}, "1240": {"vr": "TM", "Value": ["094704.002500"]}, "1241": {"vr": "TM", "Value": ["094518.695000"]}, "1242": {"vr": "TM", "Value": ["095147.942500"]}, "1243": {"vr": "TM", "Value": ["095236.207500"]}, "1244": {"vr": "TM", "Value": ["095037.105000"]}, "1245": {"vr": "TM", "Value": ["094847.260000"]}, "1246": {"vr": "TM", "Value": ["095235.767500"]}, "1247": {"vr": "TM", "Value": ["094729.670000"]}, "1248": {"vr": "TM", "Value": ["094951.055000"]}, "1249": {"vr": "TM", "Value": ["095336.490000"]}, "1250": {"vr": "TM", "Value": ["094545.532500"]}, "1251": {"vr": "TM", "Value": ["095126.100000"]}, "1252": {"vr": "TM", "Value": ["094950.617500"]}, "1253": {"vr": "TM", "Value": ["095324.450000"]}, "1254": {"vr": "TM", "Value": ["094829.075000"]}, "1255": {"vr": "TM", "Value": ["094842.557500"]}, "1256": {"vr": "TM", "Value": ["095208.490000"]}, "1257": {"vr": "TM", "Value": ["094522.060000"]}, "1258": {"vr": "TM", "Value": ["094601.525000"]}, "1259": {"vr": "TM", "Value": ["095246.762500"]}, "1260": {"vr": "TM", "Value": ["095133.582500"]}, "1261": {"vr": "TM", "Value": ["094633.777500"]}, "1262": {"vr": "TM", "Value": ["094728.207500"]}, "1263": {"vr": "TM", "Value": ["095144.577500"]}, "1264": {"vr": "TM", "Value": ["094649.622500"]}, "1265": {"vr": "TM", "Value": ["094709.875000"]}, "1266": {"vr": "TM", "Value": ["094750.050000"]}, "1267": {"vr": "TM", "Value": ["095034.762500"]}, "1268": {"vr": "TM", "Value": ["094947.690000"]}, "1269": {"vr": "TM", "Value": ["094558.577500"]}, "1270": {"vr": "TM", "Value": ["094623.222500"]}, "1271": {"vr": "TM", "Value": ["095451.720000"]}, "1272": {"vr": "TM", "Value": ["094921.290000"]}, "1273": {"vr": "TM", "Value": ["094713.240000"]}, "1274": {"vr": "TM", "Value": ["095153.085000"]}, "1275": {"vr": "TM", "Value": ["095248.520000"]}, "1276": {"vr": "TM", "Value": ["095357.455000"]}, "1277": {"vr": "TM", "Value": ["095414.470000"]}, "1278": {"vr": "TM", "Value": ["094912.930000"]}, "1279": {"vr": "TM", "Value": ["094853.845000"]}, "1280": {"vr": "TM", "Value": ["094554.627500"]}, "1281": {"vr": "TM", "Value": ["095157.330000"]}, "1282": {"vr": "TM", "Value": ["094651.085000"]}, "1283": {"vr": "TM", "Value": ["095154.842500"]}, "1284": {"vr": "TM", "Value": ["095205.837500"]}, "1285": {"vr": "TM", "Value": ["094859.865000"]}, "1286": {"vr": "TM", "Value": ["094854.577500"]}, "1287": {"vr": "TM", "Value": ["094904.275000"]}, "1288": {"vr": "TM", "Value": ["094804.285000"]}, "1289": {"vr": "TM", "Value": ["095231.212500"]}, "1290": {"vr": "TM", "Value": ["094755.192500"]}, "1291": {"vr": "TM", "Value": ["094510.040000"]}, "1292": {"vr": "TM", "Value": ["094917.465000"]}, "1293": {"vr": "TM", "Value": ["095006.607500"]}, "1294": {"vr": "TM", "Value": ["095330.470000"]}, "1295": {"vr": "TM", "Value": ["094924.655000"]}, "1296": {"vr": "TM", "Value": ["094711.192500"]}, "1297": {"vr": "TM", "Value": ["094704.295000"]}, "1298": {"vr": "TM", "Value": ["094520.890000"]}, "1299": {"vr": "TM", "Value": ["094620.587500"]}, "1300": {"vr": "TM", "Value": ["094959.562500"]}, "1301": {"vr": "TM", "Value": ["094940.207500"]}, "1302": {"vr": "TM", "Value": ["094523.837500"]}, "1303": {"vr": "TM", "Value": ["095349.972500"]}, "1304": {"vr": "TM", "Value": ["094909.982500"]}, "1305": {"vr": "TM", "Value": ["094951.935000"]}, "1306": {"vr": "TM", "Value": ["094546.412500"]}, "1307": {"vr": "TM", "Value": ["095303.340000"]}, "1308": {"vr": "TM", "Value": ["094623.515000"]}, "1309": {"vr": "TM", "Value": ["094643.182500"]}, "1310": {"vr": "TM", "Value": ["094521.915000"]}, "1311": {"vr": "TM", "Value": ["094941.085000"]}, "1312": {"vr": "TM", "Value": ["095403.037500"]}, "1313": {"vr": "TM", "Value": ["094926.997500"]}, "1314": {"vr": "TM", "Value": ["094723.212500"]}, "1315": {"vr": "TM", "Value": ["094522.645000"]}, "1316": {"vr": "TM", "Value": ["095025.525000"]}, "1317": {"vr": "TM", "Value": ["094848.725000"]}, "1318": {"vr": "TM", "Value": ["094550.530000"]}, "1319": {"vr": "TM", "Value": ["094627.337500"]}, "1320": {"vr": "TM", "Value": ["095242.500000"]}, "1321": {"vr": "TM", "Value": ["094941.525000"]}, "1322": {"vr": "TM", "Value": ["094607.085000"]}, "1323": {"vr": "TM", "Value": ["094741.982500"]}, "1324": {"vr": "TM", "Value": ["094820.860000"]}, "1325": {"vr": "TM", "Value": ["094529.250000"]}, "1326": {"vr": "TM", "Value": ["094819.837500"]}, "1327": {"vr": "TM", "Value": ["095359.945000"]}, "1328": {"vr": "TM", "Value": ["094714.997500"]}, "1329": {"vr": "TM", "Value": ["095144.285000"]}, "1330": {"vr": "TM", "Value": ["095451.280000"]}, "1331": {"vr": "TM", "Value": ["094910.275000"]}, "1332": {"vr": "TM", "Value": ["095342.637500"]}, "1333": {"vr": "TM", "Value": ["095317.845000"]}, "1334": {"vr": "TM", "Value": ["095231.942500"]}, "1335": {"vr": "TM", "Value": ["094744.637500"]}, "1336": {"vr": "TM", "Value": ["095011.142500"]}, "1337": {"vr": "TM", "Value": ["094719.115000"]}, "1338": {"vr": "TM", "Value": ["094840.362500"]}, "1339": {"vr": "TM", "Value": ["095216.537500"]}, "1340": {"vr": "TM", "Value": ["094557.260000"]}, "1341": {"vr": "TM", "Value": ["095408.890000"]}, "1342": {"vr": "TM", "Value": ["094609.152500"]}, "1343": {"vr": "TM", "Value": ["095240.450000"]}, "1344": {"vr": "TM", "Value": ["094714.850000"]}, "1345": {"vr": "TM", "Value": ["094717.045000"]}, "1346": {"vr": "TM", "Value": ["094615.592500"]}, "1347": {"vr": "TM", "Value": ["094513.115000"]}, "1348": {"vr": "TM", "Value": ["095121.690000"]}, "1349": {"vr": "TM", "Value": ["094615.737500"]}, "1350": {"vr": "TM", "Value": ["095120.372500"]}, "1351": {"vr": "TM", "Value": ["094547.435000"]}, "1352": {"vr": "TM", "Value": ["094953.835000"]}, "1353": {"vr": "TM", "Value": ["095238.842500"]}, "1354": {"vr": "TM", "Value": ["095416.372500"]}, "1355": {"vr": "TM", "Value": ["094812.500000"]}, "1356": {"vr": "TM", "Value": ["094935.650000"]}, "1357": {"vr": "TM", "Value": ["095024.940000"]}, "1358": {"vr": "TM", "Value": ["094647.132500"]}, "1359": {"vr": "TM", "Value": ["095352.022500"]}, "1360": {"vr": "TM", "Value": ["095352.167500"]}, "1361": {"vr": "TM", "Value": ["094601.085000"]}, "1362": {"vr": "TM", "Value": ["094516.792500"]}, "1363": {"vr": "TM", "Value": ["094701.367500"]}, "1364": {"vr": "TM", "Value": ["094722.187500"]}, "1365": {"vr": "TM", "Value": ["095032.130000"]}, "1366": {"vr": "TM", "Value": ["094838.752500"]}, "1367": {"vr": "TM", "Value": ["094551.992500"]}, "1368": {"vr": "TM", "Value": ["094805.895000"]}, "1369": {"vr": "TM", "Value": ["094831.125000"]}, "1370": {"vr": "TM", "Value": ["094941.817500"]}, "1371": {"vr": "TM", "Value": ["094620.147500"]}, "1372": {"vr": "TM", "Value": ["094555.212500"]}, "1373": {"vr": "TM", "Value": ["095207.152500"]}, "1374": {"vr": "TM", "Value": ["095014.675000"]}, "1375": {"vr": "TM", "Value": ["094825.250000"]}, "1376": {"vr": "TM", "Value": ["094621.465000"]}, "1377": {"vr": "TM", "Value": ["094630.557500"]}, "1378": {"vr": "TM", "Value": ["095426.930000"]}, "1379": {"vr": "TM", "Value": ["095435.875000"]}, "1380": {"vr": "TM", "Value": ["095040.930000"]}, "1381": {"vr": "TM", "Value": ["095313.750000"]}, "1382": {"vr": "TM", "Value": ["095320.500000"]}, "1383": {"vr": "TM", "Value": ["094724.675000"]}, "1384": {"vr": "TM", "Value": ["094616.177500"]}, "1385": {"vr": "TM", "Value": ["094845.485000"]}, "1386": {"vr": "TM", "Value": ["095148.967500"]}, "1387": {"vr": "TM", "Value": ["094842.850000"]}, "1388": {"vr": "TM", "Value": ["095044.735000"]}, "1389": {"vr": "TM", "Value": ["094610.032500"]}, "1390": {"vr": "TM", "Value": ["094851.065000"]}, "1391": {"vr": "TM", "Value": ["094516.500000"]}, "1392": {"vr": "TM", "Value": ["095354.675000"]}, "1393": {"vr": "TM", "Value": ["094844.315000"]}, "1394": {"vr": "TM", "Value": ["095012.460000"]}, "1395": {"vr": "TM", "Value": ["094924.510000"]}, "1396": {"vr": "TM", "Value": ["095112.597500"]}, "1397": {"vr": "TM", "Value": ["094930.675000"]}, "1398": {"vr": "TM", "Value": ["094750.927500"]}, "1399": {"vr": "TM", "Value": ["094817.622500"]}, "1400": {"vr": "TM", "Value": ["095046.050000"]}, "1401": {"vr": "TM", "Value": ["094735.837500"]}, "1402": {"vr": "TM", "Value": ["095343.367500"]}, "1403": {"vr": "TM", "Value": ["094953.250000"]}, "1404": {"vr": "TM", "Value": ["094506.967500"]}, "1405": {"vr": "TM", "Value": ["094530.127500"]}, "1406": {"vr": "TM", "Value": ["094725.992500"]}, "1407": {"vr": "TM", "Value": ["094702.392500"]}, "1408": {"vr": "TM", "Value": ["094815.572500"]}, "1409": {"vr": "TM", "Value": ["094707.660000"]}, "1410": {"vr": "TM", "Value": ["095344.685000"]}, "1411": {"vr": "TM", "Value": ["094629.387500"]}, "1412": {"vr": "TM", "Value": ["095037.982500"]}, "1413": {"vr": "TM", "Value": ["095316.675000"]}, "1414": {"vr": "TM", "Value": ["095120.520000"]}, "1415": {"vr": "TM", "Value": ["094537.465000"]}, "1416": {"vr": "TM", "Value": ["094718.967500"]}, "1417": {"vr": "TM", "Value": ["094643.767500"]}, "1418": {"vr": "TM", "Value": ["095016.870000"]}, "1419": {"vr": "TM", "Value": ["095339.270000"]}, "1420": {"vr": "TM", "Value": ["095232.675000"]}, "1421": {"vr": "TM", "Value": ["094721.310000"]}, "1422": {"vr": "TM", "Value": ["095321.962500"]}, "1423": {"vr": "TM", "Value": ["094934.772500"]}, "1424": {"vr": "TM", "Value": ["095404.647500"]}, "1425": {"vr": "TM", "Value": ["094849.895000"]}, "1426": {"vr": "TM", "Value": ["095247.495000"]}, "1427": {"vr": "TM", "Value": ["095212.735000"]}, "1428": {"vr": "TM", "Value": ["094913.952500"]}, "1429": {"vr": "TM", "Value": ["095328.567500"]}, "1430": {"vr": "TM", "Value": ["095317.407500"]}, "1431": {"vr": "TM", "Value": ["095424.880000"]}, "1432": {"vr": "TM", "Value": ["094934.627500"]}, "1433": {"vr": "TM", "Value": ["095228.577500"]}, "1434": {"vr": "TM", "Value": ["095127.855000"]}, "1435": {"vr": "TM", "Value": ["095035.495000"]}, "1436": {"vr": "TM", "Value": ["095251.152500"]}, "1437": {"vr": "TM", "Value": ["095123.885000"]}, "1438": {"vr": "TM", "Value": ["094554.332500"]}, "1439": {"vr": "TM", "Value": ["095012.315000"]}, "1440": {"vr": "TM", "Value": ["095434.557500"]}, "1441": {"vr": "TM", "Value": ["095026.695000"]}, "1442": {"vr": "TM", "Value": ["094506.530000"]}, "1443": {"vr": "TM", "Value": ["095431.485000"]}, "1444": {"vr": "TM", "Value": ["095028.742500"]}, "1445": {"vr": "TM", "Value": ["095353.192500"]}, "1446": {"vr": "TM", "Value": ["095158.352500"]}, "1447": {"vr": "TM", "Value": ["094739.347500"]}, "1448": {"vr": "TM", "Value": ["094545.827500"]}, "1449": {"vr": "TM", "Value": ["094643.622500"]}, "1450": {"vr": "TM", "Value": ["094752.392500"]}, "1451": {"vr": "TM", "Value": ["094931.115000"]}, "1452": {"vr": "TM", "Value": ["094516.645000"]}, "1453": {"vr": "TM", "Value": ["095159.837500"]}, "1454": {"vr": "TM", "Value": ["095414.325000"]}, "1455": {"vr": "TM", "Value": ["095452.012500"]}, "1456": {"vr": "TM", "Value": ["095038.422500"]}, "1457": {"vr": "TM", "Value": ["094657.105000"]}, "1458": {"vr": "TM", "Value": ["095437.777500"]}, "1459": {"vr": "TM", "Value": ["094608.422500"]}, "1460": {"vr": "TM", "Value": ["095314.042500"]}, "1461": {"vr": "TM", "Value": ["094648.890000"]}, "1462": {"vr": "TM", "Value": ["094927.290000"]}, "1463": {"vr": "TM", "Value": ["094923.047500"]}, "1464": {"vr": "TM", "Value": ["095304.655000"]}, "1465": {"vr": "TM", "Value": ["095059.700000"]}, "1466": {"vr": "TM", "Value": ["094735.230000"]}, "1467": {"vr": "TM", "Value": ["094711.045000"]}, "1468": {"vr": "TM", "Value": ["095151.037500"]}, "1469": {"vr": "TM", "Value": ["095355.847500"]}, "1470": {"vr": "TM", "Value": ["095055.437500"]}, "1471": {"vr": "TM", "Value": ["095319.330000"]}, "1472": {"vr": "TM", "Value": ["094725.115000"]}, "1473": {"vr": "TM", "Value": ["094728.940000"]}, "1474": {"vr": "TM", "Value": ["095138.120000"]}, "1475": {"vr": "TM", "Value": ["095323.720000"]}, "1476": {"vr": "TM", "Value": ["094836.245000"]}, "1477": {"vr": "TM", "Value": ["094543.192500"]}, "1478": {"vr": "TM", "Value": ["094840.802500"]}, "1479": {"vr": "TM", "Value": ["095115.837500"]}, "1480": {"vr": "TM", "Value": ["095233.552500"]}, "1481": {"vr": "TM", "Value": ["095300.685000"]}, "1482": {"vr": "TM", "Value": ["095232.967500"]}, "1483": {"vr": "TM", "Value": ["095224.022500"]}, "1484": {"vr": "TM", "Value": ["095038.130000"]}, "1485": {"vr": "TM", "Value": ["094859.280000"]}, "1486": {"vr": "TM", "Value": ["094634.967500"]}, "1487": {"vr": "TM", "Value": ["095427.660000"]}, "1488": {"vr": "TM", "Value": ["095136.655000"]}, "1489": {"vr": "TM", "Value": ["094907.202500"]}, "1490": {"vr": "TM", "Value": ["095029.475000"]}, "1491": {"vr": "TM", "Value": ["094803.115000"]}, "1492": {"vr": "TM", "Value": ["095056.315000"]}, "1493": {"vr": "TM", "Value": ["094646.695000"]}, "1494": {"vr": "TM", "Value": ["095403.475000"]}, "1495": {"vr": "TM", "Value": ["095147.357500"]}, "1496": {"vr": "TM", "Value": ["095336.782500"]}, "1497": {"vr": "TM", "Value": ["094704.147500"]}, "1498": {"vr": "TM", "Value": ["094919.952500"]}, "1499": {"vr": "TM", "Value": ["095337.075000"]}, "1500": {"vr": "TM", "Value": ["095118.470000"]}, "1501": {"vr": "TM", "Value": ["094731.427500"]}, "1502": {"vr": "TM", "Value": ["095058.530000"]}, "1503": {"vr": "TM", "Value": ["095323.865000"]}, "1504": {"vr": "TM", "Value": ["095103.065000"]}, "1505": {"vr": "TM", "Value": ["094752.685000"]}, "1506": {"vr": "TM", "Value": ["094906.910000"]}, "1507": {"vr": "TM", "Value": ["094750.197500"]}, "1508": {"vr": "TM", "Value": ["094601.817500"]}, "1509": {"vr": "TM", "Value": ["094652.275000"]}, "1510": {"vr": "TM", "Value": ["095122.860000"]}, "1511": {"vr": "TM", "Value": ["095319.182500"]}, "1512": {"vr": "TM", "Value": ["095137.827500"]}, "1513": {"vr": "TM", "Value": ["094542.315000"]}, "1514": {"vr": "TM", "Value": ["094718.237500"]}, "1515": {"vr": "TM", "Value": ["094507.700000"]}, "1516": {"vr": "TM", "Value": ["094525.152500"]}, "1517": {"vr": "TM", "Value": ["095316.237500"]}, "1518": {"vr": "TM", "Value": ["095251.445000"]}, "1519": {"vr": "TM", "Value": ["095019.357500"]}, "1520": {"vr": "TM", "Value": ["094833.172500"]}, "1521": {"vr": "TM", "Value": ["095309.485000"]}, "1522": {"vr": "TM", "Value": ["094750.782500"]}, "1523": {"vr": "TM", "Value": ["094834.635000"]}, "1524": {"vr": "TM", "Value": ["094916.440000"]}, "1525": {"vr": "TM", "Value": ["094618.100000"]}, "1526": {"vr": "TM", "Value": ["094726.577500"]}, "1527": {"vr": "TM", "Value": ["095244.715000"]}, "1528": {"vr": "TM", "Value": ["094528.372500"]}, "1529": {"vr": "TM", "Value": ["094901.767500"]}, "1530": {"vr": "TM", "Value": ["095222.705000"]}, "1531": {"vr": "TM", "Value": ["094930.090000"]}, "1532": {"vr": "TM", "Value": ["095404.500000"]}, "1533": {"vr": "TM", "Value": ["094732.450000"]}, "1534": {"vr": "TM", "Value": ["094841.095000"]}, "1535": {"vr": "TM", "Value": ["094719.260000"]}, "1536": {"vr": "TM", "Value": ["094958.685000"]}, "1537": {"vr": "TM", "Value": ["094547.142500"]}, "1538": {"vr": "TM", "Value": ["094544.655000"]}, "1539": {"vr": "TM", "Value": ["094637.017500"]}, "1540": {"vr": "TM", "Value": ["095015.260000"]}, "1541": {"vr": "TM", "Value": ["095034.617500"]}, "1542": {"vr": "TM", "Value": ["094741.690000"]}, "1543": {"vr": "TM", "Value": ["094839.485000"]}, "1544": {"vr": "TM", "Value": ["094955.885000"]}, "1545": {"vr": "TM", "Value": ["094931.552500"]}, "1546": {"vr": "TM", "Value": ["095046.197500"]}, "1547": {"vr": "TM", "Value": ["095029.182500"]}, "1548": {"vr": "TM", "Value": ["095012.900000"]}, "1549": {"vr": "TM", "Value": ["094900.742500"]}, "1550": {"vr": "TM", "Value": ["094758.705000"]}, "1551": {"vr": "TM", "Value": ["094809.700000"]}, "1552": {"vr": "TM", "Value": ["094853.407500"]}, "1553": {"vr": "TM", "Value": ["094645.525000"]}, "1554": {"vr": "TM", "Value": ["094949.152500"]}, "1555": {"vr": "TM", "Value": ["094511.797500"]}, "1556": {"vr": "TM", "Value": ["095051.047500"]}, "1557": {"vr": "TM", "Value": ["094942.547500"]}, "1558": {"vr": "TM", "Value": ["094911.737500"]}, "1559": {"vr": "TM", "Value": ["095135.340000"]}, "1560": {"vr": "TM", "Value": ["095420.782500"]}, "1561": {"vr": "TM", "Value": ["095009.387500"]}, "1562": {"vr": "TM", "Value": ["095310.822500"]}, "1563": {"vr": "TM", "Value": ["094725.700000"]}, "1564": {"vr": "TM", "Value": ["094730.695000"]}, "1565": {"vr": "TM", "Value": ["094615.300000"]}, "1566": {"vr": "TM", "Value": ["095023.037500"]}, "1567": {"vr": "TM", "Value": ["094802.967500"]}, "1568": {"vr": "TM", "Value": ["095013.945000"]}, "1569": {"vr": "TM", "Value": ["095326.207500"]}, "1570": {"vr": "TM", "Value": ["095058.967500"]}, "1571": {"vr": "TM", "Value": ["094534.685000"]}, "1572": {"vr": "TM", "Value": ["094841.535000"]}, "1573": {"vr": "TM", "Value": ["095041.075000"]}, "1574": {"vr": "TM", "Value": ["095000.002500"]}, "1575": {"vr": "TM", "Value": ["095057.485000"]}, "1576": {"vr": "TM", "Value": ["094632.167500"]}, "1577": {"vr": "TM", "Value": ["095114.645000"]}, "1578": {"vr": "TM", "Value": ["095434.997500"]}, "1579": {"vr": "TM", "Value": ["095436.022500"]}, "1580": {"vr": "TM", "Value": ["095204.080000"]}, "1581": {"vr": "TM", "Value": ["094923.340000"]}, "1582": {"vr": "TM", "Value": ["095222.265000"]}, "1583": {"vr": "TM", "Value": ["095047.222500"]}, "1584": {"vr": "TM", "Value": ["094718.822500"]}, "1585": {"vr": "TM", "Value": ["095334.715000"]}, "1586": {"vr": "TM", "Value": ["095245.007500"]}, "1587": {"vr": "TM", "Value": ["095047.660000"]}, "1588": {"vr": "TM", "Value": ["095131.367500"]}, "1589": {"vr": "TM", "Value": ["094700.490000"]}, "1590": {"vr": "TM", "Value": ["094828.177500"]}, "1591": {"vr": "TM", "Value": ["094724.090000"]}, "1592": {"vr": "TM", "Value": ["095329.885000"]}, "1593": {"vr": "TM", "Value": ["095035.642500"]}, "1594": {"vr": "TM", "Value": ["095312.285000"]}, "1595": {"vr": "TM", "Value": ["095417.837500"]}, "1596": {"vr": "TM", "Value": ["094558.890000"]}, "1597": {"vr": "TM", "Value": ["094918.490000"]}, "1598": {"vr": "TM", "Value": ["095348.655000"]}, "1599": {"vr": "TM", "Value": ["095209.367500"]}, "1600": {"vr": "TM", "Value": ["095136.510000"]}, "1601": {"vr": "TM", "Value": ["094513.992500"]}, "1602": {"vr": "TM", "Value": ["095357.162500"]}, "1603": {"vr": "TM", "Value": ["095449.232500"]}, "1604": {"vr": "TM", "Value": ["094650.500000"]}, "1605": {"vr": "TM", "Value": ["095101.310000"]}, "1606": {"vr": "TM", "Value": ["095423.270000"]}, "1607": {"vr": "TM", "Value": ["094835.075000"]}, "1608": {"vr": "TM", "Value": ["095301.290000"]}, "1609": {"vr": "TM", "Value": ["094926.557500"]}, "1610": {"vr": "TM", "Value": ["095003.515000"]}, "1611": {"vr": "TM", "Value": ["095234.577500"]}, "1612": {"vr": "TM", "Value": ["094938.285000"]}, "1613": {"vr": "TM", "Value": ["095238.110000"]}, "1614": {"vr": "TM", "Value": ["094723.650000"]}, "1615": {"vr": "TM", "Value": ["095251.007500"]}, "1616": {"vr": "TM", "Value": ["094719.700000"]}, "1617": {"vr": "TM", "Value": ["094952.372500"]}, "1618": {"vr": "TM", "Value": ["094943.572500"]}, "1619": {"vr": "TM", "Value": ["094532.177500"]}, "1620": {"vr": "TM", "Value": ["094713.827500"]}, "1621": {"vr": "TM", "Value": ["094948.275000"]}, "1622": {"vr": "TM", "Value": ["095121.542500"]}, "1623": {"vr": "TM", "Value": ["094936.967500"]}, "1624": {"vr": "TM", "Value": ["095357.602500"]}, "1625": {"vr": "TM", "Value": ["094821.592500"]}, "1626": {"vr": "TM", "Value": ["095025.085000"]}, "1627": {"vr": "TM", "Value": ["094831.710000"]}, "1628": {"vr": "TM", "Value": ["095028.890000"]}, "1629": {"vr": "TM", "Value": ["095232.090000"]}, "1630": {"vr": "TM", "Value": ["095432.070000"]}, "1631": {"vr": "TM", "Value": ["094652.860000"]}, "1632": {"vr": "TM", "Value": ["095128.735000"]}, "1633": {"vr": "TM", "Value": ["095027.865000"]}, "1634": {"vr": "TM", "Value": ["094535.562500"]}, "1635": {"vr": "TM", "Value": ["095213.320000"]}, "1636": {"vr": "TM", "Value": ["094557.115000"]}, "1637": {"vr": "TM", "Value": ["095150.745000"]}, "1638": {"vr": "TM", "Value": ["094904.567500"]}, "1639": {"vr": "TM", "Value": ["095321.377500"]}, "1640": {"vr": "TM", "Value": ["094641.407500"]}, "1641": {"vr": "TM", "Value": ["095445.845000"]}, "1642": {"vr": "TM", "Value": ["094528.812500"]}, "1643": {"vr": "TM", "Value": ["095450.842500"]}, "1644": {"vr": "TM", "Value": ["094958.247500"]}, "1645": {"vr": "TM", "Value": ["095352.607500"]}, "1646": {"vr": "TM", "Value": ["095228.140000"]}, "1647": {"vr": "TM", "Value": ["095329.447500"]}, "1648": {"vr": "TM", "Value": ["094730.547500"]}, "1649": {"vr": "TM", "Value": ["094826.130000"]}, "1650": {"vr": "TM", "Value": ["094952.080000"]}, "1651": {"vr": "TM", "Value": ["095242.207500"]}, "1652": {"vr": "TM", "Value": ["094907.640000"]}, "1653": {"vr": "TM", "Value": ["094935.212500"]}, "1654": {"vr": "TM", "Value": ["094748.440000"]}, "1655": {"vr": "TM", "Value": ["095142.237500"]}, "1656": {"vr": "TM", "Value": ["094932.725000"]}, "1657": {"vr": "TM", "Value": ["095132.832500"]}, "1658": {"vr": "TM", "Value": ["095210.540000"]}, "1659": {"vr": "TM", "Value": ["094854.745000"]}, "1660": {"vr": "TM", "Value": ["095118.325000"]}, "1661": {"vr": "TM", "Value": ["094517.670000"]}, "1662": {"vr": "TM", "Value": ["095056.607500"]}, "1663": {"vr": "TM", "Value": ["094811.767500"]}, "1664": {"vr": "TM", "Value": ["095255.855000"]}, "1665": {"vr": "TM", "Value": ["095216.392500"]}, "1666": {"vr": "TM", "Value": ["094911.592500"]}, "1667": {"vr": "TM", "Value": ["095225.337500"]}, "1668": {"vr": "TM", "Value": ["094658.422500"]}, "1669": {"vr": "TM", "Value": ["095229.895000"]}, "1670": {"vr": "TM", "Value": ["094914.685000"]}, "1671": {"vr": "TM", "Value": ["095132.392500"]}, "1672": {"vr": "TM", "Value": ["094559.330000"]}, "1673": {"vr": "TM", "Value": ["094812.940000"]}, "1674": {"vr": "TM", "Value": ["095022.430000"]}, "1675": {"vr": "TM", "Value": ["094731.720000"]}, "1676": {"vr": "TM", "Value": ["094526.470000"]}, "1677": {"vr": "TM", "Value": ["095412.275000"]}, "1678": {"vr": "TM", "Value": ["094837.875000"]}, "1679": {"vr": "TM", "Value": ["094902.937500"]}, "1680": {"vr": "TM", "Value": ["095227.555000"]}, "1681": {"vr": "TM", "Value": ["094634.382500"]}, "1682": {"vr": "TM", "Value": ["095211.125000"]}, "1683": {"vr": "TM", "Value": ["095124.490000"]}, "1684": {"vr": "TM", "Value": ["095346.900000"]}, "1685": {"vr": "TM", "Value": ["095252.032500"]}, "1686": {"vr": "TM", "Value": ["094527.932500"]}, "1687": {"vr": "TM", "Value": ["095155.865000"]}, "1688": {"vr": "TM", "Value": ["094801.192500"]}, "1689": {"vr": "TM", "Value": ["094820.567500"]}, "1690": {"vr": "TM", "Value": ["095022.577500"]}, "1691": {"vr": "TM", "Value": ["095313.017500"]}, "1692": {"vr": "TM", "Value": ["094829.660000"]}, "1693": {"vr": "TM", "Value": ["094847.992500"]}, "1694": {"vr": "TM", "Value": ["095302.460000"]}, "1695": {"vr": "TM", "Value": ["094713.680000"]}, "1696": {"vr": "TM", "Value": ["094536.295000"]}, "1697": {"vr": "TM", "Value": ["095034.325000"]}, "1698": {"vr": "TM", "Value": ["095416.665000"]}, "1699": {"vr": "TM", "Value": ["095042.540000"]}, "1700": {"vr": "TM", "Value": ["094509.747500"]}, "1701": {"vr": "TM", "Value": ["095258.637500"]}, "1702": {"vr": "TM", "Value": ["094709.437500"]}, "1703": {"vr": "TM", "Value": ["094541.290000"]}, "1704": {"vr": "TM", "Value": ["095356.725000"]}, "1705": {"vr": "TM", "Value": ["094536.147500"]}, "1706": {"vr": "TM", "Value": ["094537.027500"]}, "1707": {"vr": "TM", "Value": ["094828.490000"]}, "1708": {"vr": "TM", "Value": ["095219.632500"]}, "1709": {"vr": "TM", "Value": ["095014.822500"]}, "1710": {"vr": "TM", "Value": ["094913.367500"]}, "1711": {"vr": "TM", "Value": ["094532.030000"]}, "1712": {"vr": "TM", "Value": ["095148.530000"]}, "1713": {"vr": "TM", "Value": ["094735.982500"]}, "1714": {"vr": "TM", "Value": ["095359.650000"]}, "1715": {"vr": "TM", "Value": ["095241.767500"]}, "1716": {"vr": "TM", "Value": ["094605.475000"]}, "1717": {"vr": "TM", "Value": ["094642.890000"]}, "1718": {"vr": "TM", "Value": ["094944.012500"]}, "1719": {"vr": "TM", "Value": ["095412.715000"]}, "1720": {"vr": "TM", "Value": ["095455.232500"]}, "1721": {"vr": "TM", "Value": ["095401.992500"]}, "1722": {"vr": "TM", "Value": ["094727.475000"]}, "1723": {"vr": "TM", "Value": ["095416.957500"]}, "1724": {"vr": "TM", "Value": ["095249.250000"]}, "1725": {"vr": "TM", "Value": ["094740.080000"]}, "1726": {"vr": "TM", "Value": ["095346.755000"]}, "1727": {"vr": "TM", "Value": ["094917.027500"]}, "1728": {"vr": "TM", "Value": ["094746.392500"]}, "1729": {"vr": "TM", "Value": ["094955.007500"]}, "1730": {"vr": "TM", "Value": ["094536.587500"]}, "1731": {"vr": "TM", "Value": ["094837.437500"]}, "1732": {"vr": "TM", "Value": ["094528.957500"]}, "1733": {"vr": "TM", "Value": ["094517.525000"]}, "1734": {"vr": "TM", "Value": ["095358.920000"]}, "1735": {"vr": "TM", "Value": ["095303.632500"]}, "1736": {"vr": "TM", "Value": ["094824.080000"]}, "1737": {"vr": "TM", "Value": ["094702.540000"]}, "1738": {"vr": "TM", "Value": ["095136.947500"]}, "1739": {"vr": "TM", "Value": ["094841.972500"]}, "1740": {"vr": "TM", "Value": ["095356.870000"]}, "1741": {"vr": "TM", "Value": ["094752.100000"]}, "1742": {"vr": "TM", "Value": ["094622.927500"]}, "1743": {"vr": "TM", "Value": ["094738.762500"]}, "1744": {"vr": "TM", "Value": ["095128.147500"]}, "1745": {"vr": "TM", "Value": ["095102.480000"]}, "1746": {"vr": "TM", "Value": ["095241.475000"]}, "1747": {"vr": "TM", "Value": ["095046.782500"]}, "1748": {"vr": "TM", "Value": ["095215.515000"]}, "1749": {"vr": "TM", "Value": ["095301.145000"]}, "1750": {"vr": "TM", "Value": ["095423.857500"]}, "1751": {"vr": "TM", "Value": ["095434.265000"]}, "1752": {"vr": "TM", "Value": ["094609.007500"]}, "1753": {"vr": "TM", "Value": ["094734.060000"]}, "1754": {"vr": "TM", "Value": ["094940.647500"]}, "1755": {"vr": "TM", "Value": ["095127.270000"]}, "1756": {"vr": "TM", "Value": ["094738.470000"]}, "1757": {"vr": "TM", "Value": ["095120.665000"]}, "1758": {"vr": "TM", "Value": ["094517.962500"]}, "1759": {"vr": "TM", "Value": ["094527.347500"]}, "1760": {"vr": "TM", "Value": ["095121.105000"]}, "1761": {"vr": "TM", "Value": ["094545.680000"]}, "1762": {"vr": "TM", "Value": ["094517.085000"]}, "1763": {"vr": "TM", "Value": ["094559.915000"]}, "1764": {"vr": "TM", "Value": ["094927.730000"]}, "1765": {"vr": "TM", "Value": ["094642.430000"]}, "1766": {"vr": "TM", "Value": ["094833.757500"]}, "1767": {"vr": "TM", "Value": ["094847.700000"]}, "1768": {"vr": "TM", "Value": ["094852.090000"]}, "1769": {"vr": "TM", "Value": ["094516.352500"]}, "1770": {"vr": "TM", "Value": ["095124.637500"]}, "1771": {"vr": "TM", "Value": ["094934.920000"]}, "1772": {"vr": "TM", "Value": ["094942.110000"]}, "1773": {"vr": "TM", "Value": ["095354.237500"]}, "1774": {"vr": "TM", "Value": ["094549.045000"]}, "1775": {"vr": "TM", "Value": ["094644.645000"]}, "1776": {"vr": "TM", "Value": ["095434.705000"]}, "1777": {"vr": "TM", "Value": ["094734.937500"]}, "1778": {"vr": "TM", "Value": ["094743.885000"]}, "1779": {"vr": "TM", "Value": ["095243.377500"]}, "1780": {"vr": "TM", "Value": ["094804.432500"]}, "1781": {"vr": "TM", "Value": ["095248.812500"]}, "1782": {"vr": "TM", "Value": ["094701.660000"]}, "1783": {"vr": "TM", "Value": ["094736.130000"]}, "1784": {"vr": "TM", "Value": ["095227.260000"]}, "1785": {"vr": "TM", "Value": ["094842.705000"]}, "1786": {"vr": "TM", "Value": ["095142.530000"]}, "1787": {"vr": "TM", "Value": ["095442.920000"]}, "1788": {"vr": "TM", "Value": ["094751.952500"]}, "1789": {"vr": "TM", "Value": ["095230.627500"]}, "1790": {"vr": "TM", "Value": ["094713.532500"]}, "1791": {"vr": "TM", "Value": ["094628.070000"]}, "1792": {"vr": "TM", "Value": ["095024.352500"]}, "1793": {"vr": "TM", "Value": ["094930.530000"]}, "1794": {"vr": "TM", "Value": ["094927.875000"]}, "1795": {"vr": "TM", "Value": ["094729.085000"]}, "1796": {"vr": "TM", "Value": ["094508.870000"]}, "1797": {"vr": "TM", "Value": ["095039.737500"]}, "1798": {"vr": "TM", "Value": ["094706.927500"]}, "1799": {"vr": "TM", "Value": ["095100.140000"]}, "1800": {"vr": "TM", "Value": ["095110.110000"]}, "1801": {"vr": "TM", "Value": ["095328.275000"]}, "1802": {"vr": "TM", "Value": ["094820.715000"]}, "1803": {"vr": "TM", "Value": ["095415.202500"]}, "1804": {"vr": "TM", "Value": ["095415.495000"]}, "1805": {"vr": "TM", "Value": ["095453.915000"]}, "1806": {"vr": "TM", "Value": ["094602.987500"]}, "1807": {"vr": "TM", "Value": ["095408.450000"]}, "1808": {"vr": "TM", "Value": ["095233.992500"]}, "1809": {"vr": "TM", "Value": ["094735.085000"]}, "1810": {"vr": "TM", "Value": ["095044.295000"]}, "1811": {"vr": "TM", "Value": ["094937.700000"]}, "1812": {"vr": "TM", "Value": ["094851.357500"]}, "1813": {"vr": "TM", "Value": ["094839.632500"]}, "1814": {"vr": "TM", "Value": ["095307.437500"]}, "1815": {"vr": "TM", "Value": ["095426.050000"]}, "1816": {"vr": "TM", "Value": ["095022.285000"]}, "1817": {"vr": "TM", "Value": ["095045.027500"]}, "1818": {"vr": "TM", "Value": ["095028.597500"]}, "1819": {"vr": "TM", "Value": ["094920.392500"]}, "1820": {"vr": "TM", "Value": ["094829.515000"]}, "1821": {"vr": "TM", "Value": ["095132.977500"]}, "1822": {"vr": "TM", "Value": ["095239.135000"]}, "1823": {"vr": "TM", "Value": ["095131.807500"]}, "1824": {"vr": "TM", "Value": ["094721.602500"]}, "1825": {"vr": "TM", "Value": ["095047.515000"]}, "1826": {"vr": "TM", "Value": ["094739.935000"]}, "1827": {"vr": "TM", "Value": ["095316.967500"]}, "1828": {"vr": "TM", "Value": ["094902.792500"]}, "1829": {"vr": "TM", "Value": ["094607.690000"]}, "1830": {"vr": "TM", "Value": ["094728.792500"]}, "1831": {"vr": "TM", "Value": ["095043.855000"]}, "1832": {"vr": "TM", "Value": ["094849.747500"]}, "1833": {"vr": "TM", "Value": ["095024.792500"]}, "1834": {"vr": "TM", "Value": ["094706.197500"]}, "1835": {"vr": "TM", "Value": ["095017.162500"]}, "1836": {"vr": "TM", "Value": ["095118.032500"]}, "1837": {"vr": "TM", "Value": ["094827.300000"]}, "1838": {"vr": "TM", "Value": ["095318.137500"]}, "1839": {"vr": "TM", "Value": ["095218.900000"]}, "1840": {"vr": "TM", "Value": ["094554.772500"]}, "1841": {"vr": "TM", "Value": ["095051.777500"]}, "1842": {"vr": "TM", "Value": ["094937.552500"]}, "1843": {"vr": "TM", "Value": ["094703.562500"]}, "1844": {"vr": "TM", "Value": ["095123.445000"]}, "1845": {"vr": "TM", "Value": ["094819.545000"]}, "1846": {"vr": "TM", "Value": ["094807.650000"]}, "1847": {"vr": "TM", "Value": ["094801.485000"]}, "1848": {"vr": "TM", "Value": ["094950.762500"]}, "1849": {"vr": "TM", "Value": ["095233.845000"]}, "1850": {"vr": "TM", "Value": ["095015.700000"]}, "1851": {"vr": "TM", "Value": ["095234.890000"]}, "1852": {"vr": "TM", "Value": ["095110.402500"]}, "1853": {"vr": "TM", "Value": ["094520.305000"]}, "1854": {"vr": "TM", "Value": ["094621.612500"]}, "1855": {"vr": "TM", "Value": ["094944.890000"]}, "1856": {"vr": "TM", "Value": ["094635.845000"]}, "1857": {"vr": "TM", "Value": ["095420.345000"]}, "1858": {"vr": "TM", "Value": ["094817.475000"]}, "1859": {"vr": "TM", "Value": ["094635.992500"]}, "1860": {"vr": "TM", "Value": ["095038.715000"]}, "1861": {"vr": "TM", "Value": ["095052.802500"]}, "1862": {"vr": "TM", "Value": ["094727.622500"]}, "1863": {"vr": "TM", "Value": ["095321.525000"]}, "1864": {"vr": "TM", "Value": ["094602.255000"]}, "1865": {"vr": "TM", "Value": ["094955.592500"]}, "1866": {"vr": "TM", "Value": ["095038.275000"]}, "1867": {"vr": "TM", "Value": ["095105.992500"]}, "1868": {"vr": "TM", "Value": ["095442.335000"]}, "1869": {"vr": "TM", "Value": ["095157.037500"]}, "1870": {"vr": "TM", "Value": ["094548.607500"]}, "1871": {"vr": "TM", "Value": ["095210.685000"]}, "1872": {"vr": "TM", "Value": ["095453.037500"]}, "1873": {"vr": "TM", "Value": ["094510.627500"]}, "1874": {"vr": "TM", "Value": ["094736.567500"]}, "1875": {"vr": "TM", "Value": ["095419.885000"]}, "1876": {"vr": "TM", "Value": ["094604.742500"]}, "1877": {"vr": "TM", "Value": ["094616.782500"]}, "1878": {"vr": "TM", "Value": ["095441.750000"]}, "1879": {"vr": "TM", "Value": ["094814.110000"]}, "1880": {"vr": "TM", "Value": ["094741.835000"]}, "1881": {"vr": "TM", "Value": ["095234.432500"]}, "1882": {"vr": "TM", "Value": ["094922.460000"]}, "1883": {"vr": "TM", "Value": ["094540.977500"]}, "1884": {"vr": "TM", "Value": ["094754.900000"]}, "1885": {"vr": "TM", "Value": ["095410.940000"]}, "1886": {"vr": "TM", "Value": ["095006.752500"]}, "1887": {"vr": "TM", "Value": ["095247.350000"]}, "1888": {"vr": "TM", "Value": ["095422.832500"]}, "1889": {"vr": "TM", "Value": ["095311.260000"]}, "1890": {"vr": "TM", "Value": ["095050.752500"]}, "1891": {"vr": "TM", "Value": ["095026.842500"]}, "1892": {"vr": "TM", "Value": ["095349.387500"]}, "1893": {"vr": "TM", "Value": ["094541.875000"]}, "1894": {"vr": "TM", "Value": ["095403.330000"]}, "1895": {"vr": "TM", "Value": ["095349.680000"]}, "1896": {"vr": "TM", "Value": ["095149.115000"]}, "1897": {"vr": "TM", "Value": ["094749.465000"]}, "1898": {"vr": "TM", "Value": ["095437.192500"]}, "1899": {"vr": "TM", "Value": ["094540.100000"]}, "1900": {"vr": "TM", "Value": ["094651.837500"]}, "1901": {"vr": "TM", "Value": ["095400.675000"]}, "1902": {"vr": "TM", "Value": ["094846.675000"]}, "1903": {"vr": "TM", "Value": ["094741.542500"]}, "1904": {"vr": "TM", "Value": ["094907.347500"]}, "1905": {"vr": "TM", "Value": ["095229.162500"]}, "1906": {"vr": "TM", "Value": ["094832.440000"]}, "1907": {"vr": "TM", "Value": ["094846.822500"]}, "1908": {"vr": "TM", "Value": ["094906.177500"]}, "1909": {"vr": "TM", "Value": ["095316.382500"]}, "1910": {"vr": "TM", "Value": ["094737.007500"]}, "1911": {"vr": "TM", "Value": ["094600.645000"]}, "1912": {"vr": "TM", "Value": ["094620.880000"]}, "1913": {"vr": "TM", "Value": ["095241.330000"]}, "1914": {"vr": "TM", "Value": ["095315.797500"]}, "1915": {"vr": "TM", "Value": ["094513.845000"]}, "1916": {"vr": "TM", "Value": ["095003.075000"]}, "1917": {"vr": "TM", "Value": ["095226.822500"]}, "1918": {"vr": "TM", "Value": ["095001.465000"]}, "1919": {"vr": "TM", "Value": ["095442.187500"]}, "1920": {"vr": "TM", "Value": ["094824.227500"]}, "1921": {"vr": "TM", "Value": ["094846.382500"]}, "1922": {"vr": "TM", "Value": ["094915.710000"]}, "1923": {"vr": "TM", "Value": ["094910.422500"]}, "1924": {"vr": "TM", "Value": ["094544.802500"]}, "1925": {"vr": "TM", "Value": ["094758.997500"]}, "1926": {"vr": "TM", "Value": ["095308.167500"]}, "1927": {"vr": "TM", "Value": ["094916.587500"]}, "1928": {"vr": "TM", "Value": ["094756.802500"]}, "1929": {"vr": "TM", "Value": ["094940.352500"]}, "1930": {"vr": "TM", "Value": ["095217.582500"]}, "1931": {"vr": "TM", "Value": ["094904.860000"]}, "1932": {"vr": "TM", "Value": ["095328.130000"]}, "1933": {"vr": "TM", "Value": ["095139.875000"]}, "1934": {"vr": "TM", "Value": ["094607.230000"]}, "1935": {"vr": "TM", "Value": ["095335.152500"]}, "1936": {"vr": "TM", "Value": ["094642.137500"]}, "1937": {"vr": "TM", "Value": ["095215.807500"]}, "1938": {"vr": "TM", "Value": ["095342.197500"]}, "1939": {"vr": "TM", "Value": ["094930.822500"]}, "1940": {"vr": "TM", "Value": ["094810.285000"]}, "1941": {"vr": "TM", "Value": ["094830.685000"]}, "1942": {"vr": "TM", "Value": ["095113.622500"]}, "1943": {"vr": "TM", "Value": ["094616.930000"]}, "1944": {"vr": "TM", "Value": ["095114.207500"]}, "1945": {"vr": "TM", "Value": ["095147.065000"]}, "1946": {"vr": "TM", "Value": ["094846.967500"]}, "1947": {"vr": "TM", "Value": ["094852.530000"]}, "1948": {"vr": "TM", "Value": ["095335.445000"]}, "1949": {"vr": "TM", "Value": ["094649.035000"]}, "1950": {"vr": "TM", "Value": ["095217.437500"]}, "1951": {"vr": "TM", "Value": ["095046.637500"]}, "1952": {"vr": "TM", "Value": ["095115.982500"]}, "1953": {"vr": "TM", "Value": ["094937.992500"]}, "1954": {"vr": "TM", "Value": ["094548.167500"]}, "1955": {"vr": "TM", "Value": ["094711.632500"]}, "1956": {"vr": "TM", "Value": ["095237.817500"]}, "1957": {"vr": "TM", "Value": ["095016.577500"]}, "1958": {"vr": "TM", "Value": ["095115.377500"]}, "1959": {"vr": "TM", "Value": ["094931.992500"]}, "1960": {"vr": "TM", "Value": ["094809.992500"]}, "1961": {"vr": "TM", "Value": ["094507.845000"]}, "1962": {"vr": "TM", "Value": ["095156.305000"]}, "1963": {"vr": "TM", "Value": ["095122.715000"]}, "1964": {"vr": "TM", "Value": ["094953.397500"]}, "1965": {"vr": "TM", "Value": ["094851.797500"]}, "1966": {"vr": "TM", "Value": ["095210.392500"]}, "1967": {"vr": "TM", "Value": ["095451.135000"]}, "1968": {"vr": "TM", "Value": ["095128.880000"]}, "1969": {"vr": "TM", "Value": ["095432.510000"]}, "1970": {"vr": "TM", "Value": ["094747.417500"]}, "1971": {"vr": "TM", "Value": ["094843.875000"]}, "1972": {"vr": "TM", "Value": ["095011.290000"]}, "1973": {"vr": "TM", "Value": ["095447.475000"]}, "1974": {"vr": "TM", "Value": ["094801.045000"]}, "1975": {"vr": "TM", "Value": ["095257.027500"]}, "1976": {"vr": "TM", "Value": ["094547.290000"]}, "1977": {"vr": "TM", "Value": ["095011.730000"]}, "1978": {"vr": "TM", "Value": ["094639.797500"]}, "1979": {"vr": "TM", "Value": ["095208.782500"]}, "1980": {"vr": "TM", "Value": ["094837.290000"]}, "1981": {"vr": "TM", "Value": ["095057.777500"]}, "1982": {"vr": "TM", "Value": ["095233.407500"]}, "1983": {"vr": "TM", "Value": ["095008.655000"]}, "1984": {"vr": "TM", "Value": ["094622.342500"]}, "1985": {"vr": "TM", "Value": ["095008.217500"]}, "1986": {"vr": "TM", "Value": ["095318.577500"]}, "1987": {"vr": "TM", "Value": ["095426.490000"]}, "1988": {"vr": "TM", "Value": ["094533.515000"]}, "1989": {"vr": "TM", "Value": ["095009.535000"]}, "1990": {"vr": "TM", "Value": ["095215.222500"]}, "1991": {"vr": "TM", "Value": ["094919.807500"]}, "1992": {"vr": "TM", "Value": ["094743.737500"]}, "1993": {"vr": "TM", "Value": ["095002.635000"]}, "1994": {"vr": "TM", "Value": ["095348.510000"]}, "1995": {"vr": "TM", "Value": ["095408.745000"]}, "1996": {"vr": "TM", "Value": ["094957.367500"]}, "1997": {"vr": "TM", "Value": ["094553.310000"]}, "1998": {"vr": "TM", "Value": ["095106.890000"]}, "1999": {"vr": "TM", "Value": ["095127.710000"]}, "2000": {"vr": "TM", "Value": ["095244.860000"]}, "2001": {"vr": "TM", "Value": ["095450.257500"]}, "2002": {"vr": "TM", "Value": ["095224.900000"]}, "2003": {"vr": "TM", "Value": ["094534.245000"]}, "2004": {"vr": "TM", "Value": ["095148.237500"]}, "2005": {"vr": "TM", "Value": ["094636.432500"]}, "2006": {"vr": "TM", "Value": ["094943.135000"]}, "2007": {"vr": "TM", "Value": ["094602.547500"]}, "2008": {"vr": "TM", "Value": ["094658.860000"]}, "2009": {"vr": "TM", "Value": ["095440.285000"]}, "2010": {"vr": "TM", "Value": ["094626.315000"]}, "2011": {"vr": "TM", "Value": ["095343.807500"]}, "2012": {"vr": "TM", "Value": ["094507.260000"]}, "2013": {"vr": "TM", "Value": ["095300.245000"]}, "2014": {"vr": "TM", "Value": ["094857.817500"]}, "2015": {"vr": "TM", "Value": ["095235.330000"]}, "2016": {"vr": "TM", "Value": ["095010.557500"]}, "2017": {"vr": "TM", "Value": ["094956.345000"]}, "2018": {"vr": "TM", "Value": ["095333.397500"]}, "2019": {"vr": "TM", "Value": ["094952.520000"]}, "2020": {"vr": "TM", "Value": ["095436.607500"]}, "2021": {"vr": "TM", "Value": ["094834.050000"]}, "2022": {"vr": "TM", "Value": ["095103.505000"]}, "2023": {"vr": "TM", "Value": ["094814.695000"]}, "2024": {"vr": "TM", "Value": ["095409.475000"]}, "2025": {"vr": "TM", "Value": ["094650.645000"]}, "2026": {"vr": "TM", "Value": ["095359.065000"]}, "2027": {"vr": "TM", "Value": ["094755.777500"]}, "2028": {"vr": "TM", "Value": ["095126.247500"]}, "2029": {"vr": "TM", "Value": ["094650.207500"]}, "2030": {"vr": "TM", "Value": ["095439.262500"]}, "2031": {"vr": "TM", "Value": ["095018.042500"]}, "2032": {"vr": "TM", "Value": ["094630.850000"]}, "2033": {"vr": "TM", "Value": ["095427.367500"]}, "2034": {"vr": "TM", "Value": ["095042.685000"]}, "2035": {"vr": "TM", "Value": ["095007.192500"]}, "2036": {"vr": "TM", "Value": ["094808.382500"]}, "2037": {"vr": "TM", "Value": ["094734.645000"]}, "2038": {"vr": "TM", "Value": ["095238.987500"]}, "2039": {"vr": "TM", "Value": ["094954.130000"]}, "2040": {"vr": "TM", "Value": ["094617.660000"]}, "2041": {"vr": "TM", "Value": ["095108.940000"]}, "2042": {"vr": "TM", "Value": ["094619.855000"]}, "2043": {"vr": "TM", "Value": ["095254.392500"]}, "2044": {"vr": "TM", "Value": ["094902.645000"]}, "2045": {"vr": "TM", "Value": ["095055.290000"]}, "2046": {"vr": "TM", "Value": ["094745.807500"]}, "2047": {"vr": "TM", "Value": ["095433.827500"]}, "2048": {"vr": "TM", "Value": ["094818.207500"]}, "2049": {"vr": "TM", "Value": ["095010.705000"]}, "2050": {"vr": "TM", "Value": ["094544.070000"]}, "2051": {"vr": "TM", "Value": ["094909.397500"]}, "2052": {"vr": "TM", "Value": ["094611.640000"]}, "2053": {"vr": "TM", "Value": ["095209.807500"]}, "2054": {"vr": "TM", "Value": ["094943.720000"]}, "2055": {"vr": "TM", "Value": ["094839.340000"]}, "2056": {"vr": "TM", "Value": ["095115.545000"]}, "2057": {"vr": "TM", "Value": ["095410.645000"]}, "2058": {"vr": "TM", "Value": ["095445.407500"]}, "2059": {"vr": "TM", "Value": ["095341.612500"]}, "2060": {"vr": "TM", "Value": ["094653.592500"]}, "2061": {"vr": "TM", "Value": ["095037.250000"]}, "2062": {"vr": "TM", "Value": ["094736.860000"]}, "2063": {"vr": "TM", "Value": ["095050.900000"]}, "2064": {"vr": "TM", "Value": ["095311.407500"]}, "2065": {"vr": "TM", "Value": ["095404.792500"]}, "2066": {"vr": "TM", "Value": ["095032.422500"]}, "2067": {"vr": "TM", "Value": ["094844.460000"]}, "2068": {"vr": "TM", "Value": ["094844.022500"]}, "2069": {"vr": "TM", "Value": ["095347.777500"]}, "2070": {"vr": "TM", "Value": ["095047.807500"]}, "2071": {"vr": "TM", "Value": ["095224.460000"]}, "2072": {"vr": "TM", "Value": ["095006.022500"]}, "2073": {"vr": "TM", "Value": ["095120.957500"]}, "2074": {"vr": "TM", "Value": ["094732.742500"]}, "2075": {"vr": "TM", "Value": ["094821.740000"]}, "2076": {"vr": "TM", "Value": ["095110.255000"]}, "2077": {"vr": "TM", "Value": ["095305.972500"]}, "2078": {"vr": "TM", "Value": ["094748.002500"]}, "2079": {"vr": "TM", "Value": ["094825.690000"]}, "2080": {"vr": "TM", "Value": ["094810.577500"]}, "2081": {"vr": "TM", "Value": ["095351.875000"]}, "2082": {"vr": "TM", "Value": ["094824.957500"]}, "2083": {"vr": "TM", "Value": ["094957.515000"]}, "2084": {"vr": "TM", "Value": ["094958.540000"]}, "2085": {"vr": "TM", "Value": ["094723.357500"]}, "2086": {"vr": "TM", "Value": ["095313.602500"]}, "2087": {"vr": "TM", "Value": ["095408.305000"]}, "2088": {"vr": "TM", "Value": ["095152.355000"]}, "2089": {"vr": "TM", "Value": ["094747.710000"]}, "2090": {"vr": "TM", "Value": ["095008.362500"]}, "2091": {"vr": "TM", "Value": ["095043.125000"]}, "2092": {"vr": "TM", "Value": ["095145.455000"]}, "2093": {"vr": "TM", "Value": ["095441.310000"]}, "2094": {"vr": "TM", "Value": ["095432.950000"]}, "2095": {"vr": "TM", "Value": ["094853.260000"]}, "2096": {"vr": "TM", "Value": ["094654.325000"]}, "2097": {"vr": "TM", "Value": ["094657.690000"]}, "2098": {"vr": "TM", "Value": ["094507.115000"]}, "2099": {"vr": "TM", "Value": ["095251.592500"]}, "2100": {"vr": "TM", "Value": ["095115.085000"]}, "2101": {"vr": "TM", "Value": ["095248.372500"]}, "2102": {"vr": "TM", "Value": ["094927.142500"]}, "2103": {"vr": "TM", "Value": ["094517.377500"]}, "2104": {"vr": "TM", "Value": ["095243.690000"]}, "2105": {"vr": "TM", "Value": ["094547.727500"]}, "2106": {"vr": "TM", "Value": ["094730.987500"]}, "2107": {"vr": "TM", "Value": ["095101.162500"]}, "2108": {"vr": "TM", "Value": ["094620.732500"]}, "2109": {"vr": "TM", "Value": ["095310.237500"]}, "2110": {"vr": "TM", "Value": ["095352.900000"]}, "2111": {"vr": "TM", "Value": ["094653.885000"]}, "2112": {"vr": "TM", "Value": ["094752.977500"]}, "2113": {"vr": "TM", "Value": ["095021.115000"]}, "2114": {"vr": "TM", "Value": ["095322.695000"]}, "2115": {"vr": "TM", "Value": ["094545.240000"]}, "2116": {"vr": "TM", "Value": ["095014.530000"]}, "2117": {"vr": "TM", "Value": ["094809.552500"]}, "2118": {"vr": "TM", "Value": ["094716.022500"]}, "2119": {"vr": "TM", "Value": ["095040.345000"]}, "2120": {"vr": "TM", "Value": ["095442.042500"]}, "2121": {"vr": "TM", "Value": ["094636.577500"]}, "2122": {"vr": "TM", "Value": ["094517.817500"]}, "2123": {"vr": "TM", "Value": ["094633.192500"]}, "2124": {"vr": "TM", "Value": ["094546.265000"]}, "2125": {"vr": "TM", "Value": ["094808.967500"]}, "2126": {"vr": "TM", "Value": ["094539.075000"]}, "2127": {"vr": "TM", "Value": ["094913.807500"]}, "2128": {"vr": "TM", "Value": ["095052.510000"]}, "2129": {"vr": "TM", "Value": ["095355.407500"]}, "2130": {"vr": "TM", "Value": ["094913.515000"]}, "2131": {"vr": "TM", "Value": ["095413.740000"]}, "2132": {"vr": "TM", "Value": ["095139.730000"]}, "2133": {"vr": "TM", "Value": ["094606.937500"]}, "2134": {"vr": "TM", "Value": ["094653.300000"]}, "2135": {"vr": "TM", "Value": ["094723.065000"]}, "2136": {"vr": "TM", "Value": ["094637.310000"]}, "2137": {"vr": "TM", "Value": ["094828.930000"]}, "2138": {"vr": "TM", "Value": ["094905.740000"]}, "2139": {"vr": "TM", "Value": ["095008.802500"]}, "2140": {"vr": "TM", "Value": ["095005.145000"]}, "2141": {"vr": "TM", "Value": ["095109.525000"]}, "2142": {"vr": "TM", "Value": ["094937.407500"]}, "2143": {"vr": "TM", "Value": ["095436.315000"]}, "2144": {"vr": "TM", "Value": ["095054.850000"]}, "2145": {"vr": "TM", "Value": ["094742.860000"]}, "2146": {"vr": "TM", "Value": ["095449.525000"]}, "2147": {"vr": "TM", "Value": ["094628.802500"]}, "2148": {"vr": "TM", "Value": ["094629.827500"]}, "2149": {"vr": "TM", "Value": ["095409.767500"]}, "2150": {"vr": "TM", "Value": ["095418.567500"]}, "2151": {"vr": "TM", "Value": ["095018.335000"]}, "2152": {"vr": "TM", "Value": ["094557.407500"]}, "2153": {"vr": "TM", "Value": ["094726.137500"]}, "2154": {"vr": "TM", "Value": ["095131.222500"]}, "2155": {"vr": "TM", "Value": ["095050.315000"]}, "2156": {"vr": "TM", "Value": ["095156.742500"]}, "2157": {"vr": "TM", "Value": ["094948.860000"]}, "2158": {"vr": "TM", "Value": ["095135.632500"]}, "2159": {"vr": "TM", "Value": ["094952.812500"]}, "2160": {"vr": "TM", "Value": ["094946.792500"]}, "2161": {"vr": "TM", "Value": ["094706.490000"]}, "2162": {"vr": "TM", "Value": ["094553.017500"]}, "2163": {"vr": "TM", "Value": ["094931.847500"]}, "2164": {"vr": "TM", "Value": ["095104.967500"]}, "2165": {"vr": "TM", "Value": ["094819.690000"]}, "2166": {"vr": "TM", "Value": ["094922.167500"]}, "2167": {"vr": "TM", "Value": ["095116.275000"]}, "2168": {"vr": "TM", "Value": ["095429.145000"]}, "2169": {"vr": "TM", "Value": ["094745.660000"]}, "2170": {"vr": "TM", "Value": ["095002.782500"]}, "2171": {"vr": "TM", "Value": ["095418.715000"]}, "2172": {"vr": "TM", "Value": ["094656.957500"]}, "2173": {"vr": "TM", "Value": ["095240.157500"]}, "2174": {"vr": "TM", "Value": ["095004.392500"]}, "2175": {"vr": "TM", "Value": ["094800.315000"]}, "2176": {"vr": "TM", "Value": ["095106.285000"]}, "2177": {"vr": "TM", "Value": ["095444.675000"]}, "2178": {"vr": "TM", "Value": ["094655.932500"]}, "2179": {"vr": "TM", "Value": ["095112.157500"]}, "2180": {"vr": "TM", "Value": ["094619.417500"]}, "2181": {"vr": "TM", "Value": ["094730.110000"]}, "2182": {"vr": "TM", "Value": ["095143.992500"]}, "2183": {"vr": "TM", "Value": ["095329.007500"]}, "2184": {"vr": "TM", "Value": ["095213.465000"]}, "2185": {"vr": "TM", "Value": ["094951.347500"]}, "2186": {"vr": "TM", "Value": ["095238.550000"]}, "2187": {"vr": "TM", "Value": ["095446.745000"]}, "2188": {"vr": "TM", "Value": ["095117.300000"]}, "2189": {"vr": "TM", "Value": ["094750.490000"]}, "2190": {"vr": "TM", "Value": ["094546.705000"]}, "2191": {"vr": "TM", "Value": ["094637.895000"]}, "2192": {"vr": "TM", "Value": ["094820.130000"]}, "2193": {"vr": "TM", "Value": ["095251.737500"]}, "2194": {"vr": "TM", "Value": ["094535.855000"]}, "2195": {"vr": "TM", "Value": ["094900.597500"]}, "2196": {"vr": "TM", "Value": ["095113.182500"]}, "2197": {"vr": "TM", "Value": ["094949.592500"]}, "2198": {"vr": "TM", "Value": ["095348.950000"]}, "2199": {"vr": "TM", "Value": ["095239.720000"]}, "2200": {"vr": "TM", "Value": ["094652.130000"]}, "2201": {"vr": "TM", "Value": ["094753.145000"]}, "2202": {"vr": "TM", "Value": ["095318.745000"]}, "2203": {"vr": "TM", "Value": ["095200.715000"]}, "2204": {"vr": "TM", "Value": ["095449.817500"]}, "2205": {"vr": "TM", "Value": ["094559.767500"]}, "2206": {"vr": "TM", "Value": ["095124.930000"]}, "2207": {"vr": "TM", "Value": ["095056.022500"]}, "2208": {"vr": "TM", "Value": ["095440.870000"]}, "2209": {"vr": "TM", "Value": ["095257.612500"]}, "2210": {"vr": "TM", "Value": ["094705.612500"]}, "2211": {"vr": "TM", "Value": ["094541.142500"]}, "2212": {"vr": "TM", "Value": ["095209.660000"]}, "2213": {"vr": "TM", "Value": ["095207.445000"]}, "2214": {"vr": "TM", "Value": ["094808.822500"]}, "2215": {"vr": "TM", "Value": ["095308.022500"]}, "2216": {"vr": "TM", "Value": ["095006.315000"]}, "2217": {"vr": "TM", "Value": ["095153.377500"]}, "2218": {"vr": "TM", "Value": ["094905.885000"]}, "2219": {"vr": "TM", "Value": ["094712.947500"]}, "2220": {"vr": "TM", "Value": ["094511.505000"]}, "2221": {"vr": "TM", "Value": ["094637.747500"]}, "2222": {"vr": "TM", "Value": ["095253.660000"]}, "2223": {"vr": "TM", "Value": ["095039.592500"]}, "2224": {"vr": "TM", "Value": ["094606.352500"]}, "2225": {"vr": "TM", "Value": ["095048.977500"]}, "2226": {"vr": "TM", "Value": ["094833.612500"]}, "2227": {"vr": "TM", "Value": ["095400.967500"]}, "2228": {"vr": "TM", "Value": ["094539.660000"]}, "2229": {"vr": "TM", "Value": ["095411.377500"]}, "2230": {"vr": "TM", "Value": ["095150.432500"]}, "2231": {"vr": "TM", "Value": ["095230.187500"]}, "2232": {"vr": "TM", "Value": ["095109.232500"]}, "2233": {"vr": "TM", "Value": ["095444.822500"]}, "2234": {"vr": "TM", "Value": ["095025.670000"]}, "2235": {"vr": "TM", "Value": ["095201.447500"]}, "2236": {"vr": "TM", "Value": ["095220.655000"]}, "2237": {"vr": "TM", "Value": ["095104.822500"]}, "2238": {"vr": "TM", "Value": ["095225.945000"]}, "2239": {"vr": "TM", "Value": ["094648.742500"]}, "2240": {"vr": "TM", "Value": ["094804.725000"]}, "2241": {"vr": "TM", "Value": ["094642.285000"]}, "2242": {"vr": "TM", "Value": ["095112.890000"]}, "2243": {"vr": "TM", "Value": ["094608.275000"]}, "2244": {"vr": "TM", "Value": ["094543.925000"]}, "2245": {"vr": "TM", "Value": ["094918.635000"]}, "2246": {"vr": "TM", "Value": ["094526.910000"]}, "2247": {"vr": "TM", "Value": ["095102.335000"]}, "2248": {"vr": "TM", "Value": ["094610.617500"]}, "2249": {"vr": "TM", "Value": ["095327.982500"]}, "2250": {"vr": "TM", "Value": ["095300.832500"]}, "2251": {"vr": "TM", "Value": ["094703.125000"]}, "2252": {"vr": "TM", "Value": ["094519.280000"]}, "2253": {"vr": "TM", "Value": ["095328.860000"]}, "2254": {"vr": "TM", "Value": ["095454.207500"]}, "2255": {"vr": "TM", "Value": ["094814.547500"]}, "2256": {"vr": "TM", "Value": ["095438.237500"]}, "2257": {"vr": "TM", "Value": ["095158.792500"]}, "2258": {"vr": "TM", "Value": ["094626.752500"]}, "2259": {"vr": "TM", "Value": ["094645.377500"]}, "2260": {"vr": "TM", "Value": ["095014.090000"]}, "2261": {"vr": "TM", "Value": ["094745.952500"]}, "2262": {"vr": "TM", "Value": ["095432.802500"]}, "2263": {"vr": "TM", "Value": ["095314.772500"]}, "2264": {"vr": "TM", "Value": ["095153.962500"]}, "2265": {"vr": "TM", "Value": ["094936.822500"]}, "2266": {"vr": "TM", "Value": ["095129.905000"]}, "2267": {"vr": "TM", "Value": ["095415.642500"]}, "2268": {"vr": "TM", "Value": ["095106.430000"]}, "2269": {"vr": "TM", "Value": ["094625.437500"]}, "2270": {"vr": "TM", "Value": ["095154.110000"]}, "2271": {"vr": "TM", "Value": ["094812.645000"]}, "2272": {"vr": "TM", "Value": ["095415.055000"]}, "2273": {"vr": "TM", "Value": ["094858.402500"]}, "2274": {"vr": "TM", "Value": ["095307.582500"]}, "2275": {"vr": "TM", "Value": ["095030.060000"]}, "2276": {"vr": "TM", "Value": ["095102.772500"]}, "2277": {"vr": "TM", "Value": ["095017.602500"]}, "2278": {"vr": "TM", "Value": ["095314.920000"]}, "2279": {"vr": "TM", "Value": ["095430.167500"]}, "2280": {"vr": "TM", "Value": ["094637.455000"]}, "2281": {"vr": "TM", "Value": ["095221.242500"]}, "2282": {"vr": "TM", "Value": ["094732.305000"]}, "2283": {"vr": "TM", "Value": ["094743.007500"]}, "2284": {"vr": "TM", "Value": ["094952.227500"]}, "2285": {"vr": "TM", "Value": ["095253.222500"]}, "2286": {"vr": "TM", "Value": ["095338.100000"]}, "2287": {"vr": "TM", "Value": ["094510.187500"]}, "2288": {"vr": "TM", "Value": ["095441.602500"]}, "2289": {"vr": "TM", "Value": ["094529.105000"]}, "2290": {"vr": "TM", "Value": ["094702.977500"]}, "2291": {"vr": "TM", "Value": ["095138.997500"]}, "2292": {"vr": "TM", "Value": ["095347.192500"]}, "2293": {"vr": "TM", "Value": ["094715.582500"]}, "2294": {"vr": "TM", "Value": ["095015.992500"]}, "2295": {"vr": "TM", "Value": ["095000.147500"]}, "2296": {"vr": "TM", "Value": ["095133.730000"]}, "2297": {"vr": "TM", "Value": ["095351.145000"]}, "2298": {"vr": "TM", "Value": ["095128.442500"]}, "2299": {"vr": "TM", "Value": ["095424.735000"]}, "2300": {"vr": "TM", "Value": ["095249.690000"]}, "2301": {"vr": "TM", "Value": ["095121.250000"]}, "2302": {"vr": "TM", "Value": ["094716.460000"]}, "2303": {"vr": "TM", "Value": ["095144.870000"]}, "2304": {"vr": "TM", "Value": ["095033.300000"]}, "2305": {"vr": "TM", "Value": ["094518.547500"]}, "2306": {"vr": "TM", "Value": ["094532.490000"]}, "2307": {"vr": "TM", "Value": ["095207.300000"]}, "2308": {"vr": "TM", "Value": ["095220.802500"]}, "2309": {"vr": "TM", "Value": ["094924.802500"]}, "2310": {"vr": "TM", "Value": ["094849.455000"]}, "2311": {"vr": "TM", "Value": ["095202.910000"]}, "2312": {"vr": "TM", "Value": ["095326.937500"]}, "2313": {"vr": "TM", "Value": ["094506.675000"]}, "2314": {"vr": "TM", "Value": ["094916.735000"]}, "2315": {"vr": "TM", "Value": ["095442.480000"]}, "2316": {"vr": "TM", "Value": ["094530.275000"]}, "2317": {"vr": "TM", "Value": ["095219.192500"]}, "2318": {"vr": "TM", "Value": ["095146.335000"]}, "2319": {"vr": "TM", "Value": ["094742.715000"]}, "2320": {"vr": "TM", "Value": ["094929.192500"]}, "2321": {"vr": "TM", "Value": ["094753.875000"]}, "2322": {"vr": "TM", "Value": ["094546.850000"]}, "2323": {"vr": "TM", "Value": ["095339.125000"]}, "2324": {"vr": "TM", "Value": ["095154.255000"]}, "2325": {"vr": "TM", "Value": ["095421.367500"]}, "2326": {"vr": "TM", "Value": ["094743.300000"]}, "2327": {"vr": "TM", "Value": ["094925.680000"]}, "2328": {"vr": "TM", "Value": ["094804.870000"]}, "2329": {"vr": "TM", "Value": ["094907.935000"]}, "2330": {"vr": "TM", "Value": ["095218.167500"]}, "2331": {"vr": "TM", "Value": ["094711.485000"]}, "2332": {"vr": "TM", "Value": ["095154.402500"]}, "2333": {"vr": "TM", "Value": ["095114.060000"]}, "2334": {"vr": "TM", "Value": ["095016.140000"]}, "2335": {"vr": "TM", "Value": ["094836.685000"]}, "2336": {"vr": "TM", "Value": ["094550.675000"]}, "2337": {"vr": "TM", "Value": ["095131.952500"]}, "2338": {"vr": "TM", "Value": ["094611.055000"]}, "2339": {"vr": "TM", "Value": ["094754.167500"]}, "2340": {"vr": "TM", "Value": ["095315.945000"]}, "2341": {"vr": "TM", "Value": ["095045.320000"]}, "2342": {"vr": "TM", "Value": ["095325.037500"]}, "2343": {"vr": "TM", "Value": ["094856.352500"]}, "2344": {"vr": "TM", "Value": ["094834.490000"]}, "2345": {"vr": "TM", "Value": ["094909.690000"]}, "2346": {"vr": "TM", "Value": ["095315.357500"]}, "2347": {"vr": "TM", "Value": ["094658.567500"]}, "2348": {"vr": "TM", "Value": ["095058.237500"]}, "2349": {"vr": "TM", "Value": ["094722.772500"]}, "2350": {"vr": "TM", "Value": ["094601.232500"]}, "2351": {"vr": "TM", "Value": ["095147.650000"]}, "2352": {"vr": "TM", "Value": ["094808.675000"]}, "2353": {"vr": "TM", "Value": ["095342.050000"]}, "2354": {"vr": "TM", "Value": ["094619.125000"]}, "2355": {"vr": "TM", "Value": ["094522.352500"]}, "2356": {"vr": "TM", "Value": ["094833.465000"]}, "2357": {"vr": "TM", "Value": ["095427.952500"]}, "2358": {"vr": "TM", "Value": ["094816.157500"]}, "2359": {"vr": "TM", "Value": ["095314.187500"]}, "2360": {"vr": "TM", "Value": ["094646.402500"]}, "2361": {"vr": "TM", "Value": ["095439.407500"]}, "2362": {"vr": "TM", "Value": ["095250.860000"]}, "2363": {"vr": "TM", "Value": ["095431.925000"]}, "2364": {"vr": "TM", "Value": ["095357.750000"]}, "2365": {"vr": "TM", "Value": ["094556.675000"]}, "2366": {"vr": "TM", "Value": ["094834.930000"]}, "2367": {"vr": "TM", "Value": ["095043.417500"]}, "2368": {"vr": "TM", "Value": ["095242.060000"]}, "2369": {"vr": "TM", "Value": ["094509.017500"]}, "2370": {"vr": "TM", "Value": ["094548.315000"]}, "2371": {"vr": "TM", "Value": ["095047.075000"]}, "2372": {"vr": "TM", "Value": ["094819.085000"]}, "2373": {"vr": "TM", "Value": ["094618.392500"]}, "2374": {"vr": "TM", "Value": ["094553.747500"]}, "2375": {"vr": "TM", "Value": ["094947.545000"]}, "2376": {"vr": "TM", "Value": ["094648.597500"]}, "2377": {"vr": "TM", "Value": ["094538.927500"]}, "2378": {"vr": "TM", "Value": ["095305.387500"]}, "2379": {"vr": "TM", "Value": ["094614.275000"]}, "2380": {"vr": "TM", "Value": ["095327.545000"]}, "2381": {"vr": "TM", "Value": ["095140.167500"]}, "2382": {"vr": "TM", "Value": ["095138.557500"]}, "2383": {"vr": "TM", "Value": ["094903.982500"]}, "2384": {"vr": "TM", "Value": ["094939.475000"]}, "2385": {"vr": "TM", "Value": ["095001.320000"]}, "2386": {"vr": "TM", "Value": ["095336.032500"]}, "2387": {"vr": "TM", "Value": ["094732.890000"]}, "2388": {"vr": "TM", "Value": ["095420.032500"]}, "2389": {"vr": "TM", "Value": ["094553.455000"]}, "2390": {"vr": "TM", "Value": ["095443.212500"]}, "2391": {"vr": "TM", "Value": ["094744.177500"]}, "2392": {"vr": "TM", "Value": ["094734.500000"]}, "2393": {"vr": "TM", "Value": ["094542.900000"]}, "2394": {"vr": "TM", "Value": ["095134.315000"]}, "2395": {"vr": "TM", "Value": ["095340.442500"]}, "2396": {"vr": "TM", "Value": ["094855.182500"]}, "2397": {"vr": "TM", "Value": ["095335.300000"]}, "2398": {"vr": "TM", "Value": ["095259.807500"]}, "2399": {"vr": "TM", "Value": ["095359.797500"]}, "2400": {"vr": "TM", "Value": ["095310.675000"]}, "2401": {"vr": "TM", "Value": ["094841.240000"]}, "2402": {"vr": "TM", "Value": ["095325.475000"]}, "2403": {"vr": "TM", "Value": ["095214.930000"]}, "2404": {"vr": "TM", "Value": ["095144.140000"]}, "2405": {"vr": "TM", "Value": ["095157.915000"]}, "2406": {"vr": "TM", "Value": ["094628.362500"]}, "2407": {"vr": "TM", "Value": ["094803.260000"]}, "2408": {"vr": "TM", "Value": ["094544.217500"]}, "2409": {"vr": "TM", "Value": ["094846.237500"]}, "2410": {"vr": "TM", "Value": ["095435.145000"]}, "2411": {"vr": "TM", "Value": ["095113.475000"]}, "2412": {"vr": "TM", "Value": ["095146.480000"]}, "2413": {"vr": "TM", "Value": ["095249.397500"]}, "2414": {"vr": "TM", "Value": ["095036.227500"]}, "2415": {"vr": "TM", "Value": ["094607.377500"]}, "2416": {"vr": "TM", "Value": ["094623.660000"]}, "2417": {"vr": "TM", "Value": ["095453.475000"]}, "2418": {"vr": "TM", "Value": ["095133.437500"]}, "2419": {"vr": "TM", "Value": ["094752.830000"]}, "2420": {"vr": "TM", "Value": ["095208.637500"]}, "2421": {"vr": "TM", "Value": ["095156.450000"]}, "2422": {"vr": "TM", "Value": ["095222.997500"]}, "2423": {"vr": "TM", "Value": ["094531.737500"]}, "2424": {"vr": "TM", "Value": ["094616.637500"]}, "2425": {"vr": "TM", "Value": ["095107.622500"]}, "2426": {"vr": "TM", "Value": ["094534.977500"]}, "2427": {"vr": "TM", "Value": ["094740.665000"]}, "2428": {"vr": "TM", "Value": ["095054.120000"]}, "2429": {"vr": "TM", "Value": ["094923.925000"]}, "2430": {"vr": "TM", "Value": ["094911.007500"]}, "2431": {"vr": "TM", "Value": ["094537.172500"]}, "2432": {"vr": "TM", "Value": ["094540.245000"]}, "2433": {"vr": "TM", "Value": ["094822.032500"]}, "2434": {"vr": "TM", "Value": ["094805.455000"]}, "2435": {"vr": "TM", "Value": ["095402.140000"]}, "2436": {"vr": "TM", "Value": ["094657.397500"]}, "2437": {"vr": "TM", "Value": ["095130.637500"]}, "2438": {"vr": "TM", "Value": ["094613.105000"]}, "2439": {"vr": "TM", "Value": ["095121.837500"]}, "2440": {"vr": "TM", "Value": ["095055.875000"]}, "2441": {"vr": "TM", "Value": ["095334.275000"]}, "2442": {"vr": "TM", "Value": ["095159.377500"]}, "2443": {"vr": "TM", "Value": ["095240.890000"]}, "2444": {"vr": "TM", "Value": ["095103.357500"]}, "2445": {"vr": "TM", "Value": ["095158.060000"]}, "2446": {"vr": "TM", "Value": ["094626.167500"]}, "2447": {"vr": "TM", "Value": ["094925.972500"]}, "2448": {"vr": "TM", "Value": ["095341.757500"]}, "2449": {"vr": "TM", "Value": ["094540.392500"]}, "2450": {"vr": "TM", "Value": ["095210.100000"]}, "2451": {"vr": "TM", "Value": ["095024.500000"]}, "2452": {"vr": "TM", "Value": ["094600.500000"]}, "2453": {"vr": "TM", "Value": ["094918.342500"]}, "2454": {"vr": "TM", "Value": ["095422.247500"]}, "2455": {"vr": "TM", "Value": ["094739.495000"]}, "2456": {"vr": "TM", "Value": ["095017.310000"]}, "2457": {"vr": "TM", "Value": ["095011.875000"]}, "2458": {"vr": "TM", "Value": ["095019.505000"]}, "2459": {"vr": "TM", "Value": ["095425.465000"]}, "2460": {"vr": "TM", "Value": ["094830.540000"]}, "2461": {"vr": "TM", "Value": ["094754.022500"]}, "2462": {"vr": "TM", "Value": ["095229.017500"]}, "2463": {"vr": "TM", "Value": ["095355.555000"]}, "2464": {"vr": "TM", "Value": ["095258.197500"]}, "2465": {"vr": "TM", "Value": ["095142.822500"]}, "2466": {"vr": "TM", "Value": ["094911.885000"]}, "2467": {"vr": "TM", "Value": ["095024.207500"]}, "2468": {"vr": "TM", "Value": ["095302.315000"]}, "2469": {"vr": "TM", "Value": ["094941.670000"]}, "2470": {"vr": "TM", "Value": ["094656.520000"]}, "2471": {"vr": "TM", "Value": ["095126.977500"]}, "2472": {"vr": "TM", "Value": ["094940.792500"]}, "2473": {"vr": "TM", "Value": ["094806.480000"]}, "2474": {"vr": "TM", "Value": ["094523.085000"]}, "2475": {"vr": "TM", "Value": ["095128.587500"]}, "2476": {"vr": "TM", "Value": ["095113.767500"]}, "2477": {"vr": "TM", "Value": ["095427.222500"]}, "2478": {"vr": "TM", "Value": ["094622.782500"]}, "2479": {"vr": "TM", "Value": ["094644.207500"]}, "2480": {"vr": "TM", "Value": ["095313.895000"]}, "2481": {"vr": "TM", "Value": ["095334.860000"]}, "2482": {"vr": "TM", "Value": ["094841.827500"]}, "2483": {"vr": "TM", "Value": ["095325.915000"]}, "2484": {"vr": "TM", "Value": ["094611.347500"]}, "2485": {"vr": "TM", "Value": ["094807.357500"]}, "2486": {"vr": "TM", "Value": ["094805.162500"]}, "2487": {"vr": "TM", "Value": ["095309.632500"]}, "2488": {"vr": "TM", "Value": ["095428.540000"]}, "2489": {"vr": "TM", "Value": ["095417.397500"]}, "2490": {"vr": "TM", "Value": ["095206.130000"]}, "2491": {"vr": "TM", "Value": ["094624.100000"]}, "2492": {"vr": "TM", "Value": ["095020.530000"]}, "2493": {"vr": "TM", "Value": ["095100.432500"]}, "2494": {"vr": "TM", "Value": ["095419.592500"]}, "2495": {"vr": "TM", "Value": ["094813.670000"]}, "2496": {"vr": "TM", "Value": ["094701.807500"]}, "2497": {"vr": "TM", "Value": ["095325.330000"]}, "2498": {"vr": "TM", "Value": ["095148.090000"]}, "2499": {"vr": "TM", "Value": ["094843.435000"]}, "2500": {"vr": "TM", "Value": ["095343.660000"]}, "2501": {"vr": "TM", "Value": ["094934.187500"]}, "2502": {"vr": "TM", "Value": ["094604.305000"]}, "2503": {"vr": "TM", "Value": ["095308.460000"]}, "2504": {"vr": "TM", "Value": ["094710.752500"]}, "2505": {"vr": "TM", "Value": ["095145.747500"]}, "2506": {"vr": "TM", "Value": ["094850.335000"]}, "2507": {"vr": "TM", "Value": ["095126.540000"]}, "2508": {"vr": "TM", "Value": ["095056.752500"]}, "2509": {"vr": "TM", "Value": ["094725.845000"]}, "2510": {"vr": "TM", "Value": ["095216.977500"]}, "2511": {"vr": "TM", "Value": ["094856.647500"]}, "2512": {"vr": "TM", "Value": ["095051.925000"]}, "2513": {"vr": "TM", "Value": ["095413.300000"]}, "2514": {"vr": "TM", "Value": ["094811.037500"]}, "2515": {"vr": "TM", "Value": ["094557.992500"]}, "2516": {"vr": "TM", "Value": ["094551.700000"]}, "2517": {"vr": "TM", "Value": ["095345.145000"]}, "2518": {"vr": "TM", "Value": ["094922.900000"]}, "2519": {"vr": "TM", "Value": ["094838.022500"]}, "2520": {"vr": "TM", "Value": ["095137.535000"]}, "2521": {"vr": "TM", "Value": ["095308.607500"]}, "2522": {"vr": "TM", "Value": ["095448.355000"]}, "2523": {"vr": "TM", "Value": ["094608.715000"]}, "2524": {"vr": "TM", "Value": ["095029.037500"]}, "2525": {"vr": "TM", "Value": ["095452.305000"]}, "2526": {"vr": "TM", "Value": ["094803.407500"]}, "2527": {"vr": "TM", "Value": ["094802.090000"]}, "2528": {"vr": "TM", "Value": ["095326.792500"]}, "2529": {"vr": "TM", "Value": ["094835.222500"]}, "2530": {"vr": "TM", "Value": ["095251.885000"]}, "2531": {"vr": "TM", "Value": ["095229.750000"]}, "2532": {"vr": "TM", "Value": ["095051.485000"]}, "2533": {"vr": "TM", "Value": ["094545.387500"]}, "2534": {"vr": "TM", "Value": ["095141.485000"]}, "2535": {"vr": "TM", "Value": ["095101.017500"]}, "2536": {"vr": "TM", "Value": ["094920.537500"]}, "2537": {"vr": "TM", "Value": ["095004.100000"]}, "2538": {"vr": "TM", "Value": ["095150.890000"]}, "2539": {"vr": "TM", "Value": ["095447.330000"]}, "2540": {"vr": "TM", "Value": ["095438.675000"]}, "2541": {"vr": "TM", "Value": ["095018.187500"]}, "2542": {"vr": "TM", "Value": ["094816.012500"]}, "2543": {"vr": "TM", "Value": ["095230.772500"]}, "2544": {"vr": "TM", "Value": ["094633.045000"]}, "2545": {"vr": "TM", "Value": ["095054.557500"]}, "2546": {"vr": "TM", "Value": ["095134.900000"]}, "2547": {"vr": "TM", "Value": ["094658.127500"]}, "2548": {"vr": "TM", "Value": ["094821.445000"]}, "2549": {"vr": "TM", "Value": ["095017.895000"]}, "2550": {"vr": "TM", "Value": ["095404.062500"]}, "2551": {"vr": "TM", "Value": ["095246.470000"]}, "2552": {"vr": "TM", "Value": ["095431.777500"]}, "2553": {"vr": "TM", "Value": ["094606.500000"]}, "2554": {"vr": "TM", "Value": ["094800.167500"]}, "2555": {"vr": "TM", "Value": ["095112.450000"]}, "2556": {"vr": "TM", "Value": ["095349.095000"]}, "2557": {"vr": "TM", "Value": ["095315.650000"]}, "2558": {"vr": "TM", "Value": ["095040.030000"]}, "2559": {"vr": "TM", "Value": ["095323.135000"]}, "2560": {"vr": "TM", "Value": ["095414.032500"]}, "2561": {"vr": "TM", "Value": ["094915.562500"]}, "2562": {"vr": "TM", "Value": ["095116.422500"]}, "2563": {"vr": "TM", "Value": ["094842.412500"]}, "2564": {"vr": "TM", "Value": ["094729.525000"]}, "2565": {"vr": "TM", "Value": ["095334.130000"]}, "2566": {"vr": "TM", "Value": ["095224.167500"]}, "2567": {"vr": "TM", "Value": ["095132.100000"]}, "2568": {"vr": "TM", "Value": ["095420.930000"]}, "2569": {"vr": "TM", "Value": ["094635.407500"]}, "2570": {"vr": "TM", "Value": ["095409.182500"]}, "2571": {"vr": "TM", "Value": ["094647.865000"]}, "2572": {"vr": "TM", "Value": ["095454.940000"]}, "2573": {"vr": "TM", "Value": ["094543.777500"]}, "2574": {"vr": "TM", "Value": ["095116.860000"]}, "2575": {"vr": "TM", "Value": ["094612.520000"]}, "2576": {"vr": "TM", "Value": ["095238.695000"]}, "2577": {"vr": "TM", "Value": ["094805.017500"]}, "2578": {"vr": "TM", "Value": ["094525.007500"]}, "2579": {"vr": "TM", "Value": ["094515.330000"]}, "2580": {"vr": "TM", "Value": ["095445.260000"]}, "2581": {"vr": "TM", "Value": ["095010.265000"]}, "2582": {"vr": "TM", "Value": ["095013.630000"]}, "2583": {"vr": "TM", "Value": ["094909.835000"]}, "2584": {"vr": "TM", "Value": ["094826.275000"]}, "2585": {"vr": "TM", "Value": ["095317.992500"]}, "2586": {"vr": "TM", "Value": ["095124.177500"]}, "2587": {"vr": "TM", "Value": ["095222.120000"]}, "2588": {"vr": "TM", "Value": ["094521.035000"]}, "2589": {"vr": "TM", "Value": ["095444.530000"]}, "2590": {"vr": "TM", "Value": ["095105.407500"]}, "2591": {"vr": "TM", "Value": ["095403.915000"]}, "2592": {"vr": "TM", "Value": ["094852.822500"]}, "2593": {"vr": "TM", "Value": ["094920.977500"]}, "2594": {"vr": "TM", "Value": ["094753.730000"]}, "2595": {"vr": "TM", "Value": ["095346.022500"]}, "2596": {"vr": "TM", "Value": ["094801.630000"]}, "2597": {"vr": "TM", "Value": ["095424.150000"]}, "2598": {"vr": "TM", "Value": ["094745.075000"]}, "2599": {"vr": "TM", "Value": ["095102.920000"]}, "2600": {"vr": "TM", "Value": ["095237.377500"]}, "2601": {"vr": "TM", "Value": ["095321.670000"]}, "2602": {"vr": "TM", "Value": ["094928.607500"]}, "2603": {"vr": "TM", "Value": ["095237.962500"]}, "2604": {"vr": "TM", "Value": ["095342.930000"]}, "2605": {"vr": "TM", "Value": ["095158.207500"]}, "2606": {"vr": "TM", "Value": ["095254.247500"]}, "2607": {"vr": "TM", "Value": ["095158.937500"]}, "2608": {"vr": "TM", "Value": ["095429.437500"]}, "2609": {"vr": "TM", "Value": ["095134.022500"]}, "2610": {"vr": "TM", "Value": ["094751.367500"]}, "2611": {"vr": "TM", "Value": ["094822.177500"]}, "2612": {"vr": "TM", "Value": ["094711.777500"]}, "2613": {"vr": "TM", "Value": ["094610.325000"]}, "2614": {"vr": "TM", "Value": ["095127.125000"]}, "2615": {"vr": "TM", "Value": ["095341.320000"]}, "2616": {"vr": "TM", "Value": ["094754.315000"]}, "2617": {"vr": "TM", "Value": ["095206.422500"]}, "2618": {"vr": "TM", "Value": ["095137.972500"]}, "2619": {"vr": "TM", "Value": ["094910.567500"]}, "2620": {"vr": "TM", "Value": ["094749.027500"]}, "2621": {"vr": "TM", "Value": ["095023.767500"]}, "2622": {"vr": "TM", "Value": ["095347.047500"]}, "2623": {"vr": "TM", "Value": ["095320.060000"]}, "2624": {"vr": "TM", "Value": ["095319.475000"]}, "2625": {"vr": "TM", "Value": ["094839.777500"]}, "2626": {"vr": "TM", "Value": ["095440.725000"]}, "2627": {"vr": "TM", "Value": ["095309.045000"]}, "2628": {"vr": "TM", "Value": ["095448.207500"]}, "2629": {"vr": "TM", "Value": ["094650.352500"]}, "2630": {"vr": "TM", "Value": ["094939.182500"]}, "2631": {"vr": "TM", "Value": ["094928.752500"]}, "2632": {"vr": "TM", "Value": ["094712.655000"]}, "2633": {"vr": "TM", "Value": ["094953.982500"]}, "2634": {"vr": "TM", "Value": ["094836.392500"]}, "2635": {"vr": "TM", "Value": ["094534.832500"]}, "2636": {"vr": "TM", "Value": ["095314.627500"]}, "2637": {"vr": "TM", "Value": ["094936.530000"]}, "2638": {"vr": "TM", "Value": ["094525.737500"]}, "2639": {"vr": "TM", "Value": ["095135.485000"]}, "2640": {"vr": "TM", "Value": ["094512.527500"]}, "2641": {"vr": "TM", "Value": ["094625.145000"]}, "2642": {"vr": "TM", "Value": ["094908.812500"]}, "2643": {"vr": "TM", "Value": ["095442.627500"]}, "2644": {"vr": "TM", "Value": ["095049.730000"]}, "2645": {"vr": "TM", "Value": ["095306.997500"]}, "2646": {"vr": "TM", "Value": ["095029.622500"]}, "2647": {"vr": "TM", "Value": ["095208.930000"]}, "2648": {"vr": "TM", "Value": ["095128.295000"]}, "2649": {"vr": "TM", "Value": ["094704.880000"]}, "2650": {"vr": "TM", "Value": ["094731.572500"]}, "2651": {"vr": "TM", "Value": ["094819.230000"]}, "2652": {"vr": "TM", "Value": ["094634.530000"]}, "2653": {"vr": "TM", "Value": ["095410.207500"]}, "2654": {"vr": "TM", "Value": ["095254.540000"]}, "2655": {"vr": "TM", "Value": ["094539.952500"]}, "2656": {"vr": "TM", "Value": ["094623.952500"]}, "2657": {"vr": "TM", "Value": ["094740.520000"]}, "2658": {"vr": "TM", "Value": ["095454.352500"]}, "2659": {"vr": "TM", "Value": ["094842.120000"]}, "2660": {"vr": "TM", "Value": ["095153.525000"]}, "2661": {"vr": "TM", "Value": ["095331.642500"]}, "2662": {"vr": "TM", "Value": ["095405.670000"]}, "2663": {"vr": "TM", "Value": ["094555.505000"]}, "2664": {"vr": "TM", "Value": ["094609.300000"]}, "2665": {"vr": "TM", "Value": ["094616.030000"]}, "2666": {"vr": "TM", "Value": ["095329.155000"]}, "2667": {"vr": "TM", "Value": ["094746.540000"]}, "2668": {"vr": "TM", "Value": ["094602.840000"]}, "2669": {"vr": "TM", "Value": ["094630.120000"]}, "2670": {"vr": "TM", "Value": ["094924.362500"]}, "2671": {"vr": "TM", "Value": ["094837.582500"]}, "2672": {"vr": "TM", "Value": ["095243.232500"]}, "2673": {"vr": "TM", "Value": ["094656.372500"]}, "2674": {"vr": "TM", "Value": ["094606.792500"]}, "2675": {"vr": "TM", "Value": ["094623.807500"]}, "2676": {"vr": "TM", "Value": ["094600.060000"]}, "2677": {"vr": "TM", "Value": ["094928.167500"]}, "2678": {"vr": "TM", "Value": ["095244.275000"]}, "2679": {"vr": "TM", "Value": ["095002.930000"]}, "2680": {"vr": "TM", "Value": ["094514.577500"]}, "2681": {"vr": "TM", "Value": ["095205.690000"]}, "2682": {"vr": "TM", "Value": ["095020.967500"]}, "2683": {"vr": "TM", "Value": ["095219.925000"]}, "2684": {"vr": "TM", "Value": ["094909.542500"]}, "2685": {"vr": "TM", "Value": ["095131.515000"]}, "2686": {"vr": "TM", "Value": ["094712.217500"]}, "2687": {"vr": "TM", "Value": ["095047.952500"]}, "2688": {"vr": "TM", "Value": ["095059.847500"]}, "2689": {"vr": "TM", "Value": ["094834.782500"]}, "2690": {"vr": "TM", "Value": ["094915.270000"]}, "2691": {"vr": "TM", "Value": ["094630.265000"]}, "2692": {"vr": "TM", "Value": ["094640.090000"]}, "2693": {"vr": "TM", "Value": ["095100.577500"]}, "2694": {"vr": "TM", "Value": ["095242.645000"]}, "2695": {"vr": "TM", "Value": ["095212.880000"]}, "2696": {"vr": "TM", "Value": ["094619.270000"]}, "2697": {"vr": "TM", "Value": ["095406.987500"]}, "2698": {"vr": "TM", "Value": ["095101.455000"]}, "2699": {"vr": "TM", "Value": ["094719.552500"]}, "2700": {"vr": "TM", "Value": ["094532.637500"]}, "2701": {"vr": "TM", "Value": ["094857.232500"]}, "2702": {"vr": "TM", "Value": ["094828.030000"]}, "2703": {"vr": "TM", "Value": ["095422.685000"]}, "2704": {"vr": "TM", "Value": ["094900.012500"]}, "2705": {"vr": "TM", "Value": ["094551.552500"]}, "2706": {"vr": "TM", "Value": ["094659.445000"]}, "2707": {"vr": "TM", "Value": ["095358.627500"]}, "2708": {"vr": "TM", "Value": ["095336.930000"]}, "2709": {"vr": "TM", "Value": ["095308.900000"]}, "2710": {"vr": "TM", "Value": ["095107.037500"]}, "2711": {"vr": "TM", "Value": ["094603.865000"]}, "2712": {"vr": "TM", "Value": ["094847.407500"]}, "2713": {"vr": "TM", "Value": ["095423.710000"]}, "2714": {"vr": "TM", "Value": ["095327.377500"]}, "2715": {"vr": "TM", "Value": ["095048.245000"]}, "2716": {"vr": "TM", "Value": ["095054.265000"]}, "2717": {"vr": "TM", "Value": ["094839.192500"]}, "2718": {"vr": "TM", "Value": ["094519.865000"]}, "2719": {"vr": "TM", "Value": ["095034.032500"]}, "2720": {"vr": "TM", "Value": ["094828.345000"]}, "2721": {"vr": "TM", "Value": ["095405.377500"]}, "2722": {"vr": "TM", "Value": ["094835.515000"]}, "2723": {"vr": "TM", "Value": ["095438.967500"]}, "2724": {"vr": "TM", "Value": ["095240.012500"]}, "2725": {"vr": "TM", "Value": ["095226.967500"]}, "2726": {"vr": "TM", "Value": ["095312.725000"]}, "2727": {"vr": "TM", "Value": ["094910.715000"]}, "2728": {"vr": "TM", "Value": ["094723.942500"]}, "2729": {"vr": "TM", "Value": ["094920.830000"]}, "2730": {"vr": "TM", "Value": ["095036.957500"]}, "2731": {"vr": "TM", "Value": ["094850.040000"]}, "2732": {"vr": "TM", "Value": ["095431.047500"]}, "2733": {"vr": "TM", "Value": ["095359.357500"]}, "2734": {"vr": "TM", "Value": ["094920.685000"]}, "2735": {"vr": "TM", "Value": ["094628.655000"]}, "2736": {"vr": "TM", "Value": ["095002.050000"]}, "2737": {"vr": "TM", "Value": ["094912.782500"]}, "2738": {"vr": "TM", "Value": ["094519.720000"]}, "2739": {"vr": "TM", "Value": ["095035.202500"]}, "2740": {"vr": "TM", "Value": ["094742.422500"]}, "2741": {"vr": "TM", "Value": ["095449.377500"]}, "2742": {"vr": "TM", "Value": ["095440.577500"]}, "2743": {"vr": "TM", "Value": ["095400.090000"]}, "2744": {"vr": "TM", "Value": ["095152.500000"]}, "2745": {"vr": "TM", "Value": ["094527.055000"]}, "2746": {"vr": "TM", "Value": ["095136.217500"]}, "2747": {"vr": "TM", "Value": ["095245.740000"]}, "2748": {"vr": "TM", "Value": ["095048.537500"]}, "2749": {"vr": "TM", "Value": ["094836.537500"]}, "2750": {"vr": "TM", "Value": ["094644.060000"]}, "2751": {"vr": "TM", "Value": ["095227.407500"]}, "2752": {"vr": "TM", "Value": ["094722.335000"]}, "2753": {"vr": "TM", "Value": ["094521.182500"]}, "2754": {"vr": "TM", "Value": ["095358.042500"]}, "2755": {"vr": "TM", "Value": ["094725.260000"]}, "2756": {"vr": "TM", "Value": ["095322.842500"]}, "2757": {"vr": "TM", "Value": ["094822.617500"]}, "2758": {"vr": "TM", "Value": ["094559.037500"]}, "2759": {"vr": "TM", "Value": ["094636.140000"]}, "2760": {"vr": "TM", "Value": ["095052.070000"]}, "2761": {"vr": "TM", "Value": ["094911.445000"]}, "2762": {"vr": "TM", "Value": ["095125.367500"]}, "2763": {"vr": "TM", "Value": ["094659.885000"]}, "2764": {"vr": "TM", "Value": ["094601.962500"]}, "2765": {"vr": "TM", "Value": ["094956.490000"]}, "2766": {"vr": "TM", "Value": ["094732.012500"]}, "2767": {"vr": "TM", "Value": ["095007.047500"]}, "2768": {"vr": "TM", "Value": ["095126.392500"]}, "2769": {"vr": "TM", "Value": ["094621.320000"]}, "2770": {"vr": "TM", "Value": ["095134.755000"]}, "2771": {"vr": "TM", "Value": ["094536.440000"]}, "2772": {"vr": "TM", "Value": ["094625.875000"]}, "2773": {"vr": "TM", "Value": ["095332.665000"]}, "2774": {"vr": "TM", "Value": ["094912.490000"]}, "2775": {"vr": "TM", "Value": ["094516.060000"]}, "2776": {"vr": "TM", "Value": ["094613.690000"]}, "2777": {"vr": "TM", "Value": ["095138.705000"]}, "2778": {"vr": "TM", "Value": ["095006.460000"]}, "2779": {"vr": "TM", "Value": ["095232.237500"]}, "2780": {"vr": "TM", "Value": ["095039.885000"]}, "2781": {"vr": "TM", "Value": ["095448.940000"]}, "2782": {"vr": "TM", "Value": ["094708.100000"]}, "2783": {"vr": "TM", "Value": ["094620.295000"]}, "2784": {"vr": "TM", "Value": ["094903.377500"]}, "2785": {"vr": "TM", "Value": ["095005.875000"]}, "2786": {"vr": "TM", "Value": ["094940.060000"]}, "2787": {"vr": "TM", "Value": ["095413.885000"]}, "2788": {"vr": "TM", "Value": ["095053.680000"]}, "2789": {"vr": "TM", "Value": ["095125.955000"]}, "2790": {"vr": "TM", "Value": ["094711.925000"]}, "2791": {"vr": "TM", "Value": ["095200.275000"]}, "2792": {"vr": "TM", "Value": ["095312.577500"]}, "2793": {"vr": "TM", "Value": ["095234.745000"]}, "2794": {"vr": "TM", "Value": ["094803.552500"]}, "2795": {"vr": "TM", "Value": ["094731.135000"]}, "2796": {"vr": "TM", "Value": ["095031.230000"]}, "2797": {"vr": "TM", "Value": ["095140.607500"]}, "2798": {"vr": "TM", "Value": ["095222.557500"]}, "2799": {"vr": "TM", "Value": ["095327.837500"]}, "2800": {"vr": "TM", "Value": ["095143.407500"]}, "2801": {"vr": "TM", "Value": ["094850.187500"]}, "2802": {"vr": "TM", "Value": ["095403.182500"]}, "2803": {"vr": "TM", "Value": ["094931.700000"]}, "2804": {"vr": "TM", "Value": ["095036.520000"]}, "2805": {"vr": "TM", "Value": ["095119.642500"]}, "2806": {"vr": "TM", "Value": ["094634.090000"]}, "2807": {"vr": "TM", "Value": ["095414.762500"]}, "2808": {"vr": "TM", "Value": ["095357.310000"]}, "2809": {"vr": "TM", "Value": ["094903.545000"]}, "2810": {"vr": "TM", "Value": ["095030.207500"]}, "2811": {"vr": "TM", "Value": ["095446.432500"]}, "2812": {"vr": "TM", "Value": ["094932.432500"]}, "2813": {"vr": "TM", "Value": ["094740.957500"]}, "2814": {"vr": "TM", "Value": ["094555.065000"]}, "2815": {"vr": "TM", "Value": ["095035.347500"]}, "2816": {"vr": "TM", "Value": ["094702.245000"]}, "2817": {"vr": "TM", "Value": ["095108.647500"]}, "2818": {"vr": "TM", "Value": ["094822.910000"]}, "2819": {"vr": "TM", "Value": ["095354.382500"]}, "2820": {"vr": "TM", "Value": ["094940.500000"]}, "2821": {"vr": "TM", "Value": ["095357.017500"]}, "2822": {"vr": "TM", "Value": ["095133.290000"]}, "2823": {"vr": "TM", "Value": ["095344.392500"]}, "2824": {"vr": "TM", "Value": ["095344.977500"]}, "2825": {"vr": "TM", "Value": ["094818.645000"]}, "2826": {"vr": "TM", "Value": ["094551.407500"]}, "2827": {"vr": "TM", "Value": ["094721.895000"]}, "2828": {"vr": "TM", "Value": ["095406.842500"]}, "2829": {"vr": "TM", "Value": ["095252.490000"]}, "2830": {"vr": "TM", "Value": ["095004.685000"]}, "2831": {"vr": "TM", "Value": ["095326.500000"]}, "2832": {"vr": "TM", "Value": ["095053.972500"]}, "2833": {"vr": "TM", "Value": ["094933.895000"]}, "2834": {"vr": "TM", "Value": ["095113.037500"]}, "2835": {"vr": "TM", "Value": ["094855.915000"]}, "2836": {"vr": "TM", "Value": ["095056.167500"]}, "2837": {"vr": "TM", "Value": ["094657.542500"]}, "2838": {"vr": "TM", "Value": ["094816.742500"]}, "2839": {"vr": "TM", "Value": ["095028.450000"]}, "2840": {"vr": "TM", "Value": ["094925.827500"]}, "2841": {"vr": "TM", "Value": ["095237.232500"]}, "2842": {"vr": "TM", "Value": ["095232.530000"]}, "2843": {"vr": "TM", "Value": ["094929.045000"]}, "2844": {"vr": "TM", "Value": ["094733.182500"]}, "2845": {"vr": "TM", "Value": ["094811.182500"]}, "2846": {"vr": "TM", "Value": ["094743.152500"]}, "2847": {"vr": "TM", "Value": ["095324.305000"]}, "2848": {"vr": "TM", "Value": ["095428.832500"]}, "2849": {"vr": "TM", "Value": ["095304.950000"]}, "2850": {"vr": "TM", "Value": ["095130.930000"]}, "2851": {"vr": "TM", "Value": ["095227.115000"]}, "2852": {"vr": "TM", "Value": ["094956.637500"]}, "2853": {"vr": "TM", "Value": ["094718.530000"]}, "2854": {"vr": "TM", "Value": ["094802.382500"]}, "2855": {"vr": "TM", "Value": ["094506.382500"]}, "2856": {"vr": "TM", "Value": ["094857.525000"]}, "2857": {"vr": "TM", "Value": ["094805.310000"]}, "2858": {"vr": "TM", "Value": ["094850.772500"]}, "2859": {"vr": "TM", "Value": ["095214.490000"]}, "2860": {"vr": "TM", "Value": ["095305.095000"]}, "2861": {"vr": "TM", "Value": ["094748.147500"]}, "2862": {"vr": "TM", "Value": ["094511.650000"]}, "2863": {"vr": "TM", "Value": ["094950.177500"]}, "2864": {"vr": "TM", "Value": ["094609.885000"]}, "2865": {"vr": "TM", "Value": ["095233.115000"]}, "2866": {"vr": "TM", "Value": ["094806.920000"]}, "2867": {"vr": "TM", "Value": ["095159.232500"]}, "2868": {"vr": "TM", "Value": ["095321.085000"]}, "2869": {"vr": "TM", "Value": ["094803.700000"]}, "2870": {"vr": "TM", "Value": ["094717.485000"]}, "2871": {"vr": "TM", "Value": ["094526.617500"]}, "2872": {"vr": "TM", "Value": ["095238.402500"]}, "2873": {"vr": "TM", "Value": ["095152.940000"]}, "2874": {"vr": "TM", "Value": ["094844.167500"]}, "2875": {"vr": "TM", "Value": ["095351.290000"]}, "2876": {"vr": "TM", "Value": ["094941.962500"]}, "2877": {"vr": "TM", "Value": ["095042.832500"]}, "2878": {"vr": "TM", "Value": ["095310.530000"]}, "2879": {"vr": "TM", "Value": ["095045.465000"]}, "2880": {"vr": "TM", "Value": ["095041.367500"]}, "2881": {"vr": "TM", "Value": ["094935.797500"]}, "2882": {"vr": "TM", "Value": ["094645.962500"]}, "2883": {"vr": "TM", "Value": ["094605.767500"]}, "2884": {"vr": "TM", "Value": ["094550.967500"]}, "2885": {"vr": "TM", "Value": ["094838.900000"]}, "2886": {"vr": "TM", "Value": ["095031.982500"]}, "2887": {"vr": "TM", "Value": ["094903.690000"]}, "2888": {"vr": "TM", "Value": ["094858.840000"]}, "2889": {"vr": "TM", "Value": ["095430.315000"]}, "2890": {"vr": "TM", "Value": ["094624.392500"]}, "2891": {"vr": "TM", "Value": ["094703.270000"]}, "2892": {"vr": "TM", "Value": ["095301.875000"]}, "2893": {"vr": "TM", "Value": ["094807.797500"]}, "2894": {"vr": "TM", "Value": ["094947.377500"]}, "2895": {"vr": "TM", "Value": ["094538.342500"]}, "2896": {"vr": "TM", "Value": ["095326.352500"]}, "2897": {"vr": "TM", "Value": ["094930.237500"]}, "2898": {"vr": "TM", "Value": ["095019.942500"]}, "2899": {"vr": "TM", "Value": ["094734.352500"]}, "2900": {"vr": "TM", "Value": ["095109.817500"]}, "2901": {"vr": "TM", "Value": ["094609.445000"]}, "2902": {"vr": "TM", "Value": ["095355.262500"]}, "2903": {"vr": "TM", "Value": ["095118.177500"]}, "2904": {"vr": "TM", "Value": ["095111.427500"]}, "2905": {"vr": "TM", "Value": ["094744.782500"]}, "2906": {"vr": "TM", "Value": ["094507.407500"]}, "2907": {"vr": "TM", "Value": ["095447.622500"]}, "2908": {"vr": "TM", "Value": ["094629.972500"]}, "2909": {"vr": "TM", "Value": ["095414.177500"]}, "2910": {"vr": "TM", "Value": ["094802.237500"]}, "2911": {"vr": "TM", "Value": ["095354.530000"]}, "2912": {"vr": "TM", "Value": ["094614.127500"]}, "2913": {"vr": "TM", "Value": ["094917.320000"]}, "2914": {"vr": "TM", "Value": ["094627.632500"]}, "2915": {"vr": "TM", "Value": ["095026.402500"]}, "2916": {"vr": "TM", "Value": ["094957.952500"]}, "2917": {"vr": "TM", "Value": ["094801.777500"]}, "2918": {"vr": "TM", "Value": ["094511.212500"]}, "2919": {"vr": "TM", "Value": ["095453.182500"]}, "2920": {"vr": "TM", "Value": ["095215.952500"]}, "2921": {"vr": "TM", "Value": ["095127.562500"]}, "2922": {"vr": "TM", "Value": ["095150.285000"]}, "2923": {"vr": "TM", "Value": ["094959.125000"]}, "2924": {"vr": "TM", "Value": ["095116.130000"]}, "2925": {"vr": "TM", "Value": ["094554.187500"]}, "2926": {"vr": "TM", "Value": ["094653.152500"]}, "2927": {"vr": "TM", "Value": ["095259.075000"]}, "2928": {"vr": "TM", "Value": ["094746.100000"]}, "2929": {"vr": "TM", "Value": ["094522.207500"]}, "2930": {"vr": "TM", "Value": ["094647.280000"]}, "2931": {"vr": "TM", "Value": ["095443.357500"]}, "2932": {"vr": "TM", "Value": ["095425.612500"]}, "2933": {"vr": "TM", "Value": ["094627.777500"]}, "2934": {"vr": "TM", "Value": ["095049.290000"]}, "2935": {"vr": "TM", "Value": ["094651.230000"]}, "2936": {"vr": "TM", "Value": ["095154.987500"]}, "2937": {"vr": "TM", "Value": ["095301.582500"]}, "2938": {"vr": "TM", "Value": ["095303.777500"]}, "2939": {"vr": "TM", "Value": ["094839.045000"]}, "2940": {"vr": "TM", "Value": ["094906.617500"]}, "2941": {"vr": "TM", "Value": ["094720.870000"]}, "2942": {"vr": "TM", "Value": ["095333.837500"]}, "2943": {"vr": "TM", "Value": ["095149.552500"]}, "2944": {"vr": "TM", "Value": ["095401.552500"]}, "2945": {"vr": "TM", "Value": ["095444.967500"]}, "2946": {"vr": "TM", "Value": ["094820.422500"]}, "2947": {"vr": "TM", "Value": ["095304.217500"]}, "2948": {"vr": "TM", "Value": ["094933.602500"]}, "2949": {"vr": "TM", "Value": ["094510.772500"]}, "2950": {"vr": "TM", "Value": ["094659.737500"]}, "2951": {"vr": "TM", "Value": ["095059.260000"]}, "2952": {"vr": "TM", "Value": ["095401.115000"]}, "2953": {"vr": "TM", "Value": ["094858.695000"]}, "2954": {"vr": "TM", "Value": ["095002.197500"]}, "2955": {"vr": "TM", "Value": ["095141.337500"]}, "2956": {"vr": "TM", "Value": ["095214.782500"]}, "2957": {"vr": "TM", "Value": ["094622.197500"]}, "2958": {"vr": "TM", "Value": ["094629.095000"]}, "2959": {"vr": "TM", "Value": ["094738.617500"]}, "2960": {"vr": "TM", "Value": ["094754.752500"]}, "2961": {"vr": "TM", "Value": ["094744.490000"]}, "2962": {"vr": "TM", "Value": ["094743.445000"]}, "2963": {"vr": "TM", "Value": ["095329.300000"]}, "2964": {"vr": "TM", "Value": ["094653.445000"]}, "2965": {"vr": "TM", "Value": ["095321.817500"]}, "2966": {"vr": "TM", "Value": ["094840.655000"]}, "2967": {"vr": "TM", "Value": ["094600.207500"]}, "2968": {"vr": "TM", "Value": ["094826.422500"]}, "2969": {"vr": "TM", "Value": ["094702.100000"]}, "2970": {"vr": "TM", "Value": ["095241.622500"]}, "2971": {"vr": "TM", "Value": ["095441.162500"]}, "2972": {"vr": "TM", "Value": ["095324.597500"]}, "2973": {"vr": "TM", "Value": ["095033.007500"]}, "2974": {"vr": "TM", "Value": ["094703.417500"]}, "2975": {"vr": "TM", "Value": ["094543.045000"]}, "2976": {"vr": "TM", "Value": ["094741.250000"]}, "2977": {"vr": "TM", "Value": ["095052.217500"]}, "2978": {"vr": "TM", "Value": ["094628.217500"]}, "2979": {"vr": "TM", "Value": ["095247.642500"]}, "2980": {"vr": "TM", "Value": ["095015.552500"]}, "2981": {"vr": "TM", "Value": ["095218.460000"]}, "2982": {"vr": "TM", "Value": ["095105.115000"]}, "2983": {"vr": "TM", "Value": ["094614.715000"]}, "2984": {"vr": "TM", "Value": ["095252.637500"]}, "2985": {"vr": "TM", "Value": ["094827.885000"]}, "2986": {"vr": "TM", "Value": ["094818.060000"]}, "2987": {"vr": "TM", "Value": ["095111.135000"]}, "2988": {"vr": "TM", "Value": ["095117.740000"]}, "2989": {"vr": "TM", "Value": ["095230.480000"]}, "2990": {"vr": "TM", "Value": ["094532.342500"]}, "2991": {"vr": "TM", "Value": ["095147.797500"]}, "2992": {"vr": "TM", "Value": ["095117.885000"]}, "2993": {"vr": "TM", "Value": ["095017.455000"]}, "2994": {"vr": "TM", "Value": ["095237.670000"]}, "2995": {"vr": "TM", "Value": ["095336.177500"]}, "2996": {"vr": "TM", "Value": ["094923.632500"]}, "2997": {"vr": "TM", "Value": ["094751.807500"]}, "2998": {"vr": "TM", "Value": ["095034.177500"]}, "2999": {"vr": "TM", "Value": ["095018.480000"]}, "3000": {"vr": "TM", "Value": ["095245.447500"]}, "3001": {"vr": "TM", "Value": ["094613.982500"]}, "3002": {"vr": "TM", "Value": ["095325.767500"]}, "3003": {"vr": "TM", "Value": ["095114.500000"]}, "3004": {"vr": "TM", "Value": ["095222.412500"]}, "3005": {"vr": "TM", "Value": ["095448.062500"]}, "3006": {"vr": "TM", "Value": ["095221.535000"]}, "3007": {"vr": "TM", "Value": ["095255.125000"]}, "3008": {"vr": "TM", "Value": ["094603.427500"]}, "3009": {"vr": "TM", "Value": ["094654.470000"]}, "3010": {"vr": "TM", "Value": ["095206.275000"]}, "3011": {"vr": "TM", "Value": ["094838.315000"]}, "3012": {"vr": "TM", "Value": ["094844.607500"]}, "3013": {"vr": "TM", "Value": ["094715.435000"]}, "3014": {"vr": "TM", "Value": ["095433.680000"]}, "3015": {"vr": "TM", "Value": ["094906.470000"]}, "3016": {"vr": "TM", "Value": ["094944.597500"]}, "3017": {"vr": "TM", "Value": ["095037.542500"]}, "3018": {"vr": "TM", "Value": ["095338.685000"]}, "3019": {"vr": "TM", "Value": ["094512.967500"]}, "3020": {"vr": "TM", "Value": ["094908.957500"]}, "3021": {"vr": "TM", "Value": ["095027.427500"]}, "3022": {"vr": "TM", "Value": ["094816.450000"]}, "3023": {"vr": "TM", "Value": ["095115.690000"]}, "3024": {"vr": "TM", "Value": ["095025.377500"]}, "3025": {"vr": "TM", "Value": ["095247.935000"]}, "3026": {"vr": "TM", "Value": ["094520.742500"]}, "3027": {"vr": "TM", "Value": ["094710.167500"]}, "3028": {"vr": "TM", "Value": ["094922.022500"]}, "3029": {"vr": "TM", "Value": ["095140.752500"]}, "3030": {"vr": "TM", "Value": ["095254.832500"]}, "3031": {"vr": "TM", "Value": ["095304.802500"]}, "3032": {"vr": "TM", "Value": ["095436.752500"]}, "3033": {"vr": "TM", "Value": ["094634.822500"]}, "3034": {"vr": "TM", "Value": ["094753.437500"]}, "3035": {"vr": "TM", "Value": ["094850.480000"]}, "3036": {"vr": "TM", "Value": ["095330.762500"]}, "3037": {"vr": "TM", "Value": ["095045.612500"]}, "3038": {"vr": "TM", "Value": ["094638.920000"]}, "3039": {"vr": "TM", "Value": ["094638.480000"]}, "3040": {"vr": "TM", "Value": ["094639.212500"]}, "3041": {"vr": "TM", "Value": ["094741.397500"]}, "3042": {"vr": "TM", "Value": ["095111.572500"]}, "3043": {"vr": "TM", "Value": ["095233.260000"]}, "3044": {"vr": "TM", "Value": ["095306.265000"]}, "3045": {"vr": "TM", "Value": ["094618.977500"]}, "3046": {"vr": "TM", "Value": ["094710.022500"]}, "3047": {"vr": "TM", "Value": ["094932.285000"]}, "3048": {"vr": "TM", "Value": ["094908.227500"]}, "3049": {"vr": "TM", "Value": ["095406.255000"]}, "3050": {"vr": "TM", "Value": ["095123.592500"]}, "3051": {"vr": "TM", "Value": ["095018.772500"]}, "3052": {"vr": "TM", "Value": ["094724.967500"]}, "3053": {"vr": "TM", "Value": ["094642.745000"]}, "3054": {"vr": "TM", "Value": ["095306.705000"]}, "3055": {"vr": "TM", "Value": ["094548.022500"]}, "3056": {"vr": "TM", "Value": ["095351.582500"]}, "3057": {"vr": "TM", "Value": ["094558.745000"]}, "3058": {"vr": "TM", "Value": ["094717.337500"]}, "3059": {"vr": "TM", "Value": ["094717.630000"]}, "3060": {"vr": "TM", "Value": ["095122.422500"]}, "3061": {"vr": "TM", "Value": ["094814.840000"]}, "3062": {"vr": "TM", "Value": ["095417.982500"]}, "3063": {"vr": "TM", "Value": ["095346.607500"]}, "3064": {"vr": "TM", "Value": ["094917.172500"]}, "3065": {"vr": "TM", "Value": ["095108.500000"]}, "3066": {"vr": "TM", "Value": ["095215.367500"]}, "3067": {"vr": "TM", "Value": ["095012.607500"]}, "3068": {"vr": "TM", "Value": ["095155.572500"]}, "3069": {"vr": "TM", "Value": ["095023.330000"]}, "3070": {"vr": "TM", "Value": ["095420.490000"]}, "3071": {"vr": "TM", "Value": ["095010.412500"]}, "3072": {"vr": "TM", "Value": ["095139.142500"]}, "3073": {"vr": "TM", "Value": ["094730.840000"]}, "3074": {"vr": "TM", "Value": ["094643.475000"]}, "3075": {"vr": "TM", "Value": ["095432.362500"]}, "3076": {"vr": "TM", "Value": ["094533.807500"]}, "3077": {"vr": "TM", "Value": ["095135.925000"]}, "3078": {"vr": "TM", "Value": ["095034.910000"]}, "3079": {"vr": "TM", "Value": ["094910.860000"]}, "3080": {"vr": "TM", "Value": ["094542.752500"]}, "3081": {"vr": "TM", "Value": ["095326.060000"]}, "3082": {"vr": "TM", "Value": ["095345.582500"]}, "3083": {"vr": "TM", "Value": ["094843.142500"]}, "3084": {"vr": "TM", "Value": ["095033.592500"]}, "3085": {"vr": "TM", "Value": ["094842.997500"]}, "3086": {"vr": "TM", "Value": ["095032.860000"]}, "3087": {"vr": "TM", "Value": ["094536.880000"]}, "3088": {"vr": "TM", "Value": ["095221.972500"]}, "3089": {"vr": "TM", "Value": ["094508.725000"]}, "3090": {"vr": "TM", "Value": ["095353.945000"]}, "3091": {"vr": "TM", "Value": ["095104.382500"]}, "3092": {"vr": "TM", "Value": ["094647.720000"]}, "3093": {"vr": "TM", "Value": ["094746.685000"]}, "3094": {"vr": "TM", "Value": ["095238.255000"]}, "3095": {"vr": "TM", "Value": ["095235.037500"]}, "3096": {"vr": "TM", "Value": ["095049.582500"]}, "3097": {"vr": "TM", "Value": ["095005.290000"]}, "3098": {"vr": "TM", "Value": ["094914.832500"]}, "3099": {"vr": "TM", "Value": ["094818.352500"]}, "3100": {"vr": "TM", "Value": ["094718.675000"]}, "3101": {"vr": "TM", "Value": ["094807.212500"]}, "3102": {"vr": "TM", "Value": ["095136.362500"]}, "3103": {"vr": "TM", "Value": ["095126.832500"]}, "3104": {"vr": "TM", "Value": ["095107.767500"]}, "3105": {"vr": "TM", "Value": ["094903.085000"]}, "3106": {"vr": "TM", "Value": ["094751.660000"]}, "3107": {"vr": "TM", "Value": ["095353.632500"]}, "3108": {"vr": "TM", "Value": ["095443.797500"]}, "3109": {"vr": "TM", "Value": ["095421.662500"]}, "3110": {"vr": "TM", "Value": ["094852.235000"]}, "3111": {"vr": "TM", "Value": ["094807.505000"]}, "3112": {"vr": "TM", "Value": ["094809.407500"]}, "3113": {"vr": "TM", "Value": ["095221.387500"]}, "3114": {"vr": "TM", "Value": ["094756.362500"]}, "3115": {"vr": "TM", "Value": ["094518.110000"]}, "3116": {"vr": "TM", "Value": ["094651.545000"]}, "3117": {"vr": "TM", "Value": ["094851.212500"]}, "3118": {"vr": "TM", "Value": ["094853.115000"]}, "3119": {"vr": "TM", "Value": ["094641.552500"]}, "3120": {"vr": "TM", "Value": ["095423.562500"]}, "3121": {"vr": "TM", "Value": ["094845.777500"]}, "3122": {"vr": "TM", "Value": ["094618.685000"]}, "3123": {"vr": "TM", "Value": ["095300.537500"]}, "3124": {"vr": "TM", "Value": ["094533.222500"]}, "3125": {"vr": "TM", "Value": ["095237.525000"]}, "3126": {"vr": "TM", "Value": ["095302.167500"]}, "3127": {"vr": "TM", "Value": ["095157.182500"]}, "3128": {"vr": "TM", "Value": ["095256.002500"]}, "3129": {"vr": "TM", "Value": ["094557.700000"]}, "3130": {"vr": "TM", "Value": ["094755.340000"]}, "3131": {"vr": "TM", "Value": ["094828.782500"]}, "3132": {"vr": "TM", "Value": ["094511.357500"]}, "3133": {"vr": "TM", "Value": ["095205.982500"]}, "3134": {"vr": "TM", "Value": ["095023.475000"]}, "3135": {"vr": "TM", "Value": ["095337.515000"]}, "3136": {"vr": "TM", "Value": ["094533.367500"]}, "3137": {"vr": "TM", "Value": ["095404.355000"]}, "3138": {"vr": "TM", "Value": ["094550.382500"]}, "3139": {"vr": "TM", "Value": ["094530.420000"]}, "3140": {"vr": "TM", "Value": ["095031.837500"]}, "3141": {"vr": "TM", "Value": ["094757.972500"]}, "3142": {"vr": "TM", "Value": ["095319.037500"]}, "3143": {"vr": "TM", "Value": ["094623.075000"]}, "3144": {"vr": "TM", "Value": ["094712.510000"]}, "3145": {"vr": "TM", "Value": ["094523.690000"]}, "3146": {"vr": "TM", "Value": ["095012.752500"]}, "3147": {"vr": "TM", "Value": ["094715.875000"]}, "3148": {"vr": "TM", "Value": ["094751.515000"]}, "3149": {"vr": "TM", "Value": ["095146.187500"]}, "3150": {"vr": "TM", "Value": ["095035.935000"]}, "3151": {"vr": "TM", "Value": ["094654.910000"]}, "3152": {"vr": "TM", "Value": ["095052.362500"]}, "3153": {"vr": "TM", "Value": ["095251.300000"]}, "3154": {"vr": "TM", "Value": ["094744.345000"]}, "3155": {"vr": "TM", "Value": ["095419.007500"]}, "3156": {"vr": "TM", "Value": ["094717.945000"]}, "3157": {"vr": "TM", "Value": ["095242.937500"]}, "3158": {"vr": "TM", "Value": ["095015.407500"]}, "3159": {"vr": "TM", "Value": ["094749.612500"]}, "3160": {"vr": "TM", "Value": ["094513.260000"]}, "3161": {"vr": "TM", "Value": ["094955.300000"]}, "3162": {"vr": "TM", "Value": ["094935.505000"]}, "3163": {"vr": "TM", "Value": ["094604.450000"]}, "3164": {"vr": "TM", "Value": ["094729.817500"]}, "3165": {"vr": "TM", "Value": ["094507.552500"]}, "3166": {"vr": "TM", "Value": ["094635.260000"]}, "3167": {"vr": "TM", "Value": ["094627.192500"]}, "3168": {"vr": "TM", "Value": ["095248.957500"]}, "3169": {"vr": "TM", "Value": ["094956.030000"]}, "3170": {"vr": "TM", "Value": ["095437.632500"]}, "3171": {"vr": "TM", "Value": ["095016.725000"]}, "3172": {"vr": "TM", "Value": ["095452.745000"]}, "3173": {"vr": "TM", "Value": ["095322.987500"]}, "3174": {"vr": "TM", "Value": ["094810.430000"]}, "3175": {"vr": "TM", "Value": ["094954.422500"]}, "3176": {"vr": "TM", "Value": ["095445.992500"]}, "3177": {"vr": "TM", "Value": ["094912.637500"]}, "3178": {"vr": "TM", "Value": ["095101.747500"]}, "3179": {"vr": "TM", "Value": ["094859.135000"]}, "3180": {"vr": "TM", "Value": ["095243.837500"]}, "3181": {"vr": "TM", "Value": ["095253.955000"]}, "3182": {"vr": "TM", "Value": ["095250.130000"]}, "3183": {"vr": "TM", "Value": ["094750.635000"]}, "3184": {"vr": "TM", "Value": ["094638.627500"]}, "3185": {"vr": "TM", "Value": ["095255.270000"]}, "3186": {"vr": "TM", "Value": ["095209.515000"]}, "3187": {"vr": "TM", "Value": ["094914.247500"]}, "3188": {"vr": "TM", "Value": ["094738.910000"]}, "3189": {"vr": "TM", "Value": ["094739.787500"]}, "3190": {"vr": "TM", "Value": ["095346.462500"]}, "3191": {"vr": "TM", "Value": ["095304.510000"]}, "3192": {"vr": "TM", "Value": ["095110.987500"]}, "3193": {"vr": "TM", "Value": ["094959.855000"]}, "3194": {"vr": "TM", "Value": ["094513.552500"]}, "3195": {"vr": "TM", "Value": ["094921.730000"]}, "3196": {"vr": "TM", "Value": ["094636.725000"]}, "3197": {"vr": "TM", "Value": ["095243.545000"]}, "3198": {"vr": "TM", "Value": ["095010.850000"]}, "3199": {"vr": "TM", "Value": ["094856.207500"]}, "3200": {"vr": "TM", "Value": ["094521.475000"]}, "3201": {"vr": "TM", "Value": ["095240.742500"]}, "3202": {"vr": "TM", "Value": ["095439.115000"]}, "3203": {"vr": "TM", "Value": ["094938.430000"]}, "3204": {"vr": "TM", "Value": ["094939.622500"]}, "3205": {"vr": "TM", "Value": ["095435.437500"]}, "3206": {"vr": "TM", "Value": ["094630.997500"]}, "3207": {"vr": "TM", "Value": ["094855.330000"]}, "3208": {"vr": "TM", "Value": ["094914.977500"]}, "3209": {"vr": "TM", "Value": ["095216.685000"]}, "3210": {"vr": "TM", "Value": ["094626.022500"]}, "3211": {"vr": "TM", "Value": ["095043.562500"]}, "3212": {"vr": "TM", "Value": ["094951.642500"]}, "3213": {"vr": "TM", "Value": ["095303.192500"]}, "3214": {"vr": "TM", "Value": ["095450.987500"]}, "3215": {"vr": "TM", "Value": ["095351.730000"]}, "3216": {"vr": "TM", "Value": ["095146.042500"]}, "3217": {"vr": "TM", "Value": ["094621.757500"]}, "3218": {"vr": "TM", "Value": ["094510.332500"]}, "3219": {"vr": "TM", "Value": ["094738.325000"]}, "3220": {"vr": "TM", "Value": ["095008.510000"]}, "3221": {"vr": "TM", "Value": ["094707.075000"]}, "3222": {"vr": "TM", "Value": ["095340.880000"]}, "3223": {"vr": "TM", "Value": ["094850.627500"]}, "3224": {"vr": "TM", "Value": ["094518.987500"]}, "3225": {"vr": "TM", "Value": ["095130.490000"]}, "3226": {"vr": "TM", "Value": ["095118.762500"]}, "3227": {"vr": "TM", "Value": ["094737.740000"]}, "3228": {"vr": "TM", "Value": ["095213.612500"]}, "3229": {"vr": "TM", "Value": ["094617.222500"]}, "3230": {"vr": "TM", "Value": ["094824.372500"]}, "3231": {"vr": "TM", "Value": ["095152.060000"]}, "3232": {"vr": "TM", "Value": ["094736.715000"]}, "3233": {"vr": "TM", "Value": ["095421.075000"]}, "3234": {"vr": "TM", "Value": ["094746.245000"]}, "3235": {"vr": "TM", "Value": ["095127.417500"]}, "3236": {"vr": "TM", "Value": ["094847.552500"]}, "3237": {"vr": "TM", "Value": ["094925.240000"]}, "3238": {"vr": "TM", "Value": ["095340.002500"]}, "3239": {"vr": "TM", "Value": ["095254.100000"]}, "3240": {"vr": "TM", "Value": ["095443.650000"]}, "3241": {"vr": "TM", "Value": ["095220.070000"]}, "3242": {"vr": "TM", "Value": ["094732.597500"]}, "3243": {"vr": "TM", "Value": ["095003.660000"]}, "3244": {"vr": "TM", "Value": ["094627.485000"]}, "3245": {"vr": "TM", "Value": ["094519.572500"]}, "3246": {"vr": "TM", "Value": ["095332.227500"]}, "3247": {"vr": "TM", "Value": ["094915.125000"]}, "3248": {"vr": "TM", "Value": ["095123.300000"]}, "3249": {"vr": "TM", "Value": ["094845.192500"]}, "3250": {"vr": "TM", "Value": ["095335.007500"]}, "3251": {"vr": "TM", "Value": ["095048.100000"]}, "3252": {"vr": "TM", "Value": ["095042.392500"]}, "3253": {"vr": "TM", "Value": ["095258.782500"]}, "3254": {"vr": "TM", "Value": ["095318.890000"]}, "3255": {"vr": "TM", "Value": ["095445.700000"]}, "3256": {"vr": "TM", "Value": ["095139.290000"]}, "3257": {"vr": "TM", "Value": ["095250.275000"]}, "3258": {"vr": "TM", "Value": ["095001.612500"]}, "3259": {"vr": "TM", "Value": ["094556.822500"]}, "3260": {"vr": "TM", "Value": ["095033.740000"]}, "3261": {"vr": "TM", "Value": ["094908.372500"]}, "3262": {"vr": "TM", "Value": ["094913.075000"]}, "3263": {"vr": "TM", "Value": ["094816.597500"]}, "3264": {"vr": "TM", "Value": ["095003.807500"]}, "3265": {"vr": "TM", "Value": ["095339.417500"]}, "3266": {"vr": "TM", "Value": ["095400.530000"]}, "3267": {"vr": "TM", "Value": ["094915.855000"]}, "3268": {"vr": "TM", "Value": ["094818.937500"]}, "3269": {"vr": "TM", "Value": ["095217.875000"]}, "3270": {"vr": "TM", "Value": ["095448.500000"]}, "3271": {"vr": "TM", "Value": ["094743.592500"]}, "3272": {"vr": "TM", "Value": ["095405.525000"]}, "3273": {"vr": "TM", "Value": ["095430.900000"]}, "3274": {"vr": "TM", "Value": ["095444.237500"]}, "3275": {"vr": "TM", "Value": ["094721.017500"]}, "3276": {"vr": "TM", "Value": ["094730.255000"]}, "3277": {"vr": "TM", "Value": ["095034.470000"]}, "3278": {"vr": "TM", "Value": ["095331.202500"]}, "3279": {"vr": "TM", "Value": ["095332.372500"]}, "3280": {"vr": "TM", "Value": ["094825.542500"]}, "3281": {"vr": "TM", "Value": ["094737.445000"]}, "3282": {"vr": "TM", "Value": ["094817.035000"]}, "3283": {"vr": "TM", "Value": ["094632.900000"]}, "3284": {"vr": "TM", "Value": ["095152.792500"]}, "3285": {"vr": "TM", "Value": ["095041.952500"]}, "3286": {"vr": "TM", "Value": ["095112.305000"]}, "3287": {"vr": "TM", "Value": ["095320.792500"]}, "3288": {"vr": "TM", "Value": ["094750.342500"]}, "3289": {"vr": "TM", "Value": ["094633.630000"]}, "3290": {"vr": "TM", "Value": ["094628.510000"]}, "3291": {"vr": "TM", "Value": ["095048.830000"]}, "3292": {"vr": "TM", "Value": ["095421.515000"]}, "3293": {"vr": "TM", "Value": ["094947.230000"]}, "3294": {"vr": "TM", "Value": ["095024.647500"]}, "3295": {"vr": "TM", "Value": ["095109.377500"]}, "3296": {"vr": "TM", "Value": ["094733.915000"]}, "3297": {"vr": "TM", "Value": ["094730.402500"]}, "3298": {"vr": "TM", "Value": ["094846.530000"]}, "3299": {"vr": "TM", "Value": ["094620.440000"]}, "3300": {"vr": "TM", "Value": ["094929.777500"]}, "3301": {"vr": "TM", "Value": ["094942.695000"]}, "3302": {"vr": "TM", "Value": ["095109.085000"]}, "3303": {"vr": "TM", "Value": ["095441.895000"]}, "3304": {"vr": "TM", "Value": ["094707.952500"]}, "3305": {"vr": "TM", "Value": ["094923.777500"]}, "3306": {"vr": "TM", "Value": ["095409.915000"]}, "3307": {"vr": "TM", "Value": ["094558.430000"]}, "3308": {"vr": "TM", "Value": ["094802.822500"]}, "3309": {"vr": "TM", "Value": ["095205.397500"]}, "3310": {"vr": "TM", "Value": ["094551.845000"]}, "3311": {"vr": "TM", "Value": ["094834.197500"]}, "3312": {"vr": "TM", "Value": ["095106.137500"]}, "3313": {"vr": "TM", "Value": ["094516.207500"]}, "3314": {"vr": "TM", "Value": ["094934.040000"]}, "3315": {"vr": "TM", "Value": ["095004.977500"]}, "3316": {"vr": "TM", "Value": ["094717.777500"]}, "3317": {"vr": "TM", "Value": ["095347.632500"]}, "3318": {"vr": "TM", "Value": ["095016.285000"]}, "3319": {"vr": "TM", "Value": ["095259.952500"]}, "3320": {"vr": "TM", "Value": ["095411.232500"]}, "3321": {"vr": "TM", "Value": ["095224.752500"]}, "3322": {"vr": "TM", "Value": ["095121.397500"]}, "3323": {"vr": "TM", "Value": ["095031.085000"]}, "3324": {"vr": "TM", "Value": ["094951.202500"]}, "3325": {"vr": "TM", "Value": ["094712.362500"]}, "3326": {"vr": "TM", "Value": ["094845.045000"]}, "3327": {"vr": "TM", "Value": ["094928.900000"]}, "3328": {"vr": "TM", "Value": ["095312.432500"]}, "3329": {"vr": "TM", "Value": ["094756.655000"]}, "3330": {"vr": "TM", "Value": ["094548.900000"]}, "3331": {"vr": "TM", "Value": ["095439.847500"]}, "3332": {"vr": "TM", "Value": ["095356.140000"]}, "3333": {"vr": "TM", "Value": ["094800.900000"]}, "3334": {"vr": "TM", "Value": ["095051.632500"]}, "3335": {"vr": "TM", "Value": ["094941.232500"]}, "3336": {"vr": "TM", "Value": ["094637.602500"]}, "3337": {"vr": "TM", "Value": ["094514.742500"]}, "3338": {"vr": "TM", "Value": ["094701.075000"]}, "3339": {"vr": "TM", "Value": ["095100.870000"]}, "3340": {"vr": "TM", "Value": ["094929.945000"]}, "3341": {"vr": "TM", "Value": ["095125.660000"]}, "3342": {"vr": "TM", "Value": ["095253.367500"]}, "3343": {"vr": "TM", "Value": ["095000.587500"]}, "3344": {"vr": "TM", "Value": ["094529.982500"]}, "3345": {"vr": "TM", "Value": ["095104.237500"]}, "3346": {"vr": "TM", "Value": ["095338.247500"]}, "3347": {"vr": "TM", "Value": ["094823.202500"]}, "3348": {"vr": "TM", "Value": ["094856.500000"]}, "3349": {"vr": "TM", "Value": ["095417.105000"]}, "3350": {"vr": "TM", "Value": ["094700.345000"]}, "3351": {"vr": "TM", "Value": ["094617.952500"]}, "3352": {"vr": "TM", "Value": ["094740.372500"]}, "3353": {"vr": "TM", "Value": ["095322.110000"]}, "3354": {"vr": "TM", "Value": ["094858.547500"]}, "3355": {"vr": "TM", "Value": ["094951.787500"]}, "3356": {"vr": "TM", "Value": ["095018.920000"]}, "3357": {"vr": "TM", "Value": ["094537.905000"]}, "3358": {"vr": "TM", "Value": ["094759.142500"]}, "3359": {"vr": "TM", "Value": ["095350.265000"]}, "3360": {"vr": "TM", "Value": ["095330.325000"]}, "3361": {"vr": "TM", "Value": ["094848.285000"]}, "3362": {"vr": "TM", "Value": ["094921.875000"]}, "3363": {"vr": "TM", "Value": ["095335.885000"]}, "3364": {"vr": "TM", "Value": ["095240.597500"]}, "3365": {"vr": "TM", "Value": ["095451.865000"]}, "3366": {"vr": "TM", "Value": ["095414.617500"]}, "3367": {"vr": "TM", "Value": ["095339.562500"]}, "3368": {"vr": "TM", "Value": ["094707.367500"]}, "3369": {"vr": "TM", "Value": ["095229.455000"]}, "3370": {"vr": "TM", "Value": ["095143.260000"]}, "3371": {"vr": "TM", "Value": ["094917.612500"]}, "3372": {"vr": "TM", "Value": ["095236.500000"]}, "3373": {"vr": "TM", "Value": ["095205.105000"]}, "3374": {"vr": "TM", "Value": ["095041.660000"]}, "3375": {"vr": "TM", "Value": ["095224.315000"]}, "3376": {"vr": "TM", "Value": ["094823.787500"]}, "3377": {"vr": "TM", "Value": ["095245.885000"]}, "3378": {"vr": "TM", "Value": ["094854.430000"]}, "3379": {"vr": "TM", "Value": ["095006.900000"]}, "3380": {"vr": "TM", "Value": ["094737.592500"]}, "3381": {"vr": "TM", "Value": ["095210.977500"]}, "3382": {"vr": "TM", "Value": ["095000.442500"]}, "3383": {"vr": "TM", "Value": ["094605.622500"]}, "3384": {"vr": "TM", "Value": ["094958.100000"]}, "3385": {"vr": "TM", "Value": ["094803.992500"]}, "3386": {"vr": "TM", "Value": ["095204.812500"]}, "3387": {"vr": "TM", "Value": ["095439.700000"]}, "3388": {"vr": "TM", "Value": ["094946.352500"]}, "3389": {"vr": "TM", "Value": ["095311.115000"]}, "3390": {"vr": "TM", "Value": ["095324.012500"]}, "3391": {"vr": "TM", "Value": ["094812.352500"]}, "3392": {"vr": "TM", "Value": ["094749.905000"]}, "3393": {"vr": "TM", "Value": ["094955.445000"]}, "3394": {"vr": "TM", "Value": ["094550.822500"]}, "3395": {"vr": "TM", "Value": ["095204.957500"]}, "3396": {"vr": "TM", "Value": ["094704.440000"]}, "3397": {"vr": "TM", "Value": ["094804.140000"]}, "3398": {"vr": "TM", "Value": ["094634.237500"]}, "3399": {"vr": "TM", "Value": ["095219.485000"]}, "3400": {"vr": "TM", "Value": ["095019.797500"]}, "3401": {"vr": "TM", "Value": ["094946.645000"]}, "3402": {"vr": "TM", "Value": ["095111.280000"]}, "3403": {"vr": "TM", "Value": ["094849.017500"]}, "3404": {"vr": "TM", "Value": ["094747.270000"]}, "3405": {"vr": "TM", "Value": ["095001.172500"]}, "3406": {"vr": "TM", "Value": ["095240.305000"]}, "3407": {"vr": "TM", "Value": ["094707.222500"]}, "3408": {"vr": "TM", "Value": ["094622.635000"]}, "3409": {"vr": "TM", "Value": ["095155.135000"]}, "3410": {"vr": "TM", "Value": ["095103.650000"]}, "3411": {"vr": "TM", "Value": ["095212.150000"]}, "3412": {"vr": "TM", "Value": ["095358.335000"]}, "3413": {"vr": "TM", "Value": ["095413.155000"]}, "3414": {"vr": "TM", "Value": ["095253.075000"]}, "3415": {"vr": "TM", "Value": ["095321.232500"]}, "3416": {"vr": "TM", "Value": ["094926.412500"]}, "3417": {"vr": "TM", "Value": ["095119.495000"]}, "3418": {"vr": "TM", "Value": ["094530.715000"]}, "3419": {"vr": "TM", "Value": ["095333.105000"]}, "3420": {"vr": "TM", "Value": ["094733.767500"]}, "3421": {"vr": "TM", "Value": ["094629.532500"]}, "3422": {"vr": "TM", "Value": ["095348.217500"]}, "3423": {"vr": "TM", "Value": ["095412.422500"]}, "3424": {"vr": "TM", "Value": ["095013.045000"]}, "3425": {"vr": "TM", "Value": ["094950.910000"]}, "3426": {"vr": "TM", "Value": ["095332.520000"]}, "3427": {"vr": "TM", "Value": ["095110.695000"]}, "3428": {"vr": "TM", "Value": ["094924.947500"]}, "3429": {"vr": "TM", "Value": ["094933.017500"]}, "3430": {"vr": "TM", "Value": ["095102.627500"]}, "3431": {"vr": "TM", "Value": ["095313.310000"]}, "3432": {"vr": "TM", "Value": ["094616.345000"]}, "3433": {"vr": "TM", "Value": ["094613.397500"]}, "3434": {"vr": "TM", "Value": ["095226.237500"]}, "3435": {"vr": "TM", "Value": ["095154.547500"]}, "3436": {"vr": "TM", "Value": ["095315.065000"]}, "3437": {"vr": "TM", "Value": ["095337.662500"]}, "3438": {"vr": "TM", "Value": ["094809.115000"]}, "3439": {"vr": "TM", "Value": ["095129.465000"]}, "3440": {"vr": "TM", "Value": ["095236.355000"]}, "3441": {"vr": "TM", "Value": ["095305.827500"]}, "3442": {"vr": "TM", "Value": ["095153.817500"]}, "3443": {"vr": "TM", "Value": ["095338.977500"]}, "3444": {"vr": "TM", "Value": ["095009.972500"]}, "3445": {"vr": "TM", "Value": ["094527.640000"]}, "3446": {"vr": "TM", "Value": ["094508.285000"]}, "3447": {"vr": "TM", "Value": ["095407.280000"]}, "3448": {"vr": "TM", "Value": ["094934.480000"]}, "3449": {"vr": "TM", "Value": ["094857.377500"]}, "3450": {"vr": "TM", "Value": ["095239.280000"]}, "3451": {"vr": "TM", "Value": ["095025.232500"]}, "3452": {"vr": "TM", "Value": ["094835.367500"]}, "3453": {"vr": "TM", "Value": ["094905.152500"]}, "3454": {"vr": "TM", "Value": ["094821.300000"]}, "3455": {"vr": "TM", "Value": ["094619.562500"]}, "3456": {"vr": "TM", "Value": ["094925.387500"]}, "3457": {"vr": "TM", "Value": ["095230.335000"]}, "3458": {"vr": "TM", "Value": ["095101.602500"]}, "3459": {"vr": "TM", "Value": ["095356.577500"]}, "3460": {"vr": "TM", "Value": ["095052.947500"]}, "3461": {"vr": "TM", "Value": ["094627.925000"]}, "3462": {"vr": "TM", "Value": ["094759.727500"]}, "3463": {"vr": "TM", "Value": ["095119.202500"]}, "3464": {"vr": "TM", "Value": ["095429.875000"]}, "3465": {"vr": "TM", "Value": ["095123.007500"]}, "3466": {"vr": "TM", "Value": ["094843.582500"]}, "3467": {"vr": "TM", "Value": ["095331.495000"]}, "3468": {"vr": "TM", "Value": ["094813.962500"]}, "3469": {"vr": "TM", "Value": ["094716.167500"]}, "3470": {"vr": "TM", "Value": ["095113.330000"]}, "3471": {"vr": "TM", "Value": ["095059.992500"]}, "3472": {"vr": "TM", "Value": ["095341.905000"]}, "3473": {"vr": "TM", "Value": ["094559.182500"]}, "3474": {"vr": "TM", "Value": ["094649.915000"]}, "3475": {"vr": "TM", "Value": ["094921.437500"]}, "3476": {"vr": "TM", "Value": ["094542.167500"]}, "3477": {"vr": "TM", "Value": ["094518.840000"]}, "3478": {"vr": "TM", "Value": ["095344.832500"]}, "3479": {"vr": "TM", "Value": ["095055.142500"]}, "3480": {"vr": "TM", "Value": ["094706.635000"]}, "3481": {"vr": "TM", "Value": ["095449.085000"]}, "3482": {"vr": "TM", "Value": ["095248.080000"]}, "3483": {"vr": "TM", "Value": ["095343.075000"]}, "3484": {"vr": "TM", "Value": ["095349.827500"]}, "3485": {"vr": "TM", "Value": ["095118.617500"]}, "3486": {"vr": "TM", "Value": ["095239.572500"]}, "3487": {"vr": "TM", "Value": ["095442.772500"]}, "3488": {"vr": "TM", "Value": ["094539.515000"]}, "3489": {"vr": "TM", "Value": ["095218.755000"]}, "3490": {"vr": "TM", "Value": ["094553.602500"]}, "3491": {"vr": "TM", "Value": ["095329.740000"]}, "3492": {"vr": "TM", "Value": ["094824.520000"]}, "3493": {"vr": "TM", "Value": ["095416.080000"]}, "3494": {"vr": "TM", "Value": ["095044.442500"]}, "3495": {"vr": "TM", "Value": ["095223.290000"]}, "3496": {"vr": "TM", "Value": ["094911.300000"]}, "3497": {"vr": "TM", "Value": ["095117.592500"]}, "3498": {"vr": "TM", "Value": ["095314.480000"]}, "3499": {"vr": "TM", "Value": ["094902.060000"]}, "3500": {"vr": "TM", "Value": ["095256.880000"]}, "3501": {"vr": "TM", "Value": ["095004.537500"]}, "3502": {"vr": "TM", "Value": ["095005.437500"]}, "3503": {"vr": "TM", "Value": ["095312.870000"]}, "3504": {"vr": "TM", "Value": ["094538.050000"]}, "3505": {"vr": "TM", "Value": ["094756.217500"]}, "3506": {"vr": "TM", "Value": ["094846.090000"]}, "3507": {"vr": "TM", "Value": ["095036.812500"]}, "3508": {"vr": "TM", "Value": ["095249.837500"]}, "3509": {"vr": "TM", "Value": ["095148.675000"]}, "3510": {"vr": "TM", "Value": ["095007.925000"]}, "3511": {"vr": "TM", "Value": ["094509.602500"]}, "3512": {"vr": "TM", "Value": ["094918.197500"]}, "3513": {"vr": "TM", "Value": ["095050.460000"]}, "3514": {"vr": "TM", "Value": ["095348.802500"]}, "3515": {"vr": "TM", "Value": ["095013.485000"]}, "3516": {"vr": "TM", "Value": ["094522.792500"]}, "3517": {"vr": "TM", "Value": ["095407.865000"]}, "3518": {"vr": "TM", "Value": ["094723.797500"]}, "3519": {"vr": "TM", "Value": ["095015.847500"]}, "3520": {"vr": "TM", "Value": ["095204.227500"]}, "3521": {"vr": "TM", "Value": ["095450.110000"]}, "3522": {"vr": "TM", "Value": ["094505.942500"]}, "3523": {"vr": "TM", "Value": ["095435.290000"]}, "3524": {"vr": "TM", "Value": ["095129.612500"]}, "3525": {"vr": "TM", "Value": ["094949.447500"]}, "3526": {"vr": "TM", "Value": ["094831.855000"]}, "3527": {"vr": "TM", "Value": ["095412.862500"]}, "3528": {"vr": "TM", "Value": ["094749.320000"]}, "3529": {"vr": "TM", "Value": ["095448.792500"]}, "3530": {"vr": "TM", "Value": ["094806.627500"]}, "3531": {"vr": "TM", "Value": ["094631.142500"]}, "3532": {"vr": "TM", "Value": ["094819.982500"]}, "3533": {"vr": "TM", "Value": ["094817.915000"]}, "3534": {"vr": "TM", "Value": ["095350.997500"]}, "3535": {"vr": "TM", "Value": ["095208.032500"]}, "3536": {"vr": "TM", "Value": ["094708.245000"]}, "3537": {"vr": "TM", "Value": ["094607.982500"]}, "3538": {"vr": "TM", "Value": ["095157.767500"]}, "3539": {"vr": "TM", "Value": ["095453.622500"]}, "3540": {"vr": "TM", "Value": ["095040.637500"]}, "3541": {"vr": "TM", "Value": ["095159.690000"]}, "3542": {"vr": "TM", "Value": ["094747.855000"]}, "3543": {"vr": "TM", "Value": ["094902.500000"]}, "3544": {"vr": "TM", "Value": ["094931.407500"]}, "3545": {"vr": "TM", "Value": ["094841.680000"]}, "3546": {"vr": "TM", "Value": ["094952.665000"]}, "3547": {"vr": "TM", "Value": ["094830.977500"]}, "3548": {"vr": "TM", "Value": ["095057.192500"]}, "3549": {"vr": "TM", "Value": ["094607.837500"]}, "3550": {"vr": "TM", "Value": ["095129.172500"]}, "3551": {"vr": "TM", "Value": ["094610.177500"]}, "3552": {"vr": "TM", "Value": ["095401.260000"]}, "3553": {"vr": "TM", "Value": ["094933.455000"]}, "3554": {"vr": "TM", "Value": ["094830.245000"]}, "3555": {"vr": "TM", "Value": ["094927.582500"]}, "3556": {"vr": "TM", "Value": ["094806.335000"]}, "3557": {"vr": "TM", "Value": ["094729.962500"]}, "3558": {"vr": "TM", "Value": ["094606.060000"]}, "3559": {"vr": "TM", "Value": ["095031.545000"]}, "3560": {"vr": "TM", "Value": ["094921.582500"]}, "3561": {"vr": "TM", "Value": ["095231.357500"]}, "3562": {"vr": "TM", "Value": ["094859.720000"]}, "3563": {"vr": "TM", "Value": ["095212.002500"]}, "3564": {"vr": "TM", "Value": ["094907.495000"]}, "3565": {"vr": "TM", "Value": ["095309.337500"]}, "3566": {"vr": "TM", "Value": ["095032.567500"]}, "3567": {"vr": "TM", "Value": ["094604.597500"]}, "3568": {"vr": "TM", "Value": ["094524.860000"]}, "3569": {"vr": "TM", "Value": ["094705.027500"]}, "3570": {"vr": "TM", "Value": ["094816.890000"]}, "3571": {"vr": "TM", "Value": ["094549.630000"]}, "3572": {"vr": "TM", "Value": ["095031.690000"]}, "3573": {"vr": "TM", "Value": ["094541.730000"]}, "3574": {"vr": "TM", "Value": ["094617.075000"]}, "3575": {"vr": "TM", "Value": ["094650.060000"]}, "3576": {"vr": "TM", "Value": ["095131.075000"]}, "3577": {"vr": "TM", "Value": ["094932.577500"]}, "3578": {"vr": "TM", "Value": ["094638.332500"]}, "3579": {"vr": "TM", "Value": ["094950.470000"]}, "3580": {"vr": "TM", "Value": ["095416.812500"]}, "3581": {"vr": "TM", "Value": ["095257.905000"]}, "3582": {"vr": "TM", "Value": ["095015.115000"]}, "3583": {"vr": "TM", "Value": ["095439.992500"]}, "3584": {"vr": "TM", "Value": ["094658.275000"]}, "3585": {"vr": "TM", "Value": ["095031.377500"]}, "3586": {"vr": "TM", "Value": ["095345.875000"]}, "3587": {"vr": "TM", "Value": ["095339.710000"]}, "3588": {"vr": "TM", "Value": ["094855.622500"]}, "3589": {"vr": "TM", "Value": ["095313.455000"]}, "3590": {"vr": "TM", "Value": ["094835.660000"]}, "3591": {"vr": "TM", "Value": ["095250.567500"]}, "3592": {"vr": "TM", "Value": ["094901.475000"]}, "3593": {"vr": "TM", "Value": ["095303.925000"]}, "3594": {"vr": "TM", "Value": ["095236.060000"]}, "3595": {"vr": "TM", "Value": ["094718.382500"]}, "3596": {"vr": "TM", "Value": ["094823.055000"]}, "3597": {"vr": "TM", "Value": ["094727.767500"]}, "3598": {"vr": "TM", "Value": ["094825.105000"]}, "3599": {"vr": "TM", "Value": ["094535.710000"]}, "3600": {"vr": "TM", "Value": ["095124.782500"]}, "3601": {"vr": "TM", "Value": ["095225.777500"]}, "3602": {"vr": "TM", "Value": ["094933.747500"]}, "3603": {"vr": "TM", "Value": ["094810.137500"]}, "3604": {"vr": "TM", "Value": ["094901.915000"]}, "3605": {"vr": "TM", "Value": ["094919.367500"]}, "3606": {"vr": "TM", "Value": ["095027.135000"]}, "3607": {"vr": "TM", "Value": ["095429.290000"]}, "3608": {"vr": "TM", "Value": ["094726.285000"]}, "3609": {"vr": "TM", "Value": ["095349.242500"]}, "3610": {"vr": "TM", "Value": ["095310.967500"]}, "3611": {"vr": "TM", "Value": ["094556.382500"]}, "3612": {"vr": "TM", "Value": ["095007.777500"]}, "3613": {"vr": "TM", "Value": ["095231.650000"]}, "3614": {"vr": "TM", "Value": ["095310.090000"]}, "3615": {"vr": "TM", "Value": ["094614.860000"]}, "3616": {"vr": "TM", "Value": ["094930.967500"]}, "3617": {"vr": "TM", "Value": ["094652.567500"]}, "3618": {"vr": "TM", "Value": ["094612.957500"]}, "3619": {"vr": "TM", "Value": ["094525.300000"]}, "3620": {"vr": "TM", "Value": ["094758.850000"]}, "3621": {"vr": "TM", "Value": ["094831.270000"]}, "3622": {"vr": "TM", "Value": ["094556.090000"]}, "3623": {"vr": "TM", "Value": ["094640.527500"]}, "3624": {"vr": "TM", "Value": ["095438.090000"]}, "3625": {"vr": "TM", "Value": ["095432.217500"]}, "3626": {"vr": "TM", "Value": ["094916.880000"]}, "3627": {"vr": "TM", "Value": ["095337.955000"]}, "3628": {"vr": "TM", "Value": ["095141.192500"]}, "3629": {"vr": "TM", "Value": ["094546.557500"]}, "3630": {"vr": "TM", "Value": ["095343.515000"]}, "3631": {"vr": "TM", "Value": ["095402.432500"]}, "3632": {"vr": "TM", "Value": ["094728.352500"]}, "3633": {"vr": "TM", "Value": ["095209.075000"]}, "3634": {"vr": "TM", "Value": ["095348.070000"]}, "3635": {"vr": "TM", "Value": ["094909.105000"]}, "3636": {"vr": "TM", "Value": ["095436.460000"]}, "3637": {"vr": "TM", "Value": ["094544.510000"]}, "3638": {"vr": "TM", "Value": ["094645.670000"]}, "3639": {"vr": "TM", "Value": ["095425.757500"]}, "3640": {"vr": "TM", "Value": ["094958.392500"]}, "3641": {"vr": "TM", "Value": ["094838.460000"]}, "3642": {"vr": "TM", "Value": ["095424.442500"]}, "3643": {"vr": "TM", "Value": ["094934.335000"]}, "3644": {"vr": "TM", "Value": ["095104.090000"]}, "3645": {"vr": "TM", "Value": ["094622.050000"]}, "3646": {"vr": "TM", "Value": ["094704.732500"]}, "3647": {"vr": "TM", "Value": ["095234.285000"]}, "3648": {"vr": "TM", "Value": ["095213.027500"]}, "3649": {"vr": "TM", "Value": ["095010.120000"]}, "3650": {"vr": "TM", "Value": ["094848.432500"]}, "3651": {"vr": "TM", "Value": ["094756.947500"]}, "3652": {"vr": "TM", "Value": ["095018.627500"]}, "3653": {"vr": "TM", "Value": ["095317.260000"]}, "3654": {"vr": "TM", "Value": ["095000.735000"]}, "3655": {"vr": "TM", "Value": ["094652.715000"]}, "3656": {"vr": "TM", "Value": ["095142.675000"]}, "3657": {"vr": "TM", "Value": ["095402.285000"]}, "3658": {"vr": "TM", "Value": ["094558.285000"]}, "3659": {"vr": "TM", "Value": ["095404.207500"]}, "3660": {"vr": "TM", "Value": ["094625.290000"]}, "3661": {"vr": "TM", "Value": ["094726.745000"]}, "3662": {"vr": "TM", "Value": ["095330.177500"]}, "3663": {"vr": "TM", "Value": ["095333.250000"]}, "3664": {"vr": "TM", "Value": ["094622.490000"]}, "3665": {"vr": "TM", "Value": ["094726.430000"]}, "3666": {"vr": "TM", "Value": ["095217.145000"]}, "3667": {"vr": "TM", "Value": ["094919.222500"]}, "3668": {"vr": "TM", "Value": ["094647.427500"]}, "3669": {"vr": "TM", "Value": ["094753.582500"]}, "3670": {"vr": "TM", "Value": ["094748.587500"]}, "3671": {"vr": "TM", "Value": ["094937.260000"]}, "3672": {"vr": "TM", "Value": ["094544.362500"]}, "3673": {"vr": "TM", "Value": ["095454.060000"]}, "3674": {"vr": "TM", "Value": ["094614.422500"]}, "3675": {"vr": "TM", "Value": ["094850.920000"]}, "3676": {"vr": "TM", "Value": ["095215.660000"]}, "3677": {"vr": "TM", "Value": ["094605.182500"]}, "3678": {"vr": "TM", "Value": ["095211.270000"]}, "3679": {"vr": "TM", "Value": ["095215.075000"]}, "3680": {"vr": "TM", "Value": ["095125.075000"]}, "3681": {"vr": "TM", "Value": ["094651.982500"]}, "3682": {"vr": "TM", "Value": ["094757.240000"]}, "3683": {"vr": "TM", "Value": ["094939.767500"]}, "3684": {"vr": "TM", "Value": ["094621.905000"]}, "3685": {"vr": "TM", "Value": ["095200.567500"]}, "3686": {"vr": "TM", "Value": ["094835.807500"]}, "3687": {"vr": "TM", "Value": ["095136.802500"]}, "3688": {"vr": "TM", "Value": ["095053.387500"]}, "3689": {"vr": "TM", "Value": ["095227.992500"]}, "3690": {"vr": "TM", "Value": ["094534.537500"]}, "3691": {"vr": "TM", "Value": ["094833.905000"]}, "3692": {"vr": "TM", "Value": ["094600.792500"]}, "3693": {"vr": "TM", "Value": ["095029.915000"]}, "3694": {"vr": "TM", "Value": ["095408.597500"]}, "3695": {"vr": "TM", "Value": ["094608.567500"]}, "3696": {"vr": "TM", "Value": ["094957.222500"]}, "3697": {"vr": "TM", "Value": ["094859.427500"]}, "3698": {"vr": "TM", "Value": ["094644.500000"]}, "3699": {"vr": "TM", "Value": ["094803.845000"]}, "3700": {"vr": "TM", "Value": ["095433.095000"]}, "3701": {"vr": "TM", "Value": ["094631.582500"]}, "3702": {"vr": "TM", "Value": ["094733.035000"]}, "3703": {"vr": "TM", "Value": ["095421.222500"]}, "3704": {"vr": "TM", "Value": ["095145.602500"]}, "3705": {"vr": "TM", "Value": ["094600.352500"]}, "3706": {"vr": "TM", "Value": ["095042.977500"]}, "3707": {"vr": "TM", "Value": ["094701.515000"]}, "3708": {"vr": "TM", "Value": ["095213.757500"]}, "3709": {"vr": "TM", "Value": ["094811.475000"]}, "3710": {"vr": "TM", "Value": ["095233.700000"]}, "3711": {"vr": "TM", "Value": ["095320.207500"]}, "3712": {"vr": "TM", "Value": ["094852.967500"]}, "3713": {"vr": "TM", "Value": ["094523.377500"]}, "3714": {"vr": "TM", "Value": ["095423.125000"]}, "3715": {"vr": "TM", "Value": ["095039.007500"]}, "3716": {"vr": "TM", "Value": ["095137.095000"]}, "3717": {"vr": "TM", "Value": ["095406.550000"]}, "3718": {"vr": "TM", "Value": ["095334.567500"]}, "3719": {"vr": "TM", "Value": ["094555.942500"]}, "3720": {"vr": "TM", "Value": ["095242.792500"]}, "3721": {"vr": "TM", "Value": ["094942.987500"]}, "3722": {"vr": "TM", "Value": ["094857.670000"]}, "3723": {"vr": "TM", "Value": ["094823.495000"]}, "3724": {"vr": "TM", "Value": ["094714.265000"]}, "3725": {"vr": "TM", "Value": ["094635.552500"]}, "3726": {"vr": "TM", "Value": ["095207.737500"]}, "3727": {"vr": "TM", "Value": ["095041.515000"]}, "3728": {"vr": "TM", "Value": ["095148.822500"]}, "3729": {"vr": "TM", "Value": ["095311.700000"]}, "3730": {"vr": "TM", "Value": ["094609.737500"]}, "3731": {"vr": "TM", "Value": ["095111.720000"]}, "3732": {"vr": "TM", "Value": ["094703.710000"]}, "3733": {"vr": "TM", "Value": ["094531.152500"]}, "3734": {"vr": "TM", "Value": ["095407.572500"]}, "3735": {"vr": "TM", "Value": ["095318.432500"]}, "3736": {"vr": "TM", "Value": ["095354.967500"]}, "3737": {"vr": "TM", "Value": ["094844.752500"]}, "3738": {"vr": "TM", "Value": ["095428.100000"]}, "3739": {"vr": "TM", "Value": ["095038.860000"]}, "3740": {"vr": "TM", "Value": ["094801.945000"]}, "3741": {"vr": "TM", "Value": ["095119.055000"]}, "3742": {"vr": "TM", "Value": ["094957.075000"]}, "3743": {"vr": "TM", "Value": ["095228.870000"]}, "3744": {"vr": "TM", "Value": ["094512.235000"]}, "3745": {"vr": "TM", "Value": ["094527.202500"]}, "3746": {"vr": "TM", "Value": ["094751.222500"]}, "3747": {"vr": "TM", "Value": ["095356.432500"]}, "3748": {"vr": "TM", "Value": ["095340.587500"]}, "3749": {"vr": "TM", "Value": ["094814.402500"]}, "3750": {"vr": "TM", "Value": ["094840.217500"]}, "3751": {"vr": "TM", "Value": ["094758.265000"]}, "3752": {"vr": "TM", "Value": ["094800.752500"]}, "3753": {"vr": "TM", "Value": ["094928.315000"]}, "3754": {"vr": "TM", "Value": ["094949.740000"]}, "3755": {"vr": "TM", "Value": ["095012.167500"]}, "3756": {"vr": "TM", "Value": ["095134.167500"]}, "3757": {"vr": "TM", "Value": ["094624.977500"]}, "3758": {"vr": "TM", "Value": ["095322.255000"]}, "3759": {"vr": "TM", "Value": ["094922.607500"]}, "3760": {"vr": "TM", "Value": ["094632.315000"]}, "3761": {"vr": "TM", "Value": ["094911.152500"]}, "3762": {"vr": "TM", "Value": ["094549.337500"]}, "3763": {"vr": "TM", "Value": ["095140.022500"]}, "3764": {"vr": "TM", "Value": ["095050.167500"]}, "3765": {"vr": "TM", "Value": ["095441.017500"]}, "3766": {"vr": "TM", "Value": ["094942.255000"]}, "3767": {"vr": "TM", "Value": ["095120.227500"]}, "3768": {"vr": "TM", "Value": ["095323.427500"]}, "3769": {"vr": "TM", "Value": ["094641.992500"]}, "3770": {"vr": "TM", "Value": ["094728.060000"]}, "3771": {"vr": "TM", "Value": ["095426.637500"]}, "3772": {"vr": "TM", "Value": ["095007.632500"]}, "3773": {"vr": "TM", "Value": ["095306.850000"]}, "3774": {"vr": "TM", "Value": ["094919.515000"]}, "3775": {"vr": "TM", "Value": ["095103.942500"]}, "3776": {"vr": "TM", "Value": ["094522.500000"]}, "3777": {"vr": "TM", "Value": ["095008.947500"]}, "3778": {"vr": "TM", "Value": ["094552.285000"]}, "3779": {"vr": "TM", "Value": ["094829.367500"]}, "3780": {"vr": "TM", "Value": ["094549.945000"]}, "3781": {"vr": "TM", "Value": ["095333.545000"]}, "3782": {"vr": "TM", "Value": ["094629.240000"]}, "3783": {"vr": "TM", "Value": ["094639.065000"]}, "3784": {"vr": "TM", "Value": ["095436.900000"]}, "3785": {"vr": "TM", "Value": ["094642.577500"]}, "3786": {"vr": "TM", "Value": ["095013.192500"]}, "3787": {"vr": "TM", "Value": ["094520.597500"]}, "3788": {"vr": "TM", "Value": ["094646.987500"]}, "3789": {"vr": "TM", "Value": ["095256.442500"]}, "3790": {"vr": "TM", "Value": ["094654.177500"]}, "3791": {"vr": "TM", "Value": ["094619.710000"]}, "3792": {"vr": "TM", "Value": ["094731.280000"]}, "3793": {"vr": "TM", "Value": ["094932.870000"]}, "3794": {"vr": "TM", "Value": ["094523.230000"]}, "3795": {"vr": "TM", "Value": ["095137.387500"]}, "3796": {"vr": "TM", "Value": ["095418.860000"]}, "3797": {"vr": "TM", "Value": ["094740.227500"]}, "3798": {"vr": "TM", "Value": ["095130.782500"]}, "3799": {"vr": "TM", "Value": ["094733.622500"]}, "3800": {"vr": "TM", "Value": ["095408.157500"]}, "3801": {"vr": "TM", "Value": ["094933.162500"]}, "3802": {"vr": "TM", "Value": ["095350.412500"]}, "3803": {"vr": "TM", "Value": ["094635.700000"]}, "3804": {"vr": "TM", "Value": ["095122.567500"]}, "3805": {"vr": "TM", "Value": ["095137.242500"]}, "3806": {"vr": "TM", "Value": ["095141.632500"]}, "3807": {"vr": "TM", "Value": ["095252.177500"]}, "3808": {"vr": "TM", "Value": ["095413.007500"]}, "3809": {"vr": "TM", "Value": ["094656.080000"]}, "3810": {"vr": "TM", "Value": ["095324.890000"]}, "3811": {"vr": "TM", "Value": ["095223.437500"]}, "3812": {"vr": "TM", "Value": ["095439.555000"]}, "3813": {"vr": "TM", "Value": ["095206.715000"]}, "3814": {"vr": "TM", "Value": ["094845.337500"]}, "3815": {"vr": "TM", "Value": ["095104.675000"]}, "3816": {"vr": "TM", "Value": ["095153.232500"]}, "3817": {"vr": "TM", "Value": ["095146.627500"]}, "3818": {"vr": "TM", "Value": ["094639.650000"]}, "3819": {"vr": "TM", "Value": ["094815.865000"]}, "3820": {"vr": "TM", "Value": ["095125.807500"]}, "3821": {"vr": "TM", "Value": ["095044.587500"]}, "3822": {"vr": "TM", "Value": ["095416.520000"]}, "3823": {"vr": "TM", "Value": ["095202.470000"]}, "3824": {"vr": "TM", "Value": ["095443.945000"]}, "3825": {"vr": "TM", "Value": ["094821.007500"]}, "3826": {"vr": "TM", "Value": ["094542.460000"]}, "3827": {"vr": "TM", "Value": ["095022.745000"]}, "3828": {"vr": "TM", "Value": ["094811.622500"]}, "3829": {"vr": "TM", "Value": ["095304.070000"]}, "3830": {"vr": "TM", "Value": ["094900.450000"]}, "3831": {"vr": "TM", "Value": ["095050.022500"]}, "3832": {"vr": "TM", "Value": ["095003.222500"]}, "3833": {"vr": "TM", "Value": ["094932.140000"]}, "3834": {"vr": "TM", "Value": ["094556.967500"]}, "3835": {"vr": "TM", "Value": ["095352.460000"]}, "3836": {"vr": "TM", "Value": ["095216.832500"]}, "3837": {"vr": "TM", "Value": ["094720.140000"]}, "3838": {"vr": "TM", "Value": ["094515.182500"]}, "3839": {"vr": "TM", "Value": ["094515.622500"]}, "3840": {"vr": "TM", "Value": ["095253.515000"]}, "3841": {"vr": "TM", "Value": ["094656.665000"]}, "3842": {"vr": "TM", "Value": ["094550.090000"]}, "3843": {"vr": "TM", "Value": ["095059.407500"]}, "3844": {"vr": "TM", "Value": ["094656.227500"]}, "3845": {"vr": "TM", "Value": ["094822.470000"]}, "3846": {"vr": "TM", "Value": ["095200.422500"]}, "3847": {"vr": "TM", "Value": ["095123.737500"]}, "3848": {"vr": "TM", "Value": ["095126.685000"]}, "3849": {"vr": "TM", "Value": ["095409.622500"]}, "3850": {"vr": "TM", "Value": ["095013.777500"]}, "3851": {"vr": "TM", "Value": ["095158.645000"]}, "3852": {"vr": "TM", "Value": ["094708.685000"]}, "3853": {"vr": "TM", "Value": ["094549.192500"]}, "3854": {"vr": "TM", "Value": ["094836.977500"]}, "3855": {"vr": "TM", "Value": ["095449.962500"]}, "3856": {"vr": "TM", "Value": ["094529.397500"]}, "3857": {"vr": "TM", "Value": ["094703.855000"]}, "3858": {"vr": "TM", "Value": ["094527.495000"]}, "3859": {"vr": "TM", "Value": ["095025.962500"]}, "3860": {"vr": "TM", "Value": ["094719.992500"]}, "3861": {"vr": "TM", "Value": ["094945.622500"]}, "3862": {"vr": "TM", "Value": ["094739.640000"]}, "3863": {"vr": "TM", "Value": ["095310.382500"]}, "3864": {"vr": "TM", "Value": ["094849.162500"]}, "3865": {"vr": "TM", "Value": ["095104.530000"]}, "3866": {"vr": "TM", "Value": ["094926.265000"]}, "3867": {"vr": "TM", "Value": ["094605.035000"]}, "3868": {"vr": "TM", "Value": ["094654.032500"]}, "3869": {"vr": "TM", "Value": ["095231.065000"]}, "3870": {"vr": "TM", "Value": ["095429.582500"]}, "3871": {"vr": "TM", "Value": ["095329.592500"]}, "3872": {"vr": "TM", "Value": ["094603.720000"]}, "3873": {"vr": "TM", "Value": ["095252.930000"]}, "3874": {"vr": "TM", "Value": ["095132.685000"]}, "3875": {"vr": "TM", "Value": ["095400.382500"]}, "3876": {"vr": "TM", "Value": ["094736.422500"]}, "3877": {"vr": "TM", "Value": ["095353.485000"]}, "3878": {"vr": "TM", "Value": ["095315.212500"]}, "3879": {"vr": "TM", "Value": ["094720.432500"]}, "3880": {"vr": "TM", "Value": ["095155.280000"]}, "3881": {"vr": "TM", "Value": ["094853.992500"]}, "3882": {"vr": "TM", "Value": ["095141.777500"]}, "3883": {"vr": "TM", "Value": ["094922.315000"]}, "3884": {"vr": "TM", "Value": ["095005.582500"]}, "3885": {"vr": "TM", "Value": ["094646.110000"]}, "3886": {"vr": "TM", "Value": ["095305.535000"]}, "3887": {"vr": "TM", "Value": ["095020.822500"]}, "3888": {"vr": "TM", "Value": ["094800.607500"]}, "3889": {"vr": "TM", "Value": ["094537.320000"]}, "3890": {"vr": "TM", "Value": ["094916.295000"]}, "3891": {"vr": "TM", "Value": ["095105.700000"]}, "3892": {"vr": "TM", "Value": ["095411.982500"]}, "3893": {"vr": "TM", "Value": ["095145.895000"]}, "3894": {"vr": "TM", "Value": ["094546.997500"]}, "3895": {"vr": "TM", "Value": ["094728.500000"]}, "3896": {"vr": "TM", "Value": ["095417.690000"]}, "3897": {"vr": "TM", "Value": ["095336.637500"]}, "3898": {"vr": "TM", "Value": ["095058.090000"]}, "3899": {"vr": "TM", "Value": ["095200.860000"]}, "3900": {"vr": "TM", "Value": ["094645.232500"]}, "3901": {"vr": "TM", "Value": ["095247.055000"]}, "3902": {"vr": "TM", "Value": ["095021.992500"]}, "3903": {"vr": "TM", "Value": ["095222.850000"]}, "3904": {"vr": "TM", "Value": ["094945.475000"]}, "3905": {"vr": "TM", "Value": ["095430.755000"]}, "3906": {"vr": "TM", "Value": ["095032.275000"]}, "3907": {"vr": "TM", "Value": ["095341.465000"]}, "3908": {"vr": "TM", "Value": ["094800.460000"]}, "3909": {"vr": "TM", "Value": ["094637.162500"]}, "3910": {"vr": "TM", "Value": ["094547.582500"]}, "3911": {"vr": "TM", "Value": ["094840.947500"]}, "3912": {"vr": "TM", "Value": ["095402.745000"]}, "3913": {"vr": "TM", "Value": ["094918.782500"]}, "3914": {"vr": "TM", "Value": ["095047.367500"]}, "3915": {"vr": "TM", "Value": ["094524.715000"]}, "3916": {"vr": "TM", "Value": ["094823.347500"]}, "3917": {"vr": "TM", "Value": ["094603.572500"]}, "3918": {"vr": "TM", "Value": ["094948.567500"]}, "3919": {"vr": "TM", "Value": ["094908.665000"]}, "3920": {"vr": "TM", "Value": ["094747.562500"]}, "3921": {"vr": "TM", "Value": ["095320.940000"]}, "3922": {"vr": "TM", "Value": ["095420.637500"]}, "3923": {"vr": "TM", "Value": ["094628.947500"]}, "3924": {"vr": "TM", "Value": ["094525.445000"]}, "3925": {"vr": "TM", "Value": ["094752.245000"]}, "3926": {"vr": "TM", "Value": ["095208.177500"]}, "3927": {"vr": "TM", "Value": ["095220.217500"]}, "3928": {"vr": "TM", "Value": ["095001.757500"]}, "3929": {"vr": "TM", "Value": ["095304.362500"]}, "3930": {"vr": "TM", "Value": ["095229.310000"]}, "3931": {"vr": "TM", "Value": ["094945.035000"]}, "3932": {"vr": "TM", "Value": ["095145.162500"]}, "3933": {"vr": "TM", "Value": ["095343.952500"]}, "3934": {"vr": "TM", "Value": ["095023.622500"]}, "3935": {"vr": "TM", "Value": ["095342.782500"]}, "3936": {"vr": "TM", "Value": ["095029.330000"]}, "3937": {"vr": "TM", "Value": ["095138.412500"]}, "3938": {"vr": "TM", "Value": ["095417.250000"]}, "3939": {"vr": "TM", "Value": ["094641.700000"]}, "3940": {"vr": "TM", "Value": ["094906.325000"]}, "3941": {"vr": "TM", "Value": ["095328.422500"]}, "3942": {"vr": "TM", "Value": ["095202.177500"]}, "3943": {"vr": "TM", "Value": ["095406.695000"]}, "3944": {"vr": "TM", "Value": ["095040.177500"]}, "3945": {"vr": "TM", "Value": ["094824.665000"]}, "3946": {"vr": "TM", "Value": ["095407.427500"]}, "3947": {"vr": "TM", "Value": ["094641.845000"]}, "3948": {"vr": "TM", "Value": ["094811.915000"]}, "3949": {"vr": "TM", "Value": ["095346.315000"]}, "3950": {"vr": "TM", "Value": ["095109.962500"]}, "3951": {"vr": "TM", "Value": ["094848.870000"]}, "3952": {"vr": "TM", "Value": ["095023.182500"]}, "3953": {"vr": "TM", "Value": ["095029.767500"]}, "3954": {"vr": "TM", "Value": ["094613.250000"]}, "3955": {"vr": "TM", "Value": ["095444.382500"]}, "3956": {"vr": "TM", "Value": ["095014.382500"]}, "3957": {"vr": "TM", "Value": ["094953.542500"]}, "3958": {"vr": "TM", "Value": ["094831.562500"]}, "3959": {"vr": "TM", "Value": ["095340.295000"]}, "3960": {"vr": "TM", "Value": ["095132.245000"]}, "3961": {"vr": "TM", "Value": ["095203.350000"]}, "3962": {"vr": "TM", "Value": ["095306.557500"]}, "3963": {"vr": "TM", "Value": ["094715.142500"]}, "3964": {"vr": "TM", "Value": ["095151.622500"]}, "3965": {"vr": "TM", "Value": ["095434.850000"]}, "3966": {"vr": "TM", "Value": ["094655.495000"]}, "3967": {"vr": "TM", "Value": ["094858.110000"]}, "3968": {"vr": "TM", "Value": ["094649.767500"]}, "3969": {"vr": "TM", "Value": ["094549.777500"]}, "3970": {"vr": "TM", "Value": ["094928.022500"]}, "3971": {"vr": "TM", "Value": ["094602.402500"]}, "3972": {"vr": "TM", "Value": ["095230.920000"]}, "3973": {"vr": "TM", "Value": ["094854.137500"]}, "3974": {"vr": "TM", "Value": ["094757.827500"]}, "3975": {"vr": "TM", "Value": ["095245.300000"]}, "3976": {"vr": "TM", "Value": ["094531.007500"]}, "3977": {"vr": "TM", "Value": ["094624.537500"]}, "3978": {"vr": "TM", "Value": ["095428.392500"]}, "3979": {"vr": "TM", "Value": ["094917.757500"]}, "3980": {"vr": "TM", "Value": ["094638.187500"]}, "3981": {"vr": "TM", "Value": ["095207.592500"]}, "3982": {"vr": "TM", "Value": ["094946.060000"]}, "3983": {"vr": "TM", "Value": ["094538.490000"]}, "3984": {"vr": "TM", "Value": ["094741.105000"]}, "3985": {"vr": "TM", "Value": ["095044.880000"]}, "3986": {"vr": "TM", "Value": ["095419.152500"]}, "3987": {"vr": "TM", "Value": ["094905.592500"]}, "3988": {"vr": "TM", "Value": ["094946.500000"]}, "3989": {"vr": "TM", "Value": ["094840.070000"]}, "3990": {"vr": "TM", "Value": ["095033.885000"]}, "3991": {"vr": "TM", "Value": ["095039.152500"]}, "3992": {"vr": "TM", "Value": ["095418.422500"]}, "3993": {"vr": "TM", "Value": ["095331.350000"]}, "3994": {"vr": "TM", "Value": ["094935.942500"]}, "3995": {"vr": "TM", "Value": ["094652.422500"]}, "3996": {"vr": "TM", "Value": ["094555.357500"]}, "3997": {"vr": "TM", "Value": ["095339.855000"]}, "3998": {"vr": "TM", "Value": ["094935.065000"]}, "3999": {"vr": "TM", "Value": ["095206.860000"]}, "4000": {"vr": "TM", "Value": ["095348.362500"]}, "4001": {"vr": "TM", "Value": ["095202.762500"]}, "4002": {"vr": "TM", "Value": ["095237.085000"]}, "4003": {"vr": "TM", "Value": ["094832.587500"]}, "4004": {"vr": "TM", "Value": ["095332.957500"]}, "4005": {"vr": "TM", "Value": ["094720.285000"]}, "4006": {"vr": "TM", "Value": ["094612.080000"]}, "4007": {"vr": "TM", "Value": ["095055.730000"]}, "4008": {"vr": "TM", "Value": ["094710.900000"]}, "4009": {"vr": "TM", "Value": ["094956.782500"]}, "4010": {"vr": "TM", "Value": ["095009.095000"]}, "4011": {"vr": "TM", "Value": ["094646.255000"]}, "4012": {"vr": "TM", "Value": ["095255.710000"]}, "4013": {"vr": "TM", "Value": ["094636.870000"]}, "4014": {"vr": "TM", "Value": ["094811.330000"]}, "4015": {"vr": "TM", "Value": ["095402.577500"]}, "4016": {"vr": "TM", "Value": ["095347.925000"]}, "4017": {"vr": "TM", "Value": ["094945.330000"]}, "4018": {"vr": "TM", "Value": ["095227.847500"]}, "4019": {"vr": "TM", "Value": ["095054.997500"]}}, "00080033": {"0": {"vr": "TM", "Value": ["094827.811000"]}, "1": {"vr": "TM", "Value": ["094947.660000"]}, "2": {"vr": "TM", "Value": ["095127.776000"]}, "3": {"vr": "TM", "Value": ["095147.804000"]}, "4": {"vr": "TM", "Value": ["095107.672000"]}, "5": {"vr": "TM", "Value": ["095047.889000"]}, "6": {"vr": "TM", "Value": ["095307.863000"]}, "7": {"vr": "TM", "Value": ["095327.829000"]}, "8": {"vr": "TM", "Value": ["094847.667000"]}, "9": {"vr": "TM", "Value": ["094707.827000"]}, "10": {"vr": "TM", "Value": ["095307.825000"]}, "11": {"vr": "TM", "Value": ["094847.852000"]}, "12": {"vr": "TM", "Value": ["094847.774000"]}, "13": {"vr": "TM", "Value": ["094527.681000"]}, "14": {"vr": "TM", "Value": ["095007.805000"]}, "15": {"vr": "TM", "Value": ["095207.670000"]}, "16": {"vr": "TM", "Value": ["095247.920000"]}, "17": {"vr": "TM", "Value": ["094607.854000"]}, "18": {"vr": "TM", "Value": ["094807.810000"]}, "19": {"vr": "TM", "Value": ["095207.729000"]}, "20": {"vr": "TM", "Value": ["094727.655000"]}, "21": {"vr": "TM", "Value": ["095207.916000"]}, "22": {"vr": "TM", "Value": ["095227.930000"]}, "23": {"vr": "TM", "Value": ["095407.705000"]}, "24": {"vr": "TM", "Value": ["095227.666000"]}, "25": {"vr": "TM", "Value": ["094807.770000"]}, "26": {"vr": "TM", "Value": ["094947.815000"]}, "27": {"vr": "TM", "Value": ["094727.896000"]}, "28": {"vr": "TM", "Value": ["094747.949000"]}, "29": {"vr": "TM", "Value": ["095147.882000"]}, "30": {"vr": "TM", "Value": ["094947.846000"]}, "31": {"vr": "TM", "Value": ["094827.939000"]}, "32": {"vr": "TM", "Value": ["095027.864000"]}, "33": {"vr": "TM", "Value": ["094747.821000"]}, "34": {"vr": "TM", "Value": ["095456.546000"]}, "35": {"vr": "TM", "Value": ["094527.618000"]}, "36": {"vr": "TM", "Value": ["094647.883000"]}, "37": {"vr": "TM", "Value": ["094807.723000"]}, "38": {"vr": "TM", "Value": ["095107.925000"]}, "39": {"vr": "TM", "Value": ["094927.742000"]}, "40": {"vr": "TM", "Value": ["095327.790000"]}, "41": {"vr": "TM", "Value": ["095427.944000"]}, "42": {"vr": "TM", "Value": ["095447.685000"]}, "43": {"vr": "TM", "Value": ["094807.812000"]}, "44": {"vr": "TM", "Value": ["095307.634000"]}, "45": {"vr": "TM", "Value": ["094627.764000"]}, "46": {"vr": "TM", "Value": ["095307.845000"]}, "47": {"vr": "TM", "Value": ["095427.881000"]}, "48": {"vr": "TM", "Value": ["094927.616000"]}, "49": {"vr": "TM", "Value": ["094547.697000"]}, "50": {"vr": "TM", "Value": ["095247.637000"]}, "51": {"vr": "TM", "Value": ["095247.775000"]}, "52": {"vr": "TM", "Value": ["095307.608000"]}, "53": {"vr": "TM", "Value": ["094827.763000"]}, "54": {"vr": "TM", "Value": ["094647.710000"]}, "55": {"vr": "TM", "Value": ["094907.641000"]}, "56": {"vr": "TM", "Value": ["095047.915000"]}, "57": {"vr": "TM", "Value": ["094907.946000"]}, "58": {"vr": "TM", "Value": ["094847.651000"]}, "59": {"vr": "TM", "Value": ["094747.612000"]}, "60": {"vr": "TM", "Value": ["095147.849000"]}, "61": {"vr": "TM", "Value": ["095327.697000"]}, "62": {"vr": "TM", "Value": ["094827.760000"]}, "63": {"vr": "TM", "Value": ["095447.788000"]}, "64": {"vr": "TM", "Value": ["095047.838000"]}, "65": {"vr": "TM", "Value": ["095447.811000"]}, "66": {"vr": "TM", "Value": ["094827.784000"]}, "67": {"vr": "TM", "Value": ["094847.900000"]}, "68": {"vr": "TM", "Value": ["094707.680000"]}, "69": {"vr": "TM", "Value": ["094727.761000"]}, "70": {"vr": "TM", "Value": ["094647.606000"]}, "71": {"vr": "TM", "Value": ["095107.642000"]}, "72": {"vr": "TM", "Value": ["095047.907000"]}, "73": {"vr": "TM", "Value": ["095207.918000"]}, "74": {"vr": "TM", "Value": ["094607.931000"]}, "75": {"vr": "TM", "Value": ["095427.619000"]}, "76": {"vr": "TM", "Value": ["095207.859000"]}, "77": {"vr": "TM", "Value": ["094947.870000"]}, "78": {"vr": "TM", "Value": ["095147.892000"]}, "79": {"vr": "TM", "Value": ["094747.806000"]}, "80": {"vr": "TM", "Value": ["095456.515000"]}, "81": {"vr": "TM", "Value": ["094607.923000"]}, "82": {"vr": "TM", "Value": ["095127.678000"]}, "83": {"vr": "TM", "Value": ["095027.862000"]}, "84": {"vr": "TM", "Value": ["094527.933000"]}, "85": {"vr": "TM", "Value": ["095207.639000"]}, "86": {"vr": "TM", "Value": ["095247.855000"]}, "87": {"vr": "TM", "Value": ["095207.900000"]}, "88": {"vr": "TM", "Value": ["094907.934000"]}, "89": {"vr": "TM", "Value": ["095347.923000"]}, "90": {"vr": "TM", "Value": ["094527.655000"]}, "91": {"vr": "TM", "Value": ["094707.634000"]}, "92": {"vr": "TM", "Value": ["095227.817000"]}, "93": {"vr": "TM", "Value": ["094627.962000"]}, "94": {"vr": "TM", "Value": ["095347.853000"]}, "95": {"vr": "TM", "Value": ["094727.929000"]}, "96": {"vr": "TM", "Value": ["094747.759000"]}, "97": {"vr": "TM", "Value": ["095447.901000"]}, "98": {"vr": "TM", "Value": ["094527.851000"]}, "99": {"vr": "TM", "Value": ["094527.865000"]}, "100": {"vr": "TM", "Value": ["094627.756000"]}, "101": {"vr": "TM", "Value": ["094907.693000"]}, "102": {"vr": "TM", "Value": ["094627.812000"]}, "103": {"vr": "TM", "Value": ["095027.739000"]}, "104": {"vr": "TM", "Value": ["095307.751000"]}, "105": {"vr": "TM", "Value": ["095347.802000"]}, "106": {"vr": "TM", "Value": ["095227.671000"]}, "107": {"vr": "TM", "Value": ["095347.666000"]}, "108": {"vr": "TM", "Value": ["094727.721000"]}, "109": {"vr": "TM", "Value": ["094727.748000"]}, "110": {"vr": "TM", "Value": ["095447.773000"]}, "111": {"vr": "TM", "Value": ["095307.809000"]}, "112": {"vr": "TM", "Value": ["094827.854000"]}, "113": {"vr": "TM", "Value": ["095447.693000"]}, "114": {"vr": "TM", "Value": ["095007.882000"]}, "115": {"vr": "TM", "Value": ["095227.830000"]}, "116": {"vr": "TM", "Value": ["095327.630000"]}, "117": {"vr": "TM", "Value": ["094707.922000"]}, "118": {"vr": "TM", "Value": ["095147.632000"]}, "119": {"vr": "TM", "Value": ["095447.945000"]}, "120": {"vr": "TM", "Value": ["094607.654000"]}, "121": {"vr": "TM", "Value": ["094547.687000"]}, "122": {"vr": "TM", "Value": ["095247.863000"]}, "123": {"vr": "TM", "Value": ["094527.820000"]}, "124": {"vr": "TM", "Value": ["095227.747000"]}, "125": {"vr": "TM", "Value": ["095007.946000"]}, "126": {"vr": "TM", "Value": ["095447.634000"]}, "127": {"vr": "TM", "Value": ["094927.804000"]}, "128": {"vr": "TM", "Value": ["095147.731000"]}, "129": {"vr": "TM", "Value": ["094827.636000"]}, "130": {"vr": "TM", "Value": ["094627.694000"]}, "131": {"vr": "TM", "Value": ["095147.898000"]}, "132": {"vr": "TM", "Value": ["095347.794000"]}, "133": {"vr": "TM", "Value": ["095427.899000"]}, "134": {"vr": "TM", "Value": ["095347.820000"]}, "135": {"vr": "TM", "Value": ["094747.900000"]}, "136": {"vr": "TM", "Value": ["094947.853000"]}, "137": {"vr": "TM", "Value": ["095047.882000"]}, "138": {"vr": "TM", "Value": ["094627.741000"]}, "139": {"vr": "TM", "Value": ["094807.836000"]}, "140": {"vr": "TM", "Value": ["094847.793000"]}, "141": {"vr": "TM", "Value": ["094547.822000"]}, "142": {"vr": "TM", "Value": ["095027.800000"]}, "143": {"vr": "TM", "Value": ["095247.875000"]}, "144": {"vr": "TM", "Value": ["095027.910000"]}, "145": {"vr": "TM", "Value": ["095307.656000"]}, "146": {"vr": "TM", "Value": ["094607.861000"]}, "147": {"vr": "TM", "Value": ["094727.891000"]}, "148": {"vr": "TM", "Value": ["095307.868000"]}, "149": {"vr": "TM", "Value": ["095247.843000"]}, "150": {"vr": "TM", "Value": ["095007.753000"]}, "151": {"vr": "TM", "Value": ["094727.789000"]}, "152": {"vr": "TM", "Value": ["095447.793000"]}, "153": {"vr": "TM", "Value": ["094747.704000"]}, "154": {"vr": "TM", "Value": ["094527.796000"]}, "155": {"vr": "TM", "Value": ["095207.780000"]}, "156": {"vr": "TM", "Value": ["094807.611000"]}, "157": {"vr": "TM", "Value": ["094907.832000"]}, "158": {"vr": "TM", "Value": ["095047.607000"]}, "159": {"vr": "TM", "Value": ["094607.776000"]}, "160": {"vr": "TM", "Value": ["095456.529000"]}, "161": {"vr": "TM", "Value": ["095307.771000"]}, "162": {"vr": "TM", "Value": ["094747.770000"]}, "163": {"vr": "TM", "Value": ["095247.822000"]}, "164": {"vr": "TM", "Value": ["094707.830000"]}, "165": {"vr": "TM", "Value": ["095247.608000"]}, "166": {"vr": "TM", "Value": ["095107.637000"]}, "167": {"vr": "TM", "Value": ["094927.611000"]}, "168": {"vr": "TM", "Value": ["094647.702000"]}, "169": {"vr": "TM", "Value": ["094807.950000"]}, "170": {"vr": "TM", "Value": ["094607.710000"]}, "171": {"vr": "TM", "Value": ["094807.795000"]}, "172": {"vr": "TM", "Value": ["094547.869000"]}, "173": {"vr": "TM", "Value": ["095427.949000"]}, "174": {"vr": "TM", "Value": ["094727.703000"]}, "175": {"vr": "TM", "Value": ["094827.802000"]}, "176": {"vr": "TM", "Value": ["094527.982000"]}, "177": {"vr": "TM", "Value": ["095307.704000"]}, "178": {"vr": "TM", "Value": ["095427.633000"]}, "179": {"vr": "TM", "Value": ["095247.930000"]}, "180": {"vr": "TM", "Value": ["094707.892000"]}, "181": {"vr": "TM", "Value": ["094827.839000"]}, "182": {"vr": "TM", "Value": ["095247.642000"]}, "183": {"vr": "TM", "Value": ["095127.734000"]}, "184": {"vr": "TM", "Value": ["094547.717000"]}, "185": {"vr": "TM", "Value": ["094807.651000"]}, "186": {"vr": "TM", "Value": ["095227.811000"]}, "187": {"vr": "TM", "Value": ["095227.837000"]}, "188": {"vr": "TM", "Value": ["095427.910000"]}, "189": {"vr": "TM", "Value": ["094907.819000"]}, "190": {"vr": "TM", "Value": ["095027.844000"]}, "191": {"vr": "TM", "Value": ["094527.772000"]}, "192": {"vr": "TM", "Value": ["095207.908000"]}, "193": {"vr": "TM", "Value": ["094627.684000"]}, "194": {"vr": "TM", "Value": ["095427.708000"]}, "195": {"vr": "TM", "Value": ["095047.633000"]}, "196": {"vr": "TM", "Value": ["095127.611000"]}, "197": {"vr": "TM", "Value": ["094907.864000"]}, "198": {"vr": "TM", "Value": ["094527.663000"]}, "199": {"vr": "TM", "Value": ["095127.696000"]}, "200": {"vr": "TM", "Value": ["094547.679000"]}, "201": {"vr": "TM", "Value": ["095147.885000"]}, "202": {"vr": "TM", "Value": ["095227.694000"]}, "203": {"vr": "TM", "Value": ["094807.645000"]}, "204": {"vr": "TM", "Value": ["094927.727000"]}, "205": {"vr": "TM", "Value": ["095227.901000"]}, "206": {"vr": "TM", "Value": ["095247.758000"]}, "207": {"vr": "TM", "Value": ["095047.863000"]}, "208": {"vr": "TM", "Value": ["094547.847000"]}, "209": {"vr": "TM", "Value": ["094627.837000"]}, "210": {"vr": "TM", "Value": ["095007.885000"]}, "211": {"vr": "TM", "Value": ["095047.736000"]}, "212": {"vr": "TM", "Value": ["095347.925000"]}, "213": {"vr": "TM", "Value": ["095347.946000"]}, "214": {"vr": "TM", "Value": ["095227.607000"]}, "215": {"vr": "TM", "Value": ["095107.721000"]}, "216": {"vr": "TM", "Value": ["094727.675000"]}, "217": {"vr": "TM", "Value": ["094707.845000"]}, "218": {"vr": "TM", "Value": ["095427.727000"]}, "219": {"vr": "TM", "Value": ["094947.663000"]}, "220": {"vr": "TM", "Value": ["094847.680000"]}, "221": {"vr": "TM", "Value": ["095027.682000"]}, "222": {"vr": "TM", "Value": ["095027.870000"]}, "223": {"vr": "TM", "Value": ["094547.850000"]}, "224": {"vr": "TM", "Value": ["094607.636000"]}, "225": {"vr": "TM", "Value": ["094607.705000"]}, "226": {"vr": "TM", "Value": ["095127.630000"]}, "227": {"vr": "TM", "Value": ["094707.621000"]}, "228": {"vr": "TM", "Value": ["095047.825000"]}, "229": {"vr": "TM", "Value": ["094827.633000"]}, "230": {"vr": "TM", "Value": ["094727.650000"]}, "231": {"vr": "TM", "Value": ["094707.820000"]}, "232": {"vr": "TM", "Value": ["095227.944000"]}, "233": {"vr": "TM", "Value": ["095247.772000"]}, "234": {"vr": "TM", "Value": ["094807.958000"]}, "235": {"vr": "TM", "Value": ["095247.753000"]}, "236": {"vr": "TM", "Value": ["095407.676000"]}, "237": {"vr": "TM", "Value": ["094547.845000"]}, "238": {"vr": "TM", "Value": ["095027.662000"]}, "239": {"vr": "TM", "Value": ["095247.933000"]}, "240": {"vr": "TM", "Value": ["094907.801000"]}, "241": {"vr": "TM", "Value": ["095027.659000"]}, "242": {"vr": "TM", "Value": ["095127.867000"]}, "243": {"vr": "TM", "Value": ["094827.894000"]}, "244": {"vr": "TM", "Value": ["095427.827000"]}, "245": {"vr": "TM", "Value": ["095327.888000"]}, "246": {"vr": "TM", "Value": ["094527.678000"]}, "247": {"vr": "TM", "Value": ["094627.810000"]}, "248": {"vr": "TM", "Value": ["095047.782000"]}, "249": {"vr": "TM", "Value": ["095047.953000"]}, "250": {"vr": "TM", "Value": ["095147.710000"]}, "251": {"vr": "TM", "Value": ["094807.763000"]}, "252": {"vr": "TM", "Value": ["095027.788000"]}, "253": {"vr": "TM", "Value": ["095027.890000"]}, "254": {"vr": "TM", "Value": ["095107.781000"]}, "255": {"vr": "TM", "Value": ["094847.943000"]}, "256": {"vr": "TM", "Value": ["095327.772000"]}, "257": {"vr": "TM", "Value": ["095407.888000"]}, "258": {"vr": "TM", "Value": ["094907.768000"]}, "259": {"vr": "TM", "Value": ["094907.705000"]}, "260": {"vr": "TM", "Value": ["094647.849000"]}, "261": {"vr": "TM", "Value": ["095327.621000"]}, "262": {"vr": "TM", "Value": ["094807.745000"]}, "263": {"vr": "TM", "Value": ["094627.729000"]}, "264": {"vr": "TM", "Value": ["095347.644000"]}, "265": {"vr": "TM", "Value": ["095427.876000"]}, "266": {"vr": "TM", "Value": ["095447.727000"]}, "267": {"vr": "TM", "Value": ["094847.714000"]}, "268": {"vr": "TM", "Value": ["094627.947000"]}, "269": {"vr": "TM", "Value": ["095207.795000"]}, "270": {"vr": "TM", "Value": ["095456.551000"]}, "271": {"vr": "TM", "Value": ["095227.868000"]}, "272": {"vr": "TM", "Value": ["095427.683000"]}, "273": {"vr": "TM", "Value": ["094947.888000"]}, "274": {"vr": "TM", "Value": ["094627.974000"]}, "275": {"vr": "TM", "Value": ["094707.637000"]}, "276": {"vr": "TM", "Value": ["095227.923000"]}, "277": {"vr": "TM", "Value": ["095407.768000"]}, "278": {"vr": "TM", "Value": ["094847.664000"]}, "279": {"vr": "TM", "Value": ["094807.827000"]}, "280": {"vr": "TM", "Value": ["095107.891000"]}, "281": {"vr": "TM", "Value": ["094907.748000"]}, "282": {"vr": "TM", "Value": ["094547.804000"]}, "283": {"vr": "TM", "Value": ["095007.618000"]}, "284": {"vr": "TM", "Value": ["095427.695000"]}, "285": {"vr": "TM", "Value": ["095227.892000"]}, "286": {"vr": "TM", "Value": ["095027.877000"]}, "287": {"vr": "TM", "Value": ["094627.709000"]}, "288": {"vr": "TM", "Value": ["094727.751000"]}, "289": {"vr": "TM", "Value": ["095447.796000"]}, "290": {"vr": "TM", "Value": ["095456.412000"]}, "291": {"vr": "TM", "Value": ["094907.855000"]}, "292": {"vr": "TM", "Value": ["094947.917000"]}, "293": {"vr": "TM", "Value": ["094727.865000"]}, "294": {"vr": "TM", "Value": ["095427.842000"]}, "295": {"vr": "TM", "Value": ["095147.649000"]}, "296": {"vr": "TM", "Value": ["094747.772000"]}, "297": {"vr": "TM", "Value": ["094527.953000"]}, "298": {"vr": "TM", "Value": ["094547.634000"]}, "299": {"vr": "TM", "Value": ["094527.902000"]}, "300": {"vr": "TM", "Value": ["095427.884000"]}, "301": {"vr": "TM", "Value": ["095456.473000"]}, "302": {"vr": "TM", "Value": ["095127.632000"]}, "303": {"vr": "TM", "Value": ["094927.938000"]}, "304": {"vr": "TM", "Value": ["094947.723000"]}, "305": {"vr": "TM", "Value": ["094707.889000"]}, "306": {"vr": "TM", "Value": ["095407.870000"]}, "307": {"vr": "TM", "Value": ["094947.612000"]}, "308": {"vr": "TM", "Value": ["095407.620000"]}, "309": {"vr": "TM", "Value": ["095047.961000"]}, "310": {"vr": "TM", "Value": ["095027.948000"]}, "311": {"vr": "TM", "Value": ["094647.925000"]}, "312": {"vr": "TM", "Value": ["095147.672000"]}, "313": {"vr": "TM", "Value": ["095456.490000"]}, "314": {"vr": "TM", "Value": ["095447.664000"]}, "315": {"vr": "TM", "Value": ["094727.784000"]}, "316": {"vr": "TM", "Value": ["094647.935000"]}, "317": {"vr": "TM", "Value": ["095407.718000"]}, "318": {"vr": "TM", "Value": ["094847.706000"]}, "319": {"vr": "TM", "Value": ["095047.615000"]}, "320": {"vr": "TM", "Value": ["095127.770000"]}, "321": {"vr": "TM", "Value": ["094727.738000"]}, "322": {"vr": "TM", "Value": ["095407.943000"]}, "323": {"vr": "TM", "Value": ["094947.784000"]}, "324": {"vr": "TM", "Value": ["094927.909000"]}, "325": {"vr": "TM", "Value": ["094727.662000"]}, "326": {"vr": "TM", "Value": ["094607.730000"]}, "327": {"vr": "TM", "Value": ["095127.708000"]}, "328": {"vr": "TM", "Value": ["095327.637000"]}, "329": {"vr": "TM", "Value": ["095127.727000"]}, "330": {"vr": "TM", "Value": ["094547.812000"]}, "331": {"vr": "TM", "Value": ["094947.903000"]}, "332": {"vr": "TM", "Value": ["094727.624000"]}, "333": {"vr": "TM", "Value": ["095247.701000"]}, "334": {"vr": "TM", "Value": ["094927.666000"]}, "335": {"vr": "TM", "Value": ["094807.931000"]}, "336": {"vr": "TM", "Value": ["094727.870000"]}, "337": {"vr": "TM", "Value": ["094907.882000"]}, "338": {"vr": "TM", "Value": ["094547.796000"]}, "339": {"vr": "TM", "Value": ["094847.771000"]}, "340": {"vr": "TM", "Value": ["094647.612000"]}, "341": {"vr": "TM", "Value": ["095447.672000"]}, "342": {"vr": "TM", "Value": ["094807.875000"]}, "343": {"vr": "TM", "Value": ["095347.743000"]}, "344": {"vr": "TM", "Value": ["094847.811000"]}, "345": {"vr": "TM", "Value": ["095207.856000"]}, "346": {"vr": "TM", "Value": ["094627.831000"]}, "347": {"vr": "TM", "Value": ["094707.807000"]}, "348": {"vr": "TM", "Value": ["095007.667000"]}, "349": {"vr": "TM", "Value": ["094527.675000"]}, "350": {"vr": "TM", "Value": ["095147.813000"]}, "351": {"vr": "TM", "Value": ["095407.842000"]}, "352": {"vr": "TM", "Value": ["095007.694000"]}, "353": {"vr": "TM", "Value": ["095007.646000"]}, "354": {"vr": "TM", "Value": ["094927.886000"]}, "355": {"vr": "TM", "Value": ["095327.827000"]}, "356": {"vr": "TM", "Value": ["094747.895000"]}, "357": {"vr": "TM", "Value": ["094547.674000"]}, "358": {"vr": "TM", "Value": ["095227.925000"]}, "359": {"vr": "TM", "Value": ["094707.945000"]}, "360": {"vr": "TM", "Value": ["094547.714000"]}, "361": {"vr": "TM", "Value": ["095007.848000"]}, "362": {"vr": "TM", "Value": ["095227.699000"]}, "363": {"vr": "TM", "Value": ["095007.924000"]}, "364": {"vr": "TM", "Value": ["095327.824000"]}, "365": {"vr": "TM", "Value": ["095007.939000"]}, "366": {"vr": "TM", "Value": ["095427.892000"]}, "367": {"vr": "TM", "Value": ["094707.805000"]}, "368": {"vr": "TM", "Value": ["094647.951000"]}, "369": {"vr": "TM", "Value": ["095307.899000"]}, "370": {"vr": "TM", "Value": ["095227.856000"]}, "371": {"vr": "TM", "Value": ["095227.691000"]}, "372": {"vr": "TM", "Value": ["095207.813000"]}, "373": {"vr": "TM", "Value": ["095107.916000"]}, "374": {"vr": "TM", "Value": ["094927.916000"]}, "375": {"vr": "TM", "Value": ["095107.807000"]}, "376": {"vr": "TM", "Value": ["094947.886000"]}, "377": {"vr": "TM", "Value": ["095327.644000"]}, "378": {"vr": "TM", "Value": ["094927.758000"]}, "379": {"vr": "TM", "Value": ["094747.748000"]}, "380": {"vr": "TM", "Value": ["094907.898000"]}, "381": {"vr": "TM", "Value": ["094727.881000"]}, "382": {"vr": "TM", "Value": ["094847.908000"]}, "383": {"vr": "TM", "Value": ["094527.726000"]}, "384": {"vr": "TM", "Value": ["095007.827000"]}, "385": {"vr": "TM", "Value": ["095347.843000"]}, "386": {"vr": "TM", "Value": ["095347.861000"]}, "387": {"vr": "TM", "Value": ["095107.833000"]}, "388": {"vr": "TM", "Value": ["095407.825000"]}, "389": {"vr": "TM", "Value": ["094907.924000"]}, "390": {"vr": "TM", "Value": ["094707.755000"]}, "391": {"vr": "TM", "Value": ["095347.943000"]}, "392": {"vr": "TM", "Value": ["094807.897000"]}, "393": {"vr": "TM", "Value": ["095127.673000"]}, "394": {"vr": "TM", "Value": ["095107.660000"]}, "395": {"vr": "TM", "Value": ["095007.751000"]}, "396": {"vr": "TM", "Value": ["094827.914000"]}, "397": {"vr": "TM", "Value": ["095007.631000"]}, "398": {"vr": "TM", "Value": ["094607.737000"]}, "399": {"vr": "TM", "Value": ["094707.654000"]}, "400": {"vr": "TM", "Value": ["094907.913000"]}, "401": {"vr": "TM", "Value": ["094647.881000"]}, "402": {"vr": "TM", "Value": ["094807.684000"]}, "403": {"vr": "TM", "Value": ["095047.805000"]}, "404": {"vr": "TM", "Value": ["094607.681000"]}, "405": {"vr": "TM", "Value": ["095227.742000"]}, "406": {"vr": "TM", "Value": ["094727.779000"]}, "407": {"vr": "TM", "Value": ["094807.760000"]}, "408": {"vr": "TM", "Value": ["095027.693000"]}, "409": {"vr": "TM", "Value": ["095107.649000"]}, "410": {"vr": "TM", "Value": ["094747.709000"]}, "411": {"vr": "TM", "Value": ["095347.682000"]}, "412": {"vr": "TM", "Value": ["094547.640000"]}, "413": {"vr": "TM", "Value": ["094707.794000"]}, "414": {"vr": "TM", "Value": ["094607.763000"]}, "415": {"vr": "TM", "Value": ["095307.789000"]}, "416": {"vr": "TM", "Value": ["094947.810000"]}, "417": {"vr": "TM", "Value": ["094607.895000"]}, "418": {"vr": "TM", "Value": ["094527.742000"]}, "419": {"vr": "TM", "Value": ["094607.771000"]}, "420": {"vr": "TM", "Value": ["095447.763000"]}, "421": {"vr": "TM", "Value": ["094627.817000"]}, "422": {"vr": "TM", "Value": ["094747.840000"]}, "423": {"vr": "TM", "Value": ["095327.894000"]}, "424": {"vr": "TM", "Value": ["095147.767000"]}, "425": {"vr": "TM", "Value": ["095427.750000"]}, "426": {"vr": "TM", "Value": ["095207.711000"]}, "427": {"vr": "TM", "Value": ["095127.924000"]}, "428": {"vr": "TM", "Value": ["095407.830000"]}, "429": {"vr": "TM", "Value": ["095207.765000"]}, "430": {"vr": "TM", "Value": ["095047.679000"]}, "431": {"vr": "TM", "Value": ["094647.878000"]}, "432": {"vr": "TM", "Value": ["095427.758000"]}, "433": {"vr": "TM", "Value": ["095127.883000"]}, "434": {"vr": "TM", "Value": ["094707.863000"]}, "435": {"vr": "TM", "Value": ["095447.734000"]}, "436": {"vr": "TM", "Value": ["094527.790000"]}, "437": {"vr": "TM", "Value": ["094827.768000"]}, "438": {"vr": "TM", "Value": ["095107.713000"]}, "439": {"vr": "TM", "Value": ["095307.791000"]}, "440": {"vr": "TM", "Value": ["095407.753000"]}, "441": {"vr": "TM", "Value": ["094627.825000"]}, "442": {"vr": "TM", "Value": ["094647.785000"]}, "443": {"vr": "TM", "Value": ["095347.697000"]}, "444": {"vr": "TM", "Value": ["095147.662000"]}, "445": {"vr": "TM", "Value": ["095147.763000"]}, "446": {"vr": "TM", "Value": ["095247.894000"]}, "447": {"vr": "TM", "Value": ["094527.883000"]}, "448": {"vr": "TM", "Value": ["095327.802000"]}, "449": {"vr": "TM", "Value": ["095047.731000"]}, "450": {"vr": "TM", "Value": ["095407.689000"]}, "451": {"vr": "TM", "Value": ["094707.948000"]}, "452": {"vr": "TM", "Value": ["095247.626000"]}, "453": {"vr": "TM", "Value": ["094547.824000"]}, "454": {"vr": "TM", "Value": ["094807.948000"]}, "455": {"vr": "TM", "Value": ["095107.684000"]}, "456": {"vr": "TM", "Value": ["094807.829000"]}, "457": {"vr": "TM", "Value": ["094827.730000"]}, "458": {"vr": "TM", "Value": ["094927.639000"]}, "459": {"vr": "TM", "Value": ["094807.805000"]}, "460": {"vr": "TM", "Value": ["094847.703000"]}, "461": {"vr": "TM", "Value": ["095107.682000"]}, "462": {"vr": "TM", "Value": ["094927.898000"]}, "463": {"vr": "TM", "Value": ["095107.882000"]}, "464": {"vr": "TM", "Value": ["095307.873000"]}, "465": {"vr": "TM", "Value": ["094747.943000"]}, "466": {"vr": "TM", "Value": ["094707.760000"]}, "467": {"vr": "TM", "Value": ["095027.723000"]}, "468": {"vr": "TM", "Value": ["094547.814000"]}, "469": {"vr": "TM", "Value": ["095456.425000"]}, "470": {"vr": "TM", "Value": ["095047.841000"]}, "471": {"vr": "TM", "Value": ["095047.690000"]}, "472": {"vr": "TM", "Value": ["094707.853000"]}, "473": {"vr": "TM", "Value": ["095347.958000"]}, "474": {"vr": "TM", "Value": ["095347.702000"]}, "475": {"vr": "TM", "Value": ["094527.711000"]}, "476": {"vr": "TM", "Value": ["095347.858000"]}, "477": {"vr": "TM", "Value": ["094727.942000"]}, "478": {"vr": "TM", "Value": ["095427.673000"]}, "479": {"vr": "TM", "Value": ["095307.730000"]}, "480": {"vr": "TM", "Value": ["094947.829000"]}, "481": {"vr": "TM", "Value": ["094527.887000"]}, "482": {"vr": "TM", "Value": ["094707.932000"]}, "483": {"vr": "TM", "Value": ["095327.735000"]}, "484": {"vr": "TM", "Value": ["095127.620000"]}, "485": {"vr": "TM", "Value": ["095227.722000"]}, "486": {"vr": "TM", "Value": ["094827.735000"]}, "487": {"vr": "TM", "Value": ["094847.842000"]}, "488": {"vr": "TM", "Value": ["094907.634000"]}, "489": {"vr": "TM", "Value": ["095307.618000"]}, "490": {"vr": "TM", "Value": ["095047.638000"]}, "491": {"vr": "TM", "Value": ["094947.930000"]}, "492": {"vr": "TM", "Value": ["094727.923000"]}, "493": {"vr": "TM", "Value": ["095307.781000"]}, "494": {"vr": "TM", "Value": ["095327.930000"]}, "495": {"vr": "TM", "Value": ["094827.774000"]}, "496": {"vr": "TM", "Value": ["095007.723000"]}, "497": {"vr": "TM", "Value": ["094527.769000"]}, "498": {"vr": "TM", "Value": ["095427.809000"]}, "499": {"vr": "TM", "Value": ["094607.703000"]}, "500": {"vr": "TM", "Value": ["094627.689000"]}, "501": {"vr": "TM", "Value": ["095456.541000"]}, "502": {"vr": "TM", "Value": ["095027.834000"]}, "503": {"vr": "TM", "Value": ["094907.750000"]}, "504": {"vr": "TM", "Value": ["094847.690000"]}, "505": {"vr": "TM", "Value": ["094607.757000"]}, "506": {"vr": "TM", "Value": ["094727.728000"]}, "507": {"vr": "TM", "Value": ["094707.629000"]}, "508": {"vr": "TM", "Value": ["094747.837000"]}, "509": {"vr": "TM", "Value": ["094947.675000"]}, "510": {"vr": "TM", "Value": ["095347.951000"]}, "511": {"vr": "TM", "Value": ["094927.948000"]}, "512": {"vr": "TM", "Value": ["094807.710000"]}, "513": {"vr": "TM", "Value": ["095227.737000"]}, "514": {"vr": "TM", "Value": ["094647.990000"]}, "515": {"vr": "TM", "Value": ["094827.887000"]}, "516": {"vr": "TM", "Value": ["094527.799000"]}, "517": {"vr": "TM", "Value": ["095347.812000"]}, "518": {"vr": "TM", "Value": ["094907.654000"]}, "519": {"vr": "TM", "Value": ["094707.935000"]}, "520": {"vr": "TM", "Value": ["095147.847000"]}, "521": {"vr": "TM", "Value": ["094547.642000"]}, "522": {"vr": "TM", "Value": ["094947.768000"]}, "523": {"vr": "TM", "Value": ["095447.848000"]}, "524": {"vr": "TM", "Value": ["094707.858000"]}, "525": {"vr": "TM", "Value": ["094947.813000"]}, "526": {"vr": "TM", "Value": ["095427.835000"]}, "527": {"vr": "TM", "Value": ["095407.774000"]}, "528": {"vr": "TM", "Value": ["095407.713000"]}, "529": {"vr": "TM", "Value": ["094547.627000"]}, "530": {"vr": "TM", "Value": ["094727.888000"]}, "531": {"vr": "TM", "Value": ["094847.621000"]}, "532": {"vr": "TM", "Value": ["094527.994000"]}, "533": {"vr": "TM", "Value": ["094747.644000"]}, "534": {"vr": "TM", "Value": ["095027.777000"]}, "535": {"vr": "TM", "Value": ["095227.773000"]}, "536": {"vr": "TM", "Value": ["095207.664000"]}, "537": {"vr": "TM", "Value": ["095027.651000"]}, "538": {"vr": "TM", "Value": ["095107.716000"]}, "539": {"vr": "TM", "Value": ["094527.633000"]}, "540": {"vr": "TM", "Value": ["094827.610000"]}, "541": {"vr": "TM", "Value": ["095407.945000"]}, "542": {"vr": "TM", "Value": ["095007.909000"]}, "543": {"vr": "TM", "Value": ["095447.947000"]}, "544": {"vr": "TM", "Value": ["094647.943000"]}, "545": {"vr": "TM", "Value": ["094947.614000"]}, "546": {"vr": "TM", "Value": ["095407.807000"]}, "547": {"vr": "TM", "Value": ["095407.763000"]}, "548": {"vr": "TM", "Value": ["094847.617000"]}, "549": {"vr": "TM", "Value": ["095127.784000"]}, "550": {"vr": "TM", "Value": ["095047.951000"]}, "551": {"vr": "TM", "Value": ["095307.804000"]}, "552": {"vr": "TM", "Value": ["095107.726000"]}, "553": {"vr": "TM", "Value": ["094647.977000"]}, "554": {"vr": "TM", "Value": ["095007.914000"]}, "555": {"vr": "TM", "Value": ["094527.657000"]}, "556": {"vr": "TM", "Value": ["094747.630000"]}, "557": {"vr": "TM", "Value": ["095427.933000"]}, "558": {"vr": "TM", "Value": ["095107.814000"]}, "559": {"vr": "TM", "Value": ["095247.899000"]}, "560": {"vr": "TM", "Value": ["095107.772000"]}, "561": {"vr": "TM", "Value": ["095347.907000"]}, "562": {"vr": "TM", "Value": ["095207.823000"]}, "563": {"vr": "TM", "Value": ["094807.743000"]}, "564": {"vr": "TM", "Value": ["095107.779000"]}, "565": {"vr": "TM", "Value": ["094907.869000"]}, "566": {"vr": "TM", "Value": ["095127.816000"]}, "567": {"vr": "TM", "Value": ["094847.614000"]}, "568": {"vr": "TM", "Value": ["095207.656000"]}, "569": {"vr": "TM", "Value": ["094927.740000"]}, "570": {"vr": "TM", "Value": ["094827.686000"]}, "571": {"vr": "TM", "Value": ["095327.628000"]}, "572": {"vr": "TM", "Value": ["095347.931000"]}, "573": {"vr": "TM", "Value": ["095427.654000"]}, "574": {"vr": "TM", "Value": ["095407.679000"]}, "575": {"vr": "TM", "Value": ["095127.634000"]}, "576": {"vr": "TM", "Value": ["095127.824000"]}, "577": {"vr": "TM", "Value": ["095347.700000"]}, "578": {"vr": "TM", "Value": ["095027.690000"]}, "579": {"vr": "TM", "Value": ["095307.712000"]}, "580": {"vr": "TM", "Value": ["095307.779000"]}, "581": {"vr": "TM", "Value": ["095147.918000"]}, "582": {"vr": "TM", "Value": ["095027.620000"]}, "583": {"vr": "TM", "Value": ["095127.809000"]}, "584": {"vr": "TM", "Value": ["095227.776000"]}, "585": {"vr": "TM", "Value": ["094527.709000"]}, "586": {"vr": "TM", "Value": ["095347.730000"]}, "587": {"vr": "TM", "Value": ["094647.920000"]}, "588": {"vr": "TM", "Value": ["094727.875000"]}, "589": {"vr": "TM", "Value": ["095327.837000"]}, "590": {"vr": "TM", "Value": ["094907.710000"]}, "591": {"vr": "TM", "Value": ["095047.764000"]}, "592": {"vr": "TM", "Value": ["095347.792000"]}, "593": {"vr": "TM", "Value": ["095247.656000"]}, "594": {"vr": "TM", "Value": ["094527.827000"]}, "595": {"vr": "TM", "Value": ["094527.960000"]}, "596": {"vr": "TM", "Value": ["094947.928000"]}, "597": {"vr": "TM", "Value": ["094907.785000"]}, "598": {"vr": "TM", "Value": ["095347.608000"]}, "599": {"vr": "TM", "Value": ["094747.804000"]}, "600": {"vr": "TM", "Value": ["094847.612000"]}, "601": {"vr": "TM", "Value": ["095147.872000"]}, "602": {"vr": "TM", "Value": ["095007.720000"]}, "603": {"vr": "TM", "Value": ["095407.901000"]}, "604": {"vr": "TM", "Value": ["094627.622000"]}, "605": {"vr": "TM", "Value": ["095427.768000"]}, "606": {"vr": "TM", "Value": ["095227.946000"]}, "607": {"vr": "TM", "Value": ["095127.898000"]}, "608": {"vr": "TM", "Value": ["095407.748000"]}, "609": {"vr": "TM", "Value": ["095227.681000"]}, "610": {"vr": "TM", "Value": ["095427.928000"]}, "611": {"vr": "TM", "Value": ["095007.875000"]}, "612": {"vr": "TM", "Value": ["094547.632000"]}, "613": {"vr": "TM", "Value": ["095307.649000"]}, "614": {"vr": "TM", "Value": ["095007.758000"]}, "615": {"vr": "TM", "Value": ["095207.677000"]}, "616": {"vr": "TM", "Value": ["095207.831000"]}, "617": {"vr": "TM", "Value": ["094607.908000"]}, "618": {"vr": "TM", "Value": ["094707.843000"]}, "619": {"vr": "TM", "Value": ["095027.872000"]}, "620": {"vr": "TM", "Value": ["095027.824000"]}, "621": {"vr": "TM", "Value": ["094647.724000"]}, "622": {"vr": "TM", "Value": ["094527.871000"]}, "623": {"vr": "TM", "Value": ["095407.730000"]}, "624": {"vr": "TM", "Value": ["095456.441000"]}, "625": {"vr": "TM", "Value": ["095307.832000"]}, "626": {"vr": "TM", "Value": ["094727.810000"]}, "627": {"vr": "TM", "Value": ["094707.742000"]}, "628": {"vr": "TM", "Value": ["094527.950000"]}, "629": {"vr": "TM", "Value": ["094907.936000"]}, "630": {"vr": "TM", "Value": ["095227.846000"]}, "631": {"vr": "TM", "Value": ["094807.797000"]}, "632": {"vr": "TM", "Value": ["094607.893000"]}, "633": {"vr": "TM", "Value": ["095027.852000"]}, "634": {"vr": "TM", "Value": ["094807.895000"]}, "635": {"vr": "TM", "Value": ["095247.663000"]}, "636": {"vr": "TM", "Value": ["094707.687000"]}, "637": {"vr": "TM", "Value": ["094707.876000"]}, "638": {"vr": "TM", "Value": ["095207.689000"]}, "639": {"vr": "TM", "Value": ["095447.688000"]}, "640": {"vr": "TM", "Value": ["094627.936000"]}, "641": {"vr": "TM", "Value": ["094627.657000"]}, "642": {"vr": "TM", "Value": ["094807.768000"]}, "643": {"vr": "TM", "Value": ["095227.794000"]}, "644": {"vr": "TM", "Value": ["095307.938000"]}, "645": {"vr": "TM", "Value": ["094927.832000"]}, "646": {"vr": "TM", "Value": ["095327.661000"]}, "647": {"vr": "TM", "Value": ["095107.821000"]}, "648": {"vr": "TM", "Value": ["095427.678000"]}, "649": {"vr": "TM", "Value": ["094927.699000"]}, "650": {"vr": "TM", "Value": ["094627.858000"]}, "651": {"vr": "TM", "Value": ["094747.775000"]}, "652": {"vr": "TM", "Value": ["095307.892000"]}, "653": {"vr": "TM", "Value": ["094747.615000"]}, "654": {"vr": "TM", "Value": ["095147.695000"]}, "655": {"vr": "TM", "Value": ["094827.727000"]}, "656": {"vr": "TM", "Value": ["095127.842000"]}, "657": {"vr": "TM", "Value": ["094547.794000"]}, "658": {"vr": "TM", "Value": ["095207.866000"]}, "659": {"vr": "TM", "Value": ["094647.700000"]}, "660": {"vr": "TM", "Value": ["095027.908000"]}, "661": {"vr": "TM", "Value": ["095307.884000"]}, "662": {"vr": "TM", "Value": ["094647.864000"]}, "663": {"vr": "TM", "Value": ["095456.556000"]}, "664": {"vr": "TM", "Value": ["095207.703000"]}, "665": {"vr": "TM", "Value": ["095207.691000"]}, "666": {"vr": "TM", "Value": ["094947.896000"]}, "667": {"vr": "TM", "Value": ["094627.879000"]}, "668": {"vr": "TM", "Value": ["095007.834000"]}, "669": {"vr": "TM", "Value": ["094527.958000"]}, "670": {"vr": "TM", "Value": ["094627.749000"]}, "671": {"vr": "TM", "Value": ["095107.861000"]}, "672": {"vr": "TM", "Value": ["095407.812000"]}, "673": {"vr": "TM", "Value": ["094607.745000"]}, "674": {"vr": "TM", "Value": ["095327.618000"]}, "675": {"vr": "TM", "Value": ["094847.948000"]}, "676": {"vr": "TM", "Value": ["094847.672000"]}, "677": {"vr": "TM", "Value": ["094907.845000"]}, "678": {"vr": "TM", "Value": ["094647.712000"]}, "679": {"vr": "TM", "Value": ["095007.824000"]}, "680": {"vr": "TM", "Value": ["095147.655000"]}, "681": {"vr": "TM", "Value": ["095447.711000"]}, "682": {"vr": "TM", "Value": ["095247.750000"]}, "683": {"vr": "TM", "Value": ["095447.647000"]}, "684": {"vr": "TM", "Value": ["095227.707000"]}, "685": {"vr": "TM", "Value": ["094607.828000"]}, "686": {"vr": "TM", "Value": ["094907.879000"]}, "687": {"vr": "TM", "Value": ["095147.794000"]}, "688": {"vr": "TM", "Value": ["094947.756000"]}, "689": {"vr": "TM", "Value": ["094527.880000"]}, "690": {"vr": "TM", "Value": ["095007.788000"]}, "691": {"vr": "TM", "Value": ["094547.726000"]}, "692": {"vr": "TM", "Value": ["094547.859000"]}, "693": {"vr": "TM", "Value": ["094547.942000"]}, "694": {"vr": "TM", "Value": ["094947.642000"]}, "695": {"vr": "TM", "Value": ["094607.799000"]}, "696": {"vr": "TM", "Value": ["095227.904000"]}, "697": {"vr": "TM", "Value": ["094927.632000"]}, "698": {"vr": "TM", "Value": ["095107.803000"]}, "699": {"vr": "TM", "Value": ["094847.626000"]}, "700": {"vr": "TM", "Value": ["094607.727000"]}, "701": {"vr": "TM", "Value": ["095227.915000"]}, "702": {"vr": "TM", "Value": ["094547.739000"]}, "703": {"vr": "TM", "Value": ["095307.671000"]}, "704": {"vr": "TM", "Value": ["094807.788000"]}, "705": {"vr": "TM", "Value": ["094827.641000"]}, "706": {"vr": "TM", "Value": ["095127.618000"]}, "707": {"vr": "TM", "Value": ["094707.649000"]}, "708": {"vr": "TM", "Value": ["094847.719000"]}, "709": {"vr": "TM", "Value": ["095247.815000"]}, "710": {"vr": "TM", "Value": ["095307.830000"]}, "711": {"vr": "TM", "Value": ["095227.615000"]}, "712": {"vr": "TM", "Value": ["094527.848000"]}, "713": {"vr": "TM", "Value": ["095047.887000"]}, "714": {"vr": "TM", "Value": ["094827.879000"]}, "715": {"vr": "TM", "Value": ["095147.751000"]}, "716": {"vr": "TM", "Value": ["095207.874000"]}, "717": {"vr": "TM", "Value": ["095307.931000"]}, "718": {"vr": "TM", "Value": ["095407.666000"]}, "719": {"vr": "TM", "Value": ["094947.900000"]}, "720": {"vr": "TM", "Value": ["094607.946000"]}, "721": {"vr": "TM", "Value": ["095107.786000"]}, "722": {"vr": "TM", "Value": ["094647.735000"]}, "723": {"vr": "TM", "Value": ["095447.642000"]}, "724": {"vr": "TM", "Value": ["095247.708000"]}, "725": {"vr": "TM", "Value": ["094547.661000"]}, "726": {"vr": "TM", "Value": ["095407.929000"]}, "727": {"vr": "TM", "Value": ["095407.623000"]}, "728": {"vr": "TM", "Value": ["094527.990000"]}, "729": {"vr": "TM", "Value": ["095407.940000"]}, "730": {"vr": "TM", "Value": ["095027.622000"]}, "731": {"vr": "TM", "Value": ["094907.782000"]}, "732": {"vr": "TM", "Value": ["094647.962000"]}, "733": {"vr": "TM", "Value": ["095427.916000"]}, "734": {"vr": "TM", "Value": ["094547.936000"]}, "735": {"vr": "TM", "Value": ["094907.728000"]}, "736": {"vr": "TM", "Value": ["094727.855000"]}, "737": {"vr": "TM", "Value": ["094627.712000"]}, "738": {"vr": "TM", "Value": ["095307.745000"]}, "739": {"vr": "TM", "Value": ["094527.779000"]}, "740": {"vr": "TM", "Value": ["094647.875000"]}, "741": {"vr": "TM", "Value": ["094607.683000"]}, "742": {"vr": "TM", "Value": ["094707.825000"]}, "743": {"vr": "TM", "Value": ["095327.914000"]}, "744": {"vr": "TM", "Value": ["095107.757000"]}, "745": {"vr": "TM", "Value": ["094707.714000"]}, "746": {"vr": "TM", "Value": ["094707.787000"]}, "747": {"vr": "TM", "Value": ["095047.858000"]}, "748": {"vr": "TM", "Value": ["095147.667000"]}, "749": {"vr": "TM", "Value": ["095207.696000"]}, "750": {"vr": "TM", "Value": ["095447.819000"]}, "751": {"vr": "TM", "Value": ["094807.824000"]}, "752": {"vr": "TM", "Value": ["095247.729000"]}, "753": {"vr": "TM", "Value": ["094627.672000"]}, "754": {"vr": "TM", "Value": ["095207.759000"]}, "755": {"vr": "TM", "Value": ["094947.820000"]}, "756": {"vr": "TM", "Value": ["094827.829000"]}, "757": {"vr": "TM", "Value": ["095456.493000"]}, "758": {"vr": "TM", "Value": ["094747.951000"]}, "759": {"vr": "TM", "Value": ["094547.891000"]}, "760": {"vr": "TM", "Value": ["094727.906000"]}, "761": {"vr": "TM", "Value": ["094747.927000"]}, "762": {"vr": "TM", "Value": ["095447.623000"]}, "763": {"vr": "TM", "Value": ["095147.670000"]}, "764": {"vr": "TM", "Value": ["095007.651000"]}, "765": {"vr": "TM", "Value": ["094727.630000"]}, "766": {"vr": "TM", "Value": ["094727.716000"]}, "767": {"vr": "TM", "Value": ["095327.842000"]}, "768": {"vr": "TM", "Value": ["095047.787000"]}, "769": {"vr": "TM", "Value": ["095227.858000"]}, "770": {"vr": "TM", "Value": ["094827.799000"]}, "771": {"vr": "TM", "Value": ["095456.510000"]}, "772": {"vr": "TM", "Value": ["094907.758000"]}, "773": {"vr": "TM", "Value": ["095407.927000"]}, "774": {"vr": "TM", "Value": ["094747.869000"]}, "775": {"vr": "TM", "Value": ["094727.652000"]}, "776": {"vr": "TM", "Value": ["094847.882000"]}, "777": {"vr": "TM", "Value": ["095007.839000"]}, "778": {"vr": "TM", "Value": ["095447.724000"]}, "779": {"vr": "TM", "Value": ["094547.832000"]}, "780": {"vr": "TM", "Value": ["095047.921000"]}, "781": {"vr": "TM", "Value": ["094907.698000"]}, "782": {"vr": "TM", "Value": ["095427.628000"]}, "783": {"vr": "TM", "Value": ["095207.892000"]}, "784": {"vr": "TM", "Value": ["094527.910000"]}, "785": {"vr": "TM", "Value": ["095207.654000"]}, "786": {"vr": "TM", "Value": ["095047.871000"]}, "787": {"vr": "TM", "Value": ["094707.763000"]}, "788": {"vr": "TM", "Value": ["095327.716000"]}, "789": {"vr": "TM", "Value": ["094827.670000"]}, "790": {"vr": "TM", "Value": ["095407.802000"]}, "791": {"vr": "TM", "Value": ["095327.755000"]}, "792": {"vr": "TM", "Value": ["094607.626000"]}, "793": {"vr": "TM", "Value": ["095207.698000"]}, "794": {"vr": "TM", "Value": ["094827.659000"]}, "795": {"vr": "TM", "Value": ["094907.858000"]}, "796": {"vr": "TM", "Value": ["094747.892000"]}, "797": {"vr": "TM", "Value": ["095107.840000"]}, "798": {"vr": "TM", "Value": ["095207.785000"]}, "799": {"vr": "TM", "Value": ["094547.779000"]}, "800": {"vr": "TM", "Value": ["094627.960000"]}, "801": {"vr": "TM", "Value": ["094527.781000"]}, "802": {"vr": "TM", "Value": ["094627.704000"]}, "803": {"vr": "TM", "Value": ["095247.770000"]}, "804": {"vr": "TM", "Value": ["095247.691000"]}, "805": {"vr": "TM", "Value": ["094807.834000"]}, "806": {"vr": "TM", "Value": ["095107.864000"]}, "807": {"vr": "TM", "Value": ["095227.824000"]}, "808": {"vr": "TM", "Value": ["094807.661000"]}, "809": {"vr": "TM", "Value": ["095027.826000"]}, "810": {"vr": "TM", "Value": ["095007.899000"]}, "811": {"vr": "TM", "Value": ["095207.861000"]}, "812": {"vr": "TM", "Value": ["094927.628000"]}, "813": {"vr": "TM", "Value": ["095047.628000"]}, "814": {"vr": "TM", "Value": ["095107.810000"]}, "815": {"vr": "TM", "Value": ["095447.611000"]}, "816": {"vr": "TM", "Value": ["095327.782000"]}, "817": {"vr": "TM", "Value": ["095447.765000"]}, "818": {"vr": "TM", "Value": ["095047.676000"]}, "819": {"vr": "TM", "Value": ["094927.931000"]}, "820": {"vr": "TM", "Value": ["095327.689000"]}, "821": {"vr": "TM", "Value": ["095327.652000"]}, "822": {"vr": "TM", "Value": ["094847.743000"]}, "823": {"vr": "TM", "Value": ["095127.741000"]}, "824": {"vr": "TM", "Value": ["095247.912000"]}, "825": {"vr": "TM", "Value": ["095127.637000"]}, "826": {"vr": "TM", "Value": ["094807.955000"]}, "827": {"vr": "TM", "Value": ["095456.462000"]}, "828": {"vr": "TM", "Value": ["094947.690000"]}, "829": {"vr": "TM", "Value": ["095147.753000"]}, "830": {"vr": "TM", "Value": ["094607.885000"]}, "831": {"vr": "TM", "Value": ["094827.722000"]}, "832": {"vr": "TM", "Value": ["094747.787000"]}, "833": {"vr": "TM", "Value": ["094647.663000"]}, "834": {"vr": "TM", "Value": ["094627.702000"]}, "835": {"vr": "TM", "Value": ["095447.842000"]}, "836": {"vr": "TM", "Value": ["094827.823000"]}, "837": {"vr": "TM", "Value": ["094627.724000"]}, "838": {"vr": "TM", "Value": ["094547.895000"]}, "839": {"vr": "TM", "Value": ["094727.746000"]}, "840": {"vr": "TM", "Value": ["095307.946000"]}, "841": {"vr": "TM", "Value": ["095147.866000"]}, "842": {"vr": "TM", "Value": ["094607.698000"]}, "843": {"vr": "TM", "Value": ["095007.748000"]}, "844": {"vr": "TM", "Value": ["094807.616000"]}, "845": {"vr": "TM", "Value": ["094547.766000"]}, "846": {"vr": "TM", "Value": ["095007.858000"]}, "847": {"vr": "TM", "Value": ["095207.770000"]}, "848": {"vr": "TM", "Value": ["094947.877000"]}, "849": {"vr": "TM", "Value": ["094627.751000"]}, "850": {"vr": "TM", "Value": ["095147.719000"]}, "851": {"vr": "TM", "Value": ["095047.625000"]}, "852": {"vr": "TM", "Value": ["095027.946000"]}, "853": {"vr": "TM", "Value": ["095227.739000"]}, "854": {"vr": "TM", "Value": ["094747.734000"]}, "855": {"vr": "TM", "Value": ["094727.841000"]}, "856": {"vr": "TM", "Value": ["094927.801000"]}, "857": {"vr": "TM", "Value": ["095107.921000"]}, "858": {"vr": "TM", "Value": ["094807.643000"]}, "859": {"vr": "TM", "Value": ["094607.874000"]}, "860": {"vr": "TM", "Value": ["094847.701000"]}, "861": {"vr": "TM", "Value": ["095456.414000"]}, "862": {"vr": "TM", "Value": ["095347.881000"]}, "863": {"vr": "TM", "Value": ["095127.865000"]}, "864": {"vr": "TM", "Value": ["095447.804000"]}, "865": {"vr": "TM", "Value": ["094907.658000"]}, "866": {"vr": "TM", "Value": ["095207.931000"]}, "867": {"vr": "TM", "Value": ["094707.632000"]}, "868": {"vr": "TM", "Value": ["095147.743000"]}, "869": {"vr": "TM", "Value": ["094707.753000"]}, "870": {"vr": "TM", "Value": ["094827.909000"]}, "871": {"vr": "TM", "Value": ["094927.842000"]}, "872": {"vr": "TM", "Value": ["094547.659000"]}, "873": {"vr": "TM", "Value": ["095347.735000"]}, "874": {"vr": "TM", "Value": ["095207.624000"]}, "875": {"vr": "TM", "Value": ["094527.758000"]}, "876": {"vr": "TM", "Value": ["094707.835000"]}, "877": {"vr": "TM", "Value": ["094607.911000"]}, "878": {"vr": "TM", "Value": ["095347.815000"]}, "879": {"vr": "TM", "Value": ["094547.734000"]}, "880": {"vr": "TM", "Value": ["094607.794000"]}, "881": {"vr": "TM", "Value": ["094727.610000"]}, "882": {"vr": "TM", "Value": ["094607.866000"]}, "883": {"vr": "TM", "Value": ["094707.856000"]}, "884": {"vr": "TM", "Value": ["095327.904000"]}, "885": {"vr": "TM", "Value": ["095456.544000"]}, "886": {"vr": "TM", "Value": ["094727.786000"]}, "887": {"vr": "TM", "Value": ["094947.910000"]}, "888": {"vr": "TM", "Value": ["094707.750000"]}, "889": {"vr": "TM", "Value": ["094607.666000"]}, "890": {"vr": "TM", "Value": ["094747.954000"]}, "891": {"vr": "TM", "Value": ["095007.776000"]}, "892": {"vr": "TM", "Value": ["095427.649000"]}, "893": {"vr": "TM", "Value": ["095047.813000"]}, "894": {"vr": "TM", "Value": ["094747.819000"]}, "895": {"vr": "TM", "Value": ["095007.634000"]}, "896": {"vr": "TM", "Value": ["094647.727000"]}, "897": {"vr": "TM", "Value": ["095007.641000"]}, "898": {"vr": "TM", "Value": ["095027.867000"]}, "899": {"vr": "TM", "Value": ["094907.628000"]}, "900": {"vr": "TM", "Value": ["094927.893000"]}, "901": {"vr": "TM", "Value": ["094607.941000"]}, "902": {"vr": "TM", "Value": ["095027.941000"]}, "903": {"vr": "TM", "Value": ["095447.928000"]}, "904": {"vr": "TM", "Value": ["094627.677000"]}, "905": {"vr": "TM", "Value": ["094727.919000"]}, "906": {"vr": "TM", "Value": ["094627.645000"]}, "907": {"vr": "TM", "Value": ["095207.772000"]}, "908": {"vr": "TM", "Value": ["095007.656000"]}, "909": {"vr": "TM", "Value": ["095447.742000"]}, "910": {"vr": "TM", "Value": ["095107.859000"]}, "911": {"vr": "TM", "Value": ["094907.780000"]}, "912": {"vr": "TM", "Value": ["095427.830000"]}, "913": {"vr": "TM", "Value": ["095127.608000"]}, "914": {"vr": "TM", "Value": ["094727.857000"]}, "915": {"vr": "TM", "Value": ["095047.792000"]}, "916": {"vr": "TM", "Value": ["095427.921000"]}, "917": {"vr": "TM", "Value": ["095147.864000"]}, "918": {"vr": "TM", "Value": ["095307.676000"]}, "919": {"vr": "TM", "Value": ["094527.700000"]}, "920": {"vr": "TM", "Value": ["094647.816000"]}, "921": {"vr": "TM", "Value": ["094807.753000"]}, "922": {"vr": "TM", "Value": ["095307.663000"]}, "923": {"vr": "TM", "Value": ["095227.932000"]}, "924": {"vr": "TM", "Value": ["094527.622000"]}, "925": {"vr": "TM", "Value": ["094547.893000"]}, "926": {"vr": "TM", "Value": ["095456.427000"]}, "927": {"vr": "TM", "Value": ["095207.747000"]}, "928": {"vr": "TM", "Value": ["095347.626000"]}, "929": {"vr": "TM", "Value": ["095047.620000"]}, "930": {"vr": "TM", "Value": ["094947.778000"]}, "931": {"vr": "TM", "Value": ["095007.768000"]}, "932": {"vr": "TM", "Value": ["095456.476000"]}, "933": {"vr": "TM", "Value": ["095127.644000"]}, "934": {"vr": "TM", "Value": ["094547.753000"]}, "935": {"vr": "TM", "Value": ["094927.840000"]}, "936": {"vr": "TM", "Value": ["095147.825000"]}, "937": {"vr": "TM", "Value": ["094927.819000"]}, "938": {"vr": "TM", "Value": ["095456.404000"]}, "939": {"vr": "TM", "Value": ["094907.691000"]}, "940": {"vr": "TM", "Value": ["095307.820000"]}, "941": {"vr": "TM", "Value": ["095307.773000"]}, "942": {"vr": "TM", "Value": ["094707.953000"]}, "943": {"vr": "TM", "Value": ["094927.822000"]}, "944": {"vr": "TM", "Value": ["095127.772000"]}, "945": {"vr": "TM", "Value": ["095407.862000"]}, "946": {"vr": "TM", "Value": ["095127.658000"]}, "947": {"vr": "TM", "Value": ["094907.929000"]}, "948": {"vr": "TM", "Value": ["095147.823000"]}, "949": {"vr": "TM", "Value": ["094827.709000"]}, "950": {"vr": "TM", "Value": ["095247.928000"]}, "951": {"vr": "TM", "Value": ["094907.919000"]}, "952": {"vr": "TM", "Value": ["094727.677000"]}, "953": {"vr": "TM", "Value": ["095027.842000"]}, "954": {"vr": "TM", "Value": ["095227.630000"]}, "955": {"vr": "TM", "Value": ["094607.830000"]}, "956": {"vr": "TM", "Value": ["095147.840000"]}, "957": {"vr": "TM", "Value": ["094907.861000"]}, "958": {"vr": "TM", "Value": ["095247.891000"]}, "959": {"vr": "TM", "Value": ["094827.688000"]}, "960": {"vr": "TM", "Value": ["094927.768000"]}, "961": {"vr": "TM", "Value": ["095007.831000"]}, "962": {"vr": "TM", "Value": ["095307.840000"]}, "963": {"vr": "TM", "Value": ["095207.798000"]}, "964": {"vr": "TM", "Value": ["094647.862000"]}, "965": {"vr": "TM", "Value": ["094747.816000"]}, "966": {"vr": "TM", "Value": ["094927.702000"]}, "967": {"vr": "TM", "Value": ["095407.735000"]}, "968": {"vr": "TM", "Value": ["094707.938000"]}, "969": {"vr": "TM", "Value": ["094727.642000"]}, "970": {"vr": "TM", "Value": ["094527.977000"]}, "971": {"vr": "TM", "Value": ["094727.768000"]}, "972": {"vr": "TM", "Value": ["095407.867000"]}, "973": {"vr": "TM", "Value": ["095327.876000"]}, "974": {"vr": "TM", "Value": ["095047.693000"]}, "975": {"vr": "TM", "Value": ["095127.919000"]}, "976": {"vr": "TM", "Value": ["094807.614000"]}, "977": {"vr": "TM", "Value": ["094947.773000"]}, "978": {"vr": "TM", "Value": ["095456.507000"]}, "979": {"vr": "TM", "Value": ["095147.895000"]}, "980": {"vr": "TM", "Value": ["095207.686000"]}, "981": {"vr": "TM", "Value": ["095347.766000"]}, "982": {"vr": "TM", "Value": ["094907.842000"]}, "983": {"vr": "TM", "Value": ["095147.837000"]}, "984": {"vr": "TM", "Value": ["095307.641000"]}, "985": {"vr": "TM", "Value": ["094947.770000"]}, "986": {"vr": "TM", "Value": ["094847.725000"]}, "987": {"vr": "TM", "Value": ["094527.987000"]}, "988": {"vr": "TM", "Value": ["095347.618000"]}, "989": {"vr": "TM", "Value": ["094927.704000"]}, "990": {"vr": "TM", "Value": ["094947.801000"]}, "991": {"vr": "TM", "Value": ["095407.852000"]}, "992": {"vr": "TM", "Value": ["094827.631000"]}, "993": {"vr": "TM", "Value": ["095427.807000"]}, "994": {"vr": "TM", "Value": ["094647.751000"]}, "995": {"vr": "TM", "Value": ["095307.827000"]}, "996": {"vr": "TM", "Value": ["095456.410000"]}, "997": {"vr": "TM", "Value": ["095227.709000"]}, "998": {"vr": "TM", "Value": ["095307.613000"]}, "999": {"vr": "TM", "Value": ["095427.951000"]}, "1000": {"vr": "TM", "Value": ["095007.636000"]}, "1001": {"vr": "TM", "Value": ["095447.616000"]}, "1002": {"vr": "TM", "Value": ["094607.715000"]}, "1003": {"vr": "TM", "Value": ["094747.657000"]}, "1004": {"vr": "TM", "Value": ["095347.764000"]}, "1005": {"vr": "TM", "Value": ["095207.614000"]}, "1006": {"vr": "TM", "Value": ["095227.801000"]}, "1007": {"vr": "TM", "Value": ["094727.673000"]}, "1008": {"vr": "TM", "Value": ["094627.679000"]}, "1009": {"vr": "TM", "Value": ["094727.794000"]}, "1010": {"vr": "TM", "Value": ["095347.677000"]}, "1011": {"vr": "TM", "Value": ["095447.866000"]}, "1012": {"vr": "TM", "Value": ["095227.653000"]}, "1013": {"vr": "TM", "Value": ["095227.806000"]}, "1014": {"vr": "TM", "Value": ["095147.907000"]}, "1015": {"vr": "TM", "Value": ["095456.522000"]}, "1016": {"vr": "TM", "Value": ["094827.949000"]}, "1017": {"vr": "TM", "Value": ["095447.659000"]}, "1018": {"vr": "TM", "Value": ["094807.635000"]}, "1019": {"vr": "TM", "Value": ["095347.894000"]}, "1020": {"vr": "TM", "Value": ["095207.884000"]}, "1021": {"vr": "TM", "Value": ["095427.797000"]}, "1022": {"vr": "TM", "Value": ["094847.803000"]}, "1023": {"vr": "TM", "Value": ["094907.909000"]}, "1024": {"vr": "TM", "Value": ["095227.696000"]}, "1025": {"vr": "TM", "Value": ["094547.751000"]}, "1026": {"vr": "TM", "Value": ["094547.879000"]}, "1027": {"vr": "TM", "Value": ["095207.905000"]}, "1028": {"vr": "TM", "Value": ["095347.715000"]}, "1029": {"vr": "TM", "Value": ["095047.923000"]}, "1030": {"vr": "TM", "Value": ["094527.753000"]}, "1031": {"vr": "TM", "Value": ["094647.698000"]}, "1032": {"vr": "TM", "Value": ["094827.868000"]}, "1033": {"vr": "TM", "Value": ["094947.624000"]}, "1034": {"vr": "TM", "Value": ["094647.873000"]}, "1035": {"vr": "TM", "Value": ["095407.674000"]}, "1036": {"vr": "TM", "Value": ["094847.867000"]}, "1037": {"vr": "TM", "Value": ["095107.736000"]}, "1038": {"vr": "TM", "Value": ["094627.945000"]}, "1039": {"vr": "TM", "Value": ["094847.607000"]}, "1040": {"vr": "TM", "Value": ["094827.712000"]}, "1041": {"vr": "TM", "Value": ["095207.879000"]}, "1042": {"vr": "TM", "Value": ["094827.747000"]}, "1043": {"vr": "TM", "Value": ["095027.751000"]}, "1044": {"vr": "TM", "Value": ["094807.792000"]}, "1045": {"vr": "TM", "Value": ["094607.708000"]}, "1046": {"vr": "TM", "Value": ["095107.791000"]}, "1047": {"vr": "TM", "Value": ["095407.903000"]}, "1048": {"vr": "TM", "Value": ["095427.766000"]}, "1049": {"vr": "TM", "Value": ["094547.756000"]}, "1050": {"vr": "TM", "Value": ["095047.777000"]}, "1051": {"vr": "TM", "Value": ["095007.616000"]}, "1052": {"vr": "TM", "Value": ["094647.693000"]}, "1053": {"vr": "TM", "Value": ["095107.796000"]}, "1054": {"vr": "TM", "Value": ["094627.918000"]}, "1055": {"vr": "TM", "Value": ["094847.662000"]}, "1056": {"vr": "TM", "Value": ["095307.812000"]}, "1057": {"vr": "TM", "Value": ["095427.690000"]}, "1058": {"vr": "TM", "Value": ["095227.712000"]}, "1059": {"vr": "TM", "Value": ["094907.762000"]}, "1060": {"vr": "TM", "Value": ["094527.735000"]}, "1061": {"vr": "TM", "Value": ["094547.862000"]}, "1062": {"vr": "TM", "Value": ["094727.833000"]}, "1063": {"vr": "TM", "Value": ["094847.716000"]}, "1064": {"vr": "TM", "Value": ["094727.921000"]}, "1065": {"vr": "TM", "Value": ["094847.610000"]}, "1066": {"vr": "TM", "Value": ["094907.616000"]}, "1067": {"vr": "TM", "Value": ["095207.841000"]}, "1068": {"vr": "TM", "Value": ["095307.951000"]}, "1069": {"vr": "TM", "Value": ["095047.963000"]}, "1070": {"vr": "TM", "Value": ["094727.660000"]}, "1071": {"vr": "TM", "Value": ["095307.761000"]}, "1072": {"vr": "TM", "Value": ["095207.921000"]}, "1073": {"vr": "TM", "Value": ["095456.478000"]}, "1074": {"vr": "TM", "Value": ["095447.935000"]}, "1075": {"vr": "TM", "Value": ["094647.759000"]}, "1076": {"vr": "TM", "Value": ["095107.653000"]}, "1077": {"vr": "TM", "Value": ["095227.939000"]}, "1078": {"vr": "TM", "Value": ["094727.647000"]}, "1079": {"vr": "TM", "Value": ["095307.856000"]}, "1080": {"vr": "TM", "Value": ["094827.766000"]}, "1081": {"vr": "TM", "Value": ["094647.960000"]}, "1082": {"vr": "TM", "Value": ["095207.894000"]}, "1083": {"vr": "TM", "Value": ["095207.936000"]}, "1084": {"vr": "TM", "Value": ["094627.697000"]}, "1085": {"vr": "TM", "Value": ["095307.799000"]}, "1086": {"vr": "TM", "Value": ["095207.838000"]}, "1087": {"vr": "TM", "Value": ["095207.872000"]}, "1088": {"vr": "TM", "Value": ["095327.792000"]}, "1089": {"vr": "TM", "Value": ["095207.661000"]}, "1090": {"vr": "TM", "Value": ["095007.808000"]}, "1091": {"vr": "TM", "Value": ["094847.624000"]}, "1092": {"vr": "TM", "Value": ["095147.923000"]}, "1093": {"vr": "TM", "Value": ["094627.773000"]}, "1094": {"vr": "TM", "Value": ["095447.627000"]}, "1095": {"vr": "TM", "Value": ["095227.734000"]}, "1096": {"vr": "TM", "Value": ["095127.623000"]}, "1097": {"vr": "TM", "Value": ["094827.947000"]}, "1098": {"vr": "TM", "Value": ["095347.615000"]}, "1099": {"vr": "TM", "Value": ["095127.903000"]}, "1100": {"vr": "TM", "Value": ["094947.905000"]}, "1101": {"vr": "TM", "Value": ["095127.829000"]}, "1102": {"vr": "TM", "Value": ["095127.694000"]}, "1103": {"vr": "TM", "Value": ["095307.886000"]}, "1104": {"vr": "TM", "Value": ["094647.690000"]}, "1105": {"vr": "TM", "Value": ["095147.741000"]}, "1106": {"vr": "TM", "Value": ["094647.714000"]}, "1107": {"vr": "TM", "Value": ["095007.669000"]}, "1108": {"vr": "TM", "Value": ["094747.620000"]}, "1109": {"vr": "TM", "Value": ["095427.871000"]}, "1110": {"vr": "TM", "Value": ["095327.664000"]}, "1111": {"vr": "TM", "Value": ["094807.778000"]}, "1112": {"vr": "TM", "Value": ["094727.741000"]}, "1113": {"vr": "TM", "Value": ["095207.667000"]}, "1114": {"vr": "TM", "Value": ["094947.935000"]}, "1115": {"vr": "TM", "Value": ["095427.693000"]}, "1116": {"vr": "TM", "Value": ["094527.907000"]}, "1117": {"vr": "TM", "Value": ["095247.687000"]}, "1118": {"vr": "TM", "Value": ["094727.690000"]}, "1119": {"vr": "TM", "Value": ["095427.671000"]}, "1120": {"vr": "TM", "Value": ["095427.931000"]}, "1121": {"vr": "TM", "Value": ["094947.808000"]}, "1122": {"vr": "TM", "Value": ["094727.640000"]}, "1123": {"vr": "TM", "Value": ["094627.632000"]}, "1124": {"vr": "TM", "Value": ["094947.658000"]}, "1125": {"vr": "TM", "Value": ["094927.651000"]}, "1126": {"vr": "TM", "Value": ["095447.911000"]}, "1127": {"vr": "TM", "Value": ["094647.833000"]}, "1128": {"vr": "TM", "Value": ["095127.779000"]}, "1129": {"vr": "TM", "Value": ["094847.819000"]}, "1130": {"vr": "TM", "Value": ["095427.873000"]}, "1131": {"vr": "TM", "Value": ["094707.678000"]}, "1132": {"vr": "TM", "Value": ["094647.857000"]}, "1133": {"vr": "TM", "Value": ["095107.706000"]}, "1134": {"vr": "TM", "Value": ["095227.637000"]}, "1135": {"vr": "TM", "Value": ["094927.719000"]}, "1136": {"vr": "TM", "Value": ["094827.929000"]}, "1137": {"vr": "TM", "Value": ["095307.627000"]}, "1138": {"vr": "TM", "Value": ["094647.680000"]}, "1139": {"vr": "TM", "Value": ["095027.632000"]}, "1140": {"vr": "TM", "Value": ["094607.641000"]}, "1141": {"vr": "TM", "Value": ["094907.725000"]}, "1142": {"vr": "TM", "Value": ["094627.607000"]}, "1143": {"vr": "TM", "Value": ["094647.675000"]}, "1144": {"vr": "TM", "Value": ["094747.617000"]}, "1145": {"vr": "TM", "Value": ["095007.743000"]}, "1146": {"vr": "TM", "Value": ["094827.615000"]}, "1147": {"vr": "TM", "Value": ["095456.502000"]}, "1148": {"vr": "TM", "Value": ["094707.651000"]}, "1149": {"vr": "TM", "Value": ["094527.666000"]}, "1150": {"vr": "TM", "Value": ["095447.721000"]}, "1151": {"vr": "TM", "Value": ["094927.858000"]}, "1152": {"vr": "TM", "Value": ["095047.674000"]}, "1153": {"vr": "TM", "Value": ["095007.733000"]}, "1154": {"vr": "TM", "Value": ["095107.613000"]}, "1155": {"vr": "TM", "Value": ["095047.723000"]}, "1156": {"vr": "TM", "Value": ["094647.846000"]}, "1157": {"vr": "TM", "Value": ["094547.657000"]}, "1158": {"vr": "TM", "Value": ["095247.901000"]}, "1159": {"vr": "TM", "Value": ["095007.674000"]}, "1160": {"vr": "TM", "Value": ["095107.741000"]}, "1161": {"vr": "TM", "Value": ["094707.727000"]}, "1162": {"vr": "TM", "Value": ["095127.827000"]}, "1163": {"vr": "TM", "Value": ["095127.744000"]}, "1164": {"vr": "TM", "Value": ["094927.770000"]}, "1165": {"vr": "TM", "Value": ["095327.765000"]}, "1166": {"vr": "TM", "Value": ["094527.740000"]}, "1167": {"vr": "TM", "Value": ["095227.849000"]}, "1168": {"vr": "TM", "Value": ["094607.804000"]}, "1169": {"vr": "TM", "Value": ["095307.794000"]}, "1170": {"vr": "TM", "Value": ["095327.873000"]}, "1171": {"vr": "TM", "Value": ["094627.881000"]}, "1172": {"vr": "TM", "Value": ["095147.913000"]}, "1173": {"vr": "TM", "Value": ["095407.924000"]}, "1174": {"vr": "TM", "Value": ["095207.619000"]}, "1175": {"vr": "TM", "Value": ["095247.746000"]}, "1176": {"vr": "TM", "Value": ["095247.635000"]}, "1177": {"vr": "TM", "Value": ["095347.684000"]}, "1178": {"vr": "TM", "Value": ["094527.767000"]}, "1179": {"vr": "TM", "Value": ["094747.654000"]}, "1180": {"vr": "TM", "Value": ["094907.738000"]}, "1181": {"vr": "TM", "Value": ["094847.787000"]}, "1182": {"vr": "TM", "Value": ["094547.918000"]}, "1183": {"vr": "TM", "Value": ["095027.847000"]}, "1184": {"vr": "TM", "Value": ["095307.758000"]}, "1185": {"vr": "TM", "Value": ["094907.806000"]}, "1186": {"vr": "TM", "Value": ["094547.712000"]}, "1187": {"vr": "TM", "Value": ["094947.796000"]}, "1188": {"vr": "TM", "Value": ["095247.841000"]}, "1189": {"vr": "TM", "Value": ["095327.694000"]}, "1190": {"vr": "TM", "Value": ["095407.817000"]}, "1191": {"vr": "TM", "Value": ["094527.729000"]}, "1192": {"vr": "TM", "Value": ["094707.745000"]}, "1193": {"vr": "TM", "Value": ["095007.861000"]}, "1194": {"vr": "TM", "Value": ["095447.894000"]}, "1195": {"vr": "TM", "Value": ["094927.735000"]}, "1196": {"vr": "TM", "Value": ["094547.691000"]}, "1197": {"vr": "TM", "Value": ["095427.666000"]}, "1198": {"vr": "TM", "Value": ["094847.641000"]}, "1199": {"vr": "TM", "Value": ["095207.869000"]}, "1200": {"vr": "TM", "Value": ["095307.889000"]}, "1201": {"vr": "TM", "Value": ["094527.689000"]}, "1202": {"vr": "TM", "Value": ["094707.609000"]}, "1203": {"vr": "TM", "Value": ["095447.737000"]}, "1204": {"vr": "TM", "Value": ["095227.899000"]}, "1205": {"vr": "TM", "Value": ["095047.941000"]}, "1206": {"vr": "TM", "Value": ["095327.922000"]}, "1207": {"vr": "TM", "Value": ["095127.748000"]}, "1208": {"vr": "TM", "Value": ["094547.610000"]}, "1209": {"vr": "TM", "Value": ["094547.920000"]}, "1210": {"vr": "TM", "Value": ["095047.635000"]}, "1211": {"vr": "TM", "Value": ["095447.675000"]}, "1212": {"vr": "TM", "Value": ["094727.939000"]}, "1213": {"vr": "TM", "Value": ["095027.700000"]}, "1214": {"vr": "TM", "Value": ["095407.723000"]}, "1215": {"vr": "TM", "Value": ["095047.810000"]}, "1216": {"vr": "TM", "Value": ["095207.902000"]}, "1217": {"vr": "TM", "Value": ["095227.871000"]}, "1218": {"vr": "TM", "Value": ["094527.943000"]}, "1219": {"vr": "TM", "Value": ["095327.699000"]}, "1220": {"vr": "TM", "Value": ["095327.777000"]}, "1221": {"vr": "TM", "Value": ["095427.724000"]}, "1222": {"vr": "TM", "Value": ["094707.943000"]}, "1223": {"vr": "TM", "Value": ["095407.656000"]}, "1224": {"vr": "TM", "Value": ["094847.930000"]}, "1225": {"vr": "TM", "Value": ["094547.731000"]}, "1226": {"vr": "TM", "Value": ["094527.955000"]}, "1227": {"vr": "TM", "Value": ["095427.773000"]}, "1228": {"vr": "TM", "Value": ["095427.700000"]}, "1229": {"vr": "TM", "Value": ["095207.611000"]}, "1230": {"vr": "TM", "Value": ["095127.862000"]}, "1231": {"vr": "TM", "Value": ["095347.776000"]}, "1232": {"vr": "TM", "Value": ["095407.951000"]}, "1233": {"vr": "TM", "Value": ["094747.731000"]}, "1234": {"vr": "TM", "Value": ["094647.614000"]}, "1235": {"vr": "TM", "Value": ["094827.740000"]}, "1236": {"vr": "TM", "Value": ["094547.689000"]}, "1237": {"vr": "TM", "Value": ["095447.814000"]}, "1238": {"vr": "TM", "Value": ["094827.733000"]}, "1239": {"vr": "TM", "Value": ["094707.692000"]}, "1240": {"vr": "TM", "Value": ["094707.912000"]}, "1241": {"vr": "TM", "Value": ["094527.857000"]}, "1242": {"vr": "TM", "Value": ["095207.631000"]}, "1243": {"vr": "TM", "Value": ["095247.763000"]}, "1244": {"vr": "TM", "Value": ["095047.800000"]}, "1245": {"vr": "TM", "Value": ["094907.619000"]}, "1246": {"vr": "TM", "Value": ["095247.755000"]}, "1247": {"vr": "TM", "Value": ["094747.662000"]}, "1248": {"vr": "TM", "Value": ["095007.687000"]}, "1249": {"vr": "TM", "Value": ["095347.779000"]}, "1250": {"vr": "TM", "Value": ["094547.928000"]}, "1251": {"vr": "TM", "Value": ["095127.934000"]}, "1252": {"vr": "TM", "Value": ["095007.679000"]}, "1253": {"vr": "TM", "Value": ["095327.909000"]}, "1254": {"vr": "TM", "Value": ["094847.649000"]}, "1255": {"vr": "TM", "Value": ["094847.887000"]}, "1256": {"vr": "TM", "Value": ["095227.640000"]}, "1257": {"vr": "TM", "Value": ["094527.916000"]}, "1258": {"vr": "TM", "Value": ["094607.864000"]}, "1259": {"vr": "TM", "Value": ["095307.611000"]}, "1260": {"vr": "TM", "Value": ["095147.727000"]}, "1261": {"vr": "TM", "Value": ["094647.732000"]}, "1262": {"vr": "TM", "Value": ["094747.636000"]}, "1263": {"vr": "TM", "Value": ["095147.910000"]}, "1264": {"vr": "TM", "Value": ["094707.656000"]}, "1265": {"vr": "TM", "Value": ["094727.665000"]}, "1266": {"vr": "TM", "Value": ["094807.666000"]}, "1267": {"vr": "TM", "Value": ["095047.759000"]}, "1268": {"vr": "TM", "Value": ["095007.629000"]}, "1269": {"vr": "TM", "Value": ["094607.812000"]}, "1270": {"vr": "TM", "Value": ["094627.916000"]}, "1271": {"vr": "TM", "Value": ["095456.495000"]}, "1272": {"vr": "TM", "Value": ["094927.860000"]}, "1273": {"vr": "TM", "Value": ["094727.723000"]}, "1274": {"vr": "TM", "Value": ["095207.718000"]}, "1275": {"vr": "TM", "Value": ["095307.639000"]}, "1276": {"vr": "TM", "Value": ["095407.794000"]}, "1277": {"vr": "TM", "Value": ["095427.743000"]}, "1278": {"vr": "TM", "Value": ["094927.714000"]}, "1279": {"vr": "TM", "Value": ["094907.730000"]}, "1280": {"vr": "TM", "Value": ["094607.740000"]}, "1281": {"vr": "TM", "Value": ["095207.793000"]}, "1282": {"vr": "TM", "Value": ["094707.682000"]}, "1283": {"vr": "TM", "Value": ["095207.749000"]}, "1284": {"vr": "TM", "Value": ["095207.941000"]}, "1285": {"vr": "TM", "Value": ["094907.837000"]}, "1286": {"vr": "TM", "Value": ["094907.743000"]}, "1287": {"vr": "TM", "Value": ["094907.916000"]}, "1288": {"vr": "TM", "Value": ["094807.926000"]}, "1289": {"vr": "TM", "Value": ["095247.682000"]}, "1290": {"vr": "TM", "Value": ["094807.755000"]}, "1291": {"vr": "TM", "Value": ["094527.692000"]}, "1292": {"vr": "TM", "Value": ["094927.793000"]}, "1293": {"vr": "TM", "Value": ["095027.608000"]}, "1294": {"vr": "TM", "Value": ["095347.674000"]}, "1295": {"vr": "TM", "Value": ["094927.923000"]}, "1296": {"vr": "TM", "Value": ["094727.688000"]}, "1297": {"vr": "TM", "Value": ["094707.917000"]}, "1298": {"vr": "TM", "Value": ["094527.895000"]}, "1299": {"vr": "TM", "Value": ["094627.868000"]}, "1300": {"vr": "TM", "Value": ["095007.836000"]}, "1301": {"vr": "TM", "Value": ["094947.834000"]}, "1302": {"vr": "TM", "Value": ["094527.948000"]}, "1303": {"vr": "TM", "Value": ["095407.664000"]}, "1304": {"vr": "TM", "Value": ["094927.664000"]}, "1305": {"vr": "TM", "Value": ["095007.703000"]}, "1306": {"vr": "TM", "Value": ["094547.947000"]}, "1307": {"vr": "TM", "Value": ["095307.897000"]}, "1308": {"vr": "TM", "Value": ["094627.921000"]}, "1309": {"vr": "TM", "Value": ["094647.922000"]}, "1310": {"vr": "TM", "Value": ["094527.914000"]}, "1311": {"vr": "TM", "Value": ["094947.848000"]}, "1312": {"vr": "TM", "Value": ["095407.890000"]}, "1313": {"vr": "TM", "Value": ["094947.617000"]}, "1314": {"vr": "TM", "Value": ["094727.901000"]}, "1315": {"vr": "TM", "Value": ["094527.928000"]}, "1316": {"vr": "TM", "Value": ["095027.936000"]}, "1317": {"vr": "TM", "Value": ["094907.644000"]}, "1318": {"vr": "TM", "Value": ["094607.671000"]}, "1319": {"vr": "TM", "Value": ["094647.620000"]}, "1320": {"vr": "TM", "Value": ["095247.865000"]}, "1321": {"vr": "TM", "Value": ["094947.855000"]}, "1322": {"vr": "TM", "Value": ["094627.615000"]}, "1323": {"vr": "TM", "Value": ["094747.890000"]}, "1324": {"vr": "TM", "Value": ["094827.863000"]}, "1325": {"vr": "TM", "Value": ["094547.652000"]}, "1326": {"vr": "TM", "Value": ["094827.846000"]}, "1327": {"vr": "TM", "Value": ["095407.837000"]}, "1328": {"vr": "TM", "Value": ["094727.756000"]}, "1329": {"vr": "TM", "Value": ["095147.905000"]}, "1330": {"vr": "TM", "Value": ["095456.488000"]}, "1331": {"vr": "TM", "Value": ["094927.669000"]}, "1332": {"vr": "TM", "Value": ["095347.897000"]}, "1333": {"vr": "TM", "Value": ["095327.794000"]}, "1334": {"vr": "TM", "Value": ["095247.694000"]}, "1335": {"vr": "TM", "Value": ["094747.938000"]}, "1336": {"vr": "TM", "Value": ["095027.685000"]}, "1337": {"vr": "TM", "Value": ["094727.828000"]}, "1338": {"vr": "TM", "Value": ["094847.849000"]}, "1339": {"vr": "TM", "Value": ["095227.781000"]}, "1340": {"vr": "TM", "Value": ["094607.789000"]}, "1341": {"vr": "TM", "Value": ["095427.647000"]}, "1342": {"vr": "TM", "Value": ["094627.650000"]}, "1343": {"vr": "TM", "Value": ["095247.832000"]}, "1344": {"vr": "TM", "Value": ["094727.753000"]}, "1345": {"vr": "TM", "Value": ["094727.792000"]}, "1346": {"vr": "TM", "Value": ["094627.759000"]}, "1347": {"vr": "TM", "Value": ["094527.747000"]}, "1348": {"vr": "TM", "Value": ["095127.858000"]}, "1349": {"vr": "TM", "Value": ["094627.761000"]}, "1350": {"vr": "TM", "Value": ["095127.835000"]}, "1351": {"vr": "TM", "Value": ["094607.618000"]}, "1352": {"vr": "TM", "Value": ["095007.735000"]}, "1353": {"vr": "TM", "Value": ["095247.806000"]}, "1354": {"vr": "TM", "Value": ["095427.776000"]}, "1355": {"vr": "TM", "Value": ["094827.717000"]}, "1356": {"vr": "TM", "Value": ["094947.761000"]}, "1357": {"vr": "TM", "Value": ["095027.926000"]}, "1358": {"vr": "TM", "Value": ["094707.614000"]}, "1359": {"vr": "TM", "Value": ["095407.700000"]}, "1360": {"vr": "TM", "Value": ["095407.702000"]}, "1361": {"vr": "TM", "Value": ["094607.856000"]}, "1362": {"vr": "TM", "Value": ["094527.817000"]}, "1363": {"vr": "TM", "Value": ["094707.866000"]}, "1364": {"vr": "TM", "Value": ["094727.883000"]}, "1365": {"vr": "TM", "Value": ["095047.713000"]}, "1366": {"vr": "TM", "Value": ["094847.822000"]}, "1367": {"vr": "TM", "Value": ["094607.695000"]}, "1368": {"vr": "TM", "Value": ["094807.953000"]}, "1369": {"vr": "TM", "Value": ["094847.685000"]}, "1370": {"vr": "TM", "Value": ["094947.860000"]}, "1371": {"vr": "TM", "Value": ["094627.861000"]}, "1372": {"vr": "TM", "Value": ["094607.750000"]}, "1373": {"vr": "TM", "Value": ["095227.617000"]}, "1374": {"vr": "TM", "Value": ["095027.746000"]}, "1375": {"vr": "TM", "Value": ["094827.936000"]}, "1376": {"vr": "TM", "Value": ["094627.886000"]}, "1377": {"vr": "TM", "Value": ["094647.678000"]}, "1378": {"vr": "TM", "Value": ["095447.613000"]}, "1379": {"vr": "TM", "Value": ["095447.768000"]}, "1380": {"vr": "TM", "Value": ["095047.866000"]}, "1381": {"vr": "TM", "Value": ["095327.726000"]}, "1382": {"vr": "TM", "Value": ["095327.840000"]}, "1383": {"vr": "TM", "Value": ["094727.926000"]}, "1384": {"vr": "TM", "Value": ["094627.768000"]}, "1385": {"vr": "TM", "Value": ["094847.940000"]}, "1386": {"vr": "TM", "Value": ["095207.649000"]}, "1387": {"vr": "TM", "Value": ["094847.892000"]}, "1388": {"vr": "TM", "Value": ["095047.933000"]}, "1389": {"vr": "TM", "Value": ["094627.665000"]}, "1390": {"vr": "TM", "Value": ["094907.683000"]}, "1391": {"vr": "TM", "Value": ["094527.810000"]}, "1392": {"vr": "TM", "Value": ["095407.746000"]}, "1393": {"vr": "TM", "Value": ["094847.920000"]}, "1394": {"vr": "TM", "Value": ["095027.708000"]}, "1395": {"vr": "TM", "Value": ["094927.921000"]}, "1396": {"vr": "TM", "Value": ["095127.706000"]}, "1397": {"vr": "TM", "Value": ["094947.680000"]}, "1398": {"vr": "TM", "Value": ["094807.682000"]}, "1399": {"vr": "TM", "Value": ["094827.808000"]}, "1400": {"vr": "TM", "Value": ["095047.956000"]}, "1401": {"vr": "TM", "Value": ["094747.778000"]}, "1402": {"vr": "TM", "Value": ["095347.910000"]}, "1403": {"vr": "TM", "Value": ["095007.725000"]}, "1404": {"vr": "TM", "Value": ["094527.636000"]}, "1405": {"vr": "TM", "Value": ["094547.667000"]}, "1406": {"vr": "TM", "Value": ["094727.950000"]}, "1407": {"vr": "TM", "Value": ["094707.884000"]}, "1408": {"vr": "TM", "Value": ["094827.771000"]}, "1409": {"vr": "TM", "Value": ["094727.627000"]}, "1410": {"vr": "TM", "Value": ["095347.933000"]}, "1411": {"vr": "TM", "Value": ["094647.657000"]}, "1412": {"vr": "TM", "Value": ["095047.815000"]}, "1413": {"vr": "TM", "Value": ["095327.775000"]}, "1414": {"vr": "TM", "Value": ["095127.837000"]}, "1415": {"vr": "TM", "Value": ["094547.791000"]}, "1416": {"vr": "TM", "Value": ["094727.825000"]}, "1417": {"vr": "TM", "Value": ["094647.933000"]}, "1418": {"vr": "TM", "Value": ["095027.785000"]}, "1419": {"vr": "TM", "Value": ["095347.827000"]}, "1420": {"vr": "TM", "Value": ["095247.705000"]}, "1421": {"vr": "TM", "Value": ["094727.868000"]}, "1422": {"vr": "TM", "Value": ["095327.865000"]}, "1423": {"vr": "TM", "Value": ["094947.747000"]}, "1424": {"vr": "TM", "Value": ["095407.919000"]}, "1425": {"vr": "TM", "Value": ["094907.663000"]}, "1426": {"vr": "TM", "Value": ["095307.622000"]}, "1427": {"vr": "TM", "Value": ["095227.714000"]}, "1428": {"vr": "TM", "Value": ["094927.732000"]}, "1429": {"vr": "TM", "Value": ["095347.641000"]}, "1430": {"vr": "TM", "Value": ["095327.787000"]}, "1431": {"vr": "TM", "Value": ["095427.926000"]}, "1432": {"vr": "TM", "Value": ["094947.745000"]}, "1433": {"vr": "TM", "Value": ["095247.640000"]}, "1434": {"vr": "TM", "Value": ["095147.629000"]}, "1435": {"vr": "TM", "Value": ["095047.772000"]}, "1436": {"vr": "TM", "Value": ["095307.684000"]}, "1437": {"vr": "TM", "Value": ["095127.895000"]}, "1438": {"vr": "TM", "Value": ["094607.735000"]}, "1439": {"vr": "TM", "Value": ["095027.705000"]}, "1440": {"vr": "TM", "Value": ["095447.745000"]}, "1441": {"vr": "TM", "Value": ["095047.610000"]}, "1442": {"vr": "TM", "Value": ["094527.628000"]}, "1443": {"vr": "TM", "Value": ["095447.690000"]}, "1444": {"vr": "TM", "Value": ["095047.646000"]}, "1445": {"vr": "TM", "Value": ["095407.720000"]}, "1446": {"vr": "TM", "Value": ["095207.810000"]}, "1447": {"vr": "TM", "Value": ["094747.842000"]}, "1448": {"vr": "TM", "Value": ["094547.933000"]}, "1449": {"vr": "TM", "Value": ["094647.931000"]}, "1450": {"vr": "TM", "Value": ["094807.707000"]}, "1451": {"vr": "TM", "Value": ["094947.687000"]}, "1452": {"vr": "TM", "Value": ["094527.815000"]}, "1453": {"vr": "TM", "Value": ["095207.836000"]}, "1454": {"vr": "TM", "Value": ["095427.740000"]}, "1455": {"vr": "TM", "Value": ["095456.500000"]}, "1456": {"vr": "TM", "Value": ["095047.823000"]}, "1457": {"vr": "TM", "Value": ["094707.792000"]}, "1458": {"vr": "TM", "Value": ["095447.801000"]}, "1459": {"vr": "TM", "Value": ["094627.637000"]}, "1460": {"vr": "TM", "Value": ["095327.731000"]}, "1461": {"vr": "TM", "Value": ["094707.644000"]}, "1462": {"vr": "TM", "Value": ["094947.622000"]}, "1463": {"vr": "TM", "Value": ["094927.891000"]}, "1464": {"vr": "TM", "Value": ["095307.920000"]}, "1465": {"vr": "TM", "Value": ["095107.824000"]}, "1466": {"vr": "TM", "Value": ["094747.767000"]}, "1467": {"vr": "TM", "Value": ["094727.685000"]}, "1468": {"vr": "TM", "Value": ["095207.684000"]}, "1469": {"vr": "TM", "Value": ["095407.766000"]}, "1470": {"vr": "TM", "Value": ["095107.754000"]}, "1471": {"vr": "TM", "Value": ["095327.819000"]}, "1472": {"vr": "TM", "Value": ["094727.934000"]}, "1473": {"vr": "TM", "Value": ["094747.649000"]}, "1474": {"vr": "TM", "Value": ["095147.801000"]}, "1475": {"vr": "TM", "Value": ["095327.896000"]}, "1476": {"vr": "TM", "Value": ["094847.777000"]}, "1477": {"vr": "TM", "Value": ["094547.888000"]}, "1478": {"vr": "TM", "Value": ["094847.857000"]}, "1479": {"vr": "TM", "Value": ["095127.758000"]}, "1480": {"vr": "TM", "Value": ["095247.719000"]}, "1481": {"vr": "TM", "Value": ["095307.850000"]}, "1482": {"vr": "TM", "Value": ["095247.710000"]}, "1483": {"vr": "TM", "Value": ["095227.906000"]}, "1484": {"vr": "TM", "Value": ["095047.818000"]}, "1485": {"vr": "TM", "Value": ["094907.824000"]}, "1486": {"vr": "TM", "Value": ["094647.757000"]}, "1487": {"vr": "TM", "Value": ["095447.625000"]}, "1488": {"vr": "TM", "Value": ["095147.777000"]}, "1489": {"vr": "TM", "Value": ["094927.618000"]}, "1490": {"vr": "TM", "Value": ["095047.658000"]}, "1491": {"vr": "TM", "Value": ["094807.905000"]}, "1492": {"vr": "TM", "Value": ["095107.770000"]}, "1493": {"vr": "TM", "Value": ["094707.607000"]}, "1494": {"vr": "TM", "Value": ["095407.898000"]}, "1495": {"vr": "TM", "Value": ["095207.621000"]}, "1496": {"vr": "TM", "Value": ["095347.784000"]}, "1497": {"vr": "TM", "Value": ["094707.914000"]}, "1498": {"vr": "TM", "Value": ["094927.837000"]}, "1499": {"vr": "TM", "Value": ["095347.789000"]}, "1500": {"vr": "TM", "Value": ["095127.801000"]}, "1501": {"vr": "TM", "Value": ["094747.695000"]}, "1502": {"vr": "TM", "Value": ["095107.805000"]}, "1503": {"vr": "TM", "Value": ["095327.899000"]}, "1504": {"vr": "TM", "Value": ["095107.878000"]}, "1505": {"vr": "TM", "Value": ["094807.712000"]}, "1506": {"vr": "TM", "Value": ["094927.613000"]}, "1507": {"vr": "TM", "Value": ["094807.668000"]}, "1508": {"vr": "TM", "Value": ["094607.869000"]}, "1509": {"vr": "TM", "Value": ["094707.702000"]}, "1510": {"vr": "TM", "Value": ["095127.877000"]}, "1511": {"vr": "TM", "Value": ["095327.817000"]}, "1512": {"vr": "TM", "Value": ["095147.796000"]}, "1513": {"vr": "TM", "Value": ["094547.874000"]}, "1514": {"vr": "TM", "Value": ["094727.813000"]}, "1515": {"vr": "TM", "Value": ["094527.649000"]}, "1516": {"vr": "TM", "Value": ["094527.970000"]}, "1517": {"vr": "TM", "Value": ["095327.767000"]}, "1518": {"vr": "TM", "Value": ["095307.689000"]}, "1519": {"vr": "TM", "Value": ["095027.829000"]}, "1520": {"vr": "TM", "Value": ["094847.722000"]}, "1521": {"vr": "TM", "Value": ["095327.656000"]}, "1522": {"vr": "TM", "Value": ["094807.679000"]}, "1523": {"vr": "TM", "Value": ["094847.748000"]}, "1524": {"vr": "TM", "Value": ["094927.776000"]}, "1525": {"vr": "TM", "Value": ["094627.822000"]}, "1526": {"vr": "TM", "Value": ["094747.607000"]}, "1527": {"vr": "TM", "Value": ["095247.904000"]}, "1528": {"vr": "TM", "Value": ["094547.637000"]}, "1529": {"vr": "TM", "Value": ["094907.871000"]}, "1530": {"vr": "TM", "Value": ["095227.885000"]}, "1531": {"vr": "TM", "Value": ["094947.670000"]}, "1532": {"vr": "TM", "Value": ["095407.917000"]}, "1533": {"vr": "TM", "Value": ["094747.715000"]}, "1534": {"vr": "TM", "Value": ["094847.862000"]}, "1535": {"vr": "TM", "Value": ["094727.830000"]}, "1536": {"vr": "TM", "Value": ["095007.822000"]}, "1537": {"vr": "TM", "Value": ["094607.613000"]}, "1538": {"vr": "TM", "Value": ["094547.913000"]}, "1539": {"vr": "TM", "Value": ["094647.799000"]}, "1540": {"vr": "TM", "Value": ["095027.757000"]}, "1541": {"vr": "TM", "Value": ["095047.757000"]}, "1542": {"vr": "TM", "Value": ["094747.884000"]}, "1543": {"vr": "TM", "Value": ["094847.835000"]}, "1544": {"vr": "TM", "Value": ["095007.771000"]}, "1545": {"vr": "TM", "Value": ["094947.694000"]}, "1546": {"vr": "TM", "Value": ["095047.958000"]}, "1547": {"vr": "TM", "Value": ["095047.653000"]}, "1548": {"vr": "TM", "Value": ["095027.715000"]}, "1549": {"vr": "TM", "Value": ["094907.853000"]}, "1550": {"vr": "TM", "Value": ["094807.814000"]}, "1551": {"vr": "TM", "Value": ["094827.667000"]}, "1552": {"vr": "TM", "Value": ["094907.723000"]}, "1553": {"vr": "TM", "Value": ["094647.972000"]}, "1554": {"vr": "TM", "Value": ["095007.654000"]}, "1555": {"vr": "TM", "Value": ["094527.724000"]}, "1556": {"vr": "TM", "Value": ["095107.679000"]}, "1557": {"vr": "TM", "Value": ["094947.872000"]}, "1558": {"vr": "TM", "Value": ["094927.694000"]}, "1559": {"vr": "TM", "Value": ["095147.755000"]}, "1560": {"vr": "TM", "Value": ["095427.853000"]}, "1561": {"vr": "TM", "Value": ["095027.654000"]}, "1562": {"vr": "TM", "Value": ["095327.677000"]}, "1563": {"vr": "TM", "Value": ["094727.944000"]}, "1564": {"vr": "TM", "Value": ["094747.682000"]}, "1565": {"vr": "TM", "Value": ["094627.754000"]}, "1566": {"vr": "TM", "Value": ["095027.892000"]}, "1567": {"vr": "TM", "Value": ["094807.902000"]}, "1568": {"vr": "TM", "Value": ["095027.733000"]}, "1569": {"vr": "TM", "Value": ["095327.941000"]}, "1570": {"vr": "TM", "Value": ["095107.812000"]}, "1571": {"vr": "TM", "Value": ["094547.744000"]}, "1572": {"vr": "TM", "Value": ["094847.870000"]}, "1573": {"vr": "TM", "Value": ["095047.868000"]}, "1574": {"vr": "TM", "Value": ["095007.843000"]}, "1575": {"vr": "TM", "Value": ["095107.789000"]}, "1576": {"vr": "TM", "Value": ["094647.705000"]}, "1577": {"vr": "TM", "Value": ["095127.739000"]}, "1578": {"vr": "TM", "Value": ["095447.752000"]}, "1579": {"vr": "TM", "Value": ["095447.770000"]}, "1580": {"vr": "TM", "Value": ["095207.910000"]}, "1581": {"vr": "TM", "Value": ["094927.896000"]}, "1582": {"vr": "TM", "Value": ["095227.878000"]}, "1583": {"vr": "TM", "Value": ["095107.618000"]}, "1584": {"vr": "TM", "Value": ["094727.823000"]}, "1585": {"vr": "TM", "Value": ["095347.748000"]}, "1586": {"vr": "TM", "Value": ["095247.910000"]}, "1587": {"vr": "TM", "Value": ["095107.625000"]}, "1588": {"vr": "TM", "Value": ["095147.689000"]}, "1589": {"vr": "TM", "Value": ["094707.851000"]}, "1590": {"vr": "TM", "Value": ["094847.634000"]}, "1591": {"vr": "TM", "Value": ["094727.916000"]}, "1592": {"vr": "TM", "Value": ["095347.664000"]}, "1593": {"vr": "TM", "Value": ["095047.774000"]}, "1594": {"vr": "TM", "Value": ["095327.701000"]}, "1595": {"vr": "TM", "Value": ["095427.802000"]}, "1596": {"vr": "TM", "Value": ["094607.817000"]}, "1597": {"vr": "TM", "Value": ["094927.812000"]}, "1598": {"vr": "TM", "Value": ["095407.642000"]}, "1599": {"vr": "TM", "Value": ["095227.655000"]}, "1600": {"vr": "TM", "Value": ["095147.775000"]}, "1601": {"vr": "TM", "Value": ["094527.764000"]}, "1602": {"vr": "TM", "Value": ["095407.789000"]}, "1603": {"vr": "TM", "Value": ["095456.455000"]}, "1604": {"vr": "TM", "Value": ["094707.671000"]}, "1605": {"vr": "TM", "Value": ["095107.850000"]}, "1606": {"vr": "TM", "Value": ["095427.897000"]}, "1607": {"vr": "TM", "Value": ["094847.756000"]}, "1608": {"vr": "TM", "Value": ["095307.861000"]}, "1609": {"vr": "TM", "Value": ["094947.609000"]}, "1610": {"vr": "TM", "Value": ["095007.901000"]}, "1611": {"vr": "TM", "Value": ["095247.736000"]}, "1612": {"vr": "TM", "Value": ["094947.803000"]}, "1613": {"vr": "TM", "Value": ["095247.794000"]}, "1614": {"vr": "TM", "Value": ["094727.909000"]}, "1615": {"vr": "TM", "Value": ["095307.681000"]}, "1616": {"vr": "TM", "Value": ["094727.838000"]}, "1617": {"vr": "TM", "Value": ["095007.710000"]}, "1618": {"vr": "TM", "Value": ["094947.891000"]}, "1619": {"vr": "TM", "Value": ["094547.702000"]}, "1620": {"vr": "TM", "Value": ["094727.735000"]}, "1621": {"vr": "TM", "Value": ["095007.639000"]}, "1622": {"vr": "TM", "Value": ["095127.855000"]}, "1623": {"vr": "TM", "Value": ["094947.782000"]}, "1624": {"vr": "TM", "Value": ["095407.797000"]}, "1625": {"vr": "TM", "Value": ["094827.875000"]}, "1626": {"vr": "TM", "Value": ["095027.929000"]}, "1627": {"vr": "TM", "Value": ["094847.695000"]}, "1628": {"vr": "TM", "Value": ["095047.648000"]}, "1629": {"vr": "TM", "Value": ["095247.696000"]}, "1630": {"vr": "TM", "Value": ["095447.701000"]}, "1631": {"vr": "TM", "Value": ["094707.712000"]}, "1632": {"vr": "TM", "Value": ["095147.644000"]}, "1633": {"vr": "TM", "Value": ["095047.630000"]}, "1634": {"vr": "TM", "Value": ["094547.758000"]}, "1635": {"vr": "TM", "Value": ["095227.724000"]}, "1636": {"vr": "TM", "Value": ["094607.786000"]}, "1637": {"vr": "TM", "Value": ["095207.679000"]}, "1638": {"vr": "TM", "Value": ["094907.921000"]}, "1639": {"vr": "TM", "Value": ["095327.855000"]}, "1640": {"vr": "TM", "Value": ["094647.886000"]}, "1641": {"vr": "TM", "Value": ["095447.940000"]}, "1642": {"vr": "TM", "Value": ["094547.644000"]}, "1643": {"vr": "TM", "Value": ["095456.481000"]}, "1644": {"vr": "TM", "Value": ["095007.815000"]}, "1645": {"vr": "TM", "Value": ["095407.710000"]}, "1646": {"vr": "TM", "Value": ["095247.633000"]}, "1647": {"vr": "TM", "Value": ["095347.656000"]}, "1648": {"vr": "TM", "Value": ["094747.679000"]}, "1649": {"vr": "TM", "Value": ["094827.952000"]}, "1650": {"vr": "TM", "Value": ["095007.705000"]}, "1651": {"vr": "TM", "Value": ["095247.860000"]}, "1652": {"vr": "TM", "Value": ["094927.625000"]}, "1653": {"vr": "TM", "Value": ["094947.754000"]}, "1654": {"vr": "TM", "Value": ["094807.638000"]}, "1655": {"vr": "TM", "Value": ["095147.869000"]}, "1656": {"vr": "TM", "Value": ["094947.714000"]}, "1657": {"vr": "TM", "Value": ["095147.715000"]}, "1658": {"vr": "TM", "Value": ["095227.676000"]}, "1659": {"vr": "TM", "Value": ["094907.745000"]}, "1660": {"vr": "TM", "Value": ["095127.798000"]}, "1661": {"vr": "TM", "Value": ["094527.837000"]}, "1662": {"vr": "TM", "Value": ["095107.774000"]}, "1663": {"vr": "TM", "Value": ["094827.704000"]}, "1664": {"vr": "TM", "Value": ["095307.766000"]}, "1665": {"vr": "TM", "Value": ["095227.778000"]}, "1666": {"vr": "TM", "Value": ["094927.692000"]}, "1667": {"vr": "TM", "Value": ["095227.927000"]}, "1668": {"vr": "TM", "Value": ["094707.815000"]}, "1669": {"vr": "TM", "Value": ["095247.661000"]}, "1670": {"vr": "TM", "Value": ["094927.745000"]}, "1671": {"vr": "TM", "Value": ["095147.707000"]}, "1672": {"vr": "TM", "Value": ["094607.825000"]}, "1673": {"vr": "TM", "Value": ["094827.725000"]}, "1674": {"vr": "TM", "Value": ["095027.882000"]}, "1675": {"vr": "TM", "Value": ["094747.701000"]}, "1676": {"vr": "TM", "Value": ["094527.996000"]}, "1677": {"vr": "TM", "Value": ["095427.703000"]}, "1678": {"vr": "TM", "Value": ["094847.806000"]}, "1679": {"vr": "TM", "Value": ["094907.892000"]}, "1680": {"vr": "TM", "Value": ["095247.623000"]}, "1681": {"vr": "TM", "Value": ["094647.746000"]}, "1682": {"vr": "TM", "Value": ["095227.686000"]}, "1683": {"vr": "TM", "Value": ["095127.906000"]}, "1684": {"vr": "TM", "Value": ["095407.613000"]}, "1685": {"vr": "TM", "Value": ["095307.699000"]}, "1686": {"vr": "TM", "Value": ["094547.630000"]}, "1687": {"vr": "TM", "Value": ["095207.767000"]}, "1688": {"vr": "TM", "Value": ["094807.873000"]}, "1689": {"vr": "TM", "Value": ["094827.858000"]}, "1690": {"vr": "TM", "Value": ["095027.885000"]}, "1691": {"vr": "TM", "Value": ["095327.714000"]}, "1692": {"vr": "TM", "Value": ["094847.659000"]}, "1693": {"vr": "TM", "Value": ["094907.631000"]}, "1694": {"vr": "TM", "Value": ["095307.881000"]}, "1695": {"vr": "TM", "Value": ["094727.733000"]}, "1696": {"vr": "TM", "Value": ["094547.771000"]}, "1697": {"vr": "TM", "Value": ["095047.751000"]}, "1698": {"vr": "TM", "Value": ["095427.781000"]}, "1699": {"vr": "TM", "Value": ["095047.895000"]}, "1700": {"vr": "TM", "Value": ["094527.686000"]}, "1701": {"vr": "TM", "Value": ["095307.815000"]}, "1702": {"vr": "TM", "Value": ["094727.657000"]}, "1703": {"vr": "TM", "Value": ["094547.857000"]}, "1704": {"vr": "TM", "Value": ["095407.781000"]}, "1705": {"vr": "TM", "Value": ["094547.768000"]}, "1706": {"vr": "TM", "Value": ["094547.784000"]}, "1707": {"vr": "TM", "Value": ["094847.639000"]}, "1708": {"vr": "TM", "Value": ["095227.834000"]}, "1709": {"vr": "TM", "Value": ["095027.749000"]}, "1710": {"vr": "TM", "Value": ["094927.722000"]}, "1711": {"vr": "TM", "Value": ["094547.699000"]}, "1712": {"vr": "TM", "Value": ["095207.641000"]}, "1713": {"vr": "TM", "Value": ["094747.781000"]}, "1714": {"vr": "TM", "Value": ["095407.832000"]}, "1715": {"vr": "TM", "Value": ["095247.853000"]}, "1716": {"vr": "TM", "Value": ["094607.933000"]}, "1717": {"vr": "TM", "Value": ["094647.918000"]}, "1718": {"vr": "TM", "Value": ["094947.898000"]}, "1719": {"vr": "TM", "Value": ["095427.710000"]}, "1720": {"vr": "TM", "Value": ["095456.553000"]}, "1721": {"vr": "TM", "Value": ["095407.872000"]}, "1722": {"vr": "TM", "Value": ["094747.623000"]}, "1723": {"vr": "TM", "Value": ["095427.786000"]}, "1724": {"vr": "TM", "Value": ["095307.651000"]}, "1725": {"vr": "TM", "Value": ["094747.856000"]}, "1726": {"vr": "TM", "Value": ["095407.611000"]}, "1727": {"vr": "TM", "Value": ["094927.786000"]}, "1728": {"vr": "TM", "Value": ["094747.970000"]}, "1729": {"vr": "TM", "Value": ["095007.756000"]}, "1730": {"vr": "TM", "Value": ["094547.776000"]}, "1731": {"vr": "TM", "Value": ["094847.798000"]}, "1732": {"vr": "TM", "Value": ["094547.647000"]}, "1733": {"vr": "TM", "Value": ["094527.834000"]}, "1734": {"vr": "TM", "Value": ["095407.819000"]}, "1735": {"vr": "TM", "Value": ["095307.902000"]}, "1736": {"vr": "TM", "Value": ["094827.917000"]}, "1737": {"vr": "TM", "Value": ["094707.887000"]}, "1738": {"vr": "TM", "Value": ["095147.782000"]}, "1739": {"vr": "TM", "Value": ["094847.877000"]}, "1740": {"vr": "TM", "Value": ["095407.784000"]}, "1741": {"vr": "TM", "Value": ["094807.702000"]}, "1742": {"vr": "TM", "Value": ["094627.911000"]}, "1743": {"vr": "TM", "Value": ["094747.832000"]}, "1744": {"vr": "TM", "Value": ["095147.634000"]}, "1745": {"vr": "TM", "Value": ["095107.868000"]}, "1746": {"vr": "TM", "Value": ["095247.848000"]}, "1747": {"vr": "TM", "Value": ["095107.611000"]}, "1748": {"vr": "TM", "Value": ["095227.763000"]}, "1749": {"vr": "TM", "Value": ["095307.858000"]}, "1750": {"vr": "TM", "Value": ["095427.907000"]}, "1751": {"vr": "TM", "Value": ["095447.740000"]}, "1752": {"vr": "TM", "Value": ["094627.647000"]}, "1753": {"vr": "TM", "Value": ["094747.745000"]}, "1754": {"vr": "TM", "Value": ["094947.841000"]}, "1755": {"vr": "TM", "Value": ["095147.620000"]}, "1756": {"vr": "TM", "Value": ["094747.827000"]}, "1757": {"vr": "TM", "Value": ["095127.840000"]}, "1758": {"vr": "TM", "Value": ["094527.842000"]}, "1759": {"vr": "TM", "Value": ["094547.620000"]}, "1760": {"vr": "TM", "Value": ["095127.848000"]}, "1761": {"vr": "TM", "Value": ["094547.931000"]}, "1762": {"vr": "TM", "Value": ["094527.823000"]}, "1763": {"vr": "TM", "Value": ["094607.836000"]}, "1764": {"vr": "TM", "Value": ["094947.629000"]}, "1765": {"vr": "TM", "Value": ["094647.907000"]}, "1766": {"vr": "TM", "Value": ["094847.732000"]}, "1767": {"vr": "TM", "Value": ["094907.626000"]}, "1768": {"vr": "TM", "Value": ["094907.701000"]}, "1769": {"vr": "TM", "Value": ["094527.807000"]}, "1770": {"vr": "TM", "Value": ["095127.909000"]}, "1771": {"vr": "TM", "Value": ["094947.749000"]}, "1772": {"vr": "TM", "Value": ["094947.865000"]}, "1773": {"vr": "TM", "Value": ["095407.738000"]}, "1774": {"vr": "TM", "Value": ["094607.646000"]}, "1775": {"vr": "TM", "Value": ["094647.948000"]}, "1776": {"vr": "TM", "Value": ["095447.747000"]}, "1777": {"vr": "TM", "Value": ["094747.762000"]}, "1778": {"vr": "TM", "Value": ["094747.924000"]}, "1779": {"vr": "TM", "Value": ["095247.881000"]}, "1780": {"vr": "TM", "Value": ["094807.929000"]}, "1781": {"vr": "TM", "Value": ["095307.644000"]}, "1782": {"vr": "TM", "Value": ["094707.871000"]}, "1783": {"vr": "TM", "Value": ["094747.785000"]}, "1784": {"vr": "TM", "Value": ["095247.618000"]}, "1785": {"vr": "TM", "Value": ["094847.890000"]}, "1786": {"vr": "TM", "Value": ["095147.875000"]}, "1787": {"vr": "TM", "Value": ["095447.891000"]}, "1788": {"vr": "TM", "Value": ["094807.699000"]}, "1789": {"vr": "TM", "Value": ["095247.673000"]}, "1790": {"vr": "TM", "Value": ["094727.730000"]}, "1791": {"vr": "TM", "Value": ["094647.633000"]}, "1792": {"vr": "TM", "Value": ["095027.916000"]}, "1793": {"vr": "TM", "Value": ["094947.677000"]}, "1794": {"vr": "TM", "Value": ["094947.632000"]}, "1795": {"vr": "TM", "Value": ["094747.651000"]}, "1796": {"vr": "TM", "Value": ["094527.671000"]}, "1797": {"vr": "TM", "Value": ["095047.846000"]}, "1798": {"vr": "TM", "Value": ["094727.613000"]}, "1799": {"vr": "TM", "Value": ["095107.831000"]}, "1800": {"vr": "TM", "Value": ["095127.666000"]}, "1801": {"vr": "TM", "Value": ["095347.636000"]}, "1802": {"vr": "TM", "Value": ["094827.861000"]}, "1803": {"vr": "TM", "Value": ["095427.755000"]}, "1804": {"vr": "TM", "Value": ["095427.760000"]}, "1805": {"vr": "TM", "Value": ["095456.531000"]}, "1806": {"vr": "TM", "Value": ["094607.890000"]}, "1807": {"vr": "TM", "Value": ["095427.640000"]}, "1808": {"vr": "TM", "Value": ["095247.727000"]}, "1809": {"vr": "TM", "Value": ["094747.764000"]}, "1810": {"vr": "TM", "Value": ["095047.926000"]}, "1811": {"vr": "TM", "Value": ["094947.794000"]}, "1812": {"vr": "TM", "Value": ["094907.688000"]}, "1813": {"vr": "TM", "Value": ["094847.837000"]}, "1814": {"vr": "TM", "Value": ["095327.623000"]}, "1815": {"vr": "TM", "Value": ["095427.946000"]}, "1816": {"vr": "TM", "Value": ["095027.880000"]}, "1817": {"vr": "TM", "Value": ["095047.938000"]}, "1818": {"vr": "TM", "Value": ["095047.643000"]}, "1819": {"vr": "TM", "Value": ["094927.845000"]}, "1820": {"vr": "TM", "Value": ["094847.656000"]}, "1821": {"vr": "TM", "Value": ["095147.717000"]}, "1822": {"vr": "TM", "Value": ["095247.811000"]}, "1823": {"vr": "TM", "Value": ["095147.697000"]}, "1824": {"vr": "TM", "Value": ["094727.873000"]}, "1825": {"vr": "TM", "Value": ["095107.622000"]}, "1826": {"vr": "TM", "Value": ["094747.853000"]}, "1827": {"vr": "TM", "Value": ["095327.779000"]}, "1828": {"vr": "TM", "Value": ["094907.890000"]}, "1829": {"vr": "TM", "Value": ["094627.625000"]}, "1830": {"vr": "TM", "Value": ["094747.646000"]}, "1831": {"vr": "TM", "Value": ["095047.918000"]}, "1832": {"vr": "TM", "Value": ["094907.661000"]}, "1833": {"vr": "TM", "Value": ["095027.923000"]}, "1834": {"vr": "TM", "Value": ["094707.950000"]}, "1835": {"vr": "TM", "Value": ["095027.790000"]}, "1836": {"vr": "TM", "Value": ["095127.793000"]}, "1837": {"vr": "TM", "Value": ["094847.619000"]}, "1838": {"vr": "TM", "Value": ["095327.799000"]}, "1839": {"vr": "TM", "Value": ["095227.822000"]}, "1840": {"vr": "TM", "Value": ["094607.742000"]}, "1841": {"vr": "TM", "Value": ["095107.691000"]}, "1842": {"vr": "TM", "Value": ["094947.792000"]}, "1843": {"vr": "TM", "Value": ["094707.904000"]}, "1844": {"vr": "TM", "Value": ["095127.888000"]}, "1845": {"vr": "TM", "Value": ["094827.842000"]}, "1846": {"vr": "TM", "Value": ["094827.625000"]}, "1847": {"vr": "TM", "Value": ["094807.878000"]}, "1848": {"vr": "TM", "Value": ["095007.682000"]}, "1849": {"vr": "TM", "Value": ["095247.724000"]}, "1850": {"vr": "TM", "Value": ["095027.764000"]}, "1851": {"vr": "TM", "Value": ["095247.741000"]}, "1852": {"vr": "TM", "Value": ["095127.671000"]}, "1853": {"vr": "TM", "Value": ["094527.885000"]}, "1854": {"vr": "TM", "Value": ["094627.889000"]}, "1855": {"vr": "TM", "Value": ["094947.913000"]}, "1856": {"vr": "TM", "Value": ["094647.774000"]}, "1857": {"vr": "TM", "Value": ["095427.845000"]}, "1858": {"vr": "TM", "Value": ["094827.805000"]}, "1859": {"vr": "TM", "Value": ["094647.777000"]}, "1860": {"vr": "TM", "Value": ["095047.828000"]}, "1861": {"vr": "TM", "Value": ["095107.708000"]}, "1862": {"vr": "TM", "Value": ["094747.625000"]}, "1863": {"vr": "TM", "Value": ["095327.858000"]}, "1864": {"vr": "TM", "Value": ["094607.877000"]}, "1865": {"vr": "TM", "Value": ["095007.766000"]}, "1866": {"vr": "TM", "Value": ["095047.820000"]}, "1867": {"vr": "TM", "Value": ["095107.928000"]}, "1868": {"vr": "TM", "Value": ["095447.881000"]}, "1869": {"vr": "TM", "Value": ["095207.788000"]}, "1870": {"vr": "TM", "Value": ["094607.639000"]}, "1871": {"vr": "TM", "Value": ["095227.678000"]}, "1872": {"vr": "TM", "Value": ["095456.517000"]}, "1873": {"vr": "TM", "Value": ["094527.702000"]}, "1874": {"vr": "TM", "Value": ["094747.793000"]}, "1875": {"vr": "TM", "Value": ["095427.837000"]}, "1876": {"vr": "TM", "Value": ["094607.921000"]}, "1877": {"vr": "TM", "Value": ["094627.800000"]}, "1878": {"vr": "TM", "Value": ["095447.871000"]}, "1879": {"vr": "TM", "Value": ["094827.745000"]}, "1880": {"vr": "TM", "Value": ["094747.887000"]}, "1881": {"vr": "TM", "Value": ["095247.734000"]}, "1882": {"vr": "TM", "Value": ["094927.881000"]}, "1883": {"vr": "TM", "Value": ["094547.852000"]}, "1884": {"vr": "TM", "Value": ["094807.750000"]}, "1885": {"vr": "TM", "Value": ["095427.680000"]}, "1886": {"vr": "TM", "Value": ["095027.611000"]}, "1887": {"vr": "TM", "Value": ["095307.620000"]}, "1888": {"vr": "TM", "Value": ["095427.889000"]}, "1889": {"vr": "TM", "Value": ["095327.684000"]}, "1890": {"vr": "TM", "Value": ["095107.675000"]}, "1891": {"vr": "TM", "Value": ["095047.613000"]}, "1892": {"vr": "TM", "Value": ["095407.654000"]}, "1893": {"vr": "TM", "Value": ["094547.867000"]}, "1894": {"vr": "TM", "Value": ["095407.896000"]}, "1895": {"vr": "TM", "Value": ["095407.658000"]}, "1896": {"vr": "TM", "Value": ["095207.651000"]}, "1897": {"vr": "TM", "Value": ["094807.656000"]}, "1898": {"vr": "TM", "Value": ["095447.791000"]}, "1899": {"vr": "TM", "Value": ["094547.837000"]}, "1900": {"vr": "TM", "Value": ["094707.695000"]}, "1901": {"vr": "TM", "Value": ["095407.850000"]}, "1902": {"vr": "TM", "Value": ["094907.609000"]}, "1903": {"vr": "TM", "Value": ["094747.882000"]}, "1904": {"vr": "TM", "Value": ["094927.620000"]}, "1905": {"vr": "TM", "Value": ["095247.649000"]}, "1906": {"vr": "TM", "Value": ["094847.709000"]}, "1907": {"vr": "TM", "Value": ["094907.611000"]}, "1908": {"vr": "TM", "Value": ["094907.949000"]}, "1909": {"vr": "TM", "Value": ["095327.770000"]}, "1910": {"vr": "TM", "Value": ["094747.801000"]}, "1911": {"vr": "TM", "Value": ["094607.848000"]}, "1912": {"vr": "TM", "Value": ["094627.876000"]}, "1913": {"vr": "TM", "Value": ["095247.846000"]}, "1914": {"vr": "TM", "Value": ["095327.760000"]}, "1915": {"vr": "TM", "Value": ["094527.761000"]}, "1916": {"vr": "TM", "Value": ["095007.894000"]}, "1917": {"vr": "TM", "Value": ["095247.611000"]}, "1918": {"vr": "TM", "Value": ["095007.868000"]}, "1919": {"vr": "TM", "Value": ["095447.879000"]}, "1920": {"vr": "TM", "Value": ["094827.919000"]}, "1921": {"vr": "TM", "Value": ["094847.955000"]}, "1922": {"vr": "TM", "Value": ["094927.763000"]}, "1923": {"vr": "TM", "Value": ["094927.671000"]}, "1924": {"vr": "TM", "Value": ["094547.916000"]}, "1925": {"vr": "TM", "Value": ["094807.819000"]}, "1926": {"vr": "TM", "Value": ["095327.635000"]}, "1927": {"vr": "TM", "Value": ["094927.778000"]}, "1928": {"vr": "TM", "Value": ["094807.783000"]}, "1929": {"vr": "TM", "Value": ["094947.836000"]}, "1930": {"vr": "TM", "Value": ["095227.799000"]}, "1931": {"vr": "TM", "Value": ["094907.926000"]}, "1932": {"vr": "TM", "Value": ["095347.633000"]}, "1933": {"vr": "TM", "Value": ["095147.830000"]}, "1934": {"vr": "TM", "Value": ["094627.617000"]}, "1935": {"vr": "TM", "Value": ["095347.756000"]}, "1936": {"vr": "TM", "Value": ["094647.902000"]}, "1937": {"vr": "TM", "Value": ["095227.768000"]}, "1938": {"vr": "TM", "Value": ["095347.879000"]}, "1939": {"vr": "TM", "Value": ["094947.682000"]}, "1940": {"vr": "TM", "Value": ["094827.678000"]}, "1941": {"vr": "TM", "Value": ["094847.677000"]}, "1942": {"vr": "TM", "Value": ["095127.723000"]}, "1943": {"vr": "TM", "Value": ["094627.803000"]}, "1944": {"vr": "TM", "Value": ["095127.732000"]}, "1945": {"vr": "TM", "Value": ["095207.616000"]}, "1946": {"vr": "TM", "Value": ["094907.614000"]}, "1947": {"vr": "TM", "Value": ["094907.708000"]}, "1948": {"vr": "TM", "Value": ["095347.761000"]}, "1949": {"vr": "TM", "Value": ["094707.647000"]}, "1950": {"vr": "TM", "Value": ["095227.796000"]}, "1951": {"vr": "TM", "Value": ["095107.608000"]}, "1952": {"vr": "TM", "Value": ["095127.760000"]}, "1953": {"vr": "TM", "Value": ["094947.799000"]}, "1954": {"vr": "TM", "Value": ["094607.631000"]}, "1955": {"vr": "TM", "Value": ["094727.696000"]}, "1956": {"vr": "TM", "Value": ["095247.789000"]}, "1957": {"vr": "TM", "Value": ["095027.780000"]}, "1958": {"vr": "TM", "Value": ["095127.751000"]}, "1959": {"vr": "TM", "Value": ["094947.701000"]}, "1960": {"vr": "TM", "Value": ["094827.673000"]}, "1961": {"vr": "TM", "Value": ["094527.652000"]}, "1962": {"vr": "TM", "Value": ["095207.775000"]}, "1963": {"vr": "TM", "Value": ["095127.875000"]}, "1964": {"vr": "TM", "Value": ["095007.728000"]}, "1965": {"vr": "TM", "Value": ["094907.696000"]}, "1966": {"vr": "TM", "Value": ["095227.673000"]}, "1967": {"vr": "TM", "Value": ["095456.485000"]}, "1968": {"vr": "TM", "Value": ["095147.647000"]}, "1969": {"vr": "TM", "Value": ["095447.709000"]}, "1970": {"vr": "TM", "Value": ["094807.621000"]}, "1971": {"vr": "TM", "Value": ["094847.911000"]}, "1972": {"vr": "TM", "Value": ["095027.687000"]}, "1973": {"vr": "TM", "Value": ["095456.420000"]}, "1974": {"vr": "TM", "Value": ["094807.870000"]}, "1975": {"vr": "TM", "Value": ["095307.786000"]}, "1976": {"vr": "TM", "Value": ["094607.616000"]}, "1977": {"vr": "TM", "Value": ["095027.695000"]}, "1978": {"vr": "TM", "Value": ["094647.854000"]}, "1979": {"vr": "TM", "Value": ["095227.645000"]}, "1980": {"vr": "TM", "Value": ["094847.795000"]}, "1981": {"vr": "TM", "Value": ["095107.793000"]}, "1982": {"vr": "TM", "Value": ["095247.717000"]}, "1983": {"vr": "TM", "Value": ["095027.641000"]}, "1984": {"vr": "TM", "Value": ["094627.901000"]}, "1985": {"vr": "TM", "Value": ["095027.634000"]}, "1986": {"vr": "TM", "Value": ["095327.806000"]}, "1987": {"vr": "TM", "Value": ["095427.954000"]}, "1988": {"vr": "TM", "Value": ["094547.724000"]}, "1989": {"vr": "TM", "Value": ["095027.657000"]}, "1990": {"vr": "TM", "Value": ["095227.758000"]}, "1991": {"vr": "TM", "Value": ["094927.835000"]}, "1992": {"vr": "TM", "Value": ["094747.922000"]}, "1993": {"vr": "TM", "Value": ["095007.887000"]}, "1994": {"vr": "TM", "Value": ["095407.639000"]}, "1995": {"vr": "TM", "Value": ["095427.645000"]}, "1996": {"vr": "TM", "Value": ["095007.800000"]}, "1997": {"vr": "TM", "Value": ["094607.718000"]}, "1998": {"vr": "TM", "Value": ["095127.613000"]}, "1999": {"vr": "TM", "Value": ["095147.627000"]}, "2000": {"vr": "TM", "Value": ["095247.907000"]}, "2001": {"vr": "TM", "Value": ["095456.471000"]}, "2002": {"vr": "TM", "Value": ["095227.920000"]}, "2003": {"vr": "TM", "Value": ["094547.736000"]}, "2004": {"vr": "TM", "Value": ["095207.636000"]}, "2005": {"vr": "TM", "Value": ["094647.787000"]}, "2006": {"vr": "TM", "Value": ["094947.883000"]}, "2007": {"vr": "TM", "Value": ["094607.882000"]}, "2008": {"vr": "TM", "Value": ["094707.823000"]}, "2009": {"vr": "TM", "Value": ["095447.845000"]}, "2010": {"vr": "TM", "Value": ["094627.972000"]}, "2011": {"vr": "TM", "Value": ["095347.918000"]}, "2012": {"vr": "TM", "Value": ["094527.641000"]}, "2013": {"vr": "TM", "Value": ["095307.843000"]}, "2014": {"vr": "TM", "Value": ["094907.798000"]}, "2015": {"vr": "TM", "Value": ["095247.748000"]}, "2016": {"vr": "TM", "Value": ["095027.675000"]}, "2017": {"vr": "TM", "Value": ["095007.778000"]}, "2018": {"vr": "TM", "Value": ["095347.725000"]}, "2019": {"vr": "TM", "Value": ["095007.713000"]}, "2020": {"vr": "TM", "Value": ["095447.781000"]}, "2021": {"vr": "TM", "Value": ["094847.737000"]}, "2022": {"vr": "TM", "Value": ["095107.887000"]}, "2023": {"vr": "TM", "Value": ["094827.755000"]}, "2024": {"vr": "TM", "Value": ["095427.656000"]}, "2025": {"vr": "TM", "Value": ["094707.675000"]}, "2026": {"vr": "TM", "Value": ["095407.822000"]}, "2027": {"vr": "TM", "Value": ["094807.765000"]}, "2028": {"vr": "TM", "Value": ["095127.937000"]}, "2029": {"vr": "TM", "Value": ["094707.666000"]}, "2030": {"vr": "TM", "Value": ["095447.827000"]}, "2031": {"vr": "TM", "Value": ["095027.806000"]}, "2032": {"vr": "TM", "Value": ["094647.683000"]}, "2033": {"vr": "TM", "Value": ["095447.620000"]}, "2034": {"vr": "TM", "Value": ["095047.897000"]}, "2035": {"vr": "TM", "Value": ["095027.618000"]}, "2036": {"vr": "TM", "Value": ["094827.639000"]}, "2037": {"vr": "TM", "Value": ["094747.756000"]}, "2038": {"vr": "TM", "Value": ["095247.808000"]}, "2039": {"vr": "TM", "Value": ["095007.740000"]}, "2040": {"vr": "TM", "Value": ["094627.815000"]}, "2041": {"vr": "TM", "Value": ["095127.646000"]}, "2042": {"vr": "TM", "Value": ["094627.855000"]}, "2043": {"vr": "TM", "Value": ["095307.740000"]}, "2044": {"vr": "TM", "Value": ["094907.887000"]}, "2045": {"vr": "TM", "Value": ["095107.752000"]}, "2046": {"vr": "TM", "Value": ["094747.959000"]}, "2047": {"vr": "TM", "Value": ["095447.732000"]}, "2048": {"vr": "TM", "Value": ["094827.818000"]}, "2049": {"vr": "TM", "Value": ["095027.677000"]}, "2050": {"vr": "TM", "Value": ["094547.903000"]}, "2051": {"vr": "TM", "Value": ["094927.654000"]}, "2052": {"vr": "TM", "Value": ["094627.692000"]}, "2053": {"vr": "TM", "Value": ["095227.663000"]}, "2054": {"vr": "TM", "Value": ["094947.893000"]}, "2055": {"vr": "TM", "Value": ["094847.832000"]}, "2056": {"vr": "TM", "Value": ["095127.753000"]}, "2057": {"vr": "TM", "Value": ["095427.676000"]}, "2058": {"vr": "TM", "Value": ["095447.933000"]}, "2059": {"vr": "TM", "Value": ["095347.869000"]}, "2060": {"vr": "TM", "Value": ["094707.725000"]}, "2061": {"vr": "TM", "Value": ["095047.803000"]}, "2062": {"vr": "TM", "Value": ["094747.798000"]}, "2063": {"vr": "TM", "Value": ["095107.677000"]}, "2064": {"vr": "TM", "Value": ["095327.687000"]}, "2065": {"vr": "TM", "Value": ["095407.922000"]}, "2066": {"vr": "TM", "Value": ["095047.718000"]}, "2067": {"vr": "TM", "Value": ["094847.923000"]}, "2068": {"vr": "TM", "Value": ["094847.914000"]}, "2069": {"vr": "TM", "Value": ["095407.628000"]}, "2070": {"vr": "TM", "Value": ["095107.627000"]}, "2071": {"vr": "TM", "Value": ["095227.913000"]}, "2072": {"vr": "TM", "Value": ["095007.944000"]}, "2073": {"vr": "TM", "Value": ["095127.845000"]}, "2074": {"vr": "TM", "Value": ["094747.720000"]}, "2075": {"vr": "TM", "Value": ["094827.877000"]}, "2076": {"vr": "TM", "Value": ["095127.668000"]}, "2077": {"vr": "TM", "Value": ["095307.943000"]}, "2078": {"vr": "TM", "Value": ["094807.631000"]}, "2079": {"vr": "TM", "Value": ["094827.944000"]}, "2080": {"vr": "TM", "Value": ["094827.683000"]}, "2081": {"vr": "TM", "Value": ["095407.697000"]}, "2082": {"vr": "TM", "Value": ["094827.931000"]}, "2083": {"vr": "TM", "Value": ["095007.803000"]}, "2084": {"vr": "TM", "Value": ["095007.819000"]}, "2085": {"vr": "TM", "Value": ["094727.903000"]}, "2086": {"vr": "TM", "Value": ["095327.723000"]}, "2087": {"vr": "TM", "Value": ["095427.638000"]}, "2088": {"vr": "TM", "Value": ["095207.706000"]}, "2089": {"vr": "TM", "Value": ["094807.626000"]}, "2090": {"vr": "TM", "Value": ["095027.636000"]}, "2091": {"vr": "TM", "Value": ["095047.905000"]}, "2092": {"vr": "TM", "Value": ["095147.925000"]}, "2093": {"vr": "TM", "Value": ["095447.863000"]}, "2094": {"vr": "TM", "Value": ["095447.716000"]}, "2095": {"vr": "TM", "Value": ["094907.720000"]}, "2096": {"vr": "TM", "Value": ["094707.737000"]}, "2097": {"vr": "TM", "Value": ["094707.803000"]}, "2098": {"vr": "TM", "Value": ["094527.638000"]}, "2099": {"vr": "TM", "Value": ["095307.691000"]}, "2100": {"vr": "TM", "Value": ["095127.746000"]}, "2101": {"vr": "TM", "Value": ["095307.637000"]}, "2102": {"vr": "TM", "Value": ["094947.619000"]}, "2103": {"vr": "TM", "Value": ["094527.830000"]}, "2104": {"vr": "TM", "Value": ["095247.886000"]}, "2105": {"vr": "TM", "Value": ["094607.624000"]}, "2106": {"vr": "TM", "Value": ["094747.687000"]}, "2107": {"vr": "TM", "Value": ["095107.847000"]}, "2108": {"vr": "TM", "Value": ["094627.870000"]}, "2109": {"vr": "TM", "Value": ["095327.668000"]}, "2110": {"vr": "TM", "Value": ["095407.715000"]}, "2111": {"vr": "TM", "Value": ["094707.730000"]}, "2112": {"vr": "TM", "Value": ["094807.718000"]}, "2113": {"vr": "TM", "Value": ["095027.859000"]}, "2114": {"vr": "TM", "Value": ["095327.878000"]}, "2115": {"vr": "TM", "Value": ["094547.923000"]}, "2116": {"vr": "TM", "Value": ["095027.744000"]}, "2117": {"vr": "TM", "Value": ["094827.665000"]}, "2118": {"vr": "TM", "Value": ["094727.773000"]}, "2119": {"vr": "TM", "Value": ["095047.856000"]}, "2120": {"vr": "TM", "Value": ["095447.876000"]}, "2121": {"vr": "TM", "Value": ["094647.790000"]}, "2122": {"vr": "TM", "Value": ["094527.839000"]}, "2123": {"vr": "TM", "Value": ["094647.722000"]}, "2124": {"vr": "TM", "Value": ["094547.944000"]}, "2125": {"vr": "TM", "Value": ["094827.649000"]}, "2126": {"vr": "TM", "Value": ["094547.819000"]}, "2127": {"vr": "TM", "Value": ["094927.729000"]}, "2128": {"vr": "TM", "Value": ["095107.703000"]}, "2129": {"vr": "TM", "Value": ["095407.758000"]}, "2130": {"vr": "TM", "Value": ["094927.724000"]}, "2131": {"vr": "TM", "Value": ["095427.729000"]}, "2132": {"vr": "TM", "Value": ["095147.828000"]}, "2133": {"vr": "TM", "Value": ["094627.612000"]}, "2134": {"vr": "TM", "Value": ["094707.719000"]}, "2135": {"vr": "TM", "Value": ["094727.898000"]}, "2136": {"vr": "TM", "Value": ["094647.804000"]}, "2137": {"vr": "TM", "Value": ["094847.646000"]}, "2138": {"vr": "TM", "Value": ["094907.941000"]}, "2139": {"vr": "TM", "Value": ["095027.644000"]}, "2140": {"vr": "TM", "Value": ["095007.929000"]}, "2141": {"vr": "TM", "Value": ["095127.656000"]}, "2142": {"vr": "TM", "Value": ["094947.789000"]}, "2143": {"vr": "TM", "Value": ["095447.775000"]}, "2144": {"vr": "TM", "Value": ["095107.744000"]}, "2145": {"vr": "TM", "Value": ["094747.905000"]}, "2146": {"vr": "TM", "Value": ["095456.459000"]}, "2147": {"vr": "TM", "Value": ["094647.647000"]}, "2148": {"vr": "TM", "Value": ["094647.665000"]}, "2149": {"vr": "TM", "Value": ["095427.661000"]}, "2150": {"vr": "TM", "Value": ["095427.814000"]}, "2151": {"vr": "TM", "Value": ["095027.811000"]}, "2152": {"vr": "TM", "Value": ["094607.791000"]}, "2153": {"vr": "TM", "Value": ["094727.952000"]}, "2154": {"vr": "TM", "Value": ["095147.687000"]}, "2155": {"vr": "TM", "Value": ["095107.668000"]}, "2156": {"vr": "TM", "Value": ["095207.782000"]}, "2157": {"vr": "TM", "Value": ["095007.649000"]}, "2158": {"vr": "TM", "Value": ["095147.760000"]}, "2159": {"vr": "TM", "Value": ["095007.718000"]}, "2160": {"vr": "TM", "Value": ["095007.613000"]}, "2161": {"vr": "TM", "Value": ["094707.955000"]}, "2162": {"vr": "TM", "Value": ["094607.712000"]}, "2163": {"vr": "TM", "Value": ["094947.699000"]}, "2164": {"vr": "TM", "Value": ["095107.911000"]}, "2165": {"vr": "TM", "Value": ["094827.844000"]}, "2166": {"vr": "TM", "Value": ["094927.875000"]}, "2167": {"vr": "TM", "Value": ["095127.765000"]}, "2168": {"vr": "TM", "Value": ["095447.649000"]}, "2169": {"vr": "TM", "Value": ["094747.957000"]}, "2170": {"vr": "TM", "Value": ["095007.889000"]}, "2171": {"vr": "TM", "Value": ["095427.817000"]}, "2172": {"vr": "TM", "Value": ["094707.789000"]}, "2173": {"vr": "TM", "Value": ["095247.827000"]}, "2174": {"vr": "TM", "Value": ["095007.916000"]}, "2175": {"vr": "TM", "Value": ["094807.841000"]}, "2176": {"vr": "TM", "Value": ["095107.933000"]}, "2177": {"vr": "TM", "Value": ["095447.921000"]}, "2178": {"vr": "TM", "Value": ["094707.765000"]}, "2179": {"vr": "TM", "Value": ["095127.698000"]}, "2180": {"vr": "TM", "Value": ["094627.848000"]}, "2181": {"vr": "TM", "Value": ["094747.670000"]}, "2182": {"vr": "TM", "Value": ["095147.900000"]}, "2183": {"vr": "TM", "Value": ["095347.649000"]}, "2184": {"vr": "TM", "Value": ["095227.727000"]}, "2185": {"vr": "TM", "Value": ["095007.692000"]}, "2186": {"vr": "TM", "Value": ["095247.801000"]}, "2187": {"vr": "TM", "Value": ["095456.407000"]}, "2188": {"vr": "TM", "Value": ["095127.781000"]}, "2189": {"vr": "TM", "Value": ["094807.674000"]}, "2190": {"vr": "TM", "Value": ["094607.606000"]}, "2191": {"vr": "TM", "Value": ["094647.814000"]}, "2192": {"vr": "TM", "Value": ["094827.851000"]}, "2193": {"vr": "TM", "Value": ["095307.694000"]}, "2194": {"vr": "TM", "Value": ["094547.763000"]}, "2195": {"vr": "TM", "Value": ["094907.850000"]}, "2196": {"vr": "TM", "Value": ["095127.716000"]}, "2197": {"vr": "TM", "Value": ["095007.662000"]}, "2198": {"vr": "TM", "Value": ["095407.646000"]}, "2199": {"vr": "TM", "Value": ["095247.820000"]}, "2200": {"vr": "TM", "Value": ["094707.699000"]}, "2201": {"vr": "TM", "Value": ["094807.720000"]}, "2202": {"vr": "TM", "Value": ["095327.809000"]}, "2203": {"vr": "TM", "Value": ["095207.851000"]}, "2204": {"vr": "TM", "Value": ["095456.464000"]}, "2205": {"vr": "TM", "Value": ["094607.833000"]}, "2206": {"vr": "TM", "Value": ["095127.914000"]}, "2207": {"vr": "TM", "Value": ["095107.765000"]}, "2208": {"vr": "TM", "Value": ["095447.856000"]}, "2209": {"vr": "TM", "Value": ["095307.797000"]}, "2210": {"vr": "TM", "Value": ["094707.940000"]}, "2211": {"vr": "TM", "Value": ["094547.854000"]}, "2212": {"vr": "TM", "Value": ["095227.661000"]}, "2213": {"vr": "TM", "Value": ["095227.622000"]}, "2214": {"vr": "TM", "Value": ["094827.646000"]}, "2215": {"vr": "TM", "Value": ["095327.632000"]}, "2216": {"vr": "TM", "Value": ["095007.949000"]}, "2217": {"vr": "TM", "Value": ["095207.724000"]}, "2218": {"vr": "TM", "Value": ["094907.944000"]}, "2219": {"vr": "TM", "Value": ["094727.718000"]}, "2220": {"vr": "TM", "Value": ["094527.719000"]}, "2221": {"vr": "TM", "Value": ["094647.811000"]}, "2222": {"vr": "TM", "Value": ["095307.728000"]}, "2223": {"vr": "TM", "Value": ["095047.843000"]}, "2224": {"vr": "TM", "Value": ["094607.948000"]}, "2225": {"vr": "TM", "Value": ["095107.646000"]}, "2226": {"vr": "TM", "Value": ["094847.730000"]}, "2227": {"vr": "TM", "Value": ["095407.855000"]}, "2228": {"vr": "TM", "Value": ["094547.829000"]}, "2229": {"vr": "TM", "Value": ["095427.687000"]}, "2230": {"vr": "TM", "Value": ["095207.674000"]}, "2231": {"vr": "TM", "Value": ["095247.666000"]}, "2232": {"vr": "TM", "Value": ["095127.651000"]}, "2233": {"vr": "TM", "Value": ["095447.923000"]}, "2234": {"vr": "TM", "Value": ["095027.939000"]}, "2235": {"vr": "TM", "Value": ["095207.864000"]}, "2236": {"vr": "TM", "Value": ["095227.851000"]}, "2237": {"vr": "TM", "Value": ["095107.908000"]}, "2238": {"vr": "TM", "Value": ["095227.937000"]}, "2239": {"vr": "TM", "Value": ["094707.642000"]}, "2240": {"vr": "TM", "Value": ["094807.933000"]}, "2241": {"vr": "TM", "Value": ["094647.905000"]}, "2242": {"vr": "TM", "Value": ["095127.711000"]}, "2243": {"vr": "TM", "Value": ["094627.635000"]}, "2244": {"vr": "TM", "Value": ["094547.901000"]}, "2245": {"vr": "TM", "Value": ["094927.814000"]}, "2246": {"vr": "TM", "Value": ["094547.613000"]}, "2247": {"vr": "TM", "Value": ["095107.866000"]}, "2248": {"vr": "TM", "Value": ["094627.674000"]}, "2249": {"vr": "TM", "Value": ["095347.631000"]}, "2250": {"vr": "TM", "Value": ["095307.853000"]}, "2251": {"vr": "TM", "Value": ["094707.897000"]}, "2252": {"vr": "TM", "Value": ["094527.868000"]}, "2253": {"vr": "TM", "Value": ["095347.646000"]}, "2254": {"vr": "TM", "Value": ["095456.536000"]}, "2255": {"vr": "TM", "Value": ["094827.753000"]}, "2256": {"vr": "TM", "Value": ["095447.809000"]}, "2257": {"vr": "TM", "Value": ["095207.818000"]}, "2258": {"vr": "TM", "Value": ["094647.609000"]}, "2259": {"vr": "TM", "Value": ["094647.967000"]}, "2260": {"vr": "TM", "Value": ["095027.736000"]}, "2261": {"vr": "TM", "Value": ["094747.962000"]}, "2262": {"vr": "TM", "Value": ["095447.714000"]}, "2263": {"vr": "TM", "Value": ["095327.743000"]}, "2264": {"vr": "TM", "Value": ["095207.734000"]}, "2265": {"vr": "TM", "Value": ["094947.780000"]}, "2266": {"vr": "TM", "Value": ["095147.665000"]}, "2267": {"vr": "TM", "Value": ["095427.763000"]}, "2268": {"vr": "TM", "Value": ["095107.935000"]}, "2269": {"vr": "TM", "Value": ["094627.957000"]}, "2270": {"vr": "TM", "Value": ["095207.737000"]}, "2271": {"vr": "TM", "Value": ["094827.719000"]}, "2272": {"vr": "TM", "Value": ["095427.753000"]}, "2273": {"vr": "TM", "Value": ["094907.808000"]}, "2274": {"vr": "TM", "Value": ["095327.625000"]}, "2275": {"vr": "TM", "Value": ["095047.669000"]}, "2276": {"vr": "TM", "Value": ["095107.873000"]}, "2277": {"vr": "TM", "Value": ["095027.798000"]}, "2278": {"vr": "TM", "Value": ["095327.745000"]}, "2279": {"vr": "TM", "Value": ["095447.667000"]}, "2280": {"vr": "TM", "Value": ["094647.806000"]}, "2281": {"vr": "TM", "Value": ["095227.861000"]}, "2282": {"vr": "TM", "Value": ["094747.712000"]}, "2283": {"vr": "TM", "Value": ["094747.908000"]}, "2284": {"vr": "TM", "Value": ["095007.708000"]}, "2285": {"vr": "TM", "Value": ["095307.720000"]}, "2286": {"vr": "TM", "Value": ["095347.807000"]}, "2287": {"vr": "TM", "Value": ["094527.694000"]}, "2288": {"vr": "TM", "Value": ["095447.868000"]}, "2289": {"vr": "TM", "Value": ["094547.649000"]}, "2290": {"vr": "TM", "Value": ["094707.894000"]}, "2291": {"vr": "TM", "Value": ["095147.816000"]}, "2292": {"vr": "TM", "Value": ["095407.618000"]}, "2293": {"vr": "TM", "Value": ["094727.766000"]}, "2294": {"vr": "TM", "Value": ["095027.769000"]}, "2295": {"vr": "TM", "Value": ["095007.846000"]}, "2296": {"vr": "TM", "Value": ["095147.729000"]}, "2297": {"vr": "TM", "Value": ["095407.684000"]}, "2298": {"vr": "TM", "Value": ["095147.639000"]}, "2299": {"vr": "TM", "Value": ["095427.923000"]}, "2300": {"vr": "TM", "Value": ["095307.658000"]}, "2301": {"vr": "TM", "Value": ["095127.850000"]}, "2302": {"vr": "TM", "Value": ["094727.781000"]}, "2303": {"vr": "TM", "Value": ["095147.915000"]}, "2304": {"vr": "TM", "Value": ["095047.734000"]}, "2305": {"vr": "TM", "Value": ["094527.854000"]}, "2306": {"vr": "TM", "Value": ["094547.707000"]}, "2307": {"vr": "TM", "Value": ["095227.620000"]}, "2308": {"vr": "TM", "Value": ["095227.854000"]}, "2309": {"vr": "TM", "Value": ["094927.926000"]}, "2310": {"vr": "TM", "Value": ["094907.656000"]}, "2311": {"vr": "TM", "Value": ["095207.889000"]}, "2312": {"vr": "TM", "Value": ["095347.613000"]}, "2313": {"vr": "TM", "Value": ["094527.630000"]}, "2314": {"vr": "TM", "Value": ["094927.781000"]}, "2315": {"vr": "TM", "Value": ["095447.884000"]}, "2316": {"vr": "TM", "Value": ["094547.669000"]}, "2317": {"vr": "TM", "Value": ["095227.827000"]}, "2318": {"vr": "TM", "Value": ["095147.950000"]}, "2319": {"vr": "TM", "Value": ["094747.903000"]}, "2320": {"vr": "TM", "Value": ["094947.655000"]}, "2321": {"vr": "TM", "Value": ["094807.733000"]}, "2322": {"vr": "TM", "Value": ["094607.608000"]}, "2323": {"vr": "TM", "Value": ["095347.825000"]}, "2324": {"vr": "TM", "Value": ["095207.739000"]}, "2325": {"vr": "TM", "Value": ["095427.863000"]}, "2326": {"vr": "TM", "Value": ["094747.913000"]}, "2327": {"vr": "TM", "Value": ["094927.941000"]}, "2328": {"vr": "TM", "Value": ["094807.936000"]}, "2329": {"vr": "TM", "Value": ["094927.630000"]}, "2330": {"vr": "TM", "Value": ["095227.809000"]}, "2331": {"vr": "TM", "Value": ["094727.693000"]}, "2332": {"vr": "TM", "Value": ["095207.742000"]}, "2333": {"vr": "TM", "Value": ["095127.730000"]}, "2334": {"vr": "TM", "Value": ["095027.772000"]}, "2335": {"vr": "TM", "Value": ["094847.785000"]}, "2336": {"vr": "TM", "Value": ["094607.673000"]}, "2337": {"vr": "TM", "Value": ["095147.700000"]}, "2338": {"vr": "TM", "Value": ["094627.682000"]}, "2339": {"vr": "TM", "Value": ["094807.738000"]}, "2340": {"vr": "TM", "Value": ["095327.762000"]}, "2341": {"vr": "TM", "Value": ["095047.943000"]}, "2342": {"vr": "TM", "Value": ["095327.920000"]}, "2343": {"vr": "TM", "Value": ["094907.772000"]}, "2344": {"vr": "TM", "Value": ["094847.745000"]}, "2345": {"vr": "TM", "Value": ["094927.659000"]}, "2346": {"vr": "TM", "Value": ["095327.753000"]}, "2347": {"vr": "TM", "Value": ["094707.817000"]}, "2348": {"vr": "TM", "Value": ["095107.800000"]}, "2349": {"vr": "TM", "Value": ["094727.893000"]}, "2350": {"vr": "TM", "Value": ["094607.859000"]}, "2351": {"vr": "TM", "Value": ["095207.626000"]}, "2352": {"vr": "TM", "Value": ["094827.644000"]}, "2353": {"vr": "TM", "Value": ["095347.876000"]}, "2354": {"vr": "TM", "Value": ["094627.843000"]}, "2355": {"vr": "TM", "Value": ["094527.922000"]}, "2356": {"vr": "TM", "Value": ["094847.727000"]}, "2357": {"vr": "TM", "Value": ["095447.630000"]}, "2358": {"vr": "TM", "Value": ["094827.781000"]}, "2359": {"vr": "TM", "Value": ["095327.733000"]}, "2360": {"vr": "TM", "Value": ["094647.987000"]}, "2361": {"vr": "TM", "Value": ["095447.829000"]}, "2362": {"vr": "TM", "Value": ["095307.679000"]}, "2363": {"vr": "TM", "Value": ["095447.698000"]}, "2364": {"vr": "TM", "Value": ["095407.799000"]}, "2365": {"vr": "TM", "Value": ["094607.778000"]}, "2366": {"vr": "TM", "Value": ["094847.753000"]}, "2367": {"vr": "TM", "Value": ["095047.910000"]}, "2368": {"vr": "TM", "Value": ["095247.858000"]}, "2369": {"vr": "TM", "Value": ["094527.673000"]}, "2370": {"vr": "TM", "Value": ["094607.634000"]}, "2371": {"vr": "TM", "Value": ["095107.615000"]}, "2372": {"vr": "TM", "Value": ["094827.834000"]}, "2373": {"vr": "TM", "Value": ["094627.828000"]}, "2374": {"vr": "TM", "Value": ["094607.725000"]}, "2375": {"vr": "TM", "Value": ["095007.626000"]}, "2376": {"vr": "TM", "Value": ["094707.639000"]}, "2377": {"vr": "TM", "Value": ["094547.817000"]}, "2378": {"vr": "TM", "Value": ["095307.933000"]}, "2379": {"vr": "TM", "Value": ["094627.736000"]}, "2380": {"vr": "TM", "Value": ["095347.623000"]}, "2381": {"vr": "TM", "Value": ["095147.835000"]}, "2382": {"vr": "TM", "Value": ["095147.808000"]}, "2383": {"vr": "TM", "Value": ["094907.911000"]}, "2384": {"vr": "TM", "Value": ["094947.822000"]}, "2385": {"vr": "TM", "Value": ["095007.865000"]}, "2386": {"vr": "TM", "Value": ["095347.771000"]}, "2387": {"vr": "TM", "Value": ["094747.723000"]}, "2388": {"vr": "TM", "Value": ["095427.840000"]}, "2389": {"vr": "TM", "Value": ["094607.720000"]}, "2390": {"vr": "TM", "Value": ["095447.897000"]}, "2391": {"vr": "TM", "Value": ["094747.930000"]}, "2392": {"vr": "TM", "Value": ["094747.754000"]}, "2393": {"vr": "TM", "Value": ["094547.883000"]}, "2394": {"vr": "TM", "Value": ["095147.739000"]}, "2395": {"vr": "TM", "Value": ["095347.848000"]}, "2396": {"vr": "TM", "Value": ["094907.753000"]}, "2397": {"vr": "TM", "Value": ["095347.759000"]}, "2398": {"vr": "TM", "Value": ["095307.835000"]}, "2399": {"vr": "TM", "Value": ["095407.835000"]}, "2400": {"vr": "TM", "Value": ["095327.675000"]}, "2401": {"vr": "TM", "Value": ["094847.865000"]}, "2402": {"vr": "TM", "Value": ["095327.928000"]}, "2403": {"vr": "TM", "Value": ["095227.752000"]}, "2404": {"vr": "TM", "Value": ["095147.903000"]}, "2405": {"vr": "TM", "Value": ["095207.803000"]}, "2406": {"vr": "TM", "Value": ["094647.638000"]}, "2407": {"vr": "TM", "Value": ["094807.907000"]}, "2408": {"vr": "TM", "Value": ["094547.906000"]}, "2409": {"vr": "TM", "Value": ["094847.953000"]}, "2410": {"vr": "TM", "Value": ["095447.755000"]}, "2411": {"vr": "TM", "Value": ["095127.720000"]}, "2412": {"vr": "TM", "Value": ["095147.953000"]}, "2413": {"vr": "TM", "Value": ["095307.653000"]}, "2414": {"vr": "TM", "Value": ["095047.785000"]}, "2415": {"vr": "TM", "Value": ["094627.619000"]}, "2416": {"vr": "TM", "Value": ["094627.924000"]}, "2417": {"vr": "TM", "Value": ["095456.524000"]}, "2418": {"vr": "TM", "Value": ["095147.724000"]}, "2419": {"vr": "TM", "Value": ["094807.715000"]}, "2420": {"vr": "TM", "Value": ["095227.643000"]}, "2421": {"vr": "TM", "Value": ["095207.777000"]}, "2422": {"vr": "TM", "Value": ["095227.889000"]}, "2423": {"vr": "TM", "Value": ["094547.694000"]}, "2424": {"vr": "TM", "Value": ["094627.776000"]}, "2425": {"vr": "TM", "Value": ["095127.625000"]}, "2426": {"vr": "TM", "Value": ["094547.749000"]}, "2427": {"vr": "TM", "Value": ["094747.866000"]}, "2428": {"vr": "TM", "Value": ["095107.731000"]}, "2429": {"vr": "TM", "Value": ["094927.906000"]}, "2430": {"vr": "TM", "Value": ["094927.681000"]}, "2431": {"vr": "TM", "Value": ["094547.786000"]}, "2432": {"vr": "TM", "Value": ["094547.839000"]}, "2433": {"vr": "TM", "Value": ["094827.882000"]}, "2434": {"vr": "TM", "Value": ["094807.945000"]}, "2435": {"vr": "TM", "Value": ["095407.875000"]}, "2436": {"vr": "TM", "Value": ["094707.797000"]}, "2437": {"vr": "TM", "Value": ["095147.677000"]}, "2438": {"vr": "TM", "Value": ["094627.716000"]}, "2439": {"vr": "TM", "Value": ["095127.860000"]}, "2440": {"vr": "TM", "Value": ["095107.762000"]}, "2441": {"vr": "TM", "Value": ["095347.741000"]}, "2442": {"vr": "TM", "Value": ["095207.828000"]}, "2443": {"vr": "TM", "Value": ["095247.839000"]}, "2444": {"vr": "TM", "Value": ["095107.884000"]}, "2445": {"vr": "TM", "Value": ["095207.805000"]}, "2446": {"vr": "TM", "Value": ["094627.969000"]}, "2447": {"vr": "TM", "Value": ["094927.946000"]}, "2448": {"vr": "TM", "Value": ["095347.871000"]}, "2449": {"vr": "TM", "Value": ["094547.842000"]}, "2450": {"vr": "TM", "Value": ["095227.668000"]}, "2451": {"vr": "TM", "Value": ["095027.918000"]}, "2452": {"vr": "TM", "Value": ["094607.846000"]}, "2453": {"vr": "TM", "Value": ["094927.809000"]}, "2454": {"vr": "TM", "Value": ["095427.878000"]}, "2455": {"vr": "TM", "Value": ["094747.845000"]}, "2456": {"vr": "TM", "Value": ["095027.793000"]}, "2457": {"vr": "TM", "Value": ["095027.698000"]}, "2458": {"vr": "TM", "Value": ["095027.832000"]}, "2459": {"vr": "TM", "Value": ["095427.936000"]}, "2460": {"vr": "TM", "Value": ["094847.674000"]}, "2461": {"vr": "TM", "Value": ["094807.735000"]}, "2462": {"vr": "TM", "Value": ["095247.647000"]}, "2463": {"vr": "TM", "Value": ["095407.761000"]}, "2464": {"vr": "TM", "Value": ["095307.807000"]}, "2465": {"vr": "TM", "Value": ["095147.880000"]}, "2466": {"vr": "TM", "Value": ["094927.697000"]}, "2467": {"vr": "TM", "Value": ["095027.913000"]}, "2468": {"vr": "TM", "Value": ["095307.879000"]}, "2469": {"vr": "TM", "Value": ["094947.858000"]}, "2470": {"vr": "TM", "Value": ["094707.775000"]}, "2471": {"vr": "TM", "Value": ["095147.615000"]}, "2472": {"vr": "TM", "Value": ["094947.844000"]}, "2473": {"vr": "TM", "Value": ["094807.962000"]}, "2474": {"vr": "TM", "Value": ["094527.936000"]}, "2475": {"vr": "TM", "Value": ["095147.642000"]}, "2476": {"vr": "TM", "Value": ["095127.725000"]}, "2477": {"vr": "TM", "Value": ["095447.618000"]}, "2478": {"vr": "TM", "Value": ["094627.909000"]}, "2479": {"vr": "TM", "Value": ["094647.940000"]}, "2480": {"vr": "TM", "Value": ["095327.728000"]}, "2481": {"vr": "TM", "Value": ["095347.751000"]}, "2482": {"vr": "TM", "Value": ["094847.875000"]}, "2483": {"vr": "TM", "Value": ["095327.935000"]}, "2484": {"vr": "TM", "Value": ["094627.687000"]}, "2485": {"vr": "TM", "Value": ["094827.620000"]}, "2486": {"vr": "TM", "Value": ["094807.941000"]}, "2487": {"vr": "TM", "Value": ["095327.659000"]}, "2488": {"vr": "TM", "Value": ["095447.639000"]}, "2489": {"vr": "TM", "Value": ["095427.794000"]}, "2490": {"vr": "TM", "Value": ["095207.946000"]}, "2491": {"vr": "TM", "Value": ["094627.933000"]}, "2492": {"vr": "TM", "Value": ["095027.849000"]}, "2493": {"vr": "TM", "Value": ["095107.835000"]}, "2494": {"vr": "TM", "Value": ["095427.832000"]}, "2495": {"vr": "TM", "Value": ["094827.737000"]}, "2496": {"vr": "TM", "Value": ["094707.874000"]}, "2497": {"vr": "TM", "Value": ["095327.925000"]}, "2498": {"vr": "TM", "Value": ["095207.634000"]}, "2499": {"vr": "TM", "Value": ["094847.903000"]}, "2500": {"vr": "TM", "Value": ["095347.915000"]}, "2501": {"vr": "TM", "Value": ["094947.737000"]}, "2502": {"vr": "TM", "Value": ["094607.913000"]}, "2503": {"vr": "TM", "Value": ["095327.639000"]}, "2504": {"vr": "TM", "Value": ["094727.680000"]}, "2505": {"vr": "TM", "Value": ["095147.930000"]}, "2506": {"vr": "TM", "Value": ["094907.671000"]}, "2507": {"vr": "TM", "Value": ["095147.607000"]}, "2508": {"vr": "TM", "Value": ["095107.777000"]}, "2509": {"vr": "TM", "Value": ["094727.947000"]}, "2510": {"vr": "TM", "Value": ["095227.789000"]}, "2511": {"vr": "TM", "Value": ["094907.777000"]}, "2512": {"vr": "TM", "Value": ["095107.694000"]}, "2513": {"vr": "TM", "Value": ["095427.722000"]}, "2514": {"vr": "TM", "Value": ["094827.691000"]}, "2515": {"vr": "TM", "Value": ["094607.802000"]}, "2516": {"vr": "TM", "Value": ["094607.691000"]}, "2517": {"vr": "TM", "Value": ["095347.941000"]}, "2518": {"vr": "TM", "Value": ["094927.888000"]}, "2519": {"vr": "TM", "Value": ["094847.808000"]}, "2520": {"vr": "TM", "Value": ["095147.792000"]}, "2521": {"vr": "TM", "Value": ["095327.642000"]}, "2522": {"vr": "TM", "Value": ["095456.435000"]}, "2523": {"vr": "TM", "Value": ["094627.642000"]}, "2524": {"vr": "TM", "Value": ["095047.651000"]}, "2525": {"vr": "TM", "Value": ["095456.505000"]}, "2526": {"vr": "TM", "Value": ["094807.910000"]}, "2527": {"vr": "TM", "Value": ["094807.888000"]}, "2528": {"vr": "TM", "Value": ["095347.610000"]}, "2529": {"vr": "TM", "Value": ["094847.758000"]}, "2530": {"vr": "TM", "Value": ["095307.696000"]}, "2531": {"vr": "TM", "Value": ["095247.658000"]}, "2532": {"vr": "TM", "Value": ["095107.686000"]}, "2533": {"vr": "TM", "Value": ["094547.926000"]}, "2534": {"vr": "TM", "Value": ["095147.857000"]}, "2535": {"vr": "TM", "Value": ["095107.845000"]}, "2536": {"vr": "TM", "Value": ["094927.848000"]}, "2537": {"vr": "TM", "Value": ["095007.911000"]}, "2538": {"vr": "TM", "Value": ["095207.681000"]}, "2539": {"vr": "TM", "Value": ["095456.417000"]}, "2540": {"vr": "TM", "Value": ["095447.816000"]}, "2541": {"vr": "TM", "Value": ["095027.808000"]}, "2542": {"vr": "TM", "Value": ["094827.779000"]}, "2543": {"vr": "TM", "Value": ["095247.675000"]}, "2544": {"vr": "TM", "Value": ["094647.719000"]}, "2545": {"vr": "TM", "Value": ["095107.739000"]}, "2546": {"vr": "TM", "Value": ["095147.748000"]}, "2547": {"vr": "TM", "Value": ["094707.810000"]}, "2548": {"vr": "TM", "Value": ["094827.872000"]}, "2549": {"vr": "TM", "Value": ["095027.803000"]}, "2550": {"vr": "TM", "Value": ["095407.909000"]}, "2551": {"vr": "TM", "Value": ["095247.935000"]}, "2552": {"vr": "TM", "Value": ["095447.696000"]}, "2553": {"vr": "TM", "Value": ["094607.951000"]}, "2554": {"vr": "TM", "Value": ["094807.839000"]}, "2555": {"vr": "TM", "Value": ["095127.703000"]}, "2556": {"vr": "TM", "Value": ["095407.649000"]}, "2557": {"vr": "TM", "Value": ["095327.758000"]}, "2558": {"vr": "TM", "Value": ["095047.851000"]}, "2559": {"vr": "TM", "Value": ["095327.886000"]}, "2560": {"vr": "TM", "Value": ["095427.735000"]}, "2561": {"vr": "TM", "Value": ["094927.760000"]}, "2562": {"vr": "TM", "Value": ["095127.767000"]}, "2563": {"vr": "TM", "Value": ["094847.885000"]}, "2564": {"vr": "TM", "Value": ["094747.660000"]}, "2565": {"vr": "TM", "Value": ["095347.738000"]}, "2566": {"vr": "TM", "Value": ["095227.908000"]}, "2567": {"vr": "TM", "Value": ["095147.702000"]}, "2568": {"vr": "TM", "Value": ["095427.855000"]}, "2569": {"vr": "TM", "Value": ["094647.764000"]}, "2570": {"vr": "TM", "Value": ["095427.652000"]}, "2571": {"vr": "TM", "Value": ["094707.627000"]}, "2572": {"vr": "TM", "Value": ["095456.548000"]}, "2573": {"vr": "TM", "Value": ["094547.898000"]}, "2574": {"vr": "TM", "Value": ["095127.774000"]}, "2575": {"vr": "TM", "Value": ["094627.707000"]}, "2576": {"vr": "TM", "Value": ["095247.804000"]}, "2577": {"vr": "TM", "Value": ["094807.938000"]}, "2578": {"vr": "TM", "Value": ["094527.967000"]}, "2579": {"vr": "TM", "Value": ["094527.786000"]}, "2580": {"vr": "TM", "Value": ["095447.930000"]}, "2581": {"vr": "TM", "Value": ["095027.669000"]}, "2582": {"vr": "TM", "Value": ["095027.728000"]}, "2583": {"vr": "TM", "Value": ["094927.661000"]}, "2584": {"vr": "TM", "Value": ["094827.954000"]}, "2585": {"vr": "TM", "Value": ["095327.797000"]}, "2586": {"vr": "TM", "Value": ["095127.900000"]}, "2587": {"vr": "TM", "Value": ["095227.875000"]}, "2588": {"vr": "TM", "Value": ["094527.897000"]}, "2589": {"vr": "TM", "Value": ["095447.918000"]}, "2590": {"vr": "TM", "Value": ["095107.918000"]}, "2591": {"vr": "TM", "Value": ["095407.906000"]}, "2592": {"vr": "TM", "Value": ["094907.713000"]}, "2593": {"vr": "TM", "Value": ["094927.855000"]}, "2594": {"vr": "TM", "Value": ["094807.731000"]}, "2595": {"vr": "TM", "Value": ["095347.956000"]}, "2596": {"vr": "TM", "Value": ["094807.880000"]}, "2597": {"vr": "TM", "Value": ["095427.913000"]}, "2598": {"vr": "TM", "Value": ["094747.946000"]}, "2599": {"vr": "TM", "Value": ["095107.875000"]}, "2600": {"vr": "TM", "Value": ["095247.782000"]}, "2601": {"vr": "TM", "Value": ["095327.860000"]}, "2602": {"vr": "TM", "Value": ["094947.645000"]}, "2603": {"vr": "TM", "Value": ["095247.792000"]}, "2604": {"vr": "TM", "Value": ["095347.902000"]}, "2605": {"vr": "TM", "Value": ["095207.808000"]}, "2606": {"vr": "TM", "Value": ["095307.738000"]}, "2607": {"vr": "TM", "Value": ["095207.821000"]}, "2608": {"vr": "TM", "Value": ["095447.654000"]}, "2609": {"vr": "TM", "Value": ["095147.734000"]}, "2610": {"vr": "TM", "Value": ["094807.689000"]}, "2611": {"vr": "TM", "Value": ["094827.884000"]}, "2612": {"vr": "TM", "Value": ["094727.698000"]}, "2613": {"vr": "TM", "Value": ["094627.669000"]}, "2614": {"vr": "TM", "Value": ["095147.617000"]}, "2615": {"vr": "TM", "Value": ["095347.864000"]}, "2616": {"vr": "TM", "Value": ["094807.740000"]}, "2617": {"vr": "TM", "Value": ["095207.951000"]}, "2618": {"vr": "TM", "Value": ["095147.799000"]}, "2619": {"vr": "TM", "Value": ["094927.674000"]}, "2620": {"vr": "TM", "Value": ["094807.648000"]}, "2621": {"vr": "TM", "Value": ["095027.905000"]}, "2622": {"vr": "TM", "Value": ["095407.615000"]}, "2623": {"vr": "TM", "Value": ["095327.832000"]}, "2624": {"vr": "TM", "Value": ["095327.822000"]}, "2625": {"vr": "TM", "Value": ["094847.839000"]}, "2626": {"vr": "TM", "Value": ["095447.853000"]}, "2627": {"vr": "TM", "Value": ["095327.649000"]}, "2628": {"vr": "TM", "Value": ["095456.432000"]}, "2629": {"vr": "TM", "Value": ["094707.668000"]}, "2630": {"vr": "TM", "Value": ["094947.818000"]}, "2631": {"vr": "TM", "Value": ["094947.647000"]}, "2632": {"vr": "TM", "Value": ["094727.713000"]}, "2633": {"vr": "TM", "Value": ["095007.738000"]}, "2634": {"vr": "TM", "Value": ["094847.779000"]}, "2635": {"vr": "TM", "Value": ["094547.746000"]}, "2636": {"vr": "TM", "Value": ["095327.740000"]}, "2637": {"vr": "TM", "Value": ["094947.775000"]}, "2638": {"vr": "TM", "Value": ["094527.979000"]}, "2639": {"vr": "TM", "Value": ["095147.758000"]}, "2640": {"vr": "TM", "Value": ["094527.737000"]}, "2641": {"vr": "TM", "Value": ["094627.952000"]}, "2642": {"vr": "TM", "Value": ["094927.644000"]}, "2643": {"vr": "TM", "Value": ["095447.886000"]}, "2644": {"vr": "TM", "Value": ["095107.658000"]}, "2645": {"vr": "TM", "Value": ["095327.616000"]}, "2646": {"vr": "TM", "Value": ["095047.661000"]}, "2647": {"vr": "TM", "Value": ["095227.648000"]}, "2648": {"vr": "TM", "Value": ["095147.637000"]}, "2649": {"vr": "TM", "Value": ["094707.927000"]}, "2650": {"vr": "TM", "Value": ["094747.698000"]}, "2651": {"vr": "TM", "Value": ["094827.836000"]}, "2652": {"vr": "TM", "Value": ["094647.749000"]}, "2653": {"vr": "TM", "Value": ["095427.668000"]}, "2654": {"vr": "TM", "Value": ["095307.743000"]}, "2655": {"vr": "TM", "Value": ["094547.834000"]}, "2656": {"vr": "TM", "Value": ["094627.930000"]}, "2657": {"vr": "TM", "Value": ["094747.863000"]}, "2658": {"vr": "TM", "Value": ["095456.539000"]}, "2659": {"vr": "TM", "Value": ["094847.879000"]}, "2660": {"vr": "TM", "Value": ["095207.726000"]}, "2661": {"vr": "TM", "Value": ["095347.695000"]}, "2662": {"vr": "TM", "Value": ["095407.937000"]}, "2663": {"vr": "TM", "Value": ["094607.754000"]}, "2664": {"vr": "TM", "Value": ["094627.652000"]}, "2665": {"vr": "TM", "Value": ["094627.766000"]}, "2666": {"vr": "TM", "Value": ["095347.651000"]}, "2667": {"vr": "TM", "Value": ["094747.972000"]}, "2668": {"vr": "TM", "Value": ["094607.888000"]}, "2669": {"vr": "TM", "Value": ["094647.670000"]}, "2670": {"vr": "TM", "Value": ["094927.918000"]}, "2671": {"vr": "TM", "Value": ["094847.801000"]}, "2672": {"vr": "TM", "Value": ["095247.878000"]}, "2673": {"vr": "TM", "Value": ["094707.773000"]}, "2674": {"vr": "TM", "Value": ["094627.610000"]}, "2675": {"vr": "TM", "Value": ["094627.927000"]}, "2676": {"vr": "TM", "Value": ["094607.838000"]}, "2677": {"vr": "TM", "Value": ["094947.637000"]}, "2678": {"vr": "TM", "Value": ["095247.896000"]}, "2679": {"vr": "TM", "Value": ["095007.892000"]}, "2680": {"vr": "TM", "Value": ["094527.774000"]}, "2681": {"vr": "TM", "Value": ["095207.938000"]}, "2682": {"vr": "TM", "Value": ["095027.857000"]}, "2683": {"vr": "TM", "Value": ["095227.839000"]}, "2684": {"vr": "TM", "Value": ["094927.656000"]}, "2685": {"vr": "TM", "Value": ["095147.692000"]}, "2686": {"vr": "TM", "Value": ["094727.706000"]}, "2687": {"vr": "TM", "Value": ["095107.630000"]}, "2688": {"vr": "TM", "Value": ["095107.826000"]}, "2689": {"vr": "TM", "Value": ["094847.750000"]}, "2690": {"vr": "TM", "Value": ["094927.755000"]}, "2691": {"vr": "TM", "Value": ["094647.673000"]}, "2692": {"vr": "TM", "Value": ["094647.859000"]}, "2693": {"vr": "TM", "Value": ["095107.838000"]}, "2694": {"vr": "TM", "Value": ["095247.868000"]}, "2695": {"vr": "TM", "Value": ["095227.717000"]}, "2696": {"vr": "TM", "Value": ["094627.845000"]}, "2697": {"vr": "TM", "Value": ["095427.616000"]}, "2698": {"vr": "TM", "Value": ["095107.852000"]}, "2699": {"vr": "TM", "Value": ["094727.836000"]}, "2700": {"vr": "TM", "Value": ["094547.709000"]}, "2701": {"vr": "TM", "Value": ["094907.788000"]}, "2702": {"vr": "TM", "Value": ["094847.631000"]}, "2703": {"vr": "TM", "Value": ["095427.886000"]}, "2704": {"vr": "TM", "Value": ["094907.840000"]}, "2705": {"vr": "TM", "Value": ["094607.688000"]}, "2706": {"vr": "TM", "Value": ["094707.833000"]}, "2707": {"vr": "TM", "Value": ["095407.814000"]}, "2708": {"vr": "TM", "Value": ["095347.787000"]}, "2709": {"vr": "TM", "Value": ["095327.647000"]}, "2710": {"vr": "TM", "Value": ["095127.616000"]}, "2711": {"vr": "TM", "Value": ["094607.905000"]}, "2712": {"vr": "TM", "Value": ["094907.621000"]}, "2713": {"vr": "TM", "Value": ["095427.905000"]}, "2714": {"vr": "TM", "Value": ["095347.621000"]}, "2715": {"vr": "TM", "Value": ["095107.634000"]}, "2716": {"vr": "TM", "Value": ["095107.734000"]}, "2717": {"vr": "TM", "Value": ["094847.829000"]}, "2718": {"vr": "TM", "Value": ["094527.878000"]}, "2719": {"vr": "TM", "Value": ["095047.746000"]}, "2720": {"vr": "TM", "Value": ["094847.636000"]}, "2721": {"vr": "TM", "Value": ["095407.932000"]}, "2722": {"vr": "TM", "Value": ["094847.763000"]}, "2723": {"vr": "TM", "Value": ["095447.821000"]}, "2724": {"vr": "TM", "Value": ["095247.825000"]}, "2725": {"vr": "TM", "Value": ["095247.613000"]}, "2726": {"vr": "TM", "Value": ["095327.709000"]}, "2727": {"vr": "TM", "Value": ["094927.676000"]}, "2728": {"vr": "TM", "Value": ["094727.913000"]}, "2729": {"vr": "TM", "Value": ["094927.853000"]}, "2730": {"vr": "TM", "Value": ["095047.797000"]}, "2731": {"vr": "TM", "Value": ["094907.666000"]}, "2732": {"vr": "TM", "Value": ["095447.683000"]}, "2733": {"vr": "TM", "Value": ["095407.827000"]}, "2734": {"vr": "TM", "Value": ["094927.850000"]}, "2735": {"vr": "TM", "Value": ["094647.644000"]}, "2736": {"vr": "TM", "Value": ["095007.877000"]}, "2737": {"vr": "TM", "Value": ["094927.712000"]}, "2738": {"vr": "TM", "Value": ["094527.875000"]}, "2739": {"vr": "TM", "Value": ["095047.767000"]}, "2740": {"vr": "TM", "Value": ["094747.898000"]}, "2741": {"vr": "TM", "Value": ["095456.457000"]}, "2742": {"vr": "TM", "Value": ["095447.850000"]}, "2743": {"vr": "TM", "Value": ["095407.840000"]}, "2744": {"vr": "TM", "Value": ["095207.708000"]}, "2745": {"vr": "TM", "Value": ["094547.615000"]}, "2746": {"vr": "TM", "Value": ["095147.770000"]}, "2747": {"vr": "TM", "Value": ["095247.923000"]}, "2748": {"vr": "TM", "Value": ["095107.639000"]}, "2749": {"vr": "TM", "Value": ["094847.782000"]}, "2750": {"vr": "TM", "Value": ["094647.938000"]}, "2751": {"vr": "TM", "Value": ["095247.621000"]}, "2752": {"vr": "TM", "Value": ["094727.886000"]}, "2753": {"vr": "TM", "Value": ["094527.900000"]}, "2754": {"vr": "TM", "Value": ["095407.804000"]}, "2755": {"vr": "TM", "Value": ["094727.937000"]}, "2756": {"vr": "TM", "Value": ["095327.881000"]}, "2757": {"vr": "TM", "Value": ["094827.892000"]}, "2758": {"vr": "TM", "Value": ["094607.820000"]}, "2759": {"vr": "TM", "Value": ["094647.782000"]}, "2760": {"vr": "TM", "Value": ["095107.696000"]}, "2761": {"vr": "TM", "Value": ["094927.689000"]}, "2762": {"vr": "TM", "Value": ["095127.922000"]}, "2763": {"vr": "TM", "Value": ["094707.840000"]}, "2764": {"vr": "TM", "Value": ["094607.872000"]}, "2765": {"vr": "TM", "Value": ["095007.781000"]}, "2766": {"vr": "TM", "Value": ["094747.706000"]}, "2767": {"vr": "TM", "Value": ["095027.615000"]}, "2768": {"vr": "TM", "Value": ["095127.939000"]}, "2769": {"vr": "TM", "Value": ["094627.884000"]}, "2770": {"vr": "TM", "Value": ["095147.746000"]}, "2771": {"vr": "TM", "Value": ["094547.774000"]}, "2772": {"vr": "TM", "Value": ["094627.965000"]}, "2773": {"vr": "TM", "Value": ["095347.712000"]}, "2774": {"vr": "TM", "Value": ["094927.707000"]}, "2775": {"vr": "TM", "Value": ["094527.801000"]}, "2776": {"vr": "TM", "Value": ["094627.726000"]}, "2777": {"vr": "TM", "Value": ["095147.811000"]}, "2778": {"vr": "TM", "Value": ["095007.951000"]}, "2779": {"vr": "TM", "Value": ["095247.698000"]}, "2780": {"vr": "TM", "Value": ["095047.848000"]}, "2781": {"vr": "TM", "Value": ["095456.448000"]}, "2782": {"vr": "TM", "Value": ["094727.634000"]}, "2783": {"vr": "TM", "Value": ["094627.863000"]}, "2784": {"vr": "TM", "Value": ["094907.900000"]}, "2785": {"vr": "TM", "Value": ["095007.941000"]}, "2786": {"vr": "TM", "Value": ["094947.832000"]}, "2787": {"vr": "TM", "Value": ["095427.732000"]}, "2788": {"vr": "TM", "Value": ["095107.723000"]}, "2789": {"vr": "TM", "Value": ["095127.932000"]}, "2790": {"vr": "TM", "Value": ["094727.701000"]}, "2791": {"vr": "TM", "Value": ["095207.844000"]}, "2792": {"vr": "TM", "Value": ["095327.706000"]}, "2793": {"vr": "TM", "Value": ["095247.739000"]}, "2794": {"vr": "TM", "Value": ["094807.913000"]}, "2795": {"vr": "TM", "Value": ["094747.690000"]}, "2796": {"vr": "TM", "Value": ["095047.698000"]}, "2797": {"vr": "TM", "Value": ["095147.842000"]}, "2798": {"vr": "TM", "Value": ["095227.882000"]}, "2799": {"vr": "TM", "Value": ["095347.628000"]}, "2800": {"vr": "TM", "Value": ["095147.890000"]}, "2801": {"vr": "TM", "Value": ["094907.668000"]}, "2802": {"vr": "TM", "Value": ["095407.893000"]}, "2803": {"vr": "TM", "Value": ["094947.697000"]}, "2804": {"vr": "TM", "Value": ["095047.790000"]}, "2805": {"vr": "TM", "Value": ["095127.821000"]}, "2806": {"vr": "TM", "Value": ["094647.737000"]}, "2807": {"vr": "TM", "Value": ["095427.748000"]}, "2808": {"vr": "TM", "Value": ["095407.791000"]}, "2809": {"vr": "TM", "Value": ["094907.903000"]}, "2810": {"vr": "TM", "Value": ["095047.671000"]}, "2811": {"vr": "TM", "Value": ["095447.950000"]}, "2812": {"vr": "TM", "Value": ["094947.709000"]}, "2813": {"vr": "TM", "Value": ["094747.871000"]}, "2814": {"vr": "TM", "Value": ["094607.747000"]}, "2815": {"vr": "TM", "Value": ["095047.769000"]}, "2816": {"vr": "TM", "Value": ["094707.882000"]}, "2817": {"vr": "TM", "Value": ["095127.642000"]}, "2818": {"vr": "TM", "Value": ["094827.896000"]}, "2819": {"vr": "TM", "Value": ["095407.741000"]}, "2820": {"vr": "TM", "Value": ["094947.839000"]}, "2821": {"vr": "TM", "Value": ["095407.786000"]}, "2822": {"vr": "TM", "Value": ["095147.722000"]}, "2823": {"vr": "TM", "Value": ["095347.928000"]}, "2824": {"vr": "TM", "Value": ["095347.938000"]}, "2825": {"vr": "TM", "Value": ["094827.826000"]}, "2826": {"vr": "TM", "Value": ["094607.686000"]}, "2827": {"vr": "TM", "Value": ["094727.878000"]}, "2828": {"vr": "TM", "Value": ["095427.614000"]}, "2829": {"vr": "TM", "Value": ["095307.707000"]}, "2830": {"vr": "TM", "Value": ["095007.921000"]}, "2831": {"vr": "TM", "Value": ["095327.945000"]}, "2832": {"vr": "TM", "Value": ["095107.729000"]}, "2833": {"vr": "TM", "Value": ["094947.733000"]}, "2834": {"vr": "TM", "Value": ["095127.713000"]}, "2835": {"vr": "TM", "Value": ["094907.765000"]}, "2836": {"vr": "TM", "Value": ["095107.767000"]}, "2837": {"vr": "TM", "Value": ["094707.800000"]}, "2838": {"vr": "TM", "Value": ["094827.791000"]}, "2839": {"vr": "TM", "Value": ["095047.640000"]}, "2840": {"vr": "TM", "Value": ["094927.943000"]}, "2841": {"vr": "TM", "Value": ["095247.780000"]}, "2842": {"vr": "TM", "Value": ["095247.703000"]}, "2843": {"vr": "TM", "Value": ["094947.652000"]}, "2844": {"vr": "TM", "Value": ["094747.728000"]}, "2845": {"vr": "TM", "Value": ["094827.694000"]}, "2846": {"vr": "TM", "Value": ["094747.911000"]}, "2847": {"vr": "TM", "Value": ["095327.907000"]}, "2848": {"vr": "TM", "Value": ["095447.644000"]}, "2849": {"vr": "TM", "Value": ["095307.926000"]}, "2850": {"vr": "TM", "Value": ["095147.682000"]}, "2851": {"vr": "TM", "Value": ["095247.616000"]}, "2852": {"vr": "TM", "Value": ["095007.783000"]}, "2853": {"vr": "TM", "Value": ["094727.818000"]}, "2854": {"vr": "TM", "Value": ["094807.892000"]}, "2855": {"vr": "TM", "Value": ["094527.625000"]}, "2856": {"vr": "TM", "Value": ["094907.793000"]}, "2857": {"vr": "TM", "Value": ["094807.943000"]}, "2858": {"vr": "TM", "Value": ["094907.678000"]}, "2859": {"vr": "TM", "Value": ["095227.745000"]}, "2860": {"vr": "TM", "Value": ["095307.928000"]}, "2861": {"vr": "TM", "Value": ["094807.633000"]}, "2862": {"vr": "TM", "Value": ["094527.721000"]}, "2863": {"vr": "TM", "Value": ["095007.672000"]}, "2864": {"vr": "TM", "Value": ["094627.662000"]}, "2865": {"vr": "TM", "Value": ["095247.712000"]}, "2866": {"vr": "TM", "Value": ["094827.612000"]}, "2867": {"vr": "TM", "Value": ["095207.826000"]}, "2868": {"vr": "TM", "Value": ["095327.850000"]}, "2869": {"vr": "TM", "Value": ["094807.915000"]}, "2870": {"vr": "TM", "Value": ["094727.800000"]}, "2871": {"vr": "TM", "Value": ["094547.607000"]}, "2872": {"vr": "TM", "Value": ["095247.799000"]}, "2873": {"vr": "TM", "Value": ["095207.716000"]}, "2874": {"vr": "TM", "Value": ["094847.917000"]}, "2875": {"vr": "TM", "Value": ["095407.687000"]}, "2876": {"vr": "TM", "Value": ["094947.862000"]}, "2877": {"vr": "TM", "Value": ["095047.900000"]}, "2878": {"vr": "TM", "Value": ["095327.672000"]}, "2879": {"vr": "TM", "Value": ["095047.946000"]}, "2880": {"vr": "TM", "Value": ["095047.874000"]}, "2881": {"vr": "TM", "Value": ["094947.763000"]}, "2882": {"vr": "TM", "Value": ["094647.980000"]}, "2883": {"vr": "TM", "Value": ["094607.938000"]}, "2884": {"vr": "TM", "Value": ["094607.678000"]}, "2885": {"vr": "TM", "Value": ["094847.824000"]}, "2886": {"vr": "TM", "Value": ["095047.710000"]}, "2887": {"vr": "TM", "Value": ["094907.906000"]}, "2888": {"vr": "TM", "Value": ["094907.816000"]}, "2889": {"vr": "TM", "Value": ["095447.670000"]}, "2890": {"vr": "TM", "Value": ["094627.939000"]}, "2891": {"vr": "TM", "Value": ["094707.899000"]}, "2892": {"vr": "TM", "Value": ["095307.871000"]}, "2893": {"vr": "TM", "Value": ["094827.628000"]}, "2894": {"vr": "TM", "Value": ["095007.624000"]}, "2895": {"vr": "TM", "Value": ["094547.806000"]}, "2896": {"vr": "TM", "Value": ["095327.943000"]}, "2897": {"vr": "TM", "Value": ["094947.673000"]}, "2898": {"vr": "TM", "Value": ["095027.839000"]}, "2899": {"vr": "TM", "Value": ["094747.751000"]}, "2900": {"vr": "TM", "Value": ["095127.661000"]}, "2901": {"vr": "TM", "Value": ["094627.655000"]}, "2902": {"vr": "TM", "Value": ["095407.756000"]}, "2903": {"vr": "TM", "Value": ["095127.796000"]}, "2904": {"vr": "TM", "Value": ["095127.687000"]}, "2905": {"vr": "TM", "Value": ["094747.941000"]}, "2906": {"vr": "TM", "Value": ["094527.644000"]}, "2907": {"vr": "TM", "Value": ["095456.422000"]}, "2908": {"vr": "TM", "Value": ["094647.668000"]}, "2909": {"vr": "TM", "Value": ["095427.737000"]}, "2910": {"vr": "TM", "Value": ["094807.890000"]}, "2911": {"vr": "TM", "Value": ["095407.743000"]}, "2912": {"vr": "TM", "Value": ["094627.733000"]}, "2913": {"vr": "TM", "Value": ["094927.791000"]}, "2914": {"vr": "TM", "Value": ["094647.625000"]}, "2915": {"vr": "TM", "Value": ["095027.951000"]}, "2916": {"vr": "TM", "Value": ["095007.810000"]}, "2917": {"vr": "TM", "Value": ["094807.883000"]}, "2918": {"vr": "TM", "Value": ["094527.714000"]}, "2919": {"vr": "TM", "Value": ["095456.519000"]}, "2920": {"vr": "TM", "Value": ["095227.770000"]}, "2921": {"vr": "TM", "Value": ["095147.625000"]}, "2922": {"vr": "TM", "Value": ["095207.672000"]}, "2923": {"vr": "TM", "Value": ["095007.829000"]}, "2924": {"vr": "TM", "Value": ["095127.762000"]}, "2925": {"vr": "TM", "Value": ["094607.732000"]}, "2926": {"vr": "TM", "Value": ["094707.717000"]}, "2927": {"vr": "TM", "Value": ["095307.822000"]}, "2928": {"vr": "TM", "Value": ["094747.964000"]}, "2929": {"vr": "TM", "Value": ["094527.919000"]}, "2930": {"vr": "TM", "Value": ["094707.617000"]}, "2931": {"vr": "TM", "Value": ["095447.899000"]}, "2932": {"vr": "TM", "Value": ["095427.939000"]}, "2933": {"vr": "TM", "Value": ["094647.627000"]}, "2934": {"vr": "TM", "Value": ["095107.651000"]}, "2935": {"vr": "TM", "Value": ["094707.685000"]}, "2936": {"vr": "TM", "Value": ["095207.752000"]}, "2937": {"vr": "TM", "Value": ["095307.866000"]}, "2938": {"vr": "TM", "Value": ["095307.905000"]}, "2939": {"vr": "TM", "Value": ["094847.827000"]}, "2940": {"vr": "TM", "Value": ["094927.608000"]}, "2941": {"vr": "TM", "Value": ["094727.860000"]}, "2942": {"vr": "TM", "Value": ["095347.733000"]}, "2943": {"vr": "TM", "Value": ["095207.659000"]}, "2944": {"vr": "TM", "Value": ["095407.865000"]}, "2945": {"vr": "TM", "Value": ["095447.926000"]}, "2946": {"vr": "TM", "Value": ["094827.856000"]}, "2947": {"vr": "TM", "Value": ["095307.912000"]}, "2948": {"vr": "TM", "Value": ["094947.728000"]}, "2949": {"vr": "TM", "Value": ["094527.705000"]}, "2950": {"vr": "TM", "Value": ["094707.838000"]}, "2951": {"vr": "TM", "Value": ["095107.817000"]}, "2952": {"vr": "TM", "Value": ["095407.857000"]}, "2953": {"vr": "TM", "Value": ["094907.813000"]}, "2954": {"vr": "TM", "Value": ["095007.880000"]}, "2955": {"vr": "TM", "Value": ["095147.854000"]}, "2956": {"vr": "TM", "Value": ["095227.750000"]}, "2957": {"vr": "TM", "Value": ["094627.899000"]}, "2958": {"vr": "TM", "Value": ["094647.652000"]}, "2959": {"vr": "TM", "Value": ["094747.829000"]}, "2960": {"vr": "TM", "Value": ["094807.748000"]}, "2961": {"vr": "TM", "Value": ["094747.935000"]}, "2962": {"vr": "TM", "Value": ["094747.916000"]}, "2963": {"vr": "TM", "Value": ["095347.654000"]}, "2964": {"vr": "TM", "Value": ["094707.722000"]}, "2965": {"vr": "TM", "Value": ["095327.863000"]}, "2966": {"vr": "TM", "Value": ["094847.855000"]}, "2967": {"vr": "TM", "Value": ["094607.841000"]}, "2968": {"vr": "TM", "Value": ["094827.957000"]}, "2969": {"vr": "TM", "Value": ["094707.879000"]}, "2970": {"vr": "TM", "Value": ["095247.851000"]}, "2971": {"vr": "TM", "Value": ["095447.861000"]}, "2972": {"vr": "TM", "Value": ["095327.912000"]}, "2973": {"vr": "TM", "Value": ["095047.728000"]}, "2974": {"vr": "TM", "Value": ["094707.902000"]}, "2975": {"vr": "TM", "Value": ["094547.886000"]}, "2976": {"vr": "TM", "Value": ["094747.877000"]}, "2977": {"vr": "TM", "Value": ["095107.699000"]}, "2978": {"vr": "TM", "Value": ["094647.636000"]}, "2979": {"vr": "TM", "Value": ["095307.625000"]}, "2980": {"vr": "TM", "Value": ["095027.762000"]}, "2981": {"vr": "TM", "Value": ["095227.814000"]}, "2982": {"vr": "TM", "Value": ["095107.913000"]}, "2983": {"vr": "TM", "Value": ["094627.744000"]}, "2984": {"vr": "TM", "Value": ["095307.710000"]}, "2985": {"vr": "TM", "Value": ["094847.629000"]}, "2986": {"vr": "TM", "Value": ["094827.816000"]}, "2987": {"vr": "TM", "Value": ["095127.682000"]}, "2988": {"vr": "TM", "Value": ["095127.789000"]}, "2989": {"vr": "TM", "Value": ["095247.670000"]}, "2990": {"vr": "TM", "Value": ["094547.704000"]}, "2991": {"vr": "TM", "Value": ["095207.629000"]}, "2992": {"vr": "TM", "Value": ["095127.791000"]}, "2993": {"vr": "TM", "Value": ["095027.795000"]}, "2994": {"vr": "TM", "Value": ["095247.787000"]}, "2995": {"vr": "TM", "Value": ["095347.774000"]}, "2996": {"vr": "TM", "Value": ["094927.901000"]}, "2997": {"vr": "TM", "Value": ["094807.697000"]}, "2998": {"vr": "TM", "Value": ["095047.749000"]}, "2999": {"vr": "TM", "Value": ["095027.814000"]}, "3000": {"vr": "TM", "Value": ["095247.918000"]}, "3001": {"vr": "TM", "Value": ["094627.731000"]}, "3002": {"vr": "TM", "Value": ["095327.932000"]}, "3003": {"vr": "TM", "Value": ["095127.737000"]}, "3004": {"vr": "TM", "Value": ["095227.880000"]}, "3005": {"vr": "TM", "Value": ["095456.430000"]}, "3006": {"vr": "TM", "Value": ["095227.866000"]}, "3007": {"vr": "TM", "Value": ["095307.753000"]}, "3008": {"vr": "TM", "Value": ["094607.898000"]}, "3009": {"vr": "TM", "Value": ["094707.740000"]}, "3010": {"vr": "TM", "Value": ["095207.948000"]}, "3011": {"vr": "TM", "Value": ["094847.814000"]}, "3012": {"vr": "TM", "Value": ["094847.925000"]}, "3013": {"vr": "TM", "Value": ["094727.763000"]}, "3014": {"vr": "TM", "Value": ["095447.729000"]}, "3015": {"vr": "TM", "Value": ["094907.954000"]}, "3016": {"vr": "TM", "Value": ["094947.908000"]}, "3017": {"vr": "TM", "Value": ["095047.807000"]}, "3018": {"vr": "TM", "Value": ["095347.817000"]}, "3019": {"vr": "TM", "Value": ["094527.744000"]}, "3020": {"vr": "TM", "Value": ["094927.647000"]}, "3021": {"vr": "TM", "Value": ["095047.623000"]}, "3022": {"vr": "TM", "Value": ["094827.786000"]}, "3023": {"vr": "TM", "Value": ["095127.755000"]}, "3024": {"vr": "TM", "Value": ["095027.934000"]}, "3025": {"vr": "TM", "Value": ["095307.629000"]}, "3026": {"vr": "TM", "Value": ["094527.892000"]}, "3027": {"vr": "TM", "Value": ["094727.670000"]}, "3028": {"vr": "TM", "Value": ["094927.873000"]}, "3029": {"vr": "TM", "Value": ["095147.845000"]}, "3030": {"vr": "TM", "Value": ["095307.748000"]}, "3031": {"vr": "TM", "Value": ["095307.923000"]}, "3032": {"vr": "TM", "Value": ["095447.783000"]}, "3033": {"vr": "TM", "Value": ["094647.754000"]}, "3034": {"vr": "TM", "Value": ["094807.726000"]}, "3035": {"vr": "TM", "Value": ["094907.673000"]}, "3036": {"vr": "TM", "Value": ["095347.679000"]}, "3037": {"vr": "TM", "Value": ["095047.948000"]}, "3038": {"vr": "TM", "Value": ["094647.835000"]}, "3039": {"vr": "TM", "Value": ["094647.827000"]}, "3040": {"vr": "TM", "Value": ["094647.841000"]}, "3041": {"vr": "TM", "Value": ["094747.879000"]}, "3042": {"vr": "TM", "Value": ["095127.689000"]}, "3043": {"vr": "TM", "Value": ["095247.715000"]}, "3044": {"vr": "TM", "Value": ["095307.949000"]}, "3045": {"vr": "TM", "Value": ["094627.840000"]}, "3046": {"vr": "TM", "Value": ["094727.667000"]}, "3047": {"vr": "TM", "Value": ["094947.706000"]}, "3048": {"vr": "TM", "Value": ["094927.635000"]}, "3049": {"vr": "TM", "Value": ["095407.948000"]}, "3050": {"vr": "TM", "Value": ["095127.890000"]}, "3051": {"vr": "TM", "Value": ["095027.819000"]}, "3052": {"vr": "TM", "Value": ["094727.931000"]}, "3053": {"vr": "TM", "Value": ["094647.912000"]}, "3054": {"vr": "TM", "Value": ["095327.611000"]}, "3055": {"vr": "TM", "Value": ["094607.629000"]}, "3056": {"vr": "TM", "Value": ["095407.692000"]}, "3057": {"vr": "TM", "Value": ["094607.815000"]}, "3058": {"vr": "TM", "Value": ["094727.797000"]}, "3059": {"vr": "TM", "Value": ["094727.802000"]}, "3060": {"vr": "TM", "Value": ["095127.870000"]}, "3061": {"vr": "TM", "Value": ["094827.758000"]}, "3062": {"vr": "TM", "Value": ["095427.804000"]}, "3063": {"vr": "TM", "Value": ["095407.608000"]}, "3064": {"vr": "TM", "Value": ["094927.788000"]}, "3065": {"vr": "TM", "Value": ["095127.639000"]}, "3066": {"vr": "TM", "Value": ["095227.760000"]}, "3067": {"vr": "TM", "Value": ["095027.710000"]}, "3068": {"vr": "TM", "Value": ["095207.762000"]}, "3069": {"vr": "TM", "Value": ["095027.897000"]}, "3070": {"vr": "TM", "Value": ["095427.848000"]}, "3071": {"vr": "TM", "Value": ["095027.672000"]}, "3072": {"vr": "TM", "Value": ["095147.818000"]}, "3073": {"vr": "TM", "Value": ["094747.684000"]}, "3074": {"vr": "TM", "Value": ["094647.928000"]}, "3075": {"vr": "TM", "Value": ["095447.706000"]}, "3076": {"vr": "TM", "Value": ["094547.729000"]}, "3077": {"vr": "TM", "Value": ["095147.765000"]}, "3078": {"vr": "TM", "Value": ["095047.762000"]}, "3079": {"vr": "TM", "Value": ["094927.679000"]}, "3080": {"vr": "TM", "Value": ["094547.881000"]}, "3081": {"vr": "TM", "Value": ["095327.938000"]}, "3082": {"vr": "TM", "Value": ["095347.948000"]}, "3083": {"vr": "TM", "Value": ["094847.898000"]}, "3084": {"vr": "TM", "Value": ["095047.739000"]}, "3085": {"vr": "TM", "Value": ["094847.895000"]}, "3086": {"vr": "TM", "Value": ["095047.726000"]}, "3087": {"vr": "TM", "Value": ["094547.781000"]}, "3088": {"vr": "TM", "Value": ["095227.873000"]}, "3089": {"vr": "TM", "Value": ["094527.668000"]}, "3090": {"vr": "TM", "Value": ["095407.733000"]}, "3091": {"vr": "TM", "Value": ["095107.901000"]}, "3092": {"vr": "TM", "Value": ["094707.624000"]}, "3093": {"vr": "TM", "Value": ["094807.607000"]}, "3094": {"vr": "TM", "Value": ["095247.796000"]}, "3095": {"vr": "TM", "Value": ["095247.743000"]}, "3096": {"vr": "TM", "Value": ["095107.656000"]}, "3097": {"vr": "TM", "Value": ["095007.931000"]}, "3098": {"vr": "TM", "Value": ["094927.747000"]}, "3099": {"vr": "TM", "Value": ["094827.821000"]}, "3100": {"vr": "TM", "Value": ["094727.820000"]}, "3101": {"vr": "TM", "Value": ["094827.618000"]}, "3102": {"vr": "TM", "Value": ["095147.772000"]}, "3103": {"vr": "TM", "Value": ["095147.613000"]}, "3104": {"vr": "TM", "Value": ["095127.627000"]}, "3105": {"vr": "TM", "Value": ["094907.895000"]}, "3106": {"vr": "TM", "Value": ["094807.694000"]}, "3107": {"vr": "TM", "Value": ["095407.728000"]}, "3108": {"vr": "TM", "Value": ["095447.906000"]}, "3109": {"vr": "TM", "Value": ["095427.868000"]}, "3110": {"vr": "TM", "Value": ["094907.703000"]}, "3111": {"vr": "TM", "Value": ["094827.623000"]}, "3112": {"vr": "TM", "Value": ["094827.662000"]}, "3113": {"vr": "TM", "Value": ["095227.863000"]}, "3114": {"vr": "TM", "Value": ["094807.775000"]}, "3115": {"vr": "TM", "Value": ["094527.845000"]}, "3116": {"vr": "TM", "Value": ["094707.689000"]}, "3117": {"vr": "TM", "Value": ["094907.686000"]}, "3118": {"vr": "TM", "Value": ["094907.718000"]}, "3119": {"vr": "TM", "Value": ["094647.888000"]}, "3120": {"vr": "TM", "Value": ["095427.902000"]}, "3121": {"vr": "TM", "Value": ["094847.946000"]}, "3122": {"vr": "TM", "Value": ["094627.834000"]}, "3123": {"vr": "TM", "Value": ["095307.848000"]}, "3124": {"vr": "TM", "Value": ["094547.719000"]}, "3125": {"vr": "TM", "Value": ["095247.784000"]}, "3126": {"vr": "TM", "Value": ["095307.876000"]}, "3127": {"vr": "TM", "Value": ["095207.790000"]}, "3128": {"vr": "TM", "Value": ["095307.768000"]}, "3129": {"vr": "TM", "Value": ["094607.796000"]}, "3130": {"vr": "TM", "Value": ["094807.758000"]}, "3131": {"vr": "TM", "Value": ["094847.644000"]}, "3132": {"vr": "TM", "Value": ["094527.716000"]}, "3133": {"vr": "TM", "Value": ["095207.943000"]}, "3134": {"vr": "TM", "Value": ["095027.900000"]}, "3135": {"vr": "TM", "Value": ["095347.797000"]}, "3136": {"vr": "TM", "Value": ["094547.721000"]}, "3137": {"vr": "TM", "Value": ["095407.914000"]}, "3138": {"vr": "TM", "Value": ["094607.668000"]}, "3139": {"vr": "TM", "Value": ["094547.672000"]}, "3140": {"vr": "TM", "Value": ["095047.708000"]}, "3141": {"vr": "TM", "Value": ["094807.802000"]}, "3142": {"vr": "TM", "Value": ["095327.814000"]}, "3143": {"vr": "TM", "Value": ["094627.914000"]}, "3144": {"vr": "TM", "Value": ["094727.711000"]}, "3145": {"vr": "TM", "Value": ["094527.945000"]}, "3146": {"vr": "TM", "Value": ["095027.713000"]}, "3147": {"vr": "TM", "Value": ["094727.771000"]}, "3148": {"vr": "TM", "Value": ["094807.692000"]}, "3149": {"vr": "TM", "Value": ["095147.948000"]}, "3150": {"vr": "TM", "Value": ["095047.780000"]}, "3151": {"vr": "TM", "Value": ["094707.747000"]}, "3152": {"vr": "TM", "Value": ["095107.701000"]}, "3153": {"vr": "TM", "Value": ["095307.686000"]}, "3154": {"vr": "TM", "Value": ["094747.933000"]}, "3155": {"vr": "TM", "Value": ["095427.822000"]}, "3156": {"vr": "TM", "Value": ["094727.807000"]}, "3157": {"vr": "TM", "Value": ["095247.873000"]}, "3158": {"vr": "TM", "Value": ["095027.759000"]}, "3159": {"vr": "TM", "Value": ["094807.658000"]}, "3160": {"vr": "TM", "Value": ["094527.750000"]}, "3161": {"vr": "TM", "Value": ["095007.761000"]}, "3162": {"vr": "TM", "Value": ["094947.759000"]}, "3163": {"vr": "TM", "Value": ["094607.916000"]}, "3164": {"vr": "TM", "Value": ["094747.665000"]}, "3165": {"vr": "TM", "Value": ["094527.646000"]}, "3166": {"vr": "TM", "Value": ["094647.762000"]}, "3167": {"vr": "TM", "Value": ["094647.617000"]}, "3168": {"vr": "TM", "Value": ["095307.646000"]}, "3169": {"vr": "TM", "Value": ["095007.773000"]}, "3170": {"vr": "TM", "Value": ["095447.799000"]}, "3171": {"vr": "TM", "Value": ["095027.782000"]}, "3172": {"vr": "TM", "Value": ["095456.512000"]}, "3173": {"vr": "TM", "Value": ["095327.883000"]}, "3174": {"vr": "TM", "Value": ["094827.680000"]}, "3175": {"vr": "TM", "Value": ["095007.746000"]}, "3176": {"vr": "TM", "Value": ["095447.943000"]}, "3177": {"vr": "TM", "Value": ["094927.709000"]}, "3178": {"vr": "TM", "Value": ["095107.857000"]}, "3179": {"vr": "TM", "Value": ["094907.822000"]}, "3180": {"vr": "TM", "Value": ["095247.888000"]}, "3181": {"vr": "TM", "Value": ["095307.733000"]}, "3182": {"vr": "TM", "Value": ["095307.666000"]}, "3183": {"vr": "TM", "Value": ["094807.676000"]}, "3184": {"vr": "TM", "Value": ["094647.830000"]}, "3185": {"vr": "TM", "Value": ["095307.756000"]}, "3186": {"vr": "TM", "Value": ["095227.658000"]}, "3187": {"vr": "TM", "Value": ["094927.737000"]}, "3188": {"vr": "TM", "Value": ["094747.835000"]}, "3189": {"vr": "TM", "Value": ["094747.850000"]}, "3190": {"vr": "TM", "Value": ["095347.963000"]}, "3191": {"vr": "TM", "Value": ["095307.918000"]}, "3192": {"vr": "TM", "Value": ["095127.680000"]}, "3193": {"vr": "TM", "Value": ["095007.841000"]}, "3194": {"vr": "TM", "Value": ["094527.756000"]}, "3195": {"vr": "TM", "Value": ["094927.868000"]}, "3196": {"vr": "TM", "Value": ["094647.794000"]}, "3197": {"vr": "TM", "Value": ["095247.883000"]}, "3198": {"vr": "TM", "Value": ["095027.680000"]}, "3199": {"vr": "TM", "Value": ["094907.770000"]}, "3200": {"vr": "TM", "Value": ["094527.904000"]}, "3201": {"vr": "TM", "Value": ["095247.836000"]}, "3202": {"vr": "TM", "Value": ["095447.824000"]}, "3203": {"vr": "TM", "Value": ["094947.806000"]}, "3204": {"vr": "TM", "Value": ["094947.825000"]}, "3205": {"vr": "TM", "Value": ["095447.760000"]}, "3206": {"vr": "TM", "Value": ["094647.685000"]}, "3207": {"vr": "TM", "Value": ["094907.755000"]}, "3208": {"vr": "TM", "Value": ["094927.750000"]}, "3209": {"vr": "TM", "Value": ["095227.783000"]}, "3210": {"vr": "TM", "Value": ["094627.967000"]}, "3211": {"vr": "TM", "Value": ["095047.912000"]}, "3212": {"vr": "TM", "Value": ["095007.697000"]}, "3213": {"vr": "TM", "Value": ["095307.894000"]}, "3214": {"vr": "TM", "Value": ["095456.483000"]}, "3215": {"vr": "TM", "Value": ["095407.695000"]}, "3216": {"vr": "TM", "Value": ["095147.946000"]}, "3217": {"vr": "TM", "Value": ["094627.891000"]}, "3218": {"vr": "TM", "Value": ["094527.697000"]}, "3219": {"vr": "TM", "Value": ["094747.824000"]}, "3220": {"vr": "TM", "Value": ["095027.639000"]}, "3221": {"vr": "TM", "Value": ["094727.615000"]}, "3222": {"vr": "TM", "Value": ["095347.856000"]}, "3223": {"vr": "TM", "Value": ["094907.676000"]}, "3224": {"vr": "TM", "Value": ["094527.863000"]}, "3225": {"vr": "TM", "Value": ["095147.674000"]}, "3226": {"vr": "TM", "Value": ["095127.806000"]}, "3227": {"vr": "TM", "Value": ["094747.814000"]}, "3228": {"vr": "TM", "Value": ["095227.729000"]}, "3229": {"vr": "TM", "Value": ["094627.807000"]}, "3230": {"vr": "TM", "Value": ["094827.922000"]}, "3231": {"vr": "TM", "Value": ["095207.700000"]}, "3232": {"vr": "TM", "Value": ["094747.796000"]}, "3233": {"vr": "TM", "Value": ["095427.858000"]}, "3234": {"vr": "TM", "Value": ["094747.967000"]}, "3235": {"vr": "TM", "Value": ["095147.622000"]}, "3236": {"vr": "TM", "Value": ["094907.624000"]}, "3237": {"vr": "TM", "Value": ["094927.933000"]}, "3238": {"vr": "TM", "Value": ["095347.840000"]}, "3239": {"vr": "TM", "Value": ["095307.735000"]}, "3240": {"vr": "TM", "Value": ["095447.904000"]}, "3241": {"vr": "TM", "Value": ["095227.842000"]}, "3242": {"vr": "TM", "Value": ["094747.717000"]}, "3243": {"vr": "TM", "Value": ["095007.904000"]}, "3244": {"vr": "TM", "Value": ["094647.622000"]}, "3245": {"vr": "TM", "Value": ["094527.873000"]}, "3246": {"vr": "TM", "Value": ["095347.705000"]}, "3247": {"vr": "TM", "Value": ["094927.753000"]}, "3248": {"vr": "TM", "Value": ["095127.885000"]}, "3249": {"vr": "TM", "Value": ["094847.935000"]}, "3250": {"vr": "TM", "Value": ["095347.753000"]}, "3251": {"vr": "TM", "Value": ["095107.632000"]}, "3252": {"vr": "TM", "Value": ["095047.892000"]}, "3253": {"vr": "TM", "Value": ["095307.817000"]}, "3254": {"vr": "TM", "Value": ["095327.811000"]}, "3255": {"vr": "TM", "Value": ["095447.938000"]}, "3256": {"vr": "TM", "Value": ["095147.821000"]}, "3257": {"vr": "TM", "Value": ["095307.668000"]}, "3258": {"vr": "TM", "Value": ["095007.870000"]}, "3259": {"vr": "TM", "Value": ["094607.781000"]}, "3260": {"vr": "TM", "Value": ["095047.741000"]}, "3261": {"vr": "TM", "Value": ["094927.637000"]}, "3262": {"vr": "TM", "Value": ["094927.717000"]}, "3263": {"vr": "TM", "Value": ["094827.789000"]}, "3264": {"vr": "TM", "Value": ["095007.907000"]}, "3265": {"vr": "TM", "Value": ["095347.830000"]}, "3266": {"vr": "TM", "Value": ["095407.847000"]}, "3267": {"vr": "TM", "Value": ["094927.765000"]}, "3268": {"vr": "TM", "Value": ["094827.831000"]}, "3269": {"vr": "TM", "Value": ["095227.804000"]}, "3270": {"vr": "TM", "Value": ["095456.437000"]}, "3271": {"vr": "TM", "Value": ["094747.919000"]}, "3272": {"vr": "TM", "Value": ["095407.934000"]}, "3273": {"vr": "TM", "Value": ["095447.680000"]}, "3274": {"vr": "TM", "Value": ["095447.913000"]}, "3275": {"vr": "TM", "Value": ["094727.863000"]}, "3276": {"vr": "TM", "Value": ["094747.673000"]}, "3277": {"vr": "TM", "Value": ["095047.754000"]}, "3278": {"vr": "TM", "Value": ["095347.687000"]}, "3279": {"vr": "TM", "Value": ["095347.707000"]}, "3280": {"vr": "TM", "Value": ["094827.942000"]}, "3281": {"vr": "TM", "Value": ["094747.809000"]}, "3282": {"vr": "TM", "Value": ["094827.797000"]}, "3283": {"vr": "TM", "Value": ["094647.717000"]}, "3284": {"vr": "TM", "Value": ["095207.713000"]}, "3285": {"vr": "TM", "Value": ["095047.884000"]}, "3286": {"vr": "TM", "Value": ["095127.701000"]}, "3287": {"vr": "TM", "Value": ["095327.845000"]}, "3288": {"vr": "TM", "Value": ["094807.671000"]}, "3289": {"vr": "TM", "Value": ["094647.729000"]}, "3290": {"vr": "TM", "Value": ["094647.642000"]}, "3291": {"vr": "TM", "Value": ["095107.644000"]}, "3292": {"vr": "TM", "Value": ["095427.865000"]}, "3293": {"vr": "TM", "Value": ["095007.621000"]}, "3294": {"vr": "TM", "Value": ["095027.921000"]}, "3295": {"vr": "TM", "Value": ["095127.654000"]}, "3296": {"vr": "TM", "Value": ["094747.743000"]}, "3297": {"vr": "TM", "Value": ["094747.676000"]}, "3298": {"vr": "TM", "Value": ["094907.606000"]}, "3299": {"vr": "TM", "Value": ["094627.865000"]}, "3300": {"vr": "TM", "Value": ["094947.665000"]}, "3301": {"vr": "TM", "Value": ["094947.875000"]}, "3302": {"vr": "TM", "Value": ["095127.649000"]}, "3303": {"vr": "TM", "Value": ["095447.874000"]}, "3304": {"vr": "TM", "Value": ["094727.632000"]}, "3305": {"vr": "TM", "Value": ["094927.904000"]}, "3306": {"vr": "TM", "Value": ["095427.664000"]}, "3307": {"vr": "TM", "Value": ["094607.809000"]}, "3308": {"vr": "TM", "Value": ["094807.900000"]}, "3309": {"vr": "TM", "Value": ["095207.933000"]}, "3310": {"vr": "TM", "Value": ["094607.693000"]}, "3311": {"vr": "TM", "Value": ["094847.740000"]}, "3312": {"vr": "TM", "Value": ["095107.930000"]}, "3313": {"vr": "TM", "Value": ["094527.804000"]}, "3314": {"vr": "TM", "Value": ["094947.735000"]}, "3315": {"vr": "TM", "Value": ["095007.926000"]}, "3316": {"vr": "TM", "Value": ["094727.805000"]}, "3317": {"vr": "TM", "Value": ["095407.625000"]}, "3318": {"vr": "TM", "Value": ["095027.774000"]}, "3319": {"vr": "TM", "Value": ["095307.838000"]}, "3320": {"vr": "TM", "Value": ["095427.685000"]}, "3321": {"vr": "TM", "Value": ["095227.918000"]}, "3322": {"vr": "TM", "Value": ["095127.853000"]}, "3323": {"vr": "TM", "Value": ["095047.695000"]}, "3324": {"vr": "TM", "Value": ["095007.689000"]}, "3325": {"vr": "TM", "Value": ["094727.708000"]}, "3326": {"vr": "TM", "Value": ["094847.933000"]}, "3327": {"vr": "TM", "Value": ["094947.650000"]}, "3328": {"vr": "TM", "Value": ["095327.704000"]}, "3329": {"vr": "TM", "Value": ["094807.780000"]}, "3330": {"vr": "TM", "Value": ["094607.644000"]}, "3331": {"vr": "TM", "Value": ["095447.837000"]}, "3332": {"vr": "TM", "Value": ["095407.771000"]}, "3333": {"vr": "TM", "Value": ["094807.868000"]}, "3334": {"vr": "TM", "Value": ["095107.689000"]}, "3335": {"vr": "TM", "Value": ["094947.851000"]}, "3336": {"vr": "TM", "Value": ["094647.809000"]}, "3337": {"vr": "TM", "Value": ["094527.776000"]}, "3338": {"vr": "TM", "Value": ["094707.861000"]}, "3339": {"vr": "TM", "Value": ["095107.843000"]}, "3340": {"vr": "TM", "Value": ["094947.668000"]}, "3341": {"vr": "TM", "Value": ["095127.927000"]}, "3342": {"vr": "TM", "Value": ["095307.722000"]}, "3343": {"vr": "TM", "Value": ["095007.853000"]}, "3344": {"vr": "TM", "Value": ["094547.664000"]}, "3345": {"vr": "TM", "Value": ["095107.899000"]}, "3346": {"vr": "TM", "Value": ["095347.810000"]}, "3347": {"vr": "TM", "Value": ["094827.901000"]}, "3348": {"vr": "TM", "Value": ["094907.775000"]}, "3349": {"vr": "TM", "Value": ["095427.789000"]}, "3350": {"vr": "TM", "Value": ["094707.848000"]}, "3351": {"vr": "TM", "Value": ["094627.820000"]}, "3352": {"vr": "TM", "Value": ["094747.861000"]}, "3353": {"vr": "TM", "Value": ["095327.868000"]}, "3354": {"vr": "TM", "Value": ["094907.811000"]}, "3355": {"vr": "TM", "Value": ["095007.700000"]}, "3356": {"vr": "TM", "Value": ["095027.821000"]}, "3357": {"vr": "TM", "Value": ["094547.799000"]}, "3358": {"vr": "TM", "Value": ["094807.822000"]}, "3359": {"vr": "TM", "Value": ["095407.669000"]}, "3360": {"vr": "TM", "Value": ["095347.672000"]}, "3361": {"vr": "TM", "Value": ["094907.636000"]}, "3362": {"vr": "TM", "Value": ["094927.870000"]}, "3363": {"vr": "TM", "Value": ["095347.769000"]}, "3364": {"vr": "TM", "Value": ["095247.834000"]}, "3365": {"vr": "TM", "Value": ["095456.497000"]}, "3366": {"vr": "TM", "Value": ["095427.745000"]}, "3367": {"vr": "TM", "Value": ["095347.833000"]}, "3368": {"vr": "TM", "Value": ["094727.622000"]}, "3369": {"vr": "TM", "Value": ["095247.654000"]}, "3370": {"vr": "TM", "Value": ["095147.887000"]}, "3371": {"vr": "TM", "Value": ["094927.796000"]}, "3372": {"vr": "TM", "Value": ["095247.767000"]}, "3373": {"vr": "TM", "Value": ["095207.928000"]}, "3374": {"vr": "TM", "Value": ["095047.879000"]}, "3375": {"vr": "TM", "Value": ["095227.911000"]}, "3376": {"vr": "TM", "Value": ["094827.912000"]}, "3377": {"vr": "TM", "Value": ["095247.925000"]}, "3378": {"vr": "TM", "Value": ["094907.740000"]}, "3379": {"vr": "TM", "Value": ["095027.613000"]}, "3380": {"vr": "TM", "Value": ["094747.811000"]}, "3381": {"vr": "TM", "Value": ["095227.684000"]}, "3382": {"vr": "TM", "Value": ["095007.851000"]}, "3383": {"vr": "TM", "Value": ["094607.936000"]}, "3384": {"vr": "TM", "Value": ["095007.812000"]}, "3385": {"vr": "TM", "Value": ["094807.921000"]}, "3386": {"vr": "TM", "Value": ["095207.923000"]}, "3387": {"vr": "TM", "Value": ["095447.834000"]}, "3388": {"vr": "TM", "Value": ["094947.938000"]}, "3389": {"vr": "TM", "Value": ["095327.682000"]}, "3390": {"vr": "TM", "Value": ["095327.901000"]}, "3391": {"vr": "TM", "Value": ["094827.714000"]}, "3392": {"vr": "TM", "Value": ["094807.663000"]}, "3393": {"vr": "TM", "Value": ["095007.763000"]}, "3394": {"vr": "TM", "Value": ["094607.676000"]}, "3395": {"vr": "TM", "Value": ["095207.926000"]}, "3396": {"vr": "TM", "Value": ["094707.919000"]}, "3397": {"vr": "TM", "Value": ["094807.924000"]}, "3398": {"vr": "TM", "Value": ["094647.740000"]}, "3399": {"vr": "TM", "Value": ["095227.832000"]}, "3400": {"vr": "TM", "Value": ["095027.837000"]}, "3401": {"vr": "TM", "Value": ["095007.611000"]}, "3402": {"vr": "TM", "Value": ["095127.684000"]}, "3403": {"vr": "TM", "Value": ["094907.649000"]}, "3404": {"vr": "TM", "Value": ["094807.618000"]}, "3405": {"vr": "TM", "Value": ["095007.863000"]}, "3406": {"vr": "TM", "Value": ["095247.829000"]}, "3407": {"vr": "TM", "Value": ["094727.619000"]}, "3408": {"vr": "TM", "Value": ["094627.906000"]}, "3409": {"vr": "TM", "Value": ["095207.754000"]}, "3410": {"vr": "TM", "Value": ["095107.889000"]}, "3411": {"vr": "TM", "Value": ["095227.704000"]}, "3412": {"vr": "TM", "Value": ["095407.809000"]}, "3413": {"vr": "TM", "Value": ["095427.719000"]}, "3414": {"vr": "TM", "Value": ["095307.717000"]}, "3415": {"vr": "TM", "Value": ["095327.853000"]}, "3416": {"vr": "TM", "Value": ["094927.953000"]}, "3417": {"vr": "TM", "Value": ["095127.819000"]}, "3418": {"vr": "TM", "Value": ["094547.677000"]}, "3419": {"vr": "TM", "Value": ["095347.720000"]}, "3420": {"vr": "TM", "Value": ["094747.740000"]}, "3421": {"vr": "TM", "Value": ["094647.660000"]}, "3422": {"vr": "TM", "Value": ["095407.634000"]}, "3423": {"vr": "TM", "Value": ["095427.705000"]}, "3424": {"vr": "TM", "Value": ["095027.718000"]}, "3425": {"vr": "TM", "Value": ["095007.684000"]}, "3426": {"vr": "TM", "Value": ["095347.710000"]}, "3427": {"vr": "TM", "Value": ["095127.675000"]}, "3428": {"vr": "TM", "Value": ["094927.928000"]}, "3429": {"vr": "TM", "Value": ["094947.719000"]}, "3430": {"vr": "TM", "Value": ["095107.871000"]}, "3431": {"vr": "TM", "Value": ["095327.719000"]}, "3432": {"vr": "TM", "Value": ["094627.771000"]}, "3433": {"vr": "TM", "Value": ["094627.721000"]}, "3434": {"vr": "TM", "Value": ["095227.942000"]}, "3435": {"vr": "TM", "Value": ["095207.744000"]}, "3436": {"vr": "TM", "Value": ["095327.748000"]}, "3437": {"vr": "TM", "Value": ["095347.799000"]}, "3438": {"vr": "TM", "Value": ["094827.656000"]}, "3439": {"vr": "TM", "Value": ["095147.657000"]}, "3440": {"vr": "TM", "Value": ["095247.765000"]}, "3441": {"vr": "TM", "Value": ["095307.941000"]}, "3442": {"vr": "TM", "Value": ["095207.731000"]}, "3443": {"vr": "TM", "Value": ["095347.822000"]}, "3444": {"vr": "TM", "Value": ["095027.664000"]}, "3445": {"vr": "TM", "Value": ["094547.625000"]}, "3446": {"vr": "TM", "Value": ["094527.660000"]}, "3447": {"vr": "TM", "Value": ["095427.621000"]}, "3448": {"vr": "TM", "Value": ["094947.742000"]}, "3449": {"vr": "TM", "Value": ["094907.790000"]}, "3450": {"vr": "TM", "Value": ["095247.813000"]}, "3451": {"vr": "TM", "Value": ["095027.931000"]}, "3452": {"vr": "TM", "Value": ["094847.761000"]}, "3453": {"vr": "TM", "Value": ["094907.931000"]}, "3454": {"vr": "TM", "Value": ["094827.870000"]}, "3455": {"vr": "TM", "Value": ["094627.851000"]}, "3456": {"vr": "TM", "Value": ["094927.936000"]}, "3457": {"vr": "TM", "Value": ["095247.668000"]}, "3458": {"vr": "TM", "Value": ["095107.854000"]}, "3459": {"vr": "TM", "Value": ["095407.779000"]}, "3460": {"vr": "TM", "Value": ["095107.711000"]}, "3461": {"vr": "TM", "Value": ["094647.631000"]}, "3462": {"vr": "TM", "Value": ["094807.831000"]}, "3463": {"vr": "TM", "Value": ["095127.814000"]}, "3464": {"vr": "TM", "Value": ["095447.662000"]}, "3465": {"vr": "TM", "Value": ["095127.880000"]}, "3466": {"vr": "TM", "Value": ["094847.906000"]}, "3467": {"vr": "TM", "Value": ["095347.692000"]}, "3468": {"vr": "TM", "Value": ["094827.743000"]}, "3469": {"vr": "TM", "Value": ["094727.776000"]}, "3470": {"vr": "TM", "Value": ["095127.718000"]}, "3471": {"vr": "TM", "Value": ["095107.828000"]}, "3472": {"vr": "TM", "Value": ["095347.874000"]}, "3473": {"vr": "TM", "Value": ["094607.823000"]}, "3474": {"vr": "TM", "Value": ["094707.661000"]}, "3475": {"vr": "TM", "Value": ["094927.863000"]}, "3476": {"vr": "TM", "Value": ["094547.871000"]}, "3477": {"vr": "TM", "Value": ["094527.860000"]}, "3478": {"vr": "TM", "Value": ["095347.936000"]}, "3479": {"vr": "TM", "Value": ["095107.749000"]}, "3480": {"vr": "TM", "Value": ["094727.607000"]}, "3481": {"vr": "TM", "Value": ["095456.451000"]}, "3482": {"vr": "TM", "Value": ["095307.632000"]}, "3483": {"vr": "TM", "Value": ["095347.905000"]}, "3484": {"vr": "TM", "Value": ["095407.661000"]}, "3485": {"vr": "TM", "Value": ["095127.803000"]}, "3486": {"vr": "TM", "Value": ["095247.818000"]}, "3487": {"vr": "TM", "Value": ["095447.889000"]}, "3488": {"vr": "TM", "Value": ["094547.827000"]}, "3489": {"vr": "TM", "Value": ["095227.819000"]}, "3490": {"vr": "TM", "Value": ["094607.722000"]}, "3491": {"vr": "TM", "Value": ["095347.661000"]}, "3492": {"vr": "TM", "Value": ["094827.924000"]}, "3493": {"vr": "TM", "Value": ["095427.771000"]}, "3494": {"vr": "TM", "Value": ["095047.928000"]}, "3495": {"vr": "TM", "Value": ["095227.894000"]}, "3496": {"vr": "TM", "Value": ["094927.687000"]}, "3497": {"vr": "TM", "Value": ["095127.786000"]}, "3498": {"vr": "TM", "Value": ["095327.738000"]}, "3499": {"vr": "TM", "Value": ["094907.877000"]}, "3500": {"vr": "TM", "Value": ["095307.784000"]}, "3501": {"vr": "TM", "Value": ["095007.919000"]}, "3502": {"vr": "TM", "Value": ["095007.934000"]}, "3503": {"vr": "TM", "Value": ["095327.711000"]}, "3504": {"vr": "TM", "Value": ["094547.802000"]}, "3505": {"vr": "TM", "Value": ["094807.773000"]}, "3506": {"vr": "TM", "Value": ["094847.950000"]}, "3507": {"vr": "TM", "Value": ["095047.795000"]}, "3508": {"vr": "TM", "Value": ["095307.661000"]}, "3509": {"vr": "TM", "Value": ["095207.644000"]}, "3510": {"vr": "TM", "Value": ["095027.629000"]}, "3511": {"vr": "TM", "Value": ["094527.683000"]}, "3512": {"vr": "TM", "Value": ["094927.807000"]}, "3513": {"vr": "TM", "Value": ["095107.670000"]}, "3514": {"vr": "TM", "Value": ["095407.644000"]}, "3515": {"vr": "TM", "Value": ["095027.726000"]}, "3516": {"vr": "TM", "Value": ["094527.931000"]}, "3517": {"vr": "TM", "Value": ["095427.631000"]}, "3518": {"vr": "TM", "Value": ["094727.911000"]}, "3519": {"vr": "TM", "Value": ["095027.767000"]}, "3520": {"vr": "TM", "Value": ["095207.913000"]}, "3521": {"vr": "TM", "Value": ["095456.469000"]}, "3522": {"vr": "TM", "Value": ["094527.613000"]}, "3523": {"vr": "TM", "Value": ["095447.757000"]}, "3524": {"vr": "TM", "Value": ["095147.660000"]}, "3525": {"vr": "TM", "Value": ["095007.659000"]}, "3526": {"vr": "TM", "Value": ["094847.698000"]}, "3527": {"vr": "TM", "Value": ["095427.713000"]}, "3528": {"vr": "TM", "Value": ["094807.653000"]}, "3529": {"vr": "TM", "Value": ["095456.445000"]}, "3530": {"vr": "TM", "Value": ["094827.607000"]}, "3531": {"vr": "TM", "Value": ["094647.688000"]}, "3532": {"vr": "TM", "Value": ["094827.849000"]}, "3533": {"vr": "TM", "Value": ["094827.813000"]}, "3534": {"vr": "TM", "Value": ["095407.682000"]}, "3535": {"vr": "TM", "Value": ["095227.632000"]}, "3536": {"vr": "TM", "Value": ["094727.637000"]}, "3537": {"vr": "TM", "Value": ["094627.630000"]}, "3538": {"vr": "TM", "Value": ["095207.800000"]}, "3539": {"vr": "TM", "Value": ["095456.527000"]}, "3540": {"vr": "TM", "Value": ["095047.861000"]}, "3541": {"vr": "TM", "Value": ["095207.833000"]}, "3542": {"vr": "TM", "Value": ["094807.628000"]}, "3543": {"vr": "TM", "Value": ["094907.885000"]}, "3544": {"vr": "TM", "Value": ["094947.692000"]}, "3545": {"vr": "TM", "Value": ["094847.872000"]}, "3546": {"vr": "TM", "Value": ["095007.715000"]}, "3547": {"vr": "TM", "Value": ["094847.682000"]}, "3548": {"vr": "TM", "Value": ["095107.784000"]}, "3549": {"vr": "TM", "Value": ["094627.627000"]}, "3550": {"vr": "TM", "Value": ["095147.652000"]}, "3551": {"vr": "TM", "Value": ["094627.667000"]}, "3552": {"vr": "TM", "Value": ["095407.860000"]}, "3553": {"vr": "TM", "Value": ["094947.726000"]}, "3554": {"vr": "TM", "Value": ["094847.669000"]}, "3555": {"vr": "TM", "Value": ["094947.627000"]}, "3556": {"vr": "TM", "Value": ["094807.960000"]}, "3557": {"vr": "TM", "Value": ["094747.668000"]}, "3558": {"vr": "TM", "Value": ["094607.943000"]}, "3559": {"vr": "TM", "Value": ["095047.703000"]}, "3560": {"vr": "TM", "Value": ["094927.865000"]}, "3561": {"vr": "TM", "Value": ["095247.684000"]}, "3562": {"vr": "TM", "Value": ["094907.834000"]}, "3563": {"vr": "TM", "Value": ["095227.701000"]}, "3564": {"vr": "TM", "Value": ["094927.623000"]}, "3565": {"vr": "TM", "Value": ["095327.654000"]}, "3566": {"vr": "TM", "Value": ["095047.721000"]}, "3567": {"vr": "TM", "Value": ["094607.918000"]}, "3568": {"vr": "TM", "Value": ["094527.965000"]}, "3569": {"vr": "TM", "Value": ["094707.930000"]}, "3570": {"vr": "TM", "Value": ["094827.794000"]}, "3571": {"vr": "TM", "Value": ["094607.656000"]}, "3572": {"vr": "TM", "Value": ["095047.705000"]}, "3573": {"vr": "TM", "Value": ["094547.864000"]}, "3574": {"vr": "TM", "Value": ["094627.805000"]}, "3575": {"vr": "TM", "Value": ["094707.663000"]}, "3576": {"vr": "TM", "Value": ["095147.684000"]}, "3577": {"vr": "TM", "Value": ["094947.711000"]}, "3578": {"vr": "TM", "Value": ["094647.825000"]}, "3579": {"vr": "TM", "Value": ["095007.677000"]}, "3580": {"vr": "TM", "Value": ["095427.784000"]}, "3581": {"vr": "TM", "Value": ["095307.802000"]}, "3582": {"vr": "TM", "Value": ["095027.754000"]}, "3583": {"vr": "TM", "Value": ["095447.839000"]}, "3584": {"vr": "TM", "Value": ["094707.813000"]}, "3585": {"vr": "TM", "Value": ["095047.700000"]}, "3586": {"vr": "TM", "Value": ["095347.953000"]}, "3587": {"vr": "TM", "Value": ["095347.835000"]}, "3588": {"vr": "TM", "Value": ["094907.760000"]}, "3589": {"vr": "TM", "Value": ["095327.721000"]}, "3590": {"vr": "TM", "Value": ["094847.766000"]}, "3591": {"vr": "TM", "Value": ["095307.673000"]}, "3592": {"vr": "TM", "Value": ["094907.866000"]}, "3593": {"vr": "TM", "Value": ["095307.907000"]}, "3594": {"vr": "TM", "Value": ["095247.760000"]}, "3595": {"vr": "TM", "Value": ["094727.815000"]}, "3596": {"vr": "TM", "Value": ["094827.899000"]}, "3597": {"vr": "TM", "Value": ["094747.628000"]}, "3598": {"vr": "TM", "Value": ["094827.934000"]}, "3599": {"vr": "TM", "Value": ["094547.761000"]}, "3600": {"vr": "TM", "Value": ["095127.911000"]}, "3601": {"vr": "TM", "Value": ["095227.934000"]}, "3602": {"vr": "TM", "Value": ["094947.730000"]}, "3603": {"vr": "TM", "Value": ["094827.675000"]}, "3604": {"vr": "TM", "Value": ["094907.874000"]}, "3605": {"vr": "TM", "Value": ["094927.827000"]}, "3606": {"vr": "TM", "Value": ["095047.618000"]}, "3607": {"vr": "TM", "Value": ["095447.652000"]}, "3608": {"vr": "TM", "Value": ["094727.954000"]}, "3609": {"vr": "TM", "Value": ["095407.651000"]}, "3610": {"vr": "TM", "Value": ["095327.680000"]}, "3611": {"vr": "TM", "Value": ["094607.773000"]}, "3612": {"vr": "TM", "Value": ["095027.627000"]}, "3613": {"vr": "TM", "Value": ["095247.689000"]}, "3614": {"vr": "TM", "Value": ["095327.666000"]}, "3615": {"vr": "TM", "Value": ["094627.746000"]}, "3616": {"vr": "TM", "Value": ["094947.685000"]}, "3617": {"vr": "TM", "Value": ["094707.707000"]}, "3618": {"vr": "TM", "Value": ["094627.714000"]}, "3619": {"vr": "TM", "Value": ["094527.972000"]}, "3620": {"vr": "TM", "Value": ["094807.817000"]}, "3621": {"vr": "TM", "Value": ["094847.688000"]}, "3622": {"vr": "TM", "Value": ["094607.768000"]}, "3623": {"vr": "TM", "Value": ["094647.870000"]}, "3624": {"vr": "TM", "Value": ["095447.806000"]}, "3625": {"vr": "TM", "Value": ["095447.703000"]}, "3626": {"vr": "TM", "Value": ["094927.783000"]}, "3627": {"vr": "TM", "Value": ["095347.804000"]}, "3628": {"vr": "TM", "Value": ["095147.852000"]}, "3629": {"vr": "TM", "Value": ["094547.950000"]}, "3630": {"vr": "TM", "Value": ["095347.912000"]}, "3631": {"vr": "TM", "Value": ["095407.880000"]}, "3632": {"vr": "TM", "Value": ["094747.638000"]}, "3633": {"vr": "TM", "Value": ["095227.650000"]}, "3634": {"vr": "TM", "Value": ["095407.632000"]}, "3635": {"vr": "TM", "Value": ["094927.649000"]}, "3636": {"vr": "TM", "Value": ["095447.778000"]}, "3637": {"vr": "TM", "Value": ["094547.910000"]}, "3638": {"vr": "TM", "Value": ["094647.975000"]}, "3639": {"vr": "TM", "Value": ["095427.941000"]}, "3640": {"vr": "TM", "Value": ["095007.817000"]}, "3641": {"vr": "TM", "Value": ["094847.816000"]}, "3642": {"vr": "TM", "Value": ["095427.918000"]}, "3643": {"vr": "TM", "Value": ["094947.739000"]}, "3644": {"vr": "TM", "Value": ["095107.896000"]}, "3645": {"vr": "TM", "Value": ["094627.896000"]}, "3646": {"vr": "TM", "Value": ["094707.925000"]}, "3647": {"vr": "TM", "Value": ["095247.731000"]}, "3648": {"vr": "TM", "Value": ["095227.719000"]}, "3649": {"vr": "TM", "Value": ["095027.667000"]}, "3650": {"vr": "TM", "Value": ["094907.639000"]}, "3651": {"vr": "TM", "Value": ["094807.785000"]}, "3652": {"vr": "TM", "Value": ["095027.816000"]}, "3653": {"vr": "TM", "Value": ["095327.784000"]}, "3654": {"vr": "TM", "Value": ["095007.856000"]}, "3655": {"vr": "TM", "Value": ["094707.709000"]}, "3656": {"vr": "TM", "Value": ["095147.877000"]}, "3657": {"vr": "TM", "Value": ["095407.877000"]}, "3658": {"vr": "TM", "Value": ["094607.807000"]}, "3659": {"vr": "TM", "Value": ["095407.911000"]}, "3660": {"vr": "TM", "Value": ["094627.955000"]}, "3661": {"vr": "TM", "Value": ["094747.610000"]}, "3662": {"vr": "TM", "Value": ["095347.669000"]}, "3663": {"vr": "TM", "Value": ["095347.723000"]}, "3664": {"vr": "TM", "Value": ["094627.904000"]}, "3665": {"vr": "TM", "Value": ["094727.957000"]}, "3666": {"vr": "TM", "Value": ["095227.791000"]}, "3667": {"vr": "TM", "Value": ["094927.825000"]}, "3668": {"vr": "TM", "Value": ["094707.619000"]}, "3669": {"vr": "TM", "Value": ["094807.728000"]}, "3670": {"vr": "TM", "Value": ["094807.641000"]}, "3671": {"vr": "TM", "Value": ["094947.787000"]}, "3672": {"vr": "TM", "Value": ["094547.908000"]}, "3673": {"vr": "TM", "Value": ["095456.534000"]}, "3674": {"vr": "TM", "Value": ["094627.738000"]}, "3675": {"vr": "TM", "Value": ["094907.681000"]}, "3676": {"vr": "TM", "Value": ["095227.765000"]}, "3677": {"vr": "TM", "Value": ["094607.928000"]}, "3678": {"vr": "TM", "Value": ["095227.689000"]}, "3679": {"vr": "TM", "Value": ["095227.755000"]}, "3680": {"vr": "TM", "Value": ["095127.917000"]}, "3681": {"vr": "TM", "Value": ["094707.697000"]}, "3682": {"vr": "TM", "Value": ["094807.790000"]}, "3683": {"vr": "TM", "Value": ["094947.827000"]}, "3684": {"vr": "TM", "Value": ["094627.894000"]}, "3685": {"vr": "TM", "Value": ["095207.849000"]}, "3686": {"vr": "TM", "Value": ["094847.768000"]}, "3687": {"vr": "TM", "Value": ["095147.779000"]}, "3688": {"vr": "TM", "Value": ["095107.718000"]}, "3689": {"vr": "TM", "Value": ["095247.630000"]}, "3690": {"vr": "TM", "Value": ["094547.741000"]}, "3691": {"vr": "TM", "Value": ["094847.735000"]}, "3692": {"vr": "TM", "Value": ["094607.851000"]}, "3693": {"vr": "TM", "Value": ["095047.666000"]}, "3694": {"vr": "TM", "Value": ["095427.642000"]}, "3695": {"vr": "TM", "Value": ["094627.640000"]}, "3696": {"vr": "TM", "Value": ["095007.798000"]}, "3697": {"vr": "TM", "Value": ["094907.829000"]}, "3698": {"vr": "TM", "Value": ["094647.946000"]}, "3699": {"vr": "TM", "Value": ["094807.918000"]}, "3700": {"vr": "TM", "Value": ["095447.719000"]}, "3701": {"vr": "TM", "Value": ["094647.695000"]}, "3702": {"vr": "TM", "Value": ["094747.726000"]}, "3703": {"vr": "TM", "Value": ["095427.860000"]}, "3704": {"vr": "TM", "Value": ["095147.928000"]}, "3705": {"vr": "TM", "Value": ["094607.843000"]}, "3706": {"vr": "TM", "Value": ["095047.902000"]}, "3707": {"vr": "TM", "Value": ["094707.868000"]}, "3708": {"vr": "TM", "Value": ["095227.732000"]}, "3709": {"vr": "TM", "Value": ["094827.699000"]}, "3710": {"vr": "TM", "Value": ["095247.722000"]}, "3711": {"vr": "TM", "Value": ["095327.835000"]}, "3712": {"vr": "TM", "Value": ["094907.716000"]}, "3713": {"vr": "TM", "Value": ["094527.941000"]}, "3714": {"vr": "TM", "Value": ["095427.894000"]}, "3715": {"vr": "TM", "Value": ["095047.833000"]}, "3716": {"vr": "TM", "Value": ["095147.784000"]}, "3717": {"vr": "TM", "Value": ["095427.609000"]}, "3718": {"vr": "TM", "Value": ["095347.746000"]}, "3719": {"vr": "TM", "Value": ["094607.765000"]}, "3720": {"vr": "TM", "Value": ["095247.870000"]}, "3721": {"vr": "TM", "Value": ["094947.880000"]}, "3722": {"vr": "TM", "Value": ["094907.796000"]}, "3723": {"vr": "TM", "Value": ["094827.907000"]}, "3724": {"vr": "TM", "Value": ["094727.743000"]}, "3725": {"vr": "TM", "Value": ["094647.769000"]}, "3726": {"vr": "TM", "Value": ["095227.627000"]}, "3727": {"vr": "TM", "Value": ["095047.876000"]}, "3728": {"vr": "TM", "Value": ["095207.646000"]}, "3729": {"vr": "TM", "Value": ["095327.692000"]}, "3730": {"vr": "TM", "Value": ["094627.660000"]}, "3731": {"vr": "TM", "Value": ["095127.691000"]}, "3732": {"vr": "TM", "Value": ["094707.907000"]}, "3733": {"vr": "TM", "Value": ["094547.684000"]}, "3734": {"vr": "TM", "Value": ["095427.626000"]}, "3735": {"vr": "TM", "Value": ["095327.804000"]}, "3736": {"vr": "TM", "Value": ["095407.751000"]}, "3737": {"vr": "TM", "Value": ["094847.928000"]}, "3738": {"vr": "TM", "Value": ["095447.632000"]}, "3739": {"vr": "TM", "Value": ["095047.830000"]}, "3740": {"vr": "TM", "Value": ["094807.885000"]}, "3741": {"vr": "TM", "Value": ["095127.811000"]}, "3742": {"vr": "TM", "Value": ["095007.795000"]}, "3743": {"vr": "TM", "Value": ["095247.644000"]}, "3744": {"vr": "TM", "Value": ["094527.732000"]}, "3745": {"vr": "TM", "Value": ["094547.618000"]}, "3746": {"vr": "TM", "Value": ["094807.687000"]}, "3747": {"vr": "TM", "Value": ["095407.776000"]}, "3748": {"vr": "TM", "Value": ["095347.850000"]}, "3749": {"vr": "TM", "Value": ["094827.750000"]}, "3750": {"vr": "TM", "Value": ["094847.847000"]}, "3751": {"vr": "TM", "Value": ["094807.807000"]}, "3752": {"vr": "TM", "Value": ["094807.848000"]}, "3753": {"vr": "TM", "Value": ["094947.640000"]}, "3754": {"vr": "TM", "Value": ["095007.664000"]}, "3755": {"vr": "TM", "Value": ["095027.703000"]}, "3756": {"vr": "TM", "Value": ["095147.736000"]}, "3757": {"vr": "TM", "Value": ["094627.950000"]}, "3758": {"vr": "TM", "Value": ["095327.871000"]}, "3759": {"vr": "TM", "Value": ["094927.883000"]}, "3760": {"vr": "TM", "Value": ["094647.707000"]}, "3761": {"vr": "TM", "Value": ["094927.684000"]}, "3762": {"vr": "TM", "Value": ["094607.651000"]}, "3763": {"vr": "TM", "Value": ["095147.833000"]}, "3764": {"vr": "TM", "Value": ["095107.665000"]}, "3765": {"vr": "TM", "Value": ["095447.858000"]}, "3766": {"vr": "TM", "Value": ["094947.867000"]}, "3767": {"vr": "TM", "Value": ["095127.832000"]}, "3768": {"vr": "TM", "Value": ["095327.891000"]}, "3769": {"vr": "TM", "Value": ["094647.899000"]}, "3770": {"vr": "TM", "Value": ["094747.633000"]}, "3771": {"vr": "TM", "Value": ["095447.608000"]}, "3772": {"vr": "TM", "Value": ["095027.625000"]}, "3773": {"vr": "TM", "Value": ["095327.613000"]}, "3774": {"vr": "TM", "Value": ["094927.830000"]}, "3775": {"vr": "TM", "Value": ["095107.894000"]}, "3776": {"vr": "TM", "Value": ["094527.925000"]}, "3777": {"vr": "TM", "Value": ["095027.646000"]}, "3778": {"vr": "TM", "Value": ["094607.700000"]}, "3779": {"vr": "TM", "Value": ["094847.654000"]}, "3780": {"vr": "TM", "Value": ["094607.661000"]}, "3781": {"vr": "TM", "Value": ["095347.728000"]}, "3782": {"vr": "TM", "Value": ["094647.655000"]}, "3783": {"vr": "TM", "Value": ["094647.838000"]}, "3784": {"vr": "TM", "Value": ["095447.786000"]}, "3785": {"vr": "TM", "Value": ["094647.910000"]}, "3786": {"vr": "TM", "Value": ["095027.721000"]}, "3787": {"vr": "TM", "Value": ["094527.890000"]}, "3788": {"vr": "TM", "Value": ["094707.612000"]}, "3789": {"vr": "TM", "Value": ["095307.776000"]}, "3790": {"vr": "TM", "Value": ["094707.735000"]}, "3791": {"vr": "TM", "Value": ["094627.853000"]}, "3792": {"vr": "TM", "Value": ["094747.693000"]}, "3793": {"vr": "TM", "Value": ["094947.716000"]}, "3794": {"vr": "TM", "Value": ["094527.938000"]}, "3795": {"vr": "TM", "Value": ["095147.789000"]}, "3796": {"vr": "TM", "Value": ["095427.819000"]}, "3797": {"vr": "TM", "Value": ["094747.858000"]}, "3798": {"vr": "TM", "Value": ["095147.679000"]}, "3799": {"vr": "TM", "Value": ["094747.737000"]}, "3800": {"vr": "TM", "Value": ["095427.635000"]}, "3801": {"vr": "TM", "Value": ["094947.721000"]}, "3802": {"vr": "TM", "Value": ["095407.671000"]}, "3803": {"vr": "TM", "Value": ["094647.772000"]}, "3804": {"vr": "TM", "Value": ["095127.872000"]}, "3805": {"vr": "TM", "Value": ["095147.787000"]}, "3806": {"vr": "TM", "Value": ["095147.859000"]}, "3807": {"vr": "TM", "Value": ["095307.702000"]}, "3808": {"vr": "TM", "Value": ["095427.716000"]}, "3809": {"vr": "TM", "Value": ["094707.768000"]}, "3810": {"vr": "TM", "Value": ["095327.917000"]}, "3811": {"vr": "TM", "Value": ["095227.897000"]}, "3812": {"vr": "TM", "Value": ["095447.832000"]}, "3813": {"vr": "TM", "Value": ["095227.610000"]}, "3814": {"vr": "TM", "Value": ["094847.938000"]}, "3815": {"vr": "TM", "Value": ["095107.906000"]}, "3816": {"vr": "TM", "Value": ["095207.721000"]}, "3817": {"vr": "TM", "Value": ["095207.608000"]}, "3818": {"vr": "TM", "Value": ["094647.851000"]}, "3819": {"vr": "TM", "Value": ["094827.776000"]}, "3820": {"vr": "TM", "Value": ["095127.929000"]}, "3821": {"vr": "TM", "Value": ["095047.931000"]}, "3822": {"vr": "TM", "Value": ["095427.778000"]}, "3823": {"vr": "TM", "Value": ["095207.882000"]}, "3824": {"vr": "TM", "Value": ["095447.909000"]}, "3825": {"vr": "TM", "Value": ["094827.865000"]}, "3826": {"vr": "TM", "Value": ["094547.876000"]}, "3827": {"vr": "TM", "Value": ["095027.887000"]}, "3828": {"vr": "TM", "Value": ["094827.701000"]}, "3829": {"vr": "TM", "Value": ["095307.910000"]}, "3830": {"vr": "TM", "Value": ["094907.848000"]}, "3831": {"vr": "TM", "Value": ["095107.663000"]}, "3832": {"vr": "TM", "Value": ["095007.896000"]}, "3833": {"vr": "TM", "Value": ["094947.704000"]}, "3834": {"vr": "TM", "Value": ["094607.784000"]}, "3835": {"vr": "TM", "Value": ["095407.708000"]}, "3836": {"vr": "TM", "Value": ["095227.786000"]}, "3837": {"vr": "TM", "Value": ["094727.847000"]}, "3838": {"vr": "TM", "Value": ["094527.783000"]}, "3839": {"vr": "TM", "Value": ["094527.793000"]}, "3840": {"vr": "TM", "Value": ["095307.725000"]}, "3841": {"vr": "TM", "Value": ["094707.784000"]}, "3842": {"vr": "TM", "Value": ["094607.663000"]}, "3843": {"vr": "TM", "Value": ["095107.819000"]}, "3844": {"vr": "TM", "Value": ["094707.770000"]}, "3845": {"vr": "TM", "Value": ["094827.889000"]}, "3846": {"vr": "TM", "Value": ["095207.846000"]}, "3847": {"vr": "TM", "Value": ["095127.893000"]}, "3848": {"vr": "TM", "Value": ["095147.610000"]}, "3849": {"vr": "TM", "Value": ["095427.659000"]}, "3850": {"vr": "TM", "Value": ["095027.731000"]}, "3851": {"vr": "TM", "Value": ["095207.815000"]}, "3852": {"vr": "TM", "Value": ["094727.645000"]}, "3853": {"vr": "TM", "Value": ["094607.649000"]}, "3854": {"vr": "TM", "Value": ["094847.790000"]}, "3855": {"vr": "TM", "Value": ["095456.466000"]}, "3856": {"vr": "TM", "Value": ["094547.654000"]}, "3857": {"vr": "TM", "Value": ["094707.909000"]}, "3858": {"vr": "TM", "Value": ["094547.622000"]}, "3859": {"vr": "TM", "Value": ["095027.943000"]}, "3860": {"vr": "TM", "Value": ["094727.844000"]}, "3861": {"vr": "TM", "Value": ["094947.925000"]}, "3862": {"vr": "TM", "Value": ["094747.848000"]}, "3863": {"vr": "TM", "Value": ["095327.670000"]}, "3864": {"vr": "TM", "Value": ["094907.651000"]}, "3865": {"vr": "TM", "Value": ["095107.903000"]}, "3866": {"vr": "TM", "Value": ["094927.951000"]}, "3867": {"vr": "TM", "Value": ["094607.926000"]}, "3868": {"vr": "TM", "Value": ["094707.732000"]}, "3869": {"vr": "TM", "Value": ["095247.680000"]}, "3870": {"vr": "TM", "Value": ["095447.657000"]}, "3871": {"vr": "TM", "Value": ["095347.659000"]}, "3872": {"vr": "TM", "Value": ["094607.903000"]}, "3873": {"vr": "TM", "Value": ["095307.715000"]}, "3874": {"vr": "TM", "Value": ["095147.712000"]}, "3875": {"vr": "TM", "Value": ["095407.845000"]}, "3876": {"vr": "TM", "Value": ["094747.790000"]}, "3877": {"vr": "TM", "Value": ["095407.725000"]}, "3878": {"vr": "TM", "Value": ["095327.750000"]}, "3879": {"vr": "TM", "Value": ["094727.852000"]}, "3880": {"vr": "TM", "Value": ["095207.757000"]}, "3881": {"vr": "TM", "Value": ["094907.733000"]}, "3882": {"vr": "TM", "Value": ["095147.861000"]}, "3883": {"vr": "TM", "Value": ["094927.878000"]}, "3884": {"vr": "TM", "Value": ["095007.936000"]}, "3885": {"vr": "TM", "Value": ["094647.982000"]}, "3886": {"vr": "TM", "Value": ["095307.936000"]}, "3887": {"vr": "TM", "Value": ["095027.854000"]}, "3888": {"vr": "TM", "Value": ["094807.846000"]}, "3889": {"vr": "TM", "Value": ["094547.789000"]}, "3890": {"vr": "TM", "Value": ["094927.773000"]}, "3891": {"vr": "TM", "Value": ["095107.923000"]}, "3892": {"vr": "TM", "Value": ["095427.698000"]}, "3893": {"vr": "TM", "Value": ["095147.943000"]}, "3894": {"vr": "TM", "Value": ["094607.611000"]}, "3895": {"vr": "TM", "Value": ["094747.641000"]}, "3896": {"vr": "TM", "Value": ["095427.799000"]}, "3897": {"vr": "TM", "Value": ["095347.781000"]}, "3898": {"vr": "TM", "Value": ["095107.798000"]}, "3899": {"vr": "TM", "Value": ["095207.854000"]}, "3900": {"vr": "TM", "Value": ["094647.965000"]}, "3901": {"vr": "TM", "Value": ["095307.615000"]}, "3902": {"vr": "TM", "Value": ["095027.875000"]}, "3903": {"vr": "TM", "Value": ["095227.887000"]}, "3904": {"vr": "TM", "Value": ["094947.922000"]}, "3905": {"vr": "TM", "Value": ["095447.677000"]}, "3906": {"vr": "TM", "Value": ["095047.715000"]}, "3907": {"vr": "TM", "Value": ["095347.866000"]}, "3908": {"vr": "TM", "Value": ["094807.843000"]}, "3909": {"vr": "TM", "Value": ["094647.801000"]}, "3910": {"vr": "TM", "Value": ["094607.621000"]}, "3911": {"vr": "TM", "Value": ["094847.859000"]}, "3912": {"vr": "TM", "Value": ["095407.885000"]}, "3913": {"vr": "TM", "Value": ["094927.817000"]}, "3914": {"vr": "TM", "Value": ["095107.620000"]}, "3915": {"vr": "TM", "Value": ["094527.963000"]}, "3916": {"vr": "TM", "Value": ["094827.904000"]}, "3917": {"vr": "TM", "Value": ["094607.901000"]}, "3918": {"vr": "TM", "Value": ["095007.644000"]}, "3919": {"vr": "TM", "Value": ["094927.642000"]}, "3920": {"vr": "TM", "Value": ["094807.623000"]}, "3921": {"vr": "TM", "Value": ["095327.848000"]}, "3922": {"vr": "TM", "Value": ["095427.850000"]}, "3923": {"vr": "TM", "Value": ["094647.649000"]}, "3924": {"vr": "TM", "Value": ["094527.975000"]}, "3925": {"vr": "TM", "Value": ["094807.705000"]}, "3926": {"vr": "TM", "Value": ["095227.635000"]}, "3927": {"vr": "TM", "Value": ["095227.844000"]}, "3928": {"vr": "TM", "Value": ["095007.872000"]}, "3929": {"vr": "TM", "Value": ["095307.915000"]}, "3930": {"vr": "TM", "Value": ["095247.651000"]}, "3931": {"vr": "TM", "Value": ["094947.915000"]}, "3932": {"vr": "TM", "Value": ["095147.920000"]}, "3933": {"vr": "TM", "Value": ["095347.920000"]}, "3934": {"vr": "TM", "Value": ["095027.902000"]}, "3935": {"vr": "TM", "Value": ["095347.899000"]}, "3936": {"vr": "TM", "Value": ["095047.656000"]}, "3937": {"vr": "TM", "Value": ["095147.806000"]}, "3938": {"vr": "TM", "Value": ["095427.791000"]}, "3939": {"vr": "TM", "Value": ["094647.894000"]}, "3940": {"vr": "TM", "Value": ["094907.952000"]}, "3941": {"vr": "TM", "Value": ["095347.638000"]}, "3942": {"vr": "TM", "Value": ["095207.877000"]}, "3943": {"vr": "TM", "Value": ["095427.612000"]}, "3944": {"vr": "TM", "Value": ["095047.853000"]}, "3945": {"vr": "TM", "Value": ["094827.927000"]}, "3946": {"vr": "TM", "Value": ["095427.624000"]}, "3947": {"vr": "TM", "Value": ["094647.897000"]}, "3948": {"vr": "TM", "Value": ["094827.706000"]}, "3949": {"vr": "TM", "Value": ["095347.961000"]}, "3950": {"vr": "TM", "Value": ["095127.663000"]}, "3951": {"vr": "TM", "Value": ["094907.646000"]}, "3952": {"vr": "TM", "Value": ["095027.895000"]}, "3953": {"vr": "TM", "Value": ["095047.664000"]}, "3954": {"vr": "TM", "Value": ["094627.719000"]}, "3955": {"vr": "TM", "Value": ["095447.916000"]}, "3956": {"vr": "TM", "Value": ["095027.741000"]}, "3957": {"vr": "TM", "Value": ["095007.730000"]}, "3958": {"vr": "TM", "Value": ["094847.693000"]}, "3959": {"vr": "TM", "Value": ["095347.845000"]}, "3960": {"vr": "TM", "Value": ["095147.705000"]}, "3961": {"vr": "TM", "Value": ["095207.897000"]}, "3962": {"vr": "TM", "Value": ["095327.608000"]}, "3963": {"vr": "TM", "Value": ["094727.758000"]}, "3964": {"vr": "TM", "Value": ["095207.693000"]}, "3965": {"vr": "TM", "Value": ["095447.750000"]}, "3966": {"vr": "TM", "Value": ["094707.758000"]}, "3967": {"vr": "TM", "Value": ["094907.803000"]}, "3968": {"vr": "TM", "Value": ["094707.659000"]}, "3969": {"vr": "TM", "Value": ["094607.659000"]}, "3970": {"vr": "TM", "Value": ["094947.635000"]}, "3971": {"vr": "TM", "Value": ["094607.879000"]}, "3972": {"vr": "TM", "Value": ["095247.677000"]}, "3973": {"vr": "TM", "Value": ["094907.735000"]}, "3974": {"vr": "TM", "Value": ["094807.800000"]}, "3975": {"vr": "TM", "Value": ["095247.915000"]}, "3976": {"vr": "TM", "Value": ["094547.682000"]}, "3977": {"vr": "TM", "Value": ["094627.942000"]}, "3978": {"vr": "TM", "Value": ["095447.637000"]}, "3979": {"vr": "TM", "Value": ["094927.799000"]}, "3980": {"vr": "TM", "Value": ["094647.822000"]}, "3981": {"vr": "TM", "Value": ["095227.625000"]}, "3982": {"vr": "TM", "Value": ["094947.933000"]}, "3983": {"vr": "TM", "Value": ["094547.809000"]}, "3984": {"vr": "TM", "Value": ["094747.874000"]}, "3985": {"vr": "TM", "Value": ["095047.936000"]}, "3986": {"vr": "TM", "Value": ["095427.825000"]}, "3987": {"vr": "TM", "Value": ["094907.939000"]}, "3988": {"vr": "TM", "Value": ["095007.608000"]}, "3989": {"vr": "TM", "Value": ["094847.845000"]}, "3990": {"vr": "TM", "Value": ["095047.744000"]}, "3991": {"vr": "TM", "Value": ["095047.835000"]}, "3992": {"vr": "TM", "Value": ["095427.812000"]}, "3993": {"vr": "TM", "Value": ["095347.690000"]}, "3994": {"vr": "TM", "Value": ["094947.766000"]}, "3995": {"vr": "TM", "Value": ["094707.704000"]}, "3996": {"vr": "TM", "Value": ["094607.752000"]}, "3997": {"vr": "TM", "Value": ["095347.838000"]}, "3998": {"vr": "TM", "Value": ["094947.752000"]}, "3999": {"vr": "TM", "Value": ["095227.613000"]}, "4000": {"vr": "TM", "Value": ["095407.637000"]}, "4001": {"vr": "TM", "Value": ["095207.887000"]}, "4002": {"vr": "TM", "Value": ["095247.777000"]}, "4003": {"vr": "TM", "Value": ["094847.711000"]}, "4004": {"vr": "TM", "Value": ["095347.718000"]}, "4005": {"vr": "TM", "Value": ["094727.849000"]}, "4006": {"vr": "TM", "Value": ["094627.699000"]}, "4007": {"vr": "TM", "Value": ["095107.759000"]}, "4008": {"vr": "TM", "Value": ["094727.683000"]}, "4009": {"vr": "TM", "Value": ["095007.786000"]}, "4010": {"vr": "TM", "Value": ["095027.649000"]}, "4011": {"vr": "TM", "Value": ["094647.985000"]}, "4012": {"vr": "TM", "Value": ["095307.763000"]}, "4013": {"vr": "TM", "Value": ["094647.796000"]}, "4014": {"vr": "TM", "Value": ["094827.696000"]}, "4015": {"vr": "TM", "Value": ["095407.883000"]}, "4016": {"vr": "TM", "Value": ["095407.630000"]}, "4017": {"vr": "TM", "Value": ["094947.920000"]}, "4018": {"vr": "TM", "Value": ["095247.628000"]}, "4019": {"vr": "TM", "Value": ["095107.747000"]}}, "00180024": {"0": {"vr": "SH", "Value": ["*ep_b3000#22"]}, "1": {"vr": "SH", "Value": ["*ep_b3000#30"]}, "2": {"vr": "SH", "Value": ["*ep_b3000#43"]}, "3": {"vr": "SH", "Value": ["*ep_b0"]}, "4": {"vr": "SH", "Value": ["*ep_b3000#40"]}, "5": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "6": {"vr": "SH", "Value": ["*ep_b3000#55"]}, "7": {"vr": "SH", "Value": ["*ep_b3000#57"]}, "8": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "9": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "10": {"vr": "SH", "Value": ["*ep_b3000#54"]}, "11": {"vr": "SH", "Value": ["*ep_b3000#25"]}, "12": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "13": {"vr": "SH", "Value": ["*ep_b0"]}, "14": {"vr": "SH", "Value": ["*ep_b0"]}, "15": {"vr": "SH", "Value": ["*ep_b3000#46"]}, "16": {"vr": "SH", "Value": ["*ep_b3000#53"]}, "17": {"vr": "SH", "Value": ["*ep_b3000#7"]}, "18": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "19": {"vr": "SH", "Value": ["*ep_b3000#47"]}, "20": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "21": {"vr": "SH", "Value": ["*ep_b3000#48"]}, "22": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "23": {"vr": "SH", "Value": ["*ep_b3000#60"]}, "24": {"vr": "SH", "Value": ["*ep_b3000#49"]}, "25": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "26": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "27": {"vr": "SH", "Value": ["*ep_b3000#16"]}, "28": {"vr": "SH", "Value": ["*ep_b3000#19"]}, "29": {"vr": "SH", "Value": ["*ep_b3000#46"]}, "30": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "31": {"vr": "SH", "Value": ["*ep_b0"]}, "32": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "33": {"vr": "SH", "Value": ["*ep_b3000#18"]}, "34": {"vr": "SH", "Value": ["*ep_b0"]}, "35": {"vr": "SH", "Value": ["*ep_b0"]}, "36": {"vr": "SH", "Value": ["*ep_b3000#11"]}, "37": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "38": {"vr": "SH", "Value": ["*ep_b3000#41"]}, "39": {"vr": "SH", "Value": ["*ep_b3000#29"]}, "40": {"vr": "SH", "Value": ["*ep_b0"]}, "41": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "42": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "43": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "44": {"vr": "SH", "Value": ["*ep_b3000#53"]}, "45": {"vr": "SH", "Value": ["*ep_b3000#8"]}, "46": {"vr": "SH", "Value": ["*ep_b3000#54"]}, "47": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "48": {"vr": "SH", "Value": ["*ep_b3000#28"]}, "49": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "50": {"vr": "SH", "Value": ["*ep_b3000#51"]}, "51": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "52": {"vr": "SH", "Value": ["*ep_b3000#53"]}, "53": {"vr": "SH", "Value": ["*ep_b3000#22"]}, "54": {"vr": "SH", "Value": ["*ep_b3000#10"]}, "55": {"vr": "SH", "Value": ["*ep_b3000#26"]}, "56": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "57": {"vr": "SH", "Value": ["*ep_b3000#28"]}, "58": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "59": {"vr": "SH", "Value": ["*ep_b3000#17"]}, "60": {"vr": "SH", "Value": ["*ep_b0"]}, "61": {"vr": "SH", "Value": ["*ep_b0"]}, "62": {"vr": "SH", "Value": ["*ep_b3000#22"]}, "63": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "64": {"vr": "SH", "Value": ["*ep_b3000#38"]}, "65": {"vr": "SH", "Value": ["*ep_b3000#66"]}, "66": {"vr": "SH", "Value": ["*ep_b3000#22"]}, "67": {"vr": "SH", "Value": ["*ep_b3000#25"]}, "68": {"vr": "SH", "Value": ["*ep_b0"]}, "69": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "70": {"vr": "SH", "Value": ["*ep_b3000#10"]}, "71": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "72": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "73": {"vr": "SH", "Value": ["*ep_b3000#48"]}, "74": {"vr": "SH", "Value": ["*ep_b3000#7"]}, "75": {"vr": "SH", "Value": ["*ep_b3000#62"]}, "76": {"vr": "SH", "Value": ["*ep_b3000#48"]}, "77": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "78": {"vr": "SH", "Value": ["*ep_b3000#46"]}, "79": {"vr": "SH", "Value": ["*ep_b3000#18"]}, "80": {"vr": "SH", "Value": ["*ep_b0"]}, "81": {"vr": "SH", "Value": ["*ep_b3000#7"]}, "82": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "83": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "84": {"vr": "SH", "Value": ["*ep_b3000#2"]}, "85": {"vr": "SH", "Value": ["*ep_b3000#46"]}, "86": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "87": {"vr": "SH", "Value": ["*ep_b3000#48"]}, "88": {"vr": "SH", "Value": ["*ep_b3000#28"]}, "89": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "90": {"vr": "SH", "Value": ["*ep_b0"]}, "91": {"vr": "SH", "Value": ["*ep_b0"]}, "92": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "93": {"vr": "SH", "Value": ["*ep_b3000#10"]}, "94": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "95": {"vr": "SH", "Value": ["*ep_b3000#16"]}, "96": {"vr": "SH", "Value": ["*ep_b3000#17"]}, "97": {"vr": "SH", "Value": ["*ep_b3000#66"]}, "98": {"vr": "SH", "Value": ["*ep_b3000#2"]}, "99": {"vr": "SH", "Value": ["*ep_b3000#2"]}, "100": {"vr": "SH", "Value": ["*ep_b3000#8"]}, "101": {"vr": "SH", "Value": ["*ep_b3000#26"]}, "102": {"vr": "SH", "Value": ["*ep_b3000#9"]}, "103": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "104": {"vr": "SH", "Value": ["*ep_b3000#54"]}, "105": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "106": {"vr": "SH", "Value": ["*ep_b3000#49"]}, "107": {"vr": "SH", "Value": ["*ep_b3000#58"]}, "108": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "109": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "110": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "111": {"vr": "SH", "Value": ["*ep_b3000#54"]}, "112": {"vr": "SH", "Value": ["*ep_b0"]}, "113": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "114": {"vr": "SH", "Value": ["*ep_b0"]}, "115": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "116": {"vr": "SH", "Value": ["*ep_b3000#55"]}, "117": {"vr": "SH", "Value": ["*ep_b3000#14"]}, "118": {"vr": "SH", "Value": ["*ep_b3000#44"]}, "119": {"vr": "SH", "Value": ["*ep_b3000#66"]}, "120": {"vr": "SH", "Value": ["*ep_b3000#5"]}, "121": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "122": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "123": {"vr": "SH", "Value": ["*ep_b3000#2"]}, "124": {"vr": "SH", "Value": ["*ep_b3000#49"]}, "125": {"vr": "SH", "Value": ["*ep_b3000#35"]}, "126": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "127": {"vr": "SH", "Value": ["*ep_b3000#29"]}, "128": {"vr": "SH", "Value": ["*ep_b0"]}, "129": {"vr": "SH", "Value": ["*ep_b3000#21"]}, "130": {"vr": "SH", "Value": ["*ep_b3000#8"]}, "131": {"vr": "SH", "Value": ["*ep_b3000#46"]}, "132": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "133": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "134": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "135": {"vr": "SH", "Value": ["*ep_b3000#18"]}, "136": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "137": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "138": {"vr": "SH", "Value": ["*ep_b3000#8"]}, "139": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "140": {"vr": "SH", "Value": ["*ep_b3000#25"]}, "141": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "142": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "143": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "144": {"vr": "SH", "Value": ["*ep_b3000#37"]}, "145": {"vr": "SH", "Value": ["*ep_b3000#53"]}, "146": {"vr": "SH", "Value": ["*ep_b3000#7"]}, "147": {"vr": "SH", "Value": ["*ep_b3000#16"]}, "148": {"vr": "SH", "Value": ["*ep_b3000#55"]}, "149": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "150": {"vr": "SH", "Value": ["*ep_b3000#33"]}, "151": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "152": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "153": {"vr": "SH", "Value": ["*ep_b3000#17"]}, "154": {"vr": "SH", "Value": ["*ep_b3000#2"]}, "155": {"vr": "SH", "Value": ["*ep_b3000#47"]}, "156": {"vr": "SH", "Value": ["*ep_b3000#19"]}, "157": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "158": {"vr": "SH", "Value": ["*ep_b3000#37"]}, "159": {"vr": "SH", "Value": ["*ep_b3000#6"]}, "160": {"vr": "SH", "Value": ["*ep_b0"]}, "161": {"vr": "SH", "Value": ["*ep_b3000#54"]}, "162": {"vr": "SH", "Value": ["*ep_b3000#17"]}, "163": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "164": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "165": {"vr": "SH", "Value": ["*ep_b3000#51"]}, "166": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "167": {"vr": "SH", "Value": ["*ep_b3000#28"]}, "168": {"vr": "SH", "Value": ["*ep_b3000#10"]}, "169": {"vr": "SH", "Value": ["*ep_b3000#21"]}, "170": {"vr": "SH", "Value": ["*ep_b3000#6"]}, "171": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "172": {"vr": "SH", "Value": ["*ep_b3000#5"]}, "173": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "174": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "175": {"vr": "SH", "Value": ["*ep_b3000#22"]}, "176": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "177": {"vr": "SH", "Value": ["*ep_b3000#54"]}, "178": {"vr": "SH", "Value": ["*ep_b3000#62"]}, "179": {"vr": "SH", "Value": ["*ep_b3000#53"]}, "180": {"vr": "SH", "Value": ["*ep_b3000#14"]}, "181": {"vr": "SH", "Value": ["*ep_b3000#22"]}, "182": {"vr": "SH", "Value": ["*ep_b3000#51"]}, "183": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "184": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "185": {"vr": "SH", "Value": ["*ep_b3000#19"]}, "186": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "187": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "188": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "189": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "190": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "191": {"vr": "SH", "Value": ["*ep_b0"]}, "192": {"vr": "SH", "Value": ["*ep_b3000#48"]}, "193": {"vr": "SH", "Value": ["*ep_b3000#8"]}, "194": {"vr": "SH", "Value": ["*ep_b3000#63"]}, "195": {"vr": "SH", "Value": ["*ep_b3000#37"]}, "196": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "197": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "198": {"vr": "SH", "Value": ["*ep_b0"]}, "199": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "200": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "201": {"vr": "SH", "Value": ["*ep_b3000#46"]}, "202": {"vr": "SH", "Value": ["*ep_b3000#49"]}, "203": {"vr": "SH", "Value": ["*ep_b3000#19"]}, "204": {"vr": "SH", "Value": ["*ep_b3000#29"]}, "205": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "206": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "207": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "208": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "209": {"vr": "SH", "Value": ["*ep_b3000#9"]}, "210": {"vr": "SH", "Value": ["*ep_b0"]}, "211": {"vr": "SH", "Value": ["*ep_b3000#38"]}, "212": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "213": {"vr": "SH", "Value": ["*ep_b3000#60"]}, "214": {"vr": "SH", "Value": ["*ep_b3000#48"]}, "215": {"vr": "SH", "Value": ["*ep_b3000#40"]}, "216": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "217": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "218": {"vr": "SH", "Value": ["*ep_b3000#63"]}, "219": {"vr": "SH", "Value": ["*ep_b3000#30"]}, "220": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "221": {"vr": "SH", "Value": ["*ep_b3000#35"]}, "222": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "223": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "224": {"vr": "SH", "Value": ["*ep_b3000#5"]}, "225": {"vr": "SH", "Value": ["*ep_b3000#6"]}, "226": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "227": {"vr": "SH", "Value": ["*ep_b0"]}, "228": {"vr": "SH", "Value": ["*ep_b3000#38"]}, "229": {"vr": "SH", "Value": ["*ep_b3000#21"]}, "230": {"vr": "SH", "Value": ["*ep_b3000#14"]}, "231": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "232": {"vr": "SH", "Value": ["*ep_b3000#51"]}, "233": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "234": {"vr": "SH", "Value": ["*ep_b3000#21"]}, "235": {"vr": "SH", "Value": ["*ep_b3000#52"]}, "236": {"vr": "SH", "Value": ["*ep_b3000#60"]}, "237": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "238": {"vr": "SH", "Value": ["*ep_b3000#35"]}, "239": {"vr": "SH", "Value": ["*ep_b3000#53"]}, "240": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "241": {"vr": "SH", "Value": ["*ep_b3000#35"]}, "242": {"vr": "SH", "Value": ["*ep_b3000#43"]}, "243": {"vr": "SH", "Value": ["*ep_b0"]}, "244": {"vr": "SH", "Value": ["*ep_b3000#63"]}, "245": {"vr": "SH", "Value": ["*ep_b3000#57"]}, "246": {"vr": "SH", "Value": ["*ep_b0"]}, "247": {"vr": "SH", "Value": ["*ep_b3000#9"]}, "248": {"vr": "SH", "Value": ["*ep_b3000#38"]}, "249": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "250": {"vr": "SH", "Value": ["*ep_b3000#44"]}, "251": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "252": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "253": {"vr": "SH", "Value": ["*ep_b3000#37"]}, "254": {"vr": "SH", "Value": ["*ep_b3000#40"]}, "255": {"vr": "SH", "Value": ["*ep_b3000#25"]}, "256": {"vr": "SH", "Value": ["*ep_b0"]}, "257": {"vr": "SH", "Value": ["*ep_b3000#62"]}, "258": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "259": {"vr": "SH", "Value": ["*ep_b3000#26"]}, "260": {"vr": "SH", "Value": ["*ep_b3000#11"]}, "261": {"vr": "SH", "Value": ["*ep_b3000#55"]}, "262": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "263": {"vr": "SH", "Value": ["*ep_b3000#8"]}, "264": {"vr": "SH", "Value": ["*ep_b3000#58"]}, "265": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "266": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "267": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "268": {"vr": "SH", "Value": ["*ep_b3000#9"]}, "269": {"vr": "SH", "Value": ["*ep_b3000#47"]}, "270": {"vr": "SH", "Value": ["*ep_b0"]}, "271": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "272": {"vr": "SH", "Value": ["*ep_b3000#62"]}, "273": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "274": {"vr": "SH", "Value": ["*ep_b3000#10"]}, "275": {"vr": "SH", "Value": ["*ep_b0"]}, "276": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "277": {"vr": "SH", "Value": ["*ep_b3000#61"]}, "278": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "279": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "280": {"vr": "SH", "Value": ["*ep_b3000#41"]}, "281": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "282": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "283": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "284": {"vr": "SH", "Value": ["*ep_b3000#63"]}, "285": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "286": {"vr": "SH", "Value": ["*ep_b3000#36"]}, "287": {"vr": "SH", "Value": ["*ep_b3000#8"]}, "288": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "289": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "290": {"vr": "SH", "Value": ["*ep_b0"]}, "291": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "292": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "293": {"vr": "SH", "Value": ["*ep_b3000#16"]}, "294": {"vr": "SH", "Value": ["*ep_b3000#63"]}, "295": {"vr": "SH", "Value": ["*ep_b3000#44"]}, "296": {"vr": "SH", "Value": ["*ep_b3000#18"]}, "297": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "298": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "299": {"vr": "SH", "Value": ["*ep_b3000#2"]}, "300": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "301": {"vr": "SH", "Value": ["*ep_b0"]}, "302": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "303": {"vr": "SH", "Value": ["*ep_b3000#30"]}, "304": {"vr": "SH", "Value": ["*ep_b3000#31"]}, "305": {"vr": "SH", "Value": ["*ep_b3000#14"]}, "306": {"vr": "SH", "Value": ["*ep_b3000#61"]}, "307": {"vr": "SH", "Value": ["*ep_b3000#30"]}, "308": {"vr": "SH", "Value": ["*ep_b3000#60"]}, "309": {"vr": "SH", "Value": ["*ep_b3000#39"]}, "310": {"vr": "SH", "Value": ["*ep_b3000#37"]}, "311": {"vr": "SH", "Value": ["*ep_b0"]}, "312": {"vr": "SH", "Value": ["*ep_b3000#44"]}, "313": {"vr": "SH", "Value": ["*ep_b0"]}, "314": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "315": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "316": {"vr": "SH", "Value": ["*ep_b0"]}, "317": {"vr": "SH", "Value": ["*ep_b3000#60"]}, "318": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "319": {"vr": "SH", "Value": ["*ep_b3000#37"]}, "320": {"vr": "SH", "Value": ["*ep_b3000#43"]}, "321": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "322": {"vr": "SH", "Value": ["*ep_b3000#62"]}, "323": {"vr": "SH", "Value": ["*ep_b3000#31"]}, "324": {"vr": "SH", "Value": ["*ep_b3000#30"]}, "325": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "326": {"vr": "SH", "Value": ["*ep_b3000#6"]}, "327": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "328": {"vr": "SH", "Value": ["*ep_b3000#55"]}, "329": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "330": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "331": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "332": {"vr": "SH", "Value": ["*ep_b3000#14"]}, "333": {"vr": "SH", "Value": ["*ep_b3000#51"]}, "334": {"vr": "SH", "Value": ["*ep_b3000#28"]}, "335": {"vr": "SH", "Value": ["*ep_b3000#21"]}, "336": {"vr": "SH", "Value": ["*ep_b3000#16"]}, "337": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "338": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "339": {"vr": "SH", "Value": ["*ep_b3000#24"]}, "340": {"vr": "SH", "Value": ["*ep_b3000#10"]}, "341": {"vr": "SH", "Value": ["*ep_b3000#65"]}, "342": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "343": {"vr": "SH", "Value": ["*ep_b3000#58"]}, "344": {"vr": "SH", "Value": ["*ep_b3000#25"]}, "345": {"vr": "SH", "Value": ["*ep_b3000#48"]}, "346": {"vr": "SH", "Value": ["*ep_b3000#9"]}, "347": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "348": {"vr": "SH", "Value": ["*ep_b3000#33"]}, "349": {"vr": "SH", "Value": ["*ep_b0"]}, "350": {"vr": "SH", "Value": ["*ep_b0"]}, "351": {"vr": "SH", "Value": ["*ep_b3000#61"]}, "352": {"vr": "SH", "Value": ["*ep_b3000#33"]}, "353": {"vr": "SH", "Value": ["*ep_b3000#33"]}, "354": {"vr": "SH", "Value": ["*ep_b3000#30"]}, "355": {"vr": "SH", "Value": ["*ep_b3000#57"]}, "356": {"vr": "SH", "Value": ["*ep_b3000#18"]}, "357": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "358": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "359": {"vr": "SH", "Value": ["*ep_b3000#14"]}, "360": {"vr": "SH", "Value": ["*ep_b3000#4"]}, "361": {"vr": "SH", "Value": ["*ep_b0"]}, "362": {"vr": "SH", "Value": ["*ep_b3000#49"]}, "363": {"vr": "SH", "Value": ["*ep_b0"]}, "364": {"vr": "SH", "Value": ["*ep_b3000#57"]}, "365": {"vr": "SH", "Value": ["*ep_b3000#35"]}, "366": {"vr": "SH", "Value": ["*ep_b3000#64"]}, "367": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "368": {"vr": "SH", "Value": ["*ep_b0"]}, "369": {"vr": "SH", "Value": ["*ep_b3000#55"]}, "370": {"vr": "SH", "Value": ["*ep_b3000#50"]}, "371": {"vr": "SH", "Value": ["*ep_b3000#49"]}, "372": {"vr": "SH", "Value": ["*ep_b3000#47"]}, "373": {"vr": "SH", "Value": ["*ep_b3000#41"]}, "374": {"vr": "SH", "Value": ["*ep_b3000#30"]}, "375": {"vr": "SH", "Value": ["*ep_b3000#41"]}, "376": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "377": {"vr": "SH", "Value": ["*ep_b3000#55"]}, "378": {"vr": "SH", "Value": ["*ep_b3000#29"]}, "379": {"vr": "SH", "Value": ["*ep_b3000#17"]}, "380": {"vr": "SH", "Value": ["*ep_b3000#27"]}, "381": {"vr": "SH", "Value": ["*ep_b3000#16"]}, "382": {"vr": "SH", "Value": ["*ep_b3000#25"]}, "383": {"vr": "SH", "Value": ["*ep_b0"]}, "384": {"vr": "SH", "Value": ["*ep_b0"]}, "385": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "386": {"vr": "SH", "Value": ["*ep_b3000#59"]}, "387": {"vr": "SH", "Value": ["*ep_b3000#41"]}, "388": {"vr": "SH", "Value": ["*ep_b3000#61"]}, "389": {"vr": "SH", "Value": ["*ep_b3000#28"]}, "390": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "391": {"vr": "SH", "Value": ["*ep_b3000#60"]}, "392": {"vr": "SH", "Value": ["*ep_b3000#21"]}, "393": {"vr": "SH", "Value": ["*ep_b3000#42"]}, "394": {"vr": "SH", "Value": ["*ep_b3000#40"]}, "395": {"vr": "SH", "Value": ["*ep_b3000#33"]}, "396": {"vr": "SH", "Value": ["*ep_b0"]}, "397": {"vr": "SH", "Value": ["*ep_b3000#33"]}, "398": {"vr": "SH", "Value": ["*ep_b3000#6"]}, "399": {"vr": "SH", "Value": ["*ep_b0"]}, "400": {"vr": "SH", "Value": ["*ep_b3000#28"]}, "401": {"vr": "SH", "Value": ["*ep_b3000#11"]}, "402": {"vr": "SH", "Value": ["*ep_b3000#19"]}, "403": {"vr": "SH", "Value": ["*ep_b3000#38"]}, "404": {"vr": "SH", "Value": ["*ep_b3000#6"]}, "405": {"vr": "SH", "Value": ["*ep_b3000#49"]}, "406": {"vr": "SH", "Value": ["*ep_b3000#15"]}, "407": {"vr": "SH", "Value": ["*ep_b3000#20"]}, "408": {"vr": "SH", "Value": ["*ep_b3000#35"]}, "409": {"vr": "SH", "Value": ["*ep_b3000#40"]}, "410": {"vr": "SH", "Value": ["*ep_b3000#17"]}, "411": {"vr": "SH", "Value": ["*ep_b3000#58"]}, "412": {"vr": "SH", "Value": ["*ep_b3000#3"]}, "413": {"vr": "SH", "Value": ["*ep_b3000#13"]}, "414": {"vr": "SH", "Value": ["*ep_b3000#6"]}, "415": {"vr": "SH", "Value": ["*ep_b3000#54"]}, "416": {"vr": "SH", "Value": ["*ep_b3000#32"]}, "417": {"vr": "SH", "Value": ["*ep_b3000#7