from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__)):
    return generate_dicom(out_dir, num_vols, constant_hdr,
                          collated_data, varying_hdr)


num_vols = 240


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY",
            "OTHER"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.4"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20210420"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20210420"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20210420"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20210420"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "152316"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "153048"
        ]
    },
    "00080032": {
        "vr": "TM",
        "Value": [
            "153048"
        ]
    },
    "00080033": {
        "vr": "TM",
        "Value": [
            "153048"
        ]
    },
    "00080050": {
        "vr": "SH",
        "Value": [
            "77.30442877_1"
        ]
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "MR"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "GE MEDICAL SYSTEMS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "TWIST^OLIVIER^^PROF"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "MR750"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^Project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "Ax Field map (TE 4.9)"
        ]
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "DISCOVERY MR888"
        ]
    },
    "00081110": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.31"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.6.1.4.1.14301.77.4.30442877.1"
                    ]
                }
            }
        ]
    },
    "00081111": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.3.1.2.3.3"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.113619.6.408.192341662414845199409379431428544218334"
                    ]
                }
            }
        ]
    },
    "00081140": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.113619.2.408.5282380.5891679.24341.1618892808.371"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.113619.2.408.5282380.5891679.24341.1618892808.375"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.113619.2.408.5282380.5891679.24341.1618892808.363"
                    ]
                }
            }
        ]
    },
    "00082218": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "T-A0100"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "SRT"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "Brain"
                    ]
                }
            }
        ]
    },
    "00090010": {
        "vr": "LO",
        "Value": [
            "GEMS_IDEN_01"
        ]
    },
    "00091002": {
        "vr": "SH",
        "Value": [
            "MR"
        ]
    },
    "00091004": {
        "vr": "SH",
        "Value": [
            "SIGNA"
        ]
    },
    "00091027": {
        "vr": "SL",
        "Value": [
            1618932648
        ]
    },
    "00091030": {
        "vr": "SH",
        "Value": [
            "0910272071"
        ]
    },
    "00091031": {
        "vr": "SH",
        "Value": [
            "9999"
        ]
    },
    "000910E3": {
        "vr": "UI",
        "Value": [
            "1.2.840.113619.1.408.5.5282380.5891679"
        ]
    },
    "000910E9": {
        "vr": "SL",
        "Value": [
            1618932648
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Session Identifier"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "Session Label"
        ]
    },
    "00100030": {
        "vr": "DA"
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "F"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "073Y"
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            60.0
        ]
    },
    "001021B0": {
        "vr": "LT"
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            "Patient comments string"
        ]
    },
    "00120064": {
        "vr": "SQ",
        "Value": [
            {
                "00080100": {
                    "vr": "SH",
                    "Value": [
                        "25"
                    ]
                },
                "00080102": {
                    "vr": "SH",
                    "Value": [
                        "XNAT"
                    ]
                },
                "00080103": {
                    "vr": "SH",
                    "Value": [
                        "1.0"
                    ]
                },
                "00080104": {
                    "vr": "LO",
                    "Value": [
                        "XNAT DicomEdit 4 Script"
                    ]
                }
            }
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "BRAIN"
        ]
    },
    "00180020": {
        "vr": "CS",
        "Value": [
            "GR"
        ]
    },
    "00180021": {
        "vr": "CS",
        "Value": [
            "SS",
            "SP",
            "SK"
        ]
    },
    "00180022": {
        "vr": "CS",
        "Value": [
            "FAST_GEMS"
        ]
    },
    "00180023": {
        "vr": "CS",
        "Value": [
            "2D"
        ]
    },
    "00180025": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00180050": {
        "vr": "DS",
        "Value": [
            2.5
        ]
    },
    "00180080": {
        "vr": "DS",
        "Value": [
            50.0
        ]
    },
    "00180081": {
        "vr": "DS",
        "Value": [
            4.9
        ]
    },
    "00180083": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00180084": {
        "vr": "DS",
        "Value": [
            127.769299
        ]
    },
    "00180085": {
        "vr": "SH",
        "Value": [
            "1H"
        ]
    },
    "00180086": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00180087": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00180088": {
        "vr": "DS",
        "Value": [
            2.5
        ]
    },
    "00180091": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00180093": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "00180094": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "00180095": {
        "vr": "DS",
        "Value": [
            244.141
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "0000000910272071"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "27",
            "LX",
            "MR Software release:DV26.0_R05_2008.a"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "--Frontier"
        ]
    },
    "00181080": {
        "vr": "CS",
        "Value": [
            "Y"
        ]
    },
    "00181088": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00181090": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00181094": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00181100": {
        "vr": "DS",
        "Value": [
            240.0
        ]
    },
    "00181250": {
        "vr": "SH",
        "Value": [
            "8HRBRAIN"
        ]
    },
    "00181310": {
        "vr": "US",
        "Value": [
            96,
            0,
            0,
            96
        ]
    },
    "00181312": {
        "vr": "CS",
        "Value": [
            "COL"
        ]
    },
    "00181314": {
        "vr": "DS",
        "Value": [
            45.0
        ]
    },
    "00181315": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00181316": {
        "vr": "DS",
        "Value": [
            0.083181
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "00190010": {
        "vr": "LO",
        "Value": [
            "GEMS_ACQU_01"
        ]
    },
    "0019100F": {
        "vr": "DS",
        "Value": [
            380.899994
        ]
    },
    "00191011": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00191012": {
        "vr": "SS",
        "Value": [
            22
        ]
    },
    "00191017": {
        "vr": "SS",
        "Value": [
            16
        ]
    },
    "00191018": {
        "vr": "LO",
        "Value": [
            "I"
        ]
    },
    "00191019": {
        "vr": "DS",
        "Value": [
            -58.5651
        ]
    },
    "0019101A": {
        "vr": "LO",
        "Value": [
            "S"
        ]
    },
    "0019101B": {
        "vr": "DS",
        "Value": [
            74.8327
        ]
    },
    "0019101E": {
        "vr": "DS",
        "Value": [
            240.0
        ]
    },
    "0019105A": {
        "vr": "FL",
        "Value": [
            52200000.0
        ]
    },
    "0019107D": {
        "vr": "DS",
        "Value": [
            1000.0
        ]
    },
    "0019107E": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "0019107F": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00191081": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "00191084": {
        "vr": "DS",
        "Value": [
            1.033304
        ]
    },
    "00191087": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00191088": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "0019108A": {
        "vr": "SS",
        "Value": [
            13
        ]
    },
    "0019108B": {
        "vr": "SS",
        "Value": [
            15
        ]
    },
    "0019108D": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0019108F": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "00191090": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00191091": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00191092": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00191093": {
        "vr": "DS",
        "Value": [
            1277692990.0
        ]
    },
    "00191094": {
        "vr": "SS",
        "Value": [
            106
        ]
    },
    "00191095": {
        "vr": "SS",
        "Value": [
            13
        ]
    },
    "00191096": {
        "vr": "SS",
        "Value": [
            15
        ]
    },
    "00191097": {
        "vr": "SL",
        "Value": [
            320
        ]
    },
    "0019109B": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "0019109C": {
        "vr": "LO",
        "Value": [
            "fgre"
        ]
    },
    "0019109D": {
        "vr": "DT",
        "Value": [
            "20200223164950"
        ]
    },
    "0019109E": {
        "vr": "LO",
        "Value": [
            "FGRE"
        ]
    },
    "0019109F": {
        "vr": "SS",
        "Value": [
            3
        ]
    },
    "001910A0": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910A1": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910A3": {
        "vr": "UL",
        "Value": [
            0
        ]
    },
    "001910A4": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910A7": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910A8": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910A9": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910AA": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910AB": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910AC": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910AD": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910AE": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910AF": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B0": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B1": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B2": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B3": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B4": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B5": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B6": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B7": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B8": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910B9": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910BA": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910BB": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910BC": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910BD": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910BE": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910C0": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910C2": {
        "vr": "SS",
        "Value": [
            9990
        ]
    },
    "001910C3": {
        "vr": "SS",
        "Value": [
            9990
        ]
    },
    "001910C4": {
        "vr": "SS",
        "Value": [
            9990
        ]
    },
    "001910C5": {
        "vr": "SS",
        "Value": [
            9990
        ]
    },
    "001910C6": {
        "vr": "SS",
        "Value": [
            9990
        ]
    },
    "001910C7": {
        "vr": "SS",
        "Value": [
            9990
        ]
    },
    "001910C8": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910C9": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910CA": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910CB": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910CC": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910CD": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910CE": {
        "vr": "SS",
        "Value": [
            2
        ]
    },
    "001910CF": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910D2": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910D3": {
        "vr": "SH"
    },
    "001910D5": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910D7": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910D8": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910D9": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910DF": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910E0": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910E2": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "001910F2": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "001910F9": {
        "vr": "DS",
        "Value": [
            106.0
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.3.6.1.4.1.14301.77.4.30442877.1"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.2.840.113619.2.408.5282380.5891679.25897.1618892550.729"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "PROJECT_ID"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            4
        ]
    },
    "00200012": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.2.840.113619.2.408.5282380.5891679.25897.1618892550.723"
        ]
    },
    "00200060": {
        "vr": "CS"
    },
    "00201002": {
        "vr": "IS",
        "Value": [
            240
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00209056": {
        "vr": "SH",
        "Value": [
            "1"
        ]
    },
    "00210010": {
        "vr": "LO",
        "Value": [
            "GEMS_RELA_01"
        ]
    },
    "00211035": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "00211036": {
        "vr": "SS",
        "Value": [
            9
        ]
    },
    "00211037": {
        "vr": "SS",
        "Value": [
            16
        ]
    },
    "0021104F": {
        "vr": "SS",
        "Value": [
            60
        ]
    },
    "00211050": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00211051": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211052": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211053": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211056": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00211057": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00211058": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00211059": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "0021105A": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "0021105B": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0021105C": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0021105D": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0021105E": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0021105F": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211081": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211082": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211083": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211084": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00230010": {
        "vr": "LO",
        "Value": [
            "XXX_STDY_01"
        ]
    },
    "00231070": {
        "vr": "FD",
        "Value": [
            0.0
        ]
    },
    "00231074": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "0023107D": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00231080": {
        "vr": "SQ",
        "Value": [
            {
                "00081120": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00081150": {
                                "vr": "UI",
                                "Value": [
                                    "1.2.840.10008.5.1.4.31"
                                ]
                            },
                            "00081155": {
                                "vr": "UI",
                                "Value": [
                                    "1.3.6.1.4.1.14301.77.1.8592641"
                                ]
                            }
                        }
                    ]
                },
                "00321064": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "MRNRB"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "PME"
                                ]
                            },
                            "00080103": {
                                "vr": "SH",
                                "Value": [
                                    "1"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "MRI NR Brain"
                                ]
                            }
                        }
                    ]
                },
                "00400255": {
                    "vr": "LO"
                }
            }
        ]
    },
    "00250010": {
        "vr": "LO",
        "Value": [
            "GEMS_SERS_01"
        ]
    },
    "00251006": {
        "vr": "SS",
        "Value": [
            22
        ]
    },
    "00251007": {
        "vr": "SL",
        "Value": [
            240
        ]
    },
    "00251010": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00251011": {
        "vr": "SS",
        "Value": [
            10
        ]
    },
    "00251014": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00251017": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00251018": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00251019": {
        "vr": "SL",
        "Value": [
            240
        ]
    },
    "0025101A": {
        "vr": "SH",
        "Value": [
            "MR750"
        ]
    },
    "00270010": {
        "vr": "LO",
        "Value": [
            "GEMS_IMAG_01"
        ]
    },
    "00271006": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00271010": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00271030": {
        "vr": "SH"
    },
    "00271031": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "00271032": {
        "vr": "SS",
        "Value": [
            22
        ]
    },
    "00271033": {
        "vr": "UL",
        "Value": [
            0
        ]
    },
    "00271035": {
        "vr": "SS",
        "Value": [
            16
        ]
    },
    "00271060": {
        "vr": "FL",
        "Value": [
            96.0
        ]
    },
    "00271061": {
        "vr": "FL",
        "Value": [
            96.0
        ]
    },
    "00271062": {
        "vr": "FL",
        "Value": [
            1.0
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            256
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            256
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            0.9375,
            0.9375
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            15
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "GEMS_IMPS_01"
        ]
    },
    "00291015": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00291016": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00291017": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00291018": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00291026": {
        "vr": "SS",
        "Value": [
            2
        ]
    },
    "00291034": {
        "vr": "SL",
        "Value": [
            16384
        ]
    },
    "00291035": {
        "vr": "SL",
        "Value": [
            0
        ]
    },
    "00400242": {
        "vr": "SH",
        "Value": [
            "MR750"
        ]
    },
    "00400243": {
        "vr": "SH",
        "Value": [
            "MR"
        ]
    },
    "00400244": {
        "vr": "DA",
        "Value": [
            "20210420"
        ]
    },
    "00400245": {
        "vr": "TM",
        "Value": [
            "152305"
        ]
    },
    "00400253": {
        "vr": "SH",
        "Value": [
            "1260.1618896185"
        ]
    },
    "00400254": {
        "vr": "LO",
        "Value": [
            "MRI NR Brain"
        ]
    },
    "00400275": {
        "vr": "SQ",
        "Value": [
            {
                "00321060": {
                    "vr": "LO",
                    "Value": [
                        "MRI NR Brain"
                    ]
                },
                "00400006": {
                    "vr": "PN",
                    "Value": [
                        {
                            "Alphabetic": "MASTERS^LYNETTE^^DR"
                        }
                    ]
                },
                "00400007": {
                    "vr": "LO",
                    "Value": [
                        "MRI NR Brain"
                    ]
                },
                "00400008": {
                    "vr": "SQ",
                    "Value": [
                        {
                            "00080100": {
                                "vr": "SH",
                                "Value": [
                                    "MRNRB"
                                ]
                            },
                            "00080102": {
                                "vr": "SH",
                                "Value": [
                                    "PME"
                                ]
                            },
                            "00080103": {
                                "vr": "SH",
                                "Value": [
                                    "1"
                                ]
                            },
                            "00080104": {
                                "vr": "LO",
                                "Value": [
                                    "MRI NR Brain"
                                ]
                            }
                        }
                    ]
                },
                "00400009": {
                    "vr": "SH",
                    "Value": [
                        "77.30442877_1"
                    ]
                },
                "00401001": {
                    "vr": "SH",
                    "Value": [
                        "77.30442877_1"
                    ]
                }
            }
        ]
    },
    "00430010": {
        "vr": "LO",
        "Value": [
            "GEMS_PARM_01"
        ]
    },
    "00431001": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "00431002": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00431003": {
        "vr": "SS",
        "Value": [
            5
        ]
    },
    "00431004": {
        "vr": "SS",
        "Value": [
            -25
        ]
    },
    "00431006": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00431007": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00431008": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00431009": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "0043100A": {
        "vr": "SS",
        "Value": [
            1
        ]
    },
    "0043100B": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0043100C": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "0043100D": {
        "vr": "DS",
        "Value": [
            97.176361
        ]
    },
    "0043100E": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00431010": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "0043101C": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "0043101D": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "0043102C": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "0043102E": {
        "vr": "SH"
    },
    "00431030": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00431032": {
        "vr": "SS",
        "Value": [
            2
        ]
    },
    "00431033": {
        "vr": "FL",
        "Value": [
            0.0
        ]
    },
    "00431034": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00431035": {
        "vr": "UL",
        "Value": [
            0
        ]
    },
    "00431036": {
        "vr": "UL",
        "Value": [
            0
        ]
    },
    "00431037": {
        "vr": "UL",
        "Value": [
            0
        ]
    },
    "00431038": {
        "vr": "FL",
        "Value": [
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0
        ]
    },
    "00431039": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0,
            0
        ]
    },
    "00431060": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
        ]
    },
    "00431061": {
        "vr": "UI",
        "Value": [
            "1.3.6.1.4.1.14301.77.4.30442877.1"
        ]
    },
    "00431062": {
        "vr": "SH",
        "Value": [
            "27399"
        ]
    },
    "0043106F": {
        "vr": "DS",
        "Value": [
            0.0,
            0.0,
            0.0,
            0.0
        ]
    },
    "0043107D": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00431080": {
        "vr": "LO",
        "Value": [
            "A:",
            "INVIOOPorvJn6rmqnVtabBmQu4yXlK17",
            "ad00000011084e0f",
            "P1:0",
            "P2:0",
            "P3:0",
            "P4:0"
        ]
    },
    "00431081": {
        "vr": "LO",
        "Value": [
            "C-GE_HDx 8HRBrain"
        ]
    },
    "00431082": {
        "vr": "LO",
        "Value": [
            "SRMode=200",
            "GCoilType=8",
            "gradientAmp=8920",
            "lineFreq=50",
            "RFampType=15",
            "broadBandXcvr=yes",
            "DerateGrad=Yes"
        ]
    },
    "00431083": {
        "vr": "DS",
        "Value": [
            1.0,
            1.0
        ]
    },
    "00431084": {
        "vr": "LO",
        "Value": [
            "10000",
            "0",
            "2",
            "1",
            "asset",
            "NO",
            ""
        ]
    },
    "00431089": {
        "vr": "LO",
        "Value": [
            "FDA",
            "IEC_FIRST_LEVEL",
            "IEC_FIRST_LEVEL"
        ]
    },
    "0043108A": {
        "vr": "CS",
        "Value": [
            "COL"
        ]
    },
    "00431090": {
        "vr": "LO",
        "Value": [
            "WHOLE_BODY_6_MIN",
            "LOCAL_PEAK_6_MIN",
            "PARTIAL_BODY_6MIN"
        ]
    },
    "00431091": {
        "vr": "DS",
        "Value": [
            0.08318,
            1.0333,
            0.413322
        ]
    },
    "00431095": {
        "vr": "LO",
        "Value": [
            "TG/s1,RN/s1"
        ]
    },
    "00431096": {
        "vr": "CS",
        "Value": [
            "RESEARCH"
        ]
    },
    "00431098": {
        "vr": "UI",
        "Value": [
            "1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"
        ]
    },
    "0043109A": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "004310AA": {
        "vr": "LO",
        "Value": [
            "rev=2;a=1;b=10.0;c=0.0;d=1.0;e=0.00;f=12.00",
            "rev=2;g=48.0;h=10.0;i=1.0",
            "rev=2;j=0;k=0.00",
            "rev=2;l=10.0;m=0.00;n=1.00;o=0;p=0.0",
            "rev=2;q=0.00;r=2;s=1.0;t=0;u=1;v=0;w=0;x=0"
        ]
    },
    "004310B2": {
        "vr": "LO",
        "Value": [
            "956",
            "380.9",
            "-8.13376",
            "0",
            "83.8734",
            "75.7396"
        ]
    },
    "004310B7": {
        "vr": "LO",
        "Value": [
            "1",
            "0",
            "3",
            "0"
        ]
    },
    "004310BB": {
        "vr": "LO",
        "Value": [
            "2.5",
            "2.5",
            "651.0"
        ]
    },
    "004310BC": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotype"
            }
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "Address of said institute"
        ]
    }
}


varying_hdr = {"00080018": {"0": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.405"]}, "1": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.292"]}, "2": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.302"]}, "3": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.282"]}, "4": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.418"]}, "5": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.347"]}, "6": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.412"]}, "7": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.315"]}, "8": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.495"]}, "9": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.392"]}, "10": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.454"]}, "11": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.464"]}, "12": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.420"]}, "13": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.500"]}, "14": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.390"]}, "15": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.447"]}, "16": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.324"]}, "17": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.297"]}, "18": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.286"]}, "19": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.334"]}, "20": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.280"]}, "21": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.272"]}, "22": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.369"]}, "23": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.289"]}, "24": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.326"]}, "25": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.442"]}, "26": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.267"]}, "27": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.364"]}, "28": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.434"]}, "29": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.381"]}, "30": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.331"]}, "31": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.397"]}, "32": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.474"]}, "33": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.327"]}, "34": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.407"]}, "35": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.365"]}, "36": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.455"]}, "37": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.446"]}, "38": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.394"]}, "39": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.472"]}, "40": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.422"]}, "41": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.290"]}, "42": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.435"]}, "43": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.310"]}, "44": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.389"]}, "45": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.449"]}, "46": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.301"]}, "47": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.304"]}, "48": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.429"]}, "49": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.383"]}, "50": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.270"]}, "51": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.284"]}, "52": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.443"]}, "53": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.414"]}, "54": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.330"]}, "55": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.477"]}, "56": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.352"]}, "57": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.491"]}, "58": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.379"]}, "59": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.335"]}, "60": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.337"]}, "61": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.498"]}, "62": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.306"]}, "63": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.441"]}, "64": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.377"]}, "65": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.493"]}, "66": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.448"]}, "67": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.425"]}, "68": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.293"]}, "69": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.423"]}, "70": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.476"]}, "71": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.485"]}, "72": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.399"]}, "73": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.266"]}, "74": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.484"]}, "75": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.269"]}, "76": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.451"]}, "77": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.440"]}, "78": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.299"]}, "79": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.413"]}, "80": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.494"]}, "81": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.471"]}, "82": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.403"]}, "83": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.353"]}, "84": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.473"]}, "85": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.478"]}, "86": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.296"]}, "87": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.433"]}, "88": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.488"]}, "89": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.342"]}, "90": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.462"]}, "91": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.431"]}, "92": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.415"]}, "93": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.376"]}, "94": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.466"]}, "95": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.428"]}, "96": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.325"]}, "97": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.305"]}, "98": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.338"]}, "99": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.505"]}, "100": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.499"]}, "101": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.351"]}, "102": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.400"]}, "103": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.490"]}, "104": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.378"]}, "105": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.307"]}, "106": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.367"]}, "107": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.406"]}, "108": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.419"]}, "109": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.395"]}, "110": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.283"]}, "111": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.314"]}, "112": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.409"]}, "113": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.384"]}, "114": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.504"]}, "115": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.486"]}, "116": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.421"]}, "117": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.276"]}, "118": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.311"]}, "119": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.450"]}, "120": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.382"]}, "121": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.459"]}, "122": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.387"]}, "123": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.287"]}, "124": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.497"]}, "125": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.355"]}, "126": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.300"]}, "127": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.339"]}, "128": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.370"]}, "129": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.426"]}, "130": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.502"]}, "131": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.444"]}, "132": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.358"]}, "133": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.279"]}, "134": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.313"]}, "135": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.277"]}, "136": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.482"]}, "137": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.328"]}, "138": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.322"]}, "139": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.401"]}, "140": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.345"]}, "141": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.336"]}, "142": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.456"]}, "143": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.492"]}, "144": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.348"]}, "145": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.309"]}, "146": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.350"]}, "147": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.465"]}, "148": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.469"]}, "149": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.501"]}, "150": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.408"]}, "151": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.359"]}, "152": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.458"]}, "153": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.320"]}, "154": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.380"]}, "155": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.374"]}, "156": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.303"]}, "157": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.274"]}, "158": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.417"]}, "159": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.354"]}, "160": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.343"]}, "161": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.357"]}, "162": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.385"]}, "163": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.479"]}, "164": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.332"]}, "165": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.496"]}, "166": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.411"]}, "167": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.470"]}, "168": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.461"]}, "169": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.268"]}, "170": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.363"]}, "171": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.316"]}, "172": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.373"]}, "173": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.341"]}, "174": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.453"]}, "175": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.291"]}, "176": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.463"]}, "177": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.323"]}, "178": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.436"]}, "179": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.480"]}, "180": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.391"]}, "181": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.467"]}, "182": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.361"]}, "183": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.294"]}, "184": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.271"]}, "185": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.396"]}, "186": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.340"]}, "187": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.457"]}, "188": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.368"]}, "189": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.430"]}, "190": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.372"]}, "191": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.489"]}, "192": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.388"]}, "193": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.288"]}, "194": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.375"]}, "195": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.356"]}, "196": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.371"]}, "197": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.312"]}, "198": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.437"]}, "199": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.481"]}, "200": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.318"]}, "201": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.275"]}, "202": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.298"]}, "203": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.285"]}, "204": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.503"]}, "205": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.398"]}, "206": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.439"]}, "207": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.366"]}, "208": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.308"]}, "209": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.475"]}, "210": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.317"]}, "211": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.410"]}, "212": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.349"]}, "213": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.404"]}, "214": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.386"]}, "215": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.468"]}, "216": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.319"]}, "217": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.452"]}, "218": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.402"]}, "219": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.362"]}, "220": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.393"]}, "221": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.427"]}, "222": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.273"]}, "223": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.360"]}, "224": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.295"]}, "225": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.281"]}, "226": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.438"]}, "227": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.487"]}, "228": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.432"]}, "229": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.321"]}, "230": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.278"]}, "231": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.445"]}, "232": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.416"]}, "233": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.346"]}, "234": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.329"]}, "235": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.333"]}, "236": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.424"]}, "237": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.460"]}, "238": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.344"]}, "239": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.24341.1618892809.483"]}}, "001910A2": {"0": {"vr": "SL", "Value": [12333]}, "1": {"vr": "SL", "Value": [12289]}, "2": {"vr": "SL", "Value": [12319]}, "3": {"vr": "SL", "Value": [12328]}, "4": {"vr": "SL", "Value": [12314]}, "5": {"vr": "SL", "Value": [12311]}, "6": {"vr": "SL", "Value": [12294]}, "7": {"vr": "SL", "Value": [12290]}, "8": {"vr": "SL", "Value": [12327]}, "9": {"vr": "SL", "Value": [12303]}, "10": {"vr": "SL", "Value": [12345]}, "11": {"vr": "SL", "Value": [12306]}, "12": {"vr": "SL", "Value": [12314]}, "13": {"vr": "SL", "Value": [12337]}, "14": {"vr": "SL", "Value": [12303]}, "15": {"vr": "SL", "Value": [12325]}, "16": {"vr": "SL", "Value": [12310]}, "17": {"vr": "SL", "Value": [12299]}, "18": {"vr": "SL", "Value": [12338]}, "19": {"vr": "SL", "Value": [12340]}, "20": {"vr": "SL", "Value": [12318]}, "21": {"vr": "SL", "Value": [12298]}, "22": {"vr": "SL", "Value": [12302]}, "23": {"vr": "SL", "Value": [12338]}, "24": {"vr": "SL", "Value": [12320]}, "25": {"vr": "SL", "Value": [12315]}, "26": {"vr": "SL", "Value": [12288]}, "27": {"vr": "SL", "Value": [12292]}, "28": {"vr": "SL", "Value": [12295]}, "29": {"vr": "SL", "Value": [12332]}, "30": {"vr": "SL", "Value": [12330]}, "31": {"vr": "SL", "Value": [12313]}, "32": {"vr": "SL", "Value": [12336]}, "33": {"vr": "SL", "Value": [12320]}, "34": {"vr": "SL", "Value": [12343]}, "35": {"vr": "SL", "Value": [12292]}, "36": {"vr": "SL", "Value": [12345]}, "37": {"vr": "SL", "Value": [12325]}, "38": {"vr": "SL", "Value": [12313]}, "39": {"vr": "SL", "Value": [12326]}, "40": {"vr": "SL", "Value": [12324]}, "41": {"vr": "SL", "Value": [12289]}, "42": {"vr": "SL", "Value": [12295]}, "43": {"vr": "SL", "Value": [12339]}, "44": {"vr": "SL", "Value": [12293]}, "45": {"vr": "SL", "Value": [12325]}, "46": {"vr": "SL", "Value": [12309]}, "47": {"vr": "SL", "Value": [12319]}, "48": {"vr": "SL", "Value": [12334]}, "49": {"vr": "SL", "Value": [12342]}, "50": {"vr": "SL", "Value": [12298]}, "51": {"vr": "SL", "Value": [12328]}, "52": {"vr": "SL", "Value": [12315]}, "53": {"vr": "SL", "Value": [12304]}, "54": {"vr": "SL", "Value": [12330]}, "55": {"vr": "SL", "Value": [12336]}, "56": {"vr": "SL", "Value": [12321]}, "57": {"vr": "SL", "Value": [12317]}, "58": {"vr": "SL", "Value": [12332]}, "59": {"vr": "SL", "Value": [12340]}, "60": {"vr": "SL", "Value": [12340]}, "61": {"vr": "SL", "Value": [12337]}, "62": {"vr": "SL", "Value": [12329]}, "63": {"vr": "SL", "Value": [12305]}, "64": {"vr": "SL", "Value": [12322]}, "65": {"vr": "SL", "Value": [12317]}, "66": {"vr": "SL", "Value": [12325]}, "67": {"vr": "SL", "Value": [12324]}, "68": {"vr": "SL", "Value": [12289]}, "69": {"vr": "SL", "Value": [12324]}, "70": {"vr": "SL", "Value": [12336]}, "71": {"vr": "SL", "Value": [12297]}, "72": {"vr": "SL", "Value": [12323]}, "73": {"vr": "SL", "Value": [12288]}, "74": {"vr": "SL", "Value": [12297]}, "75": {"vr": "SL", "Value": [12288]}, "76": {"vr": "SL", "Value": [12335]}, "77": {"vr": "SL", "Value": [12305]}, "78": {"vr": "SL", "Value": [12309]}, "79": {"vr": "SL", "Value": [12294]}, "80": {"vr": "SL", "Value": [12327]}, "81": {"vr": "SL", "Value": [12326]}, "82": {"vr": "SL", "Value": [12333]}, "83": {"vr": "SL", "Value": [12321]}, "84": {"vr": "SL", "Value": [12326]}, "85": {"vr": "SL", "Value": [12346]}, "86": {"vr": "SL", "Value": [12299]}, "87": {"vr": "SL", "Value": [12344]}, "88": {"vr": "SL", "Value": [12307]}, "89": {"vr": "SL", "Value": [12301]}, "90": {"vr": "SL", "Value": [12306]}, "91": {"vr": "SL", "Value": [12344]}, "92": {"vr": "SL", "Value": [12304]}, "93": {"vr": "SL", "Value": [12322]}, "94": {"vr": "SL", "Value": [12316]}, "95": {"vr": "SL", "Value": [12334]}, "96": {"vr": "SL", "Value": [12310]}, "97": {"vr": "SL", "Value": [12319]}, "98": {"vr": "SL", "Value": [12291]}, "99": {"vr": "SL", "Value": [12347]}, "100": {"vr": "SL", "Value": [12337]}, "101": {"vr": "SL", "Value": [12321]}, "102": {"vr": "SL", "Value": [12323]}, "103": {"vr": "SL", "Value": [12317]}, "104": {"vr": "SL", "Value": [12332]}, "105": {"vr": "SL", "Value": [12329]}, "106": {"vr": "SL", "Value": [12302]}, "107": {"vr": "SL", "Value": [12343]}, "108": {"vr": "SL", "Value": [12314]}, "109": {"vr": "SL", "Value": [12313]}, "110": {"vr": "SL", "Value": [12328]}, "111": {"vr": "SL", "Value": [12290]}, "112": {"vr": "SL", "Value": [12343]}, "113": {"vr": "SL", "Value": [12342]}, "114": {"vr": "SL", "Value": [12347]}, "115": {"vr": "SL", "Value": [12307]}, "116": {"vr": "SL", "Value": [12314]}, "117": {"vr": "SL", "Value": [12308]}, "118": {"vr": "SL", "Value": [12339]}, "119": {"vr": "SL", "Value": [12335]}, "120": {"vr": "SL", "Value": [12342]}, "121": {"vr": "SL", "Value": [12296]}, "122": {"vr": "SL", "Value": [12293]}, "123": {"vr": "SL", "Value": [12338]}, "124": {"vr": "SL", "Value": [12327]}, "125": {"vr": "SL", "Value": [12331]}, "126": {"vr": "SL", "Value": [12309]}, "127": {"vr": "SL", "Value": [12291]}, "128": {"vr": "SL", "Value": [12312]}, "129": {"vr": "SL", "Value": [12334]}, "130": {"vr": "SL", "Value": [12347]}, "131": {"vr": "SL", "Value": [12315]}, "132": {"vr": "SL", "Value": [12341]}, "133": {"vr": "SL", "Value": [12318]}, "134": {"vr": "SL", "Value": [12339]}, "135": {"vr": "SL", "Value": [12308]}, "136": {"vr": "SL", "Value": [12297]}, "137": {"vr": "SL", "Value": [12320]}, "138": {"vr": "SL", "Value": [12310]}, "139": {"vr": "SL", "Value": [12323]}, "140": {"vr": "SL", "Value": [12301]}, "141": {"vr": "SL", "Value": [12340]}, "142": {"vr": "SL", "Value": [12345]}, "143": {"vr": "SL", "Value": [12317]}, "144": {"vr": "SL", "Value": [12311]}, "145": {"vr": "SL", "Value": [12329]}, "146": {"vr": "SL", "Value": [12321]}, "147": {"vr": "SL", "Value": [12306]}, "148": {"vr": "SL", "Value": [12316]}, "149": {"vr": "SL", "Value": [12337]}, "150": {"vr": "SL", "Value": [12343]}, "151": {"vr": "SL", "Value": [12341]}, "152": {"vr": "SL", "Value": [12296]}, "153": {"vr": "SL", "Value": [12300]}, "154": {"vr": "SL", "Value": [12332]}, "155": {"vr": "SL", "Value": [12322]}, "156": {"vr": "SL", "Value": [12319]}, "157": {"vr": "SL", "Value": [12308]}, "158": {"vr": "SL", "Value": [12304]}, "159": {"vr": "SL", "Value": [12331]}, "160": {"vr": "SL", "Value": [12301]}, "161": {"vr": "SL", "Value": [12331]}, "162": {"vr": "SL", "Value": [12342]}, "163": {"vr": "SL", "Value": [12346]}, "164": {"vr": "SL", "Value": [12330]}, "165": {"vr": "SL", "Value": [12327]}, "166": {"vr": "SL", "Value": [12294]}, "167": {"vr": "SL", "Value": [12326]}, "168": {"vr": "SL", "Value": [12296]}, "169": {"vr": "SL", "Value": [12288]}, "170": {"vr": "SL", "Value": [12292]}, "171": {"vr": "SL", "Value": [12290]}, "172": {"vr": "SL", "Value": [12312]}, "173": {"vr": "SL", "Value": [12291]}, "174": {"vr": "SL", "Value": [12335]}, "175": {"vr": "SL", "Value": [12289]}, "176": {"vr": "SL", "Value": [12306]}, "177": {"vr": "SL", "Value": [12310]}, "178": {"vr": "SL", "Value": [12295]}, "179": {"vr": "SL", "Value": [12346]}, "180": {"vr": "SL", "Value": [12303]}, "181": {"vr": "SL", "Value": [12316]}, "182": {"vr": "SL", "Value": [12341]}, "183": {"vr": "SL", "Value": [12299]}, "184": {"vr": "SL", "Value": [12298]}, "185": {"vr": "SL", "Value": [12313]}, "186": {"vr": "SL", "Value": [12291]}, "187": {"vr": "SL", "Value": [12345]}, "188": {"vr": "SL", "Value": [12302]}, "189": {"vr": "SL", "Value": [12344]}, "190": {"vr": "SL", "Value": [12312]}, "191": {"vr": "SL", "Value": [12307]}, "192": {"vr": "SL", "Value": [12293]}, "193": {"vr": "SL", "Value": [12338]}, "194": {"vr": "SL", "Value": [12322]}, "195": {"vr": "SL", "Value": [12331]}, "196": {"vr": "SL", "Value": [12312]}, "197": {"vr": "SL", "Value": [12339]}, "198": {"vr": "SL", "Value": [12295]}, "199": {"vr": "SL", "Value": [12346]}, "200": {"vr": "SL", "Value": [12300]}, "201": {"vr": "SL", "Value": [12308]}, "202": {"vr": "SL", "Value": [12309]}, "203": {"vr": "SL", "Value": [12328]}, "204": {"vr": "SL", "Value": [12347]}, "205": {"vr": "SL", "Value": [12323]}, "206": {"vr": "SL", "Value": [12305]}, "207": {"vr": "SL", "Value": [12302]}, "208": {"vr": "SL", "Value": [12329]}, "209": {"vr": "SL", "Value": [12336]}, "210": {"vr": "SL", "Value": [12290]}, "211": {"vr": "SL", "Value": [12294]}, "212": {"vr": "SL", "Value": [12311]}, "213": {"vr": "SL", "Value": [12333]}, "214": {"vr": "SL", "Value": [12293]}, "215": {"vr": "SL", "Value": [12316]}, "216": {"vr": "SL", "Value": [12300]}, "217": {"vr": "SL", "Value": [12335]}, "218": {"vr": "SL", "Value": [12333]}, "219": {"vr": "SL", "Value": [12292]}, "220": {"vr": "SL", "Value": [12303]}, "221": {"vr": "SL", "Value": [12334]}, "222": {"vr": "SL", "Value": [12298]}, "223": {"vr": "SL", "Value": [12341]}, "224": {"vr": "SL", "Value": [12299]}, "225": {"vr": "SL", "Value": [12318]}, "226": {"vr": "SL", "Value": [12305]}, "227": {"vr": "SL", "Value": [12307]}, "228": {"vr": "SL", "Value": [12344]}, "229": {"vr": "SL", "Value": [12300]}, "230": {"vr": "SL", "Value": [12318]}, "231": {"vr": "SL", "Value": [12315]}, "232": {"vr": "SL", "Value": [12304]}, "233": {"vr": "SL", "Value": [12311]}, "234": {"vr": "SL", "Value": [12320]}, "235": {"vr": "SL", "Value": [12330]}, "236": {"vr": "SL", "Value": [12324]}, "237": {"vr": "SL", "Value": [12296]}, "238": {"vr": "SL", "Value": [12301]}, "239": {"vr": "SL", "Value": [12297]}}, "00200013": {"0": {"vr": "IS", "Value": [184]}, "1": {"vr": "IS", "Value": [7]}, "2": {"vr": "IS", "Value": [125]}, "3": {"vr": "IS", "Value": [161]}, "4": {"vr": "IS", "Value": [105]}, "5": {"vr": "IS", "Value": [94]}, "6": {"vr": "IS", "Value": [27]}, "7": {"vr": "IS", "Value": [10]}, "8": {"vr": "IS", "Value": [158]}, "9": {"vr": "IS", "Value": [63]}, "10": {"vr": "IS", "Value": [229]}, "11": {"vr": "IS", "Value": [75]}, "12": {"vr": "IS", "Value": [107]}, "13": {"vr": "IS", "Value": [199]}, "14": {"vr": "IS", "Value": [61]}, "15": {"vr": "IS", "Value": [150]}, "16": {"vr": "IS", "Value": [91]}, "17": {"vr": "IS", "Value": [48]}, "18": {"vr": "IS", "Value": [201]}, "19": {"vr": "IS", "Value": [209]}, "20": {"vr": "IS", "Value": [123]}, "21": {"vr": "IS", "Value": [43]}, "22": {"vr": "IS", "Value": [60]}, "23": {"vr": "IS", "Value": [204]}, "24": {"vr": "IS", "Value": [129]}, "25": {"vr": "IS", "Value": [109]}, "26": {"vr": "IS", "Value": [2]}, "27": {"vr": "IS", "Value": [19]}, "28": {"vr": "IS", "Value": [29]}, "29": {"vr": "IS", "Value": [180]}, "30": {"vr": "IS", "Value": [170]}, "31": {"vr": "IS", "Value": [104]}, "32": {"vr": "IS", "Value": [193]}, "33": {"vr": "IS", "Value": [130]}, "34": {"vr": "IS", "Value": [222]}, "35": {"vr": "IS", "Value": [20]}, "36": {"vr": "IS", "Value": [230]}, "37": {"vr": "IS", "Value": [149]}, "38": {"vr": "IS", "Value": [101]}, "39": {"vr": "IS", "Value": [155]}, "40": {"vr": "IS", "Value": [145]}, "41": {"vr": "IS", "Value": [5]}, "42": {"vr": "IS", "Value": [30]}, "43": {"vr": "IS", "Value": [205]}, "44": {"vr": "IS", "Value": [24]}, "45": {"vr": "IS", "Value": [152]}, "46": {"vr": "IS", "Value": [88]}, "47": {"vr": "IS", "Value": [127]}, "48": {"vr": "IS", "Value": [188]}, "49": {"vr": "IS", "Value": [218]}, "50": {"vr": "IS", "Value": [41]}, "51": {"vr": "IS", "Value": [163]}, "52": {"vr": "IS", "Value": [110]}, "53": {"vr": "IS", "Value": [65]}, "54": {"vr": "IS", "Value": [169]}, "55": {"vr": "IS", "Value": [196]}, "56": {"vr": "IS", "Value": [135]}, "57": {"vr": "IS", "Value": [118]}, "58": {"vr": "IS", "Value": [178]}, "59": {"vr": "IS", "Value": [210]}, "60": {"vr": "IS", "Value": [212]}, "61": {"vr": "IS", "Value": [197]}, "62": {"vr": "IS", "Value": [165]}, "63": {"vr": "IS", "Value": [72]}, "64": {"vr": "IS", "Value": [140]}, "65": {"vr": "IS", "Value": [120]}, "66": {"vr": "IS", "Value": [151]}, "67": {"vr": "IS", "Value": [148]}, "68": {"vr": "IS", "Value": [8]}, "69": {"vr": "IS", "Value": [146]}, "70": {"vr": "IS", "Value": [195]}, "71": {"vr": "IS", "Value": [40]}, "72": {"vr": "IS", "Value": [142]}, "73": {"vr": "IS", "Value": [1]}, "74": {"vr": "IS", "Value": [39]}, "75": {"vr": "IS", "Value": [4]}, "76": {"vr": "IS", "Value": [190]}, "77": {"vr": "IS", "Value": [71]}, "78": {"vr": "IS", "Value": [86]}, "79": {"vr": "IS", "Value": [28]}, "80": {"vr": "IS", "Value": [157]}, "81": {"vr": "IS", "Value": [154]}, "82": {"vr": "IS", "Value": [182]}, "83": {"vr": "IS", "Value": [136]}, "84": {"vr": "IS", "Value": [156]}, "85": {"vr": "IS", "Value": [233]}, "86": {"vr": "IS", "Value": [47]}, "87": {"vr": "IS", "Value": [228]}, "88": {"vr": "IS", "Value": [79]}, "89": {"vr": "IS", "Value": [53]}, "90": {"vr": "IS", "Value": [73]}, "91": {"vr": "IS", "Value": [226]}, "92": {"vr": "IS", "Value": [66]}, "93": {"vr": "IS", "Value": [139]}, "94": {"vr": "IS", "Value": [113]}, "95": {"vr": "IS", "Value": [187]}, "96": {"vr": "IS", "Value": [92]}, "97": {"vr": "IS", "Value": [128]}, "98": {"vr": "IS", "Value": [13]}, "99": {"vr": "IS", "Value": [240]}, "100": {"vr": "IS", "Value": [198]}, "101": {"vr": "IS", "Value": [134]}, "102": {"vr": "IS", "Value": [143]}, "103": {"vr": "IS", "Value": [117]}, "104": {"vr": "IS", "Value": [177]}, "105": {"vr": "IS", "Value": [166]}, "106": {"vr": "IS", "Value": [58]}, "107": {"vr": "IS", "Value": [221]}, "108": {"vr": "IS", "Value": [106]}, "109": {"vr": "IS", "Value": [102]}, "110": {"vr": "IS", "Value": [162]}, "111": {"vr": "IS", "Value": [9]}, "112": {"vr": "IS", "Value": [224]}, "113": {"vr": "IS", "Value": [219]}, "114": {"vr": "IS", "Value": [239]}, "115": {"vr": "IS", "Value": [77]}, "116": {"vr": "IS", "Value": [108]}, "117": {"vr": "IS", "Value": [83]}, "118": {"vr": "IS", "Value": [206]}, "119": {"vr": "IS", "Value": [189]}, "120": {"vr": "IS", "Value": [217]}, "121": {"vr": "IS", "Value": [34]}, "122": {"vr": "IS", "Value": [22]}, "123": {"vr": "IS", "Value": [202]}, "124": {"vr": "IS", "Value": [160]}, "125": {"vr": "IS", "Value": [174]}, "126": {"vr": "IS", "Value": [87]}, "127": {"vr": "IS", "Value": [14]}, "128": {"vr": "IS", "Value": [97]}, "129": {"vr": "IS", "Value": [185]}, "130": {"vr": "IS", "Value": [237]}, "131": {"vr": "IS", "Value": [111]}, "132": {"vr": "IS", "Value": [213]}, "133": {"vr": "IS", "Value": [122]}, "134": {"vr": "IS", "Value": [208]}, "135": {"vr": "IS", "Value": [84]}, "136": {"vr": "IS", "Value": [37]}, "137": {"vr": "IS", "Value": [131]}, "138": {"vr": "IS", "Value": [89]}, "139": {"vr": "IS", "Value": [144]}, "140": {"vr": "IS", "Value": [56]}, "141": {"vr": "IS", "Value": [211]}, "142": {"vr": "IS", "Value": [231]}, "143": {"vr": "IS", "Value": [119]}, "144": {"vr": "IS", "Value": [95]}, "145": {"vr": "IS", "Value": [168]}, "146": {"vr": "IS", "Value": [133]}, "147": {"vr": "IS", "Value": [76]}, "148": {"vr": "IS", "Value": [116]}, "149": {"vr": "IS", "Value": [200]}, "150": {"vr": "IS", "Value": [223]}, "151": {"vr": "IS", "Value": [214]}, "152": {"vr": "IS", "Value": [33]}, "153": {"vr": "IS", "Value": [51]}, "154": {"vr": "IS", "Value": [179]}, "155": {"vr": "IS", "Value": [137]}, "156": {"vr": "IS", "Value": [126]}, "157": {"vr": "IS", "Value": [81]}, "158": {"vr": "IS", "Value": [68]}, "159": {"vr": "IS", "Value": [173]}, "160": {"vr": "IS", "Value": [54]}, "161": {"vr": "IS", "Value": [176]}, "162": {"vr": "IS", "Value": [220]}, "163": {"vr": "IS", "Value": [234]}, "164": {"vr": "IS", "Value": [171]}, "165": {"vr": "IS", "Value": [159]}, "166": {"vr": "IS", "Value": [26]}, "167": {"vr": "IS", "Value": [153]}, "168": {"vr": "IS", "Value": [36]}, "169": {"vr": "IS", "Value": [3]}, "170": {"vr": "IS", "Value": [18]}, "171": {"vr": "IS", "Value": [11]}, "172": {"vr": "IS", "Value": [100]}, "173": {"vr": "IS", "Value": [16]}, "174": {"vr": "IS", "Value": [192]}, "175": {"vr": "IS", "Value": [6]}, "176": {"vr": "IS", "Value": [74]}, "177": {"vr": "IS", "Value": [90]}, "178": {"vr": "IS", "Value": [31]}, "179": {"vr": "IS", "Value": [235]}, "180": {"vr": "IS", "Value": [62]}, "181": {"vr": "IS", "Value": [114]}, "182": {"vr": "IS", "Value": [216]}, "183": {"vr": "IS", "Value": [45]}, "184": {"vr": "IS", "Value": [42]}, "185": {"vr": "IS", "Value": [103]}, "186": {"vr": "IS", "Value": [15]}, "187": {"vr": "IS", "Value": [232]}, "188": {"vr": "IS", "Value": [59]}, "189": {"vr": "IS", "Value": [225]}, "190": {"vr": "IS", "Value": [99]}, "191": {"vr": "IS", "Value": [80]}, "192": {"vr": "IS", "Value": [23]}, "193": {"vr": "IS", "Value": [203]}, "194": {"vr": "IS", "Value": [138]}, "195": {"vr": "IS", "Value": [175]}, "196": {"vr": "IS", "Value": [98]}, "197": {"vr": "IS", "Value": [207]}, "198": {"vr": "IS", "Value": [32]}, "199": {"vr": "IS", "Value": [236]}, "200": {"vr": "IS", "Value": [49]}, "201": {"vr": "IS", "Value": [82]}, "202": {"vr": "IS", "Value": [85]}, "203": {"vr": "IS", "Value": [164]}, "204": {"vr": "IS", "Value": [238]}, "205": {"vr": "IS", "Value": [141]}, "206": {"vr": "IS", "Value": [70]}, "207": {"vr": "IS", "Value": [57]}, "208": {"vr": "IS", "Value": [167]}, "209": {"vr": "IS", "Value": [194]}, "210": {"vr": "IS", "Value": [12]}, "211": {"vr": "IS", "Value": [25]}, "212": {"vr": "IS", "Value": [96]}, "213": {"vr": "IS", "Value": [183]}, "214": {"vr": "IS", "Value": [21]}, "215": {"vr": "IS", "Value": [115]}, "216": {"vr": "IS", "Value": [50]}, "217": {"vr": "IS", "Value": [191]}, "218": {"vr": "IS", "Value": [181]}, "219": {"vr": "IS", "Value": [17]}, "220": {"vr": "IS", "Value": [64]}, "221": {"vr": "IS", "Value": [186]}, "222": {"vr": "IS", "Value": [44]}, "223": {"vr": "IS", "Value": [215]}, "224": {"vr": "IS", "Value": [46]}, "225": {"vr": "IS", "Value": [124]}, "226": {"vr": "IS", "Value": [69]}, "227": {"vr": "IS", "Value": [78]}, "228": {"vr": "IS", "Value": [227]}, "229": {"vr": "IS", "Value": [52]}, "230": {"vr": "IS", "Value": [121]}, "231": {"vr": "IS", "Value": [112]}, "232": {"vr": "IS", "Value": [67]}, "233": {"vr": "IS", "Value": [93]}, "234": {"vr": "IS", "Value": [132]}, "235": {"vr": "IS", "Value": [172]}, "236": {"vr": "IS", "Value": [147]}, "237": {"vr": "IS", "Value": [35]}, "238": {"vr": "IS", "Value": [55]}, "239": {"vr": "IS", "Value": [38]}}, "00200032": {"0": {"vr": "DS", "Value": [-126.72, -106.111, 95.3752]}, "1": {"vr": "DS", "Value": [-126.411, -153.047, -4.10795]}, "2": {"vr": "DS", "Value": [-126.621, -121.045, 63.7214]}, "3": {"vr": "DS", "Value": [-126.685, -111.445, 84.0703]}, "4": {"vr": "DS", "Value": [-126.586, -126.379, 52.4165]}, "5": {"vr": "DS", "Value": [-126.565, -129.579, 45.6336]}, "6": {"vr": "DS", "Value": [-126.446, -147.714, 7.19694]}, "7": {"vr": "DS", "Value": [-126.418, -151.981, -1.84698]}, "8": {"vr": "DS", "Value": [-126.678, -112.512, 81.8093]}, "9": {"vr": "DS", "Value": [-126.509, -138.113, 27.5458]}, "10": {"vr": "DS", "Value": [-126.804, -93.3103, 122.507]}, "11": {"vr": "DS", "Value": [-126.53, -134.913, 34.3287]}, "12": {"vr": "DS", "Value": [-126.586, -126.379, 52.4165]}, "13": {"vr": "DS", "Value": [-126.748, -101.844, 104.419]}, "14": {"vr": "DS", "Value": [-126.509, -138.113, 27.5458]}, "15": {"vr": "DS", "Value": [-126.664, -114.645, 77.2873]}, "16": {"vr": "DS", "Value": [-126.558, -130.646, 43.3726]}, "17": {"vr": "DS", "Value": [-126.481, -142.38, 18.5018]}, "18": {"vr": "DS", "Value": [-126.755, -100.777, 106.68]}, "19": {"vr": "DS", "Value": [-126.769, -98.644, 111.202]}, "20": {"vr": "DS", "Value": [-126.614, -122.112, 61.4605]}, "21": {"vr": "DS", "Value": [-126.474, -143.447, 16.2409]}, "22": {"vr": "DS", "Value": [-126.502, -139.18, 25.2848]}, "23": {"vr": "DS", "Value": [-126.755, -100.777, 106.68]}, "24": {"vr": "DS", "Value": [-126.629, -119.979, 65.9824]}, "25": {"vr": "DS", "Value": [-126.593, -125.312, 54.6775]}, "26": {"vr": "DS", "Value": [-126.404, -154.114, -6.36893]}, "27": {"vr": "DS", "Value": [-126.432, -149.847, 2.67498]}, "28": {"vr": "DS", "Value": [-126.453, -146.647, 9.45792]}, "29": {"vr": "DS", "Value": [-126.713, -107.178, 93.1142]}, "30": {"vr": "DS", "Value": [-126.699, -109.311, 88.5922]}, "31": {"vr": "DS", "Value": [-126.579, -127.446, 50.1556]}, "32": {"vr": "DS", "Value": [-126.741, -102.911, 102.158]}, "33": {"vr": "DS", "Value": [-126.629, -119.979, 65.9824]}, "34": {"vr": "DS", "Value": [-126.79, -95.4438, 117.985]}, "35": {"vr": "DS", "Value": [-126.432, -149.847, 2.67498]}, "36": {"vr": "DS", "Value": [-126.804, -93.3103, 122.507]}, "37": {"vr": "DS", "Value": [-126.664, -114.645, 77.2873]}, "38": {"vr": "DS", "Value": [-126.579, -127.446, 50.1556]}, "39": {"vr": "DS", "Value": [-126.671, -113.578, 79.5483]}, "40": {"vr": "DS", "Value": [-126.657, -115.712, 75.0263]}, "41": {"vr": "DS", "Value": [-126.411, -153.047, -4.10795]}, "42": {"vr": "DS", "Value": [-126.453, -146.647, 9.45792]}, "43": {"vr": "DS", "Value": [-126.762, -99.7107, 108.941]}, "44": {"vr": "DS", "Value": [-126.439, -148.781, 4.93596]}, "45": {"vr": "DS", "Value": [-126.664, -114.645, 77.2873]}, "46": {"vr": "DS", "Value": [-126.551, -131.713, 41.1116]}, "47": {"vr": "DS", "Value": [-126.621, -121.045, 63.7214]}, "48": {"vr": "DS", "Value": [-126.727, -105.044, 97.6361]}, "49": {"vr": "DS", "Value": [-126.783, -96.5105, 115.724]}, "50": {"vr": "DS", "Value": [-126.474, -143.447, 16.2409]}, "51": {"vr": "DS", "Value": [-126.685, -111.445, 84.0703]}, "52": {"vr": "DS", "Value": [-126.593, -125.312, 54.6775]}, "53": {"vr": "DS", "Value": [-126.516, -137.046, 29.8067]}, "54": {"vr": "DS", "Value": [-126.699, -109.311, 88.5922]}, "55": {"vr": "DS", "Value": [-126.741, -102.911, 102.158]}, "56": {"vr": "DS", "Value": [-126.636, -118.912, 68.2434]}, "57": {"vr": "DS", "Value": [-126.607, -123.179, 59.1995]}, "58": {"vr": "DS", "Value": [-126.713, -107.178, 93.1142]}, "59": {"vr": "DS", "Value": [-126.769, -98.644, 111.202]}, "60": {"vr": "DS", "Value": [-126.769, -98.644, 111.202]}, "61": {"vr": "DS", "Value": [-126.748, -101.844, 104.419]}, "62": {"vr": "DS", "Value": [-126.692, -110.378, 86.3312]}, "63": {"vr": "DS", "Value": [-126.523, -135.98, 32.0677]}, "64": {"vr": "DS", "Value": [-126.643, -117.845, 70.5044]}, "65": {"vr": "DS", "Value": [-126.607, -123.179, 59.1995]}, "66": {"vr": "DS", "Value": [-126.664, -114.645, 77.2873]}, "67": {"vr": "DS", "Value": [-126.657, -115.712, 75.0263]}, "68": {"vr": "DS", "Value": [-126.411, -153.047, -4.10795]}, "69": {"vr": "DS", "Value": [-126.657, -115.712, 75.0263]}, "70": {"vr": "DS", "Value": [-126.741, -102.911, 102.158]}, "71": {"vr": "DS", "Value": [-126.467, -144.514, 13.9799]}, "72": {"vr": "DS", "Value": [-126.65, -116.778, 72.7654]}, "73": {"vr": "DS", "Value": [-126.404, -154.114, -6.36893]}, "74": {"vr": "DS", "Value": [-126.467, -144.514, 13.9799]}, "75": {"vr": "DS", "Value": [-126.404, -154.114, -6.36893]}, "76": {"vr": "DS", "Value": [-126.734, -103.978, 99.8971]}, "77": {"vr": "DS", "Value": [-126.523, -135.98, 32.0677]}, "78": {"vr": "DS", "Value": [-126.551, -131.713, 41.1116]}, "79": {"vr": "DS", "Value": [-126.446, -147.714, 7.19694]}, "80": {"vr": "DS", "Value": [-126.678, -112.512, 81.8093]}, "81": {"vr": "DS", "Value": [-126.671, -113.578, 79.5483]}, "82": {"vr": "DS", "Value": [-126.72, -106.111, 95.3752]}, "83": {"vr": "DS", "Value": [-126.636, -118.912, 68.2434]}, "84": {"vr": "DS", "Value": [-126.671, -113.578, 79.5483]}, "85": {"vr": "DS", "Value": [-126.811, -92.2436, 124.768]}, "86": {"vr": "DS", "Value": [-126.481, -142.38, 18.5018]}, "87": {"vr": "DS", "Value": [-126.797, -94.377, 120.246]}, "88": {"vr": "DS", "Value": [-126.537, -133.846, 36.5897]}, "89": {"vr": "DS", "Value": [-126.495, -140.247, 23.0238]}, "90": {"vr": "DS", "Value": [-126.53, -134.913, 34.3287]}, "91": {"vr": "DS", "Value": [-126.797, -94.377, 120.246]}, "92": {"vr": "DS", "Value": [-126.516, -137.046, 29.8067]}, "93": {"vr": "DS", "Value": [-126.643, -117.845, 70.5044]}, "94": {"vr": "DS", "Value": [-126.6, -124.246, 56.9385]}, "95": {"vr": "DS", "Value": [-126.727, -105.044, 97.6361]}, "96": {"vr": "DS", "Value": [-126.558, -130.646, 43.3726]}, "97": {"vr": "DS", "Value": [-126.621, -121.045, 63.7214]}, "98": {"vr": "DS", "Value": [-126.425, -150.914, 0.414003]}, "99": {"vr": "DS", "Value": [-126.818, -91.1768, 127.029]}, "100": {"vr": "DS", "Value": [-126.748, -101.844, 104.419]}, "101": {"vr": "DS", "Value": [-126.636, -118.912, 68.2434]}, "102": {"vr": "DS", "Value": [-126.65, -116.778, 72.7654]}, "103": {"vr": "DS", "Value": [-126.607, -123.179, 59.1995]}, "104": {"vr": "DS", "Value": [-126.713, -107.178, 93.1142]}, "105": {"vr": "DS", "Value": [-126.692, -110.378, 86.3312]}, "106": {"vr": "DS", "Value": [-126.502, -139.18, 25.2848]}, "107": {"vr": "DS", "Value": [-126.79, -95.4438, 117.985]}, "108": {"vr": "DS", "Value": [-126.586, -126.379, 52.4165]}, "109": {"vr": "DS", "Value": [-126.579, -127.446, 50.1556]}, "110": {"vr": "DS", "Value": [-126.685, -111.445, 84.0703]}, "111": {"vr": "DS", "Value": [-126.418, -151.981, -1.84698]}, "112": {"vr": "DS", "Value": [-126.79, -95.4438, 117.985]}, "113": {"vr": "DS", "Value": [-126.783, -96.5105, 115.724]}, "114": {"vr": "DS", "Value": [-126.818, -91.1768, 127.029]}, "115": {"vr": "DS", "Value": [-126.537, -133.846, 36.5897]}, "116": {"vr": "DS", "Value": [-126.586, -126.379, 52.4165]}, "117": {"vr": "DS", "Value": [-126.544, -132.78, 38.8507]}, "118": {"vr": "DS", "Value": [-126.762, -99.7107, 108.941]}, "119": {"vr": "DS", "Value": [-126.734, -103.978, 99.8971]}, "120": {"vr": "DS", "Value": [-126.783, -96.5105, 115.724]}, "121": {"vr": "DS", "Value": [-126.46, -145.58, 11.7189]}, "122": {"vr": "DS", "Value": [-126.439, -148.781, 4.93596]}, "123": {"vr": "DS", "Value": [-126.755, -100.777, 106.68]}, "124": {"vr": "DS", "Value": [-126.678, -112.512, 81.8093]}, "125": {"vr": "DS", "Value": [-126.706, -108.245, 90.8532]}, "126": {"vr": "DS", "Value": [-126.551, -131.713, 41.1116]}, "127": {"vr": "DS", "Value": [-126.425, -150.914, 0.414003]}, "128": {"vr": "DS", "Value": [-126.572, -128.513, 47.8946]}, "129": {"vr": "DS", "Value": [-126.727, -105.044, 97.6361]}, "130": {"vr": "DS", "Value": [-126.818, -91.1768, 127.029]}, "131": {"vr": "DS", "Value": [-126.593, -125.312, 54.6775]}, "132": {"vr": "DS", "Value": [-126.776, -97.5773, 113.463]}, "133": {"vr": "DS", "Value": [-126.614, -122.112, 61.4605]}, "134": {"vr": "DS", "Value": [-126.762, -99.7107, 108.941]}, "135": {"vr": "DS", "Value": [-126.544, -132.78, 38.8507]}, "136": {"vr": "DS", "Value": [-126.467, -144.514, 13.9799]}, "137": {"vr": "DS", "Value": [-126.629, -119.979, 65.9824]}, "138": {"vr": "DS", "Value": [-126.558, -130.646, 43.3726]}, "139": {"vr": "DS", "Value": [-126.65, -116.778, 72.7654]}, "140": {"vr": "DS", "Value": [-126.495, -140.247, 23.0238]}, "141": {"vr": "DS", "Value": [-126.769, -98.644, 111.202]}, "142": {"vr": "DS", "Value": [-126.804, -93.3103, 122.507]}, "143": {"vr": "DS", "Value": [-126.607, -123.179, 59.1995]}, "144": {"vr": "DS", "Value": [-126.565, -129.579, 45.6336]}, "145": {"vr": "DS", "Value": [-126.692, -110.378, 86.3312]}, "146": {"vr": "DS", "Value": [-126.636, -118.912, 68.2434]}, "147": {"vr": "DS", "Value": [-126.53, -134.913, 34.3287]}, "148": {"vr": "DS", "Value": [-126.6, -124.246, 56.9385]}, "149": {"vr": "DS", "Value": [-126.748, -101.844, 104.419]}, "150": {"vr": "DS", "Value": [-126.79, -95.4438, 117.985]}, "151": {"vr": "DS", "Value": [-126.776, -97.5773, 113.463]}, "152": {"vr": "DS", "Value": [-126.46, -145.58, 11.7189]}, "153": {"vr": "DS", "Value": [-126.488, -141.313, 20.7628]}, "154": {"vr": "DS", "Value": [-126.713, -107.178, 93.1142]}, "155": {"vr": "DS", "Value": [-126.643, -117.845, 70.5044]}, "156": {"vr": "DS", "Value": [-126.621, -121.045, 63.7214]}, "157": {"vr": "DS", "Value": [-126.544, -132.78, 38.8507]}, "158": {"vr": "DS", "Value": [-126.516, -137.046, 29.8067]}, "159": {"vr": "DS", "Value": [-126.706, -108.245, 90.8532]}, "160": {"vr": "DS", "Value": [-126.495, -140.247, 23.0238]}, "161": {"vr": "DS", "Value": [-126.706, -108.245, 90.8532]}, "162": {"vr": "DS", "Value": [-126.783, -96.5105, 115.724]}, "163": {"vr": "DS", "Value": [-126.811, -92.2436, 124.768]}, "164": {"vr": "DS", "Value": [-126.699, -109.311, 88.5922]}, "165": {"vr": "DS", "Value": [-126.678, -112.512, 81.8093]}, "166": {"vr": "DS", "Value": [-126.446, -147.714, 7.19694]}, "167": {"vr": "DS", "Value": [-126.671, -113.578, 79.5483]}, "168": {"vr": "DS", "Value": [-126.46, -145.58, 11.7189]}, "169": {"vr": "DS", "Value": [-126.404, -154.114, -6.36893]}, "170": {"vr": "DS", "Value": [-126.432, -149.847, 2.67498]}, "171": {"vr": "DS", "Value": [-126.418, -151.981, -1.84698]}, "172": {"vr": "DS", "Value": [-126.572, -128.513, 47.8946]}, "173": {"vr": "DS", "Value": [-126.425, -150.914, 0.414003]}, "174": {"vr": "DS", "Value": [-126.734, -103.978, 99.8971]}, "175": {"vr": "DS", "Value": [-126.411, -153.047, -4.10795]}, "176": {"vr": "DS", "Value": [-126.53, -134.913, 34.3287]}, "177": {"vr": "DS", "Value": [-126.558, -130.646, 43.3726]}, "178": {"vr": "DS", "Value": [-126.453, -146.647, 9.45792]}, "179": {"vr": "DS", "Value": [-126.811, -92.2436, 124.768]}, "180": {"vr": "DS", "Value": [-126.509, -138.113, 27.5458]}, "181": {"vr": "DS", "Value": [-126.6, -124.246, 56.9385]}, "182": {"vr": "DS", "Value": [-126.776, -97.5773, 113.463]}, "183": {"vr": "DS", "Value": [-126.481, -142.38, 18.5018]}, "184": {"vr": "DS", "Value": [-126.474, -143.447, 16.2409]}, "185": {"vr": "DS", "Value": [-126.579, -127.446, 50.1556]}, "186": {"vr": "DS", "Value": [-126.425, -150.914, 0.414003]}, "187": {"vr": "DS", "Value": [-126.804, -93.3103, 122.507]}, "188": {"vr": "DS", "Value": [-126.502, -139.18, 25.2848]}, "189": {"vr": "DS", "Value": [-126.797, -94.377, 120.246]}, "190": {"vr": "DS", "Value": [-126.572, -128.513, 47.8946]}, "191": {"vr": "DS", "Value": [-126.537, -133.846, 36.5897]}, "192": {"vr": "DS", "Value": [-126.439, -148.781, 4.93596]}, "193": {"vr": "DS", "Value": [-126.755, -100.777, 106.68]}, "194": {"vr": "DS", "Value": [-126.643, -117.845, 70.5044]}, "195": {"vr": "DS", "Value": [-126.706, -108.245, 90.8532]}, "196": {"vr": "DS", "Value": [-126.572, -128.513, 47.8946]}, "197": {"vr": "DS", "Value": [-126.762, -99.7107, 108.941]}, "198": {"vr": "DS", "Value": [-126.453, -146.647, 9.45792]}, "199": {"vr": "DS", "Value": [-126.811, -92.2436, 124.768]}, "200": {"vr": "DS", "Value": [-126.488, -141.313, 20.7628]}, "201": {"vr": "DS", "Value": [-126.544, -132.78, 38.8507]}, "202": {"vr": "DS", "Value": [-126.551, -131.713, 41.1116]}, "203": {"vr": "DS", "Value": [-126.685, -111.445, 84.0703]}, "204": {"vr": "DS", "Value": [-126.818, -91.1768, 127.029]}, "205": {"vr": "DS", "Value": [-126.65, -116.778, 72.7654]}, "206": {"vr": "DS", "Value": [-126.523, -135.98, 32.0677]}, "207": {"vr": "DS", "Value": [-126.502, -139.18, 25.2848]}, "208": {"vr": "DS", "Value": [-126.692, -110.378, 86.3312]}, "209": {"vr": "DS", "Value": [-126.741, -102.911, 102.158]}, "210": {"vr": "DS", "Value": [-126.418, -151.981, -1.84698]}, "211": {"vr": "DS", "Value": [-126.446, -147.714, 7.19694]}, "212": {"vr": "DS", "Value": [-126.565, -129.579, 45.6336]}, "213": {"vr": "DS", "Value": [-126.72, -106.111, 95.3752]}, "214": {"vr": "DS", "Value": [-126.439, -148.781, 4.93596]}, "215": {"vr": "DS", "Value": [-126.6, -124.246, 56.9385]}, "216": {"vr": "DS", "Value": [-126.488, -141.313, 20.7628]}, "217": {"vr": "DS", "Value": [-126.734, -103.978, 99.8971]}, "218": {"vr": "DS", "Value": [-126.72, -106.111, 95.3752]}, "219": {"vr": "DS", "Value": [-126.432, -149.847, 2.67498]}, "220": {"vr": "DS", "Value": [-126.509, -138.113, 27.5458]}, "221": {"vr": "DS", "Value": [-126.727, -105.044, 97.6361]}, "222": {"vr": "DS", "Value": [-126.474, -143.447, 16.2409]}, "223": {"vr": "DS", "Value": [-126.776, -97.5773, 113.463]}, "224": {"vr": "DS", "Value": [-126.481, -142.38, 18.5018]}, "225": {"vr": "DS", "Value": [-126.614, -122.112, 61.4605]}, "226": {"vr": "DS", "Value": [-126.523, -135.98, 32.0677]}, "227": {"vr": "DS", "Value": [-126.537, -133.846, 36.5897]}, "228": {"vr": "DS", "Value": [-126.797, -94.377, 120.246]}, "229": {"vr": "DS", "Value": [-126.488, -141.313, 20.7628]}, "230": {"vr": "DS", "Value": [-126.614, -122.112, 61.4605]}, "231": {"vr": "DS", "Value": [-126.593, -125.312, 54.6775]}, "232": {"vr": "DS", "Value": [-126.516, -137.046, 29.8067]}, "233": {"vr": "DS", "Value": [-126.565, -129.579, 45.6336]}, "234": {"vr": "DS", "Value": [-126.629, -119.979, 65.9824]}, "235": {"vr": "DS", "Value": [-126.699, -109.311, 88.5922]}, "236": {"vr": "DS", "Value": [-126.657, -115.712, 75.0263]}, "237": {"vr": "DS", "Value": [-126.46, -145.58, 11.7189]}, "238": {"vr": "DS", "Value": [-126.495, -140.247, 23.0238]}, "239": {"vr": "DS", "Value": [-126.467, -144.514, 13.9799]}}, "00200037": {"0": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "1": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "2": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "3": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "4": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "5": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "6": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "7": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "8": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "9": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999201679, 0.903963161737, -0.4265846304644]}, "10": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "11": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "12": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "13": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "14": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999201679, 0.903963161737, -0.4265846304644]}, "15": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "16": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "17": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "18": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "19": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "20": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "21": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "22": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "23": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "24": {"vr": "DS", "Value": [0.999557874956, 0.0279689161474, -0.010089318262, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "25": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "26": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "27": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "28": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "29": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "30": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "31": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "32": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "33": {"vr": "DS", "Value": [0.999557874956, 0.0279689161474, -0.010089318262, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "34": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "35": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "36": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "37": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "38": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "39": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "40": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "41": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "42": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "43": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "44": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "45": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "46": {"vr": "DS", "Value": [0.9995578742276, 0.0279689479162, -0.01008930236, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "47": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "48": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "49": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "50": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "51": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "52": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "53": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "54": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "55": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "56": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "57": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "58": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "59": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "60": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "61": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "62": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "63": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "64": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "65": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "66": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "67": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "68": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "69": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "70": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "71": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "72": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "73": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "74": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "75": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "76": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "77": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "78": {"vr": "DS", "Value": [0.9995578742276, 0.0279689479162, -0.01008930236, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "79": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "80": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "81": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "82": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "83": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "84": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "85": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "86": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "87": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "88": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "89": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "90": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "91": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "92": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "93": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "94": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "95": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "96": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "97": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "98": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "99": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "100": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "101": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "102": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "103": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "104": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "105": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "106": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "107": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "108": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "109": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "110": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "111": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "112": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "113": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "114": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "115": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "116": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "117": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "118": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "119": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "120": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "121": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "122": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "123": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "124": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "125": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "126": {"vr": "DS", "Value": [0.9995578742276, 0.0279689479162, -0.01008930236, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "127": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "128": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "129": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "130": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "131": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "132": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "133": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "134": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "135": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "136": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "137": {"vr": "DS", "Value": [0.999557874956, 0.0279689161474, -0.010089318262, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "138": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "139": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "140": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "141": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "142": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "143": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "144": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "145": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "146": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "147": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "148": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "149": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "150": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "151": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "152": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "153": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "154": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "155": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "156": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "157": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "158": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "159": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "160": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "161": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "162": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "163": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "164": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "165": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "166": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "167": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "168": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "169": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "170": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "171": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "172": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "173": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "174": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "175": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "176": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "177": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "178": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "179": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "180": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999201679, 0.903963161737, -0.4265846304644]}, "181": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "182": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "183": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "184": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "185": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "186": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "187": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "188": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "189": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "190": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "191": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "192": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "193": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "194": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "195": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "196": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "197": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "198": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "199": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "200": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "201": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "202": {"vr": "DS", "Value": [0.9995578742276, 0.0279689479162, -0.01008930236, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "203": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "204": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "205": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "206": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "207": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999211189, 0.903963158989, -0.4265846362217]}, "208": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "209": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "210": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "211": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "212": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "213": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "214": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}, "215": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "216": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "217": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "218": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "219": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "220": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999201679, 0.903963161737, -0.4265846304644]}, "221": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "222": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "223": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "224": {"vr": "DS", "Value": [0.9995578768937, 0.0279688526233, -0.010089302387, -0.0295999205693, 0.9039631739955, -0.4265846044601]}, "225": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "226": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "227": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "228": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "229": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "230": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "231": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "232": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999213196, 0.9039631651182, -0.4265846232196]}, "233": {"vr": "DS", "Value": [0.999557876005, 0.0279688843876, -0.010089302378, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "234": {"vr": "DS", "Value": [0.999557874956, 0.0279689161474, -0.010089318262, -0.0295999212192, 0.9039631620536, -0.4265846297206]}, "235": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "236": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999214199, 0.9039631681828, -0.4265846167185]}, "237": {"vr": "DS", "Value": [0.9995578751163, 0.0279689161519, -0.010089302369, -0.0295999210185, 0.9039631559244, -0.4265846427228]}, "238": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999220698, 0.9039631562409, -0.4265846419791]}, "239": {"vr": "DS", "Value": [0.9995578733389, 0.0279689796805, -0.0100893023511, -0.0295999222705, 0.9039631623701, -0.4265846289769]}}, "00201041": {"0": {"vr": "DS", "Value": [43.17898178]}, "1": {"vr": "DS", "Value": [-56.30413437]}, "2": {"vr": "DS", "Value": [11.52526379]}, "3": {"vr": "DS", "Value": [31.87408829]}, "4": {"vr": "DS", "Value": [0.2203613371]}, "5": {"vr": "DS", "Value": [-6.562580109]}, "6": {"vr": "DS", "Value": [-44.99924088]}, "7": {"vr": "DS", "Value": [-54.04315567]}, "8": {"vr": "DS", "Value": [29.61310768]}, "9": {"vr": "DS", "Value": [-24.65042496]}, "10": {"vr": "DS", "Value": [70.31072998]}, "11": {"vr": "DS", "Value": [-17.86748314]}, "12": {"vr": "DS", "Value": [0.2203613371]}, "13": {"vr": "DS", "Value": [52.22289658]}, "14": {"vr": "DS", "Value": [-24.65042496]}, "15": {"vr": "DS", "Value": [25.09114647]}, "16": {"vr": "DS", "Value": [-8.823560715]}, "17": {"vr": "DS", "Value": [-33.69434738]}, "18": {"vr": "DS", "Value": [54.48387527]}, "19": {"vr": "DS", "Value": [59.00583267]}, "20": {"vr": "DS", "Value": [9.26428318]}, "21": {"vr": "DS", "Value": [-35.95532608]}, "22": {"vr": "DS", "Value": [-26.91140556]}, "23": {"vr": "DS", "Value": [54.48387527]}, "24": {"vr": "DS", "Value": [13.78624439]}, "25": {"vr": "DS", "Value": [2.481341839]}, "26": {"vr": "DS", "Value": [-58.56511307]}, "27": {"vr": "DS", "Value": [-49.52119827]}, "28": {"vr": "DS", "Value": [-42.73826218]}, "29": {"vr": "DS", "Value": [40.91800308]}, "30": {"vr": "DS", "Value": [36.39604568]}, "31": {"vr": "DS", "Value": [-2.040619135]}, "32": {"vr": "DS", "Value": [49.96191788]}, "33": {"vr": "DS", "Value": [13.78624439]}, "34": {"vr": "DS", "Value": [65.78877258]}, "35": {"vr": "DS", "Value": [-49.52119827]}, "36": {"vr": "DS", "Value": [70.31072998]}, "37": {"vr": "DS", "Value": [25.09114647]}, "38": {"vr": "DS", "Value": [-2.040619135]}, "39": {"vr": "DS", "Value": [27.35212708]}, "40": {"vr": "DS", "Value": [22.83016586]}, "41": {"vr": "DS", "Value": [-56.30413437]}, "42": {"vr": "DS", "Value": [-42.73826218]}, "43": {"vr": "DS", "Value": [56.74485397]}, "44": {"vr": "DS", "Value": [-47.26021957]}, "45": {"vr": "DS", "Value": [25.09114647]}, "46": {"vr": "DS", "Value": [-11.08454132]}, "47": {"vr": "DS", "Value": [11.52526379]}, "48": {"vr": "DS", "Value": [45.43996048]}, "49": {"vr": "DS", "Value": [63.52779007]}, "50": {"vr": "DS", "Value": [-35.95532608]}, "51": {"vr": "DS", "Value": [31.87408829]}, "52": {"vr": "DS", "Value": [2.481341839]}, "53": {"vr": "DS", "Value": [-22.38944435]}, "54": {"vr": "DS", "Value": [36.39604568]}, "55": {"vr": "DS", "Value": [49.96191788]}, "56": {"vr": "DS", "Value": [16.04722404]}, "57": {"vr": "DS", "Value": [7.003303051]}, "58": {"vr": "DS", "Value": [40.91800308]}, "59": {"vr": "DS", "Value": [59.00583267]}, "60": {"vr": "DS", "Value": [59.00583267]}, "61": {"vr": "DS", "Value": [52.22289658]}, "62": {"vr": "DS", "Value": [34.13506699]}, "63": {"vr": "DS", "Value": [-20.12846375]}, "64": {"vr": "DS", "Value": [18.30820465]}, "65": {"vr": "DS", "Value": [7.003303051]}, "66": {"vr": "DS", "Value": [25.09114647]}, "67": {"vr": "DS", "Value": [22.83016586]}, "68": {"vr": "DS", "Value": [-56.30413437]}, "69": {"vr": "DS", "Value": [22.83016586]}, "70": {"vr": "DS", "Value": [49.96191788]}, "71": {"vr": "DS", "Value": [-38.21630478]}, "72": {"vr": "DS", "Value": [20.56918526]}, "73": {"vr": "DS", "Value": [-58.56511307]}, "74": {"vr": "DS", "Value": [-38.21630478]}, "75": {"vr": "DS", "Value": [-58.56511307]}, "76": {"vr": "DS", "Value": [47.70093918]}, "77": {"vr": "DS", "Value": [-20.12846375]}, "78": {"vr": "DS", "Value": [-11.08454132]}, "79": {"vr": "DS", "Value": [-44.99924088]}, "80": {"vr": "DS", "Value": [29.61310768]}, "81": {"vr": "DS", "Value": [27.35212708]}, "82": {"vr": "DS", "Value": [43.17898178]}, "83": {"vr": "DS", "Value": [16.04722404]}, "84": {"vr": "DS", "Value": [27.35212708]}, "85": {"vr": "DS", "Value": [72.57170868]}, "86": {"vr": "DS", "Value": [-33.69434738]}, "87": {"vr": "DS", "Value": [68.04975128]}, "88": {"vr": "DS", "Value": [-15.60650253]}, "89": {"vr": "DS", "Value": [-29.17238617]}, "90": {"vr": "DS", "Value": [-17.86748314]}, "91": {"vr": "DS", "Value": [68.04975128]}, "92": {"vr": "DS", "Value": [-22.38944435]}, "93": {"vr": "DS", "Value": [18.30820465]}, "94": {"vr": "DS", "Value": [4.742322445]}, "95": {"vr": "DS", "Value": [45.43996048]}, "96": {"vr": "DS", "Value": [-8.823560715]}, "97": {"vr": "DS", "Value": [11.52526379]}, "98": {"vr": "DS", "Value": [-51.78217697]}, "99": {"vr": "DS", "Value": [74.83268738]}, "100": {"vr": "DS", "Value": [52.22289658]}, "101": {"vr": "DS", "Value": [16.04722404]}, "102": {"vr": "DS", "Value": [20.56918526]}, "103": {"vr": "DS", "Value": [7.003303051]}, "104": {"vr": "DS", "Value": [40.91800308]}, "105": {"vr": "DS", "Value": [34.13506699]}, "106": {"vr": "DS", "Value": [-26.91140556]}, "107": {"vr": "DS", "Value": [65.78877258]}, "108": {"vr": "DS", "Value": [0.2203613371]}, "109": {"vr": "DS", "Value": [-2.040619135]}, "110": {"vr": "DS", "Value": [31.87408829]}, "111": {"vr": "DS", "Value": [-54.04315567]}, "112": {"vr": "DS", "Value": [65.78877258]}, "113": {"vr": "DS", "Value": [63.52779007]}, "114": {"vr": "DS", "Value": [74.83268738]}, "115": {"vr": "DS", "Value": [-15.60650253]}, "116": {"vr": "DS", "Value": [0.2203613371]}, "117": {"vr": "DS", "Value": [-13.34552193]}, "118": {"vr": "DS", "Value": [56.74485397]}, "119": {"vr": "DS", "Value": [47.70093918]}, "120": {"vr": "DS", "Value": [63.52779007]}, "121": {"vr": "DS", "Value": [-40.47728348]}, "122": {"vr": "DS", "Value": [-47.26021957]}, "123": {"vr": "DS", "Value": [54.48387527]}, "124": {"vr": "DS", "Value": [29.61310768]}, "125": {"vr": "DS", "Value": [38.65702438]}, "126": {"vr": "DS", "Value": [-11.08454132]}, "127": {"vr": "DS", "Value": [-51.78217697]}, "128": {"vr": "DS", "Value": [-4.301599503]}, "129": {"vr": "DS", "Value": [45.43996048]}, "130": {"vr": "DS", "Value": [74.83268738]}, "131": {"vr": "DS", "Value": [2.481341839]}, "132": {"vr": "DS", "Value": [61.26681137]}, "133": {"vr": "DS", "Value": [9.26428318]}, "134": {"vr": "DS", "Value": [56.74485397]}, "135": {"vr": "DS", "Value": [-13.34552193]}, "136": {"vr": "DS", "Value": [-38.21630478]}, "137": {"vr": "DS", "Value": [13.78624439]}, "138": {"vr": "DS", "Value": [-8.823560715]}, "139": {"vr": "DS", "Value": [20.56918526]}, "140": {"vr": "DS", "Value": [-29.17238617]}, "141": {"vr": "DS", "Value": [59.00583267]}, "142": {"vr": "DS", "Value": [70.31072998]}, "143": {"vr": "DS", "Value": [7.003303051]}, "144": {"vr": "DS", "Value": [-6.562580109]}, "145": {"vr": "DS", "Value": [34.13506699]}, "146": {"vr": "DS", "Value": [16.04722404]}, "147": {"vr": "DS", "Value": [-17.86748314]}, "148": {"vr": "DS", "Value": [4.742322445]}, "149": {"vr": "DS", "Value": [52.22289658]}, "150": {"vr": "DS", "Value": [65.78877258]}, "151": {"vr": "DS", "Value": [61.26681137]}, "152": {"vr": "DS", "Value": [-40.47728348]}, "153": {"vr": "DS", "Value": [-31.43336678]}, "154": {"vr": "DS", "Value": [40.91800308]}, "155": {"vr": "DS", "Value": [18.30820465]}, "156": {"vr": "DS", "Value": [11.52526379]}, "157": {"vr": "DS", "Value": [-13.34552193]}, "158": {"vr": "DS", "Value": [-22.38944435]}, "159": {"vr": "DS", "Value": [38.65702438]}, "160": {"vr": "DS", "Value": [-29.17238617]}, "161": {"vr": "DS", "Value": [38.65702438]}, "162": {"vr": "DS", "Value": [63.52779007]}, "163": {"vr": "DS", "Value": [72.57170868]}, "164": {"vr": "DS", "Value": [36.39604568]}, "165": {"vr": "DS", "Value": [29.61310768]}, "166": {"vr": "DS", "Value": [-44.99924088]}, "167": {"vr": "DS", "Value": [27.35212708]}, "168": {"vr": "DS", "Value": [-40.47728348]}, "169": {"vr": "DS", "Value": [-58.56511307]}, "170": {"vr": "DS", "Value": [-49.52119827]}, "171": {"vr": "DS", "Value": [-54.04315567]}, "172": {"vr": "DS", "Value": [-4.301599503]}, "173": {"vr": "DS", "Value": [-51.78217697]}, "174": {"vr": "DS", "Value": [47.70093918]}, "175": {"vr": "DS", "Value": [-56.30413437]}, "176": {"vr": "DS", "Value": [-17.86748314]}, "177": {"vr": "DS", "Value": [-8.823560715]}, "178": {"vr": "DS", "Value": [-42.73826218]}, "179": {"vr": "DS", "Value": [72.57170868]}, "180": {"vr": "DS", "Value": [-24.65042496]}, "181": {"vr": "DS", "Value": [4.742322445]}, "182": {"vr": "DS", "Value": [61.26681137]}, "183": {"vr": "DS", "Value": [-33.69434738]}, "184": {"vr": "DS", "Value": [-35.95532608]}, "185": {"vr": "DS", "Value": [-2.040619135]}, "186": {"vr": "DS", "Value": [-51.78217697]}, "187": {"vr": "DS", "Value": [70.31072998]}, "188": {"vr": "DS", "Value": [-26.91140556]}, "189": {"vr": "DS", "Value": [68.04975128]}, "190": {"vr": "DS", "Value": [-4.301599503]}, "191": {"vr": "DS", "Value": [-15.60650253]}, "192": {"vr": "DS", "Value": [-47.26021957]}, "193": {"vr": "DS", "Value": [54.48387527]}, "194": {"vr": "DS", "Value": [18.30820465]}, "195": {"vr": "DS", "Value": [38.65702438]}, "196": {"vr": "DS", "Value": [-4.301599503]}, "197": {"vr": "DS", "Value": [56.74485397]}, "198": {"vr": "DS", "Value": [-42.73826218]}, "199": {"vr": "DS", "Value": [72.57170868]}, "200": {"vr": "DS", "Value": [-31.43336678]}, "201": {"vr": "DS", "Value": [-13.34552193]}, "202": {"vr": "DS", "Value": [-11.08454132]}, "203": {"vr": "DS", "Value": [31.87408829]}, "204": {"vr": "DS", "Value": [74.83268738]}, "205": {"vr": "DS", "Value": [20.56918526]}, "206": {"vr": "DS", "Value": [-20.12846375]}, "207": {"vr": "DS", "Value": [-26.91140556]}, "208": {"vr": "DS", "Value": [34.13506699]}, "209": {"vr": "DS", "Value": [49.96191788]}, "210": {"vr": "DS", "Value": [-54.04315567]}, "211": {"vr": "DS", "Value": [-44.99924088]}, "212": {"vr": "DS", "Value": [-6.562580109]}, "213": {"vr": "DS", "Value": [43.17898178]}, "214": {"vr": "DS", "Value": [-47.26021957]}, "215": {"vr": "DS", "Value": [4.742322445]}, "216": {"vr": "DS", "Value": [-31.43336678]}, "217": {"vr": "DS", "Value": [47.70093918]}, "218": {"vr": "DS", "Value": [43.17898178]}, "219": {"vr": "DS", "Value": [-49.52119827]}, "220": {"vr": "DS", "Value": [-24.65042496]}, "221": {"vr": "DS", "Value": [45.43996048]}, "222": {"vr": "DS", "Value": [-35.95532608]}, "223": {"vr": "DS", "Value": [61.26681137]}, "224": {"vr": "DS", "Value": [-33.69434738]}, "225": {"vr": "DS", "Value": [9.26428318]}, "226": {"vr": "DS", "Value": [-20.12846375]}, "227": {"vr": "DS", "Value": [-15.60650253]}, "228": {"vr": "DS", "Value": [68.04975128]}, "229": {"vr": "DS", "Value": [-31.43336678]}, "230": {"vr": "DS", "Value": [9.26428318]}, "231": {"vr": "DS", "Value": [2.481341839]}, "232": {"vr": "DS", "Value": [-22.38944435]}, "233": {"vr": "DS", "Value": [-6.562580109]}, "234": {"vr": "DS", "Value": [13.78624439]}, "235": {"vr": "DS", "Value": [36.39604568]}, "236": {"vr": "DS", "Value": [22.83016586]}, "237": {"vr": "DS", "Value": [-40.47728348]}, "238": {"vr": "DS", "Value": [-29.17238617]}, "239": {"vr": "DS", "Value": [-38.21630478]}}, "00209057": {"0": {"vr": "UL", "Value": [46]}, "1": {"vr": "UL", "Value": [2]}, "2": {"vr": "UL", "Value": [32]}, "3": {"vr": "UL", "Value": [41]}, "4": {"vr": "UL", "Value": [27]}, "5": {"vr": "UL", "Value": [24]}, "6": {"vr": "UL", "Value": [7]}, "7": {"vr": "UL", "Value": [3]}, "8": {"vr": "UL", "Value": [40]}, "9": {"vr": "UL", "Value": [16]}, "10": {"vr": "UL", "Value": [58]}, "11": {"vr": "UL", "Value": [19]}, "12": {"vr": "UL", "Value": [27]}, "13": {"vr": "UL", "Value": [50]}, "14": {"vr": "UL", "Value": [16]}, "15": {"vr": "UL", "Value": [38]}, "16": {"vr": "UL", "Value": [23]}, "17": {"vr": "UL", "Value": [12]}, "18": {"vr": "UL", "Value": [51]}, "19": {"vr": "UL", "Value": [53]}, "20": {"vr": "UL", "Value": [31]}, "21": {"vr": "UL", "Value": [11]}, "22": {"vr": "UL", "Value": [15]}, "23": {"vr": "UL", "Value": [51]}, "24": {"vr": "UL", "Value": [33]}, "25": {"vr": "UL", "Value": [28]}, "26": {"vr": "UL", "Value": [1]}, "27": {"vr": "UL", "Value": [5]}, "28": {"vr": "UL", "Value": [8]}, "29": {"vr": "UL", "Value": [45]}, "30": {"vr": "UL", "Value": [43]}, "31": {"vr": "UL", "Value": [26]}, "32": {"vr": "UL", "Value": [49]}, "33": {"vr": "UL", "Value": [33]}, "34": {"vr": "UL", "Value": [56]}, "35": {"vr": "UL", "Value": [5]}, "36": {"vr": "UL", "Value": [58]}, "37": {"vr": "UL", "Value": [38]}, "38": {"vr": "UL", "Value": [26]}, "39": {"vr": "UL", "Value": [39]}, "40": {"vr": "UL", "Value": [37]}, "41": {"vr": "UL", "Value": [2]}, "42": {"vr": "UL", "Value": [8]}, "43": {"vr": "UL", "Value": [52]}, "44": {"vr": "UL", "Value": [6]}, "45": {"vr": "UL", "Value": [38]}, "46": {"vr": "UL", "Value": [22]}, "47": {"vr": "UL", "Value": [32]}, "48": {"vr": "UL", "Value": [47]}, "49": {"vr": "UL", "Value": [55]}, "50": {"vr": "UL", "Value": [11]}, "51": {"vr": "UL", "Value": [41]}, "52": {"vr": "UL", "Value": [28]}, "53": {"vr": "UL", "Value": [17]}, "54": {"vr": "UL", "Value": [43]}, "55": {"vr": "UL", "Value": [49]}, "56": {"vr": "UL", "Value": [34]}, "57": {"vr": "UL", "Value": [30]}, "58": {"vr": "UL", "Value": [45]}, "59": {"vr": "UL", "Value": [53]}, "60": {"vr": "UL", "Value": [53]}, "61": {"vr": "UL", "Value": [50]}, "62": {"vr": "UL", "Value": [42]}, "63": {"vr": "UL", "Value": [18]}, "64": {"vr": "UL", "Value": [35]}, "65": {"vr": "UL", "Value": [30]}, "66": {"vr": "UL", "Value": [38]}, "67": {"vr": "UL", "Value": [37]}, "68": {"vr": "UL", "Value": [2]}, "69": {"vr": "UL", "Value": [37]}, "70": {"vr": "UL", "Value": [49]}, "71": {"vr": "UL", "Value": [10]}, "72": {"vr": "UL", "Value": [36]}, "73": {"vr": "UL", "Value": [1]}, "74": {"vr": "UL", "Value": [10]}, "75": {"vr": "UL", "Value": [1]}, "76": {"vr": "UL", "Value": [48]}, "77": {"vr": "UL", "Value": [18]}, "78": {"vr": "UL", "Value": [22]}, "79": {"vr": "UL", "Value": [7]}, "80": {"vr": "UL", "Value": [40]}, "81": {"vr": "UL", "Value": [39]}, "82": {"vr": "UL", "Value": [46]}, "83": {"vr": "UL", "Value": [34]}, "84": {"vr": "UL", "Value": [39]}, "85": {"vr": "UL", "Value": [59]}, "86": {"vr": "UL", "Value": [12]}, "87": {"vr": "UL", "Value": [57]}, "88": {"vr": "UL", "Value": [20]}, "89": {"vr": "UL", "Value": [14]}, "90": {"vr": "UL", "Value": [19]}, "91": {"vr": "UL", "Value": [57]}, "92": {"vr": "UL", "Value": [17]}, "93": {"vr": "UL", "Value": [35]}, "94": {"vr": "UL", "Value": [29]}, "95": {"vr": "UL", "Value": [47]}, "96": {"vr": "UL", "Value": [23]}, "97": {"vr": "UL", "Value": [32]}, "98": {"vr": "UL", "Value": [4]}, "99": {"vr": "UL", "Value": [60]}, "100": {"vr": "UL", "Value": [50]}, "101": {"vr": "UL", "Value": [34]}, "102": {"vr": "UL", "Value": [36]}, "103": {"vr": "UL", "Value": [30]}, "104": {"vr": "UL", "Value": [45]}, "105": {"vr": "UL", "Value": [42]}, "106": {"vr": "UL", "Value": [15]}, "107": {"vr": "UL", "Value": [56]}, "108": {"vr": "UL", "Value": [27]}, "109": {"vr": "UL", "Value": [26]}, "110": {"vr": "UL", "Value": [41]}, "111": {"vr": "UL", "Value": [3]}, "112": {"vr": "UL", "Value": [56]}, "113": {"vr": "UL", "Value": [55]}, "114": {"vr": "UL", "Value": [60]}, "115": {"vr": "UL", "Value": [20]}, "116": {"vr": "UL", "Value": [27]}, "117": {"vr": "UL", "Value": [21]}, "118": {"vr": "UL", "Value": [52]}, "119": {"vr": "UL", "Value": [48]}, "120": {"vr": "UL", "Value": [55]}, "121": {"vr": "UL", "Value": [9]}, "122": {"vr": "UL", "Value": [6]}, "123": {"vr": "UL", "Value": [51]}, "124": {"vr": "UL", "Value": [40]}, "125": {"vr": "UL", "Value": [44]}, "126": {"vr": "UL", "Value": [22]}, "127": {"vr": "UL", "Value": [4]}, "128": {"vr": "UL", "Value": [25]}, "129": {"vr": "UL", "Value": [47]}, "130": {"vr": "UL", "Value": [60]}, "131": {"vr": "UL", "Value": [28]}, "132": {"vr": "UL", "Value": [54]}, "133": {"vr": "UL", "Value": [31]}, "134": {"vr": "UL", "Value": [52]}, "135": {"vr": "UL", "Value": [21]}, "136": {"vr": "UL", "Value": [10]}, "137": {"vr": "UL", "Value": [33]}, "138": {"vr": "UL", "Value": [23]}, "139": {"vr": "UL", "Value": [36]}, "140": {"vr": "UL", "Value": [14]}, "141": {"vr": "UL", "Value": [53]}, "142": {"vr": "UL", "Value": [58]}, "143": {"vr": "UL", "Value": [30]}, "144": {"vr": "UL", "Value": [24]}, "145": {"vr": "UL", "Value": [42]}, "146": {"vr": "UL", "Value": [34]}, "147": {"vr": "UL", "Value": [19]}, "148": {"vr": "UL", "Value": [29]}, "149": {"vr": "UL", "Value": [50]}, "150": {"vr": "UL", "Value": [56]}, "151": {"vr": "UL", "Value": [54]}, "152": {"vr": "UL", "Value": [9]}, "153": {"vr": "UL", "Value": [13]}, "154": {"vr": "UL", "Value": [45]}, "155": {"vr": "UL", "Value": [35]}, "156": {"vr": "UL", "Value": [32]}, "157": {"vr": "UL", "Value": [21]}, "158": {"vr": "UL", "Value": [17]}, "159": {"vr": "UL", "Value": [44]}, "160": {"vr": "UL", "Value": [14]}, "161": {"vr": "UL", "Value": [44]}, "162": {"vr": "UL", "Value": [55]}, "163": {"vr": "UL", "Value": [59]}, "164": {"vr": "UL", "Value": [43]}, "165": {"vr": "UL", "Value": [40]}, "166": {"vr": "UL", "Value": [7]}, "167": {"vr": "UL", "Value": [39]}, "168": {"vr": "UL", "Value": [9]}, "169": {"vr": "UL", "Value": [1]}, "170": {"vr": "UL", "Value": [5]}, "171": {"vr": "UL", "Value": [3]}, "172": {"vr": "UL", "Value": [25]}, "173": {"vr": "UL", "Value": [4]}, "174": {"vr": "UL", "Value": [48]}, "175": {"vr": "UL", "Value": [2]}, "176": {"vr": "UL", "Value": [19]}, "177": {"vr": "UL", "Value": [23]}, "178": {"vr": "UL", "Value": [8]}, "179": {"vr": "UL", "Value": [59]}, "180": {"vr": "UL", "Value": [16]}, "181": {"vr": "UL", "Value": [29]}, "182": {"vr": "UL", "Value": [54]}, "183": {"vr": "UL", "Value": [12]}, "184": {"vr": "UL", "Value": [11]}, "185": {"vr": "UL", "Value": [26]}, "186": {"vr": "UL", "Value": [4]}, "187": {"vr": "UL", "Value": [58]}, "188": {"vr": "UL", "Value": [15]}, "189": {"vr": "UL", "Value": [57]}, "190": {"vr": "UL", "Value": [25]}, "191": {"vr": "UL", "Value": [20]}, "192": {"vr": "UL", "Value": [6]}, "193": {"vr": "UL", "Value": [51]}, "194": {"vr": "UL", "Value": [35]}, "195": {"vr": "UL", "Value": [44]}, "196": {"vr": "UL", "Value": [25]}, "197": {"vr": "UL", "Value": [52]}, "198": {"vr": "UL", "Value": [8]}, "199": {"vr": "UL", "Value": [59]}, "200": {"vr": "UL", "Value": [13]}, "201": {"vr": "UL", "Value": [21]}, "202": {"vr": "UL", "Value": [22]}, "203": {"vr": "UL", "Value": [41]}, "204": {"vr": "UL", "Value": [60]}, "205": {"vr": "UL", "Value": [36]}, "206": {"vr": "UL", "Value": [18]}, "207": {"vr": "UL", "Value": [15]}, "208": {"vr": "UL", "Value": [42]}, "209": {"vr": "UL", "Value": [49]}, "210": {"vr": "UL", "Value": [3]}, "211": {"vr": "UL", "Value": [7]}, "212": {"vr": "UL", "Value": [24]}, "213": {"vr": "UL", "Value": [46]}, "214": {"vr": "UL", "Value": [6]}, "215": {"vr": "UL", "Value": [29]}, "216": {"vr": "UL", "Value": [13]}, "217": {"vr": "UL", "Value": [48]}, "218": {"vr": "UL", "Value": [46]}, "219": {"vr": "UL", "Value": [5]}, "220": {"vr": "UL", "Value": [16]}, "221": {"vr": "UL", "Value": [47]}, "222": {"vr": "UL", "Value": [11]}, "223": {"vr": "UL", "Value": [54]}, "224": {"vr": "UL", "Value": [12]}, "225": {"vr": "UL", "Value": [31]}, "226": {"vr": "UL", "Value": [18]}, "227": {"vr": "UL", "Value": [20]}, "228": {"vr": "UL", "Value": [57]}, "229": {"vr": "UL", "Value": [13]}, "230": {"vr": "UL", "Value": [31]}, "231": {"vr": "UL", "Value": [28]}, "232": {"vr": "UL", "Value": [17]}, "233": {"vr": "UL", "Value": [24]}, "234": {"vr": "UL", "Value": [33]}, "235": {"vr": "UL", "Value": [43]}, "236": {"vr": "UL", "Value": [37]}, "237": {"vr": "UL", "Value": [9]}, "238": {"vr": "UL", "Value": [14]}, "239": {"vr": "UL", "Value": [10]}}, "00271040": {"0": {"vr": "SH", "Value": ["S"]}, "1": {"vr": "SH", "Value": ["I"]}, "2": {"vr": "SH", "Value": ["S"]}, "3": {"vr": "SH", "Value": ["S"]}, "4": {"vr": "SH", "Value": ["S"]}, "5": {"vr": "SH", "Value": ["I"]}, "6": {"vr": "SH", "Value": ["I"]}, "7": {"vr": "SH", "Value": ["I"]}, "8": {"vr": "SH", "Value": ["S"]}, "9": {"vr": "SH", "Value": ["I"]}, "10": {"vr": "SH", "Value": ["S"]}, "11": {"vr": "SH", "Value": ["I"]}, "12": {"vr": "SH", "Value": ["S"]}, "13": {"vr": "SH", "Value": ["S"]}, "14": {"vr": "SH", "Value": ["I"]}, "15": {"vr": "SH", "Value": ["S"]}, "16": {"vr": "SH", "Value": ["I"]}, "17": {"vr": "SH", "Value": ["I"]}, "18": {"vr": "SH", "Value": ["S"]}, "19": {"vr": "SH", "Value": ["S"]}, "20": {"vr": "SH", "Value": ["S"]}, "21": {"vr": "SH", "Value": ["I"]}, "22": {"vr": "SH", "Value": ["I"]}, "23": {"vr": "SH", "Value": ["S"]}, "24": {"vr": "SH", "Value": ["S"]}, "25": {"vr": "SH", "Value": ["S"]}, "26": {"vr": "SH", "Value": ["I"]}, "27": {"vr": "SH", "Value": ["I"]}, "28": {"vr": "SH", "Value": ["I"]}, "29": {"vr": "SH", "Value": ["S"]}, "30": {"vr": "SH", "Value": ["S"]}, "31": {"vr": "SH", "Value": ["I"]}, "32": {"vr": "SH", "Value": ["S"]}, "33": {"vr": "SH", "Value": ["S"]}, "34": {"vr": "SH", "Value": ["S"]}, "35": {"vr": "SH", "Value": ["I"]}, "36": {"vr": "SH", "Value": ["S"]}, "37": {"vr": "SH", "Value": ["S"]}, "38": {"vr": "SH", "Value": ["I"]}, "39": {"vr": "SH", "Value": ["S"]}, "40": {"vr": "SH", "Value": ["S"]}, "41": {"vr": "SH", "Value": ["I"]}, "42": {"vr": "SH", "Value": ["I"]}, "43": {"vr": "SH", "Value": ["S"]}, "44": {"vr": "SH", "Value": ["I"]}, "45": {"vr": "SH", "Value": ["S"]}, "46": {"vr": "SH", "Value": ["I"]}, "47": {"vr": "SH", "Value": ["S"]}, "48": {"vr": "SH", "Value": ["S"]}, "49": {"vr": "SH", "Value": ["S"]}, "50": {"vr": "SH", "Value": ["I"]}, "51": {"vr": "SH", "Value": ["S"]}, "52": {"vr": "SH", "Value": ["S"]}, "53": {"vr": "SH", "Value": ["I"]}, "54": {"vr": "SH", "Value": ["S"]}, "55": {"vr": "SH", "Value": ["S"]}, "56": {"vr": "SH", "Value": ["S"]}, "57": {"vr": "SH", "Value": ["S"]}, "58": {"vr": "SH", "Value": ["S"]}, "59": {"vr": "SH", "Value": ["S"]}, "60": {"vr": "SH", "Value": ["S"]}, "61": {"vr": "SH", "Value": ["S"]}, "62": {"vr": "SH", "Value": ["S"]}, "63": {"vr": "SH", "Value": ["I"]}, "64": {"vr": "SH", "Value": ["S"]}, "65": {"vr": "SH", "Value": ["S"]}, "66": {"vr": "SH", "Value": ["S"]}, "67": {"vr": "SH", "Value": ["S"]}, "68": {"vr": "SH", "Value": ["I"]}, "69": {"vr": "SH", "Value": ["S"]}, "70": {"vr": "SH", "Value": ["S"]}, "71": {"vr": "SH", "Value": ["I"]}, "72": {"vr": "SH", "Value": ["S"]}, "73": {"vr": "SH", "Value": ["I"]}, "74": {"vr": "SH", "Value": ["I"]}, "75": {"vr": "SH", "Value": ["I"]}, "76": {"vr": "SH", "Value": ["S"]}, "77": {"vr": "SH", "Value": ["I"]}, "78": {"vr": "SH", "Value": ["I"]}, "79": {"vr": "SH", "Value": ["I"]}, "80": {"vr": "SH", "Value": ["S"]}, "81": {"vr": "SH", "Value": ["S"]}, "82": {"vr": "SH", "Value": ["S"]}, "83": {"vr": "SH", "Value": ["S"]}, "84": {"vr": "SH", "Value": ["S"]}, "85": {"vr": "SH", "Value": ["S"]}, "86": {"vr": "SH", "Value": ["I"]}, "87": {"vr": "SH", "Value": ["S"]}, "88": {"vr": "SH", "Value": ["I"]}, "89": {"vr": "SH", "Value": ["I"]}, "90": {"vr": "SH", "Value": ["I"]}, "91": {"vr": "SH", "Value": ["S"]}, "92": {"vr": "SH", "Value": ["I"]}, "93": {"vr": "SH", "Value": ["S"]}, "94": {"vr": "SH", "Value": ["S"]}, "95": {"vr": "SH", "Value": ["S"]}, "96": {"vr": "SH", "Value": ["I"]}, "97": {"vr": "SH", "Value": ["S"]}, "98": {"vr": "SH", "Value": ["I"]}, "99": {"vr": "SH", "Value": ["S"]}, "100": {"vr": "SH", "Value": ["S"]}, "101": {"vr": "SH", "Value": ["S"]}, "102": {"vr": "SH", "Value": ["S"]}, "103": {"vr": "SH", "Value": ["S"]}, "104": {"vr": "SH", "Value": ["S"]}, "105": {"vr": "SH", "Value": ["S"]}, "106": {"vr": "SH", "Value": ["I"]}, "107": {"vr": "SH", "Value": ["S"]}, "108": {"vr": "SH", "Value": ["S"]}, "109": {"vr": "SH", "Value": ["I"]}, "110": {"vr": "SH", "Value": ["S"]}, "111": {"vr": "SH", "Value": ["I"]}, "112": {"vr": "SH", "Value": ["S"]}, "113": {"vr": "SH", "Value": ["S"]}, "114": {"vr": "SH", "Value": ["S"]}, "115": {"vr": "SH", "Value": ["I"]}, "116": {"vr": "SH", "Value": ["S"]}, "117": {"vr": "SH", "Value": ["I"]}, "118": {"vr": "SH", "Value": ["S"]}, "119": {"vr": "SH", "Value": ["S"]}, "120": {"vr": "SH", "Value": ["S"]}, "121": {"vr": "SH", "Value": ["I"]}, "122": {"vr": "SH", "Value": ["I"]}, "123": {"vr": "SH", "Value": ["S"]}, "124": {"vr": "SH", "Value": ["S"]}, "125": {"vr": "SH", "Value": ["S"]}, "126": {"vr": "SH", "Value": ["I"]}, "127": {"vr": "SH", "Value": ["I"]}, "128": {"vr": "SH", "Value": ["I"]}, "129": {"vr": "SH", "Value": ["S"]}, "130": {"vr": "SH", "Value": ["S"]}, "131": {"vr": "SH", "Value": ["S"]}, "132": {"vr": "SH", "Value": ["S"]}, "133": {"vr": "SH", "Value": ["S"]}, "134": {"vr": "SH", "Value": ["S"]}, "135": {"vr": "SH", "Value": ["I"]}, "136": {"vr": "SH", "Value": ["I"]}, "137": {"vr": "SH", "Value": ["S"]}, "138": {"vr": "SH", "Value": ["I"]}, "139": {"vr": "SH", "Value": ["S"]}, "140": {"vr": "SH", "Value": ["I"]}, "141": {"vr": "SH", "Value": ["S"]}, "142": {"vr": "SH", "Value": ["S"]}, "143": {"vr": "SH", "Value": ["S"]}, "144": {"vr": "SH", "Value": ["I"]}, "145": {"vr": "SH", "Value": ["S"]}, "146": {"vr": "SH", "Value": ["S"]}, "147": {"vr": "SH", "Value": ["I"]}, "148": {"vr": "SH", "Value": ["S"]}, "149": {"vr": "SH", "Value": ["S"]}, "150": {"vr": "SH", "Value": ["S"]}, "151": {"vr": "SH", "Value": ["S"]}, "152": {"vr": "SH", "Value": ["I"]}, "153": {"vr": "SH", "Value": ["I"]}, "154": {"vr": "SH", "Value": ["S"]}, "155": {"vr": "SH", "Value": ["S"]}, "156": {"vr": "SH", "Value": ["S"]}, "157": {"vr": "SH", "Value": ["I"]}, "158": {"vr": "SH", "Value": ["I"]}, "159": {"vr": "SH", "Value": ["S"]}, "160": {"vr": "SH", "Value": ["I"]}, "161": {"vr": "SH", "Value": ["S"]}, "162": {"vr": "SH", "Value": ["S"]}, "163": {"vr": "SH", "Value": ["S"]}, "164": {"vr": "SH", "Value": ["S"]}, "165": {"vr": "SH", "Value": ["S"]}, "166": {"vr": "SH", "Value": ["I"]}, "167": {"vr": "SH", "Value": ["S"]}, "168": {"vr": "SH", "Value": ["I"]}, "169": {"vr": "SH", "Value": ["I"]}, "170": {"vr": "SH", "Value": ["I"]}, "171": {"vr": "SH", "Value": ["I"]}, "172": {"vr": "SH", "Value": ["I"]}, "173": {"vr": "SH", "Value": ["I"]}, "174": {"vr": "SH", "Value": ["S"]}, "175": {"vr": "SH", "Value": ["I"]}, "176": {"vr": "SH", "Value": ["I"]}, "177": {"vr": "SH", "Value": ["I"]}, "178": {"vr": "SH", "Value": ["I"]}, "179": {"vr": "SH", "Value": ["S"]}, "180": {"vr": "SH", "Value": ["I"]}, "181": {"vr": "SH", "Value": ["S"]}, "182": {"vr": "SH", "Value": ["S"]}, "183": {"vr": "SH", "Value": ["I"]}, "184": {"vr": "SH", "Value": ["I"]}, "185": {"vr": "SH", "Value": ["I"]}, "186": {"vr": "SH", "Value": ["I"]}, "187": {"vr": "SH", "Value": ["S"]}, "188": {"vr": "SH", "Value": ["I"]}, "189": {"vr": "SH", "Value": ["S"]}, "190": {"vr": "SH", "Value": ["I"]}, "191": {"vr": "SH", "Value": ["I"]}, "192": {"vr": "SH", "Value": ["I"]}, "193": {"vr": "SH", "Value": ["S"]}, "194": {"vr": "SH", "Value": ["S"]}, "195": {"vr": "SH", "Value": ["S"]}, "196": {"vr": "SH", "Value": ["I"]}, "197": {"vr": "SH", "Value": ["S"]}, "198": {"vr": "SH", "Value": ["I"]}, "199": {"vr": "SH", "Value": ["S"]}, "200": {"vr": "SH", "Value": ["I"]}, "201": {"vr": "SH", "Value": ["I"]}, "202": {"vr": "SH", "Value": ["I"]}, "203": {"vr": "SH", "Value": ["S"]}, "204": {"vr": "SH", "Value": ["S"]}, "205": {"vr": "SH", "Value": ["S"]}, "206": {"vr": "SH", "Value": ["I"]}, "207": {"vr": "SH", "Value": ["I"]}, "208": {"vr": "SH", "Value": ["S"]}, "209": {"vr": "SH", "Value": ["S"]}, "210": {"vr": "SH", "Value": ["I"]}, "211": {"vr": "SH", "Value": ["I"]}, "212": {"vr": "SH", "Value": ["I"]}, "213": {"vr": "SH", "Value": ["S"]}, "214": {"vr": "SH", "Value": ["I"]}, "215": {"vr": "SH", "Value": ["S"]}, "216": {"vr": "SH", "Value": ["I"]}, "217": {"vr": "SH", "Value": ["S"]}, "218": {"vr": "SH", "Value": ["S"]}, "219": {"vr": "SH", "Value": ["I"]}, "220": {"vr": "SH", "Value": ["I"]}, "221": {"vr": "SH", "Value": ["S"]}, "222": {"vr": "SH", "Value": ["I"]}, "223": {"vr": "SH", "Value": ["S"]}, "224": {"vr": "SH", "Value": ["I"]}, "225": {"vr": "SH", "Value": ["S"]}, "226": {"vr": "SH", "Value": ["I"]}, "227": {"vr": "SH", "Value": ["I"]}, "228": {"vr": "SH", "Value": ["S"]}, "229": {"vr": "SH", "Value": ["I"]}, "230": {"vr": "SH", "Value": ["S"]}, "231": {"vr": "SH", "Value": ["S"]}, "232": {"vr": "SH", "Value": ["I"]}, "233": {"vr": "SH", "Value": ["I"]}, "234": {"vr": "SH", "Value": ["S"]}, "235": {"vr": "SH", "Value": ["S"]}, "236": {"vr": "SH", "Value": ["S"]}, "237": {"vr": "SH", "Value": ["I"]}, "238": {"vr": "SH", "Value": ["I"]}, "239": {"vr": "SH", "Value": ["I"]}}, "00271041": {"0": {"vr": "FL", "Value": [43.17898178100586]}, "1": {"vr": "FL", "Value": [-56.304134368896484]}, "2": {"vr": "FL", "Value": [11.525263786315918]}, "3": {"vr": "FL", "Value": [31.874088287353516]}, "4": {"vr": "FL", "Value": [0.22036133706569672]}, "5": {"vr": "FL", "Value": [-6.562580108642578]}, "6": {"vr": "FL", "Value": [-44.99924087524414]}, "7": {"vr": "FL", "Value": [-54.043155670166016]}, "8": {"vr": "FL", "Value": [29.613107681274414]}, "9": {"vr": "FL", "Value": [-24.65042495727539]}, "10": {"vr": "FL", "Value": [70.31072998046875]}, "11": {"vr": "FL", "Value": [-17.867483139038086]}, "12": {"vr": "FL", "Value": [0.22036133706569672]}, "13": {"vr": "FL", "Value": [52.222896575927734]}, "14": {"vr": "FL", "Value": [-24.65042495727539]}, "15": {"vr": "FL", "Value": [25.09114646911621]}, "16": {"vr": "FL", "Value": [-8.82356071472168]}, "17": {"vr": "FL", "Value": [-33.6943473815918]}, "18": {"vr": "FL", "Value": [54.4838752746582]}, "19": {"vr": "FL", "Value": [59.00583267211914]}, "20": {"vr": "FL", "Value": [9.264283180236816]}, "21": {"vr": "FL", "Value": [-35.955326080322266]}, "22": {"vr": "FL", "Value": [-26.911405563354492]}, "23": {"vr": "FL", "Value": [54.4838752746582]}, "24": {"vr": "FL", "Value": [13.78624439239502]}, "25": {"vr": "FL", "Value": [2.48134183883667]}, "26": {"vr": "FL", "Value": [-58.56511306762695]}, "27": {"vr": "FL", "Value": [-49.52119827270508]}, "28": {"vr": "FL", "Value": [-42.73826217651367]}, "29": {"vr": "FL", "Value": [40.91800308227539]}, "30": {"vr": "FL", "Value": [36.39604568481445]}, "31": {"vr": "FL", "Value": [-2.040619134902954]}, "32": {"vr": "FL", "Value": [49.961917877197266]}, "33": {"vr": "FL", "Value": [13.78624439239502]}, "34": {"vr": "FL", "Value": [65.78877258300781]}, "35": {"vr": "FL", "Value": [-49.52119827270508]}, "36": {"vr": "FL", "Value": [70.31072998046875]}, "37": {"vr": "FL", "Value": [25.09114646911621]}, "38": {"vr": "FL", "Value": [-2.040619134902954]}, "39": {"vr": "FL", "Value": [27.352127075195312]}, "40": {"vr": "FL", "Value": [22.83016586303711]}, "41": {"vr": "FL", "Value": [-56.304134368896484]}, "42": {"vr": "FL", "Value": [-42.73826217651367]}, "43": {"vr": "FL", "Value": [56.74485397338867]}, "44": {"vr": "FL", "Value": [-47.26021957397461]}, "45": {"vr": "FL", "Value": [25.09114646911621]}, "46": {"vr": "FL", "Value": [-11.084541320800781]}, "47": {"vr": "FL", "Value": [11.525263786315918]}, "48": {"vr": "FL", "Value": [45.43996047973633]}, "49": {"vr": "FL", "Value": [63.52779006958008]}, "50": {"vr": "FL", "Value": [-35.955326080322266]}, "51": {"vr": "FL", "Value": [31.874088287353516]}, "52": {"vr": "FL", "Value": [2.48134183883667]}, "53": {"vr": "FL", "Value": [-22.38944435119629]}, "54": {"vr": "FL", "Value": [36.39604568481445]}, "55": {"vr": "FL", "Value": [49.961917877197266]}, "56": {"vr": "FL", "Value": [16.047224044799805]}, "57": {"vr": "FL", "Value": [7.003303050994873]}, "58": {"vr": "FL", "Value": [40.91800308227539]}, "59": {"vr": "FL", "Value": [59.00583267211914]}, "60": {"vr": "FL", "Value": [59.00583267211914]}, "61": {"vr": "FL", "Value": [52.222896575927734]}, "62": {"vr": "FL", "Value": [34.135066986083984]}, "63": {"vr": "FL", "Value": [-20.128463745117188]}, "64": {"vr": "FL", "Value": [18.308204650878906]}, "65": {"vr": "FL", "Value": [7.003303050994873]}, "66": {"vr": "FL", "Value": [25.09114646911621]}, "67": {"vr": "FL", "Value": [22.83016586303711]}, "68": {"vr": "FL", "Value": [-56.304134368896484]}, "69": {"vr": "FL", "Value": [22.83016586303711]}, "70": {"vr": "FL", "Value": [49.961917877197266]}, "71": {"vr": "FL", "Value": [-38.216304779052734]}, "72": {"vr": "FL", "Value": [20.569185256958008]}, "73": {"vr": "FL", "Value": [-58.56511306762695]}, "74": {"vr": "FL", "Value": [-38.216304779052734]}, "75": {"vr": "FL", "Value": [-58.56511306762695]}, "76": {"vr": "FL", "Value": [47.7009391784668]}, "77": {"vr": "FL", "Value": [-20.128463745117188]}, "78": {"vr": "FL", "Value": [-11.084541320800781]}, "79": {"vr": "FL", "Value": [-44.99924087524414]}, "80": {"vr": "FL", "Value": [29.613107681274414]}, "81": {"vr": "FL", "Value": [27.352127075195312]}, "82": {"vr": "FL", "Value": [43.17898178100586]}, "83": {"vr": "FL", "Value": [16.047224044799805]}, "84": {"vr": "FL", "Value": [27.352127075195312]}, "85": {"vr": "FL", "Value": [72.57170867919922]}, "86": {"vr": "FL", "Value": [-33.6943473815918]}, "87": {"vr": "FL", "Value": [68.04975128173828]}, "88": {"vr": "FL", "Value": [-15.606502532958984]}, "89": {"vr": "FL", "Value": [-29.172386169433594]}, "90": {"vr": "FL", "Value": [-17.867483139038086]}, "91": {"vr": "FL", "Value": [68.04975128173828]}, "92": {"vr": "FL", "Value": [-22.38944435119629]}, "93": {"vr": "FL", "Value": [18.308204650878906]}, "94": {"vr": "FL", "Value": [4.7423224449157715]}, "95": {"vr": "FL", "Value": [45.43996047973633]}, "96": {"vr": "FL", "Value": [-8.82356071472168]}, "97": {"vr": "FL", "Value": [11.525263786315918]}, "98": {"vr": "FL", "Value": [-51.78217697143555]}, "99": {"vr": "FL", "Value": [74.83268737792969]}, "100": {"vr": "FL", "Value": [52.222896575927734]}, "101": {"vr": "FL", "Value": [16.047224044799805]}, "102": {"vr": "FL", "Value": [20.569185256958008]}, "103": {"vr": "FL", "Value": [7.003303050994873]}, "104": {"vr": "FL", "Value": [40.91800308227539]}, "105": {"vr": "FL", "Value": [34.135066986083984]}, "106": {"vr": "FL", "Value": [-26.911405563354492]}, "107": {"vr": "FL", "Value": [65.78877258300781]}, "108": {"vr": "FL", "Value": [0.22036133706569672]}, "109": {"vr": "FL", "Value": [-2.040619134902954]}, "110": {"vr": "FL", "Value": [31.874088287353516]}, "111": {"vr": "FL", "Value": [-54.043155670166016]}, "112": {"vr": "FL", "Value": [65.78877258300781]}, "113": {"vr": "FL", "Value": [63.52779006958008]}, "114": {"vr": "FL", "Value": [74.83268737792969]}, "115": {"vr": "FL", "Value": [-15.606502532958984]}, "116": {"vr": "FL", "Value": [0.22036133706569672]}, "117": {"vr": "FL", "Value": [-13.345521926879883]}, "118": {"vr": "FL", "Value": [56.74485397338867]}, "119": {"vr": "FL", "Value": [47.7009391784668]}, "120": {"vr": "FL", "Value": [63.52779006958008]}, "121": {"vr": "FL", "Value": [-40.4772834777832]}, "122": {"vr": "FL", "Value": [-47.26021957397461]}, "123": {"vr": "FL", "Value": [54.4838752746582]}, "124": {"vr": "FL", "Value": [29.613107681274414]}, "125": {"vr": "FL", "Value": [38.65702438354492]}, "126": {"vr": "FL", "Value": [-11.084541320800781]}, "127": {"vr": "FL", "Value": [-51.78217697143555]}, "128": {"vr": "FL", "Value": [-4.301599502563477]}, "129": {"vr": "FL", "Value": [45.43996047973633]}, "130": {"vr": "FL", "Value": [74.83268737792969]}, "131": {"vr": "FL", "Value": [2.48134183883667]}, "132": {"vr": "FL", "Value": [61.26681137084961]}, "133": {"vr": "FL", "Value": [9.264283180236816]}, "134": {"vr": "FL", "Value": [56.74485397338867]}, "135": {"vr": "FL", "Value": [-13.345521926879883]}, "136": {"vr": "FL", "Value": [-38.216304779052734]}, "137": {"vr": "FL", "Value": [13.78624439239502]}, "138": {"vr": "FL", "Value": [-8.82356071472168]}, "139": {"vr": "FL", "Value": [20.569185256958008]}, "140": {"vr": "FL", "Value": [-29.172386169433594]}, "141": {"vr": "FL", "Value": [59.00583267211914]}, "142": {"vr": "FL", "Value": [70.31072998046875]}, "143": {"vr": "FL", "Value": [7.003303050994873]}, "144": {"vr": "FL", "Value": [-6.562580108642578]}, "145": {"vr": "FL", "Value": [34.135066986083984]}, "146": {"vr": "FL", "Value": [16.047224044799805]}, "147": {"vr": "FL", "Value": [-17.867483139038086]}, "148": {"vr": "FL", "Value": [4.7423224449157715]}, "149": {"vr": "FL", "Value": [52.222896575927734]}, "150": {"vr": "FL", "Value": [65.78877258300781]}, "151": {"vr": "FL", "Value": [61.26681137084961]}, "152": {"vr": "FL", "Value": [-40.4772834777832]}, "153": {"vr": "FL", "Value": [-31.433366775512695]}, "154": {"vr": "FL", "Value": [40.91800308227539]}, "155": {"vr": "FL", "Value": [18.308204650878906]}, "156": {"vr": "FL", "Value": [11.525263786315918]}, "157": {"vr": "FL", "Value": [-13.345521926879883]}, "158": {"vr": "FL", "Value": [-22.38944435119629]}, "159": {"vr": "FL", "Value": [38.65702438354492]}, "160": {"vr": "FL", "Value": [-29.172386169433594]}, "161": {"vr": "FL", "Value": [38.65702438354492]}, "162": {"vr": "FL", "Value": [63.52779006958008]}, "163": {"vr": "FL", "Value": [72.57170867919922]}, "164": {"vr": "FL", "Value": [36.39604568481445]}, "165": {"vr": "FL", "Value": [29.613107681274414]}, "166": {"vr": "FL", "Value": [-44.99924087524414]}, "167": {"vr": "FL", "Value": [27.352127075195312]}, "168": {"vr": "FL", "Value": [-40.4772834777832]}, "169": {"vr": "FL", "Value": [-58.56511306762695]}, "170": {"vr": "FL", "Value": [-49.52119827270508]}, "171": {"vr": "FL", "Value": [-54.043155670166016]}, "172": {"vr": "FL", "Value": [-4.301599502563477]}, "173": {"vr": "FL", "Value": [-51.78217697143555]}, "174": {"vr": "FL", "Value": [47.7009391784668]}, "175": {"vr": "FL", "Value": [-56.304134368896484]}, "176": {"vr": "FL", "Value": [-17.867483139038086]}, "177": {"vr": "FL", "Value": [-8.82356071472168]}, "178": {"vr": "FL", "Value": [-42.73826217651367]}, "179": {"vr": "FL", "Value": [72.57170867919922]}, "180": {"vr": "FL", "Value": [-24.65042495727539]}, "181": {"vr": "FL", "Value": [4.7423224449157715]}, "182": {"vr": "FL", "Value": [61.26681137084961]}, "183": {"vr": "FL", "Value": [-33.6943473815918]}, "184": {"vr": "FL", "Value": [-35.955326080322266]}, "185": {"vr": "FL", "Value": [-2.040619134902954]}, "186": {"vr": "FL", "Value": [-51.78217697143555]}, "187": {"vr": "FL", "Value": [70.31072998046875]}, "188": {"vr": "FL", "Value": [-26.911405563354492]}, "189": {"vr": "FL", "Value": [68.04975128173828]}, "190": {"vr": "FL", "Value": [-4.301599502563477]}, "191": {"vr": "FL", "Value": [-15.606502532958984]}, "192": {"vr": "FL", "Value": [-47.26021957397461]}, "193": {"vr": "FL", "Value": [54.4838752746582]}, "194": {"vr": "FL", "Value": [18.308204650878906]}, "195": {"vr": "FL", "Value": [38.65702438354492]}, "196": {"vr": "FL", "Value": [-4.301599502563477]}, "197": {"vr": "FL", "Value": [56.74485397338867]}, "198": {"vr": "FL", "Value": [-42.73826217651367]}, "199": {"vr": "FL", "Value": [72.57170867919922]}, "200": {"vr": "FL", "Value": [-31.433366775512695]}, "201": {"vr": "FL", "Value": [-13.345521926879883]}, "202": {"vr": "FL", "Value": [-11.084541320800781]}, "203": {"vr": "FL", "Value": [31.874088287353516]}, "204": {"vr": "FL", "Value": [74.83268737792969]}, "205": {"vr": "FL", "Value": [20.569185256958008]}, "206": {"vr": "FL", "Value": [-20.128463745117188]}, "207": {"vr": "FL", "Value": [-26.911405563354492]}, "208": {"vr": "FL", "Value": [34.135066986083984]}, "209": {"vr": "FL", "Value": [49.961917877197266]}, "210": {"vr": "FL", "Value": [-54.043155670166016]}, "211": {"vr": "FL", "Value": [-44.99924087524414]}, "212": {"vr": "FL", "Value": [-6.562580108642578]}, "213": {"vr": "FL", "Value": [43.17898178100586]}, "214": {"vr": "FL", "Value": [-47.26021957397461]}, "215": {"vr": "FL", "Value": [4.7423224449157715]}, "216": {"vr": "FL", "Value": [-31.433366775512695]}, "217": {"vr": "FL", "Value": [47.7009391784668]}, "218": {"vr": "FL", "Value": [43.17898178100586]}, "219": {"vr": "FL", "Value": [-49.52119827270508]}, "220": {"vr": "FL", "Value": [-24.65042495727539]}, "221": {"vr": "FL", "Value": [45.43996047973633]}, "222": {"vr": "FL", "Value": [-35.955326080322266]}, "223": {"vr": "FL", "Value": [61.26681137084961]}, "224": {"vr": "FL", "Value": [-33.6943473815918]}, "225": {"vr": "FL", "Value": [9.264283180236816]}, "226": {"vr": "FL", "Value": [-20.128463745117188]}, "227": {"vr": "FL", "Value": [-15.606502532958984]}, "228": {"vr": "FL", "Value": [68.04975128173828]}, "229": {"vr": "FL", "Value": [-31.433366775512695]}, "230": {"vr": "FL", "Value": [9.264283180236816]}, "231": {"vr": "FL", "Value": [2.48134183883667]}, "232": {"vr": "FL", "Value": [-22.38944435119629]}, "233": {"vr": "FL", "Value": [-6.562580108642578]}, "234": {"vr": "FL", "Value": [13.78624439239502]}, "235": {"vr": "FL", "Value": [36.39604568481445]}, "236": {"vr": "FL", "Value": [22.83016586303711]}, "237": {"vr": "FL", "Value": [-40.4772834777832]}, "238": {"vr": "FL", "Value": [-29.172386169433594]}, "239": {"vr": "FL", "Value": [-38.216304779052734]}}, "00280106": {"0": {"vr": "SS", "Value": [-688]}, "1": {"vr": "SS", "Value": [-1439]}, "2": {"vr": "SS", "Value": [0]}, "3": {"vr": "SS", "Value": [0]}, "4": {"vr": "SS", "Value": [0]}, "5": {"vr": "SS", "Value": [-4655]}, "6": {"vr": "SS", "Value": [-1810]}, "7": {"vr": "SS", "Value": [-4710]}, "8": {"vr": "SS", "Value": [-4816]}, "9": {"vr": "SS", "Value": [-1657]}, "10": {"vr": "SS", "Value": [0]}, "11": {"vr": "SS", "Value": [-1743]}, "12": {"vr": "SS", "Value": [-1989]}, "13": {"vr": "SS", "Value": [-2047]}, "14": {"vr": "SS", "Value": [0]}, "15": {"vr": "SS", "Value": [-4788]}, "16": {"vr": "SS", "Value": [-785]}, "17": {"vr": "SS", "Value": [-1773]}, "18": {"vr": "SS", "Value": [0]}, "19": {"vr": "SS", "Value": [0]}, "20": {"vr": "SS", "Value": [-1665]}, "21": {"vr": "SS", "Value": [-1318]}, "22": {"vr": "SS", "Value": [-1038]}, "23": {"vr": "SS", "Value": [-723]}, "24": {"vr": "SS", "Value": [0]}, "25": {"vr": "SS", "Value": [0]}, "26": {"vr": "SS", "Value": [-4860]}, "27": {"vr": "SS", "Value": [-1064]}, "28": {"vr": "SS", "Value": [0]}, "29": {"vr": "SS", "Value": [-673]}, "30": {"vr": "SS", "Value": [-4835]}, "31": {"vr": "SS", "Value": [-1366]}, "32": {"vr": "SS", "Value": [0]}, "33": {"vr": "SS", "Value": [-4899]}, "34": {"vr": "SS", "Value": [-4725]}, "35": {"vr": "SS", "Value": [-1376]}, "36": {"vr": "SS", "Value": [-4833]}, "37": {"vr": "SS", "Value": [0]}, "38": {"vr": "SS", "Value": [0]}, "39": {"vr": "SS", "Value": [-983]}, "40": {"vr": "SS", "Value": [0]}, "41": {"vr": "SS", "Value": [0]}, "42": {"vr": "SS", "Value": [-4795]}, "43": {"vr": "SS", "Value": [0]}, "44": {"vr": "SS", "Value": [-2248]}, "45": {"vr": "SS", "Value": [-845]}, "46": {"vr": "SS", "Value": [-1069]}, "47": {"vr": "SS", "Value": [-1441]}, "48": {"vr": "SS", "Value": [-1065]}, "49": {"vr": "SS", "Value": [-4880]}, "50": {"vr": "SS", "Value": [0]}, "51": {"vr": "SS", "Value": [-410]}, "52": {"vr": "SS", "Value": [-4921]}, "53": {"vr": "SS", "Value": [0]}, "54": {"vr": "SS", "Value": [0]}, "55": {"vr": "SS", "Value": [-2430]}, "56": {"vr": "SS", "Value": [-683]}, "57": {"vr": "SS", "Value": [-4815]}, "58": {"vr": "SS", "Value": [-4964]}, "59": {"vr": "SS", "Value": [-4847]}, "60": {"vr": "SS", "Value": [-553]}, "61": {"vr": "SS", "Value": [0]}, "62": {"vr": "SS", "Value": [0]}, "63": {"vr": "SS", "Value": [-2040]}, "64": {"vr": "SS", "Value": [-2091]}, "65": {"vr": "SS", "Value": [-1680]}, "66": {"vr": "SS", "Value": [-1366]}, "67": {"vr": "SS", "Value": [-1295]}, "68": {"vr": "SS", "Value": [-1126]}, "69": {"vr": "SS", "Value": [-4829]}, "70": {"vr": "SS", "Value": [-1199]}, "71": {"vr": "SS", "Value": [-1026]}, "72": {"vr": "SS", "Value": [-4822]}, "73": {"vr": "SS", "Value": [0]}, "74": {"vr": "SS", "Value": [-1603]}, "75": {"vr": "SS", "Value": [-1300]}, "76": {"vr": "SS", "Value": [-4702]}, "77": {"vr": "SS", "Value": [-897]}, "78": {"vr": "SS", "Value": [-4946]}, "79": {"vr": "SS", "Value": [-1966]}, "80": {"vr": "SS", "Value": [0]}, "81": {"vr": "SS", "Value": [-4830]}, "82": {"vr": "SS", "Value": [-4847]}, "83": {"vr": "SS", "Value": [-1146]}, "84": {"vr": "SS", "Value": [-493]}, "85": {"vr": "SS", "Value": [0]}, "86": {"vr": "SS", "Value": [-1372]}, "87": {"vr": "SS", "Value": [-1201]}, "88": {"vr": "SS", "Value": [-1984]}, "89": {"vr": "SS", "Value": [0]}, "90": {"vr": "SS", "Value": [0]}, "91": {"vr": "SS", "Value": [-4888]}, "92": {"vr": "SS", "Value": [-4836]}, "93": {"vr": "SS", "Value": [-661]}, "94": {"vr": "SS", "Value": [0]}, "95": {"vr": "SS", "Value": [-721]}, "96": {"vr": "SS", "Value": [-1259]}, "97": {"vr": "SS", "Value": [-1013]}, "98": {"vr": "SS", "Value": [0]}, "99": {"vr": "SS", "Value": [-195]}, "100": {"vr": "SS", "Value": [-4877]}, "101": {"vr": "SS", "Value": [-4835]}, "102": {"vr": "SS", "Value": [-1605]}, "103": {"vr": "SS", "Value": [0]}, "104": {"vr": "SS", "Value": [0]}, "105": {"vr": "SS", "Value": [-4599]}, "106": {"vr": "SS", "Value": [-4858]}, "107": {"vr": "SS", "Value": [0]}, "108": {"vr": "SS", "Value": [-4825]}, "109": {"vr": "SS", "Value": [-4828]}, "110": {"vr": "SS", "Value": [-4750]}, "111": {"vr": "SS", "Value": [0]}, "112": {"vr": "SS", "Value": [-1164]}, "113": {"vr": "SS", "Value": [-325]}, "114": {"vr": "SS", "Value": [-764]}, "115": {"vr": "SS", "Value": [0]}, "116": {"vr": "SS", "Value": [-764]}, "117": {"vr": "SS", "Value": [-1831]}, "118": {"vr": "SS", "Value": [-4836]}, "119": {"vr": "SS", "Value": [0]}, "120": {"vr": "SS", "Value": [0]}, "121": {"vr": "SS", "Value": [-4790]}, "122": {"vr": "SS", "Value": [-4815]}, "123": {"vr": "SS", "Value": [-4804]}, "124": {"vr": "SS", "Value": [-1002]}, "125": {"vr": "SS", "Value": [-4817]}, "126": {"vr": "SS", "Value": [-998]}, "127": {"vr": "SS", "Value": [-4860]}, "128": {"vr": "SS", "Value": [0]}, "129": {"vr": "SS", "Value": [0]}, "130": {"vr": "SS", "Value": [0]}, "131": {"vr": "SS", "Value": [-798]}, "132": {"vr": "SS", "Value": [0]}, "133": {"vr": "SS", "Value": [-4726]}, "134": {"vr": "SS", "Value": [-606]}, "135": {"vr": "SS", "Value": [-925]}, "136": {"vr": "SS", "Value": [0]}, "137": {"vr": "SS", "Value": [-1104]}, "138": {"vr": "SS", "Value": [0]}, "139": {"vr": "SS", "Value": [-1670]}, "140": {"vr": "SS", "Value": [-1333]}, "141": {"vr": "SS", "Value": [-765]}, "142": {"vr": "SS", "Value": [-1053]}, "143": {"vr": "SS", "Value": [-1191]}, "144": {"vr": "SS", "Value": [-1238]}, "145": {"vr": "SS", "Value": [-1932]}, "146": {"vr": "SS", "Value": [0]}, "147": {"vr": "SS", "Value": [-1737]}, "148": {"vr": "SS", "Value": [-1311]}, "149": {"vr": "SS", "Value": [-1407]}, "150": {"vr": "SS", "Value": [-684]}, "151": {"vr": "SS", "Value": [-4889]}, "152": {"vr": "SS", "Value": [0]}, "153": {"vr": "SS", "Value": [-1058]}, "154": {"vr": "SS", "Value": [-1153]}, "155": {"vr": "SS", "Value": [0]}, "156": {"vr": "SS", "Value": [-4796]}, "157": {"vr": "SS", "Value": [0]}, "158": {"vr": "SS", "Value": [-1412]}, "159": {"vr": "SS", "Value": [0]}, "160": {"vr": "SS", "Value": [-4808]}, "161": {"vr": "SS", "Value": [-839]}, "162": {"vr": "SS", "Value": [-859]}, "163": {"vr": "SS", "Value": [-4771]}, "164": {"vr": "SS", "Value": [-1954]}, "165": {"vr": "SS", "Value": [-683]}, "166": {"vr": "SS", "Value": [-4800]}, "167": {"vr": "SS", "Value": [0]}, "168": {"vr": "SS", "Value": [-919]}, "169": {"vr": "SS", "Value": [-1959]}, "170": {"vr": "SS", "Value": [-4719]}, "171": {"vr": "SS", "Value": [-1354]}, "172": {"vr": "SS", "Value": [-2139]}, "173": {"vr": "SS", "Value": [-1227]}, "174": {"vr": "SS", "Value": [-1898]}, "175": {"vr": "SS", "Value": [-4755]}, "176": {"vr": "SS", "Value": [-4726]}, "177": {"vr": "SS", "Value": [-4782]}, "178": {"vr": "SS", "Value": [-2143]}, "179": {"vr": "SS", "Value": [-937]}, "180": {"vr": "SS", "Value": [-4761]}, "181": {"vr": "SS", "Value": [-4694]}, "182": {"vr": "SS", "Value": [-605]}, "183": {"vr": "SS", "Value": [0]}, "184": {"vr": "SS", "Value": [-4786]}, "185": {"vr": "SS", "Value": [-2101]}, "186": {"vr": "SS", "Value": [-1172]}, "187": {"vr": "SS", "Value": [-1029]}, "188": {"vr": "SS", "Value": [-1699]}, "189": {"vr": "SS", "Value": [0]}, "190": {"vr": "SS", "Value": [-1368]}, "191": {"vr": "SS", "Value": [-1218]}, "192": {"vr": "SS", "Value": [-993]}, "193": {"vr": "SS", "Value": [-1370]}, "194": {"vr": "SS", "Value": [-4863]}, "195": {"vr": "SS", "Value": [-1577]}, "196": {"vr": "SS", "Value": [-4777]}, "197": {"vr": "SS", "Value": [-971]}, "198": {"vr": "SS", "Value": [-998]}, "199": {"vr": "SS", "Value": [-889]}, "200": {"vr": "SS", "Value": [0]}, "201": {"vr": "SS", "Value": [-4933]}, "202": {"vr": "SS", "Value": [0]}, "203": {"vr": "SS", "Value": [-1780]}, "204": {"vr": "SS", "Value": [-4777]}, "205": {"vr": "SS", "Value": [0]}, "206": {"vr": "SS", "Value": [-4597]}, "207": {"vr": "SS", "Value": [0]}, "208": {"vr": "SS", "Value": [-1205]}, "209": {"vr": "SS", "Value": [-4742]}, "210": {"vr": "SS", "Value": [-1031]}, "211": {"vr": "SS", "Value": [0]}, "212": {"vr": "SS", "Value": [-1364]}, "213": {"vr": "SS", "Value": [-798]}, "214": {"vr": "SS", "Value": [0]}, "215": {"vr": "SS", "Value": [-994]}, "216": {"vr": "SS", "Value": [-4839]}, "217": {"vr": "SS", "Value": [-624]}, "218": {"vr": "SS", "Value": [0]}, "219": {"vr": "SS", "Value": [0]}, "220": {"vr": "SS", "Value": [-1043]}, "221": {"vr": "SS", "Value": [-4680]}, "222": {"vr": "SS", "Value": [-1183]}, "223": {"vr": "SS", "Value": [-616]}, "224": {"vr": "SS", "Value": [-4806]}, "225": {"vr": "SS", "Value": [-1338]}, "226": {"vr": "SS", "Value": [0]}, "227": {"vr": "SS", "Value": [-4610]}, "228": {"vr": "SS", "Value": [-890]}, "229": {"vr": "SS", "Value": [-1783]}, "230": {"vr": "SS", "Value": [0]}, "231": {"vr": "SS", "Value": [-1076]}, "232": {"vr": "SS", "Value": [-1038]}, "233": {"vr": "SS", "Value": [0]}, "234": {"vr": "SS", "Value": [-494]}, "235": {"vr": "SS", "Value": [-1169]}, "236": {"vr": "SS", "Value": [-2241]}, "237": {"vr": "SS", "Value": [-1857]}, "238": {"vr": "SS", "Value": [-1232]}, "239": {"vr": "SS", "Value": [-4825]}}, "00280107": {"0": {"vr": "SS", "Value": [1769]}, "1": {"vr": "SS", "Value": [1155]}, "2": {"vr": "SS", "Value": [1810]}, "3": {"vr": "SS", "Value": [2216]}, "4": {"vr": "SS", "Value": [2275]}, "5": {"vr": "SS", "Value": [4756]}, "6": {"vr": "SS", "Value": [1001]}, "7": {"vr": "SS", "Value": [4855]}, "8": {"vr": "SS", "Value": [4710]}, "9": {"vr": "SS", "Value": [1207]}, "10": {"vr": "SS", "Value": [1156]}, "11": {"vr": "SS", "Value": [1111]}, "12": {"vr": "SS", "Value": [1148]}, "13": {"vr": "SS", "Value": [667]}, "14": {"vr": "SS", "Value": [2050]}, "15": {"vr": "SS", "Value": [4639]}, "16": {"vr": "SS", "Value": [1750]}, "17": {"vr": "SS", "Value": [1694]}, "18": {"vr": "SS", "Value": [2085]}, "19": {"vr": "SS", "Value": [2009]}, "20": {"vr": "SS", "Value": [882]}, "21": {"vr": "SS", "Value": [1142]}, "22": {"vr": "SS", "Value": [1407]}, "23": {"vr": "SS", "Value": [1710]}, "24": {"vr": "SS", "Value": [1667]}, "25": {"vr": "SS", "Value": [2165]}, "26": {"vr": "SS", "Value": [4723]}, "27": {"vr": "SS", "Value": [2511]}, "28": {"vr": "SS", "Value": [2216]}, "29": {"vr": "SS", "Value": [2575]}, "30": {"vr": "SS", "Value": [4828]}, "31": {"vr": "SS", "Value": [1363]}, "32": {"vr": "SS", "Value": [2451]}, "33": {"vr": "SS", "Value": [4823]}, "34": {"vr": "SS", "Value": [4821]}, "35": {"vr": "SS", "Value": [1139]}, "36": {"vr": "SS", "Value": [4686]}, "37": {"vr": "SS", "Value": [2385]}, "38": {"vr": "SS", "Value": [2308]}, "39": {"vr": "SS", "Value": [1389]}, "40": {"vr": "SS", "Value": [2343]}, "41": {"vr": "SS", "Value": [2289]}, "42": {"vr": "SS", "Value": [4782]}, "43": {"vr": "SS", "Value": [2017]}, "44": {"vr": "SS", "Value": [1106]}, "45": {"vr": "SS", "Value": [2278]}, "46": {"vr": "SS", "Value": [2050]}, "47": {"vr": "SS", "Value": [885]}, "48": {"vr": "SS", "Value": [1135]}, "49": {"vr": "SS", "Value": [4714]}, "50": {"vr": "SS", "Value": [1633]}, "51": {"vr": "SS", "Value": [1395]}, "52": {"vr": "SS", "Value": [4849]}, "53": {"vr": "SS", "Value": [2275]}, "54": {"vr": "SS", "Value": [2010]}, "55": {"vr": "SS", "Value": [670]}, "56": {"vr": "SS", "Value": [2008]}, "57": {"vr": "SS", "Value": [4766]}, "58": {"vr": "SS", "Value": [4741]}, "59": {"vr": "SS", "Value": [4801]}, "60": {"vr": "SS", "Value": [1721]}, "61": {"vr": "SS", "Value": [2233]}, "62": {"vr": "SS", "Value": [2117]}, "63": {"vr": "SS", "Value": [1062]}, "64": {"vr": "SS", "Value": [912]}, "65": {"vr": "SS", "Value": [786]}, "66": {"vr": "SS", "Value": [787]}, "67": {"vr": "SS", "Value": [1128]}, "68": {"vr": "SS", "Value": [2087]}, "69": {"vr": "SS", "Value": [4833]}, "70": {"vr": "SS", "Value": [930]}, "71": {"vr": "SS", "Value": [1652]}, "72": {"vr": "SS", "Value": [4919]}, "73": {"vr": "SS", "Value": [2222]}, "74": {"vr": "SS", "Value": [1068]}, "75": {"vr": "SS", "Value": [1490]}, "76": {"vr": "SS", "Value": [4790]}, "77": {"vr": "SS", "Value": [1278]}, "78": {"vr": "SS", "Value": [4644]}, "79": {"vr": "SS", "Value": [1127]}, "80": {"vr": "SS", "Value": [2313]}, "81": {"vr": "SS", "Value": [4788]}, "82": {"vr": "SS", "Value": [4778]}, "83": {"vr": "SS", "Value": [1324]}, "84": {"vr": "SS", "Value": [2009]}, "85": {"vr": "SS", "Value": [986]}, "86": {"vr": "SS", "Value": [1537]}, "87": {"vr": "SS", "Value": [582]}, "88": {"vr": "SS", "Value": [987]}, "89": {"vr": "SS", "Value": [1658]}, "90": {"vr": "SS", "Value": [2093]}, "91": {"vr": "SS", "Value": [4817]}, "92": {"vr": "SS", "Value": [4633]}, "93": {"vr": "SS", "Value": [1416]}, "94": {"vr": "SS", "Value": [2056]}, "95": {"vr": "SS", "Value": [2468]}, "96": {"vr": "SS", "Value": [1334]}, "97": {"vr": "SS", "Value": [1509]}, "98": {"vr": "SS", "Value": [2553]}, "99": {"vr": "SS", "Value": [709]}, "100": {"vr": "SS", "Value": [4863]}, "101": {"vr": "SS", "Value": [4894]}, "102": {"vr": "SS", "Value": [1111]}, "103": {"vr": "SS", "Value": [1805]}, "104": {"vr": "SS", "Value": [2576]}, "105": {"vr": "SS", "Value": [4648]}, "106": {"vr": "SS", "Value": [4739]}, "107": {"vr": "SS", "Value": [1239]}, "108": {"vr": "SS", "Value": [4870]}, "109": {"vr": "SS", "Value": [4816]}, "110": {"vr": "SS", "Value": [4625]}, "111": {"vr": "SS", "Value": [2438]}, "112": {"vr": "SS", "Value": [399]}, "113": {"vr": "SS", "Value": [1159]}, "114": {"vr": "SS", "Value": [679]}, "115": {"vr": "SS", "Value": [2016]}, "116": {"vr": "SS", "Value": [1908]}, "117": {"vr": "SS", "Value": [1091]}, "118": {"vr": "SS", "Value": [4882]}, "119": {"vr": "SS", "Value": [2531]}, "120": {"vr": "SS", "Value": [1210]}, "121": {"vr": "SS", "Value": [4931]}, "122": {"vr": "SS", "Value": [4849]}, "123": {"vr": "SS", "Value": [4772]}, "124": {"vr": "SS", "Value": [1279]}, "125": {"vr": "SS", "Value": [4791]}, "126": {"vr": "SS", "Value": [1236]}, "127": {"vr": "SS", "Value": [4905]}, "128": {"vr": "SS", "Value": [2176]}, "129": {"vr": "SS", "Value": [2469]}, "130": {"vr": "SS", "Value": [774]}, "131": {"vr": "SS", "Value": [1611]}, "132": {"vr": "SS", "Value": [1824]}, "133": {"vr": "SS", "Value": [4710]}, "134": {"vr": "SS", "Value": [1943]}, "135": {"vr": "SS", "Value": [1613]}, "136": {"vr": "SS", "Value": [1756]}, "137": {"vr": "SS", "Value": [1299]}, "138": {"vr": "SS", "Value": [2037]}, "139": {"vr": "SS", "Value": [407]}, "140": {"vr": "SS", "Value": [989]}, "141": {"vr": "SS", "Value": [1509]}, "142": {"vr": "SS", "Value": [571]}, "143": {"vr": "SS", "Value": [1042]}, "144": {"vr": "SS", "Value": [1843]}, "145": {"vr": "SS", "Value": [689]}, "146": {"vr": "SS", "Value": [2010]}, "147": {"vr": "SS", "Value": [819]}, "148": {"vr": "SS", "Value": [867]}, "149": {"vr": "SS", "Value": [500]}, "150": {"vr": "SS", "Value": [1023]}, "151": {"vr": "SS", "Value": [4798]}, "152": {"vr": "SS", "Value": [1991]}, "153": {"vr": "SS", "Value": [1507]}, "154": {"vr": "SS", "Value": [817]}, "155": {"vr": "SS", "Value": [2322]}, "156": {"vr": "SS", "Value": [5005]}, "157": {"vr": "SS", "Value": [1973]}, "158": {"vr": "SS", "Value": [1397]}, "159": {"vr": "SS", "Value": [2237]}, "160": {"vr": "SS", "Value": [4748]}, "161": {"vr": "SS", "Value": [1520]}, "162": {"vr": "SS", "Value": [785]}, "163": {"vr": "SS", "Value": [4832]}, "164": {"vr": "SS", "Value": [702]}, "165": {"vr": "SS", "Value": [2253]}, "166": {"vr": "SS", "Value": [4967]}, "167": {"vr": "SS", "Value": [2361]}, "168": {"vr": "SS", "Value": [1293]}, "169": {"vr": "SS", "Value": [1193]}, "170": {"vr": "SS", "Value": [4914]}, "171": {"vr": "SS", "Value": [1466]}, "172": {"vr": "SS", "Value": [924]}, "173": {"vr": "SS", "Value": [1508]}, "174": {"vr": "SS", "Value": [759]}, "175": {"vr": "SS", "Value": [4889]}, "176": {"vr": "SS", "Value": [4763]}, "177": {"vr": "SS", "Value": [4544]}, "178": {"vr": "SS", "Value": [1117]}, "179": {"vr": "SS", "Value": [511]}, "180": {"vr": "SS", "Value": [4750]}, "181": {"vr": "SS", "Value": [4757]}, "182": {"vr": "SS", "Value": [981]}, "183": {"vr": "SS", "Value": [2123]}, "184": {"vr": "SS", "Value": [4759]}, "185": {"vr": "SS", "Value": [904]}, "186": {"vr": "SS", "Value": [2211]}, "187": {"vr": "SS", "Value": [674]}, "188": {"vr": "SS", "Value": [1428]}, "189": {"vr": "SS", "Value": [1212]}, "190": {"vr": "SS", "Value": [871]}, "191": {"vr": "SS", "Value": [1047]}, "192": {"vr": "SS", "Value": [1316]}, "193": {"vr": "SS", "Value": [553]}, "194": {"vr": "SS", "Value": [4877]}, "195": {"vr": "SS", "Value": [701]}, "196": {"vr": "SS", "Value": [4567]}, "197": {"vr": "SS", "Value": [965]}, "198": {"vr": "SS", "Value": [1474]}, "199": {"vr": "SS", "Value": [814]}, "200": {"vr": "SS", "Value": [2087]}, "201": {"vr": "SS", "Value": [4845]}, "202": {"vr": "SS", "Value": [2080]}, "203": {"vr": "SS", "Value": [803]}, "204": {"vr": "SS", "Value": [4931]}, "205": {"vr": "SS", "Value": [2343]}, "206": {"vr": "SS", "Value": [4725]}, "207": {"vr": "SS", "Value": [1780]}, "208": {"vr": "SS", "Value": [992]}, "209": {"vr": "SS", "Value": [5001]}, "210": {"vr": "SS", "Value": [2279]}, "211": {"vr": "SS", "Value": [2380]}, "212": {"vr": "SS", "Value": [850]}, "213": {"vr": "SS", "Value": [1995]}, "214": {"vr": "SS", "Value": [2577]}, "215": {"vr": "SS", "Value": [1698]}, "216": {"vr": "SS", "Value": [4650]}, "217": {"vr": "SS", "Value": [1594]}, "218": {"vr": "SS", "Value": [2486]}, "219": {"vr": "SS", "Value": [2627]}, "220": {"vr": "SS", "Value": [1798]}, "221": {"vr": "SS", "Value": [4916]}, "222": {"vr": "SS", "Value": [1415]}, "223": {"vr": "SS", "Value": [1818]}, "224": {"vr": "SS", "Value": [4643]}, "225": {"vr": "SS", "Value": [1269]}, "226": {"vr": "SS", "Value": [2120]}, "227": {"vr": "SS", "Value": [4692]}, "228": {"vr": "SS", "Value": [851]}, "229": {"vr": "SS", "Value": [894]}, "230": {"vr": "SS", "Value": [1782]}, "231": {"vr": "SS", "Value": [1792]}, "232": {"vr": "SS", "Value": [2099]}, "233": {"vr": "SS", "Value": [1925]}, "234": {"vr": "SS", "Value": [1553]}, "235": {"vr": "SS", "Value": [592]}, "236": {"vr": "SS", "Value": [817]}, "237": {"vr": "SS", "Value": [1023]}, "238": {"vr": "SS", "Value": [1200]}, "239": {"vr": "SS", "Value": [4875]}}, "00281050": {"0": {"vr": "DS", "Value": [540.0]}, "1": {"vr": "DS", "Value": [-142.0]}, "2": {"vr": "DS", "Value": [905.0]}, "3": {"vr": "DS", "Value": [1108.0]}, "4": {"vr": "DS", "Value": [1137.0]}, "5": {"vr": "DS", "Value": [50.0]}, "6": {"vr": "DS", "Value": [-404.0]}, "7": {"vr": "DS", "Value": [72.0]}, "8": {"vr": "DS", "Value": [-53.0]}, "9": {"vr": "DS", "Value": [-225.0]}, "10": {"vr": "DS", "Value": [578.0]}, "11": {"vr": "DS", "Value": [-316.0]}, "12": {"vr": "DS", "Value": [-420.0]}, "13": {"vr": "DS", "Value": [-690.0]}, "14": {"vr": "DS", "Value": [1025.0]}, "15": {"vr": "DS", "Value": [-74.0]}, "16": {"vr": "DS", "Value": [482.0]}, "17": {"vr": "DS", "Value": [-39.0]}, "18": {"vr": "DS", "Value": [1042.0]}, "19": {"vr": "DS", "Value": [1004.0]}, "20": {"vr": "DS", "Value": [-391.0]}, "21": {"vr": "DS", "Value": [-88.0]}, "22": {"vr": "DS", "Value": [184.0]}, "23": {"vr": "DS", "Value": [493.0]}, "24": {"vr": "DS", "Value": [833.0]}, "25": {"vr": "DS", "Value": [1082.0]}, "26": {"vr": "DS", "Value": [-68.0]}, "27": {"vr": "DS", "Value": [723.0]}, "28": {"vr": "DS", "Value": [1108.0]}, "29": {"vr": "DS", "Value": [951.0]}, "30": {"vr": "DS", "Value": [-3.0]}, "31": {"vr": "DS", "Value": [-1.0]}, "32": {"vr": "DS", "Value": [1225.0]}, "33": {"vr": "DS", "Value": [-38.0]}, "34": {"vr": "DS", "Value": [48.0]}, "35": {"vr": "DS", "Value": [-118.0]}, "36": {"vr": "DS", "Value": [-73.0]}, "37": {"vr": "DS", "Value": [1192.0]}, "38": {"vr": "DS", "Value": [1154.0]}, "39": {"vr": "DS", "Value": [203.0]}, "40": {"vr": "DS", "Value": [1171.0]}, "41": {"vr": "DS", "Value": [1144.0]}, "42": {"vr": "DS", "Value": [-6.0]}, "43": {"vr": "DS", "Value": [1008.0]}, "44": {"vr": "DS", "Value": [-571.0]}, "45": {"vr": "DS", "Value": [716.0]}, "46": {"vr": "DS", "Value": [490.0]}, "47": {"vr": "DS", "Value": [-278.0]}, "48": {"vr": "DS", "Value": [35.0]}, "49": {"vr": "DS", "Value": [-83.0]}, "50": {"vr": "DS", "Value": [816.0]}, "51": {"vr": "DS", "Value": [492.0]}, "52": {"vr": "DS", "Value": [-36.0]}, "53": {"vr": "DS", "Value": [1137.0]}, "54": {"vr": "DS", "Value": [1005.0]}, "55": {"vr": "DS", "Value": [-880.0]}, "56": {"vr": "DS", "Value": [662.0]}, "57": {"vr": "DS", "Value": [-24.0]}, "58": {"vr": "DS", "Value": [-111.0]}, "59": {"vr": "DS", "Value": [-23.0]}, "60": {"vr": "DS", "Value": [584.0]}, "61": {"vr": "DS", "Value": [1116.0]}, "62": {"vr": "DS", "Value": [1058.0]}, "63": {"vr": "DS", "Value": [-489.0]}, "64": {"vr": "DS", "Value": [-589.0]}, "65": {"vr": "DS", "Value": [-447.0]}, "66": {"vr": "DS", "Value": [-289.0]}, "67": {"vr": "DS", "Value": [-83.0]}, "68": {"vr": "DS", "Value": [480.0]}, "69": {"vr": "DS", "Value": [2.0]}, "70": {"vr": "DS", "Value": [-134.0]}, "71": {"vr": "DS", "Value": [313.0]}, "72": {"vr": "DS", "Value": [48.0]}, "73": {"vr": "DS", "Value": [1111.0]}, "74": {"vr": "DS", "Value": [-267.0]}, "75": {"vr": "DS", "Value": [95.0]}, "76": {"vr": "DS", "Value": [44.0]}, "77": {"vr": "DS", "Value": [190.0]}, "78": {"vr": "DS", "Value": [-151.0]}, "79": {"vr": "DS", "Value": [-419.0]}, "80": {"vr": "DS", "Value": [1156.0]}, "81": {"vr": "DS", "Value": [-21.0]}, "82": {"vr": "DS", "Value": [-34.0]}, "83": {"vr": "DS", "Value": [89.0]}, "84": {"vr": "DS", "Value": [758.0]}, "85": {"vr": "DS", "Value": [493.0]}, "86": {"vr": "DS", "Value": [82.0]}, "87": {"vr": "DS", "Value": [-309.0]}, "88": {"vr": "DS", "Value": [-498.0]}, "89": {"vr": "DS", "Value": [829.0]}, "90": {"vr": "DS", "Value": [1046.0]}, "91": {"vr": "DS", "Value": [-35.0]}, "92": {"vr": "DS", "Value": [-101.0]}, "93": {"vr": "DS", "Value": [377.0]}, "94": {"vr": "DS", "Value": [1028.0]}, "95": {"vr": "DS", "Value": [873.0]}, "96": {"vr": "DS", "Value": [37.0]}, "97": {"vr": "DS", "Value": [248.0]}, "98": {"vr": "DS", "Value": [1276.0]}, "99": {"vr": "DS", "Value": [257.0]}, "100": {"vr": "DS", "Value": [-7.0]}, "101": {"vr": "DS", "Value": [29.0]}, "102": {"vr": "DS", "Value": [-247.0]}, "103": {"vr": "DS", "Value": [902.0]}, "104": {"vr": "DS", "Value": [1288.0]}, "105": {"vr": "DS", "Value": [24.0]}, "106": {"vr": "DS", "Value": [-59.0]}, "107": {"vr": "DS", "Value": [619.0]}, "108": {"vr": "DS", "Value": [22.0]}, "109": {"vr": "DS", "Value": [-6.0]}, "110": {"vr": "DS", "Value": [-62.0]}, "111": {"vr": "DS", "Value": [1219.0]}, "112": {"vr": "DS", "Value": [-382.0]}, "113": {"vr": "DS", "Value": [417.0]}, "114": {"vr": "DS", "Value": [-42.0]}, "115": {"vr": "DS", "Value": [1008.0]}, "116": {"vr": "DS", "Value": [572.0]}, "117": {"vr": "DS", "Value": [-370.0]}, "118": {"vr": "DS", "Value": [23.0]}, "119": {"vr": "DS", "Value": [1265.0]}, "120": {"vr": "DS", "Value": [605.0]}, "121": {"vr": "DS", "Value": [70.0]}, "122": {"vr": "DS", "Value": [17.0]}, "123": {"vr": "DS", "Value": [-16.0]}, "124": {"vr": "DS", "Value": [138.0]}, "125": {"vr": "DS", "Value": [-13.0]}, "126": {"vr": "DS", "Value": [119.0]}, "127": {"vr": "DS", "Value": [22.0]}, "128": {"vr": "DS", "Value": [1088.0]}, "129": {"vr": "DS", "Value": [1234.0]}, "130": {"vr": "DS", "Value": [387.0]}, "131": {"vr": "DS", "Value": [406.0]}, "132": {"vr": "DS", "Value": [912.0]}, "133": {"vr": "DS", "Value": [-8.0]}, "134": {"vr": "DS", "Value": [668.0]}, "135": {"vr": "DS", "Value": [344.0]}, "136": {"vr": "DS", "Value": [878.0]}, "137": {"vr": "DS", "Value": [97.0]}, "138": {"vr": "DS", "Value": [1018.0]}, "139": {"vr": "DS", "Value": [-631.0]}, "140": {"vr": "DS", "Value": [-172.0]}, "141": {"vr": "DS", "Value": [372.0]}, "142": {"vr": "DS", "Value": [-241.0]}, "143": {"vr": "DS", "Value": [-74.0]}, "144": {"vr": "DS", "Value": [302.0]}, "145": {"vr": "DS", "Value": [-621.0]}, "146": {"vr": "DS", "Value": [1005.0]}, "147": {"vr": "DS", "Value": [-459.0]}, "148": {"vr": "DS", "Value": [-222.0]}, "149": {"vr": "DS", "Value": [-453.0]}, "150": {"vr": "DS", "Value": [169.0]}, "151": {"vr": "DS", "Value": [-45.0]}, "152": {"vr": "DS", "Value": [995.0]}, "153": {"vr": "DS", "Value": [224.0]}, "154": {"vr": "DS", "Value": [-168.0]}, "155": {"vr": "DS", "Value": [1161.0]}, "156": {"vr": "DS", "Value": [104.0]}, "157": {"vr": "DS", "Value": [986.0]}, "158": {"vr": "DS", "Value": [-7.0]}, "159": {"vr": "DS", "Value": [1118.0]}, "160": {"vr": "DS", "Value": [-30.0]}, "161": {"vr": "DS", "Value": [340.0]}, "162": {"vr": "DS", "Value": [-37.0]}, "163": {"vr": "DS", "Value": [30.0]}, "164": {"vr": "DS", "Value": [-626.0]}, "165": {"vr": "DS", "Value": [785.0]}, "166": {"vr": "DS", "Value": [83.0]}, "167": {"vr": "DS", "Value": [1180.0]}, "168": {"vr": "DS", "Value": [187.0]}, "169": {"vr": "DS", "Value": [-383.0]}, "170": {"vr": "DS", "Value": [97.0]}, "171": {"vr": "DS", "Value": [56.0]}, "172": {"vr": "DS", "Value": [-607.0]}, "173": {"vr": "DS", "Value": [140.0]}, "174": {"vr": "DS", "Value": [-569.0]}, "175": {"vr": "DS", "Value": [67.0]}, "176": {"vr": "DS", "Value": [18.0]}, "177": {"vr": "DS", "Value": [-119.0]}, "178": {"vr": "DS", "Value": [-513.0]}, "179": {"vr": "DS", "Value": [-213.0]}, "180": {"vr": "DS", "Value": [-5.0]}, "181": {"vr": "DS", "Value": [31.0]}, "182": {"vr": "DS", "Value": [188.0]}, "183": {"vr": "DS", "Value": [1061.0]}, "184": {"vr": "DS", "Value": [-13.0]}, "185": {"vr": "DS", "Value": [-598.0]}, "186": {"vr": "DS", "Value": [519.0]}, "187": {"vr": "DS", "Value": [-177.0]}, "188": {"vr": "DS", "Value": [-135.0]}, "189": {"vr": "DS", "Value": [606.0]}, "190": {"vr": "DS", "Value": [-248.0]}, "191": {"vr": "DS", "Value": [-85.0]}, "192": {"vr": "DS", "Value": [161.0]}, "193": {"vr": "DS", "Value": [-408.0]}, "194": {"vr": "DS", "Value": [7.0]}, "195": {"vr": "DS", "Value": [-438.0]}, "196": {"vr": "DS", "Value": [-105.0]}, "197": {"vr": "DS", "Value": [-3.0]}, "198": {"vr": "DS", "Value": [238.0]}, "199": {"vr": "DS", "Value": [-37.0]}, "200": {"vr": "DS", "Value": [1043.0]}, "201": {"vr": "DS", "Value": [-44.0]}, "202": {"vr": "DS", "Value": [1040.0]}, "203": {"vr": "DS", "Value": [-488.0]}, "204": {"vr": "DS", "Value": [77.0]}, "205": {"vr": "DS", "Value": [1171.0]}, "206": {"vr": "DS", "Value": [64.0]}, "207": {"vr": "DS", "Value": [890.0]}, "208": {"vr": "DS", "Value": [-106.0]}, "209": {"vr": "DS", "Value": [129.0]}, "210": {"vr": "DS", "Value": [624.0]}, "211": {"vr": "DS", "Value": [1190.0]}, "212": {"vr": "DS", "Value": [-257.0]}, "213": {"vr": "DS", "Value": [598.0]}, "214": {"vr": "DS", "Value": [1288.0]}, "215": {"vr": "DS", "Value": [352.0]}, "216": {"vr": "DS", "Value": [-94.0]}, "217": {"vr": "DS", "Value": [485.0]}, "218": {"vr": "DS", "Value": [1243.0]}, "219": {"vr": "DS", "Value": [1313.0]}, "220": {"vr": "DS", "Value": [377.0]}, "221": {"vr": "DS", "Value": [118.0]}, "222": {"vr": "DS", "Value": [116.0]}, "223": {"vr": "DS", "Value": [601.0]}, "224": {"vr": "DS", "Value": [-81.0]}, "225": {"vr": "DS", "Value": [-34.0]}, "226": {"vr": "DS", "Value": [1060.0]}, "227": {"vr": "DS", "Value": [41.0]}, "228": {"vr": "DS", "Value": [-19.0]}, "229": {"vr": "DS", "Value": [-444.0]}, "230": {"vr": "DS", "Value": [891.0]}, "231": {"vr": "DS", "Value": [358.0]}, "232": {"vr": "DS", "Value": [530.0]}, "233": {"vr": "DS", "Value": [962.0]}, "234": {"vr": "DS", "Value": [529.0]}, "235": {"vr": "DS", "Value": [-288.0]}, "236": {"vr": "DS", "Value": [-712.0]}, "237": {"vr": "DS", "Value": [-417.0]}, "238": {"vr": "DS", "Value": [-16.0]}, "239": {"vr": "DS", "Value": [25.0]}}, "00281051": {"0": {"vr": "DS", "Value": [2457.0]}, "1": {"vr": "DS", "Value": [2594.0]}, "2": {"vr": "DS", "Value": [1810.0]}, "3": {"vr": "DS", "Value": [2216.0]}, "4": {"vr": "DS", "Value": [2275.0]}, "5": {"vr": "DS", "Value": [9411.0]}, "6": {"vr": "DS", "Value": [2811.0]}, "7": {"vr": "DS", "Value": [9565.0]}, "8": {"vr": "DS", "Value": [9526.0]}, "9": {"vr": "DS", "Value": [2864.0]}, "10": {"vr": "DS", "Value": [1156.0]}, "11": {"vr": "DS", "Value": [2854.0]}, "12": {"vr": "DS", "Value": [3137.0]}, "13": {"vr": "DS", "Value": [2714.0]}, "14": {"vr": "DS", "Value": [2050.0]}, "15": {"vr": "DS", "Value": [9427.0]}, "16": {"vr": "DS", "Value": [2535.0]}, "17": {"vr": "DS", "Value": [3467.0]}, "18": {"vr": "DS", "Value": [2085.0]}, "19": {"vr": "DS", "Value": [2009.0]}, "20": {"vr": "DS", "Value": [2547.0]}, "21": {"vr": "DS", "Value": [2460.0]}, "22": {"vr": "DS", "Value": [2445.0]}, "23": {"vr": "DS", "Value": [2433.0]}, "24": {"vr": "DS", "Value": [1667.0]}, "25": {"vr": "DS", "Value": [2165.0]}, "26": {"vr": "DS", "Value": [9583.0]}, "27": {"vr": "DS", "Value": [3575.0]}, "28": {"vr": "DS", "Value": [2216.0]}, "29": {"vr": "DS", "Value": [3248.0]}, "30": {"vr": "DS", "Value": [9663.0]}, "31": {"vr": "DS", "Value": [2729.0]}, "32": {"vr": "DS", "Value": [2451.0]}, "33": {"vr": "DS", "Value": [9722.0]}, "34": {"vr": "DS", "Value": [9546.0]}, "35": {"vr": "DS", "Value": [2515.0]}, "36": {"vr": "DS", "Value": [9519.0]}, "37": {"vr": "DS", "Value": [2385.0]}, "38": {"vr": "DS", "Value": [2308.0]}, "39": {"vr": "DS", "Value": [2372.0]}, "40": {"vr": "DS", "Value": [2343.0]}, "41": {"vr": "DS", "Value": [2289.0]}, "42": {"vr": "DS", "Value": [9577.0]}, "43": {"vr": "DS", "Value": [2017.0]}, "44": {"vr": "DS", "Value": [3354.0]}, "45": {"vr": "DS", "Value": [3123.0]}, "46": {"vr": "DS", "Value": [3119.0]}, "47": {"vr": "DS", "Value": [2326.0]}, "48": {"vr": "DS", "Value": [2200.0]}, "49": {"vr": "DS", "Value": [9594.0]}, "50": {"vr": "DS", "Value": [1633.0]}, "51": {"vr": "DS", "Value": [1805.0]}, "52": {"vr": "DS", "Value": [9770.0]}, "53": {"vr": "DS", "Value": [2275.0]}, "54": {"vr": "DS", "Value": [2010.0]}, "55": {"vr": "DS", "Value": [3100.0]}, "56": {"vr": "DS", "Value": [2691.0]}, "57": {"vr": "DS", "Value": [9581.0]}, "58": {"vr": "DS", "Value": [9705.0]}, "59": {"vr": "DS", "Value": [9648.0]}, "60": {"vr": "DS", "Value": [2274.0]}, "61": {"vr": "DS", "Value": [2233.0]}, "62": {"vr": "DS", "Value": [2117.0]}, "63": {"vr": "DS", "Value": [3102.0]}, "64": {"vr": "DS", "Value": [3003.0]}, "65": {"vr": "DS", "Value": [2466.0]}, "66": {"vr": "DS", "Value": [2153.0]}, "67": {"vr": "DS", "Value": [2423.0]}, "68": {"vr": "DS", "Value": [3213.0]}, "69": {"vr": "DS", "Value": [9662.0]}, "70": {"vr": "DS", "Value": [2129.0]}, "71": {"vr": "DS", "Value": [2678.0]}, "72": {"vr": "DS", "Value": [9741.0]}, "73": {"vr": "DS", "Value": [2222.0]}, "74": {"vr": "DS", "Value": [2671.0]}, "75": {"vr": "DS", "Value": [2790.0]}, "76": {"vr": "DS", "Value": [9492.0]}, "77": {"vr": "DS", "Value": [2175.0]}, "78": {"vr": "DS", "Value": [9590.0]}, "79": {"vr": "DS", "Value": [3093.0]}, "80": {"vr": "DS", "Value": [2313.0]}, "81": {"vr": "DS", "Value": [9618.0]}, "82": {"vr": "DS", "Value": [9625.0]}, "83": {"vr": "DS", "Value": [2470.0]}, "84": {"vr": "DS", "Value": [2502.0]}, "85": {"vr": "DS", "Value": [986.0]}, "86": {"vr": "DS", "Value": [2909.0]}, "87": {"vr": "DS", "Value": [1783.0]}, "88": {"vr": "DS", "Value": [2971.0]}, "89": {"vr": "DS", "Value": [1658.0]}, "90": {"vr": "DS", "Value": [2093.0]}, "91": {"vr": "DS", "Value": [9705.0]}, "92": {"vr": "DS", "Value": [9469.0]}, "93": {"vr": "DS", "Value": [2077.0]}, "94": {"vr": "DS", "Value": [2056.0]}, "95": {"vr": "DS", "Value": [3189.0]}, "96": {"vr": "DS", "Value": [2593.0]}, "97": {"vr": "DS", "Value": [2522.0]}, "98": {"vr": "DS", "Value": [2553.0]}, "99": {"vr": "DS", "Value": [904.0]}, "100": {"vr": "DS", "Value": [9740.0]}, "101": {"vr": "DS", "Value": [9729.0]}, "102": {"vr": "DS", "Value": [2716.0]}, "103": {"vr": "DS", "Value": [1805.0]}, "104": {"vr": "DS", "Value": [2576.0]}, "105": {"vr": "DS", "Value": [9247.0]}, "106": {"vr": "DS", "Value": [9597.0]}, "107": {"vr": "DS", "Value": [1239.0]}, "108": {"vr": "DS", "Value": [9695.0]}, "109": {"vr": "DS", "Value": [9644.0]}, "110": {"vr": "DS", "Value": [9375.0]}, "111": {"vr": "DS", "Value": [2438.0]}, "112": {"vr": "DS", "Value": [1563.0]}, "113": {"vr": "DS", "Value": [1484.0]}, "114": {"vr": "DS", "Value": [1443.0]}, "115": {"vr": "DS", "Value": [2016.0]}, "116": {"vr": "DS", "Value": [2672.0]}, "117": {"vr": "DS", "Value": [2922.0]}, "118": {"vr": "DS", "Value": [9718.0]}, "119": {"vr": "DS", "Value": [2531.0]}, "120": {"vr": "DS", "Value": [1210.0]}, "121": {"vr": "DS", "Value": [9721.0]}, "122": {"vr": "DS", "Value": [9664.0]}, "123": {"vr": "DS", "Value": [9576.0]}, "124": {"vr": "DS", "Value": [2281.0]}, "125": {"vr": "DS", "Value": [9608.0]}, "126": {"vr": "DS", "Value": [2234.0]}, "127": {"vr": "DS", "Value": [9765.0]}, "128": {"vr": "DS", "Value": [2176.0]}, "129": {"vr": "DS", "Value": [2469.0]}, "130": {"vr": "DS", "Value": [774.0]}, "131": {"vr": "DS", "Value": [2409.0]}, "132": {"vr": "DS", "Value": [1824.0]}, "133": {"vr": "DS", "Value": [9436.0]}, "134": {"vr": "DS", "Value": [2549.0]}, "135": {"vr": "DS", "Value": [2538.0]}, "136": {"vr": "DS", "Value": [1756.0]}, "137": {"vr": "DS", "Value": [2403.0]}, "138": {"vr": "DS", "Value": [2037.0]}, "139": {"vr": "DS", "Value": [2077.0]}, "140": {"vr": "DS", "Value": [2322.0]}, "141": {"vr": "DS", "Value": [2274.0]}, "142": {"vr": "DS", "Value": [1624.0]}, "143": {"vr": "DS", "Value": [2233.0]}, "144": {"vr": "DS", "Value": [3081.0]}, "145": {"vr": "DS", "Value": [2621.0]}, "146": {"vr": "DS", "Value": [2010.0]}, "147": {"vr": "DS", "Value": [2556.0]}, "148": {"vr": "DS", "Value": [2178.0]}, "149": {"vr": "DS", "Value": [1907.0]}, "150": {"vr": "DS", "Value": [1707.0]}, "151": {"vr": "DS", "Value": [9687.0]}, "152": {"vr": "DS", "Value": [1991.0]}, "153": {"vr": "DS", "Value": [2565.0]}, "154": {"vr": "DS", "Value": [1970.0]}, "155": {"vr": "DS", "Value": [2322.0]}, "156": {"vr": "DS", "Value": [9801.0]}, "157": {"vr": "DS", "Value": [1973.0]}, "158": {"vr": "DS", "Value": [2809.0]}, "159": {"vr": "DS", "Value": [2237.0]}, "160": {"vr": "DS", "Value": [9556.0]}, "161": {"vr": "DS", "Value": [2359.0]}, "162": {"vr": "DS", "Value": [1644.0]}, "163": {"vr": "DS", "Value": [9603.0]}, "164": {"vr": "DS", "Value": [2656.0]}, "165": {"vr": "DS", "Value": [2936.0]}, "166": {"vr": "DS", "Value": [9767.0]}, "167": {"vr": "DS", "Value": [2361.0]}, "168": {"vr": "DS", "Value": [2212.0]}, "169": {"vr": "DS", "Value": [3152.0]}, "170": {"vr": "DS", "Value": [9633.0]}, "171": {"vr": "DS", "Value": [2820.0]}, "172": {"vr": "DS", "Value": [3063.0]}, "173": {"vr": "DS", "Value": [2735.0]}, "174": {"vr": "DS", "Value": [2657.0]}, "175": {"vr": "DS", "Value": [9644.0]}, "176": {"vr": "DS", "Value": [9489.0]}, "177": {"vr": "DS", "Value": [9326.0]}, "178": {"vr": "DS", "Value": [3260.0]}, "179": {"vr": "DS", "Value": [1448.0]}, "180": {"vr": "DS", "Value": [9511.0]}, "181": {"vr": "DS", "Value": [9451.0]}, "182": {"vr": "DS", "Value": [1586.0]}, "183": {"vr": "DS", "Value": [2123.0]}, "184": {"vr": "DS", "Value": [9545.0]}, "185": {"vr": "DS", "Value": [3005.0]}, "186": {"vr": "DS", "Value": [3383.0]}, "187": {"vr": "DS", "Value": [1703.0]}, "188": {"vr": "DS", "Value": [3127.0]}, "189": {"vr": "DS", "Value": [1212.0]}, "190": {"vr": "DS", "Value": [2239.0]}, "191": {"vr": "DS", "Value": [2265.0]}, "192": {"vr": "DS", "Value": [2309.0]}, "193": {"vr": "DS", "Value": [1923.0]}, "194": {"vr": "DS", "Value": [9740.0]}, "195": {"vr": "DS", "Value": [2278.0]}, "196": {"vr": "DS", "Value": [9344.0]}, "197": {"vr": "DS", "Value": [1936.0]}, "198": {"vr": "DS", "Value": [2472.0]}, "199": {"vr": "DS", "Value": [1703.0]}, "200": {"vr": "DS", "Value": [2087.0]}, "201": {"vr": "DS", "Value": [9778.0]}, "202": {"vr": "DS", "Value": [2080.0]}, "203": {"vr": "DS", "Value": [2583.0]}, "204": {"vr": "DS", "Value": [9708.0]}, "205": {"vr": "DS", "Value": [2343.0]}, "206": {"vr": "DS", "Value": [9322.0]}, "207": {"vr": "DS", "Value": [1780.0]}, "208": {"vr": "DS", "Value": [2197.0]}, "209": {"vr": "DS", "Value": [9743.0]}, "210": {"vr": "DS", "Value": [3310.0]}, "211": {"vr": "DS", "Value": [2380.0]}, "212": {"vr": "DS", "Value": [2214.0]}, "213": {"vr": "DS", "Value": [2793.0]}, "214": {"vr": "DS", "Value": [2577.0]}, "215": {"vr": "DS", "Value": [2692.0]}, "216": {"vr": "DS", "Value": [9489.0]}, "217": {"vr": "DS", "Value": [2218.0]}, "218": {"vr": "DS", "Value": [2486.0]}, "219": {"vr": "DS", "Value": [2627.0]}, "220": {"vr": "DS", "Value": [2841.0]}, "221": {"vr": "DS", "Value": [9596.0]}, "222": {"vr": "DS", "Value": [2598.0]}, "223": {"vr": "DS", "Value": [2434.0]}, "224": {"vr": "DS", "Value": [9449.0]}, "225": {"vr": "DS", "Value": [2607.0]}, "226": {"vr": "DS", "Value": [2120.0]}, "227": {"vr": "DS", "Value": [9302.0]}, "228": {"vr": "DS", "Value": [1741.0]}, "229": {"vr": "DS", "Value": [2677.0]}, "230": {"vr": "DS", "Value": [1782.0]}, "231": {"vr": "DS", "Value": [2868.0]}, "232": {"vr": "DS", "Value": [3137.0]}, "233": {"vr": "DS", "Value": [1925.0]}, "234": {"vr": "DS", "Value": [2047.0]}, "235": {"vr": "DS", "Value": [1761.0]}, "236": {"vr": "DS", "Value": [3058.0]}, "237": {"vr": "DS", "Value": [2880.0]}, "238": {"vr": "DS", "Value": [2432.0]}, "239": {"vr": "DS", "Value": [9700.0]}}, "0043102F": {"0": {"vr": "SS", "Value": [3]}, "1": {"vr": "SS", "Value": [2]}, "2": {"vr": "SS", "Value": [0]}, "3": {"vr": "SS", "Value": [0]}, "4": {"vr": "SS", "Value": [0]}, "5": {"vr": "SS", "Value": [1]}, "6": {"vr": "SS", "Value": [2]}, "7": {"vr": "SS", "Value": [1]}, "8": {"vr": "SS", "Value": [1]}, "9": {"vr": "SS", "Value": [2]}, "10": {"vr": "SS", "Value": [0]}, "11": {"vr": "SS", "Value": [2]}, "12": {"vr": "SS", "Value": [2]}, "13": {"vr": "SS", "Value": [2]}, "14": {"vr": "SS", "Value": [0]}, "15": {"vr": "SS", "Value": [1]}, "16": {"vr": "SS", "Value": [2]}, "17": {"vr": "SS", "Value": [3]}, "18": {"vr": "SS", "Value": [0]}, "19": {"vr": "SS", "Value": [0]}, "20": {"vr": "SS", "Value": [2]}, "21": {"vr": "SS", "Value": [2]}, "22": {"vr": "SS", "Value": [3]}, "23": {"vr": "SS", "Value": [3]}, "24": {"vr": "SS", "Value": [0]}, "25": {"vr": "SS", "Value": [0]}, "26": {"vr": "SS", "Value": [1]}, "27": {"vr": "SS", "Value": [2]}, "28": {"vr": "SS", "Value": [0]}, "29": {"vr": "SS", "Value": [3]}, "30": {"vr": "SS", "Value": [1]}, "31": {"vr": "SS", "Value": [3]}, "32": {"vr": "SS", "Value": [0]}, "33": {"vr": "SS", "Value": [1]}, "34": {"vr": "SS", "Value": [1]}, "35": {"vr": "SS", "Value": [3]}, "36": {"vr": "SS", "Value": [1]}, "37": {"vr": "SS", "Value": [0]}, "38": {"vr": "SS", "Value": [0]}, "39": {"vr": "SS", "Value": [2]}, "40": {"vr": "SS", "Value": [0]}, "41": {"vr": "SS", "Value": [0]}, "42": {"vr": "SS", "Value": [1]}, "43": {"vr": "SS", "Value": [0]}, "44": {"vr": "SS", "Value": [3]}, "45": {"vr": "SS", "Value": [3]}, "46": {"vr": "SS", "Value": [3]}, "47": {"vr": "SS", "Value": [2]}, "48": {"vr": "SS", "Value": [3]}, "49": {"vr": "SS", "Value": [1]}, "50": {"vr": "SS", "Value": [0]}, "51": {"vr": "SS", "Value": [2]}, "52": {"vr": "SS", "Value": [1]}, "53": {"vr": "SS", "Value": [0]}, "54": {"vr": "SS", "Value": [0]}, "55": {"vr": "SS", "Value": [3]}, "56": {"vr": "SS", "Value": [2]}, "57": {"vr": "SS", "Value": [1]}, "58": {"vr": "SS", "Value": [1]}, "59": {"vr": "SS", "Value": [1]}, "60": {"vr": "SS", "Value": [3]}, "61": {"vr": "SS", "Value": [0]}, "62": {"vr": "SS", "Value": [0]}, "63": {"vr": "SS", "Value": [3]}, "64": {"vr": "SS", "Value": [3]}, "65": {"vr": "SS", "Value": [3]}, "66": {"vr": "SS", "Value": [2]}, "67": {"vr": "SS", "Value": [3]}, "68": {"vr": "SS", "Value": [3]}, "69": {"vr": "SS", "Value": [1]}, "70": {"vr": "SS", "Value": [2]}, "71": {"vr": "SS", "Value": [3]}, "72": {"vr": "SS", "Value": [1]}, "73": {"vr": "SS", "Value": [0]}, "74": {"vr": "SS", "Value": [2]}, "75": {"vr": "SS", "Value": [3]}, "76": {"vr": "SS", "Value": [1]}, "77": {"vr": "SS", "Value": [2]}, "78": {"vr": "SS", "Value": [1]}, "79": {"vr": "SS", "Value": [3]}, "80": {"vr": "SS", "Value": [0]}, "81": {"vr": "SS", "Value": [1]}, "82": {"vr": "SS", "Value": [1]}, "83": {"vr": "SS", "Value": [3]}, "84": {"vr": "SS", "Value": [3]}, "85": {"vr": "SS", "Value": [0]}, "86": {"vr": "SS", "Value": [2]}, "87": {"vr": "SS", "Value": [3]}, "88": {"vr": "SS", "Value": [2]}, "89": {"vr": "SS", "Value": [0]}, "90": {"vr": "SS", "Value": [0]}, "91": {"vr": "SS", "Value": [1]}, "92": {"vr": "SS", "Value": [1]}, "93": {"vr": "SS", "Value": [2]}, "94": {"vr": "SS", "Value": [0]}, "95": {"vr": "SS", "Value": [2]}, "96": {"vr": "SS", "Value": [3]}, "97": {"vr": "SS", "Value": [3]}, "98": {"vr": "SS", "Value": [0]}, "99": {"vr": "SS", "Value": [3]}, "100": {"vr": "SS", "Value": [1]}, "101": {"vr": "SS", "Value": [1]}, "102": {"vr": "SS", "Value": [2]}, "103": {"vr": "SS", "Value": [0]}, "104": {"vr": "SS", "Value": [0]}, "105": {"vr": "SS", "Value": [1]}, "106": {"vr": "SS", "Value": [1]}, "107": {"vr": "SS", "Value": [0]}, "108": {"vr": "SS", "Value": [1]}, "109": {"vr": "SS", "Value": [1]}, "110": {"vr": "SS", "Value": [1]}, "111": {"vr": "SS", "Value": [0]}, "112": {"vr": "SS", "Value": [3]}, "113": {"vr": "SS", "Value": [2]}, "114": {"vr": "SS", "Value": [2]}, "115": {"vr": "SS", "Value": [0]}, "116": {"vr": "SS", "Value": [3]}, "117": {"vr": "SS", "Value": [2]}, "118": {"vr": "SS", "Value": [1]}, "119": {"vr": "SS", "Value": [0]}, "120": {"vr": "SS", "Value": [0]}, "121": {"vr": "SS", "Value": [1]}, "122": {"vr": "SS", "Value": [1]}, "123": {"vr": "SS", "Value": [1]}, "124": {"vr": "SS", "Value": [3]}, "125": {"vr": "SS", "Value": [1]}, "126": {"vr": "SS", "Value": [2]}, "127": {"vr": "SS", "Value": [1]}, "128": {"vr": "SS", "Value": [0]}, "129": {"vr": "SS", "Value": [0]}, "130": {"vr": "SS", "Value": [0]}, "131": {"vr": "SS", "Value": [2]}, "132": {"vr": "SS", "Value": [0]}, "133": {"vr": "SS", "Value": [1]}, "134": {"vr": "SS", "Value": [3]}, "135": {"vr": "SS", "Value": [3]}, "136": {"vr": "SS", "Value": [0]}, "137": {"vr": "SS", "Value": [2]}, "138": {"vr": "SS", "Value": [0]}, "139": {"vr": "SS", "Value": [3]}, "140": {"vr": "SS", "Value": [3]}, "141": {"vr": "SS", "Value": [2]}, "142": {"vr": "SS", "Value": [2]}, "143": {"vr": "SS", "Value": [2]}, "144": {"vr": "SS", "Value": [2]}, "145": {"vr": "SS", "Value": [3]}, "146": {"vr": "SS", "Value": [0]}, "147": {"vr": "SS", "Value": [3]}, "148": {"vr": "SS", "Value": [3]}, "149": {"vr": "SS", "Value": [3]}, "150": {"vr": "SS", "Value": [2]}, "151": {"vr": "SS", "Value": [1]}, "152": {"vr": "SS", "Value": [0]}, "153": {"vr": "SS", "Value": [2]}, "154": {"vr": "SS", "Value": [2]}, "155": {"vr": "SS", "Value": [0]}, "156": {"vr": "SS", "Value": [1]}, "157": {"vr": "SS", "Value": [0]}, "158": {"vr": "SS", "Value": [3]}, "159": {"vr": "SS", "Value": [0]}, "160": {"vr": "SS", "Value": [1]}, "161": {"vr": "SS", "Value": [3]}, "162": {"vr": "SS", "Value": [3]}, "163": {"vr": "SS", "Value": [1]}, "164": {"vr": "SS", "Value": [2]}, "165": {"vr": "SS", "Value": [2]}, "166": {"vr": "SS", "Value": [1]}, "167": {"vr": "SS", "Value": [0]}, "168": {"vr": "SS", "Value": [3]}, "169": {"vr": "SS", "Value": [2]}, "170": {"vr": "SS", "Value": [1]}, "171": {"vr": "SS", "Value": [2]}, "172": {"vr": "SS", "Value": [3]}, "173": {"vr": "SS", "Value": [3]}, "174": {"vr": "SS", "Value": [3]}, "175": {"vr": "SS", "Value": [1]}, "176": {"vr": "SS", "Value": [1]}, "177": {"vr": "SS", "Value": [1]}, "178": {"vr": "SS", "Value": [2]}, "179": {"vr": "SS", "Value": [2]}, "180": {"vr": "SS", "Value": [1]}, "181": {"vr": "SS", "Value": [1]}, "182": {"vr": "SS", "Value": [3]}, "183": {"vr": "SS", "Value": [0]}, "184": {"vr": "SS", "Value": [1]}, "185": {"vr": "SS", "Value": [2]}, "186": {"vr": "SS", "Value": [2]}, "187": {"vr": "SS", "Value": [3]}, "188": {"vr": "SS", "Value": [2]}, "189": {"vr": "SS", "Value": [0]}, "190": {"vr": "SS", "Value": [2]}, "191": {"vr": "SS", "Value": [3]}, "192": {"vr": "SS", "Value": [2]}, "193": {"vr": "SS", "Value": [2]}, "194": {"vr": "SS", "Value": [1]}, "195": {"vr": "SS", "Value": [2]}, "196": {"vr": "SS", "Value": [1]}, "197": {"vr": "SS", "Value": [2]}, "198": {"vr": "SS", "Value": [3]}, "199": {"vr": "SS", "Value": [3]}, "200": {"vr": "SS", "Value": [0]}, "201": {"vr": "SS", "Value": [1]}, "202": {"vr": "SS", "Value": [0]}, "203": {"vr": "SS", "Value": [3]}, "204": {"vr": "SS", "Value": [1]}, "205": {"vr": "SS", "Value": [0]}, "206": {"vr": "SS", "Value": [1]}, "207": {"vr": "SS", "Value": [0]}, "208": {"vr": "SS", "Value": [2]}, "209": {"vr": "SS", "Value": [1]}, "210": {"vr": "SS", "Value": [3]}, "211": {"vr": "SS", "Value": [0]}, "212": {"vr": "SS", "Value": [3]}, "213": {"vr": "SS", "Value": [2]}, "214": {"vr": "SS", "Value": [0]}, "215": {"vr": "SS", "Value": [2]}, "216": {"vr": "SS", "Value": [1]}, "217": {"vr": "SS", "Value": [2]}, "218": {"vr": "SS", "Value": [0]}, "219": {"vr": "SS", "Value": [0]}, "220": {"vr": "SS", "Value": [3]}, "221": {"vr": "SS", "Value": [1]}, "222": {"vr": "SS", "Value": [3]}, "223": {"vr": "SS", "Value": [2]}, "224": {"vr": "SS", "Value": [1]}, "225": {"vr": "SS", "Value": [3]}, "226": {"vr": "SS", "Value": [0]}, "227": {"vr": "SS", "Value": [1]}, "228": {"vr": "SS", "Value": [2]}, "229": {"vr": "SS", "Value": [3]}, "230": {"vr": "SS", "Value": [0]}, "231": {"vr": "SS", "Value": [3]}, "232": {"vr": "SS", "Value": [2]}, "233": {"vr": "SS", "Value": [0]}, "234": {"vr": "SS", "Value": [3]}, "235": {"vr": "SS", "Value": [3]}, "236": {"vr": "SS", "Value": [2]}, "237": {"vr": "SS", "Value": [2]}, "238": {"vr": "SS", "Value": [2]}, "239": {"vr": "SS", "Value": [1]}}, "00431088": {"0": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "1": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "2": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "3": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "4": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "6": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "9": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "10": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "11": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "12": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "13": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "14": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "16": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "17": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "18": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "19": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "20": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "21": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "22": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "23": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "24": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "25": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "27": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "28": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "29": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "31": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "32": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "35": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "37": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "38": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "39": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "40": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "41": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "43": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "44": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "45": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "46": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "47": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "48": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "50": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "51": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "53": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "54": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "55": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "56": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "60": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "61": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "62": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "63": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "64": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "65": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "66": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "67": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "68": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "70": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "71": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "73": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "74": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "75": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "77": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "79": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "80": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "83": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "84": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "85": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "86": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "87": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "88": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "89": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "90": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "93": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "94": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "95": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "96": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "97": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "98": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "99": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "102": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "103": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "104": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "107": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "111": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "112": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "113": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "114": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "115": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "116": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "117": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "119": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "120": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "124": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "126": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "128": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "129": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "130": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "131": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "132": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "134": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "135": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "136": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "137": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "138": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "139": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "140": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "141": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "142": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "143": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "144": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "145": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "146": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "147": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "148": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "149": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "150": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "152": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "153": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "154": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "155": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "157": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "158": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "159": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "161": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "162": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "164": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "165": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "167": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "168": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "169": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "171": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "172": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "173": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "174": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "178": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "179": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "182": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "183": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "185": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "186": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "187": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "188": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "189": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "190": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "191": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "192": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "193": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "195": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "197": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "198": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "199": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "200": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "202": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "203": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "205": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "207": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "208": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "210": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "211": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "212": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "213": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "214": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "215": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "217": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "218": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "219": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "220": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "222": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "223": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "225": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "226": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "228": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "229": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "230": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "231": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "232": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "233": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "234": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "235": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "236": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "237": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}, "238": {"vr": "UI", "Value": ["1.2.840.113619.2.408.5282380.5891679.25897.1618892550.727"]}}, "00431097": {"0": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "1": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "2": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "3": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "4": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "5": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "6": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "7": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "8": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "9": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "10": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "11": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "12": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "13": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "14": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "15": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "16": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "17": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "18": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "19": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "20": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "21": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "22": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "23": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "24": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "25": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "26": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "27": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "28": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "29": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "30": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "31": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "32": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "33": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "34": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "35": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "36": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "37": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "38": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "39": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "40": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "41": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "42": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "43": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "44": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "45": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "46": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "47": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "48": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "49": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "50": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "51": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "52": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "53": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "54": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "55": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "56": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "57": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "58": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "59": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "60": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "61": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "62": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "63": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "64": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "65": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "66": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "67": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "68": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "69": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "70": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "71": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "72": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "73": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "74": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "75": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "76": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "77": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "78": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "79": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "80": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "81": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "82": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "83": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "84": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "85": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "86": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "87": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "88": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "89": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "90": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "91": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "92": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "93": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "94": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "95": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "96": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "97": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "98": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "99": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "100": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "101": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "102": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "103": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "104": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "105": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "106": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "107": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "108": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "109": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "110": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "111": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "112": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "113": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "114": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "115": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "116": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "117": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "118": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "119": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "120": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "121": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "122": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "123": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "124": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "125": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "126": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "127": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "128": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "129": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "130": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "131": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "132": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "133": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "134": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "135": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "136": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "137": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "138": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "139": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "140": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "141": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "142": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "143": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "144": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "145": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "146": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "147": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "148": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "149": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "150": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "151": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "152": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "153": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "154": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "155": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "156": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "157": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "158": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "159": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "160": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "161": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "162": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "163": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "164": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "165": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "166": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "167": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "168": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "169": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "170": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "171": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "172": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "173": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "174": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "175": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "176": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "177": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "178": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "179": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "180": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "181": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "182": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "183": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "184": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "185": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "186": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "187": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "188": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "189": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "190": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "191": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "192": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "193": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "194": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "195": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "196": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "197": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "198": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "199": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "200": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "201": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "202": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "203": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "204": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "205": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "206": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "207": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "208": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "209": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "210": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "211": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "212": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "213": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "214": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "215": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "216": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "217": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "218": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "219": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "220": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "221": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "222": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "223": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "224": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "225": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "226": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "227": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}, "228": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "229": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "230": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "231": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "232": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "233": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "234": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "235": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "236": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "237": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "238": {"vr": "LO", "Value": ["2", "1", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "1.5 0.2 0.2 2.0 64 0.4 1.05", "60", "0.03", "0.03", ""]}, "239": {"vr": "LO", "Value": ["2", "1", "", "", "", "60", "0.03", "0.03", ""]}}, "004310B8": {"0": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0431824]}, "1": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.347427]}, "2": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.000225544]}, "3": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00823402]}, "4": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00367451]}, "5": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00253677]}, "6": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.187038]}, "7": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.310074]}, "8": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00464058]}, "9": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0352135]}, "10": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.309048]}, "11": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0132523]}, "12": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00367451]}, "13": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0978508]}, "14": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0352135]}, "15": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -3.24249e-05]}, "16": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00101852]}, "17": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0844498]}, "18": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.116138]}, "19": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.159065]}, "20": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.000697374]}, "21": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.10099]}, "22": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0451965]}, "23": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.116138]}, "24": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00103116]}, "25": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00322437]}, "26": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.387634]}, "27": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.2435]}, "28": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.162331]}, "29": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0335846]}, "30": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0185089]}, "31": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00377083]}, "32": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0815201]}, "33": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00103116]}, "34": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.241127]}, "35": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.2435]}, "36": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.309048]}, "37": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -3.24249e-05]}, "38": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00377083]}, "39": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00193787]}, "40": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00117874]}, "41": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.347427]}, "42": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.162331]}, "43": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.136509]}, "44": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.214066]}, "45": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -3.24249e-05]}, "46": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00122643]}, "47": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.000225544]}, "48": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0542984]}, "49": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.211254]}, "50": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.10099]}, "51": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00823402]}, "52": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00322437]}, "53": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0266304]}, "54": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0185089]}, "55": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0815201]}, "56": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00162387]}, "57": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00164223]}, "58": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0335846]}, "59": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.159065]}, "60": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.159065]}, "61": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0978508]}, "62": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.012825]}, "63": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0193405]}, "64": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00191212]}, "65": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00164223]}, "66": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -3.24249e-05]}, "67": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00117874]}, "68": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.347427]}, "69": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00117874]}, "70": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0815201]}, "71": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.119404]}, "72": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00179577]}, "73": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.387634]}, "74": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.119404]}, "75": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.387634]}, "76": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0670395]}, "77": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0193405]}, "78": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00122643]}, "79": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.187038]}, "80": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00464058]}, "81": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00193787]}, "82": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0431824]}, "83": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00162387]}, "84": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00193787]}, "85": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.347359]}, "86": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0844498]}, "87": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.273678]}, "88": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00826454]}, "89": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0566559]}, "90": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0132523]}, "91": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.273678]}, "92": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0266304]}, "93": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00191212]}, "94": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00251579]}, "95": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0542984]}, "96": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00101852]}, "97": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.000225544]}, "98": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.275467]}, "99": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.388733]}, "100": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0978508]}, "101": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00162387]}, "102": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00179577]}, "103": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00164223]}, "104": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0335846]}, "105": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.012825]}, "106": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0451965]}, "107": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.241127]}, "108": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00367451]}, "109": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00377083]}, "110": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00823402]}, "111": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.310074]}, "112": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.241127]}, "113": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.211254]}, "114": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.388733]}, "115": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00826454]}, "116": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00367451]}, "117": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00428581]}, "118": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.136509]}, "119": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0670395]}, "120": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.211254]}, "121": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.139824]}, "122": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.214066]}, "123": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.116138]}, "124": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00464058]}, "125": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0253944]}, "126": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00122643]}, "127": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.275467]}, "128": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00342178]}, "129": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0542984]}, "130": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.388733]}, "131": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00322437]}, "132": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.183949]}, "133": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.000697374]}, "134": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.136509]}, "135": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00428581]}, "136": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.119404]}, "137": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00103116]}, "138": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00101852]}, "139": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00179577]}, "140": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0566559]}, "141": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.159065]}, "142": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.309048]}, "143": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00164223]}, "144": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00253677]}, "145": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.012825]}, "146": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00162387]}, "147": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0132523]}, "148": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00251579]}, "149": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0978508]}, "150": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.241127]}, "151": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.183949]}, "152": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.139824]}, "153": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0697136]}, "154": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0335846]}, "155": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00191212]}, "156": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.000225544]}, "157": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00428581]}, "158": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0266304]}, "159": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0253944]}, "160": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0566559]}, "161": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0253944]}, "162": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.211254]}, "163": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.347359]}, "164": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0185089]}, "165": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00464058]}, "166": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.187038]}, "167": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00193787]}, "168": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.139824]}, "169": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.387634]}, "170": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.2435]}, "171": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.310074]}, "172": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00342178]}, "173": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.275467]}, "174": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0670395]}, "175": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.347427]}, "176": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0132523]}, "177": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00101852]}, "178": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.162331]}, "179": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.347359]}, "180": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0352135]}, "181": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00251579]}, "182": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.183949]}, "183": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0844498]}, "184": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.10099]}, "185": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00377083]}, "186": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.275467]}, "187": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.309048]}, "188": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0451965]}, "189": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.273678]}, "190": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00342178]}, "191": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00826454]}, "192": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.214066]}, "193": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.116138]}, "194": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00191212]}, "195": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0253944]}, "196": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00342178]}, "197": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.136509]}, "198": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.162331]}, "199": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.347359]}, "200": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0697136]}, "201": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00428581]}, "202": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00122643]}, "203": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00823402]}, "204": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.388733]}, "205": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00179577]}, "206": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0193405]}, "207": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0451965]}, "208": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.012825]}, "209": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0815201]}, "210": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.310074]}, "211": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.187038]}, "212": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00253677]}, "213": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0431824]}, "214": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.214066]}, "215": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00251579]}, "216": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0697136]}, "217": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0670395]}, "218": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0431824]}, "219": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.2435]}, "220": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0352135]}, "221": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0542984]}, "222": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.10099]}, "223": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.183949]}, "224": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0844498]}, "225": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.000697374]}, "226": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0193405]}, "227": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00826454]}, "228": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.273678]}, "229": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0697136]}, "230": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.000697374]}, "231": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00322437]}, "232": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0266304]}, "233": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.00253677]}, "234": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00103116]}, "235": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, -0.0185089]}, "236": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.00117874]}, "237": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.139824]}, "238": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.0566559]}, "239": {"vr": "DS", "Value": [1.0, 1.0, 1.0, 0.0, 0.0, 0.119404]}}}


collated_data = {"0025101B": {"0": {"vr": "OB", "BinaryLength": 1264}, "1": {"vr": "OB", "BinaryLength": 1264}, "2": {"vr": "OB", "BinaryLength": 1264}, "3": {"vr": "OB", "BinaryLength": 1264}, "4": {"vr": "OB", "BinaryLength": 1264}, "5": {"vr": "OB", "BinaryLength": 1264}, "6": {"vr": "OB", "BinaryLength": 1264}, "7": {"vr": "OB", "BinaryLength": 1264}, "8": {"vr": "OB", "BinaryLength": 1264}, "9": {"vr": "OB", "BinaryLength": 1264}, "10": {"vr": "OB", "BinaryLength": 1264}, "11": {"vr": "OB", "BinaryLength": 1264}, "12": {"vr": "OB", "BinaryLength": 1264}, "13": {"vr": "OB", "BinaryLength": 1264}, "14": {"vr": "OB", "BinaryLength": 1264}, "15": {"vr": "OB", "BinaryLength": 1264}, "16": {"vr": "OB", "BinaryLength": 1264}, "17": {"vr": "OB", "BinaryLength": 1264}, "18": {"vr": "OB", "BinaryLength": 1264}, "19": {"vr": "OB", "BinaryLength": 1264}, "20": {"vr": "OB", "BinaryLength": 1264}, "21": {"vr": "OB", "BinaryLength": 1264}, "22": {"vr": "OB", "BinaryLength": 1264}, "23": {"vr": "OB", "BinaryLength": 1264}, "24": {"vr": "OB", "BinaryLength": 1264}, "25": {"vr": "OB", "BinaryLength": 1264}, "26": {"vr": "OB", "BinaryLength": 1264}, "27": {"vr": "OB", "BinaryLength": 1264}, "28": {"vr": "OB", "BinaryLength": 1264}, "29": {"vr": "OB", "BinaryLength": 1264}, "30": {"vr": "OB", "BinaryLength": 1264}, "31": {"vr": "OB", "BinaryLength": 1264}, "32": {"vr": "OB", "BinaryLength": 1264}, "33": {"vr": "OB", "BinaryLength": 1264}, "34": {"vr": "OB", "BinaryLength": 1264}, "35": {"vr": "OB", "BinaryLength": 1264}, "36": {"vr": "OB", "BinaryLength": 1264}, "37": {"vr": "OB", "BinaryLength": 1264}, "38": {"vr": "OB", "BinaryLength": 1264}, "39": {"vr": "OB", "BinaryLength": 1264}, "40": {"vr": "OB", "BinaryLength": 1264}, "41": {"vr": "OB", "BinaryLength": 1264}, "42": {"vr": "OB", "BinaryLength": 1264}, "43": {"vr": "OB", "BinaryLength": 1264}, "44": {"vr": "OB", "BinaryLength": 1264}, "45": {"vr": "OB", "BinaryLength": 1264}, "46": {"vr": "OB", "BinaryLength": 1264}, "47": {"vr": "OB", "BinaryLength": 1264}, "48": {"vr": "OB", "BinaryLength": 1264}, "49": {"vr": "OB", "BinaryLength": 1264}, "50": {"vr": "OB", "BinaryLength": 1264}, "51": {"vr": "OB", "BinaryLength": 1264}, "52": {"vr": "OB", "BinaryLength": 1264}, "53": {"vr": "OB", "BinaryLength": 1264}, "54": {"vr": "OB", "BinaryLength": 1264}, "55": {"vr": "OB", "BinaryLength": 1264}, "56": {"vr": "OB", "BinaryLength": 1264}, "57": {"vr": "OB", "BinaryLength": 1264}, "58": {"vr": "OB", "BinaryLength": 1264}, "59": {"vr": "OB", "BinaryLength": 1264}, "60": {"vr": "OB", "BinaryLength": 1264}, "61": {"vr": "OB", "BinaryLength": 1264}, "62": {"vr": "OB", "BinaryLength": 1264}, "63": {"vr": "OB", "BinaryLength": 1264}, "64": {"vr": "OB", "BinaryLength": 1264}, "65": {"vr": "OB", "BinaryLength": 1264}, "66": {"vr": "OB", "BinaryLength": 1264}, "67": {"vr": "OB", "BinaryLength": 1264}, "68": {"vr": "OB", "BinaryLength": 1264}, "69": {"vr": "OB", "BinaryLength": 1264}, "70": {"vr": "OB", "BinaryLength": 1264}, "71": {"vr": "OB", "BinaryLength": 1264}, "72": {"vr": "OB", "BinaryLength": 1264}, "73": {"vr": "OB", "BinaryLength": 1264}, "74": {"vr": "OB", "BinaryLength": 1264}, "75": {"vr": "OB", "BinaryLength": 1264}, "76": {"vr": "OB", "BinaryLength": 1264}, "77": {"vr": "OB", "BinaryLength": 1264}, "78": {"vr": "OB", "BinaryLength": 1264}, "79": {"vr": "OB", "BinaryLength": 1264}, "80": {"vr": "OB", "BinaryLength": 1264}, "81": {"vr": "OB", "BinaryLength": 1264}, "82": {"vr": "OB", "BinaryLength": 1264}, "83": {"vr": "OB", "BinaryLength": 1264}, "84": {"vr": "OB", "BinaryLength": 1264}, "85": {"vr": "OB", "BinaryLength": 1264}, "86": {"vr": "OB", "BinaryLength": 1264}, "87": {"vr": "OB", "BinaryLength": 1264}, "88": {"vr": "OB", "BinaryLength": 1264}, "89": {"vr": "OB", "BinaryLength": 1264}, "90": {"vr": "OB", "BinaryLength": 1264}, "91": {"vr": "OB", "BinaryLength": 1264}, "92": {"vr": "OB", "BinaryLength": 1264}, "93": {"vr": "OB", "BinaryLength": 1264}, "94": {"vr": "OB", "BinaryLength": 1264}, "95": {"vr": "OB", "BinaryLength": 1264}, "96": {"vr": "OB", "BinaryLength": 1264}, "97": {"vr": "OB", "BinaryLength": 1264}, "98": {"vr": "OB", "BinaryLength": 1264}, "99": {"vr": "OB", "BinaryLength": 1264}, "100": {"vr": "OB", "BinaryLength": 1264}, "101": {"vr": "OB", "BinaryLength": 1264}, "102": {"vr": "OB", "BinaryLength": 1264}, "103": {"vr": "OB", "BinaryLength": 1264}, "104": {"vr": "OB", "BinaryLength": 1264}, "105": {"vr": "OB", "BinaryLength": 1264}, "106": {"vr": "OB", "BinaryLength": 1264}, "107": {"vr": "OB", "BinaryLength": 1264}, "108": {"vr": "OB", "BinaryLength": 1264}, "109": {"vr": "OB", "BinaryLength": 1264}, "110": {"vr": "OB", "BinaryLength": 1264}, "111": {"vr": "OB", "BinaryLength": 1264}, "112": {"vr": "OB", "BinaryLength": 1264}, "113": {"vr": "OB", "BinaryLength": 1264}, "114": {"vr": "OB", "BinaryLength": 1264}, "115": {"vr": "OB", "BinaryLength": 1264}, "116": {"vr": "OB", "BinaryLength": 1264}, "117": {"vr": "OB", "BinaryLength": 1264}, "118": {"vr": "OB", "BinaryLength": 1264}, "119": {"vr": "OB", "BinaryLength": 1264}, "120": {"vr": "OB", "BinaryLength": 1264}, "121": {"vr": "OB", "BinaryLength": 1264}, "122": {"vr": "OB", "BinaryLength": 1264}, "123": {"vr": "OB", "BinaryLength": 1264}, "124": {"vr": "OB", "BinaryLength": 1264}, "125": {"vr": "OB", "BinaryLength": 1264}, "126": {"vr": "OB", "BinaryLength": 1264}, "127": {"vr": "OB", "BinaryLength": 1264}, "128": {"vr": "OB", "BinaryLength": 1264}, "129": {"vr": "OB", "BinaryLength": 1264}, "130": {"vr": "OB", "BinaryLength": 1264}, "131": {"vr": "OB", "BinaryLength": 1264}, "132": {"vr": "OB", "BinaryLength": 1264}, "133": {"vr": "OB", "BinaryLength": 1264}, "134": {"vr": "OB", "BinaryLength": 1264}, "135": {"vr": "OB", "BinaryLength": 1264}, "136": {"vr": "OB", "BinaryLength": 1264}, "137": {"vr": "OB", "BinaryLength": 1264}, "138": {"vr": "OB", "BinaryLength": 1264}, "139": {"vr": "OB", "BinaryLength": 1264}, "140": {"vr": "OB", "BinaryLength": 1264}, "141": {"vr": "OB", "BinaryLength": 1264}, "142": {"vr": "OB", "BinaryLength": 1264}, "143": {"vr": "OB", "BinaryLength": 1264}, "144": {"vr": "OB", "BinaryLength": 1264}, "145": {"vr": "OB", "BinaryLength": 1264}, "146": {"vr": "OB", "BinaryLength": 1264}, "147": {"vr": "OB", "BinaryLength": 1264}, "148": {"vr": "OB", "BinaryLength": 1264}, "149": {"vr": "OB", "BinaryLength": 1264}, "150": {"vr": "OB", "BinaryLength": 1264}, "151": {"vr": "OB", "BinaryLength": 1264}, "152": {"vr": "OB", "BinaryLength": 1264}, "153": {"vr": "OB", "BinaryLength": 1264}, "154": {"vr": "OB", "BinaryLength": 1264}, "155": {"vr": "OB", "BinaryLength": 1264}, "156": {"vr": "OB", "BinaryLength": 1264}, "157": {"vr": "OB", "BinaryLength": 1264}, "158": {"vr": "OB", "BinaryLength": 1264}, "159": {"vr": "OB", "BinaryLength": 1264}, "160": {"vr": "OB", "BinaryLength": 1264}, "161": {"vr": "OB", "BinaryLength": 1264}, "162": {"vr": "OB", "BinaryLength": 1264}, "163": {"vr": "OB", "BinaryLength": 1264}, "164": {"vr": "OB", "BinaryLength": 1264}, "165": {"vr": "OB", "BinaryLength": 1264}, "166": {"vr": "OB", "BinaryLength": 1264}, "167": {"vr": "OB", "BinaryLength": 1264}, "168": {"vr": "OB", "BinaryLength": 1264}, "169": {"vr": "OB", "BinaryLength": 1264}, "170": {"vr": "OB", "BinaryLength": 1264}, "171": {"vr": "OB", "BinaryLength": 1264}, "172": {"vr": "OB", "BinaryLength": 1264}, "173": {"vr": "OB", "BinaryLength": 1264}, "174": {"vr": "OB", "BinaryLength": 1264}, "175": {"vr": "OB", "BinaryLength": 1264}, "176": {"vr": "OB", "BinaryLength": 1264}, "177": {"vr": "OB", "BinaryLength": 1264}, "178": {"vr": "OB", "BinaryLength": 1264}, "179": {"vr": "OB", "BinaryLength": 1264}, "180": {"vr": "OB", "BinaryLength": 1264}, "181": {"vr": "OB", "BinaryLength": 1264}, "182": {"vr": "OB", "BinaryLength": 1264}, "183": {"vr": "OB", "BinaryLength": 1264}, "184": {"vr": "OB", "BinaryLength": 1264}, "185": {"vr": "OB", "BinaryLength": 1264}, "186": {"vr": "OB", "BinaryLength": 1264}, "187": {"vr": "OB", "BinaryLength": 1264}, "188": {"vr": "OB", "BinaryLength": 1264}, "189": {"vr": "OB", "BinaryLength": 1264}, "190": {"vr": "OB", "BinaryLength": 1264}, "191": {"vr": "OB", "BinaryLength": 1264}, "192": {"vr": "OB", "BinaryLength": 1264}, "193": {"vr": "OB", "BinaryLength": 1264}, "194": {"vr": "OB", "BinaryLength": 1264}, "195": {"vr": "OB", "BinaryLength": 1264}, "196": {"vr": "OB", "BinaryLength": 1264}, "197": {"vr": "OB", "BinaryLength": 1264}, "198": {"vr": "OB", "BinaryLength": 1264}, "199": {"vr": "OB", "BinaryLength": 1264}, "200": {"vr": "OB", "BinaryLength": 1264}, "201": {"vr": "OB", "BinaryLength": 1264}, "202": {"vr": "OB", "BinaryLength": 1264}, "203": {"vr": "OB", "BinaryLength": 1264}, "204": {"vr": "OB", "BinaryLength": 1264}, "205": {"vr": "OB", "BinaryLength": 1264}, "206": {"vr": "OB", "BinaryLength": 1264}, "207": {"vr": "OB", "BinaryLength": 1264}, "208": {"vr": "OB", "BinaryLength": 1264}, "209": {"vr": "OB", "BinaryLength": 1264}, "210": {"vr": "OB", "BinaryLength": 1264}, "211": {"vr": "OB", "BinaryLength": 1264}, "212": {"vr": "OB", "BinaryLength": 1264}, "213": {"vr": "OB", "BinaryLength": 1264}, "214": {"vr": "OB", "BinaryLength": 1264}, "215": {"vr": "OB", "BinaryLength": 1264}, "216": {"vr": "OB", "BinaryLength": 1264}, "217": {"vr": "OB", "BinaryLength": 1264}, "218": {"vr": "OB", "BinaryLength": 1264}, "219": {"vr": "OB", "BinaryLength": 1264}, "220": {"vr": "OB", "BinaryLength": 1264}, "221": {"vr": "OB", "BinaryLength": 1264}, "222": {"vr": "OB", "BinaryLength": 1264}, "223": {"vr": "OB", "BinaryLength": 1264}, "224": {"vr": "OB", "BinaryLength": 1264}, "225": {"vr": "OB", "BinaryLength": 1264}, "226": {"vr": "OB", "BinaryLength": 1264}, "227": {"vr": "OB", "BinaryLength": 1264}, "228": {"vr": "OB", "BinaryLength": 1264}, "229": {"vr": "OB", "BinaryLength": 1264}, "230": {"vr": "OB", "BinaryLength": 1264}, "231": {"vr": "OB", "BinaryLength": 1264}, "232": {"vr": "OB", "BinaryLength": 1264}, "233": {"vr": "OB", "BinaryLength": 1264}, "234": {"vr": "OB", "BinaryLength": 1264}, "235": {"vr": "OB", "BinaryLength": 1264}, "236": {"vr": "OB", "BinaryLength": 1264}, "237": {"vr": "OB", "BinaryLength": 1264}, "238": {"vr": "OB", "BinaryLength": 1264}, "239": {"vr": "OB", "BinaryLength": 1264}}, "00431028": {"0": {"vr": "OB", "BinaryLength": 108}, "1": {"vr": "OB", "BinaryLength": 108}, "2": {"vr": "OB", "BinaryLength": 108}, "3": {"vr": "OB", "BinaryLength": 108}, "4": {"vr": "OB", "BinaryLength": 108}, "5": {"vr": "OB", "BinaryLength": 108}, "6": {"vr": "OB", "BinaryLength": 108}, "7": {"vr": "OB", "BinaryLength": 108}, "8": {"vr": "OB", "BinaryLength": 108}, "9": {"vr": "OB", "BinaryLength": 108}, "10": {"vr": "OB", "BinaryLength": 108}, "11": {"vr": "OB", "BinaryLength": 108}, "12": {"vr": "OB", "BinaryLength": 108}, "13": {"vr": "OB", "BinaryLength": 108}, "14": {"vr": "OB", "BinaryLength": 108}, "15": {"vr": "OB", "BinaryLength": 108}, "16": {"vr": "OB", "BinaryLength": 108}, "17": {"vr": "OB", "BinaryLength": 108}, "18": {"vr": "OB", "BinaryLength": 108}, "19": {"vr": "OB", "BinaryLength": 108}, "20": {"vr": "OB", "BinaryLength": 108}, "21": {"vr": "OB", "BinaryLength": 108}, "22": {"vr": "OB", "BinaryLength": 108}, "23": {"vr": "OB", "BinaryLength": 108}, "24": {"vr": "OB", "BinaryLength": 108}, "25": {"vr": "OB", "BinaryLength": 108}, "26": {"vr": "OB", "BinaryLength": 108}, "27": {"vr": "OB", "BinaryLength": 108}, "28": {"vr": "OB", "BinaryLength": 108}, "29": {"vr": "OB", "BinaryLength": 108}, "30": {"vr": "OB", "BinaryLength": 108}, "31": {"vr": "OB", "BinaryLength": 108}, "32": {"vr": "OB", "BinaryLength": 108}, "33": {"vr": "OB", "BinaryLength": 108}, "34": {"vr": "OB", "BinaryLength": 108}, "35": {"vr": "OB", "BinaryLength": 108}, "36": {"vr": "OB", "BinaryLength": 108}, "37": {"vr": "OB", "BinaryLength": 108}, "38": {"vr": "OB", "BinaryLength": 108}, "39": {"vr": "OB", "BinaryLength": 108}, "40": {"vr": "OB", "BinaryLength": 108}, "41": {"vr": "OB", "BinaryLength": 108}, "42": {"vr": "OB", "BinaryLength": 108}, "43": {"vr": "OB", "BinaryLength": 108}, "44": {"vr": "OB", "BinaryLength": 108}, "45": {"vr": "OB", "BinaryLength": 108}, "46": {"vr": "OB", "BinaryLength": 108}, "47": {"vr": "OB", "BinaryLength": 108}, "48": {"vr": "OB", "BinaryLength": 108}, "49": {"vr": "OB", "BinaryLength": 108}, "50": {"vr": "OB", "BinaryLength": 108}, "51": {"vr": "OB", "BinaryLength": 108}, "52": {"vr": "OB", "BinaryLength": 108}, "53": {"vr": "OB", "BinaryLength": 108}, "54": {"vr": "OB", "BinaryLength": 108}, "55": {"vr": "OB", "BinaryLength": 108}, "56": {"vr": "OB", "BinaryLength": 108}, "57": {"vr": "OB", "BinaryLength": 108}, "58": {"vr": "OB", "BinaryLength": 108}, "59": {"vr": "OB", "BinaryLength": 108}, "60": {"vr": "OB", "BinaryLength": 108}, "61": {"vr": "OB", "BinaryLength": 108}, "62": {"vr": "OB", "BinaryLength": 108}, "63": {"vr": "OB", "BinaryLength": 108}, "64": {"vr": "OB", "BinaryLength": 108}, "65": {"vr": "OB", "BinaryLength": 108}, "66": {"vr": "OB", "BinaryLength": 108}, "67": {"vr": "OB", "BinaryLength": 108}, "68": {"vr": "OB", "BinaryLength": 108}, "69": {"vr": "OB", "BinaryLength": 108}, "70": {"vr": "OB", "BinaryLength": 108}, "71": {"vr": "OB", "BinaryLength": 108}, "72": {"vr": "OB", "BinaryLength": 108}, "73": {"vr": "OB", "BinaryLength": 108}, "74": {"vr": "OB", "BinaryLength": 108}, "75": {"vr": "OB", "BinaryLength": 108}, "76": {"vr": "OB", "BinaryLength": 108}, "77": {"vr": "OB", "BinaryLength": 108}, "78": {"vr": "OB", "BinaryLength": 108}, "79": {"vr": "OB", "BinaryLength": 108}, "80": {"vr": "OB", "BinaryLength": 108}, "81": {"vr": "OB", "BinaryLength": 108}, "82": {"vr": "OB", "BinaryLength": 108}, "83": {"vr": "OB", "BinaryLength": 108}, "84": {"vr": "OB", "BinaryLength": 108}, "85": {"vr": "OB", "BinaryLength": 108}, "86": {"vr": "OB", "BinaryLength": 108}, "87": {"vr": "OB", "BinaryLength": 108}, "88": {"vr": "OB", "BinaryLength": 108}, "89": {"vr": "OB", "BinaryLength": 108}, "90": {"vr": "OB", "BinaryLength": 108}, "91": {"vr": "OB", "BinaryLength": 108}, "92": {"vr": "OB", "BinaryLength": 108}, "93": {"vr": "OB", "BinaryLength": 108}, "94": {"vr": "OB", "BinaryLength": 108}, "95": {"vr": "OB", "BinaryLength": 108}, "96": {"vr": "OB", "BinaryLength": 108}, "97": {"vr": "OB", "BinaryLength": 108}, "98": {"vr": "OB", "BinaryLength": 108}, "99": {"vr": "OB", "BinaryLength": 108}, "100": {"vr": "OB", "BinaryLength": 108}, "101": {"vr": "OB", "BinaryLength": 108}, "102": {"vr": "OB", "BinaryLength": 108}, "103": {"vr": "OB", "BinaryLength": 108}, "104": {"vr": "OB", "BinaryLength": 108}, "105": {"vr": "OB", "BinaryLength": 108}, "106": {"vr": "OB", "BinaryLength": 108}, "107": {"vr": "OB", "BinaryLength": 108}, "108": {"vr": "OB", "BinaryLength": 108}, "109": {"vr": "OB", "BinaryLength": 108}, "110": {"vr": "OB", "BinaryLength": 108}, "111": {"vr": "OB", "BinaryLength": 108}, "112": {"vr": "OB", "BinaryLength": 108}, "113": {"vr": "OB", "BinaryLength": 108}, "114": {"vr": "OB", "BinaryLength": 108}, "115": {"vr": "OB", "BinaryLength": 108}, "116": {"vr": "OB", "BinaryLength": 108}, "117": {"vr": "OB", "BinaryLength": 108}, "118": {"vr": "OB", "BinaryLength": 108}, "119": {"vr": "OB", "BinaryLength": 108}, "120": {"vr": "OB", "BinaryLength": 108}, "121": {"vr": "OB", "BinaryLength": 108}, "122": {"vr": "OB", "BinaryLength": 108}, "123": {"vr": "OB", "BinaryLength": 108}, "124": {"vr": "OB", "BinaryLength": 108}, "125": {"vr": "OB", "BinaryLength": 108}, "126": {"vr": "OB", "BinaryLength": 108}, "127": {"vr": "OB", "BinaryLength": 108}, "128": {"vr": "OB", "BinaryLength": 108}, "129": {"vr": "OB", "BinaryLength": 108}, "130": {"vr": "OB", "BinaryLength": 108}, "131": {"vr": "OB", "BinaryLength": 108}, "132": {"vr": "OB", "BinaryLength": 108}, "133": {"vr": "OB", "BinaryLength": 108}, "134": {"vr": "OB", "BinaryLength": 108}, "135": {"vr": "OB", "BinaryLength": 108}, "136": {"vr": "OB", "BinaryLength": 108}, "137": {"vr": "OB", "BinaryLength": 108}, "138": {"vr": "OB", "BinaryLength": 108}, "139": {"vr": "OB", "BinaryLength": 108}, "140": {"vr": "OB", "BinaryLength": 108}, "141": {"vr": "OB", "BinaryLength": 108}, "142": {"vr": "OB", "BinaryLength": 108}, "143": {"vr": "OB", "BinaryLength": 108}, "144": {"vr": "OB", "BinaryLength": 108}, "145": {"vr": "OB", "BinaryLength": 108}, "146": {"vr": "OB", "BinaryLength": 108}, "147": {"vr": "OB", "BinaryLength": 108}, "148": {"vr": "OB", "BinaryLength": 108}, "149": {"vr": "OB", "BinaryLength": 108}, "150": {"vr": "OB", "BinaryLength": 108}, "151": {"vr": "OB", "BinaryLength": 108}, "152": {"vr": "OB", "BinaryLength": 108}, "153": {"vr": "OB", "BinaryLength": 108}, "154": {"vr": "OB", "BinaryLength": 108}, "155": {"vr": "OB", "BinaryLength": 108}, "156": {"vr": "OB", "BinaryLength": 108}, "157": {"vr": "OB", "BinaryLength": 108}, "158": {"vr": "OB", "BinaryLength": 108}, "159": {"vr": "OB", "BinaryLength": 108}, "160": {"vr": "OB", "BinaryLength": 108}, "161": {"vr": "OB", "BinaryLength": 108}, "162": {"vr": "OB", "BinaryLength": 108}, "163": {"vr": "OB", "BinaryLength": 108}, "164": {"vr": "OB", "BinaryLength": 108}, "165": {"vr": "OB", "BinaryLength": 108}, "166": {"vr": "OB", "BinaryLength": 108}, "167": {"vr": "OB", "BinaryLength": 108}, "168": {"vr": "OB", "BinaryLength": 108}, "169": {"vr": "OB", "BinaryLength": 108}, "170": {"vr": "OB", "BinaryLength": 108}, "171": {"vr": "OB", "BinaryLength": 108}, "172": {"vr": "OB", "BinaryLength": 108}, "173": {"vr": "OB", "BinaryLength": 108}, "174": {"vr": "OB", "BinaryLength": 108}, "175": {"vr": "OB", "BinaryLength": 108}, "176": {"vr": "OB", "BinaryLength": 108}, "177": {"vr": "OB", "BinaryLength": 108}, "178": {"vr": "OB", "BinaryLength": 108}, "179": {"vr": "OB", "BinaryLength": 108}, "180": {"vr": "OB", "BinaryLength": 108}, "181": {"vr": "OB", "BinaryLength": 108}, "182": {"vr": "OB", "BinaryLength": 108}, "183": {"vr": "OB", "BinaryLength": 108}, "184": {"vr": "OB", "BinaryLength": 108}, "185": {"vr": "OB", "BinaryLength": 108}, "186": {"vr": "OB", "BinaryLength": 108}, "187": {"vr": "OB", "BinaryLength": 108}, "188": {"vr": "OB", "BinaryLength": 108}, "189": {"vr": "OB", "BinaryLength": 108}, "190": {"vr": "OB", "BinaryLength": 108}, "191": {"vr": "OB", "BinaryLength": 108}, "192": {"vr": "OB", "BinaryLength": 108}, "193": {"vr": "OB", "BinaryLength": 108}, "194": {"vr": "OB", "BinaryLength": 108}, "195": {"vr": "OB", "BinaryLength": 108}, "196": {"vr": "OB", "BinaryLength": 108}, "197": {"vr": "OB", "BinaryLength": 108}, "198": {"vr": "OB", "BinaryLength": 108}, "199": {"vr": "OB", "BinaryLength": 108}, "200": {"vr": "OB", "BinaryLength": 108}, "201": {"vr": "OB", "BinaryLength": 108}, "202": {"vr": "OB", "BinaryLength": 108}, "203": {"vr": "OB", "BinaryLength": 108}, "204": {"vr": "OB", "BinaryLength": 108}, "205": {"vr": "OB", "BinaryLength": 108}, "206": {"vr": "OB", "BinaryLength": 108}, "207": {"vr": "OB", "BinaryLength": 108}, "208": {"vr": "OB", "BinaryLength": 108}, "209": {"vr": "OB", "BinaryLength": 108}, "210": {"vr": "OB", "BinaryLength": 108}, "211": {"vr": "OB", "BinaryLength": 108}, "212": {"vr": "OB", "BinaryLength": 108}, "213": {"vr": "OB", "BinaryLength": 108}, "214": {"vr": "OB", "BinaryLength": 108}, "215": {"vr": "OB", "BinaryLength": 108}, "216": {"vr": "OB", "BinaryLength": 108}, "217": {"vr": "OB", "BinaryLength": 108}, "218": {"vr": "OB", "BinaryLength": 108}, "219": {"vr": "OB", "BinaryLength": 108}, "220": {"vr": "OB", "BinaryLength": 108}, "221": {"vr": "OB", "BinaryLength": 108}, "222": {"vr": "OB", "BinaryLength": 108}, "223": {"vr": "OB", "BinaryLength": 108}, "224": {"vr": "OB", "BinaryLength": 108}, "225": {"vr": "OB", "BinaryLength": 108}, "226": {"vr": "OB", "BinaryLength": 108}, "227": {"vr": "OB", "BinaryLength": 108}, "228": {"vr": "OB", "BinaryLength": 108}, "229": {"vr": "OB", "BinaryLength": 108}, "230": {"vr": "OB", "BinaryLength": 108}, "231": {"vr": "OB", "BinaryLength": 108}, "232": {"vr": "OB", "BinaryLength": 108}, "233": {"vr": "OB", "BinaryLength": 108}, "234": {"vr": "OB", "BinaryLength": 108}, "235": {"vr": "OB", "BinaryLength": 108}, "236": {"vr": "OB", "BinaryLength": 108}, "237": {"vr": "OB", "BinaryLength": 108}, "238": {"vr": "OB", "BinaryLength": 108}, "239": {"vr": "OB", "BinaryLength": 108}}, "00431029": {"0": {"vr": "OB", "BinaryLength": 2760}, "1": {"vr": "OB", "BinaryLength": 2760}, "2": {"vr": "OB", "BinaryLength": 2760}, "3": {"vr": "OB", "BinaryLength": 2760}, "4": {"vr": "OB", "BinaryLength": 2760}, "5": {"vr": "OB", "BinaryLength": 2760}, "6": {"vr": "OB", "BinaryLength": 2760}, "7": {"vr": "OB", "BinaryLength": 2760}, "8": {"vr": "OB", "BinaryLength": 2760}, "9": {"vr": "OB", "BinaryLength": 2760}, "10": {"vr": "OB", "BinaryLength": 2760}, "11": {"vr": "OB", "BinaryLength": 2760}, "12": {"vr": "OB", "BinaryLength": 2760}, "13": {"vr": "OB", "BinaryLength": 2760}, "14": {"vr": "OB", "BinaryLength": 2760}, "15": {"vr": "OB", "BinaryLength": 2760}, "16": {"vr": "OB", "BinaryLength": 2760}, "17": {"vr": "OB", "BinaryLength": 2760}, "18": {"vr": "OB", "BinaryLength": 2760}, "19": {"vr": "OB", "BinaryLength": 2760}, "20": {"vr": "OB", "BinaryLength": 2760}, "21": {"vr": "OB", "BinaryLength": 2760}, "22": {"vr": "OB", "BinaryLength": 2760}, "23": {"vr": "OB", "BinaryLength": 2760}, "24": {"vr": "OB", "BinaryLength": 2760}, "25": {"vr": "OB", "BinaryLength": 2760}, "26": {"vr": "OB", "BinaryLength": 2760}, "27": {"vr": "OB", "BinaryLength": 2760}, "28": {"vr": "OB", "BinaryLength": 2760}, "29": {"vr": "OB", "BinaryLength": 2760}, "30": {"vr": "OB", "BinaryLength": 2760}, "31": {"vr": "OB", "BinaryLength": 2760}, "32": {"vr": "OB", "BinaryLength": 2760}, "33": {"vr": "OB", "BinaryLength": 2760}, "34": {"vr": "OB", "BinaryLength": 2760}, "35": {"vr": "OB", "BinaryLength": 2760}, "36": {"vr": "OB", "BinaryLength": 2760}, "37": {"vr": "OB", "BinaryLength": 2760}, "38": {"vr": "OB", "BinaryLength": 2760}, "39": {"vr": "OB", "BinaryLength": 2760}, "40": {"vr": "OB", "BinaryLength": 2760}, "41": {"vr": "OB", "BinaryLength": 2760}, "42": {"vr": "OB", "BinaryLength": 2760}, "43": {"vr": "OB", "BinaryLength": 2760}, "44": {"vr": "OB", "BinaryLength": 2760}, "45": {"vr": "OB", "BinaryLength": 2760}, "46": {"vr": "OB", "BinaryLength": 2760}, "47": {"vr": "OB", "BinaryLength": 2760}, "48": {"vr": "OB", "BinaryLength": 2760}, "49": {"vr": "OB", "BinaryLength": 2760}, "50": {"vr": "OB", "BinaryLength": 2760}, "51": {"vr": "OB", "BinaryLength": 2760}, "52": {"vr": "OB", "BinaryLength": 2760}, "53": {"vr": "OB", "BinaryLength": 2760}, "54": {"vr": "OB", "BinaryLength": 2760}, "55": {"vr": "OB", "BinaryLength": 2760}, "56": {"vr": "OB", "BinaryLength": 2760}, "57": {"vr": "OB", "BinaryLength": 2760}, "58": {"vr": "OB", "BinaryLength": 2760}, "59": {"vr": "OB", "BinaryLength": 2760}, "60": {"vr": "OB", "BinaryLength": 2760}, "61": {"vr": "OB", "BinaryLength": 2760}, "62": {"vr": "OB", "BinaryLength": 2760}, "63": {"vr": "OB", "BinaryLength": 2760}, "64": {"vr": "OB", "BinaryLength": 2760}, "65": {"vr": "OB", "BinaryLength": 2760}, "66": {"vr": "OB", "BinaryLength": 2760}, "67": {"vr": "OB", "BinaryLength": 2760}, "68": {"vr": "OB", "BinaryLength": 2760}, "69": {"vr": "OB", "BinaryLength": 2760}, "70": {"vr": "OB", "BinaryLength": 2760}, "71": {"vr": "OB", "BinaryLength": 2760}, "72": {"vr": "OB", "BinaryLength": 2760}, "73": {"vr": "OB", "BinaryLength": 2760}, "74": {"vr": "OB", "BinaryLength": 2760}, "75": {"vr": "OB", "BinaryLength": 2760}, "76": {"vr": "OB", "BinaryLength": 2760}, "77": {"vr": "OB", "BinaryLength": 2760}, "78": {"vr": "OB", "BinaryLength": 2760}, "79": {"vr": "OB", "BinaryLength": 2760}, "80": {"vr": "OB", "BinaryLength": 2760}, "81": {"vr": "OB", "BinaryLength": 2760}, "82": {"vr": "OB", "BinaryLength": 2760}, "83": {"vr": "OB", "BinaryLength": 2760}, "84": {"vr": "OB", "BinaryLength": 2760}, "85": {"vr": "OB", "BinaryLength": 2760}, "86": {"vr": "OB", "BinaryLength": 2760}, "87": {"vr": "OB", "BinaryLength": 2760}, "88": {"vr": "OB", "BinaryLength": 2760}, "89": {"vr": "OB", "BinaryLength": 2760}, "90": {"vr": "OB", "BinaryLength": 2760}, "91": {"vr": "OB", "BinaryLength": 2760}, "92": {"vr": "OB", "BinaryLength": 2760}, "93": {"vr": "OB", "BinaryLength": 2760}, "94": {"vr": "OB", "BinaryLength": 2760}, "95": {"vr": "OB", "BinaryLength": 2760}, "96": {"vr": "OB", "BinaryLength": 2760}, "97": {"vr": "OB", "BinaryLength": 2760}, "98": {"vr": "OB", "BinaryLength": 2760}, "99": {"vr": "OB", "BinaryLength": 2760}, "100": {"vr": "OB", "BinaryLength": 2760}, "101": {"vr": "OB", "BinaryLength": 2760}, "102": {"vr": "OB", "BinaryLength": 2760}, "103": {"vr": "OB", "BinaryLength": 2760}, "104": {"vr": "OB", "BinaryLength": 2760}, "105": {"vr": "OB", "BinaryLength": 2760}, "106": {"vr": "OB", "BinaryLength": 2760}, "107": {"vr": "OB", "BinaryLength": 2760}, "108": {"vr": "OB", "BinaryLength": 2760}, "109": {"vr": "OB", "BinaryLength": 2760}, "110": {"vr": "OB", "BinaryLength": 2760}, "111": {"vr": "OB", "BinaryLength": 2760}, "112": {"vr": "OB", "BinaryLength": 2760}, "113": {"vr": "OB", "BinaryLength": 2760}, "114": {"vr": "OB", "BinaryLength": 2760}, "115": {"vr": "OB", "BinaryLength": 2760}, "116": {"vr": "OB", "BinaryLength": 2760}, "117": {"vr": "OB", "BinaryLength": 2760}, "118": {"vr": "OB", "BinaryLength": 2760}, "119": {"vr": "OB", "BinaryLength": 2760}, "120": {"vr": "OB", "BinaryLength": 2760}, "121": {"vr": "OB", "BinaryLength": 2760}, "122": {"vr": "OB", "BinaryLength": 2760}, "123": {"vr": "OB", "BinaryLength": 2760}, "124": {"vr": "OB", "BinaryLength": 2760}, "125": {"vr": "OB", "BinaryLength": 2760}, "126": {"vr": "OB", "BinaryLength": 2760}, "127": {"vr": "OB", "BinaryLength": 2760}, "128": {"vr": "OB", "BinaryLength": 2760}, "129": {"vr": "OB", "BinaryLength": 2760}, "130": {"vr": "OB", "BinaryLength": 2760}, "131": {"vr": "OB", "BinaryLength": 2760}, "132": {"vr": "OB", "BinaryLength": 2760}, "133": {"vr": "OB", "BinaryLength": 2760}, "134": {"vr": "OB", "BinaryLength": 2760}, "135": {"vr": "OB", "BinaryLength": 2760}, "136": {"vr": "OB", "BinaryLength": 2760}, "137": {"vr": "OB", "BinaryLength": 2760}, "138": {"vr": "OB", "BinaryLength": 2760}, "139": {"vr": "OB", "BinaryLength": 2760}, "140": {"vr": "OB", "BinaryLength": 2760}, "141": {"vr": "OB", "BinaryLength": 2760}, "142": {"vr": "OB", "BinaryLength": 2760}, "143": {"vr": "OB", "BinaryLength": 2760}, "144": {"vr": "OB", "BinaryLength": 2760}, "145": {"vr": "OB", "BinaryLength": 2760}, "146": {"vr": "OB", "BinaryLength": 2760}, "147": {"vr": "OB", "BinaryLength": 2760}, "148": {"vr": "OB", "BinaryLength": 2760}, "149": {"vr": "OB", "BinaryLength": 2760}, "150": {"vr": "OB", "BinaryLength": 2760}, "151": {"vr": "OB", "BinaryLength": 2760}, "152": {"vr": "OB", "BinaryLength": 2760}, "153": {"vr": "OB", "BinaryLength": 2760}, "154": {"vr": "OB", "BinaryLength": 2760}, "155": {"vr": "OB", "BinaryLength": 2760}, "156": {"vr": "OB", "BinaryLength": 2760}, "157": {"vr": "OB", "BinaryLength": 2760}, "158": {"vr": "OB", "BinaryLength": 2760}, "159": {"vr": "OB", "BinaryLength": 2760}, "160": {"vr": "OB", "BinaryLength": 2760}, "161": {"vr": "OB", "BinaryLength": 2760}, "162": {"vr": "OB", "BinaryLength": 2760}, "163": {"vr": "OB", "BinaryLength": 2760}, "164": {"vr": "OB", "BinaryLength": 2760}, "165": {"vr": "OB", "BinaryLength": 2760}, "166": {"vr": "OB", "BinaryLength": 2760}, "167": {"vr": "OB", "BinaryLength": 2760}, "168": {"vr": "OB", "BinaryLength": 2760}, "169": {"vr": "OB", "BinaryLength": 2760}, "170": {"vr": "OB", "BinaryLength": 2760}, "171": {"vr": "OB", "BinaryLength": 2760}, "172": {"vr": "OB", "BinaryLength": 2760}, "173": {"vr": "OB", "BinaryLength": 2760}, "174": {"vr": "OB", "BinaryLength": 2760}, "175": {"vr": "OB", "BinaryLength": 2760}, "176": {"vr": "OB", "BinaryLength": 2760}, "177": {"vr": "OB", "BinaryLength": 2760}, "178": {"vr": "OB", "BinaryLength": 2760}, "179": {"vr": "OB", "BinaryLength": 2760}, "180": {"vr": "OB", "BinaryLength": 2760}, "181": {"vr": "OB", "BinaryLength": 2760}, "182": {"vr": "OB", "BinaryLength": 2760}, "183": {"vr": "OB", "BinaryLength": 2760}, "184": {"vr": "OB", "BinaryLength": 2760}, "185": {"vr": "OB", "BinaryLength": 2760}, "186": {"vr": "OB", "BinaryLength": 2760}, "187": {"vr": "OB", "BinaryLength": 2760}, "188": {"vr": "OB", "BinaryLength": 2760}, "189": {"vr": "OB", "BinaryLength": 2760}, "190": {"vr": "OB", "BinaryLength": 2760}, "191": {"vr": "OB", "BinaryLength": 2760}, "192": {"vr": "OB", "BinaryLength": 2760}, "193": {"vr": "OB", "BinaryLength": 2760}, "194": {"vr": "OB", "BinaryLength": 2760}, "195": {"vr": "OB", "BinaryLength": 2760}, "196": {"vr": "OB", "BinaryLength": 2760}, "197": {"vr": "OB", "BinaryLength": 2760}, "198": {"vr": "OB", "BinaryLength": 2760}, "199": {"vr": "OB", "BinaryLength": 2760}, "200": {"vr": "OB", "BinaryLength": 2760}, "201": {"vr": "OB", "BinaryLength": 2760}, "202": {"vr": "OB", "BinaryLength": 2760}, "203": {"vr": "OB", "BinaryLength": 2760}, "204": {"vr": "OB", "BinaryLength": 2760}, "205": {"vr": "OB", "BinaryLength": 2760}, "206": {"vr": "OB", "BinaryLength": 2760}, "207": {"vr": "OB", "BinaryLength": 2760}, "208": {"vr": "OB", "BinaryLength": 2760}, "209": {"vr": "OB", "BinaryLength": 2760}, "210": {"vr": "OB", "BinaryLength": 2760}, "211": {"vr": "OB", "BinaryLength": 2760}, "212": {"vr": "OB", "BinaryLength": 2760}, "213": {"vr": "OB", "BinaryLength": 2760}, "214": {"vr": "OB", "BinaryLength": 2760}, "215": {"vr": "OB", "BinaryLength": 2760}, "216": {"vr": "OB", "BinaryLength": 2760}, "217": {"vr": "OB", "BinaryLength": 2760}, "218": {"vr": "OB", "BinaryLength": 2760}, "219": {"vr": "OB", "BinaryLength": 2760}, "220": {"vr": "OB", "BinaryLength": 2760}, "221": {"vr": "OB", "BinaryLength": 2760}, "222": {"vr": "OB", "BinaryLength": 2760}, "223": {"vr": "OB", "BinaryLength": 2760}, "224": {"vr": "OB", "BinaryLength": 2760}, "225": {"vr": "OB", "BinaryLength": 2760}, "226": {"vr": "OB", "BinaryLength": 2760}, "227": {"vr": "OB", "BinaryLength": 2760}, "228": {"vr": "OB", "BinaryLength": 2760}, "229": {"vr": "OB", "BinaryLength": 2760}, "230": {"vr": "OB", "BinaryLength": 2760}, "231": {"vr": "OB", "BinaryLength": 2760}, "232": {"vr": "OB", "BinaryLength": 2760}, "233": {"vr": "OB", "BinaryLength": 2760}, "234": {"vr": "OB", "BinaryLength": 2760}, "235": {"vr": "OB", "BinaryLength": 2760}, "236": {"vr": "OB", "BinaryLength": 2760}, "237": {"vr": "OB", "BinaryLength": 2760}, "238": {"vr": "OB", "BinaryLength": 2760}, "239": {"vr": "OB", "BinaryLength": 2760}}, "0043102A": {"0": {"vr": "OB", "BinaryLength": 9784}, "1": {"vr": "OB", "BinaryLength": 9784}, "2": {"vr": "OB", "BinaryLength": 9784}, "3": {"vr": "OB", "BinaryLength": 9784}, "4": {"vr": "OB", "BinaryLength": 9784}, "5": {"vr": "OB", "BinaryLength": 9784}, "6": {"vr": "OB", "BinaryLength": 9784}, "7": {"vr": "OB", "BinaryLength": 9784}, "8": {"vr": "OB", "BinaryLength": 9784}, "9": {"vr": "OB", "BinaryLength": 9784}, "10": {"vr": "OB", "BinaryLength": 9784}, "11": {"vr": "OB", "BinaryLength": 9784}, "12": {"vr": "OB", "BinaryLength": 9784}, "13": {"vr": "OB", "BinaryLength": 9784}, "14": {"vr": "OB", "BinaryLength": 9784}, "15": {"vr": "OB", "BinaryLength": 9784}, "16": {"vr": "OB", "BinaryLength": 9784}, "17": {"vr": "OB", "BinaryLength": 9784}, "18": {"vr": "OB", "BinaryLength": 9784}, "19": {"vr": "OB", "BinaryLength": 9784}, "20": {"vr": "OB", "BinaryLength": 9784}, "21": {"vr": "OB", "BinaryLength": 9784}, "22": {"vr": "OB", "BinaryLength": 9784}, "23": {"vr": "OB", "BinaryLength": 9784}, "24": {"vr": "OB", "BinaryLength": 9784}, "25": {"vr": "OB", "BinaryLength": 9784}, "26": {"vr": "OB", "BinaryLength": 9784}, "27": {"vr": "OB", "BinaryLength": 9784}, "28": {"vr": "OB", "BinaryLength": 9784}, "29": {"vr": "OB", "BinaryLength": 9784}, "30": {"vr": "OB", "BinaryLength": 9784}, "31": {"vr": "OB", "BinaryLength": 9784}, "32": {"vr": "OB", "BinaryLength": 9784}, "33": {"vr": "OB", "BinaryLength": 9784}, "34": {"vr": "OB", "BinaryLength": 9784}, "35": {"vr": "OB", "BinaryLength": 9784}, "36": {"vr": "OB", "BinaryLength": 9784}, "37": {"vr": "OB", "BinaryLength": 9784}, "38": {"vr": "OB", "BinaryLength": 9784}, "39": {"vr": "OB", "BinaryLength": 9784}, "40": {"vr": "OB", "BinaryLength": 9784}, "41": {"vr": "OB", "BinaryLength": 9784}, "42": {"vr": "OB", "BinaryLength": 9784}, "43": {"vr": "OB", "BinaryLength": 9784}, "44": {"vr": "OB", "BinaryLength": 9784}, "45": {"vr": "OB", "BinaryLength": 9784}, "46": {"vr": "OB", "BinaryLength": 9784}, "47": {"vr": "OB", "BinaryLength": 9784}, "48": {"vr": "OB", "BinaryLength": 9784}, "49": {"vr": "OB", "BinaryLength": 9784}, "50": {"vr": "OB", "BinaryLength": 9784}, "51": {"vr": "OB", "BinaryLength": 9784}, "52": {"vr": "OB", "BinaryLength": 9784}, "53": {"vr": "OB", "BinaryLength": 9784}, "54": {"vr": "OB", "BinaryLength": 9784}, "55": {"vr": "OB", "BinaryLength": 9784}, "56": {"vr": "OB", "BinaryLength": 9784}, "57": {"vr": "OB", "BinaryLength": 9784}, "58": {"vr": "OB", "BinaryLength": 9784}, "59": {"vr": "OB", "BinaryLength": 9784}, "60": {"vr": "OB", "BinaryLength": 9784}, "61": {"vr": "OB", "BinaryLength": 9784}, "62": {"vr": "OB", "BinaryLength": 9784}, "63": {"vr": "OB", "BinaryLength": 9784}, "64": {"vr": "OB", "BinaryLength": 9784}, "65": {"vr": "OB", "BinaryLength": 9784}, "66": {"vr": "OB", "BinaryLength": 9784}, "67": {"vr": "OB", "BinaryLength": 9784}, "68": {"vr": "OB", "BinaryLength": 9784}, "69": {"vr": "OB", "BinaryLength": 9784}, "70": {"vr": "OB", "BinaryLength": 9784}, "71": {"vr": "OB", "BinaryLength": 9784}, "72": {"vr": "OB", "BinaryLength": 9784}, "73": {"vr": "OB", "BinaryLength": 9784}, "74": {"vr": "OB", "BinaryLength": 9784}, "75": {"vr": "OB", "BinaryLength": 9784}, "76": {"vr": "OB", "BinaryLength": 9784}, "77": {"vr": "OB", "BinaryLength": 9784}, "78": {"vr": "OB", "BinaryLength": 9784}, "79": {"vr": "OB", "BinaryLength": 9784}, "80": {"vr": "OB", "BinaryLength": 9784}, "81": {"vr": "OB", "BinaryLength": 9784}, "82": {"vr": "OB", "BinaryLength": 9784}, "83": {"vr": "OB", "BinaryLength": 9784}, "84": {"vr": "OB", "BinaryLength": 9784}, "85": {"vr": "OB", "BinaryLength": 9784}, "86": {"vr": "OB", "BinaryLength": 9784}, "87": {"vr": "OB", "BinaryLength": 9784}, "88": {"vr": "OB", "BinaryLength": 9784}, "89": {"vr": "OB", "BinaryLength": 9784}, "90": {"vr": "OB", "BinaryLength": 9784}, "91": {"vr": "OB", "BinaryLength": 9784}, "92": {"vr": "OB", "BinaryLength": 9784}, "93": {"vr": "OB", "BinaryLength": 9784}, "94": {"vr": "OB", "BinaryLength": 9784}, "95": {"vr": "OB", "BinaryLength": 9784}, "96": {"vr": "OB", "BinaryLength": 9784}, "97": {"vr": "OB", "BinaryLength": 9784}, "98": {"vr": "OB", "BinaryLength": 9784}, "99": {"vr": "OB", "BinaryLength": 9784}, "100": {"vr": "OB", "BinaryLength": 9784}, "101": {"vr": "OB", "BinaryLength": 9784}, "102": {"vr": "OB", "BinaryLength": 9784}, "103": {"vr": "OB", "BinaryLength": 9784}, "104": {"vr": "OB", "BinaryLength": 9784}, "105": {"vr": "OB", "BinaryLength": 9784}, "106": {"vr": "OB", "BinaryLength": 9784}, "107": {"vr": "OB", "BinaryLength": 9784}, "108": {"vr": "OB", "BinaryLength": 9784}, "109": {"vr": "OB", "BinaryLength": 9784}, "110": {"vr": "OB", "BinaryLength": 9784}, "111": {"vr": "OB", "BinaryLength": 9784}, "112": {"vr": "OB", "BinaryLength": 9784}, "113": {"vr": "OB", "BinaryLength": 9784}, "114": {"vr": "OB", "BinaryLength": 9784}, "115": {"vr": "OB", "BinaryLength": 9784}, "116": {"vr": "OB", "BinaryLength": 9784}, "117": {"vr": "OB", "BinaryLength": 9784}, "118": {"vr": "OB", "BinaryLength": 9784}, "119": {"vr": "OB", "BinaryLength": 9784}, "120": {"vr": "OB", "BinaryLength": 9784}, "121": {"vr": "OB", "BinaryLength": 9784}, "122": {"vr": "OB", "BinaryLength": 9784}, "123": {"vr": "OB", "BinaryLength": 9784}, "124": {"vr": "OB", "BinaryLength": 9784}, "125": {"vr": "OB", "BinaryLength": 9784}, "126": {"vr": "OB", "BinaryLength": 9784}, "127": {"vr": "OB", "BinaryLength": 9784}, "128": {"vr": "OB", "BinaryLength": 9784}, "129": {"vr": "OB", "BinaryLength": 9784}, "130": {"vr": "OB", "BinaryLength": 9784}, "131": {"vr": "OB", "BinaryLength": 9784}, "132": {"vr": "OB", "BinaryLength": 9784}, "133": {"vr": "OB", "BinaryLength": 9784}, "134": {"vr": "OB", "BinaryLength": 9784}, "135": {"vr": "OB", "BinaryLength": 9784}, "136": {"vr": "OB", "BinaryLength": 9784}, "137": {"vr": "OB", "BinaryLength": 9784}, "138": {"vr": "OB", "BinaryLength": 9784}, "139": {"vr": "OB", "BinaryLength": 9784}, "140": {"vr": "OB", "BinaryLength": 9784}, "141": {"vr": "OB", "BinaryLength": 9784}, "142": {"vr": "OB", "BinaryLength": 9784}, "143": {"vr": "OB", "BinaryLength": 9784}, "144": {"vr": "OB", "BinaryLength": 9784}, "145": {"vr": "OB", "BinaryLength": 9784}, "146": {"vr": "OB", "BinaryLength": 9784}, "147": {"vr": "OB", "BinaryLength": 9784}, "148": {"vr": "OB", "BinaryLength": 9784}, "149": {"vr": "OB", "BinaryLength": 9784}, "150": {"vr": "OB", "BinaryLength": 9784}, "151": {"vr": "OB", "BinaryLength": 9784}, "152": {"vr": "OB", "BinaryLength": 9784}, "153": {"vr": "OB", "BinaryLength": 9784}, "154": {"vr": "OB", "BinaryLength": 9784}, "155": {"vr": "OB", "BinaryLength": 9784}, "156": {"vr": "OB", "BinaryLength": 9784}, "157": {"vr": "OB", "BinaryLength": 9784}, "158": {"vr": "OB", "BinaryLength": 9784}, "159": {"vr": "OB", "BinaryLength": 9784}, "160": {"vr": "OB", "BinaryLength": 9784}, "161": {"vr": "OB", "BinaryLength": 9784}, "162": {"vr": "OB", "BinaryLength": 9784}, "163": {"vr": "OB", "BinaryLength": 9784}, "164": {"vr": "OB", "BinaryLength": 9784}, "165": {"vr": "OB", "BinaryLength": 9784}, "166": {"vr": "OB", "BinaryLength": 9784}, "167": {"vr": "OB", "BinaryLength": 9784}, "168": {"vr": "OB", "BinaryLength": 9784}, "169": {"vr": "OB", "BinaryLength": 9784}, "170": {"vr": "OB", "BinaryLength": 9784}, "171": {"vr": "OB", "BinaryLength": 9784}, "172": {"vr": "OB", "BinaryLength": 9784}, "173": {"vr": "OB", "BinaryLength": 9784}, "174": {"vr": "OB", "BinaryLength": 9784}, "175": {"vr": "OB", "BinaryLength": 9784}, "176": {"vr": "OB", "BinaryLength": 9784}, "177": {"vr": "OB", "BinaryLength": 9784}, "178": {"vr": "OB", "BinaryLength": 9784}, "179": {"vr": "OB", "BinaryLength": 9784}, "180": {"vr": "OB", "BinaryLength": 9784}, "181": {"vr": "OB", "BinaryLength": 9784}, "182": {"vr": "OB", "BinaryLength": 9784}, "183": {"vr": "OB", "BinaryLength": 9784}, "184": {"vr": "OB", "BinaryLength": 9784}, "185": {"vr": "OB", "BinaryLength": 9784}, "186": {"vr": "OB", "BinaryLength": 9784}, "187": {"vr": "OB", "BinaryLength": 9784}, "188": {"vr": "OB", "BinaryLength": 9784}, "189": {"vr": "OB", "BinaryLength": 9784}, "190": {"vr": "OB", "BinaryLength": 9784}, "191": {"vr": "OB", "BinaryLength": 9784}, "192": {"vr": "OB", "BinaryLength": 9784}, "193": {"vr": "OB", "BinaryLength": 9784}, "194": {"vr": "OB", "BinaryLength": 9784}, "195": {"vr": "OB", "BinaryLength": 9784}, "196": {"vr": "OB", "BinaryLength": 9784}, "197": {"vr": "OB", "BinaryLength": 9784}, "198": {"vr": "OB", "BinaryLength": 9784}, "199": {"vr": "OB", "BinaryLength": 9784}, "200": {"vr": "OB", "BinaryLength": 9784}, "201": {"vr": "OB", "BinaryLength": 9784}, "202": {"vr": "OB", "BinaryLength": 9784}, "203": {"vr": "OB", "BinaryLength": 9784}, "204": {"vr": "OB", "BinaryLength": 9784}, "205": {"vr": "OB", "BinaryLength": 9784}, "206": {"vr": "OB", "BinaryLength": 9784}, "207": {"vr": "OB", "BinaryLength": 9784}, "208": {"vr": "OB", "BinaryLength": 9784}, "209": {"vr": "OB", "BinaryLength": 9784}, "210": {"vr": "OB", "BinaryLength": 9784}, "211": {"vr": "OB", "BinaryLength": 9784}, "212": {"vr": "OB", "BinaryLength": 9784}, "213": {"vr": "OB", "BinaryLength": 9784}, "214": {"vr": "OB", "BinaryLength": 9784}, "215": {"vr": "OB", "BinaryLength": 9784}, "216": {"vr": "OB", "BinaryLength": 9784}, "217": {"vr": "OB", "BinaryLength": 9784}, "218": {"vr": "OB", "BinaryLength": 9784}, "219": {"vr": "OB", "BinaryLength": 9784}, "220": {"vr": "OB", "BinaryLength": 9784}, "221": {"vr": "OB", "BinaryLength": 9784}, "222": {"vr": "OB", "BinaryLength": 9784}, "223": {"vr": "OB", "BinaryLength": 9784}, "224": {"vr": "OB", "BinaryLength": 9784}, "225": {"vr": "OB", "BinaryLength": 9784}, "226": {"vr": "OB", "BinaryLength": 9784}, "227": {"vr": "OB", "BinaryLength": 9784}, "228": {"vr": "OB", "BinaryLength": 9784}, "229": {"vr": "OB", "BinaryLength": 9784}, "230": {"vr": "OB", "BinaryLength": 9784}, "231": {"vr": "OB", "BinaryLength": 9784}, "232": {"vr": "OB", "BinaryLength": 9784}, "233": {"vr": "OB", "BinaryLength": 9784}, "234": {"vr": "OB", "BinaryLength": 9784}, "235": {"vr": "OB", "BinaryLength": 9784}, "236": {"vr": "OB", "BinaryLength": 9784}, "237": {"vr": "OB", "BinaryLength": 9784}, "238": {"vr": "OB", "BinaryLength": 9784}, "239": {"vr": "OB", "BinaryLength": 9784}}, "7FE00010": {"0": {"vr": "OW", "BinaryLength": 174764}, "1": {"vr": "OW", "BinaryLength": 174764}, "2": {"vr": "OW", "BinaryLength": 174764}, "3": {"vr": "OW", "BinaryLength": 174764}, "4": {"vr": "OW", "BinaryLength": 174764}, "5": {"vr": "OW", "BinaryLength": 174764}, "6": {"vr": "OW", "BinaryLength": 174764}, "7": {"vr": "OW", "BinaryLength": 174764}, "8": {"vr": "OW", "BinaryLength": 174764}, "9": {"vr": "OW", "BinaryLength": 174764}, "10": {"vr": "OW", "BinaryLength": 174764}, "11": {"vr": "OW", "BinaryLength": 174764}, "12": {"vr": "OW", "BinaryLength": 174764}, "13": {"vr": "OW", "BinaryLength": 174764}, "14": {"vr": "OW", "BinaryLength": 174764}, "15": {"vr": "OW", "BinaryLength": 174764}, "16": {"vr": "OW", "BinaryLength": 174764}, "17": {"vr": "OW", "BinaryLength": 174764}, "18": {"vr": "OW", "BinaryLength": 174764}, "19": {"vr": "OW", "BinaryLength": 174764}, "20": {"vr": "OW", "BinaryLength": 174764}, "21": {"vr": "OW", "BinaryLength": 174764}, "22": {"vr": "OW", "BinaryLength": 174764}, "23": {"vr": "OW", "BinaryLength": 174764}, "24": {"vr": "OW", "BinaryLength": 174764}, "25": {"vr": "OW", "BinaryLength": 174764}, "26": {"vr": "OW", "BinaryLength": 174764}, "27": {"vr": "OW", "BinaryLength": 174764}, "28": {"vr": "OW", "BinaryLength": 174764}, "29": {"vr": "OW", "BinaryLength": 174764}, "30": {"vr": "OW", "BinaryLength": 174764}, "31": {"vr": "OW", "BinaryLength": 174764}, "32": {"vr": "OW", "BinaryLength": 174764}, "33": {"vr": "OW", "BinaryLength": 174764}, "34": {"vr": "OW", "BinaryLength": 174764}, "35": {"vr": "OW", "BinaryLength": 174764}, "36": {"vr": "OW", "BinaryLength": 174764}, "37": {"vr": "OW", "BinaryLength": 174764}, "38": {"vr": "OW", "BinaryLength": 174764}, "39": {"vr": "OW", "BinaryLength": 174764}, "40": {"vr": "OW", "BinaryLength": 174764}, "41": {"vr": "OW", "BinaryLength": 174764}, "42": {"vr": "OW", "BinaryLength": 174764}, "43": {"vr": "OW", "BinaryLength": 174764}, "44": {"vr": "OW", "BinaryLength": 174764}, "45": {"vr": "OW", "BinaryLength": 174764}, "46": {"vr": "OW", "BinaryLength": 174764}, "47": {"vr": "OW", "BinaryLength": 174764}, "48": {"vr": "OW", "BinaryLength": 174764}, "49": {"vr": "OW", "BinaryLength": 174764}, "50": {"vr": "OW", "BinaryLength": 174764}, "51": {"vr": "OW", "BinaryLength": 174764}, "52": {"vr": "OW", "BinaryLength": 174764}, "53": {"vr": "OW", "BinaryLength": 174764}, "54": {"vr": "OW", "BinaryLength": 174764}, "55": {"vr": "OW", "BinaryLength": 174764}, "56": {"vr": "OW", "BinaryLength": 174764}, "57": {"vr": "OW", "BinaryLength": 174764}, "58": {"vr": "OW", "BinaryLength": 174764}, "59": {"vr": "OW", "BinaryLength": 174764}, "60": {"vr": "OW", "BinaryLength": 174764}, "61": {"vr": "OW", "BinaryLength": 174764}, "62": {"vr": "OW", "BinaryLength": 174764}, "63": {"vr": "OW", "BinaryLength": 174764}, "64": {"vr": "OW", "BinaryLength": 174764}, "65": {"vr": "OW", "BinaryLength": 174764}, "66": {"vr": "OW", "BinaryLength": 174764}, "67": {"vr": "OW", "BinaryLength": 174764}, "68": {"vr": "OW", "BinaryLength": 174764}, "69": {"vr": "OW", "BinaryLength": 174764}, "70": {"vr": "OW", "BinaryLength": 174764}, "71": {"vr": "OW", "BinaryLength": 174764}, "72": {"vr": "OW", "BinaryLength": 174764}, "73": {"vr": "OW", "BinaryLength": 174764}, "74": {"vr": "OW", "BinaryLength": 174764}, "75": {"vr": "OW", "BinaryLength": 174764}, "76": {"vr": "OW", "BinaryLength": 174764}, "77": {"vr": "OW", "BinaryLength": 174764}, "78": {"vr": "OW", "BinaryLength": 174764}, "79": {"vr": "OW", "BinaryLength": 174764}, "80": {"vr": "OW", "BinaryLength": 174764}, "81": {"vr": "OW", "BinaryLength": 174764}, "82": {"vr": "OW", "BinaryLength": 174764}, "83": {"vr": "OW", "BinaryLength": 174764}, "84": {"vr": "OW", "BinaryLength": 174764}, "85": {"vr": "OW", "BinaryLength": 174764}, "86": {"vr": "OW", "BinaryLength": 174764}, "87": {"vr": "OW", "BinaryLength": 174764}, "88": {"vr": "OW", "BinaryLength": 174764}, "89": {"vr": "OW", "BinaryLength": 174764}, "90": {"vr": "OW", "BinaryLength": 174764}, "91": {"vr": "OW", "BinaryLength": 174764}, "92": {"vr": "OW", "BinaryLength": 174764}, "93": {"vr": "OW", "BinaryLength": 174764}, "94": {"vr": "OW", "BinaryLength": 174764}, "95": {"vr": "OW", "BinaryLength": 174764}, "96": {"vr": "OW", "BinaryLength": 174764}, "97": {"vr": "OW", "BinaryLength": 174764}, "98": {"vr": "OW", "BinaryLength": 174764}, "99": {"vr": "OW", "BinaryLength": 174764}, "100": {"vr": "OW", "BinaryLength": 174764}, "101": {"vr": "OW", "BinaryLength": 174764}, "102": {"vr": "OW", "BinaryLength": 174764}, "103": {"vr": "OW", "BinaryLength": 174764}, "104": {"vr": "OW", "BinaryLength": 174764}, "105": {"vr": "OW", "BinaryLength": 174764}, "106": {"vr": "OW", "BinaryLength": 174764}, "107": {"vr": "OW", "BinaryLength": 174764}, "108": {"vr": "OW", "BinaryLength": 174764}, "109": {"vr": "OW", "BinaryLength": 174764}, "110": {"vr": "OW", "BinaryLength": 174764}, "111": {"vr": "OW", "BinaryLength": 174764}, "112": {"vr": "OW", "BinaryLength": 174764}, "113": {"vr": "OW", "BinaryLength": 174764}, "114": {"vr": "OW", "BinaryLength": 174764}, "115": {"vr": "OW", "BinaryLength": 174764}, "116": {"vr": "OW", "BinaryLength": 174764}, "117": {"vr": "OW", "BinaryLength": 174764}, "118": {"vr": "OW", "BinaryLength": 174764}, "119": {"vr": "OW", "BinaryLength": 174764}, "120": {"vr": "OW", "BinaryLength": 174764}, "121": {"vr": "OW", "BinaryLength": 174764}, "122": {"vr": "OW", "BinaryLength": 174764}, "123": {"vr": "OW", "BinaryLength": 174764}, "124": {"vr": "OW", "BinaryLength": 174764}, "125": {"vr": "OW", "BinaryLength": 174764}, "126": {"vr": "OW", "BinaryLength": 174764}, "127": {"vr": "OW", "BinaryLength": 174764}, "128": {"vr": "OW", "BinaryLength": 174764}, "129": {"vr": "OW", "BinaryLength": 174764}, "130": {"vr": "OW", "BinaryLength": 174764}, "131": {"vr": "OW", "BinaryLength": 174764}, "132": {"vr": "OW", "BinaryLength": 174764}, "133": {"vr": "OW", "BinaryLength": 174764}, "134": {"vr": "OW", "BinaryLength": 174764}, "135": {"vr": "OW", "BinaryLength": 174764}, "136": {"vr": "OW", "BinaryLength": 174764}, "137": {"vr": "OW", "BinaryLength": 174764}, "138": {"vr": "OW", "BinaryLength": 174764}, "139": {"vr": "OW", "BinaryLength": 174764}, "140": {"vr": "OW", "BinaryLength": 174764}, "141": {"vr": "OW", "BinaryLength": 174764}, "142": {"vr": "OW", "BinaryLength": 174764}, "143": {"vr": "OW", "BinaryLength": 174764}, "144": {"vr": "OW", "BinaryLength": 174764}, "145": {"vr": "OW", "BinaryLength": 174764}, "146": {"vr": "OW", "BinaryLength": 174764}, "147": {"vr": "OW", "BinaryLength": 174764}, "148": {"vr": "OW", "BinaryLength": 174764}, "149": {"vr": "OW", "BinaryLength": 174764}, "150": {"vr": "OW", "BinaryLength": 174764}, "151": {"vr": "OW", "BinaryLength": 174764}, "152": {"vr": "OW", "BinaryLength": 174764}, "153": {"vr": "OW", "BinaryLength": 174764}, "154": {"vr": "OW", "BinaryLength": 174764}, "155": {"vr": "OW", "BinaryLength": 174764}, "156": {"vr": "OW", "BinaryLength": 174764}, "157": {"vr": "OW", "BinaryLength": 174764}, "158": {"vr": "OW", "BinaryLength": 174764}, "159": {"vr": "OW", "BinaryLength": 174764}, "160": {"vr": "OW", "BinaryLength": 174764}, "161": {"vr": "OW", "BinaryLength": 174764}, "162": {"vr": "OW", "BinaryLength": 174764}, "163": {"vr": "OW", "BinaryLength": 174764}, "164": {"vr": "OW", "BinaryLength": 174764}, "165": {"vr": "OW", "BinaryLength": 174764}, "166": {"vr": "OW", "BinaryLength": 174764}, "167": {"vr": "OW", "BinaryLength": 174764}, "168": {"vr": "OW", "BinaryLength": 174764}, "169": {"vr": "OW", "BinaryLength": 174764}, "170": {"vr": "OW", "BinaryLength": 174764}, "171": {"vr": "OW", "BinaryLength": 174764}, "172": {"vr": "OW", "BinaryLength": 174764}, "173": {"vr": "OW", "BinaryLength": 174764}, "174": {"vr": "OW", "BinaryLength": 174764}, "175": {"vr": "OW", "BinaryLength": 174764}, "176": {"vr": "OW", "BinaryLength": 174764}, "177": {"vr": "OW", "BinaryLength": 174764}, "178": {"vr": "OW", "BinaryLength": 174764}, "179": {"vr": "OW", "BinaryLength": 174764}, "180": {"vr": "OW", "BinaryLength": 174764}, "181": {"vr": "OW", "BinaryLength": 174764}, "182": {"vr": "OW", "BinaryLength": 174764}, "183": {"vr": "OW", "BinaryLength": 174764}, "184": {"vr": "OW", "BinaryLength": 174764}, "185": {"vr": "OW", "BinaryLength": 174764}, "186": {"vr": "OW", "BinaryLength": 174764}, "187": {"vr": "OW", "BinaryLength": 174764}, "188": {"vr": "OW", "BinaryLength": 174764}, "189": {"vr": "OW", "BinaryLength": 174764}, "190": {"vr": "OW", "BinaryLength": 174764}, "191": {"vr": "OW", "BinaryLength": 174764}, "192": {"vr": "OW", "BinaryLength": 174764}, "193": {"vr": "OW", "BinaryLength": 174764}, "194": {"vr": "OW", "BinaryLength": 174764}, "195": {"vr": "OW", "BinaryLength": 174764}, "196": {"vr": "OW", "BinaryLength": 174764}, "197": {"vr": "OW", "BinaryLength": 174764}, "198": {"vr": "OW", "BinaryLength": 174764}, "199": {"vr": "OW", "BinaryLength": 174764}, "200": {"vr": "OW", "BinaryLength": 174764}, "201": {"vr": "OW", "BinaryLength": 174764}, "202": {"vr": "OW", "BinaryLength": 174764}, "203": {"vr": "OW", "BinaryLength": 174764}, "204": {"vr": "OW", "BinaryLength": 174764}, "205": {"vr": "OW", "BinaryLength": 174764}, "206": {"vr": "OW", "BinaryLength": 174764}, "207": {"vr": "OW", "BinaryLength": 174764}, "208": {"vr": "OW", "BinaryLength": 174764}, "209": {"vr": "OW", "BinaryLength": 174764}, "210": {"vr": "OW", "BinaryLength": 174764}, "211": {"vr": "OW", "BinaryLength": 174764}, "212": {"vr": "OW", "BinaryLength": 174764}, "213": {"vr": "OW", "BinaryLength": 174764}, "214": {"vr": "OW", "BinaryLength": 174764}, "215": {"vr": "OW", "BinaryLength": 174764}, "216": {"vr": "OW", "BinaryLength": 174764}, "217": {"vr": "OW", "BinaryLength": 174764}, "218": {"vr": "OW", "BinaryLength": 174764}, "219": {"vr": "OW", "BinaryLength": 174764}, "220": {"vr": "OW", "BinaryLength": 174764}, "221": {"vr": "OW", "BinaryLength": 174764}, "222": {"vr": "OW", "BinaryLength": 174764}, "223": {"vr": "OW", "BinaryLength": 174764}, "224": {"vr": "OW", "BinaryLength": 174764}, "225": {"vr": "OW", "BinaryLength": 174764}, "226": {"vr": "OW", "BinaryLength": 174764}, "227": {"vr": "OW", "BinaryLength": 174764}, "228": {"vr": "OW", "BinaryLength": 174764}, "229": {"vr": "OW", "BinaryLength": 174764}, "230": {"vr": "OW", "BinaryLength": 174764}, "231": {"vr": "OW", "BinaryLength": 174764}, "232": {"vr": "OW", "BinaryLength": 174764}, "233": {"vr": "OW", "BinaryLength": 174764}, "234": {"vr": "OW", "BinaryLength": 174764}, "235": {"vr": "OW", "BinaryLength": 174764}, "236": {"vr": "OW", "BinaryLength": 174764}, "237": {"vr": "OW", "BinaryLength": 174764}, "238": {"vr": "OW", "BinaryLength": 174764}, "239": {"vr": "OW", "BinaryLength": 174764}}}
