
from medimages4tests.dummy.dicom.base import (
   generate_dicom, default_dicom_dir, evolve_header
)


def get_image(out_dir=default_dicom_dir(__file__)):
    return generate_dicom(out_dir, num_vols, constant_hdr,
                          collated_data, varying_hdr)


num_vols = 120


constant_hdr = {
    "00080005": {
        "vr": "CS",
        "Value": [
            "ISO_IR 100"
        ]
    },
    "00080008": {
        "vr": "CS",
        "Value": [
            "ORIGINAL",
            "PRIMARY",
            "M",
            "ND",
            "NORM"
        ]
    },
    "00080012": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080016": {
        "vr": "UI",
        "Value": [
            "1.2.840.10008.5.1.4.1.1.4"
        ]
    },
    "00080020": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080021": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080022": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080023": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00080030": {
        "vr": "TM",
        "Value": [
            "091331.137000"
        ]
    },
    "00080031": {
        "vr": "TM",
        "Value": [
            "093825.060000"
        ]
    },
    "00080050": {
        "vr": "SH"
    },
    "00080060": {
        "vr": "CS",
        "Value": [
            "MR"
        ]
    },
    "00080070": {
        "vr": "LO",
        "Value": [
            "SIEMENS"
        ]
    },
    "00080080": {
        "vr": "LO",
        "Value": [
            "An institute"
        ]
    },
    "00080081": {
        "vr": "ST",
        "Value": [
            "Address of institute"
        ]
    },
    "00080090": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "XNAT"
            }
        ]
    },
    "00081010": {
        "vr": "SH",
        "Value": [
            "AWP45193"
        ]
    },
    "00081030": {
        "vr": "LO",
        "Value": [
            "Researcher^Project"
        ]
    },
    "0008103E": {
        "vr": "LO",
        "Value": [
            "gre_field_mapping 3mm"
        ]
    },
    "00081040": {
        "vr": "LO",
        "Value": [
            "Department"
        ]
    },
    "00081048": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "Some Phenotypes"
            }
        ]
    },
    "00081050": {
        "vr": "PN"
    },
    "00081090": {
        "vr": "LO",
        "Value": [
            "Skyra"
        ]
    },
    "00081140": {
        "vr": "SQ",
        "Value": [
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509141726605700537"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509142519936700545"
                    ]
                }
            },
            {
                "00081150": {
                    "vr": "UI",
                    "Value": [
                        "1.2.840.10008.5.1.4.1.1.4"
                    ]
                },
                "00081155": {
                    "vr": "UI",
                    "Value": [
                        "1.3.12.2.1107.5.2.19.45193.2018052509142122884100541"
                    ]
                }
            }
        ]
    },
    "00100010": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "SUBJECTID^SESSIONID"
            }
        ]
    },
    "00100020": {
        "vr": "LO",
        "Value": [
            "SESSIONLABEL"
        ]
    },
    "00100021": {
        "vr": "LO",
        "Value": [
            "2"
        ]
    },
    "00100030": {
        "vr": "DA",
        "Value": [
            "19800824"
        ]
    },
    "00100040": {
        "vr": "CS",
        "Value": [
            "M"
        ]
    },
    "00101010": {
        "vr": "AS",
        "Value": [
            "037Y"
        ]
    },
    "00101020": {
        "vr": "DS",
        "Value": [
            1.82
        ]
    },
    "00101030": {
        "vr": "DS",
        "Value": [
            90.0
        ]
    },
    "00102000": {
        "vr": "LO",
        "Value": [
            "None"
        ]
    },
    "00102110": {
        "vr": "LO",
        "Value": [
            "None"
        ]
    },
    "001021C0": {
        "vr": "US",
        "Value": [
            4
        ]
    },
    "00104000": {
        "vr": "LT",
        "Value": [
            ""
        ]
    },
    "00180015": {
        "vr": "CS",
        "Value": [
            "BRAIN"
        ]
    },
    "00180020": {
        "vr": "CS",
        "Value": [
            "GR"
        ]
    },
    "00180021": {
        "vr": "CS",
        "Value": [
            "SP"
        ]
    },
    "00180022": {
        "vr": "CS"
    },
    "00180023": {
        "vr": "CS",
        "Value": [
            "2D"
        ]
    },
    "00180024": {
        "vr": "SH",
        "Value": [
            "*fm2d2r"
        ]
    },
    "00180025": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00180050": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00180080": {
        "vr": "DS",
        "Value": [
            638.0
        ]
    },
    "00180083": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00180084": {
        "vr": "DS",
        "Value": [
            123.251958
        ]
    },
    "00180085": {
        "vr": "SH",
        "Value": [
            "1H"
        ]
    },
    "00180087": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00180088": {
        "vr": "DS",
        "Value": [
            3.0
        ]
    },
    "00180089": {
        "vr": "IS",
        "Value": [
            64
        ]
    },
    "00180091": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00180093": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "00180094": {
        "vr": "DS",
        "Value": [
            100.0
        ]
    },
    "00180095": {
        "vr": "DS",
        "Value": [
            280.0
        ]
    },
    "00181000": {
        "vr": "LO",
        "Value": [
            "45193"
        ]
    },
    "00181020": {
        "vr": "LO",
        "Value": [
            "syngo MR D13C"
        ]
    },
    "00181030": {
        "vr": "LO",
        "Value": [
            "gre_field_mapping 3mm"
        ]
    },
    "00181200": {
        "vr": "DA",
        "Value": [
            "20090304",
            "20090304"
        ]
    },
    "00181201": {
        "vr": "TM",
        "Value": [
            "123723.000000",
            "123723.000000"
        ]
    },
    "00181251": {
        "vr": "SH",
        "Value": [
            "Body"
        ]
    },
    "00181310": {
        "vr": "US",
        "Value": [
            0,
            64,
            64,
            0
        ]
    },
    "00181312": {
        "vr": "CS",
        "Value": [
            "ROW"
        ]
    },
    "00181314": {
        "vr": "DS",
        "Value": [
            60.0
        ]
    },
    "00181315": {
        "vr": "CS",
        "Value": [
            "N"
        ]
    },
    "00181316": {
        "vr": "DS",
        "Value": [
            0.18091299460891
        ]
    },
    "00181318": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00185100": {
        "vr": "CS",
        "Value": [
            "HFS"
        ]
    },
    "00190010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR HEADER"
        ]
    },
    "00191008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00191009": {
        "vr": "LO",
        "Value": [
            "1.0"
        ]
    },
    "0019100F": {
        "vr": "SH",
        "Value": [
            "Fast"
        ]
    },
    "00191011": {
        "vr": "SH",
        "Value": [
            "Yes"
        ]
    },
    "00191012": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00191013": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00191014": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00191017": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00191018": {
        "vr": "IS",
        "Value": [
            27800
        ]
    },
    "0020000D": {
        "vr": "UI",
        "Value": [
            "1.2.826.0.1.3680043.8.498.35939304416003656006618747446767853539"
        ]
    },
    "0020000E": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.2.19.45193.2018052509365798558557522.0.0.0"
        ]
    },
    "00200010": {
        "vr": "SH",
        "Value": [
            "MRH060"
        ]
    },
    "00200011": {
        "vr": "IS",
        "Value": [
            6
        ]
    },
    "00200012": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00200037": {
        "vr": "DS",
        "Value": [
            1.0,
            -2.05103e-10,
            0.0,
            2.05103e-10,
            1.0,
            0.0
        ]
    },
    "00200052": {
        "vr": "UI",
        "Value": [
            "1.3.12.2.1107.5.2.19.45193.1.20180525091331822.0.0.0"
        ]
    },
    "00201040": {
        "vr": "LO"
    },
    "00210010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR SDS 01"
        ]
    },
    "00210011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR SDI 02"
        ]
    },
    "00211001": {
        "vr": "IS",
        "Value": [
            90
        ]
    },
    "00211004": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00211005": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00211006": {
        "vr": "LO",
        "Value": [
            "void"
        ]
    },
    "00211007": {
        "vr": "LO",
        "Value": [
            "NUMARIS/4"
        ]
    },
    "00211008": {
        "vr": "SH",
        "Value": [
            "Fast"
        ]
    },
    "0021100A": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "0021100C": {
        "vr": "SH",
        "Value": [
            "+LPH"
        ]
    },
    "0021100D": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "0021100F": {
        "vr": "DS",
        "Value": [
            27.8939991,
            23.26799965,
            38.05500031
        ]
    },
    "00211010": {
        "vr": "IS",
        "Value": [
            41330004
        ]
    },
    "00211011": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211012": {
        "vr": "FD",
        "Value": [
            2.0
        ]
    },
    "00211013": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211014": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211016": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211017": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211018": {
        "vr": "SH",
        "Value": [
            "Head"
        ]
    },
    "0021101A": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "0021101B": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "0021101C": {
        "vr": "DS",
        "Value": [
            0.3235679,
            16.20863914,
            15.27873421
        ]
    },
    "0021101D": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "00211022": {
        "vr": "SH",
        "Value": [
            "SIEMENS"
        ]
    },
    "00211023": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211025": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00211026": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
        ]
    },
    "00211027": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "0021102A": {
        "vr": "IS",
        "Value": [
            255,
            0,
            0,
            0,
            0,
            0,
            0,
            4865,
            4866,
            0,
            0
        ]
    },
    "0021102B": {
        "vr": "ST",
        "Value": [
            "1;HFS;90.00;37.75;2;0;2;-2057087971"
        ]
    },
    "0021102C": {
        "vr": "DS",
        "Value": [
            1000000.0,
            140.7642634,
            140.7642634
        ]
    },
    "0021102D": {
        "vr": "DS",
        "Value": [
            3.2,
            0.82066113,
            0.0
        ]
    },
    "0021102E": {
        "vr": "IS",
        "Value": [
            2
        ]
    },
    "0021102F": {
        "vr": "DS",
        "Value": [
            37.0,
            37.0,
            38.0
        ]
    },
    "00211030": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211031": {
        "vr": "IS",
        "Value": [
            -1098
        ]
    },
    "00211032": {
        "vr": "SS",
        "Value": [
            0
        ]
    },
    "00211033": {
        "vr": "SH",
        "Value": [
            "GC99"
        ]
    },
    "00211034": {
        "vr": "DS",
        "Value": [
            1.0
        ]
    },
    "00211035": {
        "vr": "DS",
        "Value": [
            0.8041082
        ]
    },
    "00211036": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "00211038": {
        "vr": "DS",
        "Value": [
            365.746003
        ]
    },
    "0021103B": {
        "vr": "DS",
        "Value": [
            0.0
        ]
    },
    "0021103D": {
        "vr": "CS",
        "Value": [
            "NONE"
        ]
    },
    "00211044": {
        "vr": "DS",
        "Value": [
            7.07106781,
            1.2197182
        ]
    },
    "00211045": {
        "vr": "CS",
        "Value": [
            "NO"
        ]
    },
    "00211046": {
        "vr": "DS",
        "Value": [
            2275.846875
        ]
    },
    "00211047": {
        "vr": "CS",
        "Value": [
            "IEC"
        ]
    },
    "00211048": {
        "vr": "CS"
    },
    "00211049": {
        "vr": "CS"
    },
    "00211050": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00211051": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00211053": {
        "vr": "CS",
        "Value": [
            "U"
        ]
    },
    "0021111A": {
        "vr": "SH",
        "Value": [
            "predicted"
        ]
    },
    "0021111C": {
        "vr": "IS",
        "Value": [
            1
        ]
    },
    "00211124": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211133": {
        "vr": "IS",
        "Value": [
            32
        ]
    },
    "00211135": {
        "vr": "IS",
        "Value": [
            0
        ]
    },
    "00211141": {
        "vr": "SH",
        "Value": [
            "predicted"
        ]
    },
    "00211142": {
        "vr": "IS",
        "Value": [
            27800
        ]
    },
    "00211145": {
        "vr": "SL",
        "Value": [
            0,
            0,
            -1098
        ]
    },
    "00211148": {
        "vr": "IS",
        "Value": [
            16
        ]
    },
    "00211149": {
        "vr": "IS",
        "Value": [
            32
        ]
    },
    "0021114F": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "00211151": {
        "vr": "UL",
        "Value": [
            134217728
        ]
    },
    "00211154": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00211158": {
        "vr": "SH",
        "Value": [
            "64*64s"
        ]
    },
    "00211159": {
        "vr": "IS",
        "Value": [
            0,
            0,
            0
        ]
    },
    "00211171": {
        "vr": "UT",
        "Value": [
            "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
        ]
    },
    "00211176": {
        "vr": "LO",
        "Value": [
            "ChannelMixing:ND=true_CMM=1_CDM=1",
            "CC:SoS",
            "NormalizeAlgo:PreScan"
        ]
    },
    "00250010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR EXTRACTED CSA HEADER"
        ]
    },
    "00251001": {
        "vr": "SQ",
        "Value": [
            {
                "00250010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MR EXTRACTED CSA HEADER"
                    ]
                },
                "00251002": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS CSA HEADER"
                    ]
                },
                "00251003": {
                    "vr": "AT",
                    "Value": [
                        "00290010"
                    ]
                }
            },
            {
                "00250010": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS MR EXTRACTED CSA HEADER"
                    ]
                },
                "00251002": {
                    "vr": "LO",
                    "Value": [
                        "SIEMENS CSA HEADER"
                    ]
                },
                "00251003": {
                    "vr": "AT",
                    "Value": [
                        "00290020"
                    ]
                }
            }
        ]
    },
    "00280002": {
        "vr": "US",
        "Value": [
            1
        ]
    },
    "00280004": {
        "vr": "CS",
        "Value": [
            "MONOCHROME2"
        ]
    },
    "00280010": {
        "vr": "US",
        "Value": [
            64
        ]
    },
    "00280011": {
        "vr": "US",
        "Value": [
            64
        ]
    },
    "00280030": {
        "vr": "DS",
        "Value": [
            3.0,
            3.0
        ]
    },
    "00280100": {
        "vr": "US",
        "Value": [
            16
        ]
    },
    "00280101": {
        "vr": "US",
        "Value": [
            12
        ]
    },
    "00280102": {
        "vr": "US",
        "Value": [
            11
        ]
    },
    "00280103": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00280106": {
        "vr": "US",
        "Value": [
            0
        ]
    },
    "00281055": {
        "vr": "LO",
        "Value": [
            "Algo1"
        ]
    },
    "00290010": {
        "vr": "LO",
        "Value": [
            "SIEMENS CSA HEADER"
        ]
    },
    "00290011": {
        "vr": "LO",
        "Value": [
            "SIEMENS MEDCOM HEADER2"
        ]
    },
    "00291008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00291009": {
        "vr": "LO",
        "Value": [
            "20180525"
        ]
    },
    "00291018": {
        "vr": "CS",
        "Value": [
            "MR"
        ]
    },
    "00291019": {
        "vr": "LO",
        "Value": [
            "20180525"
        ]
    },
    "00291160": {
        "vr": "LO",
        "Value": [
            "com"
        ]
    },
    "00321032": {
        "vr": "PN",
        "Value": [
            {
                "Alphabetic": "MND Phenotypes"
            }
        ]
    },
    "00321060": {
        "vr": "LO",
        "Value": [
            "MR_EXAM"
        ]
    },
    "00400244": {
        "vr": "DA",
        "Value": [
            "20180525"
        ]
    },
    "00400245": {
        "vr": "TM",
        "Value": [
            "091331.375000"
        ]
    },
    "00400253": {
        "vr": "SH",
        "Value": [
            "001"
        ]
    },
    "00400254": {
        "vr": "LO",
        "Value": [
            "MR Scan"
        ]
    },
    "00400275": {
        "vr": "SQ",
        "Value": [
            {
                "00400007": {
                    "vr": "LO",
                    "Value": [
                        "MR Scan"
                    ]
                },
                "00400009": {
                    "vr": "SH",
                    "Value": [
                        "001"
                    ]
                },
                "00401001": {
                    "vr": "SH",
                    "Value": [
                        "MRH060"
                    ]
                }
            }
        ]
    },
    "00400280": {
        "vr": "ST"
    },
    "00510010": {
        "vr": "LO",
        "Value": [
            "SIEMENS MR HEADER"
        ]
    },
    "00511008": {
        "vr": "CS",
        "Value": [
            "IMAGE NUM 4"
        ]
    },
    "00511009": {
        "vr": "LO",
        "Value": [
            "1.0"
        ]
    },
    "0051100A": {
        "vr": "LO",
        "Value": [
            "TA 01:20"
        ]
    },
    "0051100B": {
        "vr": "LO",
        "Value": [
            "64*64s"
        ]
    },
    "0051100C": {
        "vr": "LO",
        "Value": [
            "FoV 192*192"
        ]
    },
    "0051100E": {
        "vr": "LO",
        "Value": [
            "Tra"
        ]
    },
    "0051100F": {
        "vr": "LO",
        "Value": [
            "HEA;HEP"
        ]
    },
    "00511012": {
        "vr": "SH",
        "Value": [
            "TP 0"
        ]
    },
    "00511013": {
        "vr": "SH",
        "Value": [
            "+LPH"
        ]
    },
    "00511016": {
        "vr": "LO",
        "Value": [
            "M/ND/NORM"
        ]
    },
    "00511017": {
        "vr": "SH",
        "Value": [
            "SL 3.0"
        ]
    },
    "00511019": {
        "vr": "LO",
        "Value": [
            "A1"
        ]
    }
}


varying_hdr = {"00080013": {"0": {"vr": "TM", "Value": ["093825.350000"]}, "1": {"vr": "TM", "Value": ["093825.238000"]}, "2": {"vr": "TM", "Value": ["093825.292000"]}, "3": {"vr": "TM", "Value": ["093825.287000"]}, "4": {"vr": "TM", "Value": ["093825.265000"]}, "5": {"vr": "TM", "Value": ["093825.144000"]}, "6": {"vr": "TM", "Value": ["093825.121000"]}, "7": {"vr": "TM", "Value": ["093825.301000"]}, "8": {"vr": "TM", "Value": ["093825.208000"]}, "9": {"vr": "TM", "Value": ["093825.356000"]}, "10": {"vr": "TM", "Value": ["093825.429000"]}, "11": {"vr": "TM", "Value": ["093825.319000"]}, "12": {"vr": "TM", "Value": ["093825.229000"]}, "13": {"vr": "TM", "Value": ["093825.417000"]}, "14": {"vr": "TM", "Value": ["093825.233000"]}, "15": {"vr": "TM", "Value": ["093825.090000"]}, "16": {"vr": "TM", "Value": ["093825.227000"]}, "17": {"vr": "TM", "Value": ["093825.083000"]}, "18": {"vr": "TM", "Value": ["093825.078000"]}, "19": {"vr": "TM", "Value": ["093825.274000"]}, "20": {"vr": "TM", "Value": ["093825.393000"]}, "21": {"vr": "TM", "Value": ["093825.215000"]}, "22": {"vr": "TM", "Value": ["093825.283000"]}, "23": {"vr": "TM", "Value": ["093825.081000"]}, "24": {"vr": "TM", "Value": ["093825.236000"]}, "25": {"vr": "TM", "Value": ["093825.397000"]}, "26": {"vr": "TM", "Value": ["093825.415000"]}, "27": {"vr": "TM", "Value": ["093825.354000"]}, "28": {"vr": "TM", "Value": ["093825.422000"]}, "29": {"vr": "TM", "Value": ["093825.096000"]}, "30": {"vr": "TM", "Value": ["093825.362000"]}, "31": {"vr": "TM", "Value": ["093825.140000"]}, "32": {"vr": "TM", "Value": ["093825.219000"]}, "33": {"vr": "TM", "Value": ["093825.105000"]}, "34": {"vr": "TM", "Value": ["093825.263000"]}, "35": {"vr": "TM", "Value": ["093825.303000"]}, "36": {"vr": "TM", "Value": ["093825.384000"]}, "37": {"vr": "TM", "Value": ["093825.085000"]}, "38": {"vr": "TM", "Value": ["093825.210000"]}, "39": {"vr": "TM", "Value": ["093825.372000"]}, "40": {"vr": "TM", "Value": ["093825.313000"]}, "41": {"vr": "TM", "Value": ["093825.348000"]}, "42": {"vr": "TM", "Value": ["093825.114000"]}, "43": {"vr": "TM", "Value": ["093825.094000"]}, "44": {"vr": "TM", "Value": ["093825.102000"]}, "45": {"vr": "TM", "Value": ["093825.331000"]}, "46": {"vr": "TM", "Value": ["093825.333000"]}, "47": {"vr": "TM", "Value": ["093825.147000"]}, "48": {"vr": "TM", "Value": ["093825.400000"]}, "49": {"vr": "TM", "Value": ["093825.359000"]}, "50": {"vr": "TM", "Value": ["093825.073000"]}, "51": {"vr": "TM", "Value": ["093825.321000"]}, "52": {"vr": "TM", "Value": ["093825.307000"]}, "53": {"vr": "TM", "Value": ["093825.345000"]}, "54": {"vr": "TM", "Value": ["093825.352000"]}, "55": {"vr": "TM", "Value": ["093825.420000"]}, "56": {"vr": "TM", "Value": ["093825.326000"]}, "57": {"vr": "TM", "Value": ["093825.152000"]}, "58": {"vr": "TM", "Value": ["093825.116000"]}, "59": {"vr": "TM", "Value": ["093825.107000"]}, "60": {"vr": "TM", "Value": ["093825.389000"]}, "61": {"vr": "TM", "Value": ["093825.252000"]}, "62": {"vr": "TM", "Value": ["093825.135000"]}, "63": {"vr": "TM", "Value": ["093825.068000"]}, "64": {"vr": "TM", "Value": ["093825.294000"]}, "65": {"vr": "TM", "Value": ["093825.340000"]}, "66": {"vr": "TM", "Value": ["093825.087000"]}, "67": {"vr": "TM", "Value": ["093825.119000"]}, "68": {"vr": "TM", "Value": ["093825.224000"]}, "69": {"vr": "TM", "Value": ["093825.132000"]}, "70": {"vr": "TM", "Value": ["093825.109000"]}, "71": {"vr": "TM", "Value": ["093825.099000"]}, "72": {"vr": "TM", "Value": ["093825.427000"]}, "73": {"vr": "TM", "Value": ["093825.247000"]}, "74": {"vr": "TM", "Value": ["093825.128000"]}, "75": {"vr": "TM", "Value": ["093825.391000"]}, "76": {"vr": "TM", "Value": ["093825.092000"]}, "77": {"vr": "TM", "Value": ["093825.242000"]}, "78": {"vr": "TM", "Value": ["093825.125000"]}, "79": {"vr": "TM", "Value": ["093825.285000"]}, "80": {"vr": "TM", "Value": ["093825.309000"]}, "81": {"vr": "TM", "Value": ["093825.137000"]}, "82": {"vr": "TM", "Value": ["093825.130000"]}, "83": {"vr": "TM", "Value": ["093825.123000"]}, "84": {"vr": "TM", "Value": ["093825.240000"]}, "85": {"vr": "TM", "Value": ["093825.369000"]}, "86": {"vr": "TM", "Value": ["093825.297000"]}, "87": {"vr": "TM", "Value": ["093825.258000"]}, "88": {"vr": "TM", "Value": ["093825.425000"]}, "89": {"vr": "TM", "Value": ["093825.335000"]}, "90": {"vr": "TM", "Value": ["093825.245000"]}, "91": {"vr": "TM", "Value": ["093825.280000"]}, "92": {"vr": "TM", "Value": ["093825.112000"]}, "93": {"vr": "TM", "Value": ["093825.142000"]}, "94": {"vr": "TM", "Value": ["093825.249000"]}, "95": {"vr": "TM", "Value": ["093825.260000"]}, "96": {"vr": "TM", "Value": ["093825.367000"]}, "97": {"vr": "TM", "Value": ["093825.212000"]}, "98": {"vr": "TM", "Value": ["093825.064000"]}, "99": {"vr": "TM", "Value": ["093825.157000"]}, "100": {"vr": "TM", "Value": ["093825.290000"]}, "101": {"vr": "TM", "Value": ["093825.323000"]}, "102": {"vr": "TM", "Value": ["093825.338000"]}, "103": {"vr": "TM", "Value": ["093825.278000"]}, "104": {"vr": "TM", "Value": ["093825.256000"]}, "105": {"vr": "TM", "Value": ["093825.386000"]}, "106": {"vr": "TM", "Value": ["093825.267000"]}, "107": {"vr": "TM", "Value": ["093825.381000"]}, "108": {"vr": "TM", "Value": ["093825.071000"]}, "109": {"vr": "TM", "Value": ["093825.231000"]}, "110": {"vr": "TM", "Value": ["093825.329000"]}, "111": {"vr": "TM", "Value": ["093825.149000"]}, "112": {"vr": "TM", "Value": ["093825.154000"]}, "113": {"vr": "TM", "Value": ["093825.254000"]}, "114": {"vr": "TM", "Value": ["093825.299000"]}, "115": {"vr": "TM", "Value": ["093825.311000"]}, "116": {"vr": "TM", "Value": ["093825.317000"]}, "117": {"vr": "TM", "Value": ["093825.342000"]}, "118": {"vr": "TM", "Value": ["093825.365000"]}, "119": {"vr": "TM", "Value": ["093825.221000"]}}, "00080018": {"0": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382362883257910"]}, "1": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382314781357730"]}, "2": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382337381557814"]}, "3": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382335245957806"]}, "4": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382327803057778"]}, "5": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382295657157658"]}, "6": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382285030957618"]}, "7": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382341631557830"]}, "8": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938232030057682"]}, "9": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382366073257922"]}, "10": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382388403058006"]}, "11": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382349064257858"]}, "12": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382310538257714"]}, "13": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382383079457986"]}, "14": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382312663757722"]}, "15": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382271200957566"]}, "16": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938239471057710"]}, "17": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382268037057554"]}, "18": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382265911057546"]}, "19": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382329949757786"]}, "20": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382378829457970"]}, "21": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938235222357694"]}, "22": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382333132957798"]}, "23": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382266974357550"]}, "24": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382313723957726"]}, "25": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382379890857974"]}, "26": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382382016957982"]}, "27": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382365011157918"]}, "28": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382385208257994"]}, "29": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382274391057578"]}, "30": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382368196757930"]}, "31": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382293532457650"]}, "32": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938236282457698"]}, "33": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382277583157590"]}, "34": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382326743557774"]}, "35": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382342687657834"]}, "36": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382374577757954"]}, "37": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382269085957558"]}, "38": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938233092557686"]}, "39": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382372452557946"]}, "40": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382346940057850"]}, "41": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382361821257906"]}, "42": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382281836157606"]}, "43": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382273330257574"]}, "44": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382276528057586"]}, "45": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382354379757878"]}, "46": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382355443457882"]}, "47": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382296714657662"]}, "48": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382380959157978"]}, "49": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382367136157926"]}, "50": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382264852857542"]}, "51": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382350126557862"]}, "52": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382343753557838"]}, "53": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382360758257902"]}, "54": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382363943757914"]}, "55": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382384143357990"]}, "56": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382352253657870"]}, "57": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382298844757670"]}, "58": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382282897457610"]}, "59": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382278646057594"]}, "60": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382376704457962"]}, "61": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382321164257754"]}, "62": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382291401357642"]}, "63": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382262725457534"]}, "64": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382338433357818"]}, "65": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382358636257894"]}, "66": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382270146457562"]}, "67": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382283960257614"]}, "68": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938238412757706"]}, "69": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382290338357638"]}, "70": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382279708257598"]}, "71": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382275453157582"]}, "72": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382387334158002"]}, "73": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382319039857746"]}, "74": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382288211957630"]}, "75": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382377764657966"]}, "76": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382272274557570"]}, "77": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382316912057738"]}, "78": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382287158857626"]}, "79": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382334184257802"]}, "80": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382344811157842"]}, "81": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382292461157646"]}, "82": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382289284557634"]}, "83": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382286086457622"]}, "84": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382315854657734"]}, "85": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382371388157942"]}, "86": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382339497657822"]}, "87": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382324358657766"]}, "88": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382386272257998"]}, "89": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382356509757886"]}, "90": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382317978257742"]}, "91": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382332077857794"]}, "92": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382280777157602"]}, "93": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382294592157654"]}, "94": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382320104357750"]}, "95": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382325681557770"]}, "96": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382370323157938"]}, "97": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938234155957690"]}, "98": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382261679157530"]}, "99": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.20180525093823968657678"]}, "100": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382336311657810"]}, "101": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382351191357866"]}, "102": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382357569257890"]}, "103": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382331015257790"]}, "104": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382323286157762"]}, "105": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382375640457958"]}, "106": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382328892457782"]}, "107": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382373519257950"]}, "108": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382263770257538"]}, "109": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382311600157718"]}, "110": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382353314457874"]}, "111": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382297784957666"]}, "112": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382299900057674"]}, "113": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382322222457758"]}, "114": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382340561157826"]}, "115": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382345878357846"]}, "116": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382347999957854"]}, "117": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382359694557898"]}, "118": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.2018052509382369261657934"]}, "119": {"vr": "UI", "Value": ["1.3.12.2.1107.5.2.19.45193.201805250938237343657702"]}}, "00080032": {"0": {"vr": "TM", "Value": ["093702.540000"]}, "1": {"vr": "TM", "Value": ["093702.060000"]}, "2": {"vr": "TM", "Value": ["093702.285000"]}, "3": {"vr": "TM", "Value": ["093702.265000"]}, "4": {"vr": "TM", "Value": ["093702.190000"]}, "5": {"vr": "TM", "Value": ["093701.867500"]}, "6": {"vr": "TM", "Value": ["093701.762500"]}, "7": {"vr": "TM", "Value": ["093702.327500"]}, "8": {"vr": "TM", "Value": ["093701.932500"]}, "9": {"vr": "TM", "Value": ["093702.572500"]}, "10": {"vr": "TM", "Value": ["093702.795000"]}, "11": {"vr": "TM", "Value": ["093702.402500"]}, "12": {"vr": "TM", "Value": ["093702.017500"]}, "13": {"vr": "TM", "Value": ["093702.742500"]}, "14": {"vr": "TM", "Value": ["093702.037500"]}, "15": {"vr": "TM", "Value": ["093701.625000"]}, "16": {"vr": "TM", "Value": ["093702.007500"]}, "17": {"vr": "TM", "Value": ["093701.592500"]}, "18": {"vr": "TM", "Value": ["093701.570000"]}, "19": {"vr": "TM", "Value": ["093702.210000"]}, "20": {"vr": "TM", "Value": ["093702.700000"]}, "21": {"vr": "TM", "Value": ["093701.965000"]}, "22": {"vr": "TM", "Value": ["093702.242500"]}, "23": {"vr": "TM", "Value": ["093701.582500"]}, "24": {"vr": "TM", "Value": ["093702.050000"]}, "25": {"vr": "TM", "Value": ["093702.710000"]}, "26": {"vr": "TM", "Value": ["093702.732500"]}, "27": {"vr": "TM", "Value": ["093702.562500"]}, "28": {"vr": "TM", "Value": ["093702.765000"]}, "29": {"vr": "TM", "Value": ["093701.655000"]}, "30": {"vr": "TM", "Value": ["093702.595000"]}, "31": {"vr": "TM", "Value": ["093701.847500"]}, "32": {"vr": "TM", "Value": ["093701.975000"]}, "33": {"vr": "TM", "Value": ["093701.687500"]}, "34": {"vr": "TM", "Value": ["093702.180000"]}, "35": {"vr": "TM", "Value": ["093702.337500"]}, "36": {"vr": "TM", "Value": ["093702.657500"]}, "37": {"vr": "TM", "Value": ["093701.602500"]}, "38": {"vr": "TM", "Value": ["093701.942500"]}, "39": {"vr": "TM", "Value": ["093702.637500"]}, "40": {"vr": "TM", "Value": ["093702.380000"]}, "41": {"vr": "TM", "Value": ["093702.530000"]}, "42": {"vr": "TM", "Value": ["093701.730000"]}, "43": {"vr": "TM", "Value": ["093701.645000"]}, "44": {"vr": "TM", "Value": ["093701.677500"]}, "45": {"vr": "TM", "Value": ["093702.455000"]}, "46": {"vr": "TM", "Value": ["093702.467500"]}, "47": {"vr": "TM", "Value": ["093701.880000"]}, "48": {"vr": "TM", "Value": ["093702.722500"]}, "49": {"vr": "TM", "Value": ["093702.582500"]}, "50": {"vr": "TM", "Value": ["093701.560000"]}, "51": {"vr": "TM", "Value": ["093702.412500"]}, "52": {"vr": "TM", "Value": ["093702.350000"]}, "53": {"vr": "TM", "Value": ["093702.520000"]}, "54": {"vr": "TM", "Value": ["093702.552500"]}, "55": {"vr": "TM", "Value": ["093702.752500"]}, "56": {"vr": "TM", "Value": ["093702.435000"]}, "57": {"vr": "TM", "Value": ["093701.900000"]}, "58": {"vr": "TM", "Value": ["093701.740000"]}, "59": {"vr": "TM", "Value": ["093701.697500"]}, "60": {"vr": "TM", "Value": ["093702.680000"]}, "61": {"vr": "TM", "Value": ["093702.122500"]}, "62": {"vr": "TM", "Value": ["093701.825000"]}, "63": {"vr": "TM", "Value": ["093701.540000"]}, "64": {"vr": "TM", "Value": ["093702.295000"]}, "65": {"vr": "TM", "Value": ["093702.497500"]}, "66": {"vr": "TM", "Value": ["093701.612500"]}, "67": {"vr": "TM", "Value": ["093701.752500"]}, "68": {"vr": "TM", "Value": ["093701.995000"]}, "69": {"vr": "TM", "Value": ["093701.815000"]}, "70": {"vr": "TM", "Value": ["093701.710000"]}, "71": {"vr": "TM", "Value": ["093701.667500"]}, "72": {"vr": "TM", "Value": ["093702.785000"]}, "73": {"vr": "TM", "Value": ["093702.102500"]}, "74": {"vr": "TM", "Value": ["093701.795000"]}, "75": {"vr": "TM", "Value": ["093702.690000"]}, "76": {"vr": "TM", "Value": ["093701.635000"]}, "77": {"vr": "TM", "Value": ["093702.080000"]}, "78": {"vr": "TM", "Value": ["093701.782500"]}, "79": {"vr": "TM", "Value": ["093702.252500"]}, "80": {"vr": "TM", "Value": ["093702.360000"]}, "81": {"vr": "TM", "Value": ["093701.837500"]}, "82": {"vr": "TM", "Value": ["093701.805000"]}, "83": {"vr": "TM", "Value": ["093701.772500"]}, "84": {"vr": "TM", "Value": ["093702.070000"]}, "85": {"vr": "TM", "Value": ["093702.625000"]}, "86": {"vr": "TM", "Value": ["093702.307500"]}, "87": {"vr": "TM", "Value": ["093702.155000"]}, "88": {"vr": "TM", "Value": ["093702.775000"]}, "89": {"vr": "TM", "Value": ["093702.477500"]}, "90": {"vr": "TM", "Value": ["093702.092500"]}, "91": {"vr": "TM", "Value": ["093702.232500"]}, "92": {"vr": "TM", "Value": ["093701.720000"]}, "93": {"vr": "TM", "Value": ["093701.857500"]}, "94": {"vr": "TM", "Value": ["093702.112500"]}, "95": {"vr": "TM", "Value": ["093702.167500"]}, "96": {"vr": "TM", "Value": ["093702.615000"]}, "97": {"vr": "TM", "Value": ["093701.952500"]}, "98": {"vr": "TM", "Value": ["093701.527500"]}, "99": {"vr": "TM", "Value": ["093701.922500"]}, "100": {"vr": "TM", "Value": ["093702.275000"]}, "101": {"vr": "TM", "Value": ["093702.422500"]}, "102": {"vr": "TM", "Value": ["093702.487500"]}, "103": {"vr": "TM", "Value": ["093702.222500"]}, "104": {"vr": "TM", "Value": ["093702.145000"]}, "105": {"vr": "TM", "Value": ["093702.667500"]}, "106": {"vr": "TM", "Value": ["093702.200000"]}, "107": {"vr": "TM", "Value": ["093702.647500"]}, "108": {"vr": "TM", "Value": ["093701.550000"]}, "109": {"vr": "TM", "Value": ["093702.027500"]}, "110": {"vr": "TM", "Value": ["093702.445000"]}, "111": {"vr": "TM", "Value": ["093701.890000"]}, "112": {"vr": "TM", "Value": ["093701.910000"]}, "113": {"vr": "TM", "Value": ["093702.135000"]}, "114": {"vr": "TM", "Value": ["093702.317500"]}, "115": {"vr": "TM", "Value": ["093702.370000"]}, "116": {"vr": "TM", "Value": ["093702.392500"]}, "117": {"vr": "TM", "Value": ["093702.510000"]}, "118": {"vr": "TM", "Value": ["093702.605000"]}, "119": {"vr": "TM", "Value": ["093701.985000"]}}, "00080033": {"0": {"vr": "TM", "Value": ["093825.350000"]}, "1": {"vr": "TM", "Value": ["093825.238000"]}, "2": {"vr": "TM", "Value": ["093825.292000"]}, "3": {"vr": "TM", "Value": ["093825.287000"]}, "4": {"vr": "TM", "Value": ["093825.265000"]}, "5": {"vr": "TM", "Value": ["093825.144000"]}, "6": {"vr": "TM", "Value": ["093825.121000"]}, "7": {"vr": "TM", "Value": ["093825.301000"]}, "8": {"vr": "TM", "Value": ["093825.208000"]}, "9": {"vr": "TM", "Value": ["093825.356000"]}, "10": {"vr": "TM", "Value": ["093825.429000"]}, "11": {"vr": "TM", "Value": ["093825.319000"]}, "12": {"vr": "TM", "Value": ["093825.229000"]}, "13": {"vr": "TM", "Value": ["093825.417000"]}, "14": {"vr": "TM", "Value": ["093825.233000"]}, "15": {"vr": "TM", "Value": ["093825.090000"]}, "16": {"vr": "TM", "Value": ["093825.227000"]}, "17": {"vr": "TM", "Value": ["093825.083000"]}, "18": {"vr": "TM", "Value": ["093825.078000"]}, "19": {"vr": "TM", "Value": ["093825.274000"]}, "20": {"vr": "TM", "Value": ["093825.393000"]}, "21": {"vr": "TM", "Value": ["093825.215000"]}, "22": {"vr": "TM", "Value": ["093825.283000"]}, "23": {"vr": "TM", "Value": ["093825.081000"]}, "24": {"vr": "TM", "Value": ["093825.236000"]}, "25": {"vr": "TM", "Value": ["093825.397000"]}, "26": {"vr": "TM", "Value": ["093825.415000"]}, "27": {"vr": "TM", "Value": ["093825.354000"]}, "28": {"vr": "TM", "Value": ["093825.422000"]}, "29": {"vr": "TM", "Value": ["093825.096000"]}, "30": {"vr": "TM", "Value": ["093825.362000"]}, "31": {"vr": "TM", "Value": ["093825.140000"]}, "32": {"vr": "TM", "Value": ["093825.219000"]}, "33": {"vr": "TM", "Value": ["093825.105000"]}, "34": {"vr": "TM", "Value": ["093825.263000"]}, "35": {"vr": "TM", "Value": ["093825.303000"]}, "36": {"vr": "TM", "Value": ["093825.384000"]}, "37": {"vr": "TM", "Value": ["093825.085000"]}, "38": {"vr": "TM", "Value": ["093825.210000"]}, "39": {"vr": "TM", "Value": ["093825.372000"]}, "40": {"vr": "TM", "Value": ["093825.313000"]}, "41": {"vr": "TM", "Value": ["093825.348000"]}, "42": {"vr": "TM", "Value": ["093825.114000"]}, "43": {"vr": "TM", "Value": ["093825.094000"]}, "44": {"vr": "TM", "Value": ["093825.102000"]}, "45": {"vr": "TM", "Value": ["093825.331000"]}, "46": {"vr": "TM", "Value": ["093825.333000"]}, "47": {"vr": "TM", "Value": ["093825.147000"]}, "48": {"vr": "TM", "Value": ["093825.400000"]}, "49": {"vr": "TM", "Value": ["093825.359000"]}, "50": {"vr": "TM", "Value": ["093825.073000"]}, "51": {"vr": "TM", "Value": ["093825.321000"]}, "52": {"vr": "TM", "Value": ["093825.307000"]}, "53": {"vr": "TM", "Value": ["093825.345000"]}, "54": {"vr": "TM", "Value": ["093825.352000"]}, "55": {"vr": "TM", "Value": ["093825.420000"]}, "56": {"vr": "TM", "Value": ["093825.326000"]}, "57": {"vr": "TM", "Value": ["093825.152000"]}, "58": {"vr": "TM", "Value": ["093825.116000"]}, "59": {"vr": "TM", "Value": ["093825.107000"]}, "60": {"vr": "TM", "Value": ["093825.389000"]}, "61": {"vr": "TM", "Value": ["093825.252000"]}, "62": {"vr": "TM", "Value": ["093825.135000"]}, "63": {"vr": "TM", "Value": ["093825.068000"]}, "64": {"vr": "TM", "Value": ["093825.294000"]}, "65": {"vr": "TM", "Value": ["093825.340000"]}, "66": {"vr": "TM", "Value": ["093825.087000"]}, "67": {"vr": "TM", "Value": ["093825.119000"]}, "68": {"vr": "TM", "Value": ["093825.224000"]}, "69": {"vr": "TM", "Value": ["093825.132000"]}, "70": {"vr": "TM", "Value": ["093825.109000"]}, "71": {"vr": "TM", "Value": ["093825.099000"]}, "72": {"vr": "TM", "Value": ["093825.427000"]}, "73": {"vr": "TM", "Value": ["093825.247000"]}, "74": {"vr": "TM", "Value": ["093825.128000"]}, "75": {"vr": "TM", "Value": ["093825.391000"]}, "76": {"vr": "TM", "Value": ["093825.092000"]}, "77": {"vr": "TM", "Value": ["093825.242000"]}, "78": {"vr": "TM", "Value": ["093825.125000"]}, "79": {"vr": "TM", "Value": ["093825.285000"]}, "80": {"vr": "TM", "Value": ["093825.309000"]}, "81": {"vr": "TM", "Value": ["093825.137000"]}, "82": {"vr": "TM", "Value": ["093825.130000"]}, "83": {"vr": "TM", "Value": ["093825.123000"]}, "84": {"vr": "TM", "Value": ["093825.240000"]}, "85": {"vr": "TM", "Value": ["093825.369000"]}, "86": {"vr": "TM", "Value": ["093825.297000"]}, "87": {"vr": "TM", "Value": ["093825.258000"]}, "88": {"vr": "TM", "Value": ["093825.425000"]}, "89": {"vr": "TM", "Value": ["093825.335000"]}, "90": {"vr": "TM", "Value": ["093825.245000"]}, "91": {"vr": "TM", "Value": ["093825.280000"]}, "92": {"vr": "TM", "Value": ["093825.112000"]}, "93": {"vr": "TM", "Value": ["093825.142000"]}, "94": {"vr": "TM", "Value": ["093825.249000"]}, "95": {"vr": "TM", "Value": ["093825.260000"]}, "96": {"vr": "TM", "Value": ["093825.367000"]}, "97": {"vr": "TM", "Value": ["093825.212000"]}, "98": {"vr": "TM", "Value": ["093825.064000"]}, "99": {"vr": "TM", "Value": ["093825.157000"]}, "100": {"vr": "TM", "Value": ["093825.290000"]}, "101": {"vr": "TM", "Value": ["093825.323000"]}, "102": {"vr": "TM", "Value": ["093825.338000"]}, "103": {"vr": "TM", "Value": ["093825.278000"]}, "104": {"vr": "TM", "Value": ["093825.256000"]}, "105": {"vr": "TM", "Value": ["093825.386000"]}, "106": {"vr": "TM", "Value": ["093825.267000"]}, "107": {"vr": "TM", "Value": ["093825.381000"]}, "108": {"vr": "TM", "Value": ["093825.071000"]}, "109": {"vr": "TM", "Value": ["093825.231000"]}, "110": {"vr": "TM", "Value": ["093825.329000"]}, "111": {"vr": "TM", "Value": ["093825.149000"]}, "112": {"vr": "TM", "Value": ["093825.154000"]}, "113": {"vr": "TM", "Value": ["093825.254000"]}, "114": {"vr": "TM", "Value": ["093825.299000"]}, "115": {"vr": "TM", "Value": ["093825.311000"]}, "116": {"vr": "TM", "Value": ["093825.317000"]}, "117": {"vr": "TM", "Value": ["093825.342000"]}, "118": {"vr": "TM", "Value": ["093825.365000"]}, "119": {"vr": "TM", "Value": ["093825.221000"]}}, "00180081": {"0": {"vr": "DS", "Value": [7.38]}, "1": {"vr": "DS", "Value": [4.92]}, "2": {"vr": "DS", "Value": [7.38]}, "3": {"vr": "DS", "Value": [7.38]}, "4": {"vr": "DS", "Value": [7.38]}, "5": {"vr": "DS", "Value": [4.92]}, "6": {"vr": "DS", "Value": [4.92]}, "7": {"vr": "DS", "Value": [7.38]}, "8": {"vr": "DS", "Value": [4.92]}, "9": {"vr": "DS", "Value": [7.38]}, "10": {"vr": "DS", "Value": [7.38]}, "11": {"vr": "DS", "Value": [7.38]}, "12": {"vr": "DS", "Value": [4.92]}, "13": {"vr": "DS", "Value": [7.38]}, "14": {"vr": "DS", "Value": [4.92]}, "15": {"vr": "DS", "Value": [4.92]}, "16": {"vr": "DS", "Value": [4.92]}, "17": {"vr": "DS", "Value": [4.92]}, "18": {"vr": "DS", "Value": [4.92]}, "19": {"vr": "DS", "Value": [7.38]}, "20": {"vr": "DS", "Value": [7.38]}, "21": {"vr": "DS", "Value": [4.92]}, "22": {"vr": "DS", "Value": [7.38]}, "23": {"vr": "DS", "Value": [4.92]}, "24": {"vr": "DS", "Value": [4.92]}, "25": {"vr": "DS", "Value": [7.38]}, "26": {"vr": "DS", "Value": [7.38]}, "27": {"vr": "DS", "Value": [7.38]}, "28": {"vr": "DS", "Value": [7.38]}, "29": {"vr": "DS", "Value": [4.92]}, "30": {"vr": "DS", "Value": [7.38]}, "31": {"vr": "DS", "Value": [4.92]}, "32": {"vr": "DS", "Value": [4.92]}, "33": {"vr": "DS", "Value": [4.92]}, "34": {"vr": "DS", "Value": [7.38]}, "35": {"vr": "DS", "Value": [7.38]}, "36": {"vr": "DS", "Value": [7.38]}, "37": {"vr": "DS", "Value": [4.92]}, "38": {"vr": "DS", "Value": [4.92]}, "39": {"vr": "DS", "Value": [7.38]}, "40": {"vr": "DS", "Value": [7.38]}, "41": {"vr": "DS", "Value": [7.38]}, "42": {"vr": "DS", "Value": [4.92]}, "43": {"vr": "DS", "Value": [4.92]}, "44": {"vr": "DS", "Value": [4.92]}, "45": {"vr": "DS", "Value": [7.38]}, "46": {"vr": "DS", "Value": [7.38]}, "47": {"vr": "DS", "Value": [4.92]}, "48": {"vr": "DS", "Value": [7.38]}, "49": {"vr": "DS", "Value": [7.38]}, "50": {"vr": "DS", "Value": [4.92]}, "51": {"vr": "DS", "Value": [7.38]}, "52": {"vr": "DS", "Value": [7.38]}, "53": {"vr": "DS", "Value": [7.38]}, "54": {"vr": "DS", "Value": [7.38]}, "55": {"vr": "DS", "Value": [7.38]}, "56": {"vr": "DS", "Value": [7.38]}, "57": {"vr": "DS", "Value": [4.92]}, "58": {"vr": "DS", "Value": [4.92]}, "59": {"vr": "DS", "Value": [4.92]}, "60": {"vr": "DS", "Value": [7.38]}, "61": {"vr": "DS", "Value": [4.92]}, "62": {"vr": "DS", "Value": [4.92]}, "63": {"vr": "DS", "Value": [4.92]}, "64": {"vr": "DS", "Value": [7.38]}, "65": {"vr": "DS", "Value": [7.38]}, "66": {"vr": "DS", "Value": [4.92]}, "67": {"vr": "DS", "Value": [4.92]}, "68": {"vr": "DS", "Value": [4.92]}, "69": {"vr": "DS", "Value": [4.92]}, "70": {"vr": "DS", "Value": [4.92]}, "71": {"vr": "DS", "Value": [4.92]}, "72": {"vr": "DS", "Value": [7.38]}, "73": {"vr": "DS", "Value": [4.92]}, "74": {"vr": "DS", "Value": [4.92]}, "75": {"vr": "DS", "Value": [7.38]}, "76": {"vr": "DS", "Value": [4.92]}, "77": {"vr": "DS", "Value": [4.92]}, "78": {"vr": "DS", "Value": [4.92]}, "79": {"vr": "DS", "Value": [7.38]}, "80": {"vr": "DS", "Value": [7.38]}, "81": {"vr": "DS", "Value": [4.92]}, "82": {"vr": "DS", "Value": [4.92]}, "83": {"vr": "DS", "Value": [4.92]}, "84": {"vr": "DS", "Value": [4.92]}, "85": {"vr": "DS", "Value": [7.38]}, "86": {"vr": "DS", "Value": [7.38]}, "87": {"vr": "DS", "Value": [4.92]}, "88": {"vr": "DS", "Value": [7.38]}, "89": {"vr": "DS", "Value": [7.38]}, "90": {"vr": "DS", "Value": [4.92]}, "91": {"vr": "DS", "Value": [7.38]}, "92": {"vr": "DS", "Value": [4.92]}, "93": {"vr": "DS", "Value": [4.92]}, "94": {"vr": "DS", "Value": [4.92]}, "95": {"vr": "DS", "Value": [7.38]}, "96": {"vr": "DS", "Value": [7.38]}, "97": {"vr": "DS", "Value": [4.92]}, "98": {"vr": "DS", "Value": [4.92]}, "99": {"vr": "DS", "Value": [4.92]}, "100": {"vr": "DS", "Value": [7.38]}, "101": {"vr": "DS", "Value": [7.38]}, "102": {"vr": "DS", "Value": [7.38]}, "103": {"vr": "DS", "Value": [7.38]}, "104": {"vr": "DS", "Value": [4.92]}, "105": {"vr": "DS", "Value": [7.38]}, "106": {"vr": "DS", "Value": [7.38]}, "107": {"vr": "DS", "Value": [7.38]}, "108": {"vr": "DS", "Value": [4.92]}, "109": {"vr": "DS", "Value": [4.92]}, "110": {"vr": "DS", "Value": [7.38]}, "111": {"vr": "DS", "Value": [4.92]}, "112": {"vr": "DS", "Value": [4.92]}, "113": {"vr": "DS", "Value": [4.92]}, "114": {"vr": "DS", "Value": [7.38]}, "115": {"vr": "DS", "Value": [7.38]}, "116": {"vr": "DS", "Value": [7.38]}, "117": {"vr": "DS", "Value": [7.38]}, "118": {"vr": "DS", "Value": [7.38]}, "119": {"vr": "DS", "Value": [4.92]}}, "00180086": {"0": {"vr": "IS", "Value": [2]}, "1": {"vr": "IS", "Value": [1]}, "2": {"vr": "IS", "Value": [2]}, "3": {"vr": "IS", "Value": [2]}, "4": {"vr": "IS", "Value": [2]}, "5": {"vr": "IS", "Value": [1]}, "6": {"vr": "IS", "Value": [1]}, "7": {"vr": "IS", "Value": [2]}, "8": {"vr": "IS", "Value": [1]}, "9": {"vr": "IS", "Value": [2]}, "10": {"vr": "IS", "Value": [2]}, "11": {"vr": "IS", "Value": [2]}, "12": {"vr": "IS", "Value": [1]}, "13": {"vr": "IS", "Value": [2]}, "14": {"vr": "IS", "Value": [1]}, "15": {"vr": "IS", "Value": [1]}, "16": {"vr": "IS", "Value": [1]}, "17": {"vr": "IS", "Value": [1]}, "18": {"vr": "IS", "Value": [1]}, "19": {"vr": "IS", "Value": [2]}, "20": {"vr": "IS", "Value": [2]}, "21": {"vr": "IS", "Value": [1]}, "22": {"vr": "IS", "Value": [2]}, "23": {"vr": "IS", "Value": [1]}, "24": {"vr": "IS", "Value": [1]}, "25": {"vr": "IS", "Value": [2]}, "26": {"vr": "IS", "Value": [2]}, "27": {"vr": "IS", "Value": [2]}, "28": {"vr": "IS", "Value": [2]}, "29": {"vr": "IS", "Value": [1]}, "30": {"vr": "IS", "Value": [2]}, "31": {"vr": "IS", "Value": [1]}, "32": {"vr": "IS", "Value": [1]}, "33": {"vr": "IS", "Value": [1]}, "34": {"vr": "IS", "Value": [2]}, "35": {"vr": "IS", "Value": [2]}, "36": {"vr": "IS", "Value": [2]}, "37": {"vr": "IS", "Value": [1]}, "38": {"vr": "IS", "Value": [1]}, "39": {"vr": "IS", "Value": [2]}, "40": {"vr": "IS", "Value": [2]}, "41": {"vr": "IS", "Value": [2]}, "42": {"vr": "IS", "Value": [1]}, "43": {"vr": "IS", "Value": [1]}, "44": {"vr": "IS", "Value": [1]}, "45": {"vr": "IS", "Value": [2]}, "46": {"vr": "IS", "Value": [2]}, "47": {"vr": "IS", "Value": [1]}, "48": {"vr": "IS", "Value": [2]}, "49": {"vr": "IS", "Value": [2]}, "50": {"vr": "IS", "Value": [1]}, "51": {"vr": "IS", "Value": [2]}, "52": {"vr": "IS", "Value": [2]}, "53": {"vr": "IS", "Value": [2]}, "54": {"vr": "IS", "Value": [2]}, "55": {"vr": "IS", "Value": [2]}, "56": {"vr": "IS", "Value": [2]}, "57": {"vr": "IS", "Value": [1]}, "58": {"vr": "IS", "Value": [1]}, "59": {"vr": "IS", "Value": [1]}, "60": {"vr": "IS", "Value": [2]}, "61": {"vr": "IS", "Value": [1]}, "62": {"vr": "IS", "Value": [1]}, "63": {"vr": "IS", "Value": [1]}, "64": {"vr": "IS", "Value": [2]}, "65": {"vr": "IS", "Value": [2]}, "66": {"vr": "IS", "Value": [1]}, "67": {"vr": "IS", "Value": [1]}, "68": {"vr": "IS", "Value": [1]}, "69": {"vr": "IS", "Value": [1]}, "70": {"vr": "IS", "Value": [1]}, "71": {"vr": "IS", "Value": [1]}, "72": {"vr": "IS", "Value": [2]}, "73": {"vr": "IS", "Value": [1]}, "74": {"vr": "IS", "Value": [1]}, "75": {"vr": "IS", "Value": [2]}, "76": {"vr": "IS", "Value": [1]}, "77": {"vr": "IS", "Value": [1]}, "78": {"vr": "IS", "Value": [1]}, "79": {"vr": "IS", "Value": [2]}, "80": {"vr": "IS", "Value": [2]}, "81": {"vr": "IS", "Value": [1]}, "82": {"vr": "IS", "Value": [1]}, "83": {"vr": "IS", "Value": [1]}, "84": {"vr": "IS", "Value": [1]}, "85": {"vr": "IS", "Value": [2]}, "86": {"vr": "IS", "Value": [2]}, "87": {"vr": "IS", "Value": [1]}, "88": {"vr": "IS", "Value": [2]}, "89": {"vr": "IS", "Value": [2]}, "90": {"vr": "IS", "Value": [1]}, "91": {"vr": "IS", "Value": [2]}, "92": {"vr": "IS", "Value": [1]}, "93": {"vr": "IS", "Value": [1]}, "94": {"vr": "IS", "Value": [1]}, "95": {"vr": "IS", "Value": [2]}, "96": {"vr": "IS", "Value": [2]}, "97": {"vr": "IS", "Value": [1]}, "98": {"vr": "IS", "Value": [1]}, "99": {"vr": "IS", "Value": [1]}, "100": {"vr": "IS", "Value": [2]}, "101": {"vr": "IS", "Value": [2]}, "102": {"vr": "IS", "Value": [2]}, "103": {"vr": "IS", "Value": [2]}, "104": {"vr": "IS", "Value": [1]}, "105": {"vr": "IS", "Value": [2]}, "106": {"vr": "IS", "Value": [2]}, "107": {"vr": "IS", "Value": [2]}, "108": {"vr": "IS", "Value": [1]}, "109": {"vr": "IS", "Value": [1]}, "110": {"vr": "IS", "Value": [2]}, "111": {"vr": "IS", "Value": [1]}, "112": {"vr": "IS", "Value": [1]}, "113": {"vr": "IS", "Value": [1]}, "114": {"vr": "IS", "Value": [2]}, "115": {"vr": "IS", "Value": [2]}, "116": {"vr": "IS", "Value": [2]}, "117": {"vr": "IS", "Value": [2]}, "118": {"vr": "IS", "Value": [2]}, "119": {"vr": "IS", "Value": [1]}}, "0019100B": {"0": {"vr": "DS", "Value": [80387.5]}, "1": {"vr": "DS", "Value": [80387.5]}, "2": {"vr": "DS", "Value": [80387.5]}, "3": {"vr": "DS", "Value": [80387.5]}, "4": {"vr": "DS", "Value": [80387.5]}, "5": {"vr": "DS", "Value": [80390.0]}, "6": {"vr": "DS", "Value": [80387.5]}, "7": {"vr": "DS", "Value": [80387.5]}, "8": {"vr": "DS", "Value": [80387.5]}, "9": {"vr": "DS", "Value": [80387.5]}, "10": {"vr": "DS", "Value": [80390.0]}, "11": {"vr": "DS", "Value": [80387.5]}, "12": {"vr": "DS", "Value": [80387.5]}, "13": {"vr": "DS", "Value": [80387.5]}, "14": {"vr": "DS", "Value": [80390.0]}, "15": {"vr": "DS", "Value": [80387.5]}, "16": {"vr": "DS", "Value": [80387.5]}, "17": {"vr": "DS", "Value": [80387.5]}, "18": {"vr": "DS", "Value": [80387.5]}, "19": {"vr": "DS", "Value": [80390.0]}, "20": {"vr": "DS", "Value": [80387.5]}, "21": {"vr": "DS", "Value": [80387.5]}, "22": {"vr": "DS", "Value": [80387.5]}, "23": {"vr": "DS", "Value": [80387.5]}, "24": {"vr": "DS", "Value": [80387.5]}, "25": {"vr": "DS", "Value": [80387.5]}, "26": {"vr": "DS", "Value": [80387.5]}, "27": {"vr": "DS", "Value": [80387.5]}, "28": {"vr": "DS", "Value": [80387.5]}, "29": {"vr": "DS", "Value": [80387.5]}, "30": {"vr": "DS", "Value": [80387.5]}, "31": {"vr": "DS", "Value": [80387.5]}, "32": {"vr": "DS", "Value": [80387.5]}, "33": {"vr": "DS", "Value": [80387.5]}, "34": {"vr": "DS", "Value": [80387.5]}, "35": {"vr": "DS", "Value": [80390.0]}, "36": {"vr": "DS", "Value": [80387.5]}, "37": {"vr": "DS", "Value": [80387.5]}, "38": {"vr": "DS", "Value": [80387.5]}, "39": {"vr": "DS", "Value": [80387.5]}, "40": {"vr": "DS", "Value": [80390.0]}, "41": {"vr": "DS", "Value": [80387.5]}, "42": {"vr": "DS", "Value": [80387.5]}, "43": {"vr": "DS", "Value": [80387.5]}, "44": {"vr": "DS", "Value": [80387.5]}, "45": {"vr": "DS", "Value": [80387.5]}, "46": {"vr": "DS", "Value": [80387.5]}, "47": {"vr": "DS", "Value": [80387.5]}, "48": {"vr": "DS", "Value": [80387.5]}, "49": {"vr": "DS", "Value": [80387.5]}, "50": {"vr": "DS", "Value": [80387.5]}, "51": {"vr": "DS", "Value": [80387.5]}, "52": {"vr": "DS", "Value": [80387.5]}, "53": {"vr": "DS", "Value": [80387.5]}, "54": {"vr": "DS", "Value": [80387.5]}, "55": {"vr": "DS", "Value": [80390.0]}, "56": {"vr": "DS", "Value": [80387.5]}, "57": {"vr": "DS", "Value": [80387.5]}, "58": {"vr": "DS", "Value": [80390.0]}, "59": {"vr": "DS", "Value": [80387.5]}, "60": {"vr": "DS", "Value": [80387.5]}, "61": {"vr": "DS", "Value": [80390.0]}, "62": {"vr": "DS", "Value": [80390.0]}, "63": {"vr": "DS", "Value": [80387.5]}, "64": {"vr": "DS", "Value": [80390.0]}, "65": {"vr": "DS", "Value": [80387.5]}, "66": {"vr": "DS", "Value": [80387.5]}, "67": {"vr": "DS", "Value": [80387.5]}, "68": {"vr": "DS", "Value": [80390.0]}, "69": {"vr": "DS", "Value": [80387.5]}, "70": {"vr": "DS", "Value": [80387.5]}, "71": {"vr": "DS", "Value": [80387.5]}, "72": {"vr": "DS", "Value": [80387.5]}, "73": {"vr": "DS", "Value": [80387.5]}, "74": {"vr": "DS", "Value": [80387.5]}, "75": {"vr": "DS", "Value": [80387.5]}, "76": {"vr": "DS", "Value": [80387.5]}, "77": {"vr": "DS", "Value": [80390.0]}, "78": {"vr": "DS", "Value": [80390.0]}, "79": {"vr": "DS", "Value": [80390.0]}, "80": {"vr": "DS", "Value": [80387.5]}, "81": {"vr": "DS", "Value": [80387.5]}, "82": {"vr": "DS", "Value": [80387.5]}, "83": {"vr": "DS", "Value": [80387.5]}, "84": {"vr": "DS", "Value": [80387.5]}, "85": {"vr": "DS", "Value": [80387.5]}, "86": {"vr": "DS", "Value": [80387.5]}, "87": {"vr": "DS", "Value": [80387.5]}, "88": {"vr": "DS", "Value": [80387.5]}, "89": {"vr": "DS", "Value": [80387.5]}, "90": {"vr": "DS", "Value": [80387.5]}, "91": {"vr": "DS", "Value": [80387.5]}, "92": {"vr": "DS", "Value": [80387.5]}, "93": {"vr": "DS", "Value": [80387.5]}, "94": {"vr": "DS", "Value": [80387.5]}, "95": {"vr": "DS", "Value": [80390.0]}, "96": {"vr": "DS", "Value": [80387.5]}, "97": {"vr": "DS", "Value": [80390.0]}, "98": {"vr": "DS", "Value": [80387.5]}, "99": {"vr": "DS", "Value": [80387.5]}, "100": {"vr": "DS", "Value": [80387.5]}, "101": {"vr": "DS", "Value": [80390.0]}, "102": {"vr": "DS", "Value": [80387.5]}, "103": {"vr": "DS", "Value": [80387.5]}, "104": {"vr": "DS", "Value": [80387.5]}, "105": {"vr": "DS", "Value": [80387.5]}, "106": {"vr": "DS", "Value": [80387.5]}, "107": {"vr": "DS", "Value": [80387.5]}, "108": {"vr": "DS", "Value": [80387.5]}, "109": {"vr": "DS", "Value": [80387.5]}, "110": {"vr": "DS", "Value": [80387.5]}, "111": {"vr": "DS", "Value": [80387.5]}, "112": {"vr": "DS", "Value": [80390.0]}, "113": {"vr": "DS", "Value": [80387.5]}, "114": {"vr": "DS", "Value": [80387.5]}, "115": {"vr": "DS", "Value": [80387.5]}, "116": {"vr": "DS", "Value": [80387.5]}, "117": {"vr": "DS", "Value": [80387.5]}, "118": {"vr": "DS", "Value": [80387.5]}, "119": {"vr": "DS", "Value": [80387.5]}}, "00191015": {"0": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -61.08507538]}, "1": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 28.91492462]}, "2": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -22.08507538]}, "3": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -34.08507538]}, "4": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -76.08507538]}, "5": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -79.08507538]}, "6": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 43.91492462]}, "7": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 1.91492486]}, "8": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -43.08507538]}, "9": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -43.08507538]}, "10": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 82.91492462]}, "11": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 43.91492462]}, "12": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 4.91492462]}, "13": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 52.91492462]}, "14": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 16.91492462]}, "15": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -34.08507538]}, "16": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -1.08507514]}, "17": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -52.08507538]}, "18": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -64.08507538]}, "19": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -64.08507538]}, "20": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 28.91492462]}, "21": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -25.08507538]}, "22": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -46.08507538]}, "23": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -58.08507538]}, "24": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 22.91492462]}, "25": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 34.91492462]}, "26": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 46.91492462]}, "27": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -49.08507538]}, "28": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 64.91492462]}, "29": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -16.08507538]}, "30": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -31.08507538]}, "31": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -91.08507538]}, "32": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -19.08507538]}, "33": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 1.91492486]}, "34": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -82.08507538]}, "35": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 7.91492462]}, "36": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 4.91492462]}, "37": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -46.08507538]}, "38": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -37.08507538]}, "39": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -7.08507538]}, "40": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 31.91492462]}, "41": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -67.08507538]}, "42": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 25.91492462]}, "43": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -22.08507538]}, "44": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -4.08507538]}, "45": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 73.91492462]}, "46": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 79.91492462]}, "47": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -73.08507538]}, "48": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 40.91492462]}, "49": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -37.08507538]}, "50": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -70.08507538]}, "51": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 49.91492462]}, "52": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 13.91492462]}, "53": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -73.08507538]}, "54": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -55.08507538]}, "55": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 58.91492462]}, "56": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 61.91492462]}, "57": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -61.08507538]}, "58": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 31.91492462]}, "59": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 7.91492462]}, "60": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 16.91492462]}, "61": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 64.91492462]}, "62": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 79.91492462]}, "63": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -82.08507538]}, "64": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -16.08507538]}, "65": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -85.08507538]}, "66": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -40.08507538]}, "67": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 37.91492462]}, "68": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -7.08507538]}, "69": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 73.91492462]}, "70": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 13.91492462]}, "71": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -10.08507538]}, "72": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 76.91492462]}, "73": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 52.91492462]}, "74": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 61.91492462]}, "75": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 22.91492462]}, "76": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -28.08507538]}, "77": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 40.91492462]}, "78": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 55.91492462]}, "79": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -40.08507538]}, "80": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 19.91492462]}, "81": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 85.91492462]}, "82": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 67.91492462]}, "83": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 49.91492462]}, "84": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 34.91492462]}, "85": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -13.08507538]}, "86": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -10.08507538]}, "87": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 82.91492462]}, "88": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 70.91492462]}, "89": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 85.91492462]}, "90": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 46.91492462]}, "91": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -52.08507538]}, "92": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 19.91492462]}, "93": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -85.08507538]}, "94": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 58.91492462]}, "95": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -88.08507538]}, "96": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -19.08507538]}, "97": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -31.08507538]}, "98": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -88.08507538]}, "99": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -49.08507538]}, "100": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -28.08507538]}, "101": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 55.91492462]}, "102": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -91.08507538]}, "103": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -58.08507538]}, "104": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 76.91492462]}, "105": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 10.91492462]}, "106": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -70.08507538]}, "107": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -1.08507514]}, "108": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -76.08507538]}, "109": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 10.91492462]}, "110": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 67.91492462]}, "111": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -67.08507538]}, "112": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -55.08507538]}, "113": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 70.91492462]}, "114": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -4.08507538]}, "115": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 25.91492462]}, "116": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 37.91492462]}, "117": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -79.08507538]}, "118": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -25.08507538]}, "119": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -13.08507538]}}, "00191016": {"0": {"vr": "DS", "Value": [1.0125]}, "1": {"vr": "DS", "Value": [0.5325]}, "2": {"vr": "DS", "Value": [0.7575]}, "3": {"vr": "DS", "Value": [0.7375]}, "4": {"vr": "DS", "Value": [0.6625]}, "5": {"vr": "DS", "Value": [0.34]}, "6": {"vr": "DS", "Value": [0.235]}, "7": {"vr": "DS", "Value": [0.8]}, "8": {"vr": "DS", "Value": [0.405]}, "9": {"vr": "DS", "Value": [1.045]}, "10": {"vr": "DS", "Value": [1.2675]}, "11": {"vr": "DS", "Value": [0.875]}, "12": {"vr": "DS", "Value": [0.49]}, "13": {"vr": "DS", "Value": [1.215]}, "14": {"vr": "DS", "Value": [0.51]}, "15": {"vr": "DS", "Value": [0.095]}, "16": {"vr": "DS", "Value": [0.4775]}, "17": {"vr": "DS", "Value": [0.065]}, "18": {"vr": "DS", "Value": [0.0425]}, "19": {"vr": "DS", "Value": [0.6825]}, "20": {"vr": "DS", "Value": [1.1725]}, "21": {"vr": "DS", "Value": [0.435]}, "22": {"vr": "DS", "Value": [0.715]}, "23": {"vr": "DS", "Value": [0.0525]}, "24": {"vr": "DS", "Value": [0.52]}, "25": {"vr": "DS", "Value": [1.1825]}, "26": {"vr": "DS", "Value": [1.205]}, "27": {"vr": "DS", "Value": [1.035]}, "28": {"vr": "DS", "Value": [1.235]}, "29": {"vr": "DS", "Value": [0.1275]}, "30": {"vr": "DS", "Value": [1.065]}, "31": {"vr": "DS", "Value": [0.32]}, "32": {"vr": "DS", "Value": [0.4475]}, "33": {"vr": "DS", "Value": [0.16]}, "34": {"vr": "DS", "Value": [0.65]}, "35": {"vr": "DS", "Value": [0.81]}, "36": {"vr": "DS", "Value": [1.13]}, "37": {"vr": "DS", "Value": [0.075]}, "38": {"vr": "DS", "Value": [0.415]}, "39": {"vr": "DS", "Value": [1.1075]}, "40": {"vr": "DS", "Value": [0.8525]}, "41": {"vr": "DS", "Value": [1.0025]}, "42": {"vr": "DS", "Value": [0.2025]}, "43": {"vr": "DS", "Value": [0.1175]}, "44": {"vr": "DS", "Value": [0.15]}, "45": {"vr": "DS", "Value": [0.9275]}, "46": {"vr": "DS", "Value": [0.9375]}, "47": {"vr": "DS", "Value": [0.35]}, "48": {"vr": "DS", "Value": [1.1925]}, "49": {"vr": "DS", "Value": [1.055]}, "50": {"vr": "DS", "Value": [0.0325]}, "51": {"vr": "DS", "Value": [0.885]}, "52": {"vr": "DS", "Value": [0.8225]}, "53": {"vr": "DS", "Value": [0.9925]}, "54": {"vr": "DS", "Value": [1.0225]}, "55": {"vr": "DS", "Value": [1.225]}, "56": {"vr": "DS", "Value": [0.9075]}, "57": {"vr": "DS", "Value": [0.3725]}, "58": {"vr": "DS", "Value": [0.2125]}, "59": {"vr": "DS", "Value": [0.17]}, "60": {"vr": "DS", "Value": [1.15]}, "61": {"vr": "DS", "Value": [0.595]}, "62": {"vr": "DS", "Value": [0.2975]}, "63": {"vr": "DS", "Value": [0.01]}, "64": {"vr": "DS", "Value": [0.7675]}, "65": {"vr": "DS", "Value": [0.97]}, "66": {"vr": "DS", "Value": [0.085]}, "67": {"vr": "DS", "Value": [0.2225]}, "68": {"vr": "DS", "Value": [0.4675]}, "69": {"vr": "DS", "Value": [0.2875]}, "70": {"vr": "DS", "Value": [0.18]}, "71": {"vr": "DS", "Value": [0.1375]}, "72": {"vr": "DS", "Value": [1.2575]}, "73": {"vr": "DS", "Value": [0.575]}, "74": {"vr": "DS", "Value": [0.265]}, "75": {"vr": "DS", "Value": [1.1625]}, "76": {"vr": "DS", "Value": [0.1075]}, "77": {"vr": "DS", "Value": [0.5525]}, "78": {"vr": "DS", "Value": [0.255]}, "79": {"vr": "DS", "Value": [0.725]}, "80": {"vr": "DS", "Value": [0.8325]}, "81": {"vr": "DS", "Value": [0.3075]}, "82": {"vr": "DS", "Value": [0.2775]}, "83": {"vr": "DS", "Value": [0.245]}, "84": {"vr": "DS", "Value": [0.5425]}, "85": {"vr": "DS", "Value": [1.0975]}, "86": {"vr": "DS", "Value": [0.78]}, "87": {"vr": "DS", "Value": [0.6275]}, "88": {"vr": "DS", "Value": [1.2475]}, "89": {"vr": "DS", "Value": [0.95]}, "90": {"vr": "DS", "Value": [0.5625]}, "91": {"vr": "DS", "Value": [0.705]}, "92": {"vr": "DS", "Value": [0.1925]}, "93": {"vr": "DS", "Value": [0.33]}, "94": {"vr": "DS", "Value": [0.585]}, "95": {"vr": "DS", "Value": [0.64]}, "96": {"vr": "DS", "Value": [1.0875]}, "97": {"vr": "DS", "Value": [0.425]}, "98": {"vr": "DS", "Value": [0.0]}, "99": {"vr": "DS", "Value": [0.3925]}, "100": {"vr": "DS", "Value": [0.7475]}, "101": {"vr": "DS", "Value": [0.895]}, "102": {"vr": "DS", "Value": [0.96]}, "103": {"vr": "DS", "Value": [0.695]}, "104": {"vr": "DS", "Value": [0.6175]}, "105": {"vr": "DS", "Value": [1.14]}, "106": {"vr": "DS", "Value": [0.6725]}, "107": {"vr": "DS", "Value": [1.12]}, "108": {"vr": "DS", "Value": [0.0225]}, "109": {"vr": "DS", "Value": [0.5]}, "110": {"vr": "DS", "Value": [0.9175]}, "111": {"vr": "DS", "Value": [0.3625]}, "112": {"vr": "DS", "Value": [0.3825]}, "113": {"vr": "DS", "Value": [0.605]}, "114": {"vr": "DS", "Value": [0.79]}, "115": {"vr": "DS", "Value": [0.8425]}, "116": {"vr": "DS", "Value": [0.865]}, "117": {"vr": "DS", "Value": [0.98]}, "118": {"vr": "DS", "Value": [1.0775]}, "119": {"vr": "DS", "Value": [0.4575]}}, "00200013": {"0": {"vr": "IS", "Value": [11]}, "1": {"vr": "IS", "Value": [41]}, "2": {"vr": "IS", "Value": [24]}, "3": {"vr": "IS", "Value": [20]}, "4": {"vr": "IS", "Value": [6]}, "5": {"vr": "IS", "Value": [5]}, "6": {"vr": "IS", "Value": [46]}, "7": {"vr": "IS", "Value": [32]}, "8": {"vr": "IS", "Value": [17]}, "9": {"vr": "IS", "Value": [17]}, "10": {"vr": "IS", "Value": [59]}, "11": {"vr": "IS", "Value": [46]}, "12": {"vr": "IS", "Value": [33]}, "13": {"vr": "IS", "Value": [49]}, "14": {"vr": "IS", "Value": [37]}, "15": {"vr": "IS", "Value": [20]}, "16": {"vr": "IS", "Value": [31]}, "17": {"vr": "IS", "Value": [14]}, "18": {"vr": "IS", "Value": [10]}, "19": {"vr": "IS", "Value": [10]}, "20": {"vr": "IS", "Value": [41]}, "21": {"vr": "IS", "Value": [23]}, "22": {"vr": "IS", "Value": [16]}, "23": {"vr": "IS", "Value": [12]}, "24": {"vr": "IS", "Value": [39]}, "25": {"vr": "IS", "Value": [43]}, "26": {"vr": "IS", "Value": [47]}, "27": {"vr": "IS", "Value": [15]}, "28": {"vr": "IS", "Value": [53]}, "29": {"vr": "IS", "Value": [26]}, "30": {"vr": "IS", "Value": [21]}, "31": {"vr": "IS", "Value": [1]}, "32": {"vr": "IS", "Value": [25]}, "33": {"vr": "IS", "Value": [32]}, "34": {"vr": "IS", "Value": [4]}, "35": {"vr": "IS", "Value": [34]}, "36": {"vr": "IS", "Value": [33]}, "37": {"vr": "IS", "Value": [16]}, "38": {"vr": "IS", "Value": [19]}, "39": {"vr": "IS", "Value": [29]}, "40": {"vr": "IS", "Value": [42]}, "41": {"vr": "IS", "Value": [9]}, "42": {"vr": "IS", "Value": [40]}, "43": {"vr": "IS", "Value": [24]}, "44": {"vr": "IS", "Value": [30]}, "45": {"vr": "IS", "Value": [56]}, "46": {"vr": "IS", "Value": [58]}, "47": {"vr": "IS", "Value": [7]}, "48": {"vr": "IS", "Value": [45]}, "49": {"vr": "IS", "Value": [19]}, "50": {"vr": "IS", "Value": [8]}, "51": {"vr": "IS", "Value": [48]}, "52": {"vr": "IS", "Value": [36]}, "53": {"vr": "IS", "Value": [7]}, "54": {"vr": "IS", "Value": [13]}, "55": {"vr": "IS", "Value": [51]}, "56": {"vr": "IS", "Value": [52]}, "57": {"vr": "IS", "Value": [11]}, "58": {"vr": "IS", "Value": [42]}, "59": {"vr": "IS", "Value": [34]}, "60": {"vr": "IS", "Value": [37]}, "61": {"vr": "IS", "Value": [53]}, "62": {"vr": "IS", "Value": [58]}, "63": {"vr": "IS", "Value": [4]}, "64": {"vr": "IS", "Value": [26]}, "65": {"vr": "IS", "Value": [3]}, "66": {"vr": "IS", "Value": [18]}, "67": {"vr": "IS", "Value": [44]}, "68": {"vr": "IS", "Value": [29]}, "69": {"vr": "IS", "Value": [56]}, "70": {"vr": "IS", "Value": [36]}, "71": {"vr": "IS", "Value": [28]}, "72": {"vr": "IS", "Value": [57]}, "73": {"vr": "IS", "Value": [49]}, "74": {"vr": "IS", "Value": [52]}, "75": {"vr": "IS", "Value": [39]}, "76": {"vr": "IS", "Value": [22]}, "77": {"vr": "IS", "Value": [45]}, "78": {"vr": "IS", "Value": [50]}, "79": {"vr": "IS", "Value": [18]}, "80": {"vr": "IS", "Value": [38]}, "81": {"vr": "IS", "Value": [60]}, "82": {"vr": "IS", "Value": [54]}, "83": {"vr": "IS", "Value": [48]}, "84": {"vr": "IS", "Value": [43]}, "85": {"vr": "IS", "Value": [27]}, "86": {"vr": "IS", "Value": [28]}, "87": {"vr": "IS", "Value": [59]}, "88": {"vr": "IS", "Value": [55]}, "89": {"vr": "IS", "Value": [60]}, "90": {"vr": "IS", "Value": [47]}, "91": {"vr": "IS", "Value": [14]}, "92": {"vr": "IS", "Value": [38]}, "93": {"vr": "IS", "Value": [3]}, "94": {"vr": "IS", "Value": [51]}, "95": {"vr": "IS", "Value": [2]}, "96": {"vr": "IS", "Value": [25]}, "97": {"vr": "IS", "Value": [21]}, "98": {"vr": "IS", "Value": [2]}, "99": {"vr": "IS", "Value": [15]}, "100": {"vr": "IS", "Value": [22]}, "101": {"vr": "IS", "Value": [50]}, "102": {"vr": "IS", "Value": [1]}, "103": {"vr": "IS", "Value": [12]}, "104": {"vr": "IS", "Value": [57]}, "105": {"vr": "IS", "Value": [35]}, "106": {"vr": "IS", "Value": [8]}, "107": {"vr": "IS", "Value": [31]}, "108": {"vr": "IS", "Value": [6]}, "109": {"vr": "IS", "Value": [35]}, "110": {"vr": "IS", "Value": [54]}, "111": {"vr": "IS", "Value": [9]}, "112": {"vr": "IS", "Value": [13]}, "113": {"vr": "IS", "Value": [55]}, "114": {"vr": "IS", "Value": [30]}, "115": {"vr": "IS", "Value": [40]}, "116": {"vr": "IS", "Value": [44]}, "117": {"vr": "IS", "Value": [5]}, "118": {"vr": "IS", "Value": [23]}, "119": {"vr": "IS", "Value": [27]}}, "00200032": {"0": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -61.085075378418]}, "1": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 28.914924621582]}, "2": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -22.085075378418]}, "3": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -34.085075378418]}, "4": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -76.085075378418]}, "5": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -79.085075378418]}, "6": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 43.914924621582]}, "7": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 1.9149248600006]}, "8": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -43.085075378418]}, "9": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -43.085075378418]}, "10": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 82.914924621582]}, "11": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 43.914924621582]}, "12": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 4.914924621582]}, "13": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 52.914924621582]}, "14": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 16.914924621582]}, "15": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -34.085075378418]}, "16": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -1.0850751399994]}, "17": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -52.085075378418]}, "18": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -64.085075378418]}, "19": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -64.085075378418]}, "20": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 28.914924621582]}, "21": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -25.085075378418]}, "22": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -46.085075378418]}, "23": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -58.085075378418]}, "24": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 22.914924621582]}, "25": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 34.914924621582]}, "26": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 46.914924621582]}, "27": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -49.085075378418]}, "28": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 64.914924621582]}, "29": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -16.085075378418]}, "30": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -31.085075378418]}, "31": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -91.085075378418]}, "32": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -19.085075378418]}, "33": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 1.9149248600006]}, "34": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -82.085075378418]}, "35": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 7.914924621582]}, "36": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 4.914924621582]}, "37": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -46.085075378418]}, "38": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -37.085075378418]}, "39": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -7.085075378418]}, "40": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 31.914924621582]}, "41": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -67.085075378418]}, "42": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 25.914924621582]}, "43": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -22.085075378418]}, "44": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -4.085075378418]}, "45": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 73.914924621582]}, "46": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 79.914924621582]}, "47": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -73.085075378418]}, "48": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 40.914924621582]}, "49": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -37.085075378418]}, "50": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -70.085075378418]}, "51": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 49.914924621582]}, "52": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 13.914924621582]}, "53": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -73.085075378418]}, "54": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -55.085075378418]}, "55": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 58.914924621582]}, "56": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 61.914924621582]}, "57": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -61.085075378418]}, "58": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 31.914924621582]}, "59": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 7.914924621582]}, "60": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 16.914924621582]}, "61": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 64.914924621582]}, "62": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 79.914924621582]}, "63": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -82.085075378418]}, "64": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -16.085075378418]}, "65": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -85.085075378418]}, "66": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -40.085075378418]}, "67": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 37.914924621582]}, "68": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -7.085075378418]}, "69": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 73.914924621582]}, "70": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 13.914924621582]}, "71": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -10.085075378418]}, "72": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 76.914924621582]}, "73": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 52.914924621582]}, "74": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 61.914924621582]}, "75": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 22.914924621582]}, "76": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -28.085075378418]}, "77": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 40.914924621582]}, "78": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 55.914924621582]}, "79": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -40.085075378418]}, "80": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 19.914924621582]}, "81": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 85.914924621582]}, "82": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 67.914924621582]}, "83": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 49.914924621582]}, "84": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 34.914924621582]}, "85": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -13.085075378418]}, "86": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -10.085075378418]}, "87": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 82.914924621582]}, "88": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 70.914924621582]}, "89": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 85.914924621582]}, "90": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 46.914924621582]}, "91": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -52.085075378418]}, "92": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 19.914924621582]}, "93": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -85.085075378418]}, "94": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 58.914924621582]}, "95": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -88.085075378418]}, "96": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -19.085075378418]}, "97": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -31.085075378418]}, "98": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -88.085075378418]}, "99": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -49.085075378418]}, "100": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -28.085075378418]}, "101": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 55.914924621582]}, "102": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -91.085075378418]}, "103": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -58.085075378418]}, "104": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 76.914924621582]}, "105": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 10.914924621582]}, "106": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -70.085075378418]}, "107": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -1.0850751399994]}, "108": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -76.085075378418]}, "109": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 10.914924621582]}, "110": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 67.914924621582]}, "111": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -67.085075378418]}, "112": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -55.085075378418]}, "113": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 70.914924621582]}, "114": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -4.085075378418]}, "115": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 25.914924621582]}, "116": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, 37.914924621582]}, "117": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -79.085075378418]}, "118": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -25.085075378418]}, "119": {"vr": "DS", "Value": [-94.333344717642, -77.614906291345, -13.085075378418]}}, "00201041": {"0": {"vr": "DS", "Value": [-61.085075378418]}, "1": {"vr": "DS", "Value": [28.914924621582]}, "2": {"vr": "DS", "Value": [-22.085075378418]}, "3": {"vr": "DS", "Value": [-34.085075378418]}, "4": {"vr": "DS", "Value": [-76.085075378418]}, "5": {"vr": "DS", "Value": [-79.085075378418]}, "6": {"vr": "DS", "Value": [43.914924621582]}, "7": {"vr": "DS", "Value": [1.9149248600006]}, "8": {"vr": "DS", "Value": [-43.085075378418]}, "9": {"vr": "DS", "Value": [-43.085075378418]}, "10": {"vr": "DS", "Value": [82.914924621582]}, "11": {"vr": "DS", "Value": [43.914924621582]}, "12": {"vr": "DS", "Value": [4.914924621582]}, "13": {"vr": "DS", "Value": [52.914924621582]}, "14": {"vr": "DS", "Value": [16.914924621582]}, "15": {"vr": "DS", "Value": [-34.085075378418]}, "16": {"vr": "DS", "Value": [-1.0850751399994]}, "17": {"vr": "DS", "Value": [-52.085075378418]}, "18": {"vr": "DS", "Value": [-64.085075378418]}, "19": {"vr": "DS", "Value": [-64.085075378418]}, "20": {"vr": "DS", "Value": [28.914924621582]}, "21": {"vr": "DS", "Value": [-25.085075378418]}, "22": {"vr": "DS", "Value": [-46.085075378418]}, "23": {"vr": "DS", "Value": [-58.085075378418]}, "24": {"vr": "DS", "Value": [22.914924621582]}, "25": {"vr": "DS", "Value": [34.914924621582]}, "26": {"vr": "DS", "Value": [46.914924621582]}, "27": {"vr": "DS", "Value": [-49.085075378418]}, "28": {"vr": "DS", "Value": [64.914924621582]}, "29": {"vr": "DS", "Value": [-16.085075378418]}, "30": {"vr": "DS", "Value": [-31.085075378418]}, "31": {"vr": "DS", "Value": [-91.085075378418]}, "32": {"vr": "DS", "Value": [-19.085075378418]}, "33": {"vr": "DS", "Value": [1.9149248600006]}, "34": {"vr": "DS", "Value": [-82.085075378418]}, "35": {"vr": "DS", "Value": [7.914924621582]}, "36": {"vr": "DS", "Value": [4.914924621582]}, "37": {"vr": "DS", "Value": [-46.085075378418]}, "38": {"vr": "DS", "Value": [-37.085075378418]}, "39": {"vr": "DS", "Value": [-7.085075378418]}, "40": {"vr": "DS", "Value": [31.914924621582]}, "41": {"vr": "DS", "Value": [-67.085075378418]}, "42": {"vr": "DS", "Value": [25.914924621582]}, "43": {"vr": "DS", "Value": [-22.085075378418]}, "44": {"vr": "DS", "Value": [-4.085075378418]}, "45": {"vr": "DS", "Value": [73.914924621582]}, "46": {"vr": "DS", "Value": [79.914924621582]}, "47": {"vr": "DS", "Value": [-73.085075378418]}, "48": {"vr": "DS", "Value": [40.914924621582]}, "49": {"vr": "DS", "Value": [-37.085075378418]}, "50": {"vr": "DS", "Value": [-70.085075378418]}, "51": {"vr": "DS", "Value": [49.914924621582]}, "52": {"vr": "DS", "Value": [13.914924621582]}, "53": {"vr": "DS", "Value": [-73.085075378418]}, "54": {"vr": "DS", "Value": [-55.085075378418]}, "55": {"vr": "DS", "Value": [58.914924621582]}, "56": {"vr": "DS", "Value": [61.914924621582]}, "57": {"vr": "DS", "Value": [-61.085075378418]}, "58": {"vr": "DS", "Value": [31.914924621582]}, "59": {"vr": "DS", "Value": [7.914924621582]}, "60": {"vr": "DS", "Value": [16.914924621582]}, "61": {"vr": "DS", "Value": [64.914924621582]}, "62": {"vr": "DS", "Value": [79.914924621582]}, "63": {"vr": "DS", "Value": [-82.085075378418]}, "64": {"vr": "DS", "Value": [-16.085075378418]}, "65": {"vr": "DS", "Value": [-85.085075378418]}, "66": {"vr": "DS", "Value": [-40.085075378418]}, "67": {"vr": "DS", "Value": [37.914924621582]}, "68": {"vr": "DS", "Value": [-7.085075378418]}, "69": {"vr": "DS", "Value": [73.914924621582]}, "70": {"vr": "DS", "Value": [13.914924621582]}, "71": {"vr": "DS", "Value": [-10.085075378418]}, "72": {"vr": "DS", "Value": [76.914924621582]}, "73": {"vr": "DS", "Value": [52.914924621582]}, "74": {"vr": "DS", "Value": [61.914924621582]}, "75": {"vr": "DS", "Value": [22.914924621582]}, "76": {"vr": "DS", "Value": [-28.085075378418]}, "77": {"vr": "DS", "Value": [40.914924621582]}, "78": {"vr": "DS", "Value": [55.914924621582]}, "79": {"vr": "DS", "Value": [-40.085075378418]}, "80": {"vr": "DS", "Value": [19.914924621582]}, "81": {"vr": "DS", "Value": [85.914924621582]}, "82": {"vr": "DS", "Value": [67.914924621582]}, "83": {"vr": "DS", "Value": [49.914924621582]}, "84": {"vr": "DS", "Value": [34.914924621582]}, "85": {"vr": "DS", "Value": [-13.085075378418]}, "86": {"vr": "DS", "Value": [-10.085075378418]}, "87": {"vr": "DS", "Value": [82.914924621582]}, "88": {"vr": "DS", "Value": [70.914924621582]}, "89": {"vr": "DS", "Value": [85.914924621582]}, "90": {"vr": "DS", "Value": [46.914924621582]}, "91": {"vr": "DS", "Value": [-52.085075378418]}, "92": {"vr": "DS", "Value": [19.914924621582]}, "93": {"vr": "DS", "Value": [-85.085075378418]}, "94": {"vr": "DS", "Value": [58.914924621582]}, "95": {"vr": "DS", "Value": [-88.085075378418]}, "96": {"vr": "DS", "Value": [-19.085075378418]}, "97": {"vr": "DS", "Value": [-31.085075378418]}, "98": {"vr": "DS", "Value": [-88.085075378418]}, "99": {"vr": "DS", "Value": [-49.085075378418]}, "100": {"vr": "DS", "Value": [-28.085075378418]}, "101": {"vr": "DS", "Value": [55.914924621582]}, "102": {"vr": "DS", "Value": [-91.085075378418]}, "103": {"vr": "DS", "Value": [-58.085075378418]}, "104": {"vr": "DS", "Value": [76.914924621582]}, "105": {"vr": "DS", "Value": [10.914924621582]}, "106": {"vr": "DS", "Value": [-70.085075378418]}, "107": {"vr": "DS", "Value": [-1.0850751399994]}, "108": {"vr": "DS", "Value": [-76.085075378418]}, "109": {"vr": "DS", "Value": [10.914924621582]}, "110": {"vr": "DS", "Value": [67.914924621582]}, "111": {"vr": "DS", "Value": [-67.085075378418]}, "112": {"vr": "DS", "Value": [-55.085075378418]}, "113": {"vr": "DS", "Value": [70.914924621582]}, "114": {"vr": "DS", "Value": [-4.085075378418]}, "115": {"vr": "DS", "Value": [25.914924621582]}, "116": {"vr": "DS", "Value": [37.914924621582]}, "117": {"vr": "DS", "Value": [-79.085075378418]}, "118": {"vr": "DS", "Value": [-25.085075378418]}, "119": {"vr": "DS", "Value": [-13.085075378418]}}, "00211103": {"0": {"vr": "DS", "Value": [80387.5]}, "1": {"vr": "DS", "Value": [80387.5]}, "2": {"vr": "DS", "Value": [80387.5]}, "3": {"vr": "DS", "Value": [80387.5]}, "4": {"vr": "DS", "Value": [80387.5]}, "5": {"vr": "DS", "Value": [80390.0]}, "6": {"vr": "DS", "Value": [80387.5]}, "7": {"vr": "DS", "Value": [80387.5]}, "8": {"vr": "DS", "Value": [80387.5]}, "9": {"vr": "DS", "Value": [80387.5]}, "10": {"vr": "DS", "Value": [80390.0]}, "11": {"vr": "DS", "Value": [80387.5]}, "12": {"vr": "DS", "Value": [80387.5]}, "13": {"vr": "DS", "Value": [80387.5]}, "14": {"vr": "DS", "Value": [80390.0]}, "15": {"vr": "DS", "Value": [80387.5]}, "16": {"vr": "DS", "Value": [80387.5]}, "17": {"vr": "DS", "Value": [80387.5]}, "18": {"vr": "DS", "Value": [80387.5]}, "19": {"vr": "DS", "Value": [80390.0]}, "20": {"vr": "DS", "Value": [80387.5]}, "21": {"vr": "DS", "Value": [80387.5]}, "22": {"vr": "DS", "Value": [80387.5]}, "23": {"vr": "DS", "Value": [80387.5]}, "24": {"vr": "DS", "Value": [80387.5]}, "25": {"vr": "DS", "Value": [80387.5]}, "26": {"vr": "DS", "Value": [80387.5]}, "27": {"vr": "DS", "Value": [80387.5]}, "28": {"vr": "DS", "Value": [80387.5]}, "29": {"vr": "DS", "Value": [80387.5]}, "30": {"vr": "DS", "Value": [80387.5]}, "31": {"vr": "DS", "Value": [80387.5]}, "32": {"vr": "DS", "Value": [80387.5]}, "33": {"vr": "DS", "Value": [80387.5]}, "34": {"vr": "DS", "Value": [80387.5]}, "35": {"vr": "DS", "Value": [80390.0]}, "36": {"vr": "DS", "Value": [80387.5]}, "37": {"vr": "DS", "Value": [80387.5]}, "38": {"vr": "DS", "Value": [80387.5]}, "39": {"vr": "DS", "Value": [80387.5]}, "40": {"vr": "DS", "Value": [80390.0]}, "41": {"vr": "DS", "Value": [80387.5]}, "42": {"vr": "DS", "Value": [80387.5]}, "43": {"vr": "DS", "Value": [80387.5]}, "44": {"vr": "DS", "Value": [80387.5]}, "45": {"vr": "DS", "Value": [80387.5]}, "46": {"vr": "DS", "Value": [80387.5]}, "47": {"vr": "DS", "Value": [80387.5]}, "48": {"vr": "DS", "Value": [80387.5]}, "49": {"vr": "DS", "Value": [80387.5]}, "50": {"vr": "DS", "Value": [80387.5]}, "51": {"vr": "DS", "Value": [80387.5]}, "52": {"vr": "DS", "Value": [80387.5]}, "53": {"vr": "DS", "Value": [80387.5]}, "54": {"vr": "DS", "Value": [80387.5]}, "55": {"vr": "DS", "Value": [80390.0]}, "56": {"vr": "DS", "Value": [80387.5]}, "57": {"vr": "DS", "Value": [80387.5]}, "58": {"vr": "DS", "Value": [80390.0]}, "59": {"vr": "DS", "Value": [80387.5]}, "60": {"vr": "DS", "Value": [80387.5]}, "61": {"vr": "DS", "Value": [80390.0]}, "62": {"vr": "DS", "Value": [80390.0]}, "63": {"vr": "DS", "Value": [80387.5]}, "64": {"vr": "DS", "Value": [80390.0]}, "65": {"vr": "DS", "Value": [80387.5]}, "66": {"vr": "DS", "Value": [80387.5]}, "67": {"vr": "DS", "Value": [80387.5]}, "68": {"vr": "DS", "Value": [80390.0]}, "69": {"vr": "DS", "Value": [80387.5]}, "70": {"vr": "DS", "Value": [80387.5]}, "71": {"vr": "DS", "Value": [80387.5]}, "72": {"vr": "DS", "Value": [80387.5]}, "73": {"vr": "DS", "Value": [80387.5]}, "74": {"vr": "DS", "Value": [80387.5]}, "75": {"vr": "DS", "Value": [80387.5]}, "76": {"vr": "DS", "Value": [80387.5]}, "77": {"vr": "DS", "Value": [80390.0]}, "78": {"vr": "DS", "Value": [80390.0]}, "79": {"vr": "DS", "Value": [80390.0]}, "80": {"vr": "DS", "Value": [80387.5]}, "81": {"vr": "DS", "Value": [80387.5]}, "82": {"vr": "DS", "Value": [80387.5]}, "83": {"vr": "DS", "Value": [80387.5]}, "84": {"vr": "DS", "Value": [80387.5]}, "85": {"vr": "DS", "Value": [80387.5]}, "86": {"vr": "DS", "Value": [80387.5]}, "87": {"vr": "DS", "Value": [80387.5]}, "88": {"vr": "DS", "Value": [80387.5]}, "89": {"vr": "DS", "Value": [80387.5]}, "90": {"vr": "DS", "Value": [80387.5]}, "91": {"vr": "DS", "Value": [80387.5]}, "92": {"vr": "DS", "Value": [80387.5]}, "93": {"vr": "DS", "Value": [80387.5]}, "94": {"vr": "DS", "Value": [80387.5]}, "95": {"vr": "DS", "Value": [80390.0]}, "96": {"vr": "DS", "Value": [80387.5]}, "97": {"vr": "DS", "Value": [80390.0]}, "98": {"vr": "DS", "Value": [80387.5]}, "99": {"vr": "DS", "Value": [80387.5]}, "100": {"vr": "DS", "Value": [80387.5]}, "101": {"vr": "DS", "Value": [80390.0]}, "102": {"vr": "DS", "Value": [80387.5]}, "103": {"vr": "DS", "Value": [80387.5]}, "104": {"vr": "DS", "Value": [80387.5]}, "105": {"vr": "DS", "Value": [80387.5]}, "106": {"vr": "DS", "Value": [80387.5]}, "107": {"vr": "DS", "Value": [80387.5]}, "108": {"vr": "DS", "Value": [80387.5]}, "109": {"vr": "DS", "Value": [80387.5]}, "110": {"vr": "DS", "Value": [80387.5]}, "111": {"vr": "DS", "Value": [80387.5]}, "112": {"vr": "DS", "Value": [80390.0]}, "113": {"vr": "DS", "Value": [80387.5]}, "114": {"vr": "DS", "Value": [80387.5]}, "115": {"vr": "DS", "Value": [80387.5]}, "116": {"vr": "DS", "Value": [80387.5]}, "117": {"vr": "DS", "Value": [80387.5]}, "118": {"vr": "DS", "Value": [80387.5]}, "119": {"vr": "DS", "Value": [80387.5]}}, "00211104": {"0": {"vr": "DS", "Value": [1.0125]}, "1": {"vr": "DS", "Value": [0.5325]}, "2": {"vr": "DS", "Value": [0.7575]}, "3": {"vr": "DS", "Value": [0.7375]}, "4": {"vr": "DS", "Value": [0.6625]}, "5": {"vr": "DS", "Value": [0.34]}, "6": {"vr": "DS", "Value": [0.235]}, "7": {"vr": "DS", "Value": [0.8]}, "8": {"vr": "DS", "Value": [0.405]}, "9": {"vr": "DS", "Value": [1.045]}, "10": {"vr": "DS", "Value": [1.2675]}, "11": {"vr": "DS", "Value": [0.875]}, "12": {"vr": "DS", "Value": [0.49]}, "13": {"vr": "DS", "Value": [1.215]}, "14": {"vr": "DS", "Value": [0.51]}, "15": {"vr": "DS", "Value": [0.095]}, "16": {"vr": "DS", "Value": [0.4775]}, "17": {"vr": "DS", "Value": [0.065]}, "18": {"vr": "DS", "Value": [0.0425]}, "19": {"vr": "DS", "Value": [0.6825]}, "20": {"vr": "DS", "Value": [1.1725]}, "21": {"vr": "DS", "Value": [0.435]}, "22": {"vr": "DS", "Value": [0.715]}, "23": {"vr": "DS", "Value": [0.0525]}, "24": {"vr": "DS", "Value": [0.52]}, "25": {"vr": "DS", "Value": [1.1825]}, "26": {"vr": "DS", "Value": [1.205]}, "27": {"vr": "DS", "Value": [1.035]}, "28": {"vr": "DS", "Value": [1.235]}, "29": {"vr": "DS", "Value": [0.1275]}, "30": {"vr": "DS", "Value": [1.065]}, "31": {"vr": "DS", "Value": [0.32]}, "32": {"vr": "DS", "Value": [0.4475]}, "33": {"vr": "DS", "Value": [0.16]}, "34": {"vr": "DS", "Value": [0.65]}, "35": {"vr": "DS", "Value": [0.81]}, "36": {"vr": "DS", "Value": [1.13]}, "37": {"vr": "DS", "Value": [0.075]}, "38": {"vr": "DS", "Value": [0.415]}, "39": {"vr": "DS", "Value": [1.1075]}, "40": {"vr": "DS", "Value": [0.8525]}, "41": {"vr": "DS", "Value": [1.0025]}, "42": {"vr": "DS", "Value": [0.2025]}, "43": {"vr": "DS", "Value": [0.1175]}, "44": {"vr": "DS", "Value": [0.15]}, "45": {"vr": "DS", "Value": [0.9275]}, "46": {"vr": "DS", "Value": [0.9375]}, "47": {"vr": "DS", "Value": [0.35]}, "48": {"vr": "DS", "Value": [1.1925]}, "49": {"vr": "DS", "Value": [1.055]}, "50": {"vr": "DS", "Value": [0.0325]}, "51": {"vr": "DS", "Value": [0.885]}, "52": {"vr": "DS", "Value": [0.8225]}, "53": {"vr": "DS", "Value": [0.9925]}, "54": {"vr": "DS", "Value": [1.0225]}, "55": {"vr": "DS", "Value": [1.225]}, "56": {"vr": "DS", "Value": [0.9075]}, "57": {"vr": "DS", "Value": [0.3725]}, "58": {"vr": "DS", "Value": [0.2125]}, "59": {"vr": "DS", "Value": [0.17]}, "60": {"vr": "DS", "Value": [1.15]}, "61": {"vr": "DS", "Value": [0.595]}, "62": {"vr": "DS", "Value": [0.2975]}, "63": {"vr": "DS", "Value": [0.01]}, "64": {"vr": "DS", "Value": [0.7675]}, "65": {"vr": "DS", "Value": [0.97]}, "66": {"vr": "DS", "Value": [0.085]}, "67": {"vr": "DS", "Value": [0.2225]}, "68": {"vr": "DS", "Value": [0.4675]}, "69": {"vr": "DS", "Value": [0.2875]}, "70": {"vr": "DS", "Value": [0.18]}, "71": {"vr": "DS", "Value": [0.1375]}, "72": {"vr": "DS", "Value": [1.2575]}, "73": {"vr": "DS", "Value": [0.575]}, "74": {"vr": "DS", "Value": [0.265]}, "75": {"vr": "DS", "Value": [1.1625]}, "76": {"vr": "DS", "Value": [0.1075]}, "77": {"vr": "DS", "Value": [0.5525]}, "78": {"vr": "DS", "Value": [0.255]}, "79": {"vr": "DS", "Value": [0.725]}, "80": {"vr": "DS", "Value": [0.8325]}, "81": {"vr": "DS", "Value": [0.3075]}, "82": {"vr": "DS", "Value": [0.2775]}, "83": {"vr": "DS", "Value": [0.245]}, "84": {"vr": "DS", "Value": [0.5425]}, "85": {"vr": "DS", "Value": [1.0975]}, "86": {"vr": "DS", "Value": [0.78]}, "87": {"vr": "DS", "Value": [0.6275]}, "88": {"vr": "DS", "Value": [1.2475]}, "89": {"vr": "DS", "Value": [0.95]}, "90": {"vr": "DS", "Value": [0.5625]}, "91": {"vr": "DS", "Value": [0.705]}, "92": {"vr": "DS", "Value": [0.1925]}, "93": {"vr": "DS", "Value": [0.33]}, "94": {"vr": "DS", "Value": [0.585]}, "95": {"vr": "DS", "Value": [0.64]}, "96": {"vr": "DS", "Value": [1.0875]}, "97": {"vr": "DS", "Value": [0.425]}, "98": {"vr": "DS", "Value": [0.0]}, "99": {"vr": "DS", "Value": [0.3925]}, "100": {"vr": "DS", "Value": [0.7475]}, "101": {"vr": "DS", "Value": [0.895]}, "102": {"vr": "DS", "Value": [0.96]}, "103": {"vr": "DS", "Value": [0.695]}, "104": {"vr": "DS", "Value": [0.6175]}, "105": {"vr": "DS", "Value": [1.14]}, "106": {"vr": "DS", "Value": [0.6725]}, "107": {"vr": "DS", "Value": [1.12]}, "108": {"vr": "DS", "Value": [0.0225]}, "109": {"vr": "DS", "Value": [0.5]}, "110": {"vr": "DS", "Value": [0.9175]}, "111": {"vr": "DS", "Value": [0.3625]}, "112": {"vr": "DS", "Value": [0.3825]}, "113": {"vr": "DS", "Value": [0.605]}, "114": {"vr": "DS", "Value": [0.79]}, "115": {"vr": "DS", "Value": [0.8425]}, "116": {"vr": "DS", "Value": [0.865]}, "117": {"vr": "DS", "Value": [0.98]}, "118": {"vr": "DS", "Value": [1.0775]}, "119": {"vr": "DS", "Value": [0.4575]}}, "00211106": {"0": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_36_1_1_11_1_22"]}, "1": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_51_1_1_41_1_22"]}, "2": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_12_1_1_24_1_22"]}, "3": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_10_1_1_20_1_22"]}, "4": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_3_1_1_6_1_22"]}, "5": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_33_1_1_5_1_22"]}, "6": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_23_1_1_46_1_22"]}, "7": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_16_1_1_32_1_22"]}, "8": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_39_1_1_17_1_22"]}, "9": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_39_1_1_17_1_22"]}, "10": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_60_1_1_59_1_22"]}, "11": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_23_1_1_46_1_22"]}, "12": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_47_1_1_33_1_22"]}, "13": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_55_1_1_49_1_22"]}, "14": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_49_1_1_37_1_22"]}, "15": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_10_1_1_20_1_22"]}, "16": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_46_1_1_31_1_22"]}, "17": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_7_1_1_14_1_22"]}, "18": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_5_1_1_10_1_22"]}, "19": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_5_1_1_10_1_22"]}, "20": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_51_1_1_41_1_22"]}, "21": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_42_1_1_23_1_22"]}, "22": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_8_1_1_16_1_22"]}, "23": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_6_1_1_12_1_22"]}, "24": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_50_1_1_39_1_22"]}, "25": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_52_1_1_43_1_22"]}, "26": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_54_1_1_47_1_22"]}, "27": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_38_1_1_15_1_22"]}, "28": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_57_1_1_53_1_22"]}, "29": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_13_1_1_26_1_22"]}, "30": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_41_1_1_21_1_22"]}, "31": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_31_1_1_1_1_22"]}, "32": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_43_1_1_25_1_22"]}, "33": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_16_1_1_32_1_22"]}, "34": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_2_1_1_4_1_22"]}, "35": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_17_1_1_34_1_22"]}, "36": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_47_1_1_33_1_22"]}, "37": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_8_1_1_16_1_22"]}, "38": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_40_1_1_19_1_22"]}, "39": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_45_1_1_29_1_22"]}, "40": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_21_1_1_42_1_22"]}, "41": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_35_1_1_9_1_22"]}, "42": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_20_1_1_40_1_22"]}, "43": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_12_1_1_24_1_22"]}, "44": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_15_1_1_30_1_22"]}, "45": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_28_1_1_56_1_22"]}, "46": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_29_1_1_58_1_22"]}, "47": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_34_1_1_7_1_22"]}, "48": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_53_1_1_45_1_22"]}, "49": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_40_1_1_19_1_22"]}, "50": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_4_1_1_8_1_22"]}, "51": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_24_1_1_48_1_22"]}, "52": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_18_1_1_36_1_22"]}, "53": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_34_1_1_7_1_22"]}, "54": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_37_1_1_13_1_22"]}, "55": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_56_1_1_51_1_22"]}, "56": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_26_1_1_52_1_22"]}, "57": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_36_1_1_11_1_22"]}, "58": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_21_1_1_42_1_22"]}, "59": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_17_1_1_34_1_22"]}, "60": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_49_1_1_37_1_22"]}, "61": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_57_1_1_53_1_22"]}, "62": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_29_1_1_58_1_22"]}, "63": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_2_1_1_4_1_22"]}, "64": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_13_1_1_26_1_22"]}, "65": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_32_1_1_3_1_22"]}, "66": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_9_1_1_18_1_22"]}, "67": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_22_1_1_44_1_22"]}, "68": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_45_1_1_29_1_22"]}, "69": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_28_1_1_56_1_22"]}, "70": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_18_1_1_36_1_22"]}, "71": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_14_1_1_28_1_22"]}, "72": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_59_1_1_57_1_22"]}, "73": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_55_1_1_49_1_22"]}, "74": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_26_1_1_52_1_22"]}, "75": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_50_1_1_39_1_22"]}, "76": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_11_1_1_22_1_22"]}, "77": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_53_1_1_45_1_22"]}, "78": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_25_1_1_50_1_22"]}, "79": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_9_1_1_18_1_22"]}, "80": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_19_1_1_38_1_22"]}, "81": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_30_1_1_60_1_22"]}, "82": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_27_1_1_54_1_22"]}, "83": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_24_1_1_48_1_22"]}, "84": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_52_1_1_43_1_22"]}, "85": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_44_1_1_27_1_22"]}, "86": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_14_1_1_28_1_22"]}, "87": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_60_1_1_59_1_22"]}, "88": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_58_1_1_55_1_22"]}, "89": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_30_1_1_60_1_22"]}, "90": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_54_1_1_47_1_22"]}, "91": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_7_1_1_14_1_22"]}, "92": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_19_1_1_38_1_22"]}, "93": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_32_1_1_3_1_22"]}, "94": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_56_1_1_51_1_22"]}, "95": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_1_1_1_2_1_22"]}, "96": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_43_1_1_25_1_22"]}, "97": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_41_1_1_21_1_22"]}, "98": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_1_1_1_2_1_22"]}, "99": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_38_1_1_15_1_22"]}, "100": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_11_1_1_22_1_22"]}, "101": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_25_1_1_50_1_22"]}, "102": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_31_1_1_1_1_22"]}, "103": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_6_1_1_12_1_22"]}, "104": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_59_1_1_57_1_22"]}, "105": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_48_1_1_35_1_22"]}, "106": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_4_1_1_8_1_22"]}, "107": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_46_1_1_31_1_22"]}, "108": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_3_1_1_6_1_22"]}, "109": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_48_1_1_35_1_22"]}, "110": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_27_1_1_54_1_22"]}, "111": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_35_1_1_9_1_22"]}, "112": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_37_1_1_13_1_22"]}, "113": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_58_1_1_55_1_22"]}, "114": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_15_1_1_30_1_22"]}, "115": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_20_1_1_40_1_22"]}, "116": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_22_1_1_44_1_22"]}, "117": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_33_1_1_5_1_22"]}, "118": {"vr": "LO", "Value": ["X_2_1_1_1_1_1_42_1_1_23_1_22"]}, "119": {"vr": "LO", "Value": ["X_1_1_1_1_1_1_44_1_1_27_1_22"]}}, "0021115B": {"0": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -61.08507538]}, "1": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 28.91492462]}, "2": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -22.08507538]}, "3": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -34.08507538]}, "4": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -76.08507538]}, "5": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -79.08507538]}, "6": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 43.91492462]}, "7": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 1.91492486]}, "8": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -43.08507538]}, "9": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -43.08507538]}, "10": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 82.91492462]}, "11": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 43.91492462]}, "12": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 4.91492462]}, "13": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 52.91492462]}, "14": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 16.91492462]}, "15": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -34.08507538]}, "16": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -1.08507514]}, "17": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -52.08507538]}, "18": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -64.08507538]}, "19": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -64.08507538]}, "20": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 28.91492462]}, "21": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -25.08507538]}, "22": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -46.08507538]}, "23": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -58.08507538]}, "24": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 22.91492462]}, "25": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 34.91492462]}, "26": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 46.91492462]}, "27": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -49.08507538]}, "28": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 64.91492462]}, "29": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -16.08507538]}, "30": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -31.08507538]}, "31": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -91.08507538]}, "32": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -19.08507538]}, "33": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 1.91492486]}, "34": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -82.08507538]}, "35": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 7.91492462]}, "36": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 4.91492462]}, "37": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -46.08507538]}, "38": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -37.08507538]}, "39": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -7.08507538]}, "40": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 31.91492462]}, "41": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -67.08507538]}, "42": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 25.91492462]}, "43": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -22.08507538]}, "44": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -4.08507538]}, "45": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 73.91492462]}, "46": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 79.91492462]}, "47": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -73.08507538]}, "48": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 40.91492462]}, "49": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -37.08507538]}, "50": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -70.08507538]}, "51": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 49.91492462]}, "52": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 13.91492462]}, "53": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -73.08507538]}, "54": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -55.08507538]}, "55": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 58.91492462]}, "56": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 61.91492462]}, "57": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -61.08507538]}, "58": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 31.91492462]}, "59": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 7.91492462]}, "60": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 16.91492462]}, "61": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 64.91492462]}, "62": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 79.91492462]}, "63": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -82.08507538]}, "64": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -16.08507538]}, "65": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -85.08507538]}, "66": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -40.08507538]}, "67": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 37.91492462]}, "68": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -7.08507538]}, "69": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 73.91492462]}, "70": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 13.91492462]}, "71": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -10.08507538]}, "72": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 76.91492462]}, "73": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 52.91492462]}, "74": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 61.91492462]}, "75": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 22.91492462]}, "76": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -28.08507538]}, "77": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 40.91492462]}, "78": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 55.91492462]}, "79": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -40.08507538]}, "80": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 19.91492462]}, "81": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 85.91492462]}, "82": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 67.91492462]}, "83": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 49.91492462]}, "84": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 34.91492462]}, "85": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -13.08507538]}, "86": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -10.08507538]}, "87": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 82.91492462]}, "88": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 70.91492462]}, "89": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 85.91492462]}, "90": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 46.91492462]}, "91": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -52.08507538]}, "92": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 19.91492462]}, "93": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -85.08507538]}, "94": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 58.91492462]}, "95": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -88.08507538]}, "96": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -19.08507538]}, "97": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -31.08507538]}, "98": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -88.08507538]}, "99": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -49.08507538]}, "100": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -28.08507538]}, "101": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 55.91492462]}, "102": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -91.08507538]}, "103": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -58.08507538]}, "104": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 76.91492462]}, "105": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 10.91492462]}, "106": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -70.08507538]}, "107": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -1.08507514]}, "108": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -76.08507538]}, "109": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 10.91492462]}, "110": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 67.91492462]}, "111": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -67.08507538]}, "112": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -55.08507538]}, "113": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 70.91492462]}, "114": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -4.08507538]}, "115": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 25.91492462]}, "116": {"vr": "FD", "Value": [-94.33334472, -77.61490629, 37.91492462]}, "117": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -79.08507538]}, "118": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -25.08507538]}, "119": {"vr": "FD", "Value": [-94.33334472, -77.61490629, -13.08507538]}}, "0021115E": {"0": {"vr": "IS", "Value": [10]}, "1": {"vr": "IS", "Value": [40]}, "2": {"vr": "IS", "Value": [23]}, "3": {"vr": "IS", "Value": [19]}, "4": {"vr": "IS", "Value": [5]}, "5": {"vr": "IS", "Value": [4]}, "6": {"vr": "IS", "Value": [45]}, "7": {"vr": "IS", "Value": [31]}, "8": {"vr": "IS", "Value": [16]}, "9": {"vr": "IS", "Value": [16]}, "10": {"vr": "IS", "Value": [58]}, "11": {"vr": "IS", "Value": [45]}, "12": {"vr": "IS", "Value": [32]}, "13": {"vr": "IS", "Value": [48]}, "14": {"vr": "IS", "Value": [36]}, "15": {"vr": "IS", "Value": [19]}, "16": {"vr": "IS", "Value": [30]}, "17": {"vr": "IS", "Value": [13]}, "18": {"vr": "IS", "Value": [9]}, "19": {"vr": "IS", "Value": [9]}, "20": {"vr": "IS", "Value": [40]}, "21": {"vr": "IS", "Value": [22]}, "22": {"vr": "IS", "Value": [15]}, "23": {"vr": "IS", "Value": [11]}, "24": {"vr": "IS", "Value": [38]}, "25": {"vr": "IS", "Value": [42]}, "26": {"vr": "IS", "Value": [46]}, "27": {"vr": "IS", "Value": [14]}, "28": {"vr": "IS", "Value": [52]}, "29": {"vr": "IS", "Value": [25]}, "30": {"vr": "IS", "Value": [20]}, "31": {"vr": "IS", "Value": [0]}, "32": {"vr": "IS", "Value": [24]}, "33": {"vr": "IS", "Value": [31]}, "34": {"vr": "IS", "Value": [3]}, "35": {"vr": "IS", "Value": [33]}, "36": {"vr": "IS", "Value": [32]}, "37": {"vr": "IS", "Value": [15]}, "38": {"vr": "IS", "Value": [18]}, "39": {"vr": "IS", "Value": [28]}, "40": {"vr": "IS", "Value": [41]}, "41": {"vr": "IS", "Value": [8]}, "42": {"vr": "IS", "Value": [39]}, "43": {"vr": "IS", "Value": [23]}, "44": {"vr": "IS", "Value": [29]}, "45": {"vr": "IS", "Value": [55]}, "46": {"vr": "IS", "Value": [57]}, "47": {"vr": "IS", "Value": [6]}, "48": {"vr": "IS", "Value": [44]}, "49": {"vr": "IS", "Value": [18]}, "50": {"vr": "IS", "Value": [7]}, "51": {"vr": "IS", "Value": [47]}, "52": {"vr": "IS", "Value": [35]}, "53": {"vr": "IS", "Value": [6]}, "54": {"vr": "IS", "Value": [12]}, "55": {"vr": "IS", "Value": [50]}, "56": {"vr": "IS", "Value": [51]}, "57": {"vr": "IS", "Value": [10]}, "58": {"vr": "IS", "Value": [41]}, "59": {"vr": "IS", "Value": [33]}, "60": {"vr": "IS", "Value": [36]}, "61": {"vr": "IS", "Value": [52]}, "62": {"vr": "IS", "Value": [57]}, "63": {"vr": "IS", "Value": [3]}, "64": {"vr": "IS", "Value": [25]}, "65": {"vr": "IS", "Value": [2]}, "66": {"vr": "IS", "Value": [17]}, "67": {"vr": "IS", "Value": [43]}, "68": {"vr": "IS", "Value": [28]}, "69": {"vr": "IS", "Value": [55]}, "70": {"vr": "IS", "Value": [35]}, "71": {"vr": "IS", "Value": [27]}, "72": {"vr": "IS", "Value": [56]}, "73": {"vr": "IS", "Value": [48]}, "74": {"vr": "IS", "Value": [51]}, "75": {"vr": "IS", "Value": [38]}, "76": {"vr": "IS", "Value": [21]}, "77": {"vr": "IS", "Value": [44]}, "78": {"vr": "IS", "Value": [49]}, "79": {"vr": "IS", "Value": [17]}, "80": {"vr": "IS", "Value": [37]}, "81": {"vr": "IS", "Value": [59]}, "82": {"vr": "IS", "Value": [53]}, "83": {"vr": "IS", "Value": [47]}, "84": {"vr": "IS", "Value": [42]}, "85": {"vr": "IS", "Value": [26]}, "86": {"vr": "IS", "Value": [27]}, "87": {"vr": "IS", "Value": [58]}, "88": {"vr": "IS", "Value": [54]}, "89": {"vr": "IS", "Value": [59]}, "90": {"vr": "IS", "Value": [46]}, "91": {"vr": "IS", "Value": [13]}, "92": {"vr": "IS", "Value": [37]}, "93": {"vr": "IS", "Value": [2]}, "94": {"vr": "IS", "Value": [50]}, "95": {"vr": "IS", "Value": [1]}, "96": {"vr": "IS", "Value": [24]}, "97": {"vr": "IS", "Value": [20]}, "98": {"vr": "IS", "Value": [1]}, "99": {"vr": "IS", "Value": [14]}, "100": {"vr": "IS", "Value": [21]}, "101": {"vr": "IS", "Value": [49]}, "102": {"vr": "IS", "Value": [0]}, "103": {"vr": "IS", "Value": [11]}, "104": {"vr": "IS", "Value": [56]}, "105": {"vr": "IS", "Value": [34]}, "106": {"vr": "IS", "Value": [7]}, "107": {"vr": "IS", "Value": [30]}, "108": {"vr": "IS", "Value": [5]}, "109": {"vr": "IS", "Value": [34]}, "110": {"vr": "IS", "Value": [53]}, "111": {"vr": "IS", "Value": [8]}, "112": {"vr": "IS", "Value": [12]}, "113": {"vr": "IS", "Value": [54]}, "114": {"vr": "IS", "Value": [29]}, "115": {"vr": "IS", "Value": [39]}, "116": {"vr": "IS", "Value": [43]}, "117": {"vr": "IS", "Value": [4]}, "118": {"vr": "IS", "Value": [22]}, "119": {"vr": "IS", "Value": [26]}}, "00280107": {"0": {"vr": "US", "Value": [858]}, "1": {"vr": "US", "Value": [874]}, "2": {"vr": "US", "Value": [923]}, "3": {"vr": "US", "Value": [955]}, "4": {"vr": "US", "Value": [1089]}, "5": {"vr": "US", "Value": [1231]}, "6": {"vr": "US", "Value": [873]}, "7": {"vr": "US", "Value": [859]}, "8": {"vr": "US", "Value": [1036]}, "9": {"vr": "US", "Value": [924]}, "10": {"vr": "US", "Value": [34]}, "11": {"vr": "US", "Value": [793]}, "12": {"vr": "US", "Value": [860]}, "13": {"vr": "US", "Value": [710]}, "14": {"vr": "US", "Value": [1025]}, "15": {"vr": "US", "Value": [1135]}, "16": {"vr": "US", "Value": [875]}, "17": {"vr": "US", "Value": [1199]}, "18": {"vr": "US", "Value": [1071]}, "19": {"vr": "US", "Value": [957]}, "20": {"vr": "US", "Value": [801]}, "21": {"vr": "US", "Value": [978]}, "22": {"vr": "US", "Value": [906]}, "23": {"vr": "US", "Value": [1050]}, "24": {"vr": "US", "Value": [906]}, "25": {"vr": "US", "Value": [707]}, "26": {"vr": "US", "Value": [714]}, "27": {"vr": "US", "Value": [917]}, "28": {"vr": "US", "Value": [535]}, "29": {"vr": "US", "Value": [952]}, "30": {"vr": "US", "Value": [1048]}, "31": {"vr": "US", "Value": [1285]}, "32": {"vr": "US", "Value": [990]}, "33": {"vr": "US", "Value": [940]}, "34": {"vr": "US", "Value": [1197]}, "35": {"vr": "US", "Value": [818]}, "36": {"vr": "US", "Value": [775]}, "37": {"vr": "US", "Value": [1038]}, "38": {"vr": "US", "Value": [1086]}, "39": {"vr": "US", "Value": [760]}, "40": {"vr": "US", "Value": [760]}, "41": {"vr": "US", "Value": [980]}, "42": {"vr": "US", "Value": [848]}, "43": {"vr": "US", "Value": [942]}, "44": {"vr": "US", "Value": [873]}, "45": {"vr": "US", "Value": [378]}, "46": {"vr": "US", "Value": [243]}, "47": {"vr": "US", "Value": [1359]}, "48": {"vr": "US", "Value": [680]}, "49": {"vr": "US", "Value": [931]}, "50": {"vr": "US", "Value": [1251]}, "51": {"vr": "US", "Value": [734]}, "52": {"vr": "US", "Value": [836]}, "53": {"vr": "US", "Value": [1384]}, "54": {"vr": "US", "Value": [1089]}, "55": {"vr": "US", "Value": [593]}, "56": {"vr": "US", "Value": [566]}, "57": {"vr": "US", "Value": [908]}, "58": {"vr": "US", "Value": [869]}, "59": {"vr": "US", "Value": [933]}, "60": {"vr": "US", "Value": [953]}, "61": {"vr": "US", "Value": [666]}, "62": {"vr": "US", "Value": [278]}, "63": {"vr": "US", "Value": [1173]}, "64": {"vr": "US", "Value": [862]}, "65": {"vr": "US", "Value": [1141]}, "66": {"vr": "US", "Value": [1058]}, "67": {"vr": "US", "Value": [798]}, "68": {"vr": "US", "Value": [850]}, "69": {"vr": "US", "Value": [490]}, "70": {"vr": "US", "Value": [945]}, "71": {"vr": "US", "Value": [915]}, "72": {"vr": "US", "Value": [323]}, "73": {"vr": "US", "Value": [800]}, "74": {"vr": "US", "Value": [683]}, "75": {"vr": "US", "Value": [806]}, "76": {"vr": "US", "Value": [1045]}, "77": {"vr": "US", "Value": [788]}, "78": {"vr": "US", "Value": [785]}, "79": {"vr": "US", "Value": [952]}, "80": {"vr": "US", "Value": [767]}, "81": {"vr": "US", "Value": [18]}, "82": {"vr": "US", "Value": [597]}, "83": {"vr": "US", "Value": [819]}, "84": {"vr": "US", "Value": [818]}, "85": {"vr": "US", "Value": [889]}, "86": {"vr": "US", "Value": [829]}, "87": {"vr": "US", "Value": [37]}, "88": {"vr": "US", "Value": [481]}, "89": {"vr": "US", "Value": [16]}, "90": {"vr": "US", "Value": [792]}, "91": {"vr": "US", "Value": [1098]}, "92": {"vr": "US", "Value": [852]}, "93": {"vr": "US", "Value": [1142]}, "94": {"vr": "US", "Value": [725]}, "95": {"vr": "US", "Value": [1262]}, "96": {"vr": "US", "Value": [897]}, "97": {"vr": "US", "Value": [1015]}, "98": {"vr": "US", "Value": [1254]}, "99": {"vr": "US", "Value": [984]}, "100": {"vr": "US", "Value": [1001]}, "101": {"vr": "US", "Value": [671]}, "102": {"vr": "US", "Value": [1236]}, "103": {"vr": "US", "Value": [978]}, "104": {"vr": "US", "Value": [423]}, "105": {"vr": "US", "Value": [751]}, "106": {"vr": "US", "Value": [1203]}, "107": {"vr": "US", "Value": [792]}, "108": {"vr": "US", "Value": [1104]}, "109": {"vr": "US", "Value": [821]}, "110": {"vr": "US", "Value": [486]}, "111": {"vr": "US", "Value": [1107]}, "112": {"vr": "US", "Value": [1180]}, "113": {"vr": "US", "Value": [572]}, "114": {"vr": "US", "Value": [797]}, "115": {"vr": "US", "Value": [758]}, "116": {"vr": "US", "Value": [704]}, "117": {"vr": "US", "Value": [1244]}, "118": {"vr": "US", "Value": [949]}, "119": {"vr": "US", "Value": [973]}}, "00281050": {"0": {"vr": "DS", "Value": [527.0]}, "1": {"vr": "DS", "Value": [581.0]}, "2": {"vr": "DS", "Value": [565.0]}, "3": {"vr": "DS", "Value": [549.0]}, "4": {"vr": "DS", "Value": [517.0]}, "5": {"vr": "DS", "Value": [546.0]}, "6": {"vr": "DS", "Value": [534.0]}, "7": {"vr": "DS", "Value": [571.0]}, "8": {"vr": "DS", "Value": [601.0]}, "9": {"vr": "DS", "Value": [565.0]}, "10": {"vr": "DS", "Value": [24.0]}, "11": {"vr": "DS", "Value": [510.0]}, "12": {"vr": "DS", "Value": [599.0]}, "13": {"vr": "DS", "Value": [441.0]}, "14": {"vr": "DS", "Value": [578.0]}, "15": {"vr": "DS", "Value": [588.0]}, "16": {"vr": "DS", "Value": [608.0]}, "17": {"vr": "DS", "Value": [577.0]}, "18": {"vr": "DS", "Value": [573.0]}, "19": {"vr": "DS", "Value": [533.0]}, "20": {"vr": "DS", "Value": [553.0]}, "21": {"vr": "DS", "Value": [598.0]}, "22": {"vr": "DS", "Value": [547.0]}, "23": {"vr": "DS", "Value": [566.0]}, "24": {"vr": "DS", "Value": [558.0]}, "25": {"vr": "DS", "Value": [531.0]}, "26": {"vr": "DS", "Value": [496.0]}, "27": {"vr": "DS", "Value": [539.0]}, "28": {"vr": "DS", "Value": [323.0]}, "29": {"vr": "DS", "Value": [612.0]}, "30": {"vr": "DS", "Value": [555.0]}, "31": {"vr": "DS", "Value": [610.0]}, "32": {"vr": "DS", "Value": [609.0]}, "33": {"vr": "DS", "Value": [602.0]}, "34": {"vr": "DS", "Value": [489.0]}, "35": {"vr": "DS", "Value": [561.0]}, "36": {"vr": "DS", "Value": [567.0]}, "37": {"vr": "DS", "Value": [584.0]}, "38": {"vr": "DS", "Value": [582.0]}, "39": {"vr": "DS", "Value": [581.0]}, "40": {"vr": "DS", "Value": [542.0]}, "41": {"vr": "DS", "Value": [540.0]}, "42": {"vr": "DS", "Value": [547.0]}, "43": {"vr": "DS", "Value": [602.0]}, "44": {"vr": "DS", "Value": [610.0]}, "45": {"vr": "DS", "Value": [308.0]}, "46": {"vr": "DS", "Value": [154.0]}, "47": {"vr": "DS", "Value": [578.0]}, "48": {"vr": "DS", "Value": [517.0]}, "49": {"vr": "DS", "Value": [585.0]}, "50": {"vr": "DS", "Value": [579.0]}, "51": {"vr": "DS", "Value": [479.0]}, "52": {"vr": "DS", "Value": [552.0]}, "53": {"vr": "DS", "Value": [539.0]}, "54": {"vr": "DS", "Value": [537.0]}, "55": {"vr": "DS", "Value": [356.0]}, "56": {"vr": "DS", "Value": [328.0]}, "57": {"vr": "DS", "Value": [564.0]}, "58": {"vr": "DS", "Value": [572.0]}, "59": {"vr": "DS", "Value": [593.0]}, "60": {"vr": "DS", "Value": [547.0]}, "61": {"vr": "DS", "Value": [400.0]}, "62": {"vr": "DS", "Value": [193.0]}, "63": {"vr": "DS", "Value": [547.0]}, "64": {"vr": "DS", "Value": [577.0]}, "65": {"vr": "DS", "Value": [490.0]}, "66": {"vr": "DS", "Value": [614.0]}, "67": {"vr": "DS", "Value": [552.0]}, "68": {"vr": "DS", "Value": [612.0]}, "69": {"vr": "DS", "Value": [395.0]}, "70": {"vr": "DS", "Value": [585.0]}, "71": {"vr": "DS", "Value": [613.0]}, "72": {"vr": "DS", "Value": [251.0]}, "73": {"vr": "DS", "Value": [479.0]}, "74": {"vr": "DS", "Value": [400.0]}, "75": {"vr": "DS", "Value": [527.0]}, "76": {"vr": "DS", "Value": [595.0]}, "77": {"vr": "DS", "Value": [535.0]}, "78": {"vr": "DS", "Value": [444.0]}, "79": {"vr": "DS", "Value": [579.0]}, "80": {"vr": "DS", "Value": [537.0]}, "81": {"vr": "DS", "Value": [9.0]}, "82": {"vr": "DS", "Value": [408.0]}, "83": {"vr": "DS", "Value": [512.0]}, "84": {"vr": "DS", "Value": [560.0]}, "85": {"vr": "DS", "Value": [578.0]}, "86": {"vr": "DS", "Value": [580.0]}, "87": {"vr": "DS", "Value": [25.0]}, "88": {"vr": "DS", "Value": [313.0]}, "89": {"vr": "DS", "Value": [8.0]}, "90": {"vr": "DS", "Value": [524.0]}, "91": {"vr": "DS", "Value": [542.0]}, "92": {"vr": "DS", "Value": [568.0]}, "93": {"vr": "DS", "Value": [555.0]}, "94": {"vr": "DS", "Value": [422.0]}, "95": {"vr": "DS", "Value": [514.0]}, "96": {"vr": "DS", "Value": [573.0]}, "97": {"vr": "DS", "Value": [592.0]}, "98": {"vr": "DS", "Value": [578.0]}, "99": {"vr": "DS", "Value": [578.0]}, "100": {"vr": "DS", "Value": [559.0]}, "101": {"vr": "DS", "Value": [397.0]}, "102": {"vr": "DS", "Value": [548.0]}, "103": {"vr": "DS", "Value": [529.0]}, "104": {"vr": "DS", "Value": [328.0]}, "105": {"vr": "DS", "Value": [555.0]}, "106": {"vr": "DS", "Value": [540.0]}, "107": {"vr": "DS", "Value": [576.0]}, "108": {"vr": "DS", "Value": [565.0]}, "109": {"vr": "DS", "Value": [588.0]}, "110": {"vr": "DS", "Value": [312.0]}, "111": {"vr": "DS", "Value": [580.0]}, "112": {"vr": "DS", "Value": [573.0]}, "113": {"vr": "DS", "Value": [410.0]}, "114": {"vr": "DS", "Value": [579.0]}, "115": {"vr": "DS", "Value": [555.0]}, "116": {"vr": "DS", "Value": [523.0]}, "117": {"vr": "DS", "Value": [497.0]}, "118": {"vr": "DS", "Value": [560.0]}, "119": {"vr": "DS", "Value": [613.0]}}, "00281051": {"0": {"vr": "DS", "Value": [1068.0]}, "1": {"vr": "DS", "Value": [1081.0]}, "2": {"vr": "DS", "Value": [958.0]}, "3": {"vr": "DS", "Value": [932.0]}, "4": {"vr": "DS", "Value": [1054.0]}, "5": {"vr": "DS", "Value": [1099.0]}, "6": {"vr": "DS", "Value": [1075.0]}, "7": {"vr": "DS", "Value": [967.0]}, "8": {"vr": "DS", "Value": [1142.0]}, "9": {"vr": "DS", "Value": [1100.0]}, "10": {"vr": "DS", "Value": [60.0]}, "11": {"vr": "DS", "Value": [1025.0]}, "12": {"vr": "DS", "Value": [1008.0]}, "13": {"vr": "DS", "Value": [916.0]}, "14": {"vr": "DS", "Value": [976.0]}, "15": {"vr": "DS", "Value": [992.0]}, "16": {"vr": "DS", "Value": [1023.0]}, "17": {"vr": "DS", "Value": [1157.0]}, "18": {"vr": "DS", "Value": [1137.0]}, "19": {"vr": "DS", "Value": [1075.0]}, "20": {"vr": "DS", "Value": [1048.0]}, "21": {"vr": "DS", "Value": [1007.0]}, "22": {"vr": "DS", "Value": [1088.0]}, "23": {"vr": "DS", "Value": [1134.0]}, "24": {"vr": "DS", "Value": [945.0]}, "25": {"vr": "DS", "Value": [1048.0]}, "26": {"vr": "DS", "Value": [1004.0]}, "27": {"vr": "DS", "Value": [1084.0]}, "28": {"vr": "DS", "Value": [704.0]}, "29": {"vr": "DS", "Value": [1028.0]}, "30": {"vr": "DS", "Value": [941.0]}, "31": {"vr": "DS", "Value": [1219.0]}, "32": {"vr": "DS", "Value": [1024.0]}, "33": {"vr": "DS", "Value": [1014.0]}, "34": {"vr": "DS", "Value": [1009.0]}, "35": {"vr": "DS", "Value": [952.0]}, "36": {"vr": "DS", "Value": [961.0]}, "37": {"vr": "DS", "Value": [1142.0]}, "38": {"vr": "DS", "Value": [982.0]}, "39": {"vr": "DS", "Value": [982.0]}, "40": {"vr": "DS", "Value": [1053.0]}, "41": {"vr": "DS", "Value": [1087.0]}, "42": {"vr": "DS", "Value": [927.0]}, "43": {"vr": "DS", "Value": [1014.0]}, "44": {"vr": "DS", "Value": [1026.0]}, "45": {"vr": "DS", "Value": [667.0]}, "46": {"vr": "DS", "Value": [376.0]}, "47": {"vr": "DS", "Value": [1150.0]}, "48": {"vr": "DS", "Value": [1036.0]}, "49": {"vr": "DS", "Value": [1074.0]}, "50": {"vr": "DS", "Value": [1147.0]}, "51": {"vr": "DS", "Value": [979.0]}, "52": {"vr": "DS", "Value": [938.0]}, "53": {"vr": "DS", "Value": [1088.0]}, "54": {"vr": "DS", "Value": [1095.0]}, "55": {"vr": "DS", "Value": [766.0]}, "56": {"vr": "DS", "Value": [721.0]}, "57": {"vr": "DS", "Value": [1127.0]}, "58": {"vr": "DS", "Value": [1097.0]}, "59": {"vr": "DS", "Value": [1000.0]}, "60": {"vr": "DS", "Value": [928.0]}, "61": {"vr": "DS", "Value": [852.0]}, "62": {"vr": "DS", "Value": [445.0]}, "63": {"vr": "DS", "Value": [1102.0]}, "64": {"vr": "DS", "Value": [975.0]}, "65": {"vr": "DS", "Value": [1011.0]}, "66": {"vr": "DS", "Value": [1138.0]}, "67": {"vr": "DS", "Value": [1091.0]}, "68": {"vr": "DS", "Value": [1029.0]}, "69": {"vr": "DS", "Value": [826.0]}, "70": {"vr": "DS", "Value": [987.0]}, "71": {"vr": "DS", "Value": [1030.0]}, "72": {"vr": "DS", "Value": [562.0]}, "73": {"vr": "DS", "Value": [989.0]}, "74": {"vr": "DS", "Value": [859.0]}, "75": {"vr": "DS", "Value": [898.0]}, "76": {"vr": "DS", "Value": [1002.0]}, "77": {"vr": "DS", "Value": [1078.0]}, "78": {"vr": "DS", "Value": [932.0]}, "79": {"vr": "DS", "Value": [1105.0]}, "80": {"vr": "DS", "Value": [913.0]}, "81": {"vr": "DS", "Value": [18.0]}, "82": {"vr": "DS", "Value": [856.0]}, "83": {"vr": "DS", "Value": [1041.0]}, "84": {"vr": "DS", "Value": [1095.0]}, "85": {"vr": "DS", "Value": [977.0]}, "86": {"vr": "DS", "Value": [980.0]}, "87": {"vr": "DS", "Value": [65.0]}, "88": {"vr": "DS", "Value": [678.0]}, "89": {"vr": "DS", "Value": [16.0]}, "90": {"vr": "DS", "Value": [1058.0]}, "91": {"vr": "DS", "Value": [1098.0]}, "92": {"vr": "DS", "Value": [961.0]}, "93": {"vr": "DS", "Value": [1115.0]}, "94": {"vr": "DS", "Value": [893.0]}, "95": {"vr": "DS", "Value": [1055.0]}, "96": {"vr": "DS", "Value": [970.0]}, "97": {"vr": "DS", "Value": [998.0]}, "98": {"vr": "DS", "Value": [1159.0]}, "99": {"vr": "DS", "Value": [1143.0]}, "100": {"vr": "DS", "Value": [947.0]}, "101": {"vr": "DS", "Value": [840.0]}, "102": {"vr": "DS", "Value": [1116.0]}, "103": {"vr": "DS", "Value": [1074.0]}, "104": {"vr": "DS", "Value": [708.0]}, "105": {"vr": "DS", "Value": [943.0]}, "106": {"vr": "DS", "Value": [1086.0]}, "107": {"vr": "DS", "Value": [975.0]}, "108": {"vr": "DS", "Value": [1130.0]}, "109": {"vr": "DS", "Value": [992.0]}, "110": {"vr": "DS", "Value": [680.0]}, "111": {"vr": "DS", "Value": [1149.0]}, "112": {"vr": "DS", "Value": [1155.0]}, "113": {"vr": "DS", "Value": [849.0]}, "114": {"vr": "DS", "Value": [979.0]}, "115": {"vr": "DS", "Value": [1003.0]}, "116": {"vr": "DS", "Value": [1041.0]}, "117": {"vr": "DS", "Value": [1021.0]}, "118": {"vr": "DS", "Value": [950.0]}, "119": {"vr": "DS", "Value": [1030.0]}}, "0051100D": {"0": {"vr": "SH", "Value": ["SP F61.1"]}, "1": {"vr": "SH", "Value": ["SP H28.9"]}, "2": {"vr": "SH", "Value": ["SP F22.1"]}, "3": {"vr": "SH", "Value": ["SP F34.1"]}, "4": {"vr": "SH", "Value": ["SP F76.1"]}, "5": {"vr": "SH", "Value": ["SP F79.1"]}, "6": {"vr": "SH", "Value": ["SP H43.9"]}, "7": {"vr": "SH", "Value": ["SP H1.9"]}, "8": {"vr": "SH", "Value": ["SP F43.1"]}, "9": {"vr": "SH", "Value": ["SP F43.1"]}, "10": {"vr": "SH", "Value": ["SP H82.9"]}, "11": {"vr": "SH", "Value": ["SP H43.9"]}, "12": {"vr": "SH", "Value": ["SP H4.9"]}, "13": {"vr": "SH", "Value": ["SP H52.9"]}, "14": {"vr": "SH", "Value": ["SP H16.9"]}, "15": {"vr": "SH", "Value": ["SP F34.1"]}, "16": {"vr": "SH", "Value": ["SP F1.1"]}, "17": {"vr": "SH", "Value": ["SP F52.1"]}, "18": {"vr": "SH", "Value": ["SP F64.1"]}, "19": {"vr": "SH", "Value": ["SP F64.1"]}, "20": {"vr": "SH", "Value": ["SP H28.9"]}, "21": {"vr": "SH", "Value": ["SP F25.1"]}, "22": {"vr": "SH", "Value": ["SP F46.1"]}, "23": {"vr": "SH", "Value": ["SP F58.1"]}, "24": {"vr": "SH", "Value": ["SP H22.9"]}, "25": {"vr": "SH", "Value": ["SP H34.9"]}, "26": {"vr": "SH", "Value": ["SP H46.9"]}, "27": {"vr": "SH", "Value": ["SP F49.1"]}, "28": {"vr": "SH", "Value": ["SP H64.9"]}, "29": {"vr": "SH", "Value": ["SP F16.1"]}, "30": {"vr": "SH", "Value": ["SP F31.1"]}, "31": {"vr": "SH", "Value": ["SP F91.1"]}, "32": {"vr": "SH", "Value": ["SP F19.1"]}, "33": {"vr": "SH", "Value": ["SP H1.9"]}, "34": {"vr": "SH", "Value": ["SP F82.1"]}, "35": {"vr": "SH", "Value": ["SP H7.9"]}, "36": {"vr": "SH", "Value": ["SP H4.9"]}, "37": {"vr": "SH", "Value": ["SP F46.1"]}, "38": {"vr": "SH", "Value": ["SP F37.1"]}, "39": {"vr": "SH", "Value": ["SP F7.1"]}, "40": {"vr": "SH", "Value": ["SP H31.9"]}, "41": {"vr": "SH", "Value": ["SP F67.1"]}, "42": {"vr": "SH", "Value": ["SP H25.9"]}, "43": {"vr": "SH", "Value": ["SP F22.1"]}, "44": {"vr": "SH", "Value": ["SP F4.1"]}, "45": {"vr": "SH", "Value": ["SP H73.9"]}, "46": {"vr": "SH", "Value": ["SP H79.9"]}, "47": {"vr": "SH", "Value": ["SP F73.1"]}, "48": {"vr": "SH", "Value": ["SP H40.9"]}, "49": {"vr": "SH", "Value": ["SP F37.1"]}, "50": {"vr": "SH", "Value": ["SP F70.1"]}, "51": {"vr": "SH", "Value": ["SP H49.9"]}, "52": {"vr": "SH", "Value": ["SP H13.9"]}, "53": {"vr": "SH", "Value": ["SP F73.1"]}, "54": {"vr": "SH", "Value": ["SP F55.1"]}, "55": {"vr": "SH", "Value": ["SP H58.9"]}, "56": {"vr": "SH", "Value": ["SP H61.9"]}, "57": {"vr": "SH", "Value": ["SP F61.1"]}, "58": {"vr": "SH", "Value": ["SP H31.9"]}, "59": {"vr": "SH", "Value": ["SP H7.9"]}, "60": {"vr": "SH", "Value": ["SP H16.9"]}, "61": {"vr": "SH", "Value": ["SP H64.9"]}, "62": {"vr": "SH", "Value": ["SP H79.9"]}, "63": {"vr": "SH", "Value": ["SP F82.1"]}, "64": {"vr": "SH", "Value": ["SP F16.1"]}, "65": {"vr": "SH", "Value": ["SP F85.1"]}, "66": {"vr": "SH", "Value": ["SP F40.1"]}, "67": {"vr": "SH", "Value": ["SP H37.9"]}, "68": {"vr": "SH", "Value": ["SP F7.1"]}, "69": {"vr": "SH", "Value": ["SP H73.9"]}, "70": {"vr": "SH", "Value": ["SP H13.9"]}, "71": {"vr": "SH", "Value": ["SP F10.1"]}, "72": {"vr": "SH", "Value": ["SP H76.9"]}, "73": {"vr": "SH", "Value": ["SP H52.9"]}, "74": {"vr": "SH", "Value": ["SP H61.9"]}, "75": {"vr": "SH", "Value": ["SP H22.9"]}, "76": {"vr": "SH", "Value": ["SP F28.1"]}, "77": {"vr": "SH", "Value": ["SP H40.9"]}, "78": {"vr": "SH", "Value": ["SP H55.9"]}, "79": {"vr": "SH", "Value": ["SP F40.1"]}, "80": {"vr": "SH", "Value": ["SP H19.9"]}, "81": {"vr": "SH", "Value": ["SP H85.9"]}, "82": {"vr": "SH", "Value": ["SP H67.9"]}, "83": {"vr": "SH", "Value": ["SP H49.9"]}, "84": {"vr": "SH", "Value": ["SP H34.9"]}, "85": {"vr": "SH", "Value": ["SP F13.1"]}, "86": {"vr": "SH", "Value": ["SP F10.1"]}, "87": {"vr": "SH", "Value": ["SP H82.9"]}, "88": {"vr": "SH", "Value": ["SP H70.9"]}, "89": {"vr": "SH", "Value": ["SP H85.9"]}, "90": {"vr": "SH", "Value": ["SP H46.9"]}, "91": {"vr": "SH", "Value": ["SP F52.1"]}, "92": {"vr": "SH", "Value": ["SP H19.9"]}, "93": {"vr": "SH", "Value": ["SP F85.1"]}, "94": {"vr": "SH", "Value": ["SP H58.9"]}, "95": {"vr": "SH", "Value": ["SP F88.1"]}, "96": {"vr": "SH", "Value": ["SP F19.1"]}, "97": {"vr": "SH", "Value": ["SP F31.1"]}, "98": {"vr": "SH", "Value": ["SP F88.1"]}, "99": {"vr": "SH", "Value": ["SP F49.1"]}, "100": {"vr": "SH", "Value": ["SP F28.1"]}, "101": {"vr": "SH", "Value": ["SP H55.9"]}, "102": {"vr": "SH", "Value": ["SP F91.1"]}, "103": {"vr": "SH", "Value": ["SP F58.1"]}, "104": {"vr": "SH", "Value": ["SP H76.9"]}, "105": {"vr": "SH", "Value": ["SP H10.9"]}, "106": {"vr": "SH", "Value": ["SP F70.1"]}, "107": {"vr": "SH", "Value": ["SP F1.1"]}, "108": {"vr": "SH", "Value": ["SP F76.1"]}, "109": {"vr": "SH", "Value": ["SP H10.9"]}, "110": {"vr": "SH", "Value": ["SP H67.9"]}, "111": {"vr": "SH", "Value": ["SP F67.1"]}, "112": {"vr": "SH", "Value": ["SP F55.1"]}, "113": {"vr": "SH", "Value": ["SP H70.9"]}, "114": {"vr": "SH", "Value": ["SP F4.1"]}, "115": {"vr": "SH", "Value": ["SP H25.9"]}, "116": {"vr": "SH", "Value": ["SP H37.9"]}, "117": {"vr": "SH", "Value": ["SP F79.1"]}, "118": {"vr": "SH", "Value": ["SP F25.1"]}, "119": {"vr": "SH", "Value": ["SP F13.1"]}}}


collated_data = {"00211019": {"0": {"vr": "OB", "BinaryLength": 146456}, "1": {"vr": "OB", "BinaryLength": 146456}, "2": {"vr": "OB", "BinaryLength": 146456}, "3": {"vr": "OB", "BinaryLength": 146456}, "4": {"vr": "OB", "BinaryLength": 146456}, "5": {"vr": "OB", "BinaryLength": 146456}, "6": {"vr": "OB", "BinaryLength": 146456}, "7": {"vr": "OB", "BinaryLength": 146456}, "8": {"vr": "OB", "BinaryLength": 146456}, "9": {"vr": "OB", "BinaryLength": 146456}, "10": {"vr": "OB", "BinaryLength": 146456}, "11": {"vr": "OB", "BinaryLength": 146456}, "12": {"vr": "OB", "BinaryLength": 146456}, "13": {"vr": "OB", "BinaryLength": 146456}, "14": {"vr": "OB", "BinaryLength": 146456}, "15": {"vr": "OB", "BinaryLength": 146456}, "16": {"vr": "OB", "BinaryLength": 146456}, "17": {"vr": "OB", "BinaryLength": 146456}, "18": {"vr": "OB", "BinaryLength": 146456}, "19": {"vr": "OB", "BinaryLength": 146456}, "20": {"vr": "OB", "BinaryLength": 146456}, "21": {"vr": "OB", "BinaryLength": 146456}, "22": {"vr": "OB", "BinaryLength": 146456}, "23": {"vr": "OB", "BinaryLength": 146456}, "24": {"vr": "OB", "BinaryLength": 146456}, "25": {"vr": "OB", "BinaryLength": 146456}, "26": {"vr": "OB", "BinaryLength": 146456}, "27": {"vr": "OB", "BinaryLength": 146456}, "28": {"vr": "OB", "BinaryLength": 146456}, "29": {"vr": "OB", "BinaryLength": 146456}, "30": {"vr": "OB", "BinaryLength": 146456}, "31": {"vr": "OB", "BinaryLength": 146456}, "32": {"vr": "OB", "BinaryLength": 146456}, "33": {"vr": "OB", "BinaryLength": 146456}, "34": {"vr": "OB", "BinaryLength": 146456}, "35": {"vr": "OB", "BinaryLength": 146456}, "36": {"vr": "OB", "BinaryLength": 146456}, "37": {"vr": "OB", "BinaryLength": 146456}, "38": {"vr": "OB", "BinaryLength": 146456}, "39": {"vr": "OB", "BinaryLength": 146456}, "40": {"vr": "OB", "BinaryLength": 146456}, "41": {"vr": "OB", "BinaryLength": 146456}, "42": {"vr": "OB", "BinaryLength": 146456}, "43": {"vr": "OB", "BinaryLength": 146456}, "44": {"vr": "OB", "BinaryLength": 146456}, "45": {"vr": "OB", "BinaryLength": 146456}, "46": {"vr": "OB", "BinaryLength": 146456}, "47": {"vr": "OB", "BinaryLength": 146456}, "48": {"vr": "OB", "BinaryLength": 146456}, "49": {"vr": "OB", "BinaryLength": 146456}, "50": {"vr": "OB", "BinaryLength": 146456}, "51": {"vr": "OB", "BinaryLength": 146456}, "52": {"vr": "OB", "BinaryLength": 146456}, "53": {"vr": "OB", "BinaryLength": 146456}, "54": {"vr": "OB", "BinaryLength": 146456}, "55": {"vr": "OB", "BinaryLength": 146456}, "56": {"vr": "OB", "BinaryLength": 146456}, "57": {"vr": "OB", "BinaryLength": 146456}, "58": {"vr": "OB", "BinaryLength": 146456}, "59": {"vr": "OB", "BinaryLength": 146456}, "60": {"vr": "OB", "BinaryLength": 146456}, "61": {"vr": "OB", "BinaryLength": 146456}, "62": {"vr": "OB", "BinaryLength": 146456}, "63": {"vr": "OB", "BinaryLength": 146456}, "64": {"vr": "OB", "BinaryLength": 146456}, "65": {"vr": "OB", "BinaryLength": 146456}, "66": {"vr": "OB", "BinaryLength": 146456}, "67": {"vr": "OB", "BinaryLength": 146456}, "68": {"vr": "OB", "BinaryLength": 146456}, "69": {"vr": "OB", "BinaryLength": 146456}, "70": {"vr": "OB", "BinaryLength": 146456}, "71": {"vr": "OB", "BinaryLength": 146456}, "72": {"vr": "OB", "BinaryLength": 146456}, "73": {"vr": "OB", "BinaryLength": 146456}, "74": {"vr": "OB", "BinaryLength": 146456}, "75": {"vr": "OB", "BinaryLength": 146456}, "76": {"vr": "OB", "BinaryLength": 146456}, "77": {"vr": "OB", "BinaryLength": 146456}, "78": {"vr": "OB", "BinaryLength": 146456}, "79": {"vr": "OB", "BinaryLength": 146456}, "80": {"vr": "OB", "BinaryLength": 146456}, "81": {"vr": "OB", "BinaryLength": 146456}, "82": {"vr": "OB", "BinaryLength": 146456}, "83": {"vr": "OB", "BinaryLength": 146456}, "84": {"vr": "OB", "BinaryLength": 146456}, "85": {"vr": "OB", "BinaryLength": 146456}, "86": {"vr": "OB", "BinaryLength": 146456}, "87": {"vr": "OB", "BinaryLength": 146456}, "88": {"vr": "OB", "BinaryLength": 146456}, "89": {"vr": "OB", "BinaryLength": 146456}, "90": {"vr": "OB", "BinaryLength": 146456}, "91": {"vr": "OB", "BinaryLength": 146456}, "92": {"vr": "OB", "BinaryLength": 146456}, "93": {"vr": "OB", "BinaryLength": 146456}, "94": {"vr": "OB", "BinaryLength": 146456}, "95": {"vr": "OB", "BinaryLength": 146456}, "96": {"vr": "OB", "BinaryLength": 146456}, "97": {"vr": "OB", "BinaryLength": 146456}, "98": {"vr": "OB", "BinaryLength": 146456}, "99": {"vr": "OB", "BinaryLength": 146456}, "100": {"vr": "OB", "BinaryLength": 146456}, "101": {"vr": "OB", "BinaryLength": 146456}, "102": {"vr": "OB", "BinaryLength": 146456}, "103": {"vr": "OB", "BinaryLength": 146456}, "104": {"vr": "OB", "BinaryLength": 146456}, "105": {"vr": "OB", "BinaryLength": 146456}, "106": {"vr": "OB", "BinaryLength": 146456}, "107": {"vr": "OB", "BinaryLength": 146456}, "108": {"vr": "OB", "BinaryLength": 146456}, "109": {"vr": "OB", "BinaryLength": 146456}, "110": {"vr": "OB", "BinaryLength": 146456}, "111": {"vr": "OB", "BinaryLength": 146456}, "112": {"vr": "OB", "BinaryLength": 146456}, "113": {"vr": "OB", "BinaryLength": 146456}, "114": {"vr": "OB", "BinaryLength": 146456}, "115": {"vr": "OB", "BinaryLength": 146456}, "116": {"vr": "OB", "BinaryLength": 146456}, "117": {"vr": "OB", "BinaryLength": 146456}, "118": {"vr": "OB", "BinaryLength": 146456}, "119": {"vr": "OB", "BinaryLength": 146456}}, "00291010": {"0": {"vr": "OB", "BinaryLength": 14636}, "1": {"vr": "OB", "BinaryLength": 14632}, "2": {"vr": "OB", "BinaryLength": 14636}, "3": {"vr": "OB", "BinaryLength": 14636}, "4": {"vr": "OB", "BinaryLength": 14632}, "5": {"vr": "OB", "BinaryLength": 14632}, "6": {"vr": "OB", "BinaryLength": 14632}, "7": {"vr": "OB", "BinaryLength": 14632}, "8": {"vr": "OB", "BinaryLength": 14636}, "9": {"vr": "OB", "BinaryLength": 14636}, "10": {"vr": "OB", "BinaryLength": 14632}, "11": {"vr": "OB", "BinaryLength": 14632}, "12": {"vr": "OB", "BinaryLength": 14632}, "13": {"vr": "OB", "BinaryLength": 14632}, "14": {"vr": "OB", "BinaryLength": 14632}, "15": {"vr": "OB", "BinaryLength": 14636}, "16": {"vr": "OB", "BinaryLength": 14632}, "17": {"vr": "OB", "BinaryLength": 14632}, "18": {"vr": "OB", "BinaryLength": 14632}, "19": {"vr": "OB", "BinaryLength": 14632}, "20": {"vr": "OB", "BinaryLength": 14632}, "21": {"vr": "OB", "BinaryLength": 14636}, "22": {"vr": "OB", "BinaryLength": 14632}, "23": {"vr": "OB", "BinaryLength": 14632}, "24": {"vr": "OB", "BinaryLength": 14632}, "25": {"vr": "OB", "BinaryLength": 14632}, "26": {"vr": "OB", "BinaryLength": 14632}, "27": {"vr": "OB", "BinaryLength": 14636}, "28": {"vr": "OB", "BinaryLength": 14632}, "29": {"vr": "OB", "BinaryLength": 14636}, "30": {"vr": "OB", "BinaryLength": 14636}, "31": {"vr": "OB", "BinaryLength": 14632}, "32": {"vr": "OB", "BinaryLength": 14636}, "33": {"vr": "OB", "BinaryLength": 14632}, "34": {"vr": "OB", "BinaryLength": 14632}, "35": {"vr": "OB", "BinaryLength": 14632}, "36": {"vr": "OB", "BinaryLength": 14632}, "37": {"vr": "OB", "BinaryLength": 14632}, "38": {"vr": "OB", "BinaryLength": 14636}, "39": {"vr": "OB", "BinaryLength": 14632}, "40": {"vr": "OB", "BinaryLength": 14632}, "41": {"vr": "OB", "BinaryLength": 14632}, "42": {"vr": "OB", "BinaryLength": 14632}, "43": {"vr": "OB", "BinaryLength": 14636}, "44": {"vr": "OB", "BinaryLength": 14632}, "45": {"vr": "OB", "BinaryLength": 14632}, "46": {"vr": "OB", "BinaryLength": 14632}, "47": {"vr": "OB", "BinaryLength": 14632}, "48": {"vr": "OB", "BinaryLength": 14632}, "49": {"vr": "OB", "BinaryLength": 14636}, "50": {"vr": "OB", "BinaryLength": 14632}, "51": {"vr": "OB", "BinaryLength": 14632}, "52": {"vr": "OB", "BinaryLength": 14632}, "53": {"vr": "OB", "BinaryLength": 14632}, "54": {"vr": "OB", "BinaryLength": 14636}, "55": {"vr": "OB", "BinaryLength": 14632}, "56": {"vr": "OB", "BinaryLength": 14632}, "57": {"vr": "OB", "BinaryLength": 14636}, "58": {"vr": "OB", "BinaryLength": 14632}, "59": {"vr": "OB", "BinaryLength": 14632}, "60": {"vr": "OB", "BinaryLength": 14632}, "61": {"vr": "OB", "BinaryLength": 14632}, "62": {"vr": "OB", "BinaryLength": 14632}, "63": {"vr": "OB", "BinaryLength": 14632}, "64": {"vr": "OB", "BinaryLength": 14636}, "65": {"vr": "OB", "BinaryLength": 14632}, "66": {"vr": "OB", "BinaryLength": 14632}, "67": {"vr": "OB", "BinaryLength": 14632}, "68": {"vr": "OB", "BinaryLength": 14632}, "69": {"vr": "OB", "BinaryLength": 14632}, "70": {"vr": "OB", "BinaryLength": 14632}, "71": {"vr": "OB", "BinaryLength": 14636}, "72": {"vr": "OB", "BinaryLength": 14632}, "73": {"vr": "OB", "BinaryLength": 14632}, "74": {"vr": "OB", "BinaryLength": 14632}, "75": {"vr": "OB", "BinaryLength": 14632}, "76": {"vr": "OB", "BinaryLength": 14636}, "77": {"vr": "OB", "BinaryLength": 14632}, "78": {"vr": "OB", "BinaryLength": 14632}, "79": {"vr": "OB", "BinaryLength": 14632}, "80": {"vr": "OB", "BinaryLength": 14632}, "81": {"vr": "OB", "BinaryLength": 14632}, "82": {"vr": "OB", "BinaryLength": 14632}, "83": {"vr": "OB", "BinaryLength": 14632}, "84": {"vr": "OB", "BinaryLength": 14632}, "85": {"vr": "OB", "BinaryLength": 14636}, "86": {"vr": "OB", "BinaryLength": 14636}, "87": {"vr": "OB", "BinaryLength": 14632}, "88": {"vr": "OB", "BinaryLength": 14632}, "89": {"vr": "OB", "BinaryLength": 14632}, "90": {"vr": "OB", "BinaryLength": 14632}, "91": {"vr": "OB", "BinaryLength": 14632}, "92": {"vr": "OB", "BinaryLength": 14632}, "93": {"vr": "OB", "BinaryLength": 14632}, "94": {"vr": "OB", "BinaryLength": 14632}, "95": {"vr": "OB", "BinaryLength": 14632}, "96": {"vr": "OB", "BinaryLength": 14636}, "97": {"vr": "OB", "BinaryLength": 14636}, "98": {"vr": "OB", "BinaryLength": 14632}, "99": {"vr": "OB", "BinaryLength": 14636}, "100": {"vr": "OB", "BinaryLength": 14636}, "101": {"vr": "OB", "BinaryLength": 14632}, "102": {"vr": "OB", "BinaryLength": 14632}, "103": {"vr": "OB", "BinaryLength": 14632}, "104": {"vr": "OB", "BinaryLength": 14632}, "105": {"vr": "OB", "BinaryLength": 14632}, "106": {"vr": "OB", "BinaryLength": 14632}, "107": {"vr": "OB", "BinaryLength": 14632}, "108": {"vr": "OB", "BinaryLength": 14632}, "109": {"vr": "OB", "BinaryLength": 14632}, "110": {"vr": "OB", "BinaryLength": 14632}, "111": {"vr": "OB", "BinaryLength": 14632}, "112": {"vr": "OB", "BinaryLength": 14636}, "113": {"vr": "OB", "BinaryLength": 14632}, "114": {"vr": "OB", "BinaryLength": 14632}, "115": {"vr": "OB", "BinaryLength": 14632}, "116": {"vr": "OB", "BinaryLength": 14632}, "117": {"vr": "OB", "BinaryLength": 14632}, "118": {"vr": "OB", "BinaryLength": 14636}, "119": {"vr": "OB", "BinaryLength": 14636}}, "00291020": {"0": {"vr": "OB", "BinaryLength": 164636}, "1": {"vr": "OB", "BinaryLength": 164636}, "2": {"vr": "OB", "BinaryLength": 164636}, "3": {"vr": "OB", "BinaryLength": 164636}, "4": {"vr": "OB", "BinaryLength": 164636}, "5": {"vr": "OB", "BinaryLength": 164636}, "6": {"vr": "OB", "BinaryLength": 164636}, "7": {"vr": "OB", "BinaryLength": 164636}, "8": {"vr": "OB", "BinaryLength": 164636}, "9": {"vr": "OB", "BinaryLength": 164636}, "10": {"vr": "OB", "BinaryLength": 164636}, "11": {"vr": "OB", "BinaryLength": 164636}, "12": {"vr": "OB", "BinaryLength": 164636}, "13": {"vr": "OB", "BinaryLength": 164636}, "14": {"vr": "OB", "BinaryLength": 164636}, "15": {"vr": "OB", "BinaryLength": 164636}, "16": {"vr": "OB", "BinaryLength": 164636}, "17": {"vr": "OB", "BinaryLength": 164636}, "18": {"vr": "OB", "BinaryLength": 164636}, "19": {"vr": "OB", "BinaryLength": 164636}, "20": {"vr": "OB", "BinaryLength": 164636}, "21": {"vr": "OB", "BinaryLength": 164636}, "22": {"vr": "OB", "BinaryLength": 164636}, "23": {"vr": "OB", "BinaryLength": 164636}, "24": {"vr": "OB", "BinaryLength": 164636}, "25": {"vr": "OB", "BinaryLength": 164636}, "26": {"vr": "OB", "BinaryLength": 164636}, "27": {"vr": "OB", "BinaryLength": 164636}, "28": {"vr": "OB", "BinaryLength": 164636}, "29": {"vr": "OB", "BinaryLength": 164636}, "30": {"vr": "OB", "BinaryLength": 164636}, "31": {"vr": "OB", "BinaryLength": 164636}, "32": {"vr": "OB", "BinaryLength": 164636}, "33": {"vr": "OB", "BinaryLength": 164636}, "34": {"vr": "OB", "BinaryLength": 164636}, "35": {"vr": "OB", "BinaryLength": 164636}, "36": {"vr": "OB", "BinaryLength": 164636}, "37": {"vr": "OB", "BinaryLength": 164636}, "38": {"vr": "OB", "BinaryLength": 164636}, "39": {"vr": "OB", "BinaryLength": 164636}, "40": {"vr": "OB", "BinaryLength": 164636}, "41": {"vr": "OB", "BinaryLength": 164636}, "42": {"vr": "OB", "BinaryLength": 164636}, "43": {"vr": "OB", "BinaryLength": 164636}, "44": {"vr": "OB", "BinaryLength": 164636}, "45": {"vr": "OB", "BinaryLength": 164636}, "46": {"vr": "OB", "BinaryLength": 164636}, "47": {"vr": "OB", "BinaryLength": 164636}, "48": {"vr": "OB", "BinaryLength": 164636}, "49": {"vr": "OB", "BinaryLength": 164636}, "50": {"vr": "OB", "BinaryLength": 164636}, "51": {"vr": "OB", "BinaryLength": 164636}, "52": {"vr": "OB", "BinaryLength": 164636}, "53": {"vr": "OB", "BinaryLength": 164636}, "54": {"vr": "OB", "BinaryLength": 164636}, "55": {"vr": "OB", "BinaryLength": 164636}, "56": {"vr": "OB", "BinaryLength": 164636}, "57": {"vr": "OB", "BinaryLength": 164636}, "58": {"vr": "OB", "BinaryLength": 164636}, "59": {"vr": "OB", "BinaryLength": 164636}, "60": {"vr": "OB", "BinaryLength": 164636}, "61": {"vr": "OB", "BinaryLength": 164636}, "62": {"vr": "OB", "BinaryLength": 164636}, "63": {"vr": "OB", "BinaryLength": 164636}, "64": {"vr": "OB", "BinaryLength": 164636}, "65": {"vr": "OB", "BinaryLength": 164636}, "66": {"vr": "OB", "BinaryLength": 164636}, "67": {"vr": "OB", "BinaryLength": 164636}, "68": {"vr": "OB", "BinaryLength": 164636}, "69": {"vr": "OB", "BinaryLength": 164636}, "70": {"vr": "OB", "BinaryLength": 164636}, "71": {"vr": "OB", "BinaryLength": 164636}, "72": {"vr": "OB", "BinaryLength": 164636}, "73": {"vr": "OB", "BinaryLength": 164636}, "74": {"vr": "OB", "BinaryLength": 164636}, "75": {"vr": "OB", "BinaryLength": 164636}, "76": {"vr": "OB", "BinaryLength": 164636}, "77": {"vr": "OB", "BinaryLength": 164636}, "78": {"vr": "OB", "BinaryLength": 164636}, "79": {"vr": "OB", "BinaryLength": 164636}, "80": {"vr": "OB", "BinaryLength": 164636}, "81": {"vr": "OB", "BinaryLength": 164636}, "82": {"vr": "OB", "BinaryLength": 164636}, "83": {"vr": "OB", "BinaryLength": 164636}, "84": {"vr": "OB", "BinaryLength": 164636}, "85": {"vr": "OB", "BinaryLength": 164636}, "86": {"vr": "OB", "BinaryLength": 164636}, "87": {"vr": "OB", "BinaryLength": 164636}, "88": {"vr": "OB", "BinaryLength": 164636}, "89": {"vr": "OB", "BinaryLength": 164636}, "90": {"vr": "OB", "BinaryLength": 164636}, "91": {"vr": "OB", "BinaryLength": 164636}, "92": {"vr": "OB", "BinaryLength": 164636}, "93": {"vr": "OB", "BinaryLength": 164636}, "94": {"vr": "OB", "BinaryLength": 164636}, "95": {"vr": "OB", "BinaryLength": 164636}, "96": {"vr": "OB", "BinaryLength": 164636}, "97": {"vr": "OB", "BinaryLength": 164636}, "98": {"vr": "OB", "BinaryLength": 164636}, "99": {"vr": "OB", "BinaryLength": 164636}, "100": {"vr": "OB", "BinaryLength": 164636}, "101": {"vr": "OB", "BinaryLength": 164636}, "102": {"vr": "OB", "BinaryLength": 164636}, "103": {"vr": "OB", "BinaryLength": 164636}, "104": {"vr": "OB", "BinaryLength": 164636}, "105": {"vr": "OB", "BinaryLength": 164636}, "106": {"vr": "OB", "BinaryLength": 164636}, "107": {"vr": "OB", "BinaryLength": 164636}, "108": {"vr": "OB", "BinaryLength": 164636}, "109": {"vr": "OB", "BinaryLength": 164636}, "110": {"vr": "OB", "BinaryLength": 164636}, "111": {"vr": "OB", "BinaryLength": 164636}, "112": {"vr": "OB", "BinaryLength": 164636}, "113": {"vr": "OB", "BinaryLength": 164636}, "114": {"vr": "OB", "BinaryLength": 164636}, "115": {"vr": "OB", "BinaryLength": 164636}, "116": {"vr": "OB", "BinaryLength": 164636}, "117": {"vr": "OB", "BinaryLength": 164636}, "118": {"vr": "OB", "BinaryLength": 164636}, "119": {"vr": "OB", "BinaryLength": 164636}}, "7FE00010": {"0": {"vr": "OW", "BinaryLength": 10924}, "1": {"vr": "OW", "BinaryLength": 10924}, "2": {"vr": "OW", "BinaryLength": 10924}, "3": {"vr": "OW", "BinaryLength": 10924}, "4": {"vr": "OW", "BinaryLength": 10924}, "5": {"vr": "OW", "BinaryLength": 10924}, "6": {"vr": "OW", "BinaryLength": 10924}, "7": {"vr": "OW", "BinaryLength": 10924}, "8": {"vr": "OW", "BinaryLength": 10924}, "9": {"vr": "OW", "BinaryLength": 10924}, "10": {"vr": "OW", "BinaryLength": 10924}, "11": {"vr": "OW", "BinaryLength": 10924}, "12": {"vr": "OW", "BinaryLength": 10924}, "13": {"vr": "OW", "BinaryLength": 10924}, "14": {"vr": "OW", "BinaryLength": 10924}, "15": {"vr": "OW", "BinaryLength": 10924}, "16": {"vr": "OW", "BinaryLength": 10924}, "17": {"vr": "OW", "BinaryLength": 10924}, "18": {"vr": "OW", "BinaryLength": 10924}, "19": {"vr": "OW", "BinaryLength": 10924}, "20": {"vr": "OW", "BinaryLength": 10924}, "21": {"vr": "OW", "BinaryLength": 10924}, "22": {"vr": "OW", "BinaryLength": 10924}, "23": {"vr": "OW", "BinaryLength": 10924}, "24": {"vr": "OW", "BinaryLength": 10924}, "25": {"vr": "OW", "BinaryLength": 10924}, "26": {"vr": "OW", "BinaryLength": 10924}, "27": {"vr": "OW", "BinaryLength": 10924}, "28": {"vr": "OW", "BinaryLength": 10924}, "29": {"vr": "OW", "BinaryLength": 10924}, "30": {"vr": "OW", "BinaryLength": 10924}, "31": {"vr": "OW", "BinaryLength": 10924}, "32": {"vr": "OW", "BinaryLength": 10924}, "33": {"vr": "OW", "BinaryLength": 10924}, "34": {"vr": "OW", "BinaryLength": 10924}, "35": {"vr": "OW", "BinaryLength": 10924}, "36": {"vr": "OW", "BinaryLength": 10924}, "37": {"vr": "OW", "BinaryLength": 10924}, "38": {"vr": "OW", "BinaryLength": 10924}, "39": {"vr": "OW", "BinaryLength": 10924}, "40": {"vr": "OW", "BinaryLength": 10924}, "41": {"vr": "OW", "BinaryLength": 10924}, "42": {"vr": "OW", "BinaryLength": 10924}, "43": {"vr": "OW", "BinaryLength": 10924}, "44": {"vr": "OW", "BinaryLength": 10924}, "45": {"vr": "OW", "BinaryLength": 10924}, "46": {"vr": "OW", "BinaryLength": 10924}, "47": {"vr": "OW", "BinaryLength": 10924}, "48": {"vr": "OW", "BinaryLength": 10924}, "49": {"vr": "OW", "BinaryLength": 10924}, "50": {"vr": "OW", "BinaryLength": 10924}, "51": {"vr": "OW", "BinaryLength": 10924}, "52": {"vr": "OW", "BinaryLength": 10924}, "53": {"vr": "OW", "BinaryLength": 10924}, "54": {"vr": "OW", "BinaryLength": 10924}, "55": {"vr": "OW", "BinaryLength": 10924}, "56": {"vr": "OW", "BinaryLength": 10924}, "57": {"vr": "OW", "BinaryLength": 10924}, "58": {"vr": "OW", "BinaryLength": 10924}, "59": {"vr": "OW", "BinaryLength": 10924}, "60": {"vr": "OW", "BinaryLength": 10924}, "61": {"vr": "OW", "BinaryLength": 10924}, "62": {"vr": "OW", "BinaryLength": 10924}, "63": {"vr": "OW", "BinaryLength": 10924}, "64": {"vr": "OW", "BinaryLength": 10924}, "65": {"vr": "OW", "BinaryLength": 10924}, "66": {"vr": "OW", "BinaryLength": 10924}, "67": {"vr": "OW", "BinaryLength": 10924}, "68": {"vr": "OW", "BinaryLength": 10924}, "69": {"vr": "OW", "BinaryLength": 10924}, "70": {"vr": "OW", "BinaryLength": 10924}, "71": {"vr": "OW", "BinaryLength": 10924}, "72": {"vr": "OW", "BinaryLength": 10924}, "73": {"vr": "OW", "BinaryLength": 10924}, "74": {"vr": "OW", "BinaryLength": 10924}, "75": {"vr": "OW", "BinaryLength": 10924}, "76": {"vr": "OW", "BinaryLength": 10924}, "77": {"vr": "OW", "BinaryLength": 10924}, "78": {"vr": "OW", "BinaryLength": 10924}, "79": {"vr": "OW", "BinaryLength": 10924}, "80": {"vr": "OW", "BinaryLength": 10924}, "81": {"vr": "OW", "BinaryLength": 10924}, "82": {"vr": "OW", "BinaryLength": 10924}, "83": {"vr": "OW", "BinaryLength": 10924}, "84": {"vr": "OW", "BinaryLength": 10924}, "85": {"vr": "OW", "BinaryLength": 10924}, "86": {"vr": "OW", "BinaryLength": 10924}, "87": {"vr": "OW", "BinaryLength": 10924}, "88": {"vr": "OW", "BinaryLength": 10924}, "89": {"vr": "OW", "BinaryLength": 10924}, "90": {"vr": "OW", "BinaryLength": 10924}, "91": {"vr": "OW", "BinaryLength": 10924}, "92": {"vr": "OW", "BinaryLength": 10924}, "93": {"vr": "OW", "BinaryLength": 10924}, "94": {"vr": "OW", "BinaryLength": 10924}, "95": {"vr": "OW", "BinaryLength": 10924}, "96": {"vr": "OW", "BinaryLength": 10924}, "97": {"vr": "OW", "BinaryLength": 10924}, "98": {"vr": "OW", "BinaryLength": 10924}, "99": {"vr": "OW", "BinaryLength": 10924}, "100": {"vr": "OW", "BinaryLength": 10924}, "101": {"vr": "OW", "BinaryLength": 10924}, "102": {"vr": "OW", "BinaryLength": 10924}, "103": {"vr": "OW", "BinaryLength": 10924}, "104": {"vr": "OW", "BinaryLength": 10924}, "105": {"vr": "OW", "BinaryLength": 10924}, "106": {"vr": "OW", "BinaryLength": 10924}, "107": {"vr": "OW", "BinaryLength": 10924}, "108": {"vr": "OW", "BinaryLength": 10924}, "109": {"vr": "OW", "BinaryLength": 10924}, "110": {"vr": "OW", "BinaryLength": 10924}, "111": {"vr": "OW", "BinaryLength": 10924}, "112": {"vr": "OW", "BinaryLength": 10924}, "113": {"vr": "OW", "BinaryLength": 10924}, "114": {"vr": "OW", "BinaryLength": 10924}, "115": {"vr": "OW", "BinaryLength": 10924}, "116": {"vr": "OW", "BinaryLength": 10924}, "117": {"vr": "OW", "BinaryLength": 10924}, "118": {"vr": "OW", "BinaryLength": 10924}, "119": {"vr": "OW", "BinaryLength": 10924}}}
