"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerProcessor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
const Util_1 = require("./Util");
/**
 * Abstract class for Lambda-driven Eventbridge integrations.
 * This only works because the pattern for the S3 Keys lines up to: lambda-templates/<partner>-lambdasrc.zip
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas-furls.html
 */
class PartnerProcessor extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.partnerEventsFunction = new aws_lambda_1.Function(this, `${props.eventbridgePartner}EventsFunction`, {
            code: aws_lambda_1.Code.fromBucket(aws_s3_1.Bucket.fromBucketName(this, 'AWSFunctionBucket', `eventbridge-inbound-webhook-templates-prod-${aws_cdk_lib_1.Stack.of(this).region}`), `lambda-templates/${props.eventbridgePartner}-lambdasrc.zip`),
            handler: 'app.lambda_handler',
            runtime: aws_lambda_1.Runtime.PYTHON_3_7,
            memorySize: 128,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            reservedConcurrentExecutions: 10,
            environment: {
                GITHUB_WEBHOOK_SECRET_ARN: props.webhookSecret.secretArn,
                EVENT_BUS_NAME: props.eventBus.eventBusName,
            },
        });
        this.invocationAlarm = new Util_1.InvocationAlarm(this, `${props.eventbridgePartner}InvocationAlarm`, {
            threshold: props.lambdaInvocationAlarmThreshold,
            eventFunction: this.partnerEventsFunction,
        });
        const fURL = this.partnerEventsFunction.addFunctionUrl({ authType: aws_lambda_1.FunctionUrlAuthType.NONE });
        props.webhookSecret.grantRead(this.partnerEventsFunction);
        props.eventBus.grantPutEventsTo(this.partnerEventsFunction);
        new aws_cdk_lib_1.CfnOutput(this, `${props.eventbridgePartner}FunctionUrl`, { value: fURL.url });
    }
}
exports.PartnerProcessor = PartnerProcessor;
_a = JSII_RTTI_SYMBOL_1;
PartnerProcessor[_a] = { fqn: "cdk-eventbridge-partner-processors.PartnerProcessor", version: "0.0.118" };
//# sourceMappingURL=data:application/json;base64,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