# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .normalized_alignment import NormalizedAlignment

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AudioOutput(pydantic.BaseModel):
    audio: typing.Optional[str] = pydantic.Field(default=None)
    """
    A generated partial audio chunk, encoded using the selected output_format, by default this
    is MP3 encoded as a base64 string.
    """

    is_final: typing.Optional[bool] = pydantic.Field(alias="isFinal", default=None)
    """
    Indicates if the generation is complete. If set to `True`, `audio` will be null.
    """

    normalized_alignment: typing.Optional[NormalizedAlignment] = pydantic.Field(
        alias="normalizedAlignment", default=None
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
