# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class GenerationConfig(pydantic.BaseModel):
    chunk_length_schedule: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    This is an advanced setting that most users shouldn't need to use. It relates to our
    generation schedule explained [here](https://elevenlabs.io/docs/api-reference/websockets#understanding-how-our-websockets-buffer-text).
    
    Determines the minimum amount of text that needs to be sent and present in our
    buffer before audio starts being generated. This is to maximise the amount of context available to
    the model to improve audio quality, whilst balancing latency of the returned audio chunks.
    
    The default value is: [120, 160, 250, 290].
    
    This means that the first chunk of audio will not be generated until you send text that
    totals at least 120 characters long. The next chunk of audio will only be generated once a
    further 160 characters have been sent. The third audio chunk will be generated after the
    next 250 characters. Then the fourth, and beyond, will be generated in sets of at least 290 characters.
    
    Customize this array to suit your needs. If you want to generate audio more frequently
    to optimise latency, you can reduce the values in the array. Note that setting the values
    too low may result in lower quality audio. Please test and adjust as needed.
    
    Each item should be in the range 50-500.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
