# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .language_response import LanguageResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Model(pydantic.BaseModel):
    model_id: str
    name: typing.Optional[str] = None
    can_be_finetuned: typing.Optional[bool] = None
    can_do_text_to_speech: typing.Optional[bool] = None
    can_do_voice_conversion: typing.Optional[bool] = None
    can_use_style: typing.Optional[bool] = None
    can_use_speaker_boost: typing.Optional[bool] = None
    serves_pro_voices: typing.Optional[bool] = None
    token_cost_factor: typing.Optional[float] = None
    description: typing.Optional[str] = None
    requires_alpha_access: typing.Optional[bool] = None
    max_characters_request_free_user: typing.Optional[int] = None
    max_characters_request_subscribed_user: typing.Optional[int] = None
    languages: typing.Optional[typing.List[LanguageResponse]] = None

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
