import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHcsFederationTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/federation_token#id DataHcsFederationToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the HCS Azure Managed Application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/federation_token#managed_application_name DataHcsFederationToken#managed_application_name}
    */
    readonly managedApplicationName: string;
    /**
    * The name of the Resource Group in which the HCS Azure Managed Application belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/federation_token#resource_group_name DataHcsFederationToken#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/federation_token#timeouts DataHcsFederationToken#timeouts}
    */
    readonly timeouts?: DataHcsFederationTokenTimeouts;
}
export interface DataHcsFederationTokenTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/federation_token#default DataHcsFederationToken#default}
    */
    readonly default?: string;
}
export declare function dataHcsFederationTokenTimeoutsToTerraform(struct?: DataHcsFederationTokenTimeoutsOutputReference | DataHcsFederationTokenTimeouts | cdktf.IResolvable): any;
export declare class DataHcsFederationTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataHcsFederationTokenTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataHcsFederationTokenTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/hcs/d/federation_token hcs_federation_token}
*/
export declare class DataHcsFederationToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hcs_federation_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/hcs/d/federation_token hcs_federation_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHcsFederationTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataHcsFederationTokenConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedApplicationName?;
    get managedApplicationName(): string;
    set managedApplicationName(value: string);
    get managedApplicationNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get token(): string;
    private _timeouts;
    get timeouts(): DataHcsFederationTokenTimeoutsOutputReference;
    putTimeouts(value: DataHcsFederationTokenTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataHcsFederationTokenTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
