import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHcsPlanDefaultsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/plan_defaults#id DataHcsPlanDefaults#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/plan_defaults#timeouts DataHcsPlanDefaults#timeouts}
    */
    readonly timeouts?: DataHcsPlanDefaultsTimeouts;
}
export interface DataHcsPlanDefaultsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hcs/d/plan_defaults#default DataHcsPlanDefaults#default}
    */
    readonly default?: string;
}
export declare function dataHcsPlanDefaultsTimeoutsToTerraform(struct?: DataHcsPlanDefaultsTimeoutsOutputReference | DataHcsPlanDefaultsTimeouts | cdktf.IResolvable): any;
export declare class DataHcsPlanDefaultsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataHcsPlanDefaultsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataHcsPlanDefaultsTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/hcs/d/plan_defaults hcs_plan_defaults}
*/
export declare class DataHcsPlanDefaults extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hcs_plan_defaults";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/hcs/d/plan_defaults hcs_plan_defaults} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHcsPlanDefaultsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataHcsPlanDefaultsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get offer(): string;
    get planName(): string;
    get planVersion(): string;
    get publisher(): string;
    private _timeouts;
    get timeouts(): DataHcsPlanDefaultsTimeoutsOutputReference;
    putTimeouts(value: DataHcsPlanDefaultsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataHcsPlanDefaultsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
