# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AdminSystemSettingArgs', 'AdminSystemSetting']

@pulumi.input_type
class AdminSystemSettingArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The set of arguments for constructing a AdminSystemSetting resource.
        :param pulumi.Input[str] key: Key name for the system setting.
        :param pulumi.Input[str] type: Type of the system setting.
        :param pulumi.Input[str] value: Value for the system setting.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key name for the system setting.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the system setting.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value for the system setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _AdminSystemSettingState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AdminSystemSetting resources.
        :param pulumi.Input[str] key: Key name for the system setting.
        :param pulumi.Input[str] type: Type of the system setting.
        :param pulumi.Input[str] value: Value for the system setting.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key name for the system setting.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the system setting.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the system setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class AdminSystemSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AdminSystemSetting` manages an admin system setting in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        test_setting = duplocloud.AdminSystemSetting("test-setting",
            key="EnableVPN",
            value="true",
            type="Flags")
        ```

        ## Import

        Example: Importing an existing duplo admin setting

         - *KEY_TYPE* is the type of setting key. Replace any occurrences of '/' with '_SLASH_' if they exist within the KEY_TYPE.

         - *KEY* is the key name

        # 

        ```sh
        $ pulumi import duplocloud:index/adminSystemSetting:AdminSystemSetting mySetting *KEY_TYPE*/*KEY*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Key name for the system setting.
        :param pulumi.Input[str] type: Type of the system setting.
        :param pulumi.Input[str] value: Value for the system setting.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdminSystemSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AdminSystemSetting` manages an admin system setting in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        test_setting = duplocloud.AdminSystemSetting("test-setting",
            key="EnableVPN",
            value="true",
            type="Flags")
        ```

        ## Import

        Example: Importing an existing duplo admin setting

         - *KEY_TYPE* is the type of setting key. Replace any occurrences of '/' with '_SLASH_' if they exist within the KEY_TYPE.

         - *KEY* is the key name

        # 

        ```sh
        $ pulumi import duplocloud:index/adminSystemSetting:AdminSystemSetting mySetting *KEY_TYPE*/*KEY*
        ```

        :param str resource_name: The name of the resource.
        :param AdminSystemSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdminSystemSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdminSystemSettingArgs.__new__(AdminSystemSettingArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(AdminSystemSetting, __self__).__init__(
            'duplocloud:index/adminSystemSetting:AdminSystemSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'AdminSystemSetting':
        """
        Get an existing AdminSystemSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Key name for the system setting.
        :param pulumi.Input[str] type: Type of the system setting.
        :param pulumi.Input[str] value: Value for the system setting.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdminSystemSettingState.__new__(_AdminSystemSettingState)

        __props__.__dict__["key"] = key
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return AdminSystemSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Key name for the system setting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the system setting.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        Value for the system setting.
        """
        return pulumi.get(self, "value")

