# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AsgProfileArgs', 'AsgProfile']

@pulumi.input_type
class AsgProfileArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[str],
                 friendly_name: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 can_scale_from_zero: Optional[pulumi.Input[bool]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 is_cluster_autoscaled: Optional[pulumi.Input[bool]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 max_spot_price: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTagArgs']]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]]] = None,
                 use_spot_instances: Optional[pulumi.Input[bool]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]]] = None,
                 wait_for_capacity: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a AsgProfile resource.
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[bool] can_scale_from_zero: Whether or not ASG should leverage duplocloud's scale from 0 feature
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect for the ASG Specify one or more of the following
               metrics.`GroupMinSize`,`GroupMaxSize`,`GroupDesiredCapacity`,`GroupInServiceInstances`,`GroupPendingInstances`,`GroupStandbyInstances`,`GroupTerminatingInstances`,`GroupTotalInstances`,`GroupInServiceCapacity`,`GroupPendingCapacity`,`GroupStandbyCapacity`,`GroupTerminatingCapacity`,`GroupTotalCapacity`,`WarmPoolDesiredCapacity`,`WarmPoolWarmedCapacity`,`WarmPoolPendingCapacity`,`WarmPoolTerminatingCapacity`,`WarmPoolTotalCapacity`,`GroupAndWarmPoolDesiredCapacity`,`GroupAndWarmPoolTotalCapacity`.
        :param pulumi.Input[int] instance_count: The number of instances that should be running in the group.
        :param pulumi.Input[bool] is_cluster_autoscaled: Whether or not to enable cluster autoscaler.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[int] max_instance_count: The maximum size of the Auto Scaling Group.
        :param pulumi.Input[str] max_spot_price: Maximum price to pay for a spot instance in dollars per unit hour.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[int] min_instance_count: The minimum size of the Auto Scaling Group.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[bool] use_spot_instances: Whether or not to use spot instances.
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_for_capacity: Whether or not to wait until ASG instances to be healthy, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] zones: The multi availability zone to launch the asg in, expressed as a number and starting at 0 - Automatic 1 - Zone A 2 -
               Zone B
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if base64_user_data is not None:
            pulumi.set(__self__, "base64_user_data", base64_user_data)
        if can_scale_from_zero is not None:
            pulumi.set(__self__, "can_scale_from_zero", can_scale_from_zero)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if custom_node_labels is not None:
            pulumi.set(__self__, "custom_node_labels", custom_node_labels)
        if enabled_metrics is not None:
            pulumi.set(__self__, "enabled_metrics", enabled_metrics)
        if encrypt_disk is not None:
            pulumi.set(__self__, "encrypt_disk", encrypt_disk)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if is_cluster_autoscaled is not None:
            pulumi.set(__self__, "is_cluster_autoscaled", is_cluster_autoscaled)
        if is_ebs_optimized is not None:
            pulumi.set(__self__, "is_ebs_optimized", is_ebs_optimized)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if keypair_type is not None:
            pulumi.set(__self__, "keypair_type", keypair_type)
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if max_spot_price is not None:
            pulumi.set(__self__, "max_spot_price", max_spot_price)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if minion_tags is not None:
            pulumi.set(__self__, "minion_tags", minion_tags)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if prepend_user_data is not None:
            pulumi.set(__self__, "prepend_user_data", prepend_user_data)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if use_spot_instances is not None:
            pulumi.set(__self__, "use_spot_instances", use_spot_instances)
        if user_account is not None:
            pulumi.set(__self__, "user_account", user_account)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_for_capacity is not None:
            pulumi.set(__self__, "wait_for_capacity", wait_for_capacity)
        if zone is not None:
            warnings.warn("""zone has been deprecated instead use zones""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: zone has been deprecated instead use zones""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[str]:
        """
        The AWS EC2 instance type.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Input[str]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The AMI ID to use.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded EC2 user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @base64_user_data.setter
    def base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_user_data", value)

    @property
    @pulumi.getter(name="canScaleFromZero")
    def can_scale_from_zero(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not ASG should leverage duplocloud's scale from 0 feature
        """
        return pulumi.get(self, "can_scale_from_zero")

    @can_scale_from_zero.setter
    def can_scale_from_zero(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_scale_from_zero", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the cloud provider to launch the host in.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="customNodeLabels")
    def custom_node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specify the labels to attach to the nodes.
        """
        return pulumi.get(self, "custom_node_labels")

    @custom_node_labels.setter
    def custom_node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_node_labels", value)

    @property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of metrics to collect for the ASG Specify one or more of the following
        metrics.`GroupMinSize`,`GroupMaxSize`,`GroupDesiredCapacity`,`GroupInServiceInstances`,`GroupPendingInstances`,`GroupStandbyInstances`,`GroupTerminatingInstances`,`GroupTotalInstances`,`GroupInServiceCapacity`,`GroupPendingCapacity`,`GroupStandbyCapacity`,`GroupTerminatingCapacity`,`GroupTotalCapacity`,`WarmPoolDesiredCapacity`,`WarmPoolWarmedCapacity`,`WarmPoolPendingCapacity`,`WarmPoolTerminatingCapacity`,`WarmPoolTotalCapacity`,`GroupAndWarmPoolDesiredCapacity`,`GroupAndWarmPoolTotalCapacity`.
        """
        return pulumi.get(self, "enabled_metrics")

    @enabled_metrics.setter
    def enabled_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_metrics", value)

    @property
    @pulumi.getter(name="encryptDisk")
    def encrypt_disk(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypt_disk")

    @encrypt_disk.setter
    def encrypt_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_disk", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances that should be running in the group.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="isClusterAutoscaled")
    def is_cluster_autoscaled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable cluster autoscaler.
        """
        return pulumi.get(self, "is_cluster_autoscaled")

    @is_cluster_autoscaled.setter
    def is_cluster_autoscaled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster_autoscaled", value)

    @property
    @pulumi.getter(name="isEbsOptimized")
    def is_ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_ebs_optimized")

    @is_ebs_optimized.setter
    def is_ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ebs_optimized", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="keypairType")
    def keypair_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
        - some operating systems no longer support it)
        """
        return pulumi.get(self, "keypair_type")

    @keypair_type.setter
    def keypair_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keypair_type", value)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="maxSpotPrice")
    def max_spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum price to pay for a spot instance in dollars per unit hour.
        """
        return pulumi.get(self, "max_spot_price")

    @max_spot_price.setter
    def max_spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_spot_price", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]]]:
        """
        Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
        Key and its size as value, size value should be atleast 10*
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]]]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @minion_tags.setter
    def minion_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]]]):
        pulumi.set(self, "minion_tags", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]]]:
        """
        An optional list of custom network interface configurations to use when creating the host.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="prependUserData")
    def prepend_user_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        """
        return pulumi.get(self, "prepend_user_data")

    @prepend_user_data.setter
    def prepend_user_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prepend_user_data", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]]]:
        """
        Specify taints to attach to the nodes, to repel other nodes with different toleration
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="useSpotInstances")
    def use_spot_instances(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use spot instances.
        """
        return pulumi.get(self, "use_spot_instances")

    @use_spot_instances.setter
    def use_spot_instances(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_spot_instances", value)

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @user_account.setter
    def user_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_account", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]]]:
        """
        Block to specify additional or secondary volume beyond the root device
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitForCapacity")
    def wait_for_capacity(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until ASG instances to be healthy, after creation.
        """
        return pulumi.get(self, "wait_for_capacity")

    @wait_for_capacity.setter
    def wait_for_capacity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_capacity", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""zone has been deprecated instead use zones""")
    def zone(self) -> Optional[pulumi.Input[int]]:
        """
        The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The multi availability zone to launch the asg in, expressed as a number and starting at 0 - Automatic 1 - Zone A 2 -
        Zone B
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _AsgProfileState:
    def __init__(__self__, *,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 can_scale_from_zero: Optional[pulumi.Input[bool]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 initial_base64_user_data: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 is_cluster_autoscaled: Optional[pulumi.Input[bool]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 max_spot_price: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 public_ip_address: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTagArgs']]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_spot_instances: Optional[pulumi.Input[bool]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]]] = None,
                 wait_for_capacity: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering AsgProfile resources.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[bool] can_scale_from_zero: Whether or not ASG should leverage duplocloud's scale from 0 feature
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect for the ASG Specify one or more of the following
               metrics.`GroupMinSize`,`GroupMaxSize`,`GroupDesiredCapacity`,`GroupInServiceInstances`,`GroupPendingInstances`,`GroupStandbyInstances`,`GroupTerminatingInstances`,`GroupTotalInstances`,`GroupInServiceCapacity`,`GroupPendingCapacity`,`GroupStandbyCapacity`,`GroupTerminatingCapacity`,`GroupTotalCapacity`,`WarmPoolDesiredCapacity`,`WarmPoolWarmedCapacity`,`WarmPoolPendingCapacity`,`WarmPoolTerminatingCapacity`,`WarmPoolTotalCapacity`,`GroupAndWarmPoolDesiredCapacity`,`GroupAndWarmPoolTotalCapacity`.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] fullname: The full name of the ASG profile.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[int] instance_count: The number of instances that should be running in the group.
        :param pulumi.Input[bool] is_cluster_autoscaled: Whether or not to enable cluster autoscaler.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[int] max_instance_count: The maximum size of the Auto Scaling Group.
        :param pulumi.Input[str] max_spot_price: Maximum price to pay for a spot instance in dollars per unit hour.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[int] min_instance_count: The minimum size of the Auto Scaling Group.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[str] public_ip_address: The primary public IP address assigned to the host.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[bool] use_spot_instances: Whether or not to use spot instances.
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_for_capacity: Whether or not to wait until ASG instances to be healthy, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] zones: The multi availability zone to launch the asg in, expressed as a number and starting at 0 - Automatic 1 - Zone A 2 -
               Zone B
        """
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if base64_user_data is not None:
            pulumi.set(__self__, "base64_user_data", base64_user_data)
        if can_scale_from_zero is not None:
            pulumi.set(__self__, "can_scale_from_zero", can_scale_from_zero)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if custom_node_labels is not None:
            pulumi.set(__self__, "custom_node_labels", custom_node_labels)
        if enabled_metrics is not None:
            pulumi.set(__self__, "enabled_metrics", enabled_metrics)
        if encrypt_disk is not None:
            pulumi.set(__self__, "encrypt_disk", encrypt_disk)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if initial_base64_user_data is not None:
            pulumi.set(__self__, "initial_base64_user_data", initial_base64_user_data)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if is_cluster_autoscaled is not None:
            pulumi.set(__self__, "is_cluster_autoscaled", is_cluster_autoscaled)
        if is_ebs_optimized is not None:
            pulumi.set(__self__, "is_ebs_optimized", is_ebs_optimized)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if keypair_type is not None:
            pulumi.set(__self__, "keypair_type", keypair_type)
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if max_spot_price is not None:
            pulumi.set(__self__, "max_spot_price", max_spot_price)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if minion_tags is not None:
            pulumi.set(__self__, "minion_tags", minion_tags)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if prepend_user_data is not None:
            pulumi.set(__self__, "prepend_user_data", prepend_user_data)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_spot_instances is not None:
            pulumi.set(__self__, "use_spot_instances", use_spot_instances)
        if user_account is not None:
            pulumi.set(__self__, "user_account", user_account)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_for_capacity is not None:
            pulumi.set(__self__, "wait_for_capacity", wait_for_capacity)
        if zone is not None:
            warnings.warn("""zone has been deprecated instead use zones""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: zone has been deprecated instead use zones""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded EC2 user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @base64_user_data.setter
    def base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_user_data", value)

    @property
    @pulumi.getter(name="canScaleFromZero")
    def can_scale_from_zero(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not ASG should leverage duplocloud's scale from 0 feature
        """
        return pulumi.get(self, "can_scale_from_zero")

    @can_scale_from_zero.setter
    def can_scale_from_zero(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_scale_from_zero", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS EC2 instance type.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the cloud provider to launch the host in.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="customNodeLabels")
    def custom_node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specify the labels to attach to the nodes.
        """
        return pulumi.get(self, "custom_node_labels")

    @custom_node_labels.setter
    def custom_node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_node_labels", value)

    @property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of metrics to collect for the ASG Specify one or more of the following
        metrics.`GroupMinSize`,`GroupMaxSize`,`GroupDesiredCapacity`,`GroupInServiceInstances`,`GroupPendingInstances`,`GroupStandbyInstances`,`GroupTerminatingInstances`,`GroupTotalInstances`,`GroupInServiceCapacity`,`GroupPendingCapacity`,`GroupStandbyCapacity`,`GroupTerminatingCapacity`,`GroupTotalCapacity`,`WarmPoolDesiredCapacity`,`WarmPoolWarmedCapacity`,`WarmPoolPendingCapacity`,`WarmPoolTerminatingCapacity`,`WarmPoolTotalCapacity`,`GroupAndWarmPoolDesiredCapacity`,`GroupAndWarmPoolTotalCapacity`.
        """
        return pulumi.get(self, "enabled_metrics")

    @enabled_metrics.setter
    def enabled_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_metrics", value)

    @property
    @pulumi.getter(name="encryptDisk")
    def encrypt_disk(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "encrypt_disk")

    @encrypt_disk.setter
    def encrypt_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_disk", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the ASG profile.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="initialBase64UserData")
    def initial_base64_user_data(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "initial_base64_user_data")

    @initial_base64_user_data.setter
    def initial_base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_base64_user_data", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances that should be running in the group.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="isClusterAutoscaled")
    def is_cluster_autoscaled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable cluster autoscaler.
        """
        return pulumi.get(self, "is_cluster_autoscaled")

    @is_cluster_autoscaled.setter
    def is_cluster_autoscaled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster_autoscaled", value)

    @property
    @pulumi.getter(name="isEbsOptimized")
    def is_ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_ebs_optimized")

    @is_ebs_optimized.setter
    def is_ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ebs_optimized", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="keypairType")
    def keypair_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
        - some operating systems no longer support it)
        """
        return pulumi.get(self, "keypair_type")

    @keypair_type.setter
    def keypair_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keypair_type", value)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="maxSpotPrice")
    def max_spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum price to pay for a spot instance in dollars per unit hour.
        """
        return pulumi.get(self, "max_spot_price")

    @max_spot_price.setter
    def max_spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_spot_price", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]]]:
        """
        Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
        Key and its size as value, size value should be atleast 10*
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]]]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @minion_tags.setter
    def minion_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileMinionTagArgs']]]]):
        pulumi.set(self, "minion_tags", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]]]:
        """
        An optional list of custom network interface configurations to use when creating the host.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="prependUserData")
    def prepend_user_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        """
        return pulumi.get(self, "prepend_user_data")

    @prepend_user_data.setter
    def prepend_user_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prepend_user_data", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The primary public IP address assigned to the host.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]]]:
        """
        Specify taints to attach to the nodes, to repel other nodes with different toleration
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useSpotInstances")
    def use_spot_instances(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use spot instances.
        """
        return pulumi.get(self, "use_spot_instances")

    @use_spot_instances.setter
    def use_spot_instances(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_spot_instances", value)

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @user_account.setter
    def user_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_account", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]]]:
        """
        Block to specify additional or secondary volume beyond the root device
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsgProfileVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitForCapacity")
    def wait_for_capacity(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until ASG instances to be healthy, after creation.
        """
        return pulumi.get(self, "wait_for_capacity")

    @wait_for_capacity.setter
    def wait_for_capacity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_capacity", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""zone has been deprecated instead use zones""")
    def zone(self) -> Optional[pulumi.Input[int]]:
        """
        The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The multi availability zone to launch the asg in, expressed as a number and starting at 0 - Automatic 1 - Zone A 2 -
        Zone B
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "zones", value)


class AsgProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 can_scale_from_zero: Optional[pulumi.Input[bool]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 is_cluster_autoscaled: Optional[pulumi.Input[bool]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 max_spot_price: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMetadataArgs', 'AsgProfileMetadataArgsDict']]]]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMinionTagArgs', 'AsgProfileMinionTagArgsDict']]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileNetworkInterfaceArgs', 'AsgProfileNetworkInterfaceArgsDict']]]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTagArgs', 'AsgProfileTagArgsDict']]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTaintArgs', 'AsgProfileTaintArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_spot_instances: Optional[pulumi.Input[bool]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileVolumeArgs', 'AsgProfileVolumeArgsDict']]]]] = None,
                 wait_for_capacity: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        `AsgProfile` manages a ASG Profile in Duplo.

        ## Import

        Example: Importing an existing AWS ASG

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duploservices-<account_name>-<friendly_name>

        # 

        ```sh
        $ pulumi import duplocloud:index/asgProfile:AsgProfile myAsgProfile *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[bool] can_scale_from_zero: Whether or not ASG should leverage duplocloud's scale from 0 feature
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect for the ASG Specify one or more of the following
               metrics.`GroupMinSize`,`GroupMaxSize`,`GroupDesiredCapacity`,`GroupInServiceInstances`,`GroupPendingInstances`,`GroupStandbyInstances`,`GroupTerminatingInstances`,`GroupTotalInstances`,`GroupInServiceCapacity`,`GroupPendingCapacity`,`GroupStandbyCapacity`,`GroupTerminatingCapacity`,`GroupTotalCapacity`,`WarmPoolDesiredCapacity`,`WarmPoolWarmedCapacity`,`WarmPoolPendingCapacity`,`WarmPoolTerminatingCapacity`,`WarmPoolTotalCapacity`,`GroupAndWarmPoolDesiredCapacity`,`GroupAndWarmPoolTotalCapacity`.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[int] instance_count: The number of instances that should be running in the group.
        :param pulumi.Input[bool] is_cluster_autoscaled: Whether or not to enable cluster autoscaler.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[int] max_instance_count: The maximum size of the Auto Scaling Group.
        :param pulumi.Input[str] max_spot_price: Maximum price to pay for a spot instance in dollars per unit hour.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMetadataArgs', 'AsgProfileMetadataArgsDict']]]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[int] min_instance_count: The minimum size of the Auto Scaling Group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMinionTagArgs', 'AsgProfileMinionTagArgsDict']]]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileNetworkInterfaceArgs', 'AsgProfileNetworkInterfaceArgsDict']]]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTaintArgs', 'AsgProfileTaintArgsDict']]]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[bool] use_spot_instances: Whether or not to use spot instances.
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileVolumeArgs', 'AsgProfileVolumeArgsDict']]]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_for_capacity: Whether or not to wait until ASG instances to be healthy, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] zones: The multi availability zone to launch the asg in, expressed as a number and starting at 0 - Automatic 1 - Zone A 2 -
               Zone B
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AsgProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AsgProfile` manages a ASG Profile in Duplo.

        ## Import

        Example: Importing an existing AWS ASG

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duploservices-<account_name>-<friendly_name>

        # 

        ```sh
        $ pulumi import duplocloud:index/asgProfile:AsgProfile myAsgProfile *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AsgProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AsgProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 can_scale_from_zero: Optional[pulumi.Input[bool]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 encrypt_disk: Optional[pulumi.Input[bool]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 is_cluster_autoscaled: Optional[pulumi.Input[bool]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 max_spot_price: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMetadataArgs', 'AsgProfileMetadataArgsDict']]]]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMinionTagArgs', 'AsgProfileMinionTagArgsDict']]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileNetworkInterfaceArgs', 'AsgProfileNetworkInterfaceArgsDict']]]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTagArgs', 'AsgProfileTagArgsDict']]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTaintArgs', 'AsgProfileTaintArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_spot_instances: Optional[pulumi.Input[bool]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileVolumeArgs', 'AsgProfileVolumeArgsDict']]]]] = None,
                 wait_for_capacity: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AsgProfileArgs.__new__(AsgProfileArgs)

            __props__.__dict__["agent_platform"] = agent_platform
            __props__.__dict__["allocated_public_ip"] = allocated_public_ip
            __props__.__dict__["base64_user_data"] = base64_user_data
            __props__.__dict__["can_scale_from_zero"] = can_scale_from_zero
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["custom_node_labels"] = custom_node_labels
            __props__.__dict__["enabled_metrics"] = enabled_metrics
            __props__.__dict__["encrypt_disk"] = encrypt_disk
            if friendly_name is None and not opts.urn:
                raise TypeError("Missing required property 'friendly_name'")
            __props__.__dict__["friendly_name"] = friendly_name
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["is_cluster_autoscaled"] = is_cluster_autoscaled
            __props__.__dict__["is_ebs_optimized"] = is_ebs_optimized
            __props__.__dict__["is_minion"] = is_minion
            __props__.__dict__["keypair_type"] = keypair_type
            __props__.__dict__["max_instance_count"] = max_instance_count
            __props__.__dict__["max_spot_price"] = max_spot_price
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["min_instance_count"] = min_instance_count
            __props__.__dict__["minion_tags"] = minion_tags
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["prepend_user_data"] = prepend_user_data
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_spot_instances"] = use_spot_instances
            __props__.__dict__["user_account"] = user_account
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["wait_for_capacity"] = wait_for_capacity
            __props__.__dict__["zone"] = zone
            __props__.__dict__["zones"] = zones
            __props__.__dict__["fullname"] = None
            __props__.__dict__["initial_base64_user_data"] = None
            __props__.__dict__["public_ip_address"] = None
        super(AsgProfile, __self__).__init__(
            'duplocloud:index/asgProfile:AsgProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_platform: Optional[pulumi.Input[int]] = None,
            allocated_public_ip: Optional[pulumi.Input[bool]] = None,
            base64_user_data: Optional[pulumi.Input[str]] = None,
            can_scale_from_zero: Optional[pulumi.Input[bool]] = None,
            capacity: Optional[pulumi.Input[str]] = None,
            cloud: Optional[pulumi.Input[int]] = None,
            custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            encrypt_disk: Optional[pulumi.Input[bool]] = None,
            friendly_name: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            initial_base64_user_data: Optional[pulumi.Input[str]] = None,
            instance_count: Optional[pulumi.Input[int]] = None,
            is_cluster_autoscaled: Optional[pulumi.Input[bool]] = None,
            is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
            is_minion: Optional[pulumi.Input[bool]] = None,
            keypair_type: Optional[pulumi.Input[int]] = None,
            max_instance_count: Optional[pulumi.Input[int]] = None,
            max_spot_price: Optional[pulumi.Input[str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMetadataArgs', 'AsgProfileMetadataArgsDict']]]]] = None,
            min_instance_count: Optional[pulumi.Input[int]] = None,
            minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMinionTagArgs', 'AsgProfileMinionTagArgsDict']]]]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileNetworkInterfaceArgs', 'AsgProfileNetworkInterfaceArgsDict']]]]] = None,
            prepend_user_data: Optional[pulumi.Input[bool]] = None,
            public_ip_address: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTagArgs', 'AsgProfileTagArgsDict']]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTaintArgs', 'AsgProfileTaintArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            use_spot_instances: Optional[pulumi.Input[bool]] = None,
            user_account: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileVolumeArgs', 'AsgProfileVolumeArgsDict']]]]] = None,
            wait_for_capacity: Optional[pulumi.Input[bool]] = None,
            zone: Optional[pulumi.Input[int]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'AsgProfile':
        """
        Get an existing AsgProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[bool] can_scale_from_zero: Whether or not ASG should leverage duplocloud's scale from 0 feature
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect for the ASG Specify one or more of the following
               metrics.`GroupMinSize`,`GroupMaxSize`,`GroupDesiredCapacity`,`GroupInServiceInstances`,`GroupPendingInstances`,`GroupStandbyInstances`,`GroupTerminatingInstances`,`GroupTotalInstances`,`GroupInServiceCapacity`,`GroupPendingCapacity`,`GroupStandbyCapacity`,`GroupTerminatingCapacity`,`GroupTotalCapacity`,`WarmPoolDesiredCapacity`,`WarmPoolWarmedCapacity`,`WarmPoolPendingCapacity`,`WarmPoolTerminatingCapacity`,`WarmPoolTotalCapacity`,`GroupAndWarmPoolDesiredCapacity`,`GroupAndWarmPoolTotalCapacity`.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] fullname: The full name of the ASG profile.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[int] instance_count: The number of instances that should be running in the group.
        :param pulumi.Input[bool] is_cluster_autoscaled: Whether or not to enable cluster autoscaler.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[int] max_instance_count: The maximum size of the Auto Scaling Group.
        :param pulumi.Input[str] max_spot_price: Maximum price to pay for a spot instance in dollars per unit hour.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMetadataArgs', 'AsgProfileMetadataArgsDict']]]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[int] min_instance_count: The minimum size of the Auto Scaling Group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileMinionTagArgs', 'AsgProfileMinionTagArgsDict']]]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileNetworkInterfaceArgs', 'AsgProfileNetworkInterfaceArgsDict']]]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[str] public_ip_address: The primary public IP address assigned to the host.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileTaintArgs', 'AsgProfileTaintArgsDict']]]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[bool] use_spot_instances: Whether or not to use spot instances.
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AsgProfileVolumeArgs', 'AsgProfileVolumeArgsDict']]]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_for_capacity: Whether or not to wait until ASG instances to be healthy, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] zones: The multi availability zone to launch the asg in, expressed as a number and starting at 0 - Automatic 1 - Zone A 2 -
               Zone B
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AsgProfileState.__new__(_AsgProfileState)

        __props__.__dict__["agent_platform"] = agent_platform
        __props__.__dict__["allocated_public_ip"] = allocated_public_ip
        __props__.__dict__["base64_user_data"] = base64_user_data
        __props__.__dict__["can_scale_from_zero"] = can_scale_from_zero
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["custom_node_labels"] = custom_node_labels
        __props__.__dict__["enabled_metrics"] = enabled_metrics
        __props__.__dict__["encrypt_disk"] = encrypt_disk
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["initial_base64_user_data"] = initial_base64_user_data
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["is_cluster_autoscaled"] = is_cluster_autoscaled
        __props__.__dict__["is_ebs_optimized"] = is_ebs_optimized
        __props__.__dict__["is_minion"] = is_minion
        __props__.__dict__["keypair_type"] = keypair_type
        __props__.__dict__["max_instance_count"] = max_instance_count
        __props__.__dict__["max_spot_price"] = max_spot_price
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["min_instance_count"] = min_instance_count
        __props__.__dict__["minion_tags"] = minion_tags
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["prepend_user_data"] = prepend_user_data
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["use_spot_instances"] = use_spot_instances
        __props__.__dict__["user_account"] = user_account
        __props__.__dict__["volumes"] = volumes
        __props__.__dict__["wait_for_capacity"] = wait_for_capacity
        __props__.__dict__["zone"] = zone
        __props__.__dict__["zones"] = zones
        return AsgProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the container agent pool that this host is added to.
        """
        return pulumi.get(self, "agent_platform")

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to allocate a public IP.
        """
        return pulumi.get(self, "allocated_public_ip")

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> pulumi.Output[str]:
        """
        Base64 encoded EC2 user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @property
    @pulumi.getter(name="canScaleFromZero")
    def can_scale_from_zero(self) -> pulumi.Output[bool]:
        """
        Whether or not ASG should leverage duplocloud's scale from 0 feature
        """
        return pulumi.get(self, "can_scale_from_zero")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[str]:
        """
        The AWS EC2 instance type.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the cloud provider to launch the host in.
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="customNodeLabels")
    def custom_node_labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specify the labels to attach to the nodes.
        """
        return pulumi.get(self, "custom_node_labels")

    @property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of metrics to collect for the ASG Specify one or more of the following
        metrics.`GroupMinSize`,`GroupMaxSize`,`GroupDesiredCapacity`,`GroupInServiceInstances`,`GroupPendingInstances`,`GroupStandbyInstances`,`GroupTerminatingInstances`,`GroupTotalInstances`,`GroupInServiceCapacity`,`GroupPendingCapacity`,`GroupStandbyCapacity`,`GroupTerminatingCapacity`,`GroupTotalCapacity`,`WarmPoolDesiredCapacity`,`WarmPoolWarmedCapacity`,`WarmPoolPendingCapacity`,`WarmPoolTerminatingCapacity`,`WarmPoolTotalCapacity`,`GroupAndWarmPoolDesiredCapacity`,`GroupAndWarmPoolTotalCapacity`.
        """
        return pulumi.get(self, "enabled_metrics")

    @property
    @pulumi.getter(name="encryptDisk")
    def encrypt_disk(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "encrypt_disk")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[str]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the ASG profile.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The AMI ID to use.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="initialBase64UserData")
    def initial_base64_user_data(self) -> pulumi.Output[str]:
        return pulumi.get(self, "initial_base64_user_data")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[int]:
        """
        The number of instances that should be running in the group.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="isClusterAutoscaled")
    def is_cluster_autoscaled(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable cluster autoscaler.
        """
        return pulumi.get(self, "is_cluster_autoscaled")

    @property
    @pulumi.getter(name="isEbsOptimized")
    def is_ebs_optimized(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "is_ebs_optimized")

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "is_minion")

    @property
    @pulumi.getter(name="keypairType")
    def keypair_type(self) -> pulumi.Output[int]:
        """
        The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
        - some operating systems no longer support it)
        """
        return pulumi.get(self, "keypair_type")

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> pulumi.Output[int]:
        """
        The maximum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="maxSpotPrice")
    def max_spot_price(self) -> pulumi.Output[Optional[str]]:
        """
        Maximum price to pay for a spot instance in dollars per unit hour.
        """
        return pulumi.get(self, "max_spot_price")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.AsgProfileMetadata']]:
        """
        Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
        Key and its size as value, size value should be atleast 10*
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> pulumi.Output[int]:
        """
        The minimum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "min_instance_count")

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> pulumi.Output[Sequence['outputs.AsgProfileMinionTag']]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.AsgProfileNetworkInterface']]:
        """
        An optional list of custom network interface configurations to use when creating the host.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="prependUserData")
    def prepend_user_data(self) -> pulumi.Output[Optional[bool]]:
        """
        Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        """
        return pulumi.get(self, "prepend_user_data")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[str]:
        """
        The primary public IP address assigned to the host.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AsgProfileTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.AsgProfileTaint']]]:
        """
        Specify taints to attach to the nodes, to repel other nodes with different toleration
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="useSpotInstances")
    def use_spot_instances(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to use spot instances.
        """
        return pulumi.get(self, "use_spot_instances")

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> pulumi.Output[str]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.AsgProfileVolume']]:
        """
        Block to specify additional or secondary volume beyond the root device
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="waitForCapacity")
    def wait_for_capacity(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until ASG instances to be healthy, after creation.
        """
        return pulumi.get(self, "wait_for_capacity")

    @property
    @pulumi.getter
    @_utilities.deprecated("""zone has been deprecated instead use zones""")
    def zone(self) -> pulumi.Output[Optional[int]]:
        """
        The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        return pulumi.get(self, "zone")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        The multi availability zone to launch the asg in, expressed as a number and starting at 0 - Automatic 1 - Zone A 2 -
        Zone B
        """
        return pulumi.get(self, "zones")

