# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsApiGatewayIntegrationArgs', 'AwsApiGatewayIntegration']

@pulumi.input_type
class AwsApiGatewayIntegrationArgs:
    def __init__(__self__, *,
                 lambda_function_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsApiGatewayIntegration resource.
        :param pulumi.Input[str] lambda_function_name: Name of the lambda function to be integrated with API gateway.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws api gateway integration will be created in.
        :param pulumi.Input[str] name: The short name of the api gateway.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        pulumi.set(__self__, "lambda_function_name", lambda_function_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="lambdaFunctionName")
    def lambda_function_name(self) -> pulumi.Input[str]:
        """
        Name of the lambda function to be integrated with API gateway.
        """
        return pulumi.get(self, "lambda_function_name")

    @lambda_function_name.setter
    def lambda_function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_function_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws api gateway integration will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the api gateway.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AwsApiGatewayIntegrationState:
    def __init__(__self__, *,
                 fullname: Optional[pulumi.Input[str]] = None,
                 lambda_function_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsApiGatewayIntegration resources.
        :param pulumi.Input[str] fullname: The full name of the api gateway.
        :param pulumi.Input[str] lambda_function_name: Name of the lambda function to be integrated with API gateway.
        :param pulumi.Input[str] name: The short name of the api gateway.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws api gateway integration will be created in.
        """
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if lambda_function_name is not None:
            pulumi.set(__self__, "lambda_function_name", lambda_function_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the api gateway.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="lambdaFunctionName")
    def lambda_function_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the lambda function to be integrated with API gateway.
        """
        return pulumi.get(self, "lambda_function_name")

    @lambda_function_name.setter
    def lambda_function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_function_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the api gateway.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws api gateway integration will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsApiGatewayIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lambda_function_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsApiGatewayIntegration` manages an aws api gateway integration in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        apigw_lambda = duplocloud.AwsApiGatewayIntegration("apigw-lambda",
            tenant_id=duplo_app.tenant_id,
            name="test-api-lambda",
            lambda_function_name="duploservices-dev01-osrm-engine")
        ```

        ## Import

        Example: Importing an existing aws api gateway resource

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duploservices-<account_name>-<friendly_name>-<aws-account-number>

        # 

        ```sh
        $ pulumi import duplocloud:index/awsApiGatewayIntegration:AwsApiGatewayIntegration myApiGateway *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] lambda_function_name: Name of the lambda function to be integrated with API gateway.
        :param pulumi.Input[str] name: The short name of the api gateway.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws api gateway integration will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsApiGatewayIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsApiGatewayIntegration` manages an aws api gateway integration in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        apigw_lambda = duplocloud.AwsApiGatewayIntegration("apigw-lambda",
            tenant_id=duplo_app.tenant_id,
            name="test-api-lambda",
            lambda_function_name="duploservices-dev01-osrm-engine")
        ```

        ## Import

        Example: Importing an existing aws api gateway resource

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duploservices-<account_name>-<friendly_name>-<aws-account-number>

        # 

        ```sh
        $ pulumi import duplocloud:index/awsApiGatewayIntegration:AwsApiGatewayIntegration myApiGateway *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsApiGatewayIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsApiGatewayIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lambda_function_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsApiGatewayIntegrationArgs.__new__(AwsApiGatewayIntegrationArgs)

            if lambda_function_name is None and not opts.urn:
                raise TypeError("Missing required property 'lambda_function_name'")
            __props__.__dict__["lambda_function_name"] = lambda_function_name
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["fullname"] = None
            __props__.__dict__["metadata"] = None
        super(AwsApiGatewayIntegration, __self__).__init__(
            'duplocloud:index/awsApiGatewayIntegration:AwsApiGatewayIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            lambda_function_name: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsApiGatewayIntegration':
        """
        Get an existing AwsApiGatewayIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fullname: The full name of the api gateway.
        :param pulumi.Input[str] lambda_function_name: Name of the lambda function to be integrated with API gateway.
        :param pulumi.Input[str] name: The short name of the api gateway.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws api gateway integration will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsApiGatewayIntegrationState.__new__(_AwsApiGatewayIntegrationState)

        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["lambda_function_name"] = lambda_function_name
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsApiGatewayIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the api gateway.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="lambdaFunctionName")
    def lambda_function_name(self) -> pulumi.Output[str]:
        """
        Name of the lambda function to be integrated with API gateway.
        """
        return pulumi.get(self, "lambda_function_name")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the api gateway.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws api gateway integration will be created in.
        """
        return pulumi.get(self, "tenant_id")

