# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsApigatewayEventArgs', 'AwsApigatewayEvent']

@pulumi.input_type
class AwsApigatewayEventArgs:
    def __init__(__self__, *,
                 api_gateway_id: pulumi.Input[str],
                 integration: pulumi.Input['AwsApigatewayEventIntegrationArgs'],
                 method: pulumi.Input[str],
                 path: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 api_key_required: Optional[pulumi.Input[bool]] = None,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 content_handling: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AwsApigatewayEvent resource.
        :param pulumi.Input[str] api_gateway_id: The ID of the REST API.
        :param pulumi.Input['AwsApigatewayEventIntegrationArgs'] integration: Specify API gateway integration.
        :param pulumi.Input[str] method: HTTP Method.
        :param pulumi.Input[str] path: The path segment of API resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the API gateway event will be created in.
        :param pulumi.Input[bool] api_key_required: Specify if the method requires an API key.
        :param pulumi.Input[str] authorization_type: Type of authorization used for the method. (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
        :param pulumi.Input[str] authorizer_id: Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`.
        :param pulumi.Input[str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[bool] cors: Enable handling of preflight requests.
        """
        pulumi.set(__self__, "api_gateway_id", api_gateway_id)
        pulumi.set(__self__, "integration", integration)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if api_key_required is not None:
            pulumi.set(__self__, "api_key_required", api_key_required)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)

    @property
    @pulumi.getter(name="apiGatewayId")
    def api_gateway_id(self) -> pulumi.Input[str]:
        """
        The ID of the REST API.
        """
        return pulumi.get(self, "api_gateway_id")

    @api_gateway_id.setter
    def api_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_gateway_id", value)

    @property
    @pulumi.getter
    def integration(self) -> pulumi.Input['AwsApigatewayEventIntegrationArgs']:
        """
        Specify API gateway integration.
        """
        return pulumi.get(self, "integration")

    @integration.setter
    def integration(self, value: pulumi.Input['AwsApigatewayEventIntegrationArgs']):
        pulumi.set(self, "integration", value)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[str]:
        """
        HTTP Method.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path segment of API resource.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the API gateway event will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify if the method requires an API key.
        """
        return pulumi.get(self, "api_key_required")

    @api_key_required.setter
    def api_key_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_key_required", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of authorization used for the method. (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional[pulumi.Input[str]]:
        """
        How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        """
        return pulumi.get(self, "content_handling")

    @content_handling.setter
    def content_handling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_handling", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable handling of preflight requests.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cors", value)


@pulumi.input_type
class _AwsApigatewayEventState:
    def __init__(__self__, *,
                 api_gateway_id: Optional[pulumi.Input[str]] = None,
                 api_key_required: Optional[pulumi.Input[bool]] = None,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 content_handling: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 integration: Optional[pulumi.Input['AwsApigatewayEventIntegrationArgs']] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsApigatewayEvent resources.
        :param pulumi.Input[str] api_gateway_id: The ID of the REST API.
        :param pulumi.Input[bool] api_key_required: Specify if the method requires an API key.
        :param pulumi.Input[str] authorization_type: Type of authorization used for the method. (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
        :param pulumi.Input[str] authorizer_id: Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`.
        :param pulumi.Input[str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[bool] cors: Enable handling of preflight requests.
        :param pulumi.Input['AwsApigatewayEventIntegrationArgs'] integration: Specify API gateway integration.
        :param pulumi.Input[str] method: HTTP Method.
        :param pulumi.Input[str] path: The path segment of API resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the API gateway event will be created in.
        """
        if api_gateway_id is not None:
            pulumi.set(__self__, "api_gateway_id", api_gateway_id)
        if api_key_required is not None:
            pulumi.set(__self__, "api_key_required", api_key_required)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if integration is not None:
            pulumi.set(__self__, "integration", integration)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="apiGatewayId")
    def api_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the REST API.
        """
        return pulumi.get(self, "api_gateway_id")

    @api_gateway_id.setter
    def api_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_gateway_id", value)

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify if the method requires an API key.
        """
        return pulumi.get(self, "api_key_required")

    @api_key_required.setter
    def api_key_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_key_required", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of authorization used for the method. (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional[pulumi.Input[str]]:
        """
        How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        """
        return pulumi.get(self, "content_handling")

    @content_handling.setter
    def content_handling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_handling", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable handling of preflight requests.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter
    def integration(self) -> Optional[pulumi.Input['AwsApigatewayEventIntegrationArgs']]:
        """
        Specify API gateway integration.
        """
        return pulumi.get(self, "integration")

    @integration.setter
    def integration(self, value: Optional[pulumi.Input['AwsApigatewayEventIntegrationArgs']]):
        pulumi.set(self, "integration", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP Method.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path segment of API resource.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the API gateway event will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsApigatewayEvent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_gateway_id: Optional[pulumi.Input[str]] = None,
                 api_key_required: Optional[pulumi.Input[bool]] = None,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 content_handling: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 integration: Optional[pulumi.Input[Union['AwsApigatewayEventIntegrationArgs', 'AwsApigatewayEventIntegrationArgsDict']]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsApigatewayEvent` manages an AWS API Gateway events with integration in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        apigateway_event = duplocloud.AwsApigatewayEvent("apigateway_event",
            tenant_id=myapp.tenant_id,
            api_gateway_id="t84tb3skz0",
            method="POST",
            path="/v2/docs",
            cors=True,
            authorization_type="COGNITO_USER_POOLS",
            authorizer_id="gto03x",
            integration={
                "type": "AWS_PROXY",
                "uri": "arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-east-1:1234567890:function:duploservices-dev-valuation-test/invocations",
                "timeout": 29000,
            })
        ```

        ## Import

        Example: Importing an existing AWS API Gateway Event

         - *TENANT_ID* is the tenant GUID

         - *API_GATEWAY_ID* The API Gateway ID.

         - *METHOD* The HTTP Method.

         - *PATH* The API endpoint path.

        ```sh
        $ pulumi import duplocloud:index/awsApigatewayEvent:AwsApigatewayEvent ssm_param *TENANT_ID*/*API_GATEWAY_ID*/*METHOD*/*PATH*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_gateway_id: The ID of the REST API.
        :param pulumi.Input[bool] api_key_required: Specify if the method requires an API key.
        :param pulumi.Input[str] authorization_type: Type of authorization used for the method. (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
        :param pulumi.Input[str] authorizer_id: Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`.
        :param pulumi.Input[str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[bool] cors: Enable handling of preflight requests.
        :param pulumi.Input[Union['AwsApigatewayEventIntegrationArgs', 'AwsApigatewayEventIntegrationArgsDict']] integration: Specify API gateway integration.
        :param pulumi.Input[str] method: HTTP Method.
        :param pulumi.Input[str] path: The path segment of API resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the API gateway event will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsApigatewayEventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsApigatewayEvent` manages an AWS API Gateway events with integration in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        apigateway_event = duplocloud.AwsApigatewayEvent("apigateway_event",
            tenant_id=myapp.tenant_id,
            api_gateway_id="t84tb3skz0",
            method="POST",
            path="/v2/docs",
            cors=True,
            authorization_type="COGNITO_USER_POOLS",
            authorizer_id="gto03x",
            integration={
                "type": "AWS_PROXY",
                "uri": "arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-east-1:1234567890:function:duploservices-dev-valuation-test/invocations",
                "timeout": 29000,
            })
        ```

        ## Import

        Example: Importing an existing AWS API Gateway Event

         - *TENANT_ID* is the tenant GUID

         - *API_GATEWAY_ID* The API Gateway ID.

         - *METHOD* The HTTP Method.

         - *PATH* The API endpoint path.

        ```sh
        $ pulumi import duplocloud:index/awsApigatewayEvent:AwsApigatewayEvent ssm_param *TENANT_ID*/*API_GATEWAY_ID*/*METHOD*/*PATH*
        ```

        :param str resource_name: The name of the resource.
        :param AwsApigatewayEventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsApigatewayEventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_gateway_id: Optional[pulumi.Input[str]] = None,
                 api_key_required: Optional[pulumi.Input[bool]] = None,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 content_handling: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 integration: Optional[pulumi.Input[Union['AwsApigatewayEventIntegrationArgs', 'AwsApigatewayEventIntegrationArgsDict']]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsApigatewayEventArgs.__new__(AwsApigatewayEventArgs)

            if api_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_gateway_id'")
            __props__.__dict__["api_gateway_id"] = api_gateway_id
            __props__.__dict__["api_key_required"] = api_key_required
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["authorizer_id"] = authorizer_id
            __props__.__dict__["content_handling"] = content_handling
            __props__.__dict__["cors"] = cors
            if integration is None and not opts.urn:
                raise TypeError("Missing required property 'integration'")
            __props__.__dict__["integration"] = integration
            if method is None and not opts.urn:
                raise TypeError("Missing required property 'method'")
            __props__.__dict__["method"] = method
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AwsApigatewayEvent, __self__).__init__(
            'duplocloud:index/awsApigatewayEvent:AwsApigatewayEvent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_gateway_id: Optional[pulumi.Input[str]] = None,
            api_key_required: Optional[pulumi.Input[bool]] = None,
            authorization_type: Optional[pulumi.Input[str]] = None,
            authorizer_id: Optional[pulumi.Input[str]] = None,
            content_handling: Optional[pulumi.Input[str]] = None,
            cors: Optional[pulumi.Input[bool]] = None,
            integration: Optional[pulumi.Input[Union['AwsApigatewayEventIntegrationArgs', 'AwsApigatewayEventIntegrationArgsDict']]] = None,
            method: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsApigatewayEvent':
        """
        Get an existing AwsApigatewayEvent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_gateway_id: The ID of the REST API.
        :param pulumi.Input[bool] api_key_required: Specify if the method requires an API key.
        :param pulumi.Input[str] authorization_type: Type of authorization used for the method. (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
        :param pulumi.Input[str] authorizer_id: Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`.
        :param pulumi.Input[str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[bool] cors: Enable handling of preflight requests.
        :param pulumi.Input[Union['AwsApigatewayEventIntegrationArgs', 'AwsApigatewayEventIntegrationArgsDict']] integration: Specify API gateway integration.
        :param pulumi.Input[str] method: HTTP Method.
        :param pulumi.Input[str] path: The path segment of API resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the API gateway event will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsApigatewayEventState.__new__(_AwsApigatewayEventState)

        __props__.__dict__["api_gateway_id"] = api_gateway_id
        __props__.__dict__["api_key_required"] = api_key_required
        __props__.__dict__["authorization_type"] = authorization_type
        __props__.__dict__["authorizer_id"] = authorizer_id
        __props__.__dict__["content_handling"] = content_handling
        __props__.__dict__["cors"] = cors
        __props__.__dict__["integration"] = integration
        __props__.__dict__["method"] = method
        __props__.__dict__["path"] = path
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsApigatewayEvent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiGatewayId")
    def api_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the REST API.
        """
        return pulumi.get(self, "api_gateway_id")

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> pulumi.Output[bool]:
        """
        Specify if the method requires an API key.
        """
        return pulumi.get(self, "api_key_required")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[str]:
        """
        Type of authorization used for the method. (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> pulumi.Output[str]:
        """
        Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> pulumi.Output[str]:
        """
        How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        """
        return pulumi.get(self, "content_handling")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[bool]:
        """
        Enable handling of preflight requests.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def integration(self) -> pulumi.Output['outputs.AwsApigatewayEventIntegration']:
        """
        Specify API gateway integration.
        """
        return pulumi.get(self, "integration")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[str]:
        """
        HTTP Method.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        The path segment of API resource.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the API gateway event will be created in.
        """
        return pulumi.get(self, "tenant_id")

