# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsAppautoscalingPolicyArgs', 'AwsAppautoscalingPolicy']

@pulumi.input_type
class AwsAppautoscalingPolicyArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 scalable_dimension: pulumi.Input[str],
                 service_namespace: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs']] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs']] = None):
        """
        The set of arguments for constructing a AwsAppautoscalingPolicy resource.
        :param pulumi.Input[str] resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling policy will be created in.
        :param pulumi.Input[str] name: The name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[str] policy_type: The policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`.
        :param pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs'] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"`
        :param pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs'] target_tracking_scaling_policy_configuration: A target tracking policy, requires `policy_type = "TargetTrackingScaling"`
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "scalable_dimension", scalable_dimension)
        pulumi.set(__self__, "service_namespace", service_namespace)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if step_scaling_policy_configuration is not None:
            pulumi.set(__self__, "step_scaling_policy_configuration", step_scaling_policy_configuration)
        if target_tracking_scaling_policy_configuration is not None:
            pulumi.set(__self__, "target_tracking_scaling_policy_configuration", target_tracking_scaling_policy_configuration)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The resource type and unique identifier string for the resource associated with the scaling policy.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> pulumi.Input[str]:
        """
        The scalable dimension of the scalable target.
        """
        return pulumi.get(self, "scalable_dimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: pulumi.Input[str]):
        pulumi.set(self, "scalable_dimension", value)

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> pulumi.Input[str]:
        """
        The AWS service namespace of the scalable target.
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_namespace", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws autoscaling policy will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        The policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="stepScalingPolicyConfiguration")
    def step_scaling_policy_configuration(self) -> Optional[pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs']]:
        """
        Step scaling policy configuration, requires `policy_type = "StepScaling"`
        """
        return pulumi.get(self, "step_scaling_policy_configuration")

    @step_scaling_policy_configuration.setter
    def step_scaling_policy_configuration(self, value: Optional[pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "step_scaling_policy_configuration", value)

    @property
    @pulumi.getter(name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(self) -> Optional[pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs']]:
        """
        A target tracking policy, requires `policy_type = "TargetTrackingScaling"`
        """
        return pulumi.get(self, "target_tracking_scaling_policy_configuration")

    @target_tracking_scaling_policy_configuration.setter
    def target_tracking_scaling_policy_configuration(self, value: Optional[pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "target_tracking_scaling_policy_configuration", value)


@pulumi.input_type
class _AwsAppautoscalingPolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 full_resource_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 scalable_dimension: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs']] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs']] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsAppautoscalingPolicy resources.
        :param pulumi.Input[str] full_resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[str] name: The name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[str] policy_type: The policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`.
        :param pulumi.Input[str] resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs'] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"`
        :param pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs'] target_tracking_scaling_policy_configuration: A target tracking policy, requires `policy_type = "TargetTrackingScaling"`
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling policy will be created in.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if full_resource_id is not None:
            pulumi.set(__self__, "full_resource_id", full_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if scalable_dimension is not None:
            pulumi.set(__self__, "scalable_dimension", scalable_dimension)
        if service_namespace is not None:
            pulumi.set(__self__, "service_namespace", service_namespace)
        if step_scaling_policy_configuration is not None:
            pulumi.set(__self__, "step_scaling_policy_configuration", step_scaling_policy_configuration)
        if target_tracking_scaling_policy_configuration is not None:
            pulumi.set(__self__, "target_tracking_scaling_policy_configuration", target_tracking_scaling_policy_configuration)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="fullResourceId")
    def full_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type and unique identifier string for the resource associated with the scaling policy.
        """
        return pulumi.get(self, "full_resource_id")

    @full_resource_id.setter
    def full_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        The policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type and unique identifier string for the resource associated with the scaling policy.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> Optional[pulumi.Input[str]]:
        """
        The scalable dimension of the scalable target.
        """
        return pulumi.get(self, "scalable_dimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scalable_dimension", value)

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS service namespace of the scalable target.
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_namespace", value)

    @property
    @pulumi.getter(name="stepScalingPolicyConfiguration")
    def step_scaling_policy_configuration(self) -> Optional[pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs']]:
        """
        Step scaling policy configuration, requires `policy_type = "StepScaling"`
        """
        return pulumi.get(self, "step_scaling_policy_configuration")

    @step_scaling_policy_configuration.setter
    def step_scaling_policy_configuration(self, value: Optional[pulumi.Input['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "step_scaling_policy_configuration", value)

    @property
    @pulumi.getter(name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(self) -> Optional[pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs']]:
        """
        A target tracking policy, requires `policy_type = "TargetTrackingScaling"`
        """
        return pulumi.get(self, "target_tracking_scaling_policy_configuration")

    @target_tracking_scaling_policy_configuration.setter
    def target_tracking_scaling_policy_configuration(self, value: Optional[pulumi.Input['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "target_tracking_scaling_policy_configuration", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws autoscaling policy will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsAppautoscalingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 scalable_dimension: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input[Union['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgsDict']]] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input[Union['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsAppautoscalingPolicy` manages an aws autoscaling policy in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        #ECS Service Autoscaling
        asg_target = duplocloud.AwsAppautoscalingTarget("asg-target",
            tenant_id=duplo_app.tenant_id,
            max_capacity=4,
            min_capacity=2,
            resource_id="duploservices-duplo-app-ecs-service",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        asg_app_policy = duplocloud.AwsAppautoscalingPolicy("asg-app-policy",
            tenant_id=duplo_app.tenant_id,
            name="avg-cpu-utilization",
            policy_type="TargetTrackingScaling",
            resource_id=asg_target.resource_id,
            scalable_dimension=asg_target.scalable_dimension,
            service_namespace=asg_target.service_namespace,
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "ECSServiceAverageCPUUtilization",
                },
                "target_value": 40,
            })
        ```

        ## Import

        Example: Importing an existing Autoscaling Policy

         - *TENANT_ID* is the tenant GUID

         - *SERVICE_NAMESPACE* The AWS service namespace of the scalable target

         - *SCALABLE_DIMENSION*  The scalable dimension of the scalable target.

         - *RESOURCE_ID* is the duploservices-<account_name>-<resource_name>

         - *POLICY_NAME* is the name of policy

        ```sh
        $ pulumi import duplocloud:index/awsAppautoscalingPolicy:AwsAppautoscalingPolicy asgAppPolicy *TENANT_ID*/*SERVICE_NAMESPACE*/*SCALABLE_DIMENSION*/*RESOURCE_ID*/*POLICY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[str] policy_type: The policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`.
        :param pulumi.Input[str] resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input[Union['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgsDict']] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"`
        :param pulumi.Input[Union['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgsDict']] target_tracking_scaling_policy_configuration: A target tracking policy, requires `policy_type = "TargetTrackingScaling"`
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling policy will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsAppautoscalingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsAppautoscalingPolicy` manages an aws autoscaling policy in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        #ECS Service Autoscaling
        asg_target = duplocloud.AwsAppautoscalingTarget("asg-target",
            tenant_id=duplo_app.tenant_id,
            max_capacity=4,
            min_capacity=2,
            resource_id="duploservices-duplo-app-ecs-service",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        asg_app_policy = duplocloud.AwsAppautoscalingPolicy("asg-app-policy",
            tenant_id=duplo_app.tenant_id,
            name="avg-cpu-utilization",
            policy_type="TargetTrackingScaling",
            resource_id=asg_target.resource_id,
            scalable_dimension=asg_target.scalable_dimension,
            service_namespace=asg_target.service_namespace,
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "ECSServiceAverageCPUUtilization",
                },
                "target_value": 40,
            })
        ```

        ## Import

        Example: Importing an existing Autoscaling Policy

         - *TENANT_ID* is the tenant GUID

         - *SERVICE_NAMESPACE* The AWS service namespace of the scalable target

         - *SCALABLE_DIMENSION*  The scalable dimension of the scalable target.

         - *RESOURCE_ID* is the duploservices-<account_name>-<resource_name>

         - *POLICY_NAME* is the name of policy

        ```sh
        $ pulumi import duplocloud:index/awsAppautoscalingPolicy:AwsAppautoscalingPolicy asgAppPolicy *TENANT_ID*/*SERVICE_NAMESPACE*/*SCALABLE_DIMENSION*/*RESOURCE_ID*/*POLICY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsAppautoscalingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsAppautoscalingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 scalable_dimension: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input[Union['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgsDict']]] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input[Union['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsAppautoscalingPolicyArgs.__new__(AwsAppautoscalingPolicyArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["policy_type"] = policy_type
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if scalable_dimension is None and not opts.urn:
                raise TypeError("Missing required property 'scalable_dimension'")
            __props__.__dict__["scalable_dimension"] = scalable_dimension
            if service_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'service_namespace'")
            __props__.__dict__["service_namespace"] = service_namespace
            __props__.__dict__["step_scaling_policy_configuration"] = step_scaling_policy_configuration
            __props__.__dict__["target_tracking_scaling_policy_configuration"] = target_tracking_scaling_policy_configuration
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["full_resource_id"] = None
        super(AwsAppautoscalingPolicy, __self__).__init__(
            'duplocloud:index/awsAppautoscalingPolicy:AwsAppautoscalingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            full_resource_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_type: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            scalable_dimension: Optional[pulumi.Input[str]] = None,
            service_namespace: Optional[pulumi.Input[str]] = None,
            step_scaling_policy_configuration: Optional[pulumi.Input[Union['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgsDict']]] = None,
            target_tracking_scaling_policy_configuration: Optional[pulumi.Input[Union['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsAppautoscalingPolicy':
        """
        Get an existing AwsAppautoscalingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] full_resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[str] name: The name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[str] policy_type: The policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`.
        :param pulumi.Input[str] resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input[Union['AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyStepScalingPolicyConfigurationArgsDict']] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"`
        :param pulumi.Input[Union['AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgs', 'AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfigurationArgsDict']] target_tracking_scaling_policy_configuration: A target tracking policy, requires `policy_type = "TargetTrackingScaling"`
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling policy will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsAppautoscalingPolicyState.__new__(_AwsAppautoscalingPolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["full_resource_id"] = full_resource_id
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["scalable_dimension"] = scalable_dimension
        __props__.__dict__["service_namespace"] = service_namespace
        __props__.__dict__["step_scaling_policy_configuration"] = step_scaling_policy_configuration
        __props__.__dict__["target_tracking_scaling_policy_configuration"] = target_tracking_scaling_policy_configuration
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsAppautoscalingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fullResourceId")
    def full_resource_id(self) -> pulumi.Output[str]:
        """
        The resource type and unique identifier string for the resource associated with the scaling policy.
        """
        return pulumi.get(self, "full_resource_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[Optional[str]]:
        """
        The policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The resource type and unique identifier string for the resource associated with the scaling policy.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> pulumi.Output[str]:
        """
        The scalable dimension of the scalable target.
        """
        return pulumi.get(self, "scalable_dimension")

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> pulumi.Output[str]:
        """
        The AWS service namespace of the scalable target.
        """
        return pulumi.get(self, "service_namespace")

    @property
    @pulumi.getter(name="stepScalingPolicyConfiguration")
    def step_scaling_policy_configuration(self) -> pulumi.Output[Optional['outputs.AwsAppautoscalingPolicyStepScalingPolicyConfiguration']]:
        """
        Step scaling policy configuration, requires `policy_type = "StepScaling"`
        """
        return pulumi.get(self, "step_scaling_policy_configuration")

    @property
    @pulumi.getter(name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(self) -> pulumi.Output[Optional['outputs.AwsAppautoscalingPolicyTargetTrackingScalingPolicyConfiguration']]:
        """
        A target tracking policy, requires `policy_type = "TargetTrackingScaling"`
        """
        return pulumi.get(self, "target_tracking_scaling_policy_configuration")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws autoscaling policy will be created in.
        """
        return pulumi.get(self, "tenant_id")

