# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsAppautoscalingTargetArgs', 'AwsAppautoscalingTarget']

@pulumi.input_type
class AwsAppautoscalingTargetArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[int],
                 min_capacity: pulumi.Input[int],
                 resource_id: pulumi.Input[str],
                 scalable_dimension: pulumi.Input[str],
                 service_namespace: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsAppautoscalingTarget resource.
        :param pulumi.Input[int] max_capacity: The max capacity of the scalable target.
        :param pulumi.Input[int] min_capacity: The min capacity of the scalable target.
        :param pulumi.Input[str] resource_id: Resource name associated with the scaling policy.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling target will be created in.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "scalable_dimension", scalable_dimension)
        pulumi.set(__self__, "service_namespace", service_namespace)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[int]:
        """
        The max capacity of the scalable target.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[int]:
        """
        The min capacity of the scalable target.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        Resource name associated with the scaling policy.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> pulumi.Input[str]:
        """
        The scalable dimension of the scalable target.
        """
        return pulumi.get(self, "scalable_dimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: pulumi.Input[str]):
        pulumi.set(self, "scalable_dimension", value)

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> pulumi.Input[str]:
        """
        The AWS service namespace of the scalable target.
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_namespace", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws autoscaling target will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class _AwsAppautoscalingTargetState:
    def __init__(__self__, *,
                 full_resource_id: Optional[pulumi.Input[str]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 scalable_dimension: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsAppautoscalingTarget resources.
        :param pulumi.Input[str] full_resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[int] max_capacity: The max capacity of the scalable target.
        :param pulumi.Input[int] min_capacity: The min capacity of the scalable target.
        :param pulumi.Input[str] resource_id: Resource name associated with the scaling policy.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling target will be created in.
        """
        if full_resource_id is not None:
            pulumi.set(__self__, "full_resource_id", full_resource_id)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if scalable_dimension is not None:
            pulumi.set(__self__, "scalable_dimension", scalable_dimension)
        if service_namespace is not None:
            pulumi.set(__self__, "service_namespace", service_namespace)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="fullResourceId")
    def full_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type and unique identifier string for the resource associated with the scaling policy.
        """
        return pulumi.get(self, "full_resource_id")

    @full_resource_id.setter
    def full_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_resource_id", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The max capacity of the scalable target.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The min capacity of the scalable target.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name associated with the scaling policy.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> Optional[pulumi.Input[str]]:
        """
        The scalable dimension of the scalable target.
        """
        return pulumi.get(self, "scalable_dimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scalable_dimension", value)

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS service namespace of the scalable target.
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_namespace", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws autoscaling target will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsAppautoscalingTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 scalable_dimension: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsAppautoscalingTarget` manages an aws autoscaling target in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        #ECS Service Autoscaling
        asg_target = duplocloud.AwsAppautoscalingTarget("asg-target",
            tenant_id=duplo_app.tenant_id,
            max_capacity=4,
            min_capacity=2,
            resource_id="duploservices-duplo-app-ecs-service",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        ```

        ## Import

        Example: Importing an existing Autoscaling Target

         - *TENANT_ID* is the tenant GUID

         - *SERVICE_NAMESPACE* The AWS service namespace of the scalable target

         - *SCALABLE_DIMENSION*  The scalable dimension of the scalable target.

         - *RESOURCE_ID* is the duploservices-<account_name>-<resource_name>

        # 

        ```sh
        $ pulumi import duplocloud:index/awsAppautoscalingTarget:AwsAppautoscalingTarget asgTarget *TENANT_ID*/*SERVICE_NAMESPACE*/*SCALABLE_DIMENSION*/*RESOURCE_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] max_capacity: The max capacity of the scalable target.
        :param pulumi.Input[int] min_capacity: The min capacity of the scalable target.
        :param pulumi.Input[str] resource_id: Resource name associated with the scaling policy.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling target will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsAppautoscalingTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsAppautoscalingTarget` manages an aws autoscaling target in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        #ECS Service Autoscaling
        asg_target = duplocloud.AwsAppautoscalingTarget("asg-target",
            tenant_id=duplo_app.tenant_id,
            max_capacity=4,
            min_capacity=2,
            resource_id="duploservices-duplo-app-ecs-service",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        ```

        ## Import

        Example: Importing an existing Autoscaling Target

         - *TENANT_ID* is the tenant GUID

         - *SERVICE_NAMESPACE* The AWS service namespace of the scalable target

         - *SCALABLE_DIMENSION*  The scalable dimension of the scalable target.

         - *RESOURCE_ID* is the duploservices-<account_name>-<resource_name>

        # 

        ```sh
        $ pulumi import duplocloud:index/awsAppautoscalingTarget:AwsAppautoscalingTarget asgTarget *TENANT_ID*/*SERVICE_NAMESPACE*/*SCALABLE_DIMENSION*/*RESOURCE_ID*
        ```

        :param str resource_name: The name of the resource.
        :param AwsAppautoscalingTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsAppautoscalingTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 scalable_dimension: Optional[pulumi.Input[str]] = None,
                 service_namespace: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsAppautoscalingTargetArgs.__new__(AwsAppautoscalingTargetArgs)

            if max_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'max_capacity'")
            __props__.__dict__["max_capacity"] = max_capacity
            if min_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'min_capacity'")
            __props__.__dict__["min_capacity"] = min_capacity
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["role_arn"] = role_arn
            if scalable_dimension is None and not opts.urn:
                raise TypeError("Missing required property 'scalable_dimension'")
            __props__.__dict__["scalable_dimension"] = scalable_dimension
            if service_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'service_namespace'")
            __props__.__dict__["service_namespace"] = service_namespace
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["full_resource_id"] = None
        super(AwsAppautoscalingTarget, __self__).__init__(
            'duplocloud:index/awsAppautoscalingTarget:AwsAppautoscalingTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            full_resource_id: Optional[pulumi.Input[str]] = None,
            max_capacity: Optional[pulumi.Input[int]] = None,
            min_capacity: Optional[pulumi.Input[int]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            scalable_dimension: Optional[pulumi.Input[str]] = None,
            service_namespace: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsAppautoscalingTarget':
        """
        Get an existing AwsAppautoscalingTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] full_resource_id: The resource type and unique identifier string for the resource associated with the scaling policy.
        :param pulumi.Input[int] max_capacity: The max capacity of the scalable target.
        :param pulumi.Input[int] min_capacity: The min capacity of the scalable target.
        :param pulumi.Input[str] resource_id: Resource name associated with the scaling policy.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf.
        :param pulumi.Input[str] scalable_dimension: The scalable dimension of the scalable target.
        :param pulumi.Input[str] service_namespace: The AWS service namespace of the scalable target.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws autoscaling target will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsAppautoscalingTargetState.__new__(_AwsAppautoscalingTargetState)

        __props__.__dict__["full_resource_id"] = full_resource_id
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["min_capacity"] = min_capacity
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["scalable_dimension"] = scalable_dimension
        __props__.__dict__["service_namespace"] = service_namespace
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsAppautoscalingTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fullResourceId")
    def full_resource_id(self) -> pulumi.Output[str]:
        """
        The resource type and unique identifier string for the resource associated with the scaling policy.
        """
        return pulumi.get(self, "full_resource_id")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[int]:
        """
        The max capacity of the scalable target.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Output[int]:
        """
        The min capacity of the scalable target.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        Resource name associated with the scaling policy.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the IAM role that allows Application AutoScaling to modify your scalable target on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> pulumi.Output[str]:
        """
        The scalable dimension of the scalable target.
        """
        return pulumi.get(self, "scalable_dimension")

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> pulumi.Output[str]:
        """
        The AWS service namespace of the scalable target.
        """
        return pulumi.get(self, "service_namespace")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws autoscaling target will be created in.
        """
        return pulumi.get(self, "tenant_id")

