# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsBatchComputeEnvironmentArgs', 'AwsBatchComputeEnvironment']

@pulumi.input_type
class AwsBatchComputeEnvironmentArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 compute_resources: Optional[pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AwsBatchComputeEnvironment resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch compute environment will be created in.
        :param pulumi.Input[str] type: The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
        :param pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs'] compute_resources: Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.
        :param pulumi.Input[str] name: Specifies the name of the compute environment.
        :param pulumi.Input[str] service_role: The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        :param pulumi.Input[str] state: The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Compute environment must be created in `ENABLED` state. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if compute_resources is not None:
            pulumi.set(__self__, "compute_resources", compute_resources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws batch compute environment will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="computeResources")
    def compute_resources(self) -> Optional[pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs']]:
        """
        Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.
        """
        return pulumi.get(self, "compute_resources")

    @compute_resources.setter
    def compute_resources(self, value: Optional[pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs']]):
        pulumi.set(self, "compute_resources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the compute environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[str]]:
        """
        The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Compute environment must be created in `ENABLED` state. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)


@pulumi.input_type
class _AwsBatchComputeEnvironmentState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 compute_resources: Optional[pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs']] = None,
                 ecs_cluster_arn: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_reason: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AwsBatchComputeEnvironment resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the compute environment.
        :param pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs'] compute_resources: Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.
        :param pulumi.Input[str] ecs_cluster_arn: The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
        :param pulumi.Input[str] fullname: The full name of the compute environment.
        :param pulumi.Input[str] name: Specifies the name of the compute environment.
        :param pulumi.Input[str] service_role: The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        :param pulumi.Input[str] state: The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Compute environment must be created in `ENABLED` state. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
        :param pulumi.Input[str] status: The current status of the compute environment (for example, CREATING or VALID).
        :param pulumi.Input[str] status_reason: A short, human-readable string to provide additional details about the current status of the compute environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch compute environment will be created in.
        :param pulumi.Input[str] type: The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if compute_resources is not None:
            pulumi.set(__self__, "compute_resources", compute_resources)
        if ecs_cluster_arn is not None:
            pulumi.set(__self__, "ecs_cluster_arn", ecs_cluster_arn)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name of the compute environment.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="computeResources")
    def compute_resources(self) -> Optional[pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs']]:
        """
        Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.
        """
        return pulumi.get(self, "compute_resources")

    @compute_resources.setter
    def compute_resources(self, value: Optional[pulumi.Input['AwsBatchComputeEnvironmentComputeResourcesArgs']]):
        pulumi.set(self, "compute_resources", value)

    @property
    @pulumi.getter(name="ecsClusterArn")
    def ecs_cluster_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
        """
        return pulumi.get(self, "ecs_cluster_arn")

    @ecs_cluster_arn.setter
    def ecs_cluster_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_cluster_arn", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the compute environment.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the compute environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[str]]:
        """
        The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Compute environment must be created in `ENABLED` state. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the compute environment (for example, CREATING or VALID).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A short, human-readable string to provide additional details about the current status of the compute environment.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws batch compute environment will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)


class AwsBatchComputeEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_resources: Optional[pulumi.Input[Union['AwsBatchComputeEnvironmentComputeResourcesArgs', 'AwsBatchComputeEnvironmentComputeResourcesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AwsBatchComputeEnvironment` manages an aws batch compute environment in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        bce = duplocloud.AwsBatchComputeEnvironment("bce",
            tenant_id=myapp.tenant_id,
            name="sample",
            compute_resources={
                "ec2_configuration": {
                    "image_type": "ECS_AL2",
                },
                "instance_types": ["optimal"],
                "allocation_strategy": "BEST_FIT",
                "max_vcpus": 8,
                "min_vcpus": 1,
                "desired_vcpus": 2,
                "bid_percentage": 100,
                "type": "EC2",
            },
            type="MANAGED")
        ```

        ## Import

        Example: Importing an existing AWS Batch Compute Environment

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of compute environment

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchComputeEnvironment:AwsBatchComputeEnvironment bce *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsBatchComputeEnvironmentComputeResourcesArgs', 'AwsBatchComputeEnvironmentComputeResourcesArgsDict']] compute_resources: Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.
        :param pulumi.Input[str] name: Specifies the name of the compute environment.
        :param pulumi.Input[str] service_role: The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        :param pulumi.Input[str] state: The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Compute environment must be created in `ENABLED` state. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch compute environment will be created in.
        :param pulumi.Input[str] type: The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsBatchComputeEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsBatchComputeEnvironment` manages an aws batch compute environment in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        bce = duplocloud.AwsBatchComputeEnvironment("bce",
            tenant_id=myapp.tenant_id,
            name="sample",
            compute_resources={
                "ec2_configuration": {
                    "image_type": "ECS_AL2",
                },
                "instance_types": ["optimal"],
                "allocation_strategy": "BEST_FIT",
                "max_vcpus": 8,
                "min_vcpus": 1,
                "desired_vcpus": 2,
                "bid_percentage": 100,
                "type": "EC2",
            },
            type="MANAGED")
        ```

        ## Import

        Example: Importing an existing AWS Batch Compute Environment

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of compute environment

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchComputeEnvironment:AwsBatchComputeEnvironment bce *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsBatchComputeEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsBatchComputeEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_resources: Optional[pulumi.Input[Union['AwsBatchComputeEnvironmentComputeResourcesArgs', 'AwsBatchComputeEnvironmentComputeResourcesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsBatchComputeEnvironmentArgs.__new__(AwsBatchComputeEnvironmentArgs)

            __props__.__dict__["compute_resources"] = compute_resources
            __props__.__dict__["name"] = name
            __props__.__dict__["service_role"] = service_role
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["wait_for_deployment"] = wait_for_deployment
            __props__.__dict__["arn"] = None
            __props__.__dict__["ecs_cluster_arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
        super(AwsBatchComputeEnvironment, __self__).__init__(
            'duplocloud:index/awsBatchComputeEnvironment:AwsBatchComputeEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            compute_resources: Optional[pulumi.Input[Union['AwsBatchComputeEnvironmentComputeResourcesArgs', 'AwsBatchComputeEnvironmentComputeResourcesArgsDict']]] = None,
            ecs_cluster_arn: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_role: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            status_reason: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            wait_for_deployment: Optional[pulumi.Input[bool]] = None) -> 'AwsBatchComputeEnvironment':
        """
        Get an existing AwsBatchComputeEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the compute environment.
        :param pulumi.Input[Union['AwsBatchComputeEnvironmentComputeResourcesArgs', 'AwsBatchComputeEnvironmentComputeResourcesArgsDict']] compute_resources: Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.
        :param pulumi.Input[str] ecs_cluster_arn: The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
        :param pulumi.Input[str] fullname: The full name of the compute environment.
        :param pulumi.Input[str] name: Specifies the name of the compute environment.
        :param pulumi.Input[str] service_role: The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        :param pulumi.Input[str] state: The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Compute environment must be created in `ENABLED` state. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
        :param pulumi.Input[str] status: The current status of the compute environment (for example, CREATING or VALID).
        :param pulumi.Input[str] status_reason: A short, human-readable string to provide additional details about the current status of the compute environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch compute environment will be created in.
        :param pulumi.Input[str] type: The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsBatchComputeEnvironmentState.__new__(_AwsBatchComputeEnvironmentState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["compute_resources"] = compute_resources
        __props__.__dict__["ecs_cluster_arn"] = ecs_cluster_arn
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["name"] = name
        __props__.__dict__["service_role"] = service_role
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type"] = type
        __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        return AwsBatchComputeEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name of the compute environment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computeResources")
    def compute_resources(self) -> pulumi.Output[Optional['outputs.AwsBatchComputeEnvironmentComputeResources']]:
        """
        Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments.
        """
        return pulumi.get(self, "compute_resources")

    @property
    @pulumi.getter(name="ecsClusterArn")
    def ecs_cluster_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
        """
        return pulumi.get(self, "ecs_cluster_arn")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the compute environment.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the compute environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[str]:
        """
        The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        """
        return pulumi.get(self, "service_role")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Compute environment must be created in `ENABLED` state. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current status of the compute environment (for example, CREATING or VALID).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[str]:
        """
        A short, human-readable string to provide additional details about the current status of the compute environment.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws batch compute environment will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

