# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsBatchJobDefinitionArgs', 'AwsBatchJobDefinition']

@pulumi.input_type
class AwsBatchJobDefinitionArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 container_properties: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 platform_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 retry_strategy: Optional[pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input['AwsBatchJobDefinitionTimeoutArgs']] = None):
        """
        The set of arguments for constructing a AwsBatchJobDefinition resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job Definition will be created in.
        :param pulumi.Input[str] type: The `type` of job definition. Must be `container`.
        :param pulumi.Input[str] container_properties: A valid container properties provided as a single valid JSON document. This parameter is required if the type parameter is `container`.
        :param pulumi.Input[str] name: Specifies the name of the Job Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Specifies the parameter substitution placeholders to set in the job definition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] platform_capabilities: The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
        :param pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs'] retry_strategy: Specifies the retry strategy to use for failed jobs that are submitted with this job definition. Maximum number of `retry_strategy` is `1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input['AwsBatchJobDefinitionTimeoutArgs'] timeout: Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if container_properties is not None:
            pulumi.set(__self__, "container_properties", container_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if platform_capabilities is not None:
            pulumi.set(__self__, "platform_capabilities", platform_capabilities)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws batch Job Definition will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The `type` of job definition. Must be `container`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="containerProperties")
    def container_properties(self) -> Optional[pulumi.Input[str]]:
        """
        A valid container properties provided as a single valid JSON document. This parameter is required if the type parameter is `container`.
        """
        return pulumi.get(self, "container_properties")

    @container_properties.setter
    def container_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_properties", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Job Definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the parameter substitution placeholders to set in the job definition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="platformCapabilities")
    def platform_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
        """
        return pulumi.get(self, "platform_capabilities")

    @platform_capabilities.setter
    def platform_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "platform_capabilities", value)

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional[pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs']]:
        """
        Specifies the retry strategy to use for failed jobs that are submitted with this job definition. Maximum number of `retry_strategy` is `1`.
        """
        return pulumi.get(self, "retry_strategy")

    @retry_strategy.setter
    def retry_strategy(self, value: Optional[pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs']]):
        pulumi.set(self, "retry_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input['AwsBatchJobDefinitionTimeoutArgs']]:
        """
        Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input['AwsBatchJobDefinitionTimeoutArgs']]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _AwsBatchJobDefinitionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 container_properties: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 platform_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 retry_strategy: Optional[pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs']] = None,
                 revision: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input['AwsBatchJobDefinitionTimeoutArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsBatchJobDefinition resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the Job Definition.
        :param pulumi.Input[str] container_properties: A valid container properties provided as a single valid JSON document. This parameter is required if the type parameter is `container`.
        :param pulumi.Input[str] fullname: The full name of the Job Definition.
        :param pulumi.Input[str] name: Specifies the name of the Job Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Specifies the parameter substitution placeholders to set in the job definition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] platform_capabilities: The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
        :param pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs'] retry_strategy: Specifies the retry strategy to use for failed jobs that are submitted with this job definition. Maximum number of `retry_strategy` is `1`.
        :param pulumi.Input[int] revision: The revision of the job definition.
        :param pulumi.Input[str] status: The status of the Job Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job Definition will be created in.
        :param pulumi.Input['AwsBatchJobDefinitionTimeoutArgs'] timeout: Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`.
        :param pulumi.Input[str] type: The `type` of job definition. Must be `container`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if container_properties is not None:
            pulumi.set(__self__, "container_properties", container_properties)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if platform_capabilities is not None:
            pulumi.set(__self__, "platform_capabilities", platform_capabilities)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name of the Job Definition.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="containerProperties")
    def container_properties(self) -> Optional[pulumi.Input[str]]:
        """
        A valid container properties provided as a single valid JSON document. This parameter is required if the type parameter is `container`.
        """
        return pulumi.get(self, "container_properties")

    @container_properties.setter
    def container_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_properties", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the Job Definition.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Job Definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the parameter substitution placeholders to set in the job definition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="platformCapabilities")
    def platform_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
        """
        return pulumi.get(self, "platform_capabilities")

    @platform_capabilities.setter
    def platform_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "platform_capabilities", value)

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional[pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs']]:
        """
        Specifies the retry strategy to use for failed jobs that are submitted with this job definition. Maximum number of `retry_strategy` is `1`.
        """
        return pulumi.get(self, "retry_strategy")

    @retry_strategy.setter
    def retry_strategy(self, value: Optional[pulumi.Input['AwsBatchJobDefinitionRetryStrategyArgs']]):
        pulumi.set(self, "retry_strategy", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[int]]:
        """
        The revision of the job definition.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Job Definition.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws batch Job Definition will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input['AwsBatchJobDefinitionTimeoutArgs']]:
        """
        Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input['AwsBatchJobDefinitionTimeoutArgs']]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The `type` of job definition. Must be `container`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class AwsBatchJobDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_properties: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 platform_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 retry_strategy: Optional[pulumi.Input[Union['AwsBatchJobDefinitionRetryStrategyArgs', 'AwsBatchJobDefinitionRetryStrategyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[Union['AwsBatchJobDefinitionTimeoutArgs', 'AwsBatchJobDefinitionTimeoutArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsBatchJobDefinition` manages an aws batch Job Definition in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "d186700c-ad18-4525-9593-aad467c843ff"
        jd = duplocloud.AwsBatchJobDefinition("jd",
            tenant_id=tenant_id,
            name="tf_test_batch_job_definition",
            type="container",
            platform_capabilities=["EC2"],
            retry_strategy={
                "attempts": 2,
                "evaluate_on_exits": [{
                    "action": "EXIT",
                    "on_exit_code": "1*",
                    "on_reason": "reason*",
                    "on_status_reason": "status",
                }],
            },
            timeout={
                "attempt_duration_seconds": 60,
            },
            container_properties=\"\"\"  {
                "Command": [
                    "sleep",
                    "5"
                ],
                "Image": "amazonlinux",
                "ResourceRequirements": [
                    {
                        "Type": { "Value": "MEMORY" },
                        "Value": "2048"
                    },
                    {
                        "Type":  { "Value": "VCPU" },
                        "Value": "1"
                    },
                    {
                        "Type":  { "Value": "GPU" },
                        "Value": "2"
                    }
                ]
          }
        \"\"\")
        ```

        ## Import

        Example: Importing an existing AWS Batch Job Definition

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Job Definition

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchJobDefinition:AwsBatchJobDefinition jd *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container_properties: A valid container properties provided as a single valid JSON document. This parameter is required if the type parameter is `container`.
        :param pulumi.Input[str] name: Specifies the name of the Job Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Specifies the parameter substitution placeholders to set in the job definition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] platform_capabilities: The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
        :param pulumi.Input[Union['AwsBatchJobDefinitionRetryStrategyArgs', 'AwsBatchJobDefinitionRetryStrategyArgsDict']] retry_strategy: Specifies the retry strategy to use for failed jobs that are submitted with this job definition. Maximum number of `retry_strategy` is `1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job Definition will be created in.
        :param pulumi.Input[Union['AwsBatchJobDefinitionTimeoutArgs', 'AwsBatchJobDefinitionTimeoutArgsDict']] timeout: Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`.
        :param pulumi.Input[str] type: The `type` of job definition. Must be `container`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsBatchJobDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsBatchJobDefinition` manages an aws batch Job Definition in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "d186700c-ad18-4525-9593-aad467c843ff"
        jd = duplocloud.AwsBatchJobDefinition("jd",
            tenant_id=tenant_id,
            name="tf_test_batch_job_definition",
            type="container",
            platform_capabilities=["EC2"],
            retry_strategy={
                "attempts": 2,
                "evaluate_on_exits": [{
                    "action": "EXIT",
                    "on_exit_code": "1*",
                    "on_reason": "reason*",
                    "on_status_reason": "status",
                }],
            },
            timeout={
                "attempt_duration_seconds": 60,
            },
            container_properties=\"\"\"  {
                "Command": [
                    "sleep",
                    "5"
                ],
                "Image": "amazonlinux",
                "ResourceRequirements": [
                    {
                        "Type": { "Value": "MEMORY" },
                        "Value": "2048"
                    },
                    {
                        "Type":  { "Value": "VCPU" },
                        "Value": "1"
                    },
                    {
                        "Type":  { "Value": "GPU" },
                        "Value": "2"
                    }
                ]
          }
        \"\"\")
        ```

        ## Import

        Example: Importing an existing AWS Batch Job Definition

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Job Definition

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchJobDefinition:AwsBatchJobDefinition jd *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsBatchJobDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsBatchJobDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_properties: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 platform_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 retry_strategy: Optional[pulumi.Input[Union['AwsBatchJobDefinitionRetryStrategyArgs', 'AwsBatchJobDefinitionRetryStrategyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[Union['AwsBatchJobDefinitionTimeoutArgs', 'AwsBatchJobDefinitionTimeoutArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsBatchJobDefinitionArgs.__new__(AwsBatchJobDefinitionArgs)

            __props__.__dict__["container_properties"] = container_properties
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["platform_capabilities"] = platform_capabilities
            __props__.__dict__["retry_strategy"] = retry_strategy
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["timeout"] = timeout
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["revision"] = None
            __props__.__dict__["status"] = None
        super(AwsBatchJobDefinition, __self__).__init__(
            'duplocloud:index/awsBatchJobDefinition:AwsBatchJobDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            container_properties: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            platform_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            retry_strategy: Optional[pulumi.Input[Union['AwsBatchJobDefinitionRetryStrategyArgs', 'AwsBatchJobDefinitionRetryStrategyArgsDict']]] = None,
            revision: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[Union['AwsBatchJobDefinitionTimeoutArgs', 'AwsBatchJobDefinitionTimeoutArgsDict']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'AwsBatchJobDefinition':
        """
        Get an existing AwsBatchJobDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the Job Definition.
        :param pulumi.Input[str] container_properties: A valid container properties provided as a single valid JSON document. This parameter is required if the type parameter is `container`.
        :param pulumi.Input[str] fullname: The full name of the Job Definition.
        :param pulumi.Input[str] name: Specifies the name of the Job Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Specifies the parameter substitution placeholders to set in the job definition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] platform_capabilities: The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
        :param pulumi.Input[Union['AwsBatchJobDefinitionRetryStrategyArgs', 'AwsBatchJobDefinitionRetryStrategyArgsDict']] retry_strategy: Specifies the retry strategy to use for failed jobs that are submitted with this job definition. Maximum number of `retry_strategy` is `1`.
        :param pulumi.Input[int] revision: The revision of the job definition.
        :param pulumi.Input[str] status: The status of the Job Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job Definition will be created in.
        :param pulumi.Input[Union['AwsBatchJobDefinitionTimeoutArgs', 'AwsBatchJobDefinitionTimeoutArgsDict']] timeout: Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`.
        :param pulumi.Input[str] type: The `type` of job definition. Must be `container`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsBatchJobDefinitionState.__new__(_AwsBatchJobDefinitionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["container_properties"] = container_properties
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["platform_capabilities"] = platform_capabilities
        __props__.__dict__["retry_strategy"] = retry_strategy
        __props__.__dict__["revision"] = revision
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        return AwsBatchJobDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name of the Job Definition.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="containerProperties")
    def container_properties(self) -> pulumi.Output[str]:
        """
        A valid container properties provided as a single valid JSON document. This parameter is required if the type parameter is `container`.
        """
        return pulumi.get(self, "container_properties")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the Job Definition.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the Job Definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the parameter substitution placeholders to set in the job definition.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="platformCapabilities")
    def platform_capabilities(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
        """
        return pulumi.get(self, "platform_capabilities")

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> pulumi.Output[Optional['outputs.AwsBatchJobDefinitionRetryStrategy']]:
        """
        Specifies the retry strategy to use for failed jobs that are submitted with this job definition. Maximum number of `retry_strategy` is `1`.
        """
        return pulumi.get(self, "retry_strategy")

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Output[int]:
        """
        The revision of the job definition.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Job Definition.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws batch Job Definition will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional['outputs.AwsBatchJobDefinitionTimeout']]:
        """
        Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The `type` of job definition. Must be `container`.
        """
        return pulumi.get(self, "type")

