# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsBatchJobQueueArgs', 'AwsBatchJobQueue']

@pulumi.input_type
class AwsBatchJobQueueArgs:
    def __init__(__self__, *,
                 compute_environments: pulumi.Input[Sequence[pulumi.Input[str]]],
                 priority: pulumi.Input[int],
                 state: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AwsBatchJobQueue resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments mapped to a job queue and their order. The position of the compute environments in the list will dictate the order.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job queue will be created in.
        :param pulumi.Input[str] name: Specifies the name of the Job queue.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        pulumi.set(__self__, "compute_environments", compute_environments)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scheduling_policy_arn is not None:
            pulumi.set(__self__, "scheduling_policy_arn", scheduling_policy_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @property
    @pulumi.getter(name="computeEnvironments")
    def compute_environments(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the set of compute environments mapped to a job queue and their order. The position of the compute environments in the list will dictate the order.
        """
        return pulumi.get(self, "compute_environments")

    @compute_environments.setter
    def compute_environments(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "compute_environments", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        The priority of the job queue. Job queues with a higher priority are evaluated first when associated with the same compute environment.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[str]:
        """
        The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[str]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws batch Job queue will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Job queue.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @scheduling_policy_arn.setter
    def scheduling_policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_policy_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)


@pulumi.input_type
class _AwsBatchJobQueueState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AwsBatchJobQueue resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the Job queue.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments mapped to a job queue and their order. The position of the compute environments in the list will dictate the order.
        :param pulumi.Input[str] fullname: The full name of the Job queue.
        :param pulumi.Input[str] name: Specifies the name of the Job queue.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job queue will be created in.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if compute_environments is not None:
            pulumi.set(__self__, "compute_environments", compute_environments)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if scheduling_policy_arn is not None:
            pulumi.set(__self__, "scheduling_policy_arn", scheduling_policy_arn)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name of the Job queue.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="computeEnvironments")
    def compute_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the set of compute environments mapped to a job queue and their order. The position of the compute environments in the list will dictate the order.
        """
        return pulumi.get(self, "compute_environments")

    @compute_environments.setter
    def compute_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compute_environments", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the Job queue.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the Job queue.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the job queue. Job queues with a higher priority are evaluated first when associated with the same compute environment.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @scheduling_policy_arn.setter
    def scheduling_policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_policy_arn", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws batch Job queue will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)


class AwsBatchJobQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AwsBatchJobQueue` manages an aws batch Job queue in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "d186700c-ad18-4525-9593-aad467c843ff"
        bsp = duplocloud.AwsBatchSchedulingPolicy("bsp",
            tenant_id=tenant_id,
            name="rtt",
            fair_share_policy={
                "compute_reservation": 2,
                "share_decay_seconds": 3600,
                "share_distributions": [
                    {
                        "share_identifier": "A1*",
                        "weight_factor": 0.1,
                    },
                    {
                        "share_identifier": "A2",
                        "weight_factor": 0.2,
                    },
                ],
            },
            tags={
                "Name": "Example Batch Scheduling Policy",
            })
        bce = duplocloud.AwsBatchComputeEnvironment("bce",
            tenant_id=tenant_id,
            name="sample",
            compute_resources={
                "ec2_configuration": {
                    "image_type": "ECS_AL2",
                },
                "instance_types": ["optimal"],
                "allocation_strategy": "BEST_FIT",
                "max_vcpus": 8,
                "min_vcpus": 1,
                "desired_vcpus": 2,
                "bid_percentage": 100,
                "type": "EC2",
            },
            type="MANAGED")
        jq = duplocloud.AwsBatchJobQueue("jq",
            tenant_id=tenant_id,
            name="tf_job_queue",
            scheduling_policy_arn=bsp.arn,
            state="ENABLED",
            priority=1,
            compute_environments=[bce.arn])
        ```

        ## Import

        Example: Importing an existing AWS Batch Job Queue

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Job Queue

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchJobQueue:AwsBatchJobQueue jq *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments mapped to a job queue and their order. The position of the compute environments in the list will dictate the order.
        :param pulumi.Input[str] name: Specifies the name of the Job queue.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job queue will be created in.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsBatchJobQueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsBatchJobQueue` manages an aws batch Job queue in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "d186700c-ad18-4525-9593-aad467c843ff"
        bsp = duplocloud.AwsBatchSchedulingPolicy("bsp",
            tenant_id=tenant_id,
            name="rtt",
            fair_share_policy={
                "compute_reservation": 2,
                "share_decay_seconds": 3600,
                "share_distributions": [
                    {
                        "share_identifier": "A1*",
                        "weight_factor": 0.1,
                    },
                    {
                        "share_identifier": "A2",
                        "weight_factor": 0.2,
                    },
                ],
            },
            tags={
                "Name": "Example Batch Scheduling Policy",
            })
        bce = duplocloud.AwsBatchComputeEnvironment("bce",
            tenant_id=tenant_id,
            name="sample",
            compute_resources={
                "ec2_configuration": {
                    "image_type": "ECS_AL2",
                },
                "instance_types": ["optimal"],
                "allocation_strategy": "BEST_FIT",
                "max_vcpus": 8,
                "min_vcpus": 1,
                "desired_vcpus": 2,
                "bid_percentage": 100,
                "type": "EC2",
            },
            type="MANAGED")
        jq = duplocloud.AwsBatchJobQueue("jq",
            tenant_id=tenant_id,
            name="tf_job_queue",
            scheduling_policy_arn=bsp.arn,
            state="ENABLED",
            priority=1,
            compute_environments=[bce.arn])
        ```

        ## Import

        Example: Importing an existing AWS Batch Job Queue

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Job Queue

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchJobQueue:AwsBatchJobQueue jq *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsBatchJobQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsBatchJobQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsBatchJobQueueArgs.__new__(AwsBatchJobQueueArgs)

            if compute_environments is None and not opts.urn:
                raise TypeError("Missing required property 'compute_environments'")
            __props__.__dict__["compute_environments"] = compute_environments
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["scheduling_policy_arn"] = scheduling_policy_arn
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_for_deployment"] = wait_for_deployment
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
        super(AwsBatchJobQueue, __self__).__init__(
            'duplocloud:index/awsBatchJobQueue:AwsBatchJobQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_for_deployment: Optional[pulumi.Input[bool]] = None) -> 'AwsBatchJobQueue':
        """
        Get an existing AwsBatchJobQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the Job queue.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments mapped to a job queue and their order. The position of the compute environments in the list will dictate the order.
        :param pulumi.Input[str] fullname: The full name of the Job queue.
        :param pulumi.Input[str] name: Specifies the name of the Job queue.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch Job queue will be created in.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsBatchJobQueueState.__new__(_AwsBatchJobQueueState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["compute_environments"] = compute_environments
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["scheduling_policy_arn"] = scheduling_policy_arn
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        return AwsBatchJobQueue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name of the Job queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computeEnvironments")
    def compute_environments(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the set of compute environments mapped to a job queue and their order. The position of the compute environments in the list will dictate the order.
        """
        return pulumi.get(self, "compute_environments")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the Job queue.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the Job queue.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        The priority of the job queue. Job queues with a higher priority are evaluated first when associated with the same compute environment.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws batch Job queue will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

