# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsBatchSchedulingPolicyArgs', 'AwsBatchSchedulingPolicy']

@pulumi.input_type
class AwsBatchSchedulingPolicyArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 fair_share_policy: Optional[pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AwsBatchSchedulingPolicy resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch scheduling policy will be created in.
        :param pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs'] fair_share_policy: A fairshare policy block specifies the `compute_reservation`, `share_delay_seconds`, and `share_distribution` of the scheduling policy. The `fairshare_policy block` is documented below.
        :param pulumi.Input[str] name: Specifies the name of the scheduling policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if fair_share_policy is not None:
            pulumi.set(__self__, "fair_share_policy", fair_share_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws batch scheduling policy will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="fairSharePolicy")
    def fair_share_policy(self) -> Optional[pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs']]:
        """
        A fairshare policy block specifies the `compute_reservation`, `share_delay_seconds`, and `share_distribution` of the scheduling policy. The `fairshare_policy block` is documented below.
        """
        return pulumi.get(self, "fair_share_policy")

    @fair_share_policy.setter
    def fair_share_policy(self, value: Optional[pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs']]):
        pulumi.set(self, "fair_share_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the scheduling policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AwsBatchSchedulingPolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 fair_share_policy: Optional[pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs']] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsBatchSchedulingPolicy resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the scheduling policy.
        :param pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs'] fair_share_policy: A fairshare policy block specifies the `compute_reservation`, `share_delay_seconds`, and `share_distribution` of the scheduling policy. The `fairshare_policy block` is documented below.
        :param pulumi.Input[str] fullname: The full name of the scheduling policy.
        :param pulumi.Input[str] name: Specifies the name of the scheduling policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch scheduling policy will be created in.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if fair_share_policy is not None:
            pulumi.set(__self__, "fair_share_policy", fair_share_policy)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name of the scheduling policy.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="fairSharePolicy")
    def fair_share_policy(self) -> Optional[pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs']]:
        """
        A fairshare policy block specifies the `compute_reservation`, `share_delay_seconds`, and `share_distribution` of the scheduling policy. The `fairshare_policy block` is documented below.
        """
        return pulumi.get(self, "fair_share_policy")

    @fair_share_policy.setter
    def fair_share_policy(self, value: Optional[pulumi.Input['AwsBatchSchedulingPolicyFairSharePolicyArgs']]):
        pulumi.set(self, "fair_share_policy", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the scheduling policy.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the scheduling policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws batch scheduling policy will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsBatchSchedulingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fair_share_policy: Optional[pulumi.Input[Union['AwsBatchSchedulingPolicyFairSharePolicyArgs', 'AwsBatchSchedulingPolicyFairSharePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsBatchSchedulingPolicy` manages an aws batch scheduling policy in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        bsp = duplocloud.AwsBatchSchedulingPolicy("bsp",
            tenant_id=myapp.tenant_id,
            name="test",
            fair_share_policy={
                "compute_reservation": 1,
                "share_decay_seconds": 3600,
                "share_distributions": [
                    {
                        "share_identifier": "A1*",
                        "weight_factor": 0.1,
                    },
                    {
                        "share_identifier": "A2",
                        "weight_factor": 0.2,
                    },
                ],
            },
            tags={
                "Name": "Example Batch Scheduling Policy",
            })
        ```

        ## Import

        Example: Importing an existing AWS Batch Scheduling Policy

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Scheduling Policy

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchSchedulingPolicy:AwsBatchSchedulingPolicy bsp *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsBatchSchedulingPolicyFairSharePolicyArgs', 'AwsBatchSchedulingPolicyFairSharePolicyArgsDict']] fair_share_policy: A fairshare policy block specifies the `compute_reservation`, `share_delay_seconds`, and `share_distribution` of the scheduling policy. The `fairshare_policy block` is documented below.
        :param pulumi.Input[str] name: Specifies the name of the scheduling policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch scheduling policy will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsBatchSchedulingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsBatchSchedulingPolicy` manages an aws batch scheduling policy in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        bsp = duplocloud.AwsBatchSchedulingPolicy("bsp",
            tenant_id=myapp.tenant_id,
            name="test",
            fair_share_policy={
                "compute_reservation": 1,
                "share_decay_seconds": 3600,
                "share_distributions": [
                    {
                        "share_identifier": "A1*",
                        "weight_factor": 0.1,
                    },
                    {
                        "share_identifier": "A2",
                        "weight_factor": 0.2,
                    },
                ],
            },
            tags={
                "Name": "Example Batch Scheduling Policy",
            })
        ```

        ## Import

        Example: Importing an existing AWS Batch Scheduling Policy

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the short name of Scheduling Policy

        # 

        ```sh
        $ pulumi import duplocloud:index/awsBatchSchedulingPolicy:AwsBatchSchedulingPolicy bsp *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsBatchSchedulingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsBatchSchedulingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fair_share_policy: Optional[pulumi.Input[Union['AwsBatchSchedulingPolicyFairSharePolicyArgs', 'AwsBatchSchedulingPolicyFairSharePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsBatchSchedulingPolicyArgs.__new__(AwsBatchSchedulingPolicyArgs)

            __props__.__dict__["fair_share_policy"] = fair_share_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
        super(AwsBatchSchedulingPolicy, __self__).__init__(
            'duplocloud:index/awsBatchSchedulingPolicy:AwsBatchSchedulingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            fair_share_policy: Optional[pulumi.Input[Union['AwsBatchSchedulingPolicyFairSharePolicyArgs', 'AwsBatchSchedulingPolicyFairSharePolicyArgsDict']]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsBatchSchedulingPolicy':
        """
        Get an existing AwsBatchSchedulingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the scheduling policy.
        :param pulumi.Input[Union['AwsBatchSchedulingPolicyFairSharePolicyArgs', 'AwsBatchSchedulingPolicyFairSharePolicyArgsDict']] fair_share_policy: A fairshare policy block specifies the `compute_reservation`, `share_delay_seconds`, and `share_distribution` of the scheduling policy. The `fairshare_policy block` is documented below.
        :param pulumi.Input[str] fullname: The full name of the scheduling policy.
        :param pulumi.Input[str] name: Specifies the name of the scheduling policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws batch scheduling policy will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsBatchSchedulingPolicyState.__new__(_AwsBatchSchedulingPolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["fair_share_policy"] = fair_share_policy
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsBatchSchedulingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name of the scheduling policy.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fairSharePolicy")
    def fair_share_policy(self) -> pulumi.Output['outputs.AwsBatchSchedulingPolicyFairSharePolicy']:
        """
        A fairshare policy block specifies the `compute_reservation`, `share_delay_seconds`, and `share_distribution` of the scheduling policy. The `fairshare_policy block` is documented below.
        """
        return pulumi.get(self, "fair_share_policy")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the scheduling policy.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the scheduling policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws batch scheduling policy will be created in.
        """
        return pulumi.get(self, "tenant_id")

