# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsCloudfrontDistributionArgs', 'AwsCloudfrontDistribution']

@pulumi.input_type
class AwsCloudfrontDistributionArgs:
    def __init__(__self__, *,
                 default_cache_behavior: pulumi.Input['AwsCloudfrontDistributionDefaultCacheBehaviorArgs'],
                 enabled: pulumi.Input[bool],
                 origins: pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginArgs']]],
                 tenant_id: pulumi.Input[str],
                 viewer_certificate: pulumi.Input['AwsCloudfrontDistributionViewerCertificateArgs'],
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 cors_allowed_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionCustomErrorResponseArgs']]]] = None,
                 default_root_object: Optional[pulumi.Input[str]] = None,
                 http_version: Optional[pulumi.Input[str]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[bool]] = None,
                 logging_config: Optional[pulumi.Input['AwsCloudfrontDistributionLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOrderedCacheBehaviorArgs']]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginGroupArgs']]]] = None,
                 price_class: Optional[pulumi.Input[str]] = None,
                 restrictions: Optional[pulumi.Input['AwsCloudfrontDistributionRestrictionsArgs']] = None,
                 use_origin_access_identity: Optional[pulumi.Input[bool]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsCloudfrontDistribution resource.
        :param pulumi.Input[bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws cloudfront distribution will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[str] comment: Any comments you want to include about the distribution. comment has been deprecated instead use name
        :param pulumi.Input[str] default_root_object: The object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[str] http_version: The maximum HTTP version to support on the distribution. Allowed values are `http1.1` and `http2` Defaults to `http2`.
        :param pulumi.Input[bool] is_ipv6_enabled: Defaults to `false`.
        :param pulumi.Input[str] name: Name of the distribution
        :param pulumi.Input[str] price_class: The price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100` Defaults to `PriceClass_All`.
        :param pulumi.Input[bool] use_origin_access_identity: Defaults to `true`.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        :param pulumi.Input[str] web_acl_id: A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
        """
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "origins", origins)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if comment is not None:
            warnings.warn("""comment has been deprecated instead use name""", DeprecationWarning)
            pulumi.log.warn("""comment is deprecated: comment has been deprecated instead use name""")
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if cors_allowed_host_names is not None:
            pulumi.set(__self__, "cors_allowed_host_names", cors_allowed_host_names)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if is_ipv6_enabled is not None:
            pulumi.set(__self__, "is_ipv6_enabled", is_ipv6_enabled)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ordered_cache_behaviors is not None:
            pulumi.set(__self__, "ordered_cache_behaviors", ordered_cache_behaviors)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if use_origin_access_identity is not None:
            pulumi.set(__self__, "use_origin_access_identity", use_origin_access_identity)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Input['AwsCloudfrontDistributionDefaultCacheBehaviorArgs']:
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: pulumi.Input['AwsCloudfrontDistributionDefaultCacheBehaviorArgs']):
        pulumi.set(self, "default_cache_behavior", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the distribution is enabled to accept end user requests for content.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def origins(self) -> pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginArgs']]]:
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginArgs']]]):
        pulumi.set(self, "origins", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the aws cloudfront distribution will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> pulumi.Input['AwsCloudfrontDistributionViewerCertificateArgs']:
        return pulumi.get(self, "viewer_certificate")

    @viewer_certificate.setter
    def viewer_certificate(self, value: pulumi.Input['AwsCloudfrontDistributionViewerCertificateArgs']):
        pulumi.set(self, "viewer_certificate", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Extra CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""comment has been deprecated instead use name""")
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Any comments you want to include about the distribution. comment has been deprecated instead use name
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="corsAllowedHostNames")
    def cors_allowed_host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "cors_allowed_host_names")

    @cors_allowed_host_names.setter
    def cors_allowed_host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cors_allowed_host_names", value)

    @property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionCustomErrorResponseArgs']]]]:
        return pulumi.get(self, "custom_error_responses")

    @custom_error_responses.setter
    def custom_error_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionCustomErrorResponseArgs']]]]):
        pulumi.set(self, "custom_error_responses", value)

    @property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[pulumi.Input[str]]:
        """
        The object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        """
        return pulumi.get(self, "default_root_object")

    @default_root_object.setter
    def default_root_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_root_object", value)

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum HTTP version to support on the distribution. Allowed values are `http1.1` and `http2` Defaults to `http2`.
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_version", value)

    @property
    @pulumi.getter(name="isIpv6Enabled")
    def is_ipv6_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_ipv6_enabled")

    @is_ipv6_enabled.setter
    def is_ipv6_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ipv6_enabled", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AwsCloudfrontDistributionLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AwsCloudfrontDistributionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the distribution
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderedCacheBehaviors")
    def ordered_cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOrderedCacheBehaviorArgs']]]]:
        return pulumi.get(self, "ordered_cache_behaviors")

    @ordered_cache_behaviors.setter
    def ordered_cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOrderedCacheBehaviorArgs']]]]):
        pulumi.set(self, "ordered_cache_behaviors", value)

    @property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginGroupArgs']]]]:
        return pulumi.get(self, "origin_groups")

    @origin_groups.setter
    def origin_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginGroupArgs']]]]):
        pulumi.set(self, "origin_groups", value)

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[pulumi.Input[str]]:
        """
        The price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100` Defaults to `PriceClass_All`.
        """
        return pulumi.get(self, "price_class")

    @price_class.setter
    def price_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "price_class", value)

    @property
    @pulumi.getter
    def restrictions(self) -> Optional[pulumi.Input['AwsCloudfrontDistributionRestrictionsArgs']]:
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: Optional[pulumi.Input['AwsCloudfrontDistributionRestrictionsArgs']]):
        pulumi.set(self, "restrictions", value)

    @property
    @pulumi.getter(name="useOriginAccessIdentity")
    def use_origin_access_identity(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "use_origin_access_identity")

    @use_origin_access_identity.setter
    def use_origin_access_identity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_origin_access_identity", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_acl_id", value)


@pulumi.input_type
class _AwsCloudfrontDistributionState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 cors_allowed_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionCustomErrorResponseArgs']]]] = None,
                 default_cache_behavior: Optional[pulumi.Input['AwsCloudfrontDistributionDefaultCacheBehaviorArgs']] = None,
                 default_root_object: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[str]] = None,
                 http_version: Optional[pulumi.Input[str]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[bool]] = None,
                 logging_config: Optional[pulumi.Input['AwsCloudfrontDistributionLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOrderedCacheBehaviorArgs']]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginGroupArgs']]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginArgs']]]] = None,
                 price_class: Optional[pulumi.Input[str]] = None,
                 restrictions: Optional[pulumi.Input['AwsCloudfrontDistributionRestrictionsArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_origin_access_identity: Optional[pulumi.Input[bool]] = None,
                 viewer_certificate: Optional[pulumi.Input['AwsCloudfrontDistributionViewerCertificateArgs']] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsCloudfrontDistribution resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[str] comment: Any comments you want to include about the distribution. comment has been deprecated instead use name
        :param pulumi.Input[str] default_root_object: The object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[str] http_version: The maximum HTTP version to support on the distribution. Allowed values are `http1.1` and `http2` Defaults to `http2`.
        :param pulumi.Input[bool] is_ipv6_enabled: Defaults to `false`.
        :param pulumi.Input[str] name: Name of the distribution
        :param pulumi.Input[str] price_class: The price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100` Defaults to `PriceClass_All`.
        :param pulumi.Input[str] status: The current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws cloudfront distribution will be created in.
        :param pulumi.Input[bool] use_origin_access_identity: Defaults to `true`.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        :param pulumi.Input[str] web_acl_id: A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if comment is not None:
            warnings.warn("""comment has been deprecated instead use name""", DeprecationWarning)
            pulumi.log.warn("""comment is deprecated: comment has been deprecated instead use name""")
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if cors_allowed_host_names is not None:
            pulumi.set(__self__, "cors_allowed_host_names", cors_allowed_host_names)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if default_cache_behavior is not None:
            pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if is_ipv6_enabled is not None:
            pulumi.set(__self__, "is_ipv6_enabled", is_ipv6_enabled)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ordered_cache_behaviors is not None:
            pulumi.set(__self__, "ordered_cache_behaviors", ordered_cache_behaviors)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_origin_access_identity is not None:
            pulumi.set(__self__, "use_origin_access_identity", use_origin_access_identity)
        if viewer_certificate is not None:
            pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Extra CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""comment has been deprecated instead use name""")
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Any comments you want to include about the distribution. comment has been deprecated instead use name
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="corsAllowedHostNames")
    def cors_allowed_host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "cors_allowed_host_names")

    @cors_allowed_host_names.setter
    def cors_allowed_host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cors_allowed_host_names", value)

    @property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionCustomErrorResponseArgs']]]]:
        return pulumi.get(self, "custom_error_responses")

    @custom_error_responses.setter
    def custom_error_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionCustomErrorResponseArgs']]]]):
        pulumi.set(self, "custom_error_responses", value)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> Optional[pulumi.Input['AwsCloudfrontDistributionDefaultCacheBehaviorArgs']]:
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: Optional[pulumi.Input['AwsCloudfrontDistributionDefaultCacheBehaviorArgs']]):
        pulumi.set(self, "default_cache_behavior", value)

    @property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[pulumi.Input[str]]:
        """
        The object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        """
        return pulumi.get(self, "default_root_object")

    @default_root_object.setter
    def default_root_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_root_object", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the distribution is enabled to accept end user requests for content.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum HTTP version to support on the distribution. Allowed values are `http1.1` and `http2` Defaults to `http2`.
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_version", value)

    @property
    @pulumi.getter(name="isIpv6Enabled")
    def is_ipv6_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_ipv6_enabled")

    @is_ipv6_enabled.setter
    def is_ipv6_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ipv6_enabled", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AwsCloudfrontDistributionLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AwsCloudfrontDistributionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the distribution
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderedCacheBehaviors")
    def ordered_cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOrderedCacheBehaviorArgs']]]]:
        return pulumi.get(self, "ordered_cache_behaviors")

    @ordered_cache_behaviors.setter
    def ordered_cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOrderedCacheBehaviorArgs']]]]):
        pulumi.set(self, "ordered_cache_behaviors", value)

    @property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginGroupArgs']]]]:
        return pulumi.get(self, "origin_groups")

    @origin_groups.setter
    def origin_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginGroupArgs']]]]):
        pulumi.set(self, "origin_groups", value)

    @property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginArgs']]]]:
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudfrontDistributionOriginArgs']]]]):
        pulumi.set(self, "origins", value)

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[pulumi.Input[str]]:
        """
        The price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100` Defaults to `PriceClass_All`.
        """
        return pulumi.get(self, "price_class")

    @price_class.setter
    def price_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "price_class", value)

    @property
    @pulumi.getter
    def restrictions(self) -> Optional[pulumi.Input['AwsCloudfrontDistributionRestrictionsArgs']]:
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: Optional[pulumi.Input['AwsCloudfrontDistributionRestrictionsArgs']]):
        pulumi.set(self, "restrictions", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the aws cloudfront distribution will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useOriginAccessIdentity")
    def use_origin_access_identity(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "use_origin_access_identity")

    @use_origin_access_identity.setter
    def use_origin_access_identity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_origin_access_identity", value)

    @property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> Optional[pulumi.Input['AwsCloudfrontDistributionViewerCertificateArgs']]:
        return pulumi.get(self, "viewer_certificate")

    @viewer_certificate.setter
    def viewer_certificate(self, value: Optional[pulumi.Input['AwsCloudfrontDistributionViewerCertificateArgs']]):
        pulumi.set(self, "viewer_certificate", value)

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_deployment", value)

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_acl_id", value)


class AwsCloudfrontDistribution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 cors_allowed_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionCustomErrorResponseArgs', 'AwsCloudfrontDistributionCustomErrorResponseArgsDict']]]]] = None,
                 default_cache_behavior: Optional[pulumi.Input[Union['AwsCloudfrontDistributionDefaultCacheBehaviorArgs', 'AwsCloudfrontDistributionDefaultCacheBehaviorArgsDict']]] = None,
                 default_root_object: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 http_version: Optional[pulumi.Input[str]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[bool]] = None,
                 logging_config: Optional[pulumi.Input[Union['AwsCloudfrontDistributionLoggingConfigArgs', 'AwsCloudfrontDistributionLoggingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOrderedCacheBehaviorArgs', 'AwsCloudfrontDistributionOrderedCacheBehaviorArgsDict']]]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOriginGroupArgs', 'AwsCloudfrontDistributionOriginGroupArgsDict']]]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOriginArgs', 'AwsCloudfrontDistributionOriginArgsDict']]]]] = None,
                 price_class: Optional[pulumi.Input[str]] = None,
                 restrictions: Optional[pulumi.Input[Union['AwsCloudfrontDistributionRestrictionsArgs', 'AwsCloudfrontDistributionRestrictionsArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_origin_access_identity: Optional[pulumi.Input[bool]] = None,
                 viewer_certificate: Optional[pulumi.Input[Union['AwsCloudfrontDistributionViewerCertificateArgs', 'AwsCloudfrontDistributionViewerCertificateArgsDict']]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsCloudfrontDistribution` manages an aws cloudfront distribution in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        cfd = duplocloud.AwsCloudfrontDistribution("cfd",
            tenant_id=duplo_app.tenant_id,
            comment="duploservices-dev01-app",
            default_root_object="index.html",
            enabled=True,
            http_version="http2",
            is_ipv6_enabled=True,
            aliases=["app-dev.abc.xyz"],
            price_class="PriceClass_All",
            wait_for_deployment=True,
            origins=[
                {
                    "domain_name": "pa-api-dev01.abc.xyz",
                    "origin_id": "pa-api-dev01.abc.xyz",
                    "connection_attempts": 3,
                    "connection_timeout": 10,
                    "custom_origin_config": {
                        "http_port": 80,
                        "https_port": 443,
                        "origin_keepalive_timeout": 30,
                        "origin_read_timeout": 30,
                        "origin_protocol_policy": "https-only",
                        "origin_ssl_protocols": ["TLSv1.2"],
                    },
                },
                {
                    "domain_name": "duploservices-dev01-abc-app-1234567890.s3.us-west-2.amazonaws.com",
                    "origin_id": "duploservices-dev01-abc-app-1234567890.s3.us-west-2.amazonaws.com",
                    "connection_attempts": 3,
                    "connection_timeout": 10,
                },
            ],
            default_cache_behavior={
                "allowed_methods": [
                    "GET",
                    "HEAD",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": "duploservices-dev01-abc-app-1234567890.s3.us-west-2.amazonaws.com",
                "compress": False,
                "viewer_protocol_policy": "redirect-to-https",
                "min_ttl": 0,
                "default_ttl": 0,
                "max_ttl": 0,
            },
            ordered_cache_behaviors=[{
                "allowed_methods": [
                    "GET",
                    "HEAD",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": "pa-api-dev01.abc.xyz",
                "compress": False,
                "viewer_protocol_policy": "redirect-to-https",
                "min_ttl": 0,
                "default_ttl": 0,
                "max_ttl": 0,
                "path_pattern": "/api/*",
            }],
            viewer_certificate={
                "acm_certificate_arn": "arn:aws:acm:us-east-1:1234567890:certificate/49c7a151-14b1-486e-801f-cf6bc9a43804",
                "minimum_protocol_version": "TLSv1.2_2019",
                "ssl_support_method": "sni-only",
            },
            restrictions={
                "geo_restriction": {
                    "restriction_type": "none",
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS Cloudfront Distribution

         - *TENANT_ID* is the tenant GUID

         - *CLOUDFRONT_ID* is the cloudfront id

        # 

        ```sh
        $ pulumi import duplocloud:index/awsCloudfrontDistribution:AwsCloudfrontDistribution myCFD *TENANT_ID*/*CLOUDFRONT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[str] comment: Any comments you want to include about the distribution. comment has been deprecated instead use name
        :param pulumi.Input[str] default_root_object: The object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[str] http_version: The maximum HTTP version to support on the distribution. Allowed values are `http1.1` and `http2` Defaults to `http2`.
        :param pulumi.Input[bool] is_ipv6_enabled: Defaults to `false`.
        :param pulumi.Input[str] name: Name of the distribution
        :param pulumi.Input[str] price_class: The price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100` Defaults to `PriceClass_All`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws cloudfront distribution will be created in.
        :param pulumi.Input[bool] use_origin_access_identity: Defaults to `true`.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        :param pulumi.Input[str] web_acl_id: A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsCloudfrontDistributionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsCloudfrontDistribution` manages an aws cloudfront distribution in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        cfd = duplocloud.AwsCloudfrontDistribution("cfd",
            tenant_id=duplo_app.tenant_id,
            comment="duploservices-dev01-app",
            default_root_object="index.html",
            enabled=True,
            http_version="http2",
            is_ipv6_enabled=True,
            aliases=["app-dev.abc.xyz"],
            price_class="PriceClass_All",
            wait_for_deployment=True,
            origins=[
                {
                    "domain_name": "pa-api-dev01.abc.xyz",
                    "origin_id": "pa-api-dev01.abc.xyz",
                    "connection_attempts": 3,
                    "connection_timeout": 10,
                    "custom_origin_config": {
                        "http_port": 80,
                        "https_port": 443,
                        "origin_keepalive_timeout": 30,
                        "origin_read_timeout": 30,
                        "origin_protocol_policy": "https-only",
                        "origin_ssl_protocols": ["TLSv1.2"],
                    },
                },
                {
                    "domain_name": "duploservices-dev01-abc-app-1234567890.s3.us-west-2.amazonaws.com",
                    "origin_id": "duploservices-dev01-abc-app-1234567890.s3.us-west-2.amazonaws.com",
                    "connection_attempts": 3,
                    "connection_timeout": 10,
                },
            ],
            default_cache_behavior={
                "allowed_methods": [
                    "GET",
                    "HEAD",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": "duploservices-dev01-abc-app-1234567890.s3.us-west-2.amazonaws.com",
                "compress": False,
                "viewer_protocol_policy": "redirect-to-https",
                "min_ttl": 0,
                "default_ttl": 0,
                "max_ttl": 0,
            },
            ordered_cache_behaviors=[{
                "allowed_methods": [
                    "GET",
                    "HEAD",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": "pa-api-dev01.abc.xyz",
                "compress": False,
                "viewer_protocol_policy": "redirect-to-https",
                "min_ttl": 0,
                "default_ttl": 0,
                "max_ttl": 0,
                "path_pattern": "/api/*",
            }],
            viewer_certificate={
                "acm_certificate_arn": "arn:aws:acm:us-east-1:1234567890:certificate/49c7a151-14b1-486e-801f-cf6bc9a43804",
                "minimum_protocol_version": "TLSv1.2_2019",
                "ssl_support_method": "sni-only",
            },
            restrictions={
                "geo_restriction": {
                    "restriction_type": "none",
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS Cloudfront Distribution

         - *TENANT_ID* is the tenant GUID

         - *CLOUDFRONT_ID* is the cloudfront id

        # 

        ```sh
        $ pulumi import duplocloud:index/awsCloudfrontDistribution:AwsCloudfrontDistribution myCFD *TENANT_ID*/*CLOUDFRONT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param AwsCloudfrontDistributionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsCloudfrontDistributionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 cors_allowed_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionCustomErrorResponseArgs', 'AwsCloudfrontDistributionCustomErrorResponseArgsDict']]]]] = None,
                 default_cache_behavior: Optional[pulumi.Input[Union['AwsCloudfrontDistributionDefaultCacheBehaviorArgs', 'AwsCloudfrontDistributionDefaultCacheBehaviorArgsDict']]] = None,
                 default_root_object: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 http_version: Optional[pulumi.Input[str]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[bool]] = None,
                 logging_config: Optional[pulumi.Input[Union['AwsCloudfrontDistributionLoggingConfigArgs', 'AwsCloudfrontDistributionLoggingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOrderedCacheBehaviorArgs', 'AwsCloudfrontDistributionOrderedCacheBehaviorArgsDict']]]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOriginGroupArgs', 'AwsCloudfrontDistributionOriginGroupArgsDict']]]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOriginArgs', 'AwsCloudfrontDistributionOriginArgsDict']]]]] = None,
                 price_class: Optional[pulumi.Input[str]] = None,
                 restrictions: Optional[pulumi.Input[Union['AwsCloudfrontDistributionRestrictionsArgs', 'AwsCloudfrontDistributionRestrictionsArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_origin_access_identity: Optional[pulumi.Input[bool]] = None,
                 viewer_certificate: Optional[pulumi.Input[Union['AwsCloudfrontDistributionViewerCertificateArgs', 'AwsCloudfrontDistributionViewerCertificateArgsDict']]] = None,
                 wait_for_deployment: Optional[pulumi.Input[bool]] = None,
                 web_acl_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsCloudfrontDistributionArgs.__new__(AwsCloudfrontDistributionArgs)

            __props__.__dict__["aliases"] = aliases
            __props__.__dict__["comment"] = comment
            __props__.__dict__["cors_allowed_host_names"] = cors_allowed_host_names
            __props__.__dict__["custom_error_responses"] = custom_error_responses
            if default_cache_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'default_cache_behavior'")
            __props__.__dict__["default_cache_behavior"] = default_cache_behavior
            __props__.__dict__["default_root_object"] = default_root_object
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["http_version"] = http_version
            __props__.__dict__["is_ipv6_enabled"] = is_ipv6_enabled
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["name"] = name
            __props__.__dict__["ordered_cache_behaviors"] = ordered_cache_behaviors
            __props__.__dict__["origin_groups"] = origin_groups
            if origins is None and not opts.urn:
                raise TypeError("Missing required property 'origins'")
            __props__.__dict__["origins"] = origins
            __props__.__dict__["price_class"] = price_class
            __props__.__dict__["restrictions"] = restrictions
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_origin_access_identity"] = use_origin_access_identity
            if viewer_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'viewer_certificate'")
            __props__.__dict__["viewer_certificate"] = viewer_certificate
            __props__.__dict__["wait_for_deployment"] = wait_for_deployment
            __props__.__dict__["web_acl_id"] = web_acl_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["hosted_zone_id"] = None
            __props__.__dict__["status"] = None
        super(AwsCloudfrontDistribution, __self__).__init__(
            'duplocloud:index/awsCloudfrontDistribution:AwsCloudfrontDistribution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            cors_allowed_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionCustomErrorResponseArgs', 'AwsCloudfrontDistributionCustomErrorResponseArgsDict']]]]] = None,
            default_cache_behavior: Optional[pulumi.Input[Union['AwsCloudfrontDistributionDefaultCacheBehaviorArgs', 'AwsCloudfrontDistributionDefaultCacheBehaviorArgsDict']]] = None,
            default_root_object: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            hosted_zone_id: Optional[pulumi.Input[str]] = None,
            http_version: Optional[pulumi.Input[str]] = None,
            is_ipv6_enabled: Optional[pulumi.Input[bool]] = None,
            logging_config: Optional[pulumi.Input[Union['AwsCloudfrontDistributionLoggingConfigArgs', 'AwsCloudfrontDistributionLoggingConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOrderedCacheBehaviorArgs', 'AwsCloudfrontDistributionOrderedCacheBehaviorArgsDict']]]]] = None,
            origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOriginGroupArgs', 'AwsCloudfrontDistributionOriginGroupArgsDict']]]]] = None,
            origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudfrontDistributionOriginArgs', 'AwsCloudfrontDistributionOriginArgsDict']]]]] = None,
            price_class: Optional[pulumi.Input[str]] = None,
            restrictions: Optional[pulumi.Input[Union['AwsCloudfrontDistributionRestrictionsArgs', 'AwsCloudfrontDistributionRestrictionsArgsDict']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            use_origin_access_identity: Optional[pulumi.Input[bool]] = None,
            viewer_certificate: Optional[pulumi.Input[Union['AwsCloudfrontDistributionViewerCertificateArgs', 'AwsCloudfrontDistributionViewerCertificateArgsDict']]] = None,
            wait_for_deployment: Optional[pulumi.Input[bool]] = None,
            web_acl_id: Optional[pulumi.Input[str]] = None) -> 'AwsCloudfrontDistribution':
        """
        Get an existing AwsCloudfrontDistribution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[str] comment: Any comments you want to include about the distribution. comment has been deprecated instead use name
        :param pulumi.Input[str] default_root_object: The object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[str] http_version: The maximum HTTP version to support on the distribution. Allowed values are `http1.1` and `http2` Defaults to `http2`.
        :param pulumi.Input[bool] is_ipv6_enabled: Defaults to `false`.
        :param pulumi.Input[str] name: Name of the distribution
        :param pulumi.Input[str] price_class: The price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100` Defaults to `PriceClass_All`.
        :param pulumi.Input[str] status: The current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the aws cloudfront distribution will be created in.
        :param pulumi.Input[bool] use_origin_access_identity: Defaults to `true`.
        :param pulumi.Input[bool] wait_for_deployment: Defaults to `true`.
        :param pulumi.Input[str] web_acl_id: A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsCloudfrontDistributionState.__new__(_AwsCloudfrontDistributionState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["arn"] = arn
        __props__.__dict__["comment"] = comment
        __props__.__dict__["cors_allowed_host_names"] = cors_allowed_host_names
        __props__.__dict__["custom_error_responses"] = custom_error_responses
        __props__.__dict__["default_cache_behavior"] = default_cache_behavior
        __props__.__dict__["default_root_object"] = default_root_object
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["etag"] = etag
        __props__.__dict__["hosted_zone_id"] = hosted_zone_id
        __props__.__dict__["http_version"] = http_version
        __props__.__dict__["is_ipv6_enabled"] = is_ipv6_enabled
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["name"] = name
        __props__.__dict__["ordered_cache_behaviors"] = ordered_cache_behaviors
        __props__.__dict__["origin_groups"] = origin_groups
        __props__.__dict__["origins"] = origins
        __props__.__dict__["price_class"] = price_class
        __props__.__dict__["restrictions"] = restrictions
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["use_origin_access_identity"] = use_origin_access_identity
        __props__.__dict__["viewer_certificate"] = viewer_certificate
        __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        __props__.__dict__["web_acl_id"] = web_acl_id
        return AwsCloudfrontDistribution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Sequence[str]]:
        """
        Extra CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    @_utilities.deprecated("""comment has been deprecated instead use name""")
    def comment(self) -> pulumi.Output[str]:
        """
        Any comments you want to include about the distribution. comment has been deprecated instead use name
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="corsAllowedHostNames")
    def cors_allowed_host_names(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "cors_allowed_host_names")

    @property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> pulumi.Output[Optional[Sequence['outputs.AwsCloudfrontDistributionCustomErrorResponse']]]:
        return pulumi.get(self, "custom_error_responses")

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Output['outputs.AwsCloudfrontDistributionDefaultCacheBehavior']:
        return pulumi.get(self, "default_cache_behavior")

    @property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> pulumi.Output[str]:
        """
        The object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        """
        return pulumi.get(self, "default_root_object")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether the distribution is enabled to accept end user requests for content.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> pulumi.Output[Optional[str]]:
        """
        The maximum HTTP version to support on the distribution. Allowed values are `http1.1` and `http2` Defaults to `http2`.
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter(name="isIpv6Enabled")
    def is_ipv6_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_ipv6_enabled")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.AwsCloudfrontDistributionLoggingConfig']]:
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the distribution
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orderedCacheBehaviors")
    def ordered_cache_behaviors(self) -> pulumi.Output[Optional[Sequence['outputs.AwsCloudfrontDistributionOrderedCacheBehavior']]]:
        return pulumi.get(self, "ordered_cache_behaviors")

    @property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> pulumi.Output[Optional[Sequence['outputs.AwsCloudfrontDistributionOriginGroup']]]:
        return pulumi.get(self, "origin_groups")

    @property
    @pulumi.getter
    def origins(self) -> pulumi.Output[Sequence['outputs.AwsCloudfrontDistributionOrigin']]:
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> pulumi.Output[Optional[str]]:
        """
        The price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100` Defaults to `PriceClass_All`.
        """
        return pulumi.get(self, "price_class")

    @property
    @pulumi.getter
    def restrictions(self) -> pulumi.Output['outputs.AwsCloudfrontDistributionRestrictions']:
        return pulumi.get(self, "restrictions")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the aws cloudfront distribution will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="useOriginAccessIdentity")
    def use_origin_access_identity(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "use_origin_access_identity")

    @property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> pulumi.Output['outputs.AwsCloudfrontDistributionViewerCertificate']:
        return pulumi.get(self, "viewer_certificate")

    @property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> pulumi.Output[str]:
        """
        A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
        """
        return pulumi.get(self, "web_acl_id")

