# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsCloudwatchEventTargetArgs', 'AwsCloudwatchEventTarget']

@pulumi.input_type
class AwsCloudwatchEventTargetArgs:
    def __init__(__self__, *,
                 rule_name: pulumi.Input[str],
                 target_arn: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsCloudwatchEventTarget resource.
        :param pulumi.Input[str] rule_name: The name of the rule you want to add targets to.
        :param pulumi.Input[str] target_arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[str] target_id: The unique target assignment ID.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch event target will be created in.
        :param pulumi.Input[str] event_bus_name: The event bus to associate with the rule. If you omit this, the default event bus is used.
        :param pulumi.Input[str] input: Valid JSON text passed to the target.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "target_arn", target_arn)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if event_bus_name is not None:
            pulumi.set(__self__, "event_bus_name", event_bus_name)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        """
        The name of the rule you want to add targets to.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_arn", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        The unique target assignment ID.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the cloudwatch event target will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> Optional[pulumi.Input[str]]:
        """
        The event bus to associate with the rule. If you omit this, the default event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @event_bus_name.setter
    def event_bus_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_bus_name", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input[str]]:
        """
        Valid JSON text passed to the target.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class _AwsCloudwatchEventTargetState:
    def __init__(__self__, *,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 target_arn: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsCloudwatchEventTarget resources.
        :param pulumi.Input[str] event_bus_name: The event bus to associate with the rule. If you omit this, the default event bus is used.
        :param pulumi.Input[str] input: Valid JSON text passed to the target.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
        :param pulumi.Input[str] rule_name: The name of the rule you want to add targets to.
        :param pulumi.Input[str] target_arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[str] target_id: The unique target assignment ID.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch event target will be created in.
        """
        if event_bus_name is not None:
            pulumi.set(__self__, "event_bus_name", event_bus_name)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if target_arn is not None:
            pulumi.set(__self__, "target_arn", target_arn)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> Optional[pulumi.Input[str]]:
        """
        The event bus to associate with the rule. If you omit this, the default event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @event_bus_name.setter
    def event_bus_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_bus_name", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input[str]]:
        """
        Valid JSON text passed to the target.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule you want to add targets to.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_arn", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique target assignment ID.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the cloudwatch event target will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsCloudwatchEventTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 target_arn: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsCloudwatchEventTarget` manages an AWS cloudwatch event target in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        cw_erule = duplocloud.AwsCloudwatchEventRule("cw_erule",
            tenant_id=duplo_app.tenant_id,
            name="cw_erule",
            description="this is a test cloudwatch event rule.",
            schedule_expression="rate(10 minutes)",
            state="DISABLED",
            tags=[
                {
                    "key": "CreatedBy",
                    "value": "Duplo",
                },
                {
                    "key": "CreatedFrom",
                    "value": "Duplo",
                },
            ])
        cw_etarget1 = duplocloud.AwsCloudwatchEventTarget("cw_etarget1",
            tenant_id=duplo_app.tenant_id,
            rule_name=cw_erule.fullname,
            target_arn="arn:aws:lambda:us-west-2:294468937448:function:orphan-resource-tag",
            target_id="lamda-tst1")
        cw_etarget2 = duplocloud.AwsCloudwatchEventTarget("cw_etarget2",
            tenant_id=duplo_app.tenant_id,
            rule_name=cw_erule.fullname,
            target_arn="arn:aws:lambda:us-west-2:294468937448:function:orphan-resource-tag",
            target_id="lamda-tst2")
        ```

        ## Import

        Example: Importing an existing AWS cloudwatch event target

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duploservices-<account_name>-<name_of_event_rule>

         - *TARGET_ID* The unique target assignment ID.

        ```sh
        $ pulumi import duplocloud:index/awsCloudwatchEventTarget:AwsCloudwatchEventTarget myEventTarget *TENANT_ID*/*FRIENDLY_NAME*/*TARGET_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] event_bus_name: The event bus to associate with the rule. If you omit this, the default event bus is used.
        :param pulumi.Input[str] input: Valid JSON text passed to the target.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
        :param pulumi.Input[str] rule_name: The name of the rule you want to add targets to.
        :param pulumi.Input[str] target_arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[str] target_id: The unique target assignment ID.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch event target will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsCloudwatchEventTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsCloudwatchEventTarget` manages an AWS cloudwatch event target in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        cw_erule = duplocloud.AwsCloudwatchEventRule("cw_erule",
            tenant_id=duplo_app.tenant_id,
            name="cw_erule",
            description="this is a test cloudwatch event rule.",
            schedule_expression="rate(10 minutes)",
            state="DISABLED",
            tags=[
                {
                    "key": "CreatedBy",
                    "value": "Duplo",
                },
                {
                    "key": "CreatedFrom",
                    "value": "Duplo",
                },
            ])
        cw_etarget1 = duplocloud.AwsCloudwatchEventTarget("cw_etarget1",
            tenant_id=duplo_app.tenant_id,
            rule_name=cw_erule.fullname,
            target_arn="arn:aws:lambda:us-west-2:294468937448:function:orphan-resource-tag",
            target_id="lamda-tst1")
        cw_etarget2 = duplocloud.AwsCloudwatchEventTarget("cw_etarget2",
            tenant_id=duplo_app.tenant_id,
            rule_name=cw_erule.fullname,
            target_arn="arn:aws:lambda:us-west-2:294468937448:function:orphan-resource-tag",
            target_id="lamda-tst2")
        ```

        ## Import

        Example: Importing an existing AWS cloudwatch event target

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the duploservices-<account_name>-<name_of_event_rule>

         - *TARGET_ID* The unique target assignment ID.

        ```sh
        $ pulumi import duplocloud:index/awsCloudwatchEventTarget:AwsCloudwatchEventTarget myEventTarget *TENANT_ID*/*FRIENDLY_NAME*/*TARGET_ID*
        ```

        :param str resource_name: The name of the resource.
        :param AwsCloudwatchEventTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsCloudwatchEventTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 target_arn: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsCloudwatchEventTargetArgs.__new__(AwsCloudwatchEventTargetArgs)

            __props__.__dict__["event_bus_name"] = event_bus_name
            __props__.__dict__["input"] = input
            __props__.__dict__["role_arn"] = role_arn
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            if target_arn is None and not opts.urn:
                raise TypeError("Missing required property 'target_arn'")
            __props__.__dict__["target_arn"] = target_arn
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AwsCloudwatchEventTarget, __self__).__init__(
            'duplocloud:index/awsCloudwatchEventTarget:AwsCloudwatchEventTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            event_bus_name: Optional[pulumi.Input[str]] = None,
            input: Optional[pulumi.Input[str]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            rule_name: Optional[pulumi.Input[str]] = None,
            target_arn: Optional[pulumi.Input[str]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsCloudwatchEventTarget':
        """
        Get an existing AwsCloudwatchEventTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] event_bus_name: The event bus to associate with the rule. If you omit this, the default event bus is used.
        :param pulumi.Input[str] input: Valid JSON text passed to the target.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
        :param pulumi.Input[str] rule_name: The name of the rule you want to add targets to.
        :param pulumi.Input[str] target_arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[str] target_id: The unique target assignment ID.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch event target will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsCloudwatchEventTargetState.__new__(_AwsCloudwatchEventTargetState)

        __props__.__dict__["event_bus_name"] = event_bus_name
        __props__.__dict__["input"] = input
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["target_arn"] = target_arn
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsCloudwatchEventTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> pulumi.Output[str]:
        """
        The event bus to associate with the rule. If you omit this, the default event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @property
    @pulumi.getter
    def input(self) -> pulumi.Output[str]:
        """
        Valid JSON text passed to the target.
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) associated with the role that is used for target invocation.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        """
        The name of the rule you want to add targets to.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "target_arn")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The unique target assignment ID.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the cloudwatch event target will be created in.
        """
        return pulumi.get(self, "tenant_id")

