# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsCloudwatchMetricAlarmArgs', 'AwsCloudwatchMetricAlarm']

@pulumi.input_type
class AwsCloudwatchMetricAlarmArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input[str],
                 evaluation_periods: pulumi.Input[int],
                 metric_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[float]] = None):
        """
        The set of arguments for constructing a AwsCloudwatchMetricAlarm resource.
        :param pulumi.Input[str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`
        :param pulumi.Input[int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[str] metric_name: The name for the alarm's associated metric.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch metric alarm will be created in.
        :param pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]] dimensions: The dimensions for the alarm's associated metric. For the list of available dimensions see the AWS documentation.
        :param pulumi.Input[str] namespace: The namespace for the alarm's associated metric.
        :param pulumi.Input[int] period: The period in seconds over which the specified `statistic` is applied.
        :param pulumi.Input[str] statistic: The statistic to apply to the alarm's associated metric. Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input[str]:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Input[int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: pulumi.Input[int]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name for the alarm's associated metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the cloudwatch metric alarm will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]]]:
        """
        The dimensions for the alarm's associated metric. For the list of available dimensions see the AWS documentation.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace for the alarm's associated metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period in seconds over which the specified `statistic` is applied.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[str]]:
        """
        The statistic to apply to the alarm's associated metric. Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)


@pulumi.input_type
class _AwsCloudwatchMetricAlarmState:
    def __init__(__self__, *,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering AwsCloudwatchMetricAlarm resources.
        :param pulumi.Input[str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`
        :param pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]] dimensions: The dimensions for the alarm's associated metric. For the list of available dimensions see the AWS documentation.
        :param pulumi.Input[int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[str] fullname: Duplo will generate name of the metric alarm.
        :param pulumi.Input[str] metric_name: The name for the alarm's associated metric.
        :param pulumi.Input[str] namespace: The namespace for the alarm's associated metric.
        :param pulumi.Input[int] period: The period in seconds over which the specified `statistic` is applied.
        :param pulumi.Input[str] statistic: The statistic to apply to the alarm's associated metric. Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch metric alarm will be created in.
        :param pulumi.Input[float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[pulumi.Input[str]]:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]]]:
        """
        The dimensions for the alarm's associated metric. For the list of available dimensions see the AWS documentation.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsCloudwatchMetricAlarmDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[int]]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        Duplo will generate name of the metric alarm.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the alarm's associated metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace for the alarm's associated metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period in seconds over which the specified `statistic` is applied.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[str]]:
        """
        The statistic to apply to the alarm's associated metric. Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the cloudwatch metric alarm will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)


class AwsCloudwatchMetricAlarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudwatchMetricAlarmDimensionArgs', 'AwsCloudwatchMetricAlarmDimensionArgsDict']]]]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        """
        `AwsCloudwatchMetricAlarm` manages an AWS cloudwatch metric alarm in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        m_alarm = duplocloud.AwsCloudwatchMetricAlarm("mAlarm",
            tenant_id=duplo_app.tenant_id,
            metric_name="CPUUtilization",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=1,
            namespace="AWS/EC2",
            period=300,
            threshold=80,
            statistic="Average",
            dimensions=[{
                "key": "InstanceId",
                "value": "i-1234567abcdefghj",
            }])
        ```

        ## Import

        Example: Importing an existing cloudwatch metric alarm

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the hypen separated alarm dimension values and metric name

        ```sh
        $ pulumi import duplocloud:index/awsCloudwatchMetricAlarm:AwsCloudwatchMetricAlarm myMetricAlarm *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudwatchMetricAlarmDimensionArgs', 'AwsCloudwatchMetricAlarmDimensionArgsDict']]]] dimensions: The dimensions for the alarm's associated metric. For the list of available dimensions see the AWS documentation.
        :param pulumi.Input[int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[str] metric_name: The name for the alarm's associated metric.
        :param pulumi.Input[str] namespace: The namespace for the alarm's associated metric.
        :param pulumi.Input[int] period: The period in seconds over which the specified `statistic` is applied.
        :param pulumi.Input[str] statistic: The statistic to apply to the alarm's associated metric. Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch metric alarm will be created in.
        :param pulumi.Input[float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsCloudwatchMetricAlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsCloudwatchMetricAlarm` manages an AWS cloudwatch metric alarm in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        duplo_app = duplocloud.Tenant("duplo-app",
            account_name="duplo-app",
            plan_id="default")
        m_alarm = duplocloud.AwsCloudwatchMetricAlarm("mAlarm",
            tenant_id=duplo_app.tenant_id,
            metric_name="CPUUtilization",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=1,
            namespace="AWS/EC2",
            period=300,
            threshold=80,
            statistic="Average",
            dimensions=[{
                "key": "InstanceId",
                "value": "i-1234567abcdefghj",
            }])
        ```

        ## Import

        Example: Importing an existing cloudwatch metric alarm

         - *TENANT_ID* is the tenant GUID

         - *FRIENDLY_NAME* is the hypen separated alarm dimension values and metric name

        ```sh
        $ pulumi import duplocloud:index/awsCloudwatchMetricAlarm:AwsCloudwatchMetricAlarm myMetricAlarm *TENANT_ID*/*FRIENDLY_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsCloudwatchMetricAlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsCloudwatchMetricAlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudwatchMetricAlarmDimensionArgs', 'AwsCloudwatchMetricAlarmDimensionArgsDict']]]]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsCloudwatchMetricAlarmArgs.__new__(AwsCloudwatchMetricAlarmArgs)

            if comparison_operator is None and not opts.urn:
                raise TypeError("Missing required property 'comparison_operator'")
            __props__.__dict__["comparison_operator"] = comparison_operator
            __props__.__dict__["dimensions"] = dimensions
            if evaluation_periods is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_periods'")
            __props__.__dict__["evaluation_periods"] = evaluation_periods
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["period"] = period
            __props__.__dict__["statistic"] = statistic
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["fullname"] = None
        super(AwsCloudwatchMetricAlarm, __self__).__init__(
            'duplocloud:index/awsCloudwatchMetricAlarm:AwsCloudwatchMetricAlarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comparison_operator: Optional[pulumi.Input[str]] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudwatchMetricAlarmDimensionArgs', 'AwsCloudwatchMetricAlarmDimensionArgsDict']]]]] = None,
            evaluation_periods: Optional[pulumi.Input[int]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            metric_name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            statistic: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            threshold: Optional[pulumi.Input[float]] = None) -> 'AwsCloudwatchMetricAlarm':
        """
        Get an existing AwsCloudwatchMetricAlarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsCloudwatchMetricAlarmDimensionArgs', 'AwsCloudwatchMetricAlarmDimensionArgsDict']]]] dimensions: The dimensions for the alarm's associated metric. For the list of available dimensions see the AWS documentation.
        :param pulumi.Input[int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[str] fullname: Duplo will generate name of the metric alarm.
        :param pulumi.Input[str] metric_name: The name for the alarm's associated metric.
        :param pulumi.Input[str] namespace: The namespace for the alarm's associated metric.
        :param pulumi.Input[int] period: The period in seconds over which the specified `statistic` is applied.
        :param pulumi.Input[str] statistic: The statistic to apply to the alarm's associated metric. Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the cloudwatch metric alarm will be created in.
        :param pulumi.Input[float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsCloudwatchMetricAlarmState.__new__(_AwsCloudwatchMetricAlarmState)

        __props__.__dict__["comparison_operator"] = comparison_operator
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["evaluation_periods"] = evaluation_periods
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["period"] = period
        __props__.__dict__["statistic"] = statistic
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["threshold"] = threshold
        return AwsCloudwatchMetricAlarm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Output[str]:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Optional[Sequence['outputs.AwsCloudwatchMetricAlarmDimension']]]:
        """
        The dimensions for the alarm's associated metric. For the list of available dimensions see the AWS documentation.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Output[int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        Duplo will generate name of the metric alarm.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[str]:
        """
        The name for the alarm's associated metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace for the alarm's associated metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The period in seconds over which the specified `statistic` is applied.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Output[Optional[str]]:
        """
        The statistic to apply to the alarm's associated metric. Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the cloudwatch metric alarm will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[Optional[float]]:
        """
        The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "threshold")

