# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsDynamodbTableArgs', 'AwsDynamodbTable']

@pulumi.input_type
class AwsDynamodbTableArgs:
    def __init__(__self__, *,
                 attribute_type: pulumi.Input[str],
                 key_type: pulumi.Input[str],
                 primary_key_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsDynamodbTable resource.
        :param pulumi.Input[str] attribute_type: The attribute type of the primary key attribute.
        :param pulumi.Input[str] key_type: The key type of the primary key.
        :param pulumi.Input[str] primary_key_name: The attribute name of the primary key attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        :param pulumi.Input[str] name: The short name of the dynamodb table.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        pulumi.set(__self__, "attribute_type", attribute_type)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "primary_key_name", primary_key_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> pulumi.Input[str]:
        """
        The attribute type of the primary key attribute.
        """
        return pulumi.get(self, "attribute_type")

    @attribute_type.setter
    def attribute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute_type", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[str]:
        """
        The key type of the primary key.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="primaryKeyName")
    def primary_key_name(self) -> pulumi.Input[str]:
        """
        The attribute name of the primary key attribute.
        """
        return pulumi.get(self, "primary_key_name")

    @primary_key_name.setter
    def primary_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_key_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the dynamodb table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the dynamodb table.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AwsDynamodbTableState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 attribute_type: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_key_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsDynamodbTable resources.
        :param pulumi.Input[str] arn: The ARN of the dynamodb table.
        :param pulumi.Input[str] attribute_type: The attribute type of the primary key attribute.
        :param pulumi.Input[str] fullname: The full name of the dynamodb table.
        :param pulumi.Input[str] key_type: The key type of the primary key.
        :param pulumi.Input[str] name: The short name of the dynamodb table.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] primary_key_name: The attribute name of the primary key attribute.
        :param pulumi.Input[str] status: The status of the dynamodb table.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if attribute_type is not None:
            pulumi.set(__self__, "attribute_type", attribute_type)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_key_name is not None:
            pulumi.set(__self__, "primary_key_name", primary_key_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the dynamodb table.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute type of the primary key attribute.
        """
        return pulumi.get(self, "attribute_type")

    @attribute_type.setter
    def attribute_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attribute_type", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the dynamodb table.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The key type of the primary key.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the dynamodb table.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryKeyName")
    def primary_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute name of the primary key attribute.
        """
        return pulumi.get(self, "primary_key_name")

    @primary_key_name.setter
    def primary_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the dynamodb table.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the dynamodb table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsDynamodbTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_type: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_key_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsDynamodbTable` manages an AWS dynamodb table in Duplo.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] attribute_type: The attribute type of the primary key attribute.
        :param pulumi.Input[str] key_type: The key type of the primary key.
        :param pulumi.Input[str] name: The short name of the dynamodb table.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] primary_key_name: The attribute name of the primary key attribute.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsDynamodbTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsDynamodbTable` manages an AWS dynamodb table in Duplo.

        :param str resource_name: The name of the resource.
        :param AwsDynamodbTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsDynamodbTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_type: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_key_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsDynamodbTableArgs.__new__(AwsDynamodbTableArgs)

            if attribute_type is None and not opts.urn:
                raise TypeError("Missing required property 'attribute_type'")
            __props__.__dict__["attribute_type"] = attribute_type
            if key_type is None and not opts.urn:
                raise TypeError("Missing required property 'key_type'")
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["name"] = name
            if primary_key_name is None and not opts.urn:
                raise TypeError("Missing required property 'primary_key_name'")
            __props__.__dict__["primary_key_name"] = primary_key_name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["status"] = None
        super(AwsDynamodbTable, __self__).__init__(
            'duplocloud:index/awsDynamodbTable:AwsDynamodbTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            attribute_type: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            key_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            primary_key_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsDynamodbTable':
        """
        Get an existing AwsDynamodbTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the dynamodb table.
        :param pulumi.Input[str] attribute_type: The attribute type of the primary key attribute.
        :param pulumi.Input[str] fullname: The full name of the dynamodb table.
        :param pulumi.Input[str] key_type: The key type of the primary key.
        :param pulumi.Input[str] name: The short name of the dynamodb table.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] primary_key_name: The attribute name of the primary key attribute.
        :param pulumi.Input[str] status: The status of the dynamodb table.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsDynamodbTableState.__new__(_AwsDynamodbTableState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["attribute_type"] = attribute_type
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_key_name"] = primary_key_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsDynamodbTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the dynamodb table.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> pulumi.Output[str]:
        """
        The attribute type of the primary key attribute.
        """
        return pulumi.get(self, "attribute_type")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the dynamodb table.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[str]:
        """
        The key type of the primary key.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the dynamodb table.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryKeyName")
    def primary_key_name(self) -> pulumi.Output[str]:
        """
        The attribute name of the primary key attribute.
        """
        return pulumi.get(self, "primary_key_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the dynamodb table.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the dynamodb table will be created in.
        """
        return pulumi.get(self, "tenant_id")

