# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsDynamodbTableV2Args', 'AwsDynamodbTableV2']

@pulumi.input_type
class AwsDynamodbTableV2Args:
    def __init__(__self__, *,
                 attributes: pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2AttributeArgs']]],
                 key_schemas: pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2KeySchemaArgs']]],
                 tenant_id: pulumi.Input[str],
                 billing_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 global_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]]] = None,
                 is_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 local_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2LocalSecondaryIndexArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_capacity: Optional[pulumi.Input[int]] = None,
                 server_side_encryption: Optional[pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs']] = None,
                 stream_enabled: Optional[pulumi.Input[bool]] = None,
                 stream_view_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2TagArgs']]]] = None,
                 ttl: Optional[pulumi.Input['AwsDynamodbTableV2TtlArgs']] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 write_capacity: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AwsDynamodbTableV2 resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        :param pulumi.Input[str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[bool] deletion_protection_enabled: Deletion protection keeps the tables from being deleted unintentionally. While this setting is on, you can't delete the table.
        :param pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]] global_secondary_indices: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc.
        :param pulumi.Input[bool] is_point_in_time_recovery: The point in time recovery status of the dynamodb table. Enabled if true.
        :param pulumi.Input[str] name: The name of the table, this needs to be unique within a region.
        :param pulumi.Input[int] read_capacity: The number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs'] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS owned Customer Master Key if this argument isn't specified.
        :param pulumi.Input[bool] stream_enabled: Indicates whether Streams are to be enabled (true) or disabled (false).
        :param pulumi.Input[str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input['AwsDynamodbTableV2TtlArgs'] ttl: Setup ttl for dynamodb table. Defaults to `false or empty`, To disable ttl, enabled field should be set to false
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until dynamodb instance to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[int] write_capacity: The number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "key_schemas", key_schemas)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if global_secondary_indices is not None:
            pulumi.set(__self__, "global_secondary_indices", global_secondary_indices)
        if is_point_in_time_recovery is not None:
            pulumi.set(__self__, "is_point_in_time_recovery", is_point_in_time_recovery)
        if local_secondary_indices is not None:
            pulumi.set(__self__, "local_secondary_indices", local_secondary_indices)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if stream_enabled is not None:
            pulumi.set(__self__, "stream_enabled", stream_enabled)
        if stream_view_type is not None:
            pulumi.set(__self__, "stream_view_type", stream_view_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2AttributeArgs']]]:
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2AttributeArgs']]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="keySchemas")
    def key_schemas(self) -> pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2KeySchemaArgs']]]:
        return pulumi.get(self, "key_schemas")

    @key_schemas.setter
    def key_schemas(self, value: pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2KeySchemaArgs']]]):
        pulumi.set(self, "key_schemas", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the dynamodb table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_mode", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Deletion protection keeps the tables from being deleted unintentionally. While this setting is on, you can't delete the table.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="globalSecondaryIndices")
    def global_secondary_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]]]:
        """
        Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc.
        """
        return pulumi.get(self, "global_secondary_indices")

    @global_secondary_indices.setter
    def global_secondary_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]]]):
        pulumi.set(self, "global_secondary_indices", value)

    @property
    @pulumi.getter(name="isPointInTimeRecovery")
    def is_point_in_time_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        The point in time recovery status of the dynamodb table. Enabled if true.
        """
        return pulumi.get(self, "is_point_in_time_recovery")

    @is_point_in_time_recovery.setter
    def is_point_in_time_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_point_in_time_recovery", value)

    @property
    @pulumi.getter(name="localSecondaryIndices")
    def local_secondary_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2LocalSecondaryIndexArgs']]]]:
        return pulumi.get(self, "local_secondary_indices")

    @local_secondary_indices.setter
    def local_secondary_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2LocalSecondaryIndexArgs']]]]):
        pulumi.set(self, "local_secondary_indices", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the table, this needs to be unique within a region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "read_capacity")

    @read_capacity.setter
    def read_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_capacity", value)

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs']]:
        """
        Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS owned Customer Master Key if this argument isn't specified.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs']]):
        pulumi.set(self, "server_side_encryption", value)

    @property
    @pulumi.getter(name="streamEnabled")
    def stream_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Streams are to be enabled (true) or disabled (false).
        """
        return pulumi.get(self, "stream_enabled")

    @stream_enabled.setter
    def stream_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stream_enabled", value)

    @property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> Optional[pulumi.Input[str]]:
        """
        When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        """
        return pulumi.get(self, "stream_view_type")

    @stream_view_type.setter
    def stream_view_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_view_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input['AwsDynamodbTableV2TtlArgs']]:
        """
        Setup ttl for dynamodb table. Defaults to `false or empty`, To disable ttl, enabled field should be set to false
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input['AwsDynamodbTableV2TtlArgs']]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until dynamodb instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "write_capacity")

    @write_capacity.setter
    def write_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "write_capacity", value)


@pulumi.input_type
class _AwsDynamodbTableV2State:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2AttributeArgs']]]] = None,
                 billing_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 global_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]]] = None,
                 is_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 key_schemas: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2KeySchemaArgs']]]] = None,
                 local_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2LocalSecondaryIndexArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_capacity: Optional[pulumi.Input[int]] = None,
                 server_side_encryption: Optional[pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stream_arn: Optional[pulumi.Input[str]] = None,
                 stream_enabled: Optional[pulumi.Input[bool]] = None,
                 stream_label: Optional[pulumi.Input[str]] = None,
                 stream_view_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2TagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input['AwsDynamodbTableV2TtlArgs']] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 write_capacity: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AwsDynamodbTableV2 resources.
        :param pulumi.Input[str] arn: The ARN of the dynamodb table.
        :param pulumi.Input[str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[bool] deletion_protection_enabled: Deletion protection keeps the tables from being deleted unintentionally. While this setting is on, you can't delete the table.
        :param pulumi.Input[str] fullname: The name of the table, this needs to be unique within a region.
        :param pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]] global_secondary_indices: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc.
        :param pulumi.Input[bool] is_point_in_time_recovery: The point in time recovery status of the dynamodb table. Enabled if true.
        :param pulumi.Input[str] name: The name of the table, this needs to be unique within a region.
        :param pulumi.Input[int] read_capacity: The number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs'] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS owned Customer Master Key if this argument isn't specified.
        :param pulumi.Input[str] status: The status of the dynamodb table.
        :param pulumi.Input[bool] stream_enabled: Indicates whether Streams are to be enabled (true) or disabled (false).
        :param pulumi.Input[str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        :param pulumi.Input['AwsDynamodbTableV2TtlArgs'] ttl: Setup ttl for dynamodb table. Defaults to `false or empty`, To disable ttl, enabled field should be set to false
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until dynamodb instance to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[int] write_capacity: The number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if global_secondary_indices is not None:
            pulumi.set(__self__, "global_secondary_indices", global_secondary_indices)
        if is_point_in_time_recovery is not None:
            pulumi.set(__self__, "is_point_in_time_recovery", is_point_in_time_recovery)
        if key_schemas is not None:
            pulumi.set(__self__, "key_schemas", key_schemas)
        if local_secondary_indices is not None:
            pulumi.set(__self__, "local_secondary_indices", local_secondary_indices)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)
        if stream_enabled is not None:
            pulumi.set(__self__, "stream_enabled", stream_enabled)
        if stream_label is not None:
            pulumi.set(__self__, "stream_label", stream_label)
        if stream_view_type is not None:
            pulumi.set(__self__, "stream_view_type", stream_view_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the dynamodb table.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2AttributeArgs']]]]:
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2AttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_mode", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Deletion protection keeps the tables from being deleted unintentionally. While this setting is on, you can't delete the table.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the table, this needs to be unique within a region.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="globalSecondaryIndices")
    def global_secondary_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]]]:
        """
        Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc.
        """
        return pulumi.get(self, "global_secondary_indices")

    @global_secondary_indices.setter
    def global_secondary_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2GlobalSecondaryIndexArgs']]]]):
        pulumi.set(self, "global_secondary_indices", value)

    @property
    @pulumi.getter(name="isPointInTimeRecovery")
    def is_point_in_time_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        The point in time recovery status of the dynamodb table. Enabled if true.
        """
        return pulumi.get(self, "is_point_in_time_recovery")

    @is_point_in_time_recovery.setter
    def is_point_in_time_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_point_in_time_recovery", value)

    @property
    @pulumi.getter(name="keySchemas")
    def key_schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2KeySchemaArgs']]]]:
        return pulumi.get(self, "key_schemas")

    @key_schemas.setter
    def key_schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2KeySchemaArgs']]]]):
        pulumi.set(self, "key_schemas", value)

    @property
    @pulumi.getter(name="localSecondaryIndices")
    def local_secondary_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2LocalSecondaryIndexArgs']]]]:
        return pulumi.get(self, "local_secondary_indices")

    @local_secondary_indices.setter
    def local_secondary_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2LocalSecondaryIndexArgs']]]]):
        pulumi.set(self, "local_secondary_indices", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the table, this needs to be unique within a region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "read_capacity")

    @read_capacity.setter
    def read_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_capacity", value)

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs']]:
        """
        Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS owned Customer Master Key if this argument isn't specified.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input['AwsDynamodbTableV2ServerSideEncryptionArgs']]):
        pulumi.set(self, "server_side_encryption", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the dynamodb table.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_arn", value)

    @property
    @pulumi.getter(name="streamEnabled")
    def stream_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Streams are to be enabled (true) or disabled (false).
        """
        return pulumi.get(self, "stream_enabled")

    @stream_enabled.setter
    def stream_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stream_enabled", value)

    @property
    @pulumi.getter(name="streamLabel")
    def stream_label(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stream_label")

    @stream_label.setter
    def stream_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_label", value)

    @property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> Optional[pulumi.Input[str]]:
        """
        When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        """
        return pulumi.get(self, "stream_view_type")

    @stream_view_type.setter
    def stream_view_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_view_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsDynamodbTableV2TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the dynamodb table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input['AwsDynamodbTableV2TtlArgs']]:
        """
        Setup ttl for dynamodb table. Defaults to `false or empty`, To disable ttl, enabled field should be set to false
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input['AwsDynamodbTableV2TtlArgs']]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until dynamodb instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "write_capacity")

    @write_capacity.setter
    def write_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "write_capacity", value)


class AwsDynamodbTableV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2AttributeArgs', 'AwsDynamodbTableV2AttributeArgsDict']]]]] = None,
                 billing_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 global_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2GlobalSecondaryIndexArgs', 'AwsDynamodbTableV2GlobalSecondaryIndexArgsDict']]]]] = None,
                 is_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 key_schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2KeySchemaArgs', 'AwsDynamodbTableV2KeySchemaArgsDict']]]]] = None,
                 local_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2LocalSecondaryIndexArgs', 'AwsDynamodbTableV2LocalSecondaryIndexArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_capacity: Optional[pulumi.Input[int]] = None,
                 server_side_encryption: Optional[pulumi.Input[Union['AwsDynamodbTableV2ServerSideEncryptionArgs', 'AwsDynamodbTableV2ServerSideEncryptionArgsDict']]] = None,
                 stream_enabled: Optional[pulumi.Input[bool]] = None,
                 stream_view_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2TagArgs', 'AwsDynamodbTableV2TagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[Union['AwsDynamodbTableV2TtlArgs', 'AwsDynamodbTableV2TtlArgsDict']]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 write_capacity: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        `AwsDynamodbTableV2` manages an AWS dynamodb table in Duplo.

        ## Import

        Example: Importing an existing AWS DynamoDb Table

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of dynamodb table

        # 

        ```sh
        $ pulumi import duplocloud:index/awsDynamodbTableV2:AwsDynamodbTableV2 myDynamodbTable *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[bool] deletion_protection_enabled: Deletion protection keeps the tables from being deleted unintentionally. While this setting is on, you can't delete the table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2GlobalSecondaryIndexArgs', 'AwsDynamodbTableV2GlobalSecondaryIndexArgsDict']]]] global_secondary_indices: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc.
        :param pulumi.Input[bool] is_point_in_time_recovery: The point in time recovery status of the dynamodb table. Enabled if true.
        :param pulumi.Input[str] name: The name of the table, this needs to be unique within a region.
        :param pulumi.Input[int] read_capacity: The number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input[Union['AwsDynamodbTableV2ServerSideEncryptionArgs', 'AwsDynamodbTableV2ServerSideEncryptionArgsDict']] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS owned Customer Master Key if this argument isn't specified.
        :param pulumi.Input[bool] stream_enabled: Indicates whether Streams are to be enabled (true) or disabled (false).
        :param pulumi.Input[str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        :param pulumi.Input[Union['AwsDynamodbTableV2TtlArgs', 'AwsDynamodbTableV2TtlArgsDict']] ttl: Setup ttl for dynamodb table. Defaults to `false or empty`, To disable ttl, enabled field should be set to false
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until dynamodb instance to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[int] write_capacity: The number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsDynamodbTableV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsDynamodbTableV2` manages an AWS dynamodb table in Duplo.

        ## Import

        Example: Importing an existing AWS DynamoDb Table

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of dynamodb table

        # 

        ```sh
        $ pulumi import duplocloud:index/awsDynamodbTableV2:AwsDynamodbTableV2 myDynamodbTable *TENANT_ID*/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsDynamodbTableV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsDynamodbTableV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2AttributeArgs', 'AwsDynamodbTableV2AttributeArgsDict']]]]] = None,
                 billing_mode: Optional[pulumi.Input[str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 global_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2GlobalSecondaryIndexArgs', 'AwsDynamodbTableV2GlobalSecondaryIndexArgsDict']]]]] = None,
                 is_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
                 key_schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2KeySchemaArgs', 'AwsDynamodbTableV2KeySchemaArgsDict']]]]] = None,
                 local_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2LocalSecondaryIndexArgs', 'AwsDynamodbTableV2LocalSecondaryIndexArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_capacity: Optional[pulumi.Input[int]] = None,
                 server_side_encryption: Optional[pulumi.Input[Union['AwsDynamodbTableV2ServerSideEncryptionArgs', 'AwsDynamodbTableV2ServerSideEncryptionArgsDict']]] = None,
                 stream_enabled: Optional[pulumi.Input[bool]] = None,
                 stream_view_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2TagArgs', 'AwsDynamodbTableV2TagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[Union['AwsDynamodbTableV2TtlArgs', 'AwsDynamodbTableV2TtlArgsDict']]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 write_capacity: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsDynamodbTableV2Args.__new__(AwsDynamodbTableV2Args)

            if attributes is None and not opts.urn:
                raise TypeError("Missing required property 'attributes'")
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["billing_mode"] = billing_mode
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["global_secondary_indices"] = global_secondary_indices
            __props__.__dict__["is_point_in_time_recovery"] = is_point_in_time_recovery
            if key_schemas is None and not opts.urn:
                raise TypeError("Missing required property 'key_schemas'")
            __props__.__dict__["key_schemas"] = key_schemas
            __props__.__dict__["local_secondary_indices"] = local_secondary_indices
            __props__.__dict__["name"] = name
            __props__.__dict__["read_capacity"] = read_capacity
            __props__.__dict__["server_side_encryption"] = server_side_encryption
            __props__.__dict__["stream_enabled"] = stream_enabled
            __props__.__dict__["stream_view_type"] = stream_view_type
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["write_capacity"] = write_capacity
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["stream_arn"] = None
            __props__.__dict__["stream_label"] = None
        super(AwsDynamodbTableV2, __self__).__init__(
            'duplocloud:index/awsDynamodbTableV2:AwsDynamodbTableV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2AttributeArgs', 'AwsDynamodbTableV2AttributeArgsDict']]]]] = None,
            billing_mode: Optional[pulumi.Input[str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            global_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2GlobalSecondaryIndexArgs', 'AwsDynamodbTableV2GlobalSecondaryIndexArgsDict']]]]] = None,
            is_point_in_time_recovery: Optional[pulumi.Input[bool]] = None,
            key_schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2KeySchemaArgs', 'AwsDynamodbTableV2KeySchemaArgsDict']]]]] = None,
            local_secondary_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2LocalSecondaryIndexArgs', 'AwsDynamodbTableV2LocalSecondaryIndexArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            read_capacity: Optional[pulumi.Input[int]] = None,
            server_side_encryption: Optional[pulumi.Input[Union['AwsDynamodbTableV2ServerSideEncryptionArgs', 'AwsDynamodbTableV2ServerSideEncryptionArgsDict']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            stream_arn: Optional[pulumi.Input[str]] = None,
            stream_enabled: Optional[pulumi.Input[bool]] = None,
            stream_label: Optional[pulumi.Input[str]] = None,
            stream_view_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2TagArgs', 'AwsDynamodbTableV2TagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[Union['AwsDynamodbTableV2TtlArgs', 'AwsDynamodbTableV2TtlArgsDict']]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None,
            write_capacity: Optional[pulumi.Input[int]] = None) -> 'AwsDynamodbTableV2':
        """
        Get an existing AwsDynamodbTableV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the dynamodb table.
        :param pulumi.Input[str] billing_mode: Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        :param pulumi.Input[bool] deletion_protection_enabled: Deletion protection keeps the tables from being deleted unintentionally. While this setting is on, you can't delete the table.
        :param pulumi.Input[str] fullname: The name of the table, this needs to be unique within a region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsDynamodbTableV2GlobalSecondaryIndexArgs', 'AwsDynamodbTableV2GlobalSecondaryIndexArgsDict']]]] global_secondary_indices: Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc.
        :param pulumi.Input[bool] is_point_in_time_recovery: The point in time recovery status of the dynamodb table. Enabled if true.
        :param pulumi.Input[str] name: The name of the table, this needs to be unique within a region.
        :param pulumi.Input[int] read_capacity: The number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        :param pulumi.Input[Union['AwsDynamodbTableV2ServerSideEncryptionArgs', 'AwsDynamodbTableV2ServerSideEncryptionArgsDict']] server_side_encryption: Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS owned Customer Master Key if this argument isn't specified.
        :param pulumi.Input[str] status: The status of the dynamodb table.
        :param pulumi.Input[bool] stream_enabled: Indicates whether Streams are to be enabled (true) or disabled (false).
        :param pulumi.Input[str] stream_view_type: When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the dynamodb table will be created in.
        :param pulumi.Input[Union['AwsDynamodbTableV2TtlArgs', 'AwsDynamodbTableV2TtlArgsDict']] ttl: Setup ttl for dynamodb table. Defaults to `false or empty`, To disable ttl, enabled field should be set to false
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until dynamodb instance to be ready, after creation. Defaults to `true`.
        :param pulumi.Input[int] write_capacity: The number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsDynamodbTableV2State.__new__(_AwsDynamodbTableV2State)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["billing_mode"] = billing_mode
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["global_secondary_indices"] = global_secondary_indices
        __props__.__dict__["is_point_in_time_recovery"] = is_point_in_time_recovery
        __props__.__dict__["key_schemas"] = key_schemas
        __props__.__dict__["local_secondary_indices"] = local_secondary_indices
        __props__.__dict__["name"] = name
        __props__.__dict__["read_capacity"] = read_capacity
        __props__.__dict__["server_side_encryption"] = server_side_encryption
        __props__.__dict__["status"] = status
        __props__.__dict__["stream_arn"] = stream_arn
        __props__.__dict__["stream_enabled"] = stream_enabled
        __props__.__dict__["stream_label"] = stream_label
        __props__.__dict__["stream_view_type"] = stream_view_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        __props__.__dict__["write_capacity"] = write_capacity
        return AwsDynamodbTableV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the dynamodb table.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence['outputs.AwsDynamodbTableV2Attribute']]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Controls how you are charged for read and write throughput and how you manage capacity. The valid values are `PROVISIONED` and `PAY_PER_REQUEST`. Defaults to `PROVISIONED`.
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[bool]:
        """
        Deletion protection keeps the tables from being deleted unintentionally. While this setting is on, you can't delete the table.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The name of the table, this needs to be unique within a region.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="globalSecondaryIndices")
    def global_secondary_indices(self) -> pulumi.Output[Optional[Sequence['outputs.AwsDynamodbTableV2GlobalSecondaryIndex']]]:
        """
        Describe a GSI for the table; subject to the normal limits on the number of GSIs, projected attributes, etc.
        """
        return pulumi.get(self, "global_secondary_indices")

    @property
    @pulumi.getter(name="isPointInTimeRecovery")
    def is_point_in_time_recovery(self) -> pulumi.Output[bool]:
        """
        The point in time recovery status of the dynamodb table. Enabled if true.
        """
        return pulumi.get(self, "is_point_in_time_recovery")

    @property
    @pulumi.getter(name="keySchemas")
    def key_schemas(self) -> pulumi.Output[Sequence['outputs.AwsDynamodbTableV2KeySchema']]:
        return pulumi.get(self, "key_schemas")

    @property
    @pulumi.getter(name="localSecondaryIndices")
    def local_secondary_indices(self) -> pulumi.Output[Optional[Sequence['outputs.AwsDynamodbTableV2LocalSecondaryIndex']]]:
        return pulumi.get(self, "local_secondary_indices")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the table, this needs to be unique within a region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        The number of read units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "read_capacity")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> pulumi.Output['outputs.AwsDynamodbTableV2ServerSideEncryption']:
        """
        Encryption at rest options. AWS DynamoDB tables are automatically encrypted at rest with an AWS owned Customer Master Key if this argument isn't specified.
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the dynamodb table.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "stream_arn")

    @property
    @pulumi.getter(name="streamEnabled")
    def stream_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether Streams are to be enabled (true) or disabled (false).
        """
        return pulumi.get(self, "stream_enabled")

    @property
    @pulumi.getter(name="streamLabel")
    def stream_label(self) -> pulumi.Output[str]:
        return pulumi.get(self, "stream_label")

    @property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> pulumi.Output[str]:
        """
        When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values are `KEYS_ONLY`, `NEW_IMAGE`, `OLD_IMAGE`, `NEW_AND_OLD_IMAGES`.
        """
        return pulumi.get(self, "stream_view_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AwsDynamodbTableV2Tag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the dynamodb table will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional['outputs.AwsDynamodbTableV2Ttl']]:
        """
        Setup ttl for dynamodb table. Defaults to `false or empty`, To disable ttl, enabled field should be set to false
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until dynamodb instance to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        The number of write units for this table. If the `billing_mode` is `PROVISIONED`, this field is required.
        """
        return pulumi.get(self, "write_capacity")

