# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsEfsFileSystemArgs', 'AwsEfsFileSystem']

@pulumi.input_type
class AwsEfsFileSystemArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 backup: Optional[pulumi.Input[bool]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemLifecyclePolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemTagArgs']]]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AwsEfsFileSystem resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the efs file system will be created in.
        :param pulumi.Input[bool] backup: Specifies whether automatic backups are enabled on the file system that you are creating.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed) used as reference when creating the Elastic File System to ensure idempotent file system creation.
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] name: The name of the EFS, this needs to be unique within a region.
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `generalPurpose` or `maxIO`. Defaults to `generalPurpose`.
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. When using `provisioned`, also set `provisioned_throughput_in_mibps`. Defaults to `bursting`.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until EFS to be available, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if creation_token is not None:
            pulumi.set(__self__, "creation_token", creation_token)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if lifecycle_policies is not None:
            pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_mode is not None:
            pulumi.set(__self__, "performance_mode", performance_mode)
        if provisioned_throughput_in_mibps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mibps", provisioned_throughput_in_mibps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the efs file system will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether automatic backups are enabled on the file system that you are creating.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="creationToken")
    def creation_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name (a maximum of 64 characters are allowed) used as reference when creating the Elastic File System to ensure idempotent file system creation.
        """
        return pulumi.get(self, "creation_token")

    @creation_token.setter
    def creation_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_token", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the disk will be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemLifecyclePolicyArgs']]]]:
        return pulumi.get(self, "lifecycle_policies")

    @lifecycle_policies.setter
    def lifecycle_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemLifecyclePolicyArgs']]]]):
        pulumi.set(self, "lifecycle_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the EFS, this needs to be unique within a region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceMode")
    def performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The file system performance mode. Can be either `generalPurpose` or `maxIO`. Defaults to `generalPurpose`.
        """
        return pulumi.get(self, "performance_mode")

    @performance_mode.setter
    def performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_mode", value)

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> Optional[pulumi.Input[float]]:
        """
        The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        """
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @provisioned_throughput_in_mibps.setter
    def provisioned_throughput_in_mibps(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "provisioned_throughput_in_mibps", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Throughput mode for the file system. When using `provisioned`, also set `provisioned_throughput_in_mibps`. Defaults to `bursting`.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_mode", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until EFS to be available, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _AwsEfsFileSystemState:
    def __init__(__self__, *,
                 backup: Optional[pulumi.Input[bool]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 file_system_arn: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemLifecyclePolicyArgs']]]] = None,
                 mount_targets: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemMountTargetArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_mount_targets: Optional[pulumi.Input[int]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 size_in_bytes: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AwsEfsFileSystem resources.
        :param pulumi.Input[bool] backup: Specifies whether automatic backups are enabled on the file system that you are creating.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed) used as reference when creating the Elastic File System to ensure idempotent file system creation.
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] file_system_arn: Amazon Resource Name of the file system.
        :param pulumi.Input[str] file_system_id: The ID that identifies the file system.
        :param pulumi.Input[str] fullname: Duplo generated name of the EFS.
        :param pulumi.Input[str] name: The name of the EFS, this needs to be unique within a region.
        :param pulumi.Input[int] number_of_mount_targets: The current number of mount targets that the file system has.
        :param pulumi.Input[str] owner_id: The AWS account that created the file system.
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `generalPurpose` or `maxIO`. Defaults to `generalPurpose`.
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[int] size_in_bytes: The latest known metered size (in bytes) of data stored in the file system.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the efs file system will be created in.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. When using `provisioned`, also set `provisioned_throughput_in_mibps`. Defaults to `bursting`.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until EFS to be available, after creation. Defaults to `true`.
        """
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if creation_token is not None:
            pulumi.set(__self__, "creation_token", creation_token)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if file_system_arn is not None:
            pulumi.set(__self__, "file_system_arn", file_system_arn)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if lifecycle_policies is not None:
            pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if mount_targets is not None:
            pulumi.set(__self__, "mount_targets", mount_targets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_mount_targets is not None:
            pulumi.set(__self__, "number_of_mount_targets", number_of_mount_targets)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if performance_mode is not None:
            pulumi.set(__self__, "performance_mode", performance_mode)
        if provisioned_throughput_in_mibps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mibps", provisioned_throughput_in_mibps)
        if size_in_bytes is not None:
            pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether automatic backups are enabled on the file system that you are creating.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="creationToken")
    def creation_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name (a maximum of 64 characters are allowed) used as reference when creating the Elastic File System to ensure idempotent file system creation.
        """
        return pulumi.get(self, "creation_token")

    @creation_token.setter
    def creation_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_token", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the disk will be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="fileSystemArn")
    def file_system_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "file_system_arn")

    @file_system_arn.setter
    def file_system_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_arn", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID that identifies the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        Duplo generated name of the EFS.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemLifecyclePolicyArgs']]]]:
        return pulumi.get(self, "lifecycle_policies")

    @lifecycle_policies.setter
    def lifecycle_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemLifecyclePolicyArgs']]]]):
        pulumi.set(self, "lifecycle_policies", value)

    @property
    @pulumi.getter(name="mountTargets")
    def mount_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemMountTargetArgs']]]]:
        return pulumi.get(self, "mount_targets")

    @mount_targets.setter
    def mount_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemMountTargetArgs']]]]):
        pulumi.set(self, "mount_targets", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the EFS, this needs to be unique within a region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfMountTargets")
    def number_of_mount_targets(self) -> Optional[pulumi.Input[int]]:
        """
        The current number of mount targets that the file system has.
        """
        return pulumi.get(self, "number_of_mount_targets")

    @number_of_mount_targets.setter
    def number_of_mount_targets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_mount_targets", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="performanceMode")
    def performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The file system performance mode. Can be either `generalPurpose` or `maxIO`. Defaults to `generalPurpose`.
        """
        return pulumi.get(self, "performance_mode")

    @performance_mode.setter
    def performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_mode", value)

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> Optional[pulumi.Input[float]]:
        """
        The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        """
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @provisioned_throughput_in_mibps.setter
    def provisioned_throughput_in_mibps(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "provisioned_throughput_in_mibps", value)

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The latest known metered size (in bytes) of data stored in the file system.
        """
        return pulumi.get(self, "size_in_bytes")

    @size_in_bytes.setter
    def size_in_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_bytes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsFileSystemTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the efs file system will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Throughput mode for the file system. When using `provisioned`, also set `provisioned_throughput_in_mibps`. Defaults to `bursting`.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throughput_mode", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until EFS to be available, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class AwsEfsFileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[bool]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsFileSystemLifecyclePolicyArgs', 'AwsEfsFileSystemLifecyclePolicyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsFileSystemTagArgs', 'AwsEfsFileSystemTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `AwsEfsFileSystem` Provides an Elastic File System (EFS) File System resource in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        efs = duplocloud.AwsEfsFileSystem("efs",
            tenant_id=myapp.tenant_id,
            name="efs-test",
            performance_mode="generalPurpose",
            throughput_mode="bursting",
            backup=False,
            encrypted=False)
        ```

        ## Import

        Example: Importing an existing AWS EFS

         - *TENANT_ID* is the tenant GUID

         - *EFS_ID* is the AWS EFS ID

        # 

        ```sh
        $ pulumi import duplocloud:index/awsEfsFileSystem:AwsEfsFileSystem efs *TENANT_ID*/*EFS_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backup: Specifies whether automatic backups are enabled on the file system that you are creating.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed) used as reference when creating the Elastic File System to ensure idempotent file system creation.
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] name: The name of the EFS, this needs to be unique within a region.
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `generalPurpose` or `maxIO`. Defaults to `generalPurpose`.
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the efs file system will be created in.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. When using `provisioned`, also set `provisioned_throughput_in_mibps`. Defaults to `bursting`.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until EFS to be available, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsEfsFileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsEfsFileSystem` Provides an Elastic File System (EFS) File System resource in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        efs = duplocloud.AwsEfsFileSystem("efs",
            tenant_id=myapp.tenant_id,
            name="efs-test",
            performance_mode="generalPurpose",
            throughput_mode="bursting",
            backup=False,
            encrypted=False)
        ```

        ## Import

        Example: Importing an existing AWS EFS

         - *TENANT_ID* is the tenant GUID

         - *EFS_ID* is the AWS EFS ID

        # 

        ```sh
        $ pulumi import duplocloud:index/awsEfsFileSystem:AwsEfsFileSystem efs *TENANT_ID*/*EFS_ID*
        ```

        :param str resource_name: The name of the resource.
        :param AwsEfsFileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsEfsFileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[bool]] = None,
                 creation_token: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsFileSystemLifecyclePolicyArgs', 'AwsEfsFileSystemLifecyclePolicyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_mode: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsFileSystemTagArgs', 'AwsEfsFileSystemTagArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 throughput_mode: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsEfsFileSystemArgs.__new__(AwsEfsFileSystemArgs)

            __props__.__dict__["backup"] = backup
            __props__.__dict__["creation_token"] = creation_token
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["lifecycle_policies"] = lifecycle_policies
            __props__.__dict__["name"] = name
            __props__.__dict__["performance_mode"] = performance_mode
            __props__.__dict__["provisioned_throughput_in_mibps"] = provisioned_throughput_in_mibps
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["throughput_mode"] = throughput_mode
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["file_system_arn"] = None
            __props__.__dict__["file_system_id"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["mount_targets"] = None
            __props__.__dict__["number_of_mount_targets"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["size_in_bytes"] = None
        super(AwsEfsFileSystem, __self__).__init__(
            'duplocloud:index/awsEfsFileSystem:AwsEfsFileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup: Optional[pulumi.Input[bool]] = None,
            creation_token: Optional[pulumi.Input[str]] = None,
            encrypted: Optional[pulumi.Input[bool]] = None,
            file_system_arn: Optional[pulumi.Input[str]] = None,
            file_system_id: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsFileSystemLifecyclePolicyArgs', 'AwsEfsFileSystemLifecyclePolicyArgsDict']]]]] = None,
            mount_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsFileSystemMountTargetArgs', 'AwsEfsFileSystemMountTargetArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_mount_targets: Optional[pulumi.Input[int]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            performance_mode: Optional[pulumi.Input[str]] = None,
            provisioned_throughput_in_mibps: Optional[pulumi.Input[float]] = None,
            size_in_bytes: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsFileSystemTagArgs', 'AwsEfsFileSystemTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            throughput_mode: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'AwsEfsFileSystem':
        """
        Get an existing AwsEfsFileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backup: Specifies whether automatic backups are enabled on the file system that you are creating.
        :param pulumi.Input[str] creation_token: A unique name (a maximum of 64 characters are allowed) used as reference when creating the Elastic File System to ensure idempotent file system creation.
        :param pulumi.Input[bool] encrypted: If true, the disk will be encrypted.
        :param pulumi.Input[str] file_system_arn: Amazon Resource Name of the file system.
        :param pulumi.Input[str] file_system_id: The ID that identifies the file system.
        :param pulumi.Input[str] fullname: Duplo generated name of the EFS.
        :param pulumi.Input[str] name: The name of the EFS, this needs to be unique within a region.
        :param pulumi.Input[int] number_of_mount_targets: The current number of mount targets that the file system has.
        :param pulumi.Input[str] owner_id: The AWS account that created the file system.
        :param pulumi.Input[str] performance_mode: The file system performance mode. Can be either `generalPurpose` or `maxIO`. Defaults to `generalPurpose`.
        :param pulumi.Input[float] provisioned_throughput_in_mibps: The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        :param pulumi.Input[int] size_in_bytes: The latest known metered size (in bytes) of data stored in the file system.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the efs file system will be created in.
        :param pulumi.Input[str] throughput_mode: Throughput mode for the file system. When using `provisioned`, also set `provisioned_throughput_in_mibps`. Defaults to `bursting`.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until EFS to be available, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsEfsFileSystemState.__new__(_AwsEfsFileSystemState)

        __props__.__dict__["backup"] = backup
        __props__.__dict__["creation_token"] = creation_token
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["file_system_arn"] = file_system_arn
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["lifecycle_policies"] = lifecycle_policies
        __props__.__dict__["mount_targets"] = mount_targets
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_mount_targets"] = number_of_mount_targets
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["performance_mode"] = performance_mode
        __props__.__dict__["provisioned_throughput_in_mibps"] = provisioned_throughput_in_mibps
        __props__.__dict__["size_in_bytes"] = size_in_bytes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["throughput_mode"] = throughput_mode
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return AwsEfsFileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output[bool]:
        """
        Specifies whether automatic backups are enabled on the file system that you are creating.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="creationToken")
    def creation_token(self) -> pulumi.Output[str]:
        """
        A unique name (a maximum of 64 characters are allowed) used as reference when creating the Elastic File System to ensure idempotent file system creation.
        """
        return pulumi.get(self, "creation_token")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[bool]:
        """
        If true, the disk will be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="fileSystemArn")
    def file_system_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "file_system_arn")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        """
        The ID that identifies the file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        Duplo generated name of the EFS.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> pulumi.Output[Optional[Sequence['outputs.AwsEfsFileSystemLifecyclePolicy']]]:
        return pulumi.get(self, "lifecycle_policies")

    @property
    @pulumi.getter(name="mountTargets")
    def mount_targets(self) -> pulumi.Output[Sequence['outputs.AwsEfsFileSystemMountTarget']]:
        return pulumi.get(self, "mount_targets")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the EFS, this needs to be unique within a region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfMountTargets")
    def number_of_mount_targets(self) -> pulumi.Output[int]:
        """
        The current number of mount targets that the file system has.
        """
        return pulumi.get(self, "number_of_mount_targets")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The AWS account that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="performanceMode")
    def performance_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The file system performance mode. Can be either `generalPurpose` or `maxIO`. Defaults to `generalPurpose`.
        """
        return pulumi.get(self, "performance_mode")

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> pulumi.Output[float]:
        """
        The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
        """
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> pulumi.Output[int]:
        """
        The latest known metered size (in bytes) of data stored in the file system.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AwsEfsFileSystemTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the efs file system will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Throughput mode for the file system. When using `provisioned`, also set `provisioned_throughput_in_mibps`. Defaults to `bursting`.
        """
        return pulumi.get(self, "throughput_mode")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until EFS to be available, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

