# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsEfsLifecyclePolicyArgs', 'AwsEfsLifecyclePolicy']

@pulumi.input_type
class AwsEfsLifecyclePolicyArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[str],
                 lifecycle_policies: pulumi.Input[Sequence[pulumi.Input['AwsEfsLifecyclePolicyLifecyclePolicyArgs']]],
                 tenant_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AwsEfsLifecyclePolicy resource.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> pulumi.Input[Sequence[pulumi.Input['AwsEfsLifecyclePolicyLifecyclePolicyArgs']]]:
        return pulumi.get(self, "lifecycle_policies")

    @lifecycle_policies.setter
    def lifecycle_policies(self, value: pulumi.Input[Sequence[pulumi.Input['AwsEfsLifecyclePolicyLifecyclePolicyArgs']]]):
        pulumi.set(self, "lifecycle_policies", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _AwsEfsLifecyclePolicyState:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsLifecyclePolicyLifecyclePolicyArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsEfsLifecyclePolicy resources.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if lifecycle_policies is not None:
            pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsLifecyclePolicyLifecyclePolicyArgs']]]]:
        return pulumi.get(self, "lifecycle_policies")

    @lifecycle_policies.setter
    def lifecycle_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsEfsLifecyclePolicyLifecyclePolicyArgs']]]]):
        pulumi.set(self, "lifecycle_policies", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsEfsLifecyclePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsLifecyclePolicyLifecyclePolicyArgs', 'AwsEfsLifecyclePolicyLifecyclePolicyArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsEfsLifecyclePolicy` Provides an Elastic File System (EFS) File System Lifecycle Policy resource in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        efs = duplocloud.AwsEfsFileSystem("efs",
            tenant_id=myapp.tenant_id,
            name="efs-test",
            performance_mode="generalPurpose",
            throughput_mode="elastic",
            backup=True,
            encrypted=True)
        efs_policy = duplocloud.AwsEfsLifecyclePolicy("efs_policy",
            tenant_id=myapp.tenant_id,
            file_system_id=efs.file_system_id,
            lifecycle_policies=[
                {
                    "transition_to_ia": "AFTER_7_DAYS",
                },
                {
                    "transition_to_archive": "AFTER_14_DAYS",
                },
                {
                    "transition_to_primary_storage_class": "AFTER_1_ACCESS",
                },
            ])
        ```

        ## Import

        Example: Importing an existing AWS Elastic File System

         - *TENANT_ID* is the tenant GUID

         - *FILE_SYSTEM_ID* is the ID of the AWS Elastic File System

        # 

        ```sh
        $ pulumi import duplocloud:index/awsEfsLifecyclePolicy:AwsEfsLifecyclePolicy efslifecycle *TENANT_ID*/*FILE_SYSTEM_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsEfsLifecyclePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsEfsLifecyclePolicy` Provides an Elastic File System (EFS) File System Lifecycle Policy resource in DuploCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        efs = duplocloud.AwsEfsFileSystem("efs",
            tenant_id=myapp.tenant_id,
            name="efs-test",
            performance_mode="generalPurpose",
            throughput_mode="elastic",
            backup=True,
            encrypted=True)
        efs_policy = duplocloud.AwsEfsLifecyclePolicy("efs_policy",
            tenant_id=myapp.tenant_id,
            file_system_id=efs.file_system_id,
            lifecycle_policies=[
                {
                    "transition_to_ia": "AFTER_7_DAYS",
                },
                {
                    "transition_to_archive": "AFTER_14_DAYS",
                },
                {
                    "transition_to_primary_storage_class": "AFTER_1_ACCESS",
                },
            ])
        ```

        ## Import

        Example: Importing an existing AWS Elastic File System

         - *TENANT_ID* is the tenant GUID

         - *FILE_SYSTEM_ID* is the ID of the AWS Elastic File System

        # 

        ```sh
        $ pulumi import duplocloud:index/awsEfsLifecyclePolicy:AwsEfsLifecyclePolicy efslifecycle *TENANT_ID*/*FILE_SYSTEM_ID*
        ```

        :param str resource_name: The name of the resource.
        :param AwsEfsLifecyclePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsEfsLifecyclePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsLifecyclePolicyLifecyclePolicyArgs', 'AwsEfsLifecyclePolicyLifecyclePolicyArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsEfsLifecyclePolicyArgs.__new__(AwsEfsLifecyclePolicyArgs)

            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if lifecycle_policies is None and not opts.urn:
                raise TypeError("Missing required property 'lifecycle_policies'")
            __props__.__dict__["lifecycle_policies"] = lifecycle_policies
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AwsEfsLifecyclePolicy, __self__).__init__(
            'duplocloud:index/awsEfsLifecyclePolicy:AwsEfsLifecyclePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            file_system_id: Optional[pulumi.Input[str]] = None,
            lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsEfsLifecyclePolicyLifecyclePolicyArgs', 'AwsEfsLifecyclePolicyLifecyclePolicyArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsEfsLifecyclePolicy':
        """
        Get an existing AwsEfsLifecyclePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsEfsLifecyclePolicyState.__new__(_AwsEfsLifecyclePolicyState)

        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["lifecycle_policies"] = lifecycle_policies
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsEfsLifecyclePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> pulumi.Output[Sequence['outputs.AwsEfsLifecyclePolicyLifecyclePolicy']]:
        return pulumi.get(self, "lifecycle_policies")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "tenant_id")

