# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsElasticsearchArgs', 'AwsElasticsearch']

@pulumi.input_type
class AwsElasticsearchArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 cluster_config: Optional[pulumi.Input['AwsElasticsearchClusterConfigArgs']] = None,
                 elasticsearch_version: Optional[pulumi.Input[str]] = None,
                 enable_node_to_node_encryption: Optional[pulumi.Input[bool]] = None,
                 encrypt_at_rest: Optional[pulumi.Input['AwsElasticsearchEncryptAtRestArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None,
                 selected_zone: Optional[pulumi.Input[int]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 use_latest_tls_cipher: Optional[pulumi.Input[bool]] = None,
                 vpc_options: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchVpcOptionArgs']]]] = None):
        """
        The set of arguments for constructing a AwsElasticsearch resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the ElasticSearch instance will be created in.
        :param pulumi.Input[str] elasticsearch_version: The version of the ElasticSearch instance. Defaults to `7.9`.
        :param pulumi.Input[bool] enable_node_to_node_encryption: Whether or not to use the enable node-to-node encryption for this ElasticSearch instance.
        :param pulumi.Input['AwsElasticsearchEncryptAtRestArgs'] encrypt_at_rest: The storage encryption settings for the ElasticSearch instance.
        :param pulumi.Input[str] name: The short name of the ElasticSearch instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `domain_name` attribute.
        :param pulumi.Input[bool] require_ssl: Whether or not to require SSL for accessing this ElasticSearch instance.
        :param pulumi.Input[int] selected_zone: The numerical index of the zone to launch this ElasticSearch instance in.
        :param pulumi.Input[int] storage_size: The storage volume size, in GB, for the ElasticSearch instance.
        :param pulumi.Input[bool] use_latest_tls_cipher: Whether or not to use the latest TLS cipher for this ElasticSearch instance. For govcloud environments this should be set to true
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if elasticsearch_version is not None:
            pulumi.set(__self__, "elasticsearch_version", elasticsearch_version)
        if enable_node_to_node_encryption is not None:
            pulumi.set(__self__, "enable_node_to_node_encryption", enable_node_to_node_encryption)
        if encrypt_at_rest is not None:
            pulumi.set(__self__, "encrypt_at_rest", encrypt_at_rest)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)
        if selected_zone is not None:
            pulumi.set(__self__, "selected_zone", selected_zone)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if use_latest_tls_cipher is not None:
            pulumi.set(__self__, "use_latest_tls_cipher", use_latest_tls_cipher)
        if vpc_options is not None:
            pulumi.set(__self__, "vpc_options", vpc_options)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the ElasticSearch instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['AwsElasticsearchClusterConfigArgs']]:
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['AwsElasticsearchClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @property
    @pulumi.getter(name="elasticsearchVersion")
    def elasticsearch_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the ElasticSearch instance. Defaults to `7.9`.
        """
        return pulumi.get(self, "elasticsearch_version")

    @elasticsearch_version.setter
    def elasticsearch_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_version", value)

    @property
    @pulumi.getter(name="enableNodeToNodeEncryption")
    def enable_node_to_node_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use the enable node-to-node encryption for this ElasticSearch instance.
        """
        return pulumi.get(self, "enable_node_to_node_encryption")

    @enable_node_to_node_encryption.setter
    def enable_node_to_node_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_to_node_encryption", value)

    @property
    @pulumi.getter(name="encryptAtRest")
    def encrypt_at_rest(self) -> Optional[pulumi.Input['AwsElasticsearchEncryptAtRestArgs']]:
        """
        The storage encryption settings for the ElasticSearch instance.
        """
        return pulumi.get(self, "encrypt_at_rest")

    @encrypt_at_rest.setter
    def encrypt_at_rest(self, value: Optional[pulumi.Input['AwsElasticsearchEncryptAtRestArgs']]):
        pulumi.set(self, "encrypt_at_rest", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the ElasticSearch instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `domain_name` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to require SSL for accessing this ElasticSearch instance.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)

    @property
    @pulumi.getter(name="selectedZone")
    def selected_zone(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of the zone to launch this ElasticSearch instance in.
        """
        return pulumi.get(self, "selected_zone")

    @selected_zone.setter
    def selected_zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "selected_zone", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        The storage volume size, in GB, for the ElasticSearch instance.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size", value)

    @property
    @pulumi.getter(name="useLatestTlsCipher")
    def use_latest_tls_cipher(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use the latest TLS cipher for this ElasticSearch instance. For govcloud environments this should be set to true
        """
        return pulumi.get(self, "use_latest_tls_cipher")

    @use_latest_tls_cipher.setter
    def use_latest_tls_cipher(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_tls_cipher", value)

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchVpcOptionArgs']]]]:
        return pulumi.get(self, "vpc_options")

    @vpc_options.setter
    def vpc_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchVpcOptionArgs']]]]):
        pulumi.set(self, "vpc_options", value)


@pulumi.input_type
class _AwsElasticsearchState:
    def __init__(__self__, *,
                 access_policies: Optional[pulumi.Input[str]] = None,
                 advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 cluster_config: Optional[pulumi.Input['AwsElasticsearchClusterConfigArgs']] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 ebs_options: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchEbsOptionArgs']]]] = None,
                 elasticsearch_version: Optional[pulumi.Input[str]] = None,
                 enable_node_to_node_encryption: Optional[pulumi.Input[bool]] = None,
                 encrypt_at_rest: Optional[pulumi.Input['AwsElasticsearchEncryptAtRestArgs']] = None,
                 endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None,
                 selected_zone: Optional[pulumi.Input[int]] = None,
                 snapshot_options: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchSnapshotOptionArgs']]]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_latest_tls_cipher: Optional[pulumi.Input[bool]] = None,
                 vpc_options: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchVpcOptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering AwsElasticsearch resources.
        :param pulumi.Input[str] arn: The ARN of the ElasticSearch instance.
        :param pulumi.Input[str] domain_id: The domain ID of the ElasticSearch instance.
        :param pulumi.Input[str] domain_name: The full name of the ElasticSearch instance.
        :param pulumi.Input[str] elasticsearch_version: The version of the ElasticSearch instance. Defaults to `7.9`.
        :param pulumi.Input[bool] enable_node_to_node_encryption: Whether or not to use the enable node-to-node encryption for this ElasticSearch instance.
        :param pulumi.Input['AwsElasticsearchEncryptAtRestArgs'] encrypt_at_rest: The storage encryption settings for the ElasticSearch instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoints: The endpoints to use when connecting to the ElasticSearch instance.
        :param pulumi.Input[str] name: The short name of the ElasticSearch instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `domain_name` attribute.
        :param pulumi.Input[bool] require_ssl: Whether or not to require SSL for accessing this ElasticSearch instance.
        :param pulumi.Input[int] selected_zone: The numerical index of the zone to launch this ElasticSearch instance in.
        :param pulumi.Input[int] storage_size: The storage volume size, in GB, for the ElasticSearch instance.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the ElasticSearch instance will be created in.
        :param pulumi.Input[bool] use_latest_tls_cipher: Whether or not to use the latest TLS cipher for this ElasticSearch instance. For govcloud environments this should be set to true
        """
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if ebs_options is not None:
            pulumi.set(__self__, "ebs_options", ebs_options)
        if elasticsearch_version is not None:
            pulumi.set(__self__, "elasticsearch_version", elasticsearch_version)
        if enable_node_to_node_encryption is not None:
            pulumi.set(__self__, "enable_node_to_node_encryption", enable_node_to_node_encryption)
        if encrypt_at_rest is not None:
            pulumi.set(__self__, "encrypt_at_rest", encrypt_at_rest)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)
        if selected_zone is not None:
            pulumi.set(__self__, "selected_zone", selected_zone)
        if snapshot_options is not None:
            pulumi.set(__self__, "snapshot_options", snapshot_options)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_latest_tls_cipher is not None:
            pulumi.set(__self__, "use_latest_tls_cipher", use_latest_tls_cipher)
        if vpc_options is not None:
            pulumi.set(__self__, "vpc_options", vpc_options)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policies", value)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "advanced_options")

    @advanced_options.setter
    def advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "advanced_options", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the ElasticSearch instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['AwsElasticsearchClusterConfigArgs']]:
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['AwsElasticsearchClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        The domain ID of the ElasticSearch instance.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the ElasticSearch instance.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="ebsOptions")
    def ebs_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchEbsOptionArgs']]]]:
        return pulumi.get(self, "ebs_options")

    @ebs_options.setter
    def ebs_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchEbsOptionArgs']]]]):
        pulumi.set(self, "ebs_options", value)

    @property
    @pulumi.getter(name="elasticsearchVersion")
    def elasticsearch_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the ElasticSearch instance. Defaults to `7.9`.
        """
        return pulumi.get(self, "elasticsearch_version")

    @elasticsearch_version.setter
    def elasticsearch_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_version", value)

    @property
    @pulumi.getter(name="enableNodeToNodeEncryption")
    def enable_node_to_node_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use the enable node-to-node encryption for this ElasticSearch instance.
        """
        return pulumi.get(self, "enable_node_to_node_encryption")

    @enable_node_to_node_encryption.setter
    def enable_node_to_node_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_to_node_encryption", value)

    @property
    @pulumi.getter(name="encryptAtRest")
    def encrypt_at_rest(self) -> Optional[pulumi.Input['AwsElasticsearchEncryptAtRestArgs']]:
        """
        The storage encryption settings for the ElasticSearch instance.
        """
        return pulumi.get(self, "encrypt_at_rest")

    @encrypt_at_rest.setter
    def encrypt_at_rest(self, value: Optional[pulumi.Input['AwsElasticsearchEncryptAtRestArgs']]):
        pulumi.set(self, "encrypt_at_rest", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The endpoints to use when connecting to the ElasticSearch instance.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the ElasticSearch instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `domain_name` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to require SSL for accessing this ElasticSearch instance.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)

    @property
    @pulumi.getter(name="selectedZone")
    def selected_zone(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of the zone to launch this ElasticSearch instance in.
        """
        return pulumi.get(self, "selected_zone")

    @selected_zone.setter
    def selected_zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "selected_zone", value)

    @property
    @pulumi.getter(name="snapshotOptions")
    def snapshot_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchSnapshotOptionArgs']]]]:
        return pulumi.get(self, "snapshot_options")

    @snapshot_options.setter
    def snapshot_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchSnapshotOptionArgs']]]]):
        pulumi.set(self, "snapshot_options", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        The storage volume size, in GB, for the ElasticSearch instance.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the ElasticSearch instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useLatestTlsCipher")
    def use_latest_tls_cipher(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use the latest TLS cipher for this ElasticSearch instance. For govcloud environments this should be set to true
        """
        return pulumi.get(self, "use_latest_tls_cipher")

    @use_latest_tls_cipher.setter
    def use_latest_tls_cipher(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_tls_cipher", value)

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchVpcOptionArgs']]]]:
        return pulumi.get(self, "vpc_options")

    @vpc_options.setter
    def vpc_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsElasticsearchVpcOptionArgs']]]]):
        pulumi.set(self, "vpc_options", value)


class AwsElasticsearch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_config: Optional[pulumi.Input[Union['AwsElasticsearchClusterConfigArgs', 'AwsElasticsearchClusterConfigArgsDict']]] = None,
                 elasticsearch_version: Optional[pulumi.Input[str]] = None,
                 enable_node_to_node_encryption: Optional[pulumi.Input[bool]] = None,
                 encrypt_at_rest: Optional[pulumi.Input[Union['AwsElasticsearchEncryptAtRestArgs', 'AwsElasticsearchEncryptAtRestArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None,
                 selected_zone: Optional[pulumi.Input[int]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_latest_tls_cipher: Optional[pulumi.Input[bool]] = None,
                 vpc_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsElasticsearchVpcOptionArgs', 'AwsElasticsearchVpcOptionArgsDict']]]]] = None,
                 __props__=None):
        """
        `AwsElasticsearch` manages an AWS ElasticSearch instance in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Minimal example
        sample = duplocloud.AwsElasticsearch("sample",
            tenant_id=myapp.tenant_id,
            name="sample")
        # Example with hardened settings
        es_doc = duplocloud.AwsElasticsearch("es-doc",
            tenant_id=myapp.tenant_id,
            name="es-doc",
            enable_node_to_node_encryption=True,
            require_ssl=True,
            use_latest_tls_cipher=True)
        ```

        ## Import

        Example: Importing an existing AWS ElasticSearch cluster

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS ElasticSearch cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/awsElasticsearch:AwsElasticsearch mycluster *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] elasticsearch_version: The version of the ElasticSearch instance. Defaults to `7.9`.
        :param pulumi.Input[bool] enable_node_to_node_encryption: Whether or not to use the enable node-to-node encryption for this ElasticSearch instance.
        :param pulumi.Input[Union['AwsElasticsearchEncryptAtRestArgs', 'AwsElasticsearchEncryptAtRestArgsDict']] encrypt_at_rest: The storage encryption settings for the ElasticSearch instance.
        :param pulumi.Input[str] name: The short name of the ElasticSearch instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `domain_name` attribute.
        :param pulumi.Input[bool] require_ssl: Whether or not to require SSL for accessing this ElasticSearch instance.
        :param pulumi.Input[int] selected_zone: The numerical index of the zone to launch this ElasticSearch instance in.
        :param pulumi.Input[int] storage_size: The storage volume size, in GB, for the ElasticSearch instance.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the ElasticSearch instance will be created in.
        :param pulumi.Input[bool] use_latest_tls_cipher: Whether or not to use the latest TLS cipher for this ElasticSearch instance. For govcloud environments this should be set to true
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsElasticsearchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsElasticsearch` manages an AWS ElasticSearch instance in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Minimal example
        sample = duplocloud.AwsElasticsearch("sample",
            tenant_id=myapp.tenant_id,
            name="sample")
        # Example with hardened settings
        es_doc = duplocloud.AwsElasticsearch("es-doc",
            tenant_id=myapp.tenant_id,
            name="es-doc",
            enable_node_to_node_encryption=True,
            require_ssl=True,
            use_latest_tls_cipher=True)
        ```

        ## Import

        Example: Importing an existing AWS ElasticSearch cluster

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS ElasticSearch cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/awsElasticsearch:AwsElasticsearch mycluster *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsElasticsearchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsElasticsearchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_config: Optional[pulumi.Input[Union['AwsElasticsearchClusterConfigArgs', 'AwsElasticsearchClusterConfigArgsDict']]] = None,
                 elasticsearch_version: Optional[pulumi.Input[str]] = None,
                 enable_node_to_node_encryption: Optional[pulumi.Input[bool]] = None,
                 encrypt_at_rest: Optional[pulumi.Input[Union['AwsElasticsearchEncryptAtRestArgs', 'AwsElasticsearchEncryptAtRestArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None,
                 selected_zone: Optional[pulumi.Input[int]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_latest_tls_cipher: Optional[pulumi.Input[bool]] = None,
                 vpc_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsElasticsearchVpcOptionArgs', 'AwsElasticsearchVpcOptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsElasticsearchArgs.__new__(AwsElasticsearchArgs)

            __props__.__dict__["cluster_config"] = cluster_config
            __props__.__dict__["elasticsearch_version"] = elasticsearch_version
            __props__.__dict__["enable_node_to_node_encryption"] = enable_node_to_node_encryption
            __props__.__dict__["encrypt_at_rest"] = encrypt_at_rest
            __props__.__dict__["name"] = name
            __props__.__dict__["require_ssl"] = require_ssl
            __props__.__dict__["selected_zone"] = selected_zone
            __props__.__dict__["storage_size"] = storage_size
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_latest_tls_cipher"] = use_latest_tls_cipher
            __props__.__dict__["vpc_options"] = vpc_options
            __props__.__dict__["access_policies"] = None
            __props__.__dict__["advanced_options"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["ebs_options"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["snapshot_options"] = None
        super(AwsElasticsearch, __self__).__init__(
            'duplocloud:index/awsElasticsearch:AwsElasticsearch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policies: Optional[pulumi.Input[str]] = None,
            advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            cluster_config: Optional[pulumi.Input[Union['AwsElasticsearchClusterConfigArgs', 'AwsElasticsearchClusterConfigArgsDict']]] = None,
            domain_id: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            ebs_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsElasticsearchEbsOptionArgs', 'AwsElasticsearchEbsOptionArgsDict']]]]] = None,
            elasticsearch_version: Optional[pulumi.Input[str]] = None,
            enable_node_to_node_encryption: Optional[pulumi.Input[bool]] = None,
            encrypt_at_rest: Optional[pulumi.Input[Union['AwsElasticsearchEncryptAtRestArgs', 'AwsElasticsearchEncryptAtRestArgsDict']]] = None,
            endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            require_ssl: Optional[pulumi.Input[bool]] = None,
            selected_zone: Optional[pulumi.Input[int]] = None,
            snapshot_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsElasticsearchSnapshotOptionArgs', 'AwsElasticsearchSnapshotOptionArgsDict']]]]] = None,
            storage_size: Optional[pulumi.Input[int]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            use_latest_tls_cipher: Optional[pulumi.Input[bool]] = None,
            vpc_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsElasticsearchVpcOptionArgs', 'AwsElasticsearchVpcOptionArgsDict']]]]] = None) -> 'AwsElasticsearch':
        """
        Get an existing AwsElasticsearch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the ElasticSearch instance.
        :param pulumi.Input[str] domain_id: The domain ID of the ElasticSearch instance.
        :param pulumi.Input[str] domain_name: The full name of the ElasticSearch instance.
        :param pulumi.Input[str] elasticsearch_version: The version of the ElasticSearch instance. Defaults to `7.9`.
        :param pulumi.Input[bool] enable_node_to_node_encryption: Whether or not to use the enable node-to-node encryption for this ElasticSearch instance.
        :param pulumi.Input[Union['AwsElasticsearchEncryptAtRestArgs', 'AwsElasticsearchEncryptAtRestArgsDict']] encrypt_at_rest: The storage encryption settings for the ElasticSearch instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoints: The endpoints to use when connecting to the ElasticSearch instance.
        :param pulumi.Input[str] name: The short name of the ElasticSearch instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `domain_name` attribute.
        :param pulumi.Input[bool] require_ssl: Whether or not to require SSL for accessing this ElasticSearch instance.
        :param pulumi.Input[int] selected_zone: The numerical index of the zone to launch this ElasticSearch instance in.
        :param pulumi.Input[int] storage_size: The storage volume size, in GB, for the ElasticSearch instance.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the ElasticSearch instance will be created in.
        :param pulumi.Input[bool] use_latest_tls_cipher: Whether or not to use the latest TLS cipher for this ElasticSearch instance. For govcloud environments this should be set to true
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsElasticsearchState.__new__(_AwsElasticsearchState)

        __props__.__dict__["access_policies"] = access_policies
        __props__.__dict__["advanced_options"] = advanced_options
        __props__.__dict__["arn"] = arn
        __props__.__dict__["cluster_config"] = cluster_config
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["ebs_options"] = ebs_options
        __props__.__dict__["elasticsearch_version"] = elasticsearch_version
        __props__.__dict__["enable_node_to_node_encryption"] = enable_node_to_node_encryption
        __props__.__dict__["encrypt_at_rest"] = encrypt_at_rest
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["name"] = name
        __props__.__dict__["require_ssl"] = require_ssl
        __props__.__dict__["selected_zone"] = selected_zone
        __props__.__dict__["snapshot_options"] = snapshot_options
        __props__.__dict__["storage_size"] = storage_size
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["use_latest_tls_cipher"] = use_latest_tls_cipher
        __props__.__dict__["vpc_options"] = vpc_options
        return AwsElasticsearch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> pulumi.Output[str]:
        return pulumi.get(self, "access_policies")

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "advanced_options")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the ElasticSearch instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Output['outputs.AwsElasticsearchClusterConfig']:
        return pulumi.get(self, "cluster_config")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        """
        The domain ID of the ElasticSearch instance.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The full name of the ElasticSearch instance.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="ebsOptions")
    def ebs_options(self) -> pulumi.Output[Sequence['outputs.AwsElasticsearchEbsOption']]:
        return pulumi.get(self, "ebs_options")

    @property
    @pulumi.getter(name="elasticsearchVersion")
    def elasticsearch_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of the ElasticSearch instance. Defaults to `7.9`.
        """
        return pulumi.get(self, "elasticsearch_version")

    @property
    @pulumi.getter(name="enableNodeToNodeEncryption")
    def enable_node_to_node_encryption(self) -> pulumi.Output[bool]:
        """
        Whether or not to use the enable node-to-node encryption for this ElasticSearch instance.
        """
        return pulumi.get(self, "enable_node_to_node_encryption")

    @property
    @pulumi.getter(name="encryptAtRest")
    def encrypt_at_rest(self) -> pulumi.Output['outputs.AwsElasticsearchEncryptAtRest']:
        """
        The storage encryption settings for the ElasticSearch instance.
        """
        return pulumi.get(self, "encrypt_at_rest")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The endpoints to use when connecting to the ElasticSearch instance.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the ElasticSearch instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `domain_name` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> pulumi.Output[bool]:
        """
        Whether or not to require SSL for accessing this ElasticSearch instance.
        """
        return pulumi.get(self, "require_ssl")

    @property
    @pulumi.getter(name="selectedZone")
    def selected_zone(self) -> pulumi.Output[int]:
        """
        The numerical index of the zone to launch this ElasticSearch instance in.
        """
        return pulumi.get(self, "selected_zone")

    @property
    @pulumi.getter(name="snapshotOptions")
    def snapshot_options(self) -> pulumi.Output[Sequence['outputs.AwsElasticsearchSnapshotOption']]:
        return pulumi.get(self, "snapshot_options")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[Optional[int]]:
        """
        The storage volume size, in GB, for the ElasticSearch instance.
        """
        return pulumi.get(self, "storage_size")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the ElasticSearch instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="useLatestTlsCipher")
    def use_latest_tls_cipher(self) -> pulumi.Output[bool]:
        """
        Whether or not to use the latest TLS cipher for this ElasticSearch instance. For govcloud environments this should be set to true
        """
        return pulumi.get(self, "use_latest_tls_cipher")

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> pulumi.Output[Sequence['outputs.AwsElasticsearchVpcOption']]:
        return pulumi.get(self, "vpc_options")

