# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsHostArgs', 'AwsHost']

@pulumi.input_type
class AwsHostArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[str],
                 friendly_name: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTagArgs']]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]]] = None,
                 wait_until_connected: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AwsHost resource.
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_until_connected: Whether or not to wait until Duplo can connect to the host, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "friendly_name", friendly_name)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if base64_user_data is not None:
            pulumi.set(__self__, "base64_user_data", base64_user_data)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if custom_node_labels is not None:
            pulumi.set(__self__, "custom_node_labels", custom_node_labels)
        if is_ebs_optimized is not None:
            pulumi.set(__self__, "is_ebs_optimized", is_ebs_optimized)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if keypair_type is not None:
            pulumi.set(__self__, "keypair_type", keypair_type)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if minion_tags is not None:
            pulumi.set(__self__, "minion_tags", minion_tags)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if prepend_user_data is not None:
            pulumi.set(__self__, "prepend_user_data", prepend_user_data)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if user_account is not None:
            pulumi.set(__self__, "user_account", user_account)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_until_connected is not None:
            pulumi.set(__self__, "wait_until_connected", wait_until_connected)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[str]:
        """
        The AWS EC2 instance type.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Input[str]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The AMI ID to use.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded EC2 user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @base64_user_data.setter
    def base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_user_data", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the cloud provider to launch the host in.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="customNodeLabels")
    def custom_node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specify the labels to attach to the nodes.
        """
        return pulumi.get(self, "custom_node_labels")

    @custom_node_labels.setter
    def custom_node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_node_labels", value)

    @property
    @pulumi.getter(name="isEbsOptimized")
    def is_ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_ebs_optimized")

    @is_ebs_optimized.setter
    def is_ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ebs_optimized", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="keypairType")
    def keypair_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
        - some operating systems no longer support it)
        """
        return pulumi.get(self, "keypair_type")

    @keypair_type.setter
    def keypair_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keypair_type", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]]]:
        """
        Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
        Key and its size as value, size value should be atleast 10*
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]]]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @minion_tags.setter
    def minion_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]]]):
        pulumi.set(self, "minion_tags", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]]]:
        """
        An optional list of custom network interface configurations to use when creating the host.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="prependUserData")
    def prepend_user_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        """
        return pulumi.get(self, "prepend_user_data")

    @prepend_user_data.setter
    def prepend_user_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prepend_user_data", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]]]:
        """
        Specify taints to attach to the nodes, to repel other nodes with different toleration
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @user_account.setter
    def user_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_account", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]]]:
        """
        Block to specify additional or secondary volume beyond the root device
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitUntilConnected")
    def wait_until_connected(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Duplo can connect to the host, after creation.
        """
        return pulumi.get(self, "wait_until_connected")

    @wait_until_connected.setter
    def wait_until_connected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_connected", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[int]]:
        """
        The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _AwsHostState:
    def __init__(__self__, *,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 identity_role: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 initial_base64_user_data: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTagArgs']]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]]] = None,
                 wait_until_connected: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AwsHost resources.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] identity_role: The name of the IAM role associated with this host.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[str] instance_id: The AWS EC2 instance ID of the host.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[str] private_ip_address: The primary private IP address assigned to the host.
        :param pulumi.Input[str] public_ip_address: The primary public IP address assigned to the host.
        :param pulumi.Input[str] status: The current status of the host.
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_until_connected: Whether or not to wait until Duplo can connect to the host, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        if agent_platform is not None:
            pulumi.set(__self__, "agent_platform", agent_platform)
        if allocated_public_ip is not None:
            pulumi.set(__self__, "allocated_public_ip", allocated_public_ip)
        if base64_user_data is not None:
            pulumi.set(__self__, "base64_user_data", base64_user_data)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if custom_node_labels is not None:
            pulumi.set(__self__, "custom_node_labels", custom_node_labels)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if identity_role is not None:
            pulumi.set(__self__, "identity_role", identity_role)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if initial_base64_user_data is not None:
            pulumi.set(__self__, "initial_base64_user_data", initial_base64_user_data)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_ebs_optimized is not None:
            pulumi.set(__self__, "is_ebs_optimized", is_ebs_optimized)
        if is_minion is not None:
            pulumi.set(__self__, "is_minion", is_minion)
        if keypair_type is not None:
            pulumi.set(__self__, "keypair_type", keypair_type)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if minion_tags is not None:
            pulumi.set(__self__, "minion_tags", minion_tags)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if prepend_user_data is not None:
            pulumi.set(__self__, "prepend_user_data", prepend_user_data)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user_account is not None:
            pulumi.set(__self__, "user_account", user_account)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_until_connected is not None:
            pulumi.set(__self__, "wait_until_connected", wait_until_connected)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the container agent pool that this host is added to.
        """
        return pulumi.get(self, "agent_platform")

    @agent_platform.setter
    def agent_platform(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_platform", value)

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to allocate a public IP.
        """
        return pulumi.get(self, "allocated_public_ip")

    @allocated_public_ip.setter
    def allocated_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocated_public_ip", value)

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded EC2 user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @base64_user_data.setter
    def base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_user_data", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS EC2 instance type.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the cloud provider to launch the host in.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="customNodeLabels")
    def custom_node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specify the labels to attach to the nodes.
        """
        return pulumi.get(self, "custom_node_labels")

    @custom_node_labels.setter
    def custom_node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_node_labels", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="identityRole")
    def identity_role(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IAM role associated with this host.
        """
        return pulumi.get(self, "identity_role")

    @identity_role.setter
    def identity_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_role", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="initialBase64UserData")
    def initial_base64_user_data(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "initial_base64_user_data")

    @initial_base64_user_data.setter
    def initial_base64_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_base64_user_data", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS EC2 instance ID of the host.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="isEbsOptimized")
    def is_ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_ebs_optimized")

    @is_ebs_optimized.setter
    def is_ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ebs_optimized", value)

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_minion")

    @is_minion.setter
    def is_minion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_minion", value)

    @property
    @pulumi.getter(name="keypairType")
    def keypair_type(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
        - some operating systems no longer support it)
        """
        return pulumi.get(self, "keypair_type")

    @keypair_type.setter
    def keypair_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keypair_type", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]]]:
        """
        Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
        Key and its size as value, size value should be atleast 10*
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]]]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @minion_tags.setter
    def minion_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostMinionTagArgs']]]]):
        pulumi.set(self, "minion_tags", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]]]:
        """
        An optional list of custom network interface configurations to use when creating the host.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="prependUserData")
    def prepend_user_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        """
        return pulumi.get(self, "prepend_user_data")

    @prepend_user_data.setter
    def prepend_user_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prepend_user_data", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The primary private IP address assigned to the host.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The primary public IP address assigned to the host.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the host.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]]]:
        """
        Specify taints to attach to the nodes, to repel other nodes with different toleration
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @user_account.setter
    def user_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_account", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]]]:
        """
        Block to specify additional or secondary volume beyond the root device
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsHostVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitUntilConnected")
    def wait_until_connected(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Duplo can connect to the host, after creation.
        """
        return pulumi.get(self, "wait_until_connected")

    @wait_until_connected.setter
    def wait_until_connected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_connected", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[int]]:
        """
        The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone", value)


class AwsHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMetadataArgs', 'AwsHostMetadataArgsDict']]]]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMinionTagArgs', 'AwsHostMinionTagArgsDict']]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostNetworkInterfaceArgs', 'AwsHostNetworkInterfaceArgsDict']]]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTagArgs', 'AwsHostTagArgsDict']]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTaintArgs', 'AwsHostTaintArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostVolumeArgs', 'AwsHostVolumeArgsDict']]]]] = None,
                 wait_until_connected: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Deploy a host which will be used for DuploCloud platform's native container agent to deploy native containers

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating a host, you must first set up the infrastructure without an eks cluster. Then, you must create a tenant inside the infra. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=False,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # Create a data source to retrieve the Machine Image ID to be used by the host
        image = duplocloud.get_native_host_image_output(tenant_id=tenant.tenant_id,
            is_kubernetes=False)
        native = duplocloud.AwsHost("native",
            tenant_id=tenant.tenant_id,
            friendly_name="host01",
            image_id=image.image_id,
            capacity="t3a.medium",
            agent_platform=0,
            zone=0,
            user_account=tenant.account_name,
            metadatas=[{
                "key": "OsDiskSize",
                "value": "20",
            }])
        ```

        ### Create an EKS worker node for deployment of the Kubernetes applications

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating the EKS worker node, you must first set up the infrastructure with EKS cluster enabled and a tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=True,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # Create a data source to retrieve the Machine Image ID to be used by the host
        image = duplocloud.get_native_host_image_output(tenant_id=tenant.tenant_id,
            is_kubernetes=True)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.tenant_id,
            friendly_name="host02",
            image_id=image.image_id,
            capacity="t3a.small",
            agent_platform=7,
            zone=0,
            user_account=tenant.account_name,
            keypair_type=1)
        ```

        ### Create an EKS worker node inside the 'dev' tenant for deployment of the Kubernetes applications, with instance metadata service

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before setting up the EKS worker node.
        tenant = duplocloud.get_tenant(name="dev")
        image = duplocloud.get_native_host_image(tenant_id=tenant.id,
            is_kubernetes=True)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.id,
            friendly_name="host03",
            image_id=image.image_id,
            capacity="t3.small",
            agent_platform=7,
            zone=0,
            user_account=tenant.name,
            keypair_type=1,
            metadatas=[
                {
                    "key": "OsDiskSize",
                    "value": "20",
                },
                {
                    "key": "MetadataServiceOption",
                    "value": "enabled_v2_only",
                },
            ])
        ```

        ## Import

        Example: Importing an existing AWS host

         - *TENANT_ID* is the tenant GUID

         - *INSTANCE_ID* is the AWS EC2 instance ID

        # 

        ```sh
        $ pulumi import duplocloud:index/awsHost:AwsHost myhost v2/subscriptions/*TENANT_ID*/NativeHostV2/*INSTANCE_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMetadataArgs', 'AwsHostMetadataArgsDict']]]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMinionTagArgs', 'AwsHostMinionTagArgsDict']]]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostNetworkInterfaceArgs', 'AwsHostNetworkInterfaceArgsDict']]]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTaintArgs', 'AwsHostTaintArgsDict']]]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostVolumeArgs', 'AwsHostVolumeArgsDict']]]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_until_connected: Whether or not to wait until Duplo can connect to the host, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Deploy a host which will be used for DuploCloud platform's native container agent to deploy native containers

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating a host, you must first set up the infrastructure without an eks cluster. Then, you must create a tenant inside the infra. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=False,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # Create a data source to retrieve the Machine Image ID to be used by the host
        image = duplocloud.get_native_host_image_output(tenant_id=tenant.tenant_id,
            is_kubernetes=False)
        native = duplocloud.AwsHost("native",
            tenant_id=tenant.tenant_id,
            friendly_name="host01",
            image_id=image.image_id,
            capacity="t3a.medium",
            agent_platform=0,
            zone=0,
            user_account=tenant.account_name,
            metadatas=[{
                "key": "OsDiskSize",
                "value": "20",
            }])
        ```

        ### Create an EKS worker node for deployment of the Kubernetes applications

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating the EKS worker node, you must first set up the infrastructure with EKS cluster enabled and a tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=True,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # Create a data source to retrieve the Machine Image ID to be used by the host
        image = duplocloud.get_native_host_image_output(tenant_id=tenant.tenant_id,
            is_kubernetes=True)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.tenant_id,
            friendly_name="host02",
            image_id=image.image_id,
            capacity="t3a.small",
            agent_platform=7,
            zone=0,
            user_account=tenant.account_name,
            keypair_type=1)
        ```

        ### Create an EKS worker node inside the 'dev' tenant for deployment of the Kubernetes applications, with instance metadata service

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before setting up the EKS worker node.
        tenant = duplocloud.get_tenant(name="dev")
        image = duplocloud.get_native_host_image(tenant_id=tenant.id,
            is_kubernetes=True)
        host = duplocloud.AwsHost("host",
            tenant_id=tenant.id,
            friendly_name="host03",
            image_id=image.image_id,
            capacity="t3.small",
            agent_platform=7,
            zone=0,
            user_account=tenant.name,
            keypair_type=1,
            metadatas=[
                {
                    "key": "OsDiskSize",
                    "value": "20",
                },
                {
                    "key": "MetadataServiceOption",
                    "value": "enabled_v2_only",
                },
            ])
        ```

        ## Import

        Example: Importing an existing AWS host

         - *TENANT_ID* is the tenant GUID

         - *INSTANCE_ID* is the AWS EC2 instance ID

        # 

        ```sh
        $ pulumi import duplocloud:index/awsHost:AwsHost myhost v2/subscriptions/*TENANT_ID*/NativeHostV2/*INSTANCE_ID*
        ```

        :param str resource_name: The name of the resource.
        :param AwsHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_platform: Optional[pulumi.Input[int]] = None,
                 allocated_public_ip: Optional[pulumi.Input[bool]] = None,
                 base64_user_data: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 is_minion: Optional[pulumi.Input[bool]] = None,
                 keypair_type: Optional[pulumi.Input[int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMetadataArgs', 'AwsHostMetadataArgsDict']]]]] = None,
                 minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMinionTagArgs', 'AwsHostMinionTagArgsDict']]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostNetworkInterfaceArgs', 'AwsHostNetworkInterfaceArgsDict']]]]] = None,
                 prepend_user_data: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTagArgs', 'AwsHostTagArgsDict']]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTaintArgs', 'AwsHostTaintArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 user_account: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostVolumeArgs', 'AwsHostVolumeArgsDict']]]]] = None,
                 wait_until_connected: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsHostArgs.__new__(AwsHostArgs)

            __props__.__dict__["agent_platform"] = agent_platform
            __props__.__dict__["allocated_public_ip"] = allocated_public_ip
            __props__.__dict__["base64_user_data"] = base64_user_data
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["custom_node_labels"] = custom_node_labels
            if friendly_name is None and not opts.urn:
                raise TypeError("Missing required property 'friendly_name'")
            __props__.__dict__["friendly_name"] = friendly_name
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["is_ebs_optimized"] = is_ebs_optimized
            __props__.__dict__["is_minion"] = is_minion
            __props__.__dict__["keypair_type"] = keypair_type
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["minion_tags"] = minion_tags
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["prepend_user_data"] = prepend_user_data
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["user_account"] = user_account
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["wait_until_connected"] = wait_until_connected
            __props__.__dict__["zone"] = zone
            __props__.__dict__["identity_role"] = None
            __props__.__dict__["initial_base64_user_data"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["status"] = None
        super(AwsHost, __self__).__init__(
            'duplocloud:index/awsHost:AwsHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_platform: Optional[pulumi.Input[int]] = None,
            allocated_public_ip: Optional[pulumi.Input[bool]] = None,
            base64_user_data: Optional[pulumi.Input[str]] = None,
            capacity: Optional[pulumi.Input[str]] = None,
            cloud: Optional[pulumi.Input[int]] = None,
            custom_node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            friendly_name: Optional[pulumi.Input[str]] = None,
            identity_role: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            initial_base64_user_data: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            is_ebs_optimized: Optional[pulumi.Input[bool]] = None,
            is_minion: Optional[pulumi.Input[bool]] = None,
            keypair_type: Optional[pulumi.Input[int]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMetadataArgs', 'AwsHostMetadataArgsDict']]]]] = None,
            minion_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMinionTagArgs', 'AwsHostMinionTagArgsDict']]]]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostNetworkInterfaceArgs', 'AwsHostNetworkInterfaceArgsDict']]]]] = None,
            prepend_user_data: Optional[pulumi.Input[bool]] = None,
            private_ip_address: Optional[pulumi.Input[str]] = None,
            public_ip_address: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTagArgs', 'AwsHostTagArgsDict']]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTaintArgs', 'AwsHostTaintArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            user_account: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsHostVolumeArgs', 'AwsHostVolumeArgsDict']]]]] = None,
            wait_until_connected: Optional[pulumi.Input[bool]] = None,
            zone: Optional[pulumi.Input[int]] = None) -> 'AwsHost':
        """
        Get an existing AwsHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] agent_platform: The numeric ID of the container agent pool that this host is added to.
        :param pulumi.Input[bool] allocated_public_ip: Whether or not to allocate a public IP.
        :param pulumi.Input[str] base64_user_data: Base64 encoded EC2 user data to associated with the host.
        :param pulumi.Input[str] capacity: The AWS EC2 instance type.
        :param pulumi.Input[int] cloud: The numeric ID of the cloud provider to launch the host in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_node_labels: Specify the labels to attach to the nodes.
        :param pulumi.Input[str] friendly_name: The short name of the host.
        :param pulumi.Input[str] identity_role: The name of the IAM role associated with this host.
        :param pulumi.Input[str] image_id: The AMI ID to use.
        :param pulumi.Input[str] instance_id: The AWS EC2 instance ID of the host.
        :param pulumi.Input[int] keypair_type: The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
               - some operating systems no longer support it)
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMetadataArgs', 'AwsHostMetadataArgsDict']]]] metadatas: Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
               Key and its size as value, size value should be atleast 10*
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostMinionTagArgs', 'AwsHostMinionTagArgsDict']]]] minion_tags: A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostNetworkInterfaceArgs', 'AwsHostNetworkInterfaceArgsDict']]]] network_interfaces: An optional list of custom network interface configurations to use when creating the host.
        :param pulumi.Input[bool] prepend_user_data: Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        :param pulumi.Input[str] private_ip_address: The primary private IP address assigned to the host.
        :param pulumi.Input[str] public_ip_address: The primary public IP address assigned to the host.
        :param pulumi.Input[str] status: The current status of the host.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostTaintArgs', 'AwsHostTaintArgsDict']]]] taints: Specify taints to attach to the nodes, to repel other nodes with different toleration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the host will be created in.
        :param pulumi.Input[str] user_account: The name of the tenant that the host will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsHostVolumeArgs', 'AwsHostVolumeArgsDict']]]] volumes: Block to specify additional or secondary volume beyond the root device
        :param pulumi.Input[bool] wait_until_connected: Whether or not to wait until Duplo can connect to the host, after creation.
        :param pulumi.Input[int] zone: The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsHostState.__new__(_AwsHostState)

        __props__.__dict__["agent_platform"] = agent_platform
        __props__.__dict__["allocated_public_ip"] = allocated_public_ip
        __props__.__dict__["base64_user_data"] = base64_user_data
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["custom_node_labels"] = custom_node_labels
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["identity_role"] = identity_role
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["initial_base64_user_data"] = initial_base64_user_data
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_ebs_optimized"] = is_ebs_optimized
        __props__.__dict__["is_minion"] = is_minion
        __props__.__dict__["keypair_type"] = keypair_type
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["minion_tags"] = minion_tags
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["prepend_user_data"] = prepend_user_data
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["user_account"] = user_account
        __props__.__dict__["volumes"] = volumes
        __props__.__dict__["wait_until_connected"] = wait_until_connected
        __props__.__dict__["zone"] = zone
        return AwsHost(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPlatform")
    def agent_platform(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the container agent pool that this host is added to.
        """
        return pulumi.get(self, "agent_platform")

    @property
    @pulumi.getter(name="allocatedPublicIp")
    def allocated_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to allocate a public IP.
        """
        return pulumi.get(self, "allocated_public_ip")

    @property
    @pulumi.getter(name="base64UserData")
    def base64_user_data(self) -> pulumi.Output[str]:
        """
        Base64 encoded EC2 user data to associated with the host.
        """
        return pulumi.get(self, "base64_user_data")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[str]:
        """
        The AWS EC2 instance type.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[Optional[int]]:
        """
        The numeric ID of the cloud provider to launch the host in.
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="customNodeLabels")
    def custom_node_labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specify the labels to attach to the nodes.
        """
        return pulumi.get(self, "custom_node_labels")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[str]:
        """
        The short name of the host.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="identityRole")
    def identity_role(self) -> pulumi.Output[str]:
        """
        The name of the IAM role associated with this host.
        """
        return pulumi.get(self, "identity_role")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The AMI ID to use.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="initialBase64UserData")
    def initial_base64_user_data(self) -> pulumi.Output[str]:
        return pulumi.get(self, "initial_base64_user_data")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The AWS EC2 instance ID of the host.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isEbsOptimized")
    def is_ebs_optimized(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "is_ebs_optimized")

    @property
    @pulumi.getter(name="isMinion")
    def is_minion(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "is_minion")

    @property
    @pulumi.getter(name="keypairType")
    def keypair_type(self) -> pulumi.Output[int]:
        """
        The numeric ID of the keypair type being used.Should be one of: - `0` : Default - `1` : ED25519 - `2` : RSA (deprecated
        - some operating systems no longer support it)
        """
        return pulumi.get(self, "keypair_type")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.AwsHostMetadata']]:
        """
        Configuration metadata used when creating the host.<br>*Note: To configure OS disk size OsDiskSize can be specified as
        Key and its size as value, size value should be atleast 10*
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="minionTags")
    def minion_tags(self) -> pulumi.Output[Sequence['outputs.AwsHostMinionTag']]:
        """
        A map of tags to assign to the resource. Example - `AllocationTags` can be passed as tag key with any value.
        """
        return pulumi.get(self, "minion_tags")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.AwsHostNetworkInterface']]:
        """
        An optional list of custom network interface configurations to use when creating the host.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="prependUserData")
    def prepend_user_data(self) -> pulumi.Output[Optional[bool]]:
        """
        Bootstrap an EKS host with Duplo's user data, prepending it to custom user data if also provided.
        """
        return pulumi.get(self, "prepend_user_data")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[str]:
        """
        The primary private IP address assigned to the host.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[str]:
        """
        The primary public IP address assigned to the host.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current status of the host.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.AwsHostTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.AwsHostTaint']]]:
        """
        Specify taints to attach to the nodes, to repel other nodes with different toleration
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the host will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="userAccount")
    def user_account(self) -> pulumi.Output[str]:
        """
        The name of the tenant that the host will be created in.
        """
        return pulumi.get(self, "user_account")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.AwsHostVolume']]:
        """
        Block to specify additional or secondary volume beyond the root device
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="waitUntilConnected")
    def wait_until_connected(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until Duplo can connect to the host, after creation.
        """
        return pulumi.get(self, "wait_until_connected")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[int]]:
        """
        The availability zone to launch the host in, expressed as a number and starting at 0.
        """
        return pulumi.get(self, "zone")

