# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AwsKafkaClusterArgs', 'AwsKafkaCluster']

@pulumi.input_type
class AwsKafkaClusterArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 kafka_version: pulumi.Input[str],
                 storage_size: pulumi.Input[int],
                 tenant_id: pulumi.Input[str],
                 configuration_arn: Optional[pulumi.Input[str]] = None,
                 configuration_revision: Optional[pulumi.Input[int]] = None,
                 encryption_in_transit: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AwsKafkaCluster resource.
        :param pulumi.Input[str] instance_type: The Kafka node instance type to use.
               See the [AWS documentation](https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html) for more information.
        :param pulumi.Input[str] kafka_version: The version of the Kafka cluster.
        :param pulumi.Input[int] storage_size: The size of the Kafka storage, in gigabytes.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Kafka cluster will be created in.
        :param pulumi.Input[str] configuration_arn: An ARN of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[int] configuration_revision: An revision of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[str] encryption_in_transit: Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`
        :param pulumi.Input[str] name: The short name of the Kafka cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The list of subnets that the cluster will be launched in.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "kafka_version", kafka_version)
        pulumi.set(__self__, "storage_size", storage_size)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if configuration_arn is not None:
            pulumi.set(__self__, "configuration_arn", configuration_arn)
        if configuration_revision is not None:
            pulumi.set(__self__, "configuration_revision", configuration_revision)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The Kafka node instance type to use.
        See the [AWS documentation](https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html) for more information.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> pulumi.Input[str]:
        """
        The version of the Kafka cluster.
        """
        return pulumi.get(self, "kafka_version")

    @kafka_version.setter
    def kafka_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "kafka_version", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Input[int]:
        """
        The size of the Kafka storage, in gigabytes.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_size", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the Kafka cluster will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="configurationArn")
    def configuration_arn(self) -> Optional[pulumi.Input[str]]:
        """
        An ARN of a Kafka configuration to apply to the cluster.
        """
        return pulumi.get(self, "configuration_arn")

    @configuration_arn.setter
    def configuration_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_arn", value)

    @property
    @pulumi.getter(name="configurationRevision")
    def configuration_revision(self) -> Optional[pulumi.Input[int]]:
        """
        An revision of a Kafka configuration to apply to the cluster.
        """
        return pulumi.get(self, "configuration_revision")

    @configuration_revision.setter
    def configuration_revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "configuration_revision", value)

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`
        """
        return pulumi.get(self, "encryption_in_transit")

    @encryption_in_transit.setter
    def encryption_in_transit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_in_transit", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the Kafka cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of subnets that the cluster will be launched in.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _AwsKafkaClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 az_distribution: Optional[pulumi.Input[str]] = None,
                 configuration_arn: Optional[pulumi.Input[str]] = None,
                 configuration_revision: Optional[pulumi.Input[int]] = None,
                 encryption_in_transit: Optional[pulumi.Input[str]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kafka_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_broker_nodes: Optional[pulumi.Input[int]] = None,
                 plaintext_bootstrap_broker_string: Optional[pulumi.Input[str]] = None,
                 plaintext_zookeeper_connect_string: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tls_bootstrap_broker_string: Optional[pulumi.Input[str]] = None,
                 tls_zookeeper_connect_string: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsKafkaCluster resources.
        :param pulumi.Input[str] arn: The ARN of the Kafka cluster.
        :param pulumi.Input[str] az_distribution: The availability zone distribution used by the cluster.
        :param pulumi.Input[str] configuration_arn: An ARN of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[int] configuration_revision: An revision of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[str] encryption_in_transit: Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`
        :param pulumi.Input[str] fullname: The full name of the Kakfa cluster.
        :param pulumi.Input[str] instance_type: The Kafka node instance type to use.
               See the [AWS documentation](https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html) for more information.
        :param pulumi.Input[str] kafka_version: The version of the Kafka cluster.
        :param pulumi.Input[str] name: The short name of the Kafka cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[int] number_of_broker_nodes: The desired total number of broker nodes in the kafka cluster.
        :param pulumi.Input[str] plaintext_bootstrap_broker_string: The bootstrap broker connect string for plaintext (unencrypted) connections.
        :param pulumi.Input[str] plaintext_zookeeper_connect_string: The Zookeeper connect string for plaintext (unencrypted) connections.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The list of security groups used by the cluster.
        :param pulumi.Input[str] state: The current state of the cluster.
        :param pulumi.Input[int] storage_size: The size of the Kafka storage, in gigabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The list of subnets that the cluster will be launched in.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Kafka cluster will be created in.
        :param pulumi.Input[str] tls_bootstrap_broker_string: The bootstrap broker connect string for TLS (encrypted) connections.
        :param pulumi.Input[str] tls_zookeeper_connect_string: The Zookeeper connect string for TLS (encrypted) connections.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if az_distribution is not None:
            pulumi.set(__self__, "az_distribution", az_distribution)
        if configuration_arn is not None:
            pulumi.set(__self__, "configuration_arn", configuration_arn)
        if configuration_revision is not None:
            pulumi.set(__self__, "configuration_revision", configuration_revision)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kafka_version is not None:
            pulumi.set(__self__, "kafka_version", kafka_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_broker_nodes is not None:
            pulumi.set(__self__, "number_of_broker_nodes", number_of_broker_nodes)
        if plaintext_bootstrap_broker_string is not None:
            pulumi.set(__self__, "plaintext_bootstrap_broker_string", plaintext_bootstrap_broker_string)
        if plaintext_zookeeper_connect_string is not None:
            pulumi.set(__self__, "plaintext_zookeeper_connect_string", plaintext_zookeeper_connect_string)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tls_bootstrap_broker_string is not None:
            pulumi.set(__self__, "tls_bootstrap_broker_string", tls_bootstrap_broker_string)
        if tls_zookeeper_connect_string is not None:
            pulumi.set(__self__, "tls_zookeeper_connect_string", tls_zookeeper_connect_string)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Kafka cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="azDistribution")
    def az_distribution(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone distribution used by the cluster.
        """
        return pulumi.get(self, "az_distribution")

    @az_distribution.setter
    def az_distribution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "az_distribution", value)

    @property
    @pulumi.getter(name="configurationArn")
    def configuration_arn(self) -> Optional[pulumi.Input[str]]:
        """
        An ARN of a Kafka configuration to apply to the cluster.
        """
        return pulumi.get(self, "configuration_arn")

    @configuration_arn.setter
    def configuration_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_arn", value)

    @property
    @pulumi.getter(name="configurationRevision")
    def configuration_revision(self) -> Optional[pulumi.Input[int]]:
        """
        An revision of a Kafka configuration to apply to the cluster.
        """
        return pulumi.get(self, "configuration_revision")

    @configuration_revision.setter
    def configuration_revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "configuration_revision", value)

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`
        """
        return pulumi.get(self, "encryption_in_transit")

    @encryption_in_transit.setter
    def encryption_in_transit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_in_transit", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the Kakfa cluster.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka node instance type to use.
        See the [AWS documentation](https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html) for more information.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Kafka cluster.
        """
        return pulumi.get(self, "kafka_version")

    @kafka_version.setter
    def kafka_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the Kafka cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfBrokerNodes")
    def number_of_broker_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The desired total number of broker nodes in the kafka cluster.
        """
        return pulumi.get(self, "number_of_broker_nodes")

    @number_of_broker_nodes.setter
    def number_of_broker_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_broker_nodes", value)

    @property
    @pulumi.getter(name="plaintextBootstrapBrokerString")
    def plaintext_bootstrap_broker_string(self) -> Optional[pulumi.Input[str]]:
        """
        The bootstrap broker connect string for plaintext (unencrypted) connections.
        """
        return pulumi.get(self, "plaintext_bootstrap_broker_string")

    @plaintext_bootstrap_broker_string.setter
    def plaintext_bootstrap_broker_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plaintext_bootstrap_broker_string", value)

    @property
    @pulumi.getter(name="plaintextZookeeperConnectString")
    def plaintext_zookeeper_connect_string(self) -> Optional[pulumi.Input[str]]:
        """
        The Zookeeper connect string for plaintext (unencrypted) connections.
        """
        return pulumi.get(self, "plaintext_zookeeper_connect_string")

    @plaintext_zookeeper_connect_string.setter
    def plaintext_zookeeper_connect_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plaintext_zookeeper_connect_string", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of security groups used by the cluster.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the Kafka storage, in gigabytes.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of subnets that the cluster will be launched in.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the Kafka cluster will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="tlsBootstrapBrokerString")
    def tls_bootstrap_broker_string(self) -> Optional[pulumi.Input[str]]:
        """
        The bootstrap broker connect string for TLS (encrypted) connections.
        """
        return pulumi.get(self, "tls_bootstrap_broker_string")

    @tls_bootstrap_broker_string.setter
    def tls_bootstrap_broker_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_bootstrap_broker_string", value)

    @property
    @pulumi.getter(name="tlsZookeeperConnectString")
    def tls_zookeeper_connect_string(self) -> Optional[pulumi.Input[str]]:
        """
        The Zookeeper connect string for TLS (encrypted) connections.
        """
        return pulumi.get(self, "tls_zookeeper_connect_string")

    @tls_zookeeper_connect_string.setter
    def tls_zookeeper_connect_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_zookeeper_connect_string", value)


class AwsKafkaCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_arn: Optional[pulumi.Input[str]] = None,
                 configuration_revision: Optional[pulumi.Input[int]] = None,
                 encryption_in_transit: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kafka_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsKafkaCluster` manages an AWS MSK cluster in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mycluster = duplocloud.AwsKafkaCluster("mycluster",
            tenant_id=this["tenantId"],
            name="mycluster",
            kafka_version="2.4.1.1",
            instance_type="kafka.m5.large",
            storage_size=20)
        ```

        ## Import

        Example: Importing an existing AWS Kafka cluster

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS Kafka cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/awsKafkaCluster:AwsKafkaCluster mycluster *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_arn: An ARN of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[int] configuration_revision: An revision of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[str] encryption_in_transit: Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`
        :param pulumi.Input[str] instance_type: The Kafka node instance type to use.
               See the [AWS documentation](https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html) for more information.
        :param pulumi.Input[str] kafka_version: The version of the Kafka cluster.
        :param pulumi.Input[str] name: The short name of the Kafka cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[int] storage_size: The size of the Kafka storage, in gigabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The list of subnets that the cluster will be launched in.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Kafka cluster will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsKafkaClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsKafkaCluster` manages an AWS MSK cluster in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        mycluster = duplocloud.AwsKafkaCluster("mycluster",
            tenant_id=this["tenantId"],
            name="mycluster",
            kafka_version="2.4.1.1",
            instance_type="kafka.m5.large",
            storage_size=20)
        ```

        ## Import

        Example: Importing an existing AWS Kafka cluster

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS Kafka cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/awsKafkaCluster:AwsKafkaCluster mycluster *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsKafkaClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsKafkaClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_arn: Optional[pulumi.Input[str]] = None,
                 configuration_revision: Optional[pulumi.Input[int]] = None,
                 encryption_in_transit: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kafka_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsKafkaClusterArgs.__new__(AwsKafkaClusterArgs)

            __props__.__dict__["configuration_arn"] = configuration_arn
            __props__.__dict__["configuration_revision"] = configuration_revision
            __props__.__dict__["encryption_in_transit"] = encryption_in_transit
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            if kafka_version is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_version'")
            __props__.__dict__["kafka_version"] = kafka_version
            __props__.__dict__["name"] = name
            if storage_size is None and not opts.urn:
                raise TypeError("Missing required property 'storage_size'")
            __props__.__dict__["storage_size"] = storage_size
            __props__.__dict__["subnets"] = subnets
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["az_distribution"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["number_of_broker_nodes"] = None
            __props__.__dict__["plaintext_bootstrap_broker_string"] = None
            __props__.__dict__["plaintext_zookeeper_connect_string"] = None
            __props__.__dict__["security_groups"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["tls_bootstrap_broker_string"] = None
            __props__.__dict__["tls_zookeeper_connect_string"] = None
        super(AwsKafkaCluster, __self__).__init__(
            'duplocloud:index/awsKafkaCluster:AwsKafkaCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            az_distribution: Optional[pulumi.Input[str]] = None,
            configuration_arn: Optional[pulumi.Input[str]] = None,
            configuration_revision: Optional[pulumi.Input[int]] = None,
            encryption_in_transit: Optional[pulumi.Input[str]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            kafka_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_broker_nodes: Optional[pulumi.Input[int]] = None,
            plaintext_bootstrap_broker_string: Optional[pulumi.Input[str]] = None,
            plaintext_zookeeper_connect_string: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_size: Optional[pulumi.Input[int]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            tls_bootstrap_broker_string: Optional[pulumi.Input[str]] = None,
            tls_zookeeper_connect_string: Optional[pulumi.Input[str]] = None) -> 'AwsKafkaCluster':
        """
        Get an existing AwsKafkaCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the Kafka cluster.
        :param pulumi.Input[str] az_distribution: The availability zone distribution used by the cluster.
        :param pulumi.Input[str] configuration_arn: An ARN of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[int] configuration_revision: An revision of a Kafka configuration to apply to the cluster.
        :param pulumi.Input[str] encryption_in_transit: Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`
        :param pulumi.Input[str] fullname: The full name of the Kakfa cluster.
        :param pulumi.Input[str] instance_type: The Kafka node instance type to use.
               See the [AWS documentation](https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html) for more information.
        :param pulumi.Input[str] kafka_version: The version of the Kafka cluster.
        :param pulumi.Input[str] name: The short name of the Kafka cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[int] number_of_broker_nodes: The desired total number of broker nodes in the kafka cluster.
        :param pulumi.Input[str] plaintext_bootstrap_broker_string: The bootstrap broker connect string for plaintext (unencrypted) connections.
        :param pulumi.Input[str] plaintext_zookeeper_connect_string: The Zookeeper connect string for plaintext (unencrypted) connections.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The list of security groups used by the cluster.
        :param pulumi.Input[str] state: The current state of the cluster.
        :param pulumi.Input[int] storage_size: The size of the Kafka storage, in gigabytes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The list of subnets that the cluster will be launched in.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Kafka cluster will be created in.
        :param pulumi.Input[str] tls_bootstrap_broker_string: The bootstrap broker connect string for TLS (encrypted) connections.
        :param pulumi.Input[str] tls_zookeeper_connect_string: The Zookeeper connect string for TLS (encrypted) connections.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsKafkaClusterState.__new__(_AwsKafkaClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["az_distribution"] = az_distribution
        __props__.__dict__["configuration_arn"] = configuration_arn
        __props__.__dict__["configuration_revision"] = configuration_revision
        __props__.__dict__["encryption_in_transit"] = encryption_in_transit
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["kafka_version"] = kafka_version
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_broker_nodes"] = number_of_broker_nodes
        __props__.__dict__["plaintext_bootstrap_broker_string"] = plaintext_bootstrap_broker_string
        __props__.__dict__["plaintext_zookeeper_connect_string"] = plaintext_zookeeper_connect_string
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_size"] = storage_size
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["tls_bootstrap_broker_string"] = tls_bootstrap_broker_string
        __props__.__dict__["tls_zookeeper_connect_string"] = tls_zookeeper_connect_string
        return AwsKafkaCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Kafka cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="azDistribution")
    def az_distribution(self) -> pulumi.Output[str]:
        """
        The availability zone distribution used by the cluster.
        """
        return pulumi.get(self, "az_distribution")

    @property
    @pulumi.getter(name="configurationArn")
    def configuration_arn(self) -> pulumi.Output[str]:
        """
        An ARN of a Kafka configuration to apply to the cluster.
        """
        return pulumi.get(self, "configuration_arn")

    @property
    @pulumi.getter(name="configurationRevision")
    def configuration_revision(self) -> pulumi.Output[int]:
        """
        An revision of a Kafka configuration to apply to the cluster.
        """
        return pulumi.get(self, "configuration_revision")

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> pulumi.Output[str]:
        """
        Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`
        """
        return pulumi.get(self, "encryption_in_transit")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the Kakfa cluster.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The Kafka node instance type to use.
        See the [AWS documentation](https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html) for more information.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> pulumi.Output[str]:
        """
        The version of the Kafka cluster.
        """
        return pulumi.get(self, "kafka_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the Kafka cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfBrokerNodes")
    def number_of_broker_nodes(self) -> pulumi.Output[int]:
        """
        The desired total number of broker nodes in the kafka cluster.
        """
        return pulumi.get(self, "number_of_broker_nodes")

    @property
    @pulumi.getter(name="plaintextBootstrapBrokerString")
    def plaintext_bootstrap_broker_string(self) -> pulumi.Output[str]:
        """
        The bootstrap broker connect string for plaintext (unencrypted) connections.
        """
        return pulumi.get(self, "plaintext_bootstrap_broker_string")

    @property
    @pulumi.getter(name="plaintextZookeeperConnectString")
    def plaintext_zookeeper_connect_string(self) -> pulumi.Output[str]:
        """
        The Zookeeper connect string for plaintext (unencrypted) connections.
        """
        return pulumi.get(self, "plaintext_zookeeper_connect_string")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of security groups used by the cluster.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[int]:
        """
        The size of the Kafka storage, in gigabytes.
        """
        return pulumi.get(self, "storage_size")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of subnets that the cluster will be launched in.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the Kafka cluster will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="tlsBootstrapBrokerString")
    def tls_bootstrap_broker_string(self) -> pulumi.Output[str]:
        """
        The bootstrap broker connect string for TLS (encrypted) connections.
        """
        return pulumi.get(self, "tls_bootstrap_broker_string")

    @property
    @pulumi.getter(name="tlsZookeeperConnectString")
    def tls_zookeeper_connect_string(self) -> pulumi.Output[str]:
        """
        The Zookeeper connect string for TLS (encrypted) connections.
        """
        return pulumi.get(self, "tls_zookeeper_connect_string")

