# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsLambdaFunctionArgs', 'AwsLambdaFunction']

@pulumi.input_type
class AwsLambdaFunctionArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 architectures: Optional[pulumi.Input[str]] = None,
                 dead_letter_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['AwsLambdaFunctionEnvironmentArgs']] = None,
                 ephemeral_storage: Optional[pulumi.Input[int]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input['AwsLambdaFunctionImageConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input['AwsLambdaFunctionTracingConfigArgs']] = None):
        """
        The set of arguments for constructing a AwsLambdaFunction resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda function will be created in.
        :param pulumi.Input[str] architectures: Instruction set architecture for your Lambda function. Valid values are `[x86_64]` and `[arm64]`. Default is `[x86_64]`
        :param pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]] dead_letter_configs: Dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
        :param pulumi.Input[str] description: A description of the lambda function.
        :param pulumi.Input['AwsLambdaFunctionEnvironmentArgs'] environment: Allow customization of the lambda execution environment.
        :param pulumi.Input[int] ephemeral_storage: The Ephemeral Storage size, in MB, that your lambda function is allowed to use at runtime. Defaults to `512`.
        :param pulumi.Input[str] handler: The [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) of the lambda function in your code.
        :param pulumi.Input['AwsLambdaFunctionImageConfigArgs'] image_config: Configuration for the Lambda function's container image
        :param pulumi.Input[str] image_uri: The docker image that holds the lambda function's code. Used (and required) only when `package_type` is `"Image"`. The image must be in a private ECR.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input[int] memory_size: The maximum amount of memory, in MB, that your lambda function is allowed to use at runtime. Defaults to `128`.
        :param pulumi.Input[str] name: The short name of the lambda function cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] package_type: The type of lambda package.  Must be `Zip` or `Image`.  Defaults to `Zip`.
        :param pulumi.Input[str] runtime: The [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) that the lambda function needs.
        :param pulumi.Input[str] s3_bucket: The S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[str] s3_key: The S3 key in the S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object.
        :param pulumi.Input[int] timeout: The execution time limit for the lambda function. Defaults to `3`.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if dead_letter_configs is not None:
            pulumi.set(__self__, "dead_letter_configs", dead_letter_configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the lambda function will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[str]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `[x86_64]` and `[arm64]`. Default is `[x86_64]`
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter(name="deadLetterConfigs")
    def dead_letter_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]]]:
        """
        Dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
        """
        return pulumi.get(self, "dead_letter_configs")

    @dead_letter_configs.setter
    def dead_letter_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]]]):
        pulumi.set(self, "dead_letter_configs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the lambda function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['AwsLambdaFunctionEnvironmentArgs']]:
        """
        Allow customization of the lambda execution environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['AwsLambdaFunctionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The Ephemeral Storage size, in MB, that your lambda function is allowed to use at runtime. Defaults to `512`.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        The [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) of the lambda function in your code.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional[pulumi.Input['AwsLambdaFunctionImageConfigArgs']]:
        """
        Configuration for the Lambda function's container image
        """
        return pulumi.get(self, "image_config")

    @image_config.setter
    def image_config(self, value: Optional[pulumi.Input['AwsLambdaFunctionImageConfigArgs']]):
        pulumi.set(self, "image_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The docker image that holds the lambda function's code. Used (and required) only when `package_type` is `"Image"`. The image must be in a private ECR.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of memory, in MB, that your lambda function is allowed to use at runtime. Defaults to `128`.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the lambda function cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of lambda package.  Must be `Zip` or `Image`.  Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) that the lambda function needs.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 key in the S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the object.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The execution time limit for the lambda function. Defaults to `3`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['AwsLambdaFunctionTracingConfigArgs']]:
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['AwsLambdaFunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)


@pulumi.input_type
class _AwsLambdaFunctionState:
    def __init__(__self__, *,
                 architectures: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['AwsLambdaFunctionEnvironmentArgs']] = None,
                 ephemeral_storage: Optional[pulumi.Input[int]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input['AwsLambdaFunctionImageConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 last_modified: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 source_code_hash: Optional[pulumi.Input[str]] = None,
                 source_code_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input['AwsLambdaFunctionTracingConfigArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLambdaFunction resources.
        :param pulumi.Input[str] architectures: Instruction set architecture for your Lambda function. Valid values are `[x86_64]` and `[arm64]`. Default is `[x86_64]`
        :param pulumi.Input[str] arn: The ARN of the lambda function.
        :param pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]] dead_letter_configs: Dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
        :param pulumi.Input[str] description: A description of the lambda function.
        :param pulumi.Input['AwsLambdaFunctionEnvironmentArgs'] environment: Allow customization of the lambda execution environment.
        :param pulumi.Input[int] ephemeral_storage: The Ephemeral Storage size, in MB, that your lambda function is allowed to use at runtime. Defaults to `512`.
        :param pulumi.Input[str] fullname: The full name of the lambda function.
        :param pulumi.Input[str] handler: The [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) of the lambda function in your code.
        :param pulumi.Input['AwsLambdaFunctionImageConfigArgs'] image_config: Configuration for the Lambda function's container image
        :param pulumi.Input[str] image_uri: The docker image that holds the lambda function's code. Used (and required) only when `package_type` is `"Image"`. The image must be in a private ECR.
        :param pulumi.Input[str] last_modified: A timestamp string of lambda's last modification time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input[int] memory_size: The maximum amount of memory, in MB, that your lambda function is allowed to use at runtime. Defaults to `128`.
        :param pulumi.Input[str] name: The short name of the lambda function cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] package_type: The type of lambda package.  Must be `Zip` or `Image`.  Defaults to `Zip`.
        :param pulumi.Input[str] role: The IAM role for the lambda function's execution.
        :param pulumi.Input[str] runtime: The [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) that the lambda function needs.
        :param pulumi.Input[str] s3_bucket: The S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[str] s3_key: The S3 key in the S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[str] source_code_hash: The SHA 256 hash of the lambda functions's source code package.
        :param pulumi.Input[int] source_code_size: The size in bytes of the lambda functions's source code package.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda function will be created in.
        :param pulumi.Input[int] timeout: The execution time limit for the lambda function. Defaults to `3`.
        :param pulumi.Input[str] version: The version of the lambda function.
        """
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if dead_letter_configs is not None:
            pulumi.set(__self__, "dead_letter_configs", dead_letter_configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)
        if source_code_size is not None:
            pulumi.set(__self__, "source_code_size", source_code_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[str]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `[x86_64]` and `[arm64]`. Default is `[x86_64]`
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the lambda function.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="deadLetterConfigs")
    def dead_letter_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]]]:
        """
        Dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
        """
        return pulumi.get(self, "dead_letter_configs")

    @dead_letter_configs.setter
    def dead_letter_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsLambdaFunctionDeadLetterConfigArgs']]]]):
        pulumi.set(self, "dead_letter_configs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the lambda function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['AwsLambdaFunctionEnvironmentArgs']]:
        """
        Allow customization of the lambda execution environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['AwsLambdaFunctionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The Ephemeral Storage size, in MB, that your lambda function is allowed to use at runtime. Defaults to `512`.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the lambda function.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        The [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) of the lambda function in your code.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional[pulumi.Input['AwsLambdaFunctionImageConfigArgs']]:
        """
        Configuration for the Lambda function's container image
        """
        return pulumi.get(self, "image_config")

    @image_config.setter
    def image_config(self, value: Optional[pulumi.Input['AwsLambdaFunctionImageConfigArgs']]):
        pulumi.set(self, "image_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The docker image that holds the lambda function's code. Used (and required) only when `package_type` is `"Image"`. The image must be in a private ECR.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        A timestamp string of lambda's last modification time.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of memory, in MB, that your lambda function is allowed to use at runtime. Defaults to `128`.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the lambda function cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of lambda package.  Must be `Zip` or `Image`.  Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM role for the lambda function's execution.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) that the lambda function needs.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 key in the S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The SHA 256 hash of the lambda functions's source code package.
        """
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_code_hash", value)

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size in bytes of the lambda functions's source code package.
        """
        return pulumi.get(self, "source_code_size")

    @source_code_size.setter
    def source_code_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_code_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the object.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the lambda function will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The execution time limit for the lambda function. Defaults to `3`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['AwsLambdaFunctionTracingConfigArgs']]:
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['AwsLambdaFunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the lambda function.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class AwsLambdaFunction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[str]] = None,
                 dead_letter_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLambdaFunctionDeadLetterConfigArgs', 'AwsLambdaFunctionDeadLetterConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Union['AwsLambdaFunctionEnvironmentArgs', 'AwsLambdaFunctionEnvironmentArgsDict']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[int]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input[Union['AwsLambdaFunctionImageConfigArgs', 'AwsLambdaFunctionImageConfigArgsDict']]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input[Union['AwsLambdaFunctionTracingConfigArgs', 'AwsLambdaFunctionTracingConfigArgsDict']]] = None,
                 __props__=None):
        """
        `AwsLambdaFunction` manages an AWS lambda function in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myfunction = duplocloud.AwsLambdaFunction("myfunction",
            tenant_id=this["tenantId"],
            name="myfunction",
            description="A description of my function",
            runtime="java11",
            handler="com.example.MyFunction::handleRequest",
            s3_bucket="my-bucket-name",
            s3_key="my-function.zip",
            environment={
                "variables": {
                    "foo": "bar",
                },
            },
            timeout=60,
            memory_size=512)
        thisfunction = duplocloud.AwsLambdaFunction("thisfunction",
            tenant_id=this["tenantId"],
            name="thisfunction",
            description="A description of my function",
            package_type="Image",
            image_uri="dkr.ecr.us-west-2.amazonaws.com/myimage:latest",
            image_config={
                "commands": [
                    "echo",
                    "hello world",
                ],
                "entry_points": ["echo hello workd"],
                "working_directory": "/tmp3",
            },
            tracing_config={
                "mode": "PassThrough",
            },
            timeout=60,
            memory_size=512)
        edgefunction = duplocloud.AwsLambdaFunction("edgefunction",
            tenant_id="c7163b39-43ca-4d44-81ce-9a323087039b",
            name="edgefunction",
            description="An example edge function",
            package_type="Image",
            image_uri="dkr.ecr.us-east-1.amazonaws.com/myimage:1.0",
            image_config={
                "commands": [
                    "echo",
                    "hello world",
                ],
                "entry_points": ["echo hello workd"],
                "working_directory": "/tmp3",
            },
            tags={
                "IsEdgeDeploy": "true",
            },
            timeout=5,
            memory_size=128)
        ```

        ## Import

        Example: Importing an existing AWS lambda function

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS lambda function

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLambdaFunction:AwsLambdaFunction myfunction *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] architectures: Instruction set architecture for your Lambda function. Valid values are `[x86_64]` and `[arm64]`. Default is `[x86_64]`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsLambdaFunctionDeadLetterConfigArgs', 'AwsLambdaFunctionDeadLetterConfigArgsDict']]]] dead_letter_configs: Dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
        :param pulumi.Input[str] description: A description of the lambda function.
        :param pulumi.Input[Union['AwsLambdaFunctionEnvironmentArgs', 'AwsLambdaFunctionEnvironmentArgsDict']] environment: Allow customization of the lambda execution environment.
        :param pulumi.Input[int] ephemeral_storage: The Ephemeral Storage size, in MB, that your lambda function is allowed to use at runtime. Defaults to `512`.
        :param pulumi.Input[str] handler: The [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) of the lambda function in your code.
        :param pulumi.Input[Union['AwsLambdaFunctionImageConfigArgs', 'AwsLambdaFunctionImageConfigArgsDict']] image_config: Configuration for the Lambda function's container image
        :param pulumi.Input[str] image_uri: The docker image that holds the lambda function's code. Used (and required) only when `package_type` is `"Image"`. The image must be in a private ECR.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input[int] memory_size: The maximum amount of memory, in MB, that your lambda function is allowed to use at runtime. Defaults to `128`.
        :param pulumi.Input[str] name: The short name of the lambda function cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] package_type: The type of lambda package.  Must be `Zip` or `Image`.  Defaults to `Zip`.
        :param pulumi.Input[str] runtime: The [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) that the lambda function needs.
        :param pulumi.Input[str] s3_bucket: The S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[str] s3_key: The S3 key in the S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda function will be created in.
        :param pulumi.Input[int] timeout: The execution time limit for the lambda function. Defaults to `3`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLambdaFunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsLambdaFunction` manages an AWS lambda function in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myfunction = duplocloud.AwsLambdaFunction("myfunction",
            tenant_id=this["tenantId"],
            name="myfunction",
            description="A description of my function",
            runtime="java11",
            handler="com.example.MyFunction::handleRequest",
            s3_bucket="my-bucket-name",
            s3_key="my-function.zip",
            environment={
                "variables": {
                    "foo": "bar",
                },
            },
            timeout=60,
            memory_size=512)
        thisfunction = duplocloud.AwsLambdaFunction("thisfunction",
            tenant_id=this["tenantId"],
            name="thisfunction",
            description="A description of my function",
            package_type="Image",
            image_uri="dkr.ecr.us-west-2.amazonaws.com/myimage:latest",
            image_config={
                "commands": [
                    "echo",
                    "hello world",
                ],
                "entry_points": ["echo hello workd"],
                "working_directory": "/tmp3",
            },
            tracing_config={
                "mode": "PassThrough",
            },
            timeout=60,
            memory_size=512)
        edgefunction = duplocloud.AwsLambdaFunction("edgefunction",
            tenant_id="c7163b39-43ca-4d44-81ce-9a323087039b",
            name="edgefunction",
            description="An example edge function",
            package_type="Image",
            image_uri="dkr.ecr.us-east-1.amazonaws.com/myimage:1.0",
            image_config={
                "commands": [
                    "echo",
                    "hello world",
                ],
                "entry_points": ["echo hello workd"],
                "working_directory": "/tmp3",
            },
            tags={
                "IsEdgeDeploy": "true",
            },
            timeout=5,
            memory_size=128)
        ```

        ## Import

        Example: Importing an existing AWS lambda function

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS lambda function

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLambdaFunction:AwsLambdaFunction myfunction *TENANT_ID*/*SHORT_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param AwsLambdaFunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLambdaFunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[str]] = None,
                 dead_letter_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLambdaFunctionDeadLetterConfigArgs', 'AwsLambdaFunctionDeadLetterConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Union['AwsLambdaFunctionEnvironmentArgs', 'AwsLambdaFunctionEnvironmentArgsDict']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[int]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input[Union['AwsLambdaFunctionImageConfigArgs', 'AwsLambdaFunctionImageConfigArgsDict']]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input[Union['AwsLambdaFunctionTracingConfigArgs', 'AwsLambdaFunctionTracingConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLambdaFunctionArgs.__new__(AwsLambdaFunctionArgs)

            __props__.__dict__["architectures"] = architectures
            __props__.__dict__["dead_letter_configs"] = dead_letter_configs
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["handler"] = handler
            __props__.__dict__["image_config"] = image_config
            __props__.__dict__["image_uri"] = image_uri
            __props__.__dict__["layers"] = layers
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["name"] = name
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["s3_bucket"] = s3_bucket
            __props__.__dict__["s3_key"] = s3_key
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["tracing_config"] = tracing_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["source_code_hash"] = None
            __props__.__dict__["source_code_size"] = None
            __props__.__dict__["version"] = None
        super(AwsLambdaFunction, __self__).__init__(
            'duplocloud:index/awsLambdaFunction:AwsLambdaFunction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architectures: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            dead_letter_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsLambdaFunctionDeadLetterConfigArgs', 'AwsLambdaFunctionDeadLetterConfigArgsDict']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[Union['AwsLambdaFunctionEnvironmentArgs', 'AwsLambdaFunctionEnvironmentArgsDict']]] = None,
            ephemeral_storage: Optional[pulumi.Input[int]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            handler: Optional[pulumi.Input[str]] = None,
            image_config: Optional[pulumi.Input[Union['AwsLambdaFunctionImageConfigArgs', 'AwsLambdaFunctionImageConfigArgsDict']]] = None,
            image_uri: Optional[pulumi.Input[str]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            memory_size: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            package_type: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            s3_bucket: Optional[pulumi.Input[str]] = None,
            s3_key: Optional[pulumi.Input[str]] = None,
            source_code_hash: Optional[pulumi.Input[str]] = None,
            source_code_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            tracing_config: Optional[pulumi.Input[Union['AwsLambdaFunctionTracingConfigArgs', 'AwsLambdaFunctionTracingConfigArgsDict']]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'AwsLambdaFunction':
        """
        Get an existing AwsLambdaFunction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] architectures: Instruction set architecture for your Lambda function. Valid values are `[x86_64]` and `[arm64]`. Default is `[x86_64]`
        :param pulumi.Input[str] arn: The ARN of the lambda function.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsLambdaFunctionDeadLetterConfigArgs', 'AwsLambdaFunctionDeadLetterConfigArgsDict']]]] dead_letter_configs: Dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
        :param pulumi.Input[str] description: A description of the lambda function.
        :param pulumi.Input[Union['AwsLambdaFunctionEnvironmentArgs', 'AwsLambdaFunctionEnvironmentArgsDict']] environment: Allow customization of the lambda execution environment.
        :param pulumi.Input[int] ephemeral_storage: The Ephemeral Storage size, in MB, that your lambda function is allowed to use at runtime. Defaults to `512`.
        :param pulumi.Input[str] fullname: The full name of the lambda function.
        :param pulumi.Input[str] handler: The [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) of the lambda function in your code.
        :param pulumi.Input[Union['AwsLambdaFunctionImageConfigArgs', 'AwsLambdaFunctionImageConfigArgsDict']] image_config: Configuration for the Lambda function's container image
        :param pulumi.Input[str] image_uri: The docker image that holds the lambda function's code. Used (and required) only when `package_type` is `"Image"`. The image must be in a private ECR.
        :param pulumi.Input[str] last_modified: A timestamp string of lambda's last modification time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input[int] memory_size: The maximum amount of memory, in MB, that your lambda function is allowed to use at runtime. Defaults to `128`.
        :param pulumi.Input[str] name: The short name of the lambda function cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        :param pulumi.Input[str] package_type: The type of lambda package.  Must be `Zip` or `Image`.  Defaults to `Zip`.
        :param pulumi.Input[str] role: The IAM role for the lambda function's execution.
        :param pulumi.Input[str] runtime: The [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) that the lambda function needs.
        :param pulumi.Input[str] s3_bucket: The S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[str] s3_key: The S3 key in the S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        :param pulumi.Input[str] source_code_hash: The SHA 256 hash of the lambda functions's source code package.
        :param pulumi.Input[int] source_code_size: The size in bytes of the lambda functions's source code package.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda function will be created in.
        :param pulumi.Input[int] timeout: The execution time limit for the lambda function. Defaults to `3`.
        :param pulumi.Input[str] version: The version of the lambda function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLambdaFunctionState.__new__(_AwsLambdaFunctionState)

        __props__.__dict__["architectures"] = architectures
        __props__.__dict__["arn"] = arn
        __props__.__dict__["dead_letter_configs"] = dead_letter_configs
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["ephemeral_storage"] = ephemeral_storage
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["handler"] = handler
        __props__.__dict__["image_config"] = image_config
        __props__.__dict__["image_uri"] = image_uri
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["layers"] = layers
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["name"] = name
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["role"] = role
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["s3_bucket"] = s3_bucket
        __props__.__dict__["s3_key"] = s3_key
        __props__.__dict__["source_code_hash"] = source_code_hash
        __props__.__dict__["source_code_size"] = source_code_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["tracing_config"] = tracing_config
        __props__.__dict__["version"] = version
        return AwsLambdaFunction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architectures(self) -> pulumi.Output[Optional[str]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `[x86_64]` and `[arm64]`. Default is `[x86_64]`
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the lambda function.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deadLetterConfigs")
    def dead_letter_configs(self) -> pulumi.Output[Optional[Sequence['outputs.AwsLambdaFunctionDeadLetterConfig']]]:
        """
        Dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing.
        """
        return pulumi.get(self, "dead_letter_configs")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the lambda function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional['outputs.AwsLambdaFunctionEnvironment']]:
        """
        Allow customization of the lambda execution environment.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output[Optional[int]]:
        """
        The Ephemeral Storage size, in MB, that your lambda function is allowed to use at runtime. Defaults to `512`.
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the lambda function.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[str]:
        """
        The [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) of the lambda function in your code.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> pulumi.Output[Optional['outputs.AwsLambdaFunctionImageConfig']]:
        """
        Configuration for the Lambda function's container image
        """
        return pulumi.get(self, "image_config")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> pulumi.Output[Optional[str]]:
        """
        The docker image that holds the lambda function's code. Used (and required) only when `package_type` is `"Image"`. The image must be in a private ECR.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        A timestamp string of lambda's last modification time.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def layers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum amount of memory, in MB, that your lambda function is allowed to use at runtime. Defaults to `128`.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the lambda function cluster.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[str]:
        """
        The type of lambda package.  Must be `Zip` or `Image`.  Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The IAM role for the lambda function's execution.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        The [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) that the lambda function needs.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        The S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Output[Optional[str]]:
        """
        The S3 key in the S3 bucket where the lambda function package is located. Used (and required) only when `package_type` is `"Zip"`.
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> pulumi.Output[str]:
        """
        The SHA 256 hash of the lambda functions's source code package.
        """
        return pulumi.get(self, "source_code_hash")

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> pulumi.Output[int]:
        """
        The size in bytes of the lambda functions's source code package.
        """
        return pulumi.get(self, "source_code_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags to assign to the object.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the lambda function will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The execution time limit for the lambda function. Defaults to `3`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> pulumi.Output['outputs.AwsLambdaFunctionTracingConfig']:
        return pulumi.get(self, "tracing_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the lambda function.
        """
        return pulumi.get(self, "version")

