# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsLambdaFunctionEventConfigArgs', 'AwsLambdaFunctionEventConfig']

@pulumi.input_type
class AwsLambdaFunctionEventConfigArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 destination_config: Optional[pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs']] = None,
                 max_event_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 max_retry_attempts: Optional[pulumi.Input[int]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AwsLambdaFunctionEventConfig resource.
        :param pulumi.Input[str] function_name: Name of Lambda function this configuration should apply to
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda asynchronous invocation configuration will be created in.
        :param pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs'] destination_config: A configuration block to specify event destinations
        :param pulumi.Input[int] max_event_age_in_seconds: The maximum age of a request that Lambda sends to a function for processing
        :param pulumi.Input[int] max_retry_attempts: Maximum number of attempts a Lambda function may retry in case of error
        :param pulumi.Input[str] qualifier: The qualifier for the lambda event invoke configuration
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if max_event_age_in_seconds is not None:
            pulumi.set(__self__, "max_event_age_in_seconds", max_event_age_in_seconds)
        if max_retry_attempts is not None:
            pulumi.set(__self__, "max_retry_attempts", max_retry_attempts)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        Name of Lambda function this configuration should apply to
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the lambda asynchronous invocation configuration will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs']]:
        """
        A configuration block to specify event destinations
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="maxEventAgeInSeconds")
    def max_event_age_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum age of a request that Lambda sends to a function for processing
        """
        return pulumi.get(self, "max_event_age_in_seconds")

    @max_event_age_in_seconds.setter
    def max_event_age_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_event_age_in_seconds", value)

    @property
    @pulumi.getter(name="maxRetryAttempts")
    def max_retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of attempts a Lambda function may retry in case of error
        """
        return pulumi.get(self, "max_retry_attempts")

    @max_retry_attempts.setter
    def max_retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retry_attempts", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The qualifier for the lambda event invoke configuration
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)


@pulumi.input_type
class _AwsLambdaFunctionEventConfigState:
    def __init__(__self__, *,
                 destination_config: Optional[pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs']] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 max_event_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 max_retry_attempts: Optional[pulumi.Input[int]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsLambdaFunctionEventConfig resources.
        :param pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs'] destination_config: A configuration block to specify event destinations
        :param pulumi.Input[str] function_name: Name of Lambda function this configuration should apply to
        :param pulumi.Input[int] max_event_age_in_seconds: The maximum age of a request that Lambda sends to a function for processing
        :param pulumi.Input[int] max_retry_attempts: Maximum number of attempts a Lambda function may retry in case of error
        :param pulumi.Input[str] qualifier: The qualifier for the lambda event invoke configuration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda asynchronous invocation configuration will be created in.
        """
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if max_event_age_in_seconds is not None:
            pulumi.set(__self__, "max_event_age_in_seconds", max_event_age_in_seconds)
        if max_retry_attempts is not None:
            pulumi.set(__self__, "max_retry_attempts", max_retry_attempts)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs']]:
        """
        A configuration block to specify event destinations
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['AwsLambdaFunctionEventConfigDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Lambda function this configuration should apply to
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="maxEventAgeInSeconds")
    def max_event_age_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum age of a request that Lambda sends to a function for processing
        """
        return pulumi.get(self, "max_event_age_in_seconds")

    @max_event_age_in_seconds.setter
    def max_event_age_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_event_age_in_seconds", value)

    @property
    @pulumi.getter(name="maxRetryAttempts")
    def max_retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of attempts a Lambda function may retry in case of error
        """
        return pulumi.get(self, "max_retry_attempts")

    @max_retry_attempts.setter
    def max_retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retry_attempts", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The qualifier for the lambda event invoke configuration
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the lambda asynchronous invocation configuration will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AwsLambdaFunctionEventConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_config: Optional[pulumi.Input[Union['AwsLambdaFunctionEventConfigDestinationConfigArgs', 'AwsLambdaFunctionEventConfigDestinationConfigArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 max_event_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 max_retry_attempts: Optional[pulumi.Input[int]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `AwsLambdaFunctionEventConfig` manages an AWS lambda function in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="nondefault")
        myfunction = duplocloud.AwsLambdaFunction("myfunction",
            tenant_id=myapp.tenant_id,
            name="myfunction",
            description="A description of my function",
            runtime="java11",
            handler="com.example.MyFunction::handleRequest",
            s3_bucket="my-bucket-name",
            s3_key="my-function.zip",
            environment={
                "variables": {
                    "foo": "bar",
                },
            },
            timeout=60,
            memory_size=512)
        failure_queue = duplocloud.AwsSqsQueue("failure_queue",
            tenant_id=myapp.tenant_id,
            name="failure_queue",
            fifo_queue=False,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=False,
            delay_seconds=10)
        success_queue = duplocloud.AwsSqsQueue("success_queue",
            tenant_id=myapp.tenant_id,
            name="success_queue",
            fifo_queue=False,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=False,
            delay_seconds=10)
        event_invoke_config = duplocloud.AwsLambdaFunctionEventConfig("event-invoke-config",
            tenant_id=myapp.tenant_id,
            function_name=myfunction.fullname,
            max_retry_attempts=1,
            max_event_age_in_seconds=100,
            destination_config={
                "on_failure": {
                    "destination": failure_queue.arn,
                },
                "on_success": {
                    "destination": success_queue.arn,
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS lambda function event invoke config

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS lambda function

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLambdaFunctionEventConfig:AwsLambdaFunctionEventConfig event-invoke-config *TENANT_ID*/*SHORT_NAME*/eventInvokeConfig
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsLambdaFunctionEventConfigDestinationConfigArgs', 'AwsLambdaFunctionEventConfigDestinationConfigArgsDict']] destination_config: A configuration block to specify event destinations
        :param pulumi.Input[str] function_name: Name of Lambda function this configuration should apply to
        :param pulumi.Input[int] max_event_age_in_seconds: The maximum age of a request that Lambda sends to a function for processing
        :param pulumi.Input[int] max_retry_attempts: Maximum number of attempts a Lambda function may retry in case of error
        :param pulumi.Input[str] qualifier: The qualifier for the lambda event invoke configuration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda asynchronous invocation configuration will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsLambdaFunctionEventConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `AwsLambdaFunctionEventConfig` manages an AWS lambda function in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="nondefault")
        myfunction = duplocloud.AwsLambdaFunction("myfunction",
            tenant_id=myapp.tenant_id,
            name="myfunction",
            description="A description of my function",
            runtime="java11",
            handler="com.example.MyFunction::handleRequest",
            s3_bucket="my-bucket-name",
            s3_key="my-function.zip",
            environment={
                "variables": {
                    "foo": "bar",
                },
            },
            timeout=60,
            memory_size=512)
        failure_queue = duplocloud.AwsSqsQueue("failure_queue",
            tenant_id=myapp.tenant_id,
            name="failure_queue",
            fifo_queue=False,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=False,
            delay_seconds=10)
        success_queue = duplocloud.AwsSqsQueue("success_queue",
            tenant_id=myapp.tenant_id,
            name="success_queue",
            fifo_queue=False,
            message_retention_seconds=345600,
            visibility_timeout_seconds=30,
            content_based_deduplication=False,
            delay_seconds=10)
        event_invoke_config = duplocloud.AwsLambdaFunctionEventConfig("event-invoke-config",
            tenant_id=myapp.tenant_id,
            function_name=myfunction.fullname,
            max_retry_attempts=1,
            max_event_age_in_seconds=100,
            destination_config={
                "on_failure": {
                    "destination": failure_queue.arn,
                },
                "on_success": {
                    "destination": success_queue.arn,
                },
            })
        ```

        ## Import

        Example: Importing an existing AWS lambda function event invoke config

         - *TENANT_ID* is the tenant GUID

         - *SHORT_NAME* is the short name of the AWS lambda function

        # 

        ```sh
        $ pulumi import duplocloud:index/awsLambdaFunctionEventConfig:AwsLambdaFunctionEventConfig event-invoke-config *TENANT_ID*/*SHORT_NAME*/eventInvokeConfig
        ```

        :param str resource_name: The name of the resource.
        :param AwsLambdaFunctionEventConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsLambdaFunctionEventConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_config: Optional[pulumi.Input[Union['AwsLambdaFunctionEventConfigDestinationConfigArgs', 'AwsLambdaFunctionEventConfigDestinationConfigArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 max_event_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 max_retry_attempts: Optional[pulumi.Input[int]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsLambdaFunctionEventConfigArgs.__new__(AwsLambdaFunctionEventConfigArgs)

            __props__.__dict__["destination_config"] = destination_config
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["max_event_age_in_seconds"] = max_event_age_in_seconds
            __props__.__dict__["max_retry_attempts"] = max_retry_attempts
            __props__.__dict__["qualifier"] = qualifier
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AwsLambdaFunctionEventConfig, __self__).__init__(
            'duplocloud:index/awsLambdaFunctionEventConfig:AwsLambdaFunctionEventConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_config: Optional[pulumi.Input[Union['AwsLambdaFunctionEventConfigDestinationConfigArgs', 'AwsLambdaFunctionEventConfigDestinationConfigArgsDict']]] = None,
            function_name: Optional[pulumi.Input[str]] = None,
            max_event_age_in_seconds: Optional[pulumi.Input[int]] = None,
            max_retry_attempts: Optional[pulumi.Input[int]] = None,
            qualifier: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AwsLambdaFunctionEventConfig':
        """
        Get an existing AwsLambdaFunctionEventConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsLambdaFunctionEventConfigDestinationConfigArgs', 'AwsLambdaFunctionEventConfigDestinationConfigArgsDict']] destination_config: A configuration block to specify event destinations
        :param pulumi.Input[str] function_name: Name of Lambda function this configuration should apply to
        :param pulumi.Input[int] max_event_age_in_seconds: The maximum age of a request that Lambda sends to a function for processing
        :param pulumi.Input[int] max_retry_attempts: Maximum number of attempts a Lambda function may retry in case of error
        :param pulumi.Input[str] qualifier: The qualifier for the lambda event invoke configuration
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the lambda asynchronous invocation configuration will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsLambdaFunctionEventConfigState.__new__(_AwsLambdaFunctionEventConfigState)

        __props__.__dict__["destination_config"] = destination_config
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["max_event_age_in_seconds"] = max_event_age_in_seconds
        __props__.__dict__["max_retry_attempts"] = max_retry_attempts
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["tenant_id"] = tenant_id
        return AwsLambdaFunctionEventConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output[Optional['outputs.AwsLambdaFunctionEventConfigDestinationConfig']]:
        """
        A configuration block to specify event destinations
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        Name of Lambda function this configuration should apply to
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="maxEventAgeInSeconds")
    def max_event_age_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum age of a request that Lambda sends to a function for processing
        """
        return pulumi.get(self, "max_event_age_in_seconds")

    @property
    @pulumi.getter(name="maxRetryAttempts")
    def max_retry_attempts(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of attempts a Lambda function may retry in case of error
        """
        return pulumi.get(self, "max_retry_attempts")

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[str]]:
        """
        The qualifier for the lambda event invoke configuration
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the lambda asynchronous invocation configuration will be created in.
        """
        return pulumi.get(self, "tenant_id")

